/*
 *  Boa, an http server
 *  Copyright (C) 1995 Paul Phillips <paulp@go2net.com>
 *  Copyright (C) 1996-2005 Larry Doolittle <ldoolitt@boa.org>
 *  Copyright (C) 1996-2004 Jon Nelson <jnelson@boa.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* $Id: request.c,v 1.112.2.51 2005/02/22 14:11:29 jnelson Exp $*/

/* WNC-NMR0000-JOE-PENG-20140716-Implemen top page, home page and GUI menu of Linear step 2 (repeater mode) */
#include <unistd.h>

#include "boa.h"
#ifdef BOA_WITH_OPENSSL
#include <openssl/ssl.h>
#include <openssl/err.h>
#endif

#include <stddef.h>             /* for offsetof */
#ifdef SUPPORT_ASP
#include "asp_page.h"
#endif

/* WNC-NMR0517-JOE-PENG-20131008-Fix bug 517 Gateway and DNS address are 0.0.0.0 during disconnected WAN cable in static IP mode */
#include <arpa/inet.h>

#ifdef SUPER_NAME_SUPPORT
#include "auth.h"
#endif

#ifdef DIGEST_AUTHENTICATION
#include "md5.h"
#define TEMP_DIGEST_LENGTH 16
#define FINAL_DIGEST_LENGTH 32
#endif

#include "apform.h"
#include "libwnc.h"

#define TUNE_SNDBUF

/* WNC-MIKE-YEH-20160805-implement remote maintenance account. */
#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)
#define RMAINTE_ACCOUNT_CONF "/var/rmainte_account.conf"
#define RMAINTE_NOW "/var/rmainte_now"
#endif

/*
#define USE_TCPNODELAY
#define NO_RATE_LIMIT
#define DIE_ON_ERROR_TUNING_SNDBUF
*/

unsigned total_connections = 0;
unsigned int system_bufsize = 0; /* Default size of SNDBUF given by system */
struct status status;

#ifdef BOA_WITH_OPENSSL
extern int server_ssl;                  /*the socket to listen for ssl requests*/
extern SSL_CTX *ctx;                    /*The global connection context*/
extern int do_ssl;                              /*do ssl sockets??*/
#endif /*BOA_WITH_OPENSSL*/

extern unsigned long ssl_rw_timeout_cnt;

static unsigned int sockbufsize = SOCKETBUF_SIZE;
unsigned int authFailCount = 0; //WNC-NMR0000-Rita-20130304-V1.2.0_Sonic_SpecChangeRequest_3.4.1.-Login Lock

char latest_request[256] = "";

/* function prototypes located in this file only */
static void free_request(request * req);
static void sanitize_request(request * req, int make_new_request);
// davidhsu --------------------------------------------------------------
char last_url[100];
int check_auth_flag=0;
static int check_logout = 1; 
static int chrome_logout = 1; 
static int firefox_logout = 1; 
static int safari_logout = 1; 

/* WNC-NMR0517-JOE-PENG-20131008-Fix bug 517 Gateway and DNS address are 0.0.0.0 during disconnected WAN cable in static IP mode->start */
int booting_lan_mode = -1;
int booting_wan_mode = -1;
int is_first_time_login = 1;
/* Host order address */
unsigned long booting_mib_wan_ip=0;
unsigned long booting_mib_wan_mask=0;
unsigned long booting_mib_wan_gateway=0;
unsigned long booting_mib_wan_dns1=0;
unsigned long booting_mib_wan_dns2=0;
unsigned long booting_mib_lan_ip=0;
unsigned long booting_mib_lan_mask=0;
unsigned long booting_mib_lan_gateway=0;
/* WNC-NMR0517-JOE-PENG-20131008-Fix bug 517 Gateway and DNS address are 0.0.0.0 during disconnected WAN cable in static IP mode->end */

#ifdef WEB_ONLY_ONE_CLIENT
web_client_t webClientStatus[CLINET_MAX_NUM]={0};
int current_mac_index=-1;


int auth_get_clone_mac_by_ip(char *ip, char *clone_mac)
{
	FILE *fp;
	char line_buffer[128], tmp_mac_str[18], ip_str[16], if_name[16];		
	int i, j, retval=-1;	
	
	if(ip==NULL || clone_mac==NULL)
		return retval; 
	
	if((fp= fopen("/proc/net/arp", "r"))==NULL)
		return retval;
	
	while(fgets(line_buffer, sizeof(line_buffer), fp))
	{			
		line_buffer[strlen(line_buffer)-1]='\0';		

		sscanf(line_buffer,"%s %*s %*s %s %*s %s",ip_str,tmp_mac_str,if_name);
		
		if(strcmp(if_name, "br0")!=0 || strcmp(ip, ip_str)!=0)
			continue;
		
		for(i=0, j=0; i<17 && j<12; i++)
		{
			if(tmp_mac_str[i]!=':')
				clone_mac[j++]=tmp_mac_str[i];
		}
		clone_mac[12]=0;
		retval=0;
		break;
	}
	fclose(fp);
	return retval;		
}

int auth_get_mac_idx(char *ip)
{
	char remove_mac[6]={0};
	int i=0,find=0;
	auth_get_clone_mac_by_ip(ip,remove_mac);
	for(i=0;i<CLINET_MAX_NUM;i++)
	{
		if(memcmp(remove_mac,webClientStatus[i].remove_mac,6)==0)
		{
			return i;
		}
		
	}
//not in the table when run  here
	do{
		i=rand()%CLINET_MAX_NUM;
	}while(webClientStatus[i].status==AUTHED);
	memcpy(webClientStatus[i].remove_mac,remove_mac,6);
	webClientStatus[i].status=NOT_LOGIN;
	return i;
}
void auth_setAuthed(int idx)
{
	int i=0;
	for(i=0;i<CLINET_MAX_NUM;i++)
	{
		if(webClientStatus[i].status==AUTHED)
			webClientStatus[i].status=NOT_LOGIN;
		
		if(i==idx)
		{
			webClientStatus[i].status=AUTHED;
		}			
	}
}

#endif

//--------------------------------------------------------------------
#ifdef HTTP_FILE_SERVER_SUPPORTED
extern void http_file_server_req_init(request *wp);
extern void http_file_server_req_free(request *wp);
extern void CheckUA(request *wp);
#endif

extern int accesstimer_guardmsg;

// WNC-NMR0765-JDR231-HENG-I-CHEN-2014-10-02: add proection of firmware file uploading #BEGIN
#if defined(CONFIG_APP_FWD)
struct request * request_lock_shm = NULL;
time_t last_access_time = 0;
#endif //#if defined(CONFIG_APP_FWD)
// WNC-NMR0765-JDR231-HENG-I-CHEN-2014-10-02: add proection of firmware file uploading #END

#if 1 //#ifdef MULTI_LOGIN
typedef struct session_entry {
	unsigned char station_mac[6];

      /* WNC-NMR1812-MIKE-YEH-20161209-It can not login to WebGUI access from WAN */
#if 1 /* user-agent authentication mechanism */
	unsigned int station_ip;
	unsigned char user_agent[400];
#else
	unsigned int station_ip;	
#endif

#if defined(CONFIG_WNC_NEC_STOK_SESSION_AUTH)
	unsigned char stok[40];
#endif

	int status;
	int lastseen;
	struct session_entry *prev;
	struct session_entry *next;
} SESSION_ENTRY;

SESSION_ENTRY *session_list = NULL;

int get_station_mac(unsigned char *mac, request *req)
{
	char macbuf[20] = "";
	
#if 1 /* WNC-NMR1812-MIKE-YEH-20161209-It can not login to WebGUI access from WAN */
	struct in_addr ip = {0};
#endif

	if (get_mac_from_IP(macbuf, req->remote_ip_addr) == 1) {
		sscanf(macbuf, "%x:%x:%x:%x:%x:%x", &mac[0], &mac[1], &mac[2], &mac[3], &mac[4], &mac[5]);
		return 0;
	} else {

	  /* WNC-NMR1812-MIKE-YEH-20161209-It can not login to WebGUI access from WAN */
#if 1 /* user-agent authentication mechanism */

		inet_aton(req->remote_ip_addr, &ip);
		
		mac[0] = 0;
		mac[1] = 0;
		mac[2] = ip.s_addr & 0xff;
		mac[3] = (ip.s_addr >> 8) & 0xff;
		mac[4] = (ip.s_addr >> 16) & 0xff;
		mac[5] = (ip.s_addr >> 24) & 0xff;
		return 0;
#endif		

		return -1;
	}
}

unsigned int get_station_ip(request *req)
{

	struct in_addr ip;

	inet_aton(req->remote_ip_addr, &ip);
	
	return ip.s_addr;
}

SESSION_ENTRY * insert_session() {
	SESSION_ENTRY *new = NULL;

//	console_printf("%s %d\n", __func__, __LINE__);
		
	new = malloc(sizeof(SESSION_ENTRY));
	
	if (new == NULL) {
		return NULL;
	}
	
	if (session_list != NULL) {
		new->prev = session_list->prev;
		new->next = session_list;
		session_list->prev->next = new;
		session_list->prev = new;
	} else {
		new->prev = new;
		new->next = new;
	}
	
	session_list = new;

	return new;
}

void remove_session(SESSION_ENTRY * sessionp) {
	SESSION_ENTRY *p = NULL, *c = NULL, *n = NULL;

//	console_printf("%s %d\n", __func__, __LINE__);
	
	if (sessionp == NULL || session_list == NULL) {
		return;
	}

	c = sessionp;
	p = sessionp->prev;
	n = sessionp->next;

//	console_printf("%s %d : %.8X prev %.8X next %.8X\n", __func__, __LINE__, c, p, n);

	if (n != c) {
		p->next = n;
	}
	
	if (p != c) {
		n->prev = p;
	}
	
	free(c);
	
	if(c != n) {
		session_list = n;
	} else {
		session_list = NULL;
	}

	return;
}

int get_auth_status(request * req, int update_flag) {
	SESSION_ENTRY *sessionp = NULL;
	unsigned char sta_mac[6] = "";

	  /* WNC-NMR1812-MIKE-YEH-20161209-It can not login to WebGUI access from WAN */
#if 1 /* user-agent authentication mechanism */	
	int auth_check_flag;
#endif

//	console_printf("%s %d\n", __func__, __LINE__);
	
	if (session_list == NULL) {
		return 0;
	}

#if defined(CONFIG_WNC_NEC_STOK_SESSION_AUTH)
	if (req->stok[0] == 0) {
		return 0;
	}
#endif

	sessionp = session_list;
//	console_printf("%s %d: %.8X\n", __func__, __LINE__, sessionp);
	get_station_mac(sta_mac, req);
//	console_printf("%s %d: %.2X:%.2X:%.2X:%.2X:%.2X:%.2X\n", __func__, __LINE__, 
//		sta_mac[0], sta_mac[1], sta_mac[2], sta_mac[3], sta_mac[4], sta_mac[5]);
	do {
		
	  /* WNC-NMR1812-MIKE-YEH-20161209-It can not login to WebGUI access from WAN */
#if 0 /* user-agent authentication mechanism */

		if (req->header_user_agent != NULL) {
			if ((memcmp(sta_mac, sessionp->station_mac, 6) == 0) &&
				(get_station_ip(req) == sessionp->station_ip) &&
				(strcmp(req->header_user_agent, sessionp->user_agent) == 0))
				auth_check_flag = 1;
			else
				auth_check_flag = 0;			 
		}
		else
		{
			if ((memcmp(sta_mac, sessionp->station_mac, 6) == 0) && (get_station_ip(req) == sessionp->station_ip))
				auth_check_flag = 1;
			else
				auth_check_flag = 0;
		}

		if (auth_check_flag) {
#else

#if defined(CONFIG_WNC_NEC_STOK_SESSION_AUTH)
		if (strcmp(req->stok, sessionp->stok) == 0) {
#else
	    if (memcmp(sta_mac, sessionp->station_mac, 6) == 0) {
//	    if (get_station_ip(req) == sessionp->station_ip) {
#endif
#endif
			int timeout = 0;

//WNC-NMR00000-D2R031-HENG-I-CHEN-20160114: Add GUI expire time setting #BEGIN
			apmib_get(MIB_GUI_EXPIRE_TIME, (void *)&timeout);
//WNC-NMR00000-D2R031-HENG-I-CHEN-20160114: Add GUI expire time setting #END		
		
	    	if ((timeout > 0) && (get_uptime() > sessionp->lastseen + timeout)) {
	    		remove_session(sessionp);
//				req->auth_flag = -1;
				return -1;
			} else {
				if (update_flag) {
					sessionp->lastseen = get_uptime();
					session_list = sessionp;	
				}
//				req->auth_flag = sessionp->status;
//			console_printf("get login: %.2X:%.2X:%.2X:%.2X:%.2X:%.2X %s\n", 
//				sessionp->station_mac[0], sessionp->station_mac[1], sessionp->station_mac[2], 
//				sessionp->station_mac[3], sessionp->station_mac[4], sessionp->station_mac[5], 
//				(sessionp->status == 2)?"admin":((sessionp->status == 1)?"user":"error"));
//				console_printf("get login: %.8X auth level %d\n", sessionp->station_ip, sessionp->status);
				return sessionp->status;
			}
		} else {
			sessionp = sessionp->next;
		}
	} while (sessionp != session_list);
	
//	req->auth_flag = 0;
	return 0;
}

#if defined(CONFIG_WNC_NEC_STOK_SESSION_AUTH)
#define RANDOM_URL_STOK_LEN 32
#define RANDOM_URL_STOK_STR_LEN RANDOM_URL_STOK_LEN+1
int generate_unique_id(SESSION_ENTRY *sessionp, char *stok, int i) {
	FILE *fp;
	int randomSeed;
	char cmdBuf[128]={0};
	char randomBuf[RANDOM_URL_STOK_STR_LEN]={0};
	struct timeval time_seed = {0};

	if(sessionp == NULL)
		return -1;	

	/* generate random number with srand() and rand() functions.*/
	gettimeofday(&time_seed, NULL);
	srand(time_seed.tv_usec);
 	randomSeed = rand();
 	
	//printf("\r\n generate_unique_id , sessionp->stok=%d , time_seed.tv_usec=%d, randomSeed=%d\r\n", sizeof(sessionp->stok), time_seed.tv_usec, randomSeed);

	if((*stok)==0)
		snprintf(cmdBuf, sizeof(cmdBuf), "echo \"%d\" > /var/randomStokSeed", randomSeed);
	else /* re-generating stok id with different seed value for duplicate stok id. */
		snprintf(cmdBuf, sizeof(cmdBuf), "echo \"%d%s\" > /var/randomStokSeed", randomSeed, stok);
	
	system(cmdBuf);
	system("md5sum /var/randomStokSeed > /var/stokRandom");

	if ((fp = fopen("/var/stokRandom", "r")) != NULL) 
	{
		if(fgets(randomBuf, RANDOM_URL_STOK_STR_LEN, fp) != NULL)
		{
			randomBuf[RANDOM_URL_STOK_LEN]='\0';
		}
		fclose(fp);
	}

	system("rm -f /var/randomStokSeed");
	system("rm -f /var/stokRandom");

	//printf("\r\n generate_unique_id() , randomBuf=(%s) \r\n",randomBuf);

	if(randomBuf[0] == 0)
		return -1;

	strlcpy(stok, randomBuf, RANDOM_URL_STOK_STR_LEN);

	return 0;
}

int check_duplicate_url_stok(char *stok) {
	SESSION_ENTRY *sessionp = session_list;

	if (sessionp == NULL)
		return -1;

	do {
		if (memcmp(sessionp->stok, stok, RANDOM_URL_STOK_LEN) == 0)
			return 1;

		sessionp = sessionp->next;
			
	} while (sessionp != session_list);

	return 0;
}

int generate_url_stok(SESSION_ENTRY *sessionp) {
	
	unsigned char stok[40] = {0};
	int i;
	
	for(i=0;i<10;i++) {
		if(generate_unique_id(sessionp, stok, i) != -1) {
			if(!check_duplicate_url_stok(stok)) {
				strlcpy(sessionp->stok, stok, RANDOM_URL_STOK_STR_LEN);
				break;
			}
			printf("\r\n duplicate URL stok ID.(%d) !! \r\n", i);
		}
	}
	return 0;
}
#endif


void add_login_session(request *req, int auth_status) {
	SESSION_ENTRY *sessionp = NULL;
	
//	console_printf("%s %d\n", __func__, __LINE__);

	if (get_auth_status(req, 0) == 0) {
		sessionp = insert_session();
		if (sessionp) {

	  /* WNC-NMR1812-MIKE-YEH-20161209-It can not login to WebGUI access from WAN */
#if 0 /* user-agent authentication mechanism */

			get_station_mac(sessionp->station_mac, req);
			sessionp->station_ip = get_station_ip(req);

			if(req->header_user_agent != NULL)
				strlcpy(sessionp->user_agent, req->header_user_agent, sizeof(sessionp->user_agent));	
#else		
			get_station_mac(sessionp->station_mac, req);
//			sessionp->station_ip = get_station_ip(req);
#endif

#if defined(CONFIG_WNC_NEC_STOK_SESSION_AUTH)
			if(generate_url_stok(sessionp) != -1)
				strlcpy(req->stok, sessionp->stok, sizeof(sessionp->stok));
#endif

			sessionp->status = auth_status;
			sessionp->lastseen = get_uptime();
//			console_printf("add new login: %.8X auth level %d\n", sessionp->station_ip, sessionp->status);
//			console_printf("add new login: %.2X:%.2X:%.2X:%.2X:%.2X:%.2X %s\n", 
//				sessionp->station_mac[0], sessionp->station_mac[1], sessionp->station_mac[2], 
//				sessionp->station_mac[3], sessionp->station_mac[4], sessionp->station_mac[5], 
//				(sessionp->status == 2)?"admin":((sessionp->status == 1)?"user":"error"));
		}
	}
}

void del_logout_session(request *req) {
	SESSION_ENTRY *sessionp = NULL;
	unsigned char sta_mac[6] = "";
	
//	console_printf("%s %d\n", __func__, __LINE__);
	if (session_list == NULL) {
//	console_printf("%s %d\n", __func__, __LINE__);
		return;
	}
	
	sessionp = session_list;
//	console_printf("%s %d\n", __func__, __LINE__);
	get_station_mac(sta_mac, req);
//	console_printf("%s %d\n", __func__, __LINE__);
	do {
#if defined(CONFIG_WNC_NEC_STOK_SESSION_AUTH)
		if (strcmp(req->stok, sessionp->stok) == 0) {
#else
	    if (memcmp(sta_mac, sessionp->station_mac, 6) == 0) {
#endif
//	    if (get_station_ip(req) == sessionp->station_ip) {
//	console_printf("%s %d\n", __func__, __LINE__);
    		remove_session(sessionp);
			sleep(1);
//			console_printf("Station %.2X:%.2X:%.2X:%.2X:%.2X:%.2X session logout\n", 
//				sta_mac[0], sta_mac[1], sta_mac[2], sta_mac[3], sta_mac[4], sta_mac[5]);
//	console_printf("%s %d\n", __func__, __LINE__);
			return;
		} else {
//	console_printf("%s %d\n", __func__, __LINE__);
			sessionp = sessionp->next;
//	console_printf("%s %d\n", __func__, __LINE__);
		}
	} while (sessionp != session_list);
	
//	console_printf("%s %d\n", __func__, __LINE__);
	return;
}
   
#endif //#ifdef MULTI_LOGIN

#if 0
/* WNC-MR1527-Heng-I-Chen-20120403-DNS check function declaration */
extern int dnschk(void);
/* WNC-MR1527-Heng-I-Chen-20120403-End */
#endif

/* WNC-MR0000-Heng-I-Chen-20120503-Internet Reachability Check uses saved netbiosname */
char nbname[17] = "";
/* WNC-MR0000-Heng-I-Chen-20120503-End */
/* WNC-NMR0000-Heng-I-Chen-20130125-add wan private IP check and PPPoE discovery */
extern int privateIPcheck(char *iface);
/* WNC-NMR0000-Heng-I-Chen-20130125-End */
typedef enum { IP_ADDR, SUBNET_MASK, DEFAULT_GATEWAY, HW_ADDR } ADDR_T;
extern int getInAddr(char *interface, ADDR_T type, void *pAddr);

#ifdef USE_AUTH
/*
 * Name: base64decode
 *
 * Description: Decodes BASE-64 encoded string
 */
static int base64decode(void *dst,char *src,int maxlen)
{
	int bitval,bits;
	int val;
	int len,x,y;

	len = strlen(src);
	bitval=0;
	bits=0;
	y=0;

	for(x=0;x<len;x++)
	{
		if ((src[x]>='A')&&(src[x]<='Z')) val=src[x]-'A'; else
			if ((src[x]>='a')&&(src[x]<='z')) val=src[x]-'a'+26; else
				if ((src[x]>='0')&&(src[x]<='9')) val=src[x]-'0'+52; else
					if (src[x]=='+') val=62; else
						if (src[x]=='-') val=63; else
							val=-1;
		if (val>=0)
		{
			bitval=bitval<<6;
			bitval+=val;
			bits+=6;
			while (bits>=8)
			{
				if (y<maxlen)
					((char *)dst)[y++]=(bitval>>(bits-8))&0xFF;
				bits-=8;
				bitval &= (1<<bits)-1;
			}
		}
	}
	if (y<maxlen)
		((char *)dst)[y++]=0;
	return y;
}
#endif // USE_AUTH

/*
 * Name: new_request
 * Description: Obtains a request struct off the free list, or if the
 * free list is empty, allocates memory
 *
 * Return value: pointer to initialized request
 */

request *new_request(void)
{
	//printf("%s\n", __FUNCTION__);
	request *req;

	if (request_free) {
		req = request_free;     /* first on free list */
		dequeue(&request_free, request_free); /* dequeue the head */
	} else {
		req = (request *) malloc(sizeof (request));
		if (!req) {
			log_error_time();
			perror("malloc for new request");
			return NULL;
		}
	}

#ifdef BOA_WITH_OPENSSL
	req->ssl = NULL;
#endif

#ifdef SUPPORT_ASP
	req->max_buffer_size = CLIENT_STREAM_SIZE;
	req->buffer = (char *)malloc(req->max_buffer_size+1);
	if (!req->buffer)
		DIE("out of memory");	
#endif
	req->multipart_boundary = NULL;
#ifdef HTTP_FILE_SERVER_SUPPORTED
	http_file_server_req_init(req);
#endif

#ifdef BOA_WITH_MBEDTLS
    mbedtls_net_init( &(req->mbedtls_client_fd) );
    mbedtls_ssl_init( &(req->mbedtls_ssl_ctx) );
#endif

	sanitize_request(req, 1);

	return req;
}

/*
 * Name: get_request
 *
 * Description: Polls the server socket for a request.  If one exists,
 * does some basic initialization and adds it to the ready queue;.
 */

#ifdef BOA_WITH_OPENSSL
request* get_request(int server_sock)
#else
void get_request(int server_sock)
#endif
{
	//    printf("%s\n", __FUNCTION__);
	int fd;                     /* socket */
	struct SOCKADDR remote_addr = {0}; /* address */
	struct SOCKADDR salocal;
	unsigned int remote_addrlen = sizeof (struct SOCKADDR);
	request *conn=NULL;              /* connection */
	socklen_t len;

#ifdef BOA_WITH_MBEDTLS
    conn = new_request();
    if (!conn) {
        return NULL;
    }

#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)
	conn->ssl_flag = 0;
#endif	

    if(server_sock==((mbedtls_net_context *) &mbedtls_listen_fd)->fd)
    {
#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)
		if(get_mbedtls_request(conn, (void *)&remote_addr.sin_addr.s_addr, &remote_addrlen)!=0)
#else
        if(get_mbedtls_request(conn)!=0)
#endif		
		{
			//printf("[%s:%d] get mbedtls request fail!\n", __FUNCTION__, __LINE__);
            enqueue(&request_free, conn);
            return ;
		}
        fd = (mbedtls_net_context *)(&(conn->mbedtls_client_fd))->fd;
        //printf("[%s:%d] accept mbedtls client fd %d\n", __FUNCTION__, __LINE__, fd);

#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)
		conn->ssl_flag = 1;
#endif	

    }else
#endif
    {
#ifndef INET6
		remote_addr.S_FAMILY = (sa_family_t) 0xdead;
#endif
		fd = accept(server_sock, (struct sockaddr *) &remote_addr,
			&remote_addrlen);
    }

	if (fd == -1) {
		if (errno != EAGAIN && errno != EWOULDBLOCK) {
			/* abnormal error */
			WARN("accept");
		} else {
			/* no requests */
		}
		pending_requests = 0;
#ifdef BOA_WITH_MBEDTLS
        enqueue(&request_free, conn);
#endif
		return NULL;
	}
	if (fd >= FD_SETSIZE) {
		log_error("Got fd >= FD_SETSIZE.");
		close(fd);
#ifdef BOA_WITH_MBEDTLS
        enqueue(&request_free, conn);
#endif
		return NULL;
	}

/* WNC-MIKE-YEH-20160901-implement remote maintenance account. */
#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)
	if(isFileExist(RMAINTE_NOW)) {
		struct in_addr rm_lan_addr, rm_lan_mask_addr; /* network order */
		int rm_lan_ip, rm_lan_mask; /* host order */
		char addr_buf[256]={0};

		/* lan ip */
		apmib_get(MIB_IP_ADDR, (void *)addr_buf);
		rm_lan_addr = *((struct in_addr *)addr_buf);
		rm_lan_ip = ntohl(rm_lan_addr.s_addr);

		apmib_get(MIB_AP_SUBNET_MASK, (void *)addr_buf);
		rm_lan_mask_addr = *((struct in_addr *)addr_buf);
		rm_lan_mask = ntohl(rm_lan_mask_addr.s_addr);
		
		if((ntohl(remote_addr.sin_addr.s_addr) & rm_lan_mask) == (rm_lan_ip & rm_lan_mask))
			conn->from_interface_flag = 1; /* 1: lan */
		else
			conn->from_interface_flag = 0; /* 0: wan */
	}
#endif
	
#ifdef DEBUGNONINET
	/* This shows up due to race conditions in some Linux kernels
	   when the client closes the socket sometime between
	   the select() and accept() syscalls.
	   Code and description by Larry Doolittle <ldoolitt@boa.org>
	   */
	if (remote_addr.sin_family != PF_INET) {
		struct sockaddr *bogus = (struct sockaddr *) &remote_addr;
		char *ap, ablock[44];
		int i;
		close(fd);
		log_error_time();
		for (ap = ablock, i = 0; i < remote_addrlen && i < 14; i++) {
			*ap++ = ' ';
			*ap++ = INT_TO_HEX((bogus->sa_data[i] >> 4) & 0x0f);
			*ap++ = INT_TO_HEX(bogus->sa_data[i] & 0x0f);
		}
		*ap = '\0';
		fprintf(stderr, "non-INET connection attempt: socket %d, "
				"sa_family = %hu, sa_data[%d] = %s\n",
				fd, bogus->sa_family, remote_addrlen, ablock);
#ifdef BOA_WITH_MBEDTLS
        enqueue(&request_free, conn);
#endif
		return NULL;
	}
#endif

	/* XXX Either delete this, or document why it's needed */
	/* Pointed out 3-Oct-1999 by Paul Saab <paul@mu.org> */
#ifdef REUSE_EACH_CLIENT_CONNECTION_SOCKET
	if ((setsockopt(fd, SOL_SOCKET, SO_REUSEADDR, (void *) &sock_opt,
					sizeof (sock_opt))) == -1) {
		DIE("setsockopt: unable to set SO_REUSEADDR");
	}
#endif

	len = sizeof (salocal);

	if (getsockname(fd, (struct sockaddr *) &salocal, &len) != 0) {
		WARN("getsockname");
		close(fd);
#ifdef BOA_WITH_MBEDTLS
        enqueue(&request_free, conn);
#endif
		return NULL;
	}

#ifndef BOA_WITH_MBEDTLS
    {
	conn = new_request();
	if (!conn) {
		close(fd);
		return NULL;
	}
    }
#endif
	conn->fd = fd;
	conn->status = READ_HEADER;
	conn->header_line = conn->client_stream;
	conn->time_last = current_time;
	conn->kacount = ka_max;

	if (ascii_sockaddr
			(&salocal, conn->local_ip_addr,
			 sizeof (conn->local_ip_addr)) == NULL) {
		WARN("ascii_sockaddr failed");
		close(fd);
		enqueue(&request_free, conn);
		return conn;
	}

	/* nonblocking socket */
	if (set_nonblock_fd(conn->fd) == -1) {
		WARN("fcntl: unable to set new socket to non-block");
		close(fd);
		enqueue(&request_free, conn);
		return conn;
	}

	/* set close on exec to true */
	if (fcntl(conn->fd, F_SETFD, 1) == -1) {
		WARN("fctnl: unable to set close-on-exec for new socket");
		close(fd);
		enqueue(&request_free, conn);
		return;
	}

#ifdef TUNE_SNDBUF
	/* Increase buffer size if we have to.
	 * Only ask the system the buffer size on the first request,
	 * and assume all subsequent sockets have the same size.
	 */
	if (system_bufsize == 0) {
		len = sizeof (system_bufsize);
		if (getsockopt
				(conn->fd, SOL_SOCKET, SO_SNDBUF, &system_bufsize, &len) == 0
				&& len == sizeof (system_bufsize)) {
			;
		} else {
			WARN("getsockopt(SNDBUF)");
			system_bufsize = 1;
		}
	}
	if (system_bufsize < sockbufsize) {
		if (setsockopt
				(conn->fd, SOL_SOCKET, SO_SNDBUF, (void *) &sockbufsize,
				 sizeof (sockbufsize)) == -1) {
			WARN("setsockopt: unable to set socket buffer size");
#ifdef DIE_ON_ERROR_TUNING_SNDBUF
			exit(errno);
#endif /* DIE_ON_ERROR_TUNING_SNDBUF */
		}
	}
#endif                          /* TUNE_SNDBUF */

	/* for log file and possible use by CGI programs */
	if (ascii_sockaddr
			(&remote_addr, conn->remote_ip_addr,
			 sizeof (conn->remote_ip_addr)) == NULL) {
		WARN("ascii_sockaddr failed");
		close(fd);
		enqueue(&request_free, conn);
		return conn;
	}

	/* for possible use by CGI programs */
	conn->remote_port = net_port(&remote_addr);

	status.requests++;

#ifdef USE_TCPNODELAY
	/* Thanks to Jef Poskanzer <jef@acme.com> for this tweak */
	{
		int one = 1;
		if (setsockopt(conn->fd, IPPROTO_TCP, TCP_NODELAY,
					(void *) &one, sizeof (one)) == -1) {
			DIE("setsockopt: unable to set TCP_NODELAY");
		}

	}
#endif

	total_connections++;
	/* gotta have some breathing room */
	if (total_connections > max_connections) {
		pending_requests = 0;
#ifndef NO_RATE_LIMIT
		/* have to fake an http version */
		conn->http_version = HTTP10;
		conn->method = M_GET;
		send_r_service_unavailable(conn);
		conn->status = DONE;
#endif                          /* NO_RATE_LIMIT */
	}

	enqueue(&request_ready, conn);

	return conn;
}//end get_request

#ifdef BOA_WITH_OPENSSL
void get_ssl_request(void)
{
	//printf("%s\n",__FUNCTION__);
	request *conn;
	conn = get_request(server_ssl);
	if(!conn)
		return;
	conn->ssl = SSL_new(ctx);
	if(conn->ssl == NULL){
		printf("Couldn't create ssl connection stuff\n");
		return ;
	}
	SSL_set_fd(conn->ssl, conn->fd);
	if(SSL_accept(conn->ssl) <= 0){ 
		ERR_print_errors_fp(stderr);
		return;
	}   
	else{printf("SSL_accepted\n");}
}
#endif

#ifdef BOA_WITH_MBEDTLS
#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)
int get_mbedtls_request(request *req, void *client_ip, unsigned int *ip_len)
#else
int get_mbedtls_request(request *req)
#endif
{
    int ret=0, len;
    unsigned char buf[1024];
	unsigned long timeout_cnt = 0;
	
	/*
     * 4b. Setup stuff
     */	
	mbedtls_printf( "  . Setting up the SSL data....stage 2" );
    fflush( stdout );
	
	if( ( ret = mbedtls_ssl_setup( &(req->mbedtls_ssl_ctx), &mbedtls_conf ) ) != 0 )
    {
        mbedtls_printf( " failed\n  ! mbedtls_ssl_setup returned %d\n\n", ret );
        return ret;
    }
	
    mbedtls_printf( " ok\n" );
	
reset:
#ifdef MBEDTLS_ERROR_C
    if( ret != 0 )
    {
        char error_buf[100];
        mbedtls_strerror( ret, error_buf, 100 );
        mbedtls_printf("Last error was: %d - %s\n\n", ret, error_buf );
    }
#endif

    mbedtls_net_free( &(req->mbedtls_client_fd) );

    mbedtls_ssl_session_reset( &(req->mbedtls_ssl_ctx) );
    /*
     * 3. Wait until a client connects
     */
    mbedtls_printf( "  . Waiting for a remote connection ..." );
    fflush( stdout );

#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)
	if( ( ret = mbedtls_net_accept( &mbedtls_listen_fd, &(req->mbedtls_client_fd),
					client_ip, *ip_len, ip_len ) ) != 0 )
#else
    if( ( ret = mbedtls_net_accept( &mbedtls_listen_fd, &(req->mbedtls_client_fd),
                    NULL, 0, NULL ) ) != 0 )
#endif
    {
        mbedtls_printf( " failed\n  ! mbedtls_net_accept returned %d\n\n", ret );
        mbedtls_net_free( &(req->mbedtls_client_fd) );
        mbedtls_ssl_free( &(req->mbedtls_ssl_ctx) );
        return ret; 
    }

    mbedtls_ssl_set_bio( &(req->mbedtls_ssl_ctx), &(req->mbedtls_client_fd), mbedtls_net_send, mbedtls_net_recv, NULL );

	/* WNC-NMR2235-MIKE-YEH-20170123-Can not access any more the quick setting web page. */
	/* set nonblock mode for clients. */
	mbedtls_net_set_nonblock( &(req->mbedtls_client_fd));

    mbedtls_printf( " ok... client_fd %d\n", ((mbedtls_net_context *) &(req->mbedtls_client_fd))->fd  );

    /*
     * 5. Handshake
     */
    mbedtls_printf( "  . Performing the SSL/TLS handshake..." );
    fflush( stdout );

    while( ( ret = mbedtls_ssl_handshake( &(req->mbedtls_ssl_ctx) ) ) != 0 )
    {
		/* WNC-NMR2235-MIKE-YEH-20170123-Can not access any more the quick setting web page.-start */
		timeout_cnt++; 
		if( timeout_cnt > ssl_rw_timeout_cnt ) { 
			printf("DEBUG: mbedtls_ssl_handshake() force disconnect!!! , cnt:%ld [%s:%d]\n",timeout_cnt, __FUNCTION__, __LINE__); 
			ret=MBEDTLS_ERR_NET_CONN_RESET; 
		} 
		/* WNC-NMR2235-MIKE-YEH-20170123-Can not access any more the quick setting web page.-end */
	
        if( ret != MBEDTLS_ERR_SSL_WANT_READ && ret != MBEDTLS_ERR_SSL_WANT_WRITE )
        {
            mbedtls_printf( " failed\n  ! mbedtls_ssl_handshake returned %d\n\n", ret );
            goto reset;
        }
    }

    mbedtls_printf( " ok! Now can r/w data...\n" );

    return ret; 
}
#endif

static void sanitize_request(request * req, int new_req)
{
	static unsigned int bytes_to_zero = offsetof(request, fd);

	if (new_req) {
		req->kacount = ka_max;
		req->time_last = current_time;
		req->client_stream_pos = 0;
	} else {
		unsigned int bytes_to_move =
			req->client_stream_pos - req->parse_pos;

		if (bytes_to_move) {
			memmove(req->client_stream,
					req->client_stream + req->parse_pos, bytes_to_move);
		}
		req->client_stream_pos = bytes_to_move;
	}

	/* bzero */
	/* we want to clear a middle part of the request:
	*/

	DEBUG(DEBUG_REQUEST) {
		log_error_time();
		fprintf(stderr, "req: %p, offset: %u\n", (void *) req,
				bytes_to_zero);
	}

	memset(req, 0, bytes_to_zero);

	req->status = READ_HEADER;
	req->header_line = req->client_stream;
}

/*
 * Name: free_request
 *
 * Description: Deallocates memory for a finished request and closes
 * down socket.
 */

static void free_request(request * req)
{
	//printf("%s\n",__FUNCTION__);
	int i;
	/* free_request should *never* get called by anything but
	   process_requests */

	if (req->buffer_end && req->status < TIMED_OUT) {
		/*
		   WARN("request sent to free_request before DONE.");
		   */
		req->status = DONE;

		/* THIS IS THE SAME CODE EXECUTED BY THE 'DONE' SECTION
		 * of process_requests. It must be exactly the same!
		 */
		i = req_flush(req);
		/*
		 * retval can be -2=error, -1=blocked, or bytes left
		 */
		if (i == -2) {          /* error */
			req->status = DEAD;
		} else if (i > 0) {
			return;
		}
	}
	/* put request on the free list */
	dequeue(&request_ready, req); /* dequeue from ready or block list */

	/* set response status to 408 if the client has timed out */
	if (req->status == TIMED_OUT && req->response_status == 0)
		req->response_status = 408;

	if (req->kacount < ka_max &&
			!req->logline &&
			req->client_stream_pos == 0) {
		/* A keepalive request wherein we've read
		 * nothing.
		 * Ignore.
		 */
		;
	} else {
		log_access(req);
	}

	if (req->mmap_entry_var)
		release_mmap(req->mmap_entry_var);
	else if (req->data_mem)
		munmap(req->data_mem, req->filesize);

	if (req->data_fd) {
		close(req->data_fd);
		BOA_FD_CLR(req, req->data_fd, BOA_READ);
	}

	// davidhsu ----------------------
#ifndef NEW_POST
	if (req->post_data_fd) {
		close(req->post_data_fd);
		BOA_FD_CLR(req, req->post_data_fd, BOA_WRITE);
	}
#else
//#if defined(BOA_CGI_SUPPORT)
//WNC-JDR230-YUAN-I-CHOU-20130313, Apply Realtek rtl819x-sdk-boa_cgi_support_patch_20130313
//WNC-JDR230-YUAN-I-CHOU-20130315, Apply Realtek rtl819x-sdk-boa_cgi_support_patch_20130313_nec
//if (req->cgi_type == CGI) {
if (req->cgi_type == CGI || req->cgi_type == NPH) {
//WNC-JDR230-YUAN-I-CHOU-20130315, Apply Realtek rtl819x-sdk-boa_cgi_support_patch_20130313_nec End
   if (req->post_data_fd) {
	   close(req->post_data_fd);
	   BOA_FD_CLR(req, req->post_data_fd, BOA_WRITE);
   }
}
//WNC-JDR230-YUAN-I-CHOU-20130313, Apply Realtek rtl819x-sdk-boa_cgi_support_patch_20130313 End
else {

//#endif
   if (req->post_data) {  	
   	free(req->post_data);
	req->post_data = NULL;   	
	req->post_data_len = req->post_data_idx = 0;	
//WNC-JDR230-YUAN-I-CHOU-20130313, Apply Realtek rtl819x-sdk-boa_cgi_support_patch_20130313
   }
//WNC-JDR230-YUAN-I-CHOU-20130313, Apply Realtek rtl819x-sdk-boa_cgi_support_patch_20130313 End
}
#endif   
	//--------------------------------

	if (req->response_status >= 400)
		status.errors++;

	for (i = common_cgi_env_count; i < req->cgi_env_index; ++i) {
		if (req->cgi_env[i]) {
			free(req->cgi_env[i]);
		} else {
			log_error_time();
			fprintf(stderr, "Warning: CGI Environment contains NULL value"
					"(index %d of %d).\n", i, req->cgi_env_index);
		}
	}

	if (req->pathname)
		free(req->pathname);
	if (req->path_info)
		free(req->path_info);
	if (req->path_translated)
		free(req->path_translated);
	if (req->script_name)
		free(req->script_name);
	if (req->host)
		free(req->host);
	if (req->ranges)
		ranges_reset(req);

#ifdef USE_AUTH
	if (req->userName)
		free(req->userName);			
	if (req->password)
		free(req->password);	
#endif
#ifdef DIGEST_AUTHENTICATION
	if(req->authorization_nonce != NULL)//free nonce
	{
		free(req->authorization_nonce); //free nonce
		req->authorization_nonce = NULL;
	}
	if(req->authorization_uri != NULL)//free uri
	{
		free(req->authorization_uri);
		req->authorization_uri = NULL;
	}
	if(req->authorization_response != NULL)//free response
	{
		free(req->authorization_response);
		req->authorization_response = NULL;
	}
#endif

#ifdef SUPPORT_ASP
	if (req->buffer)
	{
		free(req->buffer);
		req->buffer=NULL;
	}

	// davidhsu -------------	
	if (req->upload_data)
	{
#if defined(CONFIG_APP_FWD)		
		fprintf(stderr, "free upload data..............................\n");
		/*upload_data points to share memory*/
		req->upload_data=NULL;
// WNC-NMR0765-JDR231-HENG-I-CHEN-2014-10-02: add proection of firmware file uploading #BEGIN
		if (request_lock_shm == req) {
			request_lock_shm = NULL;
			last_access_time = 0;
		}
// WNC-NMR0765-JDR231-HENG-I-CHEN-2014-10-02: add proection of firmware file uploading #END
#else
		fprintf(stderr, "free upload data..............................\n");	
		free(req->upload_data);	
		req->upload_data = NULL;
#endif
	}
	//----------------------	


#endif	

	if (req->multipart_boundary) {
		free(req->multipart_boundary);
	}

#ifdef HTTP_FILE_SERVER_SUPPORTED
	http_file_server_req_free(req);
	http_file_server_req_init(req);
#endif

	if (req->status < TIMED_OUT && (req->keepalive == KA_ACTIVE) &&
			(req->response_status < 500 && req->response_status != 0) && req->kacount > 0) {
		sanitize_request(req, 0);

		--(req->kacount);

		status.requests++;
		enqueue(&request_block, req);
		BOA_FD_SET(req, req->fd, BOA_READ);
		BOA_FD_CLR(req, req->fd, BOA_WRITE);
		return;
	}

#ifdef BOA_WITH_OPENSSL
	SSL_free(req->ssl);
#elif defined(BOA_WITH_MBEDTLS)
    if(req->mbedtls_client_fd.fd!=-1)
    {
        int ret;
        mbedtls_printf( "  . Closing the connection %d...", req->mbedtls_client_fd.fd );

        while( ( ret = mbedtls_ssl_close_notify( &req->mbedtls_ssl_ctx ) ) < 0 )
        {
            if( ret != MBEDTLS_ERR_SSL_WANT_READ &&
                    ret != MBEDTLS_ERR_SSL_WANT_WRITE )
            {
                mbedtls_printf( " failed\n  ! mbedtls_ssl_close_notify returned %d\n\n", ret );
                break;
            }
        }

        mbedtls_printf( " ok\n" );

        mbedtls_net_free( &(req->mbedtls_client_fd) );
        mbedtls_ssl_session_reset( &(req->mbedtls_ssl_ctx) );
        mbedtls_ssl_free( &(req->mbedtls_ssl_ctx) );
    }
#endif
	/*
	   While debugging some weird errors, Jon Nelson learned that
	   some versions of Netscape Navigator break the
	   HTTP specification.

	   Some research on the issue brought up:

http://www.apache.org/docs/misc/known_client_problems.html

As quoted here:

"
Trailing CRLF on POSTs

This is a legacy issue. The CERN webserver required POST
data to have an extra CRLF following it. Thus many
clients send an extra CRLF that is not included in the
Content-Length of the request. Apache works around this
problem by eating any empty lines which appear before a
request.
"

Boa will (for now) hack around this stupid bug in Netscape
(and Internet Exploder)
by reading up to 32k after the connection is all but closed.
This should eliminate any remaining spurious crlf sent
by the client.

Building bugs *into* software to be compatible is
just plain wrong
*/

	if (req->method == M_POST) {
		char buf[32768];
		read(req->fd, buf, sizeof(buf));
	}
	close(req->fd);
	BOA_FD_CLR(req, req->fd, BOA_READ);
	BOA_FD_CLR(req, req->fd, BOA_WRITE);
	total_connections--;

	enqueue(&request_free, req);

	return;
}

/*
 * Name: process_requests
 *
 * Description: Iterates through the ready queue, passing each request
 * to the appropriate handler for processing.  It monitors the
 * return value from handler functions, all of which return -1
 * to indicate a block, 0 on completion and 1 to remain on the
 * ready list for more processing.
 */

extern int isFWUPGRADE;
#ifdef BOA_WITH_SSL
extern int fwInProgress;
#endif
int firmware_len=0;
char *firmware_data;
void process_requests(int server_sock)
{
	int retval = 0;
	request *current, *trailer;

	if (pending_requests) {
		get_request(server_sock);
#ifdef ORIGINAL_BEHAVIOR
		pending_requests = 0;
#endif
	}

	current = request_ready;

	while (current) {
		time(&current_time);
		retval = 1;             /* emulate "success" in case we don't have to flush */

		if (current->buffer_end && /* there is data in the buffer */
				current->status < TIMED_OUT) {
			retval = req_flush(current);
			/*
			 * retval can be -2=error, -1=blocked, or bytes left
			 */
			if (retval == -2) { /* error */
				current->status = DEAD;
				retval = 0;
			} else if (retval >= 0) {
				/* notice the >= which is different from below?
				   Here, we may just be flushing headers.
				   We don't want to return 0 because we are not DONE
				   or DEAD */
				retval = 1;
			}
		}
		//fprintf(stderr, "###current=%p status=%d###\n", current, current->status);
		if (retval == 1) {
			switch (current->status) {
				case READ_HEADER:
				case ONE_CR:
				case ONE_LF:
				case TWO_CR:
					retval = read_header(current);
					break;
				case BODY_READ:
					retval = read_body(current);
					break;
				case BODY_WRITE:
					retval = write_body(current);
					break;
				case WRITE:
					retval = process_get(current);
					break;
				case PIPE_READ:
					retval = read_from_pipe(current);
					break;
				case PIPE_WRITE:
					retval = write_from_pipe(current);
					break;
				case IOSHUFFLE:
#ifdef HAVE_SENDFILE
					retval = io_shuffle_sendfile(current);
#else
					retval = io_shuffle(current);
#endif
					break;
				case DONE:
					/* a non-status that will terminate the request */
					retval = req_flush(current);
					/*
					 * retval can be -2=error, -1=blocked, or bytes left
					 */
					if (retval == -2) { /* error */
						current->status = DEAD;
						retval = 0;
					} else if (retval > 0) {
						retval = 1;
					}
					break;
				case TIMED_OUT:
				case DEAD:
					retval = 0;
					current->buffer_end = 0;
					SQUASH_KA(current);
					break;
				default:
					retval = 0;
					fprintf(stderr, "Unknown status (%d), "
							"closing!\n", current->status);
					current->status = DEAD;
					break;
			}

		}

		if (sigterm_flag)
			SQUASH_KA(current);

		/* we put this here instead of after the switch so that
		 * if we are on the last request, and get_request is successful,
		 * current->next is valid!
		 */
		if (pending_requests)
			get_request(server_sock);

		//printf("[%s:%d]retval=%d, isFWUPGRADE=%d\n", __FUNCTION__,__LINE__,retval, isFWUPGRADE);
		switch (retval) {
			case -1:               /* request blocked */
				trailer = current;
				current = current->next;
				block_request(trailer);
				break;
			case 0:                /* request complete */
				current->time_last = current_time;
				//brad add
/* WNC-MRXXXX-Heng-I-Chen-20120503-Add Online Version Up function */
            if(isFWUPGRADE == 1 && (!strcmp(current->request_uri,"/boafrm/formUpload") || !strcmp(current->request_uri,"/boafrm/formOnlineVersionUp")
				|| !strcmp(current->request_uri,"/boafrm/formUploadToEbank"))
#ifdef BOA_WITH_SSL
				&& fwInProgress == 0) 
#else
				)
#endif
				{
/* WNC-MRXXXX-Heng-I-Chen-20120503-End */
				if (current->upload_len && current->upload_data) {
	            	firmware_len= current->upload_len;   //assign upload length
    	        	firmware_data = (char *)current->upload_data; //assign upload data pointer
            		//fprintf(stderr, "free upload data..............................\n");
    	        	current->upload_data = NULL;
#ifdef BOA_WITH_SSL
                    fwInProgress = 1;
#endif
				}
            }
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, Add Shared memory protection
#if defined(CONFIG_APP_FWD)
// WNC-NMR0765-JDR231-HENG-I-CHEN-2014-10-02: add proection of firmware file uploading #BEGIN
			else if ((request_lock_shm == current) && !(get_shm_id() < 0)) {
// WNC-NMR0765-JDR231-HENG-I-CHEN-2014-10-02: add proection of firmware file uploading #END
            	clear_shm();
// WNC-NMR0765-JDR231-HENG-I-CHEN-2014-10-02: add proection of firmware file uploading #BEGIN
            	request_lock_shm = NULL;
            	last_access_time = 0;
// WNC-NMR0765-JDR231-HENG-I-CHEN-2014-10-02: add proection of firmware file uploading #END
				//fprintf(stderr, "FWD free upload data..............................\n");
            	current->upload_data = NULL;
        	}
#endif
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, End
				trailer = current;
				current = current->next;
				free_request(trailer);
				break;
			case 1:                /* more to do */
				current->time_last = current_time;
				current = current->next;
				break;
			default:
				log_error_doc(current);
				fprintf(stderr, "Unknown retval in process.c - "
						"Status: %d, retval: %d\n", current->status, retval);
				current->status = DEAD;
				current = current->next;
				break;
		}
	}
}

/*
 * Name: process_logline
 *
 * Description: This is called with the first req->header_line received
 * by a request, called "logline" because it is logged to a file.
 * It is parsed to determine request type and method, then passed to
 * translate_uri for further parsing.  Also sets up CGI environment if
 * needed.
 */

int process_logline(request * req)
{
	char *stop, *stop2;

	req->logline = req->client_stream;

	if (strlen(req->logline) < 5) {
		/* minimum length req'd. */
		log_error_doc(req);
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch for NMR158
		DEBUG(DEBUG_BOA) {
			fprintf(stderr, "Request too short: \"%s\"\n", req->logline);
		}
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch for NMR158 End
		send_r_bad_request(req);
		return 0;
	}

	if (!memcmp(req->logline, "GET ", 4))
		req->method = M_GET;
	else if (!memcmp(req->logline, "HEAD ", 5))
		/* head is just get w/no body */
		req->method = M_HEAD;
	else if (!memcmp(req->logline, "POST ", 5))
		req->method = M_POST;
	else {
		log_error_doc(req);
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch for NMR158
		DEBUG(DEBUG_BOA) {
			fprintf(stderr, "malformed request: \"%s\"\n", req->logline);
		}
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch for NMR158 End
		send_r_not_implemented(req);
		return 0;
	}

	req->http_version = HTTP10;

	/* Guaranteed to find ' ' since we matched a method above */
	stop = req->logline + 3;
	if (*stop != ' ')
		++stop;

	/* scan to start of non-whitespace */
	while (*(++stop) == ' ');

	stop2 = stop;

	/* scan to end of non-whitespace */
	while (*stop2 != '\0' && *stop2 != ' ')
		++stop2;

	if (stop2 - stop > MAX_HEADER_LENGTH) {
		log_error_doc(req);
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch for NMR158
		DEBUG(DEBUG_BOA) {
			fprintf(stderr, "URI too long %d: \"%s\"\n", MAX_HEADER_LENGTH,
					req->logline);
		}
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch for NMR158 End
		send_r_bad_request(req);
		return 0;
	}

	/* check for absolute URL */
	if (!memcmp(stop, SERVER_METHOD,
				strlen(SERVER_METHOD)) &&
			!memcmp(stop + strlen(SERVER_METHOD), "://", 3)) {
		char *host;

		/* we have an absolute URL */
		/* advance STOP until first '/' after host */
		stop += strlen(SERVER_METHOD) + 3;
		host = stop;
		/* if *host is '/' there is no host in the URI
		 * if *host is ' ' there is corruption in the URI
		 * if *host is '\0' there is nothing after http://
		 */
		if (*host == '/' || *host == ' ' || *host == '\0') {
			/* nothing *at all* after http:// */
			/* no host in absolute URI */
			log_error_doc(req);
			/* we don't need to log req->logline, because log_error_doc does */
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch for NMR158
			DEBUG(DEBUG_BOA) {
				fprintf(stderr, "bogus absolute URI\n");
			}
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch for NMR158 End
			send_r_bad_request(req);
			return 0;
		}

		/* OK.  The 'host' is at least 1 char long.
		 * advance to '/', or end of host+url (' ' or ''\0')
		 */
		while(*stop != '\0' && *stop != '/' && *stop != ' ')
			++stop;

		if (*stop != '/') { /* *stop is '\0' or ' ' */
			/* host is valid, but there is no URL. */
			log_error_doc(req);
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch for NMR158
			DEBUG(DEBUG_BOA) {
				fprintf(stderr, "no URL in absolute URI: \"%s\"\n",
						req->logline);
			}
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch for NMR158 End
			send_r_bad_request(req);
			return 0;
		}

		/* we have http://X/ where X is not ' ' or '/' (or '\0') */
		/* since stop2 stops on '\0' and ' ', it *must* be after stop */
		/* still, a safety check (belts and suspenders) */
		if (stop2 < stop) {
			/* Corruption in absolute URI */
			/* This prevents a DoS attack from format string attacks */
			log_error_doc(req);
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch for NMR158
			DEBUG(DEBUG_BOA) {
				fprintf(stderr, "Error: corruption in absolute URI:"
						"\"%s\".  This should not happen.\n", req->logline);
			}
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch for NMR158 End
			send_r_bad_request(req);
			return 0;
		}

		/* copy the URI */
		memcpy(req->request_uri, stop, stop2 - stop);
		/* place a NIL in the file spot to terminate host */
		*stop = '\0';
		/* place host */
		/* according to RFC2616 --

		   1. If Request-URI is an absoluteURI, the host is part of the
		   Request-URI. Any Host header field value in the request MUST
		   be ignored.

		   Since we ignore any Host header if req->host is already set,
		   well, we rock!

*/
		req->header_host = host; /* this includes the port! (if any) */
	} else {
		/* copy the URI */
		memcpy(req->request_uri, stop, stop2 - stop);
	}

	req->request_uri[stop2 - stop] = '\0';

	/* METHOD URL\0 */
	if (*stop2 == '\0')
		req->http_version = HTTP09;
	else if (*stop2 == ' ') {
		/* if found, we should get an HTTP/x.x */
		unsigned int p1, p2;

		/* scan to end of whitespace */
		++stop2;
		while (*stop2 == ' ' && *stop2 != '\0')
			++stop2;

		if (*stop2 == '\0') {
			req->http_version = HTTP09;
		} else {
			/* scan in HTTP/major.minor */
			//joe_debug: to modify
			if (sscanf(stop2, "HTTP/%u.%u", &p1, &p2) == 2) {
				/* HTTP/{0.9,1.0,1.1} */
				if (p1 == 0 && p2 == 9) {
					req->http_version = HTTP09;
				} else if (p1 == 1 && p2 == 0) {
					req->http_version = HTTP10;
				} else if (p1 == 1 && p2 == 1) {
					req->http_version = HTTP11;
					//req->keepalive = KA_ACTIVE; /* enable keepalive */
					req->keepalive = KA_STOPPED; /* disable it for some smart phone access DUT web UI fail */
					/* Disable send_r_continue because some clients
					 * *still* don't work with it, Python 2.2 being one
					 * see bug 227361 at the sourceforge web site.
					 * fixed in revision 1.52 of httplib.py, dated
					 * 2002-06-28 (perhaps Python 2.3 will
					 * contain the fix.)
					 *
					 * Also, send_r_continue should *only* be
					 * used if the expect header was sent.
					 */
					/* send_r_continue(req); */
				} else {
					goto BAD_VERSION;
				}
			} else {
				goto BAD_VERSION;
			}
		}
	}

	if (req->method == M_HEAD && req->http_version == HTTP09) {
		log_error("method is HEAD but version is HTTP/0.9");
		send_r_bad_request(req);
		return 0;
	}
	req->cgi_env_index = common_cgi_env_count;

	return 1;

BAD_VERSION:
	log_error_doc(req);
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch for NMR158
	DEBUG(DEBUG_BOA) {
		fprintf(stderr, "bogus HTTP version: \"%s\"\n", stop2);
	}
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch for NMR158 End
	send_r_bad_request(req);
	return 0;
}

/* WNC-MR0000-Heng-I-Chen-20130312-5.18.2 Skip Basic Authentication, add check skip authentication configuration */		
int check_auth_conf(char *uri) {
    FILE *fp;
    char buf[256];
    char *cp, *path, *pattern;
    fp = fopen("/etc/boa/auth.conf", "r");
    if (!fp)
        return 0;

    do {
        cp = fgets(buf, 256, fp);
        if (cp) {
            if (*buf == '#')
                continue;
            path = strtok(buf, " \t\n\r");
// WNC-NMR0000-Heng-I-Chen-20130815: 20130717-pocket-alpha2-coverity-error-userland Errors 601 RESOURCE_LEAK
            if (path == NULL) {
            	fclose(fp);
                return 0;
            }
// WNC-NMR0000-Heng-I-Chen-20130815: End
            pattern = strtok(NULL, " \t\n\r");
// WNC-NMR0000-Heng-I-Chen-20130815: 20130717-pocket-alpha2-coverity-error-userland Errors 610 RESOURCE_LEAK
            if (pattern == NULL) {
            	fclose(fp);
                return 0;
            }
// WNC-NMR0000-Heng-I-Chen-20130815: End
            if (strcmp(pattern, "PREFIX")==0) {
                if(strncmp(uri, path, strlen(path))==0) {
                    fclose(fp);
                    return 1;
                }
            } else if (strcmp(pattern, "PERFECT")==0) {
                if(strcmp(uri, path)==0) {
                    fclose(fp);
                    return 1;
                }
            } else {
                continue;
            }
        }
    } while (cp);

    fclose(fp);
    return 0;
}
/* WNC-MR0000-Heng-I-Chen-20130312-End */

#ifdef DIGEST_AUTHENTICATION     //define MD5_encryption method
char * MD5_encryption(char *input_string)
{
	if(input_string == NULL)
	{
		perror("boa: argument of MD5_encryption is NULL.");
		return NULL;
	}

	unsigned char temp_encryption[TEMP_DIGEST_LENGTH];
	MD5_CTX md5;
	
	MD5Init(&md5);
	MD5Update(&md5,input_string,strlen(input_string));
	MD5Final(&md5,temp_encryption);

	char * encryption=malloc(FINAL_DIGEST_LENGTH+1);
	if(encryption == NULL)
	{
		perror("boa: malloc encryption out of memory in function MD5_encryption.");
		return NULL;
	}
	memset(encryption,0,FINAL_DIGEST_LENGTH+1);
	char str[2];

	int i;
	for(i=0;i<16;i++)
	{
		//snprintf(str, sizeof(str),"%02x",temp_encryption[i]&0x0ff);
		snprintf(str, sizeof(str),"%02x",temp_encryption[i]);
		strlcat(encryption, str, (FINAL_DIGEST_LENGTH+1));
	}
	return encryption;
}

char * generate_digest(request * req,char user_name[],char user_password[])
{
	if(req == NULL)
	{
		perror("boa: req is NULL in function process_header_end.");
		exit(1);
	}
	
	char server_realm[]=":Realtek:";       //===generate HA1===
	int A1_length=strlen(user_name)+strlen(server_realm)+strlen(user_password);
	unsigned char * A1=malloc(A1_length+1);
	if(A1 == NULL)
	{
		perror("boa: malloc A1 out of memory in function process_header_end.");
		exit(1);
	}
	memset(A1,0,A1_length+1);
	strlcat(A1, user_name, (A1_length+1));
	strlcat(A1, server_realm, (A1_length+1));
	strlcat(A1, user_password, (A1_length+1));

	char * HA1 = MD5_encryption(A1);
	free(A1);
	if(HA1 == NULL)
	{
		perror("boa: generate HA1 error in function process_header_end.");
		exit(1);
	}	

	char * request_method=NULL;             //===generate HA2===
	switch(req->method)
	{
		case M_GET:
			request_method="GET";
			break;
		case M_HEAD:
			request_method="HEAD";
			break;
		case M_PUT:
			request_method="PUT";
			break;
		case M_POST:
			request_method="POST";
			break;
		case M_DELETE:
			request_method="DELETE";
			break;
		case M_LINK:
			request_method="LINK";
			break;
		case M_UNLINK:
			request_method="UNLINK";
			break;
		case M_MOVE:
			request_method="MOVE";
			break;
		case M_TRACE:
			request_method="TRACE";
			break;
		default:
			log_error("request_method is NULL.\n");
			send_r_bad_request(req);
			return 0;
	}
	//if(request_method == NULL)
	//{
	//	log_error("request_method is NULL.\n");
	//	send_r_bad_request(req);
	//	return 0;
	//}
	int A2_length;
	if(req->authorization_uri != NULL)
	{
		A2_length=strlen(request_method)+1+strlen(req->authorization_uri);
	}
	else
	{
		A2_length=strlen(request_method)+1;
	}
	
	unsigned char * A2=malloc(A2_length+1);
	if(A2 == NULL)
	{
		perror("boa: malloc A2 out of memory in function process_header_end.");
		exit(1);
	}
	
	memset(A2,0,A2_length+1);
	strlcat(A2, request_method, (A2_length+1));
	strlcat(A2, ":", (A2_length+1));
	if(req->authorization_uri != NULL)
	{
		strlcat(A2, req->authorization_uri, (A2_length+1));
	}
	char * HA2=MD5_encryption(A2);
	free(A2);
	if(HA2 == NULL)
	{
		perror("boa: generate HA2 error in function process_header_end.");
		exit(1);
	}	

	int MD5_input_length;                     //===generate digest===
	if(req->authorization_nonce != NULL)
	{
		MD5_input_length=strlen(HA1)+1+strlen(req->authorization_nonce)+1+strlen(HA2);
	}
	else
	{
		MD5_input_length=strlen(HA1)+1+1+strlen(HA2);
	}
	
	unsigned char * MD5_input=malloc(MD5_input_length+1);
	if(MD5_input == NULL)
	{
		perror("boa: malloc MD5_input out of memory in function process_header_end.");
		exit(1);
	}
	
	memset(MD5_input,0,MD5_input_length+1);
	strlcat(MD5_input, HA1, (MD5_input_length+1));
	strlcat(MD5_input, ":", (MD5_input_length+1));
	if(req->authorization_nonce != NULL)
	{
		strlcat(MD5_input, req->authorization_nonce, (MD5_input_length+1));
	}
	strlcat(MD5_input, ":", (MD5_input_length+1));
	strlcat(MD5_input, HA2, (MD5_input_length+1));
	
	free(HA1);
	free(HA2);
	char * digest=MD5_encryption(MD5_input);
	free(MD5_input);
	if(digest == NULL)
	{
		perror("boa: generate digest error in function process_header_end.");
		exit(1);
	}
	
	return digest;
}
#endif

// WNC-NMR0000-D2R031-HENG-I-CHEN-2016-03-16: 4.4.47.3 #BEGIN	
#define SECRET_CODE "77EQ39NV13PQXWEW"
#define ATREM_SERVER_CONF_FILENAME "/var/aterm_server.conf"
time_t aterm_server_conf_update = -1;
int get_server_setting_times = 0;

char* get_action_code() {

		char product[17]="";
		unsigned char mac[6]="";
		char buf[45] = "";
		char *cp, *result;
		int i;
		
		if ( !apmib_get(MIB_HW_PRODUCT_NAME,  (void*)product))
			return -1;

		if ( !apmib_get(MIB_HW_NIC1_ADDR,  (void *)mac) ) {
			return -1;
		}

		snprintf(buf, sizeof(buf), "%s%02X%02X%02X%02X%02X%02X%s", product,
			mac[0], mac[1], mac[2], mac[3], mac[4], mac[5], SECRET_CODE);
	
		cp = buf;
		while (*cp) {
			*cp = toupper(*cp);
			cp++;
		}

		result = md5sum(buf, strlen(buf));

		cp = result;
		while (*cp) {
			*cp = toupper(*cp);
			cp++;
		}
		
		return result;
}
// WNC-NMR0000-D2R031-HENG-I-CHEN-2016-03-16: 4.4.47.3 #END


/* WNC-MIKE-YEH-20160805-implement remote maintenance account. */
#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)
int check_rmainte_conf(void)
{
	if(isFileExist(RMAINTE_ACCOUNT_CONF) && isFileExist(RMAINTE_NOW))
	{
		return 1;
	}
	else
		return 0;
}
#endif

#if defined(CONFIG_WNC_NEC_STOK_SESSION_AUTH)
void url_stok_paser(request * req)
{
	if (req->request_uri) {
	
		char  *stok_head = NULL, *stok_head_tmp = NULL, *stok_tail = NULL;
		char stok_str[40] = {0}, skip_stok_url[MAX_HEADER_LENGTH + 1] = {0};
		int len = 0;
	
		//printf("\r\n before url_stok_paser() , req->request_uri=%s , req->stok=%s , sizeof(req->stok)=%d \r\n", req->request_uri, req->stok, sizeof(req->stok));

		memset(req->stok, 0, sizeof(req->stok));

		if (stok_head = strstr(req->request_uri, "stok=")) {
			/* skip redundancy stok id. */
			stok_head += strlen("stok=");
			while (stok_head_tmp = strstr(stok_head, "stok=")) {
				stok_head = stok_head_tmp;
				stok_head += strlen("stok=");
			}

			if (stok_tail = strstr(stok_head, "/")) {
				len = stok_tail - stok_head;			
				strlcpy(req->stok, stok_head, len+1);
				len = 0;
				len = strlen(stok_tail);

				if(len > 0) {
					strlcpy(req->request_uri, stok_tail, len+1);
					//printf("\r\n after url_stok_paser() , req->request_uri=%s \r\n", req->request_uri);
				}
			}			
		}
	}
}
#endif

/*
 * Name: process_header_end
 *
 * Description: takes a request and performs some final checking before
 * init_cgi or init_get
 * Returns 0 for error or NPH, or 1 for success
 */

int process_header_end(request * req)
{
	/* WNC-NMR0000-Rita-20130226-V1.2.0_Sonic_SpecChangeRequest_3.2.3-GUI Response Depending on Operation Mode */
	//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130814, fix coverity error 777
	/* WNC-NMR0000-JOE-PENG-20140109-Implement section 4.2.2 GUI Response Depending on Operation Mode according to Voyager spec. V0.9.0-start */
	/* WNC-NMR0000-JOE-PENG-20140521-Modify codes of boa detecting system mode (Gateway/Bridge/Converter/Repeater)-start */
	int mode = 0;
	/* WNC-NMR0000-JOE-PENG-20140521-Modify codes of boa detecting system mode (Gateway/Bridge/Converter/Repeater)-end */
	/* WNC-NMR0000-JOE-PENG-20140109-Implement section 4.2.2 GUI Response Depending on Operation Mode according to Voyager spec. V0.9.0-end */
	apmib_get( MIB_OP_MODE, (void *)&mode);

	/* WNC-NMR0517-JOE-PENG-20131008-Fix bug 517 Gateway and DNS address are 0.0.0.0 during disconnected WAN cable in static IP mode->start */
	if (is_first_time_login == 1) {
		/* Get MIB setting of booting for GUI use */
		struct in_addr temp_address;/* network order */
		char buffer[500]={0};

//WNC-NMR00949-D2R031-HENG-I-CHEN-20151022, fix bug 949 #BEGIN
		apmib_getBoot(MIB_DHCP, (void *)&booting_lan_mode);
//WNC-NMR00949-D2R031-HENG-I-CHEN-20151022, fix bug 949 #END
		apmib_get(MIB_WAN_DHCP, (void *)&booting_wan_mode);

		apmib_get(MIB_WAN_IP_ADDR, (void *)buffer);
		temp_address = *((struct in_addr *)buffer);
		booting_mib_wan_ip = ntohl(temp_address.s_addr);

		apmib_get(MIB_WAN_SUBNET_MASK, (void *)buffer);
		temp_address = *((struct in_addr *)buffer);
		booting_mib_wan_mask = ntohl(temp_address.s_addr);

		apmib_get(MIB_WAN_DEFAULT_GATEWAY, (void *)buffer);
		temp_address = *((struct in_addr *)buffer);
		booting_mib_wan_gateway = ntohl(temp_address.s_addr);

		apmib_get(MIB_DNS1, (void *)buffer);
		temp_address = *((struct in_addr *)buffer);
		booting_mib_wan_dns1 = ntohl(temp_address.s_addr);

		apmib_get(MIB_DNS2, (void *)buffer);
		temp_address = *((struct in_addr *)buffer);
		booting_mib_wan_dns2 = ntohl(temp_address.s_addr);

//WNC-NMR00949-D2R031-HENG-I-CHEN-20151022, fix bug 949 #BEGIN
		apmib_getBoot(MIB_IP_ADDR, (void *)buffer);
//WNC-NMR00949-D2R031-HENG-I-CHEN-20151022, fix bug 949 #END
		temp_address = *((struct in_addr *)buffer);
		booting_mib_lan_ip = ntohl(temp_address.s_addr);

//WNC-NMR00949-D2R031-HENG-I-CHEN-20151022, fix bug 949 #BEGIN
		apmib_getBoot(MIB_SUBNET_MASK, (void *)buffer);
//WNC-NMR00949-D2R031-HENG-I-CHEN-20151022, fix bug 949 #END
		temp_address = *((struct in_addr *)buffer);
		booting_mib_lan_mask = ntohl(temp_address.s_addr);

//WNC-NMR00949-D2R031-HENG-I-CHEN-20151022, fix bug 949 #BEGIN
		apmib_getBoot(MIB_DEFAULT_GATEWAY, (void *)buffer);
//WNC-NMR00949-D2R031-HENG-I-CHEN-20151022, fix bug 949 #END
		temp_address = *((struct in_addr *)buffer);
		booting_mib_lan_gateway = ntohl(temp_address.s_addr);

		is_first_time_login = 0;
	}
	/* WNC-NMR0517-JOE-PENG-20131008-Fix bug 517 Gateway and DNS address are 0.0.0.0 during disconnected WAN cable in static IP mode->end */

#if defined(CONFIG_WNC_NEC_STOK_SESSION_AUTH)
	if (strstr(req->request_uri, "/login_main.html") && strstr(req->request_uri, "stok=")) {
		send_redirect_perm(req, "../login_main.html");
		return 0;
	}

	url_stok_paser(req);
#endif

	/* WNC-NMR0000-JOE-PENG-20140430-Modify 4.2 structure of menu according to Linear Spec-start */
	/* WNC-NMR0000-JOE-PENG-20140521-Modify codes of boa detecting system mode (Gateway/Bridge/Converter/Repeater)-start */
	/* WNC-NMR2097-JOE-PENG-20161121-Fix bug 2097 [Aero] The PageID27 can access in CNV mode-start */
	if(mode == BRIDGE_MODE){ 
		int rptEnabled1_value=0, rptEnabled2_value=0;
		int is_ap_mode=1, is_client_mode=0, is_repeater_mode=0;
		
		apmib_get(MIB_REPEATER_ENABLED1, (void *)&rptEnabled1_value);
		apmib_get(MIB_REPEATER_ENABLED2, (void *)&rptEnabled2_value);
		
		if ((rptEnabled1_value==1) || (rptEnabled2_value==1)) {
			/* WNC-NMR0000-JOE-PENG-20140716-Implemen top page, home page and GUI menu of Linear step 2 (repeater mode)-start */
			/* Detect system is converter mode or repeater mode */
			if (access("/tmp/MODE_RPT", F_OK) == 0) {//repeater mode
				is_ap_mode=0;
				is_client_mode=0;
				is_repeater_mode=1;
			} else if (access("/tmp/MODE_CNV", F_OK) == 0) {//converter mode
				is_ap_mode=0;
				is_client_mode=1;
				is_repeater_mode=0;
			} else {//bridge mode
				is_ap_mode=1;
				is_client_mode=0;
				is_repeater_mode=0;
			}
			/* WNC-NMR0000-JOE-PENG-20140716-Implemen top page, home page and GUI menu of Linear step 2 (repeater mode)-end */
		} else {
			is_ap_mode=1;
			is_client_mode=0;
			is_repeater_mode=0;
		}

		if (is_client_mode==1) {
			/* Converter mode */
			if((strstr(req->request_uri,"wizard.htm")!= NULL) ||
					/* WNC-NMR2097-JOE-PENG-20161121-Fix bug 2097 [Aero] The PageID27 can access in CNV mode-start */
					(strstr(req->request_uri,"air24g_main_pri.html")!= NULL) ||
					(strstr(req->request_uri,"air24g_main_sec.html")!= NULL) ||
					(strstr(req->request_uri,"air5g_main_pri.html")!= NULL) ||
					(strstr(req->request_uri,"air5g_main_sec.html")!= NULL) ||
					(strstr(req->request_uri,"air_basic_main2.html")!= NULL) ||
					(strstr(req->request_uri,"amgr_local_dhcp.html")!= NULL) ||
					(strstr(req->request_uri,"amgr_local_ppp.html")!= NULL) ||
					(strstr(req->request_uri,"basic_main_ap.html")!= NULL) ||
					(strstr(req->request_uri,"basic_main_local.html")!= NULL) ||
					(strstr(req->request_uri,"dhcp_assign_add.html")!= NULL) ||
					(strstr(req->request_uri,"dhcp_assign_main.html")!= NULL) ||
					(strstr(req->request_uri,"help_ap.html")!= NULL) ||
					(strstr(req->request_uri,"help_local.html")!= NULL) ||
					(strstr(req->request_uri,"help_ppp.html")!= NULL) ||
					(strstr(req->request_uri,"index_contents_ap.html")!= NULL) ||
					(strstr(req->request_uri,"index_contents_local.html")!= NULL) ||
					(strstr(req->request_uri,"index_contents_ppp.html")!= NULL) ||
					(strstr(req->request_uri,"info_ap_main.html")!= NULL) ||
					(strstr(req->request_uri,"info_client_main.html")!= NULL) ||
					(strstr(req->request_uri,"info_local_main.html")!= NULL) ||
					(strstr(req->request_uri,"info_ppp_main.html")!= NULL) ||
					(strstr(req->request_uri,"ipfilter_add.html")!= NULL) ||
					(strstr(req->request_uri,"ipfilter_main.html")!= NULL) ||
					(strstr(req->request_uri,"ipnat_add.html")!= NULL) ||
					(strstr(req->request_uri,"ipnat_main.html")!= NULL) ||
					(strstr(req->request_uri,"lan_main.html")!= NULL) ||
					(strstr(req->request_uri,"mac_filter_add.html")!= NULL) ||
					(strstr(req->request_uri,"mac_filter_main.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_brige_mode.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_ipdup.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_mode.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_Mode_info.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_PPPoE.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_reboot.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_wan.html")!= NULL) ||
					(strstr(req->request_uri,"other_main.html")!= NULL) ||
					(strstr(req->request_uri,"ping_main.html")!= NULL) ||
					(strstr(req->request_uri,"ping_result.html")!= NULL) ||
					(strstr(req->request_uri,"wlsch.html")!= NULL) ||
					(strstr(req->request_uri,"wps_main.html")!= NULL) ||
					/* WNC-NMR2097-JOE-PENG-20161121-Fix bug 2097 [Aero] The PageID27 can access in CNV mode-end */
				   (strstr(req->request_uri,"tcpipwan.htm")!= NULL) ||
				   (strstr(req->request_uri,"tcpiplan.htm")!= NULL) ||
				   /* WNC-NMR0000-JOE-PENG-20140716-Implemen LAN setting (section 4.4.39) of Linear step 2 (repeater mode) */
				   (strstr(req->request_uri,"tcpiplan_bridge.htm")!= NULL)||
				   /* WNC-NMR0000-JOE-PENG-20140804-Make user could not access mainte_wlrepeater.htm and mainte_wlrepeater_main.htm (Follow section 4.4.33 and 4.4.34 of Linear Spec. V2.4.0)-start */
				   (strstr(req->request_uri,"mainte_wlrepeater.htm")!= NULL)||
				   (strstr(req->request_uri,"mainte_wlrepeater_main.htm")!= NULL)||
				   /* WNC-NMR0000-JOE-PENG-20140804-Make user could not access mainte_wlrepeater.htm and mainte_wlrepeater_main.htm (Follow section 4.4.33 and 4.4.34 of Linear Spec. V2.4.0)-end */
				   (strstr(req->request_uri,"tcpip_staticdhcp.htm")!= NULL) ||
				   (strstr(req->request_uri,"portfilter.htm")!= NULL) ||
				   (strstr(req->request_uri,"ipfilter.htm")!= NULL) ||
				   (strstr(req->request_uri,"portfw.htm")!= NULL) ||
					/* WNC-NMR0000-JOE-PENG-20131120-Modify for section "4.2 Structure of Menu" of Voyager spec.-start */
				   //(strstr(req->request_uri,"wlprofile.htm")!= NULL) ||
				   //(strstr(req->request_uri,"wlsurvey.htm")!= NULL) ||
					/* WNC-NMR0000-JOE-PENG-20131120-Modify for section "4.2 Structure of Menu" of Voyager spec.-end */
				   (strstr(req->request_uri,"home.htm")!= NULL) ||
				   (strstr(req->request_uri,"home_detail.htm")!= NULL) ||
				   /* WNC-NMR0000-JOE-PENG-20140206-Change homepage page of repeater mode to upload firmware page and hide original home page of repeater mode (Refer to section 4.2.1 and 4.4.21 of Spec. V1.4.0) */
				   (strstr(req->request_uri,"upload_repeater.htm")!= NULL) ||
				   (strstr(req->request_uri,"home_bridge.htm")!= NULL) ||
				   (strstr(req->request_uri,"home_detail_bridge.htm")!= NULL) ||
				   (strstr(req->request_uri,"home_repeater.htm")!= NULL) ||
			/* WNC-NMR2487-JOE-PENG-20170704-Fix bug 2487 [Aero] In /boa/src/ directory, some send_XXXX_XXXX() codes do not add return 0;-start */
				   (strstr(req->request_uri,"home_detail_repeater.htm")!= NULL)) {
						send_r_not_found(req);
						return 0;
			}
			/* WNC-NMR2487-JOE-PENG-20170704-Fix bug 2487 [Aero] In /boa/src/ directory, some send_XXXX_XXXX() codes do not add return 0;-end */
		} else if (is_repeater_mode==1) {
			/* Repeater mode */
			if((strstr(req->request_uri,"wizard.htm")!= NULL) ||
					/* WNC-NMR2097-JOE-PENG-20161121-Fix bug 2097 [Aero] The PageID27 can access in CNV mode-start */
					(strstr(req->request_uri,"air24g_main_pri.html")!= NULL) ||
					(strstr(req->request_uri,"air24g_main_sec.html")!= NULL) ||
					(strstr(req->request_uri,"air5g_main_pri.html")!= NULL) ||
					(strstr(req->request_uri,"air5g_main_sec.html")!= NULL) ||
					(strstr(req->request_uri,"air_basic_main2.html")!= NULL) ||
					(strstr(req->request_uri,"amgr_local_dhcp.html")!= NULL) ||
					(strstr(req->request_uri,"amgr_local_ppp.html")!= NULL) ||
					(strstr(req->request_uri,"basic_main_ap.html")!= NULL) ||
					(strstr(req->request_uri,"basic_main_local.html")!= NULL) ||
					(strstr(req->request_uri,"dhcp_assign_add.html")!= NULL) ||
					(strstr(req->request_uri,"dhcp_assign_main.html")!= NULL) ||
					(strstr(req->request_uri,"help_ap.html")!= NULL) ||
					(strstr(req->request_uri,"help_local.html")!= NULL) ||
					(strstr(req->request_uri,"help_ppp.html")!= NULL) ||
					(strstr(req->request_uri,"index_contents_ap.html")!= NULL) ||
					(strstr(req->request_uri,"index_contents_local.html")!= NULL) ||
					(strstr(req->request_uri,"index_contents_ppp.html")!= NULL) ||
					(strstr(req->request_uri,"info_ap_main.html")!= NULL) ||
					(strstr(req->request_uri,"info_client_main.html")!= NULL) ||
					(strstr(req->request_uri,"info_local_main.html")!= NULL) ||
					(strstr(req->request_uri,"info_ppp_main.html")!= NULL) ||
					(strstr(req->request_uri,"ipfilter_add.html")!= NULL) ||
					(strstr(req->request_uri,"ipfilter_main.html")!= NULL) ||
					(strstr(req->request_uri,"ipnat_add.html")!= NULL) ||
					(strstr(req->request_uri,"ipnat_main.html")!= NULL) ||
					(strstr(req->request_uri,"lan_main.html")!= NULL) ||
					(strstr(req->request_uri,"mac_filter_add.html")!= NULL) ||
					(strstr(req->request_uri,"mac_filter_main.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_brige_mode.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_ipdup.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_mode.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_Mode_info.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_PPPoE.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_reboot.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_wan.html")!= NULL) ||
					(strstr(req->request_uri,"other_main.html")!= NULL) ||
					(strstr(req->request_uri,"ping_main.html")!= NULL) ||
					(strstr(req->request_uri,"ping_result.html")!= NULL) ||
					(strstr(req->request_uri,"wlsch.html")!= NULL) ||
					(strstr(req->request_uri,"wps_main.html")!= NULL) ||
					/* WNC-NMR2097-JOE-PENG-20161121-Fix bug 2097 [Aero] The PageID27 can access in CNV mode-end */
				   (strstr(req->request_uri,"tcpipwan.htm")!= NULL) ||
				   (strstr(req->request_uri,"tcpiplan.htm")!= NULL) ||
				   /* WNC-NMR0000-JOE-PENG-20140716-Implemen LAN setting (section 4.4.39) of Linear step 2 (repeater mode) */
				   (strstr(req->request_uri,"tcpiplan_bridge.htm")!= NULL)||
				   /* WNC-NMR0000-JOE-PENG-20140804-Make user could not access mainte_wlrepeater.htm and mainte_wlrepeater_main.htm (Follow section 4.4.33 and 4.4.34 of Linear Spec. V2.4.0)-start */
				   (strstr(req->request_uri,"mainte_wlrepeater.htm")!= NULL)||
				   (strstr(req->request_uri,"mainte_wlrepeater_main.htm")!= NULL)||
				   /* WNC-NMR0000-JOE-PENG-20140804-Make user could not access mainte_wlrepeater.htm and mainte_wlrepeater_main.htm (Follow section 4.4.33 and 4.4.34 of Linear Spec. V2.4.0)-end */
				   (strstr(req->request_uri,"tcpip_staticdhcp.htm")!= NULL) ||
				   (strstr(req->request_uri,"portfilter.htm")!= NULL) ||
				   (strstr(req->request_uri,"ipfilter.htm")!= NULL) ||
				   (strstr(req->request_uri,"portfw.htm")!= NULL) ||
				   (strstr(req->request_uri,"home.htm")!= NULL) ||
				   (strstr(req->request_uri,"home_detail.htm")!= NULL) ||
				   (strstr(req->request_uri,"home_converter.htm")!= NULL) ||
				   (strstr(req->request_uri,"home_detail_converter.htm")!= NULL) ||
				   (strstr(req->request_uri,"home_bridge.htm")!= NULL) ||
			/* WNC-NMR2487-JOE-PENG-20170704-Fix bug 2487 [Aero] In /boa/src/ directory, some send_XXXX_XXXX() codes do not add return 0;-start */
				   (strstr(req->request_uri,"home_detail_bridge.htm")!= NULL)) {
						send_r_not_found(req);
						return 0;
			}
			/* WNC-NMR2487-JOE-PENG-20170704-Fix bug 2487 [Aero] In /boa/src/ directory, some send_XXXX_XXXX() codes do not add return 0;-end */
		} else {
			/* Bridge mode */
			if((strstr(req->request_uri,"wizard.htm")!= NULL) ||
					/* WNC-NMR2097-JOE-PENG-20161121-Fix bug 2097 [Aero] The PageID27 can access in CNV mode-start */
					(strstr(req->request_uri,"air24g_main.html")!= NULL) ||
					(strstr(req->request_uri,"air5g_main.html")!= NULL) ||
					(strstr(req->request_uri,"amgr_local_dhcp.html")!= NULL) ||
					(strstr(req->request_uri,"amgr_local_ppp.html")!= NULL) ||
					(strstr(req->request_uri,"ap_search.html")!= NULL) ||
					(strstr(req->request_uri,"apsearch_main.html")!= NULL) ||
					(strstr(req->request_uri,"ap_search_setting.html")!= NULL) ||
					(strstr(req->request_uri,"ap_set_failure.html")!= NULL) ||
					(strstr(req->request_uri,"basic_main_local.html")!= NULL) ||
					(strstr(req->request_uri,"basic_main_repeater.html")!= NULL) ||
					(strstr(req->request_uri,"detail_main2.html")!= NULL) ||
					(strstr(req->request_uri,"detail_main.html")!= NULL) ||
					(strstr(req->request_uri,"dhcp_assign_add.html")!= NULL) ||
					(strstr(req->request_uri,"dhcp_assign_main.html")!= NULL) ||
					(strstr(req->request_uri,"help_local.html")!= NULL) ||
					(strstr(req->request_uri,"help_ppp.html")!= NULL) ||
					(strstr(req->request_uri,"help_repeater.html")!= NULL) ||
					(strstr(req->request_uri,"index_contents_local.html")!= NULL) ||
					(strstr(req->request_uri,"index_contents_ppp.html")!= NULL) ||
					(strstr(req->request_uri,"index_contents_repeater.html")!= NULL) ||
					(strstr(req->request_uri,"info_client_main.html")!= NULL) ||
					(strstr(req->request_uri,"info_local_main.html")!= NULL) ||
					(strstr(req->request_uri,"info_ppp_main.html")!= NULL) ||
					(strstr(req->request_uri,"info_repeater_main.html")!= NULL) ||
					(strstr(req->request_uri,"ipfilter_add.html")!= NULL) ||
					(strstr(req->request_uri,"ipfilter_main.html")!= NULL) ||
					(strstr(req->request_uri,"ipnat_add.html")!= NULL) ||
					(strstr(req->request_uri,"ipnat_main.html")!= NULL) ||
					(strstr(req->request_uri,"lan_main.html")!= NULL) ||
					(strstr(req->request_uri,"mac_filter_add_repeater.html")!= NULL) ||
					(strstr(req->request_uri,"mac_filter_main_repeater.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_brige_mode.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_ipdup.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_mode.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_Mode_info.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_PPPoE.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_reboot.html")!= NULL) ||
					(strstr(req->request_uri,"netstartlite_wan.html")!= NULL) ||
					(strstr(req->request_uri,"other_main.html")!= NULL) ||
					(strstr(req->request_uri,"ping_main.html")!= NULL) ||
					(strstr(req->request_uri,"ping_result.html")!= NULL) ||
					/* WNC-NMR2097-JOE-PENG-20161121-Fix bug 2097 [Aero] The PageID27 can access in CNV mode-end */
				   (strstr(req->request_uri,"tcpipwan.htm")!= NULL) ||
				   (strstr(req->request_uri,"tcpiplan.htm")!= NULL) ||
				   /* WNC-NMR0000-JOE-PENG-20140716-Implemen LAN setting (section 4.4.39) of Linear step 2 (repeater mode) */
				   (strstr(req->request_uri,"tcpiplan_repeater.htm")!= NULL)||
				   /* WNC-NMR0000-JOE-PENG-20140804-Make user could not access mainte_wlrepeater.htm and mainte_wlrepeater_main.htm (Follow section 4.4.33 and 4.4.34 of Linear Spec. V2.4.0)-start */
				   (strstr(req->request_uri,"mainte_wlrepeater.htm")!= NULL)||
				   (strstr(req->request_uri,"mainte_wlrepeater_main.htm")!= NULL)||
				   /* WNC-NMR0000-JOE-PENG-20140804-Make user could not access mainte_wlrepeater.htm and mainte_wlrepeater_main.htm (Follow section 4.4.33 and 4.4.34 of Linear Spec. V2.4.0)-end */
				   (strstr(req->request_uri,"tcpip_staticdhcp.htm")!= NULL) ||
				   (strstr(req->request_uri,"portfilter.htm")!= NULL) ||
				   (strstr(req->request_uri,"ipfilter.htm")!= NULL) ||
				   (strstr(req->request_uri,"portfw.htm")!= NULL) ||
					/* WNC-NMR0000-JOE-PENG-20131120-Modify for section "4.2 Structure of Menu" of Voyager spec.-start */
				   //(strstr(req->request_uri,"wlprofile.htm")!= NULL) ||
				   //(strstr(req->request_uri,"wlsurvey.htm")!= NULL) ||
					/* WNC-NMR0000-JOE-PENG-20131120-Modify for section "4.2 Structure of Menu" of Voyager spec.-end */
				   (strstr(req->request_uri,"home.htm")!= NULL) ||
				   (strstr(req->request_uri,"home_detail.htm")!= NULL) ||
				   /* WNC-NMR0000-JOE-PENG-20140206-Change homepage page of repeater mode to upload firmware page and hide original home page of repeater mode (Refer to section 4.2.1 and 4.4.21 of Spec. V1.4.0) */
				   (strstr(req->request_uri,"upload_repeater.htm")!= NULL) ||
				   (strstr(req->request_uri,"home_converter.htm")!= NULL) ||
				   (strstr(req->request_uri,"home_detail_converter.htm")!= NULL) ||
				   (strstr(req->request_uri,"home_repeater.htm")!= NULL) ||
			/* WNC-NMR2487-JOE-PENG-20170704-Fix bug 2487 [Aero] In /boa/src/ directory, some send_XXXX_XXXX() codes do not add return 0;-start */
				   (strstr(req->request_uri,"home_detail_repeater.htm")!= NULL)) {
						send_r_not_found(req);
						return 0;
			}
			/* WNC-NMR2487-JOE-PENG-20170704-Fix bug 2487 [Aero] In /boa/src/ directory, some send_XXXX_XXXX() codes do not add return 0;-end */
		}
	}
	else if(mode == GATEWAY_MODE){
console_printf("%s %d    [%s]\n", __func__, __LINE__,req->request_uri);//DEB_NEC
		/* router mode */
		if((strstr(req->request_uri,"tcpiplan_bridge.htm")!= NULL) ||
				/* WNC-NMR2097-JOE-PENG-20161121-Fix bug 2097 [Aero] The PageID27 can access in CNV mode-start */
				(strstr(req->request_uri,"air24g_main.html")!= NULL)||
				(strstr(req->request_uri,"air5g_main.html")!= NULL)||
				(strstr(req->request_uri,"ap_search.html")!= NULL)||
				(strstr(req->request_uri,"apsearch_main.html")!= NULL)||
				(strstr(req->request_uri,"ap_search_setting.html")!= NULL)||
				(strstr(req->request_uri,"ap_set_failure.html")!= NULL)||
				(strstr(req->request_uri,"basic_main_ap.html")!= NULL)||
				(strstr(req->request_uri,"basic_main_repeater.html")!= NULL)||
				(strstr(req->request_uri,"detail_main2.html")!= NULL)||
				(strstr(req->request_uri,"detail_main.html")!= NULL)||
				(strstr(req->request_uri,"help_ap.html")!= NULL)||
				(strstr(req->request_uri,"help_repeater.html")!= NULL)||
				(strstr(req->request_uri,"index_contents_ap.html")!= NULL)||
				(strstr(req->request_uri,"index_contents_repeater.html")!= NULL)||
				(strstr(req->request_uri,"info_ap_main.html")!= NULL)||
				(strstr(req->request_uri,"info_repeater_main.html")!= NULL)||
				(strstr(req->request_uri,"mac_filter_add_repeater.html")!= NULL)||
				(strstr(req->request_uri,"mac_filter_main_repeater.html")!= NULL)||
				/* WNC-NMR2097-JOE-PENG-20161121-Fix bug 2097 [Aero] The PageID27 can access in CNV mode-end */
			    /* WNC-NMR0000-JOE-PENG-20140716-Implemen LAN setting (section 4.4.39) of Linear step 2 (repeater mode) */
			    (strstr(req->request_uri,"tcpiplan_repeater.htm")!= NULL)||
			    /* WNC-NMR0000-JOE-PENG-20140804-Make user could not access mainte_wlrepeater.htm and mainte_wlrepeater_main.htm (Follow section 4.4.33 and 4.4.34 of Linear Spec. V2.4.0)-start */
			    (strstr(req->request_uri,"mainte_wlrepeater.htm")!= NULL)||
			    (strstr(req->request_uri,"mainte_wlrepeater_main.htm")!= NULL)||
			    /* WNC-NMR0000-JOE-PENG-20140804-Make user could not access mainte_wlrepeater.htm and mainte_wlrepeater_main.htm (Follow section 4.4.33 and 4.4.34 of Linear Spec. V2.4.0)-end */
			    (strstr(req->request_uri,"home_converter.htm")!= NULL)||
			    (strstr(req->request_uri,"home_detail_converter.htm")!= NULL)||
			    (strstr(req->request_uri,"home_bridge.htm")!= NULL)||
			    (strstr(req->request_uri,"home_detail_bridge.htm")!= NULL)||
			    /* WNC-NMR0000-JOE-PENG-20140206-Change homepage page of repeater mode to upload firmware page and hide original home page of repeater mode (Refer to section 4.2.1 and 4.4.21 of Spec. V1.4.0) */
			    (strstr(req->request_uri,"upload_repeater.htm")!= NULL)||
			    (strstr(req->request_uri,"home_repeater.htm")!= NULL)||
		/* WNC-NMR2487-JOE-PENG-20170704-Fix bug 2487 [Aero] In /boa/src/ directory, some send_XXXX_XXXX() codes do not add return 0;-start */
				(strstr(req->request_uri,"home_detail_repeater.htm")!= NULL)) {
					send_r_not_found(req);
					return 0;
		}
		/* WNC-NMR2487-JOE-PENG-20170704-Fix bug 2487 [Aero] In /boa/src/ directory, some send_XXXX_XXXX() codes do not add return 0;-end */
	}
	/* WNC-NMR2097-JOE-PENG-20161121-Fix bug 2097 [Aero] The PageID27 can access in CNV mode-end */
	/* WNC-NMR0000-JOE-PENG-20140521-Modify codes of boa detecting system mode (Gateway/Bridge/Converter/Repeater)-end */
	/* WNC-NMR0000-JOE-PENG-20140430-Modify 4.2 structure of menu according to Linear Spec-end */
	/* WNC-NMR0000-Rita-20130226-V1.2.0_Sonic_SpecChangeRequest_3.2.3-End */
    if (!req->logline) {
        log_error_doc(req);
        fputs("No logline in process_header_end\n", stderr);
        send_r_error(req);
        return 0;
    }

    /* Percent-decode request */
    if (unescape_uri(req->request_uri, &(req->query_string)) == 0) {
        log_error_doc(req);
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch for NMR158
		DEBUG(DEBUG_BOA) {
        fputs("URI contains bogus characters\n", stderr);
		}
//WNC-JDR230-YUAN-I-CHOU, Apply Realtek Patch for NMR158 End
        send_r_bad_request(req);
        return 0;
    }

    /* clean pathname */
    clean_pathname(req->request_uri);

    if (req->request_uri[0] != '/') {
        log_error("URI does not begin with '/'\n");
        send_r_bad_request(req);
        return 0;
    }

    if (vhost_root) {
        char *c;
        if (!req->header_host) {
            req->host = strdup(default_vhost);
        } else {
            req->host = strdup(req->header_host);
        }
        if (!req->host) {
            log_error_doc(req);
            fputs("unable to strdup default_vhost/req->header_host\n", stderr);
            send_r_error(req);
            return 0;
        }
        strlower(req->host);
        /* check for port, and remove
         * we essentially ignore the port, because we cannot
         * as yet report a different port than the one we are
         * listening on
         */
        c = strchr(req->host, ':');
        if (c)
            *c = '\0';

        if (check_host(req->host) < 1) {
            log_error_doc(req);
            fputs("host invalid!\n", stderr);
            send_r_bad_request(req);
            return 0;
        }
    }

	/* WNC-NMR0000-JOE-PENG-20120713-Implement NEC spec. request CheeperSW:0703(Deny HTTP request(GET or POST) when device is in ready to initialization state.) */
	{
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140320, Replace HW_DEFAULT_STATE to DEFAULT_STATE
		int default_state=0; //WNC-NMR0000-Rita-20130306-Error_508-fix warnings of cppcheck (uninitialized value).

		/* In normal state, MIB_DEFAULT_STATE is 0. */
		/* In ready to initialization state, MIB_DEFAULT_STATE is 1. */
		apmib_get(MIB_DEFAULT_STATE, (void *)&default_state);

		if (default_state == 1) {
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140320, Replace HW_DEFAULT_STATE to DEFAULT_STATE End
			/* In ready to initialization state. */

			if((strstr(req->request_uri,"503.htm")==NULL) &&
				/* NMR0000-20160323-Fine tune codes related to GUI error page-start */
				(strstr(req->request_uri,"cgi_html_903.html")==NULL) &&
				(strstr(req->request_uri,".png")==NULL) &&
				/* NMR0000-20160323-Fine tune codes related to GUI error page-end */
				(strstr(req->request_uri,".css")==NULL) &&
				(strstr(req->request_uri,".js")==NULL) &&
				(strstr(req->request_uri,".gif")==NULL)){ 
					send_r_service_unavailable(req);
					return 0;
				}
		}
	}
	/* WNC-NMR0000-JOE-PENG-20120713-end */

/* WNC-MR1527-Heng-I-Chen-20120402-Check Host and redirect */
/* NMR0000-20160726-Implement responsive GUI page of Aero model-start */
#if 1
	if (req->header_host) {
		int netchk=0;//WNC-NMR0000-Rita-20130310-Error_524-fix warnings of cppcheck (uninitialized value).
		int opmode=0;//WNC-NMR0000-Rita-20130310-Error_523-fix warnings of cppcheck (uninitialized value).
		
		struct in_addr curIP;
		char *strtmp=NULL;

		apmib_get(MIB_OP_MODE, (void *)&opmode);
		apmib_get(MIB_NETCHK, (void *)&netchk);
		if (opmode == GATEWAY_MODE && netchk) {
//			apmib_get(MIB_IP_ADDR, (void *)&curIP);
/* WNC-MR0000-Heng-I-Chen-20120503-Internet Reachability Check uses saved netbiosname */
//			char nbname[17]={0};//WNC-NMR0000-Rita-20130310-Error_531-fix warnings of cppcheck (uninitialized value).
/* WNC-MR0000-Heng-I-Chen-20120503-End*/

/* WNC-MR0000-Heng-I-Chen-20120503-Internet Reachability Check uses saved netbiosname */
//			apmib_get( MIB_NETBIOS_NAME, (void *)&nbname);
/* WNC-MR0000-Heng-I-Chen-20120503-End */
// WNC-NMR0435-HENG-I-CHEN-20120503: Fix Bug 435
			char *host_str = strdup(req->header_host);
			char *cp = NULL;

			
			if (cp = strchr(host_str, ':')) {
				*cp = 0;
			}
// WNC-NMR0435-HENG-I-CHEN-20120503: End
			
			if (getInAddr("br0", IP_ADDR, &curIP) != 0)
				strtmp = inet_ntoa(curIP);
			//fprintf(stderr, "%s %d: host: %s current IP : %s\n", __FILE__, __LINE__, req->header_host, strtmp?strtmp:"None");

// WNC-NMR0435-HENG-I-CHEN-20120503: Fix Bug 435
//			if (strcasecmp(req->header_host, "aterm.me") && (!strtmp || strcasecmp(req->header_host, strtmp)) && strcasecmp(req->header_host, nbname)) {
			if (strcasecmp(host_str, "aterm.me") && (!strtmp || strcasecmp(host_str, strtmp)) && strcasecmp(host_str, nbname)) {
// WNC-NMR0435-HENG-I-CHEN-20120503: End
				char redircturl[256];
				
				//fprintf(stderr, "%s %d: run redirect\n", __FILE__, __LINE__);
				strlcpy(redircturl, "http://aterm.me/login_raku.html", sizeof(redircturl));

#if 0
				strlcpy(redircturl, "http://aterm.me", sizeof(redircturl));
				
				if (getWanLink("eth1") < 0) {
					strcat(redircturl, "/netstartlite_wan.html");
					system ("echo linkdown > /var/internetSts");
				} else if((isFileExist("/var/ip_conflict") == 1) && (isFileExist("/var/lan_ip_changed") == 0)){
					strcat(redircturl, "/netstartlite_ipdup.html");
					system ("echo ipconflict > /var/internetSts");
				} else {
					int dns_ret = dnschk();
					//fprintf(stderr, "%s %d: dnschk return %d\n", __FILE__, __LINE__, dns_ret);
					if (dns_ret == 0) {
/* WNC-NMR0000-Heng-I-Chen-20130125-add wan private IP check */
						if (privateIPcheck("eth1")) {
							strcat(redircturl, "/netstartlite_brige_mode.html");
							system ("echo privatewanip > /var/internetSts");
						} else {
							strcat(redircturl, "/netstartlite_Mode_info.html");
							system ("echo ready > /var/internetSts");
						}
/* WNC-NMR0000-Heng-I-Chen-20130125-End */
						netchk=0;
						apmib_set(MIB_NETCHK, (void*)&netchk);
						apmib_update(CURRENT_SETTING);	// update to flash
					} else {
/* WNC-NMR0000-Heng-I-Chen-20130205-use independent pppoe_discovery utility */
						struct stat filestat;
						system("pppoe_discovery eth1 3 1");
						if (stat("/tmp/recv_pado", &filestat) == 0) {
							/* PPPoE eerver sxists */
							strcat(redircturl, "/netstartlite_PPPoE.html");
							system ("echo pppoedetected > /var/internetSts");
						} else {
							/* No PPPoE server */
							strcat(redircturl, "/netstartlite_mode.html");
							system ("echo notset > /var/internetSts");
						}
/* WNC-NMR0000-Heng-I-Chen-20130205-End */
					}
				}	
#endif

				send_r_moved_temp(req, redircturl, "");
			//	free(cp);	/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1512- RESOURCE_LEAK */
				free(host_str);	/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1513- RESOURCE_LEAK */
				//fprintf(stderr, "%s %d: run redirect to %s\n", __FILE__, __LINE__, redircturl);
				return 0;
			}
		//	free(cp);	/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1516,1517- RESOURCE_LEAK */
			free(host_str);	/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1514,1515- RESOURCE_LEAK */
		}
	}
#else
	if (req->header_host) {
		int netchk=0;//WNC-NMR0000-Rita-20130310-Error_524-fix warnings of cppcheck (uninitialized value).
		int opmode=0;//WNC-NMR0000-Rita-20130310-Error_523-fix warnings of cppcheck (uninitialized value).
		
		struct in_addr curIP;
		char *strtmp=NULL;

		apmib_get(MIB_OP_MODE, (void *)&opmode);
		apmib_get(MIB_NETCHK, (void *)&netchk);
		if (opmode == GATEWAY_MODE && netchk) {
//			apmib_get(MIB_IP_ADDR, (void *)&curIP);
/* WNC-MR0000-Heng-I-Chen-20120503-Internet Reachability Check uses saved netbiosname */
//			char nbname[17]={0};//WNC-NMR0000-Rita-20130310-Error_531-fix warnings of cppcheck (uninitialized value).
/* WNC-MR0000-Heng-I-Chen-20120503-End*/

/* WNC-MR0000-Heng-I-Chen-20120503-Internet Reachability Check uses saved netbiosname */
//			apmib_get( MIB_NETBIOS_NAME, (void *)&nbname);
/* WNC-MR0000-Heng-I-Chen-20120503-End */
// WNC-NMR0435-HENG-I-CHEN-20120503: Fix Bug 435
			char *host_str = strdup(req->header_host);
			char *cp = NULL;

			
			if (cp = strchr(host_str, ':')) {
				*cp = 0;
			}
// WNC-NMR0435-HENG-I-CHEN-20120503: End
			
			if (getInAddr("br0", IP_ADDR, &curIP) != 0)
				strtmp = inet_ntoa(curIP);
			//fprintf(stderr, "%s %d: host: %s current IP : %s\n", __FILE__, __LINE__, req->header_host, strtmp?strtmp:"None");

// WNC-NMR0435-HENG-I-CHEN-20120503: Fix Bug 435
//			if (strcasecmp(req->header_host, "aterm.me") && (!strtmp || strcasecmp(req->header_host, strtmp)) && strcasecmp(req->header_host, nbname)) {
			if (strcasecmp(host_str, "aterm.me") && (!strtmp || strcasecmp(host_str, strtmp)) && strcasecmp(host_str, nbname)) {
// WNC-NMR0435-HENG-I-CHEN-20120503: End
				char redircturl[256];
				
				//fprintf(stderr, "%s %d: run redirect\n", __FILE__, __LINE__);
				strlcpy(redircturl, "http://aterm.me/home.htm", sizeof(redircturl));
				
				if (getWanLink("eth1") < 0) {
					strcat(redircturl, "?internet=linkdown");
					system ("echo linkdown > /var/internetSts");
				} else {
					int dns_ret = dnschk();
					//fprintf(stderr, "%s %d: dnschk return %d\n", __FILE__, __LINE__, dns_ret);
					if (dns_ret == 0) {
/* WNC-NMR0000-Heng-I-Chen-20130125-add wan private IP check */
						if (privateIPcheck("eth1")) {
							strcat(redircturl, "?internet=privatewanip");
							system ("echo privatewanip > /var/internetSts");
						} else {
							strcat(redircturl, "?internet=ready");
							system ("echo ready > /var/internetSts");
						}
/* WNC-NMR0000-Heng-I-Chen-20130125-End */
						netchk=0;
						apmib_set(MIB_NETCHK, (void*)&netchk);
						apmib_update(CURRENT_SETTING);	// update to flash
					} else {
/* WNC-NMR0000-Heng-I-Chen-20130205-use independent pppoe_discovery utility */
						struct stat filestat;
						system("pppoe_discovery eth1 3 1");
						if (stat("/tmp/recv_pado", &filestat) == 0) {
							/* PPPoE eerver sxists */
							strcat(redircturl, "?internet=pppoedetected");
							system ("echo pppoedetected > /var/internetSts");
						} else {
							/* No PPPoE server */
							strcat(redircturl, "?internet=notset");
							system ("echo notset > /var/internetSts");
						}
/* WNC-NMR0000-Heng-I-Chen-20130205-End */
					}
				}	

				send_r_moved_temp(req, redircturl, "");
			//	free(cp);	/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1512- RESOURCE_LEAK */
				free(host_str);	/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1513- RESOURCE_LEAK */
				//fprintf(stderr, "%s %d: run redirect to %s\n", __FILE__, __LINE__, redircturl);
				return 0;
			}
		//	free(cp);	/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1516,1517- RESOURCE_LEAK */
			free(host_str);	/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1514,1515- RESOURCE_LEAK */
		}
	}
#endif
/* NMR0000-20160726-Implement responsive GUI page of Aero model-end */

/* NMR0000-20160726-Implement responsive GUI page of Aero model-start */
	if (req->request_uri) {
		/* NMR0000-20160729-Fix bug that browser show not show Internet Reachability pages if user access http://192.168.10.1 and Internet reachability is enabled.-start */
		if ((strncmp(req->request_uri, "/index_contents.html", sizeof("/index_contents.html")) == 0) || 
			(strncmp(req->request_uri, "/", sizeof("/")) == 0)) {
		/* NMR0000-20160729-Fix bug that browser show not show Internet Reachability pages if user access http://192.168.10.1 and Internet reachability is enabled.-end */
			int netchk = 0;
	
			apmib_get(MIB_NETCHK, (void *)&netchk);
				
			if (netchk) {
				if (getWanLink("eth1") < 0) {
					/* linkdown */
					send_r_moved_temp(req, "/netstartlite_wan.html", "");
					return 0;
				} else if((isFileExist("/var/ip_conflict") == 1) && (isFileExist("/var/lan_ip_changed") == 0)){
					/* ipconflict */				
					send_r_moved_temp(req, "/netstartlite_ipdup.html", "");					
					return 0;
				} else {
					int dns_ret;

					dns_ret = dnschk();
					if (dns_ret == 0) {
						netchk=0;
						apmib_set(MIB_NETCHK, (void*)&netchk);
						apmib_update(CURRENT_SETTING);	// update to flash
						/* wan private IP check */
						if (privateIPcheck("eth1")) {
							/* privatewanip */						
							send_r_moved_temp(req, "/netstartlite_brige_mode.html", "");
							return 0;
						} else {
							/* ready */				
							send_r_moved_temp(req, "/netstartlite_Mode_info.html", "");
							return 0;
						}
					} else {
						/* Use independent pppoe_discovery utility */
						struct stat filestat;
						system("pppoe_discovery eth1 3 1");
						if (stat("/tmp/recv_pado", &filestat) == 0) {
							/* PPPoE server exists */
							/* pppoedetected */
							send_r_moved_temp(req, "/netstartlite_PPPoE.html", "");
							return 0;
						} else {
							/* No PPPoE eerver */
							/* notset */								
							send_r_moved_temp(req, "/netstartlite_mode.html", "");
							return 0;
						}
					}
				}
			}
		} else if (strncmp(req->request_uri, "/index_contents_skip.html", sizeof("/index_contents_skip.html")) == 0) {
			int netchk = 0;

			/* Disable Internet Reachability */
			apmib_set(MIB_NETCHK, (void*)&netchk);
			apmib_update(CURRENT_SETTING);	// update to flash

			/* Redirect to home page */
			send_r_moved_temp(req, "/index_contents.html", "");
			return 0;
		}
	}
/* NMR0000-20160726-Implement responsive GUI page of Aero model-end */

#ifdef CONFIG_APP_ACCESSTIMER
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Access Timer Guard #BEGIN	
	if (req->request_uri) {
// WNC-NMR0000-D2R031-HENG-I-CHEN-2016-03-16: 4.4.47.3 #BEGIN	
		if (strncmp(req->request_uri, "/action/", strlen("/action/")) == 0) {
			if (strcmp(req->request_uri+strlen("/action/"), get_action_code()) == 0) {
				aterm_server_conf_update = file_get_modified_time(ATREM_SERVER_CONF_FILENAME);
				get_server_setting_times = 1;
				system("aim_immediate.sh");
				send_r_moved_temp(req, "../server_setting.html", "");
				return 0;
			} else {
				send_redirect_perm(req, "../cgi_html_404.html");
				return 0;
			}
		}
		if (strncmp(req->request_uri, "/xxx.html", strlen("/xxx.html")+1) == 0) {
			time_t new = file_get_modified_time(ATREM_SERVER_CONF_FILENAME);
			if (new > 0 && new != aterm_server_conf_update) {
				send_r_moved_temp(req, "/server_setting_finish.html", "");
				return 0;
			} else if (get_server_setting_times < 10) {
				get_server_setting_times++;
				send_r_moved_temp(req, "/server_setting.html", "");
				return 0;
			} else {
				send_r_moved_temp(req, "/server_setting_failure.html", "");
				return 0;
			}
		}

// WNC-NMR0000-D2R031-HENG-I-CHEN-2016-03-16: 4.4.47.3 #END

//WNC-D2R230-YUAN-I-CHOU-20171003, Firmware upgrade modification.
//Cancel LED light off setting when user click OK on GUI
	if ((strncmp(req->request_uri, "/boafrm/formUpload", sizeof("/boafrm/formUpload")) == 0) ||
		(strncmp(req->request_uri, "/boafrm/formOnlineVersionUp", sizeof("/boafrm/formOnlineVersionUp")) == 0)){
		system("echo CLOS > /proc/ledgpio");
	}

// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
		if (strncmp(req->request_uri, "/boafrm/formAccesstimerGoto", sizeof("/boafrm/formAccesstimerGoto")) == 0) {
			goto login_bypass;
		}

		if (accesstimer_guardmsg != 0) {
			if (strncmp(req->request_uri, "/kodomo_guard.html", sizeof("/kodomo_guard.html")) == 0) {
				goto login_bypass;
			}
		} else {
			if ((strncmp(req->request_uri, "/miete_anshin_net.html", sizeof("/miete_anshin_net.html")) == 0) ||
				(strncmp(req->request_uri, "/miete_anshin_setting.html", sizeof("/miete_anshin_setting.html")) == 0) ||
				(strncmp(req->request_uri, "/kodomo_schedule.html", sizeof("/kodomo_schedule.html")) == 0)||
				(strncmp(req->request_uri, "/kodomo_temporary.html", sizeof("/kodomo_temporary.html")) == 0) ||
	// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
				((strncmp(req->request_uri, "/boafrm/", 8) == 0) && ( 
				(strncmp(req->request_uri+8, "formAccesstimerSet", sizeof("formAccesstimerSet")) == 0) ||
				(strncmp(req->request_uri+8, "formAccesstimerStaSet", sizeof("formAccesstimerStaSet")) == 0) ||
				(strncmp(req->request_uri+8, "formAccesstimerStaReg", sizeof("formAccesstimerStaReg")) == 0) ||
				(strncmp(req->request_uri+8, "formAccessstimerSchedulerSet", sizeof("formAccessstimerSchedulerSet")) == 0) ||
				(strncmp(req->request_uri+8, "formAccessstimerTemporarySet", sizeof("formAccessstimerTemporarySet")) == 0) ||
				(strncmp(req->request_uri+8, "formAccesstimerStaSetCategory", sizeof("formAccesstimerStaSetCategory")) == 0) ||
				(strncmp(req->request_uri+8, "formAccesstimerGoto", sizeof("formAccesstimerGoto")) == 0)))) { 

				if (req->remote_ip_addr) {
					char macStr[40];
					unsigned char mac[6];
					get_mac_from_IP(macStr, req->remote_ip_addr);
					if(macStrToBin(mac, macStr)==0) {
						//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140916, Fix bug 2691, 2695 (UNINIT) in StaticCodeCheck_Linear_Delta1.xls
						//int i, entryNum;
						
						int i, entryNum = 0;
						ACCESS_TIMER_T entry;
						INIQUITOUS_STA_T entry2;

	//WNC-NMR00983/NMR00984-D2R031-HENG-I-CHEN-20151008, fix bug 983/984 #BEGIN					
						char *wiface[4] = {"wlan0", "wlan0-va0", "wlan1", "wlan1-va0"};
						char a4StaMacStr[32];
						char line_buf[32];
						int found = 0;

						snprintf(a4StaMacStr, sizeof(a4StaMacStr), "    STA_MAC: %02hhx%02hhx%02hhx%02hhx%02hhx%02hhx\n",
							mac[0], mac[1], mac[2], mac[3], mac[4], mac[5] );

						for (i=0;i<4;i++)
						{
							char proc_path[32];

							snprintf(proc_path, sizeof(proc_path), "/proc/%s/a4_sta_info", wiface[i]);

							FILE *a4_info_fp = fopen(proc_path, "r");
							if (a4_info_fp) {
								while (fgets(line_buf, 32, a4_info_fp)) {
									if (strcmp(line_buf, a4StaMacStr) == 0) {
										if(fgets(line_buf, 32, a4_info_fp)) {
											sscanf(line_buf, "    OWNER_MAC: %02hhx%02hhx%02hhx%02hhx%02hhx%02hhx\n",
												mac, mac+1, mac+2, mac+3, mac+4, mac+5);
											found = 1;
											break;
										}
									}
								}
								fclose(a4_info_fp);
							}
							if (found)
								break;
						}

						i = 0;
	//WNC-NMR00983/NMR00984-D2R031-HENG-I-CHEN-20151008, fix bug 983/984 #END

						if ( apmib_get(MIB_ACCESS_TIMER_TBL_NUM, (void *)&entryNum)) {
							for (i=1;i<=entryNum;i++) {
								*((char *)&entry) = (char)i;
								apmib_get(MIB_ACCESS_TIMER_TBL, (void *)&entry);
								if (memcmp(entry.macAddr, mac,6) == 0) {
									if (entry.category == 1) {
										accesstimer_guardmsg = 1;
	// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
//										if (strncmp(req->request_uri,  MWF_PORTAL_PAGE, sizeof(MWF_PORTAL_PAGE)) != 0) {
											send_r_moved_temp(req, MWF_GUARD_PAGE, "");
											return 0;
//										}
	// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
									}
									break;
								}
							}
						}
						if ( apmib_get(MIB_INIQUITOUS_STA_TBL_NUM, (void *)&entryNum)) {
							for (i=1;i<=entryNum;i++) {
								*((char *)&entry2) = (char)i;
								apmib_get(MIB_INIQUITOUS_STA_TBL, (void *)&entry2);
								if (memcmp(entry2.macAddr, mac,6) == 0) {
									accesstimer_guardmsg = 2;
	//								if (strncmp(req->request_uri,  MWF_PORTAL_PAGE, sizeof(MWF_PORTAL_PAGE)) != 0) {
										send_r_moved_temp(req, MWF_GUARD_PAGE, "");
										return 0;
	//								}
									break;
								}
							}
						}
					}
				}
			}

//			console_printf("%s %d accesstimer_guardmsg == %d, req->request_uri %s\n", __func__, __LINE__, accesstimer_guardmsg, req->request_uri);
			if (accesstimer_guardmsg == 0 &&
	// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
				((strncmp(req->request_uri, "/miete_anshin_setting.html", sizeof("/miete_anshin_setting.html")) == 0) ||
				(strncmp(req->request_uri, "/kodomo_schedule.html", sizeof("/kodomo_schedule.html")) == 0)||
				(strncmp(req->request_uri, "/kodomo_temporary.html", sizeof("/kodomo_temporary.html")) == 0))) {
	// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END

				if (req->header_referer == NULL) {
					accesstimer_guardmsg = 4;
	// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
					if (strncmp(req->request_uri,  MWF_PORTAL_PAGE, sizeof(MWF_PORTAL_PAGE)) != 0) {
						send_r_moved_temp(req, MWF_PORTAL_PAGE, "");
						return 0;
					}
	// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
				}
			}
		}
	}
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Access Timer Guard #END	
#endif	//#ifdef CONFIG_APP_ACCESSTIMER
	
/* WNC-MR1527-Heng-I-Chen-20120330-End */


// davidhsu ----------------
#ifdef USE_AUTH
{
#ifdef WEB_ONLY_ONE_CLIENT
	int idx=-1;						
#endif
// WNC-MRXXXX-Yuan-I-Chou-20120524- Remove Super user
//#ifdef SUPER_NAME_SUPPORT
//	char super_name[MAX_NAME_LEN], super_password[PASSWORD_SIZE];
//#endif
	char user_name[MAX_NAME_LEN]={0}, user_password[PASSWORD_SIZE]={0};//WNC-NMR0000-Rita-20130310-Error_567,Error_568-fix warnings of cppcheck (uninitialized value).
	int bypass=1;	/* WNC-MR0000-Libera-20120308-bypass for NEC authentication false page */
	/* NMR1746-20160902-Fix bug 1746 [Aero] The strange page will indicate after input the host name-start */
	//char host_name[MAX_NAME_LEN]={0};
	char host_name[MAX_NAME_LEN_65]={0};
	/* NMR1746-20160902-Fix bug 1746 [Aero] The strange page will indicate after input the host name-end */
#ifdef SUPER_NAME_SUPPORT
	//apmib_get(MIB_SUPER_NAME, super_name);
	//apmib_get(MIB_SUPER_PASSWORD, super_password);
	//if( !strcmp(super_name, "") && !strcmp(super_password, ""))//no super user,login without check
	//{
	//	req->auth_flag = NO_LOGIN;
	//	check_auth_flag = 1;
	//}
#endif

#if 1	/* WNC-MR0000-Libera-20120308-bypass for NEC authentication false page */		
		if (req && req->request_uri) {
			if((strstr(req->request_uri,"401.htm")==NULL) &&
				(strstr(req->request_uri,"403.8.htm")==NULL) && //WNC-NMR0000-Rita-20130227-V1.2.0_Sonic_SpecChangeRequest_3.4.1.-Login lock page bypass.
			    (strstr(req->request_uri,".css")==NULL) &&
			    (strstr(req->request_uri,".js")==NULL) &&
			    (strstr(req->request_uri,".gif")==NULL) &&
			    (strstr(req->request_uri,".ico")==NULL) &&
// WNC-NMR0735-JDR231-HENG-I-CHEN-2014-08-27: Bypass authentication when request png files #BEGIN
			    (strstr(req->request_uri,".png")==NULL) &&
// WNC-NMR0735-JDR231-HENG-I-CHEN-2014-08-27: Bypass authentication when request png files #END
			    (strstr(req->request_uri,"countDownPage_PW.htm")==NULL) &&
			    (strstr(req->request_uri,"countDownPage.htm")==NULL) &&
			    (strstr(req->request_uri,"countDownPage_REINIT.htm")==NULL)
			  ){ 
			  	bypass=0;
			   }
			if(bypass){
				goto login_bypass;
			}
		}
#endif	/* WNC-MR0000-Libera-20120308-END*/

	apmib_get(MIB_USER_NAME, user_name);
	apmib_get(MIB_USER_PASSWORD, user_password);
#if 1

//	if (strcmp(user_name, "") || strcmp(user_password, "")) {
	req->auth_flag = get_auth_status(req, 1);

	if (req->auth_flag > 0 && req->header_referer == NULL) {
		req->auth_flag = 0;
	}

	if (req->auth_flag < 0) {
		if (req->header_referer == NULL) {
			console_printf("%s %d request: %s\n", __func__, __LINE__, (req && req->request_uri)?req->request_uri:"<NULL>");
			strncpy(latest_request, (req && req->request_uri)?req->request_uri:"/", 255);
			accesstimer_guardmsg = 0;
			/* WNC-NMR2197-JOE-PENG-20161220-Fix bug 2197 [Aero] After 15 minutes past during the DLG-070LPB-01 indicated, the browser will no response */
			send_redirect_perm(req, "/login_main.html");
			/* NMR1699-20170531-Fix bug 1699 [Spider] Sometimes the strange text will indicate after session timeout on Aero model-start */
			return 0;
			/* NMR1699-20170531-Fix bug 1699 [Spider] Sometimes the strange text will indicate after session timeout on Aero model-end */
		} else {
#ifdef CONFIG_APP_ACCESSTIMER
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Access Timer Guard #BEGIN	
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
			if ((strncmp(req->request_uri, "/miete_anshin_net.html", sizeof("/miete_anshin_net.html")) == 0) ||
				(strncmp(req->request_uri, "/miete_anshin_setting.html", sizeof("/miete_anshin_setting.html")) == 0) ||
				(strncmp(req->request_uri, "/kodomo_schedule.html", sizeof("/kodomo_schedule.html")) == 0)||
				(strncmp(req->request_uri, "/kodomo_temporary.html", sizeof("/kodomo_temporary.html")) == 0) ||
				(strncmp(req->request_uri, "/kodomo_reboot.html", sizeof("/kodomo_reboot.html")) == 0)||
				(strncmp(req->request_uri, "/kodomo_frame.html", sizeof("/kodomo_frame.html")) == 0) ||
				(strncmp(req->request_uri, "/kodomo_guard.html", sizeof("/kodomo_guard.html")) == 0) ||
				(strncmp(req->request_uri, "/set_device_time.html", sizeof("/set_device_time.html")) == 0 ) ||
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
				((strncmp(req->request_uri, "/boafrm/", 8) == 0) && ( 
				(strncmp(req->request_uri+8, "formAccesstimerSet", sizeof("formAccesstimerSet")) == 0) ||
				(strncmp(req->request_uri+8, "formAccesstimerStaSet", sizeof("formAccesstimerStaSet")) == 0) ||
				(strncmp(req->request_uri+8, "formAccesstimerStaReg", sizeof("formAccesstimerStaReg")) == 0) ||
				(strncmp(req->request_uri+8, "formAccessstimerSchedulerSet", sizeof("formAccessstimerSchedulerSet")) == 0) ||
				(strncmp(req->request_uri+8, "formAccessstimerTemporarySet", sizeof("formAccessstimerTemporarySet")) == 0) ||
				(strncmp(req->request_uri+8, "formAccesstimerStaSetCategory", sizeof("formAccesstimerStaSetCategory")) == 0) ||
				(strncmp(req->request_uri+8, "formSetDeviceTime", sizeof("formSetDeviceTime")) == 0) || 
				(strncmp(req->request_uri+8, "formAccesstimerGoto", sizeof("formAccesstimerGoto")) == 0))) 
				) 
			{
				accesstimer_guardmsg = 6;
				/* WNC-NMR2197-JOE-PENG-20161220-Fix bug 2197 [Aero] After 15 minutes past during the DLG-070LPB-01 indicated, the browser will no response */
				send_redirect_perm(req, "/kodomo_guard.html");
				return 0;
			} else 
#endif
			{	
				/* WNC-NMR2197-JOE-PENG-20161220-Fix bug 2197 [Aero] After 15 minutes past during the DLG-070LPB-01 indicated, the browser will no response */
				send_redirect_perm(req, "/session_expired.html");
			}
			return 0;
		}
	}

#if 0		// For Admin pages
	if (req->auth_flag == 1) {
		if((strstr(req->request_uri,"adminpassword.htm") != NULL) ||
		   (strstr(req->request_uri,"ipfilter.htm") != NULL) ||
		   (strstr(req->request_uri,"portfilter.htm") != NULL) ||
		   (strstr(req->request_uri,"portfw.htm") != NULL) ||
		   (strstr(req->request_uri,"upload.htm")!= NULL) ||
		   (strstr(req->request_uri,"saveconf.htm") != NULL) ||
		   (strstr(req->request_uri,"reboot.htm") != NULL) ||
		   (strstr(req->request_uri,"tcpiplan_bridge.htm") != NULL) ||
		   (strstr(req->request_uri,"tcpiplan.htm") != NULL) ||
		   (strstr(req->request_uri,"tcpip_staticdhcp.htm") != NULL) ||
		   (strstr(req->request_uri,"tcpipwan.htm") != NULL) ||
		   (strstr(req->request_uri,"wizard.htm") != NULL) ||
		   (strstr(req->request_uri,"wlactrl.htm") != NULL) ||
		   (strstr(req->request_uri,"wlsch.htm") != NULL) ||
		   (strstr(req->request_uri,"wlwps.htm") != NULL)) {
			send_r_forbidden(req);
			return 0;
		}
	}
#endif	//#if 0		// For Admin pages

	{
#if 0
		if (req->auth_flag == 0 && authFailCount < 10) {
// WNC-NMR0844-JDR231-HENG-I-CHEN-2014-11-12: Fix bug 844 #END
			if (req->userName) {
				/*
				if (!strcmp(req->userName, admin_name)) {
					if (req->password==NULL || req->password[0]==0) {
						if (admin_password[0]==0)
							req->auth_flag = 2;
							check_auth_flag = 2;
					}
					else  {
						if (!strcmp(req->password, admin_password))
							req->auth_flag = 2;
							check_auth_flag = 2;
					}
				}
				else */ 
				if (!strcmp(req->userName, user_name)) {
// WNC-MRXXXX-Yuan-I-Chou-20120524- Remove Super user
					/* WNC-NMR0409-JOE-PENG-20140102-Fix bug 409 [Sonic]logout behavior for Safari-start */
					if (req->password==NULL || req->password[0]==0) {
						if (user_password[0]==0) {
							req->auth_flag = 1;
							safari_logout = 1;
						}
						check_auth_flag = 1;
					} else {
						if (!strcmp(req->password, user_password)) {
							req->auth_flag = 1;
							safari_logout = 1;
						}
						check_auth_flag = 1;
					}
					/* WNC-NMR0409-JOE-PENG-20140102-Fix bug 409 [Sonic]logout behavior for Safari-end */
				}
				/* WNC-NMR0000-Rita-20130227-V1.2.0_Sonic_SpecChangeRequest_3.4.1.-Login:
				 If user failed in login 10 times by a wrong username or password, login shall be locked. */
				if(req->auth_flag == 1)
					authFailCount = 0;
				else
					authFailCount++;
				/* WNC-NMR0000-Rita-20130227-End */
			}
		}
#endif
//console_printf("%s %d req->auth_flag: %d\n", __func__, __LINE__, req->auth_flag);

//		if (strncmp(req->request_uri, "/logout.htm", sizeof("/logout.htm")) == 0) {
//			del_logout_session(req);
//		}

		if (req->auth_flag == 0) {
/* WNC-MR0000-JOE-PENG-20120522-Modification for specification 1.6 */
/* Does not show authentication dialogue if password is not set(Default value is blank). */
			if (!strcmp(user_password, "")) {
				goto login_bypass;
			}
/* WNC-MR0000-JOE-PENG-20120522-end */
/* WNC-MR0000-Heng-I-Chen-20130312-5.18.2 Skip Basic Authentication, add check skip authentication configuration */		
			if (check_auth_conf(req->request_uri)) {
				goto login_bypass;
			}
/* WNC-MR0000-Heng-I-Chen-20130312-End */

			if (req->request_uri) {
//				console_printf("%s %d: uri: %s (%d)\n", __func__, __LINE__, req->request_uri, sizeof("/cgi_html_"));
				if ((strncmp(req->request_uri, "/login_main.html", sizeof("/login_main.html")) == 0) ||
				    (strncmp(req->request_uri, "/login_raku.html", sizeof("/login_raku.html")) == 0) ||
				    (strncmp(req->request_uri, "/logout_main.html", sizeof("/logout_main.html")) == 0) ||
				    (strncmp(req->request_uri, "/boafrm/formLogout", sizeof("/boafrm/formLogout")) == 0) ||
//WNC-NMR2209-D2R030-CHEN-HENG-I-20161221 - Merge Spider bug 1712's modification
				    (strncmp(req->request_uri, "/boafrm/formLogin", sizeof("/boafrm/formLogin")) == 0)) {
					if (authFailCount < 10) {
						goto login_bypass;
					} else {
						send_redirect_perm(req, "/cgi_html_lockout.html");
						return 0;
					}
				}

				if ((strncmp(req->request_uri, "/session_expired.html", sizeof("/session_expired.html")) == 0) ||
//WNC-NMR2209-D2R030-CHEN-HENG-I-20161221 - Merge Spider bug 1712's modification End
				    (strncmp(req->request_uri, "/server_setting.html", sizeof("/server_setting.html")) == 0) ||
				    (strncmp(req->request_uri, "/server_setting_finish.html", sizeof("/server_setting_finish.html")) == 0) ||
				    (strncmp(req->request_uri, "/server_setting_failure.html", sizeof("/server_setting_failure.html")) == 0) ||
				    (strncmp(req->request_uri, "/cgi_html_", strlen("/cgi_html_")) == 0) ||
				    (strncmp(req->request_uri, "/mntnnc/", strlen("/mntnnc/")) == 0)) {
//					console_printf("%s %d: uri: %s bypass login\n", __func__, __LINE__, req->request_uri);

#if 1 /* WNC-MR1793-[Aero]-MIKE-YEH-20160922-User can login during account lock. */
					if ((strncmp(req->request_uri, "/boafrm/formLogin", sizeof("/boafrm/formLogin"))) || 
#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)
						((req->from_interface_flag == 0)&&(req->ssl_flag == 1)&&(check_rmainte_conf())) || 
#endif					
						(authFailCount < 10)) {
						goto login_bypass;
					}
#else
					goto login_bypass;
#endif
				}
// WNC-NMR0735-JDR231-HENG-I-CHEN-2014-08-27: Bypass authentication when administrator Sta access Access Timer pages #BEGIN
#ifdef CONFIG_APP_ACCESSTIMER
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-01-27: Access Timer Guard #BEGIN	
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
				if ((strncmp(req->request_uri, "/miete_anshin_net.html", sizeof("/miete_anshin_net.html")) == 0) ||
					(strncmp(req->request_uri, "/miete_anshin_setting.html", sizeof("/miete_anshin_setting.html")) == 0) ||
					(strncmp(req->request_uri, "/kodomo_schedule.html", sizeof("/kodomo_schedule.html")) == 0)||
					(strncmp(req->request_uri, "/kodomo_temporary.html", sizeof("/kodomo_temporary.html")) == 0) ||
					(strncmp(req->request_uri, "/kodomo_reboot.html", sizeof("/kodomo_reboot.html")) == 0)||
					(strncmp(req->request_uri, "/kodomo_frame.html", sizeof("/kodomo_frame.html")) == 0) ||
					(strncmp(req->request_uri, "/kodomo_guard.html", sizeof("/kodomo_guard.html")) == 0) ||
					(strncmp(req->request_uri, "/set_device_time.html", sizeof("/set_device_time.html")) == 0 ) ||
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
					((strncmp(req->request_uri, "/boafrm/", 8) == 0) && ( 
					(strncmp(req->request_uri+8, "formAccesstimerSet", sizeof("formAccesstimerSet")) == 0) ||
					(strncmp(req->request_uri+8, "formAccesstimerStaSet", sizeof("formAccesstimerStaSet")) == 0) ||
					(strncmp(req->request_uri+8, "formAccesstimerStaReg", sizeof("formAccesstimerStaReg")) == 0) ||
					(strncmp(req->request_uri+8, "formAccessstimerSchedulerSet", sizeof("formAccessstimerSchedulerSet")) == 0) ||
					(strncmp(req->request_uri+8, "formAccessstimerTemporarySet", sizeof("formAccessstimerTemporarySet")) == 0) ||
					(strncmp(req->request_uri+8, "formAccesstimerStaSetCategory", sizeof("formAccesstimerStaSetCategory")) == 0) ||
					(strncmp(req->request_uri+8, "formSetDeviceTime", sizeof("formSetDeviceTime")) == 0) || 
					(strncmp(req->request_uri+8, "formAccesstimerGoto", sizeof("formAccesstimerGoto")) == 0))) 
					) {

					if (req->remote_ip_addr) {
						char macStr[40];
						unsigned char mac[6];
						get_mac_from_IP(macStr, req->remote_ip_addr);
						if(macStrToBin(mac, macStr)==0) {
							int i, entryNum;
							int bypass = 0;
							ACCESS_TIMER_T entry;

							if ( apmib_get(MIB_ACCESS_TIMER_TBL_NUM, (void *)&entryNum)) {
								for (i=1;i<=entryNum;i++) {
									*((char *)&entry) = (char)i;
									apmib_get(MIB_ACCESS_TIMER_TBL, (void *)&entry);
									if (memcmp(entry.macAddr, mac,6) == 0) {
										if (entry.category == 0) {
											bypass = 1;
										}
										break;
									}
								}
								if (bypass) {
									goto login_bypass;
								}
							}
						}
					}
				}
#endif
// WNC-NMR0735-JDR231-HENG-I-CHEN-2014-08-27: Bypass authentication when administrator Sta access Access Timer pages #END

			}

// WNC-MRXXXX-Yuan-I-Chou-20120524- Remove Super user
#if 0
#ifdef HOME_GATEWAY
			//apmib_get(MIB_HOST_NAME, admin_name);	//libera --
			strcpy(admin_name,"Aterm(admin)");	/* WNC-MR0000-Libera-20120308-for NEC requirement. */
#else
			strcpy(admin_name, "");
#endif
#endif
			/* WNC-NMR0381-Rita-20130412-When client [username:password] of AUTH are [logout: logout] ,
			/* the popup login at client can't be triggered by receiving THIS HTTP 401 packet without type of WWW-Authenticate. */
			if(req->userName && req->password){


#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)
				if((!check_rmainte_conf()) || 
					(req->from_interface_flag == 1) || 
					((req->from_interface_flag == 0)&&(req->ssl_flag != 1)&&(check_rmainte_conf()))) {
#endif		
					if(!strcmp(req->userName, "anonymous") || !strcmp(req->password, "logout")){
						authFailCount=0;
					}
#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)
				}
#endif	
		
				    /* WNC-NMR2197-JOE-PENG-20161220-Fix bug 2197 [Aero] After 15 minutes past during the DLG-070LPB-01 indicated, the browser will no response-start */
				    if(!strcmp(req->password, "logout")){
						if(!strcmp(req->userName, "firefox")&& firefox_logout ==1){	
								firefox_logout = 0;
								send_redirect_perm(req, "/login_main.html");
//								send_r_unauthorized_logout(req, "Aterm(admin)");
								return 0;
						}
						else if(!strcmp(req->userName, "chrome")&& chrome_logout ==1){	
								chrome_logout = 0;
								send_redirect_perm(req, "/login_main.html");
//								send_r_unauthorized_logout(req, "Aterm(admin)");
								return 0;
						}
						else if(!strcmp(req->userName, "safari")&& safari_logout ==1){	
								safari_logout = 0;
								send_redirect_perm(req, "/login_main.html");
//								send_r_unauthorized_logout(req, "Aterm(admin)");
								return 0;
						}
						else if(!strcmp(req->userName, "logout")&& check_logout ==1){	
							check_logout = 0;
								send_redirect_perm(req, "/login_main.html");
//							send_r_unauthorized_logout(req, "Aterm(admin)");
							return 0;
						}
				}
				/* WNC-NMR2197-JOE-PENG-20161220-Fix bug 2197 [Aero] After 15 minutes past during the DLG-070LPB-01 indicated, the browser will no response-end */
			}
			if (chrome_logout == 0)
				chrome_logout = 1; 
			if (firefox_logout == 0)
				firefox_logout = 1; 
/* WNC-NMR0409-JOE-PENG-20140102-Fix bug 409 [Sonic]logout behavior for Safari-start */
#if 0
			if (safari_logout == 0) {
				safari_logout = 1; 
			}
#endif
/* WNC-NMR0409-JOE-PENG-20140102-Fix bug 409 [Sonic]logout behavior for Safari-end */
			if (check_logout == 0)
				check_logout = 1; 
			/* WNC-NMR0381-Rita-20130412-End*/

			/* WNC-NMR0000-Rita-20130227-V1.2.0_Sonic_SpecChangeRequest_3.4.1.-Login lock.
			If user failed in login 10 times by a wrong username or password, login shall be locked. */

#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)
			if(((req->from_interface_flag == 0)&&(req->ssl_flag == 1)&&(check_rmainte_conf())) || (authFailCount < 10)) {			
#else
			if(authFailCount < 10) {
#endif
				strncpy(latest_request, (req && req->request_uri)?req->request_uri:"/", 255);
				accesstimer_guardmsg = 0;
				/* WNC-NMR2197-JOE-PENG-20161220-Fix bug 2197 [Aero] After 15 minutes past during the DLG-070LPB-01 indicated, the browser will no response */
				send_redirect_perm(req, "../login_main.html");
			//	send_r_unauthorized(req, "Aterm(admin)");
			
			} else {
//			  	send_r_forbidden_403_8(req);
				accesstimer_guardmsg = 0;
				/* WNC-NMR2197-JOE-PENG-20161220-Fix bug 2197 [Aero] After 15 minutes past during the DLG-070LPB-01 indicated, the browser will no response */
				send_redirect_perm(req, "/cgi_html_lockout.html");
			}
			/* WNC-NMR0000-Rita-20130227-V1.2.0_Sonic_SpecChangeRequest_3.4.1.-End*/
// WNC-MRXXXX-Yuan-I-Chou-20120524- Remove Super user
			return 0;
		}
	}

#else
#ifdef WEB_ONLY_ONE_CLIENT
	idx=auth_get_mac_idx(req->remote_ip_addr);			
#endif

#ifdef SUPER_NAME_SUPPORT
	if(check_auth_flag == 0 && req->auth_flag == 0){//super user exits
	#ifdef DIGEST_AUTHENTICATION
		if (req->userName != NULL) 
		{
			char * digest = NULL;
			if(strcmp(req->userName, super_name) == 0)//if  req->userName == super_name
			{					
				digest = generate_digest(req, super_name, super_password);
				if((digest != NULL) && (req->authorization_response != NULL))
				{
					if(strncmp(digest,req->authorization_response,FINAL_DIGEST_LENGTH) == 0)
					{
						req->auth_flag = SUPER_FLAG;
					}
				}
				free(digest);
			}
			else if(strcmp(req->userName, user_name) == 0)//if  req->userName == user_name
			{
				digest = generate_digest(req,user_name,user_password);
				if((digest != NULL) && (req->authorization_response != NULL))
				{
					if(strncmp(digest,req->authorization_response,FINAL_DIGEST_LENGTH) == 0)
					{
						req->auth_flag = SECOND_FLAG;
					}
				}
				free(digest);
			}
		}
	#else
		if (req->userName) {
			if (!strcmp(req->userName, super_name)){					
				if (req->password==NULL || req->password[0]==0){
					if (super_password[0]==0)
						req->auth_flag = SUPER_FLAG;
				}
				else {
					if (!strcmp(req->password, super_password))
						req->auth_flag = SUPER_FLAG;
				}
			}
			else{
				if (!strcmp(req->userName, user_name)){
					if (req->password==NULL || req->password[0]==0) {
						if (user_password[0]==0)
							req->auth_flag = SECOND_FLAG;							
					}
					else  {
						if (!strcmp(req->password, user_password))
							req->auth_flag = SECOND_FLAG;							
					}
				}
						
			}
					
		}//end if (req->userName)
//	}//end if(check_auth_flag == 0 && req->auth_flag == 0)
	#endif
		
#else
	
	if (strcmp(user_name, "") || strcmp(user_password, "") ) {		
		if (req->auth_flag == 0) {
		#ifdef DIGEST_AUTHENTICATION
			char * digest = generate_digest(req,user_name,user_password);
			if((digest != NULL) && (req->authorization_response != NULL))
			{
				if(strncmp(digest,req->authorization_response,FINAL_DIGEST_LENGTH) == 0)
				{
					req->auth_flag = 1;
				}
			}
			free(digest);
		#else
			if (req->userName) {
				if (!strcmp(req->userName, user_name)){
					if (req->password==NULL || req->password[0]==0) {
						if (user_password[0]==0)
							req->auth_flag = 1;					
					}
					else  {
						if (!strcmp(req->password, user_password))
							req->auth_flag = 1;					
					}//end else
				}				//end if (!strcmp(req->userName, user_name))		
			}		//end if (req->userName)
		#endif
		}//end if (req->auth_flag == 0)
#endif
		
#ifdef WEB_ONLY_ONE_CLIENT
		if (req->auth_flag == 1)
		{
			if(webClientStatus[idx].status==NOT_LOGIN)
			{
				req->auth_flag=0;
			}else
			if(webClientStatus[idx].status==TOBE_LOGIN)
			{
				webClientStatus[idx].status=AUTHED;
				auth_setAuthed(idx);
			}
		}
#endif
		if (req->auth_flag == 0 && check_auth_flag == 0) {
#ifdef HOME_GATEWAY
			apmib_get(MIB_HOST_NAME, host_name);
#else
			strcpy(host_name, "");
#endif
#ifdef WEB_ONLY_ONE_CLIENT
			webClientStatus[idx].status=TOBE_LOGIN;
#endif
			send_r_unauthorized(req, host_name);
			return 0;
		}
	}//end strcmp(user_name, "") || strcmp(user_password, "")
#endif

/* WNC-MIKE-YEH-20160805-implement remote maintenance account. */
#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)
	if (req->request_uri) {
		if(req->auth_flag)
		{
			//printf(" prepare to extend LED. ");
			system("touch /var/remote_expire_reset");
		}
	}
#endif
}
login_bypass:	/* WNC-MR0000-Libera-20120308-bypass for NEC authentication false page */
#endif
//-------------------------

    if (translate_uri(req) == 0) { /* unescape, parse uri */
        /* errors already logged */
        SQUASH_KA(req);
        return 0;               /* failure, close down */
    }

    if (req->method == M_POST) {
// davidhsu ------------------------
#ifndef NEW_POST
        req->post_data_fd = create_temporary_file(1, NULL, 0);
        if (req->post_data_fd == 0) {
            /* errors already logged */
            send_r_error(req);
            return 0;
        }
        if (fcntl(req->post_data_fd, F_SETFD, 1) == -1) {
            boa_perror(req, "unable to set close-on-exec for req->post_data_fd!");
            close(req->post_data_fd);
            req->post_data_fd = 0;
            return 0;
        }
#else
#if defined(BOA_CGI_SUPPORT)
//WNC-JDR230-YUAN-I-CHOU-20130315, Apply Realtek rtl819x-sdk-boa_cgi_support_patch_20130313_nec
//if (req->cgi_type == CGI) {
if (req->cgi_type == CGI || req->cgi_type == NPH) {
//WNC-JDR230-YUAN-I-CHOU-20130315, Apply Realtek rtl819x-sdk-boa_cgi_support_patch_20130313_nec End
        req->post_data_fd = create_temporary_file(1, NULL, 0);
        if (req->post_data_fd == 0) {
            /* errors already logged */
            send_r_error(req);
            return 0;
        }
        if (fcntl(req->post_data_fd, F_SETFD, 1) == -1) {
            boa_perror(req, "unable to set close-on-exec for req->post_data_fd!");
            close(req->post_data_fd);
            req->post_data_fd = 0;
            return 0;
        }
		}else
#endif
		{
	req->post_data =  calloc(1, BUFFER_SIZE);
	if (req->post_data == NULL) {
            send_r_error(req);
            return 0;
	}
	req->post_data_len = req->post_data_idx = 0;
		}
#endif
//------------------------------------------

// davidhsu --------------------
#ifdef SUPPORT_ASP
#if defined(CONFIG_APP_TR069) && defined(_CWMP_WITH_SSL_)
#ifdef CONFIG_RTL_BT_CLIENT
		if (strstr(req->logline, FORM_FW_UPLOAD) ||
				strstr(req->logline, FORM_CFG_UPLOAD) ||
				strstr(req->logline, FORMTR069CACERT) ||
				strstr(req->logline, FORMTR069CPECERT) ||
				strstr(req->logline, FORM_BT_NEW_TORRENT)) {
#else
if (strstr(req->logline, FORM_FW_UPLOAD) || strstr(req->logline, FORM_CFG_UPLOAD) || strstr(req->logline, FORM_FW_UPLOAD_TOEBANK) || strstr(req->logline, FORMTR069CACERT) || strstr(req->logline, FORMTR069CPECERT)) {
#endif
#else
#ifdef CONFIG_RTL_BT_CLIENT
				if (strstr(req->logline, FORM_FW_UPLOAD) ||
						strstr(req->logline, FORM_CFG_UPLOAD) ||
						strstr(req->logline, FORM_BT_NEW_TORRENT)) {
#else
	if (strstr(req->logline, FORM_FW_UPLOAD) || strstr(req->logline, FORM_CFG_UPLOAD)|| strstr(req->logline, FORM_FW_UPLOAD_TOEBANK)) {
#endif
#endif

#if defined(CONFIG_APP_FWD)
						{
							extern int get_shm_id();
							extern int clear_fwupload_shm();
							int shm_id = get_shm_id();
							/* free upload share memory, if it is existed */
// WNC-NMR0765-JDR231-HENG-I-CHEN-2014-10-02: add proection of firmware file uploading #BEGIN
							if ((request_lock_shm == req) || (last_access_time + 300 < time(NULL))) {
								if (shm_id >= 0) {
									clear_fwupload_shm(shm_id);
									request_lock_shm = NULL;
									last_access_time = 0;
								}
							}
// WNC-NMR0765-JDR231-HENG-I-CHEN-2014-10-02: add proection of firmware file uploading #END
						}
#endif

						req->upload_data = malloc(MAX_UPLOAD_SIZE);
						if (req->upload_data == NULL) {
							boa_perror(req, "allocate upload buffer failed!");
							return 0;
						}
						req->upload_len = 0;
					}
#endif
					//-----------------------------
					return 1;             /* success */
				}

				//fprintf(stderr,"####%s:%d req->request_uri=%s req->cgi_type=%d###\n",  __FILE__, __LINE__ , req->request_uri, req->cgi_type);
				//fprintf(stderr,"####%s:%d req->host=%s req->header_host=%s default_vhost=%s###\n",  __FILE__, __LINE__ , req->host, req->header_host, default_vhost);

#if 1 /* WNC-NMR2269-MIKE-YEH-20170208-Can open telnet by user: The stange page will shown when input the URL with "www". */
				if (!strncmp(req->request_uri, "/cgi-bin/www.cgi", strlen("/cgi-bin/www.cgi"))){
					req->cgi_type = CGI;
				}else
#endif
#ifdef SUPPORT_ASP
				if (strstr(req->request_uri, ".htm") ||	strstr(req->request_uri, ".asp") ||	strstr(req->request_uri, "navigation.js")) {
//WNC-JDR230-YUAN-I-CHOU-20130226, Apply Realtek rtl819x-sdk-boa_cgi_support_patch_130222
					//req->cgi_type = 1;
					req->cgi_type = ASP;
//WNC-JDR230-YUAN-I-CHOU-20130226, Apply Realtek rtl819x-sdk-boa_cgi_support_patch_130222 End
				}else
#endif
				if(strstr(req->request_uri, ".cgi")){
					req->cgi_type = CGI;
				}

				//fprintf(stderr,"####%s:%d req->request_uri=%s req->cgi_type=%d###\n",  __FILE__, __LINE__ , req->request_uri, req->cgi_type);
				if (req->cgi_type) {
//WNC-JDR230-YUAN-I-CHOU-20130226, Apply Realtek rtl819x-sdk-boa_cgi_support_patch_130222
#if 0
#ifdef SUPPORT_ASP
					return init_get2(req);
#else
        			return init_cgi(req);
#endif
#endif
#ifdef SUPPORT_ASP
					if (req->cgi_type == ASP)
	    				return init_get2(req);
					else
#endif
						return init_cgi(req);

//WNC-JDR230-YUAN-I-CHOU-20130226, Apply Realtek rtl819x-sdk-boa_cgi_support_patch_130222 End
    			}

				req->status = WRITE;

				return init_get(req);       /* get and head */
			}

#ifdef DIGEST_AUTHENTICATION
char * pick_up_field_value(char * value, char * field)
{
	if(value == NULL || field == NULL)
	{
		printf("argument is NULL in pick_up_field_value function.\n");
		return NULL;
	}
	char * field_pointer=strstr(value,field);
	if(field_pointer == NULL)
	{
		printf("No %s field in Authorizaition line.\n",field);
		return NULL;
	}
	char * field_start_pointer = field_pointer+strlen(field)+strlen("=\"");
	char * field_end_pointer = strstr(field_start_pointer,"\",");
	int field_length = field_end_pointer - field_start_pointer;
	char * field_value = malloc(field_length+1);
	if(field_value == NULL)
	{
		perror("boa: malloc username out of memory in function process_option_line");
		exit(1);
	}
	memset(field_value,0,field_length+1);
	strncpy(field_value,field_start_pointer,field_length);
	field_value[field_length]='\0';
	return field_value;
}
#endif

			/*
			 * Name: process_option_line
			 *
			 * Description: Parses the contents of req->header_line and takes
			 * appropriate action.
			 */

			int process_option_line(request * req)
			{
				char c, *value, *line = req->header_line;

				/* Start by aggressively hacking the in-place copy of the header line */

#ifdef FASCIST_LOGGING
				log_error_time();
				fprintf(stderr, "%s:%d - Parsing \"%s\"\n", __FILE__, __LINE__, line);
#endif

				value = strchr(line, ':');
				if (value == NULL) {
					log_error_doc(req);
					fprintf(stderr, "header \"%s\" does not contain ':'\n", line);
					return 0;
				}
				*value++ = '\0';            /* overwrite the : */
				to_upper(line);             /* header types are case-insensitive */

				/* the code below *does* catch '\0' due to the c = *value test */
				while ((c = *value) && (c == ' ' || c == '\t'))
					value++;

				/* if c == '\0' there was no 'value' for the key */
				if (c == '\0') {
					/* return now to bypass any parsing or assignment */
					return 1;
				}

				switch (line[0]) {
					case 'A':
						if (!memcmp(line, "ACCEPT", 7)) {
#ifdef ACCEPT_ON
							add_accept_header(req, value);
#endif
							return 1;
						}

						if (!memcmp(line,"AUTHORIZATION",14)) {
							req->http_authorization = value;
						}

#ifdef USE_AUTH
	#ifdef DIGEST_AUTHENTICATION
			if (!memcmp(line,"AUTHORIZATION",14))
			{
				if (strncasecmp(value, "Digest ", 7))
				{
					printf("Can only handle Digest auth\n");
					send_r_bad_request(req);
					return 0;
				}

				//Authorization: Digest username="111", realm="Realtek", nonce="VGh1IE9jdCAxNSAxMDowNjoxMSAyMDE1", uri="/", response="07f9580e67fc71ad24301541f9a52d8f"

				//pick up the value of 'username' from 'value' string
				req->userName=pick_up_field_value(value,"username");
				if(req->userName == NULL)
				{
					send_r_bad_request(req);
					return 0;
				}

				//pick up the value of 'nonce' from 'value' string
				req->authorization_nonce = pick_up_field_value(value,"nonce");
				if(req->authorization_nonce == NULL)
				{
					send_r_bad_request(req);
					return 0;
				}

				//pick up the value of 'uri' from 'value' string
				req->authorization_uri = pick_up_field_value(value,"uri");
				if(req->authorization_uri == NULL)
				{
					send_r_bad_request(req);
					return 0;
				}

				//pick up the value of 'response' from 'value' string
				char * response_pointer=strstr(value,"response");
				if(response_pointer != NULL)
				{
					req->authorization_response=malloc(FINAL_DIGEST_LENGTH+1);//magic number
					if(req->authorization_response != NULL)
					{
						memset(req->authorization_response,0,FINAL_DIGEST_LENGTH+1);
						strncpy(req->authorization_response,response_pointer+10,FINAL_DIGEST_LENGTH);//magic number
						req->authorization_response[FINAL_DIGEST_LENGTH]='\0';
					}
					else
					{
						perror("boa: malloc response out of memory in function process_option_line");
						exit(1);
					}
				}
				else
				{
					printf("No response field in Authorizaition line.\n");
					send_r_bad_request(req);
					return 0;
				}
				return 1;
			}
	#else
												 //get username and password inputed by user from browser,
												 //after decode, assign them to 'req->userName' and 'req->password'
						if (!memcmp(line,"AUTHORIZATION",14)) {
							char userAuth[0x80];
							char *cp;
							if (strncasecmp(value, "Basic ", 6)) {
								printf("Can only handle Basic auth\n");
								send_r_bad_request(req);
								return 0;
							}
							base64decode(userAuth, value+6, sizeof(userAuth));
							if ( (cp = strchr(userAuth,':')) == 0 ) {
								printf("No user:pass in Basic auth\n");
								send_r_bad_request(req);
								return 0;
							}
							*cp++=0;
							req->userName = strdup(userAuth);
							req->password = strdup(cp);
							return 1;
						}
	#endif
#endif

						break;
					case 'C':
						//printf("line=%s value=%s\n", line, value);
						if (!memcmp(line, "CONTENT_TYPE", 13) && !req->content_type) {
							req->content_type = value;
							req->multipart_boundary = NULL;
							if (strlen(value) > strlen("multipart/form-data")) {
								if (strncmp(value, "multipart/form-data", strlen("multipart/form-data")) == 0) {
									char *ptr;
									if ((ptr = strstr(value, "boundary=")) != NULL) {
										ptr += strlen("boundary=");
										req->multipart_boundary = malloc(strlen(ptr)+4);
										if (req->multipart_boundary)
											snprintf(req->multipart_boundary, (strlen(ptr)+4), "--%s", ptr);
									}
								}
							}
							//printf("req->content_type=%s\n", req->content_type);
							//if (req->multipart_boundary)
							//	printf("req->multipart_boundary=%s\n", req->multipart_boundary);
							return 1;
						} else if (!memcmp(line, "CONTENT_LENGTH", 15)
								&& !req->content_length) {
							req->content_length = value;
#ifdef HTTP_FILE_SERVER_SUPPORTED
							req->clen = boa_atoi(req->content_length);
							req->TotalContentLen = req->clen;
#endif
							return 1;
						} else if (!memcmp(line, "CONNECTION", 11) &&
								ka_max && req->keepalive != KA_STOPPED) {
#ifdef SUPPORT_ASP
							req->keepalive = KA_STOPPED;
#else
							req->keepalive = (!strncasecmp(value, "Keep-Alive", 10) ?
									KA_ACTIVE : KA_STOPPED);
#endif            
							return 1;
						}
						break;
					case 'H':
						if (!memcmp(line, "HOST", 5) && !req->header_host) {
							req->header_host = value; /* may be complete garbage! */
							return 1;
						}
						break;
					case 'I':
						if (!memcmp(line, "IF_MODIFIED_SINCE", 18)
								&& !req->if_modified_since) {
							req->if_modified_since = value;
							return 1;
						}
						break;
					case 'R':
						/* Need agent and referer for logs */
						if (!memcmp(line, "REFERER", 8)) {
							req->header_referer = value;
							if (!add_cgi_env(req, "REFERER", value, 1)) {
								/* errors already logged */
								return 0;
							}
						} else if (!memcmp(line, "RANGE", 6)) {
							if (req->ranges && req->ranges->stop == INT_MAX) {
								/* there was an error parsing, ignore */
								return 1;
							} else if (!range_parse(req, value)) {
								/* unable to parse range */
								send_r_invalid_range(req);
								return 0;
							}                   /* req->ranges */
						}
						break;
					case 'U':
						if (!memcmp(line, "USER_AGENT", 11)) {
							req->header_user_agent = value;
#ifdef HTTP_FILE_SERVER_SUPPORTED
							CheckUA(req);
#endif            

							if (!add_cgi_env(req, "USER_AGENT", value, 1)) {
								/* errors already logged */
								return 0;
							}
							return 1;
						}
						break;
					default:                   /* no default */
						break;
				}                           /* switch */

				return add_cgi_env(req, line, value, 1);
			}

#ifdef ACCEPT_ON
			/*
			 * Name: add_accept_header
			 * Description: Adds a mime_type to a requests accept char buffer
			 *   silently ignore any that don't fit -
			 *   shouldn't happen because of relative buffer sizes
			 */

			void add_accept_header(request * req, const char *mime_type)
			{
				int l = strlen(req->accept);
				int l2 = strlen(mime_type);

				if ((l + l2 + 2) >= MAX_HEADER_LENGTH)
					return;

				if (req->accept[0] == '\0') {
					memcpy(req->accept, mime_type, l2 + 1);
				} else {
					req->accept[l] = ',';
					req->accept[l + 1] = ' ';
					memcpy(req->accept + l + 2, mime_type, l2 + 1);
					/* the +1 is for the '\0' */
				}
			}
#endif

			void free_requests(void) {
				request *ptr, *next;

				ptr = request_free;
				while (ptr != NULL) {
					next = ptr->next;

#ifdef SUPPORT_ASP
					if (ptr->buffer)
					{
						free(ptr->buffer);
						ptr->buffer=NULL;
					}
					// davidhsu -------------
					if (ptr->upload_data){
						free(ptr->upload_data);
						ptr->upload_data=NULL;
					}
					//----------------------
#endif

					free(ptr);
					ptr = next;
				}
				request_free = NULL;
			}
