#include <linux/if_ether.h>
#include <linux/in.h>
#include <linux/in6.h>
#include <linux/time.h>
#include <linux/etherdevice.h>
#include <net/ip.h>
#include <net/ipv6.h>
#include <net/rtl/rtl_types.h>
#include <net/rtl/rtl_queue.h>
#include <net/rtl/fastpath/fastpath_core.h>
#include <net/netfilter/nf_conntrack.h>
#include <net/netfilter/nf_conntrack_helper.h>


#include <linux/types.h>
#include <linux/icmp.h>
#include <net/icmp.h>


extern CTAILQ_HEAD(Path_list_inuse_head, Path_List_Entry) path_list_inuse;
extern CTAILQ_HEAD(Path_list_free_head, Path_List_Entry) path_list_free;

extern int path_table_list_max;
extern struct Path_Table *table_path;
extern __IRAM_GEN uint32 FastPath_Hash_PATH_Entry(ipaddr_t sip, uint32 sport, ipaddr_t dip, uint32 dport, uint16 protocol);
extern int ip_finish_output6(struct sk_buff *skb);
#ifndef DEL_NAPT_TBL
extern int napt_table_list_max;
extern struct Napt_Table *table_napt;
extern CTAILQ_HEAD(Napt_list_inuse_head, Napt_List_Entry) napt_list_inuse;
extern CTAILQ_HEAD(Napt_list_free_head, Napt_List_Entry) napt_list_free;
extern uint32 FastPath_Hash_NAPT_Entry(ipaddr_t sip, uint32 sport, ipaddr_t dip, uint32 dport, uint16 protocol);
#endif

// IPv4 address of v4dev
u32 br_ip4_addr = 0; 
u32 br_ip4_mask = 0;

int rtl_dslite_debug = 0;

///////////////////////////////////////////////////////////////////
int dslite_fast_enter(struct sk_buff *pskb){
	struct sk_buff *new_skb;
	struct ethhdr *eth;
	struct ipv6hdr *ip6h;
	struct iphdr *ip4h;
	__u8 *payload;//, poffset
	u32 hlen, plen, hash; 

	struct tcphdr *tcphudph;
	struct udphdr *uh;
	u16 s_port, d_port;//, skb_protocol
	
	struct Path_List_Entry *entry_path;
	int ret;
	if (!pskb) return 1;
	if (rtl_skb_fastpath_flag(pskb)) return 0;
	if (!init_dslite_info) return 0;
	
	eth = eth_hdr(pskb);	
	
	/* IPv4 0x0800: Lan->Wan */
	if (eth && (ntohs(eth->h_proto) == (ETH_P_IP)) ){ 
		/* check v4 rx_device */
		if(!is_tunnel46_rx_from_lan_dev(pskb)){
			RTL_TUNNEL_FP_DEBUG("Invalid DSLITE RX Device! rx_device_name (%s)\n",rtl_skb_dev_name(pskb));
			return 0;
		} 
			
		ip4h = ip_hdr(pskb);
		
		/* By pass multicast packet */
		if (ipv4_is_multicast(ip4h->daddr) || ipv4_is_lbcast(ip4h->daddr) || ipv4_is_loopback(ip4h->daddr)){
			RTL_TUNNEL_FP_DEBUG("By pass Multicast/Broadcast/Loopback packet!\n",ip4h->id);
			return 0;	
		}	

		/* Do not translate ipv4 packets that are toward local v4network. */			
		if (is_tunnel46_to_local_network(ip4h->daddr, br_ip4_addr, br_ip4_mask)){
			RTL_TUNNEL_FP_DEBUG("By pass Local packet!\n");			
			return 0;		
		}	

		/* Check IPv4 header ( protocol /frag_off /checksum ) */
		if (!is_ip4_header_valid(ip4h, fast_dslite_fw)) {
			RTL_TUNNEL_FP_DEBUG("ttl(%d), protocol(%d), frag_off(0x%x)", ip4h->ttl, ip4h->protocol, ntohs(ip4h->frag_off));
			RTL_TUNNEL_FP_DEBUG("Invalid Ipv4 header for DSLITE fastpath!\n");
			return 0;	
		}
		
		tcphudph = (struct tcphdr *)(ip4h + 1);
		
		/* Check TCP/UDP header ( flag /checksum ) */
		if (!is_tcp_udp_header_valid(ip4h, tcphudph, fast_dslite_fw)) {
			RTL_TUNNEL_FP_DEBUG("Invalid tcp/udp header for DSLITE fastpath!\n");
			return 0;	
		}
		if (ip4h->protocol == IPPROTO_TCP){
			s_port = tcphudph->source;
			d_port = tcphudph->dest;		
		}else{
			uh = (struct udphdr *)tcphudph;
			s_port = uh->source;
			d_port = uh->dest;			
		}
		
	#ifdef CONFIG_SMP
		spin_lock(&table_path->path_table_lock);
	#endif
		hash = FastPath_Hash_PATH_Entry(ip4h->saddr, s_port, ip4h->daddr, d_port, ip4h->protocol);
		CTAILQ_FOREACH(entry_path, &table_path->list[hash], path_link){			
			if ( (entry_path->in_sIp == ip4h->saddr) &&
				  (entry_path->in_dIp == ip4h->daddr) &&
				  (entry_path->in_sPort == s_port) &&
				  (entry_path->in_dPort == d_port) &&			
				  ((entry_path->protocol == NP_TCP && ip4h->protocol == IPPROTO_TCP)||
				  (entry_path->protocol == NP_UDP && ip4h->protocol == IPPROTO_UDP)) &&
				  ((entry_path->p_flag & DSLITE_PCK_FLAG) != 0) && 
				  (entry_path->course == 1) && 
				  (entry_path->vaild == RTL_FP_NAPT_VALID) ){

					/* Check SPI (Tcp sequnce/ack number) note: there is no nat on b4 */
					ret = fast_path_before_nat_check(pskb, ip4h, ip4h->protocol);
					if (ret == NET_RX_DROP){
						RTL_TUNNEL_FP_DEBUG("[Check SPI] seq(%u) ack(%u)!\n",ntohl(tcphudph->seq),ntohs(tcphudph->ack_seq));	
					#if defined(CONFIG_SMP)
						spin_unlock(&table_path->path_table_lock);
					#endif
						kfree_skb(pskb);
						return 1;
					}
														
					hlen = sizeof(struct ipv6hdr);	

					/* Add IPv6 header Encapsulation */	
					if (skb_headroom(pskb) >= (hlen + ETH_HLEN) && (!rtl_skb_cloned(pskb)) && (!rtl_skb_shared(pskb)) ){
						//RTL_TUNNEL_FP_DEBUG("Origin: ip4h->id (0x%x)\n",ip4h->id);														
						
						skb_push(pskb, hlen + ETH_HLEN);//pskb->data -= (hlen + ETH_HLEN);

						/* Keep MAC header Unchanged */	
						memmove(rtl_get_skb_data(pskb), rtl_skb_mac_header(pskb), ETH_HLEN);
						skb_reset_mac_header(pskb);//pskb->mac_header = pskb->data;	
						eth = eth_hdr(pskb);
						eth->h_proto  = htons(ETH_P_IPV6);

						/* Reset data pointer and Network header */
						skb_pull(pskb, ETH_HLEN);
						skb_reset_network_header(pskb);

						/* Set IPv6 header */
						ip6h = (struct ipv6hdr *)rtl_get_skb_data(pskb);
						set_tunnel46_ipv6_header(ip4h, ip6h, &entry_path->src6, &entry_path->dst6);

						rtl_set_skb_protocol(pskb, htons(ETH_P_IPV6));
						
						/* Check dst_IPv6 route */
						if (tunnel46_ipv6_route_input(pskb) == FAILED)	{	
							RTL_TUNNEL_FP_DEBUG("Lookup for ipv6 route failed!\n");
						#ifdef CONFIG_SMP
							spin_unlock(&table_path->path_table_lock);
						#endif

							/* Reset data pointer /Network header /Mac header */
							tunnel46_recover_ipv4_pkt(&pskb);
							rtl_skb_set_fastpath_flag(pskb, 1);
							return 0;
						}
						/* Check ipv6 mtu/neighbor */
						if ( (tunnel46_ipv6_mtu_check(pskb, ip4h, ip4h->protocol) == FAILED) ||
							  (rtl_skb_ipv6_dst_check(pskb) == FAILED) ||
							  (rtl_check_dst_input(pskb) == FAILED) ){			
							RTL_TUNNEL_FP_DEBUG("Lookup for ipv6 neighbor failed or len(%d) is longer than MTU!\n",rtl_get_skb_len(pskb));	
						#ifdef CONFIG_SMP
							spin_unlock(&table_path->path_table_lock);
						#endif

							rtl_dst_release(pskb);	
						
							/* Reset data pointer /Network header /Mac header */
							tunnel46_recover_ipv4_pkt(&pskb);
							rtl_skb_set_fastpath_flag(pskb, 1);
							return 0;
						}				
						rtl_set_skb_dev(pskb, NULL);
						rtl_set_skb_ip_summed(pskb,CHECKSUM_NONE);

						/* Update the last_used time */
						entry_path->last_used = jiffies;	
						
						/*Update the IPv6 cache last_used time when packets forwarded by MAP-E/Ds-Lite fast-path*/
						rtl_updateTunnelIPv6Cache(&entry_path->src6, &entry_path->dst6);
				
					#ifdef CONFIG_SMP
						spin_unlock(&table_path->path_table_lock);
					#endif

					#if 1 //CONFIG_RTL_FASTPATH_SUPPORT_DPI_ENGINE
					ret = tunnel_dpi_hook_for_app_type(pskb, entry_path->app_type, entry_path->type);
					if (ret == DPI_set_block){
						kfree_skb(pskb);
						return NET_RX_DROP;
					}
					#endif

					#if LINUX_VERSION_CODE >= KERNEL_VERSION(3,10,0)
						tunnel_adjust_ipv4_ttl(ip4h);

						ret = tunnel46_ipv6_output6(pskb, tunnel46_finish_output6, entry_path->app_type, entry_path->type);	
						statistic_dslite_fp++;
						return 1;
					#else
						if (rtl_get_hh_from_skb(pskb)){
							tunnel_adjust_ipv4_ttl(ip4h);					

							tunnel46_ipv6_output6(pskb, rtl_neigh_hh_output, entry_path->app_type, entry_path->type);//rtl_neigh_hh_output(pskb);		
							statistic_dslite_fp++;
							return 1;					
						}else if (rtl_get_neigh_from_skb(pskb)){
							tunnel_adjust_ipv4_ttl(ip4h);				

							tunnel46_ipv6_output6(pskb, rtl_neigh_output, entry_path->app_type, entry_path->type);//rtl_neigh_hh_output(pskb);	
							statistic_dslite_fp++;
							return 1;
						}else if (rtl_check_skb_dst_output_exist(pskb) == TRUE){
							tunnel_adjust_ipv4_ttl(ip4h);												
	
							tunnel46_ipv6_output6(pskb, rtl_dst_output, entry_path->app_type, entry_path->type);//rtl_neigh_hh_output(pskb); 
							statistic_dslite_fp++;
							return 1;
						}		

						rtl_dst_release(pskb);	
						tunnel46_recover_ipv4_pkt(&pskb);																						
						rtl_skb_set_fastpath_flag(pskb, 1);
						return 0;
						
					#endif					
					}else {/* new_skb */
						hlen = sizeof(struct ipv6hdr);	// IPv6 header len
						plen = ntohs(ip4h->tot_len);
						if (!(new_skb = skb_copy(pskb, GFP_ATOMIC))) {
								RTL_TUNNEL_FP_DEBUG("Failed to skb_copy.\n");
						#ifdef CONFIG_SMP
							spin_unlock(&table_path->path_table_lock);
						#endif
								rtl_skb_set_fastpath_flag(pskb, 1);
								return 0;
						}

						ip4h = ip_hdr(new_skb);
						tcphudph = (struct tcphdr*)(ip4h + 1);

						if(skb_headroom(new_skb) < (hlen + ETH_HLEN) && skb_cow(new_skb, hlen + ETH_HLEN) != 0){
								RTL_TUNNEL_FP_DEBUG("skb_cow fail!\n");
							#ifdef CONFIG_SMP
								spin_unlock(&table_path->path_table_lock);
							#endif
								kfree_skb(new_skb);
							rtl_skb_set_fastpath_flag(pskb, 1);
							return 0;
						}

						skb_push(new_skb, hlen + ETH_HLEN);//pskb->data -= (hlen + ETH_HLEN);						
					
						/* Keep MAC header Unchanged */ 
						memmove(rtl_get_skb_data(new_skb), rtl_skb_mac_header(new_skb), ETH_HLEN);
						skb_reset_mac_header(new_skb);//pskb->mac_header = pskb->data; 
						eth = eth_hdr(new_skb);
						eth->h_proto  = htons(ETH_P_IPV6);

						/* Reset data pointer and Network header */
						skb_pull(new_skb, ETH_HLEN);
						skb_reset_network_header(new_skb);

						/* Set IPv6 header */
						ip6h = (struct ipv6hdr *)rtl_get_skb_data(new_skb);
						set_tunnel46_ipv6_header(ip4h, ip6h, &entry_path->src6, &entry_path->dst6);

						rtl_set_skb_protocol(new_skb, htons(ETH_P_IPV6));

						/* Check ipv6 route/mtu/neighbor */
						if ( (tunnel46_ipv6_route_input(new_skb) == FAILED) ||
							  (tunnel46_ipv6_mtu_check(new_skb, ip4h, ip4h->protocol) == FAILED) ||
							  (rtl_skb_ipv6_dst_check(new_skb) == FAILED) ||
							  (rtl_check_dst_input(new_skb) == FAILED)){							
							RTL_TUNNEL_FP_DEBUG("Lookup for ipv6 route/neighbor failed or len(%d) is longer than MTU!\n",rtl_get_skb_len(new_skb));	
						#ifdef CONFIG_SMP
							spin_unlock(&table_path->path_table_lock);
						#endif
						
							kfree_skb(new_skb);

							rtl_skb_set_fastpath_flag(pskb, 1);
							return 0;
						}
						
						rtl_set_skb_dev(new_skb, NULL);
						rtl_set_skb_ip_summed(new_skb,CHECKSUM_NONE);

						/* Update the last_used time */
						entry_path->last_used = jiffies;	
					
						/*Update the IPv6 cache last_used time when packets forwarded by MAP-E/Ds-Lite fast-path*/
						rtl_updateTunnelIPv6Cache(&entry_path->src6, &entry_path->dst6);
					
					#ifdef CONFIG_SMP
						spin_unlock(&table_path->path_table_lock);
					#endif
					
					#if 1 //CONFIG_RTL_FASTPATH_SUPPORT_DPI_ENGINE
						ret = tunnel_dpi_hook_for_app_type(new_skb, entry_path->app_type, entry_path->type);
						if (ret == DPI_set_block){
							kfree_skb(new_skb);
							kfree_skb(pskb);
							return NET_RX_DROP;
						}
					#endif

					#if LINUX_VERSION_CODE >= KERNEL_VERSION(3,10,0)
						tunnel_adjust_ipv4_ttl(ip4h);
						
						ret = tunnel46_ipv6_output6(new_skb, tunnel46_finish_output6, entry_path->app_type, entry_path->type);	
						kfree_skb(pskb);
						statistic_dslite_fp++;
						return 1;
					#else
						if (rtl_get_hh_from_skb(new_skb)){
							tunnel_adjust_ipv4_ttl(ip4h);					

							tunnel46_ipv6_output6(new_skb, rtl_neigh_hh_output, entry_path->app_type, entry_path->type);//rtl_neigh_hh_output(pskb);	
							kfree_skb(pskb);
							statistic_dslite_fp++;
							return 1;					
						}else if (rtl_get_neigh_from_skb(new_skb)){
							tunnel_adjust_ipv4_ttl(ip4h);						

							tunnel46_ipv6_output6(new_skb, rtl_neigh_output, entry_path->app_type, entry_path->type);//rtl_neigh_output(pskb);							
							kfree_skb(pskb);
							statistic_dslite_fp++;
							return 1;	
						}else if (rtl_check_skb_dst_output_exist(new_skb) == TRUE){
							tunnel_adjust_ipv4_ttl(ip4h);														

							tunnel46_ipv6_output6(new_skb, rtl_dst_output, entry_path->app_type, entry_path->type);//rtl_dst_output(pskb);
							kfree_skb(pskb);
							statistic_dslite_fp++;
							return 1;	
						}		
						
						kfree_skb(new_skb);					
						rtl_skb_set_fastpath_flag(pskb, 1);
						return 0;
					#endif
						
					}// alloc new _skb
					
				} // if matched entry
		} //CTAILQ_FOREACH
		
	#ifdef CONFIG_SMP
		spin_unlock(&table_path->path_table_lock);
	#endif
	
	}else if (eth && (ntohs(eth->h_proto) == (ETH_P_IPV6)) )/*IPv6 0x86dd: Wan->Lan*/
	{
	
	//RTL_TUNNEL_FP_DEBUG("dslite_fast_enter wan to lan\n");
		u8 next_hdr;//, *ext_hdr
		struct ipv6hdr tmpIPv6h;
		
		/* check v6 rx_device */
		if(!is_tunnel64_rx_from_wan_device(pskb)){
			RTL_TUNNEL_FP_DEBUG("Invalid DSLITE RX Device! rx_device_name (%s)\n",rtl_skb_dev_name(pskb));
			return 0;
		} 
			
		ip6h = ipv6_hdr(pskb);		
		if (ip6h->hop_limit <= 1){
			RTL_TUNNEL_FP_DEBUG("ip6h->hop_limit (%d)\n",ip6h->hop_limit);
			return 0;	// forward to CPU
		} 		
		
		/* process extension headers */
		next_hdr = ip6h->nexthdr;		
		if (next_hdr != IPPROTO_IPIP) {
			RTL_TUNNEL_FP_DEBUG("Not DSLITE packet!\n");
			return 0;	// forward to CPU
		}

		/*skip the link local/Mcast ip address packet!!!*/
		if( (ipv6_addr_type(&ip6h->saddr) & IPV6_ADDR_LINKLOCAL)|| 
			(ipv6_addr_type(&ip6h->daddr) & (IPV6_ADDR_MULTICAST|IPV6_ADDR_LINKLOCAL))){
			RTL_TUNNEL_FP_DEBUG("Local/Mcast packet!\n");
			return 0;	// forward to CPU
		}
			
		ip4h = (struct iphdr *)(ip6h + 1);
		if (!is_ip4_header_valid(ip4h, fast_dslite_fw)){
			RTL_TUNNEL_FP_DEBUG("Invalid Ipv4 header for DSLITE fastpath!\n");
			return 0;	// forward to CPU
		}

		tcphudph = (struct tcphdr *)(ip4h + 1);
		if (!is_tcp_udp_header_valid(ip4h, tcphudph, fast_dslite_fw)){
			RTL_TUNNEL_FP_DEBUG("Invalid tcp/udp header for DSLITE fastpath!\n");
			return 0;	// forward to CPU
		}
		if (ip4h->protocol == IPPROTO_TCP){
			s_port = tcphudph->source;
			d_port = tcphudph->dest;		
		}else{
			uh = (struct udphdr *)tcphudph;
			s_port = uh->source;
			d_port = uh->dest;		
		}

	#ifdef CONFIG_SMP
		spin_lock(&table_path->path_table_lock);
	#endif
		hash = FastPath_Hash_PATH_Entry(ip4h->saddr, s_port, ip4h->daddr, d_port, ip4h->protocol);
		CTAILQ_FOREACH(entry_path, &table_path->list[hash], path_link){
			if( (entry_path->in_sIp == ip4h->saddr) &&
				 (entry_path->in_dIp == ip4h->daddr) &&
				 (entry_path->in_sPort == s_port) &&
				 (entry_path->in_dPort == d_port) &&
				 ((entry_path->protocol == NP_TCP && ip4h->protocol == IPPROTO_TCP)||
				 (entry_path->protocol == NP_UDP && ip4h->protocol == IPPROTO_UDP))&&
				 ((entry_path->p_flag & DSLITE_PCK_FLAG) != 0) && 
				 (entry_path->course == 2 ) &&
				 (entry_path->vaild == RTL_FP_NAPT_VALID) ){
					hlen = sizeof(struct ipv6hdr);	// IPv6 header len
					memset(&tmpIPv6h, 0x00, hlen);
					memcpy(&tmpIPv6h, ip6h, hlen);

					/* delete IPv6 header */
					skb_pull(pskb, hlen);
					skb_reset_network_header(pskb);

					/* Keep mac header unchanged */
					memmove(rtl_get_skb_data(pskb) - ETH_HLEN, eth, ETH_HLEN);
					rtl_skb_set_mac_header(pskb, -ETH_HLEN);

					rtl_set_skb_protocol(pskb, htons(ETH_P_IP));						

					/* Check Route */
					if (tunel64_ipv4_route_input(pskb, entry_path->out_dIp, NULL)){
						RTL_TUNNEL_FP_DEBUG("Lookup for ipv4 route failed!\n");					
					#ifdef CONFIG_SMP
						spin_unlock(&table_path->path_table_lock);
					#endif

						tunnel64_recover_ipv6_pkt(&pskb, &tmpIPv6h);
						rtl_skb_set_fastpath_flag(pskb, 1);
						return 0;	// forward to CPU
					}

					/* Check neighbour/MTU */
				#if defined(CONFIG_RTL_FASTPATH_HWNAT_SUPPORT_KERNEL_3_X)
					if (rtl_skb_dst_check(pskb, entry_path->out_dIp) == FAILED)
				#else
					if (rtl_skb_dst_check(pskb, entry_path->out_dIp, ip4h) == FAILED)
				#endif
					{
						RTL_TUNNEL_FP_DEBUG("Lookup for ipv4 neighbour failed or MTU oversize!\n");					
					#ifdef CONFIG_SMP
						spin_unlock(&table_path->path_table_lock);
					#endif

						rtl_dst_release(pskb);
						tunnel64_recover_ipv6_pkt(&pskb, &tmpIPv6h);
						rtl_skb_set_fastpath_flag(pskb, 1);
						return 0;
					}											

					rtl_set_skb_dev(pskb, NULL);
					
					tunnel_adjust_ipv4_ttl(ip4h); /*TTL*/

					/* Check SPI (Tcp sequnce/ack number) */
					ret = fast_path_before_nat_check(pskb, ip4h, ip4h->protocol);
					if (ret == NET_RX_DROP){
						RTL_TUNNEL_FP_DEBUG("[Check SPI] seq(%u) ack(%u)!\n",ntohl(tcphudph->seq),ntohs(tcphudph->ack_seq));	
					#if defined(CONFIG_SMP)
						spin_unlock(&table_path->path_table_lock);
					#endif
						kfree_skb(pskb);
						return 1;
					}						
					
					entry_path->last_used = jiffies;					

					/*Update the IPv6 cache last_used time when packets forwarded by MAP-E/Ds-Lite fast-path*/
					rtl_updateTunnelIPv6Cache(&entry_path->dst6, &entry_path->src6);	
					
					#if defined(CONFIG_SMP)
					spin_unlock(&table_path->path_table_lock);
					#endif

					ret = tunnel_dpi_hook_for_app_type(pskb, entry_path->app_type, entry_path->type);
					if (ret == DPI_set_block){
						kfree_skb(pskb);
						return NET_RX_DROP;
					}

					ret = ip_finish_output3(pskb);
					RTL_TUNNEL_FP_DEBUG("forward_ret(%d)\n",ret);

					statistic_dslite_fp++;
					return 1;
				}//if matched
		}//CTAILQ_FOREACH
		
	#ifdef CONFIG_SMP
		spin_unlock(&table_path->path_table_lock);
	#endif
	}
	 
	 return 0; /* forward to CPU */
}

///////////////////////////////////////////////////////////////////

#define FLUSH_DSLITE_TBL(type, list_inuse, list_free, tbl, link, max) { \
	int i; \
	struct type *en;	\
	for (i=0; i<max; i++) { \
		CTAILQ_FOREACH(en, &tbl->list[i], link) { \
		if(en->p_flag & DSLITE_PCK_FLAG){\
			CTAILQ_REMOVE(&tbl->list[i], en, link); \
			CTAILQ_REMOVE(&list_inuse, en, tqe_link); \
			CTAILQ_INSERT_TAIL(&list_free, en, tqe_link); \
		} \			
		} \
	} \
}

/* flush all DSLITE connnection info */
static int rtk_flushDSLITEConnection(){	
	unsigned long irq_flags;

	local_irq_save(irq_flags);

#ifndef DEL_NAPT_TBL
	FLUSH_DSLITE_TBL(Napt_List_Entry, napt_list_inuse, napt_list_free, table_napt, napt_link, napt_table_list_max);
#endif
	FLUSH_DSLITE_TBL(Path_List_Entry, path_list_inuse, path_list_free, table_path, path_link, path_table_list_max);

  	local_irq_restore(irq_flags);

	return;
}


#if LINUX_VERSION_CODE >= KERNEL_VERSION(3,10,0)
static int dslite_fast_forward_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data);
static int dslite_fast_forward_read_proc(struct seq_file *s, void *v){
      seq_printf(s, "fast_dslite_fw=%c, rtl_dslite_debug=%c \n", fast_dslite_fw + '0', rtl_dslite_debug + '0');
      return 0;
}

int dslite_fast_forward_single_open(struct inode *inode, struct file *file){
        return(single_open(file, dslite_fast_forward_read_proc, NULL));
}

static ssize_t dslite_fast_forward_single_write(struct file * file, const char __user * userbuf,
		     size_t count, loff_t * off){
	return dslite_fast_forward_write_proc(file, userbuf,count, off);
}

struct file_operations dslite_fast_forward_proc_fops= {
        .open		 = dslite_fast_forward_single_open,
        .write		 = dslite_fast_forward_single_write,
        .read 		 = seq_read,
        .llseek	 = seq_lseek,
        .release	 = single_release,
};
#else
static int dslite_fast_forward_read_proc(char *page, char **start, off_t off,
		     int count, int *eof, void *data){
      int len;

      len = sprintf(page, "fast_dslite_fw=%c, rtl_dslite_debug=%c \n", fast_dslite_fw + '0', rtl_dslite_debug + '0');

      if (len <= off+count) *eof = 1;
      *start = page + off;
      len -= off;
      if (len>count) len = count;
      if (len<0) len = 0;
      return len;
}
#endif

//extern int fast_spi;

static int dslite_fast_forward_write_proc(struct file *file, const char *buffer,
		      unsigned long count, void *data){
      char dslite_tmp[10];

      if (count < 3)
	    return -EFAULT;
	  
      if (buffer && !copy_from_user(&dslite_tmp, buffer, ((count < 10) ? count : 10)))  {
	    	fast_dslite_fw = dslite_tmp[0] - '0';
			rtl_dslite_debug = dslite_tmp[2] - '0';
			tunnel_debug_level = rtl_dslite_debug;
		//	fast_spi = dslite_tmp[4] - '0';
			
			//if echo 0 > proc/dslite_fast_forward,flush the original sesson info!!!
			if(!fast_dslite_fw){
				rtk_flushDSLITEConnection();
				init_dslite_info = 0;
			}
			else{
				tunnel_get_br0_ip_mask(&br_ip4_addr, &br_ip4_mask);
			}
			
			return count;
      }
      return -EFAULT;
}

#if defined(CONFIG_PROC_FS)
static struct proc_dir_entry *dslite_res=NULL;
#endif

int __init dslite_fast_forward_init(void){
#if defined(CONFIG_PROC_FS)
#if LINUX_VERSION_CODE >= KERNEL_VERSION(3,10,0)
	dslite_res = proc_create_data("dslite_fast_forward", 0, &proc_root,
			 &dslite_fast_forward_proc_fops, NULL);
#else
	dslite_res = create_proc_entry("dslite_fast_forward", 0, NULL);
	if (dslite_res) {
		dslite_res->read_proc =  dslite_fast_forward_read_proc;
		dslite_res->write_proc = dslite_fast_forward_write_proc;		
	}
#endif
#endif
	//fast_dslite_fw = 1;	//control by set_init now
	return 0;
}

void __exit dslite_fast_forward_exit(void){
#if defined(CONFIG_PROC_FS)
#if LINUX_VERSION_CODE >= KERNEL_VERSION(3,10,0)
	if (dslite_res) {
	    remove_proc_entry("dslite_fast_forward", &proc_root);
	}
#else
	if (dslite_res) {
		remove_proc_entry("dslite_fast_forward", dslite_res);
		dslite_res = NULL;
	}
#endif
#endif
	fast_dslite_fw = 0 ;
}
