#ifndef INCLUDE_POWERCON_H
#define INCLUDE_POWERCON_H


#if defined(POWER_CONSUMPTION_SUPPORT)

/* 92C, according to describe to measure the power consumption */
/* a. Wireless off, CPU suspend turn-on*/
#define WLAN_OFF_CPU_SUSPEND_ON_92C	450

/* b. No station link, CPU suspend turn-on*/
#define WLAN_NOLINK_CPU_SUSPEND_ON_92C	860

/* c. No station link, CPU suspend turn-off */
#define WLAN_NOLINK_CPU_SUSPEND_OFF_92C	1080

/* d. One station link,  CPU suspend turn-off */
#define WLAN_ONELINK_CPU_SUSPEND_OFF_92C	1480

/* e. MCS15, LAN to WLAN 3-pairs upload?Chariot test,  CPU suspend turn-off */
#define WLAN_MCS15_LAN_WLAN_3U_CPU_SUSPEND_OFF_92C	2100

/* f. MCS7, LAN to WLAN? 3-pairs upload?Chariot test,  CPU suspend turn-off */
#define WLAN_MCS7_LAN_WLAN_3U_CPU_SUSPEND_OFF_92C	1836

/* g. OFDM-54M, LAN to WLAN? 3-pairs upload?Chariot test,  CPU suspend turn-off*/
#define WLAN_OFDM_LAN_WLAN_3U_CPU_SUSPEND_OFF_92C	1836

/* h. CCK-11M, LAN to WLAN? 3-pairs upload?Chariot test,  CPU suspend turn-off */
#define WLAN_CCK_LAN_WLAN_3U_CPU_SUSPEND_OFF_92C	2244

/* i. Ethernet LAN ro WAN 3D3U?Chariot test,  CPU suspend turn-off */
#define LAN_WAN_3DU_CPU_SUSPEND_OFF_92C	1734

/* 88C, according to describe to measure the power consumption */
/* a. Wireless off, CPU suspend turn-on*/
#define WLAN_OFF_CPU_SUSPEND_ON_88C	410

/* b. No station link, CPU suspend turn-on*/
#define WLAN_NOLINK_CPU_SUSPEND_ON_88C	780

/* c. No station link, CPU suspend turn-off */
#define WLAN_NOLINK_CPU_SUSPEND_OFF_88C	980

/* d. One station link,  CPU suspend turn-off */
#define WLAN_ONELINK_CPU_SUSPEND_OFF_88C	1377

/* e. MCS15, LAN to WLAN 3-pairs upload?Chariot test,  CPU suspend turn-off */
#define WLAN_MCS15_LAN_WLAN_3U_CPU_SUSPEND_OFF_88C	0

/* f. MCS7, LAN to WLAN? 3-pairs upload?Chariot test,  CPU suspend turn-off */
#define WLAN_MCS7_LAN_WLAN_3U_CPU_SUSPEND_OFF_88C	1989

/* g. OFDM-54M, LAN to WLAN? 3-pairs upload?Chariot test,  CPU suspend turn-off*/
#define WLAN_OFDM_LAN_WLAN_3U_CPU_SUSPEND_OFF_88C	1632

/* h. CCK-11M, LAN to WLAN? 3-pairs upload?Chariot test,  CPU suspend turn-off */
#define WLAN_CCK_LAN_WLAN_3U_CPU_SUSPEND_OFF_88C	1887

/* i. Ethernet LAN ro WAN 3D3U?Chariot test,  CPU suspend turn-off */
#define LAN_WAN_3DU_CPU_SUSPEND_OFF_88C	1581



/* !!! DONT modify the below defined value !!! */
/* C */
#define PWRCON_PER_ETHERNET	50

/* D */
#define PWRCON_WLAN_OFF_92C	20
#define PWRCON_WLAN_OFF_88C	20

/* B=a-D */
#define PWRCON_CPU_SUSPEND_92C	(WLAN_OFF_CPU_SUSPEND_ON_92C - PWRCON_WLAN_OFF_92C)
#define PWRCON_CPU_SUSPEND_88C	(WLAN_OFF_CPU_SUSPEND_ON_88C - PWRCON_WLAN_OFF_88C)

/* E=b-B */
#define PWRCON_WLAN_NOLINK_92C	(WLAN_NOLINK_CPU_SUSPEND_ON_92C - PWRCON_CPU_SUSPEND_92C)
#define PWRCON_WLAN_NOLINK_88C	(WLAN_NOLINK_CPU_SUSPEND_ON_88C - PWRCON_CPU_SUSPEND_88C)

/* A=c-E */
#define PWRCON_CPU_NORMAL_92C	(WLAN_NOLINK_CPU_SUSPEND_OFF_92C - PWRCON_WLAN_NOLINK_92C)
#define PWRCON_CPU_NORMAL_88C	(WLAN_NOLINK_CPU_SUSPEND_OFF_88C - PWRCON_WLAN_NOLINK_88C)

/* F=d-A */
#define PWRCON_WLAN_LINK_92C	(WLAN_ONELINK_CPU_SUSPEND_OFF_92C - PWRCON_CPU_NORMAL_92C)
#define PWRCON_WLAN_LINK_88C	(WLAN_ONELINK_CPU_SUSPEND_OFF_88C - PWRCON_CPU_NORMAL_88C)

/* K=(i-A-2*C)/90% */
#define PWRCON_CPU_UTILIZATION_92C	(100*(LAN_WAN_3DU_CPU_SUSPEND_OFF_92C - WLAN_ONELINK_CPU_SUSPEND_OFF_92C - 2*PWRCON_PER_ETHERNET)/90)
#define PWRCON_CPU_UTILIZATION_88C	(100*(LAN_WAN_3DU_CPU_SUSPEND_OFF_88C - WLAN_ONELINK_CPU_SUSPEND_OFF_88C - 2*PWRCON_PER_ETHERNET)/90)

/* G=(e-A-C-F-K*50%)/95 */
#define PWRCON_WLAN_TRAFFIC_MCS8_15_92C	\
(100*(WLAN_MCS15_LAN_WLAN_3U_CPU_SUSPEND_OFF_92C - PWRCON_CPU_NORMAL_92C - PWRCON_PER_ETHERNET - \
PWRCON_WLAN_LINK_92C /*- (PWRCON_CPU_UTILIZATION_92C*50/100)*/)/95)
#define PWRCON_WLAN_TRAFFIC_MCS8_15_88C	0

/* H=(f-A-C-F-K*50%)/95 */
#define PWRCON_WLAN_TRAFFIC_MCS0_7_92C	\
(100*(WLAN_MCS7_LAN_WLAN_3U_CPU_SUSPEND_OFF_92C - PWRCON_CPU_NORMAL_92C - PWRCON_PER_ETHERNET - \
PWRCON_WLAN_LINK_92C /*- (PWRCON_CPU_UTILIZATION_92C*50)/100*/)/90)
#define PWRCON_WLAN_TRAFFIC_MCS0_7_88C	\
(100*(WLAN_MCS7_LAN_WLAN_3U_CPU_SUSPEND_OFF_88C - PWRCON_CPU_NORMAL_88C - PWRCON_PER_ETHERNET - \
PWRCON_WLAN_LINK_88C /*- (PWRCON_CPU_UTILIZATION_88C*50)/100*/)/90)

/* I=(g-A-C-F-K*50%)/25 */
#define PWRCON_WLAN_TRAFFIC_OFDM_92C	\
(100*(WLAN_OFDM_LAN_WLAN_3U_CPU_SUSPEND_OFF_92C - PWRCON_CPU_NORMAL_92C - PWRCON_PER_ETHERNET - \
PWRCON_WLAN_LINK_92C /*- (PWRCON_CPU_UTILIZATION_92C*50)/100*/)/25)
#define PWRCON_WLAN_TRAFFIC_OFDM_88C	\
(100*(WLAN_OFDM_LAN_WLAN_3U_CPU_SUSPEND_OFF_88C - PWRCON_CPU_NORMAL_88C - PWRCON_PER_ETHERNET - \
PWRCON_WLAN_LINK_88C /*- (PWRCON_CPU_UTILIZATION_88C*50)/100*/)/25)

/* J=(h-A-C-F-K*50%)/5 */
#define PWRCON_WLAN_TRAFFIC_CCK_92C	\
(100*(WLAN_CCK_LAN_WLAN_3U_CPU_SUSPEND_OFF_92C - PWRCON_CPU_NORMAL_92C - PWRCON_PER_ETHERNET - \
PWRCON_WLAN_LINK_92C /*- (PWRCON_CPU_UTILIZATION_92C*50)/100*/)/5)
#define PWRCON_WLAN_TRAFFIC_CCK_88C	\
(100*(WLAN_CCK_LAN_WLAN_3U_CPU_SUSPEND_OFF_88C - PWRCON_CPU_NORMAL_88C - PWRCON_PER_ETHERNET - \
PWRCON_WLAN_LINK_88C /*- (PWRCON_CPU_UTILIZATION_88C*50)/100*/)/5)




#define PWRCON_PER_EEE_ETHERNET_LINK_MINUS	740
#define PWRCON_PER_EEE_ETHERNET	55


#endif //#if defined(POWER_CONSUMPTION_SUPPORT)

#endif // INCLUDE_POWERCON_H
