/******************************************************************************
 *
 * Copyright(c) 2016 - 2019 Realtek Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 ******************************************************************************/

#ifndef _HALMAC_GPIO_88XX_V1_H_
#define _HALMAC_GPIO_88XX_V1_H_

#include "../halmac_api.h"
#include "../halmac_gpio_cmd.h"

#if HALMAC_88XX_V1_SUPPORT

enum halmac_ret_status
pinmux_wl_led_mode_88xx_v1(struct halmac_adapter *adapter,
			   enum halmac_wlled_mode mode);

void
pinmux_wl_led_sw_ctrl_88xx_v1(struct halmac_adapter *adapter, u8 on);

void
pinmux_sdio_int_polarity_88xx_v1(struct halmac_adapter *adapter, u8 low_active);

enum halmac_ret_status
pinmux_gpio_mode_88xx_v1(struct halmac_adapter *adapter, u8 gpio_id, u8 output);

enum halmac_ret_status
pinmux_gpio_output_88xx_v1(struct halmac_adapter *adapter, u8 gpio_id, u8 high);

enum halmac_ret_status
pinmux_pin_status_88xx_v1(struct halmac_adapter *adapter, u8 pin_id, u8 *high);

enum halmac_ret_status
pinmux_parser_88xx_v1(struct halmac_adapter *adapter,
		      const struct halmac_gpio_pimux_list *list, u32 size,
		      u32 gpio_id, u32 *cur_func);

enum halmac_ret_status
pinmux_switch_88xx_v1(struct halmac_adapter *adapter,
		      const struct halmac_gpio_pimux_list *list, u32 size,
		      u32 gpio_id, enum halmac_gpio_func gpio_func);

enum halmac_ret_status
pinmux_record_88xx_v1(struct halmac_adapter *adapter,
		      enum halmac_gpio_func gpio_func, u8 val);

#endif /* HALMAC_88XX_V1_SUPPORT */

#endif/* _HALMAC_GPIO_88XX_V1_H_ */
