/******************************************************************************
 *
 * Copyright(c) 2007 - 2017 Realtek Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * The full GNU General Public License is included in this distribution in the
 * file called LICENSE.
 *
 * Contact Information:
 * wlanfae <wlanfae@realtek.com>
 * Realtek Corporation, No. 2, Innovation Road II, Hsinchu Science Park,
 * Hsinchu 300, Taiwan.
 *
 * Larry Finger <Larry.Finger@lwfinger.net>
 *
 *****************************************************************************/

/*Image2HeaderVersion: R3 1.5.5*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8195B_SUPPORT == 1)
static boolean
check_positive(struct dm_struct *dm,
	       const u32	condition1,
	       const u32	condition2,
	       const u32	condition3,
	       const u32	condition4
)
{
	u32	cond1 = condition1, cond2 = condition2,
		cond3 = condition3, cond4 = condition4;

	u8	cut_version_for_para =
		(dm->cut_version ==  ODM_CUT_A) ? 15 : dm->cut_version;

	u8	pkg_type_for_para =
		(dm->package_type == 0) ? 15 : dm->package_type;

	u32	driver1 = cut_version_for_para << 24 |
			(dm->support_interface & 0xF0) << 16 |
			dm->support_platform << 16 |
			pkg_type_for_para << 12 |
			(dm->support_interface & 0x0F) << 8  |
			dm->rfe_type;

	u32	driver2 = (dm->type_glna & 0xFF) <<  0 |
			(dm->type_gpa & 0xFF)  <<  8 |
			(dm->type_alna & 0xFF) << 16 |
			(dm->type_apa & 0xFF)  << 24;

	u32	driver3 = 0;

	u32	driver4 = (dm->type_glna & 0xFF00) >>  8 |
			(dm->type_gpa & 0xFF00) |
			(dm->type_alna & 0xFF00) << 8 |
			(dm->type_apa & 0xFF00)  << 16;

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, cond1, cond2, cond3, cond4);
	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "===> %s (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n",
		  __func__, driver1, driver2, driver3, driver4);

	PHYDM_DBG(dm, ODM_COMP_INIT,
		  "	(Platform, Interface) = (0x%X, 0x%X)\n",
		  dm->support_platform, dm->support_interface);
	PHYDM_DBG(dm, ODM_COMP_INIT, "	(RFE, Package) = (0x%X, 0x%X)\n",
		  dm->rfe_type, dm->package_type);

	/*============== value Defined Check ===============*/
	/*cut version [27:24] need to do value check*/
	if (((cond1 & 0x0F000000) != 0) &&
	    ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return false;

	/*pkg type [15:12] need to do value check*/
	if (((cond1 & 0x0000F000) != 0) &&
	    ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return false;

	/*interface [11:8] need to do value check*/
	if (((cond1 & 0x00000F00) != 0) &&
	    ((cond1 & 0x00000F00) != (driver1 & 0x00000F00)))
		return false;
	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1 &= 0x000000FF;
	driver1 &= 0x000000FF;

	if (cond1 == driver1)
		return true;
	else
		return false;
}


/******************************************************************************
 *                           agc_tab.TXT
 ******************************************************************************/

const u32 array_mp_8195b_agc_tab[] = {
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xED000003,
		0x81C, 0xEC020003,
		0x81C, 0xEB040003,
		0x81C, 0xEA060003,
		0x81C, 0xE9080003,
		0x81C, 0xE80A0003,
		0x81C, 0xE70C0003,
		0x81C, 0xE60E0003,
		0x81C, 0xE5100003,
		0x81C, 0xE4120003,
		0x81C, 0xE3140003,
		0x81C, 0xE2160003,
		0x81C, 0xE1180003,
		0x81C, 0xE01A0003,
		0x81C, 0xEE1C0003,
		0x81C, 0xEE1E0003,
		0x81C, 0xED200003,
		0x81C, 0xEC220003,
		0x81C, 0xEB240003,
		0x81C, 0xEA260003,
	0xA0000000,	0x00000000,
		0x81C, 0xFD000003,
		0x81C, 0xFC020003,
		0x81C, 0xFB040003,
		0x81C, 0xFA060003,
		0x81C, 0xF9080003,
		0x81C, 0xF80A0003,
		0x81C, 0xF70C0003,
		0x81C, 0xF60E0003,
		0x81C, 0xF5100003,
		0x81C, 0xF4120003,
		0x81C, 0xF3140003,
		0x81C, 0xF2160003,
		0x81C, 0xF1180003,
		0x81C, 0xF01A0003,
		0x81C, 0xEF1C0003,
		0x81C, 0xEE1E0003,
		0x81C, 0xED200003,
		0x81C, 0xEC220003,
		0x81C, 0xEB240003,
		0x81C, 0xEA260003,
	0xB0000000,	0x00000000,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xCE280003,
		0x81C, 0xCD2A0003,
		0x81C, 0xCC2C0003,
		0x81C, 0xCB2E0003,
		0x81C, 0xCA300003,
		0x81C, 0xC9320003,
		0x81C, 0xC8340003,
		0x81C, 0xC7360003,
		0x81C, 0xC6380003,
		0x81C, 0xC53A0003,
		0x81C, 0xC43C0003,
		0x81C, 0xC33E0003,
		0x81C, 0xA7400003,
		0x81C, 0xA6420003,
		0x81C, 0xA5440003,
		0x81C, 0xA4460003,
		0x81C, 0xA3480003,
		0x81C, 0x6B4A0003,
		0x81C, 0x6A4C0003,
		0x81C, 0x694E0003,
		0x81C, 0x68500003,
		0x81C, 0x67520003,
		0x81C, 0x66540003,
		0x81C, 0x65560003,
		0x81C, 0x64580003,
		0x81C, 0x635A0003,
		0x81C, 0x455C0003,
		0x81C, 0x445E0003,
		0x81C, 0x43600003,
		0x81C, 0x07620003,
		0x81C, 0x06640003,
		0x81C, 0x05660003,
		0x81C, 0x04680003,
		0x81C, 0x036A0003,
		0x81C, 0x026C0003,
		0x81C, 0x016E0003,
		0x81C, 0x00700003,
		0x81C, 0x00720003,
		0x81C, 0x00740003,
		0x81C, 0x00760003,
		0x81C, 0x00780003,
		0x81C, 0x007A0003,
		0x81C, 0x007C0003,
		0x81C, 0x007E0003,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xCD280003,
		0x81C, 0xCC2A0003,
		0x81C, 0xCB2C0003,
		0x81C, 0xCA2E0003,
		0x81C, 0xC9300003,
		0x81C, 0xC8320003,
		0x81C, 0xC7340003,
		0x81C, 0xC6360003,
		0x81C, 0xC5380003,
		0x81C, 0xC43A0003,
		0x81C, 0xC33C0003,
		0x81C, 0xA73E0003,
		0x81C, 0xA6400003,
		0x81C, 0xA5420003,
		0x81C, 0xA4440003,
		0x81C, 0xA3460003,
		0x81C, 0x6B480003,
		0x81C, 0x6A4A0003,
		0x81C, 0x694C0003,
		0x81C, 0x684E0003,
		0x81C, 0x67500003,
		0x81C, 0x66520003,
		0x81C, 0x65540003,
		0x81C, 0x64560003,
		0x81C, 0x63580003,
		0x81C, 0x475A0003,
		0x81C, 0x465C0003,
		0x81C, 0x455E0003,
		0x81C, 0x44600003,
		0x81C, 0x43620003,
		0x81C, 0x08640003,
		0x81C, 0x07660003,
		0x81C, 0x06680003,
		0x81C, 0x056A0003,
		0x81C, 0x046C0003,
		0x81C, 0x036E0003,
		0x81C, 0x03700003,
		0x81C, 0x03720003,
		0x81C, 0x03740003,
		0x81C, 0x03760003,
		0x81C, 0x03780003,
		0x81C, 0x037A0003,
		0x81C, 0x037C0003,
		0x81C, 0x037E0003,
	0xA0000000,	0x00000000,
		0x81C, 0xCE280003,
		0x81C, 0xCD2A0003,
		0x81C, 0xCC2C0003,
		0x81C, 0xCB2E0003,
		0x81C, 0xCA300003,
		0x81C, 0xC9320003,
		0x81C, 0xC8340003,
		0x81C, 0xC7360003,
		0x81C, 0xC6380003,
		0x81C, 0xC53A0003,
		0x81C, 0xC43C0003,
		0x81C, 0xC33E0003,
		0x81C, 0xA7400003,
		0x81C, 0xA6420003,
		0x81C, 0xA5440003,
		0x81C, 0xA4460003,
		0x81C, 0xA3480003,
		0x81C, 0x6B4A0003,
		0x81C, 0x6A4C0003,
		0x81C, 0x694E0003,
		0x81C, 0x68500003,
		0x81C, 0x67520003,
		0x81C, 0x66540003,
		0x81C, 0x65560003,
		0x81C, 0x64580003,
		0x81C, 0x635A0003,
		0x81C, 0x455C0003,
		0x81C, 0x445E0003,
		0x81C, 0x43600003,
		0x81C, 0x07620003,
		0x81C, 0x06640003,
		0x81C, 0x05660003,
		0x81C, 0x04680003,
		0x81C, 0x036A0003,
		0x81C, 0x026C0003,
		0x81C, 0x016E0003,
		0x81C, 0x00700003,
		0x81C, 0x00720003,
		0x81C, 0x00740003,
		0x81C, 0x00760003,
		0x81C, 0x00780003,
		0x81C, 0x007A0003,
		0x81C, 0x007C0003,
		0x81C, 0x007E0003,
	0xB0000000,	0x00000000,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xED000103,
		0x81C, 0xEC020103,
		0x81C, 0xEB040103,
		0x81C, 0xEA060103,
		0x81C, 0xE9080103,
		0x81C, 0xE80A0103,
		0x81C, 0xE70C0103,
		0x81C, 0xE60E0103,
		0x81C, 0xE5100103,
		0x81C, 0xE4120103,
		0x81C, 0xE3140103,
		0x81C, 0xE2160103,
		0x81C, 0xE1180103,
		0x81C, 0xE01A0103,
		0x81C, 0xEE1C0103,
		0x81C, 0xEE1E0103,
		0x81C, 0xED200103,
		0x81C, 0xEC220103,
		0x81C, 0xEB240103,
		0x81C, 0xEA260103,
		0x81C, 0xE9280103,
		0x81C, 0xE82A0103,
		0x81C, 0xCE2C0103,
		0x81C, 0xCD2E0103,
		0x81C, 0xCC300103,
		0x81C, 0xCB320103,
		0x81C, 0xCA340103,
		0x81C, 0xC9360103,
		0x81C, 0xC8380103,
		0x81C, 0xC73A0103,
		0x81C, 0xAA3C0103,
		0x81C, 0xA93E0103,
		0x81C, 0xA8400103,
		0x81C, 0xA7420103,
		0x81C, 0xA6440103,
		0x81C, 0xA5460103,
		0x81C, 0x87480103,
		0x81C, 0x864A0103,
		0x81C, 0x854C0103,
		0x81C, 0x844E0103,
		0x81C, 0x83500103,
		0x81C, 0x68520103,
		0x81C, 0x67540103,
		0x81C, 0x66560103,
		0x81C, 0x65580103,
		0x81C, 0x645A0103,
		0x81C, 0x635C0103,
		0x81C, 0x475E0103,
		0x81C, 0x46600103,
		0x81C, 0x45620103,
		0x81C, 0x44640103,
		0x81C, 0x43660103,
		0x81C, 0x27680103,
		0x81C, 0x266A0103,
		0x81C, 0x256C0103,
		0x81C, 0x246E0103,
		0x81C, 0x23700103,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000103,
		0x81C, 0xFE020103,
		0x81C, 0xFD040103,
		0x81C, 0xFC060103,
		0x81C, 0xFB080103,
		0x81C, 0xFA0A0103,
		0x81C, 0xF90C0103,
		0x81C, 0xF80E0103,
		0x81C, 0xF7100103,
		0x81C, 0xF6120103,
		0x81C, 0xF5140103,
		0x81C, 0xF4160103,
		0x81C, 0xF3180103,
		0x81C, 0xF21A0103,
		0x81C, 0xF11C0103,
		0x81C, 0xF01E0103,
		0x81C, 0xEF200103,
		0x81C, 0xEE220103,
		0x81C, 0xED240103,
		0x81C, 0xEC260103,
		0x81C, 0xEB280103,
		0x81C, 0xEA2A0103,
		0x81C, 0xCD2C0103,
		0x81C, 0xCC2E0103,
		0x81C, 0xCB300103,
		0x81C, 0xCA320103,
		0x81C, 0xC9340103,
		0x81C, 0xC8360103,
		0x81C, 0xC7380103,
		0x81C, 0xC63A0103,
		0x81C, 0xC53C0103,
		0x81C, 0xA93E0103,
		0x81C, 0xA8400103,
		0x81C, 0xA7420103,
		0x81C, 0xA6440103,
		0x81C, 0xA5460103,
		0x81C, 0x87480103,
		0x81C, 0x864A0103,
		0x81C, 0x854C0103,
		0x81C, 0x844E0103,
		0x81C, 0x83500103,
		0x81C, 0x68520103,
		0x81C, 0x67540103,
		0x81C, 0x66560103,
		0x81C, 0x65580103,
		0x81C, 0x645A0103,
		0x81C, 0x635C0103,
		0x81C, 0x485E0103,
		0x81C, 0x47600103,
		0x81C, 0x46620103,
		0x81C, 0x45640103,
		0x81C, 0x44660103,
		0x81C, 0x43680103,
		0x81C, 0x276A0103,
		0x81C, 0x266C0103,
		0x81C, 0x256E0103,
		0x81C, 0x24700103,
	0xA0000000,	0x00000000,
		0x81C, 0xFD000103,
		0x81C, 0xFC020103,
		0x81C, 0xFB040103,
		0x81C, 0xFA060103,
		0x81C, 0xF9080103,
		0x81C, 0xF80A0103,
		0x81C, 0xF70C0103,
		0x81C, 0xF60E0103,
		0x81C, 0xF5100103,
		0x81C, 0xF4120103,
		0x81C, 0xF3140103,
		0x81C, 0xF2160103,
		0x81C, 0xF1180103,
		0x81C, 0xF01A0103,
		0x81C, 0xEF1C0103,
		0x81C, 0xEE1E0103,
		0x81C, 0xED200103,
		0x81C, 0xEC220103,
		0x81C, 0xEB240103,
		0x81C, 0xEA260103,
		0x81C, 0xE9280103,
		0x81C, 0xE82A0103,
		0x81C, 0xCE2C0103,
		0x81C, 0xCD2E0103,
		0x81C, 0xCC300103,
		0x81C, 0xCB320103,
		0x81C, 0xCA340103,
		0x81C, 0xC9360103,
		0x81C, 0xC8380103,
		0x81C, 0xC73A0103,
		0x81C, 0xAA3C0103,
		0x81C, 0xA93E0103,
		0x81C, 0xA8400103,
		0x81C, 0xA7420103,
		0x81C, 0xA6440103,
		0x81C, 0xA5460103,
		0x81C, 0x87480103,
		0x81C, 0x864A0103,
		0x81C, 0x854C0103,
		0x81C, 0x844E0103,
		0x81C, 0x83500103,
		0x81C, 0x68520103,
		0x81C, 0x67540103,
		0x81C, 0x66560103,
		0x81C, 0x65580103,
		0x81C, 0x645A0103,
		0x81C, 0x635C0103,
		0x81C, 0x475E0103,
		0x81C, 0x46600103,
		0x81C, 0x45620103,
		0x81C, 0x44640103,
		0x81C, 0x43660103,
		0x81C, 0x27680103,
		0x81C, 0x266A0103,
		0x81C, 0x256C0103,
		0x81C, 0x246E0103,
		0x81C, 0x23700103,
	0xB0000000,	0x00000000,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0x23720103,
		0x81C, 0x23740103,
		0x81C, 0x23760103,
		0x81C, 0x23780103,
		0x81C, 0x237A0103,
		0x81C, 0x237C0103,
		0x81C, 0x237E0103,
	0xA0000000,	0x00000000,
		0x81C, 0x23720103,
		0x81C, 0x23740103,
		0x81C, 0x23760103,
		0x81C, 0x23780103,
		0x81C, 0x237A0103,
		0x81C, 0x237C0103,
		0x81C, 0x237E0103,
	0xB0000000,	0x00000000,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xED000203,
		0x81C, 0xEC020203,
		0x81C, 0xEB040203,
		0x81C, 0xEA060203,
		0x81C, 0xE9080203,
		0x81C, 0xE80A0203,
		0x81C, 0xE70C0203,
		0x81C, 0xE60E0203,
		0x81C, 0xE5100203,
		0x81C, 0xE4120203,
		0x81C, 0xE3140203,
		0x81C, 0xE2160203,
		0x81C, 0xE1180203,
		0x81C, 0xE01A0203,
		0x81C, 0xEE1C0203,
		0x81C, 0xEE1E0203,
		0x81C, 0xED200203,
		0x81C, 0xEC220203,
		0x81C, 0xEB240203,
		0x81C, 0xEA260203,
		0x81C, 0xE9280203,
		0x81C, 0xCE2A0203,
		0x81C, 0xCD2C0203,
		0x81C, 0xCC2E0203,
		0x81C, 0xCB300203,
		0x81C, 0xCA320203,
		0x81C, 0xC9340203,
		0x81C, 0xC8360203,
		0x81C, 0xC7380203,
		0x81C, 0xC63A0203,
		0x81C, 0xC53C0203,
		0x81C, 0xC43E0203,
		0x81C, 0xC3400203,
		0x81C, 0xA7420203,
		0x81C, 0xA6440203,
		0x81C, 0xA5460203,
		0x81C, 0xA4480203,
		0x81C, 0xA34A0203,
		0x81C, 0x854C0203,
		0x81C, 0x844E0203,
		0x81C, 0x83500203,
		0x81C, 0x68520203,
		0x81C, 0x67540203,
		0x81C, 0x66560203,
		0x81C, 0x65580203,
		0x81C, 0x645A0203,
		0x81C, 0x635C0203,
		0x81C, 0x475E0203,
		0x81C, 0x46600203,
		0x81C, 0x45620203,
		0x81C, 0x44640203,
		0x81C, 0x43660203,
		0x81C, 0x27680203,
		0x81C, 0x266A0203,
		0x81C, 0x256C0203,
		0x81C, 0x246E0203,
		0x81C, 0x23700203,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFF000203,
		0x81C, 0xFF020203,
		0x81C, 0xFE040203,
		0x81C, 0xFD060203,
		0x81C, 0xFC080203,
		0x81C, 0xFB0A0203,
		0x81C, 0xFA0C0203,
		0x81C, 0xF90E0203,
		0x81C, 0xF8100203,
		0x81C, 0xF7120203,
		0x81C, 0xF6140203,
		0x81C, 0xF5160203,
		0x81C, 0xF4180203,
		0x81C, 0xF31A0203,
		0x81C, 0xF21C0203,
		0x81C, 0xF11E0203,
		0x81C, 0xF0200203,
		0x81C, 0xEF220203,
		0x81C, 0xEE240203,
		0x81C, 0xED260203,
		0x81C, 0xEC280203,
		0x81C, 0xEB2A0203,
		0x81C, 0xEA2C0203,
		0x81C, 0xE92E0203,
		0x81C, 0xE8300203,
		0x81C, 0xCB320203,
		0x81C, 0xCA340203,
		0x81C, 0xC9360203,
		0x81C, 0xC8380203,
		0x81C, 0xC73A0203,
		0x81C, 0xC63C0203,
		0x81C, 0xC53E0203,
		0x81C, 0xC4400203,
		0x81C, 0xC3420203,
		0x81C, 0xA6440203,
		0x81C, 0xA5460203,
		0x81C, 0xA4480203,
		0x81C, 0xA34A0203,
		0x81C, 0x854C0203,
		0x81C, 0x844E0203,
		0x81C, 0x83500203,
		0x81C, 0x69520203,
		0x81C, 0x68540203,
		0x81C, 0x67560203,
		0x81C, 0x66580203,
		0x81C, 0x655A0203,
		0x81C, 0x645C0203,
		0x81C, 0x635E0203,
		0x81C, 0x47600203,
		0x81C, 0x46620203,
		0x81C, 0x45640203,
		0x81C, 0x44660203,
		0x81C, 0x43680203,
		0x81C, 0x276A0203,
		0x81C, 0x266C0203,
		0x81C, 0x256E0203,
		0x81C, 0x24700203,
	0xA0000000,	0x00000000,
		0x81C, 0xFD000203,
		0x81C, 0xFC020203,
		0x81C, 0xFB040203,
		0x81C, 0xFA060203,
		0x81C, 0xF9080203,
		0x81C, 0xF80A0203,
		0x81C, 0xF70C0203,
		0x81C, 0xF60E0203,
		0x81C, 0xF5100203,
		0x81C, 0xF4120203,
		0x81C, 0xF3140203,
		0x81C, 0xF2160203,
		0x81C, 0xF1180203,
		0x81C, 0xF01A0203,
		0x81C, 0xEF1C0203,
		0x81C, 0xEE1E0203,
		0x81C, 0xED200203,
		0x81C, 0xEC220203,
		0x81C, 0xEB240203,
		0x81C, 0xEA260203,
		0x81C, 0xE9280203,
		0x81C, 0xCE2A0203,
		0x81C, 0xCD2C0203,
		0x81C, 0xCC2E0203,
		0x81C, 0xCB300203,
		0x81C, 0xCA320203,
		0x81C, 0xC9340203,
		0x81C, 0xC8360203,
		0x81C, 0xC7380203,
		0x81C, 0xC63A0203,
		0x81C, 0xC53C0203,
		0x81C, 0xC43E0203,
		0x81C, 0xC3400203,
		0x81C, 0xA7420203,
		0x81C, 0xA6440203,
		0x81C, 0xA5460203,
		0x81C, 0xA4480203,
		0x81C, 0xA34A0203,
		0x81C, 0x854C0203,
		0x81C, 0x844E0203,
		0x81C, 0x83500203,
		0x81C, 0x68520203,
		0x81C, 0x67540203,
		0x81C, 0x66560203,
		0x81C, 0x65580203,
		0x81C, 0x645A0203,
		0x81C, 0x635C0203,
		0x81C, 0x475E0203,
		0x81C, 0x46600203,
		0x81C, 0x45620203,
		0x81C, 0x44640203,
		0x81C, 0x43660203,
		0x81C, 0x27680203,
		0x81C, 0x266A0203,
		0x81C, 0x256C0203,
		0x81C, 0x246E0203,
		0x81C, 0x23700203,
	0xB0000000,	0x00000000,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0x23720203,
		0x81C, 0x23740203,
		0x81C, 0x23760203,
		0x81C, 0x23780203,
		0x81C, 0x237A0203,
		0x81C, 0x237C0203,
		0x81C, 0x237E0203,
	0xA0000000,	0x00000000,
		0x81C, 0x23720203,
		0x81C, 0x23740203,
		0x81C, 0x23760203,
		0x81C, 0x23780203,
		0x81C, 0x237A0203,
		0x81C, 0x237C0203,
		0x81C, 0x237E0203,
	0xB0000000,	0x00000000,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xEB000303,
		0x81C, 0xEA020303,
		0x81C, 0xE9040303,
		0x81C, 0xE8060303,
		0x81C, 0xE7080303,
		0x81C, 0xE60A0303,
		0x81C, 0xE50C0303,
		0x81C, 0xE40E0303,
		0x81C, 0xE3100303,
		0x81C, 0xE2120303,
		0x81C, 0xE1140303,
		0x81C, 0xE0160303,
		0x81C, 0xEE180303,
		0x81C, 0xEE1A0303,
		0x81C, 0xED1C0303,
		0x81C, 0xEC1E0303,
		0x81C, 0xEB200303,
		0x81C, 0xEA220303,
		0x81C, 0xE9240303,
		0x81C, 0xE8260303,
		0x81C, 0xE7280303,
		0x81C, 0xE62A0303,
		0x81C, 0xCD2C0303,
		0x81C, 0xCC2E0303,
		0x81C, 0xCB300303,
		0x81C, 0xCA320303,
		0x81C, 0xC9340303,
		0x81C, 0xC8360303,
		0x81C, 0xC7380303,
		0x81C, 0xC63A0303,
		0x81C, 0xC53C0303,
		0x81C, 0xC43E0303,
		0x81C, 0xC3400303,
		0x81C, 0xA7420303,
		0x81C, 0xA6440303,
		0x81C, 0xA5460303,
		0x81C, 0xA4480303,
		0x81C, 0xA34A0303,
		0x81C, 0x864C0303,
		0x81C, 0x854E0303,
		0x81C, 0x84500303,
		0x81C, 0x83520303,
		0x81C, 0x66540303,
		0x81C, 0x65560303,
		0x81C, 0x64580303,
		0x81C, 0x635A0303,
		0x81C, 0x485C0303,
		0x81C, 0x475E0303,
		0x81C, 0x46600303,
		0x81C, 0x45620303,
		0x81C, 0x44640303,
		0x81C, 0x43660303,
		0x81C, 0x27680303,
	0x90001000,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xFE000303,
		0x81C, 0xFD020303,
		0x81C, 0xFC040303,
		0x81C, 0xFB060303,
		0x81C, 0xFA080303,
		0x81C, 0xF90A0303,
		0x81C, 0xF80C0303,
		0x81C, 0xF70E0303,
		0x81C, 0xF6100303,
		0x81C, 0xF5120303,
		0x81C, 0xF4140303,
		0x81C, 0xF3160303,
		0x81C, 0xF2180303,
		0x81C, 0xF11A0303,
		0x81C, 0xF01C0303,
		0x81C, 0xEF1E0303,
		0x81C, 0xEE200303,
		0x81C, 0xED220303,
		0x81C, 0xEC240303,
		0x81C, 0xEB260303,
		0x81C, 0xEA280303,
		0x81C, 0xE92A0303,
		0x81C, 0xE82C0303,
		0x81C, 0xE72E0303,
		0x81C, 0xE6300303,
		0x81C, 0xE5320303,
		0x81C, 0xE4340303,
		0x81C, 0xE3360303,
		0x81C, 0xC7380303,
		0x81C, 0xC63A0303,
		0x81C, 0xC53C0303,
		0x81C, 0xC43E0303,
		0x81C, 0xC3400303,
		0x81C, 0xA7420303,
		0x81C, 0xA6440303,
		0x81C, 0xA5460303,
		0x81C, 0x88480303,
		0x81C, 0x874A0303,
		0x81C, 0x864C0303,
		0x81C, 0x854E0303,
		0x81C, 0x84500303,
		0x81C, 0x83520303,
		0x81C, 0x67540303,
		0x81C, 0x66560303,
		0x81C, 0x65580303,
		0x81C, 0x645A0303,
		0x81C, 0x635C0303,
		0x81C, 0x485E0303,
		0x81C, 0x47600303,
		0x81C, 0x46620303,
		0x81C, 0x45640303,
		0x81C, 0x44660303,
		0x81C, 0x43680303,
	0xA0000000,	0x00000000,
		0x81C, 0xFB000303,
		0x81C, 0xFA020303,
		0x81C, 0xF9040303,
		0x81C, 0xF8060303,
		0x81C, 0xF7080303,
		0x81C, 0xF60A0303,
		0x81C, 0xF50C0303,
		0x81C, 0xF40E0303,
		0x81C, 0xF3100303,
		0x81C, 0xF2120303,
		0x81C, 0xF1140303,
		0x81C, 0xF0160303,
		0x81C, 0xEF180303,
		0x81C, 0xEE1A0303,
		0x81C, 0xED1C0303,
		0x81C, 0xEC1E0303,
		0x81C, 0xEB200303,
		0x81C, 0xEA220303,
		0x81C, 0xE9240303,
		0x81C, 0xE8260303,
		0x81C, 0xE7280303,
		0x81C, 0xE62A0303,
		0x81C, 0xCD2C0303,
		0x81C, 0xCC2E0303,
		0x81C, 0xCB300303,
		0x81C, 0xCA320303,
		0x81C, 0xC9340303,
		0x81C, 0xC8360303,
		0x81C, 0xC7380303,
		0x81C, 0xC63A0303,
		0x81C, 0xC53C0303,
		0x81C, 0xC43E0303,
		0x81C, 0xC3400303,
		0x81C, 0xA7420303,
		0x81C, 0xA6440303,
		0x81C, 0xA5460303,
		0x81C, 0xA4480303,
		0x81C, 0xA34A0303,
		0x81C, 0x864C0303,
		0x81C, 0x854E0303,
		0x81C, 0x84500303,
		0x81C, 0x83520303,
		0x81C, 0x66540303,
		0x81C, 0x65560303,
		0x81C, 0x64580303,
		0x81C, 0x635A0303,
		0x81C, 0x485C0303,
		0x81C, 0x475E0303,
		0x81C, 0x46600303,
		0x81C, 0x45620303,
		0x81C, 0x44640303,
		0x81C, 0x43660303,
		0x81C, 0x27680303,
	0xB0000000,	0x00000000,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0x266A0303,
		0x81C, 0x256C0303,
		0x81C, 0x246E0303,
		0x81C, 0x23700303,
		0x81C, 0x23720303,
		0x81C, 0x23740303,
		0x81C, 0x23760303,
		0x81C, 0x23780303,
		0x81C, 0x237A0303,
		0x81C, 0x237C0303,
		0x81C, 0x237E0303,
	0xA0000000,	0x00000000,
		0x81C, 0x266A0303,
		0x81C, 0x256C0303,
		0x81C, 0x246E0303,
		0x81C, 0x23700303,
		0x81C, 0x23720303,
		0x81C, 0x23740303,
		0x81C, 0x23760303,
		0x81C, 0x23780303,
		0x81C, 0x237A0303,
		0x81C, 0x237C0303,
		0x81C, 0x237E0303,
	0xB0000000,	0x00000000,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0x81C, 0xEE000803,
		0x81C, 0xEE020803,
		0x81C, 0xED040803,
		0x81C, 0xEC060803,
		0x81C, 0xEB080803,
		0x81C, 0xEA0A0803,
		0x81C, 0xE90C0803,
		0x81C, 0xE80E0803,
		0x81C, 0xE7100803,
		0x81C, 0xE6120803,
		0x81C, 0xE5140803,
		0x81C, 0xE4160803,
		0x81C, 0xE3180803,
		0x81C, 0xE21A0803,
		0x81C, 0xE11C0803,
		0x81C, 0xE01E0803,
		0x81C, 0xEE200803,
		0x81C, 0xEE220803,
		0x81C, 0xED240803,
		0x81C, 0xEC260803,
		0x81C, 0xCE280803,
		0x81C, 0xCE2A0803,
		0x81C, 0xCD2C0803,
		0x81C, 0xCC2E0803,
		0x81C, 0xCB300803,
		0x81C, 0xCA320803,
		0x81C, 0xC9340803,
		0x81C, 0xC8360803,
		0x81C, 0xC7380803,
		0x81C, 0xC63A0803,
		0x81C, 0xC53C0803,
		0x81C, 0xA93E0803,
		0x81C, 0xC3400803,
		0x81C, 0x8A420803,
		0x81C, 0x89440803,
		0x81C, 0x88460803,
		0x81C, 0x87480803,
		0x81C, 0x864A0803,
		0x81C, 0x854C0803,
		0x81C, 0x694E0803,
		0x81C, 0x83500803,
		0x81C, 0x82520803,
		0x81C, 0x49540803,
		0x81C, 0x48560803,
		0x81C, 0x47580803,
		0x81C, 0x465A0803,
		0x81C, 0x455C0803,
		0x81C, 0x445E0803,
		0x81C, 0x43600803,
		0x81C, 0x42620803,
		0x81C, 0x41640803,
		0x81C, 0x25660803,
		0x81C, 0x24680803,
		0x81C, 0x236A0803,
		0x81C, 0x226C0803,
		0x81C, 0x216E0803,
		0x81C, 0x06700803,
		0x81C, 0x05720803,
		0x81C, 0x04740803,
		0x81C, 0x03760803,
		0x81C, 0x02780803,
		0x81C, 0x017A0803,
		0x81C, 0x017C0803,
		0x81C, 0x017E0803,
	0xA0000000,	0x00000000,
		0x81C, 0xFF000803,
		0x81C, 0xFE020803,
		0x81C, 0xFD040803,
		0x81C, 0xFC060803,
		0x81C, 0xFB080803,
		0x81C, 0xFA0A0803,
		0x81C, 0xF90C0803,
		0x81C, 0xF80E0803,
		0x81C, 0xF7100803,
		0x81C, 0xF6120803,
		0x81C, 0xF5140803,
		0x81C, 0xF4160803,
		0x81C, 0xF3180803,
		0x81C, 0xF21A0803,
		0x81C, 0xF11C0803,
		0x81C, 0xF01E0803,
		0x81C, 0xEF200803,
		0x81C, 0xEE220803,
		0x81C, 0xED240803,
		0x81C, 0xEC260803,
		0x81C, 0xCF280803,
		0x81C, 0xCE2A0803,
		0x81C, 0xCD2C0803,
		0x81C, 0xCC2E0803,
		0x81C, 0xCB300803,
		0x81C, 0xCA320803,
		0x81C, 0xC9340803,
		0x81C, 0xC8360803,
		0x81C, 0xC7380803,
		0x81C, 0xC63A0803,
		0x81C, 0xC53C0803,
		0x81C, 0xA93E0803,
		0x81C, 0xC3400803,
		0x81C, 0x8A420803,
		0x81C, 0x89440803,
		0x81C, 0x88460803,
		0x81C, 0x87480803,
		0x81C, 0x864A0803,
		0x81C, 0x854C0803,
		0x81C, 0x694E0803,
		0x81C, 0x83500803,
		0x81C, 0x82520803,
		0x81C, 0x49540803,
		0x81C, 0x48560803,
		0x81C, 0x47580803,
		0x81C, 0x465A0803,
		0x81C, 0x455C0803,
		0x81C, 0x445E0803,
		0x81C, 0x43600803,
		0x81C, 0x42620803,
		0x81C, 0x41640803,
		0x81C, 0x25660803,
		0x81C, 0x24680803,
		0x81C, 0x236A0803,
		0x81C, 0x226C0803,
		0x81C, 0x216E0803,
		0x81C, 0x06700803,
		0x81C, 0x05720803,
		0x81C, 0x04740803,
		0x81C, 0x03760803,
		0x81C, 0x02780803,
		0x81C, 0x017A0803,
		0x81C, 0x017C0803,
		0x81C, 0x017E0803,
	0xB0000000,	0x00000000,
	0x8000f002,	0x00000000,	0x40000000,	0x00000000,
		0xC50, 0x00000022,
		0xC50, 0x00000020,
	0xA0000000,	0x00000000,
		0xC50, 0x00000022,
		0xC50, 0x00000020,
	0xB0000000,	0x00000000,

};

void
odm_read_and_config_mp_8195b_agc_tab(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8195b_agc_tab) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8195b_agc_tab;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_agc_8195b(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8195b_agc_tab(void)
{
		return 46;
}

/******************************************************************************
 *                           phy_reg.TXT
 ******************************************************************************/

const u32 array_mp_8195b_phy_reg[] = {
		0x800, 0x9020D010,
		0x804, 0x00018180,
		0x808, 0x34028211,
		0x80C, 0x13D10011,
		0x810, 0x21101222,
		0x814, 0x020C3D10,
		0x818, 0x84A10385,
		0x81C, 0x1E1E081F,
		0x820, 0x0001AAAA,
		0x824, 0x00030FE0,
		0x828, 0x0000CCCC,
		0x82C, 0x77CB7010,
		0x830, 0x7998AAAA,
		0x834, 0x072E698A,
		0x838, 0x87768561,
		0x83C, 0x9194B2B8,
		0x840, 0x171740E0,
		0x844, 0x4D3D7CDB,
		0x848, 0x4AD0408B,
		0x84C, 0x6AFBF7A5,
		0x850, 0x28A74706,
		0x854, 0x0001520C,
		0x858, 0x4060C000,
		0x85C, 0x74011D60,
		0x860, 0x68A7C321,
		0x864, 0x79F27032,
		0x868, 0x8CA7A314,
		0x86C, 0x558C2878,
		0x870, 0x55555555,
		0x874, 0x27612C2E,
		0x878, 0xC0003152,
		0x87C, 0x5C8FC000,
		0x880, 0x00000000,
		0x884, 0x00000000,
		0x888, 0x00000000,
		0x88C, 0x00000000,
		0x890, 0x00000000,
		0x894, 0x00000000,
		0x898, 0x00000000,
		0x89C, 0x00000000,
		0x8A0, 0x00000013,
		0x8A4, 0x7F7F7F7F,
		0x8A8, 0x2202033E,
		0x8AC, 0xF00F000A,
		0x8B0, 0x00000600,
		0x8B4, 0x000FC080,
		0x8B8, 0xEC0057FF,
		0x8BC, 0x2CB520A3,
		0x8C0, 0xFFE04020,
		0x8C4, 0x47C00000,
		0x8C8, 0x00025165,
		0x8CC, 0x08108492,
		0x8D0, 0x0000B800,
		0x8D4, 0x860308A0,
		0x8D8, 0x39085612,
		0x8DC, 0x00000000,
		0x8E0, 0x32D16777,
		0x8E4, 0x49092925,
		0x8E8, 0xFFFFC42C,
		0x8EC, 0x99999999,
		0x8F0, 0x00009999,
		0x8F4, 0x00D80FA1,
		0x8F8, 0x400000C0,
		0x8FC, 0x00000200,
		0x900, 0x00C00000,
		0x904, 0x0FFF0FFF,
		0x908, 0x00000000,
		0x90C, 0x1B000400,
		0x910, 0x00002C00,
		0x914, 0xC6380000,
		0x918, 0x1C1028C0,
		0x91C, 0x64B11A1C,
		0x920, 0xE0767233,
		0x924, 0x855A2500,
		0x928, 0x4AB0E4E4,
		0x92C, 0xFFFEB200,
		0x930, 0xFFFFFFFE,
		0x934, 0x001FFFFF,
		0x938, 0x00008480,
		0x93C, 0xE41C0642,
		0x940, 0x0E470430,
		0x944, 0x00000000,
		0x948, 0xAC000000,
		0x94C, 0x10000083,
		0x950, 0x82010080,
		0x954, 0x86510080,
		0x958, 0x00000181,
		0x95C, 0x04248000,
		0x960, 0x00E00000,
		0x964, 0x00600000,
		0x968, 0x00200000,
		0x96C, 0x00400000,
		0x970, 0x00001FFF,
		0x974, 0x04000FFF,
		0x978, 0x00000000,
		0x97C, 0x00000000,
		0x980, 0x00000000,
		0x984, 0x00000000,
		0x988, 0x00000000,
		0x98C, 0x33440000,
		0x990, 0x27100000,
		0x994, 0x4C480100,
		0x998, 0xFFFFFF5C,
		0x99C, 0x403C3834,
		0x9A0, 0x00000044,
		0x9A4, 0x80000088,
		0x9A8, 0x0C2F0000,
		0x9AC, 0x02560000,
		0x9B0, 0x70008000,
		0x9B4, 0x00000000,
		0x9B8, 0x00000000,
		0x9BC, 0x00000000,
		0x9C0, 0x00000000,
		0x9C4, 0x00000000,
		0x9C8, 0x00000000,
		0x9CC, 0x00000000,
		0x9D0, 0x00000000,
		0x9D4, 0x00000000,
		0x9D8, 0x00000000,
		0x9DC, 0x00000000,
		0x9E0, 0x00000000,
		0x9E4, 0x02000402,
		0x9E8, 0x000022D4,
		0x9EC, 0x00000000,
		0x9F0, 0x00000400,
		0x9F4, 0x15A00000,
		0x9F8, 0x00000000,
		0x9FC, 0xEFFFF7FF,
		0xA00, 0x00D040C8,
		0xA04, 0x80FF800C,
		0xA08, 0x9C838300,
		0xA0C, 0x297E000F,
		0xA10, 0x9500BB78,
		0xA14, 0x1114D028,
		0xA18, 0x00881117,
		0xA1C, 0x89140F00,
		0xA20, 0x00000000,
		0xA24, 0x88F03454,
		0xA28, 0x0000908C,
		0xA2C, 0x00D20000,
		0xA70, 0x101FBF00,
		0xA74, 0x00000147,
		0xA78, 0x00008900,
		0xA7C, 0x225B0606,
		0xA80, 0x21807532,
		0xA84, 0x80100000,
		0xA88, 0x048C0000,
		0xA8C, 0x12345678,
		0xA90, 0xABCDEF00,
		0xA94, 0x001B1B89,
		0xA98, 0x00FF0000,
		0xA9C, 0x3F000000,
		0xAA0, 0x00000000,
		0xAA4, 0x00080000,
	0x80001000,	0x00000000,	0x40000000,	0x00000000,
		0xAA8, 0xEAD00004,
	0xA0000000,	0x00000000,
		0xAA8, 0xEAD20004,
	0xB0000000,	0x00000000,
		0xAAC, 0x01235677,
		0xAB0, 0x00000000,
		0xABC, 0x00000000,
		0xB00, 0xE3000440,
		0xB04, 0x00800000,
		0xB08, 0xFF02030B,
		0xB0C, 0x11EAA406,
		0xB10, 0x00030690,
		0xB14, 0x006000FA,
		0xB18, 0x00000002,
		0xB1C, 0x00000002,
		0xB20, 0x4B00001F,
		0xB24, 0x4E8E3E40,
		0xB28, 0x03020100,
		0xB2C, 0x07060504,
		0xB30, 0x0B0A0908,
		0xB34, 0x0F0E0D0C,
		0xB38, 0x13121110,
		0xB3C, 0x0000003A,
		0xB40, 0x00000000,
		0xB44, 0x80000000,
		0xB48, 0x3F0000FA,
		0xB4C, 0x88C80020,
		0xB50, 0x00000000,
		0xB54, 0x00004241,
		0xB58, 0xE0008208,
		0xB5C, 0x41EFFFF9,
		0xB60, 0x00000000,
		0xB64, 0x00200063,
		0xB68, 0x0000003A,
		0xB6C, 0x00000102,
		0xB70, 0x4E6D1870,
		0xB74, 0x03020100,
		0xB78, 0x07060504,
		0xB7C, 0x0B0A0908,
		0xB80, 0x0F0E0D0C,
		0xB84, 0x13121110,
		0xB88, 0x00000000,
		0xB8C, 0x00000000,
		0xC00, 0x00000007,
		0xC04, 0x03010020,
		0xC08, 0x60403231,
		0xC0C, 0x00012345,
		0xC10, 0x00000100,
		0xC14, 0x01000000,
		0xC18, 0x00000000,
		0xC1C, 0x40000053,
		0xC20, 0x400503A3,
		0xC24, 0x0B4A70DA,
		0xC28, 0x00000000,
		0xC2C, 0x00000000,
		0xC30, 0x00000000,
		0xC34, 0x00000000,
		0xC38, 0x00000000,
		0xC3C, 0x00000000,
		0xC40, 0x00000000,
		0xC44, 0x00000000,
		0xC48, 0x00000000,
		0xC4C, 0x00000000,
		0xC50, 0x00000020,
		0xC54, 0x00000000,
		0xC58, 0xD8020402,
		0xC5C, 0xDE000120,
		0xC68, 0x0000003F,
		0xC6C, 0x0000122A,
		0xC70, 0x00000000,
		0xC74, 0x00000000,
		0xC78, 0x00000000,
		0xC7C, 0x00000000,
		0xC80, 0x00000000,
		0xC84, 0x00000000,
		0xC88, 0x00000000,
		0xC8C, 0x07000000,
		0xC94, 0x01000100,
		0xC98, 0x201C8000,
		0xC9C, 0x00000000,
		0xCA0, 0x0000A555,
		0xCA4, 0x08040201,
		0xCA8, 0x80402010,
		0xCAC, 0x00000000,
		0xCB0, 0x77775747,
		0xCB4, 0x10000077,
		0xCB8, 0x00000000,
		0xCBC, 0x00000000,
		0xCC0, 0x00000000,
		0xCC4, 0x00000000,
		0xCC8, 0x00000000,
		0xCCC, 0x00000000,
		0xCD0, 0x00000000,
		0xCD4, 0x00000000,
		0xCD8, 0x00000000,
		0xCDC, 0x00000000,
		0xCE0, 0x00000000,
		0xCE4, 0x00000000,
		0xCE8, 0x00000000,
		0xCEC, 0x00000000,
		0xE00, 0x00000000,
		0xE04, 0x00000000,
		0xE08, 0x00000000,
		0xE0C, 0x00000000,
		0xE10, 0x00000000,
		0xE14, 0x00000000,
		0xE18, 0x00000000,
		0xE1C, 0x00000000,
		0xE20, 0x00000000,
		0xE24, 0x00000000,
		0xE28, 0x00000000,
		0xE2C, 0x00000000,
		0xE30, 0x00000000,
		0xE34, 0x00000000,
		0xE38, 0x00000000,
		0xE3C, 0x00000000,
		0xE40, 0x00000000,
		0xE44, 0x00000000,
		0xE48, 0x00000000,
		0xE4C, 0x00000000,
		0xE50, 0x00000000,
		0xE54, 0x00000000,
		0xE58, 0x00000000,
		0xE5C, 0x00000000,
		0xE68, 0x00000000,
		0xE6C, 0x00000000,
		0xE70, 0x00000000,
		0xE74, 0x00000000,
		0xE78, 0x00000000,
		0xE7C, 0x00000000,
		0xE80, 0x00000000,
		0xE84, 0x00000000,
		0xE88, 0x00000000,
		0xE8C, 0x00000000,
		0xE94, 0x00000000,
		0xE98, 0x00000000,
		0xE9C, 0x00000000,
		0xEA0, 0x00000000,
		0xEA4, 0x00000000,
		0xEA8, 0x00000000,
		0xEAC, 0x00000000,
		0xEB0, 0x00000000,
		0xEB4, 0x00000000,
		0xEB8, 0x00000000,
		0xEBC, 0x00000000,
		0xEC0, 0x00000000,
		0xEC4, 0x00000000,
		0xEC8, 0x00000000,
		0xECC, 0x00000000,
		0xED0, 0x00000000,
		0xED4, 0x00000000,
		0xED8, 0x00000000,
		0xEDC, 0x00000000,
		0xEE0, 0x00000000,
		0xEE4, 0x00000000,
		0xEE8, 0x00000000,
		0xEEC, 0x00000000,
		0x1900, 0x00000000,
		0x1904, 0x00238000,
		0x1908, 0x00000000,
		0x190C, 0x00000000,
		0x1910, 0x00001800,
		0x1914, 0x00000000,
		0x1918, 0x00000000,
		0x191C, 0x00000000,
		0x1920, 0x00000000,
		0x1924, 0x00000000,
		0x1928, 0x00000000,
		0x192C, 0x00000000,
		0x1930, 0x00000000,
		0x1934, 0x00000000,
		0x1938, 0x00000000,
		0x193C, 0x00000000,
		0x1940, 0x00000000,
		0x1944, 0x00000000,
		0x1948, 0x00000000,
		0x194C, 0x00000000,
		0x1950, 0x00000000,
		0x1954, 0x00000000,
		0x1958, 0x00000000,
		0x195C, 0x00000000,
		0x1960, 0x00000000,
		0x1964, 0x00000000,
		0x1968, 0x00000000,
		0x196C, 0x00000000,
		0x1970, 0x00000000,
		0x1974, 0x00000000,
		0x1978, 0x00000000,
		0x197C, 0x00000000,
		0x1980, 0x00000000,
		0x1984, 0x03000000,
		0x1988, 0x21401E88,
		0x198C, 0x00004000,
		0x1990, 0x00000000,
		0x1994, 0x00000000,
		0x1998, 0x00000053,
		0x199C, 0x00000000,
		0x19A0, 0x00000000,
		0x19A4, 0x00000000,
		0x19A8, 0x010A0000,
		0x19AC, 0x0E47E47F,
		0x19B0, 0x00000000,
		0x19B4, 0x0E47E47F,
		0x19B8, 0x00000000,
		0x19BC, 0x00000000,
		0x19C0, 0x00000000,
		0x19C4, 0x00000000,
		0x19C8, 0x00000000,
		0x19CC, 0x00000000,
		0x19D0, 0x00000000,
		0x19D4, 0x77777777,
		0x19D8, 0x00000777,
		0x19DC, 0x133E0F37,
		0x19E0, 0x00000000,
		0x19E4, 0x00000000,
		0x19E8, 0x00000000,
		0x19EC, 0x00000000,
		0x19F0, 0x00000000,
		0x19F4, 0x00000000,
		0x19F8, 0x01A00000,
		0x19FC, 0x00000000,
		0x1C00, 0x00000100,
		0x1C04, 0x01000000,
		0x1C08, 0x00000100,
		0x1C0C, 0x01000000,
		0x1C10, 0x00000100,
		0x1C14, 0x01000000,
		0x1C18, 0x00000100,
		0x1C1C, 0x01000000,
		0x1C20, 0x00000100,
		0x1C24, 0x01000000,
		0x1C28, 0x00000100,
		0x1C2C, 0x01000000,
		0x1C30, 0x00000100,
		0x1C34, 0x01000000,
		0x1C38, 0x00000000,
		0x1C3C, 0x00008000,
		0x1C40, 0x000C0100,
		0x1C44, 0xA34000F3,
		0x1C48, 0x1A8249A8,
		0x1C4C, 0x1461C826,
		0x1C50, 0x0001469E,
		0x1C54, 0x58D158D1,
		0x1C58, 0x04490088,
		0x1C5C, 0x1C004400,
		0x1C60, 0xBF550000,
		0x1C64, 0x04004400,
		0x1C68, 0x0B7B7B75,
		0x1C6C, 0x01000000,
		0x1C70, 0x00A08145,
		0x1C74, 0x2080E0E0,
		0x1C78, 0x00000000,
		0x1C7C, 0x00000010,
		0x1C80, 0x00000100,
		0x1C84, 0x01000000,
		0x1C88, 0x00000100,
		0x1C8C, 0x01000000,
		0x1C90, 0x00000100,
		0x1C94, 0x01000000,
		0x1C98, 0x00000100,
		0x1C9C, 0x01000000,
		0x1CA0, 0x00000100,
		0x1CA4, 0x01000000,
		0x1CA8, 0x00000100,
		0x1CAC, 0x01000000,
		0x1CB0, 0x00000100,
		0x1CB4, 0x01000000,
		0x1CB8, 0x00000000,
		0x1CBC, 0x00000000,
		0x1CC0, 0xA0C63100,
		0x1CC4, 0x00308000,
		0x1CC8, 0x5B74B6E9,
		0x1CCC, 0x01000000,
		0x1CD0, 0x00000400,
		0x1CD4, 0x00000000,
		0x1CD8, 0x01B8ADEB,
		0x1CDC, 0x01000000,
		0x1CE0, 0x00030003,
		0x1CE4, 0x4E4A0306,
		0x1CE8, 0x00000100,
		0x1CEC, 0x01000000,
		0x1CF0, 0x00000100,
		0x1CF4, 0x01000000,
		0x1CF8, 0x01B8ADEB,
		0x1CFC, 0x00000000,
		0x034, 0xC10AA254,
		0xC58, 0xE4012C92,
		0xC5C, 0xF05E0002,
		0xC6C, 0x00000003,
		0xC60, 0x70000000,
		0xC60, 0x70070040,
		0xC60, 0x70180040,
		0xC60, 0x70280040,
		0xC60, 0x70380040,
		0xC60, 0x70480040,
		0xC60, 0x70570040,
		0xC60, 0x70680040,
		0xC60, 0x70770040,
		0xC60, 0x70870040,
		0xC60, 0x70970040,
		0xC60, 0x70A70040,
		0xC60, 0x70B70040,
		0xC60, 0x70C00040,
		0xC60, 0x70D00040,
		0xC60, 0x70E00340,
		0xC60, 0x70F00040,

};

void
odm_read_and_config_mp_8195b_phy_reg(struct dm_struct *dm)
{
	u32	i = 0;
	u8	c_cond;
	boolean	is_matched = true, is_skipped = false;
	u32	array_len =
			sizeof(array_mp_8195b_phy_reg) / sizeof(u32);
	u32	*array = (u32 *)array_mp_8195b_phy_reg;

	u32	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;
	u32	a1 = 0, a2 = 0, a3 = 0, a4 = 0;

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	while ((i + 1) < array_len) {
		v1 = array[i];
		v2 = array[i + 1];

		if (v1 & (BIT(31) | BIT(30))) {/*positive & negative condition*/
			if (v1 & BIT(31)) {/* positive condition*/
				c_cond  =
					(u8)((v1 & (BIT(29) | BIT(28))) >> 28);
				if (c_cond == COND_ENDIF) {/*end*/
					is_matched = true;
					is_skipped = false;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ENDIF\n");
				} else if (c_cond == COND_ELSE) { /*else*/
					is_matched = is_skipped ? false : true;
					PHYDM_DBG(dm, ODM_COMP_INIT, "ELSE\n");
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					PHYDM_DBG(dm, ODM_COMP_INIT,
						  "IF or ELSE IF\n");
				}
			} else if (v1 & BIT(30)) { /*negative condition*/
				if (!is_skipped) {
					a1 = pre_v1; a2 = pre_v2;
					a3 = v1; a4 = v2;
					if (check_positive(dm,
							   a1, a2, a3, a4)) {
						is_matched = true;
						is_skipped = true;
					} else {
						is_matched = false;
						is_skipped = false;
					}
				} else {
					is_matched = false;
				}
			}
		} else {
			if (is_matched)
				odm_config_bb_phy_8195b(dm, v1, MASKDWORD, v2);
		}
		i = i + 2;
	}
}

u32
odm_get_version_mp_8195b_phy_reg(void)
{
		return 46;
}

/******************************************************************************
 *                           phy_reg_pg.TXT
 ******************************************************************************/

#ifdef CONFIG_8195B
_WEAK const u32 array_mp_8195b_phy_reg_pg[] = {
	0, 0, 0, 0x00000c20, 0xffffffff, 0x34363840,
	0, 0, 0, 0x00000c24, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000c28, 0xffffffff, 0x30323436,
	0, 0, 0, 0x00000c2c, 0xffffffff, 0x34363638,
	0, 0, 0, 0x00000c30, 0xffffffff, 0x28303234,
	0, 0, 0, 0x00000c3c, 0xffffffff, 0x36383838,
	0, 0, 0, 0x00000c40, 0xffffffff, 0x28303234,
	0, 0, 0, 0x00000c44, 0xffffffff, 0x24242426,
	1, 0, 0, 0x00000c24, 0xffffffff, 0x36363636,
	1, 0, 0, 0x00000c28, 0xffffffff, 0x28303234,
	1, 0, 0, 0x00000c2c, 0xffffffff, 0x34363636,
	1, 0, 0, 0x00000c30, 0xffffffff, 0x26283032,
	1, 0, 0, 0x00000c3c, 0xffffffff, 0x34363636,
	1, 0, 0, 0x00000c40, 0xffffffff, 0x26283032,
	1, 0, 0, 0x00000c44, 0xffffffff, 0x22222224
};

#endif

void
odm_read_and_config_mp_8195b_phy_reg_pg(struct dm_struct *dm)
{
#ifdef CONFIG_8195B

	u32 i = 0;
	u32 array_len =
		 sizeof(array_mp_8195b_phy_reg_pg) / sizeof(u32);
	u32 *array = (u32 *)array_mp_8195b_phy_reg_pg;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	void	*adapter = dm->adapter;
	HAL_DATA_TYPE	*hal_data = GET_HAL_DATA(((PADAPTER)adapter));

	odm_memory_set(dm, hal_data->BufOfLinesPwrByRate, 0,
		       MAX_LINES_HWCONFIG_TXT *
		       MAX_BYTES_LINE_HWCONFIG_TXT);
	hal_data->nLinesReadPwrByRate = array_len / 6;
#endif

	PHYDM_DBG(dm, ODM_COMP_INIT, "===> %s\n", __func__);

	dm->phy_reg_pg_version = 1;
	dm->phy_reg_pg_value_type = PHY_REG_PG_EXACT_VALUE;

	for (i = 0; i < array_len; i += 6) {
		u32	v1 = array[i];
		u32	v2 = array[i + 1];
		u32	v3 = array[i + 2];
		u32	v4 = array[i + 3];
		u32	v5 = array[i + 4];
		u32	v6 = array[i + 5];

		odm_config_bb_phy_reg_pg_8195b(dm, v1, v2, v3, v4, v5, v6);

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	rsprintf((char *)hal_data->BufOfLinesPwrByRate[i / 6], 100,
		 "%s, %s, %s, 0x%X, 0x%08X, 0x%08X,",
		 (v1 == 0 ? "2.4G" : "  5G"), (v2 == 0 ? "A" : "B"),
		 (v3 == 0 ? "1Tx" : "2Tx"), v4, v5, v6);
#endif
	}
#endif
}

#endif /* end of HWIMG_SUPPORT*/

