/*
 * smp sync procfs
 * wait cpu sync
 *  echo 1 > /proc/smp_sync
 * no wait cpu sync
 *  echo 0 > /proc/smp_sync
 */
#include <linux/rcupdate.h>
#include <linux/rculist.h>
#include <linux/kernel.h>
#include <linux/export.h>
#include <linux/percpu.h>
#include <linux/init.h>
#include <linux/gfp.h>
#include <linux/smp.h>
#include <linux/cpu.h>
#include <linux/proc_fs.h>
#include <linux/seq_file.h>
#include <asm/uaccess.h>

#define SMP_SYNC_DEBUG 0

static void smp_sync_callback(void *arg)
{
#if SMP_SYNC_DEBUG > 0
	printk("%s:%d cpu %d\n", __func__, __LINE__, smp_processor_id());
#endif	/* SMP_SYNC_DEBUG */
}

static int smp_sync_proc_show(struct seq_file *m, void *v)
{
	return 0;
}

static int smp_sync_proc_open(struct inode *inode, struct file *file)
{
	return single_open(file, smp_sync_proc_show, NULL);
}

static ssize_t write_smp_sync(
	int type, struct file *file, const char __user *buffer, size_t count, loff_t *pos)
{
	int wait;
	char s[32];
	int len;

	len = (count > (sizeof(s) - 1)) ? sizeof(s) - 1 : count;
	s[len] = '\0';
	if ((buffer == NULL) || (copy_from_user(s, buffer, len) != 0))
		return -EINVAL;
	wait = 1;					/* default */
	if (sscanf(s, "%d", &wait) != 1)
		wait = 1;				/* default */
	smp_call_function(smp_sync_callback, NULL, wait);
	return count;
}

static ssize_t smp_sync_proc_write(
	struct file *file, const char __user *buffer, size_t count, loff_t *pos)
{
	return write_smp_sync(0, file, buffer, count, pos);
}

static const struct file_operations smp_sync_proc_fops = {
	.open		= smp_sync_proc_open,
	.read		= seq_read,
	.llseek		= seq_lseek,
	.release	= single_release,
	.write		= smp_sync_proc_write,
};

static int __init proc_smp_sync_init(void)
{
	/* create /proc/smp_sync */
	proc_create("smp_sync", 0, NULL, &smp_sync_proc_fops);
	return 0;
}
module_init(proc_smp_sync_init);
