/*
 * arpping.c
 *
 * Mostly stolen from: dhcpcd - DHCP client daemon
 * by Yoichi Hariguchi <yoichi@fore.com>
 */

#include <sys/types.h>
#include <sys/time.h>
#include <time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/if_ether.h>
#include <net/if_arp.h>
#include <netinet/in.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
/* WNC-MR0000-JOE-PENG-20130107-Implement auto subnet function */
//#ifdef KERNEL_3_10
#include <linux/sysinfo.h>
//#endif
//#ifdef KERNEL_2_6_30
//#include <sys/sysinfo.h>
//#endif

#include "dhcpd.h"
#include "debug.h"
#include "arpping.h"

//#ifdef SEND_GRATUITOUS_ARP
#include "dhcpc.h"
//#endif


/* args:	yiaddr - what IP to ping
 *		ip - our ip
 *		mac - our arp address
 *		interface - interface to use
 * retn: 	1 addr free
 *		0 addr used
 *		-1 error 
 */  

/* FIXME: match response against chaddr */
int arpping(u_int32_t yiaddr, u_int32_t ip, unsigned char *mac, char *interface, char *ret_hwaddr)
{

	int	timeout = 2;
	int 	optval = 1;
	int	s;			/* socket */
	int	rv = 1;			/* return value */
	struct sockaddr addr;		/* for interface name */
	struct arpMsg	arp;
	fd_set		fdset;
	struct timeval	tm;
	/* WNC-MR0000-JOE-PENG-20130107-Implement auto subnet function-->start */
	//time_t		prevTime;
	int		prevTime=0;
	struct sysinfo system_info;
	/* WNC-MR0000-JOE-PENG-20130107-Implement auto subnet function-->end */

	if ((s = socket (PF_PACKET, SOCK_PACKET, htons(ETH_P_ARP))) == -1) {
		LOG(LOG_ERR, "Could not open raw socket");
		return -1;
	}
	
	if (setsockopt(s, SOL_SOCKET, SO_BROADCAST, &optval, sizeof(optval)) == -1) {
		LOG(LOG_ERR, "Could not setsocketopt on raw socket");
		close(s);
		return -1;
	}

	/* send arp request */
	memset(&arp, 0, sizeof(arp));
	memcpy(arp.ethhdr.h_dest, MAC_BCAST_ADDR, 6);	/* MAC DA */
	memcpy(arp.ethhdr.h_source, mac, 6);		/* MAC SA */
	arp.ethhdr.h_proto = htons(ETH_P_ARP);		/* protocol type (Ethernet) */
	arp.htype = htons(ARPHRD_ETHER);		/* hardware type */
	arp.ptype = htons(ETH_P_IP);			/* protocol type (ARP message) */
	arp.hlen = 6;					/* hardware address length */
	arp.plen = 4;					/* protocol address length */
	arp.operation = htons(ARPOP_REQUEST);		/* ARP op code */
	memcpy(arp.sInaddr, &ip, sizeof(ip));		/* source IP address */
	memcpy(arp.sHaddr, mac, 6);			/* source hardware address */
	memcpy(arp.tInaddr, &yiaddr, sizeof(yiaddr));	/* target IP address */
	
	memset(&addr, 0, sizeof(addr));
	strcpy(addr.sa_data, interface);
	if (sendto(s, &arp, sizeof(arp), 0, &addr, sizeof(addr)) < 0)
		rv = 0;
	
	/* wait arp reply, and check it */
	tm.tv_usec = 0;

/* WNC-MR0000-JOE-PENG-20130107-Implement auto subnet function-->start */
#if 1
	/* Original timer use system time, we want to use system uptime instead. */
	sysinfo(&system_info);
	prevTime = (int) system_info.uptime;
#else
	time(&prevTime);
#endif
/* WNC-MR0000-JOE-PENG-20130107-Implement auto subnet function-->end */

	while (timeout > 0) {
		FD_ZERO(&fdset);
		FD_SET(s, &fdset);
		tm.tv_sec = timeout;
		if (select(s + 1, &fdset, (fd_set *) NULL, (fd_set *) NULL, &tm) < 0) {
			DEBUG(LOG_ERR, "Error on ARPING request: %s", strerror(errno));
			if (errno != EINTR) rv = 0;
		} else if (FD_ISSET(s, &fdset)) {
			if (recv(s, &arp, sizeof(arp), 0) < 0 ) rv = 0;
/* WNC-MR0000-JOE-PENG-20130411-Modify for Win 7 IOT issue (Destination MAC address in ARP reply of Win7 are all zero) */
//			if (arp.operation == htons(ARPOP_REPLY) && 
//			    bcmp(arp.tHaddr, mac, 6) == 0 && 
//			    *((u_int *) arp.sInaddr) == yiaddr) {
			if (arp.operation == htons(ARPOP_REPLY) && 
			    *((u_int *) arp.sInaddr) == yiaddr) {
				memcpy(ret_hwaddr,arp.sHaddr,6);
				DEBUG(LOG_INFO, "Valid arp reply receved for this address");
				rv = 0;
				break;
			}
		}

/* WNC-MR0000-JOE-PENG-20130107-Implement auto subnet function-->start */
#if 1
		/* Original timer use system time, we want to use system uptime instead. */
		/* Here we we calculate remaining time for waiting. */
		{
			int	tempCurrentTime = 0;

			sysinfo(&system_info);
			tempCurrentTime = (int) system_info.uptime;

			timeout = timeout - (tempCurrentTime - prevTime);

			sysinfo(&system_info);
			prevTime = (int) system_info.uptime;
		}
#else
		timeout -= time(NULL) - prevTime;
		time(&prevTime);
#endif
/* WNC-MR0000-JOE-PENG-20130107-Implement auto subnet function-->end */
	}
	close(s);
	DEBUG(LOG_INFO, "%salid arp replies for this address", rv ? "No v" : "V");	 
	return rv;
}

#ifdef SEND_GRATUITOUS_ARP
int sendArpPack(unsigned char *mac, u_int32_t srcIp, u_int32_t targetIp)
{
	int 	optval = 1;
	int s;			/* socket */
	int rv = 0; 		/* return value */
	struct sockaddr addr;		/* for interface name */
	struct arpMsg	arp;

	if ((s = socket (PF_PACKET, SOCK_PACKET, htons(ETH_P_ARP))) == -1) {
		LOG(LOG_ERR, "Could not open raw socket");
		return -1;
	}

	if (setsockopt(s, SOL_SOCKET, SO_BROADCAST, &optval, sizeof(optval)) == -1) {
		LOG(LOG_ERR, "Could not setsocketopt on raw socket");
		close(s);
		return -1;
	}

	/* send arp request */
	memset(&arp, 0, sizeof(arp));
	memcpy(arp.ethhdr.h_dest, MAC_BCAST_ADDR, 6);	/* MAC DA */
	memcpy(arp.ethhdr.h_source, mac, 6);		/* MAC SA */
	arp.ethhdr.h_proto = htons(ETH_P_ARP);		/* protocol type (Ethernet) */
	arp.htype = htons(ARPHRD_ETHER);		/* hardware type */
	arp.ptype = htons(ETH_P_IP);			/* protocol type (ARP message) */
	arp.hlen = 6;					/* hardware address length */
	arp.plen = 4;					/* protocol address length */
	arp.operation = htons(ARPOP_REQUEST);		/* ARP op code */
	memcpy(arp.sInaddr, &srcIp, sizeof(srcIp));		/* source IP address */
	memcpy(arp.sHaddr, mac, 6); 		/* source hardware address */
	memcpy(arp.tInaddr, &targetIp, sizeof(targetIp));	/* target IP address */
	
	memset(&addr, 0, sizeof(addr));
	strcpy(addr.sa_data, client_config.interface);//interface);
	if (sendto(s, &arp, sizeof(arp)-sizeof(arp.pad), 0, &addr, sizeof(addr)) < 0)
		rv = -1;

	close(s);
	return rv;
}
#endif

