/*
 * FILE NAME rtl_gpio.c
 *
 * BRIEF MODULE DESCRIPTION
 *  GPIO For Flash Reload Default
 *
 *  Author: jimmylin@realtek.com.tw
 *
 *  Copyright (c) 2011 Realtek Semiconductor Corp.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 */


#include <generated/autoconf.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/interrupt.h>
#include <asm/errno.h>
#include <asm/io.h>
#include <asm/uaccess.h>
#include <linux/miscdevice.h>
#include <linux/pci.h>
#include <linux/delay.h>
#include <linux/slab.h>
#include <linux/sched.h>
#include <linux/init.h>
#include <linux/types.h>
#include <linux/reboot.h>
#include <linux/kmod.h>
#include <linux/proc_fs.h>
#include  "bspchip.h"

#include <linux/seq_file.h>

//#define CONFIG_USING_JTAG 1
#define AUTO_CONFIG

//WNC-JDR230-YUAN-I-CHOU-20140421, Add LED control function
#define RL_GPIO_LED_FREQ (HZ/10)
#define RL_GPIO_NUMBER 17

#define RL_GPIO_LED_LOW_ACT		1
#define RL_GPIO_LED_INFINITY	4000

typedef struct {
	int gpio;				//gpio number
	unsigned int on;		//interval of led on
	unsigned int off;		//interval of led off
	unsigned int blinks;		//number of blinking cycles
	unsigned int rests;		//number of break cycles
	unsigned int times;		//blinking times
} rl_gpio_led_info;

struct rl_gpio_led_status_t {
	int ticks;
	unsigned int ons;
	unsigned int offs;
	unsigned int resting;
	unsigned int times;
} rl_gpio_led_stat[RL_GPIO_NUMBER];

struct timer_list rl_gpio_led_timer;
rl_gpio_led_info rl_gpio_led_data[RL_GPIO_NUMBER];

//WNC-D2R230-NMR1752-YUAN-I-CHOU-20170110, Trigger WPS End LED after 10 seconds from WPS Success LED triggered.
struct timer_list wps_over_timer;
static void wps_over_do_timer(unsigned long unused);
//WNC-D2R230-NMR1752-YUAN-I-CHOU-20170110, Trigger WPS End LED after 10 seconds from WPS Success LED triggered End.

//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support
struct timer_list rl_skip_led_LOS_timer; // 3 minutes timer
int led_LOS_mode = 0;	//MIB information
int skip_LOS_mode = 1;	//Skip led_LOS_mode, turn ON all LED
int cencel_LOS_mode = 0;	//cancel led_LOS_mode flag
extern void rtl8192_led_force_off (int wlan_index, int state);	//Wireless LED function
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support End
extern int rl_gpio_led_set(rl_gpio_led_info led);
extern void rl_gpio_led_init_timer(void);
//WNC-JDR230-YUAN-I-CHOU-20140421, Add LED control function End

/*
enabled immediate mode pbc ; must enabled "USE_INTERRUPT_GPIO" and "IMMEDIATE_PBC"
gpio will rx pbc event and trigger wscd by signal method
note:also need enabled IMMEDIATE_PBC at wsc.h (sdk/users/wsc/src/)
*/
//#define USE_INTERRUPT_GPIO	//undefine USE_INTERRUPT_GPIO
//#define IMMEDIATE_PBC 

#ifdef IMMEDIATE_PBC
int	wscd_pid = 0;
struct pid *wscd_pid_Ptr=NULL;
#endif


#if defined(CONFIG_RTL_8198C) 
	////ori////#include "drivers/net/rtl819x/AsicDriver/rtl865xc_asicregs.h"
	#include "../net/rtl819x/AsicDriver/rtl865xc_asicregs.h"

#if 0
/*dummy api for porting*/
void RTL_BSP_GPIO_write(unsigned int gpio_num, unsigned int value)
{
    printk("this is dummy api , when api in bsp ready : use new api\n");
}
#endif
#if  defined(CONFIG_RTL_8198CD)

	// GPIO H5
	#define RESET_PIN_IOBASE    PEFGH_CNR 	
	#define RESET_PIN_DIRBASE   PEFGH_DIR 
	#define RESET_PIN_DATABASE  PEFGH_DAT
	#define RESET_PIN_NO 29 /*number of the EFGH*/
	// GPIO H7
	#define RESET_LED_IOBASE    PEFGH_CNR 	
	#define RESET_LED_DIRBASE   PEFGH_DIR	 
	#define RESET_LED_DATABASE  PEFGH_DAT 
	#define RESET_LED_NO 24+7 /*number of the EFGH*/
	// GPIO H7
	#define AUTOCFG_LED_IOBASE      PEFGH_CNR 	
	#define AUTOCFG_LED_DIRBASE     PEFGH_DIR	 
	#define AUTOCFG_LED_DATABASE    PEFGH_DAT 
	#define AUTOCFG_LED_NO 24+7 /*number of the EFGH*/
	// GPIO H6
	#define AUTOCFG_PIN_IOBASE      PEFGH_CNR 	
	#define AUTOCFG_PIN_DIRBASE     PEFGH_DIR	 
	#define AUTOCFG_PIN_DATABASE    PEFGH_DAT 
	#define AUTOCFG_PIN_NO 30 /*number of the EFGH)*/
   
	#define AUTOCFG_PIN_IMR PGH_IMR    
	#define AUTOCFG_BTN_PIN         AUTOCFG_PIN_NO
	#define AUTOCFG_LED_PIN         AUTOCFG_LED_NO
	#define RESET_LED_PIN           RESET_LED_NO
	#define RESET_BTN_PIN           RESET_PIN_NO
		
#ifdef USE_INTERRUPT_GPIO
	#define GPIO_IRQ_ABCD_NUM		26		
	#define GPIO_IRQ_EFGH_NUM		27
	#define GPIO_IRQ_NUM	     	27
#endif
	#define RTL_GPIO_MUX    0xB8000100
    #define RTL_GPIO_MUX2   0xB8000104
    #define RTL_GPIO_MUX3   0xB8000108 
    #define RTL_GPIO_MUX4   0xB800010C
    #define RTL_GPIO_MUX5   0xB8000110
    /*if 8198C demo board need to modify default mux sel value then ebable below*/
    //#define RTL_GPIO_MUX_DATA 0x00340C00//for WIFI ON/OFF and GPIO
	////#define RTL_GPIO_WIFI_ONOFF     19
	#define RTL_GPIO_PCIE_RESET_MUX	(3<<10)
	#define RTL_GPIO_RESET_BTN_MUX	(3<<23)
	#define RTL_GPIO_MUX4_DATA		( RTL_GPIO_PCIE_RESET_MUX | RTL_GPIO_RESET_BTN_MUX)

	 #define RTL_GPIO_SYS_LED_MUX    (3<<14)
	#define RTL_GPIO_WPS_BTN_MUX	(3<<0)
	#define RTL_GPIO_MUX5_DATA		(RTL_GPIO_WPS_BTN_MUX | RTL_GPIO_SYS_LED_MUX)

#else
//WNC-JDR230-YUAN-I-CHOU-20140421, Modify GPIO
#if 0
	// GPIO H5
	#define RESET_PIN_IOBASE    PEFGH_CNR 	
	#define RESET_PIN_DIRBASE   PEFGH_DIR 
	#define RESET_PIN_DATABASE  PEFGH_DAT
	#define RESET_PIN_NO 29 /*number of the EFGH*/
	// GPIO G0
	#define RESET_LED_IOBASE    PEFGH_CNR 	
	#define RESET_LED_DIRBASE   PEFGH_DIR	 
	#define RESET_LED_DATABASE  PEFGH_DAT 
	#define RESET_LED_NO 7+24 /*number of the EFGH*/
	// GPIO G0
	#define AUTOCFG_LED_IOBASE      PEFGH_CNR 	
	#define AUTOCFG_LED_DIRBASE     PEFGH_DIR	 
	#define AUTOCFG_LED_DATABASE    PEFGH_DAT 
	#define AUTOCFG_LED_NO 7+24 /*number of the EFGH*/
	// GPIO H6
	#define AUTOCFG_PIN_IOBASE      PEFGH_CNR 	
	#define AUTOCFG_PIN_DIRBASE     PEFGH_DIR	 
	#define AUTOCFG_PIN_DATABASE    PEFGH_DAT 
	#define AUTOCFG_PIN_NO 30 /*number of the EFGH)*/
   
	#define AUTOCFG_PIN_IMR PGH_IMR    
	#define AUTOCFG_BTN_PIN         AUTOCFG_PIN_NO
	#define AUTOCFG_LED_PIN         AUTOCFG_LED_NO
	#define RESET_LED_PIN           RESET_LED_NO
	#define RESET_BTN_PIN           RESET_PIN_NO
		
#ifdef USE_INTERRUPT_GPIO
	#define GPIO_IRQ_ABCD_NUM		26		
	#define GPIO_IRQ_EFGH_NUM		27
	#define GPIO_IRQ_NUM	     	27
#endif
	#define RTL_GPIO_MUX    0xB8000100
    #define RTL_GPIO_MUX2   0xB8000104
    #define RTL_GPIO_MUX3   0xB8000108 
    #define RTL_GPIO_MUX4   0xB800010C
    #define RTL_GPIO_MUX5   0xB8000110
    /*if 8198C demo board need to modify default mux sel value then ebable below*/
    //#define RTL_GPIO_MUX_DATA 0x00340C00//for WIFI ON/OFF and GPIO
	////#define RTL_GPIO_WIFI_ONOFF     19
	#define RTL_GPIO_SYS_LED_MUX	(3<<7)
	#define RTL_GPIO_PCIE_RESET_MUX	(3<<10)
	#define RTL_GPIO_RESET_BTN_MUX	(3<<23)
	#define RTL_GPIO_MUX4_DATA		(RTL_GPIO_SYS_LED_MUX | RTL_GPIO_PCIE_RESET_MUX | RTL_GPIO_RESET_BTN_MUX)

	
        #define RTL_GPIO_SYS_LED_MUX    (3<<14)
        #define RTL_GPIO_WPS_BTN_MUX    (3<<0)
        #define RTL_GPIO_MUX5_DATA              (RTL_GPIO_WPS_BTN_MUX | RTL_GPIO_SYS_LED_MUX)

#else
//Linear use here !
	//#define RESET_PIN_IOBASE    PEFGH_CNR 	
	//#define RESET_PIN_DIRBASE   PEFGH_DIR 
	#define RESET_PIN_DATABASE  PABCD_DAT
	#define RESET_PIN_NO 30 /*number of the ABCD (GPIO D6)*/

	//#define AUTOCFG_PIN_IOBASE      PEFGH_CNR 	
	//#define AUTOCFG_PIN_DIRBASE     PEFGH_DIR	 
	#define AUTOCFG_PIN_DATABASE    PEFGH_DAT 
	#define AUTOCFG_PIN_NO 30 /*number of the EFGH (GPIO H6)*/

	//#define AUTOCFG_PIN_IMR PGH_IMR    
	#define AUTOCFG_BTN_PIN         AUTOCFG_PIN_NO
	//#define AUTOCFG_LED_PIN         AUTOCFG_LED_NO
	//#define RESET_LED_PIN           RESET_LED_NO
	#define RESET_BTN_PIN           RESET_PIN_NO

	#define RTL_GPIOA1 (1<<1)
	#define RTL_GPIOB7 (1<<15)
	#define RTL_GPIOC0 (1<<16)
	#define RTL_GPIOC7 (1<<23)
	#define RTL_GPIOD6 (1<<30)
	#define RTL_GPIOE0 (1<<0)
	#define RTL_GPIOE7 (1<<7)
	#define RTL_GPIOF0 (1<<8)
	#define RTL_GPIOF1 (1<<9)
	#define RTL_GPIOG0 (1<<16)
	#define RTL_GPIOG1 (1<<17)
	#define RTL_GPIOG2 (1<<18)
	#define RTL_GPIOH0 (1<<24)
	#define RTL_GPIOH1 (1<<25)
	#define RTL_GPIOH2 (1<<26)
	#define RTL_GPIOH3 (1<<27)
	#define RTL_GPIOH4 (1<<28)
	#define RTL_GPIOH5 (1<<29)
	#define RTL_GPIOH6 (1<<30)
	#define RTL_GPIOH7 (1<<31)

	#define RTL_GPIO_MUX    0xB8000100
    #define RTL_GPIO_MUX2   0xB8000104
    #define RTL_GPIO_MUX3   0xB8000108 
    #define RTL_GPIO_MUX4   0xB800010C
    #define RTL_GPIO_MUX5   0xB8000110
    /*if 8198C demo board need to modify default mux sel value then ebable below*/
    //#define RTL_GPIO_MUX_DATA 0x00340C00//for WIFI ON/OFF and GPIO
	////#define RTL_GPIO_WIFI_ONOFF     19
	#define RTL_GPIO_PCIE_RESET_MUX	(3<<10)
	#define RTL_GPIO_RESET_BTN_MUX	(3<<23)
	#define RTL_GPIO_MUX4_DATA		( RTL_GPIO_PCIE_RESET_MUX | RTL_GPIO_RESET_BTN_MUX)

	#define RTL_GPIO_SYS_LED_MUX    (3<<14)
	#define RTL_GPIO_WPS_BTN_MUX	(3<<0)
	#define RTL_GPIO_MUX5_DATA		(RTL_GPIO_WPS_BTN_MUX | RTL_GPIO_SYS_LED_MUX)
#endif
//WNC-JDR230-YUAN-I-CHOU-20140421, Modify GPIO
#endif	
	
#endif // CONFIG_RTL_8198C



///////////////////////////////////////////////////////
#define PROBE_TIME	5
#define PROBE_NULL		0
#define PROBE_ACTIVE	1
#define PROBE_RESET		2
#define PROBE_RELOAD	3
#define RTL_R32(addr)		(*(volatile unsigned long *)(addr))
//WNC-JDR230-MRXXXX-Jimmy-20160804, Add to write register correctly
//#define RTL_W32(addr, l)	((*(volatile unsigned long*)(addr)) = (l))
#define RTL_W32(addr, l)		\
do {						\
	((*(volatile unsigned long*)(addr)) = (l));	\
	int round = 0;	\
	while (1)	\
	{	\
		if (l != (RTL_R32(addr)))	\
			((*(volatile unsigned long*)(addr)) = (l));	\
		else	\
			break;	\
			\
		if (++round > 10000) {	\
					break;	\
				}	\
	}	\
} while(0)
#define RTL_R8(addr)		(*(volatile unsigned char*)(addr))
#define RTL_W8(addr, l)		((*(volatile unsigned char*)(addr)) = (l))

//#define  GPIO_DEBUG
#ifdef GPIO_DEBUG
/* note: prints function name for you */
#  define DPRINTK(fmt, args...) printk("%s: " fmt, __FUNCTION__ , ## args)
#else
#  define DPRINTK(fmt, args...)
#endif

static struct timer_list probe_timer;
static unsigned int    probe_counter;
static unsigned int    probe_state;

//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function
static unsigned int		skip = 0;//WNC-NMRXXXX-YUAN-I-CHOU-20120503, for button control
static char 			default_flag = '2';//WNC-NMRXXXX-YUAN-I-CHOU-20120503, for default button status
//static char default_flag='0';
static int 				raku_flag = 2;
static int 				wps_flag = 2;//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140128, Reset button can't be used while WPS is running
//WNC-NMR643-JDR230-YUAN-I-CHOU-20140317, Add flag to decide when should we detect reset button behavior
static int 				sys_rdy_flag = 0;
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function End

//Brad add for update flash check 20080711
int start_count_time=0;
int Reboot_Wait=0;

//static int get_dc_pwr_plugged_state(void);

#ifdef CONFIG_RTL_USERSPACE_WTDOG
#define RTL_WATCHDOG_KICK	0x01

static int watchdog_kick_state = 0;
static int watchdog_default_flag = 0;
static int watchdog_default_val;

#define LXBUS_CLOCK		(200000000)

typedef struct wtdog_regtbl
{
	unsigned char oversel_h;
	unsigned char oversel_l;
	unsigned int wtdog_val;
}WTDOG_REGTBL_T,*WTDOG_REGTBL_Tp;

static WTDOG_REGTBL_T wtdog_tbl[] = {
	{0x00,0x00,0x8000},
	{0x00,0x01,0x10000},
	{0x00,0x02,0x20000},
	{0x00,0x03,0x40000},
	{0x01,0x00,0x80000},
	{0x01,0x01,0x100000},
	{0x01,0x02,0x200000},
	{0x01,0x03,0x400000},
	{0x02,0x00,0x800000},
	{0x02,0x01,0x1000000},
};

/* watchdog start */
static int read_watchdog_cmd_proc(struct seq_file *s, void *v)
{
	int i;
	unsigned int wtdog_enable,wtdog_intevl,wtdog_cdbr,wtdog_maxtime;
	unsigned int higl_oversel,low_oversel;

	wtdog_enable = ((REG32(BSP_WDTCNR) >> 24) & 0xA5) ==  0xA5 ? 0 : 1;

	wtdog_cdbr = (REG32(BSP_CDBR) >> 16) & 0xffff;
	higl_oversel = (REG32(BSP_WDTCNR) >> 17) & 0x3;
	low_oversel = (REG32(BSP_WDTCNR) >> 21) & 0x3;

	for(i = 0;i < sizeof(wtdog_tbl)/sizeof(WTDOG_REGTBL_T);i++){
		if(wtdog_tbl[i].oversel_h == higl_oversel
			&& wtdog_tbl[i].oversel_l == low_oversel){
			wtdog_intevl = wtdog_tbl[i].wtdog_val/(LXBUS_CLOCK/wtdog_cdbr);
			break;
		}
	}
	if(i == sizeof(wtdog_tbl)/sizeof(WTDOG_REGTBL_T)){
		seq_printf(s,"watchdog register not correct,please check\n");
		return 0;
	}

	i = sizeof(wtdog_tbl)/sizeof(WTDOG_REGTBL_T) -1;
	wtdog_maxtime = wtdog_tbl[i].wtdog_val/(LXBUS_CLOCK/wtdog_cdbr);
	
	if(wtdog_enable == 0)
		seq_printf(s,"watchdog disabled,default watchdog_time=%ds,max watchdog time=%ds\n",watchdog_default_val,wtdog_maxtime);
	else
		seq_printf(s,"watchdog enable,intervel:%dsec,default watchdog_time=%ds,max watchdog time=%ds\n", wtdog_intevl,watchdog_default_val,wtdog_maxtime);

	return 0;
}

int watchdog_cmd_open(struct inode *inode, struct file *file)
{
        return(single_open(file, read_watchdog_cmd_proc, NULL));
}

static ssize_t watchdog_cmd_single_write(struct file * file, const char __user * userbuf,
		     size_t count, loff_t * off)
{
	char flag[64];
	int enable,interval;

	extern void bsp_enable_watchdog(void);
	extern void bsp_disable_watchdog(void);
	
	if (count < 2)
		return -EFAULT;
	if (userbuf && !copy_from_user(&flag, userbuf, 63)) {
		int i,j;
		unsigned int wtdog_intervel,wtdog_intervel0 = 0,wtdog_cdbr,wtdog_maxtime;
		sscanf(flag,"enable %d interval %d",&enable,&interval);

		if(enable == 0){
			/* disable watchdog */
			bsp_disable_watchdog();
		}else if(enable == 1){
			if(watchdog_default_flag == 0){
				watchdog_default_flag = 1;
				watchdog_default_val = interval;
			}else{
				if(interval < watchdog_default_val){
					printk("\t\nwatchdog timeout time should not less than default val,default=%d\n",watchdog_default_val);
					return -1;
				}
			}

			wtdog_cdbr = (REG32(BSP_CDBR) >> 16) & 0xffff;
			i = sizeof(wtdog_tbl)/sizeof(WTDOG_REGTBL_T) -1;
			wtdog_maxtime = wtdog_tbl[i].wtdog_val/(LXBUS_CLOCK/wtdog_cdbr);

			if(interval > wtdog_maxtime){
				printk("\t\n watchdog max intervale time is %d,please check the set value\n",  wtdog_maxtime);
				return -1;
			}

			for(i = 0;i < sizeof(wtdog_tbl)/sizeof(WTDOG_REGTBL_T);i++){
				wtdog_intervel = wtdog_tbl[i].wtdog_val/(LXBUS_CLOCK/wtdog_cdbr);

				if(interval >= wtdog_intervel0
					&& interval <= wtdog_intervel)
					goto END;
				wtdog_intervel0 = wtdog_intervel;
			}
			
END:
			REG32(BSP_WDTCNR) = ( wtdog_tbl[i].oversel_l << 21) | ( wtdog_tbl[i].oversel_h << 17) ;
		}
		return count;
	}
	
	return -EFAULT;	
}

struct file_operations watchdog_cmd_proc_fops = {
        .open           = watchdog_cmd_open,
        .write         = watchdog_cmd_single_write,
        .read            = seq_read,
        .llseek          = seq_lseek,
        .release        = single_release,
};

/* watchdog kick */
static int read_watchdog_kick_proc(struct seq_file *s, void *v)
{
	char flag = '0';

	if(watchdog_kick_state == RTL_WATCHDOG_KICK)
		flag = '1';

	seq_printf(s,"%c\n", flag);

	return 0;
}

int watchdog_kick_open(struct inode *inode, struct file *file)
{
        return(single_open(file, read_watchdog_kick_proc, NULL));
}

static ssize_t watchdog_kick_single_write(struct file * file, const char __user * userbuf,
		     size_t count, loff_t * off)
{
	char flag[20];

	if (count < 2)
		return -EFAULT;
#ifdef CONFIG_RTL_WTDOG
	{ 
		/*If kernel fault. reboot whole system so softwatch dog can not kick even*/
		extern int is_fault;
		if(is_fault)
			return count;
	}
#endif
	if (userbuf && !copy_from_user(&flag, userbuf, 1)) {
		if(flag[0] == '1'){
			watchdog_kick_state = RTL_WATCHDOG_KICK;
			/* kick watchdog here*/
			*(volatile unsigned long *)(0xB800311c) |=  1 << 23;
		}else {
			watchdog_kick_state = 0;
		}
		return count;
	}
	
	return -EFAULT;	
}

struct file_operations watchdog_kick_proc_fops = {
        .open           = watchdog_kick_open,
        .write         = watchdog_kick_single_write,
        .read            = seq_read,
        .llseek          = seq_lseek,
        .release        = single_release,
};
#endif
#if defined(USE_INTERRUPT_GPIO)
struct gpio_wps_device
{
	unsigned int name;
};
struct gpio_wps_device priv_gpio_wps_device;
#endif

#ifdef USE_INTERRUPT_GPIO
static int wps_button_push = 0;
#endif

int reset_button_pressed(void)
{	
    ////todo : RTL_BSP_Get_RESET_PIN_DATABASE
	if ((RTL_R32(RESET_PIN_DATABASE) & (1 << RESET_BTN_PIN)))	
		return 0;
	else
		return 1;
}


//#ifdef AUTO_CONFIG
#if 0
static unsigned int		AutoCfg_LED_Blink;
static unsigned int		AutoCfg_LED_Toggle;
static unsigned int		AutoCfg_LED_Slow_Blink;
static unsigned int		AutoCfg_LED_Slow_Toggle;

void autoconfig_gpio_init(void)
{
#if defined(CONFIG_RTL_8198C)
    ////todo : RTL_BSP_Set_AUTOCFG_PIN  RTL_BSP_Set_AUTOCFG_LED_PIN
    /*need set pin mux sel register for gpio mode? ==> check with hw */
	RTL_W32(AUTOCFG_PIN_IOBASE,(RTL_R32(AUTOCFG_PIN_IOBASE)&(~(1 << AUTOCFG_BTN_PIN))));
    #ifdef AUTOCFG_LED_NO
	RTL_W32(AUTOCFG_LED_IOBASE,(RTL_R32(AUTOCFG_LED_IOBASE)&(~(1 << AUTOCFG_LED_PIN))));
    #endif

	// Set GPIO   pin  as input pin for auto config button
	RTL_W32(AUTOCFG_PIN_DIRBASE, (RTL_R32(AUTOCFG_PIN_DIRBASE) & (~(1 << AUTOCFG_BTN_PIN))));

    #ifdef AUTOCFG_LED_NO
	// Set GPIOA ping 3 as output pin for auto config led
	RTL_W32(AUTOCFG_LED_DIRBASE, (RTL_R32(AUTOCFG_LED_DIRBASE) | (1 << AUTOCFG_LED_PIN)));

	// turn off auto config led in the beginning
	RTL_W32(AUTOCFG_LED_DATABASE, (RTL_R32(AUTOCFG_LED_DATABASE) | (1 << AUTOCFG_LED_PIN)));
    #endif	
    //printk("LINE: %x d:%x *  %x****R:%x\n",__LINE__,RTL_R32(0xb8b00728),RTL_R32(PCIE_PIN_MUX),RTL_R32(RESET_PIN_DATABASE));
#endif
}


#if defined(CONFIG_RTL_8198C)

void autoconfig_gpio_off(void)
{
    ////todo : RTL_BSP_Set_AUTOCFG_LED_PIN
	////RTLWIFINIC_GPIO_write(AUTOCFG_LED_PIN, 0);
	RTL_W32(AUTOCFG_LED_DATABASE, (RTL_R32(AUTOCFG_LED_DATABASE) | (1 << AUTOCFG_LED_PIN)));    
	AutoCfg_LED_Blink = 0;
}

void autoconfig_gpio_on(void)
{
    ////todo : RTL_BSP_Set_AUTOCFG_LED_PIN
	////RTLWIFINIC_GPIO_write(AUTOCFG_LED_PIN, 1);
	RTL_W32(AUTOCFG_LED_DATABASE, (RTL_R32(AUTOCFG_LED_DATABASE) & (~(1 << AUTOCFG_LED_PIN))));
	AutoCfg_LED_Blink = 0;
}

void autoconfig_gpio_blink(void)
{
        ////leroy todo : RTL_BSP_Set_AUTOCFG_LED_PIN
	////RTLWIFINIC_GPIO_write(AUTOCFG_LED_PIN, 1);
	RTL_W32(AUTOCFG_LED_DATABASE, (RTL_R32(AUTOCFG_LED_DATABASE) & (~(1 << AUTOCFG_LED_PIN))));	
	AutoCfg_LED_Blink = 1;
	AutoCfg_LED_Toggle = 1;
    /*check if 98C support slow blink?*/
	////AutoCfg_LED_Slow_Blink = 0;
}
#endif

#endif // end of AUTO_CONFIG




//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160126-Add Light OFF state support
#ifndef REG32
#define REG32(reg)		(*((volatile unsigned long *)(reg)))
#endif

#define PIN_MUX_SEL3 	0xb8000108
#define RTL_MUX3_LED_S0_GPIO (3<<0)
#define RTL_MUX3_LED_S1_GPIO (3<<3)
#define RTL_MUX3_LED_S2_GPIO (3<<6)
#define RTL_MUX3_LED_S3_GPIO (3<<9)
#define RTL_MUX3_LED_P0_GPIO (3<<12)
#define RTL_MUX3_LED_S0 (1<<0)
#define RTL_MUX3_LED_S1 (1<<3)
#define RTL_MUX3_LED_S2 (1<<6)
#define RTL_MUX3_LED_S3 (1<<9)
#define RTL_MUX3_LED_P0 (1<<12)

#define PABCD_CNR			0xb8003500
#define PABCD_DIR     0xb8003508
#define PABCD_DAT     0xb800350c
#define RTL_GPIOB2 (1<<10)
#define RTL_GPIOB3 (1<<11)
#define RTL_GPIOB4 (1<<12)
#define RTL_GPIOB5 (1<<13)
#define RTL_GPIOB6 (1<<14)

void ethernet_led_ctl (int HW, int value) {
#if 1
	printk("ethernet_led_ctl, HW[%d], value[%d]\n", HW, value);
	if (HW == 1) {
		// HW control LED, don't care value
			//set back to hard mode
			RTL_W32(PIN_MUX_SEL3, (RTL_R32(PIN_MUX_SEL3) & (~ RTL_MUX3_LED_S0_GPIO))); 
		  RTL_W32(PIN_MUX_SEL3, (RTL_R32(PIN_MUX_SEL3) & (~ RTL_MUX3_LED_S1_GPIO))); 
		  RTL_W32(PIN_MUX_SEL3, (RTL_R32(PIN_MUX_SEL3) & (~ RTL_MUX3_LED_S2_GPIO))); 
		  RTL_W32(PIN_MUX_SEL3, (RTL_R32(PIN_MUX_SEL3) & (~ RTL_MUX3_LED_S3_GPIO))); 
		  RTL_W32(PIN_MUX_SEL3, (RTL_R32(PIN_MUX_SEL3) & (~ RTL_MUX3_LED_P0_GPIO))); 
			RTL_W32(PIN_MUX_SEL3, (RTL_R32(PIN_MUX_SEL3) |= RTL_MUX3_LED_S0)); // Set GPIO MUX for B2
			RTL_W32(PIN_MUX_SEL3, (RTL_R32(PIN_MUX_SEL3) |= RTL_MUX3_LED_S1)); // Set GPIO MUX for B3
			RTL_W32(PIN_MUX_SEL3, (RTL_R32(PIN_MUX_SEL3) |= RTL_MUX3_LED_S2)); // Set GPIO MUX for B4
			RTL_W32(PIN_MUX_SEL3, (RTL_R32(PIN_MUX_SEL3) |= RTL_MUX3_LED_S3)); // Set GPIO MUX for B5
			RTL_W32(PIN_MUX_SEL3, (RTL_R32(PIN_MUX_SEL3) |= RTL_MUX3_LED_P0)); // Set GPIO MUX for B6
		
	} else if (HW == 0) {
		// SW control LED
		// Cancel GPIO MUX
		RTL_W32(PIN_MUX_SEL3, (RTL_R32(PIN_MUX_SEL3) |= RTL_MUX3_LED_S0_GPIO)); // Set GPIO MUX for B2
		RTL_W32(PIN_MUX_SEL3, (RTL_R32(PIN_MUX_SEL3) |= RTL_MUX3_LED_S1_GPIO)); // Set GPIO MUX for B3
		RTL_W32(PIN_MUX_SEL3, (RTL_R32(PIN_MUX_SEL3) |= RTL_MUX3_LED_S2_GPIO)); // Set GPIO MUX for B4
		RTL_W32(PIN_MUX_SEL3, (RTL_R32(PIN_MUX_SEL3) |= RTL_MUX3_LED_S3_GPIO)); // Set GPIO MUX for B5
		RTL_W32(PIN_MUX_SEL3, (RTL_R32(PIN_MUX_SEL3) |= RTL_MUX3_LED_P0_GPIO)); // Set GPIO MUX for B6

		RTL_W32(PABCD_CNR, (RTL_R32(PABCD_CNR) & (~RTL_GPIOB2))); // set B2 to gpio
		RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) | RTL_GPIOB2)); // set B2 Output
		RTL_W32(PABCD_CNR, (RTL_R32(PABCD_CNR) & (~RTL_GPIOB3))); // set B3 to gpio
		RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) | RTL_GPIOB3)); // set B3 Output
		RTL_W32(PABCD_CNR, (RTL_R32(PABCD_CNR) & (~RTL_GPIOB4))); // set B4 to gpio
		RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) | RTL_GPIOB4)); // set B4 Output
		RTL_W32(PABCD_CNR, (RTL_R32(PABCD_CNR) & (~RTL_GPIOB5))); // set B5 to gpio
		RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) | RTL_GPIOB5)); // set B5 Output
		RTL_W32(PABCD_CNR, (RTL_R32(PABCD_CNR) & (~RTL_GPIOB6))); // set B6 to gpio
		RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) | RTL_GPIOB6)); // set B6 Output
		
		if (value == 0) {
		  RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~RTL_GPIOB2)));
		  RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~RTL_GPIOB3)));
		  RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~RTL_GPIOB4)));
		  RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~RTL_GPIOB5)));
		  RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~RTL_GPIOB6)));
		} else if (value == 1) {
		  RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | RTL_GPIOB2));
		  RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | RTL_GPIOB3));
		  RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | RTL_GPIOB4));
		  RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | RTL_GPIOB5));
		  RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | RTL_GPIOB6));
		}
	}
	#endif
	return;
}

void skip_los_config_set (void) {
	//Restore all LED to normal behavior

	//Restore wireless LED
	rtl8192_led_force_off(0, 2);
	rtl8192_led_force_off(1, 2);
	//Restore ethernet LED
	ethernet_led_ctl(1, 0);
}
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160126-Add Light OFF state support End


static void rtl_gpio_timer(unsigned long data)
{
	unsigned int pressed=1;
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,27)
	struct pid *pid;
#endif

	if(reset_button_pressed() == 0) //mark_es
	{
		pressed = 0;
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function
#if 0
		//turn off LED0
        #ifdef RESET_LED_NO
		RTL_W32(RESET_LED_DATABASE, (RTL_R32(RESET_LED_DATABASE) | ((1 << RESET_LED_PIN))));
		#endif
#endif
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function End
	}
	else
	{
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140128, Reset button can't be used while WPS is running
//WNC-NMR643-JDR230-YUAN-I-CHOU-20140317, Add flag to decide when should we detect reset button behavior
		if (raku_flag == 1 || wps_flag == 1 || sys_rdy_flag == 0) {
			//rakuraku is running, ignore reset button event.
			probe_counter = 0;
		}
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function End

		printk("Key pressed %d!\n", probe_counter+1);
	}

//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function
#if 0
	if (RTL_R32(AUTOCFG_PIN_DATABASE) & (1 << AUTOCFG_BTN_PIN))
	{
#ifdef USE_INTERRUPT_GPIO
		wps_button_push = 0;
#endif
	}else{
#ifdef USE_INTERRUPT_GPIO
		wps_button_push++;
#endif
	}
#endif
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function End

	if (probe_state == PROBE_NULL)
	{
		if (pressed)
		{
			probe_state = PROBE_ACTIVE;
			probe_counter++;
		}
		else
			probe_counter = 0;
	}
	else if (probe_state == PROBE_ACTIVE)
	{
		if (pressed)
		{
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function
			rl_gpio_led_info led;
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function End
			probe_counter++;

//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function
			if (!skip && (default_flag == '1') && (probe_counter >= 2)) {
				//normal state
				default_flag = '2';

//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support
// Not in skip LOS mode --> trigger skip LOS mode.
// Restore wireless LED
// Add timer to switch back to LOS mode
				if (skip_LOS_mode == 0) {
					skip_LOS_mode = 1;
					skip_los_config_set();
					//Add timer
					//init_timer(&rl_skip_led_LOS_timer);
					//rl_skip_led_LOS_timer.expires = jiffies + 3*60*HZ;
					//add_timer(&rl_skip_led_LOS_timer);
					//mod_timer(&rl_skip_led_LOS_timer, jiffies + 3*60*HZ);
				}
				printk("Skip Light OFF state for 3 minutes [reset - normal]\n");
				//we would extend skip LOS timer even we are in skip LOS mode
				mod_timer(&rl_skip_led_LOS_timer, jiffies + 3*60*HZ);
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support End

				printk(" normal state \n");
//WNC-NMR1583-D2R030-Yuan-I-Chou-20160414-Turn ON LED after FLASH programming process is completed.
#if 0
				led.gpio = 4;
				led.on = 4000;
				led.off = 0;
				led.blinks = 1;
				led.rests = 0;
				led.times = 4000;
				rl_gpio_led_set(led);

				led.gpio = 5;
				led.on = 0;
				led.off = 4000;
				led.blinks = 1;
				led.rests = 0;
				led.times = 4000;
				rl_gpio_led_set(led);
#endif
//WNC-NMR1583-D2R030-Yuan-I-Chou-20160414-Turn ON LED after FLASH programming process is completed End.
				skip = 1;
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support
			} else if (!skip && (default_flag == '2') && (probe_counter == 2)) {
				// In normal state and user presses reset button 2 seconds.
				if (skip_LOS_mode == 0) {
					skip_LOS_mode = 1;
					skip_los_config_set();
					//Add timer
					//init_timer(&rl_skip_led_LOS_timer);
					//rl_skip_led_LOS_timer.expires = jiffies + 3*60*HZ;
					//add_timer(&rl_skip_led_LOS_timer);
					//mod_timer(&rl_skip_led_LOS_timer, jiffies + 3*60*HZ);
				}
				printk("Skip Light OFF state for 3 minutes [reset - init]\n");
				mod_timer(&rl_skip_led_LOS_timer, jiffies + 3*60*HZ);
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support End
			} else if (!skip && (default_flag == '2') && (probe_counter >= PROBE_TIME)) {

				//initial state
				default_flag = '1';

				printk(" initial state \n");
//WNC-NMR1583-D2R030-Yuan-I-Chou-20160414-Turn ON LED after FLASH programming process is completed.
#if 0
				led.gpio = 4;
				led.on = 0;
				led.off = 4000;
				led.blinks = 1;
				led.rests = 0;
				led.times = 4000;
				rl_gpio_led_set(led);

				led.gpio = 5;
				led.on = 5;
				led.off = 5;
				led.blinks = 2;
				led.rests = 0;
				led.times = 4000;
				rl_gpio_led_set(led);
#endif
//WNC-NMR1583-D2R030-Yuan-I-Chou-20160414-Turn ON LED after FLASH programming process is completed End.
				skip = 1;
			}
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function End

//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function
#if 0
			if ((probe_counter >=2 ) && (probe_counter <=PROBE_TIME))
			{
				DPRINTK("2-5 turn on led\n");
				//turn on LED0
                #ifdef RESET_LED_NO
                    RTL_W32(RESET_LED_DATABASE, (RTL_R32(RESET_LED_DATABASE) & (~(1 << RESET_LED_PIN))));
                #endif
			}
			else if (probe_counter >= PROBE_TIME)
			{
				// sparkling LED0
				DPRINTK(">5 \n");
                #ifdef RESET_LED_NO
				if (probe_counter & 1)
				{ 				
					RTL_W32(RESET_LED_DATABASE, (RTL_R32(RESET_LED_DATABASE) | ((1 << RESET_LED_PIN))));
				}	
				else
				{
					RTL_W32(RESET_LED_DATABASE, (RTL_R32(RESET_LED_DATABASE) & (~(1 << RESET_LED_PIN))));
				}	
                #endif
			}
#endif
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function End
		}
		else
		{
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function
			probe_state = PROBE_NULL;
			probe_counter = 0;
			skip = 0;
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function End
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function
#if 0
			if (probe_counter < 2)
			{
				probe_state = PROBE_NULL;
				probe_counter = 0;
				DPRINTK("<2 \n");
				#if defined(CONFIG_RTL865X_SC)
					ResetToAutoCfgBtn = 1;
				#endif
			}
			else if (probe_counter >= PROBE_TIME)
			{
				//reload default
				default_flag = '1';
				//kernel_thread(reset_flash_default, (void *)1, SIGCHLD);
				return;
			}
			else
			{
				DPRINTK("2-5 reset 1\n");
			#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,27)
				kill_proc(1,SIGTERM,1);
			#else
				pid = get_pid(find_vpid(1));
				kill_pid(pid,SIGTERM,1);
			#endif
				DPRINTK("2-5 reset 2\n");
				//kernel_thread(reset_flash_default, 0, SIGCHLD);
				return;
			}
#endif
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Reset button function End
		}
	}

//#ifdef AUTO_CONFIG
#if 0
	if (AutoCfg_LED_Blink==1)
	{
		if (AutoCfg_LED_Toggle) {
            #ifdef AUTOCFG_LED_NO
			RTL_W32(AUTOCFG_LED_DATABASE, (RTL_R32(AUTOCFG_LED_DATABASE) | (1 << AUTOCFG_LED_PIN)));
            #endif
		}
		else {
            #ifdef AUTOCFG_LED_NO	
			 RTL_W32(AUTOCFG_LED_DATABASE, (RTL_R32(AUTOCFG_LED_DATABASE) & (~(1 << AUTOCFG_LED_PIN))));		
            #endif
		}
				
		if(AutoCfg_LED_Slow_Blink)
		{
			if(AutoCfg_LED_Slow_Toggle)
				AutoCfg_LED_Toggle = AutoCfg_LED_Toggle;
			else
				AutoCfg_LED_Toggle = AutoCfg_LED_Toggle? 0 : 1;
			
			AutoCfg_LED_Slow_Toggle = AutoCfg_LED_Slow_Toggle? 0 : 1;
		}
		else
			AutoCfg_LED_Toggle = AutoCfg_LED_Toggle? 0 : 1;
		
	}
#endif////end of #ifdef AUTO_CONFIG

	mod_timer(&probe_timer, jiffies + HZ);
}



#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE

#define SYSTEM_CONTRL_DUMMY_REG 0xb8003504

int is_bank2_root()
{
	//boot code will steal System's dummy register bit0 (set to 1 ---> bank2 booting
	//for 8198 formal chip 
	
	if ((RTL_R32(SYSTEM_CONTRL_DUMMY_REG)) & (0x00000001))  // steal for boot bank idenfy
		return 1;
	
	return 0;
}
static int read_bootbank_proc(struct seq_file *s, void *v)
{
	int len;
	char flag='1';

	if (is_bank2_root())  // steal for boot bank idenfy
		flag='2';


	seq_printf(s,"%c\n", flag);

	return 0;
#if 0		
	len = sprintf(page, "%c\n", flag);

	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len > count) len = count;
	if (len < 0) len = 0;
	return len;
#endif
}

int bootbank_open(struct inode *inode, struct file *file)
{
        return(single_open(file, read_bootbank_proc, NULL));
}

struct file_operations bootbank_proc_fops = {
        .open           = bootbank_open,
        .read            = seq_read,
        .llseek          = seq_lseek,
        .release        = single_release,
};

#endif


#ifdef AUTO_CONFIG
#if defined(USE_INTERRUPT_GPIO)
static irqreturn_t gpio_interrupt_isr(int irq, void *dev_instance, struct pt_regs *regs)
{
	printk("%s %d\n",__FUNCTION__ , __LINE__);
	unsigned int status;

#if defined(CONFIG_RTL_8198C)
	status = REG32(PEFGH_ISR);
#else

#endif

	if((status & BIT(AUTOCFG_BTN_PIN)) != 0)
	{
		wps_button_push = 1; 		

#if defined(CONFIG_RTL_8198C)
		RTL_W32(PEFGH_ISR, BIT(AUTOCFG_BTN_PIN)); 	
#else

#endif

#ifdef IMMEDIATE_PBC
	if(wscd_pid>0)
	{
		rcu_read_lock();
		wscd_pid_Ptr = get_pid(find_vpid(wscd_pid));
		rcu_read_unlock();	

		if(wscd_pid_Ptr){
			printk("(%s %d);signal wscd ;pid=%d\n",__FUNCTION__ , __LINE__,wscd_pid);			
			kill_pid(wscd_pid_Ptr, SIGUSR2, 1);
			
		}
	}
#endif
	}

	return IRQ_HANDLED;
}
#endif

// WNC-MRXXXX-Yuan-I-Chou-20140421-separate GPIO and LED GPIO proc file
//static int read_led_proc(char *page, char **start, off_t off, int count, int *eof, void *data)
static int read_led_proc(struct seq_file *s, void *v)
{
	//int len;
	char flag = 0;

	flag = '1';
#if 0
	len = sprintf(page, "%c\n", flag);

	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len > count) len = count;
	if (len < 0) len = 0;
	return len;
#else
	seq_printf(s, "%c\n", flag);
	return 0;
#endif
}
//WNC-JDR230-YUAN-I-CHOU-20140421, Add LED control function End

// WNC-MRXXXX-David-20140421-add reset button proc-Start
//static int read_proc_reset_btn(char *page, char **start, off_t off, int count, int *eof, void *data)
static int read_proc_reset_btn(struct seq_file *s, void *v)
{
	//int len;
	char flag = 0;

	if ((RTL_R32(RESET_PIN_DATABASE) & (1 << RESET_BTN_PIN))) {
		flag = '0';
	} else {
		flag = '1';
	}

#if 0
	len = sprintf(page, "%c\n", flag);

	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len > count) len = count;
	if (len < 0) len = 0;
	return len;
#else
	seq_printf(s, "%c\n", flag);
	return 0;
#endif
}
// WNC-MRXXXX-David-20140421-add reset button proc-End

//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Slide switch function
//static int read_proc_slide_sw(char *page, char **start, off_t off, int count, int *eof, void *data)
static int read_proc_slide_sw(struct seq_file *s, void *v)
{
	//int len;
	char flag = 0;

	//[H7][H5]
	//RT : 11, CNV : 10, AP : 01, 

	if (RTL_R32(PEFGH_DAT) & (RTL_GPIOH7))
	{
		flag |= 0x10;
	}

	if (RTL_R32(PEFGH_DAT) & (RTL_GPIOH5))
	{
		flag |= 0x01;
	}
#if 0
	len = sprintf(page, "%c\n", flag);

	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len > count) len = count;
	if (len < 0) len = 0;
	return len;
#else
	seq_printf(s, "%X\n", flag);
	return 0;
#endif
}
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add Slide switch function End

//WNC-NMR160,357-JDR230-YUAN-I-CHOU-20130327, Reset button can't be used while RakuRaku is running
//static int raku_read_proc(char *page, char **start, off_t off, int count, int *eof, void *data)
static int raku_read_proc(struct seq_file *s, void *v)
{
	//int len;

#if 0
	len = sprintf(page, "%d\n", raku_flag);

	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len>count) len = count;
	if (len<0) len = 0;
	return len;
#else
	seq_printf(s, "%d\n", raku_flag);
	return 0;
#endif
}
//WNC-NMR160,357-JDR230-YUAN-I-CHOU-20130327, Reset button can't be used while RakuRaku is running End

//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140128, Reset button can't be used while WPS is running
//static int wps_read_proc(char *page, char **start, off_t off, int count, int *eof, void *data)
static int wps_read_proc(struct seq_file *s, void *v)
{
	//int len;

#if 0
	len = sprintf(page, "%d\n", wps_flag);

	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len>count) len = count;
	if (len<0) len = 0;
	return len;
#else
	seq_printf(s, "%d\n", wps_flag);
	return 0;
#endif
}
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140128, Reset button can't be used while WPS is running

//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add MODEL ID function
//static int read_proc_modelid(char *page, char **start, off_t off, int count, int *eof, void *data)
static int read_proc_modelid(struct seq_file *s, void *v)
{
	//int len;
	short flag = 0;

	//[E7][F0][F1]
	//Rafale : 000, Meteor : 001

	if (RTL_R32(PEFGH_DAT) & (RTL_GPIOE7))
	{
		flag |= 0x100;
	}

	if (RTL_R32(PEFGH_DAT) & (RTL_GPIOF0))
	{
		flag |= 0x10;
	}

	if (RTL_R32(PEFGH_DAT) & (RTL_GPIOF1))
	{
		flag |= 0x01;
	}

#if 0
	len = sprintf(page, "%X\n", flag);

	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len > count) len = count;
	if (len < 0) len = 0;
	return len;
#else
	seq_printf(s, "%X\n", flag);
	return 0;
#endif
}
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20140421, Add MODEL ID function End

//static int read_proc(char *page, char **start, off_t off, int count, int *eof, void *data)
static int read_proc(struct seq_file *s, void *v)
{
//	int len;
	char flag;

#if  defined(USE_INTERRUPT_GPIO)
// 2009-0414		
	if (wps_button_push) {
		flag = '1';
		//wps_button_push = 0; //mark it for select wlan interface by button pressed time		
	}
	else{
		if (RTL_R32(AUTOCFG_PIN_DATABASE) & (1 << AUTOCFG_BTN_PIN)){
			flag = '0';
		}else{
			//printk("wps button be held \n");
			flag = '1';
		}
	}
// 2009-0414		
#else

	if (RTL_R32(AUTOCFG_PIN_DATABASE) & (1 << AUTOCFG_BTN_PIN))
		flag = '0';
	else 
		flag = '1';
	
#endif // CONFIG_RTL865X_KLD					
//	len = sprintf(page, "%c\n", flag);
	seq_printf(s, "%c\n", flag);

#if 0
	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len > count) len = count;
	if (len < 0) len = 0;
	return len;
#else
	return 0;
#endif	
}

#ifdef CONFIG_RTL_KERNEL_MIPS16_CHAR
__NOMIPS16
#endif

// WNC-MRXXXX-Yuan-I-Chou-20140421-separate GPIO and LED GPIO proc file
static int write_led_proc(struct file *file, const char *buffer, unsigned long count, void *data)
{
	unsigned char led_command[100]; 

	memset(led_command, '\0', 100);

	if (count < 2)
		return -EFAULT;

	//printk("write_led_proc: %s\n", buffer);

//LED configuration
	rl_gpio_led_info led;
	if (buffer && !copy_from_user(&led_command, buffer, 100)) {
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support
//LOS=X, X = MIB infomation = led_LOS_mode
		if (!strncmp(led_command, "LOS=", 4)) {
			led_LOS_mode = led_command[4] - '0';
			printk("led_LOS_mode = [%d]\n", led_LOS_mode);
		} else if (!strncmp(led_command, "SLOS", 4)) {
//SLOS = Skip LOS mode
			printk("Skip Light OFF state for 3 minutes [via cli]\n");
			if (skip_LOS_mode == 0) {
				skip_LOS_mode = 1;
				skip_los_config_set();
				//Reset timer to 3 minutes
				//init_timer(&rl_skip_led_LOS_timer);
				//rl_skip_led_LOS_timer.expires = jiffies + 3*60*HZ;
				//add_timer(&rl_skip_led_LOS_timer);
				//mod_timer(&rl_skip_led_LOS_timer, jiffies + 3*60*HZ);
			}
			//we would extend skip LOS timer even we are in skip LOS mode
			mod_timer(&rl_skip_led_LOS_timer, jiffies + 3*60*HZ);
		} else if (!strncmp(led_command, "CLOS", 4)) {
//CLOS = Cancel LOS mode
			if (cencel_LOS_mode == 0) {
				printk("Cancel Light OFF state\n");
				if (skip_LOS_mode == 0) {
					//Not in Skip LOS mode --> no skip_led_LOS_timer
					skip_LOS_mode = 1;
					skip_los_config_set();
				} else {
					//in Skip LOS mode or cancel LOS mode
					if (timer_pending(&rl_skip_led_LOS_timer)) {
						//in Skip LOS mode, remove timer
						del_timer(&rl_skip_led_LOS_timer);
						//needed?
						skip_LOS_mode = 1;
						skip_los_config_set();
					}
				}
				cencel_LOS_mode = 1;
			}
		} else if (!strncmp(led_command, "RLOS", 4)) {
//RLOS = Recover LOS mode
			if (cencel_LOS_mode == 1) {
				printk("Restore Light OFF state behavior\n");

				skip_LOS_mode = 0;	//Cancel Skip LOS mode flag
				if (led_LOS_mode != 0) {
					//Disable Wireless LED function
					rtl8192_led_force_off(0, 0);
					rtl8192_led_force_off(1, 0);
					//Disable Ethernet LED (HW control -> SW control and OFF)
					ethernet_led_ctl(0, 1);
				}
				cencel_LOS_mode = 0;
			}
		} else {
			if (!sscanf(&led_command, "%ld %ld %ld %ld %ld %ld\n", 
				&led.gpio,&led.on,&led.off,&led.blinks,&led.rests,&led.times))
			return -EINVAL;

			//printk("led_command %s\n", led_command);
			rl_gpio_led_set(led);
		}
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support End
		return count;
	}
	else
		return -EFAULT;
	
}
// WNC-MRXXXX-Yuan-I-Chou-20140421-End

//WNC-JDR230-NMRXXXX-Yuan-I-Chou-20140421-WPS LED control
int handle_wps_led(int flag)
{
	rl_gpio_led_info led;

	printk(" handle_wps_led [%d]\n", flag);
	switch (flag) {
		case 9:				//END
			led.gpio = 5;	//Power RED LED OFF
			led.on = 0;
			led.off = 4000;
			led.blinks = 1;
			led.rests = 0;
			led.times = 4000;
			rl_gpio_led_set(led);
			led.gpio = 4;	//Power Green LED ON
			led.on = 4000;
			led.off = 0;
			led.blinks = 1;
			led.rests = 0;
			led.times = 4000;
			rl_gpio_led_set(led);
			break;
		case 2:
			led.gpio = 4;	//Power Green LED blink 2 minutes
			led.on = 5;
			led.off = 5;
			led.blinks = 2;
			led.rests = 0;
			led.times = 120;
			rl_gpio_led_set(led);
			break;
		case 8:				//ERROR
			led.gpio = 4;	//Power Green LED OFF
			led.on = 0;
			led.off = 4000;
			led.blinks = 1;
			led.rests = 0;
			led.times = 4000;
			rl_gpio_led_set(led);
			led.gpio = 5;	//Power Red LED blink 1 time
			led.on = 100;
			led.off = 0;
			led.blinks = 1;
			led.rests = 0;
			led.times = 1;
			rl_gpio_led_set(led);
			break;
		case 7:				//SUCCESS
			led.gpio = 4;	//Power Green LED blink 1 time
			led.on = 100;
			led.off = 0;
			led.blinks = 1;
			led.rests = 0;
			led.times = 1;
			rl_gpio_led_set(led);
			led.gpio = 5;	//Power Red LED blink 1 time
			led.on = 100;
			led.off = 0;
			led.blinks = 1;
			led.rests = 0;
			led.times = 1;
			rl_gpio_led_set(led);

//WNC-D2R230-NMR1752-YUAN-I-CHOU-20170110, Trigger WPS End LED after 10 seconds from WPS Success LED triggered.
			if (timer_pending(&wps_over_timer)) {
				del_timer(&wps_over_timer);
			}

			init_timer(&wps_over_timer);
			wps_over_timer.data = (unsigned long)NULL;
			wps_over_timer.function = &wps_over_do_timer;
			wps_over_timer.expires = jiffies + 10 * HZ;
			mod_timer(&wps_over_timer, jiffies + 10 * HZ);
//WNC-D2R230-NMR1752-YUAN-I-CHOU-20170110, Trigger WPS End LED after 10 seconds from WPS Success LED triggered End.

			break;
		case 6:				//OVERLAPPED
			led.gpio = 4;	//Power Green LED OFF
			led.on = 0;
			led.off = 4000;
			led.blinks = 1;
			led.rests = 0;
			led.times = 4000;
			rl_gpio_led_set(led);
			led.gpio = 5;	//Power Red LED blink patterm for 10 period
			led.on = 1;
			led.off = 1;
			led.blinks = 10;
			led.rests = 5;
			led.times = 10;
			rl_gpio_led_set(led);
			break;
	}
}
//WNC-JDR230-NMRXXXX-Yuan-I-Chou-20140421-WPS LED control End

//WNC-D2R230-NMR1752-YUAN-I-CHOU-20170110, Trigger WPS End LED after 10 seconds from WPS Success LED triggered.
static void wps_over_do_timer(unsigned long unused)
{
	printk("WPS over timer triggered\n");
	handle_wps_led(9);
	return;
}
//WNC-D2R230-NMR1752-YUAN-I-CHOU-20170110, Trigger WPS End LED after 10 seconds from WPS Success LED triggered End.

static int write_proc(struct file *file, const char *buffer, unsigned long count, void *data)
{
	char flag[20];
//Brad add for update flash check 20080711

	char start_count[10], wait[10];

	if (count < 2)
		return -EFAULT;

	DPRINTK("file: %08x, buffer: %s, count: %lu, data: %08x\n",
		(unsigned int)file, buffer, count, (unsigned int)data);

	if (buffer && !copy_from_user(&flag, buffer, 1)) {
		if (flag[0] == 'E') {
//			autoconfig_gpio_init();
		}
//WNC-NMR643-JDR230-YUAN-I-CHOU-20140317, Add flag to decide when should we detect reset button behavior
		else if (flag[0] == 'z') {
			sys_rdy_flag = 1;
		}
//WNC-NMR643-JDR230-YUAN-I-CHOU-20140317, Add flag to decide when should we detect reset button behavior End

//WNC-JDR230-NMRXXXX-Yuan-I-Chou-20140421-WPS LED control
		else if (flag[0] == '9')	//END
			handle_wps_led(9);
		else if (flag[0] == '7')	//SUCCESS
			handle_wps_led(7);
		else if (flag[0] == '6')	//OVERLAPPED
			handle_wps_led(6);
		else if (flag[0] == '2')
			handle_wps_led(2);
		else if (flag[0] == '8')	//ERROR
			handle_wps_led(8);
#if 0
		else if (flag[0] == '0')
			autoconfig_gpio_off();
		else if (flag[0] == '1')
			autoconfig_gpio_on();
		else if (flag[0] == '2')
			autoconfig_gpio_blink();
#endif
//WNC-JDR230-NMRXXXX-Yuan-I-Chou-20140421-WPS LED control End
//Brad add for update flash check 20080711
		else if (flag[0] == '4'){
			start_count_time= 1;
			sscanf(buffer, "%s %s", start_count, wait);
			Reboot_Wait = (simple_strtol(wait,NULL,0))*100;
		}

		else
			{}

		return count;
	}
	else
		return -EFAULT;
}
#ifdef IMMEDIATE_PBC
static unsigned long atoi_dec(char *s)
{
	unsigned long k = 0;

	k = 0;
	while (*s != '\0' && *s >= '0' && *s <= '9') {
		k = 10 * k + (*s - '0');
		s++;
	}
	return k;
}
static int read_gpio_wscd_pid(char *page, char **start, off_t off,
				int count, int *eof, void *data)
{
	int len;
	char flag;

	DPRINTK("wscd_pid=%d\n",wscd_pid);	
	
	len = sprintf(page, "%d\n", wscd_pid);
	if (len <= off+count) *eof = 1;
	*start = page + off;
	len -= off;
	if (len > count) len = count;
	if (len < 0) len = 0;
	return len;
}
static int write_gpio_wscd_pid(struct file *file, const char *buffer,
				unsigned long count, void *data)
{
	char flag[20];
	char start_count[10], wait[10];
	if (count < 2)
		return -EFAULT;

	DPRINTK("file: %08x, buffer: %s, count: %lu, data: %08x\n",
		(unsigned int)file, buffer, count, (unsigned int)data);

	if (buffer && !copy_from_user(&flag, buffer, 1)) {

		wscd_pid = atoi_dec(buffer);
		DPRINTK("wscd_pid=%d\n",wscd_pid);	
		return count;
	}
	else{
		return -EFAULT;
	}
}
#endif
#endif // AUTO_CONFIG

//static int default_read_proc(char *page, char **start, off_t off, int count, int *eof, void *data)
static int default_read_proc(struct seq_file *s, void *v)
{
#if 0
	int len;

	len = sprintf(page, "%c\n", default_flag);
	if (len <= off+count) *eof = 1;
	  *start = page + off;
	len -= off;
	if (len>count) len = count;
	if (len<0) len = 0;
	  return len;
#else
	seq_printf(s, "%c\n", default_flag);
	return 0;
#endif
}

#ifdef CONFIG_RTL_KERNEL_MIPS16_CHAR
__NOMIPS16
#endif 
static int default_write_proc(struct file *file, const char *buffer,
				unsigned long count, void *data)
{
	if (count < 2)
		return -EFAULT;
	if (buffer && !copy_from_user(&default_flag, buffer, 1)) {
		return count;
	}
	return -EFAULT;
}

//WNC-NMR160,357-JDR230-YUAN-I-CHOU-20130327, Reset button can't be used while RakuRaku is running
#ifdef CONFIG_RTL_KERNEL_MIPS16_CHAR
__NOMIPS16
#endif 
static int raku_write_proc(struct file *file, const char *buffer, unsigned long count, void *data)
{
	char flag = 0;

	if (count < 2)
		return -EFAULT;
	if (buffer && !copy_from_user(&flag, buffer, 1)) {
		//printk("raku_flagc = %c\n", flag);
		raku_flag = flag - '0';
		//printk("raku_flag = %d\n", raku_flag);
		return count;
	}
	return -EFAULT;
}
//WNC-NMR160,357-JDR230-YUAN-I-CHOU-20130327, Reset button can't be used while RakuRaku is running End

//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140128, Reset button can't be used while WPS is running
#ifdef CONFIG_RTL_KERNEL_MIPS16_CHAR
__NOMIPS16
#endif 
static int wps_write_proc(struct file *file, const char *buffer, unsigned long count, void *data)
{
	char flag = 0;

	if (count < 2)
		return -EFAULT;
	if (buffer && !copy_from_user(&flag, buffer, 1)) {
		//printk("wps_flagc = %c\n", flag);
		wps_flag = flag - '0';
		//printk("wps_flag = %d\n", wps_flag);
		return count;
	}
	return -EFAULT;
}
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140128, Reset button can't be used while WPS is running End

#ifdef CONFIG_PROC_FS

extern struct proc_dir_entry proc_root;

int gpio_single_open(struct inode *inode, struct file *file)
{
        return(single_open(file, read_proc, NULL));
}

static ssize_t gpio_single_write(struct file * file, const char __user * userbuf,
		     size_t count, loff_t * off)
{
	return write_proc(file, userbuf,count, off);
}


struct file_operations gpio_proc_fops = {
        .open           = gpio_single_open,
	 .write		= gpio_single_write,
        .read           = seq_read,
        .llseek         = seq_lseek,
        .release        = single_release,
};

int load_default_single_open(struct inode *inode, struct file *file)
{
        return(single_open(file, default_read_proc, NULL));
}

static ssize_t load_default_single_write(struct file * file, const char __user * userbuf,
		     size_t count, loff_t * off)
{
	return default_write_proc(file, userbuf,count, off);
}

struct file_operations load_default_proc_fops = {
        .open           = load_default_single_open,
	 .write           = load_default_single_write,
        .read            = seq_read,
        .llseek          = seq_lseek,
        .release        = single_release,
};

//WNC
int wpsrun_single_open(struct inode *inode, struct file *file)
{
        return(single_open(file, wps_read_proc, NULL));
}

static ssize_t wpsrun_single_write(struct file * file, const char __user * userbuf,
		     size_t count, loff_t * off)
{
	return wps_write_proc(file, userbuf,count, off);
}

struct file_operations wpsrun_proc_fops = {
        .open           = wpsrun_single_open,
	 	.write           = wpsrun_single_write,
        .read            = seq_read,
        .llseek          = seq_lseek,
        .release        = single_release,
};

int rakurun_single_open(struct inode *inode, struct file *file)
{
        return(single_open(file, raku_read_proc, NULL));
}

static ssize_t rakurun_single_write(struct file * file, const char __user * userbuf,
		     size_t count, loff_t * off)
{
	return raku_write_proc(file, userbuf,count, off);
}

struct file_operations rakurun_proc_fops = {
        .open           = rakurun_single_open,
	 	.write           = rakurun_single_write,
        .read            = seq_read,
        .llseek          = seq_lseek,
        .release        = single_release,
};

int ledgpio_single_open(struct inode *inode, struct file *file)
{
        return(single_open(file, read_led_proc, NULL));
}

static ssize_t ledgpio_single_write(struct file * file, const char __user * userbuf,
		     size_t count, loff_t * off)
{
	return write_led_proc(file, userbuf,count, off);
}

struct file_operations ledgpio_proc_fops = {
        .open           = ledgpio_single_open,
	 	.write           = ledgpio_single_write,
        .read            = seq_read,
        .llseek          = seq_lseek,
        .release        = single_release,
};

int reset_btn_single_open(struct inode *inode, struct file *file)
{
        return(single_open(file, read_proc_reset_btn, NULL));
}

struct file_operations reset_btn_proc_fops = {
        .open           = reset_btn_single_open,
        .read            = seq_read,
        .llseek          = seq_lseek,
        .release        = single_release,
};

int modelid_single_open(struct inode *inode, struct file *file)
{
        return(single_open(file, read_proc_modelid, NULL));
}

struct file_operations modelid_proc_fops = {
        .open           = modelid_single_open,
        .read            = seq_read,
        .llseek          = seq_lseek,
        .release        = single_release,
};

int slide_sw_single_open(struct inode *inode, struct file *file)
{
        return(single_open(file, read_proc_slide_sw, NULL));
}

struct file_operations slide_sw_proc_fops = {
        .open           = slide_sw_single_open,
        .read            = seq_read,
        .llseek          = seq_lseek,
        .release        = single_release,
};



#endif

#if 0 // example
struct proc_dir_entry *hostap_proc;

static int __init hostap_init(void)
{
	if (init_net.proc_net != NULL) {
		hostap_proc = proc_mkdir("rtl865x", &proc_root);
		if (!hostap_proc)
			printk(KERN_WARNING "Failed to mkdir "
			       "/proc/rtl865x\n");
	} else
		hostap_proc = NULL;

	return 0;
}

static void __exit hostap_exit(void)
{
	if (hostap_proc != NULL) {
		hostap_proc = NULL;
		remove_proc_entry("rtl865x", &proc_root);
	}
}
#endif

static int write_watchdog_reboot(struct file *file, const char *buffer,
				unsigned long count, void *data)
{
	char tmp[16];

	if (count < 2)
		return -EFAULT;

	if (buffer && !copy_from_user(tmp, buffer, 8)) {	
		if (tmp[0] == '1') {
			local_irq_disable();	
			printk("reboot...\n");
			*(volatile unsigned long *)(0xB800311c)=0; /*this is to enable 865xc watch dog reset*/
			for(;;);
		}

		return count;
	}
	return -EFAULT;
}
int watchdog_reboot_open(struct inode *inode, struct file *file)
{
        return(single_open(file, read_proc, NULL));
}

struct file_operations watchdog_reboot_proc_fops = {
        .open           = watchdog_reboot_open,
	 .write           = write_watchdog_reboot,
        .read            = seq_read,
        .llseek          = seq_lseek,
        .release        = single_release,
};


int __init rtl_gpio_init(void)
{
//	struct proc_dir_entry *res=NULL;

	printk("Realtek GPIO Driver for Flash Reload Default\n");

#if  defined(CONFIG_RTL_8198C)
    ////todo : board related config.
    ////todo : logical function : set pin mux & jtag enable or not.

	#ifdef CONFIG_USING_JTAG
		////leroy todo////RTL_W32(RTL_GPIO_MUX, (RTL_R32(RTL_GPIO_MUX) | RTL_GPIO_MUX_GPIOA0_1));
	#else
		////leroy todo////RTL_W32(RTL_GPIO_MUX, (RTL_R32(RTL_GPIO_MUX) | RTL_GPIO_MUX_POCKETAP_DATA));
		RTL_W32(RTL_GPIO_MUX4, (RTL_R32(RTL_GPIO_MUX4) | (RTL_GPIO_MUX4_DATA))); 
		RTL_W32(RTL_GPIO_MUX5, (RTL_R32(RTL_GPIO_MUX5) | (RTL_GPIO_MUX5_DATA))); 
	#endif

#endif // #if defined(CONFIG_RTL_8198C)
       
    ////todo : logical function (+): reset pin & reset led : RTL_BSP_Set_Reset_PIN
    ////: RTL_BSP_Set_Reset_LEN
	//RTL_W32(RESET_PIN_IOBASE, (RTL_R32(RESET_PIN_IOBASE) & (~(1 << RESET_BTN_PIN))));
	//RTL_W32(RESET_PIN_DIRBASE, (RTL_R32(RESET_PIN_DIRBASE) & (~(1 << RESET_BTN_PIN))));

    #ifdef RESET_LED_NO
	// Set GPIOA ping 2 as output pin for reset led
    RTL_W32(RESET_LED_IOBASE, (RTL_R32(RESET_LED_IOBASE) | (((1 << RESET_LED_PIN)))));
	RTL_W32(RESET_LED_DIRBASE, (RTL_R32(RESET_LED_DIRBASE) | ((1 << RESET_LED_PIN))));
    #endif
    //// todo : logical function (-): reset pin & reset led
    
    #ifdef AUTO_CONFIG
#if 0	
	res = create_proc_entry("gpio", 0, NULL);
	if (res) {
		res->read_proc = read_proc;
		res->write_proc = write_proc;
	}
	else {
		printk("Realtek GPIO Driver, create proc failed!\n");
	}
#else

	proc_create_data("gpio", 0, &proc_root,
			 &gpio_proc_fops, NULL);

#endif


    #ifdef	USE_INTERRUPT_GPIO
    #ifdef  IMMEDIATE_PBC
	res = create_proc_entry("gpio_wscd_pid", 0, NULL);
	if (res)
	{
		res->read_proc = read_gpio_wscd_pid;
		res->write_proc = write_gpio_wscd_pid;
		DPRINTK("create gpio_wscd_pid OK!!!\n\n");
	}
	else{
		printk("create gpio_wscd_pid failed!\n\n");
	}
    #endif	
    #endif


		
    #if defined(USE_INTERRUPT_GPIO)
	RTL_R32(AUTOCFG_PIN_IMR) |= (0x01 << (AUTOCFG_BTN_PIN-16)*2); // enable interrupt in falling-edge	
	if (request_irq(GPIO_IRQ_NUM, gpio_interrupt_isr, IRQF_SHARED, "rtl_gpio", (void *)&priv_gpio_wps_device)) {
		printk("gpio request_irq(%d) error!\n", GPIO_IRQ_NUM);		
   	}
    #endif
		
    #endif ////end of AUTO_CONFIG

//WNC start our initialization
//WNC-JDR230-YUAN-I-CHOU-20140421, Add LED control function
	rl_gpio_led_init_timer();
//WNC-JDR230-YUAN-I-CHOU-20140421, Add LED control function End

// WNC-MRXXXX-Yuan-I-Chou-20120515-separate GPIO and LED GPIO proc file
	proc_create_data("ledgpio", 0, &proc_root, &ledgpio_proc_fops, NULL);
// WNC-MRXXXX-Yuan-I-Chou-20120515-End
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131126, Slide switch support for Voyager
	proc_create_data("slide_sw", 0, &proc_root, &slide_sw_proc_fops, NULL);
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131126, Slide switch support for Voyager
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20131127, Add MODEL ID function
	proc_create_data("modelid", 0, &proc_root, &modelid_proc_fops, NULL);
//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20131127, Add MODEL ID function End
// WNC-MRXXXX-David-20120521-add reset button proc-Start
	proc_create_data("reset_btn", 0, &proc_root, &reset_btn_proc_fops, NULL);
// WNC-MRXXXX-David-20120521-add reset button proc-End
//WNC-NMR160,357-JDR230-YUAN-I-CHOU-20130327, Reset button can't be used while RakuRaku is running
	proc_create_data("rakurun", 0, &proc_root, &rakurun_proc_fops, NULL);
//WNC-NMR160,357-JDR230-YUAN-I-CHOU-20130327, Reset button can't be used while RakuRaku is running End
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140128, Reset button can't be used while WPS is running
	proc_create_data("wpsrun", 0, &proc_root, &wpsrun_proc_fops, NULL);
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140128, Reset button can't be used while WPS is running End

#if 0
	res = create_proc_entry("load_default", 0, NULL);
	if (res) {
		res->read_proc = default_read_proc;
		res->write_proc = default_write_proc;
	}
#else	

	proc_create_data("load_default", 0, &proc_root,
			 &load_default_proc_fops, NULL);
#endif

	proc_create_data("watchdog_reboot", 0, &proc_root,
			&watchdog_reboot_proc_fops, NULL);


#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE	
	proc_create_data("bootbank", 0, &proc_root,
			&bootbank_proc_fops, NULL);
#endif

	
			
	init_timer(&probe_timer);
	probe_counter = 0;
	probe_state = PROBE_NULL;
	probe_timer.expires = jiffies + HZ;
	probe_timer.data = (unsigned long)NULL;
	probe_timer.function = &rtl_gpio_timer;
	mod_timer(&probe_timer, jiffies + HZ);
	//autoconfig_gpio_init(); //always init wps gpio
#if defined(CONFIG_RTL_8198C) && (defined(CONFIG_SERIAL_RTL_UART1)||defined(CONFIG_SERIAL_RTL_UART2))
	{
		int portnum=0x1;
#ifdef CONFIG_SERIAL_RTL_UART1
		portnum = 0x1;
#endif
		//System register Table
#define SYS_BASE 0xb8000000
#define SYS_INT_STATUS (SYS_BASE +0x04)
#define SYS_HW_STRAP   (SYS_BASE +0x08)
#define SYS_BOND_OPTION (SYS_BASE+0x0c) //new
#define SYS_CLKMANAGE (SYS_BASE +0x10)
		 
#define SYS_LX_CTRL   (SYS_BASE +0x14)
#define SYS_CLKMANAGE2   (SYS_BASE +0x18)
		 
#define SYS_PIN_MUX_SEL1 (SYS_BASE +0x100)
#define SYS_PIN_MUX_SEL2 (SYS_BASE +0x104)
#define SYS_PIN_MUX_SEL3 (SYS_BASE +0x108)
#define SYS_PIN_MUX_SEL4 (SYS_BASE +0x10c)
#define SYS_PIN_MUX_SEL5 (SYS_BASE +0x120)
		 
		 
		 
		/*
		UART pin:  VCC, GND,CTS, RTS,TX,RX
		 
		256 have JTAG, UART0 delicate pin.
		 
		UART0
		RX	:P5 RxD7:
		TX	:P5 TxD4
		 
		UART1
		JTAG CLK J19.6:  RXD : P5 GTXC: T2
		JTAG TMS J19.8:  CTS : P5 TXD7
		JTAG TDI J19.10: RTS : P5 TXD6
		JTAG TDO 19.2  : TXD : P5 TXD5
		 
		
		UART2
		U0RX: RXD: T0
		U0TX: TXD
		U0CTS:CTS(I)
		U0RTS:RTS(O)
		 
		*/
		 
		 
		 
		 if(portnum==1)
		 {
		  //UART1 using P5 pin.
		  REG32(SYS_PIN_MUX_SEL4)&=~((0xf<<3)|(7<<7)|(7<<10)|(0xf<<13));
		  REG32(SYS_PIN_MUX_SEL4)|=(0x7<<3)|(7<<7)|(7<<10)|(0x8<<13);
		  printk("value 0x%x\n",(0x7<<3)|(7<<7)|(7<<10)|(0x8<<13));
		  printk("value reg 0x%x\n",REG32(SYS_PIN_MUX_SEL4));
		 } 
		 
		 if(portnum==0x11)
		 {
		  //UART1 using JTAG pin, JTAG RESET not belong UART1
		  printk("Uart1 using jtag pin\n");
		  REG32(SYS_PIN_MUX_SEL2)&=~((0xf)|(0xf<<8)|(0xf<<12)|(0xf<<16));
		  REG32(SYS_PIN_MUX_SEL2)|=(2)|(2<<8)|(2<<12)|(2<<16);	  
		  printk("value 0x%x\n",(2)|(2<<8)|(2<<12)|(2<<16));;
		  printk("value reg 0x%x\n",REG32(SYS_PIN_MUX_SEL4));
		 }
#ifdef CONFIG_SERIAL_RTL_UART2	
		portnum = 2;
#endif
		 if(portnum==2)
		 {
		  //UART2
		  REG32(SYS_PIN_MUX_SEL2)&=~(0x1<<22)|(3<<23)|(3<<25);	
		 }	 
	}
#endif

#ifdef  CONFIG_RTL_USERSPACE_WTDOG
	proc_create_data("watchdog_cmd", 0, &proc_root,
			&watchdog_cmd_proc_fops, NULL);
			
	proc_create_data("watchdog_kick", 0, &proc_root,
			&watchdog_kick_proc_fops, NULL);
#endif
	return 0;
}


static void __exit rtl_gpio_exit(void)
{
	printk("Unload Realtek GPIO Driver \n");
	del_timer_sync(&probe_timer);

	del_timer_sync(&rl_gpio_led_timer);
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support
	del_timer_sync(&rl_skip_led_LOS_timer);
}

//WNC-JDR230-YUAN-I-CHOU-20140421, Add LED control function
/*
GPIO value 0: //ACTIVE RED, GPIO H2, High Active
GPIO value 1: //ACTIVE GREEN, GPIO B7, Low Active
GPIO value 2: //2.4G RED, GPIO H3, High Active
GPIO value 3: //2.4G GREEN, GPIO C0, Low Active
GPIO value 4: //POWER GREEN, GPIO H0, Low Active
GPIO value 5: //POWER RED, GPIO H1, High Active
GPIO value 6: //5G RED, GPIO H4, High Active
GPIO value 7: //5G GREEN, GPIO C7, Low Active
GPIO value 12: //TV RED, GPIO G2, High Active
GPIO value 13: //TV GREEN, GPIO E0, Low Active
GPIO value 14: //CNV RED, GPIO G0, High Active
GPIO value 15: //CNV GREEN, GPIO A1, Low Active
//Combination...
GPIO value 8: //ACTIVE GREEN + 2.4G GREEN + POWER GREEN //XXX+ 5G GREEN
GPIO value 9: //POWER GREEN + POWER RED
GPIO value 10: //ACTIVE GREEN + ACTIVE RED
GPIO value 11: //ACTIVE GREEN + 2.4G GREEN //XXX+ 5G GREEN
*/

#define RTL_92GPIO_DAT_0	1<<(0 + 8)
#define RTL_92GPIO_DAT_4	1<<(4 + 8)
#define RTL_92GPIO_DAT_5	1<<(5 + 8)
#define RTL_92GPIO_DAT_7	1<<(7 + 8)
#define RTL_92GPIO_DAT_8	1<<(0 + 8)
#define RTL_92GPIO_DAT_10	1<<(2 + 8)

void __LED_ON(int gpio)
{
	//printk("__LED_ON [%d]\n", gpio);
	switch (gpio) {
		case 0: //ACTIVE RED, GPIO H2, High Active
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOH2)));
			break;
		case 1: //ACTIVE GREEN, GPIO B7, Low Active
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOB7))));
			break;
		case 2: //2.4G RED, GPIO H3, High Active
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOH3)));
			break;
		case 3: //2.4G GREEN, GPIO C0, Low Active
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOC0))));
			break;
		case 4: //POWER GREEN, GPIO H0, Low Active
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOH0))));
			break;
		case 5: //POWER RED, GPIO H1, High Active
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOH1)));
			break;
		case 6: //5G RED, GPIO H4, High Active
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOH4)));
			break;
		case 7: //5G GREEN, GPIO C7, Low Active
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOC7))));
			break;
		//Combination...
		case 8: //All GREEN LEDs
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOC7 | RTL_GPIOC0 | RTL_GPIOB7 | RTL_GPIOA1))));
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOH0 | RTL_GPIOE0))));
			break;
		case 9: //POWER GREEN + POWER RED
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOH0))));
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOH1)));
			break;
		case 10: //ACTIVE GREEN + ACTIVE RED
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOB7))));
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOH2)));
			break;
		case 11: //All GREEN LEDs except Power GREEN
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOC7 | RTL_GPIOC0 | RTL_GPIOB7 | RTL_GPIOA1))));
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOE0))));
			break;
		//Combination End...
		case 12: //TV GREEN, GPIO E0, Low Active
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOE0))));
			break;
		case 13: //TV RED, GPIO G2, High Active
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOG2)));
			break;
//Jimmy update for Low Active
#if 0
		case 14: //CNV RED, GPIO G0, High Active
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOG0)));
			break;
#else
		case 14: //CNV RED, GPIO G0, Low Active
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOG0))));
			break;
#endif
		case 15: //CNV GREEN, GPIO A1, Low Active
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOA1))));
			break;
		case 16: //TV RED + 5G RED
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOG2 | RTL_GPIOH4)));
			break;
		case 17: //2.4G GREEN and 2.4G RED
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOH3)));
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) & (~(RTL_GPIOC0))));
			break;
		default: // ???
			break;
	}
}

void __LED_OFF(int gpio)
{
	//printk("__LED_OFF [%d]\n", gpio);
	switch (gpio) {
		case 0: //ACTIVE RED, GPIO H2, High Active
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOH2))));
			break;
		case 1: //ACTIVE GREEN, GPIO B7, Low Active
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOB7)));
			break;
		case 2: //2.4G RED, GPIO H3, High Active
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOH3))));
			break;
		case 3: //2.4G GREEN, GPIO C0, Low Active
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOC0)));
			break;
		case 4: //POWER GREEN, GPIO H0, Low Active
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOH0)));
			break;
		case 5: //POWER RED, GPIO H1, High Active
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOH1))));
			break;
		case 6: //5G RED, GPIO H4, High Active
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOH4))));
			break;
		case 7: //5G GREEN, GPIO C7, Low Active
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOC7)));
			break;
		//Combination...
		case 8: //All GREEN LEDs
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOC7 | RTL_GPIOC0 | RTL_GPIOB7 | RTL_GPIOA1)));
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOH0 | RTL_GPIOE0)));
			break;
		case 9: //POWER GREEN + POWER RED
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOH0)));
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOH1))));
			break;
		case 10: //ACTIVE GREEN + ACTIVE RED
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOH2))));
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOB7)));
			break;
		case 11: //All GREEN LEDs except Power GREEN
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOC7 | RTL_GPIOC0 | RTL_GPIOB7 | RTL_GPIOA1)));
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOE0)));
			break;
		//Combination End...
		case 12: //TV GREEN, GPIO E0, Low Active
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOE0)));
			break;
		case 13: //TV RED, GPIO G2, High Active
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOG2))));
			break;
//Jimmy update for Low Active				
#if 0
		case 14: //CNV RED, GPIO G0, High Active
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOG0))));
			break;
#else
		case 14: //CNV RED, GPIO G0, Lowe Active
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOG0)));
			break;
#endif			
		case 15: //CNV GREEN, GPIO A1, Low Active
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOA1)));
			break;
		case 16: //TV RED + 5G RED
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOG2 | RTL_GPIOH4))));
			break;
		case 17: //2.4G GREEN and 2.4G RED
			RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | (RTL_GPIOC0)));
			RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~(RTL_GPIOH3))));
			break;
		default: // ???
			break;
	}
}
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support
static void rl_skip_led_LOS_do_timer(unsigned long unused)
{
	printk("skip_LOS_mode [%d]", skip_LOS_mode);
	skip_LOS_mode = 0;	//Cancel Skip LOS mode flag
	if (led_LOS_mode != 0) {
		//Disable Wireless LED function
		rtl8192_led_force_off(0, 0);
		rtl8192_led_force_off(1, 0);
		//Disable Ethernet LED (HW control -> SW control and OFF)
		ethernet_led_ctl(0, 1);//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160126-Add Light OFF state support
		//(0,0) for ES1 board, (0,1) for ES2 and after board
	}
	printk(" to [%d]\n", skip_LOS_mode);
	return;
}
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support End

static void rl_gpio_led_do_timer(unsigned long unused)
{
	int i;
	unsigned int x;
	unsigned int a, b, c, d, o, t;

	for (i = 0; i < RL_GPIO_NUMBER; i++) {
		rl_gpio_led_stat[i].ticks++;
		if (rl_gpio_led_data[i].gpio == -1) //-1 means unused
			continue;
		if (rl_gpio_led_data[i].on == RL_GPIO_LED_INFINITY ||
			rl_gpio_led_data[i].off == 0) { //always on
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support
			//Skip light OFF state (3 minutes)
			//Light OFF state = disable
			//Light OFF state = except power LED and receive turn ON LED green/red event
			//Sensor LED
			if (skip_LOS_mode == 1 || led_LOS_mode == 0 || (led_LOS_mode == 1 && (i == 4 || i == 5 || i == 9)))
				__LED_ON(i);
			else
				__LED_OFF(i);
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support End
			continue;
		}
		if (rl_gpio_led_data[i].off == RL_GPIO_LED_INFINITY ||
				rl_gpio_led_data[i].rests == RL_GPIO_LED_INFINITY ||
				rl_gpio_led_data[i].on == 0 ||
				rl_gpio_led_data[i].blinks == 0 ||
				rl_gpio_led_data[i].times == 0) { //always off
			__LED_OFF(i);
			continue;
		}

		//led turn on or off
		if (rl_gpio_led_data[i].blinks == RL_GPIO_LED_INFINITY ||
				rl_gpio_led_data[i].rests == 0) { //always blinking
			x = rl_gpio_led_stat[i].ticks % (rl_gpio_led_data[i].on
					+ rl_gpio_led_data[i].off);
		}
		else {
			a = rl_gpio_led_data[i].blinks / 2;
			b = rl_gpio_led_data[i].rests / 2;
			c = rl_gpio_led_data[i].blinks % 2;
			d = rl_gpio_led_data[i].rests % 2;
			o = rl_gpio_led_data[i].on + rl_gpio_led_data[i].off;
			//t = blinking ticks
			t = a * o + rl_gpio_led_data[i].on * c;
			//x = ticks % (blinking ticks + resting ticks)
			x = rl_gpio_led_stat[i].ticks %
				(t + b * o + rl_gpio_led_data[i].on * d);
			//starts from 0 at resting cycles
			if (x >= t)
				x -= t;
			x %= o;
		}
		if (x < rl_gpio_led_data[i].on) {
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support
			//Skip light OFF state (3 minutes)
			//Light OFF state = disable
			//Light OFF state = except power LED and receive turn ON LED green/red event
			//Sensor LED
			if (skip_LOS_mode == 1 || led_LOS_mode == 0 || (led_LOS_mode == 1 && (i == 4 || i == 5 || i == 9))) {
				//WNC-NMR1566-D2R030-Yuan-I-Chou-20160407-Workaround for self test and force DHCP LED interference
				//2.4G RED LED want turn ON, but self test LED (number 11) is still active
				//Turn OFF 2.4G RED
				if ((i == 2) && (rl_gpio_led_data[11].gpio != -1)) {
					__LED_OFF(i);
				} else
				//WNC-NMR1566-D2R030-Yuan-I-Chou-20160407-Workaround for self test and force DHCP LED interference End
					__LED_ON(i);
			} else
				__LED_OFF(i);
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support End
			if (rl_gpio_led_stat[i].ticks && x == 0)
				rl_gpio_led_stat[i].offs++;
		}
		else {
			__LED_OFF(i);
			if (x == rl_gpio_led_data[i].on)
				rl_gpio_led_stat[i].ons++;
		}

		//blinking or resting
		if (rl_gpio_led_data[i].blinks == RL_GPIO_LED_INFINITY){
			// || rl_gpio_led_data[i].rests == 0) { //always blinking
			continue;
		}
		else {
			x = rl_gpio_led_stat[i].ons + rl_gpio_led_stat[i].offs;
			if (!rl_gpio_led_stat[i].resting) {
				if (x >= rl_gpio_led_data[i].blinks) {
					rl_gpio_led_stat[i].resting = 1;
					rl_gpio_led_stat[i].ons = 0;
					rl_gpio_led_stat[i].offs = 0;
					rl_gpio_led_stat[i].times++;
				}
			}
			else {
				if (x >= rl_gpio_led_data[i].rests) {
					rl_gpio_led_stat[i].resting = 0;
					rl_gpio_led_stat[i].ons = 0;
					rl_gpio_led_stat[i].offs = 0;
				}
			}
		}
		if (rl_gpio_led_stat[i].resting) {
			__LED_OFF(i);
		}

		//number of times
		if (rl_gpio_led_data[i].times != RL_GPIO_LED_INFINITY)
		{
			if (rl_gpio_led_stat[i].times >=
					rl_gpio_led_data[i].times) {
				__LED_OFF(i);
				rl_gpio_led_data[i].gpio = -1; //stop
			}
		}
	}

	init_timer(&rl_gpio_led_timer);
	rl_gpio_led_timer.expires = jiffies + RL_GPIO_LED_FREQ;
	add_timer(&rl_gpio_led_timer);
}

void rl_gpio_init(void)
{

	printk("rl_gpio_init\n");

	//Set PIN_MF_CS1N to GPIO (GPIO A1)
	RTL_W32(RTL_GPIO_MUX, (RTL_R32(RTL_GPIO_MUX) | (3<<26)));
	printk("RTL_GPIO_MUX 1[%X]\r\n", RTL_R32(RTL_GPIO_MUX));

	//Set PIN_U0_CTS to GPIO (GPIO D6)
	RTL_W32(RTL_GPIO_MUX2, (RTL_R32(RTL_GPIO_MUX2) | (3<<23)));
	printk("RTL_GPIO_MUX2 1[%X]\r\n", RTL_R32(RTL_GPIO_MUX2));

	//Set PIN_P0_RXD1, PIN_P0_RXD2, PIN_P0_RXD3 to GPIO (GPIO F1 F0 E7)
	RTL_W32(RTL_GPIO_MUX3, (RTL_R32(RTL_GPIO_MUX3) | ((3<<21) | (3<<24) | (3<<27))));
	printk("RTL_GPIO_MUX3 1[%X]\r\n", RTL_R32(RTL_GPIO_MUX3));

	//Set PIN_P5_GTXC PIN_P5_TXD7 PIN_P5_TXD5 PIN_P5_TXD3-0 PIN_P5_TXCTL to GPIO (GPIO H0 G0 G2 H1-4)
	RTL_W32(RTL_GPIO_MUX4, (RTL_R32(RTL_GPIO_MUX4) | ((3<<3) | (3<<7) | (3<<13) | (3<<23))));
	printk("RTL_GPIO_MUX4 1[%X]\r\n", RTL_R32(RTL_GPIO_MUX4));

	//Set PIN_P5_RXCTL PIN_P5_RXD3-0 PIN_P5_RXC to GPIO (GPIO H6 H7 C0 E0 B7 C7)
	RTL_W32(RTL_GPIO_MUX5, (RTL_R32(RTL_GPIO_MUX5) | ((3<<0) | (3<<14) | (3<<16) | (3<<18) | (3<<20) | (3<<22))));
	printk("RTL_GPIO_MUX5 1[%X]\r\n", RTL_R32(RTL_GPIO_MUX5));


	//GPIO Control Register (PABCD_CNR) 0xB8003500
	//Set A1 B7 C0 C7 D6 to GPIO mode (Bit value:0) 
	//printk("PABCD_CNR [%X]\r\n", RTL_R32(PABCD_CNR));
	RTL_W32(PABCD_CNR, (RTL_R32(PABCD_CNR) & 
	(~(RTL_GPIOA1 | RTL_GPIOB7 | RTL_GPIOC0 | RTL_GPIOC7 | RTL_GPIOD6))));
	printk("PABCD_CNR 1[%X]\r\n", RTL_R32(PABCD_CNR));

	//GPIO Control Register (PEFGH_CNR) 0xB800351C
	//Set E0 E7 F0 F1 G0 G2 H0 - H7 to GPIO mode (Bit value:0) 
	//printk("PEFGH_CNR [%X]\r\n", RTL_R32(PEFGH_CNR));
	RTL_W32(PEFGH_CNR, (RTL_R32(PEFGH_CNR) & 
	(~(RTL_GPIOE0 | RTL_GPIOE7 | RTL_GPIOF0 | RTL_GPIOF1 | RTL_GPIOG0 | RTL_GPIOG2 | RTL_GPIOH0 |
	   RTL_GPIOH1 | RTL_GPIOH2 | RTL_GPIOH3 | RTL_GPIOH4 | RTL_GPIOH5 | RTL_GPIOH6 | RTL_GPIOH7))));
	printk("PEFGH_CNR 1[%X]\r\n", RTL_R32(PEFGH_CNR));

	//GPIO Data Register (PABCD_DAT) 0xB800350C
	//Set A1 B7 C0 C7 to OFF, Low Active
	RTL_W32(PABCD_DAT, (RTL_R32(PABCD_DAT) | 
	(RTL_GPIOA1 | RTL_GPIOB7 | RTL_GPIOC0 | RTL_GPIOC7)));
	printk("PABCD_DAT 1[%X]\r\n", RTL_R32(PABCD_DAT));

	//GPIO Direction Register (PABCD_DIR) 0xB8003508
	//Set A1 B7 C0 C7 to output mode (Bit value:1)
	//printk("PABCD_DIR [%X]\r\n", RTL_R32(PABCD_DIR));
	RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) | 
	((RTL_GPIOA1 | RTL_GPIOB7 | RTL_GPIOC0 | RTL_GPIOC7))));
	
	//Set D6 to input mode (Bit value:0)
	RTL_W32(PABCD_DIR, (RTL_R32(PABCD_DIR) & (~(RTL_GPIOD6))));
	printk("PABCD_DIR 1[%X]\r\n", RTL_R32(PABCD_DIR));

#if 1//David fix bug--Set G2 value firstly to avoid it light when we set direction before setting its value, 20161220
	RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & (~RTL_GPIOG2)));
	printk("PEFGH_DAT 1[%X]\r\n", RTL_R32(PEFGH_DAT));
#endif

	//GPIO Direction Register (PEFGH_DIR) 0xB8003524
	//Set E0 G0 G2 H0 - H4 to output mode (Bit value:1)
	//printk("PEFGH_DIR [%X]\r\n", RTL_R32(PEFGH_DIR));
	RTL_W32(PEFGH_DIR, (RTL_R32(PEFGH_DIR) | 
	((RTL_GPIOE0 | RTL_GPIOG0 | RTL_GPIOG2 | RTL_GPIOH0 | RTL_GPIOH1 | RTL_GPIOH2 | RTL_GPIOH3 | RTL_GPIOH4))));

	//GPIO Data Register (PEFGH_DAT) 0xB8003528
	//Set E0 to OFF, Low Active
	RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | 
	(RTL_GPIOE0 | RTL_GPIOB7)));

//Jimmy update for Low Active
//set G0 low active
	RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) | (RTL_GPIOG0)));	

	//Set H0 to ON, Low Active
	//Set  G2 H1 H2 H3 H4 to OFF, High Active
	
	RTL_W32(PEFGH_DAT, (RTL_R32(PEFGH_DAT) & 
	(~(RTL_GPIOG2 | RTL_GPIOH0 | RTL_GPIOH1 | RTL_GPIOH2 | RTL_GPIOH3 | RTL_GPIOH4))));
	printk("PEFGH_DAT 1[%X]\r\n", RTL_R32(PEFGH_DAT));

	//Set E7 F0 F1 H5 H6 H7 to input mode (Bit value:0)
	//printk("PEFGH_DIR [%X]\r\n", RTL_R32(PEFGH_DIR));
	RTL_W32(PEFGH_DIR, (RTL_R32(PEFGH_DIR) & 
	(~(RTL_GPIOE7 | RTL_GPIOF0 | RTL_GPIOF1 | RTL_GPIOH5 | RTL_GPIOH6 | RTL_GPIOH7))));
	printk("PEFGH_DIR 1[%X]\r\n", RTL_R32(PEFGH_DIR));
}

void rl_gpio_led_init_timer(void)
{
	int i;

	printk("rl_gpio_led_init_timer\n");

	for (i = 0; i < RL_GPIO_NUMBER; i++)
		rl_gpio_led_data[i].gpio = -1; //-1 means unused

	rl_gpio_init();

	init_timer(&rl_gpio_led_timer);
	rl_gpio_led_timer.data = (unsigned long)NULL;
	rl_gpio_led_timer.function = &rl_gpio_led_do_timer;
	rl_gpio_led_timer.expires = jiffies + RL_GPIO_LED_FREQ;
	mod_timer(&rl_gpio_led_timer, jiffies + RL_GPIO_LED_FREQ);


//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support
	init_timer(&rl_skip_led_LOS_timer);
	rl_skip_led_LOS_timer.data = (unsigned long)NULL;
	rl_skip_led_LOS_timer.function = &rl_skip_led_LOS_do_timer;
	// 3 minutes
	rl_skip_led_LOS_timer.expires = jiffies + 3*60*HZ;
	mod_timer(&rl_skip_led_LOS_timer, jiffies + 3*60*HZ);
//WNC-NMRXXXX-D2R030-Yuan-I-Chou-20160114-Add Light OFF state support End
}

int rl_gpio_led_set(rl_gpio_led_info led)
{
	printk("rl_gpio_led_set [%d] [%d] [%d] [%d] [%d] [%d]\n", 
		led.gpio, led.on, led.off, led.blinks, led.rests, led.times);

	if (0 <= led.gpio && led.gpio < RL_GPIO_NUMBER) {
		if (led.on > RL_GPIO_LED_INFINITY)
			led.on = RL_GPIO_LED_INFINITY;
		if (led.off > RL_GPIO_LED_INFINITY)
			led.off = RL_GPIO_LED_INFINITY;
		if (led.blinks > RL_GPIO_LED_INFINITY)
			led.blinks = RL_GPIO_LED_INFINITY;
		if (led.rests > RL_GPIO_LED_INFINITY)
			led.rests = RL_GPIO_LED_INFINITY;
		if (led.times > RL_GPIO_LED_INFINITY)
			led.times = RL_GPIO_LED_INFINITY;
		if (led.on == 0 && led.off == 0 && led.blinks == 0 &&
				led.rests == 0) {
			rl_gpio_led_data[led.gpio].gpio = -1; //stop it
			return 0;
		}

		//register led data
		rl_gpio_led_data[led.gpio].gpio = led.gpio;
		rl_gpio_led_data[led.gpio].on = (led.on == 0)? 1 : led.on;
		rl_gpio_led_data[led.gpio].off = (led.off == 0)? 1 : led.off;
		rl_gpio_led_data[led.gpio].blinks = (led.blinks == 0)? 1 : led.blinks;
		rl_gpio_led_data[led.gpio].rests = (led.rests == 0)? 0 : led.rests;
		rl_gpio_led_data[led.gpio].times = (led.times == 0)? 1 : led.times;

		//clear previous led status
		rl_gpio_led_stat[led.gpio].ticks = -1;
		rl_gpio_led_stat[led.gpio].ons = 0;
		rl_gpio_led_stat[led.gpio].offs = 0;
		rl_gpio_led_stat[led.gpio].resting = 0;
		rl_gpio_led_stat[led.gpio].times = 0;

	}
	else {
		printk("gpio(%d) out of range\n", led.gpio);
		return -1;
	}
	return 0;
}
//WNC-JDR230-YUAN-I-CHOU-20130207, Add LED control function End

module_exit(rtl_gpio_exit);
module_init(rtl_gpio_init);

MODULE_LICENSE("GPL");
MODULE_DESCRIPTION("GPIO driver for Reload default");

