/*
 *      Web server handler routines for management (password, save config, f/w update)
 *
 *      Authors: David Hsu	<davidhsu@realtek.com.tw>
 *
 *      $Id: fmmgmt.c,v 1.45 2009/09/03 05:04:42 keith_huang Exp $
 *
 */

/* WNC-NMR2148-JOE-PENG-20161208-Fix bug 2148 [Aero] The DHCP lease time will be bigger after device time correction-start */
#include <stdio.h>
#include <time.h>
/* WNC-NMR2148-JOE-PENG-20161208-Fix bug 2148 [Aero] The DHCP lease time will be bigger after device time correction-end */

#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include <sys/reboot.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netinet/if_ether.h>

#include "openssl/evp.h"
#include "openssl/aes.h"
#include "libefdgx.h"

#include "boa.h"
#include "globals.h"
#include "apmib.h"
#include "apform.h"
#include "utility.h"
#include "mibtbl.h"
#include "asp_page.h"

#ifdef SUPER_NAME_SUPPORT
#include "auth.h"
#endif

// added by rock /////////////////////////////////////////
#ifdef VOIP_SUPPORT
#include "web_voip.h"
#include "voip_flash_mib.h"
#include "voip_flash_tool.h"
#endif

#if defined(POWER_CONSUMPTION_SUPPORT)
#include "powerCon.h"
#endif

#if defined(CONFIG_APP_FWD)
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/shm.h>
extern int get_shm_id();
extern set_shm_id(int id);
extern int clear_fwupload_shm();
extern char *shm_memory;
extern time_t last_access_time;
#endif

#include "libwnc.h" //WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131218, LIBWNC support
//#include "lw_fwenc.h" ////WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131223,Define FW_ENC_KEY and CF_ENC_KEY in libwnc


#define DEFAULT_GROUP		"administrators"
#define ACCESS_URL		"/"

#ifdef CONFIG_RTL_WAPI_SUPPORT
#define MTD1_SIZE 0x2d0000	//Address space: 0x2d0000
#define WAPI_SIZE 0x10000	//Address space: 64K
#define WAPI_AREA_BASE (MTD1_SIZE-WAPI_SIZE)
#endif

extern int Decode(unsigned char *ucInput, unsigned int inLen, unsigned char *ucOutput);

unsigned char *find_next_boundary(unsigned char *data, int size, char* boundary);

/* NMR1563-20160330-Fix bug 1563 [Spider] The PageID 43 R/C:ItemID2/ItemID3 does not keep setting value-start */
unsigned char show_sensor_light_log=1;
unsigned char show_sensor_notify_log=1;
/* NMR1563-20160330-Fix bug 1563 [Spider] The PageID 43 R/C:ItemID2/ItemID3 does not keep setting value-end */

#if defined(CONFIG_DOMAIN_NAME_QUERY_SUPPORT)
extern void Stop_Domain_Query_Process(void);
extern unsigned char WaitCountTime;
#endif
//static char superName[MAX_NAME_LEN]={0}, superPass[MAX_NAME_LEN]={0};
//static char userName[MAX_NAME_LEN]={0}, userPass[MAX_NAME_LEN]={0};
int isUpgrade_OK=0;
int isFWUPGRADE=0;
#ifdef BOA_WITH_SSL
int fwInProgress=0;
#endif
int isCFGUPGRADE=0;
int isREBOOTASP=0;
int Reboot_Wait=0;
int isCFG_ONLY=0;
#if defined(CONFIG_APP_FWD)
int isCountDown=0;
#endif
#ifdef LOGIN_URL
static void delete_user(request *wp);
#endif
int upgrade_method=0;

//WNC-JDR230-MRXXXX-HENG-I-CHEN-20121016, Apply Realtek SDK 3.2.2 Patch
#if defined(CONFIG_APP_FWD)
extern void * copy_to_shm(void * buff, int len);
extern void * allocate_shm(int size);
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, Add Shared memory protection
extern int clear_shm();
extern int shm_lock();
extern int shm_unlock();
extern int is_shm_locked();
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, End
#endif //#if defined(CONFIG_APP_FWD)
//WNC-JDR230-MRXXXX-HENG-I-CHEN-20121016, End

/* WNC-NMR0000-JOE-PENG-20130815-Implement section 5.12.1 Automatically MAC address registration of spec. V1.9.0 */
extern int get_mac_from_IP(char *MAC, char *remote_IP);

int configlen = 0;

int opModeHandler(request *wp, char *tmpBuf);
int find_head_offset(char *upload_data);

// WNC-NMR0765-JDR231-HENG-I-CHEN-2014-10-02: add proection of firmware file uploading #BEGIN
extern struct request * request_lock_shm;
// WNC-NMR0765-JDR231-HENG-I-CHEN-2014-10-02: add proection of firmware file uploading #END

/////////////////////////////////////////////////////////////////////////////
static int check_config_tag(unsigned char *data, int total_len)
{
	char tag_local[32],tag_config[32];
	memset(tag_local,0,sizeof(tag_local));
	apmib_get(MIB_CONFIG_TAG,tag_local);
	printf("tag_local(%s)\n",tag_local);
	if(strcmp(tag_local,"")==0) {
		return 1;
	}
	memset(tag_config,0,sizeof(tag_config));
	if(tlv_simple_mib_get(MIB_CONFIG_TAG,data,total_len,tag_config)<0)
	{
		return 0;
	}
	if(strcmp(tag_config,"")==0) {		
		return 0;
	}
	if(strcmp(tag_local,tag_config)==0)
	{		
		return 1;
	}
	return 0;
}
static int check_config_valid(unsigned char *data, int total_len)
{
	int len=0, status=1;
#ifdef HEADER_LEN_INT
	HW_PARAM_HEADER_Tp phwHeader;
#endif
	int isHdware=0;
	PARAM_HEADER_Tp pHeader;
#ifdef COMPRESS_MIB_SETTING
	COMPRESS_MIB_HEADER_Tp pCompHeader;
	unsigned char *expFile=NULL;
	unsigned int expandLen=0;
	int complen=0;
#endif
	unsigned char isValidfw = 0;
	char *ptr;
	do {
		if (
#ifdef COMPRESS_MIB_SETTING
			memcmp(&data[complen], COMP_HS_SIGNATURE, COMP_SIGNATURE_LEN) &&
			memcmp(&data[complen], COMP_DS_SIGNATURE, COMP_SIGNATURE_LEN) &&
			memcmp(&data[complen], COMP_CS_SIGNATURE, COMP_SIGNATURE_LEN)
#else
			memcmp(&data[len], CURRENT_SETTING_HEADER_TAG, TAG_LEN) &&
			memcmp(&data[len], CURRENT_SETTING_HEADER_FORCE_TAG, TAG_LEN) &&
			memcmp(&data[len], CURRENT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) &&
			memcmp(&data[len], DEFAULT_SETTING_HEADER_TAG, TAG_LEN) &&
			memcmp(&data[len], DEFAULT_SETTING_HEADER_FORCE_TAG, TAG_LEN) &&
			memcmp(&data[len], DEFAULT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) &&
			memcmp(&data[len], HW_SETTING_HEADER_TAG, TAG_LEN) &&
			memcmp(&data[len], HW_SETTING_HEADER_FORCE_TAG, TAG_LEN) &&
			memcmp(&data[len], HW_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) 
#endif
		) {
			if(isValidfw)			
				break;
		}

	if(
	#ifdef COMPRESS_MIB_SETTING
		memcmp(&data[complen], COMP_HS_SIGNATURE, COMP_SIGNATURE_LEN)==0
	#else
		memcmp(&data[len], HW_SETTING_HEADER_TAG, TAG_LEN)==0 ||
		memcmp(&data[len], HW_SETTING_HEADER_FORCE_TAG, TAG_LEN)==0 ||
		memcmp(&data[len], HW_SETTING_HEADER_UPGRADE_TAG, TAG_LEN)
	#endif
	)
	{
		isHdware=1;
	}
	else
	{
		isHdware=0;
	}

#ifdef COMPRESS_MIB_SETTING
		pCompHeader =(COMPRESS_MIB_HEADER_Tp)&data[complen];
#ifdef _LITTLE_ENDIAN_
		pCompHeader->compRate = WORD_SWAP(pCompHeader->compRate);
		pCompHeader->compLen = DWORD_SWAP(pCompHeader->compLen);
#endif
		expFile=malloc(pCompHeader->compLen*pCompHeader->compRate);
		if (NULL==expFile) {
			printf("malloc for expFile error!!\n");
			return 0;
		}
		expandLen = Decode(data+complen+sizeof(COMPRESS_MIB_HEADER_T), pCompHeader->compLen, expFile);
#ifdef HEADER_LEN_INT
		if(isHdware)
			phwHeader = (HW_PARAM_HEADER_Tp)expFile;
		else
#endif
		pHeader = (PARAM_HEADER_Tp)expFile;
#else
#ifdef HEADER_LEN_INT
		if(isHdware)
			phwHeader = (HW_PARAM_HEADER_Tp)expFile;
		else
#endif
		pHeader = (PARAM_HEADER_Tp)&data[len];
#endif
#ifdef _LITTLE_ENDIAN_
#ifdef HEADER_LEN_INT
		if(isHdware)
			phwHeader->len = DWORD_SWAP(phwHeader->len);
		else
#endif
		pHeader->len = WORD_SWAP(pHeader->len);
#endif
#ifdef HEADER_LEN_INT
		if(isHdware)
			len += sizeof(HW_PARAM_HEADER_T);
		else
#endif
		len += sizeof(PARAM_HEADER_T);
#ifdef COMPRESS_MIB_SETTING
#ifdef HEADER_LEN_INT
			if(isHdware)
				ptr = (char *)(expFile+sizeof(HW_PARAM_HEADER_T));
			else
#endif
			ptr = (char *)(expFile+sizeof(PARAM_HEADER_T));
#else
			ptr = &data[len];
#endif
#ifdef COMPRESS_MIB_SETTING
#else
#ifdef HEADER_LEN_INT
			if(isHdware)
				DECODE_DATA(ptr, phwHeader->len);
			else
#endif
			DECODE_DATA(ptr, pHeader->len);
#endif
#ifdef HEADER_LEN_INT
			if(isHdware)
			{
				if ( !CHECKSUM_OK((unsigned char *)ptr, phwHeader->len)) {
				status = 0;
				break;
				}
			}
			else
#endif
			if ( !CHECKSUM_OK((unsigned char *)ptr, pHeader->len)) {
				status = 0;
				break;
			}
#ifdef COMPRESS_MIB_SETTING
			if(isHdware == 0)
			{
				status=check_config_tag(ptr,pHeader->len);
				if(0 == status) {					
					break;
				}	
			}
#endif			
#ifdef COMPRESS_MIB_SETTING
			complen += pCompHeader->compLen+sizeof(COMPRESS_MIB_HEADER_T);
			if (expFile) {
				free(expFile);
				expFile=NULL;
			}
#else
#ifdef HEADER_LEN_INT
			if(isHdware)
				len += phwHeader->len;
			else
#endif
			len += pHeader->len;
#endif
			isValidfw=1;
			continue;
	}while (
#ifdef COMPRESS_MIB_SETTING
	(complen < total_len)
#else
	(len < total_len)
#endif	
	);
	return status;
}
/////////////////////////////////////////////////////////////////////////////


/* WNC-NMR0000-JOE-PENG-20130815-Implement section 5.12.1 Automatically MAC address registration of spec. V1.9.0->start */
/* Return value is as below: */
/* 	0:	Register MAC address of connected client to MAC filter table successfully. */
/* 		Or the MAC address of connected client has already existed in the MAC filter table. */
/* 	-1:	Failed to register MAC address of connected client to MAC filter table. */
/*																				*/
/* WNC-NMR0705-JOE-PENG-20140718-Fix bug 705 [Linear]MAC address is not registered automatically-start */
/* If a4_sta_owner_mac_str is not NULL string, we register owner MAC of a4 station instead*/
/* a4_sta_owner_mac_str is the Wi-fi MAC address string of converter or repeater that a4 station connects */
int register_mac_filter_table(request *req, int is_a4_sta, char *a4_sta_owner_mac_str)
{
//WNC-NMR2183-D2R030-YUAN-I-CHOU-20161213, Apply NEC patch
	char mac[20] = "00:00:00:00:00:00";
	int has_mac = 0;
	//char mac[20]={0};
//WNC-NMR2183-D2R030-YUAN-I-CHOU-20161213, Apply NEC patch End
	int entryNum=0, count=0;

//WNC-NMR2183-D2R030-YUAN-I-CHOU-20161213, Apply NEC patch
//	memset(mac,0x00,sizeof(mac));
//	if ((get_mac_from_IP(mac, req->remote_ip_addr) == 1) || (is_a4_sta==1)) {
	if (get_mac_from_IP(mac, req->remote_ip_addr))
		has_mac = 1;
	if (!has_mac && is_a4_sta == 0)
		return 0;				/* ignore remote access case */
	if (has_mac || (is_a4_sta == 1)) {
//WNC-NMR2183-D2R030-YUAN-I-CHOU-20161213, Apply NEC patch End
		int m1=0, m2=0, m3=0, m4=0, m5=0, m6=0;
		char buf[20]={0};

		if (is_a4_sta==1) {
			strncpy(buf, a4_sta_owner_mac_str, sizeof(buf));
			buf[sizeof(buf)-1]= '\0';	/* WNC-NMR000-[Linear]-Libera-20140912-coverity-error-93-BUFFER_SIZE_WARNING */
		} else {
			/* Get MAC address of connected client */
			if (sscanf(mac, "%02x:%02x:%02x:%02x:%02x:%02x", &m1, &m2, &m3, &m4, &m5, &m6) != 6) {
				return -1;
			}

			snprintf(buf, sizeof(buf), "%02x%02x%02x%02x%02x%02x", m1, m2, m3, m4, m5, m6);
		}

		/* Check if MAC address has already exist in MAC filter table */
		if (!apmib_get(MIB_WLAN_MACAC_NUM, (void *)&entryNum)) {
			return -1;
		}

		for (count=entryNum; count>0; count--) {
			char macaddr[30]={0};
			MACFILTER_T macEntry_temp;
				
			*((char *)&macEntry_temp) = (char)count;
			apmib_get(MIB_WLAN_MACAC_ADDR, (void *)&macEntry_temp);
				
			if (!memcmp(macEntry_temp.macAddr, "\x0\x0\x0\x0\x0\x0", 6))
				macaddr[0]='\0';
			else	
				snprintf(macaddr, sizeof(macaddr),"%02x%02x%02x%02x%02x%02x", macEntry_temp.macAddr[0], macEntry_temp.macAddr[1], macEntry_temp.macAddr[2], macEntry_temp.macAddr[3], macEntry_temp.macAddr[4], macEntry_temp.macAddr[5]);
				
			if(!memcmp(buf,macaddr,12)){
				return 0;
			}
		}

		/* Check if the number of MAC filter table has reached maximum number */
		if ( (entryNum + 1) > MAX_WLAN_AC_NUM) {
			return -1;
		}

		/* Add MAC address to MAC filter table  */
		{
			MACFILTER_T macEntry;

			memset(&macEntry,0,sizeof(MACFILTER_T));

			if (strlen(buf)!=12 || !string_to_hex(buf, macEntry.macAddr, 12)) {
				return -1;
			} else {
				/* WNC-NMR0000-JOE-PENG-20140610-Fix bug "Automatically MAC address registration does not work correctly in 2.4G and 5G Wi-Fi setting page" in Linear_PreTest_for_alpha3_0606.xlsx-start */
				if (NUM_WLAN_INTERFACE==2) {//Dual Radio. NEC Spec.: Radio 1 (2.4G); Radio 2 (5G)
					int original_wlan_idx=0, count1=0;
					
					original_wlan_idx = wlan_idx;

					for (count1=0; count1<NUM_WLAN_INTERFACE; count1++) {
						wlan_idx = count1;

						apmib_set(MIB_WLAN_AC_ADDR_DEL, (void *)&macEntry);
						if ( apmib_set(MIB_WLAN_AC_ADDR_ADD, (void *)&macEntry) == 0) {
							wlan_idx = original_wlan_idx;
							return -1;
						}
					}

					wlan_idx = original_wlan_idx;
				} else {//Single Radio. NEC Spec.: 2.4G
					apmib_set(MIB_WLAN_AC_ADDR_DEL, (void *)&macEntry);
					if ( apmib_set(MIB_WLAN_AC_ADDR_ADD, (void *)&macEntry) == 0) {
						return -1;
					}
				}
				/* WNC-NMR0000-JOE-PENG-20140610-Fix bug "Automatically MAC address registration does not work correctly in 2.4G and 5G Wi-Fi setting page" in Linear_PreTest_for_alpha3_0606.xlsx-end */
			}
		}
	} else {
		return -1;
	}	

	return 0;
}

/* NMR1827-20161027-Fix bug 1827 [Aero] When enable the [UWMA], The STA will not automatic entry to [UWMA]-start */
int register_wifi_mac_to_uwma(request *req, int is_a4_sta, char *a4_sta_owner_mac_str)
{
	char mac[20]={0};
	int entryNum=0, count=0;

	memset(mac,0x00,sizeof(mac));

	if ((get_mac_from_IP(mac, req->remote_ip_addr) == 1) || (is_a4_sta==1)) {
		int m1=0, m2=0, m3=0, m4=0, m5=0, m6=0;
		char buf[20]={0};

		if (is_a4_sta==1) {
			strncpy(buf, a4_sta_owner_mac_str, sizeof(buf));
			buf[sizeof(buf)-1]= '\0';	/* WNC-NMR000-[Linear]-Libera-20140912-coverity-error-93-BUFFER_SIZE_WARNING */

			if (sscanf(buf, "%02x%02x%02x%02x%02x%02x", &m1, &m2, &m3, &m4, &m5, &m6) != 6) {
				return -1;
			}
		} else {
			/* Get MAC address of connected client */
			if (sscanf(mac, "%02x:%02x:%02x:%02x:%02x:%02x", &m1, &m2, &m3, &m4, &m5, &m6) != 6) {
				return -1;
			}

			snprintf(buf, sizeof(buf), "%02x%02x%02x%02x%02x%02x", m1, m2, m3, m4, m5, m6);
		}

		/* Register MAC address to UWMA table if MAC address does not exist in UWMA table */
		{
			char command_buffer[256]={0}, return_string[256]={0};
			unsigned char command_prototype[] = "test_lib_getinfo2 device_name %s";
			int ret_value=0;

			snprintf(command_buffer, sizeof(command_buffer), command_prototype, buf);
			
			ret_value = lw_get_string_in_result_of_command(command_buffer, "", return_string, sizeof(return_string));
			
			if (ret_value==1) {
				if(strcmp(return_string,"")==0) {
					/* Register MAC address to UMWA table */
					int count=0;
					unsigned char macAddr[6]={0};
					ACCESS_TIMER_T at_entry;

					macAddr[0] = (unsigned char) m1;
					macAddr[1] = (unsigned char) m2;
					macAddr[2] = (unsigned char) m3;
					macAddr[3] = (unsigned char) m4;
					macAddr[4] = (unsigned char) m5;
					macAddr[5] = (unsigned char) m6;

					memset(&at_entry, 0, sizeof(ACCESS_TIMER_T));
					memcpy(at_entry.macAddr, macAddr, 6);
					snprintf(at_entry.name, sizeof(at_entry.name), "%.2X:%.2X:%.2X:%.2X:%.2X:%.2X",
						 at_entry.macAddr[0], at_entry.macAddr[1], at_entry.macAddr[2],
						 at_entry.macAddr[3], at_entry.macAddr[4], at_entry.macAddr[5]);
					if ( !apmib_set(MIB_ACCESS_TIMER_ADD, (void *)&at_entry)) {
						return -1;
					}
				}
			}
		}
	} else {
		return -1;
	}	

	return 0;
}

/* NMR1827-20161027-Fix bug 1827 [Aero] When enable the [UWMA], The STA will not automatic entry to [UWMA]-end */

/* This API is used to check if client is a4 station (Behind converter or repeater) or not */
/* Return value: 0(Client is not a4 station) or 1(Client is a4 station) */
/* P.S If 1 is returned, the MAC address of converter or repeater will by copied to a4_sta_owner_mac_str */
/* 
	# cat /proc/wlan0/a4_sta_info 
	 -- A4 STA info -- 
	    STA_MAC: 00c09fdc8b9b		=> MAC address of client
	    OWNER_MAC: 1066820209d8		=> MAC address of converter of repeater that client connects
	    Aging time: 1
*/
int is_a4_station(request *req, char *file_path, char *a4_sta_owner_mac_str, int a4_sta_owner_mac_str_len)
{
	FILE *file=NULL;
	char buffer[256]={0};
	char buf[20]={0};
	char *ptr1=NULL,*ptr2=NULL;
	int get_value_successfully=0;
	char mac[20]={0};

	/* Get MAC address of connected client from ARP table */
	memset(mac,0x00,sizeof(mac));

	if (get_mac_from_IP(mac, req->remote_ip_addr)==1) {
		int m1=0, m2=0, m3=0, m4=0, m5=0, m6=0;
			
		if (sscanf(mac, "%02x:%02x:%02x:%02x:%02x:%02x", &m1, &m2, &m3, &m4, &m5, &m6) != 6) {
			return 0;
		}
	
		snprintf(buf, sizeof(buf), "%02x%02x%02x%02x%02x%02x", m1, m2, m3, m4, m5, m6);
	} else {
		return 0;
	}

	/* Find MAC address of connected client in file_path */
	file = fopen(file_path, "r");
	if(file != NULL) {
		int find_mac_address=0;

		while(1) {
			ptr1 = fgets(buffer, 256, file);
			if (!ptr1)
				break;
					
			if ((ptr2 = strstr(ptr1, buf)) != NULL) {
				find_mac_address=1;
				break;
			}
		}

		/* After MAC address of client is found, we keep on finding a4 sta owner MAC */
		if (find_mac_address==1) {
			while(1) {
				ptr1 = fgets(buffer, 256, file);
				if (!ptr1)
					break;
						
				if ((ptr2 = strstr(ptr1, "OWNER_MAC: ")) != NULL) {
					ptr2 += strlen("OWNER_MAC: ");

					strncpy(a4_sta_owner_mac_str, ptr2, a4_sta_owner_mac_str_len);
					if (a4_sta_owner_mac_str[strlen(a4_sta_owner_mac_str)-1]=='\n') {
						a4_sta_owner_mac_str[strlen(a4_sta_owner_mac_str)-1]='\0';
					}

					get_value_successfully = 1;
					break;
				}
			}
		}

		fclose(file);
	}

	if (get_value_successfully == 1) {
		return 1;
	} else {
		return 0;
	}
}
/* WNC-NMR0705-JOE-PENG-20140718-Fix bug 705 [Linear]MAC address is not registered automatically-end */
/* WNC-NMR0000-JOE-PENG-20130815-Implement section 5.12.1 Automatically MAC address registration of spec. V1.9.0->end */

/* NMR1833-20161003-Fix bug 1833 [Aero] It will indicate the extra dialog (e.g. DLG-022LaPaBa-11) on the PC to use ether cable-start */
#define	MAX_USED_WIFI_VLAN_NUM	2
/* Return value: 0(Client is not a wireless client) or 1(Client is a wireless client) */
int is_wireless_station(request *req)
{
	char mac[20]={0}, buf[20]={0};
	int got_mac_from_arp_cache=0, is_wireless_client=0;
	
	memset(mac,0x00,sizeof(mac));

	/* Get MAC address of connected client (From ARP cache) */			
	if (get_mac_from_IP(mac, req->remote_ip_addr) == 1) {
		int m1=0, m2=0, m3=0, m4=0, m5=0, m6=0;

		if (sscanf(mac, "%02x:%02x:%02x:%02x:%02x:%02x", &m1, &m2, &m3, &m4, &m5, &m6) == 6) {
			snprintf(buf, sizeof(buf), "%02x%02x%02x%02x%02x%02x", m1, m2, m3, m4, m5, m6);
			got_mac_from_arp_cache=1;
		}
	}

	/* Check if the connected client is wireless client (or a4 client behind repeater or converter) or not */
	if (got_mac_from_arp_cache==1) {
		int vlan_count=0, count1=0;

		for (count1=0; count1<NUM_WLAN_INTERFACE; count1++) {
			for (vlan_count=0;vlan_count<MAX_USED_WIFI_VLAN_NUM;vlan_count++) {
				char *buff = NULL;

				buff = calloc(1, sizeof(WLAN_STA_INFO_T) * (MAX_STA_NUM+1));

				if ( buff == NULL) {
					console_printf("Allocate buffer failed!\n");
				} else {
					char wifi_ifname[20]={0};

					if (vlan_count == 0) {
						snprintf(wifi_ifname, sizeof(wifi_ifname), "wlan%d", count1);
					} else if (vlan_count > 0) {
						snprintf(wifi_ifname, sizeof(wifi_ifname), "wlan%d-va%d", count1, vlan_count-1);
					}

					if ( getWlStaInfo(wifi_ifname,	(WLAN_STA_INFO_Tp)buff ) < 0 ) {
						console_printf("Read wlan sta info failed!\n");
					} else {
						int count;
						WLAN_STA_INFO_Tp staInfo;

						staInfo = (WLAN_STA_INFO_Tp)&(buff[0]);
			
						for (count=1; count<=MAX_STA_NUM; count++) {						
							if (staInfo[count].aid && (staInfo[count].flag & STA_INFO_FLAG_ASOC)) {
								char macaddr[30]={0};

								console_printf("%d %.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n", count,
								staInfo[count].addr[0], staInfo[count].addr[1], staInfo[count].addr[2],
								staInfo[count].addr[3], staInfo[count].addr[4], staInfo[count].addr[5]);
				
								snprintf(macaddr, sizeof(macaddr), "%02x%02x%02x%02x%02x%02x", staInfo[count].addr[0], staInfo[count].addr[1], staInfo[count].addr[2], staInfo[count].addr[3], staInfo[count].addr[4], staInfo[count].addr[5]);

								if(!memcmp(buf,macaddr,12)){
									is_wireless_client=1;
									break;
								}
							}
						}
					}
					free(buff);

					/* Check if the client is a4 station (behind converter or repeater) or not */
					if (is_wireless_client!=1) {
						char file_path[128]={0};
						char a4_sta_owner_mac_str[20]={0};

						unsigned char temp_buffer[] = "/proc/%s/a4_sta_info";
						snprintf(file_path, sizeof(file_path), temp_buffer, wifi_ifname);

						if (is_a4_station(req, file_path, a4_sta_owner_mac_str, sizeof(a4_sta_owner_mac_str))==1) {
							is_wireless_client=1;
						}
					}
				}
			}
		}
	}

	return is_wireless_client;
}
/* NMR1833-20161003-Fix bug 1833 [Aero] It will indicate the extra dialog (e.g. DLG-022LaPaBa-11) on the PC to use ether cable-end */

/* NMR2067-20161118-Fix bug 2067 [Aero] It can not turn [ON] the MAC filtering setting during the entry max-start */
/* Return value: 0 (not register), 1 (has registered), or -1 (error happen) */
int is_register_mac_filter(request *req) {
	char mac[20]={0};
	int entryNum=0, count=0;
	int is_a4_sta=0;
	char a4_sta_owner_mac_str[20]={0};

	memset(mac,0x00,sizeof(mac));

	/* Check if whether client is wireless a4 client or not */
	{
		int vlan_count=0, count1=0;
		
		for (count1=0; count1<NUM_WLAN_INTERFACE; count1++) {
			for (vlan_count=0;vlan_count<MAX_USED_WIFI_VLAN_NUM;vlan_count++) {
				char wifi_ifname[20]={0};
				char file_path[128]={0};
				unsigned char temp_buffer[] = "/proc/%s/a4_sta_info";
		
				if (vlan_count == 0) {
					snprintf(wifi_ifname, sizeof(wifi_ifname), "wlan%d", count1);
				} else if (vlan_count > 0) {
					snprintf(wifi_ifname, sizeof(wifi_ifname), "wlan%d-va%d", count1, vlan_count-1);
				}
		
				snprintf(file_path, sizeof(file_path), temp_buffer, wifi_ifname);
		
				if (is_a4_station(req, file_path, a4_sta_owner_mac_str, sizeof(a4_sta_owner_mac_str))==1) {
					is_a4_sta=1;
				}
			}
		}
	}

	/* Check whether MAC address has already exist in MAC filter table or */
	if ((get_mac_from_IP(mac, req->remote_ip_addr) == 1) || (is_a4_sta==1)) {
		int m1=0, m2=0, m3=0, m4=0, m5=0, m6=0;
		char buf[20]={0};

		if (is_a4_sta==1) {
			strncpy(buf, a4_sta_owner_mac_str, sizeof(buf));
			buf[sizeof(buf)-1]= '\0';
		} else {
			/* Get MAC address of connected client */
			if (sscanf(mac, "%02x:%02x:%02x:%02x:%02x:%02x", &m1, &m2, &m3, &m4, &m5, &m6) != 6) {
				return -1;
			}

			snprintf(buf, sizeof(buf), "%02x%02x%02x%02x%02x%02x", m1, m2, m3, m4, m5, m6);
		}

		if (!apmib_get(MIB_WLAN_MACAC_NUM, (void *)&entryNum)) {
			return -1;
		}

		for (count=entryNum; count>0; count--) {
			char macaddr[30]={0};
			MACFILTER_T macEntry_temp;
				
			*((char *)&macEntry_temp) = (char)count;
			apmib_get(MIB_WLAN_MACAC_ADDR, (void *)&macEntry_temp);
				
			if (!memcmp(macEntry_temp.macAddr, "\x0\x0\x0\x0\x0\x0", 6))
				macaddr[0]='\0';
			else	
				snprintf(macaddr, sizeof(macaddr),"%02x%02x%02x%02x%02x%02x", macEntry_temp.macAddr[0], macEntry_temp.macAddr[1], macEntry_temp.macAddr[2], macEntry_temp.macAddr[3], macEntry_temp.macAddr[4], macEntry_temp.macAddr[5]);
				
			if(!memcmp(buf,macaddr,12)){
				return 1;
			}
		}	
	} else {
		return -1;
	}	

	return 0;
}
/* NMR2067-20161118-Fix bug 2067 [Aero] It can not turn [ON] the MAC filtering setting during the entry max-end */

/* WNC-MR0137-JOE-PENG-20120626-Fix bug that PPPoE disconnect action does not work. */
int reboot_device()
{
	int opmode = 0;

	apmib_get( MIB_OP_MODE, (void *)&opmode);

	/* Gateway Mode : Reboot device after PPP termination packets are sent by pppd. */
	/* When pppd is killed, it will firstly send PPP termination packets and then die. */
	if (opmode == GATEWAY_MODE) {
		int max_reboot_wait_time = 10;

		system("killall -9 ppp_inet");
		system("killall -15 pppd");

		/* reboot device when daemon pppd is killed successfully or non PPPoE mode. */
		/* or max_reboot_wait_time is decreased to zero. */
		while (max_reboot_wait_time > 0) {
			if (isConnectPPP() == 0){
				/* pppd is killed successfully or non PPPoE mode */
				break;
			}

			sleep(1);

			max_reboot_wait_time--;
		}

		trigger_reboot_led();

		system("reboot");
		return 0;
	}

	/* Non Gateway Mode : reboot directly */

	trigger_reboot_led();

	system("reboot");
	return 0;
}
/* WNC-MR0137-JOE-PENG-20120626-end */
static int updateConfigIntoFlash(unsigned char *data, int total_len, int *pType, int *pStatus)
{
	int len=0, status=1, type=0, ver, force;
#ifdef HEADER_LEN_INT
	HW_PARAM_HEADER_Tp phwHeader;
	int isHdware=0;
#endif
	PARAM_HEADER_Tp pHeader;
#ifdef COMPRESS_MIB_SETTING
	COMPRESS_MIB_HEADER_Tp pCompHeader;
	unsigned char *expFile=NULL;
	unsigned int expandLen=0;
	int complen=0;
	int compLen_of_header=0;
	short compRate=0;
#endif
	char *ptr;
	unsigned char isValidfw = 0;
	#if 0
	if(0 == check_config_valid(data,total_len))
	{
		printf("%s %d\n",__FUNCTION__,__LINE__);
		pStatus=0;
		return 0;
	}
	#endif
	do {
		if (
#ifdef COMPRESS_MIB_SETTING
			memcmp(&data[complen], COMP_HS_SIGNATURE, COMP_SIGNATURE_LEN) &&
			memcmp(&data[complen], COMP_DS_SIGNATURE, COMP_SIGNATURE_LEN) &&
			memcmp(&data[complen], COMP_CS_SIGNATURE, COMP_SIGNATURE_LEN)
#else
			memcmp(&data[len], CURRENT_SETTING_HEADER_TAG, TAG_LEN) &&
			memcmp(&data[len], CURRENT_SETTING_HEADER_FORCE_TAG, TAG_LEN) &&
			memcmp(&data[len], CURRENT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) &&
			memcmp(&data[len], DEFAULT_SETTING_HEADER_TAG, TAG_LEN) &&
			memcmp(&data[len], DEFAULT_SETTING_HEADER_FORCE_TAG, TAG_LEN) &&
			memcmp(&data[len], DEFAULT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) &&
			memcmp(&data[len], HW_SETTING_HEADER_TAG, TAG_LEN) &&
			memcmp(&data[len], HW_SETTING_HEADER_FORCE_TAG, TAG_LEN) &&
			memcmp(&data[len], HW_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) 
#endif
		) {
			if (isValidfw == 1)
				break;
		}
#ifdef HEADER_LEN_INT
	if(
	#ifdef COMPRESS_MIB_SETTING
		memcmp(&data[complen], COMP_HS_SIGNATURE, COMP_SIGNATURE_LEN)==0
	#else
		memcmp(&data[len], HW_SETTING_HEADER_TAG, TAG_LEN)==0 ||
		memcmp(&data[len], HW_SETTING_HEADER_FORCE_TAG, TAG_LEN)==0 ||
		memcmp(&data[len], HW_SETTING_HEADER_UPGRADE_TAG, TAG_LEN)
	#endif
	)
	{
		isHdware=1;
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-09-22: StaticCodeCheck_Linear_Delta1.zip fix 2839 USE_AFTER_FREE #BEGIN
	} else {
		isHdware=0;
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-09-22: StaticCodeCheck_Linear_Delta1.zip fix 2839 USE_AFTER_FREE #END
	}
#endif
#ifdef COMPRESS_MIB_SETTING
		pCompHeader =(COMPRESS_MIB_HEADER_Tp)&data[complen];
		compRate = WORD_SWAP(pCompHeader->compRate);
		compLen_of_header = DWORD_SWAP(pCompHeader->compLen);
		/*decompress and get the tag*/
#ifdef RTK_MIB_TAG_CHECK
		expFile=malloc(compLen_of_header*WORD_SWAP(pCompHeader->realcompRate));
#else
		expFile=malloc(compLen_of_header*compRate);
#endif
		if (NULL==expFile) {
			printf("malloc for expFile error!!\n");
			return 0;
		}
		expandLen = Decode(data+complen+sizeof(COMPRESS_MIB_HEADER_T), compLen_of_header, expFile);
#ifdef HEADER_LEN_INT
		if(isHdware)
			phwHeader = (HW_PARAM_HEADER_Tp)expFile;
		else
#endif
		pHeader = (PARAM_HEADER_Tp)expFile;
#else
#ifdef HEADER_LEN_INT
		if(isHdware)
			phwHeader = (HW_PARAM_HEADER_Tp)expFile;
		else
#endif
		pHeader = (PARAM_HEADER_Tp)&data[len];
#endif
		
#ifdef _LITTLE_ENDIAN_
#ifdef HEADER_LEN_INT
		if(isHdware)
			phwHeader->len = WORD_SWAP(phwHeader->len);
		else
#endif
		pHeader->len = HEADER_SWAP(pHeader->len);
#endif
#ifdef HEADER_LEN_INT
		if(isHdware)
			len += sizeof(HW_PARAM_HEADER_T);
		else
#endif
		len += sizeof(PARAM_HEADER_T);

        /*in case use wrong version config.dat*/
        #define MAX_CONFIG_LEN 1024*1024
        #define MIN_CONFIG_LEN 8*1024
#ifdef HEADER_LEN_INT
		if(isHdware)
        {
            if((phwHeader->len > MAX_CONFIG_LEN)||(phwHeader->len < MIN_CONFIG_LEN))
            {
                printf("INVALID config.data FILE\n");
                status = 0;
                break;
            }
        }else
#endif
        {
            if((pHeader->len > MAX_CONFIG_LEN)||(pHeader->len < MIN_CONFIG_LEN))
            {
                printf("INVALID config.data FILE\n");
                status = 0;
                break;
            }
        }

		if ( sscanf((char *)&pHeader->signature[TAG_LEN], "%02d", &ver) != 1)
			ver = -1;
			
		force = -1;
		if ( !memcmp(pHeader->signature, CURRENT_SETTING_HEADER_TAG, TAG_LEN) ) {
			isValidfw = 1;
			force = 1; // update
		}
		else if ( !memcmp(pHeader->signature, CURRENT_SETTING_HEADER_FORCE_TAG, TAG_LEN)) {
			isValidfw = 1;
			force = 2; // force
		}
		else if ( !memcmp(pHeader->signature, CURRENT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN)) {
			isValidfw = 1;
			force = 0; // upgrade
		}

		if ( force >= 0 ) {
#if 0
			if ( !force && (ver < CURRENT_SETTING_VER || // version is less than current
				(pHeader->len < (sizeof(APMIB_T)+1)) ) { // length is less than current
				status = 0;
				break;
			}
#endif

#ifdef COMPRESS_MIB_SETTING
#ifdef HEADER_LEN_INT
			if(isHdware)
				ptr = (char *)(expFile+sizeof(HW_PARAM_HEADER_T));
			else
#endif
			ptr = (char *)(expFile+sizeof(PARAM_HEADER_T));
#else
			ptr = &data[len];
#endif

#ifdef COMPRESS_MIB_SETTING
#else
#ifdef HEADER_LEN_INT
			if(isHdware)
				DECODE_DATA(ptr, phwHeader->len);
			else
#endif
			DECODE_DATA(ptr, pHeader->len);
#endif
#ifdef HEADER_LEN_INT
			if(isHdware)
			{
					if ( !CHECKSUM_OK((unsigned char *)ptr, phwHeader->len)) {
						status = 0;
						break;
					}
			}
			else
#endif
			if ( !CHECKSUM_OK((unsigned char *)ptr, pHeader->len)) {
				status = 0;
				break;
			}
//#ifdef _LITTLE_ENDIAN_
//			swap_mib_word_value((APMIB_Tp)ptr);
//#endif

// added by rock /////////////////////////////////////////
#ifdef VOIP_SUPPORT
		#ifndef VOIP_SUPPORT_TLV_CFG
			flash_voip_import_fix(&((APMIB_Tp)ptr)->voipCfgParam, &pMib->voipCfgParam);
#endif
#endif

#ifdef COMPRESS_MIB_SETTING
			apmib_updateFlash(CURRENT_SETTING, (char *)&data[complen], compLen_of_header+sizeof(COMPRESS_MIB_HEADER_T), force, ver);
#else
#ifdef HEADER_LEN_INT
			if(isHdware)
				apmib_updateFlash(CURRENT_SETTING, ptr, phwHeader->len-1, force, ver);
			else
#endif
			apmib_updateFlash(CURRENT_SETTING, ptr, pHeader->len-1, force, ver);
#endif

#ifdef COMPRESS_MIB_SETTING
			complen += compLen_of_header+sizeof(COMPRESS_MIB_HEADER_T);
			if (expFile) {
				free(expFile);
				expFile=NULL;
			}
#else
			
#ifdef HEADER_LEN_INT
			if(isHdware)
				len += phwHeader->len;
			else
#endif
			len += pHeader->len;
#endif
			type |= CURRENT_SETTING;
			continue;
		}


		if ( !memcmp(pHeader->signature, DEFAULT_SETTING_HEADER_TAG, TAG_LEN) ) {
			isValidfw = 1;
			force = 1;	// update
		}
		else if ( !memcmp(pHeader->signature, DEFAULT_SETTING_HEADER_FORCE_TAG, TAG_LEN) ) {
			isValidfw = 1;
			force = 2;	// force
		}
		else if ( !memcmp(pHeader->signature, DEFAULT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) ) {
			isValidfw = 1;
			force = 0;	// upgrade
		}

		if ( force >= 0 ) {
#if 0
			if ( (ver < DEFAULT_SETTING_VER) || // version is less than current
				(pHeader->len < (sizeof(APMIB_T)+1)) ) { // length is less than current
				status = 0;
				break;
			}
#endif

#ifdef COMPRESS_MIB_SETTING
#ifdef HEADER_LEN_INT
			if(isHdware)
				ptr = (char *)(expFile+sizeof(HW_PARAM_HEADER_T));
			else
#endif
			ptr = (char *)(expFile+sizeof(PARAM_HEADER_T));
#else
			ptr = &data[len];
#endif

#ifdef COMPRESS_MIB_SETTING
#else
#ifdef HEADER_LEN_INT
			if(isHdware)
				DECODE_DATA(ptr, phwHeader->len);
			else
#endif
			DECODE_DATA(ptr, pHeader->len);
#endif
#ifdef HEADER_LEN_INT
			if(isHdware)
			{
				if ( !CHECKSUM_OK((unsigned char *)ptr, phwHeader->len)) {
				status = 0;
				break;
				}
			}
			else
#endif
			if ( !CHECKSUM_OK((unsigned char *)ptr, pHeader->len)) {
				status = 0;
				break;
			}

//#ifdef _LITTLE_ENDIAN_
//			swap_mib_word_value((APMIB_Tp)ptr);
//#endif

// added by rock /////////////////////////////////////////
#ifdef VOIP_SUPPORT
		#ifndef VOIP_SUPPORT_TLV_CFG
			flash_voip_import_fix(&((APMIB_Tp)ptr)->voipCfgParam, &pMibDef->voipCfgParam);
#endif
#endif

#ifdef COMPRESS_MIB_SETTING
			apmib_updateFlash(DEFAULT_SETTING, (char *)&data[complen], compLen_of_header+sizeof(COMPRESS_MIB_HEADER_T), force, ver);
#else
		
#ifdef HEADER_LEN_INT
			if(isHdware)
				apmib_updateFlash(DEFAULT_SETTING, ptr, phwHeader->len-1, force, ver);
			else
#endif
			apmib_updateFlash(DEFAULT_SETTING, ptr, pHeader->len-1, force, ver);
#endif

#ifdef COMPRESS_MIB_SETTING
			complen += compLen_of_header+sizeof(COMPRESS_MIB_HEADER_T);
			if (expFile) {
				free(expFile);
				expFile=NULL;
			}	
#else
#ifdef HEADER_LEN_INT
			if(isHdware)
				len += phwHeader->len;
			else
#endif
			len += pHeader->len;
#endif
			type |= DEFAULT_SETTING;
			continue;
		}

		if ( !memcmp(pHeader->signature, HW_SETTING_HEADER_TAG, TAG_LEN) ) {
			isValidfw = 1;
			force = 1;	// update
		}
		else if ( !memcmp(pHeader->signature, HW_SETTING_HEADER_FORCE_TAG, TAG_LEN) ) {
			isValidfw = 1;
			force = 2;	// force
		}
		else if ( !memcmp(pHeader->signature, HW_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) ) {
			isValidfw = 1;
			force = 0;	// upgrade
		}

		if ( force >= 0 ) {
#if 0
			if ( (ver < HW_SETTING_VER) || // version is less than current
				(pHeader->len < (sizeof(HW_SETTING_T)+1)) ) { // length is less than current
				status = 0;
				break;
			}
#endif
#ifdef COMPRESS_MIB_SETTING
#ifdef HEADER_LEN_INT
			if(isHdware)
				ptr = (char *)(expFile+sizeof(HW_PARAM_HEADER_T));
			else
#endif
			ptr = (char *)(expFile+sizeof(PARAM_HEADER_T));
#else
			ptr = &data[len];
#endif
			

#ifdef COMPRESS_MIB_SETTING
#else
#ifdef HEADER_LEN_INT
			if(isHdware)
				DECODE_DATA(ptr, phwHeader->len);
			else
#endif
			DECODE_DATA(ptr, pHeader->len);
#endif
#ifdef HEADER_LEN_INT
			if(isHdware)
			{
				if ( !CHECKSUM_OK((unsigned char *)ptr, phwHeader->len)) {
				status = 0;
				break;
				}
			}
			else
#endif
			if ( !CHECKSUM_OK((unsigned char *)ptr, pHeader->len)) {
				status = 0;
				break;
			}
#ifdef COMPRESS_MIB_SETTING
			apmib_updateFlash(HW_SETTING, (char *)&data[complen], compLen_of_header + sizeof(COMPRESS_MIB_HEADER_T), force, ver);
#else
#ifdef HEADER_LEN_INT
			if(isHdware)
				apmib_updateFlash(HW_SETTING, ptr, phwHeader->len-1, force, ver);
			else
#endif
			apmib_updateFlash(HW_SETTING, ptr, pHeader->len-1, force, ver);
#endif

#ifdef COMPRESS_MIB_SETTING
			complen += compLen_of_header + sizeof(COMPRESS_MIB_HEADER_T);
			if (expFile) {
				free(expFile);
				expFile=NULL;
			}
#else
#ifdef HEADER_LEN_INT
			if(isHdware)
				len += phwHeader->len;
			else
#endif
			len += pHeader->len;
#endif

			type |= HW_SETTING;
			continue;
		}
#ifdef COMPRESS_MIB_SETTING
		// WNC-NMR0000-Heng-I-Chen-20130314-20130304 Coverity Errors 316 RESOURCE_LEAK 
		// WNC-NMR0000-Heng-I-Chen-20130314-20130304 Coverity Errors 317 RESOURCE_LEAK 
		if (expFile) {
			free(expFile);
			expFile=NULL;
		}
		// WNC-NMR0000-Heng-I-Chen-20130314-End 
#endif
		
	}
#ifdef COMPRESS_MIB_SETTING	
	while (complen < total_len);

	if (expFile) {
		free(expFile);
		expFile=NULL;
	}
#else
	while (len < total_len);
#endif

	*pType = type;
	*pStatus = status;
#ifdef COMPRESS_MIB_SETTING	
	return complen;
#else
	return len;
#endif
}

///////////////////////////////////////////////////////////////////////////////
/*
void sig_alm(int signo)
{
	if(isUpgrade_OK ==1){	
		reboot( RB_AUTOBOOT);
		return;
	}

}
*/
///////////////////////////////////////////////////////////////////////////////
#ifdef CONFIG_SNMP
void formSetSNMP(request *wp, char *path, char *query)
{
	
		char *submitUrl;
        char *strValue;
        int     snmpEnabled;
        struct in_addr ip;
		//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch
		//	char tmpBuf[100];
			char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
		//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch End
		submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page

        strValue = (char *)req_get_cstream_var(wp, ("snmp_enabled"), "");
		if(!strcmp(strValue, "ON")){
                snmpEnabled = 1;
        } else {
                snmpEnabled = 0;
        }
        if (!apmib_set(MIB_SNMP_ENABLED, (void *)&snmpEnabled)) {
                strcpy(tmpBuf, ("Set SNMP enabled error!"));
                goto setErr;
        }

        strValue = (char *)req_get_cstream_var(wp, ("snmp_name"), "");
        if (strValue[0]) {
                if (!apmib_set(MIB_SNMP_NAME, (void *)strValue)) {
                        strcpy(tmpBuf, ("Set SNMP location error!"));
                        goto setErr;
                }
        }

        strValue = (char *)req_get_cstream_var(wp, ("snmp_location"), "");
        if (strValue[0]) {
                if (!apmib_set(MIB_SNMP_LOCATION, (void *)strValue)) {
                        strcpy(tmpBuf, ("Set SNMP location error!"));
                        goto setErr;
                }
        }

        strValue = (char *)req_get_cstream_var(wp, ("snmp_contact"), "");
        if (strValue[0]) {
                if (!apmib_set(MIB_SNMP_CONTACT, (void *)strValue)) {
                        strcpy(tmpBuf, ("Set SNMP contact error!"));
                        goto setErr;
                }
        }
		
        strValue = (char *)req_get_cstream_var(wp, ("snmp_rwcommunity"), "");
        if (strValue[0]) {
                if (!apmib_set(MIB_SNMP_RWCOMMUNITY, (void *)strValue)) {
                        strcpy(tmpBuf, ("Set SNMP community error!"));
                        goto setErr;
                }
        }


        strValue = (char *)req_get_cstream_var(wp, ("snmp_rocommunity"), "");
        if (strValue[0]) {
                if (!apmib_set(MIB_SNMP_ROCOMMUNITY, (void *)strValue)) {
                        strcpy(tmpBuf, ("Set SNMP community error!"));
                        goto setErr;
                }
        }

        strValue = (char *)req_get_cstream_var(wp, ("snmp_trap1"), "");
        if (strValue[0]) {
                if (!inet_aton(strValue, &ip) ) {
                        strcpy(tmpBuf, ("Invalid Trap Receiver 1 IP-address value!"));
                        goto setErr;
                }
                if (!apmib_set(MIB_SNMP_TRAP_RECEIVER1, (void *)&ip)) {
                        strcpy(tmpBuf, ("Set Trap Receiver 1 IP-address error!"));
                        goto setErr;
                }
        }

        strValue = (char *)req_get_cstream_var(wp, ("snmp_trap2"), "");
        if (strValue[0]) {
                if (!inet_aton(strValue, &ip) ) {
                        strcpy(tmpBuf, ("Invalid Trap Receiver 2 IP-address value!"));
                        goto setErr;
                }
                if (!apmib_set(MIB_SNMP_TRAP_RECEIVER2, (void *)&ip)) {
                        strcpy(tmpBuf, ("Set Trap Receiver 2 IP-address error!"));
                        goto setErr;
                }
        }

        strValue = (char *)req_get_cstream_var(wp, ("snmp_trap3"), "");
        if (strValue[0]) {
                if (!inet_aton(strValue, &ip) ) {
                        strcpy(tmpBuf, ("Invalid Trap Receiver 3 IP-address value!"));
                        goto setErr;
                }
                if (!apmib_set(MIB_SNMP_TRAP_RECEIVER3, (void *)&ip)) {
                        strcpy(tmpBuf, ("Set Trap Receiver 3 IP-address error!"));
                        goto setErr;
                }
        }

        apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
        run_init_script("all");
#endif
		OK_MSG(submitUrl);
        return;

setErr:
		ERR_MSG(tmpBuf);
}
#endif /* CONFIG_SNMP */


countdown_action countdownAction = DO_NOTHING;

///////////////////////////////////////////////////////////////////////////////
void formDefaultConfig(request *wp, char *path, char *query)
{

	countdownAction = DO_DEFAULT;		
	send_redirect_perm(wp, "/reboot_main_finish.html");
}

void default_config() 
{
#if 0
/* WNC-MR0137-JOE-PENG-20120606-Fix bug that PPPoE disconnect action does not work. */
		int opmode = 0; //WNC-NMR0000-Rita-20130306-Error_485-fix warnings of cppcheck (uninitialized value).

		apmib_get( MIB_OP_MODE, (void *)&opmode);
/* WNC-MR0137-JOE-PENG-20120606-end */

/* WNC-NMR056-Libera-20120517- for getting right IP when factory default */
		apmib_get( MIB_IP_ADDR,  (void *)lan_ip_buf);
		sprintf(lan_ip,"%s",inet_ntoa(*((struct in_addr *)lan_ip_buf)) );
/* WNC-NMR056-Libera-20120517- for getting right IP when factory default - END*/
#endif

		//WNC-NMR1604-D2R030-YUAN-I-CHOU-20160419, Add flag to prevent LED blinking if user presses default in GUI
		system("touch /var/GUIDFT");
		system("echo 1 > /proc/load_default");
		
//WNC-NMR693-JDR230-YUAN-I-CHOU-20140703, Add delay for flash writing
//WNC-NMR792-JDR230-YUAN-I-CHOU-20141016, Add checking mechanism for flash writing

		//sleep(3);
		{
			int result = -1;
			
			while (result != 1) {
				system("rm -f /tmp/def");
				system("flash get DEFAULT_STATE > /tmp/def");

				if (lw_get_value_in_file("/tmp/def", "DEFAULT_STATE=", &result) != 1) {
					/* Could not get value of search string in file */
					printf("can't get DEFAULT_STATE value, Default might fail !\n");
					sleep(3);
				} else {
					//Got value of DEFAULT_STATE, let while do the judgement.
					//printf("DEFAULT_STATE value [%d]\n", result);
					sleep(1);
				}
			}
		}
//WNC-NMR792-JDR230-YUAN-I-CHOU-20141016, Add checking mechanism for flash writing End
//WNC-NMR693-JDR230-YUAN-I-CHOU-20140703, Add delay for flash writing End

#ifdef CONFIG_RTL_802_1X_CLIENT_SUPPORT
		//To clear 802.1x certs
		//RunSystemCmd(NULL_FILE, "rsCert","-rst", NULL_STR);
		system("rsCert -rst");
#endif
#ifdef CONFIG_RTL_WAPI_SUPPORT
		//To clear CA files
		system("storeWapiFiles -reset");
#endif

#if defined(CONFIG_RTL_92D_SUPPORT) || defined(CONFIG_POCKET_AP_SUPPORT)
		Reboot_Wait = 60;
#else
		//Reboot_Wait = 40;
		Reboot_Wait = 60;
#endif

		apmib_reinit();
		apmib_update_web(CURRENT_SETTING);	// update configuration to flash

#if 0
/* WNC-NMR056-Libera-20120517- for getting right IP when factory default
		apmib_get( MIB_IP_ADDR,  (void *)lan_ip_buf);
		snprintf(lan_ip, sizeof(lan_ip),"%s",inet_ntoa(*((struct in_addr *)lan_ip_buf)) );
WNC-NMR056-Libera-20120517- for getting right IP when factory default */
		/* WNC-NMR0000-JOE-PENG-20140211-Fix bug that reboot message of upload configuration page incorrect */
		OK_MSG_CONF(tmpBuf, submitUrl,Reboot_Wait,lan_ip);

// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 280 DEADCODE
/*		
		if(ptr != NULL) {
			free(ptr);
		}
*/
// WNC-NMR0000-Heng-I-Chen-20130814: End
		/* Reboot DUT. Keith */
		isUpgrade_OK=1;

/* WNC-MR0137-JOE-PENG-20120606-Fix bug that PPPoE disconnect action does not work. */
		if (opmode == GATEWAY_MODE) {
			system("killall -9 ppp_inet");
			system("killall -15 pppd");
			sleep(4);
		}
#endif
/* WNC-MR0137-JOE-PENG-20120606-end */

		reboot_device();
		
		return;
}

void formSaveConfig(request *wp, char *path, char *query)
{
	char *strRequest;
	/* WNC-MR0000-JDR230-YUAN-I-CHOU-Fix warnings of cppcheck */
// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 280 DEADCODE
//	char *ptr=NULL;
// WNC-NMR0000-Heng-I-Chen-20130814: End
	unsigned char checksum;
	int len, len1;
	char tmpBuf[200];
	CONFIG_DATA_T type=0;
	//char *submitUrl;
	char lan_ip_buf[30]={0}, lan_ip[30];//WNC-NMR0000-Rita-20130306-Error_510-fix warnings of cppcheck (uninitialized value).

	len1 = sizeof(PARAM_HEADER_T) + sizeof(APMIB_T) + sizeof(checksum) + 100;  // 100 for expansion
	len = csHeader.len;
#ifdef _LITTLE_ENDIAN_
#ifdef VOIP_SUPPORT
	// rock: don't need swap here
	// 1. write to private space (ex: flash)
	// 2. read from private space (ex: flash)
#else
	len  = WORD_SWAP(len);
#endif
#endif
	len += sizeof(PARAM_HEADER_T) + 100;
	if (len1 > len)
		len = len1;

/*
	buf = malloc(len);
	if ( buf == NULL ) {
		strlcpy(tmpBuf, "Allocate buffer failed!", sizeof(tmpBuf));
		goto back;
	}
*/
	strRequest = req_get_cstream_var(wp, ("save-cs"), "");
	if (strRequest[0])
		type |= CURRENT_SETTING;

	strRequest = req_get_cstream_var(wp, ("save"), "");
	if (strRequest[0])
		type |= CURRENT_SETTING;

	strRequest = req_get_cstream_var(wp, ("save-hs"), "");
	if (strRequest[0])
		type |= HW_SETTING;

	strRequest = req_get_cstream_var(wp, ("save-ds"), "");
	if (strRequest[0])
		type |= DEFAULT_SETTING;

	strRequest = req_get_cstream_var(wp, ("save-all"), "");
	if (strRequest[0])
		type |= HW_SETTING | DEFAULT_SETTING | CURRENT_SETTING;
	if (type) {
	//WNC-NMRXXXX-Yuan-I-Chou-20160811, Configured value restoration support
		save_cs_ds_to_file();
	//WNC-NMRXXXX-Yuan-I-Chou-20160811, Configured value restoration support End
		send_redirect_perm(wp, "/config.bin");
		return;
	}

back:
	ERR_MSG(tmpBuf);
	return;
}

//WNC-HENG-I-20160802, One firmware modification
#define IDENTIFIER_KEY_LEN	16
int checkIdentifierKey(char *data, int len) {
	int model_id = -1;
	int i = 0;
	unsigned char RafaleIdentifierKey[IDENTIFIER_KEY_LEN] = { 0x67, 0x05, 0x72, 0x61, 0x66, 0x61, 0x6C, 0x65, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x41, 0x48, 0x4F };
	unsigned char MeteorIdentifierKey[IDENTIFIER_KEY_LEN] =  { 0x67, 0x05, 0x6D, 0x65, 0x74, 0x65, 0x6F, 0x72, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x41, 0x48, 0x4F };

	if (len < IDENTIFIER_KEY_LEN) {
		return -1;
	}

	if (lw_get_modelid(&model_id) < 0) {
		return -2;
	}

	switch (model_id) {
		case 0:	//Ralale
			if (memcmp(data, RafaleIdentifierKey, IDENTIFIER_KEY_LEN) == 0)
				return 0;
			else
				return -3;
		case 1:	//Meteor
			if (memcmp(data, MeteorIdentifierKey, IDENTIFIER_KEY_LEN) == 0)
				return 0;
			else
				return -3;
		default:
			return 0;
	}
	return 0;
}
//WNC-HENG-I-20160802, One firmware modification End

void formUploadConfig(request *wp, char *path, char *query)
{
	int status=0;
	char tmpBuf[200],tmpBuf2[50];
	CONFIG_DATA_T type=0;
	char *submitUrl;
	char lan_ip_buf[30]={0}, lan_ip[30]; //WNC-NMR0000-Rita-20130305-Error_400-fix warnings of cppcheck (uninitialized value).
	int head_offset=0;
	char a[PASSWORD_SIZE]={0};//WNC-MRXXXX-YUAN-I-CHOU-20120615, User password feature
	char b = 0;//WNC-NR1607-YUAN-I-CHOU-20160419, Don't export NEC_AIM_ACCESS_AFTER_INITIALIZATION to config file
    //WNC-NMR0000-Rita-20130306-Error_509-fix warnings of cppcheck (uninitialized value).

#ifdef RTK_MIB_TAG_CHECK
	int cpuType;
	int valid_config=1;
#endif

#if defined(CONFIG_APP_FWD)
#define FWD_CONF "/var/fwd.conf"
	int newfile = 1;
	extern int get_shm_id();
	extern int clear_fwupload_shm();
	int shm_id = get_shm_id();	
#endif

	/* WNC-MR0000-Libera-20120416- move here*/
	apmib_get( MIB_IP_ADDR,  (void *)lan_ip_buf) ;
	snprintf(lan_ip, sizeof(lan_ip),"%s",inet_ntoa(*((struct in_addr *)lan_ip_buf)) );
	/* WNC-MR0000-Libera-20120416- move here - end */
	head_offset = find_head_offset((char *)wp->upload_data);
	//fprintf(stderr,"####%s:%d head_offset=%d###\n",  __FILE__, __LINE__ , head_offset);
	if (head_offset == -1) {
		/* WNC-MR0227-HENGI-CHEN-20121214 - return error html*/
//		strlcpy(tmpBuf, "Invalid file format!", sizeof(tmpBuf));
//		goto back;
		/* WNC-MR0000-Libera-20120416- return error html for NEC */
		strlcpy(tmpBuf2,"ͤ", sizeof(tmpBuf2));
		/* WNC-MR0000-JOE-PENG-20120522-Modification for specification 1.6 */
		strlcpy(tmpBuf, "ե˼Ԥޤ</br>ꤷե뤬ְäƤǽޤ</br>եǧƤ", sizeof(tmpBuf));
		//goto ErrPopup_uploadConfig;
		goto errback;
		/* WNC-MR0227-HENGI-CHEN-20121214 - end */
	}
#ifdef RTK_MIB_TAG_CHECK
	cpuType=getRTKCpuType();
	if(cpuType >= RTK_CPU_MAX){
		printf("get cpu type error\n");
	}
#ifdef COMPRESS_MIB_SETTING
	if(!memcmp(&wp->upload_data[head_offset], COMP_HS_SIGNATURE, COMP_SIGNATURE_LEN) ||
		!memcmp(&wp->upload_data[head_offset], COMP_DS_SIGNATURE, COMP_SIGNATURE_LEN) ||
		!memcmp(&wp->upload_data[head_offset], COMP_CS_SIGNATURE, COMP_SIGNATURE_LEN))
	{
		
		COMPRESS_MIB_HEADER_Tp pCompHeader;
		pCompHeader =(COMPRESS_MIB_HEADER_Tp)(&wp->upload_data[head_offset]);
		if(cpuType != ((pCompHeader->mibTag & RTK_CPU_TYPE_MASK) >> RTK_CPU_TYPE_OFFSET))
			valid_config=0;
	}
#endif
#endif	
/* WNC-MR1545-Heng-I-Chen-20120405-Decoding the encrypted config data */
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, Add Shared memory protection
#if defined(CONFIG_APP_FWD)
	if (is_shm_locked()) {
		strlcpy(tmpBuf, "Shared memory is locked!", sizeof(tmpBuf));
		goto back;
	} else
#endif
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, End
	{
		int i, j, k;
		//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131223,Define FW_ENC_KEY and CF_ENC_KEY in libwnc
		char enckey[64] = CF_ENC_KEY;
		int keylen = 0;

		keylen = strlen(enckey);

		for ( i = head_offset, j = 1, k = 0 ; i < wp->upload_len ; i++) {
			wp->upload_data[i] ^= j;
			wp->upload_data[i] ^= enckey[k];
			j++;
			if ( j > 251 )
				j = 1;
			k++;
			if ( k >= keylen)
				k = 0;
		}
	}
/* WNC-MR1545-Heng-I-Chen-20120405-End */

//WNC-HENG-I-20160802, One firmware modification
	if (checkIdentifierKey(wp->upload_data + head_offset, wp->upload_len)) {
		snprintf(tmpBuf, sizeof(tmpBuf), "Error Identifier Key");
		goto errback;
	}
	head_offset += IDENTIFIER_KEY_LEN;
//WNC-HENG-I-20160802, One firmware modification End

	if(
#ifdef 	RTK_MIB_TAG_CHECK
		valid_config &&
#endif
#ifdef COMPRESS_MIB_SETTING
		(!memcmp(&wp->upload_data[head_offset], COMP_HS_SIGNATURE, COMP_SIGNATURE_LEN) ||
		!memcmp(&wp->upload_data[head_offset], COMP_DS_SIGNATURE, COMP_SIGNATURE_LEN) ||
		!memcmp(&wp->upload_data[head_offset], COMP_CS_SIGNATURE, COMP_SIGNATURE_LEN))
#else
		(!memcmp(&wp->upload_data[head_offset], CURRENT_SETTING_HEADER_TAG, TAG_LEN) ||
		!memcmp(&wp->upload_data[head_offset], CURRENT_SETTING_HEADER_FORCE_TAG, TAG_LEN) ||
		!memcmp(&wp->upload_data[head_offset], CURRENT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) ||
		!memcmp(&wp->upload_data[head_offset], DEFAULT_SETTING_HEADER_TAG, TAG_LEN) ||
		!memcmp(&wp->upload_data[head_offset], DEFAULT_SETTING_HEADER_FORCE_TAG, TAG_LEN) ||
		!memcmp(&wp->upload_data[head_offset], DEFAULT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) ||
		!memcmp(&wp->upload_data[head_offset], HW_SETTING_HEADER_TAG, TAG_LEN) ||
		!memcmp(&wp->upload_data[head_offset], HW_SETTING_HEADER_FORCE_TAG, TAG_LEN) ||
		!memcmp(&wp->upload_data[head_offset], HW_SETTING_HEADER_UPGRADE_TAG, TAG_LEN))
#endif
	) {
//WNC-MRXXXX-YUAN-I-CHOU-20120615, User password feature
		apmib_init();
		apmib_get(MIB_USER_PASSWORD, (void *)a);
		//WNC-NR1607-YUAN-I-CHOU-20160419, Don't export NEC_AIM_ACCESS_AFTER_INITIALIZATION to config file
		apmib_get(MIB_NEC_AIM_ACCESS_AFTER_INITIALIZATION, (void *)&b);
		//WNC-NR1607-YUAN-I-CHOU-20160419, Don't export NEC_AIM_ACCESS_AFTER_INITIALIZATION to config file End
//		printf("from upload config device password [%s]!\n", a);
//WNC-MRXXXX-YUAN-I-CHOU-20120615, User password feature End

		updateConfigIntoFlash((unsigned char *)&wp->upload_data[head_offset], (wp->upload_len-head_offset), (int *)&type, &status);
	}
/* WNC-MR0000-Heng-I-Chen-20120729-enable telnet server with special configuration file that generated by MAC address. */
	else if (!memcmp(&wp->upload_data[head_offset], TELNET_ENABLE_HEADER_TAG, TAG_LEN)) {
		char hashstr[40];
		unsigned char mac[6]={0};//WNC-NMR0000-Rita-20130306-Error_518-fix warnings of cppcheck (uninitialized value).
		char buffer[40];
		char *cp;
		cp = &wp->upload_data[head_offset];
		cp += 2;
		if (strncmp(cp, "TELNETSENABLED",14) != 0)
		{
			char pbuf[256];
			snprintf(pbuf, 14, "%s", cp);
			status = 1;
			goto back;
		}
		cp += 14;
		apmib_get(MIB_HW_NIC1_ADDR, mac);
		{
			FILE *fp;
			fp = fopen("/var/macstr", "w");
			if (fp) {
				fprintf(fp, "%.2hhx%.2hhx%.2hhx%.2hhx%.2hhx%.2hhx", mac[0], mac[1], mac[2], mac[3], mac[4], mac[5]);
				fclose(fp);
			}
			system("md5sum /var/macstr > /var/machash");
			unlink("/var/macstr");
			fp = fopen("/var/machash", "r"); 
			if (fp) {
// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 94 CHECKED_RETURN
				if (fread(hashstr, 1, 32, fp) == 0){
					fclose(fp);	/* WNC-NMR000-[Linear]-Libera-20140919-coverity-error-1463- RESOURCE_LEAK */
					goto errback;
				}
// WNC-NMR0000-Heng-I-Chen-20130814: End
				fclose(fp);
			}
			hashstr[32] = '\0';
			unlink("/var/machash");
		}
		if (!strncmp(hashstr, cp, 32)) {
			int enabled = 1;
/* WNC-NMR0000-HENG-I-CHEN-20130716-Enable telnet server and MP opmode with special configuration file that generated by MAC address. */
/* WNC-NMR0000-JOE-PENG-20140619-Do not set MIB_HW_MP_OPMODE when user upload opentel file to enable telnet function of DUT-start */
#if 1
			if (apmib_set( MIB_HW_TELNETS_ENABLED, (void *)&enabled)) {
#else
			if (apmib_set( MIB_HW_TELNETS_ENABLED, (void *)&enabled) &&
				apmib_set( MIB_HW_MP_OPMODE, (void *)&enabled)) {
#endif
/* WNC-NMR0000-JOE-PENG-20140619-Do not set MIB_HW_MP_OPMODE when user upload opentel file to enable telnet function of DUT-end */
/* WNC-NMR0000-HENG-I-CHEN-20130716-End */
				apmib_update(HW_SETTING);
				type = FEATURE_KEY;
				status = 1;
				Reboot_Wait = 50;
				snprintf(tmpBuf, sizeof(tmpBuf), ("%s"), "եλޤ<br><br>ͤͭˤ뤿˺ƵưԤäƤޤ<br>ƵưܾʤŸڤʤǤ<br>");
//				OK_MSG_BEBOOT(tmpBuf, submitUrl,Reboot_Wait,lan_ip);

				/* Reboot DUT. Keith */
				isUpgrade_OK=1;
/* WNC-MR0137-JOE-PENG-20120626-Fix bug that PPPoE disconnect action does not work. */
//		reboot_device();
		countdownAction = DO_REBOOT;		
		send_redirect_perm(wp, "/reboot_main_finish.html");
/* WNC-MR0137-JOE-PENG-20120626-end */
				return;
			}
		}
	}
/* WNC-MR0000-Heng-I-Chen-20120729-End */
	if (status == 0 || type == 0) { // checksum error
	/*	strlcpy(tmpBuf, "Invalid configuration file!", sizeof(tmpBuf));
		goto back; */
		/* WNC-MR0000-Libera-20120416- return error html for NEC */
		strlcpy(tmpBuf2,"ͤ", sizeof(tmpBuf2));
		/* WNC-MR0000-JOE-PENG-20120522-Modification for specification 1.6 */
		strlcpy(tmpBuf, "ե˼Ԥޤ</br>ꤷե뤬ְäƤǽޤ</br>եǧƤ", sizeof(tmpBuf));
		//goto ErrPopup_uploadConfig;
		goto errback;
	}
	else {
		if (type) { // upload success
#ifdef CONFIG_RTL_802_1X_CLIENT_SUPPORT
			//To clear 802.1x certs
			//RunSystemCmd(NULL_FILE, "rsCert","-rst", NULL_STR);
			system("rsCert -rst");
#endif
#ifdef CONFIG_RTL_WAPI_SUPPORT 
			//To clear CA files
			system("storeWapiFiles -reset");
#endif
		}

#ifdef HOME_GATEWAY
		snprintf(tmpBuf, sizeof(tmpBuf), ("%s"), "եλޤ<br><br>ͤͭˤ뤿˺ƵưԤäƤޤ<br>ƵưܾʤŸڤʤǤ<br>");
#else
		snprintf(tmpBuf, sizeof(tmpBuf), ("%s"), "եλޤ<br><br>ͤͭˤ뤿˺ƵưԤäƤޤ<br>ƵưܾʤŸڤʤǤ");
#endif			

		/* WNC-MR0000-JOE-PENG-20120607-Set reboot time to 50 seconds */
		//Reboot_Wait = 45;
		Reboot_Wait = 50;
		/* WNC-MR0000-JOE-PENG-20120607-end */
		
		submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page
			
		apmib_reinit();
		apmib_set(MIB_USER_PASSWORD, (void *)a);//WNC-MRXXXX-YUAN-I-CHOU-20120615, User password feature
		//WNC-NR1607-YUAN-I-CHOU-20160419, Don't export NEC_AIM_ACCESS_AFTER_INITIALIZATION to config file
		apmib_set(MIB_NEC_AIM_ACCESS_AFTER_INITIALIZATION, (void *)&b);
		//WNC-NR1607-YUAN-I-CHOU-20160419, Don't export NEC_AIM_ACCESS_AFTER_INITIALIZATION to config file End

		//WNC-NMRXXXX-Yuan-I-Chou-20160811, Configured value restoration support
		b = 1;

		//Next reboot will trigger configured value restoration function.
		apmib_set(MIB_NEED_AUTO_UPDATE, (void*)&b);
		//WNC-NMRXXXX-Yuan-I-Chou-20160811, Configured value restoration support End

		apmib_update_web(CURRENT_SETTING);	// update configuration to flash
		system("flash set NEED_AUTO_UPDATE 1"); /* WNC-NMRxxx-YUAN-I-CHOU-20180425 - Configured value restoration is invalid in Lancer */
	/* WNC-MR0000-Libera-20120308- move from here to top */
	//	apmib_get( MIB_IP_ADDR,  (void *)lan_ip_buf) ;
	//	snprintf(lan_ip, sizeof(lan_ip),"%s",inet_ntoa(*((struct in_addr *)lan_ip_buf)) );
	/* WNC-MR0000-Libera-20120308- move from here to top -end */
#ifdef REBOOT_CHECK
		snprintf(lastUrl, sizeof(lastUrl),"%s",submitUrl);
		snprintf(okMsg, sizeof(okMsg),"%s",tmpBuf);
		countDownTime = Reboot_Wait;
		//send_redirect_perm(wp, COUNTDOWN_PAGE);	//libera --original Realtek
//		send_redirect_perm(wp, CONF_COUNTDOWN_PAGE);	/* WNC-MR0000-Libera-20120308- for NEC config countdown page */
		/*Reboot DUT in main loop*/
		isCFGUPGRADE=1;

		countdownAction = DO_REBOOT;		
		send_redirect_perm(wp, "/backup_main_finish.html");
#else
		/* WNC-NMR0000-JOE-PENG-20140211-Fix bug that reboot message of upload configuration page incorrect */
//		OK_MSG_CONF(tmpBuf, submitUrl,Reboot_Wait,lan_ip);

		/* Reboot DUT. Keith */
		isUpgrade_OK=1;
/* WNC-MR0137-JOE-PENG-20120626-Fix bug that PPPoE disconnect action does not work. */
//		reboot_device();
		countdownAction = DO_REBOOT;		
		send_redirect_perm(wp, "/reboot_main_finish.html");
/* WNC-MR0137-JOE-PENG-20120626-end */
#endif
		return;
	}
back:
#if defined(CONFIG_APP_FWD)		
	clear_fwupload_shm(shm_id);
#endif
	ERR_MSG(tmpBuf);
	return;
errback:	/* WNC-MR0000-Libera-20120416- for return error html */
#if 0
/* WNC-NMR0000-JOE-PENG-20140310-Correct "restore configuration file" message when user upgrade incorrect configuration file (Show the button of "Back to Top page", Refer to mail [WNCSW_NEC:1988])-start */
#if 1
	RETURN_TOP_MSG_NEC("ͤ", "ͤ", "<font color=red>ե˼Ԥޤ</br>ꤷե뤬ְäƤǽޤեǧƤ</font>", "index.htm");
#else
	/* WNC-MR0000-JOE-PENG-20120522-Modification for specification 1.6 */
	/* Upgrade fail(Return to detail page) */
	{
		int opmode=0;//WNC-NMR0000-Rita-20130310-Error_583-fix warnings of cppcheck (uninitialized value).
		/* WNC-NMR0000-JOE-PENG-20131202-Correct the return homepage link when upgrade firmware or configuration fails in repeater mode-start */
		/* WNC-NMR0240-JOE-PENG-20121210-Fix bug that return home page is incorrect if mode is repeater mode.-->start */
		int is_repeater_enabled=0;

		apmib_get(MIB_REPEATER_ENABLED1, (void *)&is_repeater_enabled);
		apmib_get( MIB_OP_MODE, (void *)&opmode);

		if (is_repeater_enabled == 1) {
			FAIL_MSG_NEC(tmpBuf2,tmpBuf,lan_ip, "home_detail_repeater.htm");
		} else {
			if (opmode == GATEWAY_MODE) {
				FAIL_MSG_NEC(tmpBuf2,tmpBuf,lan_ip, "home_detail.htm");
			} else if (opmode == BRIDGE_MODE) {
				FAIL_MSG_NEC(tmpBuf2,tmpBuf,lan_ip, "home_detail_bridge.htm");
			} else {
				FAIL_MSG_NEC(tmpBuf2,tmpBuf,lan_ip, "index.htm");
			}
		}
		/* WNC-NMR0240-JOE-PENG-20121210-Fix bug that return home page is incorrect if mode is repeater mode.-->end */
		/* WNC-NMR0000-JOE-PENG-20131202-Correct the return homepage link when upgrade firmware or configuration fails in repeater mode-end */
	}
	/* WNC-MR0000-JOE-PENG-20120522-end */
#endif
/* WNC-NMR0000-JOE-PENG-20140310-Correct "restore configuration file" message when user upgrade incorrect configuration file (Show the button of "Back to Top page", Refer to mail [WNCSW_NEC:1988])-end */
#endif
#if defined(CONFIG_APP_FWD)		
	clear_fwupload_shm(shm_id);
#endif
	send_redirect_perm(wp, "/backup_main_failure.html");
	return;
	//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130814, fix coverity error 826
//ErrPopup_uploadConfig:	/* WNC-MR0000-Libera-20120308- for popup alert */
	//POP_ERR_MSG(tmpBuf);
	//return;
	//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130814, fix coverity error 826 End
	/* WNC-MR0000-Libera-20120308- END */
}
#ifdef CONFIG_APP_OPENVPN
void formSaveOpenvpnClientConfig(request *wp, char *path, char *query)
{
	char *strRequest;	

	strRequest = req_get_cstream_var(wp, ("saveOpenvpnClientConfig"), "");
	
	if (strRequest[0]) 
	{
		//system("cp /var/openvpn/client.conf /web");
		send_redirect_perm(wp, "/client.ovpn");
	}

	return;	
}
#endif
///////////////////////////////////////////////////////////////////////////////

/* WNC-MR0000-JOE-PENG-20120405-Implement reboot page */
void formReboot(request *wp, char *path, char *query)
{
#if 0
// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 896 UNUSED_VALUE
//	char *strRequest;
// WNC-NMR0000-Heng-I-Chen-20130814: End
	char tmpBuf[200];
	char *submitUrl;
	char lan_ip_buf[30]={0}, lan_ip[30];//WNC-NMR0000-Rita-20130305-Error_441-fix warnings of cppcheck (uninitialized value).

// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 896 UNUSED_VALUE
//	strRequest = req_get_cstream_var(wp, ("reboot"), "");
	//if (strRequest[0]) {/* WNC-NMR0000-JOE-PENG-20120529-Modification for spec. v1.7.0 section 6.10 "Reboot Now" */
// WNC-NMR0000-Heng-I-Chen-20130814: End
#if defined(CONFIG_RTL_92D_SUPPORT) || defined(CONFIG_POCKET_AP_SUPPORT)
		Reboot_Wait = 60;
#else
/* WNC-NMR066-Libera-20120517-fixed  reboot time is not enough*/
		//Reboot_Wait = 40;
		Reboot_Wait = 50;
/* WNC-NMR066-Libera-20120517- fixed  reboot time is not enough - END */

#endif
#ifdef HOME_GATEWAY
		snprintf(tmpBuf, sizeof(tmpBuf), "%s","<SPAN id=show_msg class='message_red_s'>ƵưԤäƤޤƵưܾʤŸڤʤǤ</span>");
#else
		snprintf(tmpBuf, sizeof(tmpBuf), "%s", "Reload setting successfully!<br><br>The AP is booting.<br>");
#endif
		apmib_get( MIB_IP_ADDR,  (void *)lan_ip_buf);
		snprintf(lan_ip, sizeof(lan_ip),"%s",inet_ntoa(*((struct in_addr *)lan_ip_buf)) );
		OK_MSG_BEBOOT(tmpBuf, submitUrl,Reboot_Wait,lan_ip);
	//}/* WNC-NMR0000-JOE-PENG-20120529-Modification for spec. v1.7.0 section 6.10 "Reboot Now" */
#endif
	
	countdownAction = DO_REBOOT;
	send_redirect_perm(wp, "/reboot_main_finish.html");

	return;
}
/* WNC-MR0000-JOE-PENG-20120405-end */
/* Do reboot after setting done */
void formDoReboot(request *wp, char *path, char *query)
{
	if (countdownAction == DO_REBOOT) {
		reboot_device();
	} else 	if (countdownAction == DO_DEFAULT) {
		default_config();
	}
}

#if 0 //Keith. move to utility.c
void kill_processes(void)
{


	printf("upgrade: killing tasks...\n");
	
	kill(1, SIGTSTP);		/* Stop init from reforking tasks */
	kill(1, SIGSTOP);		
	kill(2, SIGSTOP);		
	kill(3, SIGSTOP);		
	kill(4, SIGSTOP);		
	kill(5, SIGSTOP);		
	kill(6, SIGSTOP);		
	kill(7, SIGSTOP);		
	//atexit(restartinit);		/* If exit prematurely, restart init */
	sync();

	signal(SIGTERM,SIG_IGN);	/* Don't kill ourselves... */
	setpgrp(); 			/* Don't let our parent kill us */
	sleep(1);
	signal(SIGHUP, SIG_IGN);	/* Don't die if our parent dies due to
					 * a closed controlling terminal */
	
}
#endif //#if 0 //Keith. move to utility.c

//////////////////////////////////////////////////////////////////////////////
#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE

#define SQSH_SIGNATURE		((char *)"sqsh")
#define SQSH_SIGNATURE_LE       ((char *)"hsqs")

#define IMAGE_ROOTFS 2
#define IMAGE_KERNEL 1
#define GET_BACKUP_BANK 2
#define GET_ACTIVE_BANK 1

#define GOOD_BANK_MARK_MASK 0x80000000  //goo abnk mark must set bit31 to 1

#define NO_IMAGE_BANK_MARK 0x80000000  
#define OLD_BURNADDR_BANK_MARK 0x80000001 
#define BASIC_BANK_MARK 0x80000002           
#define FORCEBOOT_BANK_MARK 0xFFFFFFF0  //means always boot/upgrade in this bank

#ifndef CONFIG_MTD_NAND
char *Kernel_dev_name[2]=
 {
   "/dev/mtdblock0", "/dev/mtdblock2"
 };
char *Rootfs_dev_name[2]=
 {
   "/dev/mtdblock1", "/dev/mtdblock3"
 };

#if defined(CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE)
#if defined(CONFIG_RTL_FLASH_DUAL_IMAGE_WEB_BACKUP_ENABLE)
char *Web_dev_name[2]=
{
	"/dev/mtdblock0", "/dev/mtdblock2"
};
#endif
#endif
#else
char *Kernel_dev_name[2]=
 {
   "/dev/mtdblock2", "/dev/mtdblock5"
 };
char *Rootfs_dev_name[2]=
 {
   "/dev/mtdblock3", "/dev/mtdblock6"
 };

#if defined(CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE)
#if defined(CONFIG_RTL_FLASH_DUAL_IMAGE_WEB_BACKUP_ENABLE)
char *Web_dev_name[2]=
{
	"/dev/mtdblock2", "/dev/mtdblock5"
};
#endif
#endif


#endif

static int get_actvie_bank()
{
	FILE *fp;
	char buffer[2];
	int bootbank;
	fp = fopen("/proc/bootbank", "r");
	
	if (!fp) {
		fprintf(stderr,"%s\n","Read /proc/bootbank failed!\n");
	}else
	{
			//fgets(bootbank, sizeof(bootbank), fp);
			fgets(buffer, sizeof(buffer), fp);
			fclose(fp);
	}
	bootbank = buffer[0] - 0x30;	
	if ( bootbank ==1 || bootbank ==2)
		return bootbank;
	else
		return 1;	
}

void get_bank_info(int dual_enable,int *active,int *backup)
{
	int bootbank=0,backup_bank;
	
	bootbank = get_actvie_bank();	

	if(bootbank == 1 )
	{
		if( dual_enable ==0 )
			backup_bank =1;
		else
			backup_bank =2;
	}
	else if(bootbank == 2 )
	{
		if( dual_enable ==0 )
			backup_bank =2;
		else
			backup_bank =1;
	}
	else
	{
		bootbank =1 ;
		backup_bank =1 ;
	}	

	*active = bootbank;
	*backup = backup_bank;	

	//fprintf(stderr,"get_bank_info active_bank =%d , backup_bank=%d  \n",*active,*backup); //mark_debug	   
}
static unsigned long header_to_mark(int  flag, IMG_HEADER_Tp pHeader)
{
	unsigned long ret_mark=NO_IMAGE_BANK_MARK;
	//mark_dual ,  how to diff "no image" "image with no bank_mark(old)" , "boot with lowest priority"
	if(flag) //flag ==0 means ,header is illegal
	{
		if( (pHeader->burnAddr & GOOD_BANK_MARK_MASK) )
			ret_mark=pHeader->burnAddr;	
		else
			ret_mark = OLD_BURNADDR_BANK_MARK;
	}
	return ret_mark;
}

// return,  0: not found, 1: linux found, 2:linux with root found
static int check_system_image(int fh,IMG_HEADER_Tp pHeader)
{
	// Read header, heck signature and checksum
	int i, ret=0;		
	char image_sig[4]={0};
	char image_sig_root[4]={0};
	
        /*check firmware image.*/
	if ( read(fh, pHeader, sizeof(IMG_HEADER_T)) != sizeof(IMG_HEADER_T)) 
     		return 0;	
	
	memcpy(image_sig, FW_HEADER, SIGNATURE_LEN);
	memcpy(image_sig_root, FW_HEADER_WITH_ROOT, SIGNATURE_LEN);

	if (!memcmp(pHeader->signature, image_sig, SIGNATURE_LEN))
		ret=1;
	else if  (!memcmp(pHeader->signature, image_sig_root, SIGNATURE_LEN))
		ret=2;
	else{
		printf("no sys signature at !\n");
	}				
       //mark_dual , ignore checksum() now.(to do) 
	return (ret);
}

static int check_rootfs_image(int fh)
{
	// Read header, heck signature and checksum
	int i;
	unsigned short sum=0, *word_ptr;
	unsigned long length=0;
	unsigned char rootfs_head[SIGNATURE_LEN];		
	
	if ( read(fh, &rootfs_head, SIGNATURE_LEN ) != SIGNATURE_LEN ) 
     		return 0;	
	
	if ( memcmp(rootfs_head, SQSH_SIGNATURE, SIGNATURE_LEN) && memcmp(rootfs_head, SQSH_SIGNATURE_LE, SIGNATURE_LEN)) {
		printf("no rootfs signature at !\n");
		return 0;
	}
	
	return 1;
}

static int get_image_header(int fh,IMG_HEADER_Tp header_p)
{
	int ret=0;
	//check 	CODE_IMAGE_OFFSET2 , CODE_IMAGE_OFFSET3 ?
	//ignore check_image_header () for fast get header , assume image are same offset......	
	// support CONFIG_RTL_FLASH_MAPPING_ENABLE ? , scan header ...
#ifndef CONFIG_MTD_NAND
	lseek(fh, CODE_IMAGE_OFFSET, SEEK_SET);		
#else
	lseek(fh, CODE_IMAGE_OFFSET-NAND_BOOT_SETTING_SIZE, SEEK_SET);	
#endif
	ret = check_system_image(fh,header_p);

	//assume , we find the image header in CODE_IMAGE_OFFSET
#ifndef CONFIG_MTD_NAND
	lseek(fh, CODE_IMAGE_OFFSET, SEEK_SET);	
#else
	lseek(fh, CODE_IMAGE_OFFSET-NAND_BOOT_SETTING_SIZE, SEEK_SET);	
#endif
	
	return ret;	
}

 int check_bank_image(int bank)
{
	int i,ret=0;	
    int fh,fh_rootfs;

#ifdef MTD_NAME_MAPPING
	char linuxMtd[16],rootfsMtd[16];
#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE
	char linuxMtd2[16],rootfsMtd2[16];
#endif

	if(rtl_name_to_mtdblock(FLASH_LINUX_NAME,linuxMtd) == 0
			|| rtl_name_to_mtdblock(FLASH_ROOTFS_NAME,rootfsMtd) == 0){
		printf("cannot mapping %s and %s\n",FLASH_LINUX_NAME,FLASH_ROOTFS_NAME);
		return 0;
	}
#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE
	if(rtl_name_to_mtdblock(FLASH_LINUX_NAME2,linuxMtd2) == 0
			|| rtl_name_to_mtdblock(FLASH_ROOTFS_NAME2,rootfsMtd2) == 0){
		printf("cannot mapping %s and %s\n",FLASH_LINUX_NAME2,FLASH_ROOTFS_NAME2);
		return 0;
	}
#endif

	Kernel_dev_name[0] = linuxMtd;
	Rootfs_dev_name[0] = rootfsMtd;
#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE	
	Kernel_dev_name[1] = linuxMtd2;
	Rootfs_dev_name[1] = rootfsMtd2;
#endif
#endif

    
	char *rootfs_dev = Rootfs_dev_name[bank-1];	
	char *kernel_dev = Kernel_dev_name[bank-1];	
	IMG_HEADER_T header;
           	
	fh = open(kernel_dev, O_RDONLY);
	if ( fh == -1 ) {
      		printf("Open file failed!\n");
		return 0;
	}
	ret = get_image_header(fh,&header);			
	
	close(fh);	
	if(ret==2)
        {	
	      	fh_rootfs = open(rootfs_dev, O_RDONLY);
		if ( fh_rootfs == -1 ) {
      		printf("Open file failed!\n");
		return 0;
		}
              ret=check_rootfs_image(fh_rootfs);
		close(fh_rootfs);	  
	  }
	return ret;
}

int write_header_bankmark(char *kernel_dev, unsigned long bankmark)
{
	int ret=0,fh,numWrite;
	IMG_HEADER_T header,*header_p;
	char buffer[200]; //mark_debug
	
	header_p = &header;
	fh = open(kernel_dev, O_RDWR);

	if ( fh == -1 ) {
      		printf("Open file failed!\n");
		return -1;
	}
	ret = get_image_header(fh,&header);

	if(!ret)
		return -2; //can't find active(current) imager header ...something wrong

	//fh , has been seek to correct offset	

	header_p->burnAddr = bankmark;

	//sprintf(buffer, ("write_header_bankmark kernel_dev =%s , bankmark=%x \n"), kernel_dev , header_p->burnAddr);
       //fprintf(stderr, "%s\n", buffer); //mark_debug	
       
	 //move to write image header will be done in get_image_header
	numWrite = write(fh, (char *)header_p, sizeof(IMG_HEADER_T));
	
	close(fh);
	
	return 0;	//success
}


// return,  0: not found, 1: linux found, 2:linux with root found

unsigned long get_next_bankmark(char *kernel_dev,int dual_enable)
{
    unsigned long bankmark=NO_IMAGE_BANK_MARK;
    int ret=0,fh;
    IMG_HEADER_T header; 	
	
	fh = open(kernel_dev, O_RDONLY);
	if ( fh == -1 ) {
      		fprintf(stderr,"%s\n","Open file failed!\n");
		return NO_IMAGE_BANK_MARK;
	}
	ret = get_image_header(fh,&header);	

	//fprintf(stderr,"get_next_bankmark = %s , ret = %d \n",kernel_dev,ret); //mark_debug

	bankmark= header_to_mark(ret, &header);	
	close(fh);
	//get next boot mark

	if( bankmark < BASIC_BANK_MARK)
		return BASIC_BANK_MARK;
	else if( (bankmark ==  FORCEBOOT_BANK_MARK) || (dual_enable == 0)) //dual_enable = 0 ....
	{
		return FORCEBOOT_BANK_MARK;//it means dual bank disable
	}
	else
		return bankmark+1;
	
}

// set mib at the same time or get mib to set this function? 
int set_dualbank(int enable)
{	
	int ret =0, active_bank=0, backup_bank=0;
	unsigned long bankmark=0;
	
#ifdef MTD_NAME_MAPPING
	char linuxMtd[16],rootfsMtd[16];
#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE
	char linuxMtd2[16],rootfsMtd2[16];
#endif

	if(rtl_name_to_mtdblock(FLASH_LINUX_NAME,linuxMtd) == 0
			|| rtl_name_to_mtdblock(FLASH_ROOTFS_NAME,rootfsMtd) == 0){
		printf("cannot mapping %s and %s\n",FLASH_LINUX_NAME,FLASH_ROOTFS_NAME);
		return 0;
	}
#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE
	if(rtl_name_to_mtdblock(FLASH_LINUX_NAME2,linuxMtd2) == 0
			|| rtl_name_to_mtdblock(FLASH_ROOTFS_NAME2,rootfsMtd2) == 0){
		printf("cannot mapping %s and %s\n",FLASH_LINUX_NAME2,FLASH_ROOTFS_NAME2);
		return 0;
	}
#endif

	Kernel_dev_name[0] = linuxMtd;
	Rootfs_dev_name[0] = rootfsMtd;
#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE	
	Kernel_dev_name[1] = linuxMtd2;
	Rootfs_dev_name[1] = rootfsMtd2;
#endif
#endif

	get_bank_info(enable,&active_bank,&backup_bank);    	
	if(enable)
	{
		//set_to mib to 1.??		
		bankmark = get_next_bankmark(Kernel_dev_name[backup_bank-1],enable);		
		ret = write_header_bankmark(Kernel_dev_name[active_bank-1], bankmark);
	}
	else //disable this
	{
		//set_to mib to 0 .??		
		ret = write_header_bankmark(Kernel_dev_name[active_bank-1], FORCEBOOT_BANK_MARK);		
	}	
	if(!ret)
	{
   	       apmib_set( MIB_DUALBANK_ENABLED, (void *)&enable);
		//fprintf(stderr,"set_dualbank enable =%d ,ret2 =%d  \n",enable,ret2); //mark_debug			
	}
	
	return ret; //-1 fail , 0 : ok
}

// need to reject this function if dual bank is disable
int  boot_from_backup()
{
	int ret =0, active_bank=0, backup_bank=0;
	unsigned long bankmark=0;	

	get_bank_info(1,&active_bank,&backup_bank);    

	ret = check_bank_image(backup_bank);	
	if(!ret)
	    return -2;
	    
#ifdef MTD_NAME_MAPPING
	char linuxMtd[16],rootfsMtd[16];
#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE
	char linuxMtd2[16],rootfsMtd2[16];
#endif
	

	if(rtl_name_to_mtdblock(FLASH_LINUX_NAME,linuxMtd) == 0
			|| rtl_name_to_mtdblock(FLASH_ROOTFS_NAME,rootfsMtd) == 0){
		printf("cannot mapping %s and %s\n",FLASH_LINUX_NAME,FLASH_ROOTFS_NAME);
		return 0;
	}
#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE
	if(rtl_name_to_mtdblock(FLASH_LINUX_NAME2,linuxMtd2) == 0
			|| rtl_name_to_mtdblock(FLASH_ROOTFS_NAME2,rootfsMtd2) == 0){
		printf("cannot mapping %s and %s\n",FLASH_LINUX_NAME2,FLASH_ROOTFS_NAME2);
		return 0;
	}
#endif

	Kernel_dev_name[0] = linuxMtd;
	Rootfs_dev_name[0] = rootfsMtd;
#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE	
	Kernel_dev_name[1] = linuxMtd2;
	Rootfs_dev_name[1] = rootfsMtd2;
#endif
#endif

	bankmark = get_next_bankmark(Kernel_dev_name[active_bank-1],1);
	
	ret = write_header_bankmark(Kernel_dev_name[backup_bank-1], bankmark);

	return ret; //-2 , no kernel , -1 fail , 0 : ok}
}
#endif

int find_head_offset(char *upload_data)
{
	int head_offset=0 ;
	char *pStart=NULL;
	int iestr_offset=0;
	char *dquote;
	char *dquote1;
	
	if (upload_data==NULL) {
		//fprintf(stderr, "upload data is NULL\n");
		return -1;
	}

	pStart = strstr(upload_data, WINIE6_STR);
	if (pStart == NULL) {
		pStart = strstr(upload_data, LINUXFX36_FWSTR);
		if (pStart == NULL) {
			pStart = strstr(upload_data, WINIE10_STR);	/* WNC-NMR160-Libera-20120620 - for IE10*/
			if (pStart == NULL) {
				pStart = strstr(upload_data, MACIE5_FWSTR);
				if (pStart == NULL) {
					pStart = strstr(upload_data, OPERA_FWSTR);
					if (pStart == NULL) {
						pStart = strstr(upload_data, "filename=");
						if (pStart == NULL) {
							return -1;
						}
						else {
							dquote =  strstr(pStart, "\"");
							if (dquote !=NULL) {
								dquote1 = strstr(dquote, LINE_FWSTR);
								if (dquote1!=NULL) {
									iestr_offset = 4;
									pStart = dquote1;
								}
								else {
									return -1;
								}
							}
							else {
								return -1;
							}
						}
					}
					else {
						iestr_offset = 16;
					}
				} 
				else {
					iestr_offset = 14;
				}
			}
			else {
				iestr_offset = 18;	/* WNC-NMR160-Libera-20120620 - for IE10*/
			}
	}
		else {
			iestr_offset = 26;
		}
	}
	else {
		iestr_offset = 17;
	}
	//fprintf(stderr,"####%s:%d %d###\n",  __FILE__, __LINE__ , iestr_offset);
	head_offset = (int)(((unsigned long)pStart)-((unsigned long)upload_data)) + iestr_offset;
	return head_offset;
}

extern int firmware_len;
extern char *firmware_data;

void formDoFirmwareUpgrade(request *wp, char * path, char * query)
{
	fprintf(stderr,"\r\n%s %d isFWUPGRADE %d isREBOOTASP %d\r\n",__FILE__,__LINE__,isFWUPGRADE ,isREBOOTASP);
	
	if (isFWUPGRADE !=0 && isREBOOTASP == 1 ) {
		char buffer[200];
		//fprintf(stderr,"\r\n [%s-%u] FirmwareUpgrade start",__FILE__,__LINE__);
		FirmwareUpgrade(firmware_data, firmware_len, 0, buffer, sizeof(buffer));
		//fprintf(stderr,"\r\n [%s-%u] FirmwareUpgrade end",__FILE__,__LINE__);
		//system("echo 7 > /proc/gpio"); // disable system LED
		isFWUPGRADE=0;
		isREBOOTASP=0;
		//reboot_time = 5;
	}
}

int FirmwareUpgrade(char *upload_data, int upload_len, int is_root, char *buffer, int buffer_len)
{
	int head_offset=0 ;
	int isIncludeRoot=0;
	int		 len;
	int          locWrite;
	int          numLeft;
	int          numWrite=0;//WNC-NMR0000-Rita-20130310-Error_612-fix warnings of cppcheck (uninitialized value).
	IMG_HEADER_Tp pHeader;
	int flag=0, startAddr=-1, startAddrWeb=-1;
	int update_fw=0, update_cfg=0;
	int fh;
	//unsigned char cmdBuf[30];
	//Support WAPI/openssl, the flash MUST up to 4m
/*
#if defined(CONFIG_RTL_WAPI_SUPPORT) || defined(HTTP_FILE_SERVER_SUPPORTED) || defined(CONFIG_APP_TR069)
	int fwSizeLimit = 0x400000;
#elif defined( CONFIG_RTK_VOIP )
	int fwSizeLimit = 0x400000;
#else
	int fwSizeLimit = 0x200000;
#endif
*/
	int fwSizeLimit = CONFIG_FLASH_SIZE;
#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE
	int active_bank,backup_bank;
	int dual_enable =0;
#endif

	unsigned char isValidfw = 0;

#ifdef MTD_NAME_MAPPING
	char webpageMtd[16],linuxMtd[16],rootfsMtd[16];
#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE
	char webpageMtd2[16],linuxMtd2[16],rootfsMtd2[16];
#endif
#endif
/* WNC-MR0137-JOE-PENG-20120606-Fix bug that PPPoE disconnect action does not work. */
	{
		int opmode = 0; //WNC-NMR0000-Rita-20130205-Error_378-fix warnings of cppcheck (uninitialized value).

		apmib_get( MIB_OP_MODE, (void *)&opmode);

		//WNC-NMR492-YUAN-I-CHOU-20130909-prevent interference from HTTP browser
		system("iptables -I INPUT -p tcp --dport 80 -j DROP");
		//WNC-NMR492-YUAN-I-CHOU-20130909-prevent interference from HTTP browser End

		trigger_reboot_led();

		if (opmode == GATEWAY_MODE) {
			system("killall -9 ppp_inet");
			system("killall -15 pppd");
			sleep(4);
		}

#ifdef CONFIG_APP_AUTOCH2
		// WNC-NMR0000-Jog-20160913, remove autoch2 daemon before wlan0 down
		int repeater_enable1 = 0;
		apmib_get(MIB_REPEATER_ENABLED1, (void *)&repeater_enable1);
		if ((opmode == GATEWAY_MODE) || 
			((opmode == BRIDGE_MODE) && (repeater_enable1 == 0))) {
			system("killall -9 autoch2");
		}
#endif	
// WNC-NMR0000-Jimmy-20170907, remove daemon on BUG2645, comment 45
			system("killall -9 wdf");
			system("killall -9 wifi_notify");
			system("killall -9 dnrd");
			system("killall -9 sysmon");
			system("killall -9 udhcpd");
			system("killall -9 wscd");
			system("killall -9 iwcontrol");
			system("killall -9 udhcpc");
			system("killall -9 miniigd");
			system("killall -9 reload");
			system("killall -9 nmbserver");
			system("killall -9 adp");
			system("killall -9 aim");
			system("killall -9 dnsnquery");
			system("killall -9 wzcm");
			system("killall -9 crond");

	
	}
/* WNC-MR0137-JOE-PENG-20120606-end */
/* WNC-MR0000-Rita-20121119-hidden page for firmware upgrade to E-bank */
FILE *fp;
int upgrade2Ebank = 0;
if(fp = fopen("/var/upgrade2Ebank", "r")){
    upgrade2Ebank = 1;
    fclose(fp);
}
/* WNC-MR0000-Rita-20121119-End */

#if defined(CONFIG_APP_FWD)
#define FWD_CONF "/var/fwd.conf"
	int newfile = 1;
	extern int get_shm_id();
	extern int clear_fwupload_shm();
	int shm_id = get_shm_id();
#endif

#ifdef MTD_NAME_MAPPING
	if(rtl_name_to_mtdblock(FLASH_WEBPAGE_NAME,webpageMtd) == 0
		|| rtl_name_to_mtdblock(FLASH_LINUX_NAME,linuxMtd) == 0
			|| rtl_name_to_mtdblock(FLASH_ROOTFS_NAME,rootfsMtd) == 0){
		strlcpy(buffer, "cannot find webpage/linux/rootfs mtdblock!", buffer_len);
		goto ret_upload;
	}
#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE
	if(rtl_name_to_mtdblock(FLASH_WEBPAGE_NAME2,webpageMtd2) == 0
		|| rtl_name_to_mtdblock(FLASH_LINUX_NAME2,linuxMtd2) == 0
			|| rtl_name_to_mtdblock(FLASH_ROOTFS_NAME2,rootfsMtd2) == 0){
		strlcpy(buffer, "cannot find webpage/linux/rootfs mtdblock!", buffer_len);
		goto ret_upload;
	}
#endif
#endif

	if (isCFG_ONLY == 0) {
		/*
		#ifdef CONFIG_RTL_8196B
			snprintf(cmdBuf, sizeof(cmdBuf), "echo \"4 %d\" > /proc/gpio", (Reboot_Wait+12));
		#else	
			snprintf(cmdBuf, sizeof(cmdBuf), "echo \"4 %d\" > /proc/gpio", (Reboot_Wait+20));
		#endif
		
			system(cmdBuf);
		*/
		system("ifconfig br0 down 2> /dev/null");
		// WNC-NMR0000-Jimmy-20170907, disable eth1	on BUG2645, comment 45	
		system("ifconfig eth1 down 2> /dev/null");	
		/* Set Active LED(Green) to off forever */
		/* Set Active LED(Red) to off forever */
		lw_ledctl(ACT_ORANGE, 0, LED_FOREVER, 1, 0, LED_FOREVER);
	}
#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE
	apmib_get(MIB_DUALBANK_ENABLED,(void *)&dual_enable);   
	get_bank_info(dual_enable,&active_bank,&backup_bank);        
#endif

#ifdef MTD_NAME_MAPPING
#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE
		Kernel_dev_name[0] = linuxMtd;
		Kernel_dev_name[1] = linuxMtd2;
		Rootfs_dev_name[0] = rootfsMtd;
		Rootfs_dev_name[1] = rootfsMtd2;
#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_WEB_BACKUP_ENABLE
		Web_dev_name[0] = webpageMtd;
		Web_dev_name[1] = webpageMtd2;
#endif
#endif
#endif
#if 0
	head_offset = find_head_offset(upload_data);
//	fprintf(stderr,"####%s:%d head_offset=%d upload_data=%p###\n",  __FILE__, __LINE__ , head_offset, upload_data);
	if (head_offset == -1) {
		strlcpy(buffer, "Invalid file format!", buffer_len);
		goto ret_upload;
	}
#else
	head_offset = 0;
#endif

	if (checkIdentifierKey(upload_data + head_offset, upload_len)) {
		strlcpy(buffer, ("Error Identifier Key"), buffer_len);
		goto ret_upload;
	}

//WNC-HENG-I-20160802, One firmware modification
	head_offset += IDENTIFIER_KEY_LEN;
//WNC-HENG-I-20160802, One firmware modification End
	
#ifdef DEFSETTING_AUTO_UPDATE
	system("flash save-defsetting");
#endif

//WNC-NMRXXXX-Yuan-I-Chou-20160811, Configured value restoration support
	{
		int val = 1;
		//Write current default setting from hardcoded into FLASH
		//After firmware upgrade, default setting in FLASH would be current firmware's default setting
		system("flash default-ds");

		//Check if FLASH write is completed
		while (access("/tmp/ds-def", F_OK) != 0) {
			sleep(1);
		}
		//Clear flag for next check
		system("rm -f /tmp/ds-def");

		//Next reboot will trigger configured value restoration function.
		apmib_set(MIB_NEED_AUTO_UPDATE, (void*)&val);
		apmib_update(CURRENT_SETTING);

	}
//WNC-NMRXXXX-Yuan-I-Chou-20160811, Configured value restoration support End

	/* WNC-NMR000-[Linear]-Libera-20141124- remove conn_mgmt when upgrading FW-start*/
	if (NUM_WLAN_INTERFACE==2){
		if (access("/tmp/MODE_RPT", F_OK) == 0 || access("/tmp/MODE_CNV", F_OK) == 0) {	
			system("killall -9 conn_mgmt");
		}
	}
	/* WNC-NMR000-[Linear]-Libera-20141124- remove conn_mgmt when upgrading FW-end*/
	
	while ((head_offset+sizeof(IMG_HEADER_T)) < upload_len) {
		locWrite = 0;
		pHeader = (IMG_HEADER_Tp) &upload_data[head_offset];
		len = pHeader->len;
#ifdef _LITTLE_ENDIAN_
		len  = DWORD_SWAP(len);
#endif
		numLeft = len + sizeof(IMG_HEADER_T) ;
		// check header and checksum
		if (!memcmp(&upload_data[head_offset], FW_HEADER, SIGNATURE_LEN) ||
			!memcmp(&upload_data[head_offset], FW_HEADER_WITH_ROOT, SIGNATURE_LEN)) {
			isValidfw = 1;
			flag = 1;
		}
		else if (!memcmp(&upload_data[head_offset], WEB_HEADER, SIGNATURE_LEN)) {
			isValidfw = 1;
			flag = 2;
		}
		else if (!memcmp(&upload_data[head_offset], ROOT_HEADER, SIGNATURE_LEN)) {
			isValidfw = 1;
			flag = 3;
			isIncludeRoot = 1;
		}else if (
#ifdef COMPRESS_MIB_SETTING
				!memcmp(&upload_data[head_offset], COMP_HS_SIGNATURE, COMP_SIGNATURE_LEN) ||
				!memcmp(&upload_data[head_offset], COMP_DS_SIGNATURE, COMP_SIGNATURE_LEN) ||
				!memcmp(&upload_data[head_offset], COMP_CS_SIGNATURE, COMP_SIGNATURE_LEN)
#else
				!memcmp(&upload_data[head_offset], CURRENT_SETTING_HEADER_TAG, TAG_LEN) ||
				!memcmp(&upload_data[head_offset], CURRENT_SETTING_HEADER_FORCE_TAG, TAG_LEN) ||
				!memcmp(&upload_data[head_offset], CURRENT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) ||
				!memcmp(&upload_data[head_offset], DEFAULT_SETTING_HEADER_TAG, TAG_LEN) ||
				!memcmp(&upload_data[head_offset], DEFAULT_SETTING_HEADER_FORCE_TAG, TAG_LEN) ||
				!memcmp(&upload_data[head_offset], DEFAULT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) ||
				!memcmp(&upload_data[head_offset], HW_SETTING_HEADER_TAG, TAG_LEN) ||
				!memcmp(&upload_data[head_offset], HW_SETTING_HEADER_FORCE_TAG, TAG_LEN) ||
				!memcmp(&upload_data[head_offset], HW_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) 
#endif			
				) {
			int type=0, status=0, cfg_len;
			cfg_len = updateConfigIntoFlash((unsigned char *)&upload_data[head_offset],configlen , &type, &status);

			if (status == 0 || type == 0) { // checksum error
				strlcpy(buffer, "Invalid configuration file!", buffer_len);
				goto ret_upload;
			}
			else { // upload success
				strlcpy(buffer, "Update successfully!", buffer_len);
				head_offset += cfg_len;
				isValidfw = 1;
				update_cfg = 1;
			}
			continue;
		}
		else {
			if (isValidfw == 1)
				break;
			strlcpy(buffer, ("Invalid file format!"), buffer_len);
			goto ret_upload;
		}

		if (len > fwSizeLimit) { //len check by sc_yang 
			snprintf(buffer, buffer_len, ("Image len exceed max size 0x%x ! len=0x%x</b><br>"),fwSizeLimit, len);
			goto ret_upload;
		}
		if ( (flag == 1) || (flag == 3)) {
			if ( !fwChecksumOk(&upload_data[sizeof(IMG_HEADER_T)+head_offset], len)) {
				snprintf(buffer, buffer_len, ("Image checksum mismatched! len=0x%x, checksum=0x%x</b><br>"), len,
					*((unsigned short *)&upload_data[len-2]) );
				goto ret_upload;
			}
		}
		else {
			char *ptr = &upload_data[sizeof(IMG_HEADER_T)+head_offset];
			if ( !CHECKSUM_OK((unsigned char *)ptr, len) ) {
				snprintf(buffer, buffer_len, ("Image checksum mismatched! len=0x%x</b><br>"), len);
				goto ret_upload;
			}
		}
/* WNC-MR0000-Rita-20121119-hidden page for firmware upgrade to E-bank-start */		
	if(upgrade2Ebank == 1){
		if (flag == 3) //rootfs
				{
					fh = open("/dev/mtdblock3", O_RDWR);
#if defined(CONFIG_APP_FWD)			
					write_line_to_file(FWD_CONF, (newfile==1?1:2), "/dev/mtdblock3");
					newfile = 2;
#endif			
				}
				else if (flag == 1) //linux
				{
					fh = open("/dev/mtdblock2", O_RDWR);
#if defined(CONFIG_APP_FWD)			
					write_line_to_file(FWD_CONF, (newfile==1?1:2), "/dev/mtdblock2");
					newfile = 2;
#endif			
		}
		else //web
		{
			fh = open(FLASH_DEVICE_NAME, O_RDWR);
#if defined(CONFIG_APP_FWD)			
			write_line_to_file(FWD_CONF, (newfile==1?1:2), FLASH_DEVICE_NAME);
			newfile = 2;
#endif			
		}
	}
	else{ /* WNC-MR0000-Rita-20121119-End */
#ifndef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE
		if (flag == 3) // rootfs
		{
#ifndef MTD_NAME_MAPPING
			fh = open(FLASH_DEVICE_NAME1, O_RDWR);
#else
			fh = open(rootfsMtd, O_RDWR);
#endif

#if defined(CONFIG_APP_FWD)	
#ifndef MTD_NAME_MAPPING
			write_line_to_file(FWD_CONF, (newfile==1?1:2), FLASH_DEVICE_NAME1);
#else
			write_line_to_file(FWD_CONF, (newfile==1?1:2), rootfsMtd);
#endif
			newfile = 2;
#endif			
		}
		else if(flag == 1)	//linux
		{
#ifndef MTD_NAME_MAPPING
			fh = open(FLASH_DEVICE_NAME, O_RDWR);
#else
			fh = open(linuxMtd,O_RDWR);
#endif
#if defined(CONFIG_APP_FWD)			
#ifndef MTD_NAME_MAPPING
			write_line_to_file(FWD_CONF, (newfile==1?1:2), FLASH_DEVICE_NAME);
#else
			write_line_to_file(FWD_CONF, (newfile==1?1:2), linuxMtd);
#endif
			newfile = 2;
#endif			
		}
		else	//web
		{
#ifndef MTD_NAME_MAPPING
			fh = open(FLASH_DEVICE_NAME, O_RDWR);
#else
			fh = open(webpageMtd, O_RDWR);
#endif
#if defined(CONFIG_APP_FWD)			
#ifndef MTD_NAME_MAPPING
			write_line_to_file(FWD_CONF, (newfile==1?1:2), FLASH_DEVICE_NAME);
#else
			write_line_to_file(FWD_CONF, (newfile==1?1:2), webpageMtd);
#endif
			newfile = 2;
#endif			
		}
#else
		if (flag == 3) //rootfs
		{
			fh = open(Rootfs_dev_name[backup_bank-1], O_RDWR);
			
#if defined(CONFIG_APP_FWD)			
			write_line_to_file(FWD_CONF, (newfile==1?1:2), Rootfs_dev_name[backup_bank-1]);
			newfile = 2;
#endif			
		}
		else if (flag == 1) //linux
		{
			fh = open(Kernel_dev_name[backup_bank-1], O_RDWR);
#if defined(CONFIG_APP_FWD)			
			write_line_to_file(FWD_CONF, (newfile==1?1:2), Kernel_dev_name[backup_bank-1]);
			newfile = 2;
#endif			
		}
		else //web
		{
#if defined(CONFIG_RTL_FLASH_DUAL_IMAGE_WEB_BACKUP_ENABLE)
			fh = open(Web_dev_name[backup_bank-1],O_RDWR);
#if defined(CONFIG_APP_FWD)			
			write_line_to_file(FWD_CONF, (newfile==1?1:2), Web_dev_name[backup_bank-1]);
			newfile = 2;
#endif			
#else		
#ifndef MTD_NAME_MAPPING
			fh = open(FLASH_DEVICE_NAME, O_RDWR);
#else
			fh = open(webpageMtd,O_RDWR);
#endif
#if defined(CONFIG_APP_FWD)			
#ifndef MTD_NAME_MAPPING
			write_line_to_file(FWD_CONF, (newfile==1?1:2), FLASH_DEVICE_NAME);
#else
			write_line_to_file(FWD_CONF, (newfile==1?1:2), webpageMtd);
#endif
			newfile = 2;
#endif	
#endif		
		}
#endif
}
		if ( fh == -1 ) {
			strlcpy(buffer, ("File open failed!"), buffer_len);
			goto ret_upload;
		} else {
			if (flag == 1) {
				if (startAddr == -1) {
					//startAddr = CODE_IMAGE_OFFSET;
					startAddr = pHeader->burnAddr ;
#ifdef _LITTLE_ENDIAN_
					startAddr = DWORD_SWAP(startAddr);
#endif
#ifdef CONFIG_MTD_NAND
					startAddr = startAddr - NAND_BOOT_SETTING_SIZE;
#endif


				}
			}
			else if (flag == 3) {
				if (startAddr == -1) {
					startAddr = 0; // always start from offset 0 for 2nd FLASH partition
				}
			}
			else {
				if (startAddrWeb == -1) {
					//startAddr = WEB_PAGE_OFFSET;
					startAddr = pHeader->burnAddr ;
#ifdef _LITTLE_ENDIAN_
					startAddr = DWORD_SWAP(startAddr);
#endif
#ifdef CONFIG_MTD_NAND
					startAddr = startAddr - NAND_BOOT_SETTING_SIZE;		
#endif
				}
				else
					startAddr = startAddrWeb;
			}
// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 112 CHECKED_RETURN
			if (lseek(fh, startAddr, SEEK_SET) < 0) {
				close(fh);
				snprintf(buffer, buffer_len, ("lseek failed. startAddr=%.8X."), startAddr);
				goto ret_upload;
			}
// WNC-NMR0000-Heng-I-Chen-20130814: End
			
#if defined(CONFIG_APP_FWD)			
			{
				char tmpStr[20]={0};
				snprintf(tmpStr, sizeof(tmpStr),"\n%d",startAddr);
				write_line_to_file(FWD_CONF, (newfile==1?1:2), tmpStr);
				
				newfile = 2;
			}
#endif			
			
			
						
			if (flag == 3) {
				locWrite += sizeof(IMG_HEADER_T); // remove header
				numLeft -=  sizeof(IMG_HEADER_T);
				system("ifconfig br0 down 2> /dev/null");
				system("ifconfig eth0 down 2> /dev/null");
				system("ifconfig eth1 down 2> /dev/null");
				system("ifconfig ppp0 down 2> /dev/null");
				system("ifconfig wlan0 down 2> /dev/null");
				system("ifconfig wlan0-vxd down 2> /dev/null");		
				system("ifconfig wlan0-va0 down 2> /dev/null");		
				system("ifconfig wlan0-va1 down 2> /dev/null");		
				system("ifconfig wlan0-va2 down 2> /dev/null");		
				system("ifconfig wlan0-va3 down 2> /dev/null");
				system("ifconfig wlan0-wds0 down 2> /dev/null");
				system("ifconfig wlan0-wds1 down 2> /dev/null");
				system("ifconfig wlan0-wds2 down 2> /dev/null");
				system("ifconfig wlan0-wds3 down 2> /dev/null");
				system("ifconfig wlan0-wds4 down 2> /dev/null");
				system("ifconfig wlan0-wds5 down 2> /dev/null");
				system("ifconfig wlan0-wds6 down 2> /dev/null");
				system("ifconfig wlan0-wds7 down 2> /dev/null");
#if defined(CONFIG_RTL_92D_SUPPORT)	
				system("ifconfig wlan1 down 2> /dev/null");
				system("ifconfig wlan1-vxd down 2> /dev/null");		
				system("ifconfig wlan1-va0 down 2> /dev/null");		
				system("ifconfig wlan1-va1 down 2> /dev/null");		
				system("ifconfig wlan1-va2 down 2> /dev/null");		
				system("ifconfig wlan1-va3 down 2> /dev/null");
				system("ifconfig wlan1-wds0 down 2> /dev/null");
				system("ifconfig wlan1-wds1 down 2> /dev/null");
				system("ifconfig wlan1-wds2 down 2> /dev/null");
				system("ifconfig wlan1-wds3 down 2> /dev/null");
				system("ifconfig wlan1-wds4 down 2> /dev/null");
				system("ifconfig wlan1-wds5 down 2> /dev/null");
				system("ifconfig wlan1-wds6 down 2> /dev/null");
				system("ifconfig wlan1-wds7 down 2> /dev/null");
#endif
				// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-05-29: Don't kill process for NEC's requests
				//kill_processes();
				sleep(2);
			}
#ifdef CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE
			if (flag == 1) {  //kernel image
				pHeader->burnAddr = get_next_bankmark(Kernel_dev_name[active_bank-1],dual_enable);	//replace the firmware header with new bankmark //mark_debug		
			}
#endif

#if defined(CONFIG_APP_FWD)
			{
				char tmpStr[20]={0};
				
				snprintf(tmpStr, sizeof(tmpStr),"\n%d",numLeft);
				write_line_to_file(FWD_CONF, (newfile==1?1:2), tmpStr);
				snprintf(tmpStr, sizeof(tmpStr),"\n%d\n",locWrite+head_offset);
				write_line_to_file(FWD_CONF, (newfile==1?1:2), tmpStr);					
				newfile = 2;
			}

#else //#if defined(CONFIG_APP_FWD)
			numWrite = write(fh, &(upload_data[locWrite+head_offset]), numLeft);
			if (numWrite < numLeft) {
				snprintf(buffer, buffer_len, ("File write failed. locWrite=%d numLeft=%d numWrite=%d Size=%d bytes."), locWrite, numLeft, numWrite, upload_len);
				goto ret_upload;
			}

#endif //#if defined(CONFIG_APP_FWD)
			
			locWrite += numWrite;
			numLeft -= numWrite;
			//WNC-NMR146-HENGI-20120605, fix firmware upgrade error.
			fsync(fh);
			//WNC-NMR146-HENGI-20120605-End
			close(fh);

			head_offset += len + sizeof(IMG_HEADER_T) ;
			startAddr = -1 ; //by sc_yang to reset the startAddr for next image
			update_fw = 1;
		}
	} //while //sc_yang   

	//fprintf(stderr,"####isUpgrade_OK###\n");
#ifndef NO_ACTION
	isUpgrade_OK=1;
	
#if defined(CONFIG_APP_FWD)
	{			
			char tmpStr[20]={0};
			
			snprintf(tmpStr, sizeof(tmpStr),"%d",shm_id);

//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, Add Shared memory protection
			shmdt(upload_data); 
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, End

			write_line_to_file("/var/fwd.ready", 1, tmpStr);
			
			sync();
			exit(0);
	}
#else	//#if defined(CONFIG_APP_FWD)
	//REBOOT_WAIT_COMMAND(2);		
	system("reboot");
	for(;;);
#endif //#if defined(CONFIG_APP_FWD)

	
#else
#ifdef VOIP_SUPPORT
	// rock: for x86 simulation
	if (update_cfg && !update_fw) {
		if (apmib_reinit()) {
			//reset_user_profile();  // re-initialize user password
		}
	}
#endif
#endif

	return 1;
ret_upload:
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, Add Shared memory protection
#if defined(CONFIG_APP_FWD)
	//clear_fwupload_shm(shm_id);
	shm_unlock();
	clear_shm();
#else
	free(upload_data);
#endif
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, End
	fprintf(stderr, "%s\n", buffer);
	// Reboot when firmware upgrade failed. #BEGIN
	system("reboot");
	// Reboot when firmware upgrade failed. #END
	return 0;
}
//////////////////////////////////////////////////////////////////////////////
#if defined(CONFIG_RTL_FLASH_DUAL_IMAGE_ENABLE)
void formDualFirmware(request *wp, char *path, char *query)
{
	char *strRequest, *submitUrl, *strVal;
	unsigned char enableDualFW=0, whichBand=0;
	unsigned char tmpBuf[200];
	
	//displayPostDate(wp->post_data);
	
	submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page
	
	strVal = req_get_cstream_var(wp, ("active"), "");
	if(strVal[0])
	{
		if(strcmp(strVal,"save") == 0)
		{
//fprintf(stderr,"\r\n apply setting,__[%s-%u]",__FILE__,__LINE__);								
			strVal = req_get_cstream_var(wp, ("dualFw"), "");
			if (strVal[0])
			{
				enableDualFW = 1;
			}
			set_dualbank(enableDualFW);

			
		}
		else if(strcmp(strVal,"reboot") == 0)
		{

			if( boot_from_backup() == 0)
			{
			 	strlcpy(tmpBuf, ("Rebooting !!~~~~Please wait for 40~50secs! "), sizeof(tmpBuf));
				 goto setReboot;
			}	
			else {
				strlcpy(tmpBuf, ("Reboot Fail!!The image in Backup Bank maybe corrupted!! "), sizeof(tmpBuf));
       	              goto setErr;			
			}
			
		}
	}
	
	apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("all");
#endif

	OK_MSG(submitUrl);		

	return;

setErr:
	ERR_MSG(tmpBuf);
	return ;

setReboot:
	ERR_MSG(tmpBuf);
	//REBOOT_WAIT_COMMAND(2);		
/* WNC-MR0137-JOE-PENG-20120626-Fix bug that PPPoE disconnect action does not work. */
	reboot_device();
/* WNC-MR0137-JOE-PENG-20120626-end */
}
#endif

#if 0 //defined(CONFIG_USBDISK_UPDATE_IMAGE)
extern int firmware_len;
extern char *firmware_data;
void formUploadFromUsb(request *wp, char * path, char * query)
{
	int oneReadMax = 4096;
	int oneRead = 0;
	int fileLen=0;
	char *buff = NULL;
	char tmpBuf[200];
	char *submitUrl;
	char lan_ip[30];	
	char lan_ip_buf[30];
    	FILE *       fd;
	struct stat fileStat={0};
	int readLen=0,i=0;	
	 if(!isFileExist(USB_UPLOAD_FORM_PATH))
	 {
      		strlcpy(tmpBuf, ("Error!form ware is not exist in usb storage!\n"), sizeof(tmpBuf));
	 	goto ret_err;
	 }
	 stat(USB_UPLOAD_FORM_PATH,&fileStat);
	 fileLen=fileStat.st_size;
	fd = open(USB_UPLOAD_FORM_PATH, O_RDONLY);
	if (!fd){
      		strlcpy(tmpBuf, ("Open image file  failed!\n"), sizeof(tmpBuf));
	 	goto ret_err;
	}
	lseek(fd, 0L, SEEK_SET);
	printf("		<read image from usb storage device>\n");
	buff=malloc(fileLen+17);
	if(buff == NULL)
	{
      	snprintf(tmpBuf, sizeof(tmpBuf), ("malloc %d failed !\n"),fileLen+17);
	 		goto ret_err;
	}
	bzero(buff,fileLen+17);
	
	strlcpy(buff,WINIE6_STR,fileLen+17);
	buff[13]=0x0d;
	buff[14]=0x0a;
	buff[15]=0x0d;
	buff[16]=0x0a;
	
	 printf("\n buff=%s len=%d\n",buff,17);
	readLen=read(fd,buff+17,fileLen);
	if(readLen!=fileLen)
	{
		sprnintf(tmpBuf, sizeof(tmpBuf), ("read %d but file len is %d, read fail!\n"),readLen,fileLen);
	 		goto ret_err;
	}
#if 0
	/* read image from file to buff */
	 do{
		 buff = realloc(buff, fileLen + oneReadMax);
		 if(buff == NULL)
		 {
      			strlcpy(tmpBuf, ("my god breallco failed !\n"), sizeof(tmpBuf));
	 		goto ret_err;
		 }
		oneRead = read(fd, (void *)(buff + fileLen), oneReadMax);
		fileLen += oneRead;
		printf(".");
		if(oneRead == -1)
		{
			printf("file read error!\n");
	 		goto ret_err;
		 }
	 }while(oneRead == oneReadMax);
	 printf("\n");

	free(wp->post_data);
	wp->post_data = buff;
	wp->post_data_len = fileLen;
#endif
	wp->upload_data=buff;
		
	wp->upload_len=fileLen+17;
#if defined(CONFIG_APP_FWD)
	int shm_id = get_shm_id();	
	clear_fwupload_shm(shm_id);
	//if(shm_id == 0)
	{
		/* Generate a System V IPC key */ 
		key_t key;
		key = ftok("/bin/fwd", 0xE04);
				
		/* Allocate a shared memory segment */
		shm_id = shmget(key, wp->upload_len, IPC_CREAT | IPC_EXCL | 0666);	
					 
		if (shm_id == -1) {
					
			return -2;
		}
		set_shm_id(shm_id);
		/* Attach the shared memory segment */
		shm_memory = (char *)shmat(shm_id, NULL, 0);
		//printf("%s:%d get_shm_id()=%d shm_memory=%p\n",__FUNCTION__,__LINE__,get_shm_id(),shm_memory);
		memcpy(shm_memory,wp->upload_data,wp->upload_len);
		free(wp->upload_data);
		wp->upload_data=shm_memory;
	}
#endif
	firmware_data=wp->upload_data;
	firmware_len=wp->upload_len;

	formUpload(wp, NULL, NULL);/*further check and upload */
	return;
ret_err:
	ERR_MSG(tmpBuf);
	return;
	 
}
#endif
/* WNC-MRXXXX-Heng-I-Chen-20120503-Reuse USB firmware upgrade function to Online Version Up */
void formUploadFromFile(request *wp, char * path, char * query, char * filepath)
{
	int oneReadMax = 4096;
	int oneRead = 0;
	int fileLen=0;
	char *buff = NULL;
	char tmpBuf[200];
	char *submitUrl;
	char lan_ip[30];
	char lan_ip_buf[30];
	int fd;

	if(!isFileExist(filepath))
	{
		strlcpy(tmpBuf, ("Error!form ware is not exist in filesystem!\n"), sizeof(tmpBuf));
		goto ret_err;
	}
	fd = open(filepath, O_RDONLY);
// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 416 NEGATIVE_RETURNS
//	if (!fd){
	if (fd < 0) {
// WNC-NMR0000-Heng-I-Chen-20130814: End
		strlcpy(tmpBuf, ("Open image file  failed!\n"), sizeof(tmpBuf));
		goto ret_err;
	}
	lseek(fd, 0L, SEEK_SET);
	//printf("read image from filesystem\n");

	buff = malloc(26);

	snprintf(buff, 26, "filename=\"fw_enc.bin\"\x0d\x0a\x0d\x0a");

	/* read image from file to buff */
	do {
		buff = realloc(buff, 25 + fileLen + oneReadMax);
		if(buff == NULL)
		{
			strlcpy(tmpBuf, ("my god breallco failed !\n"), sizeof(tmpBuf));
			goto ret_err1;
		}
		oneRead = read(fd, (void *)(buff + 25 + fileLen), oneReadMax);
		fileLen += oneRead;
		//printf(".");
		if(oneRead == -1)
		{
			printf("file read error!\n");
			goto ret_err2;
		}
	} while(oneRead == oneReadMax);
	//printf("\n");

	close(fd); //WNC-NMR0000-Rita-20130305-Error_249-fix warnings of cppcheck (RESOURCE_LEAK).
	free(wp->upload_data);
//WNC-JDR230-MRXXXX-HENG-I-CHEN-20121016, Apply Realtek SDK 3.2.2 Patch
#if defined(CONFIG_APP_FWD)
	wp->upload_data = copy_to_shm(buff, fileLen + 25);
	free(buff);
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, Add Shared memory protection	
	if (wp->upload_data == NULL) {
		goto ret_err;
	}
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, End
#else
//WNC-JDR230-MRXXXX-HENG-I-CHEN-20121016, End
	wp->upload_data = buff;
//WNC-JDR230-MRXXXX-HENG-I-CHEN-20121016, Apply Realtek SDK 3.2.2 Patch
#endif	//#if defined(CONFIG_APP_FWD)	
//WNC-JDR230-MRXXXX-HENG-I-CHEN-20121016, End
	wp->upload_len = fileLen + 25;
// WNC-NMR0000-JDR231-HENG-I-CHEN-2014-05-29: Don't kill process for NEC's requests
//	killDaemon(1);
	formUploadMain(wp, "/var/fw_enc.bin");/*further check and upload */
	return;
//WNC-NMR0000-Rita-20130305-Error_252-fix warnings of cppcheck (RESOURCE_LEAK).
ret_err2:
	free(buff); //WNC-NMR0000-Rita-20130305-Error_251-fix warnings of cppcheck (RESOURCE_LEAK).
ret_err1:
	close(fd); 
ret_err:
	ERR_MSG(tmpBuf);
	return;
//WNC-NMR0000-Rita-20130305-Error_252-End.
}

#if defined(CONFIG_USBDISK_UPDATE_IMAGE)
void formUploadFromUsb(request *wp, char * path, char * query)
{
	formUploadMain(wp, USB_UPLOAD_FORM_PATH);
}
/* WNC-MRXXXX-Heng-I-Chen-20120503-End */
#endif

#if 0//def SAMBA_WEB_SUPPORT
void formDiskCreateFolder(request *wp, char * path, char * query)
{
	char *submitUrl,*strLocation,*strFolder;
	char cmdBuffer[40];
	
	strLocation = req_get_cstream_var(wp,("Location"),"");
	strFolder = req_get_cstream_var(wp,("newfolder"),"");

	memset(cmdBuffer,'\0',40);
	snprintf(cmdBuffer,40,"mkdir %s/%s",strLocation,strFolder);
	system(cmdBuffer);

setOk_DiskCreateFolder:
	apmib_update_web(CURRENT_SETTING);
	
	submitUrl = req_get_cstream_var(wp, "submit-url", "");	
	if (submitUrl[0])
		send_redirect_perm(wp, submitUrl);
	return;
}

void formDiskCreateShare(request *wp, char * path, char * query)
{
	char *submitUrl,*strDisplayName,*strShareAll,*strDelete,*strSelect,*strGroup;
	char *strDirNum,*strLocation;
	char cmdBuffer[50];;
	char tmpBuff[100];
	FILE	*fp;
	STORAGE_USER_T		s_user;
	STORAGE_GROUP_T		s_group;
	STORAGE_GROUP_T		s_groups[2] = {0};
	int					number,i,j;

	strDisplayName = req_get_cstream_var(wp,("displayname"),""); 
	strShareAll = req_get_cstream_var(wp,("shareall"),""); 
	strGroup = req_get_cstream_var(wp,("Group"),"");
	strDirNum = req_get_cstream_var(wp,("DirNum"),"");
	strLocation = req_get_cstream_var(wp,("Location"),"");

	if(strShareAll[0]){
		//printf("in strShareAll\n");
		memset(&s_group,'\0',sizeof(STORAGE_GROUP_T));
		*((char*)&s_group) = (char)atoi(strGroup);
		apmib_get(MIB_STORAGE_GROUP_TBL,(void*)&s_group);
		s_group.storage_group_sharefolder_flag = 1;
		strcpy(s_group.storage_group_sharefolder,strLocation);
		strcpy(s_group.storage_group_displayname,strDisplayName);
		
		*((char*)&s_groups) = (char)atoi(strGroup);
		apmib_get(MIB_STORAGE_GROUP_TBL,(void*)(s_groups));
		memcpy(&(s_groups[1]),&s_group,sizeof(STORAGE_GROUP_T));
		apmib_set(MIB_STORAGE_GROUP_MOD,(void*)s_groups);

		/*memset(cmdBuffer,'\0',50);
		snprintf(cmdBuffer,50,"chgrp %s %s",s_group.storage_group_name,strLocation);
		system(cmdBuffer);*/
		
		storage_UpdateSambaConf();
		goto setOk_DiskCreateShare;
	}

	for(i = 0;i < atoi(strDirNum);i++)
	{
		//delete Dir
		memset(cmdBuffer,'\0',50);
		snprintf(cmdBuffer,50,"delete%d",i);
		strDelete =  req_get_cstream_var(wp,(cmdBuffer),""); 
		memset(cmdBuffer,'\0',50);
		if(strDelete[0]){
			snprintf(cmdBuffer,50,"rm -rf %s",strDelete);
			system(cmdBuffer);
		}
		apmib_get(MIB_STORAGE_GROUP_TBL_NUM,(void*)&number);
		for(j = 0;j < number;j++)
		{
			memset(&s_group,'\0',sizeof(STORAGE_GROUP_T));
			*((char*)&s_group) = (char)(j+1);
			apmib_get(MIB_STORAGE_GROUP_TBL,(void*)&s_group);

			if(s_group.storage_group_sharefolder_flag == 1){
				if(!strcmp(s_group.storage_group_sharefolder,strDelete)){
					s_group.storage_group_sharefolder_flag = 0;
					memset(s_group.storage_group_sharefolder,'\0',MAX_FOLDER_NAME_LEN);
					memset(s_group.storage_group_displayname,'\0',MAX_DISPLAY_NAME_LEN);

					*((char*)&s_groups) = (char)(j+1);
					apmib_get(MIB_STORAGE_GROUP_TBL,(void*)(s_groups));
					memcpy(&(s_groups[1]),&s_group,sizeof(STORAGE_GROUP_T));
					apmib_set(MIB_STORAGE_GROUP_MOD,(void*)s_groups);
					break;
				}
			}
		}

		snprintf(cmdBuffer,50,"select%d",i);
		strSelect =  req_get_cstream_var(wp,(cmdBuffer),""); 
		if(!strSelect[0])
			continue;

		apmib_get(MIB_STORAGE_GROUP_TBL_NUM,(void*)&number);
		for(j = 0;j < number;j++)
		{
			memset(&s_group,'\0',sizeof(STORAGE_GROUP_T));
			*((char*)&s_group) = (char)(j+1);
			apmib_get(MIB_STORAGE_GROUP_TBL,(void*)&s_group);

			//printf("flag2:%d.\n",s_group.storage_group_sharefolder_flag);
			if(atoi(strGroup) == (j+1)){
				if(s_group.storage_group_sharefolder_flag == 1){
					memset(tmpBuff,'\0',100);
					strcpy(tmpBuff,"group is already have share folder");
					goto setErr_DiskCreateShare;
				}
				strcpy(s_group.storage_group_sharefolder,strSelect);
				strcpy(s_group.storage_group_displayname,strDisplayName);
				s_group.storage_group_sharefolder_flag = 1;

				*((char*)&s_groups) = (char)atoi(strGroup);
				apmib_get(MIB_STORAGE_GROUP_TBL,(void*)(s_groups));
				memcpy(&(s_groups[1]),&s_group,sizeof(STORAGE_GROUP_T));
				apmib_set(MIB_STORAGE_GROUP_MOD,(void*)s_groups);

				/*memset(cmdBuffer,'\0',50);
				snprintf(cmdBuffer,50,"chgrp %s %s",s_group.storage_group_name,strSelect);
				system(cmdBuffer);*/
				
				storage_UpdateSambaConf();
				goto setOk_DiskCreateShare;
			}
		}
	}

setOk_DiskCreateShare:
	apmib_update_web(CURRENT_SETTING);
	
	submitUrl = req_get_cstream_var(wp, "submit-url", "");	
	if (submitUrl[0])
		send_redirect_perm(wp, submitUrl);
	return;
	
setErr_DiskCreateShare:
	ERR_MSG(tmpBuff);

}

void formDiskCfg(request *wp, char * path, char * query)
{
	char *submitUrl,*strLocation,*strDeleteAll,*strDeleteSelect,*strDeleteVal;
	int number,i,shareNum = 0;
	char tmpBuff[20];
	
	STORAGE_GROUP_T	s_group;
	STORAGE_GROUP_T s_groups[2];
		
	submitUrl = req_get_cstream_var(wp, "submit_url", "");	
	
	if(strcmp(submitUrl,"/storage_createsharefolder.htm")){
		strDeleteAll =  req_get_cstream_var(wp, "Delete_All", "");
		if(strDeleteAll[0]){
			apmib_get(MIB_STORAGE_GROUP_TBL_NUM,(void*)&number);
			for(i = 0;i < number;i++)
			{
				memset(&s_group,'\0',sizeof(STORAGE_GROUP_T));
				*((char*)&s_group) = (char)(i+1);
				apmib_get(MIB_STORAGE_GROUP_TBL,(void*)&s_group);

				if(s_group.storage_group_sharefolder_flag == 1){
					s_group.storage_group_sharefolder_flag = 0;
					memset(s_group.storage_group_sharefolder,'\0',MAX_FOLDER_NAME_LEN);
					memset(s_group.storage_group_displayname,'\0',MAX_DISPLAY_NAME_LEN);
					
					memset(s_groups,'\0',2*sizeof(STORAGE_GROUP_T));
					*((char*)s_groups) = (char)(i+1);
					apmib_get(MIB_STORAGE_GROUP_TBL,(void*)s_groups);
					memcpy(&(s_groups[1]),&s_group,sizeof(STORAGE_GROUP_T));
					apmib_set(MIB_STORAGE_GROUP_MOD,(void*)s_groups);
				}
			}
			goto setOk_DiskCfg;
		}
				
		strDeleteSelect =  req_get_cstream_var(wp, "Delete_Selected", "");
		apmib_get(MIB_STORAGE_GROUP_TBL_NUM,(void*)&number);
		for(i = 0;i < number;i++)
		{
			memset(&s_group,'\0',sizeof(STORAGE_GROUP_T));
			*((char*)&s_group) = (char)(i+1);
			apmib_get(MIB_STORAGE_GROUP_TBL,(void*)&s_group);

			if(s_group.storage_group_sharefolder_flag == 1){
				memset(tmpBuff,'\0',20);
				snprintf(tmpBuff,20,"delete%d",i);
				strDeleteVal = req_get_cstream_var(wp, tmpBuff, "");

				if(!strcmp(strDeleteVal,s_group.storage_group_name)){
					s_group.storage_group_sharefolder_flag = 0;
					memset(s_group.storage_group_sharefolder,'\0',MAX_FOLDER_NAME_LEN);
					memset(s_group.storage_group_displayname,'\0',MAX_DISPLAY_NAME_LEN);

					memset(s_groups,'\0',2*sizeof(STORAGE_GROUP_T));
					*((char*)s_groups) = (char)(i+1);
					apmib_get(MIB_STORAGE_GROUP_TBL,(void*)s_groups);
					memcpy(&(s_groups[1]),&s_group,sizeof(STORAGE_GROUP_T));
					apmib_set(MIB_STORAGE_GROUP_MOD,(void*)s_groups);
				}
			}
		}
		storage_UpdateSambaConf();
	}else{
		strLocation =  req_get_cstream_var(wp, "Create_Share", "");
		apmib_set(MIB_STORAGE_FOLDER_LOCAL,(void*)strLocation);
		goto setOk_DiskCfg;
	}				
setOk_DiskCfg:
	apmib_update_web(CURRENT_SETTING);
	if(submitUrl[0])
		send_redirect_perm(wp, submitUrl);
	return;

}

void formDiskManagementAnon(request *wp, char * path, char * query)
{
	char *submitUrl,*strAnonDiskEnable,*strAnonEnable;
	char *strAnonFtpEnable;
	int mib_val = 0;
	char cmdBuffer[100] = {0};

	strAnonEnable = req_get_cstream_var(wp,("AnonEnabled"),"");

	if(!strcmp(strAnonEnable,"ON")){
		mib_val = 1;
		apmib_set(MIB_STORAGE_ANON_ENABLE,(void*)&mib_val);
		#if 0
		//strAnonFtpEnable = req_get_cstream_var(wp,("anonymous_ftp_enable"),""); 
		strAnonDiskEnable = req_get_cstream_var(wp,("anonymous_disk_enable"),"");		
		/*if(!strcmp(strAnonFtpEnable,"enabled")){
			mib_val = 1;
			apmib_set(MIB_STORAGE_ANON_FTP_ENABLE,(void*)&mib_val);
		}else{
			mib_val = 0;
			apmib_set(MIB_STORAGE_ANON_FTP_ENABLE,(void*)&mib_val);
		}*/

		if(!strcmp(strAnonDiskEnable,"enabled")){
			mib_val = 1;
			apmib_set(MIB_STORAGE_ANON_DISK_ENABLE,(void*)&mib_val);
		}else{
			mib_val = 0;
			apmib_set(MIB_STORAGE_ANON_DISK_ENABLE,(void*)&mib_val);
		}
		#endif
	}else{
		mib_val = 0;
		apmib_set(MIB_STORAGE_ANON_ENABLE,(void*)&mib_val);
		
		apmib_set(MIB_STORAGE_ANON_DISK_ENABLE,(void*)&mib_val);
		//apmib_set(MIB_STORAGE_ANON_FTP_ENABLE,(void*)&mib_val);
	}

setOk_AnonAccessCfg:
	apmib_update_web(CURRENT_SETTING);
	system("killall usbStorageAppController 2>/dev/null");
	snprintf(cmdBuffer,100,"usbStorageAppController -a %d &",mib_val);
	system(cmdBuffer);
	//storage_UpdateSambaConf();
	
	submitUrl = req_get_cstream_var(wp, "submit-url", "");	
	if (submitUrl[0])
		send_redirect_perm(wp, submitUrl);
	return;

}

void formDiskManagementUser(request *wp, char * path, char * query)
{
	char *submitUrl, *strDeleAll,*strVal,*strUserIndex;
	char tmpBuff[20];
	char cmdBuffer[30];
	int number,i;
	STORAGE_USER_T	s_user;
	int	index;
	
	submitUrl = req_get_cstream_var(wp, "submit_url", "");
	if(strcmp(submitUrl,"/storage_edituser.htm")){
		apmib_get(MIB_STORAGE_USER_TBL_NUM,(void*)&number);
		strDeleAll = req_get_cstream_var(wp,("Delete_All"),"");
		if(strDeleAll[0]){
		
			for(i = 0; i < number;i++)
			{
				memset(&s_user,'\0',sizeof(STORAGE_USER_T));
				*((char*)&s_user) = (char)(i+1);
				apmib_get(MIB_STORAGE_USER_TBL,(void*)&s_user);
			
				memset(cmdBuffer,'\0',30);
				snprintf(cmdBuffer,30,"deluser %s",s_user.storage_user_name);
				system(cmdBuffer);
				memset(cmdBuffer,'\0',30);
				snprintf(cmdBuffer,30,"smbpasswd -del %s",s_user.storage_user_name);
				system(cmdBuffer);
				memset(cmdBuffer,'\0',30);
				snprintf(cmdBuffer,30,"rm -rf /home/%s",s_user.storage_user_name);
				system(cmdBuffer);
			}

			apmib_set(MIB_STORAGE_USER_DELALL,(void*)&s_user);
			goto setOk_deleteUser;
		}


		for(i = number;i > 0;i--)
		{
			memset(tmpBuff,'\0',20);
			snprintf(tmpBuff, 20, "select%d", i);
			strVal =  req_get_cstream_var(wp,tmpBuff,"");

			if(!strcmp(strVal,"ON")){
				*((char*)&s_user) = (char)i;
				apmib_get(MIB_STORAGE_USER_TBL,(void*)&s_user);
	
				memset(cmdBuffer,'\0',30);
				snprintf(cmdBuffer,30,"deluser %s",s_user.storage_user_name);
				system(cmdBuffer);
				memset(cmdBuffer,'\0',30);
				snprintf(cmdBuffer,30,"smbpasswd -del %s",s_user.storage_user_name);
				system(cmdBuffer);
				memset(cmdBuffer,'\0',30);
				snprintf(cmdBuffer,30,"rm -rf /home/%s",s_user.storage_user_name);
				system(cmdBuffer);
			
				apmib_set(MIB_STORAGE_USER_DEL,(void*)&s_user);
			}	
		}
	}else{
		strUserIndex = req_get_cstream_var(wp, "userindex", "");
		index = atoi(strUserIndex);
		if(strUserIndex[0])
			apmib_set(MIB_STORAGE_USER_EDIT_INDEX,(void*)&index);
		goto setOk_deleteUser;
	}
	
setOk_deleteUser:
	apmib_update_web(CURRENT_SETTING);
	
	if (submitUrl[0])
		send_redirect_perm(wp, submitUrl);
	return;
}

void formDiskManagementGroup(request *wp, char * path, char * query)
{
	char *submitUrl, *strDeleAll,*strVal,*strGroupIndex;
	char tmpBuff[20];
	char cmdBuffer[30];
	int number,i,user_num,j;
	STORAGE_GROUP_T	s_group;
	STORAGE_USER_T	s_user;
	STORAGE_USER_T	s_users[2] = {0};
	int			 index;
	submitUrl = req_get_cstream_var(wp, "submit_url", "");
		
	if(strcmp(submitUrl,"/storage_editgroup.htm")){
		apmib_get(MIB_STORAGE_GROUP_TBL_NUM,(void*)&number);
		apmib_get(MIB_STORAGE_USER_TBL_NUM,(void*)&user_num);

		/*Delete All Group Process*/
		strDeleAll = req_get_cstream_var(wp,("Delete_All"),"");
		if(strDeleAll[0]){
			for(i = 0;i < user_num;i++)
			{
				memset(&s_user,'\0',sizeof(STORAGE_USER_T));
				*((char*)&s_user) = (char)(i+1);
				apmib_get(MIB_STORAGE_USER_TBL,(void*)&s_user);
				
				strcpy(s_user.storage_user_group,"--");
				*((char*)s_users) = (char)(i+1);
				apmib_get(MIB_STORAGE_USER_TBL,(void*)(s_users));
				memcpy(&(s_users[1]),&s_user,sizeof(STORAGE_USER_T));
				apmib_set(MIB_STORAGE_USER_MOD,(void*)s_users);

				memset(cmdBuffer,'\0',30);
				snprintf(cmdBuffer,30,"deluser %s",s_user.storage_user_name);
				system(cmdBuffer);
				memset(cmdBuffer,'\0',30);
				snprintf(cmdBuffer,30,"rm -rf  /home/%s",s_user.storage_user_name);
				system(cmdBuffer);
				memset(cmdBuffer,'\0',30);
				snprintf(cmdBuffer,30,"adduser %s",s_user.storage_user_name);
				system(cmdBuffer);
				//may be need modify

			}

			for(i = 0;i < number;i++)
			{
				memset(&s_group,'\0',sizeof(STORAGE_GROUP_T));
				*((char*)&s_group) = (char)(i+1);
				apmib_get(MIB_STORAGE_GROUP_TBL,(void*)&s_group);
					
				memset(cmdBuffer,'\0',30);
				snprintf(cmdBuffer,30,"delgroup %s",s_group.storage_group_name);
				system(cmdBuffer);

			}
			
			apmib_set(MIB_STORAGE_GROUP_DELALL,(void*)&s_group);
			storage_UpdateSambaConf();
			goto setOk_deleteGroup;
		}
	

		/*Delete Selected Group Process*/
		for(i = number;i > 0;i--)
		{
			memset(tmpBuff,'\0',20);
			snprintf(tmpBuff, 20, "select%d", i);
			strVal =  req_get_cstream_var(wp,tmpBuff,"");

			if(!strcmp(strVal,"ON")){
				*((char*)&s_group) = (char)i;
				apmib_get(MIB_STORAGE_GROUP_TBL,(void*)&s_group);
				apmib_set(MIB_STORAGE_GROUP_DEL,(void*)&s_group);

				
				memset(cmdBuffer,'\0',30);
				snprintf(cmdBuffer,30,"delgroup %s",s_group.storage_group_name);
				system(cmdBuffer);

				//apmib_get(MIB_STORAGE_USER_TBL_NUM,(void*)&user_num);
				for(j = 0;j < user_num;j++)
				{
					*((char*)&s_user) = (char)(j+1);
					apmib_get(MIB_STORAGE_USER_TBL,(void*)&s_user);
					
					if(!strcmp(s_user.storage_user_group,s_group.storage_group_name)){
						memset(s_user.storage_user_group,'\0',10);
						strcpy(s_user.storage_user_group,"--");
						*((char*)s_users) = (char)(j+1);
						apmib_get(MIB_STORAGE_USER_TBL,(void*)(s_users));
						memcpy(&(s_users[1]),&s_user,sizeof(STORAGE_USER_T));
						apmib_set(MIB_STORAGE_USER_MOD,(void*)s_users);

						memset(cmdBuffer,'\0',30);
						snprintf(cmdBuffer,30,"deluser %s",s_user.storage_user_name);
						system(cmdBuffer);
						memset(cmdBuffer,'\0',30);
						snprintf(cmdBuffer,30,"rm -rf  /home/%s",s_user.storage_user_name);
						system(cmdBuffer);
						memset(cmdBuffer,'\0',30);
						snprintf(cmdBuffer,30,"adduser %s",s_user.storage_user_name);
						system(cmdBuffer);
						//may be need modify
					}
				}
						
			}
		}
		storage_UpdateSambaConf();
		goto setOk_deleteGroup;
	}else{
		strGroupIndex = req_get_cstream_var(wp, "groupindex", "");
		index = atoi(strGroupIndex);
		if(strGroupIndex[0]){
			apmib_set(MIB_STORAGE_GROUP_EDIT_INDEX,(void*)&index);
		}
		goto setOk_deleteGroup;
	}
		
setOk_deleteGroup:
	apmib_update_web(CURRENT_SETTING);
			
	if (submitUrl[0])
		send_redirect_perm(wp, submitUrl);
	return;
}

void formDiskCreateUser(request *wp, char * path, char * query)
{
		char *submitUrl, *strName, *strPasswd, *strConfPasswd,*strGroup;
		char tmpBuff[100];
		char cmdBuffer[100];
		STORAGE_USER_T	s_user;
		STORAGE_GROUP_T	s_group;
		
		unsigned char number,i;

		strName = req_get_cstream_var(wp,("username"),"");
		strPasswd = req_get_cstream_var(wp,("newpass"),"");
		strConfPasswd = req_get_cstream_var(wp,("confpass"),"");
		strGroup = req_get_cstream_var(wp,("Group"),"");

		if(!strName[0]){
			strcpy(tmpBuff, ("userName should not be NULL!"));
			goto setErr_createUser;
		}

		if(!strPasswd[0] || !strConfPasswd[0]){
			strcpy(tmpBuff, ("passwd or confpasswd should not be NULL!"));
			goto setErr_createUser;
		}

		if(strcmp(strPasswd,strConfPasswd)){
			strcpy(tmpBuff, ("passwd should be equal to confpasswd"));
			goto setErr_createUser;
		}

		if(!strcmp(strName,"root") || !strcmp(strName,"nobody")){
			strcpy(tmpBuff,"user Name should not be nobody or root");
			goto setErr_createUser;
		}
		
		apmib_get(MIB_STORAGE_USER_TBL_NUM,(void*)&number);
		if(number >= MAX_USER_NUM){
			snprintf(tmpBuff,100,"user num shoule not be more than %d",MAX_USER_NUM);
			goto setErr_createUser;
		}
		
		for(i = 0;i <number;i++)
		{
			memset(&s_user,'\0',sizeof(STORAGE_USER_T));
			*((char*)&s_user) = (char)(i+1);
			apmib_get(MIB_STORAGE_USER_TBL,(void*)&s_user);

			if(strlen(s_user.storage_user_name) == strlen(strName)
				&& strncmp(s_user.storage_user_name,strName,strlen(strName))){
				strcpy(tmpBuff, ("user name is already exist,Please choose another user name"));
				goto setErr_createUser;
			}
		}

		*((char*)&s_group) = (char)(atoi(strGroup));
		if(atoi(strGroup) == 0){
			memset(&s_user,'\0',sizeof(STORAGE_USER_T));
			strcpy(s_user.storage_user_group,"--");	
		}else{
			*((char*)&s_group) = (char)(atoi(strGroup));
			apmib_get(MIB_STORAGE_GROUP_TBL,(void*)&s_group);
			memset(&s_user,'\0',sizeof(STORAGE_USER_T));
			strcpy(s_user.storage_user_group,s_group.storage_group_name);
		}	
		
		number++;
		apmib_set(MIB_STORAGE_USER_TBL_NUM,(void*)&number);
		
		strcpy(s_user.storage_user_name,strName);
		strcpy(s_user.storage_user_password,strPasswd);
		apmib_set(MIB_STORAGE_USER_ADD,(void*)&s_user);

		memset(cmdBuffer,'\0',100);
		if(atoi(strGroup) == 0){
			snprintf(cmdBuffer,100,"adduser %s",strName);
		}else{
			snprintf(cmdBuffer,100,"adduser -G %s %s",s_group.storage_group_name,strName);
		}

		system(cmdBuffer);
		memset(cmdBuffer,'\0',100);
		snprintf(cmdBuffer,100,"smbpasswd %s %s",strName,strPasswd);
		system(cmdBuffer);
	
	setOk_createUser:
		apmib_update_web(CURRENT_SETTING);
	
		submitUrl = req_get_cstream_var(wp, "submit-url", "");	
		if (submitUrl[0])
			send_redirect_perm(wp, submitUrl);
		return;
	
	setErr_createUser:
		ERR_MSG(tmpBuff);
}


void formDiskEditUser(request *wp, char * path, char * query)
{
	char 	*submitUrl, *strOrigPasswd,*strNewPasswd,*strConfPasswd,*strGroup;
	int	    index;
	char	tmpBuff[100];
	char	cmdBuffer[50];
	
	STORAGE_USER_T 	s_user;
	STORAGE_GROUP_T	s_group;
	STORAGE_USER_T	s_users[2] = {0};

	memset(tmpBuff,'\0',100);
	memset(cmdBuffer,'\0',50);
	strOrigPasswd = req_get_cstream_var(wp,("origpass"),"");
	strNewPasswd = req_get_cstream_var(wp,("newpass"),"");
	strConfPasswd = req_get_cstream_var(wp,("confpass"),"");
	strGroup = req_get_cstream_var(wp,("Group"),"");

	apmib_get(MIB_STORAGE_USER_EDIT_INDEX,(void*)&index);
	memset(&s_user,'\0',sizeof(STORAGE_USER_T));
	*((char*)&s_user) = (char)index;
	apmib_get(MIB_STORAGE_USER_TBL,(void*)&s_user);
	
	if(strcmp(strOrigPasswd,s_user.storage_user_password)){
		strcpy(tmpBuff,"Orig Password is wrong,Please Enter the password again");
		goto setError_EditUser;
	}
	if(!strNewPasswd[0] || !strConfPasswd[0]){
		strcpy(tmpBuff,"newpassword or confpassword should not be empty");
		goto setError_EditUser;
	}
	if(strcmp(strNewPasswd,strConfPasswd)){
		strcpy(tmpBuff,"newpassword is not equal confpassword");
		goto setError_EditUser;
	}

	strcpy(s_user.storage_user_password,strNewPasswd);	
	if(atoi(strGroup) == 0)
		strcpy(s_user.storage_user_group,"--");
	else{
		memset(&s_group,'\0',sizeof(STORAGE_GROUP_T));
		*((char*)&s_group) = (char)atoi(strGroup);
		apmib_get(MIB_STORAGE_GROUP_TBL,(void*)&s_group);
		strcpy(s_user.storage_user_group,s_group.storage_group_name);
	}

	*((char*)s_users) = (char)index;
	apmib_get(MIB_STORAGE_USER_TBL,(void*)s_users);
	memcpy(&(s_users[1]),&s_user,sizeof(STORAGE_USER_T));
	apmib_set(MIB_STORAGE_USER_MOD,(void*)s_users);

	snprintf(cmdBuffer,50,"smbpasswd -del %s",s_user.storage_user_name);
	system(cmdBuffer);
	memset(cmdBuffer,'\0',50);
	snprintf(cmdBuffer,50,"smbpasswd %s %s",s_user.storage_user_name,s_user.storage_user_password);
	system(cmdBuffer);
	
setOk_EditUser:
	apmib_update_web(CURRENT_SETTING);
	storage_UpdateSambaConf();
		
	submitUrl = req_get_cstream_var(wp, "submit-url", "");	
	if (submitUrl[0])
		send_redirect_perm(wp, submitUrl);
	return;	

setError_EditUser:
	ERR_MSG(tmpBuff);
}

void formDiskEditGroup(request *wp, char * path, char * query)
{
	char 	*submitUrl, *strAccess;
	int		 index;
	
	STORAGE_GROUP_T s_group;
	STORAGE_GROUP_T	s_groups[2] = {0};
	strAccess = req_get_cstream_var(wp,("Access"),"");

	apmib_get(MIB_STORAGE_GROUP_EDIT_INDEX,(void*)&index);
	memset(&s_group,'\0',sizeof(STORAGE_GROUP_T));
	*((char*)&s_group) = (char)index;
	apmib_get(MIB_STORAGE_GROUP_TBL,(void*)&s_group);
	strcpy(s_group.storage_group_access,strAccess);

	*((char*)s_groups) = (char)index;
	apmib_get(MIB_STORAGE_GROUP_TBL,(void*)s_groups);
	memcpy(&(s_groups[1]),&s_group,sizeof(STORAGE_GROUP_T));
	apmib_set(MIB_STORAGE_GROUP_MOD,(void*)s_groups);

setOk_EditGroup:
	apmib_update_web(CURRENT_SETTING);
	storage_UpdateSambaConf();
		
	submitUrl = req_get_cstream_var(wp, "submit-url", "");	
	if (submitUrl[0])
		send_redirect_perm(wp, submitUrl);
	return;	
}


void formDiskCreateGroup(request *wp, char * path, char * query)
{
		char *submitUrl, *strName,*strAccess;
		char tmpBuff[100];
		char cmdBuffer[100];
		STORAGE_GROUP_T	s_group;
		unsigned char	 number,i;
	
		strName = req_get_cstream_var(wp,("groupname"),"");
		strAccess = req_get_cstream_var(wp,("Access"),"");

		if(!strcmp(strName,"root") || !strcmp(strName,"nobody")){
			strcpy(tmpBuff,"group name should not be root or nobody");
			goto setErr_createGroup;
		}
			
		apmib_get(MIB_STORAGE_GROUP_TBL_NUM,(void*)&number);
		
		if(number >= MAX_GROUP_NUM){
			snprintf(tmpBuff,100,"group num shoule not be more than %d",MAX_GROUP_NUM);
			goto setErr_createGroup;
		}

		for(i = 0;i <number;i++)
		{
			memset(&s_group,'\0',sizeof(STORAGE_GROUP_T));
			*((char*)&s_group) = (char)(i+1);
			apmib_get(MIB_STORAGE_GROUP_TBL,(void*)&s_group);

			if(!strcmp(strName,s_group.storage_group_name)){
				strcpy(tmpBuff,("group name repeat"));
				goto setErr_createGroup;
			}

			if(strlen(s_group.storage_group_name) == strlen(strName)
				&& strncmp(s_group.storage_group_name,strName,strlen(strName))){
				strcpy(tmpBuff, ("group name is already exist,Please choose another group name"));
				goto setErr_createGroup;
			}
		}
	
		number++;
		apmib_set(MIB_STORAGE_GROUP_TBL_NUM,(void*)&number);
	
		memset(&s_group,'\0',sizeof(STORAGE_GROUP_T));
		strcpy(s_group.storage_group_name,strName);
		strcpy(s_group.storage_group_access,strAccess);
		s_group.storage_group_sharefolder_flag = 0;
		apmib_set(MIB_STORAGE_GROUP_ADD,(void*)&s_group);

		memset(cmdBuffer,'\0',100);
		snprintf(cmdBuffer,100,"addgroup %s",strName);
		system(cmdBuffer);
		
	setOk_createGroup:
		apmib_update_web(CURRENT_SETTING);
		
		submitUrl = req_get_cstream_var(wp, "submit-url", "");	
		if (submitUrl[0])
			send_redirect_perm(wp, submitUrl);
		return;
		
	setErr_createGroup:
		ERR_MSG(tmpBuff);
}
#endif
#if defined(CONFIG_APP_ZIGBEE)
int zigbee_dev_list(request *wp, int argc, char **argv)
{
	int nBytesSent=0, i, found=0;
	FILE* fp;
	char buffer[128] = {0};	
    char u64IEEEAddress[64];
	char status[16] = {0};
	int brightness[16] = {0};
	system("zigbeed light_status");
	sleep(1);
	fp = fopen("/tmp/zigbee_dev_list","r");
	if(fp)
	{
        while(fgets(buffer,sizeof(buffer),fp))
		{
			if(!strncmp(buffer,"IEEE Address",strlen("IEEE Address")))
			{
				strcpy(u64IEEEAddress,buffer+strlen("IEEE Address: "));
			}
			if(!strncmp(buffer,"status",strlen("status")))
			{
				strcpy(status,buffer+strlen("status:"));
				if(atoi(status)==1)
				{
					strcpy(status,"On");
				}
				else if(atoi(status)==0)
				{
					strcpy(status,"Off");
				}
			}
			if(!strncmp(buffer,"brightness",strlen("brightness")))
			{
				strcpy(brightness,buffer+strlen("brightness:"));
			}
			else
			{
				continue;
			}
        }
		nBytesSent += req_format_write(wp,	
			("<tr class=\"tbl_body\"><td><font size=2>%s</td>"
		"<td><font size=2>%s</td>"
		"<td><font size=2>%s</td>"
		"</tr>"),u64IEEEAddress,status,brightness);
		fclose(fp);
	}
	else
	{
		nBytesSent += req_format_write(wp,
	   		("<tr class=\"tbl_body\"><td><font size=2>---</td>"
			"<td><font size=2>---</td>"
	     		"<td><font size=2>---</td>"
			"</tr>"));
	}
	return nBytesSent;
}
void formZigBee(request *wp, char *path, char *query)
{
	char *submitUrl;
	char *strRequest;
	char *refresh;
	char *zigbeeCmd;
	char *brightness;
	char cmd[64] = {0};
	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");
	strRequest = req_get_cstream_var(wp, ("zigbee_request"), "");
	zigbeeCmd = req_get_cstream_var(wp, ("ZigBeeCmd"), "");
	refresh = req_get_cstream_var(wp, ("refresh"), "");
	if(refresh[0])
	{
		if (submitUrl[0])
			send_redirect_perm(wp, submitUrl);
	}
	else if(strRequest[0])
	{
		if(!strcmp(zigbeeCmd,"0"))//off
		{
			system("zigbeed light_off");
		}
		if(!strcmp(zigbeeCmd,"1"))//on
		{
			system("zigbeed light_on");
		}
		if(!strcmp(zigbeeCmd,"2"))//set brightness
		{
			brightness = req_get_cstream_var(wp, ("brightness"), "");
			sprintf(cmd,"zigbeed set_brightness %s",brightness);
			system(cmd);
		}
		if(!strcmp(zigbeeCmd,"3"))//permit join
		{
			system("zigbeed permit_join");
		}
		if (submitUrl[0])
			send_redirect_perm(wp, submitUrl);
	}
}

#endif
void formUpload(request *wp, char * path, char * query)
{
	char tmpBuf[200],tmpBuf2[128],tmpBuf3[256];

	int head_offset=0;
	unsigned char *bp = NULL;

	if (isFileExist("/var/fw_upgrading")) {
		send_redirect_perm(wp, "/cgi_html_903.html");
		return;
	}

	/* WNC-NMR0000-JOE-PENG-20140214-Fix bug that upgrade firmware page does not return to Top Page of simple or detailed mode after RakuRaku is running warning message appears-start */
	/* WNC-NMR0528-JOE-PENG-20140115-Fix bug 528 "During RakuRaku or WPS, Can upgrade firmware" in Voyager-start */
	if ((lw_is_rakuraku_running()==1) || (lw_is_wps_running()==1)) {
		/* WNC-NMR1915-JOE-PENG-20161014-Fix bug 1915 [Aero] The "processing" icon and description are displayed wrong in "processing" error page-start */
		//RETURN_TOP_MSG_NEC("", "", "<font color=red>ΤꥯȤդ뤳ȤǤޤǤ</font>", "index.htm");
		send_redirect_perm(wp, "/cgi_html_903.html");
		/* WNC-NMR1915-JOE-PENG-20161014-Fix bug 1915 [Aero] The "processing" icon and description are displayed wrong in "processing" error page-end */
		return;
	}
	/* WNC-NMR0528-JOE-PENG-20140115-Fix bug 528 "During RakuRaku or WPS, Can upgrade firmware" in Voyager-end */
	/* WNC-NMR0000-JOE-PENG-20140214-Fix bug that upgrade firmware page does not return to Top Page of simple or detailed mode after RakuRaku is running warning message appears-end */

	//support multiple image
	head_offset = find_head_offset((char *)wp->upload_data);
	//fprintf(stderr,"####%s:%d %d wp->upload_data=%p###\n",  __FILE__, __LINE__ , head_offset, wp->upload_data);
	//fprintf(stderr,"####%s:%d content_length=%s###contenttype=%s###\n",  __FILE__, __LINE__ ,wp->content_length , wp->content_type);
	if (head_offset == -1) {
/* WNC-MR0000-JOE-PENG-20120330-for NEC requirement */
#if 1
/* WNC-MR0227-HENGI-CHEN-20121213- upgrade firmware failed don't use pop up message */
//		strlcpy(tmpBuf, "̵ʥե०եǤ", sizeof(tmpBuf));
//		goto ErrPopup_Upload;
		/* WNC-NMR0000-JOE-PENG-20140911-Fix bug 2167 (STRING_OVERFLOW) in StaticCodeCheck_Linear_Delta1.xls */
		strlcpy(tmpBuf3, "ե०˼Ԥޤ</br>ꤷե०ե뤬ְäƤ뤫ե빹˼Ԥǽޤ</br>٥ե०ԤԤϡե०եǧƤ", sizeof(tmpBuf3));	/* WNC-MR0000-Libera-20120308- for NEC requirement */
		strlcpy(tmpBuf2,"ե०", sizeof(tmpBuf2));
		goto fw_errback;
/* WNC-MR0227-HENGI-CHEN-20121213- end */
#else
		send_redirect_perm(wp, "/cgi_html_903.html");
		return;
#endif
/* WNC-MR0000-JOE-PENG-20120330-end */
	}

	bp =find_next_boundary(wp->upload_data+head_offset, wp->upload_len-head_offset, wp->multipart_boundary);

	write_to_file("/tmp/upload.img", bp-wp->upload_data-head_offset, wp->upload_data+head_offset);
	system("touch /var/fw_upgrading");
	formUploadMain(wp, "/tmp/upload.img");
	return;

fw_errback:
	/* WNC-MR0000-JOE-PENG-20120522-Modification for specification 1.6 */
	/* WNC-NMR0000-JOE-PENG-20140521-Modify codes of boa detecting system mode (Gateway/Bridge/Converter/Repeater)-start */
	/* Upgrade fail(Return to detail page) */
	{
		int opmode=0;//WNC-NMR0000-Rita-20130310-Error_594-fix warnings of cppcheck (uninitialized value).
		char lan_ip_buf2[30]={0}; //WNC-NMR0000-Rita-20130306-Error_481-fix warnings of cppcheck (uninitialized value).
		char lan_ip2[30];

		apmib_get( MIB_OP_MODE, (void *)&opmode);

/* WNC-MR0000-Libera-20120416- return error html for NEC */
		apmib_get( MIB_IP_ADDR,  (void *)lan_ip_buf2) ;
		snprintf(lan_ip2, sizeof(lan_ip2),"%s",inet_ntoa(*((struct in_addr *)lan_ip_buf2)) );
/* WNC-MR0000-Libera-20120416- return error html for NEC - END*/

		if (opmode == GATEWAY_MODE) {
			FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail.htm");
		} else if (opmode == BRIDGE_MODE) {
			/* WNC-NMR0000-JOE-PENG-20140430-Modify 4.1 structure of page according to Linear Spec-start */
			//FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail_bridge.htm");
			int wifi_mode=WIFI_MODE_AP;

			if (lw_get_wifi_mode(&wifi_mode) == 1) {
				switch (wifi_mode) {
					case WIFI_MODE_AP:
						FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail_bridge.htm");
						break;
					case WIFI_MODE_CLIENT:
						FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail_converter.htm");
						break;
					case WIFI_MODE_REPEATER:
						FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail_repeater.htm");
						break;
					default:
						FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail_bridge.htm");
						break;
				}
			} else {
				FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail_bridge.htm");
			}
			/* WNC-NMR0000-JOE-PENG-20140430-Modify 4.1 structure of page according to Linear Spec-end */
		} else {
			FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "index.htm");
		}
	}
	/* WNC-NMR0000-JOE-PENG-20140521-Modify codes of boa detecting system mode (Gateway/Bridge/Converter/Repeater)-end */
	/* WNC-MR0000-JOE-PENG-20120522-end */
	// WNC-MR0000-Yuan-I-Chou-20120515-firmware upgrade LED
//WNC-D2R230-YUAN-I-CHOU-20171003, Firmware upgrade modification.
//Power red LED is not ON yet, turn OFF is not necessary.
	//lw_ledctl(PWR_RED, 0, LED_FOREVER, 1, 0, LED_FOREVER);
	system("echo RLOS > /proc/ledgpio");
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131218, Modify LED control API End
	return;
ret_upload:
	Reboot_Wait=0;
//	ERR_MSG(tmpBuf);
	/* WNC-MR0000-JOE-PENG-20120330-for popup firmware error alert */
	// WNC-MR0000-Yuan-I-Chou-20120515-firmware upgrade LED
//WNC-D2R230-YUAN-I-CHOU-20171003, Firmware upgrade modification.
//Power red LED is not ON yet, turn OFF is not necessary.
	//lw_ledctl(PWR_RED, 0, LED_FOREVER, 1, 0, LED_FOREVER);
	system("echo RLOS > /proc/ledgpio");
	send_redirect_perm(wp, "/cgi_html_903.html");
	unlink("/var/fw_upgrading");
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131218, Modify LED control API End
	return;
}

void formUploadMain(request *wp, char *file)
{
	//int fh;
	int len;
	int locWrite;
	int numLeft;
	//int numWrite;
	IMG_HEADER_Tp pHeader;
	char tmpBuf[200],tmpBuf2[128],tmpBuf3[256];
#ifndef REBOOT_CHECK
	char lan_ip_buf[30];
	char lan_ip[30];
#endif
// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 884 UNUSED_VALUE
//	char *submitUrl;
// WNC-NMR0000-Heng-I-Chen-20130814: End
	int flag=0, startAddr=-1;
	int isIncludeRoot=0;
#ifndef NO_ACTION
	//int pid;
#endif
	int head_offset=0;
	int update_fw=0, update_cfg=0;
	//Support WAPI/openssl, the flash MUST up to 4m
/*
#if defined(CONFIG_RTL_WAPI_SUPPORT) || defined(HTTP_FILE_SERVER_SUPPORTED)
	int fwSizeLimit = 0x400000;
#elif defined( CONFIG_RTK_VOIP )
	int fwSizeLimit = 0x400000;
#else
	int fwSizeLimit = 0x200000;
#endif
*/
	int fwSizeLimit = CONFIG_FLASH_SIZE;
	unsigned char isValidfw = 0;
	int ret = 0;

	// WNC-MR0000-Yuan-I-Chou-20120515-firmware upgrade LED
//WNC-D2R230-YUAN-I-CHOU-20171003, Firmware upgrade modification.
//Move turn ON power red LED to ready to write firmware
//Move cancel LED light off setting to user click OK on GUI
	//system("echo CLOS > /proc/ledgpio");
	//lw_ledctl(PWR_RED, LED_FOREVER, 0, 1, 0, LED_FOREVER);

// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 884 UNUSED_VALUE
//	submitUrl = req_get_cstream_var(wp, "submit-url", "");
	//fprintf(stderr,"####%s:%d submitUrl=%s###\n",  __FILE__, __LINE__ , submitUrl);
// WNC-NMR0000-Heng-I-Chen-20130814: End

	FILE *fp0=NULL;
	FILE *fp1=NULL;
	FILE *fp2=NULL;

	//decoding the encryption image
	if (decode_image(file,  "/tmp/image.tar") != 0) {
		send_redirect_perm(wp, "/fw_main_update_failure.html");
		unlink("/var/fw_upgrading");
		goto ret_upload;
	}

	unlink(file);

	ret = system("tar xf /tmp/image.tar -C /tmp");

	if (ret != 0 ) {
		send_redirect_perm(wp, "/fw_main_update_failure.html");
		unlink("/var/fw_upgrading");
		goto ret_upload;
	}

	unlink("/tmp/image.tar");

	//verifying signature of encryption image
#if 1
	{
		FILE *tp = NULL;
		char buffer[512]={0};
		int result = -1;

		tp = popen("efdgx -v -p /etc/efdgx.pbk -s /tmp/fw.bin.sig -i /tmp/fw.bin", "r");

		if(tp == NULL) {
			send_redirect_perm(wp, "/fw_main_update_failure.html");
			unlink("/var/fw_upgrading");
			goto ret_upload;
		}

		while( fgets(buffer,sizeof(buffer),tp) != NULL){
//			console_printf("Verify: %s\n", buffer);
			if (result == -1) {
				if (memcmp(buffer, "FW verify OK", 12) == 0) {
					result = 0;
				}
			}
		}
		fclose(tp);
		tp = NULL;
		if (result == -1) {
			send_redirect_perm(wp, "/fw_main_update_failure.html");
			unlink("/var/fw_upgrading");
			goto ret_upload;
		}
	}
#else
	if ((fp0 = fopen("/etc/efdgx.pbk", "r")) == NULL) {
		send_redirect_perm(wp, "/fw_main_update_failure.html");
		unlink("/var/fw_upgrading");
		goto ret_upload;
	}
	if ((fp1 = fopen("/tmp/fw.bin.sig", "r")) == NULL) {
		send_redirect_perm(wp, "/fw_main_update_failure.html");
		unlink("/var/fw_upgrading");
		fclose(fp0);
		fp0 = NULL;
		goto ret_upload;
	}
	if ((fp2 = fopen("/tmp/fw.bin", "r")) == NULL) {
		send_redirect_perm(wp, "/fw_main_update_failure.html");
		unlink("/var/fw_upgrading");
		fclose(fp0);
		fp0 = NULL;
		fclose(fp1);
		fp1 = NULL;
		goto ret_upload;
	}

	ret = VFY(fp0, fp1, fp2);

	fclose(fp0);
	fp0 = NULL;
	fclose(fp1);
	fp1 = NULL;
	fclose(fp2);
	fp2 = NULL;
#endif

	if (ret != 0) {
		send_redirect_perm(wp, "/fw_main_update_failure.html");
		unlink("/var/fw_upgrading");
		goto ret_upload;
	}

	unlink("/tmp/fw.bin.sig");

	struct stat statbuf;
	ret = stat("/tmp/fw.bin", &statbuf);

	int fwlen = statbuf.st_size;

//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, Add Shared memory protection
#if defined(CONFIG_APP_FWD)
	if (is_shm_locked()) {
		strlcpy(tmpBuf, "Shared memory is locked!", sizeof(tmpBuf));
		goto ret_upload;
	}
#endif
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, End

	if (shm_memory == NULL) {
		void *addr = NULL;
		addr = allocate_shm(fwlen);
		if (addr == NULL) {
			strlcpy(tmpBuf, "Shared memory allocate failed!", sizeof(tmpBuf));
			goto ret_upload;
		}
		free(wp->upload_data);
		wp->upload_data = addr;
		wp->upload_len = fwlen;

		request_lock_shm = wp;
		last_access_time = time(NULL);
	}

#if 1
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, Add Shared memory protection
#if defined(CONFIG_APP_FWD)
	shm_lock();
#endif
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, End
#else //original
#ifndef REBOOT_CHECK
	apmib_get( MIB_IP_ADDR,  (void *)lan_ip_buf) ;
	snprintf(lan_ip, sizeof(lan_ip),"%s",inet_ntoa(*((struct in_addr *)lan_ip_buf)) );
#endif
	
	submitUrl = req_get_cstream_var(wp, "submit-url", "");
	//fprintf(stderr,"####%s:%d submitUrl=%s###\n",  __FILE__, __LINE__ , submitUrl);
	//support multiple image
	head_offset = find_head_offset((char *)wp->upload_data);
	//fprintf(stderr,"####%s:%d %d wp->upload_data=%p###\n",  __FILE__, __LINE__ , head_offset, wp->upload_data);
	//fprintf(stderr,"####%s:%d content_length=%s###contenttype=%s###\n",  __FILE__, __LINE__ ,wp->content_length , wp->content_type);
	if (head_offset == -1) {
		strlcpy(tmpBuf, "<b>Invalid file format!", sizeof(tmpBuf));
		goto ret_upload;
	}
#endif	
	fp0 = fopen("/tmp/fw.bin", "r");
	fread(wp->upload_data, 1, statbuf.st_size, fp0);
	fclose(fp0);
	fp0 = NULL;

//WNC-HENG-I-20160802, One firmware modification
	if (checkIdentifierKey(wp->upload_data + head_offset, wp->upload_len)) {
		snprintf(tmpBuf, sizeof(tmpBuf), "Error Identifier Key");
		goto fw_errback;
	}
	head_offset += IDENTIFIER_KEY_LEN;
//WNC-HENG-I-20160802, One firmware modification End

	while ((head_offset+sizeof(IMG_HEADER_T)) <  wp->upload_len) {
		locWrite = 0;
		pHeader = (IMG_HEADER_Tp) &wp->upload_data[head_offset];
		len = pHeader->len;
#ifdef _LITTLE_ENDIAN_
		len  = DWORD_SWAP(len);
#endif    
		numLeft = len + sizeof(IMG_HEADER_T);
		// check header and checksum
		if (!memcmp(&wp->upload_data[head_offset], FW_HEADER, SIGNATURE_LEN) ||
		    !memcmp(&wp->upload_data[head_offset], FW_HEADER_WITH_ROOT, SIGNATURE_LEN)) {
		    	isValidfw = 1;
			flag = 1;
			//Reboot_Wait = Reboot_Wait+ 50;
		} else if (!memcmp(&wp->upload_data[head_offset], WEB_HEADER, SIGNATURE_LEN)) {
			isValidfw = 1;
			flag = 2;
			//Reboot_Wait = Reboot_Wait+ 40;
		} else if (!memcmp(&wp->upload_data[head_offset], ROOT_HEADER, SIGNATURE_LEN)) {
			isValidfw = 1;
			flag = 3;
			//Reboot_Wait = Reboot_Wait+ 60;
			isIncludeRoot = 1;	
		}
//WNC-JDR230-NMR0393-HENG-I-CHEN-20130417-Remove valid signature for config file 
#if 0
		else if ( 
#ifdef COMPRESS_MIB_SETTING
				!memcmp(&wp->upload_data[head_offset], COMP_HS_SIGNATURE, COMP_SIGNATURE_LEN) ||
				!memcmp(&wp->upload_data[head_offset], COMP_DS_SIGNATURE, COMP_SIGNATURE_LEN) ||
				!memcmp(&wp->upload_data[head_offset], COMP_CS_SIGNATURE, COMP_SIGNATURE_LEN)
#else
				!memcmp(&wp->upload_data[head_offset], CURRENT_SETTING_HEADER_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], CURRENT_SETTING_HEADER_FORCE_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], CURRENT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], DEFAULT_SETTING_HEADER_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], DEFAULT_SETTING_HEADER_FORCE_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], DEFAULT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], HW_SETTING_HEADER_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], HW_SETTING_HEADER_FORCE_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], HW_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) 
#endif
			) {
#if 1
			strlcpy(tmpBuf, ("<b>Invalid file format! Should upload fireware but not config dat!"), sizeof(tmpBuf));
			goto ret_upload;
#else
#ifdef COMPRESS_MIB_SETTING
				COMPRESS_MIB_HEADER_Tp pHeader_cfg;
				pHeader_cfg = (COMPRESS_MIB_HEADER_Tp)&wp->upload_data[head_offset];
				if(!memcmp(&wp->upload_data[head_offset], COMP_CS_SIGNATURE, COMP_SIGNATURE_LEN)) {
					head_offset +=  pHeader_cfg->compLen+sizeof(COMPRESS_MIB_HEADER_T);
					configlen = head_offset;
				}
				else {
					head_offset +=  pHeader_cfg->compLen+sizeof(COMPRESS_MIB_HEADER_T);
				}
#else
#ifdef HEADER_LEN_INT
				if(!memcmp(&wp->upload_data[head_offset], HW_SETTING_HEADER_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], HW_SETTING_HEADER_FORCE_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], HW_SETTING_HEADER_UPGRADE_TAG, TAG_LEN))
				{
					HW_PARAM_HEADER_Tp phwHeader_cfg;
					phwHeader_cfg = (HW_PARAM_HEADER_Tp)&wp->upload_data[head_offset];
					head_offset +=  phwHeader_cfg->len+sizeof(HW_PARAM_HEADER_T);
				}
				else
#endif
				{
					PARAM_HEADER_Tp pHeader_cfg;
					pHeader_cfg = (PARAM_HEADER_Tp)&wp->upload_data[head_offset];
					head_offset +=  pHeader_cfg->len+sizeof(PARAM_HEADER_T);
				}
#endif
				isValidfw = 1;
				update_cfg = 1;
				continue;
#endif
		}
#endif
//WNC-JDR230-NMR0393-HENG-I-CHEN-20130417-End 		
		else {
			if (isValidfw == 1)
				break;
/* WNC-MR0000-JOE-PENG-20120330-for NEC requirement */
#if 1
/* WNC-MR0000-Libera-20120416- return error html for NEC */
		//	strlcpy(tmpBuf, "̵ʥե०եǤ", sizeof(tmpBuf));
		//	goto ErrPopup_Upload;
		/* WNC-MR0000-JOE-PENG-20120522-Modification for specification 1.6 */
		/* WNC-NMR0000-JOE-PENG-20140911-Fix bug 2218 (STRING_OVERFLOW) in StaticCodeCheck_Linear_Delta1.xls */
		strlcpy(tmpBuf3, "ե०˼Ԥޤ</br>ꤷե०ե뤬ְäƤ뤫ե빹˼Ԥǽޤ</br>٥ե०ԤԤϡե०եǧƤ", sizeof(tmpBuf3));	/* WNC-MR0000-Libera-20120308- for NEC requirement */
		strlcpy(tmpBuf2,"ե०", sizeof(tmpBuf2));
			goto fw_errback;
#else
			strlcpy(tmpBuf, "<b>Invalid file format!", sizeof(tmpBuf));
			goto ret_upload;
#endif
/* WNC-MR0000-JOE-PENG-20120330-end */
		}

		if (head_offset + numLeft >  wp->upload_len) { // file completion check 
			console_printf("Uploaded image is not completed\n");
			goto fw_errback;
		}

		if (len > fwSizeLimit) { //len check by sc_yang
			snprintf(tmpBuf, sizeof(tmpBuf), "<b>Image len exceed max size 0x%x ! len=0x%x</b><br>",fwSizeLimit, len);
//				goto ret_upload;
				goto fw_errback;
		}
#ifdef CONFIG_RTL_WAPI_SUPPORT
		if((flag == 3) && (len>WAPI_AREA_BASE)) {
			snprintf(tmpBuf, sizeof(tmpBuf), "<b>Root image len 0x%x exceed 0x%x which will overwrite wapi area at flash ! </b><br>", len, WAPI_AREA_BASE);
//				goto ret_upload;
				goto fw_errback;
		}
#endif
		if ( (flag == 1) || (flag == 3)) {
			if ( !fwChecksumOk((char *)&wp->upload_data[sizeof(IMG_HEADER_T)+head_offset], len)) {
				snprintf(tmpBuf, sizeof(tmpBuf), "<b>Image checksum mismatched! len=0x%x, checksum=0x%x</b><br>", len,
					*((unsigned short *)&wp->upload_data[len-2]) );
//				goto ret_upload;
				goto fw_errback;
			}
		}
		else {
			char *ptr = (char *)&wp->upload_data[sizeof(IMG_HEADER_T)+head_offset];
			if ( !CHECKSUM_OK((unsigned char *)ptr, len) ) {
				snprintf(tmpBuf, sizeof(tmpBuf), "<b>Image checksum mismatched! len=0x%x</b><br>", len);
//				goto ret_upload;
				goto fw_errback;
			}
		}
#ifdef HOME_GATEWAY
#ifdef REBOOT_CHECK
		snprintf(tmpBuf, sizeof(tmpBuf), "Upload successfully (size = %d bytes)!<br><br>Firmware update in progress.", wp->upload_len);
#else
		snprintf(tmpBuf, sizeof(tmpBuf), "Upload successfully (size = %d bytes)!<br><br>Firmware update in progress.<br> Do not turn off or reboot the AP during this time.", wp->upload_len);
#endif
#else
		snprintf(tmpBuf, sizeof(tmpBuf), "Upload successfully (size = %d bytes)!<br><br>Firmware update in progress.<br> Do not turn off or reboot the AP during this time.", wp->upload_len);
#endif
		//sc_yang
		head_offset += len + sizeof(IMG_HEADER_T);
		startAddr = -1 ; //by sc_yang to reset the startAddr for next image
		update_fw = 1;
	} //while //sc_yang    

	isFWUPGRADE = 1;

#if defined(CONFIG_DOMAIN_NAME_QUERY_SUPPORT)
	Stop_Domain_Query_Process();
	WaitCountTime=2;
#endif

#if defined(CONFIG_RTL_819X)
#ifdef RTL_8367R_DUAL_BAND
	Reboot_Wait = (wp->upload_len/69633)+57+5+15;
#elif defined(RTL_8367R_8881a_DUAL_BAND)
	Reboot_Wait = (wp->upload_len/69633)+57+5+25;
#elif defined(CONFIG_RTL_8198C)
	Reboot_Wait = (wp->upload_len/19710)+50+5;
#else
	Reboot_Wait = (wp->upload_len/69633)+57+5;
#endif
	if (update_cfg==1 && update_fw==0) {
		strlcpy(tmpBuf, "<b>Update successfully!", sizeof(tmpBuf));
		Reboot_Wait = (wp->upload_len/69633)+45+5;
		isCFG_ONLY= 1;
	}
#else
	Reboot_Wait = (wp->upload_len/43840)+35;
	if (update_cfg==1 && update_fw==0) {
		strlcpy(tmpBuf, "<b>Update successfully!", sizeof(tmpBuf));
		Reboot_Wait = (wp->upload_len/43840)+30;
		isCFG_ONLY= 1;
	}
#endif

	/* WNC-NMR0000-JOE-PENG-20141114- Add 10 seconds to current reboot time of firmware upgrade after we apply Realtek patch to fix Linear aging test fail issue */
	Reboot_Wait = Reboot_Wait + 15;

#ifdef REBOOT_CHECK
	snprintf(lastUrl, sizeof(lastUrl),"%s","/status.htm");
	snprintf(okMsg, sizeof(okMsg),"%s",tmpBuf);
	countDownTime = Reboot_Wait;
//	send_redirect_perm(wp, COUNTDOWN_PAGE);
	send_redirect_perm(wp, "/fw_main_updating.html");
#else
	apmib_get( MIB_IP_ADDR,  (void *)lan_ip_buf) ;
	snprintf(lan_ip, sizeof(lan_ip),"%s",inet_ntoa(*((struct in_addr *)lan_ip_buf)) );
	OK_MSG_FW(tmpBuf, submitUrl,Reboot_Wait,lan_ip);
#endif
	return;

ret_upload:
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, Add Shared memory protection
#if defined(CONFIG_APP_FWD)
	//clear_fwupload_shm(shm_id);
// WNC-NMR0765-JDR231-HENG-I-CHEN-2014-10-02: add proection of firmware file uploading #BEGIN
	if (wp == request_lock_shm) {
		shm_unlock();
		clear_shm();
		wp->upload_data = NULL;
	}
// WNC-NMR0765-JDR231-HENG-I-CHEN-2014-10-02: add proection of firmware file uploading #END
#endif
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, End
	Reboot_Wait=0;
//	ERR_MSG(tmpBuf);
	/* WNC-MR0000-JOE-PENG-20120330-for popup firmware error alert */
	// WNC-MR0000-Yuan-I-Chou-20120515-firmware upgrade LED
//WNC-D2R230-YUAN-I-CHOU-20171003, Firmware upgrade modification.
//Power red LED is not ON yet, turn OFF is not necessary.
	//lw_ledctl(PWR_RED, 0, LED_FOREVER, 1, 0, LED_FOREVER);
	system("echo RLOS > /proc/ledgpio");
	send_redirect_perm(wp, "/cgi_html_903.html");
	unlink("/var/fw_upgrading");
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131218, Modify LED control API End
	return;
fw_errback:	/* WNC-MR0000-Libera-20120416- for return error html */
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, Add Shared memory protection
#if defined(CONFIG_APP_FWD)
	shm_unlock();
	clear_shm();
	wp->upload_data = NULL;
#endif
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, End
	if (strcmp(wp->request_uri, "/boafrm/formOnlineVersionUp") == 0) {
		upgrade_method=1;
	} else {
		upgrade_method=0;
	}
	
	send_redirect_perm(wp, "/fw_main_update_failure.html");
	unlink("/var/fw_upgrading");
#if 0
	/* WNC-MR0000-JOE-PENG-20120522-Modification for specification 1.6 */
	/* Upgrade fail(Return to detail page) */
	{
		int opmode=0;//WNC-NMR0000-Rita-20130310-Error_595-fix warnings of cppcheck (uninitialized value).
		/* WNC-NMR0000-JOE-PENG-20131202-Correct the return homepage link when upgrade firmware or configuration fails in repeater mode-start */
		/* WNC-NMR0240-JOE-PENG-20121210-Fix bug that return home page is incorrect if mode is repeater mode.-->start */
		/* WNC-NMR0000-JOE-PENG-20140521-Modify codes of boa detecting system mode (Gateway/Bridge/Converter/Repeater)-start */
		apmib_get( MIB_OP_MODE, (void *)&opmode);

		if (opmode == GATEWAY_MODE) {
			FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail.htm");
		} else if (opmode == BRIDGE_MODE) {
			/* WNC-NMR0000-JOE-PENG-20140430-Modify 4.1 structure of page according to Linear Spec-start */
			//FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail_bridge.htm");
			int wifi_mode=WIFI_MODE_AP;
			
			if (lw_get_wifi_mode(&wifi_mode) == 1) {
				switch (wifi_mode) {
					case WIFI_MODE_AP:
						FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail_bridge.htm");
						break;
					case WIFI_MODE_CLIENT:
						FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail_converter.htm");
						break;
					case WIFI_MODE_REPEATER:
						FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail_repeater.htm");
						break;
					default:
						FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail_bridge.htm");
						break;
				}	
			} else {
				FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail_bridge.htm");
			}
			/* WNC-NMR0000-JOE-PENG-20140521-Modify codes of boa detecting system mode (Gateway/Bridge/Converter/Repeater)-end */
			/* WNC-NMR0000-JOE-PENG-20140430-Modify 4.1 structure of page according to Linear Spec-end */
		} else {
			FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "index.htm");
		}
		/* WNC-NMR0000-JOE-PENG-20140521-Modify codes of boa detecting system mode (Gateway/Bridge/Converter/Repeater)-end */
		/* WNC-NMR0240-JOE-PENG-20121210-Fix bug that return home page is incorrect if mode is repeater mode.-->end */
		/* WNC-NMR0000-JOE-PENG-20131202-Correct the return homepage link when upgrade firmware or configuration fails in repeater mode-end */
	}
	/* WNC-MR0000-JOE-PENG-20120522-end */
#endif	
	// WNC-MR0000-Yuan-I-Chou-20120515-firmware upgrade LED
//WNC-D2R230-YUAN-I-CHOU-20171003, Firmware upgrade modification.
//Power red LED is not ON yet, turn OFF is not necessary.
	//lw_ledctl(PWR_RED, 0, LED_FOREVER, 1, 0, LED_FOREVER);
	system("echo RLOS > /proc/ledgpio");
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131218, Modify LED control API End
	return;
// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 832 UNREACHABLE
#if 0
//ErrPopup_Upload:
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, Add Shared memory protection
#if defined(CONFIG_APP_FWD)
	shm_unlock();
	clear_shm();
	wp->upload_data = NULL;
#endif
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, End
	Reboot_Wait=0;
	POP_ERR_MSG(tmpBuf);
	// WNC-MR0000-Yuan-I-Chou-20120515-firmware upgrade LED
	system("echo 5 0 4000 1 0 4000 > /proc/ledgpio");
	return;
	/* WNC-MR0000-JOE-PENG-20120330-end */
#endif
// WNC-NMR0000-Heng-I-Chen-20130814: End


}

/*WNC-MR0000-Rita-20121120-upgrade firmware to Ebank */
void formUploadToEbank(request *wp, char * path, char * query)
{
	//int fh;
	int len;
	int locWrite;
	int numLeft;
	//int numWrite;
	IMG_HEADER_Tp pHeader;
	char tmpBuf[200],tmpBuf2[128],tmpBuf3[256];
	char lan_ip_buf2[30]={0};//WNC-NMR0000-Rita-20130306-Error_479-fix warnings of cppcheck (uninitialized value).
	char lan_ip2[30];
#ifndef REBOOT_CHECK
	char lan_ip_buf[30];
	char lan_ip[30];
#endif
// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 860 UNUSED_VALUE
//	char *submitUrl;
// WNC-NMR0000-Heng-I-Chen-20130814: End
	int flag=0, startAddr=-1;
	int isIncludeRoot=0;
#ifndef NO_ACTION
	//int pid;
#endif
	int head_offset=0;
	int update_fw=0, update_cfg=0;
	//Support WAPI/openssl, the flash MUST up to 4m
#if defined(CONFIG_RTL_WAPI_SUPPORT) || defined(HTTP_FILE_SERVER_SUPPORTED)
	int fwSizeLimit = 0x400000;
#elif defined( CONFIG_RTK_VOIP )
	int fwSizeLimit = 0x400000;
#else
	int fwSizeLimit = 0x200000;
#endif
	unsigned char isValidfw = 0;

	// WNC-MR0000-Yuan-I-Chou-20120515-firmware upgrade LED
//WNC-D2R230-YUAN-I-CHOU-20171003, Firmware upgrade modification.
//Move turn ON power red LED to ready to write firmware
//Move cancel LED light off setting to user click OK on GUI
	//system("echo CLOS > /proc/ledgpio");
	//lw_ledctl(PWR_RED, LED_FOREVER, 0, 1, 0, LED_FOREVER);

#ifndef REBOOT_CHECK
	apmib_get( MIB_IP_ADDR,  (void *)lan_ip_buf) ;
	snprintf(lan_ip, sizeof(lan_ip),"%s",inet_ntoa(*((struct in_addr *)lan_ip_buf)) );
#endif

/* WNC-MR0000-Libera-20120416- return error html for NEC */
	apmib_get( MIB_IP_ADDR,  (void *)lan_ip_buf2) ;
	snprintf(lan_ip2, sizeof(lan_ip2),"%s",inet_ntoa(*((struct in_addr *)lan_ip_buf2)) );
/* WNC-MR0000-Libera-20120416- return error html for NEC - END*/

// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 860 UNUSED_VALUE
//	submitUrl = req_get_cstream_var(wp, "submit-url", "");
	//fprintf(stderr,"####%s:%d submitUrl=%s###\n",  __FILE__, __LINE__ , submitUrl);
// WNC-NMR0000-Heng-I-Chen-20130814: End
    /* WNC-MR0000-Rita-20121119-hidden page for firmware upgrade to E-bank */
    system("echo 1 > /var/upgrade2Ebank");

	//support multiple image
	head_offset = find_head_offset((char *)wp->upload_data);
	//fprintf(stderr,"####%s:%d %d wp->upload_data=%p###\n",  __FILE__, __LINE__ , head_offset, wp->upload_data);
	//fprintf(stderr,"####%s:%d content_length=%s###contenttype=%s###\n",  __FILE__, __LINE__ ,wp->content_length , wp->content_type);
	if (head_offset == -1) {
/* WNC-MR0000-JOE-PENG-20120330-for NEC requirement */
#if 1
		strlcpy(tmpBuf, "̵ʥե०եǤ", sizeof(tmpBuf));
		goto ErrPopup_Upload;
#else
		strlcpy(tmpBuf, "<b>Invalid file format!", sizeof(tmpBuf));
		goto ret_upload;
#endif
/* WNC-MR0000-JOE-PENG-20120330-end */
	}
	//decoding the encryption firmware
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, Add Shared memory protection
#if defined(CONFIG_APP_FWD)
	if (is_shm_locked()) {
		strlcpy(tmpBuf, "Shared memory is locked!", sizeof(tmpBuf));
		goto ret_upload;
	} else 
#endif
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, End
	{
		int i, j, k;
		//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131223,Define FW_ENC_KEY and CF_ENC_KEY in libwnc
		char enckey[64] = FW_ENC_KEY;
		int keylen = strlen(enckey);

		for ( i = head_offset, j = 1, k = 0 ; i < wp->upload_len ; i++) {
			wp->upload_data[i] ^= j;
			wp->upload_data[i] ^= enckey[k];
			j++;
			if ( j > 251 )
				j = 1;
			k++;
			if ( k >= keylen)
				k = 0;
		}
	}

//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, Add Shared memory protection
#if defined(CONFIG_APP_FWD)
	shm_lock();
#endif
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, End

//WNC-HENG-I-20160802, One firmware modification
	if (checkIdentifierKey(wp->upload_data + head_offset, wp->upload_len)) {
		snprintf(tmpBuf, sizeof(tmpBuf), "Error Identifier Key");
		goto fw_errback;
	}

	head_offset += IDENTIFIER_KEY_LEN;
//WNC-HENG-I-20160802, One firmware modification End

	while ((head_offset+sizeof(IMG_HEADER_T)) <  wp->upload_len) {
		locWrite = 0;
		pHeader = (IMG_HEADER_Tp) &wp->upload_data[head_offset];
		len = pHeader->len;
#ifdef _LITTLE_ENDIAN_
		len  = DWORD_SWAP(len);
#endif    
		numLeft = len + sizeof(IMG_HEADER_T);
		// check header and checksum
		if (!memcmp(&wp->upload_data[head_offset], FW_HEADER, SIGNATURE_LEN) ||
		    !memcmp(&wp->upload_data[head_offset], FW_HEADER_WITH_ROOT, SIGNATURE_LEN)) {
		    	isValidfw = 1;
			flag = 1;
			//Reboot_Wait = Reboot_Wait+ 50;
		} else if (!memcmp(&wp->upload_data[head_offset], WEB_HEADER, SIGNATURE_LEN)) {
			isValidfw = 1;
			flag = 2;
			//Reboot_Wait = Reboot_Wait+ 40;
		} else if (!memcmp(&wp->upload_data[head_offset], ROOT_HEADER, SIGNATURE_LEN)) {
			isValidfw = 1;
			flag = 3;
			//Reboot_Wait = Reboot_Wait+ 60;
			isIncludeRoot = 1;	
		}else if ( 
#ifdef COMPRESS_MIB_SETTING
				!memcmp(&wp->upload_data[head_offset], COMP_HS_SIGNATURE, COMP_SIGNATURE_LEN) ||
				!memcmp(&wp->upload_data[head_offset], COMP_DS_SIGNATURE, COMP_SIGNATURE_LEN) ||
				!memcmp(&wp->upload_data[head_offset], COMP_CS_SIGNATURE, COMP_SIGNATURE_LEN)
#else
				!memcmp(&wp->upload_data[head_offset], CURRENT_SETTING_HEADER_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], CURRENT_SETTING_HEADER_FORCE_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], CURRENT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], DEFAULT_SETTING_HEADER_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], DEFAULT_SETTING_HEADER_FORCE_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], DEFAULT_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], HW_SETTING_HEADER_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], HW_SETTING_HEADER_FORCE_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], HW_SETTING_HEADER_UPGRADE_TAG, TAG_LEN) 
#endif
			) {
#if 1
			strlcpy(tmpBuf, ("<b>Invalid file format! Should upload fireware but not config dat!"), sizeof(tmpBuf));
			goto ret_upload;
#else
#ifdef COMPRESS_MIB_SETTING
				COMPRESS_MIB_HEADER_Tp pHeader_cfg;
				pHeader_cfg = (COMPRESS_MIB_HEADER_Tp)&wp->upload_data[head_offset];
				if(!memcmp(&wp->upload_data[head_offset], COMP_CS_SIGNATURE, COMP_SIGNATURE_LEN)) {
					head_offset +=  pHeader_cfg->compLen+sizeof(COMPRESS_MIB_HEADER_T);
					configlen = head_offset;
				}
				else {
					head_offset +=  pHeader_cfg->compLen+sizeof(COMPRESS_MIB_HEADER_T);
				}
#else
#ifdef HEADER_LEN_INT
				if(!memcmp(&wp->upload_data[head_offset], HW_SETTING_HEADER_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], HW_SETTING_HEADER_FORCE_TAG, TAG_LEN) ||
				!memcmp(&wp->upload_data[head_offset], HW_SETTING_HEADER_UPGRADE_TAG, TAG_LEN))
				{
					HW_PARAM_HEADER_Tp phwHeader_cfg;
					phwHeader_cfg = (HW_PARAM_HEADER_Tp)&wp->upload_data[head_offset];
					head_offset +=  phwHeader_cfg->len+sizeof(HW_PARAM_HEADER_T);
				}
				else
#endif
				{
					PARAM_HEADER_Tp pHeader_cfg;
					pHeader_cfg = (PARAM_HEADER_Tp)&wp->upload_data[head_offset];
					head_offset +=  pHeader_cfg->len+sizeof(PARAM_HEADER_T);
				}
#endif
				isValidfw = 1;
				update_cfg = 1;
				continue;
#endif
		}
		else {
			if (isValidfw == 1)
				break;
/* WNC-MR0000-JOE-PENG-20120330-for NEC requirement */
#if 1
/* WNC-MR0000-Libera-20120416- return error html for NEC */
		//	strlcpy(tmpBuf, "̵ʥե०եǤ", sizeof(tmpBuf));
		//	goto ErrPopup_Upload;
		/* WNC-MR0000-JOE-PENG-20120522-Modification for specification 1.6 */
		/* WNC-NMR0000-JOE-PENG-20140911-Fix bug 2212 (STRING_OVERFLOW) in StaticCodeCheck_Linear_Delta1.xls */
		strlcpy(tmpBuf3, "ե०˼Ԥޤ</br>ꤷե०ե뤬ְäƤ뤫ե빹˼Ԥǽޤ</br>٥ե०ԤԤϡե०եǧƤ", sizeof(tmpBuf3));	/* WNC-MR0000-Libera-20120308- for NEC requirement */
		strlcpy(tmpBuf2,"ե०", sizeof(tmpBuf2));
			goto fw_errback;
#else
			strlcpy(tmpBuf, "<b>Invalid file format!", sizeof(tmpBuf));
			goto ret_upload;
#endif
/* WNC-MR0000-JOE-PENG-20120330-end */
		}

		if (len > fwSizeLimit) { //len check by sc_yang
			snprintf(tmpBuf, sizeof(tmpBuf), "<b>Image len exceed max size 0x%x ! len=0x%x</b><br>",fwSizeLimit, len);
			goto ret_upload;
		}
#ifdef CONFIG_RTL_WAPI_SUPPORT
		if((flag == 3) && (len>WAPI_AREA_BASE)) {
			snprintf(tmpBuf, sizeof(tmpBuf), "<b>Root image len 0x%x exceed 0x%x which will overwrite wapi area at flash ! </b><br>", len, WAPI_AREA_BASE);
			goto ret_upload;
		}
#endif
		if ( (flag == 1) || (flag == 3)) {
			if ( !fwChecksumOk((char *)&wp->upload_data[sizeof(IMG_HEADER_T)+head_offset], len)) {
				snprintf(tmpBuf, sizeof(tmpBuf), "<b>Image checksum mismatched! len=0x%x, checksum=0x%x</b><br>", len,
					*((unsigned short *)&wp->upload_data[len-2]) );
				goto ret_upload;
			}
		}
		else {
			char *ptr = (char *)&wp->upload_data[sizeof(IMG_HEADER_T)+head_offset];
			if ( !CHECKSUM_OK((unsigned char *)ptr, len) ) {
				snprintf(tmpBuf, sizeof(tmpBuf), "<b>Image checksum mismatched! len=0x%x</b><br>", len);
				goto ret_upload;
			}
		}
#ifdef HOME_GATEWAY
#ifdef REBOOT_CHECK
		snprintf(tmpBuf, sizeof(tmpBuf), "Upload successfully (size = %d bytes)!<br><br>Firmware update in progress.", wp->upload_len);
#else
		snprintf(tmpBuf, sizeof(tmpBuf), "Upload successfully (size = %d bytes)!<br><br>Firmware update in progress.<br> Do not turn off or reboot the AP during this time.", wp->upload_len);
#endif
#else
		snprintf(tmpBuf, sizeof(tmpBuf), "Upload successfully (size = %d bytes)!<br><br>Firmware update in progress.<br> Do not turn off or reboot the AP during this time.", wp->upload_len);
#endif
		//sc_yang
		head_offset += len + sizeof(IMG_HEADER_T);
		startAddr = -1 ; //by sc_yang to reset the startAddr for next image
		update_fw = 1;
	} //while //sc_yang    

	isFWUPGRADE = 1;

#if defined(CONFIG_DOMAIN_NAME_QUERY_SUPPORT)
	Stop_Domain_Query_Process();
	WaitCountTime=2;
#endif

#if defined(CONFIG_RTL_819X)
#ifdef RTL_8367R_DUAL_BAND
	Reboot_Wait = (wp->upload_len/69633)+57+5+15;
#elif defined(RTL_8367R_8881a_DUAL_BAND)
	Reboot_Wait = (wp->upload_len/69633)+57+5+25;
#else
	Reboot_Wait = (wp->upload_len/69633)+57+5;
#endif
	if (update_cfg==1 && update_fw==0) {
		strlcpy(tmpBuf, "<b>Update successfully!", sizeof(tmpBuf));
		Reboot_Wait = (wp->upload_len/69633)+45+5;
		isCFG_ONLY= 1;
	}
#else
	Reboot_Wait = (wp->upload_len/43840)+35;
	if (update_cfg==1 && update_fw==0) {
		strlcpy(tmpBuf, "<b>Update successfully!", sizeof(tmpBuf));
		Reboot_Wait = (wp->upload_len/43840)+30;
		isCFG_ONLY= 1;
	}
#endif

#ifdef REBOOT_CHECK
	snprintf(lastUrl, sizeof(lastUrl),"%s","/status.htm");
	snprintf(okMsg, sizeof(okMsg),"%s",tmpBuf);
	countDownTime = Reboot_Wait;
	send_redirect_perm(wp, COUNTDOWN_PAGE);
#else
	OK_MSG_FW(tmpBuf, submitUrl,Reboot_Wait,lan_ip);
#endif
	return;

ret_upload:
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, Add Shared memory protection
#if defined(CONFIG_APP_FWD)
	shm_unlock();
	clear_shm();
	wp->upload_data = NULL;
#endif
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, End
	Reboot_Wait=0;
	ERR_MSG(tmpBuf);
	/* WNC-MR0000-JOE-PENG-20120330-for popup firmware error alert */
	// WNC-MR0000-Yuan-I-Chou-20120515-firmware upgrade LED
//WNC-D2R230-YUAN-I-CHOU-20171003, Firmware upgrade modification.
//Power red LED is not ON yet, turn OFF is not necessary.
	//lw_ledctl(PWR_RED, 0, LED_FOREVER, 1, 0, LED_FOREVER);
	system("echo RLOS > /proc/ledgpio");
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131218, Modify LED control API End
	return;
fw_errback:	/* WNC-MR0000-Libera-20120416- for return error html */
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, Add Shared memory protection
#if defined(CONFIG_APP_FWD)
	shm_unlock();
	clear_shm();
	wp->upload_data = NULL;
#endif
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, End

	/* WNC-MR0000-JOE-PENG-20120522-Modification for specification 1.6 */
	/* WNC-NMR0000-JOE-PENG-20140521-Modify codes of boa detecting system mode (Gateway/Bridge/Converter/Repeater)-start */
	/* Upgrade fail(Return to detail page) */
	{
		int opmode=0;//WNC-NMR0000-Rita-20130310-Error_594-fix warnings of cppcheck (uninitialized value).

		apmib_get( MIB_OP_MODE, (void *)&opmode);

		if (opmode == GATEWAY_MODE) {
			FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail.htm");
		} else if (opmode == BRIDGE_MODE) {
			/* WNC-NMR0000-JOE-PENG-20140430-Modify 4.1 structure of page according to Linear Spec-start */
			//FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail_bridge.htm");
			int wifi_mode=WIFI_MODE_AP;
			
			if (lw_get_wifi_mode(&wifi_mode) == 1) {
				switch (wifi_mode) {
					case WIFI_MODE_AP:
						FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail_bridge.htm");
						break;
					case WIFI_MODE_CLIENT:
						FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail_converter.htm");
						break;
					case WIFI_MODE_REPEATER:
						FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail_repeater.htm");
						break;
					default:
						FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail_bridge.htm");
						break;
				}	
			} else {
				FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "home_detail_bridge.htm");
			}
			/* WNC-NMR0000-JOE-PENG-20140430-Modify 4.1 structure of page according to Linear Spec-end */
		} else {
			FAIL_MSG_NEC(tmpBuf2,tmpBuf3,lan_ip2, "index.htm");
		}
	}
	/* WNC-NMR0000-JOE-PENG-20140521-Modify codes of boa detecting system mode (Gateway/Bridge/Converter/Repeater)-end */
	/* WNC-MR0000-JOE-PENG-20120522-end */
	// WNC-MR0000-Yuan-I-Chou-20120515-firmware upgrade LED
//WNC-D2R230-YUAN-I-CHOU-20171003, Firmware upgrade modification.
//Power red LED is not ON yet, turn OFF is not necessary.
	//lw_ledctl(PWR_RED, 0, LED_FOREVER, 1, 0, LED_FOREVER);
	system("echo RLOS > /proc/ledgpio");
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131218, Modify LED control API End
	return;
ErrPopup_Upload:
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, Add Shared memory protection
#if defined(CONFIG_APP_FWD)
	shm_unlock();
	clear_shm();
	wp->upload_data = NULL;
#endif
//WNC-JDR230-NMR0211-HENG-I-CHEN-20121107, End
	Reboot_Wait=0;
	POP_ERR_MSG(tmpBuf);
	// WNC-MR0000-Yuan-I-Chou-20120515-firmware upgrade LED
//WNC-D2R230-YUAN-I-CHOU-20171003, Firmware upgrade modification.
//Power red LED is not ON yet, turn OFF is not necessary.
	//lw_ledctl(PWR_RED, 0, LED_FOREVER, 1, 0, LED_FOREVER);
	system("echo RLOS > /proc/ledgpio");
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20131218, Modify LED control API End
	return;
	/* WNC-MR0000-JOE-PENG-20120330-end */


}



/////////////////////////////////////////////////////////////////////////////
void formPasswordSetup(request *wp, char *path, char *query)
{
// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 868 UNUSED_VALUE
//	char *submitUrl, *strUser, *strPassword;
	char *strUser, *strPassword;
// WNC-NMR0000-Heng-I-Chen-20130814: End
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch
	//	char tmpBuf[100];
		char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch End
#ifdef SUPER_NAME_SUPPORT
	char *superName = NULL;
	char *superPassword = NULL;
	
	if(wp->auth_flag == SUPER_FLAG || wp->auth_flag == NO_LOGIN) 
	{
		//check superName and newSuperPass valid
		superName=req_get_cstream_var(wp, "superName", "");
		superPassword=req_get_cstream_var(wp, "newSuperPass", "");

		if(!superName[0]){
			strlcpy(tmpBuf, ("ERROR:superName cannot be empty."), sizeof(tmpBuf));
			goto setErr_pass;
		}
	
		if(superName[0] && !superPassword[0]){
			strlcpy(tmpBuf, ("ERROR:superPassword cannot be empty."), sizeof(tmpBuf));
			goto setErr_pass;
		}
	}
#endif

	//check userName and newPass valid
#if 1
//	strUser = req_get_cstream_var(wp, "username", "");
	strUser = "admin";
	strPassword = req_get_cstream_var(wp, "NEW_PASSWD", "");
#else	//original
	strUser = req_get_cstream_var(wp, "userName", "");
	strPassword = req_get_cstream_var(wp, "newPass", "");
#endif
	//if(!strUser[0])
	//{
	//	strlcpy(tmpBuf, ("ERROR: userName cannot be empty."), sizeof(tmpBuf));
	//	goto setErr_pass;
	//}
	if ( !strUser[0] && strPassword[0] )
	{
		strlcpy(tmpBuf, ("ERROR: userName is empty,Password should be empty."), sizeof(tmpBuf));
		goto setErr_pass;
	}
	if ( strUser[0] && !strPassword[0] ) {
		strlcpy(tmpBuf, ("ERROR: Password cannot be empty."), sizeof(tmpBuf));
		goto setErr_pass;
	}


// WNC-MRXXXX-Yuan-I-Chou-20120524- Remove Super user
#if 0
#ifdef SUPER_NAME_SUPPORT
	if(wp->auth_flag == SUPER_FLAG || wp->auth_flag == NO_LOGIN) 
	{
		//set MIB_SUPER_NAME and MIB_SUPER_PASSWORD 
		if ( !apmib_set(MIB_SUPER_NAME, (void *)superName) ) {
			strlcpy(tmpBuf, ("ERROR: Set superName to MIB database failed."), sizeof(tmpBuf));
			goto setErr_pass;
		}
		if ( !apmib_set(MIB_SUPER_PASSWORD, (void *)superPassword) ) {
			strlcpy(tmpBuf, ("ERROR: Set superPassword to MIB database failed."), sizeof(tmpBuf));
			goto setErr_pass;
		}	

		// Check if userName is the same as superName 
		if ( !apmib_get(MIB_SUPER_NAME, (void *)tmpBuf)) {
			strlcpy(tmpBuf, ("ERROR: Get supervisor name MIB error!"), sizeof(tmpBuf));
			goto setErr_pass;
		}
		if ( !strcmp(strUser, tmpBuf)) {
			strlcpy(tmpBuf, ("ERROR: Cannot use the same user name as supervisor."), sizeof(tmpBuf));
			goto setErr_pass;
		}

	}		
#endif	
#endif
// WNC-MRXXXX-Yuan-I-Chou-20120524- Remove Super user

	//set MIB_USER_NAME and MIB_USER_PASSWORD 
	if ( !apmib_set(MIB_USER_NAME, (void *)strUser) ) {
		strlcpy(tmpBuf, ("ERROR: Set userName to MIB database failed."), sizeof(tmpBuf));
	//	fprintf(stderr, "###%s:%d  Set userName to MIB database failed.###\n", __FILE__, __LINE__);
		goto setErr_pass;
	}
	if ( !apmib_set(MIB_USER_PASSWORD, (void *)strPassword) ) {
		//strlcpy(tmpBuf, ("ERROR: Set user password to MIB database failed."), sizeof(tmpBuf));
		strlcpy(tmpBuf, ("̵ʥѥɤǤȾѱѿ,-,_Ѥ64ϤƤ"), sizeof(tmpBuf));
		goto setErr_pass;
	}

	/* Retrieve next page URL */
	apmib_update_web(CURRENT_SETTING);

// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 868 UNUSED_VALUE
//	submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page
// WNC-NMR0000-Heng-I-Chen-20130814: End

// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 868 UNUSED_VALUE
//#ifdef LOGIN_URL
//	if (strUser[0])
//		submitUrl = "/login.htm";
//#endif
// WNC-NMR0000-Heng-I-Chen-20130814: End

#ifdef REBOOT_CHECK
	/* Case of define REBOOT_CHECK */
	{
/*WNC-MR0000-JOE-PENG-20120606-Modification for specification V1.8.0 section 6.10 Reboot Now */
#if 0
#if 1	/* WNC-MR0000-Libera-20120308- for NEC password countdown page */
#ifdef REBOOT_CHECK
		snprintf(lastUrl, sizeof(lastUrl),"%s","/status.htm");
		snprintf(okMsg, sizeof(okMsg),"%s",tmpBuf);
		countDownTime = APPLY_COUNTDOWN_TIME;
		send_redirect_perm(wp, PW_COUNTDOWN_PAGE);
#else
		OK_MSG_FW(tmpBuf, submitUrl,Reboot_Wait,lan_ip);
#endif
#endif	/* WNC-MR0000-Libera-20120308-END */
#endif
/*WNC-MR0000-JOE-PENG-20120606-end */
#if 0
		char tmpMsg[300];
		char lan_ip_buf[30], lan_ip[30];
#ifdef RTK_REINIT_SUPPORT
		char cmdBuf[64]={0};
#endif		
		snprintf(tmpMsg, sizeof(tmpMsg), "%s","Change setting successfully!<br><br>Do not turn off or reboot the Router during this time.");
		apmib_get( MIB_IP_ADDR,  (void *)lan_ip_buf) ;
		snprintf(lan_ip, sizeof(lan_ip),"%s",inet_ntoa(*((struct in_addr *)lan_ip_buf)) );
#ifdef RTK_REINIT_SUPPORT
		snprintf(cmdBuf, sizeof(cmdBuf),"reinitCli -e %d",REINIT_EVENT_APPLYCAHNGES);
		system(cmdBuf);
#endif
		OK_MSG_FW(tmpMsg, submitUrl,APPLY_COUNTDOWN_TIME,lan_ip);
#endif
/*WNC-MR0000-JOE-PENG-20120606-Modification for specification V1.8.0 section 6.10 Reboot Now */
#if 1
		formReboot(wp, path, query);
#else
#ifdef REBOOT_CHECK
		run_init_script_flag = 1;
#endif		
#ifndef NO_ACTION
		run_init_script("all");
#endif	
#endif
/*WNC-MR0000-JOE-PENG-20120606-end */
	}
#else
	/* Case of not define REBOOT_CHECK */
	OK_MSG(submitUrl);
#endif
	return;

setErr_pass:
	ERR_MSG(tmpBuf);
}

void formPasswordCheck(request *wp, char *path, char *query)
{
	extern void log_boaform(char *form, request *req);

	char *inputPass;
	
	char password[PASSWORD_SIZE] = "";
//	char tmpbuf[256] = "";
	
	inputPass = req_get_cstream_var(wp, "pass", "");

	apmib_get(MIB_USER_PASSWORD, (void *)password);
	
//	console_printf("%s %d old : %s check %s", __func__, __LINE__, password, inputPass);
//	snprintf(tmpbuf, sizeof(tmpbuf), "%s", strncmp(password, inputPass, 33)?"false":"true");
//	console_printf(" %s\n", tmpbuf);

	log_boaform("formPasswordCheck", wp);

	return req_format_write(wp, "%s", strncmp(password, inputPass, PASSWORD_SIZE)?"false":"true");
}

void formMacFilterCheck(request *wp, char *path, char *query)
{
	extern void log_boaform(char *form, request *req);

	char *macStr = NULL;
	int i=0, entryNum = 0;

	/* WNC-MR2493-MIKE-YEH-20170713-[Rafale] Same MAC address can entry to the MAC filtering list (ACL). */
	int macAddrTmp[6] = {0};
	char macAddr[6] = {0};

	macStr = req_get_cstream_var(wp, "mac", "");

	/* WNC-MR2493-MIKE-YEH-20170713-[Rafale] Same MAC address can entry to the MAC filtering list (ACL). */
	if (sscanf(macStr, "%02x:%02x:%02x:%02x:%02x:%02x", &macAddrTmp[0], &macAddrTmp[1], &macAddrTmp[2], &macAddrTmp[3], &macAddrTmp[4], &macAddrTmp[5]) != 6) {
		return -1;
	}


	/* WNC-MR2493-MIKE-YEH-20170713-[Rafale] Same MAC address can entry to the MAC filtering list (ACL). */
	for(i=0;i<6;i++)
		macAddr[i] = (char)macAddrTmp[i];

	if ( !apmib_get(MIB_WLAN_MACAC_NUM, (void *)&entryNum)) {
		req_format_write(wp,"WLAN_MAC_ERROR");
		return 0;
	}

	for (i=entryNum; i>0; i--) {
		MACFILTER_T macEntry_temp;

		*((char *)&macEntry_temp) = (char)i;
		apmib_get(MIB_WLAN_MACAC_ADDR, (void *)&macEntry_temp);

		if (!memcmp(macAddr, macEntry_temp.macAddr, 6)) {
			log_boaform("formMacFilterCheck", wp);
			return req_format_write(wp, "duplicated");
		}
	}
	if (entryNum >= 60) {
		log_boaform("formMacFilterCheck", wp);
		return req_format_write(wp, "full");
	}

	log_boaform("formMacFilterCheck", wp);
	return req_format_write(wp, "");
}

/* NMR2501-20170711-MIKE-YEH-[Aero] The ACT-028LPB-03 is not correct timing to judge. */
void formWanStatusCheck(request *wp, char *path, char *query)
{
	extern void log_boaform(char *form, request *req);
	
	bss_info bss;
	int i, wan_link, old_vwlan_idx, repeater_mode;
	
	if(isFileExist("/var/aterm_server.conf") != 1) {
		log_boaform("formWanStatusCheck", wp);
		return req_format_write(wp, "false");		
	}

	/* repeater mode */
	for(i=0;i<2;i++) {
		
		old_vwlan_idx = vwlan_idx;
		vwlan_idx = NUM_VWLAN_INTERFACE;
		
		if(i==0)
			getWlBssInfo("wlan0-vxd", &bss);
		else
			getWlBssInfo("wlan1-vxd", &bss);
			
		vwlan_idx = old_vwlan_idx;
			
		if(bss.state == STATE_CONNECTED) {
			log_boaform("formWanStatusCheck", wp);
			return req_format_write(wp, "true");
		}
	}

	/* router mode */
	wan_link = getWanLink("eth1");
	if (wan_link < 0) {
		log_boaform("formWanStatusCheck", wp);
		return req_format_write(wp, "false");
	}

	if ( !apmib_get( MIB_REPEATER_ENABLED1, (void *)&repeater_mode) )
		return;

	if(repeater_mode != 1) {
		log_boaform("formWanStatusCheck", wp);
		return req_format_write(wp, "true");
	}

	log_boaform("formWanStatusCheck", wp);
	return req_format_write(wp, "false");
}

/* NMR1833-20161003-Fix bug 1833 [Aero] It will indicate the extra dialog (e.g. DLG-022LaPaBa-11) on the PC to use ether cable-start */
void formWirelessClientCheck(request *wp, char *path, char *query)
{
	int is_wireless_client=0;

	extern void log_boaform(char *form, request *req);

	is_wireless_client=is_wireless_station(wp);

	/* NMR2067-20161118-Fix bug 2067 [Aero] It can not turn [ON] the MAC filtering setting during the entry max-start */
	/* Set is wireless client to 0 if wireless client has registered in MAC filter table */
	if (is_wireless_client==1) {
		if (is_register_mac_filter(wp)==1) {
			is_wireless_client=0;
		}
	}
	/* NMR2067-20161118-Fix bug 2067 [Aero] It can not turn [ON] the MAC filtering setting during the entry max-end */

	log_boaform("formWirelessClientCheck", wp);

	return req_format_write(wp, "%s", (is_wireless_client==0)?"false":"true");
}
/* NMR1833-20161003-Fix bug 1833 [Aero] It will indicate the extra dialog (e.g. DLG-022LaPaBa-11) on the PC to use ether cable-end */

////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
void formStats(request *wp, char *path, char *query)
{
	char *submitUrl;

	submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page

	if (submitUrl[0])
		send_redirect_perm(wp, submitUrl);
}

#ifdef CONFIG_RTK_MESH
void formMeshStatus(request *wp, char *path, char *query)
{
	char *submitUrl;

	submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page

	if (submitUrl[0])
		send_redirect_perm(wp, submitUrl);
}
#endif // CONFIG_RTK_MESH
 
/////////////////////////////////////////////////////////////////////////////
int  ntpHandler(request *wp, char *tmpBuf, int fromWizard)
{
	int enabled=0, ntpServerIdx ;
	struct in_addr ipAddr ;
	char *tmpStr ;
//Brad add for daylight save	
	int dlenabled=0;
//Brad add end	
	if (fromWizard) {
		tmpStr = req_get_cstream_var(wp, ("enabled"), "");  
		if(!strcmp(tmpStr, "ON"))
			enabled = 1 ;
		else 
			enabled = 0 ;

		if ( apmib_set( MIB_NTP_ENABLED, (void *)&enabled) == 0) {
			strcpy(tmpBuf, ("Set enabled flag error!"));
			goto setErr_ntp;
		}
//Brad add for daylight save		
		tmpStr = req_get_cstream_var(wp, ("dlenabled"), "");  
		if(!strcmp(tmpStr, "ON"))
			dlenabled = 1 ;
		else 
			dlenabled = 0 ;

		if ( apmib_set( MIB_DAYLIGHT_SAVE, (void *)&dlenabled) == 0) {
			strcpy(tmpBuf, ("Set enabled flag error!"));
			goto setErr_ntp;
		}
//Brad add end		
	}	
	else
		enabled = 1;
	if(enabled){
		tmpStr = req_get_cstream_var(wp, ("ntpServerId"), "");  
		if(tmpStr[0]){
			ntpServerIdx = tmpStr[0] - '0' ;
			if ( apmib_set(MIB_NTP_SERVER_ID, (void *)&ntpServerIdx) == 0) {
				strcpy(tmpBuf, ("Set Time Zone error!"));
				goto setErr_ntp;
			}
		}
		tmpStr = req_get_cstream_var(wp, ("timeZone"), "");  
		if(tmpStr[0]){
			if ( apmib_set(MIB_NTP_TIMEZONE, (void *)tmpStr) == 0) {
					strcpy(tmpBuf, ("Set Time Zone error!"));
				goto setErr_ntp;
		}
		}

		tmpStr = req_get_cstream_var(wp, ("ntpServerIp1"), "");  
		if(tmpStr[0]){
			inet_aton(tmpStr, &ipAddr);
			if ( apmib_set(MIB_NTP_SERVER_IP1, (void *)&ipAddr) == 0) {
				strcpy(tmpBuf, ("Set NTP server error!"));
				goto setErr_ntp;
			} 
			}
		tmpStr = req_get_cstream_var(wp, ("ntpServerIp2"), "");  
		if(tmpStr[0]){
			inet_aton(tmpStr, &ipAddr);
			if ( apmib_set(MIB_NTP_SERVER_IP2,(void *) &ipAddr ) == 0) {
				strcpy(tmpBuf, ("Set NTP server IP error!"));
				goto setErr_ntp;
			}
		}
	}
	return 0 ;	
setErr_ntp:
	return -1 ;
	
}
void formNtp(request *wp, char *path, char *query)
{
	char *submitUrl,*strVal, *tmpStr;
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch
	//	char tmpBuf[100];
		char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch End
	int enabled=0;
//Brad add for daylight save	
	int dlenabled=0;
//Brad add end	
#ifndef NO_ACTION
//	int pid;
#endif
	int time_value=0;
	int cur_year=0;
	
	submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page
	strVal = req_get_cstream_var(wp, ("save"), "");   
#if defined(APPLY_CHANGE_DIRECT_SUPPORT)
	if(strVal[0]==0){
		strVal = req_get_cstream_var(wp, ("save_apply"), "");
	}
#endif
	tmpStr = req_get_cstream_var(wp, ("timeZone"), "");  
	if(tmpStr[0]){
		if ( apmib_set(MIB_NTP_TIMEZONE, (void *)tmpStr) == 0) {
				strcpy(tmpBuf, ("Set Time Zone error!"));
			goto setErr_end;
		}
	}
//Brad add for daylight save		
	tmpStr = req_get_cstream_var(wp, ("dlenabled"), "");  
	if(!strcmp(tmpStr, "ON"))
		dlenabled = 1 ;
	else 
		dlenabled = 0 ;
	if ( apmib_set( MIB_DAYLIGHT_SAVE, (void *)&dlenabled) == 0) {
		strcpy(tmpBuf, ("Set dl enabled flag error!"));
		goto setErr_end;
	}
//Brad add end		
	set_timeZone();
	if(strVal[0]){		
		struct tm tm_time;
		time_t tm;
		memcpy(&tm_time, localtime(&tm), sizeof(tm_time));
		tm_time.tm_sec = 0;
		tm_time.tm_min = 0;
		tm_time.tm_hour = 0;
		tm_time.tm_isdst = -1;  /* Be sure to recheck dst. */
		strVal = req_get_cstream_var(wp, ("year"), "");	
		cur_year= atoi(strVal);
		tm_time.tm_year = atoi(strVal) - 1900;
		strVal = req_get_cstream_var(wp, ("month"), "");	
		tm_time.tm_mon = atoi(strVal)-1;
		strVal = req_get_cstream_var(wp, ("day"), "");	
		tm_time.tm_mday = atoi(strVal);
		strVal = req_get_cstream_var(wp, ("hour"), "");	
		tm_time.tm_hour = atoi(strVal);
		strVal = req_get_cstream_var(wp, ("minute"), "");	
		tm_time.tm_min = atoi(strVal);
		strVal = req_get_cstream_var(wp, ("second"), "");	
		tm_time.tm_sec = atoi(strVal);
		tm = mktime(&tm_time);
		if(tm < 0){
			sprintf(tmpBuf, "set Time Error\n");
			goto setErr_end;
		}
		if(stime(&tm) < 0){
			sprintf(tmpBuf, "set Time Error\n");
			goto setErr_end;
		}

		apmib_set( MIB_SYSTIME_YEAR, (void *)&cur_year);
		time_value = tm_time.tm_mon;
		apmib_set( MIB_SYSTIME_MON, (void *)&time_value);
		time_value = tm_time.tm_mday;
		apmib_set( MIB_SYSTIME_DAY, (void *)&time_value);
		time_value = tm_time.tm_hour;
		apmib_set( MIB_SYSTIME_HOUR, (void *)&time_value);
		time_value = tm_time.tm_min;
		apmib_set( MIB_SYSTIME_MIN, (void *)&time_value);
		time_value = tm_time.tm_sec;
		apmib_set( MIB_SYSTIME_SEC, (void *)&time_value);
		
		

		tmpStr = req_get_cstream_var(wp, ("enabled"), "");  
		if(!strcmp(tmpStr, "ON"))
			enabled = 1 ;
		else 
			enabled = 0 ;
		if ( apmib_set( MIB_NTP_ENABLED, (void *)&enabled) == 0) {
			strcpy(tmpBuf, ("Set enabled flag error!"));
			goto setErr_end;
		}

	}
	if (enabled == 0)		
		goto  set_ntp_end;
	
	if(ntpHandler(wp, tmpBuf, 0) < 0)
		goto setErr_end ;

set_ntp_end:
	apmib_update_web(CURRENT_SETTING);
//Brad modify for system re-init method
#if 0
	pid = find_pid_by_name("ntp.sh");
	if(pid)
		kill(pid, SIGTERM);

	pid = fork();
        if (pid)
		waitpid(pid, NULL, 0);
        else if (pid == 0) {
		snprintf(tmpBuf, 100, "%s/%s", _CONFIG_SCRIPT_PATH, _NTP_SCRIPT_PROG);
		execl( tmpBuf, _NTP_SCRIPT_PROG, NULL);
               	exit(1);
       	}
#endif
#ifndef NO_ACTION
	run_init_script("all");
#endif
	OK_MSG(submitUrl);
	return;

setErr_end:
	ERR_MSG(tmpBuf);
}

/* WNC-MR0000-Rita-20121106-ntp update immediately and UI refresh at 5 seconds */
void formTimeUpdate(request *wp, char *path, char *query)
{
	char *submitUrl;

	system("ntpclient -s -c 3 -h ntp.jst.mfeed.ad.jp -i 1 &");

	int seconds = 5;
	while (seconds > 0)
	{
		seconds = sleep(seconds);
	}
	
	submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page

	if(submitUrl[0])
		send_redirect_perm(wp, submitUrl);
  	return;
}

extern int set_unspecified_connection_time();

/* WNC-NMR0000-JOE-PENG-20131218-Implement section 5.23.3.1.3 (Set device time automatically by Web server)-start */
void formSetDeviceTime(request *wp, char *path, char *query)
{
	char *submitUrl, *strVal;
	int year=0, month=0, day=0, hour=0, minute=0, second=0;

	/* Get client time */
	strVal = req_get_cstream_var(wp, ("clienttime_year"), "");
	if (strVal[0]) {
		year = atoi(strVal);
	}

	strVal = req_get_cstream_var(wp, ("clienttime_month"), "");
	if (strVal[0]) {
		month = atoi(strVal);
	}

	strVal = req_get_cstream_var(wp, ("clienttime_day"), "");
	if (strVal[0]) {
		day = atoi(strVal);
	}

	strVal = req_get_cstream_var(wp, ("clienttime_hour"), "");
	if (strVal[0]) {
		hour = atoi(strVal);
	}

	strVal = req_get_cstream_var(wp, ("clienttime_minute"), "");
	if (strVal[0]) {
		minute = atoi(strVal);
	}

	strVal = req_get_cstream_var(wp, ("clienttime_second"), "");
	if (strVal[0]) {
		second = atoi(strVal);
	}

	/* Set device time */
	/* WNC-NMR0661-JOE-PENG-20140401-Fix bug 661 "[Voyager] AccessTimer continue to reload Page when PC set 00:00"-start */
	if ((year == 0) && (month == 0) 
		&& (day == 0) && (hour == 0) 
		&& (minute == 0) && (second == 0)) {
		/* Do not set device time if web server can not get time of client */
	} else {
		char cmdBuf[64];
		/* WNC-NMR2148-JOE-PENG-20161208-Fix bug 2148 [Aero] The DHCP lease time will be bigger after device time correction-start */
/* WNC-NMR2148-JOE-PENG-20161226-Fix issue in comment 11 of bug 2148 [Aero] The DHCP lease time will be bigger after device time correction-start */
#if 0
		unsigned long system_time_original=0;

		/* Get time before DUT set system time */
		{
			FILE *file_fp;
			
			file_fp=fopen("/var/dhcp_lease_has_updated","r");
			
			if(file_fp){
				/* Not need to update dhcp lease time because system time is set and dhcp lease time has updated */
				fclose(file_fp);
			} else {
				/* Need update DHCP lease time; Record old system time to /var/system_time_original before DUT set new device time */
				char temporary_buffer[100]={0};

				time(&system_time_original);

				if (system_time_original != 0) {
					snprintf(temporary_buffer, sizeof(temporary_buffer), "echo \"%ld\" > /var/system_time_original", system_time_original);
					system(temporary_buffer);
				}
			}
		}
#endif
/* WNC-NMR2148-JOE-PENG-20161226-Fix issue in comment 11 of bug 2148 [Aero] The DHCP lease time will be bigger after device time correction-end */
		/* WNC-NMR2148-JOE-PENG-20161208-Fix bug 2148 [Aero] The DHCP lease time will be bigger after device time correction-end */

		/*Format of date command: date MMDDhhmmYYYY.sec */
		snprintf(cmdBuf, sizeof(cmdBuf), "date %02d%02d%02d%02d%04d.%02d", month, day, hour, minute, year, second);
		system(cmdBuf);

		/* WNC-NMR2148-JOE-PENG-20161208-Fix bug 2148 [Aero] The DHCP lease time will be bigger after device time correction-start */
/* WNC-NMR2148-JOE-PENG-20161226-Fix issue in comment 11 of bug 2148 [Aero] The DHCP lease time will be bigger after device time correction-start */
#if 0
		{
			FILE *file_fp;
			
			file_fp=fopen("/var/dhcp_lease_has_updated","r");
			
			if(file_fp){
				/* Not need to update dhcp lease time because system time is set and dhcp lease time has updated */
				fclose(file_fp);
			} else {
				/* After DUT set new system time; Send signal USR1 to udhcpd (DHCP server) and make udhcpd update DHCP lease time */
				if (system_time_original != 0) {
					system("killall -SIGUSR1 udhcpd");
				}
			}
		}
#endif
/* WNC-NMR2148-JOE-PENG-20161226-Fix issue in comment 11 of bug 2148 [Aero] The DHCP lease time will be bigger after device time correction-end */
		/* WNC-NMR2148-JOE-PENG-20161208-Fix bug 2148 [Aero] The DHCP lease time will be bigger after device time correction-end */

		system("touch /var/device_time_is_set");

		set_unspecified_connection_time();
	}
	/* WNC-NMR0661-JOE-PENG-20140401-Fix bug 661 "[Voyager] AccessTimer continue to reload Page when PC set 00:00"-end */

	/* Return to original page */
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #BEGIN
//	submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page

//	if(submitUrl[0])
//		send_redirect_perm(wp, submitUrl);
	req_format_write(wp, ("<script>top.page_reload()</script>"));
// WNC-NMR00000-D2R031-HENG-I-CHEN-20160104: Add for Wi-Fi management #END
  	return;
}
/* WNC-NMR0000-JOE-PENG-20131218-Implement section 5.23.3.1.3 (Set device time automatically by Web server)-end */

/* NMR0000-20160204-Fix bug number 16 "The status of detail screen isn't kept after another screen is displayed" in Firmware NEC check 20160201.xlsx-start */
void formSetAdvancedMenu(request *wp, char *path, char *query)
{
	char *submitUrl;
	int advanced_menu_enable=0;

	/* Set new value of MIB_ADVANCED_MENU_ENABLE */
	apmib_get(MIB_ADVANCED_MENU_ENABLE, (void *)&advanced_menu_enable);
	
	if (advanced_menu_enable == 1) {
		advanced_menu_enable = 0;
	} else {
		advanced_menu_enable = 1;
	}
	
	apmib_set(MIB_ADVANCED_MENU_ENABLE, (void *)&advanced_menu_enable);

	/* NMR1426-20160307-Fix bug 1426 [Spider] The displayed-status "advanced menu" of home page is not saved after reboot-start */
	/* update configuration to flash */
	if (advanced_menu_enable == 1) {
		system("(flash set ADVANCED_MENU_ENABLE 1) &");
	} else {
		system("(flash set ADVANCED_MENU_ENABLE 0) &");
	}
	/* NMR1426-20160307-Fix bug 1426 [Spider] The displayed-status "advanced menu" of home page is not saved after reboot-end */

	/* Return to original page */
	submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page
	if(submitUrl[0]) {
		send_redirect_perm(wp, submitUrl);
	}
}
/* NMR0000-20160204-Fix bug number 16 "The status of detail screen isn't kept after another screen is displayed" in Firmware NEC check 20160201.xlsx-end */

/* WNC-NMR0000-JOE-PENG-20151125-Implement sensor related GUI page of spider model-start */
void formSensorNotifySetup(request *wp, char *path, char *query)
{
	char *submitUrl, *strVal;
	int sensor_sensitive=2;

	/* Set sensor notify sensitivity */
	strVal = req_get_cstream_var(wp, ("SENSOR_SENSITIVE"), "");
	if (strVal[0]) {
		if (!strcmp(strVal, "high")) {
			sensor_sensitive = 1;
		} else if (!strcmp(strVal, "normal")) {
			sensor_sensitive = 2;
		} else if (!strcmp(strVal, "low")) {
			sensor_sensitive = 3;
		}
		
		apmib_set(MIB_SENSOR_NOTIFY_SENSITIVITY, (void *)&sensor_sensitive);
	}

	apmib_update_web(CURRENT_SETTING);	// update configuration to flash

	/* Return to original page */
	submitUrl = req_get_cstream_var(wp, "submit-url", "");

	OK_MSG(submitUrl);

	return;
}

void formSensorLightSetup(request *wp, char *path, char *query)
{
	char *submitUrl, *strVal;
	int intVal=0;

	/* Set sensor light enable */
	strVal = req_get_cstream_var(wp, ("sensor_light_enable"), "");
	if (strVal[0]) {
		if (!strcmp(strVal, "1")) {
			intVal = 1;
		} else if (!strcmp(strVal, "0")) {
			intVal = 0;
		}
		
		apmib_set(MIB_SENSOR_LIGHT_ENABLE , (void *)&intVal);
	}

	/* Set sensor light color */
	strVal = req_get_cstream_var(wp, ("SENSOR_LIGHT_COLOR"), "");
	if (strVal[0]) {
		if (!strcmp(strVal, "incandescent")) {
			intVal = 1;
		} else if (!strcmp(strVal, "white")) {
			intVal = 2;
		}
		
		apmib_set(MIB_SENSOR_LIGHT_COLOR , (void *)&intVal);
	}

	/* Set sensor light illuminance */
	strVal = req_get_cstream_var(wp, ("SENSOR_LIGHT_ILLUMINANCE"), "");
	if (strVal[0]) {
		if (!strcmp(strVal, "normal")) {
			intVal = 1;
		} else if (!strcmp(strVal, "low")) {
			intVal = 2;
		}
		
		apmib_set(MIB_SENSOR_LIGHT_ILLUMINANCE , (void *)&intVal);
	}

	/* Set sensor light sensitivity */
	strVal = req_get_cstream_var(wp, ("SENSOR_LIGHT_SENSITIVE"), "");
	if (strVal[0]) {
		if (!strcmp(strVal, "high")) {
			intVal = 1;
		} else if (!strcmp(strVal, "normal")) {
			intVal = 2;
		} else if (!strcmp(strVal, "low")) {
			intVal = 3;
		}
		
		apmib_set(MIB_SENSOR_LIGHT_SENSITIVITY , (void *)&intVal);
	}

	/* Set sensor light start time hour */
	strVal = req_get_cstream_var(wp, ("SENSOR_LIGHT_START_TIME_HOUR"), "");
	if (strVal[0]) {
		intVal = atoi(strVal);

		apmib_set(MIB_SENSOR_LIGHT_START_TIME_HOUR , (void *)&intVal);
	}

	/* Set sensor light start time min */
	strVal = req_get_cstream_var(wp, ("SENSOR_LIGHT_START_TIME_MIN"), "");
	if (strVal[0]) {
		intVal = atoi(strVal);

		apmib_set(MIB_SENSOR_LIGHT_START_TIME_MIN , (void *)&intVal);
	}

	/* Set sensor light end time hour */
	strVal = req_get_cstream_var(wp, ("SENSOR_LIGHT_END_TIME_HOUR"), "");
	if (strVal[0]) {
		intVal = atoi(strVal);

		apmib_set(MIB_SENSOR_LIGHT_END_TIME_HOUR , (void *)&intVal);
	}

	/* Set sensor light end time min */
	strVal = req_get_cstream_var(wp, ("SENSOR_LIGHT_END_TIME_MIN"), "");
	if (strVal[0]) {
		intVal = atoi(strVal);

		apmib_set(MIB_SENSOR_LIGHT_END_TIME_MIN , (void *)&intVal);
	}

	apmib_update_web(CURRENT_SETTING);	// update configuration to flash

	/* Return to original page */
	submitUrl = req_get_cstream_var(wp, "submit-url", "");

	OK_MSG(submitUrl);

	return;
}

void formSensorClearLog(request *wp, char *path, char *query)
{
	char *submitUrl, *strVal;
	int sensor_sensitive=2;

	/* Clear sensor log */
	strVal = req_get_cstream_var(wp, ("clear_log"), "");
	if (strVal[0]) {
		if (!strcmp(strVal, "1")) {
			char cmdBuffer[128]={0};

			/* Clear sensor log */
			/* NMR0000-20160102-Fine tune some codes of sensor function */
			system("rm -f /var/sensor_log");

			/* Update time for recording sensor log after user clear the sensor log */
			snprintf(cmdBuffer, sizeof(cmdBuffer), "echo \"%s\" > /var/sensor_log_start_time", lw_get_system_time_for_sensor_log());
			system(cmdBuffer);
		}
	}

	/* Return to original page */
	submitUrl = req_get_cstream_var(wp, "submit-url", "");

	if(submitUrl[0])
		send_redirect_perm(wp, submitUrl);
	return;
}

/* NMR1563-20160330-Fix bug 1563 [Spider] The PageID 43 R/C:ItemID2/ItemID3 does not keep setting value-start */
void formSensorShowLog(request *wp, char *path, char *query)
{
	char *submitUrl, *strVal;

	/* Save status of show sensor light log */
	strVal = req_get_cstream_var(wp, ("show_sensor_light_log"), "");
	if (strVal[0]) {
		if (!strcmp(strVal, "1")) {
			show_sensor_light_log=1;
		} else {
			show_sensor_light_log=0;
		}
	}

	/* Save status of show sensor notify log */
	strVal = req_get_cstream_var(wp, ("show_sensor_notify_log"), "");
	if (strVal[0]) {
		if (!strcmp(strVal, "1")) {
			show_sensor_notify_log=1;
		} else {
			show_sensor_notify_log=0;
		}
	}

	/* Return to original page */
	submitUrl = req_get_cstream_var(wp, "submit-url", "");

	if(submitUrl[0])
		send_redirect_perm(wp, submitUrl);
	return;
}
/* NMR1563-20160330-Fix bug 1563 [Spider] The PageID 43 R/C:ItemID2/ItemID3 does not keep setting value-end */
/* WNC-NMR0000-JOE-PENG-20151125-Implement sensor related GUI page of spider model-end */

/* WNC-NMR822849-JOE-PENG-20141124-Create hidden page adv_settings.htm for NEC to enable or disable IGMP and MLD snooping-start */
void formAdvSettings(request *wp, char *path, char *query)
{
	char *submitUrl, *strVal;
	int intVal=0;

	/* Set IGMP Snooping setting */
	strVal = req_get_cstream_var(wp, ("IGMP_Snooping"), "");
	if (strVal[0]) {
		if (!strcmp(strVal, "ON")) {
			intVal = 0;
		} else {
			intVal = 1;
		}

		apmib_set(MIB_IGMP_SNOOP_DISABLED, (void *)&intVal);
	}

	/* Set MLD Snooping setting */
	strVal = req_get_cstream_var(wp, ("MLD_Snooping"), "");
	if (strVal[0]) {
		if (!strcmp(strVal, "ON")) {
			intVal = 0;
		} else {
			intVal = 1;
		}

		apmib_set(MIB_MLD_SNOOP_DISABLED, (void *)&intVal);
	}

	apmib_update_web(CURRENT_SETTING);	// update configuration to flash

	/* Return to original page */
	submitUrl = req_get_cstream_var(wp, "submit-url", "");

	OK_MSG(submitUrl);

  	return;
}

/* WNC-NMR822849-JOE-PENG-20141124-Create hidden page adv_settings.htm for NEC to enable or disable IGMP and MLD snooping-end */

void formPocketWizard(request *wp, char *path, char *query)
{
	char *tmpStr, *strVal;
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch
	//	char tmpBuf[100];
		char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch End
	char varName[20];
	int i=0;
	int mode=-1;
	int val;
	int wlBandMode = 0; //WNC-NMR0000-Rita-20130306-Error_488-fix warnings of cppcheck (uninitialized value).
	int band2G5GSelect=0;//WNC-NMR0000-Rita-20130310-Error_535-fix warnings of cppcheck (uninitialized value).
	int dns_changed=0;
    char ssidbuf[33];
#if defined(CONFIG_RTL_ULINKER)
	int ulinker_auto_changed;	
#endif

//displayPostDate(wp->post_data);

/*
	strVal = req_get_cstream_var(wp, "band0", "");
	val = strtol( strVal, (char **)NULL, 10);
	val = (val + 1);
	apmib_set( MIB_WLAN_BAND, (void *)&val);
*/
		
#if defined(CONFIG_RTL_ULINKER)
	tmpStr = req_get_cstream_var(wp, "otg_auto_val", "");
	if(tmpStr[0] != 0)
	{
		apmib_get(MIB_ULINKER_AUTO, (void *)&ulinker_auto_changed);
		val = atoi(tmpStr);
		apmib_set(MIB_ULINKER_AUTO, (void *)&val);

		if (ulinker_auto_changed != val)
			ulinker_auto_changed = 1;
		else
			ulinker_auto_changed = 0;	
	}
#endif
	
#ifdef HOME_GATEWAY
	if(tcpipWanHandler(wp, tmpBuf, &dns_changed) < 0){
		goto setErr_end;	
	}
#endif
		
#if defined(CONFIG_RTL_92D_SUPPORT)		
	tmpStr = req_get_cstream_var(wp, "wlBandMode", "");
	if(tmpStr[0] != 0)
	{
		wlBandMode = atoi(tmpStr);
		apmib_set(MIB_WLAN_BAND2G5G_SELECT, (void *)&wlBandMode);
	}
	
	apmib_get(MIB_WLAN_BAND2G5G_SELECT, (void *)&wlBandMode);
	if(wlBandMode == BANDMODEBOTH)
	{					
		unsigned char wlanIfStr[10];				
		
		for(i=0 ; i<NUM_WLAN_INTERFACE ; i++)
		{
			unsigned char wlanif[10];
			memset(wlanif,0x00,sizeof(wlanif));
			sprintf(wlanif, "wlan%d",i);
			if(SetWlan_idx(wlanif))
			{
				int intVal;	
#if defined(CONFIG_RTL_92D_SUPPORT) && defined(CONFIG_RTL_92D_DMDP) && !defined(CONFIG_RTL_DUAL_PCIESLOT_BIWLAN_D)
				intVal = DMACDPHY;
#else
				intVal = SMACSPHY;
#endif
				apmib_set(MIB_WLAN_MAC_PHY_MODE, (void *)&intVal);
				intVal = 0;
				apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&intVal);
			}						
		}
	
		/* 92d rule, 5g must up in wlan0 */
		/* phybandcheck */
		if(whichWlanIfIs(PHYBAND_5G) != 0)
		{
			swapWlanMibSetting(0,1);			
		}
		
		
	}
	else if(wlBandMode == BANDMODESINGLE)
	{
		unsigned int wlanif;
		
		for(i=0 ; i<NUM_WLAN_INTERFACE ; i++)
		{
			unsigned char wlanif[10];
			memset(wlanif,0x00,sizeof(wlanif));
			sprintf(wlanif, "wlan%d",i);
			if(SetWlan_idx(wlanif))
			{
				int intVal;
				intVal = SMACSPHY;
				apmib_set(MIB_WLAN_MAC_PHY_MODE, (void *)&intVal);
				intVal = 1;
				apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&intVal);
			}						
		}
		
		tmpStr = req_get_cstream_var(wp, "Band2G5GSupport", ""); //wlan0 PHYBAND_TYPE
		if(tmpStr[0] != 0)
		{
			band2G5GSelect = atoi(tmpStr);			
		}
		
		wlanif = whichWlanIfIs(band2G5GSelect);
		
		/* 92d rule, 5g must up in wlan0 */
		/* phybandcheck */
		if(wlanif != 0)
		{
			swapWlanMibSetting(0,1);			
		}
		
		wlan_idx = 0 ;		
		
		val = 0;
		apmib_set( MIB_WLAN_WLAN_DISABLED, (void *)&val); // enable wlan0 and disable wlan1
		
		
	}
#endif //#if defined(CONFIG_RTL_92D_SUPPORT)
				
	wlan_idx = 0 ;
	tmpStr = req_get_cstream_var(wp, "pocket_ssid", "");	
            //strSSID is BSSID, below transfer it to SSID. This fix the issue of AP ssid contains "
           
       
	if(tmpStr[0] != 0){
		if( bssid_to_ssid(tmpStr,ssidbuf) < 0)
			apmib_set(MIB_WLAN_SSID, (void *)tmpStr);
		else
			apmib_set(MIB_WLAN_SSID, (void *)ssidbuf);
	}
		
	for(i = 0 ; i<NUM_WLAN_INTERFACE ; i++)
	{
		wlan_idx = i;
		vwlan_idx = 0;
		
		if(i == 1)
		{
			if(wlBandMode != BANDMODEBOTH) // single band, no need process wlan1
				continue;
				
			tmpStr = req_get_cstream_var(wp, "pocket_ssid1", "");
			if(tmpStr[0] != 0){
				if( bssid_to_ssid(tmpStr,ssidbuf) < 0)
					apmib_set(MIB_WLAN_SSID, (void *)tmpStr);
				else
					apmib_set(MIB_WLAN_SSID, (void *)ssidbuf);
			}
		}
		sprintf(varName, "mode%d", i);
		tmpStr = req_get_cstream_var(wp, varName, "");
		if(tmpStr[0])
		{
			val = atoi(tmpStr);
			apmib_set( MIB_WLAN_MODE, (void *)&val);
		}
		
		
		
		sprintf(varName, "method%d", i);
		tmpStr = req_get_cstream_var(wp, varName, "");
		if(tmpStr[0])
		{
			val = atoi(tmpStr);
			if(val == ENCRYPT_DISABLED)
			{
				ENCRYPT_T encrypt = ENCRYPT_DISABLED;
				apmib_set( MIB_WLAN_ENCRYPT, (void *)&encrypt);
			}
			else if(val == ENCRYPT_WEP)
			{
				if(wepHandler(wp, tmpBuf, i) < 0)
				{
					goto setErr_end;
				}
			}
			else if(val > ENCRYPT_WEP && val <= WSC_AUTH_WPA2PSKMIXED)
			{
				if(wpaHandler(wp, tmpBuf, i) < 0)
				{
					goto setErr_end;
				}
			}
		}

#if defined(WLAN_PROFILE)
		if(addWlProfileHandler(wp, tmpBuf, i) < 0){
			//submitUrl = req_get_cstream_var(wp, ("submit-url-wlan2"), "");   // hidden page
			//goto setErr_end;
		}
		
#endif //#if defined(WLAN_PROFILE)


	}
	
	
#if defined(CONFIG_RTL_ULINKER) //repeater mode: clone wlan setting to wlan-vxd and modify wlan ssid
		int wlan_mode;
		int rptEnabled;
		int wlanvxd_mode;
		

		if(wlan_idx == 0)
			apmib_get(MIB_REPEATER_ENABLED1, (void *)&rptEnabled);
		else
			apmib_get(MIB_REPEATER_ENABLED2, (void *)&rptEnabled);



		apmib_get(MIB_WLAN_MODE, (void *)&wlan_mode);
		
		if(wlan_mode != CLIENT_MODE && wlan_mode != WDS_MODE && rptEnabled == 1)
		{
			int isUpnpEnabled=0;
			int ori_vwlan_idx = vwlan_idx;
			char ssidBuf[64];
			
			
			vwlan_idx = NUM_VWLAN_INTERFACE;
			
			
			/* get original setting in vxd interface */
			apmib_get(MIB_WLAN_WSC_UPNP_ENABLED, (void *)&isUpnpEnabled);
			apmib_get(MIB_WLAN_MODE, (void *)&wlanvxd_mode);
			
			if(!ulinker_auto_changed)						
			ulinker_wlan_mib_copy(&pMib->wlan[wlan_idx][NUM_VWLAN_INTERFACE], &pMib->wlan[wlan_idx][0]);
			
			/* restore original setting in vxd interface and repeater ssid*/			
			apmib_set(MIB_WLAN_WSC_UPNP_ENABLED, (void *)&isUpnpEnabled);
			apmib_set(MIB_WLAN_MODE, (void *)&wlanvxd_mode);
			
			vwlan_idx = ori_vwlan_idx;
			
			/* add "-ext" at last of wlan ssid */
			apmib_get( MIB_WLAN_SSID,  (void *)ssidBuf);

			if(!ulinker_auto_changed)
			{
			if(wlan_idx == 0)
				apmib_set(MIB_REPEATER_SSID1, (void *)&ssidBuf);
			else
				apmib_set(MIB_REPEATER_SSID2, (void *)&ssidBuf);

			
				if(strlen(ssidBuf)<sizeof(ssidBuf)+4&&!ulinker_auto_changed)
			{
				strcat(ssidBuf,"-ext");
				apmib_set( MIB_WLAN_SSID,  (void *)ssidBuf);
				apmib_set( MIB_WLAN_WSC_SSID, (void *)ssidBuf);
				}
			}
		}
#endif	
	
	
	apmib_update_web(CURRENT_SETTING);

#if defined(CONFIG_RTL_ULINKER)
	if (ulinker_auto_changed == 1) {
		char *submitUrl;
		needReboot = 1;
		submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page
		sprintf(lastUrl,"%s",submitUrl);
		send_redirect_perm(wp, "/reload.htm");
		return ;
	}
#endif


#ifdef REBOOT_CHECK
	run_init_script_flag = 1;
#endif
#ifndef NO_ACTION
	run_init_script("all");
#endif
// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 867 UNUSED_VALUE
//	tmpStr = req_get_cstream_var(wp, ("method0"), "");
// WNC-NMR0000-Heng-I-Chen-20130814: End
	REBOOT_WAIT("/wizard.htm");
	
	return ;
setErr_end:
	
	OK_MSG1(tmpBuf,"/wizard.htm");
	return ;
}


#if defined(MIB_TLV)
extern int mib_search_by_id(const mib_table_entry_T *mib_tbl, unsigned short mib_id, unsigned char *pmib_num, const mib_table_entry_T **ppmib, unsigned int *offset);
extern mib_table_entry_T mib_root_table[];
#else
extern int update_linkchain(int fmt, void *Entry_old, void *Entry_new, int type_size);
#endif

/* WNC-NMR0000-Rita-20130122-V1.0.0_Sonic_SpecChangeRequest_3.4.5-Wlan Basic Setting */
void formWncWlanBasic(request *wp, char *path, char *query)
{
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch
	//	char tmpBuf[100];
		char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch End
	//char varName[20];
	char *submitUrl;

	char *strEnabled, *strValue,*strDisabled;
	//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130814, fix coverity error 790, 791
	int val, disabled0 = 0,disabled1 = 0;
	
	
	/* WNC-NMR000-[Aero/Thalys]-Libera-20160606- responsive GUI porting-start */
	int wlan_orig=0,intVal=0;
	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");
	if ((lw_is_rakuraku_running()==1) || (lw_is_wps_running()==1)) {
		/* If RakuRaku or WPS is running, do not exeute site survey and return directly. */
		/* Site survey page knows RakuRaku or WPS is running by ASP GET function and will pop up warning message. */
		if (submitUrl[0])
			send_redirect_perm(wp, "/cgi_html_903.html");
		return;
	}
	/* WNC-NMR000-[Aero/Thalys]-Libera-20160606- responsive GUI porting-end */

	strDisabled = req_get_cstream_var(wp, "wlanDisabled0", "");
	//if(*strDisabled){
	if (strDisabled[0]) {	/* WNC-NMR000-[Aero/Thalys]-Libera-20160606- responsive GUI porting*/
	wlan_idx = 0;
	if ( !strcmp(strDisabled, "ON"))
		disabled0 = 1;
	else
		disabled0 = 0;
	if ( apmib_set( MIB_WLAN_WLAN_DISABLED, (void *)&disabled0) == 0) {
  		strcpy(tmpBuf, ("Set disabled flag error!"));
		goto setErr_end;
		}
	}

	strDisabled = req_get_cstream_var(wp, "wlanDisabled1", "");
//	if(*strDisabled){
	if (strDisabled[0]) {	/* WNC-NMR000-[Aero/Thalys]-Libera-20160606- responsive GUI porting*/
		if(NUM_WLAN_INTERFACE > 1) //Rita++-It's dangerous to reset wlan_idx=1 but the NUM_WLAN_INTERFACE=1
			wlan_idx = 1;
		
	if ( !strcmp(strDisabled, "ON"))
		disabled1 = 1;
	else
		disabled1 = 0;
	if ( apmib_set( MIB_WLAN_WLAN_DISABLED, (void *)&disabled1) == 0) {
  		strcpy(tmpBuf, ("Set disabled flag error!"));
		goto setErr_end;
		}
	}

	if(!((disabled0 == 1) && (disabled1 == 1))){
		/* Band Select: 2.4GHz (0) or 5GHz (1) */
		strValue = req_get_cstream_var(wp, "air_", "");
		if (strValue[0]) {
			if (strValue[0] == '0')
				val = 0;
			else if (strValue[0] == '1')
				val = 1;	
			else {
				strcpy(tmpBuf, ("Error! Invalid Radio Value."));
				goto setErr_end;
			}
			if( apmib_set(MIB_WLAN_WSC_BAND_SEL, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set Band Select failed!"));
				goto setErr_end;
			}
		}

		//wps
		if(wlanWncBasicHandler(wp, tmpBuf) < 0){
			goto setErr_end;
		}
		/* WNC-NMR1796-[Aero]-20160921- [request] [Bandsteering]: wifi down -> bandsteer down -change source code location */
		/* WNC-NMR000-[Aero/Thalys]-Libera-20160606- responsive GUI porting: Band steering-start */
		/* Band Sterring: enable (1) or disable (0) */
		strValue = req_get_cstream_var(wp, "bandSteer", "");
		if (strValue[0]) {
			if (strValue[0] == '0'){
				val = 0;
			}else if (strValue[0] == '1'){

				if (NUM_WLAN_INTERFACE == 2){	/* WNC-NMR000-[Linear]-Libera-20140502- SPEC.v0.2.0- WPS: for Dual Radios  */
#if defined(FOR_DUAL_BAND)	
						intVal = 2; // deny : disable ERgeg config. /* WNC-NMR1775-[Aero/Thalys]-Libera-20160907- Bandsteering-disabled external registrar */
						wlan_orig = wlan_idx;
						SetWlan_idx("wlan0");
						apmib_set(MIB_WLAN_WSC_CFG_BY_EXREG_DISABLE, (void *)&intVal);/* WNC-NMR1775-[Aero/Thalys]-Libera-20160907- Bandsteering-disabled external registrar */
						SetWlan_idx("wlan1");
						apmib_set(MIB_WLAN_WSC_CFG_BY_EXREG_DISABLE, (void *)&intVal);/* WNC-NMR1775-[Aero/Thalys]-Libera-20160907- Bandsteering-disabled external registrar */
						wlan_idx = wlan_orig;
#endif
				/* WNC-NMR000-[Linear]-Libera-20140502- SPEC.v0.2.0- WPS: for Dual Radios -End*/
				}else{
						apmib_set(MIB_WLAN_WSC_CFG_BY_EXREG_DISABLE, (void *)&intVal);	/* WNC-NMR1775-[Aero/Thalys]-Libera-20160907- Bandsteering-disabled external registrar */
				}
				val = 1;	
			}else {
				strcpy(tmpBuf, ("Error! Invalid bandSteer Value."));
				goto setErr_end;
			}
			if( apmib_set(MIB_WLAN_BAND_STEER, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set Band Steering failed!"));
				goto setErr_end;
			}
			/* WNC-NMR000-[Aero]-Libera-20161006- Band steering: link to 11v mib -start */
			/* WNC-NMR1929-[Aero]-Libera-20161021- Band steering: link to 11v mib-sync. 2G5G MIB */
			apmib_save_wlanIdx();
			SetWlan_idx("wlan0");
			if( apmib_set(MIB_WLAN_DOT11V_ENABLE, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set 11v failed!"));
				goto setErr_end;
			}
			SetWlan_idx("wlan1");
			if( apmib_set(MIB_WLAN_DOT11V_ENABLE, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set 11v failed!"));
				goto setErr_end;
			}
			apmib_recov_wlanIdx();
			/* WNC-NMR1929-[Aero]-Libera-20161021- Band steering: link to 11v mib-sync. 2G5G MIB */
			/* WNC-NMR000-[Aero]-Libera-20161006- Band steering: link to 11v mib -end */
		}

		/* Band steering copy 5G profile to 2g: enable:1, recovery:2 default:0 */
		strValue = req_get_cstream_var(wp, "copy5gto2g", "");
		if (strValue[0]) {
			if (strValue[0] == '0'){
				val = 0;
				copy5gto2g(val);
			}else if (strValue[0] == '1'){
				val = 1;
				copy5gto2g(val);
			}else if (strValue[0] == '2'){
				val = 2;
				copy5gto2g(val);
			}else {
				strcpy(tmpBuf, ("Error! Invalid copy5gto2g Value."));
				goto setErr_end;
			}
			
			if( apmib_set(MIB_WLAN_COPY_5GTO2G, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set copy5gto2g failed!"));
				goto setErr_end;
			}

			strValue = req_get_cstream_var(wp, "realtimeSet", "");
			if (strValue[0]) {
#if 1	/* WNC-NMR000-[Aero/Thalys]-Libera-20160606- responsive GUI porting*/
				if (strValue[0] == '1'){	
					if (submitUrl[0]){
						send_redirect_perm(wp, submitUrl);
					}else{
						printf("error: submitUrl=NULL, Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
					}
					return;
				}
#endif
			}
		}

		/* WNC-NMR000-[Aero/Thalys]-Libera-20160606- responsive GUI porting: Band steering-end */
	}
	apmib_update_web(CURRENT_SETTING);

#ifndef NO_ACTION
	run_init_script("all");
#endif

#if 1 /* WNC-NMR1761-[Aero/Thalys]-MIKE-YEH-20160831-After push the "reboot later" in RT mode, the transition page is wrong. */
	submitUrl = req_get_cstream_var(wp, ("submit-url"), "");
	if (!submitUrl[0]) {
		submitUrl = req_get_cstream_var(wp, ("wlan-url"), "");	 // hidden page
	}
#else
	submitUrl = req_get_cstream_var(wp, ("wlan-url"), "");	 // hidden page
#endif

	OK_MSG(submitUrl);
	return ;
setErr_end:
fprintf(stderr, "###ERROR:=%s###\n", tmpBuf);
	ERR_MSG(tmpBuf);
	return ;

//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130814, fix coverity error 827
//PopupErr_WncWlan:
	//POP_ERR_MSG(tmpBuf);
	//return ;
//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20130814, fix coverity error 827 End

}

#if 1	/* WNC-NMR000-[Aero/Thalys]-Libera-20160823- Server side input check-start */
int serverSide_check_wifi_ap(request *wp)
{
	char *wepKey, *pskKey;
	char *strFormat,*strEncrypt;
	char *strDisabled1;
	int wepFormat, vnum, idx;
	ENCRYPT_T encrypt;
	char *strVal;
	char varName[20];
	
	//apmib_save_wlanIdx();
	strDisabled1 = req_get_cstream_var(wp, "wl_disable1", "");	//wlanx-va0
	/* WNC-NMR0000-JOE-PENG-20140728-Implemen section 4.4.6 2.4G setting and 4.4.7 5G setting of Linear step 2 (repeater mode)-start */
	int only_set_root_ap=0;

	if ((access("/tmp/MODE_RPT", F_OK) == 0) || (access("/tmp/MODE_CNV", F_OK) == 0)) {//repeater or converter mode
		only_set_root_ap=1;
	}
	/* WNC-NMR0000-JOE-PENG-20140728-Implemen section 4.4.6 2.4G setting and 4.4.7 5G setting of Linear step 2 (repeater mode)-end */
	
	if (only_set_root_ap==1) {
		vnum = 1; //only set root ap
	} else {
		if ( !strcmp(strDisabled1, "ON"))	//enabled
			vnum = 2;
		else
			vnum = 1;
	}
	
	for (idx=0;idx<vnum;idx++)
	{
		vwlan_idx = idx;

		sprintf(varName, "method%d%d", wlan_idx, vwlan_idx);
		strEncrypt = req_get_cstream_var(wp, varName, "");
		if (!strEncrypt[0]) {
			printf("[error]Error! no encryption method.: Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
		}
		encrypt = (ENCRYPT_T) strEncrypt[0] - '0';
		if (encrypt!=ENCRYPT_DISABLED && encrypt!=ENCRYPT_WEP && encrypt!=ENCRYPT_WPA
			&& encrypt != ENCRYPT_WPA2 && encrypt != ENCRYPT_WPA2_MIXED) 
		{
			printf("[error]Invalid encryption method! Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
		}
		else if(encrypt == ENCRYPT_WEP){	//select WEP option
			sprintf(varName, "format%d%d", wlan_idx,vwlan_idx);
			strFormat = req_get_cstream_var(wp, varName, "");
			if (!strFormat[0]) {
				printf("[error]Key type must exist!: Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
			}
			
			if (strFormat[0]!='1' && strFormat[0]!='2') {
				printf("[error]Invalid key type value!: Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
			}

			if (strFormat[0] == '1') // ascii
				wepFormat=1;
			else { // hex
				wepFormat=2;
			}
		
			sprintf(varName, "key%d%d", wlan_idx, vwlan_idx);
			wepKey = req_get_cstream_var(wp, varName, "");
			if (wepKey[0]) {
				if (lw_WEPCheck(wepKey,wepFormat)){
					//send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
					return -1;
				}
			}else{
				printf("[error]key=NULL, Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
				//send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
				return -1;
			}
		}
		else if (encrypt==ENCRYPT_WPA || encrypt == ENCRYPT_WPA2 || encrypt == ENCRYPT_WPA2_MIXED){ //WPA-PSK

			sprintf(varName, "wpaAuth%d%d", wlan_idx, vwlan_idx);
			strVal = req_get_cstream_var(wp, varName, "");
			if (strVal[0]) {
				if ( !strcmp(strVal, ("psk"))) {

					sprintf(varName, "pskValue%d%d", wlan_idx, vwlan_idx);
					pskKey = req_get_cstream_var(wp, varName, "");


					if (pskKey[0]) {
						printf("WNC:pskKey:%s Func: %s, Line: %d\n",pskKey,__FUNCTION__ , __LINE__);
						if (lw_PSKCheck(pskKey)){
							printf("[error][psk]: Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
							//send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
							return -1;
						}
					}else{
						printf("[error][psk]:NULL Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
						//send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
						return -1;
					}
				}else{
					printf("[error][psk] not psk type!: Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
					//send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
					return -1;
				}

			}
		}
		
	}
	//apmib_recov_wlanIdx();

	return 0;
}
#endif	/* WNC-NMR000-[Aero/Thalys]-Libera-20160823- Server side input check-end */


#if 1/* WNC-MR0000-Libera-20120308- wlan page with multi-form for Cheeper */
/* WNC-NMR0000-JOE-PENG-20130819-Fix bug that registered MAC filter address of secondary "MAC filter" setting does not show in MAC filter table page */
/* WNC-NMR0000-JOE-PENG-20131126-Recover Wi-Fi interface change */
void formWncWlan(request *wp, char *path, char *query)
{
	char *tmpStr;
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch
	//	char tmpBuf[100];
		char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch End
	char varName[20];
	int handler_return;/* WNC-MRXXXX-JOE-PENG-20120403-Modification for NEC GUI customization */
	int i;
	int showed_wlan_num;
	int wlBandMode;
#ifdef HOME_GATEWAY	
	int dns_changed=0;
#endif	
	int mode=-1;
	char *submitUrl;
	char buffer[200]={0}; //WNC-NMR0000-Rita-20130306-Error_472-fix warnings of cppcheck (uninitialized value).
	struct in_addr inLanaddr_orig, inLanaddr_new;
	struct in_addr inLanmask_orig, inLanmask_new;
	int	entryNum_resvdip;
	DHCPRSVDIP_T entry_resvdip, checkentry_resvdip;
	int link_type,idx, tmp_vwlan_idx, enabled;
	struct in_addr private_host, tmp_private_host, update;
	struct in_addr dhcpRangeStart, dhcpRangeEnd;
#ifdef MIB_TLV
	char pmib_num[10]={0};
	mib_table_entry_T *pmib_tl = NULL;
	unsigned int offset;
#endif
	/* WNC-NMR2393-MIKE-YEH-20170608-[Rafale]256QAM function can enable on Meteor. */
	unsigned char productName[32]={0};
	char *strEnabled, *strValue,*strDisabled;
	int val, disabled;
	int old,vnum, disabled1;
	char *strDisabled1;
	int rakuonly1;	/* WNC-MR000-[Linear]-Libera-20140520- Spec: Rakuraku only mode */
	/* NMR2089-[Aero]-20161123 - 2G sync. 5G -v2-start */
	int bandsteer=0;
	apmib_get(MIB_WLAN_BAND_STEER, (void *)&bandsteer);	
	/* NMR2089-[Aero]-20161123 - 2G sync. 5G -v2-end */

	/* WNC-NMR0000-JOE-PENG-20140728-Implemen section 4.4.6 2.4G setting and 4.4.7 5G setting of Linear step 2 (repeater mode)-start */
	int only_set_root_ap=0;

	if ((access("/tmp/MODE_RPT", F_OK) == 0) || (access("/tmp/MODE_CNV", F_OK) == 0)) {//repeater or converter mode
		only_set_root_ap=1;
	}
	/* WNC-NMR0000-JOE-PENG-20140728-Implemen section 4.4.6 2.4G setting and 4.4.7 5G setting of Linear step 2 (repeater mode)-end */

#if 1 /* WNC-NMR1758-[Aero]-MIKE-YEH-20160831-Delete the action when secondry wireless disabled. */
	{
		char *str2gDisabled1Flag, *str5gDisabled1Flag;
		int wls_sec_flag = 0, sec_disabled;
		
		strDisabled1 = req_get_cstream_var(wp, "wl_disable1", "");	//wlanx-va0
		submitUrl = req_get_cstream_var(wp, ("submit-url"), "");

		if (!strcmp(submitUrl, "../air24g_main_sec.html"))
		{
			wls_sec_flag = 1;
			SetWlan_idx("wlan0-va0");
		}
		else if (!strcmp(submitUrl, "../air5g_main_sec.html"))
		{	
			wls_sec_flag = 1;
			SetWlan_idx("wlan1-va0");
		}

		if ((wls_sec_flag) && (!strcmp(strDisabled1, "OFF")))
		{
			sec_disabled = 1;
			apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&sec_disabled);
			apmib_update_web(CURRENT_SETTING);

			OK_MSG(submitUrl);
			return;
		}
	}
#endif

	/* WNC-NMR1390-[Spider]-Libera-20160301- warning page for WPS running-v2-start */
	if ((lw_is_rakuraku_running()==1) || (lw_is_wps_running()==1)) {
		/* If RakuRaku or WPS is running, do not exeute site survey and return directly. */
		/* Site survey page knows RakuRaku or WPS is running by ASP GET function and will pop up warning message. */
	//	if (submitUrl[0]){
			//send_redirect_perm(wp, submitUrl);
			send_redirect_perm(wp, "/cgi_html_903.html");
	//		}
		return;
	}
	/* WNC-NMR1390-[Spider]-Libera-20160301- warning page for WPS running-v2-end */
#if 1	//indicate wifi interface /* WNC-NMR2594-Libera-20160801- wifi interface global index should be recovered */
	char *name;
	name = req_get_cstream_var(wp, "name", "");

	if(NUM_WLAN_INTERFACE == 2){
		if (name == NULL) {
			fprintf(stderr, "Insufficient args\n");
			return -1;
		}	
		// Dual radio 
		if(!strcmp(name, "wlan0"))
			sprintf(WLAN_IF, "wlan0");	
		else if(!strcmp(name, "wlan1")) 
			sprintf(WLAN_IF, "wlan1");
		else if(!strcmp(name, "wlan0-va0")) 
			sprintf(WLAN_IF, "wlan0-va0");
		else if(!strcmp(name, "wlan1-va0")) 
			sprintf(WLAN_IF, "wlan1-va0");
		SetWlan_idx(WLAN_IF);
	}
#endif
#if 1	/* WNC-NMR000-[Aero/Thalys]-Libera-20160823- Server side input check-start */
		apmib_save_wlanIdx();
		if(serverSide_check_wifi_ap(wp) < 0){
			send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
			apmib_recov_wlanIdx();
			return -1;
		}
		apmib_recov_wlanIdx();
#endif	/* WNC-NMR000-[Aero/Thalys]-Libera-20160823- Server side input check-end */


/* WNC-MR0000-Libera-20120522- if root AP is disabled, all wifi gray-out and keep original */
	//sprintf(varName, "wlanDisabled%d", wlan_idx);	//radio
	snprintf(varName, sizeof(varName), "wlanDisabled%d", wlan_idx);	//2426
	
	strDisabled = req_get_cstream_var(wp, varName, "");
	if ( !strcmp(strDisabled, "ON"))
		disabled = 1;
	else
		disabled = 0;
	if ( apmib_set( MIB_WLAN_WLAN_DISABLED, (void *)&disabled) == 0) {
  		strcpy(tmpBuf, ("Set disabled flag error!"));
		goto setErr_end;
	}

	if(!disabled){
		/* WNC-NMR0000-JOE-PENG-20130819-Fix bug that registered MAC filter address of secondary "MAC filter" setting does not show in MAC filter table page->start */
		char old_wlan_macac_enabled[MAX_USED_WIFI_VLAN_NUM]={0};
		int need_register_mac=0;
		/* WNC-NMR0000-JOE-PENG-20130819-Fix bug that registered MAC filter address of secondary "MAC filter" setting does not show in MAC filter table page->end */
		/* WNC-NMR0705-JOE-PENG-20140718-Fix bug 705 [Linear]MAC address is not registered automatically-start */
		int is_a4_sta=0;
		char a4_sta_owner_mac_str[20]={0};
		/* WNC-NMR0705-JOE-PENG-20140718-Fix bug 705 [Linear]MAC address is not registered automatically-end */

		apmib_get( MIB_IP_ADDR,  (void *)buffer); //save the orig lan subnet
		memcpy((void *)&inLanaddr_orig, buffer, 4);
	// set root ap wlan partition	- START
		strValue = req_get_cstream_var(wp, ("block_relay"), "");
		/* WNC-NMR0000-JOE-PENG-20131126-Recover Wi-Fi interface change-start */
		if (strValue[0]) {
			if (!strcmp(strValue, ("enable")))
				val = 1;
			else
				val = 0;
			apmib_set(MIB_WLAN_BLOCK_RELAY, (void *)&val);
			//WNC-MRXXXX-YUAN-I-CHOU-20120407, wlan partition
			apmib_set(MIB_WLAN_ACCESS, (void *)&val);
		}
		/* WNC-NMR0000-JOE-PENG-20131126-Recover Wi-Fi interface change-end */
	//root ap wlan partition	- END
		apmib_get( MIB_SUBNET_MASK,  (void *)buffer); //save the orig lan mask
		memcpy((void *)&inLanmask_orig, buffer, 4);

#if 1	/* WNC-CheeperSW:0548-Libera-20120622- ignore vap1 when vap1 disabled */
		strDisabled1 = req_get_cstream_var(wp, "wl_disable1", "");
//		strDisabled1 = req_get_cstream_var(wp, "wl_disable2", "");	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
		//fprintf(stderr, "###strDisabled1:=%s###\n", strDisabled1);

		/* WNC-NMR0000-JOE-PENG-20140728-Implemen section 4.4.6 2.4G setting and 4.4.7 5G setting of Linear step 2 (repeater mode)-start */
		if (only_set_root_ap==1) {
			vnum = 1; //only set root ap
		} else {
			old = vwlan_idx;
			vwlan_idx=1;
			if ( !strcmp(strDisabled1, "ON")){
				vnum = 2;
				//vnum = 3;	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
				disabled1=0;
				/* WNC-MR000-[Linear]-Libera-20140520- Spec: Rakuraku only mode -start */
				rakuonly1=0;	
				if ( apmib_set( MIB_WLAN_RAKURAKU_ONLY, (void *)&rakuonly1) == 0) {
		  			strcpy(tmpBuf, ("Set vap1 rakuraku_only flag error!"));
					goto setErr_end;
				}			
				/* WNC-MR000-[Linear]-Libera-20140520- Spec: Rakuraku only mode -end */
			}
			/* WNC-MR000-[Linear]-Libera-20140520- Spec: Rakuraku only mode -start */
			else if ( !strcmp(strDisabled1, "RAKUONLY")) {
				vnum = 1;	//only set root
				disabled1=0;
				rakuonly1=1;
				if ( apmib_set( MIB_WLAN_RAKURAKU_ONLY, (void *)&rakuonly1) == 0) {
		  			strcpy(tmpBuf, ("Set vap1 rakuraku_only flag error!"));
					goto setErr_end;
				}
			}
			/* WNC-MR000-[Linear]-Libera-20140520- Spec: Rakuraku only mode -end */
			else{
				vnum = 1;
				//vnum = 2;	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
				disabled1=1;
				/* WNC-MR000-[Linear]-Libera-20140520- Spec: Rakuraku only mode -start */
				rakuonly1=0;
				if ( apmib_set( MIB_WLAN_RAKURAKU_ONLY, (void *)&rakuonly1) == 0) {
		  			strcpy(tmpBuf, ("Set vap1 rakuraku_only flag error!"));
					goto setErr_end;
				}
				/* WNC-MR000-[Linear]-Libera-20140520- Spec: Rakuraku only mode -end */
			}

			//vwlan_idx=2;/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
			if ( apmib_set( MIB_WLAN_WLAN_DISABLED, (void *)&disabled1) == 0) {
		  		strcpy(tmpBuf, ("Set vap1 disabled flag error!"));
				goto setErr_end;
			}
			vwlan_idx=old;
		}
		/* WNC-NMR0000-JOE-PENG-20140728-Implemen section 4.4.6 2.4G setting and 4.4.7 5G setting of Linear step 2 (repeater mode)-end */

#endif	/* WNC-CheeperSW:0548-Libera-20120622- ignore vap1 when vap1 disabled - END */

		/* WNC-NMR0000-JOE-PENG-20130819-Fix bug that registered MAC filter address of secondary "MAC filter" setting does not show in MAC filter table page->start */
		/* Read old MAC filter enabled setting of each WIFI VLAN */		
		{
			int count=0, old_vwlan_idx=0;

			old_vwlan_idx = vwlan_idx;
			for (count=0;count<MAX_USED_WIFI_VLAN_NUM;count++) {
				int value=0;

				vwlan_idx= count;
				apmib_get( MIB_WLAN_MACAC_ENABLED, (void *)&value);
				old_wlan_macac_enabled[count] = value;
			}
			vwlan_idx=old_vwlan_idx;
		}
		/* WNC-NMR0000-JOE-PENG-20130819-Fix bug that registered MAC filter address of secondary "MAC filter" setting does not show in MAC filter table page->end */

		//for (idx=0;idx<2;idx++){
		for (idx=0;idx<vnum;idx++){	/* WNC-CheeperSW:0548-Libera-20120622- ignore vap1 when vap1 disabled */
			tmp_vwlan_idx = vwlan_idx;
			vwlan_idx = idx;

			if(wlanWncHandler(wp, tmpBuf,&mode, wlan_idx) < 0){
				//submitUrl = req_get_cstream_var(wp, ("submit-url-wlan1"), "");   // hidden page
				goto setErr_end;
			}
#if 0	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
			int temp_vwlan_idx=0;
			temp_vwlan_idx = vwlan_idx;
			if(vwlan_idx==1){
				temp_vwlan_idx=0;
			}
#endif
			//sprintf(varName, "method%d%d", wlan_idx,vwlan_idx);
			snprintf(varName, sizeof(varName), "method%d%d", wlan_idx,vwlan_idx); //2426
		//	sprintf(varName, "method%d%d", wlan_idx, temp_vwlan_idx);	/* WNC-MR000-Libera-20130703- Pocket spec.: change interface: wlan0->wlan0-va0, wlan0-va0->wlan0-va1 */
			tmpStr = req_get_cstream_var(wp, varName, "");
			if(tmpStr[0] && tmpStr[0] == '1'){	//select WEP option

	/* WNC-MRXXXX-JOE-PENG-20120403-Modification for NEC GUI customization */
#if 1
				if((handler_return = wepWncHandler(wp, tmpBuf, wlan_idx)) < 0){
					//	submitUrl = req_get_cstream_var(wp, ("submit-url-wlan2"), "");   // hidden page

					if (handler_return == -2) {
						goto PopupErr_WncWlan;
					}

					goto setErr_end;
				}
#else
				if(wepWncHandler(wp, tmpBuf, wlan_idx) < 0){
				//	submitUrl = req_get_cstream_var(wp, ("submit-url-wlan2"), "");   // hidden page
					goto setErr_end;
				}
#endif
	/* WNC-MRXXXX-JOE-PENG-20120403-end */
			}

			if(wpaWncHandler(wp, tmpBuf, wlan_idx) < 0){
		//	submitUrl = req_get_cstream_var(wp, ("submit-url-wlan2"), "");   // hidden page
			goto setErr_end;
			}
#if 1
			/* WNC-MR0000-JOE-PENG-20130715-Fix bug that "Changing MAC filter of first WIFI SSID to disable" does not take effect->start */
			//sprintf(varName, "wlanAcEnabled%d%d", wlan_idx,vwlan_idx);
			snprintf(varName, sizeof(varName), "wlanAcEnabled%d%d", wlan_idx,vwlan_idx); //2426

		//	sprintf(varName, "wlanAcEnabled%d%d", wlan_idx, temp_vwlan_idx);
			/* WNC-MR0000-JOE-PENG-20130715-Fix bug that "Changing MAC filter of first WIFI SSID to disable" does not take effect->end */
			strEnabled = req_get_cstream_var(wp, varName, "");
			//	if (strAddMac[0]) {
			/*if ( !strcmp(strEnabled, "ON"))
				enabled = 1;
			else
				enabled = 0; */ //by sc_yang

			/* WNC-NMR0000-JOE-PENG-20130819-Fix bug that registered MAC filter address of secondary "MAC filter" setting does not show in MAC filter table page->start */
			if(strEnabled[0]){
				enabled = atoi(strEnabled);

				/* WNC-NMR0000-JOE-PENG-20131220-Set MIB MACAC_ENABLED to 3 when MAC filter is disabled. For compatible with Access-Timer-start */
				if (enabled == 0) {
					enabled = 3;
				}
				/* WNC-NMR0000-JOE-PENG-20131220-Set MIB MACAC_ENABLED to 3 when MAC filter is disabled. For compatible with Access-Timer-end */

				if ( apmib_set( MIB_WLAN_MACAC_ENABLED, (void *)&enabled) == 0) {
					strcpy(tmpBuf, ("Set enabled flag error!"));
					goto setErr_end;
				}
			}
			/* WNC-NMR0000-JOE-PENG-20130819-Fix bug that registered MAC filter address of secondary "MAC filter" setting does not show in MAC filter table page->end */
#endif
		}
		vwlan_idx=tmp_vwlan_idx;

		/* WNC-NMR0000-JOE-PENG-20130819-Fix bug that registered MAC filter address of secondary "MAC filter" setting does not show in MAC filter table page->start */
		/* Check if register MAC is needed or not */
		{
			int count=0, old_vwlan_idx=0;

			/* Backup old vwlan index */
			old_vwlan_idx = vwlan_idx;

			for (count=0;count<MAX_USED_WIFI_VLAN_NUM;count++) {
				int value=0;

				vwlan_idx = count;

				apmib_get( MIB_WLAN_MACAC_ENABLED, (void *)&value);

				/* WNC-NMR0000-JOE-PENG-20131220-Set MIB MACAC_ENABLED to 3 when MAC filter is disabled. For compatible with Access-Timer */
				//if ((value==1)&&(old_wlan_macac_enabled[count]==0)) {
				if ((value==1)&&(old_wlan_macac_enabled[count]==3)) {
					need_register_mac=1;
					break;
				}
			}

			/* Recover vwlan index */
			vwlan_idx = old_vwlan_idx;
		}

		/* WNC-NMR0536-JOE-PENG-20140212-Fix bug 536 "automatically MAC address registration" register wired client's MAC address (It should only register wireless client's MAC address)-start */
		//WNC-NMR1449-D2R030-YUAN-I-CHOU-20160401, Spider don't need "automatically MAC address registration" function.
		/* NMR0000-20160830-Fix bug that "4.3.4.1.1. Automatically MAC address registration" does not work-start */
		//need_register_mac = 0;
		/* NMR0000-20160830-Fix bug that "4.3.4.1.1. Automatically MAC address registration" does not work-end */
		if (need_register_mac==1) {
			char mac[20]={0}, buf[20]={0};
			int got_mac_from_arp_cache=0;
			
			memset(mac,0x00,sizeof(mac));

			/* Get MAC address of connected client (From ARP cache) */			
			if (get_mac_from_IP(mac, wp->remote_ip_addr) == 1) {
				int m1=0, m2=0, m3=0, m4=0, m5=0, m6=0;

				if (sscanf(mac, "%02x:%02x:%02x:%02x:%02x:%02x", &m1, &m2, &m3, &m4, &m5, &m6) == 6) {
					snprintf(buf, sizeof(buf), "%02x%02x%02x%02x%02x%02x", m1, m2, m3, m4, m5, m6);
					got_mac_from_arp_cache=1;
				}
			}

			/* Check if the connected client is wireless client or not */
			if (got_mac_from_arp_cache==1) {
				/* WNC-NMR0000-JOE-PENG-20140610-Fix bug "Automatically MAC address registration does not work correctly in 2.4G and 5G Wi-Fi setting page" in Linear_PreTest_for_alpha3_0606.xlsx-start */
				int vlan_count=0, count1=0;

				/* Set need_register_mac to 0 temporarily*/
				need_register_mac=0;

				/* If the client is wireless client, then set need_register_mac to 1 */
				/* If the client is wireless client, then keep need_register_mac to 0 */
				for (count1=0; count1<NUM_WLAN_INTERFACE; count1++) {
					for (vlan_count=0;vlan_count<MAX_USED_WIFI_VLAN_NUM;vlan_count++) {
						char *buff = NULL;

						buff = calloc(1, sizeof(WLAN_STA_INFO_T) * (MAX_STA_NUM+1));

						if ( buff == NULL) {
							console_printf("Allocate buffer failed!\n");
						} else {
							char wifi_ifname[20]={0};

							if (vlan_count == 0) {
								snprintf(wifi_ifname, sizeof(wifi_ifname), "wlan%d", count1);
							} else if (vlan_count > 0) {
								snprintf(wifi_ifname, sizeof(wifi_ifname), "wlan%d-va%d", count1, vlan_count-1);
							}

							if ( getWlStaInfo(wifi_ifname,	(WLAN_STA_INFO_Tp)buff ) < 0 ) {
								console_printf("Read wlan sta info failed!\n");
							} else {
								int count;
								WLAN_STA_INFO_Tp staInfo;

								staInfo = (WLAN_STA_INFO_Tp)&(buff[0]);
					
								for (count=1; count<=MAX_STA_NUM; count++) {						
									if (staInfo[count].aid && (staInfo[count].flag & STA_INFO_FLAG_ASOC)) {
										char macaddr[30]={0};

										console_printf("%d %.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n", count,
										staInfo[count].addr[0], staInfo[count].addr[1], staInfo[count].addr[2],
										staInfo[count].addr[3], staInfo[count].addr[4], staInfo[count].addr[5]);
						
										snprintf(macaddr, sizeof(macaddr), "%02x%02x%02x%02x%02x%02x", staInfo[count].addr[0], staInfo[count].addr[1], staInfo[count].addr[2], staInfo[count].addr[3], staInfo[count].addr[4], staInfo[count].addr[5]);

										if(!memcmp(buf,macaddr,12)){
											need_register_mac=1;
											break;
										}
									}
								}
							}
							free(buff);

							/* WNC-NMR0705-JOE-PENG-20140718-Fix bug 705 [Linear]MAC address is not registered automatically */
							/* Check if the client is a4 station (behind converter or repeater) or not */
							{
								char file_path[128]={0};
								unsigned char temp_buffer[] = "/proc/%s/a4_sta_info";
								snprintf(file_path, sizeof(file_path), temp_buffer, wifi_ifname);

								if (is_a4_station(wp, file_path, a4_sta_owner_mac_str, sizeof(a4_sta_owner_mac_str))==1) {
									need_register_mac=1;
									is_a4_sta=1;
								}
							}
							/* WNC-NMR0705-JOE-PENG-20140718-Fix bug 705 [Linear]MAC address is not registered automatically */
						}
					}
				}
				/* WNC-NMR0000-JOE-PENG-20140610-Fix bug "Automatically MAC address registration does not work correctly in 2.4G and 5G Wi-Fi setting page" in Linear_PreTest_for_alpha3_0606.xlsx-end */
			}
		}
		/* WNC-NMR0536-JOE-PENG-20140212-Fix bug 536 "automatically MAC address registration" register wired client's MAC address (It should only register wireless client's MAC address)-end */

		/* Register MAC filter address of connected client to each WIFI VLAN */		
		//WNC-NMR1449-D2R030-YUAN-I-CHOU-20160401, Spider don't need "automatically MAC address registration" function.
		/* NMR0000-20160830-Fix bug that "4.3.4.1.1. Automatically MAC address registration" does not work-start */
		//need_register_mac = 0;
		/* NMR0000-20160830-Fix bug that "4.3.4.1.1. Automatically MAC address registration" does not work-end */
		if (need_register_mac==1) {
			int count=0, old_vwlan_idx=0, is_error_happen=0;

			/* Backup old vwlan index */
			old_vwlan_idx = vwlan_idx;

			/* Register MAC address of connected client to each vwlan */
			/* NMR2203-20161227-[request]-Unite condition in each operation mode about UMWA and MAC filter-start */
			if (access("/tmp/MODE_RPT", F_OK) == 0) {
				system("rm /tmp/MIB_MAPPING");
			}
			/* NMR2203-20161227-[request]-Unite condition in each operation mode about UMWA and MAC filter-end */
			
			//for (count=0;count<MAX_USED_WIFI_VLAN_NUM;count++) {
			for (count=0;count<MAX_USED_WIFI_VLAN_NUM+1;count++) {	/* NMR2203-20161227-[request]-Unite condition in each operation mode about UMWA and MAC filter */
				vwlan_idx= count;

				/* WNC-NMR0705-JOE-PENG-20140718-Fix bug 705 [Linear]MAC address is not registered automatically */
				if (register_mac_filter_table(wp, is_a4_sta, a4_sta_owner_mac_str) == -1) {
					int value=0;

					apmib_get( MIB_WLAN_MACAC_ENABLED, (void *)&value);

					/* Only show error message if MAC filter of vwlan is enabled. */
					if (value==1) {
						is_error_happen = 1;
						break;
					}
				}
			}
			/* NMR2203-20161227-[request]-Unite condition in each operation mode about UMWA and MAC filter-start */
			if (access("/tmp/MODE_RPT", F_OK) == 0) {
				system("touch /tmp/MIB_MAPPING");
			}
			/* NMR2203-20161227-[request]-Unite condition in each operation mode about UMWA and MAC filter-end */

			/* Show pop up error message if error happens */
			if (is_error_happen==1) {
				for (count=0;count<MAX_USED_WIFI_VLAN_NUM;count++) {
					int value=0;

					vwlan_idx= count;

					value = old_wlan_macac_enabled[count];

					if ( apmib_set( MIB_WLAN_MACAC_ENABLED, (void *)&value) == 0) {
						strcpy(tmpBuf, ("Set enabled flag error!"));
						/* Recover vwlan index */
						vwlan_idx=old_vwlan_idx;
						goto setErr_end;
					}
				}

/* NMR1862-20160930-Fix bug 1862 [Aero] The extra dialog will indicate after indicating the DLG-022LaPaBa-11-start */
#if 0
				strcpy(tmpBuf, ("Ͽ(20)ĶᡢȤWi-Fiüλ˼Ԥޤ[ܺ٥⡼][Wi-Fi]-[MACɥ쥹ե륿]顢פMACɥ쥹Ƥ"));
				/* Recover vwlan index */
				vwlan_idx=old_vwlan_idx;
				goto PopupErr_WncWlan;
#endif
/* NMR1862-20160930-Fix bug 1862 [Aero] The extra dialog will indicate after indicating the DLG-022LaPaBa-11-end */
			}

			/* Recover vwlan index */
			vwlan_idx=old_vwlan_idx;

			/* NMR1827-20161027-Fix bug 1827 [Aero] When enable the [UWMA], The STA will not automatic entry to [UWMA]-start */
			/* Register Wi-Fi MAC address to UWMA (Refer to section 4.4.44.6 Relation to MAC address filtering function of Aero function Spec.) */
			if (is_error_happen==0) {
				int intVal2 = 0;
				
				/* The value of MIB_CLIENT_ACL_MODE is 0 (access timer) or 1 (MAC filter) */	
				apmib_get(MIB_CLIENT_ACL_MODE, (void *)&intVal2);

				if (intVal2==0) {
					register_wifi_mac_to_uwma(wp, is_a4_sta, a4_sta_owner_mac_str);
				}
			}
			/* NMR1827-20161027-Fix bug 1827 [Aero] When enable the [UWMA], The STA will not automatic entry to [UWMA]-end */
		}
		/* WNC-NMR0000-JOE-PENG-20130819-Fix bug that registered MAC filter address of secondary "MAC filter" setting does not show in MAC filter table page->end */

#if 1	/* WNC-NMR1795-[Aero]-20160921- [request] [Bandsteering]: 2G sync. 5G -start */
		/* Band steering copy 5G profile to 2g: enable:1, recovery:2, updateto2G:3, default:0 */
		strValue = req_get_cstream_var(wp, "copy5gto2g", "");
		//printf("WNC: Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);

		if (strValue[0]) {
			//printf("strValue:%s Func: %s, Line: %d\n",strValue,__FUNCTION__ , __LINE__);
			if (strValue[0] == '0'){
				val = 0;
				copy5gto2g(val);
				/* NMR2089-[Aero]-20161123 - 2G sync. 5G -v2-start */
				if (bandsteer == 1){
					val=3; /* WNC-NMR1795-[Aero]-20160921- [request] [Bandsteering]: 2G sync. 5G*/
				}
				/* NMR2089-[Aero]-20161123 - 2G sync. 5G -v2-end */ 		
				
			}else if (strValue[0] == '1'){
				val = 1;
				copy5gto2g(val);
			}else if (strValue[0] == '2'){
				val = 2;
				copy5gto2g(val);
			}else if (strValue[0] == '3'){/* WNC-NMR1795-[Aero]-20160921- [request] [Bandsteering]: 2G sync. 5G*/
				val = 3;
				copy5gto2g(val);
			}else {
				strcpy(tmpBuf, ("Error! Invalid copy5gto2g Value."));
				goto setErr_end;
			}
			
			if( apmib_set(MIB_WLAN_COPY_5GTO2G, (void *)&val) == 0) {
				strcpy(tmpBuf, ("Set copy5gto2g failed!"));
				goto setErr_end;
			}

			strValue = req_get_cstream_var(wp, "realtimeSet", "");
			if (strValue[0]) {
#if 1	/* WNC-NMR000-[Aero/Thalys]-Libera-20160606- responsive GUI porting*/
				if (strValue[0] == '1'){	
					if (submitUrl[0]){
						send_redirect_perm(wp, submitUrl);
					}else{
						printf("error: submitUrl=NULL, Func: %s, Line: %d\n",__FUNCTION__ , __LINE__);
					}
					return;
				}
#endif
			}
		}
#endif	/* WNC-NMR1795-[Aero]-20160921- [request] [Bandsteering]: 2G sync. 5G -end */


		/* WNC-NMR2200-MIKE-YEH-20161227-The layout and item changed. */
		strEnabled = req_get_cstream_var(wp, "modulation256qam2g", "");
		
		/* WNC-NMR2393-MIKE-YEH-20170608-[Rafale]256QAM function can enable on Meteor. */
		apmib_get(MIB_HW_PRODUCT_NAME,  (void*)productName);

		if (strEnabled[0] && (!strcmp(productName, "WG1900HP"))) {

			enabled = atoi(strEnabled);

			if ((enabled == 0) || (enabled == 1)) {

				if ( apmib_set( MIB_WLAN_MODULATION_256QAM_2G, (void *)&enabled) == 0) {
					strcpy(tmpBuf, ("Set wlan 256QAM 2G enable error!"));
					goto setErr_end;
				}				
				set_wlan0_band_256qam(enabled);
			}
		}

	}
	apmib_update_web(CURRENT_SETTING);

//#ifdef REBOOT_CHECK
//	run_init_script_flag = 1;
//#endif
#ifndef NO_ACTION
	run_init_script("all");
#endif
/*
	submitUrl = req_get_cstream_var(wp, ("next_url"), "");
	REBOOT_WAIT("/wlbasic.htm");	//original Realtek
*/

#if 1 /* WNC-NMR1761-[Aero/Thalys]-MIKE-YEH-20160831-After push the "reboot later" in RT mode, the transition page is wrong. */
		submitUrl = req_get_cstream_var(wp, ("submit-url"), "");
		if (!submitUrl[0]) {
			submitUrl = req_get_cstream_var(wp, ("wlan-url"), "");	 // hidden page
		}
#else
		submitUrl = req_get_cstream_var(wp, ("wlan-url"), "");	 // hidden page
#endif

		OK_MSG(submitUrl);
	return ;
setErr_end:
fprintf(stderr, "###ERROR:=%s###\n", tmpBuf);
	ERR_MSG(tmpBuf);
//	OK_MSG1(tmpBuf,"/wlbasic.htm");
/* WNC-MRXXXX-JOE-PENG-20120403-Modification for NEC GUI customization */
	return ;

PopupErr_WncWlan:
	POP_ERR_MSG(tmpBuf);
	return ;
/* WNC-MRXXXX-JOE-PENG-20120403-end */
}
#endif
void formWizard(request *wp, char *path, char *query)
{
	char *tmpStr;
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch
	//	char tmpBuf[100];
		char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch End
	char varName[20];
	int i;
	int showed_wlan_num;
	int wlBandMode=0;
#ifdef HOME_GATEWAY	
	int dns_changed=0;
#endif	
	int mode=-1;
// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 855, 856 UNUSED_VALUE
//	char *submitUrl;
// WNC-NMR0000-Heng-I-Chen-20130814: End
	char buffer[200]={0};//WNC-NMR0000-Rita-20130305-Error_456-fix warnings of cppcheck (uninitialized value).
	struct in_addr inLanaddr_orig, inLanaddr_new;
	struct in_addr inLanmask_orig, inLanmask_new;
	int	entryNum_resvdip=0;//WNC-NMR0000-Rita-20130310-Error_573-fix warnings of cppcheck (uninitialized value).
	DHCPRSVDIP_T entry_resvdip, checkentry_resvdip;
	int link_type;
	struct in_addr private_host, tmp_private_host, update;	
	struct in_addr dhcpRangeStart, dhcpRangeEnd;
#ifdef MIB_TLV
	char pmib_num[10]={0};
	mib_table_entry_T *pmib_tl = NULL;
	unsigned int offset;
#endif
/* WNC-MR0000-Libera-20120308- for wizard password setting */
	char *strPassword, user_password[PASSWORD_SIZE]={0};//WNC-NMR0000-Rita-20130310-Error_560-fix warnings of cppcheck (uninitialized value).
	strPassword = req_get_cstream_var(wp, "newpass", "");
	int pwdset;
/* WNC-MR0000-Libera-20120308- END */
	/* WNC-MR0000-JOE-PENG-20130626-Modify codes according to Pocket spec. V1.0.0 */
	int opmode=0;
//displayPostDate(wp->post_data);
		

	apmib_get( MIB_IP_ADDR,  (void *)buffer); //save the orig lan subnet
	memcpy((void *)&inLanaddr_orig, buffer, 4);
	
	apmib_get( MIB_SUBNET_MASK,  (void *)buffer); //save the orig lan mask
	memcpy((void *)&inLanmask_orig, buffer, 4);
#ifdef HOME_GATEWAY
	if(opModeHandler(wp, tmpBuf) < 0)
		goto setErr_end;	
#endif

	if(ntpHandler(wp, tmpBuf, 1) < 0)
		goto setErr_end;
	set_timeZone();
		
	if(tcpipLanHandler(wp, tmpBuf) < 0){
// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 855 UNUSED_VALUE
//		submitUrl = req_get_cstream_var(wp, ("submit-url-lan"), "");   // hidden page
// WNC-NMR0000-Heng-I-Chen-20130814: End
		goto setErr_end;
	}

#ifdef HOME_GATEWAY
#ifdef MULTI_WAN_SUPPORT
	wan_index=1;	

	if ( !apmib_set( MIB_WANIFACE_CURRENT_IDX, (void *)&wan_index) )
	{
		fprintf(stderr,"%s:%d get MIB_WANIFACE_CURRENT_IDX fail!wan_index=%d\n",__FUNCTION__,__LINE__,wan_index);
		return;
	}
	
	formMultiWanTcpipSetup(wp,path,query);
#endif
	if(tcpipWanHandler(wp, tmpBuf, &dns_changed) < 0){
// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 856 UNUSED_VALUE
//		submitUrl = req_get_cstream_var(wp, ("submit-url-wan"), "");   // hidden page
// WNC-NMR0000-Heng-I-Chen-20130814: End
		goto setErr_end;
	}
#endif

/* WNC-MR0000-JOE-PENG-20140527-Fix bug device would execute factory default after set WAN mode in wizard page-start */
/* Comment Wi-Fi related codes in formWizard. Avoid affecting Wi-Fi settings */
#if 0
#if defined(CONFIG_RTL_92D_SUPPORT)

	tmpStr = req_get_cstream_var(wp, "wlBandMode", "");
	if(tmpStr[0] != 0)
	{
		wlBandMode = atoi(tmpStr);
		apmib_set(MIB_WLAN_BAND2G5G_SELECT, (void *)&wlBandMode);
	}
/* WNC-NMR0000-Rita-20130213-what's the purpose of below codes?
comment it to avoid setting WLAN_DISABLED */
#if 0
	for(i=0 ; i<NUM_WLAN_INTERFACE ; i++)
	{
		unsigned char wlanif[10];
		memset(wlanif,0x00,sizeof(wlanif));
		sprintf(wlanif, "wlan%d",i);
		if(SetWlan_idx(wlanif))
		{
			int intVal;
			
			intVal = 1;
			apmib_set(MIB_WLAN_WLAN_DISABLED, (void *)&intVal);
		}						
	}
#endif
#endif
#endif
/* WNC-MR0000-JOE-PENG-20140527-Fix bug device would execute factory default after set WAN mode in wizard page-end */
/*	 WNC-MR0000-Libera-20120308- Wizard page doesn't need it

	for(i=0 ; i < wlan_num ;i++){	
		wlan_idx = i ;
		sprintf(WLAN_IF, "wlan%d", wlan_idx);
		if(wlanHandler(wp, tmpBuf,&mode, i) < 0){
		submitUrl = req_get_cstream_var(wp, ("submit-url-wlan1"), "");   // hidden page
		goto setErr_end;
	}	
		
		sprintf(varName, "method%d", i);
		tmpStr = req_get_cstream_var(wp, varName, "");
	if(tmpStr[0] && tmpStr[0] == '1'){
			if(wepHandler(wp, tmpBuf, i) < 0){
			submitUrl = req_get_cstream_var(wp, ("submit-url-wlan2"), "");   // hidden page
			goto setErr_end;
		}
	}	
		if(wpaHandler(wp, tmpBuf, i) < 0){
		submitUrl = req_get_cstream_var(wp, ("submit-url-wlan2"), "");   // hidden page
		goto setErr_end;
	}


		
#if defined(WLAN_PROFILE)
		if(addWlProfileHandler(wp, tmpBuf, i) < 0){
			//submitUrl = req_get_cstream_var(wp, ("submit-url-wlan2"), "");   // hidden page
			//goto setErr_end;
		}
		
#endif //#if defined(WLAN_PROFILE)


	}
*/	
/* WNC-MR0000-JOE-PENG-20140527-Fix bug device would execute factory default after set WAN mode in wizard page-start */
/* Comment Wi-Fi related codes in formWizard. Avoid affecting Wi-Fi settings */
#if 0
	
#if defined(CONFIG_RTL_92D_SUPPORT)		
	apmib_get(MIB_WLAN_BAND2G5G_SELECT, (void *)&wlBandMode);
	if(BANDMODEBOTH == wlBandMode)
	{
		unsigned char wlanIfStr[10];				
				
		for(i=0 ; i<NUM_WLAN_INTERFACE ; i++)
		{
			unsigned char wlanif[10];
			memset(wlanif,0x00,sizeof(wlanif));
			sprintf(wlanif, "wlan%d",i);
			if(SetWlan_idx(wlanif))
			{
				int intVal;
#if defined(CONFIG_RTL_92D_SUPPORT) && defined(CONFIG_RTL_92D_DMDP) && !defined(CONFIG_RTL_DUAL_PCIESLOT_BIWLAN_D)
				intVal = DMACDPHY;
#else
				intVal = SMACSPHY;
#endif
				apmib_set(MIB_WLAN_MAC_PHY_MODE, (void *)&intVal);				
			}						
		}
		
		/* 92d rule, 5g must up in wlan0 */
		/* phybandcheck */
		if(whichWlanIfIs(PHYBAND_5G) != 0)
		{
			swapWlanMibSetting(0,1);			
		}
	}
	else
	{
		int band2G5GSelect=0; //WNC-NMR0000-Rita-20130310-Error_548-fix warnings of cppcheck (uninitialized value).
		int intVal;

		for(i=0 ; i<NUM_WLAN_INTERFACE ; i++)
		{
			unsigned char wlanif[10];
			memset(wlanif,0x00,sizeof(wlanif));
			sprintf(wlanif, "wlan%d",i);
			if(SetWlan_idx(wlanif))
			{				
				intVal = SMACSPHY;
				apmib_set(MIB_WLAN_MAC_PHY_MODE, (void *)&intVal);				
			}						
		}
		
		tmpStr = req_get_cstream_var(wp, "Band2G5GSupport", "");
		
		if(tmpStr[0] != 0)
		{
			band2G5GSelect = atoi(tmpStr);			
		}
		
		/* 92d rule, 5g must up in wlan0 */
		/* phybandcheck */
		if(whichWlanIfIs(band2G5GSelect) != 0)
		{
			swapWlanMibSetting(0,1);			
		}
		apmib_save_wlanIdx();
		wlan_idx = 1;
		intVal = 1;
		apmib_set( MIB_WLAN_WLAN_DISABLED, (void *)&intVal); // disable wlan1
		apmib_recov_wlanIdx();
	}
#endif //#if defined(CONFIG_RTL_92D_SUPPORT)
#endif
/* WNC-MR0000-JOE-PENG-20140527-Fix bug device would execute factory default after set WAN mode in wizard page-end */

/* WNC-MR0000-Libera-20120308- for wizard password setting */
	apmib_get(MIB_USER_PASSWORD, user_password);
// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 461 NO_EFFECT
//	if (!strcmp(user_password, "") || user_password==NULL) {	//if password is empty, can do password setting.
	if (!strcmp(user_password, "")) {	//if password is empty, can do password setting.
// WNC-NMR0000-Heng-I-Chen-20130814: End
		if ( !apmib_set(MIB_USER_PASSWORD, (void *)strPassword) ) {
			//fprintf(stderr,"##  Set user  password  to  MIB database!! \n");
			strcpy(tmpBuf, ("̵ʥѥɤǤȾѱѿ,-,_Ѥ64ϤƤ"));
			goto setErr_end;
		}
	}
/* WNC-MR0000-Libera-20120308- END */
	apmib_update_web(CURRENT_SETTING);
	apmib_get( MIB_IP_ADDR,  (void *)buffer); //check the new lan subnet
	memcpy((void *)&inLanaddr_new, buffer, 4);
		
	apmib_get( MIB_SUBNET_MASK,  (void *)buffer); //check the new lan mask
	memcpy((void *)&inLanmask_new, buffer, 4);

	/* WNC-MR0000-JOE-PENG-20130626-Modify codes according to Pocket spec. V1.0.0 ->start */
	apmib_get( MIB_OP_MODE, (void *)&opmode);

	if(((inLanaddr_orig.s_addr & inLanmask_orig.s_addr) != (inLanaddr_new.s_addr & inLanmask_new.s_addr)) &&
		(opmode != BRIDGE_MODE)){
	/* WNC-MR0000-JOE-PENG-20130626-Modify codes according to Pocket spec. V1.0.0 ->end */
		//check static dhcp ip
		apmib_get(MIB_DHCPRSVDIP_TBL_NUM, (void *)&entryNum_resvdip);
		link_type = 8; //DHCPRSVDIP_ARRY_T
		for (i=1; i<=entryNum_resvdip; i++) {
			memset(&checkentry_resvdip, '\0', sizeof(checkentry_resvdip));
			*((char *)&entry_resvdip) = (char)i;
			apmib_get(MIB_DHCPRSVDIP_TBL, (void *)&entry_resvdip);
			memcpy(&checkentry_resvdip, &entry_resvdip, sizeof(checkentry_resvdip));
			memcpy((void *)&private_host, &(entry_resvdip.ipAddr), 4);
			if((inLanaddr_new.s_addr & inLanmask_new.s_addr) != (private_host.s_addr & inLanmask_new.s_addr)){
				update.s_addr = inLanaddr_new.s_addr & inLanmask_new.s_addr;
				tmp_private_host.s_addr  = ~(inLanmask_new.s_addr) & private_host.s_addr;
				update.s_addr = update.s_addr | tmp_private_host.s_addr;
				memcpy((void *)&(checkentry_resvdip.ipAddr), &(update), 4);
#if defined(MIB_TLV)
				offset=0;//must initial first for mib_search_by_id
				mib_search_by_id(mib_root_table, MIB_DHCPRSVDIP_TBL, (unsigned char *)pmib_num, &pmib_tl, &offset);
				update_tblentry(pMib,offset,entryNum_resvdip,pmib_tl,&entry_resvdip, &checkentry_resvdip);
#else
				update_linkchain(link_type, &entry_resvdip, &checkentry_resvdip , sizeof(checkentry_resvdip));
#endif

			}
		}
		apmib_get( MIB_DHCP_CLIENT_START,  (void *)buffer); //save the orig dhcp start 
		memcpy((void *)&dhcpRangeStart, buffer, 4);
		apmib_get( MIB_DHCP_CLIENT_END,  (void *)buffer); //save the orig dhcp end 
		memcpy((void *)&dhcpRangeEnd, buffer, 4);
		
		if((dhcpRangeStart.s_addr & inLanmask_new.s_addr) != (inLanaddr_new.s_addr & inLanmask_new.s_addr)){
			update.s_addr = inLanaddr_new.s_addr & inLanmask_new.s_addr;
			tmp_private_host.s_addr  = ~(inLanmask_new.s_addr) & dhcpRangeStart.s_addr;
			update.s_addr = update.s_addr | tmp_private_host.s_addr;
			memcpy((void *)&(dhcpRangeStart), &(update), 4);
			apmib_set(MIB_DHCP_CLIENT_START, (void *)&dhcpRangeStart);
		}
		if((dhcpRangeEnd.s_addr & inLanmask_new.s_addr) != (inLanaddr_new.s_addr & inLanmask_new.s_addr)){
			update.s_addr = inLanaddr_new.s_addr & inLanmask_new.s_addr;
			tmp_private_host.s_addr  = ~(inLanmask_new.s_addr) & dhcpRangeEnd.s_addr;
			update.s_addr = update.s_addr | tmp_private_host.s_addr;
			memcpy((void *)&(dhcpRangeEnd), &(update), 4);
			apmib_set(MIB_DHCP_CLIENT_END, (void *)&dhcpRangeEnd);
		}
		apmib_update_web(CURRENT_SETTING);
	}
/*WNC-MR0000-JOE-PENG-20120606-Modification for specification V1.8.0 section 6.10 Reboot Now */
#if 1
	formReboot(wp, path, query);
#else
#ifdef REBOOT_CHECK
	run_init_script_flag = 1;
#endif
#ifndef NO_ACTION
	run_init_script("all");
#endif
	submitUrl = req_get_cstream_var(wp, ("next_url"), "");
#ifdef MULTI_WAN_SUPPORT
#ifdef APPLY_CHANGE_DIRECT_SUPPORT	
	REBOOT_NOWAIT("/wizard.htm");
#else	
	OK_MSG("/wizard.htm");
#endif
#else
	REBOOT_WAIT("/wizard.htm");
#endif
#endif
/*WNC-MR0000-JOE-PENG-20120606-end */
	return ;
setErr_end:
	
	OK_MSG1(tmpBuf,"/wizard.htm");
	return ;

}

///////////////////////////////////////////////////////////////////////////////////////////////
int logout=0 ;
void formLogout(request *wp, char *path, char *query)
{
#if 0
	char *logout_str, *return_url;
	logout_str = req_get_cstream_var(wp, ("logout"), "");
	if (logout_str[0]) {
		logout = 1 ;
#ifdef LOGIN_URL
		delete_user(wp);
	    OK_MSG("/login.htm");
	    return;
#endif		
	}

	return_url = req_get_cstream_var(wp, ("return-url"), "");

#ifdef REBOOT_CHECK
	send_redirect_perm(wp, return_url);	
#else
        OK_MSG(return_url);
#endif
#endif
	
	console_printf("%s %d\n", __func__, __LINE__);
	del_logout_session(wp);
	console_printf("%s %d\n", __func__, __LINE__);
//	sleep(1);
//	console_printf("%s %d\n", __func__, __LINE__);
	send_redirect_perm(wp, "/logout_main.html");
	console_printf("%s %d\n", __func__, __LINE__);
	
	return;
}
#define _PATH_SYSCMD_LOG "/tmp/syscmd.log"

/* WNC-NMR0000-JOE-PENG-20170216-Comment formSysCmd related codes-start */
#if 0
void formSysCmd(request *wp, char *path, char *query)
{
	char  *submitUrl, *sysCmd;
#ifndef NO_ACTION
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch
	//	char tmpBuf[100];
		char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch End
#endif
	
	submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page
	sysCmd = req_get_cstream_var(wp, "sysCmd", "");   // hidden page

#ifndef NO_ACTION
	if(sysCmd[0]){
		snprintf(tmpBuf, 100, "%s 2>&1 > %s",sysCmd,  _PATH_SYSCMD_LOG);
		system(tmpBuf);
	}
#endif
		send_redirect_perm(wp, submitUrl);
	return;
}
#endif
/* WNC-NMR0000-JOE-PENG-20170216-Comment formSysCmd related codes-end */

int sysCmdLog(request *wp, int argc, char **argv)
{
        FILE *fp;
	char  buf[150];
	int nBytesSent=0;

        fp = fopen(_PATH_SYSCMD_LOG, "r");
        if ( fp == NULL )
                goto err1;
        while(fgets(buf,150,fp)){
		nBytesSent += req_format_write(wp, ("%s"), buf);
        }
	fclose(fp);
	unlink(_PATH_SYSCMD_LOG);
err1:
	return nBytesSent;
}

#if defined(CONFIG_RTL_ULINKER)

void formUlkOpMode(request *wp, char *path, char *query)
{
	char *submitUrl;
	char *tmpStr;
	int ulinker_auto, opmode, wlanMode, rpt_enabled;
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch
	//	char tmpBuf[100];
		char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch End

//displayPostDate(wp->post_data);
	
	submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page


	tmpStr = req_get_cstream_var(wp, ("ulinker_auto"), "");
	if(tmpStr[0])
	{
		ulinker_auto = tmpStr[0] - '0' ;
		apmib_set( MIB_ULINKER_AUTO, (void *)&ulinker_auto);
		
		if(ulinker_auto == 0)
		{
			int selVal;
			tmpStr = req_get_cstream_var(wp, ("ulinker_manual_Sel"), "");
			if(tmpStr[0])
			{
				selVal = tmpStr[0] - '0';
				
				switch(selVal)
				{
					case 0:
ulinker_wlan_mib_copy(&pMib->wlan[0][0], &pMib->wlan[0][ULINKER_AP_MIB]);
						opmode = BRIDGE_MODE;
						wlanMode = AP_MODE;
						rpt_enabled = 0; 
						break;
					case 1:
ulinker_wlan_mib_copy(&pMib->wlan[0][0], &pMib->wlan[0][ULINKER_CL_MIB]);						
						opmode = BRIDGE_MODE;
						wlanMode = CLIENT_MODE;
						rpt_enabled = 0; 
						break;
					case 2:
ulinker_wlan_mib_copy(&pMib->wlan[0][0], &pMib->wlan[0][ULINKER_AP_MIB]);
						opmode = GATEWAY_MODE;
						wlanMode = AP_MODE;
						rpt_enabled = 0; 
						break;
					case 3:
ulinker_wlan_mib_copy(&pMib->wlan[0][0], &pMib->wlan[0][ULINKER_RPT_MIB]);						
						opmode = BRIDGE_MODE;
						wlanMode = AP_MODE;
						rpt_enabled = 1; 
						break;
					case 4:
ulinker_wlan_mib_copy(&pMib->wlan[0][0], &pMib->wlan[0][ULINKER_RPT_MIB]);
						opmode = WISP_MODE;
						wlanMode = AP_MODE;
						rpt_enabled = 1; 
						break;
				}
				apmib_set( MIB_OP_MODE, (void *)&opmode);
				apmib_set( MIB_WLAN_MODE, (void *)&wlanMode);
				pMib->wlan[wlan_idx][NUM_VWLAN_INTERFACE].wlanMode = CLIENT_MODE;
				
				if(wlanMode == CLIENT_MODE) //set cipher suit to AES and encryption to wpa2 only if wpa2 mixed mode is set
				{
					
					ENCRYPT_T encrypt;
					int intVal;
					apmib_get( MIB_WLAN_ENCRYPT, (void *)&encrypt);
					if(encrypt == ENCRYPT_WPA2_MIXED)
					{
						intVal =   WPA_CIPHER_AES ;
						encrypt = ENCRYPT_WPA2;
						
						apmib_set(MIB_WLAN_WPA_CIPHER_SUITE, (void *)&intVal);
						apmib_set(MIB_WLAN_WPA2_CIPHER_SUITE, (void *)&intVal);
						apmib_set(MIB_WLAN_ENCRYPT, (void *)&encrypt);
					}
				}
	
				if(wlan_idx == 0)
				{
					apmib_set( MIB_REPEATER_ENABLED1, (void *)&rpt_enabled);						
				}
				else
				{
					apmib_set( MIB_REPEATER_ENABLED2, (void *)&rpt_enabled);
				}
				pMib->wlan[wlan_idx][NUM_VWLAN_INTERFACE].wlanDisabled = (rpt_enabled?0:1);
				
			}
		}
	}
	
	apmib_update_web(CURRENT_SETTING);

#if defined(CONFIG_RTL_ULINKER)
	if (ulinker_auto == 0) {
		char *submitUrl;
		needReboot = 1;
		submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page
		sprintf(lastUrl,"%s",submitUrl);
		send_redirect_perm(wp, "/reload.htm");
		return ;
	}
#endif

#ifdef REBOOT_CHECK
	run_init_script_flag = 1;
#endif		

#ifdef REBOOT_CHECK
	REBOOT_WAIT(submitUrl);
#else //#ifdef REBOOT_CHECK	.
	OK_MSG(submitUrl);
#endif //#ifdef REBOOT_CHECK	


#ifndef NO_ACTION
	run_init_script("all");
#endif
return;

setErr:
	ERR_MSG(tmpBuf);
}
#endif//#if defined(CONFIG_RTL_ULINKER)

#ifdef HOME_GATEWAY
int  opModeHandler(request *wp, char *tmpBuf)
{
	char *tmpStr;
	int opmode=0, wanId;//WNC-NMR0000-Rita-20130305-Error_420-fix warnings of cppcheck (uninitialized value).	
	//WNC-NMRXXX-JDR230-YUAN-I-CHOU-20140916, Fix bug 2573, 2584, 2608 (UNINIT) in StaticCodeCheck_Linear_Delta1.xls
	//char repeaterSSID[40];
	char repeaterSSID[40]= {0};
	tmpStr = req_get_cstream_var(wp, ("opMode"), "");  
	if(tmpStr[0]){
		opmode = tmpStr[0] - '0' ;
		if ( apmib_set(MIB_OP_MODE, (void *)&opmode) == 0) {
			strcpy(tmpBuf, ("Set Opmode error!"));
			goto setErr_opmode;
		}
	}
#if defined(CONFIG_SMART_REPEATER)
	if(opmode==2)
	{//wisp mode
#endif
		tmpStr = req_get_cstream_var(wp, ("wispWanId"), "");  
		if(tmpStr[0]){
			wanId = tmpStr[0] - '0' ;
			if ( apmib_set(MIB_WISP_WAN_ID, (void *)&wanId) == 0) {
				strcpy(tmpBuf, ("Set WISP WAN Id error!"));
				goto setErr_opmode;
			}
#if defined(CONFIG_SMART_REPEATER)
			int rpt_enabled = 1;
			char wlanifStr[20];
			int wlanMode;

			apmib_save_wlanIdx();
			if(wanId == 0)
			{
				apmib_set( MIB_REPEATER_ENABLED1, (void *)&rpt_enabled);
				apmib_get( MIB_REPEATER_SSID1, (void *)repeaterSSID);
				rpt_enabled=0;
				apmib_set(MIB_REPEATER_ENABLED2,(void *)&rpt_enabled);
			}
			else
			{
				apmib_set( MIB_REPEATER_ENABLED2, (void *)&rpt_enabled);
				apmib_get( MIB_REPEATER_SSID2, (void *)repeaterSSID);
				rpt_enabled=0;
				apmib_set(MIB_REPEATER_ENABLED1,(void *)&rpt_enabled);
			}

			sprintf(wlanifStr, "wlan%d", wanId); 
			SetWlan_idx(wlanifStr);
			wlanMode = AP_MODE;
			apmib_set( MIB_WLAN_MODE, (void *)&wlanMode);
			
			sprintf(wlanifStr, "wlan%d-vxd", wanId); 
			SetWlan_idx(wlanifStr);
			wlanMode = CLIENT_MODE;
			apmib_set( MIB_WLAN_MODE, (void *)&wlanMode);
			apmib_set(MIB_WLAN_SSID,(void *)repeaterSSID);
			rpt_enabled = 0;
			apmib_set( MIB_WLAN_WLAN_DISABLED, (void *)&rpt_enabled);
			apmib_recov_wlanIdx();

#endif
		}
#if defined(CONFIG_SMART_REPEATER)
		else{//only one wlan:92c
			int rpt_enabled = 1;
			char wlanifStr[20]={0};
			int wlanMode;

			wanId=0;
			apmib_save_wlanIdx();
			apmib_set( MIB_REPEATER_ENABLED1, (void *)&rpt_enabled);
			apmib_get( MIB_REPEATER_SSID1, (void *)repeaterSSID);
			sprintf(wlanifStr, "wlan%d", wanId); 
			SetWlan_idx(wlanifStr);
			wlanMode = AP_MODE;
			apmib_set( MIB_WLAN_MODE, (void *)&wlanMode);

			sprintf(wlanifStr, "wlan%d-vxd", wanId); 
			SetWlan_idx(wlanifStr);
			wlanMode = CLIENT_MODE;
			apmib_set( MIB_WLAN_MODE, (void *)&wlanMode);
			apmib_set(MIB_WLAN_SSID,(void *)repeaterSSID);
			rpt_enabled = 0;
			apmib_set( MIB_WLAN_WLAN_DISABLED, (void *)&rpt_enabled);
			apmib_recov_wlanIdx();
		}
	}else //opmode is gw or bridge
	{	

		int rpt_enabled=0;
		apmib_set(MIB_REPEATER_ENABLED1, (void *)&rpt_enabled);
		apmib_set(MIB_REPEATER_ENABLED2,(void *)&rpt_enabled);
	}
#endif
	return 0;

setErr_opmode:
	return -1;

}
void formOpMode(request *wp, char *path, char *query)
{
	char *submitUrl;
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch
	//	char tmpBuf[100];
		char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch End

	submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page

	if(opModeHandler(wp, tmpBuf) < 0)
			goto setErr;
	
	apmib_update_web(CURRENT_SETTING);
	
#ifdef REBOOT_CHECK
	run_init_script_flag = 1;
#endif		
#ifndef RTK_REINIT_SUPPORT
#ifdef REBOOT_CHECK
	REBOOT_WAIT(submitUrl);
#else //#ifdef REBOOT_CHECK	.
	OK_MSG(submitUrl);
#endif //#ifdef REBOOT_CHECK	
#else
	OK_MSG(submitUrl);
#endif

#ifndef NO_ACTION
	run_init_script("all");
#endif
return;

setErr:
	ERR_MSG(tmpBuf);
}
#endif

#ifdef REBOOT_CHECK
void formRebootCheck(request *wp, char *path, char *query)
{
// WNC-NMR0000-Heng-I-Chen-20130814: 20130717-pocket-alpha2-coverity-error-userland Errors 843 UNUSED_VALUE
//	char *submitUrl;

//	submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page
// WNC-NMR0000-Heng-I-Chen-20130814: End
	
	apmib_update_web(CURRENT_SETTING);
/* WNC-NMR0000-JOE-PENG-20120529-Modification for spec. v1.7.0 section 6.10 "Reboot Now" */
#if 1
	formReboot(wp, path, query);
#else
#ifdef REBOOT_CHECK
	run_init_script_flag = 1;
#endif
#ifndef NO_ACTION
	run_init_script("all");
#endif
#ifdef RTK_REINIT_SUPPORT
	{
		char lan_ip_buf[32]={0};
		char cmdBuf[64]={0};
		struct in_addr	lan_ip_orig={0};
		struct in_addr	lan_mask_orig={0};
		struct in_addr	lan_ip={0};
		struct in_addr	lan_mask={0};
		struct in_addr	remote_ip={0};
		
		//fprintf(stderr,"%d %s:%d \n",time(NULL),__FUNCTION__,__LINE__);
		
		if(!getInAddr(BRIDGE_IF,IP_ADDR,&lan_ip_orig))
			goto REBOOTCHECK_FAIL;
		if(!getInAddr(BRIDGE_IF,SUBNET_MASK,&lan_mask_orig))
			goto REBOOTCHECK_FAIL;
		if(!apmib_get(MIB_IP_ADDR,((void *)&lan_ip)))
			goto REBOOTCHECK_FAIL;
		if(!apmib_get(MIB_SUBNET_MASK,((void *)&lan_mask)))
			goto REBOOTCHECK_FAIL;
		if(!inet_aton(wp->remote_ip_addr, &remote_ip))
			goto REBOOTCHECK_FAIL;

		snprintf(lan_ip_buf, sizeof(lan_ip_buf),"%s",inet_ntoa(lan_ip));
		fprintf(stderr,"send apply change event!\n");
		//fprintf(stderr,"%d %s:%d \n",time(NULL),__FUNCTION__,__LINE__);
#ifdef	REDUCE_WEBCLIENT_WAITTIME_SUPPORT
		snprintf(cmdBuf, sizeof(cmdBuf),"reinitCli -e %d&",REINIT_EVENT_APPLYCAHNGES);
#else
		snprintf(cmdBuf, sizeof(cmdBuf),"reinitCli -e %d",REINIT_EVENT_APPLYCAHNGES);
#endif
		system(cmdBuf);
		//fprintf(stderr,"%d %s:%d \n",time(NULL),__FUNCTION__,__LINE__);
		//fprintf(stderr,"%s:%d lan_ip_orig.s_addr=%x lan_mask_orig.s_addr=%x remote_ip.s_addr=%x lan_ip=%x\n",__FUNCTION__,__LINE__,lan_ip_orig.s_addr,lan_mask_orig.s_addr,remote_ip.s_addr,lan_ip.s_addr);
		
		if(((lan_ip_orig.s_addr&lan_mask_orig.s_addr)==(remote_ip.s_addr&lan_mask_orig.s_addr))//lan visit
			&& (memcmp(&lan_ip_orig,&lan_ip,sizeof(lan_ip))!=0) //lan ip change
		)
		{
			//fprintf(stderr,"%d %s:%d \n",time(NULL),__FUNCTION__,__LINE__);
			//fprintf(stderr,"%s:%d local_ip_addr=%s remote_ip_addr=%s\n",__FUNCTION__,__LINE__,wp->local_ip_addr,wp->remote_ip_addr);
			OK_MSG_FW("<h4>Change setting successfully!<BR><BR>Do not turn off or reboot the Device during this time.</h4>", submitUrl, 0, lan_ip_buf);	
			//fprintf(stderr,"%d %s:%d \n",time(NULL),__FUNCTION__,__LINE__);
		}else
		{
			send_redirect_perm(wp,submitUrl);
		}

	}
#else
	REBOOT_WAIT(submitUrl);
#endif

	needReboot = 0;
	return;
REBOOTCHECK_FAIL:
		ERR_MSG("reboot check fail!\n");
#endif
/* WNC-NMR0000-JOE-PENG-20120529-end */
}

#if defined(WLAN_PROFILE)
void formSiteSurveyProfile(request *wp, char *path, char *query)
{
	char *submitUrl, *strTmp, *addProfileTmp;
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch
	//	char tmpBuf[100];
		char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch End
	char varName[20];
		
//displayPostDate(wp->post_data);	


	sprintf(varName, "wizardAddProfile%d", wlan_idx);
	addProfileTmp = req_get_cstream_var(wp, varName, "");
	
	if(addProfileTmp[0])	
	{
		int rptEnabled=0, wlan_mode=0; //WNC-NMR0000-Rita-20130305-Error_437,Error_444,Error_427-fix warnings of cppcheck (uninitialized value).
		int ori_vwlan_idx=vwlan_idx;
		int profile_enabled_id, profile_num_id, profile_tbl_id;
		int profileEnabledVal=1;
		char iwprivCmd[600]={0};
		int entryNum=0; //WNC-NMR0000-Rita-20130306-Error_504-fix warnings of cppcheck (uninitialized value).
		WLAN_PROFILE_T entry;
		int profileIdx;
		char ifname[10]={0}; //max is wlan0-vxd
		
		memset(iwprivCmd, 0x00, sizeof(iwprivCmd));
		apmib_get(MIB_WLAN_MODE, (void *)&wlan_mode);

		if(wlan_idx == 0)
			apmib_get(MIB_REPEATER_ENABLED1, (void *)&rptEnabled);
		else
			apmib_get(MIB_REPEATER_ENABLED2, (void *)&rptEnabled);

		
		if( (wlan_mode == AP_MODE || wlan_mode == AP_WDS_MODE) && (rptEnabled == 1))
		{
			sprintf(ifname,"wlan%d-vxd",wlan_idx);
			vwlan_idx = NUM_VWLAN_INTERFACE;
		}
		else
		{
			sprintf(ifname,"wlan%d",wlan_idx);
			vwlan_idx = 0;
		}
		
		if(wlan_idx == 0)
		{		
			profile_num_id = MIB_PROFILE_NUM1;
			profile_tbl_id = MIB_PROFILE_TBL1;
			profile_enabled_id = MIB_PROFILE_ENABLED1;
		}
		else
		{
			profile_num_id = MIB_PROFILE_NUM2;
			profile_tbl_id = MIB_PROFILE_TBL2;
			profile_enabled_id = MIB_PROFILE_ENABLED2;
		}

		apmib_set(profile_enabled_id, (void *)&profileEnabledVal);
		


		if(addWlProfileHandler(wp, tmpBuf, wlan_idx) < 0){
	printf("\r\n Add wireless profile fail__[%s-%u]\r\n",__FILE__,__LINE__);
			//strcpy(tmpBuf, ("Add wireless profile fail!"));
			//goto ss_err;
		}

		sprintf(iwprivCmd,"iwpriv %s set_mib ap_profile_enable=%d",ifname, profileEnabledVal);
		system(iwprivCmd);
		
		sprintf(iwprivCmd,"iwpriv %s set_mib ap_profile_num=0",ifname);
		system(iwprivCmd);

		apmib_get(profile_num_id, (void *)&entryNum);

		for(profileIdx=1; profileIdx<=entryNum;profileIdx++)
		{
			memset(iwprivCmd, 0x00, sizeof(iwprivCmd));
			memset(&entry, 0x00, sizeof(WLAN_PROFILE_T));
			*((char *)&entry) = (char)profileIdx;
			apmib_get(profile_tbl_id, (void *)&entry);
		



		
		
		
		
			translate_control_code_sprintf(entry.ssid);
			translate_control_code_sprintf(entry.wpaPSK);
			//iwpriv wlan0 set_mib ap_profile_add="open-ssid",0,0
			if(entry.encryption == ENCRYPT_DISABLED)
			{
				sprintf(iwprivCmd,"iwpriv %s set_mib ap_profile_add=\"%s\",%d,%d",ifname,entry.ssid,0,0);
			}
			else if(entry.encryption == WEP64 || entry.encryption == WEP128)
			{
				char tmp1[400];
				if (entry.encryption == WEP64)			
					sprintf(tmp1,"%d,%d,%02x%02x%02x%02x%02x,%02x%02x%02x%02x%02x,%02x%02x%02x%02x%02x,%02x%02x%02x%02x%02x", 
						entry.auth,
						entry.wep_default_key,
						entry.wepKey1[0],entry.wepKey1[1],entry.wepKey1[2],entry.wepKey1[3],entry.wepKey1[4],
						entry.wepKey2[0],entry.wepKey2[1],entry.wepKey2[2],entry.wepKey2[3],entry.wepKey2[4],
						entry.wepKey3[0],entry.wepKey3[1],entry.wepKey3[2],entry.wepKey3[3],entry.wepKey3[4],
						entry.wepKey4[0],entry.wepKey4[1],entry.wepKey4[2],entry.wepKey4[3],entry.wepKey4[4]);
				else
					sprintf(tmp1,"%d,%d,%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x,%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x,%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x,%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x", 
						entry.auth,
						entry.wep_default_key,
						entry.wepKey1[0],entry.wepKey1[1],entry.wepKey1[2],entry.wepKey1[3],entry.wepKey1[4],entry.wepKey1[5],entry.wepKey1[6],entry.wepKey1[7],entry.wepKey1[8],
						entry.wepKey1[9],entry.wepKey1[10],entry.wepKey1[11],entry.wepKey1[12],
						entry.wepKey2[0],entry.wepKey2[1],entry.wepKey2[2],entry.wepKey2[3],entry.wepKey2[4],entry.wepKey2[5],entry.wepKey2[6],entry.wepKey2[7],entry.wepKey2[8],
						entry.wepKey2[9],entry.wepKey2[10],entry.wepKey2[11],entry.wepKey2[12],
						entry.wepKey3[0],entry.wepKey3[1],entry.wepKey3[2],entry.wepKey3[3],entry.wepKey3[4],entry.wepKey3[5],entry.wepKey3[6],entry.wepKey3[7],entry.wepKey3[8],
						entry.wepKey3[9],entry.wepKey3[10],entry.wepKey3[11],entry.wepKey3[12],
						entry.wepKey4[0],entry.wepKey4[1],entry.wepKey4[2],entry.wepKey4[3],entry.wepKey4[4],entry.wepKey4[5],entry.wepKey4[6],entry.wepKey4[7],entry.wepKey4[8],
						entry.wepKey4[9],entry.wepKey4[10],entry.wepKey4[11],entry.wepKey4[12]);	
				
				sprintf(iwprivCmd,"iwpriv %s set_mib ap_profile_add=\"%s\",%d,%s,",ifname,entry.ssid,entry.encryption, tmp1);
			}
			else if(entry.encryption == 2 || entry.encryption == 4 || entry.encryption == 6) //wpa or wpa2
			{
				char tmp1[400];
				sprintf(tmp1, "%d,%s", entry.wpa_cipher, entry.wpaPSK);
				sprintf(iwprivCmd,"iwpriv %s set_mib ap_profile_add=\"%s\",%d,0,\"%s\"",ifname,entry.ssid,entry.encryption,tmp1 );
			}

	
			system(iwprivCmd);
		}

		vwlan_idx = ori_vwlan_idx;
		apmib_update_web(CURRENT_SETTING);
		
		
	}

	submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page
	
	strTmp = req_get_cstream_var(wp, "restartNow", ""); 
	if(strTmp[0])
	{
		
		//apmib_update_web(CURRENT_SETTING);
#ifdef REBOOT_CHECK
		run_init_script_flag = 1;
#endif
#ifndef NO_ACTION
		run_init_script("all");
#endif
		REBOOT_WAIT(submitUrl);
		needReboot = 0;
	}
	else
	{
		send_redirect_perm(wp,submitUrl);
	}
	
}
#endif //#if defined(WLAN_PROFILE)



#endif //#ifdef REBOOT_CHECK
#ifdef SYS_DIAGNOSTIC
typedef enum { DIAGNOSTIC_DOING,DIAGNOSTIC_DONE,DIAGNOSTIC_INVALID_ARG}DIAGNOSTIC_STATUS;
#define SYS_DIAGNOSTIC_STATUS "/tmp/diagnostic_status"
void clean_diagnostic_status(void)
{
	struct stat status;
	if(stat(SYS_DIAGNOSTIC_STATUS,&status)==0)
	{
		unlink(SYS_DIAGNOSTIC_STATUS);
	}
}
DIAGNOSTIC_STATUS get_diagnostic_status(void)
{
	FILE *fp;
	char  buf[32] = {0};
	DIAGNOSTIC_STATUS ret;
	memset(buf,0,sizeof(buf));
	fp = fopen(SYS_DIAGNOSTIC_STATUS,"r");
	if(fp)
	{
		fgets(buf,sizeof(buf),fp);
		fclose(fp);
	}
	else
	{
		return DIAGNOSTIC_DOING;
	}
	if(!strncmp(buf,"doing",strlen("doing")))
	{
		ret = DIAGNOSTIC_DOING;
	}
	else if(!strncmp(buf,"done",strlen("done")))
	{
		ret = DIAGNOSTIC_DONE;
	}
	else if(!strncmp(buf,"invalid_arg",strlen("invalid_arg")))
	{
		ret = DIAGNOSTIC_INVALID_ARG;
	}
	return ret;
}
void formDiagnostic(request *wp, char *path, char *query)
{
	char *strRequest;
	char *str_diagType;
	char *str_wlanDiagType;
	char *submitUrl;
	char cmdBuf[256] = {0};
	char fileName[64] = {0};
	int val;
	DIAGNOSTIC_STATUS ret;
	strRequest = req_get_cstream_var(wp, ("sys_diagnostic"), "");
	str_diagType = req_get_cstream_var(wp, ("diag_type"), "");
	str_wlanDiagType = req_get_cstream_var(wp, ("wlan_diag_type"), "");
	submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page
	strcpy(fileName,"/sys_diagnostic.txt");
	if(strRequest[0])
	{
		if(!strcmp(str_diagType,"0"))/*system overview*/
		{
			strcpy(cmdBuf,"flash sys_diagnostic summary");
		}
		else if(!strcmp(str_diagType,"1"))/*wlan related*/
		{
			val = atoi(str_wlanDiagType);
			switch(val)
			{
				case 1:
					strcpy(cmdBuf,"flash sys_diagnostic wlan_scan");
					break;
				case 2:
					strcpy(cmdBuf,"flash sys_diagnostic wlan_connect");
					break;
				case 3:
					strcpy(cmdBuf,"flash sys_diagnostic wlan_throughput");
					break;
				default:
					break;
			}
		}
		clean_diagnostic_status();
		system(cmdBuf);
		while(1)
		{
			ret = get_diagnostic_status();
			if(DIAGNOSTIC_DOING == ret)
			{
				sleep(1);
				continue;
			}
			else if(DIAGNOSTIC_DONE == ret || DIAGNOSTIC_INVALID_ARG == ret)
			{
				break;
			}
		}
		if(DIAGNOSTIC_DONE == ret)
		{
			#ifdef CONFIG_RTL_WEBPAGES_IN_ROOTFS
			sprintf(cmdBuf,"rm -f /var%s",fileName);
			#else
			sprintf(cmdBuf,"rm -f /web%s",fileName);
			#endif
			system(cmdBuf);
			#ifdef CONFIG_RTL_WEBPAGES_IN_ROOTFS
			sprintf(cmdBuf,"cp /tmp/dumpDiagnosticLog.txt /var%s",fileName);
			#else
			sprintf(cmdBuf,"cp /tmp/dumpDiagnosticLog.txt /tmp%s",fileName);
			#endif
			system(cmdBuf);
			send_redirect_perm(wp, fileName);
		}
		else if(DIAGNOSTIC_INVALID_ARG == ret)
		{
			ERR_MSG("Invalid usage!\n");
		}
		return;
	}
	return;
}
#endif
void formSysLog(request *wp, char *path, char *query)
{
	char *submitUrl, *tmpStr;
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch
	//	char tmpBuf[100];
		char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	//WNC-JDR230-MRXXXX-YUAN-I-CHOU-20130103, Apply Realtek SDK 3.3.1 Alpha Patch End
	int enabled=0, rt_enabled; //WNC-NMR0000-Rita-20130305-Error_453-fix warnings of cppcheck (uninitialized value).
	struct in_addr ipAddr ;
	
	submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page

	tmpStr = req_get_cstream_var(wp, ("clear"), "");  
	if(tmpStr[0]){
		snprintf(tmpBuf, 100, "echo \" \" > %s", "/var/log/messages");
		system(tmpBuf);
		//### add by sen_liu 2011.4.21 sync the system log update (enlarge from 1 pcs to 8 pcs) to  SDKv2.5 from kernel 2.4
#ifdef RINGLOG
		system("rm /var/log/messages.* >/dev/null 2>&1");
#endif
		//### end
		send_redirect_perm(wp, submitUrl);
		return;
	}

/*
 *	NOTE: If variable enabled (MIB_SCRLOG_ENABLED) bitmask modify(bitmap),
 *	 	Please modify driver rtl8190 reference variable (dot1180211sInfo.log_enabled in linux-2.4.18/drivers/net/rtl8190/8190n_cfg.h) 
 */
	apmib_get(MIB_SCRLOG_ENABLED, (void *)&enabled);
	
	tmpStr = req_get_cstream_var(wp, ("logEnabled"), "");  
	if(!strcmp(tmpStr, "ON")) {
		enabled |= 1;

		tmpStr = req_get_cstream_var(wp, ("syslogEnabled"), "");
		if(!strcmp(tmpStr, "ON"))
			enabled |= 2;		
		else
			enabled &= ~2;
		
		tmpStr = req_get_cstream_var(wp, ("wlanlogEnabled"), "");
		if(!strcmp(tmpStr, "ON")) 
			enabled |= 4;	
		else
			enabled &= ~4;
		
#ifdef HOME_GATEWAY
#ifdef DOS_SUPPORT
		tmpStr = req_get_cstream_var(wp, ("doslogEnabled"), "");
		if(!strcmp(tmpStr, "ON")) 
			enabled |= 8;		
		else
			enabled &= ~8;		
#endif
#endif

#ifdef CONFIG_RTK_MESH
		tmpStr = req_get_cstream_var(wp, ("meshlogEnabled"), "");
		if(!strcmp(tmpStr, "ON")) 
			enabled |= 16;	
		else
			enabled &= ~16;
#endif

	}
	else
		enabled &= ~1;						

	if ( apmib_set(MIB_SCRLOG_ENABLED, (void *)&enabled) == 0) {
		strcpy(tmpBuf, ("Set log enable error!"));
		goto setErr;
	}
	
	if(enabled & 1){
		tmpStr = req_get_cstream_var(wp, ("rtLogEnabled"), "");  

		if(!strcmp(tmpStr, "ON"))
			rt_enabled= 1;
		else
			rt_enabled= 0;
		if ( apmib_set(MIB_REMOTELOG_ENABLED, (void *)&rt_enabled) == 0) {
			strcpy(tmpBuf, ("Set remote log enable error!"));
			goto setErr;
		}

		tmpStr = req_get_cstream_var(wp, ("logServer"), "");  
		if(tmpStr[0]){
			inet_aton(tmpStr, &ipAddr);
			if ( apmib_set(MIB_REMOTELOG_SERVER, (void *)&ipAddr) == 0) {
				strcpy(tmpBuf, ("Set remote log server error!"));
				goto setErr;
			}
		}
	}
	apmib_update_web(CURRENT_SETTING);	
#ifdef REBOOT_CHECK
	run_init_script_flag = 1;
#endif
#ifndef NO_ACTION
	run_init_script("all");
#endif
	OK_MSG(submitUrl);
	return;

setErr:
	ERR_MSG(tmpBuf);
}

static int process_msg(char *msg, int is_wlan_only)
{
	char *p1, *p2;
	p1 = strstr(msg, "rlx-linux"); // host name
	if (p1 == NULL)
		return 0;

#ifdef CONFIG_RTK_MESH	
	if (is_wlan_only == 4) {
		p2 = strstr(p1, "msh");
		if (p2 && p2[4]==':')
			memcpy(p1, p2, strlen(p2)+1);
		else
			return 0;

	}else	
#endif

	if (is_wlan_only == 3){
		p2 = strstr(p1, "DoS");
		if (p2 && p2[3]==':'){
			memcpy(p1, p2, strlen(p2)+1);
		}else{
			p2 = strstr(p1, "wlan");	
			if ((p2 && p2[5]==':') || (p2 && p2[9]==':'))	{// vxd interface
				memcpy(p1, p2, strlen(p2)+1);
			}else	
				return 0;
			}	
	}else if (is_wlan_only == 2){
		p2 = strstr(p1, "DoS");
		if (p2 && p2[3]==':')
			memcpy(p1, p2, strlen(p2)+1);
		else
			return 0;

	}else{
		p2 = strstr(p1, "wlan");	
		if ((p2 && p2[5]==':') ||
			 (p2 && p2[9]==':'))	// vxd interface
			memcpy(p1, p2, strlen(p2)+1);
		else {
			if (is_wlan_only)
				return 0;
			
			p2 = strstr(p1, "kernel: ");
			if (p2 == NULL)
				return 0;
			memcpy(p1, p2+7, strlen(p2)-7+1);
		}
	}
	return 1;
}


int sysLogList(request *wp, int argc, char **argv)
{
	FILE *fp;
	char  buf[200];
	int nBytesSent=0;
	int enabled=0; //WNC-NMR0000-Rita-20130305-Error_416-fix warnings of cppcheck (uninitialized value).

//### add by sen_liu 2011.4.21 sync the system log update (enlarge from 1 pcs to 8 pcs) to  SDKv2.5 from kernel 2.4
#ifdef RINGLOG
	char logname[32];
	int lognum = LOG_SPLIT;
#endif

//### end
	apmib_get(MIB_SCRLOG_ENABLED, (void *)&enabled);
	if ( !(enabled & 1))
		goto err1;
//### add by sen_liu 2011.4.21 sync the system log update (enlarge from 1 pcs to 8 pcs) to  SDKv2.5 from kernel 2.4
#ifdef RINGLOG
		fp = fopen("/var/log/log_split", "r");
		if (fp == NULL)
			goto err1;
		fgets(buf,200,fp);
		lognum = atoi(buf);
		fclose(fp);
	
	while (lognum >= 0)
	{
		if (lognum > 0)
			snprintf(logname, 32, "/var/log/messages.%d", lognum-1);
		else if (lognum == 0)
			snprintf(logname, 32, "/var/log/messages");
		else
			goto err1;
	
		fp = fopen(logname, "r");
		if (fp == NULL)
			goto next_log;
#else
//### end
	fp = fopen("/var/log/messages", "r");
	if (fp == NULL)
		goto err1;
#endif
        
	while(fgets(buf,200,fp)){
		int ret=0;
		if (enabled&2) // system all
			ret = process_msg(buf, 0);
		else {
			if((enabled&0xC) == 0xC){ //both wlan and DoS
				ret = process_msg(buf, 3);
			}else if (enabled&4)	// wlan only
				ret = process_msg(buf, 1);
			else if (enabled&8)	//DoS only
				ret = process_msg(buf, 2);

#ifdef CONFIG_RTK_MESH			
			 if(enabled&16 && ret==0)	// mesh only
				ret = process_msg(buf, 4);
#endif

		}
		if (ret==0)
			continue;
		nBytesSent += req_format_write(wp, ("%s"), buf);
	}
	fclose(fp);

//### add by sen_liu 2011.4.21 sync the system log update (enlarge from 1 pcs to 8 pcs) to	SDKv2.5 from kernel 2.4
#ifdef RINGLOG
next_log:
	lognum--;
}
#endif
//### end
err1:
	return nBytesSent;
}

#ifdef  CONFIG_APP_SMTP_CLIENT
void formSmtpClient(request *wp, char *path, char *query)
{
	extern char* p_email_infor;
	char *send_form, *password,*send_to,*theme,*body, *attachment;
	char *timing,*year,*month,*day,*hour,*minute,*syslog_check,*usbstoragemsg,*now_time;
	char *tmpStr;
	int  enable,i,status;
	char tmpEmpty[] = "OFF";
	char tmpBuf[500];

	
	tmpStr= req_get_cstream_var(wp, ("smtpClientEnabled"), "");  
	if(!strcmp(tmpStr, "ON"))
		enable = 1;
	else
		enable = 0;
	/*if ( apmib_set(MIB_SMTP_CLIENT_ENABLED, (void *)&rt_enabled) == 0) {
			strcpy(tmpBuf, ("Set smtp client enable error!"));
			ERR_MSG(tmpBuf);
			return;
	}*/
	
	if(enable){
		syslog_check= req_get_cstream_var(wp, ("syslogmsg"), ""); 
		if(!strcmp(syslog_check, ""))
			syslog_check = tmpEmpty;
		send_form= req_get_cstream_var(wp, ("sendFrom"), "");
		if(!strcmp(send_form, ""))
			goto ipput_error;
		password= req_get_cstream_var(wp, ("password"), "");
		if(!strcmp(password, ""))
			goto ipput_error;
		send_to= req_get_cstream_var(wp, ("sendTo"), "");
		if(!strcmp(send_to, ""))
			goto ipput_error;
		theme= req_get_cstream_var(wp, ("theme"), "");
		if(!strcmp(theme, ""))
			theme = tmpEmpty;
		body = req_get_cstream_var(wp, ("msg"), "");
		if(!strcmp(body, ""))
			body = tmpEmpty;
		attachment = req_get_cstream_var(wp, ("attachment"), "");
		if(!strcmp(attachment, ""))
			attachment = tmpEmpty;
		usbstoragemsg = req_get_cstream_var(wp, ("usbstoragemsg"), "");
		if(!strcmp(usbstoragemsg, ""))
			usbstoragemsg = tmpEmpty;
		timing = req_get_cstream_var(wp, ("timing"), "");
		if(!strcmp(timing, "")){
			timing = tmpEmpty;
			year = tmpEmpty;
			month = tmpEmpty;
			day = tmpEmpty;
			hour = tmpEmpty;
			minute = tmpEmpty;
			now_time = tmpEmpty;
		}
		else{
			year = req_get_cstream_var(wp, ("year"), "");
			month = req_get_cstream_var(wp, ("month"), "");
			day = req_get_cstream_var(wp, ("day"), "");
			hour = req_get_cstream_var(wp, ("hour"), "");
			minute = req_get_cstream_var(wp, ("minute"), "");
			now_time  = req_get_cstream_var(wp, ("now_time"), "");
		}
		
		sprintf(tmpBuf,"%s \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" \"%s\" ","smtpclient",send_form,password,send_to,syslog_check,timing,year,month,day,hour,minute,now_time,theme,body,attachment,usbstoragemsg);
		status = system( tmpBuf);
	}
	strcpy(tmpBuf, ("Send Email End!"));
	//OK_MSG(tmpBuf);
	ERR_MSG(tmpBuf);
	return;
	
	ipput_error:
		strcpy(tmpBuf, ("Send Email Error!"));
		//OK_MSG(tmpBuf);
		ERR_MSG(tmpBuf);
}
#endif


#ifdef HOME_GATEWAY
#ifdef DOS_SUPPORT
void formDosCfg(request *wp, char *path, char *query)
{
	char	*submitUrl, *tmpStr;
	char	tmpBuf[100];
	int	floodCount=0,blockTimer=0;
	long	enabled = 0;

	submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page

	apmib_get(MIB_DOS_ENABLED, (void *)&enabled);

	tmpStr = req_get_cstream_var(wp, ("dosEnabled"), "");
	if(!strcmp(tmpStr, "ON")) {
		enabled |= 1;

		tmpStr = req_get_cstream_var(wp, ("sysfloodSYN"), "");
		if(!strcmp(tmpStr, "ON")) {
			enabled |= 2;
			tmpStr = req_get_cstream_var(wp, ("sysfloodSYNcount"), "");
			string_to_dec(tmpStr,&floodCount);
			if ( apmib_set(MIB_DOS_SYSSYN_FLOOD, (void *)&floodCount) == 0) {
				strcpy(tmpBuf, ("Set DoS SYSSYN_FLOOD error!"));
				goto setErr;
			}
		}
		else{
			enabled &= ~2;
		}
		tmpStr = req_get_cstream_var(wp, ("sysfloodFIN"), "");
		if(!strcmp(tmpStr, "ON")) {
			enabled |= 4;
			tmpStr = req_get_cstream_var(wp, ("sysfloodFINcount"), "");
			string_to_dec(tmpStr,&floodCount);
			if ( apmib_set(MIB_DOS_SYSFIN_FLOOD, (void *)&floodCount) == 0) {
				strcpy(tmpBuf, ("Set DoS SYSFIN_FLOOD error!"));
				goto setErr;
			}
		}
		else{
			enabled &= ~4;
		}
		tmpStr = req_get_cstream_var(wp, ("sysfloodUDP"), "");
		if(!strcmp(tmpStr, "ON")) {
			enabled |= 8;
			tmpStr = req_get_cstream_var(wp, ("sysfloodUDPcount"), "");
			string_to_dec(tmpStr,&floodCount);
			if ( apmib_set(MIB_DOS_SYSUDP_FLOOD, (void *)&floodCount) == 0) {
				strcpy(tmpBuf, ("Set DoS SYSUDP_FLOOD error!"));
				goto setErr;
			}
		}
		else{
			enabled &= ~8;
		}
		tmpStr = req_get_cstream_var(wp, ("sysfloodICMP"), "");
		if(!strcmp(tmpStr, "ON")) {
			enabled |= 0x10;
			tmpStr = req_get_cstream_var(wp, ("sysfloodICMPcount"), "");
			string_to_dec(tmpStr,&floodCount);
			if ( apmib_set(MIB_DOS_SYSICMP_FLOOD, (void *)&floodCount) == 0) {
				strcpy(tmpBuf, ("Set DoS SYSICMP_FLOOD error!"));
				goto setErr;
			}
		}
		else{
			enabled &= ~0x10;
		}
		tmpStr = req_get_cstream_var(wp, ("ipfloodSYN"), "");
		if(!strcmp(tmpStr, "ON")) {
			enabled |= 0x20;
			tmpStr = req_get_cstream_var(wp, ("ipfloodSYNcount"), "");
			string_to_dec(tmpStr,&floodCount);
			if ( apmib_set(MIB_DOS_PIPSYN_FLOOD, (void *)&floodCount) == 0) {
				strcpy(tmpBuf, ("Set DoS PIPSYN_FLOOD error!"));
				goto setErr;
			}
		}
		else{
			enabled &= ~0x20;
		}
		tmpStr = req_get_cstream_var(wp, ("ipfloodFIN"), "");
		if(!strcmp(tmpStr, "ON")) {
			enabled |= 0x40;
			tmpStr = req_get_cstream_var(wp, ("ipfloodFINcount"), "");
			string_to_dec(tmpStr,&floodCount);
			if ( apmib_set(MIB_DOS_PIPFIN_FLOOD, (void *)&floodCount) == 0) {
				strcpy(tmpBuf, ("Set DoS PIPFIN_FLOOD error!"));
				goto setErr;
			}
		}
		else{
			enabled &= ~0x40;
		}
		tmpStr = req_get_cstream_var(wp, ("ipfloodUDP"), "");
		if(!strcmp(tmpStr, "ON")) {
			enabled |= 0x80;
			tmpStr = req_get_cstream_var(wp, ("ipfloodUDPcount"), "");
			string_to_dec(tmpStr,&floodCount);
			if ( apmib_set(MIB_DOS_PIPUDP_FLOOD, (void *)&floodCount) == 0) {
				strcpy(tmpBuf, ("Set DoS PIPUDP_FLOOD error!"));
				goto setErr;
			}
		}
		else{
			enabled &= ~0x80;
		}
		tmpStr = req_get_cstream_var(wp, ("ipfloodICMP"), "");
		if(!strcmp(tmpStr, "ON")) {
			enabled |= 0x100;
			tmpStr = req_get_cstream_var(wp, ("ipfloodICMPcount"), "");
			string_to_dec(tmpStr,&floodCount);
			if ( apmib_set(MIB_DOS_PIPICMP_FLOOD, (void *)&floodCount) == 0) {
				strcpy(tmpBuf, ("Set DoS PIPICMP_FLOOD error!"));
				goto setErr;
			}
		}
		else{
			enabled &= ~0x100;
		}
		tmpStr = req_get_cstream_var(wp, ("TCPUDPPortScan"), "");
		if(!strcmp(tmpStr, "ON")) {
			enabled |= 0x200;

			tmpStr = req_get_cstream_var(wp, ("portscanSensi"), "");
			if( tmpStr[0]=='1' ) {
				enabled |= 0x800000;
			}
			else{
				enabled &= ~0x800000;
			}
		}
		else{
			enabled &= ~0x200;
		}
		tmpStr = req_get_cstream_var(wp, ("ICMPSmurfEnabled"), "");
		if(!strcmp(tmpStr, "ON")) {
			enabled |= 0x400;
		}
		else{
			enabled &= ~0x400;
		}
		tmpStr = req_get_cstream_var(wp, ("IPLandEnabled"), "");
		if(!strcmp(tmpStr, "ON")) {
			enabled |= 0x800;
		}
		else{
			enabled &= ~0x800;
		}
		tmpStr = req_get_cstream_var(wp, ("IPSpoofEnabled"), "");
		if(!strcmp(tmpStr, "ON")) {
			enabled |= 0x1000;
		}
		else{
			enabled &= ~0x1000;
		}
		tmpStr = req_get_cstream_var(wp, ("IPTearDropEnabled"), "");
		if(!strcmp(tmpStr, "ON")) {
			enabled |= 0x2000;
		}
		else{
			enabled &= ~0x2000;
		}
		tmpStr = req_get_cstream_var(wp, ("PingOfDeathEnabled"), "");
		if(!strcmp(tmpStr, "ON")) {
			enabled |= 0x4000;
		}
		else{
			enabled &= ~0x4000;
		}
		tmpStr = req_get_cstream_var(wp, ("TCPScanEnabled"), "");
		if(!strcmp(tmpStr, "ON")) {
			enabled |= 0x8000;
		}
		else{
			enabled &= ~0x8000;
		}
		tmpStr = req_get_cstream_var(wp, ("TCPSynWithDataEnabled"), "");
		if(!strcmp(tmpStr, "ON")) {
			enabled |= 0x10000;
		}
		else{
			enabled &= ~0x10000;
		}
		tmpStr = req_get_cstream_var(wp, ("UDPBombEnabled"), "");
		if(!strcmp(tmpStr, "ON")) {
			enabled |= 0x20000;
		}
		else{
			enabled &= ~0x20000;
		}
		tmpStr = req_get_cstream_var(wp, ("UDPEchoChargenEnabled"), "");
		if(!strcmp(tmpStr, "ON")) {
			enabled |= 0x40000;
		}
		else{
			enabled &= ~0x40000;
		}
		tmpStr = req_get_cstream_var(wp, ("sourceIPblock"), "");
		if(!strcmp(tmpStr, "ON")) {
			enabled |= 0x400000;
			tmpStr = req_get_cstream_var(wp, ("IPblockTime"), "");
			string_to_dec(tmpStr,&blockTimer);
			if ( apmib_set(MIB_DOS_BLOCK_TIME, (void *)&blockTimer) == 0) {
				strcpy(tmpBuf, ("Set DoS IP Block Timer error!"));
				goto setErr;
			}
		}
		else{
			enabled &= ~0x400000;
		}
	}
	else
		enabled = 0;

	if ( apmib_set(MIB_DOS_ENABLED, (void *)&enabled) == 0) {
		strcpy(tmpBuf, ("Set DoS enable error!"));
		goto setErr;
	}

	apmib_update_web(CURRENT_SETTING);

#ifdef REBOOT_CHECK
	run_init_script_flag = 1;
#endif
#ifndef NO_ACTION
	run_init_script("all");
#endif

	OK_MSG(submitUrl);
	return;

setErr:
	ERR_MSG(tmpBuf);
}
#endif
#endif


#ifdef LOGIN_URL

#define MAX_USER	5
#define ACCESS_TIMEOUT	 300	// 5m

#define MAGIC_NUMER	7168186

struct user_profile {
	int flag;
	time_t last_time;
	char ipaddr[32];		
};

static struct user_profile users[MAX_USER];

///////////////////////////////////////////////////////////////////
static void delete_user(request *wp)
{
	int i;
	for (i=0; i<MAX_USER; i++) {
		if (users[i].flag == MAGIC_NUMER && !strcmp(wp->ipaddr, users[i].ipaddr)) {
			users[i].flag = 0;
			return;
		}			
	}
}

///////////////////////////////////////////////////////////////////
static int add_user(request *wp)
{
	int i;
	for (i=0; i<MAX_USER; i++) {
		if (users[i].flag == MAGIC_NUMER && strcmp(wp->ipaddr, users[i].ipaddr) &&
			((unsigned long)wp->timestamp)-((unsigned long)users[i].last_time) < ACCESS_TIMEOUT )
			continue;
				
		users[i].flag = MAGIC_NUMER;		
		users[i].last_time = wp->timestamp;	
		strlcpy(users[i].ipaddr, wp->ipaddr, sizeof(users[i].ipaddr));	//bug2426.			
		return 0;
	}

	printf("boa: add_user error (exceed max connection)!\n");

	return -1;
}

///////////////////////////////////////////////////////////////////
int is_valid_user(request *wp)
{
	int i;
	for (i=0; i<MAX_USER; i++) {
		if (users[i].flag == MAGIC_NUMER && !strcmp(wp->ipaddr, users[i].ipaddr)) {
			if (((unsigned long)wp->timestamp)-((unsigned long)users[i].last_time) > ACCESS_TIMEOUT)
				return -1; // timeout
			return 1;
		}
	}

	return 0; // not a valid user
}

///////////////////////////////////////////////////////////////////
void formLogin(request *wp, char *path, char *query)
{
	char *strUser, *strPassword, *userpass;
	char tmpbuf[200];

	strUser = req_get_cstream_var(wp, ("username"), "");
	strPassword = req_get_cstream_var(wp, ("password"), "");
	if ( strUser[0] && !strPassword[0] ) {
		strlcpy(tmpbuf, ("ERROR: Password cannot be empty."), sizeof(tmpbuf));
		goto login_err;
	}

	if (!umUserExists(strUser)) {
		strlcpy(tmpbuf, ("ERROR: Access denied, unknown user!"), sizeof(tmpbuf));
		goto login_err;
	}
	userpass = umGetUserPassword(strUser);
	if (userpass) {
		if (strcmp(strPassword, userpass) != 0) {
			strlcpy(tmpbuf, ("ERROR: Access denied, unknown user!"), sizeof(tmpbuf));
			goto login_err;
		}
	}

	if (add_user(wp) < 0) {
		strlcpy(tmpbuf, ("ERROR: Exceed max user number!"), sizeof(tmpbuf));
		goto login_err;
	}

	/* WNC-NMR0000-JOE-PENG-20130910-Fix bug that google chrome login fail */
	send_redirect_perm(wp, ("/home.htm"));
	return;

login_err:
	ERR_MSG(tmpbuf);
}
#endif // LOGIN_URL

#ifdef CONFIG_CPU_UTILIZATION
void formCpuUtilization(request *wp, char *path, char *query)
{
	char *submitUrl, *tmpStr;
	int enable, interval, oldStatus;
	char tmpbuf[200];

	submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page
	
	tmpStr = req_get_cstream_var(wp, ("enableCpuUtilization"), "");
	if(!strcmp(tmpStr, "ON"))
		enable = 1 ;
	else 
		enable = 0 ;

	apmib_get( MIB_ENABLE_CPU_UTILIZATION, (void *)&oldStatus );
	if ( oldStatus!=enable && apmib_set( MIB_ENABLE_CPU_UTILIZATION, (void *)&enable) == 0) {
		strcpy(tmpbuf, ("Set cpu utilization enabled flag error!"));
		goto setErr_end;
	}
	
	tmpStr = req_get_cstream_var(wp, ("cpuUtilizationInterval"), "");
	if(tmpStr[0])
	{
		FILE* fp;
		
		interval = atoi(tmpStr);
		if ( apmib_set( MIB_CPU_UTILIZATION_INTERVAL, (void *)&interval) == 0) {
			strcpy(tmpbuf, ("Set cpu utilization interval error!"));
			goto setErr_end;
		}
		fp = fopen("/var/cpu_info.conf", "w+");
		if( fp!=NULL ){
			fprintf(fp, "interval: %d", interval);
			fclose(fp);
		}
		fp = fopen("/var/run/cpu.pid", "r");
		if( fp!=NULL ){
			unsigned int pid; 
			fscanf(fp, "%ud", &pid);
			kill((pid_t)pid, 10);
			fclose(fp);
		}
	}

	apmib_update_web(CURRENT_SETTING);

	OK_MSG(submitUrl);
	return;

setErr_end:
	ERR_MSG(tmpbuf);
}

#endif // CONFIG_CPU_UTILIZATION

#if defined(POWER_CONSUMPTION_SUPPORT)
unsigned int pre_cpu_d4, pre_time_secs, max_cpu_delta=0;
unsigned int ethBytesCount_previous[5] = {0};

/* http://www.360doc.com/content/070213/11/17255_365683.html */
int getPowerConsumption(request *wp, int argc, char **argv)
{
	//char dev[80];
	//char *devPtr;
	FILE *stream;
	int i=1;
	//int j;
	//char logbuf[500];
	//unsigned int rxbytes=0,rxpackets=0,rxerrs=0,rxdrops=0,txbytes=0,txpackets=0,txerrs=0,txdrops=0,txcolles=0;
	//unsigned int txeth0packets=0;
	//unsigned int tmp1,tmp2,tmp3,tmp4;
	char askfor[20];

//	unsigned int totalPwrCon = 0;
	unsigned int totalPwrCon = (rand()%2 ? 10 :0);
	
	typedef enum { NO_LINK=0, NORMAL_LINK=1, EEE_LINK=2} ETHERNET_LINK_T;
	unsigned short isLink_eth0[5]={0};
	unsigned short ethLinkNum= 0, ethEeeLinkNum = 0;
	unsigned short perEthPwrCon = PWRCON_PER_ETHERNET;
	unsigned int perEthEeeMinus = PWRCON_PER_EEE_ETHERNET_LINK_MINUS; // mw*100
	unsigned int perEthEeePwrCon = PWRCON_PER_EEE_ETHERNET; // mw*100/Mbps
	unsigned int ethThroughPut[5] = {0};
	unsigned int ethEeeThroughPut_Total = 0;
	int ethPwrCon_Total = 0;
	
	typedef enum { CHIP_UNKNOWN=0, CHIP_RTL8188C=1, CHIP_RTL8192C=2} CHIP_VERSION_T;
	CHIP_VERSION_T chipVersion = CHIP_UNKNOWN;	
	
	typedef enum { CPU_NORMAL=0, CPU_SUSPEND=1} CPU_MODE_T;
	CPU_MODE_T cpuMode = CPU_NORMAL;
	unsigned short cpuPwrCon[3][2] = { {0,0},{PWRCON_CPU_NORMAL_88C,PWRCON_CPU_SUSPEND_88C},{PWRCON_CPU_NORMAL_92C,PWRCON_CPU_SUSPEND_92C} }; // 3:chipVersion; 2:cpu mode
	
	typedef enum { WLAN_OFF=0, WLAN_NO_LINK=1, WLAN_LINK=2} WLAN_STATE_T;
	WLAN_STATE_T wlanState = WLAN_OFF; 
	unsigned short wlanStatePwrCon[3][3] = { {0,0,0},{PWRCON_WLAN_OFF_88C,PWRCON_WLAN_NOLINK_88C,PWRCON_WLAN_LINK_88C},{PWRCON_WLAN_OFF_92C,PWRCON_WLAN_NOLINK_92C,PWRCON_WLAN_LINK_92C}}; //3:chipVersion; 3:wlanState
	int wlanOff = 0;
	
	typedef enum { WLAN_MCS8_15=0, WLAN_MCS0_7=1, WLAN_OFDM=2, WLAN_CCK=3} WLAN_TRAFFIC_STATE_T;
	WLAN_TRAFFIC_STATE_T wlanTrafficState = WLAN_MCS8_15;
	unsigned int wlanTrafficStatePwrCon[3][4] = { {0,0,0,0},{PWRCON_WLAN_TRAFFIC_MCS8_15_88C,PWRCON_WLAN_TRAFFIC_MCS0_7_88C,PWRCON_WLAN_TRAFFIC_OFDM_88C,PWRCON_WLAN_TRAFFIC_CCK_88C},{PWRCON_WLAN_TRAFFIC_MCS8_15_92C,PWRCON_WLAN_TRAFFIC_MCS0_7_92C,PWRCON_WLAN_TRAFFIC_OFDM_92C,PWRCON_WLAN_TRAFFIC_CCK_92C}}; //3:chipVersion; 4:wlanTrafficState
	unsigned int wlanTrafficStatePwrConZ[3][28] = { 
		{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
		{1000,1099,1188,1454,2014,3254,4271,8039,1082,1176,1289,1681,2768,4482,6275,10458,719,919,1225,1697,2377,3735,5038,7557,938,1681,2894,5865},
		{1000,1099,1188,1454,2014,3254,4271,8039,1082,1176,1289,1681,2768,4482,6275,10458,1000,1278,1705,2360,3306,5195,7008,10511,938,1681,2894,5865}
	};//3:chipVersion; 28:DataRate MCS15~1
	unsigned int wlanTrafficZ = 0;
	
	unsigned int tx_average = 0;
	unsigned short tx_average_multiply2 = 0;
	unsigned int rx_average = 0;
	unsigned int wlanTrafficStatePwrCon_Total;
		
	unsigned int cpuUtilizationPwrCon[3] = { 0,PWRCON_CPU_UTILIZATION_88C,PWRCON_CPU_UTILIZATION_92C}; //3:chipVersion;
	unsigned short cpu_utilization=0;
	
	unsigned short debug_check = 0;
	
	time_t current_secs;
	unsigned int time_delta = 1;						
#if 0	
	for(i=0 ;i<3;i++)
		for(j=0; j<1; j++)
			fprintf(stderr,"\r\n cpuUtilizationPwrCon[%d][%d]=[%f]",i,j,cpuUtilizationPwrCon[i][j]);
#endif			

	//get current system time in second.
	time(&current_secs);
	if(pre_time_secs == 0) //first time
	{
		pre_time_secs = (int)(current_secs);
		time_delta = 1;
	}
	else
	{
		time_delta = (int)(current_secs) - (int)(pre_time_secs);
		pre_time_secs = (int)(current_secs);
	}

		
	//get chipVersion
	stream = fopen ( "/var/pwrConDebug", "r" );
	if ( stream != NULL )
	{		
		char *strtmp;
		char line[100];				
		char strTmp[10];
		
		while (fgets(line, sizeof(line), stream))
		{
			strtmp = line;
			
			while(*strtmp == ' ')
			{
				strtmp++;
			}

			sscanf(strtmp,"%[01]",strTmp);

			debug_check=atoi(strTmp);
			
		}
		
		fclose ( stream );
	}

	
	if(debug_check)
		fprintf(stderr,"\r\n  === Pwr Con Debug ===");
	//get chipVersion
	chipVersion = getWLAN_ChipVersion();
#if 0	
	stream = fopen ( "/proc/wlan0/mib_rf", "r" );
	if ( stream != NULL )
	{		
		char *strtmp;
		char line[100];
								 
		while (fgets(line, sizeof(line), stream))
		{
			
			strtmp = line;
			while(*strtmp == ' ')
			{
				strtmp++;
			}
			

			if(strstr(strtmp,"RTL8192SE") != 0)
			{
				chipVersion = CHIP_UNKNOWN;
			}
			else if(strstr(strtmp,"RTL8188C") != 0)
			{
				if(debug_check)
					fprintf(stderr,"\r\n [%s]",strtmp);				
				chipVersion = CHIP_RTL8188C;
			}
			else if(strstr(strtmp,"RTL8192C") != 0)
			{
				if(debug_check)				
					fprintf(stderr,"\r\n [%s]",strtmp);				
				chipVersion = CHIP_RTL8192C;
			}
		}			
		fclose ( stream );
	}
#endif

	if(debug_check)
	{
		fprintf(stderr,"\r\n chipVersion=[%u]",chipVersion);
		fprintf(stderr,"\r\n");
	}
	
	//get cpu mode
	stream = fopen ( "/proc/suspend_check", "r" );
	if ( stream != NULL )
	{		
		char *strtmp;
		char line[100];
		
		while (fgets(line, sizeof(line), stream))
		{			
			//enable=1, winsize=5(10), high=3200, low=2200, suspend=1
			strtmp = strstr(line,"suspend");
			if(strtmp != NULL)
			{
				
				//suspend=1
				if(debug_check)
					fprintf(stderr,"\r\n [%s]",strtmp);
				sscanf(strtmp,"%*[^=]=%u",&cpuMode);								
			}
			
		}			
		fclose ( stream );
	}
	if(debug_check)
	{
		fprintf(stderr,"\r\n cpuMode=[%u]",cpuMode);
		fprintf(stderr,"\r\n cpuPwrCon=[%u]",cpuPwrCon[chipVersion][cpuMode]);
		fprintf(stderr,"\r\n");
	}
	totalPwrCon+=cpuPwrCon[chipVersion][cpuMode];
	
	//get Eth0 port link and bytesCount
	for(i=0; i<5; i++)
	{
		unsigned int ethBytesCount[5] = {0};
		
		isLink_eth0[i]=getEth0PortLink(i);
		if(isLink_eth0[i])
		{
			isLink_eth0[i] = NORMAL_LINK;
			if(getEthernetEeeState(i))
				isLink_eth0[i] = EEE_LINK;			
	}
		else
		{
			isLink_eth0[i] = NO_LINK;
		}
		
		ethBytesCount[i] = getEthernetBytesCount(i);
		
		if(time_delta <= 0)
			time_delta = 1;
		ethThroughPut[i] = (ethBytesCount[i] - ethBytesCount_previous[i])/time_delta;		
		ethBytesCount_previous[i] = ethBytesCount[i];
	}
	
	for(i=0; i<5; i++)
	{
		if(isLink_eth0[i] == NORMAL_LINK)
		{
			ethLinkNum++;
		}
		else if(isLink_eth0[i] == EEE_LINK)
		{
			ethEeeLinkNum++;
			ethEeeThroughPut_Total += ethThroughPut[i];
		}						
	}
	ethEeeThroughPut_Total *= 8; // transfer to bits.
	
	ethPwrCon_Total += ethLinkNum*perEthPwrCon;
	ethPwrCon_Total -= (ethEeeLinkNum*perEthEeeMinus)/100;
	ethPwrCon_Total += (((float)ethEeeThroughPut_Total*perEthEeePwrCon)/100)/1000000;
	
	
	if(debug_check)
	{
		fprintf(stderr,"\r\n Eth Link State:%u-%u-%u-%u-%u", isLink_eth0[0],isLink_eth0[1],isLink_eth0[2],isLink_eth0[3],isLink_eth0[4]);
		fprintf(stderr,"\r\n Eth ThroughPut:%u-%u-%u-%u-%u (bits/sec)", ethThroughPut[0]*8,ethThroughPut[1]*8,ethThroughPut[2]*8,ethThroughPut[3]*8,ethThroughPut[4]*8);
		fprintf(stderr,"\r\n ethEeeThroughPut_Total: %u (bits/sec)",ethEeeThroughPut_Total);
		fprintf(stderr,"\r\n perEthPwrCon Total: (%u*%u)-(%u*%u)/100+(%u*%u)/100/10^6 = %u",ethLinkNum,perEthPwrCon,ethEeeLinkNum,perEthEeeMinus,ethEeeThroughPut_Total,perEthEeePwrCon,ethPwrCon_Total);
		fprintf(stderr,"\r\n");
	}
	totalPwrCon+=ethPwrCon_Total;

	//get wlan state
	apmib_get( MIB_WLAN_WLAN_DISABLED, (void *)&wlanOff);
	if(wlanOff)
		wlanState = WLAN_OFF;
	else
	{
		wlanState = updateWlanifState("wlan0");								
	}										
					
	
	if(debug_check)
					{
		fprintf(stderr,"\r\n wlanState=[%u]",wlanState);	
		fprintf(stderr,"\r\n wlanStatePwrCon = [%u]",wlanStatePwrCon[chipVersion][wlanState]);
		fprintf(stderr,"\r\n");
	}
						
	totalPwrCon+=wlanStatePwrCon[chipVersion][wlanState];
		
	// get wlan traffic power consumption
	if(wlanState == WLAN_LINK)
	{
			//get chipVersion
		stream = fopen ( "/proc/wlan0/stats", "r" );
		if ( stream != NULL )
		{		
			char *strtmp;
			char line[100];
			while (fgets(line, sizeof(line), stream))
			{
				char *p;
				strtmp = line;
				
				
				while(*strtmp == ' ')
					strtmp++;
				
				
				if(strstr(strtmp,"tx_avarage") != 0)
				{
					char str1[10];
					
					if(debug_check)																
						fprintf(stderr,"\r\n [%s]",strtmp);
						
					//tx_avarage:    1449
					sscanf(strtmp, "%*[^:]:%s",str1);
					
					p = str1;
					while(*p == ' ')
						p++;
					
					tx_average = atoi(p);	
					tx_average*=8; // bytes->bits
					
					if(debug_check)
						fprintf(stderr,"\r\n tx_average=[%u]",tx_average);
				}
				else if(strstr(strtmp,"rx_avarage") != 0)
				{
					char str1[10];
					
					if(debug_check)																
						fprintf(stderr,"\r\n [%s]",strtmp);
						
					//rx_avarage:    1449
					sscanf(strtmp, "%*[^:]:%s",str1);
					
					p = str1;
					while(*p == ' ')
						p++;
					
					rx_average = atoi(p);	
					rx_average*=8; // bytes->bits
					
					if(debug_check)
						fprintf(stderr,"\r\n rx_average=[%u]",rx_average);
					}
				else if(strstr(strtmp,"cur_tx_rate") != 0)
				{
					char str1[10];
					unsigned short OFDM_CCK = 0;
					
					if(debug_check)
						fprintf(stderr,"\r\n [%s]",strtmp);
					
					//cur_tx_rate:   MCS[8-15]
					//cur_tx_rate:   MCS[0-7]
					//cur_tx_rate:   [1,2,5,11]
					//cur_tx_rate:   [6,9,12,18,24,36,48,54]
					sscanf(strtmp, "%*[^:]:%s",str1);
					p = str1;
					while(*p == ' ')
						p++;
					
					if(debug_check)
						fprintf(stderr,"\r\n p=[%s]",p);
											
					if(strstr(p, "MCS8") != 0 || strstr(p, "MCS9") != 0 ||
						 strstr(p, "MCS10") != 0 || strstr(p, "MCS11") != 0 ||
						 strstr(p, "MCS12") != 0 || strstr(p, "MCS13") != 0 ||
						 strstr(p, "MCS14") != 0 || strstr(p, "MCS15") != 0 )
					{
						wlanTrafficState = WLAN_MCS8_15;																																	
					}
					else if(strstr(p, "MCS0") != 0 || strstr(p, "MCS1") != 0 ||
									 strstr(p, "MCS2") != 0 || strstr(p, "MCS3") != 0 ||
									 strstr(p, "MCS4") != 0 || strstr(p, "MCS5") != 0 ||
									 strstr(p, "MCS6") != 0 || strstr(p, "MCS7") != 0 )
					{						
						wlanTrafficState = WLAN_MCS0_7;						
					}
					else
					{
						OFDM_CCK = atoi(p);
						
						if(OFDM_CCK == 1 || OFDM_CCK == 2 || OFDM_CCK == 5 || OFDM_CCK ==11)										 
						{
							wlanTrafficState = WLAN_CCK;													
						}
						else if(OFDM_CCK == 6 || OFDM_CCK == 9 || OFDM_CCK == 12 || OFDM_CCK == 18 ||
							      OFDM_CCK == 24 || OFDM_CCK == 36 || OFDM_CCK == 48 || OFDM_CCK == 54 )
						{
							wlanTrafficState = WLAN_OFDM;
						}
					}
					
					if(strstr(p, "MCS15") != 0)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][0];
					else if(strstr(p, "MCS14") != 0)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][1];
					else if(strstr(p, "MCS13") != 0)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][2];
					else if(strstr(p, "MCS12") != 0)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][3];						
					else if(strstr(p, "MCS11") != 0)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][4];
					else if(strstr(p, "MCS10") != 0)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][5];
					else if(strstr(p, "MCS9") != 0)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][6];
					else if(strstr(p, "MCS8") != 0)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][7];
					else if(strstr(p, "MCS7") != 0)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][8];
					else if(strstr(p, "MCS6") != 0)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][9];
					else if(strstr(p, "MCS5") != 0)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][10];
					else if(strstr(p, "MCS4") != 0)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][11];
					else if(strstr(p, "MCS3") != 0)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][12];
					else if(strstr(p, "MCS2") != 0)	
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][13];
					else if(strstr(p, "MCS1") != 0)	
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][14];
					else if(strstr(p, "MCS0") != 0)	
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][15];																
					else if(OFDM_CCK == 54)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][16];							
					else if(OFDM_CCK == 48)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][17];
					else if(OFDM_CCK == 36)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][18];
					else if(OFDM_CCK == 24)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][19];
					else if(OFDM_CCK == 18)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][20];
					else if(OFDM_CCK == 12)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][21];
					else if(OFDM_CCK == 9)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][22];
					else if(OFDM_CCK == 6)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][23];
					else if(OFDM_CCK == 11)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][24];
					else if(OFDM_CCK == 5)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][25];
					else if(OFDM_CCK == 2)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][26];
					else if(OFDM_CCK == 1)
						wlanTrafficZ = wlanTrafficStatePwrConZ[chipVersion][27];
															
				}
				
			}
			fclose(stream );
			
		}
	}
	
	if(debug_check)
		fprintf(stderr,"\r\n wlanTrafficState=[%u], wlanTrafficZ=[%u]",wlanTrafficState, wlanTrafficZ);

	switch(wlanTrafficState)
	{
		case WLAN_MCS8_15:
			//tx_average /= 1000000;
			if(tx_average > 95000000)
				tx_average = 95000000;
									
			wlanTrafficStatePwrCon_Total = ((((float)tx_average*wlanTrafficStatePwrCon[chipVersion][wlanTrafficState]*wlanTrafficZ)/1000)/100)/1000000;
			if(debug_check)
				fprintf(stderr,"\r\n wlanTrafficStatePwrCon_Total:(((%u*%u*%u)/1000)/100)/10^6 = [%u]",tx_average,wlanTrafficStatePwrCon[chipVersion][wlanTrafficState],wlanTrafficZ,wlanTrafficStatePwrCon_Total);
	
			totalPwrCon+=wlanTrafficStatePwrCon_Total;
			break;
		case WLAN_MCS0_7:
			//tx_average /= 1000000;
			if(tx_average > 90000000)
				tx_average = 90000000;
		
			wlanTrafficStatePwrCon_Total = ((((float)tx_average*wlanTrafficStatePwrCon[chipVersion][wlanTrafficState]*wlanTrafficZ)/1000)/100)/1000000;
			if(debug_check)
				fprintf(stderr,"\r\n wlanTrafficStatePwrCon_Total:(((%u*%u*%u)/1000)/100)/10^6 = [%u]",tx_average,wlanTrafficStatePwrCon[chipVersion][wlanTrafficState],wlanTrafficZ,wlanTrafficStatePwrCon_Total);
			
			totalPwrCon+=wlanTrafficStatePwrCon_Total;
			break;
		case WLAN_OFDM:
			//tx_average /= 1000000;
			if(tx_average > 25000000)
				tx_average = 25000000;
			
			wlanTrafficStatePwrCon_Total = ((((float)tx_average*wlanTrafficStatePwrCon[chipVersion][wlanTrafficState]*wlanTrafficZ)/1000)/100)/1000000;
			if(debug_check)
				fprintf(stderr,"\r\n wlanTrafficStatePwrCon_Total:(((%u*%u*%u)/1000)/100)/10^6 = [%u]",tx_average,wlanTrafficStatePwrCon[chipVersion][wlanTrafficState],wlanTrafficZ,wlanTrafficStatePwrCon_Total);
			
			totalPwrCon+=wlanTrafficStatePwrCon_Total;
			break;
		case WLAN_CCK:

		wlanTrafficStatePwrCon_Total = ((((float)tx_average*wlanTrafficStatePwrCon[chipVersion][wlanTrafficState]*wlanTrafficZ)/1000)/100)/1000000;
			if(debug_check)
				fprintf(stderr,"\r\n wlanTrafficStatePwrCon_Total:(((%u*%u*%u)/1000)/100)/10^6 = [%u]",tx_average, wlanTrafficStatePwrCon[chipVersion][wlanTrafficState],wlanTrafficZ,wlanTrafficStatePwrCon_Total);
			totalPwrCon+=wlanTrafficStatePwrCon_Total;
			break;						
	}
	
	//get CPU utilization
	stream = fopen ( "/proc/stat", "r" );
	if ( stream != NULL )
	{
		char buf[512];
		unsigned int d1, d2, d3, d4;
		
		fgets(buf, sizeof(buf), stream);	/* eat line */
				
		
		sscanf(buf, "cpu %d %d %d %d", &d1, &d2, &d3, &d4);
		fclose(stream);
				
		if(pre_cpu_d4 == 0)
		{
			pre_cpu_d4 = d4;
		}
		else
		{			
			
			unsigned int delta = 0;						
				
			delta = (d4 - pre_cpu_d4)/time_delta;
			
			pre_cpu_d4 = d4;
			if(delta > max_cpu_delta)
				max_cpu_delta = delta;
			
			cpu_utilization = 100 - (int)(delta*100/max_cpu_delta);

			if(debug_check)
				fprintf(stderr,"\r\n cpu_busy: (%u*%u)/100=[%u] ",cpu_utilization,cpuUtilizationPwrCon[chipVersion],((cpu_utilization*cpuUtilizationPwrCon[chipVersion])/100));

	}

	}

	if(cpuMode == CPU_NORMAL)
		totalPwrCon+=((cpu_utilization*cpuUtilizationPwrCon[chipVersion])/100);


	if(1 || strcmp(askfor,"all")==0){

		
		if(debug_check)
		fprintf(stderr,"\r\n totalPwrCon=%u",totalPwrCon);
			
		if(tx_average_multiply2)
			tx_average/=2;
			
		req_format_write(wp, "<interface><name>LAN</name><type>LAN</type><totalPwrCon>%d</totalPwrCon><wlanTx>%d</wlanTx><wlanRx>%d</wlanRx></interface>",totalPwrCon,tx_average,rx_average);
		
	}

	return 0;
	
}
#endif // #if defined(POWER_CONSUMPTION_SUPPORT)

#ifdef CONFIG_RTL_ETH_802DOT1X_CLIENT_MODE_SUPPORT
#define RS_CERT_START "-----BEGIN CERTIFICATE-----"
#define RS_CERT_END "-----END CERTIFICATE-----"

#define RS_RSA_PRIV_KEY_START "-----BEGIN RSA PRIVATE KEY-----"
#define RS_RSA_PRIV_KEY_END "-----END RSA PRIVATE KEY-----"
#define RS_PRIV_KEY_TIP "PRIVATE KEY-----"



void formUploadEth8021xUserCert(request *wp, char * path, char * query)
{
	char *submitUrl,*strVal, *deleteAllCerts, *user_certstart,*ca_certstart;
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	int user_cert_len,ca_cert_len;
	char cmd[256];
	FILE *fp;
	char tryFormChange;
	char line[256];
	unsigned char userKeyPass[MAX_RS_USER_CERT_PASS_LEN+1];
	char certOk, userKeyOk;
	int wlanIdx_5G,wlanIdx_2G,rsBandSel;

	//printf("---%s:%d---sizeof(upload_data)=%d	upload_len=%d\n",__FUNCTION__,__LINE__,wp->upload_data,wp->upload_len);
	
	strVal = req_get_cstream_var_in_mime(wp, ("uploadCertType"), "",NULL);
	submitUrl = req_get_cstream_var_in_mime(wp, ("submit-url"), "",NULL);   // hidden page
	deleteAllCerts = req_get_cstream_var_in_mime(wp, ("delAllCerts"), "",NULL);   // hidden page

	if(deleteAllCerts[0]=='1')
	{
		//To delete all 802.1x certs
		system("rsCert -rst_eth");
		strcpy(tmpBuf,"Delete all 802.1x cerificates of ethernet success!");
		
	}
	else
	{
		//Initial
		tryFormChange=0;
		certOk=0;
		userKeyOk=0;	
	
		if(NULL == strstr(wp->upload_data,RS_CERT_START)|| NULL ==strstr(wp->upload_data,RS_CERT_END))
		{
			//printf("---%s:%d---No 802.1x cert inclued in upload file!\n",__FUNCTION__,__LINE__);
			strcpy(tmpBuf,"No 802.1x cert inclued in upload file!");
			tryFormChange=1;
		}

		if((tryFormChange==0)&&(!strcmp(strVal,"user")))
		{
			//if(NULL == strstr(wp->upload_data,RS_PRIV_KEY_TIP))				
			if((NULL ==strstr(wp->upload_data,RS_RSA_PRIV_KEY_START)) || (NULL ==strstr(wp->upload_data,RS_RSA_PRIV_KEY_END)))
			{			
				//printf("---%s:%d---No 802.1x private key inclued in upload file!\n",__FUNCTION__,__LINE__);
				strcpy(tmpBuf,"No 802.1x private key inclued in upload file!");
				tryFormChange=1;
			}
		}	
		if(!strcmp(strVal,"user"))
		{		
			user_certstart= req_get_cstream_var_in_mime(wp, ("radiusUserCert"), "",&user_cert_len);			
			
			if(tryFormChange==0)
			{
				
				fp=fopen(RS_USER_CERT_ETH,"w");
				if(NULL == fp)
				{
					sprintf(tmpBuf,"Can not open tmp RS cert(%s)!", RS_USER_CERT_5G);
					goto upload_ERR;
				}
				
						 
				fwrite(user_certstart,user_cert_len,0x1,fp);
				
				fclose(fp);
			}
			else
			{
				//To store user cert in tmp file: RS_USER_CERT_TMP
				fp=fopen(RS_USER_CERT_TMP,"w");
				if(NULL == fp)
				{
					sprintf(tmpBuf,"[2] Can not open tmp user cert(%s)!", RS_USER_CERT_TMP);
					goto upload_ERR;
				}
				fwrite(user_certstart,user_cert_len,0x1,fp);	
				fclose(fp);

				// try change user cert form from pfx to pem
				memset(userKeyPass, 0, sizeof(userKeyPass));
				apmib_get( MIB_ELAN_RS_USER_CERT_PASSWD, (void *)userKeyPass);
				
				sprintf(cmd, "openssl pkcs12 -in %s -nodes -out %s -passin pass:%s", RS_USER_CERT_TMP, RS_USER_CERT_ETH, userKeyPass);
				
				system(cmd);
				
				sleep(3); // wait for system(cmd) and avoid to open file failure;
				fp=fopen(RS_USER_CERT_ETH,"r");
				if(NULL == fp)
				{
					sprintf(tmpBuf,"[2] Can not open tmp user cert(%s)!Maybe you should upload your user certificate once again", RS_USER_CERT_ETH);
					goto upload_ERR;
				}
				
				while (fgets(line, sizeof(line), fp))
				{
					if((NULL != strstr(line,RS_CERT_START) ) || (NULL != strstr(line,RS_CERT_END) ))
						certOk=1;					
					//if(NULL != strstr(line,RS_PRIV_KEY_TIP))					
					if((NULL !=strstr(line,RS_RSA_PRIV_KEY_START)) || (NULL !=strstr(line,RS_RSA_PRIV_KEY_END)))
						userKeyOk=1;

					if((certOk == 1) && (userKeyOk == 1))
						break;
				}

				if((certOk != 1) || (userKeyOk != 1))
				{
					
					sprintf(cmd, "rm -rf %s", RS_USER_CERT_ETH);
					
					system(cmd);
					
					sprintf(tmpBuf,"Upload user cert failed. Please make sure: 1) uploaded file in pem or pfx form, 2) uploaded file contain user cert and user key.");
					goto upload_ERR;
				}

				fclose(fp);
			}

			//To store 802.1x user cert
			
			system("rsCert -wrUser_eth");
			
			strcpy(tmpBuf,"802.1x user cerificate and user key upload success!");
		}
		else if(!strcmp(strVal,"root"))
		{		
			ca_certstart= req_get_cstream_var_in_mime(wp, ("radiusRootCert"), "",&ca_cert_len);

			if(tryFormChange == 0)
			{
				fp=fopen(RS_ROOT_CERT_ETH,"w");
				if(NULL == fp)
				{
					sprintf(tmpBuf,"Can not open tmp RS cert(%s)!", RS_ROOT_CERT_ETH);
					goto upload_ERR;
				}
				
				fwrite(ca_certstart,ca_cert_len,0x1,fp);				
				fclose(fp);
			}
			else
			{
				// To store ca cert in tmp file: RS_ROOT_CERT_TMP
				fp=fopen(RS_ROOT_CERT_TMP,"w");
				if(NULL == fp)
				{
					sprintf(tmpBuf,"Can not open tmp RS cert(%s)!", RS_ROOT_CERT_TMP);
					goto upload_ERR;
				}
				fwrite(ca_certstart,ca_cert_len,0x1,fp);				
				fclose(fp);
				
				// try change ca cert form from der to pem
				
				sprintf(cmd, "openssl x509 -inform DER -in %s -outform PEM -out %s",RS_ROOT_CERT_TMP,RS_ROOT_CERT_ETH);
				
				
				system(cmd);
				
				sleep(3);	// wait for system(cmd) and avoid to open file failure;

				
				fp=fopen(RS_ROOT_CERT_ETH,"r");
				if(NULL == fp)
				{
					sprintf(tmpBuf,"[2] Can not open tmp RS cert(%s)!\nMaybe you should upload your root certificate once again!", RS_ROOT_CERT_ETH);
					goto upload_ERR;
				}
			
				while (fgets(line, sizeof(line), fp))
				{
					if((NULL != strstr(line,RS_CERT_START) ) || (NULL != strstr(line,RS_CERT_END) ))
					{
						certOk=1;
						break;
					}
				}

				if(certOk != 1)
				{
					
					sprintf(cmd, "rm -rf %s", RS_ROOT_CERT_ETH);
					
					system(cmd);
					
					strcpy(tmpBuf,"[2] No 802.1x cert inclued in upload file!");
					goto upload_ERR;
				}
				
				fclose(fp);
			}

			//To store 802.1x root cert
			
			system("rsCert -wrRoot_eth");
		
			strcpy(tmpBuf,"802.1x root cerificate upload success!");
		}
		else
		{
			sprintf(tmpBuf,"Upload cert type(%s) is not supported!", strVal);
			goto upload_ERR;
		}
	}
	
	OK_MSG1(tmpBuf, submitUrl);
	return;
	
upload_ERR:
	if(fp != NULL)
		fclose(fp);
	
	ERR_MSG(tmpBuf);
}
#endif
/* WNC-MRXXXX-Heng-I-Chen-20120503-Add Online Version Up function */
#define FW_BREADCRUMB		"ե०"
#define FW_TITLE		"ե०"
/* WNC-MR0000-JOE-PENG-20120522-Modification for specification 1.6 */
#define FW_NOTFOUND		"<font color=red>ǿΥե०ŬѤƤޤΤǡɬפϤޤ</font>"
/* WNC-NMR0088-Joe-20120516-fix wording error */
#define FW_NOTACCESS	"<font color=red>ե०ѥФ˥ǤޤWAN¦³֤ǧƤ</font>"
/* WNC-NMR0088-Joe-20120516-end */

void formOnlineVersionUp(request *wp, char * path, char * query)
{
	FILE *fp;
	int sts = -1;
	char lan_ip_buf[30]={0}, lan_ip[30];//WNC-NMR0000-Rita-20130305-Error_423-fix warnings of cppcheck (uninitialized value).
// WNC-NMR0840-JDR231-HENG-I-CHEN-2014-11-12: Fix bug 840,841 #BEGIN
	int status = 0;
	int ret = 0;
// WNC-NMR0840-JDR231-HENG-I-CHEN-2014-11-12: Fix bug 840,841 #END

	if (isFileExist("/var/fw_upgrading")) {
		send_redirect_perm(wp, "/cgi_html_903.html");
		//WNC-D2R230-YUAN-I-CHOU-20171003, Firmware upgrade modification.
		//Resume LED light off setting when upgrading fail.
		system("echo RLOS > /proc/ledgpio");
		return;
	} 
	system("touch /var/fw_upgrading");
	
	/* WNC-NMR0000-JOE-PENG-20140214-Fix bug that upgrade firmware page does not return to Top Page of simple or detailed mode after RakuRaku is running warning message appears-start */
	/* WNC-NMR0528-JOE-PENG-20140115-Fix bug 528 "During RakuRaku or WPS, Can upgrade firmware" in Voyager-start */
	if ((lw_is_rakuraku_running()==1) || (lw_is_wps_running()==1)) {
//		RETURN_TOP_MSG_NEC("", "", "<font color=red>ΤꥯȤդ뤳ȤǤޤǤ</font>", "index.htm");
		send_redirect_perm(wp, "/cgi_html_903.html");
		unlink("/var/fw_upgrading");
		//WNC-D2R230-YUAN-I-CHOU-20171003, Firmware upgrade modification.
		//Resume LED light off setting when upgrading fail.
		system("echo RLOS > /proc/ledgpio");
		return;
	}
	/* WNC-NMR0528-JOE-PENG-20140115-Fix bug 528 "During RakuRaku or WPS, Can upgrade firmware" in Voyager-end */
	/* WNC-NMR0000-JOE-PENG-20140214-Fix bug that upgrade firmware page does not return to Top Page of simple or detailed mode after RakuRaku is running warning message appears-end */

// WNC-NMR0840-JDR231-HENG-I-CHEN-2014-11-12: Fix bug 840,841 #BEGIN
// Can't clear firmware here, it clears file downaload by runnung force upgrade 
//	unlink("/var/fw_enc.bin");
//	unlink("/var/wget_status");
//	unlink("/var/wget.log");
// WNC-NMR0840-JDR231-HENG-I-CHEN-2014-11-12: Fix bug 840,841 #END

	/* WNC-NMR0138-HENG-I-CHEN-20120608-"online-getfw" add "-w" parameter from GUI */
	ret = system("/bin/online-getfw -w");
	/* WNC-NMR0138-HENG-I-CHEN-20120608-End */
// WNC-NMR0840-JDR231-HENG-I-CHEN-2014-11-12: Fix bug 840,841 #BEGIN
// when online-getfw doesn't get file, send 403 page to browser
	if (ret >> 8) {
		send_forbidden(wp);
		unlink("/var/fw_upgrading");
		//WNC-D2R230-YUAN-I-CHOU-20171003, Firmware upgrade modification.
		//Resume LED light off setting when upgrading fail.
		system("echo RLOS > /proc/ledgpio");
		return;
	}
// WNC-NMR0840-JDR231-HENG-I-CHEN-2014-11-12: Fix bug 840,841 #END
	wait(&status);
	fp = fopen("/var/online_getfw_status", "r");
	if (fp) {
		char buf[256];
		fgets(buf, 256, fp);
		if (strcmp(buf, "200 OK\n") == 0) {
			sts = 0;
		} else if (strcmp(buf, "404 Not Found\n") == 0) {
			sts = 1;
		}
		fclose(fp);
	}












	/* WNC-MR0000-JOE-PENG-20120522-Modification for specification 1.6 */
	/* WNC-NMR0000-JOE-PENG-20140521-Modify codes of boa detecting system mode (Gateway/Bridge/Converter/Repeater)-start */
	{
		int opmode = 0 ; //WNC-NMR0000-Rita-20130305-Error_431-fix warnings of cppcheck (uninitialized value).
		/* WNC-NMR0000-JOE-PENG-20131202-Correct the return homepage link when upgrade firmware or configuration fails in repeater mode-start */
		/* WNC-NMR0240-JOE-PENG-20121210-Fix bug that return home page is incorrect if mode is repeater mode.-->start */
		apmib_get( MIB_OP_MODE, (void *)&opmode);

		if (sts == 0) {
			formUploadMain(wp, "/var/fw_enc.bin");
		} else if (sts == 1) {
			send_redirect_perm(wp, "/fw_main_newest_version.html");
			unlink("/var/fw_upgrading");
			//WNC-D2R230-YUAN-I-CHOU-20171003, Firmware upgrade modification.
			//Resume LED light off setting when upgrading fail.
			system("echo RLOS > /proc/ledgpio");
			return;
#if 0
			apmib_get( MIB_IP_ADDR,  (void *)lan_ip_buf);
			sprintf(lan_ip,"%s",inet_ntoa(*((struct in_addr *)lan_ip_buf)) );

			if (opmode == GATEWAY_MODE) {
				OK_MSG_NEC(FW_BREADCRUMB, FW_TITLE, FW_NOTFOUND, lan_ip, "home_detail.htm");
			} else if (opmode == BRIDGE_MODE) {
				/* WNC-NMR0000-JOE-PENG-20140430-Modify 4.1 structure of page according to Linear Spec-start */
				//OK_MSG_NEC(FW_BREADCRUMB, FW_TITLE, FW_NOTFOUND, lan_ip, "home_detail_bridge.htm");
				int wifi_mode=WIFI_MODE_AP;
					
				if (lw_get_wifi_mode(&wifi_mode) == 1) {
					switch (wifi_mode) {
						case WIFI_MODE_AP:
							OK_MSG_NEC(FW_BREADCRUMB, FW_TITLE, FW_NOTFOUND, lan_ip, "home_detail_bridge.htm");
							break;
						case WIFI_MODE_CLIENT:
							OK_MSG_NEC(FW_BREADCRUMB, FW_TITLE, FW_NOTFOUND, lan_ip, "home_detail_converter.htm");
							break;
						case WIFI_MODE_REPEATER:
							OK_MSG_NEC(FW_BREADCRUMB, FW_TITLE, FW_NOTFOUND, lan_ip, "home_detail_repeater.htm");
							break;
						default:
							OK_MSG_NEC(FW_BREADCRUMB, FW_TITLE, FW_NOTFOUND, lan_ip, "home_detail_bridge.htm");
							break;						}	
				} else {
					OK_MSG_NEC(FW_BREADCRUMB, FW_TITLE, FW_NOTFOUND, lan_ip, "home_detail_bridge.htm");
				}
				/* WNC-NMR0000-JOE-PENG-20140430-Modify 4.1 structure of page according to Linear Spec-end */
			} else {
				OK_MSG_NEC(FW_BREADCRUMB, FW_TITLE, FW_NOTFOUND, lan_ip, "index.htm");
			}
#endif
		} else {
			extern int upgrade_method;
			upgrade_method = 1;
			send_redirect_perm(wp, "/fw_main_update_failure.html");
			unlink("/var/fw_upgrading");
			//WNC-D2R230-YUAN-I-CHOU-20171003, Firmware upgrade modification.
			//Resume LED light off setting when upgrading fail.
			system("echo RLOS > /proc/ledgpio");
			return;
#if 0		
			if (opmode == GATEWAY_MODE) {
				OK_MSG_NEC(FW_BREADCRUMB, FW_TITLE, FW_NOTACCESS, lan_ip, "home_detail.htm");
			} else if (opmode == BRIDGE_MODE) {
				/* WNC-NMR0000-JOE-PENG-20140430-Modify 4.1 structure of page according to Linear Spec-start */
				//OK_MSG_NEC(FW_BREADCRUMB, FW_TITLE, FW_NOTACCESS, lan_ip, "home_detail_bridge.htm");
				int wifi_mode=WIFI_MODE_AP;
				
				if (lw_get_wifi_mode(&wifi_mode) == 1) {
					switch (wifi_mode) {
						case WIFI_MODE_AP:
							OK_MSG_NEC(FW_BREADCRUMB, FW_TITLE, FW_NOTACCESS, lan_ip, "home_detail_bridge.htm");
							break;
						case WIFI_MODE_CLIENT:
							OK_MSG_NEC(FW_BREADCRUMB, FW_TITLE, FW_NOTACCESS, lan_ip, "home_detail_converter.htm");
							break;
						case WIFI_MODE_REPEATER:
							OK_MSG_NEC(FW_BREADCRUMB, FW_TITLE, FW_NOTACCESS, lan_ip, "home_detail_repeater.htm");
							break;
						default:
							OK_MSG_NEC(FW_BREADCRUMB, FW_TITLE, FW_NOTACCESS, lan_ip, "home_detail_bridge.htm");
							break;
					}	
				} else {
					OK_MSG_NEC(FW_BREADCRUMB, FW_TITLE, FW_NOTACCESS, lan_ip, "home_detail_bridge.htm");
				}
				/* WNC-NMR0000-JOE-PENG-20140430-Modify 4.1 structure of page according to Linear Spec-end */
			} else {
				OK_MSG_NEC(FW_BREADCRUMB, FW_TITLE, FW_NOTACCESS, lan_ip, "index.htm");
			}
#endif			
		}
		/* WNC-NMR0240-JOE-PENG-20121210-Fix bug that return home page is incorrect if mode is repeater mode.-->end */
		/* WNC-NMR0000-JOE-PENG-20131202-Correct the return homepage link when upgrade firmware or configuration fails in repeater mode-end */
	}
	/* WNC-NMR0000-JOE-PENG-20140521-Modify codes of boa detecting system mode (Gateway/Bridge/Converter/Repeater)-end */
	/* WNC-MR0000-JOE-PENG-20120522-end */
}
/* WNC-MRXXXX-Heng-I-Chen-20120503-End */

/* WNC-MRXXXX-Heng-I-Chen-20120508-Add Maintain Version Up Setting */
void formMaintainVersionUp(request *wp, char * path, char * query)
{
	char *submitUrl;
	char *tmpStr;
	int maintevup = 0;

	submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page

	tmpStr = req_get_cstream_var(wp, ("maintevup"), "");
	if(tmpStr[0]){
		if (strcmp(tmpStr, "enable") == 0) {
			maintevup = 1;
		} else if (strcmp(tmpStr, "disable") == 0) {
			maintevup = 0;
		}
		if ( apmib_set(MIB_MAINTE_VUP, (void *)&maintevup) == 0) {
			goto setErr;
		}
	}

	apmib_update_web(CURRENT_SETTING);

	OK_MSG(submitUrl);

	return;

setErr:
	ERR_MSG("Set Opmode error!");
}
/* WNC-MRXXXX-Heng-I-Chen-20120508-End */

/* NMR0000-20160726-Implement responsive GUI page of Aero model-start */
void formOtherSetting(request *wp, char * path, char * query)
{
	char *submitUrl;
	char *tmpStr;
	int temp_value = 0;
	int maintevup_reboot_flag = 0;	/* WNC-NMR000-Libera-20170308-WDF-implement into RT/BR mode *///libera test

	/* NMR0000-20160819-Implement server side input check for WAN and other setting page-start */
	/* Server side input check-start */
	/* TCP timeout */
	tmpStr = req_get_cstream_var(wp, ("tcp_timeout"), NULL);
	if (tmpStr != NULL) {
		if (lw_NullCheck(tmpStr) == -1) {
			send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
			return;
		}

		if (lw_DigitalRangeCheck(tmpStr, 300, 432000) == -1) {
			send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
			return;
		}
	}

	/* UDP timeout */
	tmpStr = req_get_cstream_var(wp, ("udp_timeout"), NULL);
	if (tmpStr != NULL) {
		if (lw_NullCheck(tmpStr) == -1) {
			send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
			return;
		}

		if (lw_DigitalRangeCheck(tmpStr, 30, 3600) == -1) {
			send_redirect_perm(wp, LW_GUI_INPUT_ERR_PAGE);
			return;
		}
	}
	/* Server side input check-end */
	/* NMR0000-20160819-Implement server side input check for WAN and other setting page-end */

	submitUrl = req_get_cstream_var(wp, "submit-url", "");   // hidden page

	/* Set jumbo frame enabled MIB */
	tmpStr = req_get_cstream_var(wp, ("jumbo_frame_enable"), "");
	if (tmpStr[0]) {
		if ( !strcmp(tmpStr, "ON"))
			temp_value = 1;
		else
			temp_value = 0;
		if ( !apmib_set(MIB_JUMBO_FRAME_STATE, (void *)&temp_value)) {
			goto setErr;
		}
	}

	/* Set pause frame enabled MIB */
	tmpStr = req_get_cstream_var(wp, ("pause_frame_enable"), "");
	if (tmpStr[0]) {
		if ( !strcmp(tmpStr, "ON"))
			temp_value = 1;
		else
			temp_value = 0;
		if ( !apmib_set(MIB_PAUSE_FRAME_STATE, (void *)&temp_value)) {
			goto setErr;
		}
	}

	/* Set TCP timeout MIB */
	tmpStr = req_get_cstream_var(wp, ("tcp_timeout"), "");
	if (tmpStr[0]) {
		temp_value = atoi(tmpStr);
		if ( !apmib_set(MIB_TCP_TIME_OUT, (void *)&temp_value)) {
			goto setErr;
		}
	}

	/* Set UDP timeout MIB */
	tmpStr = req_get_cstream_var(wp, ("udp_timeout"), "");
	if (tmpStr[0]) {
		temp_value = atoi(tmpStr);
		if ( !apmib_set(MIB_UDP_TIME_OUT, (void *)&temp_value)) {
			goto setErr;
		}
	}

	/* Set UPnP function enabled MIB */
	tmpStr = req_get_cstream_var(wp, ("enable_upnp"), "");
	if (tmpStr[0]) {
		if ( !strcmp(tmpStr, "ON"))
			temp_value = 1;
		else
			temp_value = 0;
		if ( !apmib_set(MIB_UPNP_ENABLED, (void *)&temp_value)) {
			goto setErr;
		}
	}

	/* Set Force version up enabled MIB */
	tmpStr = req_get_cstream_var(wp, ("force_version_up_enable"), "");
	if(tmpStr[0]){
		if (strcmp(tmpStr, "enable") == 0) {
			temp_value = 1;
		} else if (strcmp(tmpStr, "disable") == 0) {
			temp_value = 0;
		}
		if ( apmib_set(MIB_MAINTE_VUP, (void *)&temp_value) == 0) {
			goto setErr;
		}
	}

	/* Set Internet Reachability enabled MIB */
	tmpStr = req_get_cstream_var(wp, ("internet_reachability_enable"), "");
	if (tmpStr[0]) {
		if ( !strcmp(tmpStr, "ON"))
			temp_value = 1;
		else
			temp_value = 0;
		if ( !apmib_set(MIB_NETCHK, (void *)&temp_value)) {
			goto setErr;
		}
	}

	tmpStr = req_get_cstream_var(wp, ("eeeEnabled"), "");
	if (tmpStr[0]) {
		if ( !strcmp(tmpStr, "ON"))
			temp_value = 1;
		else
			temp_value = 0;
		if ( !apmib_set(MIB_EEE_STATE, (void *)&temp_value)) {
			goto setErr;
		}
	}
#if 1	/* WNC-NMR000-Libera-20170308-WDF-implement into RT/BR mode-start */
	/* WNC-NMR1444-MIKE-YEH-20160315, The Web Spec change to PageID 11 R/C. */
	/* maintane version up reboot flag */
	tmpStr = req_get_cstream_var(wp, ("maintevup_reboot"), ""); 
	if(tmpStr[0]){
		if ( !strcmp(tmpStr, "ON"))
			maintevup_reboot_flag = 1;
		else
			maintevup_reboot_flag = 0;
	}
#endif	/* WNC-NMR000-Libera-20170308-WDF-implement into RT/BR mode-end */

	/* Update MIB to flash */
	apmib_update_web(CURRENT_SETTING);

#if 1	/* WNC-NMR000-Libera-20170308-WDF-implement into RT/BR mode-start */	//libera test
	if(maintevup_reboot_flag)
	{
		/* WNC-NMR1444-MIKE-YEH-20160315, The Web Spec change to PageID 11 R/C. */
		countdownAction = DO_REBOOT;
		send_redirect_perm(wp, "/reboot_main_finish.html");
	}
	else
#endif
	{	
		/* Return reboot later page to browser */
		OK_MSG(submitUrl);

	}
	return;

setErr:
	ERR_MSG("Set flash MIB error!");
}
/* NMR0000-20160726-Implement responsive GUI page of Aero model-end */

/* WNC-NMR0000-JOE-PENG-20191128-Modify upgrade firmware page according to Spec. change of improve security */
extern void add_login_session(request *req, int auth_status, int is_rd_user);

extern unsigned int authFailCount;

/* WNC-MIKE-YEH-20160805-implement remote maintenance account. */
#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)
#define RMAINTE_CONF "/var/rmainte.conf"
#define RMAINTE_ACCOUNT_CONF "/var/rmainte_account.conf"
#define RMAINTE_NOW "/var/rmainte_now"
#define RM_ON_TYPE "ON"
#endif

void formLogin(request *wp, char * path, char * query) {
	/* WNC-NMR0000-JOE-PENG-20191128-Modify upgrade firmware page according to Spec. change of improve security-start */
	int rd_user_auth_ok=0;
	/* WNC-NMR0000-JOE-PENG-20191128-Modify upgrade firmware page according to Spec. change of improve security-end */

	char *userStr = NULL;
	char *passStr = NULL;
	
	int userlen = 0;
	int passlen = 0;

	
#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)	
	int rm_auth_flag = 0, cur_op_mode = 0;
#endif

	char cstreamBuf[128] = "/index_contents.html";

	char user_name[MAX_NAME_LEN]="admin"; 
	char user_password[PASSWORD_SIZE]="";
//	char admin_name[MAX_NAME_LEN]="adminpldt"; 
//	char admin_password[MAX_NAME_LEN]="1234567890";

//	apmib_get(MIB_SUPER_PASSWORD, admin_password);
	apmib_get(MIB_USER_PASSWORD, user_password);

	userStr = req_get_cstream_var(wp, ("user"), "");
	userlen = strlen(userStr)+1;
	if (userlen > MAX_NAME_LEN)
		userlen = MAX_NAME_LEN;
	passStr = req_get_cstream_var(wp, ("pass"), "");
	passlen = strlen(passStr)+1;
	if (passlen > PASSWORD_SIZE)
		passlen = PASSWORD_SIZE;

//	console_printf("%s %d user:%s / %s (%d) pass:%s / %s (%d)\n", __func__, __LINE__, userStr, "admin", userlen, passStr, user_password, passlen);

/* WNC-MIKE-YEH-20160805-implement remote maintenance. */
#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)

	/* NMR2130-MIKE-YEH-20161124-After got the AIM definition file in CNV mode, It can not login. */
	apmib_get( MIB_OP_MODE, (void *)&cur_op_mode);

	if ((cur_op_mode == GATEWAY_MODE) && isFileExist(RMAINTE_CONF) && isFileExist(RMAINTE_ACCOUNT_CONF) && isFileExist(RMAINTE_NOW)) {
		char ruser[256] = {0}, rpass[256] = {0}, rm_type[8] = {0}, rm_expire[8];
		FILE *fp = NULL, *afp = NULL;

		/* from wan interface */
		if((wp->from_interface_flag != 1) && 
			(strncmp(userStr, "admin", userlen) == 0) && 
			(wp->ssl_flag == 0)) { 	
			int intVal = 0;

			apmib_get( MIB_WEB_WAN_ACCESS_ENABLED, (void *)&intVal);
			if(intVal != 1) {
				return;
			}
		}

		afp = fopen(RMAINTE_ACCOUNT_CONF, "r");
		if (afp) {
			if (fscanf(afp, "ID=%s\n", ruser) == 1 && fscanf(afp, "PW=%s\n", rpass) == 1) { 		
				if ((strncmp(userStr, ruser, userlen) == 0) && (strncmp(passStr, rpass, passlen) == 0)) {
					rm_auth_flag = 1;

					/* if the rm type is ON type.*/
					fp = fopen(RMAINTE_CONF, "r");
					if(fp){
						if(fscanf(fp, "RemoteMainte=%s\n", rm_type) == 1) 
						{	
							printf("\n rm_type:%s\n", rm_type);
							if(!strcmp(RM_ON_TYPE, rm_type)) 
							{
								system("touch /var/rm_type_on_login");
							}	
						}
						fclose(fp);
					}
				}	
			}
			fclose(afp);
		}
	}
#endif

	/* WNC-NMR0000-JOE-PENG-20191128-Modify upgrade firmware page according to Spec. change of improve security-start */
	if (strncmp(userStr, "firmware", userlen) == 0) {
		char temp_buffer1[PASSWORD_SIZE]={0};
		char temp_buffer2[9]={0};

		strlcpy(temp_buffer2, user_password, sizeof(temp_buffer2));
		temp_buffer2[sizeof(temp_buffer2)-1]= '\0';

		{
			int model_id = -1;

			if (lw_get_modelid(&model_id) < 0) {
				snprintf(temp_buffer1, sizeof(temp_buffer1), "%s", user_password);
			} else {
				switch (model_id) {
					case 0: //Rafale
					case 1: //Meteor
						snprintf(temp_buffer1, sizeof(temp_buffer1), "%s%s", temp_buffer2, RD_PW);
						break;
					default:
						snprintf(temp_buffer1, sizeof(temp_buffer1), "%s", user_password);
						break;
				}
			}
		}

		if (strncmp(passStr, temp_buffer1, passlen) == 0) {
			rd_user_auth_ok = 1;
		}
	}
	/* WNC-NMR0000-JOE-PENG-20191128-Modify upgrade firmware page according to Spec. change of improve security-end */

#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)
	/* WNC-NMR0000-JOE-PENG-20191128-Modify upgrade firmware page according to Spec. change of improve security */
	if ((rm_auth_flag || (rd_user_auth_ok==1)) || (strncmp(userStr, "admin", userlen) == 0) && (strncmp(passStr, user_password, passlen) == 0)) {
#else
	/* WNC-NMR0000-JOE-PENG-20191128-Modify upgrade firmware page according to Spec. change of improve security */
	if ((rd_user_auth_ok==1) || (strncmp(userStr, "admin", userlen) == 0) && (strncmp(passStr, user_password, passlen) == 0)) {
#endif
		char *dest_url;
//		console_printf("%s %d add_login_session redirect to / \n", __func__, __LINE__);

#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)
		if(!rm_auth_flag)
			system("rm -f /var/rm_type_on_login");
#endif

		/* WNC-NMR0000-JOE-PENG-20191128-Modify upgrade firmware page according to Spec. change of improve security-start */
		if (rd_user_auth_ok==1) {
			/* RD user login */
			add_login_session(wp, 1, 1);
		} else {
			/* normal user login */
			add_login_session(wp, 1, 0);
		}
		/* WNC-NMR0000-JOE-PENG-20191128-Modify upgrade firmware page according to Spec. change of improve security-end */

#if defined(CONFIG_WNC_NEC_STOK_SESSION_AUTH)
		sprintf(cstreamBuf, "/stok=%s/index_contents.html", wp->stok);
		dest_url = req_get_cstream_var(wp, ("dest"), cstreamBuf);
#else
		dest_url = req_get_cstream_var(wp, ("dest"), "/index_contents.html");
#endif

		if (dest_url == NULL || *dest_url == 0) {
			send_redirect_perm(wp, cstreamBuf);
		} else {
#if defined(CONFIG_WNC_NEC_STOK_SESSION_AUTH)
			/* NMR2469-20170628-When the URL inputed directly, the specified page will not open.-start */
			memset(cstreamBuf, 0, sizeof(cstreamBuf));

			/* NMR2690-MIKE-YEH-20171024-[Rafale]Cannot login to WebGUI, if enter a bad stok id .-start */
			if (strstr(dest_url, "stok=")) {
				snprintf(cstreamBuf, sizeof(cstreamBuf), "/stok=%s/index_contents.html", wp->stok);
			}
			/* NMR2690-MIKE-YEH-20171024-[Rafale]Cannot login to WebGUI, if enter a bad stok id .-end */
			else
				snprintf(cstreamBuf, sizeof(cstreamBuf), "/stok=%s%s", wp->stok, dest_url);
			/* NMR2469-20170628-When the URL inputed directly, the specified page will not open.-end */
			send_redirect_perm(wp, cstreamBuf);
#else	
			send_redirect_perm(wp, dest_url);
#endif	
		}
//	} else if ((strncmp(userStr, "adminpldt", userlen) == 0) && (strncmp(passStr, admin_password, passlen) == 0)) {
/* WNC-NMR0000-JOE-PENG-20191128-Modify upgrade firmware page according to Spec. change of improve security */
//		add_login_session(wp, 2, 0);
//		send_redirect_perm(wp, "/");

#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)
		if((wp->from_interface_flag == 1) || 
		   ((wp->from_interface_flag == 0)&&(wp->ssl_flag != 1)) || 
		   (!check_rmainte_conf()))
#endif
			authFailCount = 0;
	} else {

/* NMR2338-20170407-Implement request of bug 2338 [Linear][Request] Change the account lock spec.-start */
#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)
		if((wp->from_interface_flag == 1) || 
		   ((wp->from_interface_flag == 0)&&(wp->ssl_flag != 1)) || 
		   (!check_rmainte_conf())) {
			/* WNC-NMR0000-JOE-PENG-20191128-Modify upgrade firmware page according to Spec. change of improve security-start */
			if ((strncmp(userStr, "admin", userlen) == 0) ||
				(strncmp(userStr, "firmware", userlen) == 0)) {
			/* WNC-NMR0000-JOE-PENG-20191128-Modify upgrade firmware page according to Spec. change of improve security-end */
				authFailCount++;
			}
		}
#else
		/* WNC-NMR0000-JOE-PENG-20191128-Modify upgrade firmware page according to Spec. change of improve security-start */
		if ((strncmp(userStr, "admin", userlen) == 0) ||
			(strncmp(userStr, "firmware", userlen) == 0)) {
		/* WNC-NMR0000-JOE-PENG-20191128-Modify upgrade firmware page according to Spec. change of improve security-end */
			authFailCount++;
		}
#endif
/* NMR2338-20170407-Implement request of bug 2338 [Linear][Request] Change the account lock spec.-end */

		/* NMR2059-MIKE-YEH-20161122-After login miss inputed, the transit page is wrong. */
#if defined(CONFIG_WNC_NEC_REMOTE_MAINTENANCE)
		if((authFailCount >= 10) && ((!check_rmainte_conf())||(wp->from_interface_flag != 0)))
#else
		if(authFailCount >= 10)
#endif			
			send_redirect_perm(wp, "/cgi_html_lockout.html");
		else
			send_redirect_perm(wp, "/cgi_html_401.html");
	}

	return;
}

#ifdef CONFIG_RTL_TRANSMISSION
void formTransmissionBT(request *wp, char * path, char * query)
{
	char *downdir;
	char *updir;
	char *strptr;
	char *nextwebpage;
	char tmp[128];
	char cmd[128];
	int enabled;

	nextwebpage=req_get_cstream_var(wp, ("nextwebpage"),"");
	downdir=req_get_cstream_var(wp, ("btdownloaddir"),"");
//	updir=req_get_cstream_var(wp, ("btuploaddir"),"");
	strptr=req_get_cstream_var(wp, ("bt_enabled"),"");

	if(access(downdir, 0) != 0)
	{
		ERR_MSG("Directory Not Exists!!!");
		return;
	}

	if(strptr)
		enabled=atoi(strptr);

//	apmib_set(MIB_BT_UPLOAD_DIR,updir);
	apmib_set(MIB_BT_DOWNLOAD_DIR,downdir);
	apmib_set(MIB_BT_ENABLED,&enabled);
	apmib_update(CURRENT_SETTING);

	if(enabled)
	{
		if(access("/var/run/transmission.pid", 0) == 0)
		{
			ERR_MSG("There is transmission-daemon already running!");
			return;
		}
		sprintf(tmp, "%s/transmission-daemon", downdir);
		if(access(tmp, 0) != 0)
		{
			sprintf(cmd, "mkdir %s/transmission-daemon/", downdir);
			system(cmd);
		}
		sprintf(tmp, "%s/transmission-daemon/torrents", downdir);
		if(access(tmp, 0) != 0)
		{
			sprintf(cmd, "mkdir %s/transmission-daemon/torrents/", downdir);
			system(cmd);
		}
		sprintf(tmp, "%s/transmission-daemon/resume", downdir);
		if(access(tmp, 0) != 0)
		{
			sprintf(cmd, "mkdir %s/transmission-daemon/resume/", downdir);
			system(cmd);
		}
		sprintf(tmp, "%s/transmission-daemon/blocklists", downdir);
		if(access(tmp, 0) != 0)
		{
			sprintf(cmd, "mkdir %s/transmission-daemon/blocklists/", downdir);
			system(cmd);
		}
		sprintf(tmp, "/var/transmission");
		if(access(tmp, 0) != 0)
		{
			system("mkdir /var/transmission/");
		}

		sprintf(cmd, "ln -s %s/transmission-daemon/torrents/ /var/transmission/", downdir);
		system(cmd);
		sprintf(cmd, "ln -s %s/transmission-daemon/resume/ /var/transmission/", downdir);
		system(cmd);
		sprintf(cmd, "ln -s %s/transmission-daemon/blocklists/ /var/transmission/", downdir);
		system(cmd);
		sprintf(cmd, "transmission-daemon --log-error -w %s", downdir);
//		sprintf(cmd, "transmission-daemon --log-debug -w %s -e %s/log", downdir, downdir);
		system(cmd);
	}
	else
	{
		FILE *fp;
		char buf[16];
		int pid;
		
		fp=fopen("/var/run/transmission.pid","r");
		if(NULL == fp)
		{
			ERR_MSG("Can't open /var/run/transmission.pid!");
			return;
		}
		fgets(buf, sizeof(buf), fp);
		sscanf(buf, "%d", &pid);
		fclose(fp);

		sprintf(cmd,"kill -9 %d 2>/dev/null", pid);
		system(cmd);
		system("rm /var/transmission/torrents 2>/dev/null");
		system("rm /var/transmission/resume 2>/dev/null");
		system("rm /var/transmission/blocklists 2>/dev/null");
		system("rm /var/run/transmission.pid 2>/dev/null");
	}

	send_redirect_perm(wp,nextwebpage);
	return;
}
#endif
#ifdef GET_LAN_DEV_INFO_SUPPORT
/*
  *@name rtk_get_device_brand
  *@ input 
     mac , the pointer of lan device mac address 
     mac_file , contains the prefix mac and brand list, such as "/etc/device_mac_brand.txt"
  *@output
     brand ,  hold the brand of device, such as Apple, Samsung, Xiaomi, Nokia, Huawei, etc.
  *@ return value
  	RTK_SUCCESS
  	RTK_FAILED
  *
  */
int rtk_get_device_brand(unsigned char *mac, char *mac_file, char *brand)
{		
	FILE *fp;
	int index;
	unsigned char prefix_mac[16], mac_brand[64];
	char *pchar;
	int found=0;
	if(mac==NULL || mac_file==NULL || brand==NULL)
		return -1;
	if((fp= fopen(mac_file, "r"))==NULL)
		return -1;

	sprintf(prefix_mac, "%02X-%02X-%02X", mac[0], mac[1], mac[2]);

	for(index = 0 ; index < 8; ++index)
	{
		if((prefix_mac[index]  >= 'a')  && (prefix_mac[index]<='f'))
			prefix_mac[index] -= 32;
	}

	//printf("%s.%d. str(%s)\n",__FUNCTION__,__LINE__,prefix_mac);

	while(fgets(mac_brand, sizeof(mac_brand), fp))
	{			
		mac_brand[strlen(mac_brand)-1]='\0';		
		if((pchar=strstr(mac_brand, prefix_mac))!=NULL)
		{
			pchar+=9;
			strcpy(brand, pchar);
			found=1;
			break;
		}
	}
	fclose(fp);
	
	if(found==1)
		return 0;
	
	return -1;
}

int get_info_from_l2_tab(char *filename, rtk_l2Info l2list[])
{
	FILE *fp;
	char line_buffer[512];	
	char mac_str[13];
	unsigned char mac_addr[6];
	int idx=0, i, j;	
	char *pchar, *pstart;
	
	unsigned char br0_mac[6];
	unsigned char br0_mac_str[32];
	
	if(filename==NULL)
		return -1; 
	if((fp= fopen(filename, "r"))==NULL)
		return -1;
	
	memset(br0_mac,0,6);
	apmib_get(MIB_ELAN_MAC_ADDR,  (void *)br0_mac);
	if(!memcmp(br0_mac, "\x00\x00\x00\x00\x00\x00", 6))
		apmib_get(MIB_HW_NIC0_ADDR,  (void *)br0_mac);
	
	sprintf(br0_mac_str, "%02x:%02x:%02x:%02x:%02x:%02x", br0_mac[0], br0_mac[1], br0_mac[2], br0_mac[3], br0_mac[4], br0_mac[5]);
	br0_mac_str[strlen("ff:ff:ff:ff:ff:ff")]='\0';
	
	while(fgets(line_buffer, sizeof(line_buffer), fp))
	{			
		line_buffer[strlen(line_buffer)-1]='\0';

		if(strstr(line_buffer, "ff:ff:ff:ff:ff:ff") || strstr(line_buffer, "CPU") || strstr(line_buffer, "FID:1") || strstr(line_buffer, br0_mac_str))
			continue;	
		
		pchar=strchr(line_buffer, ':');
		pstart=pchar-2;
		for(i=0, j=0; i<17 && j<12; i++)
		{
			if(pstart[i]!=':')
			{
				mac_str[j++]=pstart[i];
			}
		}
		mac_str[j]=0;
		if (strlen(mac_str)==12 && string_to_hex(mac_str, mac_addr, 12)) 
		{
			memcpy(l2list[idx].mac, mac_addr, 6);
			
			pchar=strstr(line_buffer,"mbr");
			sscanf(pchar,"mbr(%d",&(l2list[idx].portNum));
			
			idx++;
		}		
	}
	fclose(fp);
	return idx;		
}
struct arpMsg 
{
	struct ethhdr ethhdr;	 		/* Ethernet header */
	u_short htype;				/* hardware type (must be ARPHRD_ETHER) */
	u_short ptype;				/* protocol type (must be ETH_P_IP) */
	u_char  hlen;				/* hardware address length (must be 6) */
	u_char  plen;				/* protocol address length (must be 4) */
	u_short operation;			/* ARP opcode */
	u_char  sHaddr[6];			/* sender's hardware address */
	u_char  sInaddr[4];			/* sender's IP address */
	u_char  tHaddr[6];			/* target's hardware address */
	u_char  tInaddr[4];			/* target's IP address */
	u_char  pad[18];			/* pad for min. Ethernet payload (60 bytes) */
};
#if 0
int sendArpToCheckDevIsAlive(unsigned int dst_ip, unsigned int src_ip, unsigned char *mac)
{
	int	timeout = 1;
	int 	optval = 1;
	int	s;			/* socket */
	int	rv = 1;			/* return value */
	struct sockaddr addr;		/* for interface name */
	struct arpMsg	arp;
	fd_set		fdset;
	struct timeval	tm;
	time_t		prevTime;


	if ((s = socket (PF_PACKET, SOCK_PACKET, htons(ETH_P_ARP))) == -1) {
		printf("Could not open raw socket");
		return -1;
	}
	
	printf("%s:%d \n",__FUNCTION__,__LINE__);
	if (setsockopt(s, SOL_SOCKET, SO_BROADCAST, &optval, sizeof(optval)) == -1) {
		printf("Could not setsocketopt on raw socket");
		close(s);
		return -1;
	}

	/* send arp request */
	memset(&arp, 0, sizeof(arp));
	memcpy(arp.ethhdr.h_dest, MAC_BCAST_ADDR, 6);	/* MAC DA */
	memcpy(arp.ethhdr.h_source, mac, 6);		/* MAC SA */
	arp.ethhdr.h_proto = htons(ETH_P_ARP);		/* protocol type (Ethernet) */
	arp.htype = htons(ARPHRD_ETHER);		/* hardware type */
	arp.ptype = htons(ETH_P_IP);			/* protocol type (ARP message) */
	arp.hlen = 6;					/* hardware address length */
	arp.plen = 4;					/* protocol address length */
	arp.operation = htons(ARPOP_REQUEST);		/* ARP op code */
	memcpy(arp.sInaddr, &src_ip, sizeof(src_ip));		/* source IP address */
	memcpy(arp.sHaddr, mac, 6);			/* source hardware address */
	memcpy(arp.tInaddr, &dst_ip, sizeof(dst_ip));	/* target IP address */
	
	memset(&addr, 0, sizeof(addr));
	strcpy(addr.sa_data, "br0");
	if (sendto(s, &arp, sizeof(arp), 0, &addr, sizeof(addr)) < 0)
		rv = 0;
	
	printf("%s:%d \n",__FUNCTION__,__LINE__);
	/* wait arp reply, and check it */
	tm.tv_usec = 0;
	time(&prevTime);
	while (timeout > 0) {
		FD_ZERO(&fdset);
		FD_SET(s, &fdset);
		tm.tv_sec = timeout;
		if (select(s + 1, &fdset, (fd_set *) NULL, (fd_set *) NULL, &tm) < 0) {
			//printf("Error on ARPING request: %s", strerror(errno));
			if (errno != EINTR) rv = 0;
		} else if (FD_ISSET(s, &fdset)) {
			if (recv(s, &arp, sizeof(arp), 0) < 0 ) rv = 0;
			if (arp.operation == htons(ARPOP_REPLY) && 
			    bcmp(arp.tHaddr, mac, 6) == 0 && 
			    *((u_int *) arp.sInaddr) == dst_ip) {
				//memcpy(ret_hwaddr,arp.sHaddr,6);
				//printf("Valid arp reply receved for this address");
				rv = 0;
				break;
			}
		}
		timeout -= time(NULL) - prevTime;
		time(&prevTime);
	}
	printf("%s:%d \n",__FUNCTION__,__LINE__);
	close(s);
	printf("%salid arp replies for this address\n", rv ? "No v" : "V");	 
	return rv;
}
#endif
int get_arp_table_list(char *filename, RTK_ARP_ENTRY_Tp parplist)
{
	FILE *fp;
	char line_buffer[512];	
	char mac_str[13], tmp_mac_str[18];
	char ip_str[16], if_name[16];
	unsigned char mac_addr[6];
	int idx=0, i, j;	
	char *pchar, *pstart, *pend;
	struct in_addr ip_addr;

	if(filename==NULL || parplist==NULL)
		return -1; 
	if((fp= fopen(filename, "r"))==NULL)
		return -1;
	
	while(fgets(line_buffer, sizeof(line_buffer), fp))
	{			
		line_buffer[strlen(line_buffer)-1]='\0';		

		sscanf(line_buffer,"%s %*s %*s %s %*s %s",ip_str,tmp_mac_str,if_name);
		if(strcmp(if_name, "br0")!=0)
			continue;

		inet_aton(ip_str, &ip_addr);
		parplist[idx].ip=ip_addr.s_addr;
		
		for(i=0, j=0; i<17 && j<12; i++)
		{
			if(tmp_mac_str[i]!=':')
			{
				mac_str[j++]=tmp_mac_str[i];
			}
		}
		mac_str[12]=0;			
			
		if (strlen(mac_str)==12 && string_to_hex(mac_str, mac_addr, 12)) 
		{
			memcpy(parplist[idx].mac, mac_addr, 6);
			idx++;
		}		
	}
	fclose(fp);
	return idx;		
}

static int getDhcpClient(char **ppStart, unsigned long *size, unsigned char *hname, unsigned int *ip, unsigned char *mac, unsigned int *lease)
{
	struct dhcpOfferedAddr 
	{
		unsigned char chaddr[16];
		unsigned int yiaddr;       /* network order */
		unsigned int expires;      /* host order */
//#if defined(CONFIG_RTL8186_KB) || defined(CONFIG_RTL8186_TR) || defined(CONFIG_RTL865X_SC) || defined(CONFIG_RTL865X_AC) || defined(CONFIG_RTL865X_KLD)
		char hostname[64]; /* Brad add for get hostname of client */
		u_int32_t isUnAvailableCurr;	/* Brad add for WEB GUI check */
//#endif
	};

	struct dhcpOfferedAddr entry;
	unsigned char empty_haddr[16]; 

	memset(empty_haddr, 0, 16); 
	//printf("%s:%d size=%d\n",__FUNCTION__,__LINE__,*size);
	if ( *size < sizeof(entry) )
		return -1;

	entry = *((struct dhcpOfferedAddr *)*ppStart);
	*ppStart = *ppStart + sizeof(entry);
	*size = *size - sizeof(entry);
	//printf("%s:%d expires=%d\n",__FUNCTION__,__LINE__,entry.expires);

	if (entry.expires == 0)
		return 0;
	//printf("%s:%d\n",__FUNCTION__,__LINE__);

	if(!memcmp(entry.chaddr, empty_haddr, 16))
		return 0;

	//strcpy(ip, inet_ntoa(*((struct in_addr *)&entry.yiaddr)) );
	*ip=entry.yiaddr;
	memcpy(mac, entry.chaddr, 6);
	
	//snprintf(mac, 20, "%02x:%02x:%02x:%02x:%02x:%02x",entry.chaddr[0],
	//	entry.chaddr[1],entry.chaddr[2],entry.chaddr[3],entry.chaddr[4], entry.chaddr[5]);
	//if(entry.expires == 0xffffffff)
	//	sprintf(liveTime,"%s", "Always");
	//else
	//	snprintf(liveTime, 10, "%lu", (unsigned long)ntohl(entry.expires));
	*lease=entry.expires;
	
	if(entry.hostname[0])
		strcpy(hname, entry.hostname);
	
	return 1;
}

/*
  *@name rtk_get_dhcp_client_list
  *@ input 
     rtk_dhcp_client_info *, the pointer of lan dhcp client list which specific every client info, such as host name, ip, mac, lease time 
  *@output
     num , unsigned int *, which hold the num of dhcp client.
  *@ return value
  	RTK_SUCCESS
  	RTK_FAILED
  *
  */
int rtk_get_dhcp_client_list(unsigned int *num, struct rtk_dhcp_client_info *pclient)
{	
	FILE *fp;
	int idx=0, ret;
	char *buf=NULL, *ptr, tmpBuf[100];
	unsigned int ip, lease;
	unsigned char mac[6], hostname[64];

	struct stat status;
	int pid;
	unsigned long fileSize=0;
	// siganl DHCP server to update lease file
	pid = getPid(_PATH_DHCPS_PID);
	snprintf(tmpBuf, 100, "kill -SIGUSR1 %d\n", pid);

	if ( pid > 0)
		system(tmpBuf);

	usleep(1000);

	if ( stat(_PATH_DHCPS_LEASES, &status) < 0 )
		goto err;

	fileSize=status.st_size;
	buf = malloc(fileSize);
	if ( buf == NULL )
		goto err;
	fp = fopen(_PATH_DHCPS_LEASES, "r");
	if ( fp == NULL )
		goto err;

	fread(buf, 1, fileSize, fp);
	fclose(fp);

	ptr = buf;
	while (1) 
	{
		ret = getDhcpClient(&ptr, &fileSize, hostname, &ip, mac, &lease);
//		printf("%s:%d ret=%d\n",__FUNCTION__,__LINE__,ret);

		if (ret < 0)
			break;
		if (ret == 0)
			continue;

		strcpy(pclient[idx].hostname, hostname);
		pclient[idx].ip=ip;
		memcpy(pclient[idx].mac, mac, 6);
		pclient[idx].expires=lease;
		
//		printf("%s:%d pclient[%d].expires=%d\n",__FUNCTION__,__LINE__,idx,pclient[idx].expires);
	//	if(strcmp(pclient[idx].hostname, "null")==0)
		//	strcpy(pclient[idx].hostname, pclient[idx].brand);
		
		idx++;
		if(idx>=MAX_STA_NUM)
			return -1;
	}
	
err:
	*num=idx;
	if (buf)
		free(buf);
	
	return 0;
}

/********************************************************
** get dst mac index, if not exist, add the mac to (the end of) arrary
*********************************************************/
int getDstMacIdx(RTK_LAN_DEVICE_INFO_Tp pdevinfo,unsigned char mac[6],int max_num)
{
	int i=0;
	char mac_null[6]={0};
	for(i=0;i<max_num;i++)
	{
		if(memcmp(pdevinfo[i].mac,mac,6)==0)
		{
			
			//printf("%s:%d mac=%02x:%02x:%02x:%02x:%02x:%02x\n",__FUNCTION__,__LINE__,mac[0],mac[1],mac[2],mac[3],mac[4],mac[5]);
			return i;
		}
		if(memcmp(pdevinfo[i].mac,mac_null,6)==0)
		{
			//printf("%s:%d\n",__FUNCTION__,__LINE__);
			memcpy(pdevinfo[i].mac,mac,6);
			return i;
		}
	}
	return max_num;
}

/*
        get port status info by proc/rtl865x/asicCounter
*/
void GetPortStatus(int port_number,rtk_asicConterInfo *info)
{
        /*fill cur_rx /cur_tx parememter */
        FILE *fp=NULL;
        int  line_cnt =0;
        unsigned char buffer[128];
        //system("cat /proc/rtl865x/asicCounter  > /var/tmpResult");    

        //if((fp = fopen("/var/tmpResult","r+")) != NULL)
        if((fp = fopen("/proc/rtl865x/asicCounter","r+")) != NULL)
        {
                while(fgets(buffer, 128, fp))
                {
                        line_cnt++;
                        if(line_cnt == 12*port_number+3)        //update receive bytes
                        {
                                sscanf(buffer," Rcv %u ",&(info->rxBytes));
                        }

                        if(line_cnt == 12*port_number+10)       //update send bytes
                        {
                                sscanf(buffer," Snd %u ",&(info->txBytes));
                                fclose(fp);
                                return ;
                        }
                }
        }
        fclose(fp);
}

/*
  *@name rtk_get_lan_device_info
  *@ input 
     pdevinfo , the pointer of lan device info
     MAX_NUM, the max number of lan device, should be MAX_STA_NUM+1
  *@output
     num ,  hold the lan device number
  *@ return value
  	-1:fail
  	0:ok
  *
  */
int rtk_get_lan_device_info(unsigned int *num, RTK_LAN_DEVICE_INFO_Tp pdevinfo,int max_num)
{	
	int l2_tab_num=0,i=0,wifi_sta_num=0,arp_entry_num=0,dhcp_device_num=0,devInfoIdx=0;
	rtk_l2Info l2list[MAX_STA_NUM+1]={0};
	rtk_asicConterInfo asicConInfo={0};
	WLAN_STA_INFO_T wlanStaList[MAX_STA_NUM]={0};
	RTK_ARP_ENTRY_T arp_tab[ARP_TABLE_MAX_NUM]={0};
	struct in_addr lan_addr;
    struct sockaddr hwaddr;
	unsigned char lan_mac[6];
	struct rtk_dhcp_client_info dhcp_client_info[MAX_STA_NUM+1]={0};
	char mac_null[6]={0};
	int devNum=0,ret=0;
	
	if(num==NULL || pdevinfo==NULL || max_num<MAX_STA_NUM)
		return -1;
	bzero(pdevinfo,sizeof(RTK_LAN_DEVICE_INFO_T)*max_num);
	
	getInAddr("br0", IP_ADDR_T, (void *)&lan_addr);
    getInAddr("br0", HW_ADDR_T, (void *)&hwaddr);
    memcpy(lan_mac, hwaddr.sa_data, 6);

//l2 table
	l2_tab_num=get_info_from_l2_tab("/proc/rtl865x/l2", l2list);
	for(i=0;i<l2_tab_num;i++)
	{//assign all mac in pdevinfo, get mac index. if mac not exist, add it to pdevinfo arrary
		devInfoIdx=getDstMacIdx(pdevinfo,l2list[i].mac,MAX_STA_NUM);	
		//printf("%s:%d mac=%02x:%02x:%02x:%02x:%02x:%02x\n",__FUNCTION__,__LINE__,maclist[i][0],maclist[i][1],maclist[i][2],maclist[i][3],maclist[i][4],maclist[i][5]);
		pdevinfo[devInfoIdx].conType=RTK_ETHERNET;

		GetPortStatus(l2list[i].portNum,&asicConInfo);
		pdevinfo[devInfoIdx].tx_bytes=asicConInfo.rxBytes;
		pdevinfo[devInfoIdx].rx_bytes=asicConInfo.txBytes;		
	}
//	printf("%s:%d \n",__FUNCTION__,__LINE__);
	
//wlan0
	//printf("sizeof maclist=%d\n",sizeof(maclist));
	bzero(wlanStaList,sizeof(wlanStaList));
	getWlStaInfo("wlan0", wlanStaList);
	for(i=0;i<MAX_STA_NUM;i++)
	{
		if(wlanStaList[i].aid && (wlanStaList[i].flag & STA_INFO_FLAG_ASOC))
		{
			devInfoIdx=getDstMacIdx(pdevinfo,wlanStaList[i].addr,MAX_STA_NUM);	
#if defined(CONFIG_RTL_92D_SUPPORT)
			pdevinfo[devInfoIdx].conType=RTK_WIRELESS_5G;
#else
			pdevinfo[devInfoIdx].conType=RTK_WIRELESS_2G;
#endif
			pdevinfo[devInfoIdx].on_link=1;
			pdevinfo[devInfoIdx].tx_bytes=wlanStaList[i].rx_bytes;
			pdevinfo[devInfoIdx].rx_bytes=wlanStaList[i].tx_bytes;
		}
	}
	
#if defined(CONFIG_RTL_92D_SUPPORT)
//wlan1
	bzero(wlanStaList,sizeof(wlanStaList));
	getWlStaInfo("wlan1", wlanStaList);
	for(i=0;i<MAX_STA_NUM;i++)
	{
		if(wlanStaList[i].aid && (wlanStaList[i].flag & STA_INFO_FLAG_ASOC))
		{
			devInfoIdx=getDstMacIdx(pdevinfo,wlanStaList[i].addr,MAX_STA_NUM);
			pdevinfo[devInfoIdx].conType=RTK_WIRELESS_2G;
			pdevinfo[devInfoIdx].on_link=1;
			pdevinfo[devInfoIdx].tx_bytes=wlanStaList[i].rx_bytes;
			pdevinfo[devInfoIdx].rx_bytes=wlanStaList[i].tx_bytes;
		}
	}
#endif

//arp table
	arp_entry_num=get_arp_table_list("/proc/net/arp", arp_tab);
	//printf("%s:%d \n",__FUNCTION__,__LINE__);

	for(i=0;i<arp_entry_num;i++)
	{
		devInfoIdx=getDstMacIdx(pdevinfo,arp_tab[i].mac,MAX_STA_NUM);
		//printf("%s:%d devInfoIdx=%d mac=%02x:%02x:%02x:%02x:%02x:%02x\n",__FUNCTION__,__LINE__,devInfoIdx,
		//arp_tab[i].mac[0],arp_tab[i].mac[1],arp_tab[i].mac[2],arp_tab[i].mac[3],arp_tab[i].mac[4],arp_tab[i].mac[5]);
		pdevinfo[devInfoIdx].ip=arp_tab[i].ip;
		//printf("%s:%d ip=0x%x\n",__FUNCTION__,__LINE__,pdevinfo[devInfoIdx].ip);
		if(pdevinfo[devInfoIdx].conType==RTK_ETHERNET)
		//if(sendArpToCheckDevIsAlive(pdevinfo[devInfoIdx].ip,lan_addr.s_addr, lan_mac)==0)
			pdevinfo[devInfoIdx].on_link=1;
		//printf("%s:%d \n",__FUNCTION__,__LINE__);
	}

//dhcp list
	rtk_get_dhcp_client_list(&dhcp_device_num, &dhcp_client_info);
	//printf("%s:%d dhcp_device_num=%d\n",__FUNCTION__,__LINE__,dhcp_device_num);

	for(i=0;i<dhcp_device_num;i++)
	{
		devInfoIdx=getDstMacIdx(pdevinfo,dhcp_client_info[i].mac,MAX_STA_NUM);
		strcpy(pdevinfo[devInfoIdx].hostname,dhcp_client_info[i].hostname);
		pdevinfo[devInfoIdx].ip=dhcp_client_info[i].ip;
		pdevinfo[devInfoIdx].expires=dhcp_client_info[i].expires;
	}
	
	
	devNum=getDstMacIdx(pdevinfo,mac_null,MAX_STA_NUM);
	for(i=0;i<devNum;i++)
	{
		if(!pdevinfo[i].hostname[0])
			strcpy(pdevinfo[i].hostname,"---");
		ret=rtk_get_device_brand(pdevinfo[i].mac, _PATH_DEVICE_MAC_BRAND, pdevinfo[i].brand);
		if(ret<0)
			strcpy(pdevinfo[i].brand,"---");
	}

	*num=devNum;
	return 0;
	
}
int showClients(request *wp, int argc, char **argv)
{
	RTK_LAN_DEVICE_INFO_T devinfo[MAX_STA_NUM]={0};
	int num=0,nBytesSent=0,i=0;
	char deviceIp[32]={0};
	char deviceMac[32]={0};
	char connectType[32]={0};
	char linkState[16]={0};
	
	rtk_get_lan_device_info(&num,devinfo,MAX_STA_NUM);
	//printf("%s:%d client num=%d\n",__FUNCTION__,__LINE__,num);
	
	nBytesSent += req_format_write(wp,("<tr class=\"tbl_head\">"));
	nBytesSent += req_format_write(wp,("<td align=center><font size=2><b>name</b></td>"));
	nBytesSent += req_format_write(wp,("<td align=center><font size=2><b>ip address</b></td>"));
	nBytesSent += req_format_write(wp, ("\
	<td align=center><font size=2><b>mac address</b></td>\
	<td align=center><font size=2><b>dhcp expires</b></td>\
	<td align=center><font size=2><b>connect type</b></td>\
	<td align=center><font size=2><b>active</b></td>\
	<td align=center><font size=2><b>rx bytes</b></td>\
	<td align=center><font size=2><b>tx bytes</b></td>\
	<td align=center><font size=2><b>brand</b></td></tr>"));
	//	
	for(i=0;i<num;i++)
	{
		strcpy(deviceIp,inet_ntoa((*((struct in_addr *)&(devinfo[i].ip)))));
		sprintf(deviceMac,"%02x:%02x:%02x:%02x:%02x:%02x",devinfo[i].mac[0],devinfo[i].mac[1],devinfo[i].mac[2],devinfo[i].mac[3],devinfo[i].mac[4],devinfo[i].mac[5]);
		
		//printf("%s:%d \n",__FUNCTION__,__LINE__);
		switch(devinfo[i].conType)
		{
			case RTK_LINK_ERROR:
				sprintf(connectType,"-----");
				break;
			case RTK_ETHERNET:
				sprintf(connectType,"ethernet");
				break;
			case RTK_WIRELESS_5G:
				sprintf(connectType,"wifi 5G");
				break;
			case RTK_WIRELESS_2G:
				sprintf(connectType,"wifi 2.4G");
				break;
			default:
				break;
		}
		if(devinfo[i].on_link)
		{
			sprintf(linkState,"on");
		}else
		{
			sprintf(linkState,"off");
		}
		nBytesSent += req_format_write(wp,("<tr class=\"tbl_body\">"));
//printf("%s:%d \n",__FUNCTION__,__LINE__);
//printf((" %s %s %s %d %s %d %d %s\n"),
//	devinfo[i].hostname,deviceIp,deviceMac,devinfo[i].expires,connectType,devinfo[i].rx_bytes,devinfo[i].tx_bytes,devinfo[i].brand);
		//printf("%s:%d i=%d brand=%s rx=%d tx=%d\n",__FUNCTION__,__LINE__,i,devinfo[i].brand,devinfo[i].rx_bytes,devinfo[i].tx_bytes);
		nBytesSent += req_format_write(wp, ("<td>%s</td><td>%s</td><td>%s</td><td>%d</td><td>%s</td><td>%s</td><td>%d</td><td>%d</td><td>%s</td>\n"),
			devinfo[i].hostname,deviceIp,deviceMac,devinfo[i].expires,connectType,linkState,devinfo[i].rx_bytes,devinfo[i].tx_bytes,devinfo[i].brand);
	//	printf("%s:%d \n",__FUNCTION__,__LINE__);
		nBytesSent += req_format_write(wp,"</tr>");
	}
	return nBytesSent;
}

#endif
#ifdef HOME_GATEWAY
#ifdef CONFIG_APP_WEAVE
#define WEAVE_REG_TIMEOUT 50
void formWeave(request *wp, char *path, char *query)
{
	char tmpBuf[MAX_MSG_BUFFER_SIZE]={0};
	char cmdBuf[MAX_MSG_BUFFER_SIZE]={0};
	int weave_resgitered=0; 
	char *submitUrl=req_get_cstream_var(wp, ("submit-url"), "");

	char *command=req_get_cstream_var(wp, ("command"), "");
	//printf("%s:%d\n",__FUNCTION__,__LINE__);
	if(strcmp(command,"unregister device")==0)
	{
		weave_resgitered=0;
		apmib_set(MIB_WEAVE_REGISTERED,&weave_resgitered);

        // clear json file
        if(isFileExist(WEAVE_FILE_PATH))
        {
            memset(cmdBuf, 0x0, MAX_MSG_BUFFER_SIZE);
            sprintf(cmdBuf, "echo \"{}\" >%s", WEAVE_FILE_PATH);
            system(cmdBuf);

            memset(cmdBuf, 0x0, MAX_MSG_BUFFER_SIZE);
            sprintf(cmdBuf, "flash set_weaveConf %s", WEAVE_FILE_PATH);
            system(cmdBuf);

            memset(cmdBuf, 0x0, MAX_MSG_BUFFER_SIZE);
            system("flash set wlan1-vxd SSID 1b23456789098765432a1");
            system("flash set REPEATER_SSID2 1b23456789098765432a1");
        }
        system("killall weave_daemon");
        sprintf(tmpBuf, "Unregister succeed!!!");
#ifdef REBOOT_CHECK
        sprintf(lastUrl,"%s","/weave.htm");
        sprintf(okMsg,"%s",tmpBuf);
        int Reboot_Wait = 30;
        countDownTime = Reboot_Wait;
        send_redirect_perm(wp, COUNTDOWN_PAGE);
        run_init_script_flag = 1;
        run_init_script("all");
#else
        OK_MSG_FW(tmpBuf, submitUrl,Reboot_Wait,lan_ip);
#endif
        //system("init.sh gw all");
	}
	else if(strcmp(command,"register device")==0)
	{
		char strWanIP[16];
		char strWanMask[16];
		char strWanDefIP[16];
		char strWanHWAddr[18];
		int timeOut=0;
		
		char *registration_ticket=req_get_cstream_var(wp, ("weaveInfoText"), "");
		
		//printf("%s:%d\n",__FUNCTION__,__LINE__);
		getWanInfo(strWanIP,strWanMask,strWanDefIP,strWanHWAddr);
		if(strcmp(strWanIP,"0.0.0.0")==0)
		{
			sprintf(tmpBuf,"WAN not connect can't connect to cloud! can't register device!");
			goto FMWEAVE_ERROR;
		}
		if(!registration_ticket[0])
		{
			sprintf(tmpBuf,"Not get registration_ticket!\n");
			goto FMWEAVE_ERROR;
		}
		//printf("%s:%d\n",__FUNCTION__,__LINE__);

		sprintf(cmdBuf,"rm %s 2>/dev/null",WEAVE_FILE_PATH);
		system(cmdBuf);
		system("killall weave_daemon 2>/dev/null");
		sprintf(cmdBuf,"weave_daemon --registration_ticket=%s &",registration_ticket);
		system(cmdBuf);
		while(timeOut++<WEAVE_REG_TIMEOUT)
		{
			sleep(1);
			apmib_get(MIB_WEAVE_REGISTERED,&weave_resgitered);
			if(weave_resgitered)
				break;
		}
		if(timeOut>=WEAVE_REG_TIMEOUT)
		{
			FAIL_INFO("Fail! timeout!Please make sure wan connect to google cloud!\n",submitUrl);
			return;
		}
		SUCCESS_INFO("Register device success!\n",submitUrl);
		return;
		//printf("%s:%d\n",__FUNCTION__,__LINE__);
	}
	else if(strcmp(command,"register_success")==0)
	{
		
	}
	else if(strcmp(command,"register_failed")==0)
	{
		
	}
	else
	{
		sprintf(tmpBuf,"error! command is invalid!");
		goto FMWEAVE_ERROR;
	}
	if(submitUrl[0])
		send_redirect_perm(wp,submitUrl);
	else
		printf("error! submitUrl is null");
	//printf("%s:%d\n",__FUNCTION__,__LINE__);

	return;
FMWEAVE_ERROR:
	
	ERR_MSG(tmpBuf);

	return;
}
#endif
#endif

int write_to_file(char *file, int size, char *data)
{
	FILE *fp = NULL;
	int writen = 0;
	fp = fopen(file, "w");

	if ( fp == NULL ) {
		return -1;
	}

	writen = fwrite(data, 1, size, fp);

	if (writen <= 0) {
		return -1;
	}

	fclose(fp);

	return 0;
}

unsigned char *find_next_boundary(unsigned char *data, int size, char* boundary) {
	unsigned char *cp = NULL;
	unsigned char *dp = NULL;
	int blen = strlen(boundary);

	cp = data;
	dp = data+size;
	for(;cp<dp;cp++) {
		if ((memcmp(cp, "\r\n", 2) == 0) && (memcmp(cp+2, boundary, blen)==0)) {
			break;
		}
	}
	return cp;
}

int encode_image(char *input, char *output)
{
	int ret = 0;

#if 0
	FILE *fp0=NULL;
	FILE *fp1=NULL;
	unsigned char key[EVP_MAX_KEY_LENGTH+1]={0};
	unsigned char iv[EVP_MAX_IV_LENGTH+1]={0};

	sleep(1);
	memset (key, 0, EVP_MAX_KEY_LENGTH+1);
	memset (iv, 0, EVP_MAX_IV_LENGTH+1);
	MKY(key, iv);
	sleep(1);

	if ((fp0 = fopen(input, "r")) == NULL) {
		return -1;
	}

	if ((fp1 = fopen(output, "w")) == NULL) {
		fclose(fp0);
		fp0 = NULL;
		return -1;
	}

	ret = ECT(key, iv, fp0, fp1);

	fclose(fp0);
	fp0 = NULL;
	fclose(fp1);
	fp1 = NULL;
#else
	char cmd_buf[256] = "";

	snprintf(cmd_buf, 256, "efdgx -e -i %s -o %s", input, output);
	ret = system(cmd_buf);
#endif

	return ret;
}

int decode_image(char *input, char *output)
{
	int ret = 0;

#if 0
	FILE *fp0=NULL;
	FILE *fp1=NULL;
	unsigned char key[EVP_MAX_KEY_LENGTH+1]={0};
	unsigned char iv[EVP_MAX_IV_LENGTH+1]={0};

	sleep(1);
	memset (key, 0, EVP_MAX_KEY_LENGTH+1);
	memset (iv, 0, EVP_MAX_IV_LENGTH+1);
	MKY(key, iv);
	sleep(1);

	if ((fp0 = fopen(input, "r")) == NULL) {
		return -1;
	}

	if ((fp1 = fopen(output, "w")) == NULL) {
		fclose(fp0);
		fp0 = NULL;
		return -1;
	}

	ret = DCT(key, iv, fp0, fp1);

	fclose(fp0);
	fp0 = NULL;
	fclose(fp1);
	fp1 = NULL;
#else
	char cmd_buf[256] = "";

	snprintf(cmd_buf, 256, "efdgx -d -i %s -o %s", input, output);
	ret = system(cmd_buf);
#endif

	return ret;
}
