#include <linux/icmpv6.h>
#include <linux/init.h>
#include <linux/module.h>
#include <linux/mutex.h>
#include <linux/netdevice.h>
#include <linux/skbuff.h>
#include <linux/slab.h>
#include <net/ipv6.h>
#include <net/protocol.h>
#include <net/xfrm.h>
#include <net/ip6_tunnel.h>
#include <linux/if_tunnel.h>
#include <net/netns/generic.h>
#include <linux/inetdevice.h>
#include "dslite_enhancement.h"

static int after_check = DSLITE_OFF;
static int hoplimit_set = DSLITE_ON;
static char lan_ifname[IFNAMSIZ] = "br0";

int dslite_option_ioctl(struct ifreq *ifr, int cmd)
{
	int ret =  -EINVAL;
	struct ip6_tnl_parm p;

#if 0  /* chiron step3 */
	if (cmd == SIOCDSLITEOP) {
		if (!capable(CAP_NET_ADMIN))
			return ret;
                if (copy_from_user(&p, ifr->ifr_ifru.ifru_data, sizeof (p)))
			return ret;

		/* AFTR addr check */
		if (p.flags & IP6_DSLITE_AFTRCHK) {
			after_check = DSLITE_ON;
			ret = 0;
		}
		else {
			after_check = DSLITE_OFF;
			ret = 0;
		}

		/* hoplimit inherit */
		if (p.flags & IP6_DSLITE_HOPLIMIT_SET) {
			hoplimit_set = DSLITE_ON;
			ret = 0;
		}
		else {
			hoplimit_set = DSLITE_OFF;
			ret = 0;
		}

		/* lanifname */
		if (p.lan_name[0] != '\0') {
			strncpy(lan_ifname, p.lan_name, IFNAMSIZ-1);
			ret = 0;
		}
	}
#endif /* chiron step3 */
	return ret;
}
EXPORT_SYMBOL(dslite_option_ioctl);

/*  return   0:check OK   1:check NG */
int dslite_check_aftr(struct ip6_tnl *tnl, const struct in6_addr *remote, const struct in6_addr *local)
{
	int ret = DSLITE_NG; /* init NG*/

	if (ipv6_addr_equal(local, &tnl->parms.laddr) && (tnl->dev->flags & IFF_UP)) {
		ret = DSLITE_OK; /* set OK */
		if (after_check == DSLITE_ON) {
			if (!ipv6_addr_equal(remote, &tnl->parms.raddr)) {
				ret = DSLITE_NG;  /* set NG */
			}
		}
	}
	return ret;
}
EXPORT_SYMBOL(dslite_check_aftr);

/* nobori */
#if 0
int dslite_check_localnet(struct ip6_tnl *t, struct sk_buff *skb)
{
	struct net_device *dev = NULL;
	struct in_device *in_dev = NULL;
	struct in_ifaddr *ifa;
	struct iphdr *inner = (struct iphdr *)skb_transport_header(skb);

	dev = dev_get_by_name(&init_net,lan_ifname);
	if (dev == NULL) {
		return DSLITE_NG;
	}
	in_dev = __in_dev_get_rtnl(dev);
	if (in_dev == NULL) {
		return DSLITE_NG;
	}

	for (ifa = in_dev->ifa_list; ifa; ifa = ifa->ifa_next) {
		if (inet_ifa_match(inner->daddr, ifa)) {
			return DSLITE_OK;
		}
	}

	if (t->dev == NULL) {
		return DSLITE_NG;
	}
	in_dev = __in_dev_get_rtnl(t->dev);
	if (in_dev == NULL) {
		return DSLITE_NG;
	}
	for (ifa = in_dev->ifa_list; ifa; ifa = ifa->ifa_next) {
		if (inner->daddr == ifa->ifa_address) {
			return DSLITE_OK;
		}
	}

	return DSLITE_NG;
}
EXPORT_SYMBOL(dslite_check_localnet);
#endif

u8 dslite_hoplimit(struct ip6_tnl *t, struct sk_buff *skb)
{
	struct iphdr *inner = ip_hdr(skb);

	if (hoplimit_set == DSLITE_ON) {
		return t->parms.hop_limit;
	}
	else {
		return inner->ttl;
	}
}
EXPORT_SYMBOL(dslite_hoplimit);

int dslite_check_mtu(struct sk_buff *skb, __u32 *pmtu, __u32 mtu)
{
	int ret = 0;
	struct iphdr *inner = ip_hdr(skb);

	skb->local_df = 1;
	if (skb->len > mtu) {
		*pmtu = mtu;
		if (inner->frag_off & htons(IP_DF)) {
			ret = -EMSGSIZE;
			skb->local_df = 0;
		}
	}

	return ret;
}
EXPORT_SYMBOL(dslite_check_mtu);

static int __init dslite_enhancement_init(void)
{
        return 0;
}

static void __exit dslite_enhancement_fini(void)
{
        printk("dslite_enhancement_finish");
}

module_init(dslite_enhancement_init);
module_exit(dslite_enhancement_fini);
