/*
 * Dual licensed under the ISC license and the GPL2.
 */


#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <fcntl.h>
#include <errno.h>
#include <limits.h>

#include "ctl_comm.h"




#define	CTRL_SOCK_BASE_NAME	"/tmp/local_%d.sock"


static int	zm_ctrl_sock = -1;


static comm_msg_t*	zm_prxbuf;
static char		zm_sock_fname[NAME_MAX];

static ctl_comm_rx_dispatch	zm_rx_dispatch;




/*******************************************************************************/
/*******************************************************************************/
static int  common_init( void )
{
	int	res = 0;

	if( (zm_prxbuf = malloc( sizeof(*zm_prxbuf) )) == NULL ){
		res = errno;
		goto l_exit;
	}

  l_exit:;
	return res;
}


/*
 */
int  ctl_comm_send_msg( int  conn_sock, int  remote_fd, comm_msg_t*  p_msg, unsigned int  tmout_msec )
{
	return dom_sock_send_fd_msg( conn_sock, remote_fd, p_msg, sizeof(*p_msg), tmout_msec );
}


/*
 */
int  ctl_comm_recv_msg( int  conn_sock, int*  p_remote_fd, comm_msg_t*  p_msg, unsigned int  tmout_msec )
{
	return dom_sock_recv_fd_msg( conn_sock, p_remote_fd, p_msg, sizeof(*p_msg), tmout_msec );
}


/*******************************************************************************/
/*******************************************************************************/
/*
 */
int  ctl_comm_mst_init( int  slv_pid, int*  p_sock )
{
	int	res = 0;

	sprintf( zm_sock_fname, CTRL_SOCK_BASE_NAME, slv_pid );

	zm_ctrl_sock = dom_sock_open( zm_sock_fname, DOM_SOCK_CLI );
	if( zm_ctrl_sock >= 0 ){
		if( p_sock ){
			*p_sock = zm_ctrl_sock;
		}
		res = 0;
	} else{
		res = -zm_ctrl_sock;
	}

	return res;
}


/*
 */
int  ctl_comm_mst_exit( void )
{
	if( zm_ctrl_sock >= 0 ){
		dom_sock_close( zm_ctrl_sock );
		zm_ctrl_sock = -1;

		//WNC-NMR2226-JDR230-YUAN-I-CHOU-20161227, Apply BUG2193.patch
		unlink( zm_sock_fname );
		//WNC-NMR2226-JDR230-YUAN-I-CHOU-20161227, Apply BUG2193.patch End
	}

	return 0;
}


/*
 */
int  ctl_comm_mst_connect( int  sock, unsigned int  tmout_msec )
{
	return dom_sock_connect( sock, tmout_msec );
}


/*******************************************************************************/
/*******************************************************************************/
/*
 */
int  ctl_comm_slv_init( ctl_comm_rx_dispatch  hook )
{
	int	res = 0;

	res = common_init();
	if( res ){
		goto l_exit;
	}

	zm_rx_dispatch = hook;

	sprintf( zm_sock_fname, CTRL_SOCK_BASE_NAME, getpid() );

	zm_ctrl_sock = dom_sock_open( zm_sock_fname, DOM_SOCK_SERV );
	if( zm_ctrl_sock >= 0 ){
		res = 0;
	} else{
		res = -zm_ctrl_sock;
	}

  l_exit:;
	return res;
}


/*
 */
int  ctl_comm_slv_exit( void )
{
	if( zm_ctrl_sock >= 0 ){
		dom_sock_close( zm_ctrl_sock );
		zm_ctrl_sock = -1;

		unlink( zm_sock_fname );
	}

	return 0;
}


/*
 */
static int  ctl_comm_slv_conn_loop( int  conn_sock )
{
	int	res = 0;

	for( ; ; ){
		res = dom_sock_recv_fd_msg( conn_sock, NULL, zm_prxbuf, sizeof(*zm_prxbuf), DOM_SOCK_NO_TMOUT );
		if( res ){
			switch( res ){
			case EAGAIN:
				/* fall through */
#if (EWOULDBLOCK != EAGAIN)
			case EWOULDBLOCK:
				/* fall through */
#endif
				continue;	/* XXX ??? */
				break;
			case EINTR:
				/* fall through */
			default:
				goto l_exit;
			}
		} else{
			if( zm_rx_dispatch ){
				res = (*zm_rx_dispatch)( conn_sock, zm_prxbuf );
				if( res ){
					break;
				}
			}
		}
	}

  l_exit:;
	dom_sock_close( conn_sock );

	return res;
}


/*
 */
int  ctl_comm_slv_loop( void )
{
	int	conn_sock = -1;
	int	res = 0;

	for( ; ; ){
		conn_sock = dom_sock_accept( zm_ctrl_sock );
		if( conn_sock < 0 ){
			switch( -conn_sock ){
			case EAGAIN:
				/* fall through */
#if (EWOULDBLOCK != EAGAIN)
			case EWOULDBLOCK:
				/* fall through */
#endif
			case ECONNABORTED:
				continue;
				break;
			case EINTR:
				/* fall through */
			default:
				res = -conn_sock;
				goto l_exit;
				break;
			}
		}
		res = ctl_comm_slv_conn_loop( conn_sock );
		if( res ){
			break;
		}
	}

  l_exit:;
	return res;
}


/*
 * EOF
 */
