/*
 * Dual licensed under the ISC license and the GPL2.
 */


#ifndef __CTL_COMM_H
#define __CTL_COMM_H


#include "dom_sock.h"


/*********************************************/
/*********************************************/
enum {
	COMM_CMD_NONE	= 0,

	COMM_CMD_IPC_PING,

	COMM_CMD_CONNECT,
	COMM_CMD_DISCONNECT,
	COMM_CMD_CHK_OPTIONS,
	COMM_CMD_EXTRA_OPTIONS,

	COMM_CMD_NUM		/* indicate number of commands */
};



/*--------------------------------*/
/*--------------------------------*/
typedef struct {
	int	val;
} comm_msg_data_ping_t;

typedef struct {
	char	remote_number[64];
	char	ppp_devname[48];
} comm_msg_data_conn_t;

typedef struct {
	struct {

		unsigned char	neg_accompression;
		unsigned char	neg_asyncmap;
		unsigned char	neg_pcompression;
		unsigned char	dummy1;
		int		mru;
	} lcp;
	struct {
		unsigned char	deflate;
		unsigned char	bsd_compress;
		unsigned char	dummy1[2];
	} ccp;
	struct {
		unsigned char	neg_vj;
		unsigned char	dummy1[3];
	} ipcp;
} comm_msg_data_chk_opt_t;


/*********************************************/
/*********************************************/
#define	COMM_MSG_LEN	(128)

typedef struct {
	int	cmd;
	int	err;
	union {
		unsigned char		data[4];
		comm_msg_data_ping_t	ping;
		comm_msg_data_conn_t	conn;
		comm_msg_data_chk_opt_t	chkopt;
	} u;
} comm_msg_t;


#define	COMM_MSG_DATA_LEN	(sizeof(comm_msg_t) - (int)(((comm_msg_t*)0)->u.data))


/*********************************************/
/*********************************************/

typedef int	(*ctl_comm_rx_dispatch)( int  conn_sock, comm_msg_t* );

extern int	ctl_comm_mst_init( int, int* );
extern int	ctl_comm_mst_exit( void );
extern int	ctl_comm_mst_connect( int, unsigned int  tmout_msec );

extern int	ctl_comm_slv_init( ctl_comm_rx_dispatch );
extern int	ctl_comm_slv_exit( void );
extern int	ctl_comm_slv_loop( void );

extern int	ctl_comm_send_msg( int  conn_sock, int  remote_fd, comm_msg_t*, unsigned int  tmout_msec );
extern int	ctl_comm_recv_msg( int  conn_sock, int* p_remote_fd, comm_msg_t*, unsigned int  tmout_msec );


#define	CTL_COMM_NO_FD		(-1)
#define	CTL_COMM_NO_TMOUT	(DOM_SOCK_NO_TMOUT)




#endif	/* __CTL_COMM_H */
