/****************************************************************************** 
* 
* Copyright(c) 2007 - 2011 Realtek Corporation. All rights reserved. 
* 
* This program is free software; you can redistribute it and/or modify it 
* under the terms of version 2 of the GNU General Public License as 
* published by the Free Software Foundation. 
* 
* This program is distributed in the hope that it will be useful, but WITHOUT 
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
* more details. 
* 
* You should have received a copy of the GNU General Public License along with 
* this program; if not, write to the Free Software Foundation, Inc., 
* 51 Franklin Street, Fifth Floor, Boston, MA 02110, USA 
* 
* 
******************************************************************************/

/*Image2HeaderVersion: 2.22*/
#include "mp_precomp.h"
#include "../phydm_precomp.h"

#if (RTL8821C_SUPPORT == 1)
static BOOLEAN
CheckPositive(
	IN  PDM_ODM_T     pDM_Odm,
	IN  const u4Byte  Condition1,
	IN  const u4Byte  Condition2,
	IN	const u4Byte  Condition3,
	IN	const u4Byte  Condition4
)
{
	u1Byte    _BoardType = ((pDM_Odm->BoardType & BIT4) >> 4) << 0 | /* _GLNA*/
				((pDM_Odm->BoardType & BIT3) >> 3) << 1 | /* _GPA*/ 
				((pDM_Odm->BoardType & BIT7) >> 7) << 2 | /* _ALNA*/
				((pDM_Odm->BoardType & BIT6) >> 6) << 3 | /* _APA */
				((pDM_Odm->BoardType & BIT2) >> 2) << 4;  /* _BT*/  

	u4Byte	cond1   = Condition1, cond2 = Condition2, cond3 = Condition3, cond4 = Condition4;
	u4Byte    driver1 = pDM_Odm->CutVersion       << 24 | 
				(pDM_Odm->SupportInterface & 0xF0) << 16 | 
				pDM_Odm->SupportPlatform  << 16 | 
				pDM_Odm->PackageType      << 12 | 
				(pDM_Odm->SupportInterface & 0x0F) << 8  |
				_BoardType;

	u4Byte    driver2 = (pDM_Odm->TypeGLNA & 0xFF) <<  0 |  
				(pDM_Odm->TypeGPA & 0xFF)  <<  8 | 
				(pDM_Odm->TypeALNA & 0xFF) << 16 | 
				(pDM_Odm->TypeAPA & 0xFF)  << 24; 

u4Byte    driver3 = 0;

	u4Byte    driver4 = (pDM_Odm->TypeGLNA & 0xFF00) >>  8 |
				(pDM_Odm->TypeGPA & 0xFF00) |
				(pDM_Odm->TypeALNA & 0xFF00) << 8 |
				(pDM_Odm->TypeAPA & 0xFF00)  << 16;

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("===> CheckPositive (cond1, cond2, cond3, cond4) = (0x%X 0x%X 0x%X 0x%X)\n", cond1, cond2, cond3, cond4));
	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("===> CheckPositive (driver1, driver2, driver3, driver4) = (0x%X 0x%X 0x%X 0x%X)\n", driver1, driver2, driver3, driver4));

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("	(Platform, Interface) = (0x%X, 0x%X)\n", pDM_Odm->SupportPlatform, pDM_Odm->SupportInterface));
	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_TRACE, 
	("	(Board, Package) = (0x%X, 0x%X)\n", pDM_Odm->BoardType, pDM_Odm->PackageType));


	/*============== Value Defined Check ===============*/
	/*QFN Type [15:12] and Cut Version [27:24] need to do value check*/
	
	if (((cond1 & 0x0000F000) != 0) && ((cond1 & 0x0000F000) != (driver1 & 0x0000F000)))
		return FALSE;
	if (((cond1 & 0x0F000000) != 0) && ((cond1 & 0x0F000000) != (driver1 & 0x0F000000)))
		return FALSE;

	/*=============== Bit Defined Check ================*/
	/* We don't care [31:28] */

	cond1   &= 0x00FF0FFF; 
	driver1 &= 0x00FF0FFF; 

	if ((cond1 & driver1) == cond1) {
		u4Byte bitMask = 0;

		if ((cond1 & 0x0F) == 0) /* BoardType is DONTCARE*/
			return TRUE;

		if ((cond1 & BIT0) != 0) /*GLNA*/
			bitMask |= 0x000000FF;
		if ((cond1 & BIT1) != 0) /*GPA*/
			bitMask |= 0x0000FF00;
		if ((cond1 & BIT2) != 0) /*ALNA*/
			bitMask |= 0x00FF0000;
		if ((cond1 & BIT3) != 0) /*APA*/
			bitMask |= 0xFF000000;

		if (((cond2 & bitMask) == (driver2 & bitMask)) && ((cond4 & bitMask) == (driver4 & bitMask)))  /* BoardType of each RF path is matched*/
			return TRUE;
		else
			return FALSE;
	} else
		return FALSE;
}
static BOOLEAN
CheckNegative(
	IN  PDM_ODM_T     pDM_Odm,
	IN  const u4Byte  Condition1,
	IN  const u4Byte  Condition2
)
{
	return TRUE;
}

/******************************************************************************
*                           RadioA.TXT
******************************************************************************/

u4Byte Array_TC_8821C_RadioA[] = { 
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00010D24,
	0xA0000000,	0x00000000,
		0x000, 0x00030000,
		0x018, 0x00010D24,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000002,
		0x03E, 0x0000003F,
		0x03F, 0x000C0F4E,
		0x033, 0x00000001,
		0x03E, 0x00000034,
		0x03F, 0x0004080E,
	0xA0000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000002,
		0x03E, 0x0000003F,
		0x03F, 0x000C0F4E,
		0x033, 0x00000001,
		0x03E, 0x00000034,
		0x03F, 0x0004080E,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000024,
		0x03E, 0x0000003F,
		0x03F, 0x000E0FDE,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000024,
		0x03E, 0x0000003F,
		0x03F, 0x000E0FDE,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000025,
		0x03E, 0x00000037,
		0x03F, 0x0007EFCE,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000025,
		0x03E, 0x00000037,
		0x03F, 0x0007EFCE,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000026,
		0x03E, 0x00000037,
		0x03F, 0x0005EFCE,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00080000,
		0x033, 0x00000026,
		0x03E, 0x00000037,
		0x03F, 0x0005EFCE,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0B0, 0x000FF0F8,
		0x0B1, 0x0007DBE4,
		0x0B2, 0x000225D1,
		0x0B3, 0x000FC760,
		0x0B4, 0x00099DD0,
		0x0B5, 0x000400FC,
		0x0B6, 0x000187F0,
		0x0B7, 0x00030018,
		0x0B8, 0x00080800,
		0x0B9, 0x00000000,
		0x0BA, 0x00008000,
		0x0BB, 0x00000000,
		0x0BC, 0x00040000,
		0x0BD, 0x00000000,
		0x0BE, 0x00000000,
		0x0BF, 0x00000000,
		0x0C0, 0x00000000,
		0x0C1, 0x00000000,
		0x0C2, 0x00000000,
		0x0C3, 0x00000000,
		0x0C4, 0x00002402,
		0x0C5, 0x00000009,
		0x0C6, 0x00040299,
		0x0C7, 0x00055555,
		0x0C8, 0x0000C16C,
		0x0C9, 0x0001C140,
		0x0CA, 0x00000000,
		0x0CB, 0x00000000,
		0x0CC, 0x00000000,
		0x0CD, 0x00000000,
		0x0CE, 0x00090C00,
		0x0CF, 0x0006D200,
		0x0DF, 0x00000009,
	0xA0000000,	0x00000000,
		0x0B0, 0x000FF0F8,
		0x0B1, 0x0007DBE4,
		0x0B2, 0x000225D1,
		0x0B3, 0x000FC760,
		0x0B4, 0x00099DD0,
		0x0B5, 0x000400FC,
		0x0B6, 0x000187F0,
		0x0B7, 0x00030018,
		0x0B8, 0x00080800,
		0x0B9, 0x00000000,
		0x0BA, 0x00008000,
		0x0BB, 0x00000000,
		0x0BC, 0x00040000,
		0x0BD, 0x00000000,
		0x0BE, 0x00000000,
		0x0BF, 0x00000000,
		0x0C0, 0x00000000,
		0x0C1, 0x00000000,
		0x0C2, 0x00000000,
		0x0C3, 0x00000000,
		0x0C4, 0x00002402,
		0x0C5, 0x00000009,
		0x0C6, 0x00040299,
		0x0C7, 0x00055555,
		0x0C8, 0x0000C16C,
		0x0C9, 0x0001C140,
		0x0CA, 0x00000000,
		0x0CB, 0x00000000,
		0x0CC, 0x00000000,
		0x0CD, 0x00000000,
		0x0CE, 0x00090C00,
		0x0CF, 0x0006D200,
		0x0DF, 0x00000009,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00010524,
		0x089, 0x00000207,
		0x08A, 0x000F5186,
		0x08B, 0x00061830,
		0x08C, 0x000112C7,
		0x08D, 0x00060000,
		0x08E, 0x00064540,
	0xA0000000,	0x00000000,
		0x018, 0x00010524,
		0x089, 0x00000207,
		0x08A, 0x000F5186,
		0x08B, 0x00061830,
		0x08C, 0x000112C7,
		0x08D, 0x00060000,
		0x08E, 0x00064540,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00020000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00020000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x0003C000,
		0x03F, 0x000C3186,
		0x033, 0x00000006,
		0x03E, 0x0003C080,
		0x03F, 0x000C3186,
		0x033, 0x00000005,
		0x03E, 0x0003C0C8,
		0x03F, 0x000C3186,
		0x033, 0x00000004,
		0x03E, 0x0003C190,
		0x03F, 0x000C3186,
		0x033, 0x00000003,
		0x03E, 0x0003C998,
		0x03F, 0x000C3186,
		0x033, 0x00000002,
		0x03E, 0x0003D840,
		0x03F, 0x000C3186,
		0x033, 0x00000001,
		0x03E, 0x0003D8C4,
		0x03F, 0x000C3186,
		0x033, 0x00000000,
		0x03E, 0x0003D930,
		0x03F, 0x000C3186,
	0xA0000000,	0x00000000,
		0x033, 0x00000007,
		0x03E, 0x0003C000,
		0x03F, 0x000C3186,
		0x033, 0x00000006,
		0x03E, 0x0003C080,
		0x03F, 0x000C3186,
		0x033, 0x00000005,
		0x03E, 0x0003C0C8,
		0x03F, 0x000C3186,
		0x033, 0x00000004,
		0x03E, 0x0003C190,
		0x03F, 0x000C3186,
		0x033, 0x00000003,
		0x03E, 0x0003C998,
		0x03F, 0x000C3186,
		0x033, 0x00000002,
		0x03E, 0x0003D840,
		0x03F, 0x000C3186,
		0x033, 0x00000001,
		0x03E, 0x0003D8C4,
		0x03F, 0x000C3186,
		0x033, 0x00000000,
		0x03E, 0x0003D930,
		0x03F, 0x000C3186,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x0003C000,
		0x03F, 0x000C3186,
		0x033, 0x0000000E,
		0x03E, 0x0003C080,
		0x03F, 0x000C3186,
		0x033, 0x0000000D,
		0x03E, 0x0003C0C8,
		0x03F, 0x000C3186,
		0x033, 0x0000000C,
		0x03E, 0x0003C190,
		0x03F, 0x000C3186,
		0x033, 0x0000000B,
		0x03E, 0x0003C998,
		0x03F, 0x000C3186,
		0x033, 0x0000000A,
		0x03E, 0x0003D840,
		0x03F, 0x000C3186,
		0x033, 0x00000009,
		0x03E, 0x0003D8C4,
		0x03F, 0x000C3186,
		0x033, 0x00000008,
		0x03E, 0x0003D930,
		0x03F, 0x000C3186,
	0xA0000000,	0x00000000,
		0x033, 0x0000000F,
		0x03E, 0x0003C000,
		0x03F, 0x000C3186,
		0x033, 0x0000000E,
		0x03E, 0x0003C080,
		0x03F, 0x000C3186,
		0x033, 0x0000000D,
		0x03E, 0x0003C0C8,
		0x03F, 0x000C3186,
		0x033, 0x0000000C,
		0x03E, 0x0003C190,
		0x03F, 0x000C3186,
		0x033, 0x0000000B,
		0x03E, 0x0003C998,
		0x03F, 0x000C3186,
		0x033, 0x0000000A,
		0x03E, 0x0003D840,
		0x03F, 0x000C3186,
		0x033, 0x00000009,
		0x03E, 0x0003D8C4,
		0x03F, 0x000C3186,
		0x033, 0x00000008,
		0x03E, 0x0003D930,
		0x03F, 0x000C3186,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x0003C000,
		0x03F, 0x000C3186,
		0x033, 0x00000016,
		0x03E, 0x0003C080,
		0x03F, 0x000C3186,
		0x033, 0x00000015,
		0x03E, 0x0003C0C8,
		0x03F, 0x000C3186,
		0x033, 0x00000014,
		0x03E, 0x0003C190,
		0x03F, 0x000C3186,
		0x033, 0x00000013,
		0x03E, 0x0003C998,
		0x03F, 0x000C3186,
		0x033, 0x00000012,
		0x03E, 0x0003D840,
		0x03F, 0x000C3186,
		0x033, 0x00000011,
		0x03E, 0x0003D8C4,
		0x03F, 0x000C3186,
		0x033, 0x00000010,
		0x03E, 0x0003D930,
		0x03F, 0x000C3186,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x00000017,
		0x03E, 0x0003C000,
		0x03F, 0x000C3186,
		0x033, 0x00000016,
		0x03E, 0x0003C080,
		0x03F, 0x000C3186,
		0x033, 0x00000015,
		0x03E, 0x0003C0C8,
		0x03F, 0x000C3186,
		0x033, 0x00000014,
		0x03E, 0x0003C190,
		0x03F, 0x000C3186,
		0x033, 0x00000013,
		0x03E, 0x0003C998,
		0x03F, 0x000C3186,
		0x033, 0x00000012,
		0x03E, 0x0003D840,
		0x03F, 0x000C3186,
		0x033, 0x00000011,
		0x03E, 0x0003D8C4,
		0x03F, 0x000C3186,
		0x033, 0x00000010,
		0x03E, 0x0003D930,
		0x03F, 0x000C3186,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x00000005,
		0x033, 0x00000001,
		0x03F, 0x00000000,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x00000005,
		0x033, 0x00000001,
		0x03F, 0x00000000,
		0x033, 0x00000002,
		0x03F, 0x00000000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00000401,
		0x084, 0x00001209,
		0x086, 0x000001A0,
		0x087, 0x000E8180,
		0x088, 0x00040020,
		0x0DF, 0x00008009,
	0xA0000000,	0x00000000,
		0x018, 0x00000401,
		0x084, 0x00001209,
		0x086, 0x000001A0,
		0x087, 0x000E8180,
		0x088, 0x00040020,
		0x0DF, 0x00008009,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00008000,
		0x033, 0x0000000F,
		0x03F, 0x0000003C,
		0x033, 0x0000000E,
		0x03F, 0x00000038,
		0x033, 0x0000000D,
		0x03F, 0x00000030,
		0x033, 0x0000000C,
		0x03F, 0x00000028,
		0x033, 0x0000000B,
		0x03F, 0x00000020,
		0x033, 0x0000000A,
		0x03F, 0x00000018,
		0x033, 0x00000009,
		0x03F, 0x00000010,
		0x033, 0x00000008,
		0x03F, 0x00000008,
		0x033, 0x00000007,
		0x03F, 0x0000003C,
		0x033, 0x00000006,
		0x03F, 0x00000038,
		0x033, 0x00000005,
		0x03F, 0x00000030,
		0x033, 0x00000004,
		0x03F, 0x00000028,
		0x033, 0x00000003,
		0x03F, 0x00000020,
		0x033, 0x00000002,
		0x03F, 0x00000018,
		0x033, 0x00000001,
		0x03F, 0x00000010,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00008000,
		0x033, 0x0000000F,
		0x03F, 0x0000003C,
		0x033, 0x0000000E,
		0x03F, 0x00000038,
		0x033, 0x0000000D,
		0x03F, 0x00000030,
		0x033, 0x0000000C,
		0x03F, 0x00000028,
		0x033, 0x0000000B,
		0x03F, 0x00000020,
		0x033, 0x0000000A,
		0x03F, 0x00000018,
		0x033, 0x00000009,
		0x03F, 0x00000010,
		0x033, 0x00000008,
		0x03F, 0x00000008,
		0x033, 0x00000007,
		0x03F, 0x0000003C,
		0x033, 0x00000006,
		0x03F, 0x00000038,
		0x033, 0x00000005,
		0x03F, 0x00000030,
		0x033, 0x00000004,
		0x03F, 0x00000028,
		0x033, 0x00000003,
		0x03F, 0x00000020,
		0x033, 0x00000002,
		0x03F, 0x00000018,
		0x033, 0x00000001,
		0x03F, 0x00000010,
		0x033, 0x00000000,
		0x03F, 0x00000008,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x0000001E,
		0x03F, 0x00000000,
		0x033, 0x0000001C,
		0x03F, 0x00000006,
		0x033, 0x0000000E,
		0x03F, 0x00000006,
		0x033, 0x0000000C,
		0x03F, 0x00000006,
		0x033, 0x0000000A,
		0x03F, 0x00000006,
		0x033, 0x00000008,
		0x03F, 0x00000006,
		0x033, 0x00000036,
		0x03F, 0x00000006,
		0x033, 0x00000037,
		0x03F, 0x00000006,
		0x033, 0x00000034,
		0x03F, 0x00000006,
		0x033, 0x00000026,
		0x03F, 0x00000006,
		0x033, 0x00000027,
		0x03F, 0x00000006,
		0x033, 0x00000024,
		0x03F, 0x00000006,
		0x033, 0x00000022,
		0x03F, 0x00000006,
		0x033, 0x00000020,
		0x03F, 0x00000006,
		0x033, 0x00000006,
		0x03F, 0x00000006,
		0x033, 0x00000007,
		0x03F, 0x00000006,
		0x033, 0x00000004,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000006,
		0x033, 0x00000000,
		0x03F, 0x00000006,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00000002,
		0x033, 0x0000001E,
		0x03F, 0x00000000,
		0x033, 0x0000001C,
		0x03F, 0x00000006,
		0x033, 0x0000000E,
		0x03F, 0x00000006,
		0x033, 0x0000000C,
		0x03F, 0x00000006,
		0x033, 0x0000000A,
		0x03F, 0x00000006,
		0x033, 0x00000008,
		0x03F, 0x00000006,
		0x033, 0x00000036,
		0x03F, 0x00000006,
		0x033, 0x00000037,
		0x03F, 0x00000006,
		0x033, 0x00000034,
		0x03F, 0x00000006,
		0x033, 0x00000026,
		0x03F, 0x00000006,
		0x033, 0x00000027,
		0x03F, 0x00000006,
		0x033, 0x00000024,
		0x03F, 0x00000006,
		0x033, 0x00000022,
		0x03F, 0x00000006,
		0x033, 0x00000020,
		0x03F, 0x00000006,
		0x033, 0x00000006,
		0x03F, 0x00000006,
		0x033, 0x00000007,
		0x03F, 0x00000006,
		0x033, 0x00000004,
		0x03F, 0x00000006,
		0x033, 0x00000002,
		0x03F, 0x00000006,
		0x033, 0x00000000,
		0x03F, 0x00000006,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0A0, 0x000F0005,
		0x0A1, 0x0006C000,
		0x0A2, 0x0000161B,
		0x0A3, 0x000B9DBD,
		0x0AF, 0x00070000,
	0xA0000000,	0x00000000,
		0x0A0, 0x000F0005,
		0x0A1, 0x0006C000,
		0x0A2, 0x0000161B,
		0x0A3, 0x000B9DBD,
		0x0AF, 0x00070000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0B8, 0x00080A00,
		0x0B0, 0x000FF0FA,
		0x0CA, 0x00080000,
		0x0C9, 0x0001C141,
		0x0B0, 0x000FF0F8,
	0xA0000000,	0x00000000,
		0x0B8, 0x00080A00,
		0x0B0, 0x000FF0FA,
		0x0CA, 0x00080000,
		0x0C9, 0x0001C141,
		0x0B0, 0x000FF0F8,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00018D24,
	0xA0000000,	0x00000000,
		0x018, 0x00018D24,
	0xB0000000,	0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
		0xFFE, 0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x018, 0x00010D24,
	0xA0000000,	0x00000000,
		0x018, 0x00010D24,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x01B, 0x00003A40,
	0xA0000000,	0x00000000,
		0x01B, 0x00003A40,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x061, 0x0004D301,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0xA0000000,	0x00000000,
		0x061, 0x0004D301,
		0x062, 0x0000D303,
		0x063, 0x00000002,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x000004F1,
		0x030, 0x000014F1,
		0x030, 0x000024F1,
		0x030, 0x000034F1,
		0x030, 0x000044F1,
		0x030, 0x000054F1,
		0x030, 0x000064F1,
		0x030, 0x000074F1,
		0x030, 0x000084F1,
		0x030, 0x000094F1,
		0x030, 0x0000A4F1,
		0x030, 0x0000B4F1,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000200,
		0x030, 0x00000491,
		0x030, 0x00001491,
		0x030, 0x00002491,
		0x030, 0x00003491,
		0x030, 0x00004492,
		0x030, 0x00005492,
		0x030, 0x00006492,
		0x030, 0x00007492,
		0x030, 0x00008592,
		0x030, 0x00009592,
		0x030, 0x0000A592,
		0x030, 0x0000B592,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000301,
		0x030, 0x00001301,
		0x030, 0x00002301,
		0x030, 0x00003301,
		0x030, 0x00004301,
		0x030, 0x00005301,
		0x030, 0x00006301,
		0x030, 0x00007301,
		0x030, 0x00008301,
		0x030, 0x00009301,
		0x030, 0x0000A301,
		0x030, 0x0000B301,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000080,
		0x030, 0x00000401,
		0x030, 0x00001401,
		0x030, 0x00002401,
		0x030, 0x00003401,
		0x030, 0x00004403,
		0x030, 0x00005403,
		0x030, 0x00006403,
		0x030, 0x00007403,
		0x030, 0x00008402,
		0x030, 0x00009402,
		0x030, 0x0000A402,
		0x030, 0x0000B402,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000770,
		0x030, 0x00001670,
		0x030, 0x00002120,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000040,
		0x030, 0x00000773,
		0x030, 0x00001543,
		0x030, 0x00002330,
		0x030, 0x00004000,
		0x030, 0x00005000,
		0x030, 0x00006000,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
		0x0DE, 0x00020200,
		0x05C, 0x00007FE0,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000800,
		0x0DE, 0x00020200,
		0x05C, 0x00007FE0,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000E08,
		0x033, 0x00000021,
		0x03F, 0x00000E0B,
		0x033, 0x00000022,
		0x03F, 0x00000E0E,
		0x033, 0x00000023,
		0x03F, 0x00000E2B,
		0x033, 0x00000024,
		0x03F, 0x00000E2E,
		0x033, 0x00000025,
		0x03F, 0x00000E6B,
		0x033, 0x00000026,
		0x03F, 0x00000EE9,
		0x033, 0x00000027,
		0x03F, 0x00000EEC,
		0x033, 0x00000028,
		0x03F, 0x00000EEF,
		0x033, 0x00000029,
		0x03F, 0x00000EF2,
		0x033, 0x0000002A,
		0x03F, 0x00000EF5,
	0xA0000000,	0x00000000,
		0x033, 0x00000020,
		0x03F, 0x00000E08,
		0x033, 0x00000021,
		0x03F, 0x00000E0B,
		0x033, 0x00000022,
		0x03F, 0x00000E0E,
		0x033, 0x00000023,
		0x03F, 0x00000E2B,
		0x033, 0x00000024,
		0x03F, 0x00000E2E,
		0x033, 0x00000025,
		0x03F, 0x00000E6B,
		0x033, 0x00000026,
		0x03F, 0x00000EE8,
		0x033, 0x00000027,
		0x03F, 0x00000EEB,
		0x033, 0x00000028,
		0x03F, 0x00000EEE,
		0x033, 0x00000029,
		0x03F, 0x00000EF1,
		0x033, 0x0000002A,
		0x03F, 0x00000EF4,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E09,
		0x033, 0x00000061,
		0x03F, 0x00000E0C,
		0x033, 0x00000062,
		0x03F, 0x00000E0F,
		0x033, 0x00000063,
		0x03F, 0x00000E2C,
		0x033, 0x00000064,
		0x03F, 0x00000E2F,
		0x033, 0x00000065,
		0x03F, 0x00000E6B,
		0x033, 0x00000066,
		0x03F, 0x00000EE6,
		0x033, 0x00000067,
		0x03F, 0x00000EE9,
		0x033, 0x00000068,
		0x03F, 0x00000EEC,
		0x033, 0x00000069,
		0x03F, 0x00000EF0,
		0x033, 0x0000006A,
		0x03F, 0x00000EF3,
	0xA0000000,	0x00000000,
		0x033, 0x00000060,
		0x03F, 0x00000E08,
		0x033, 0x00000061,
		0x03F, 0x00000E0B,
		0x033, 0x00000062,
		0x03F, 0x00000E0E,
		0x033, 0x00000063,
		0x03F, 0x00000E2B,
		0x033, 0x00000064,
		0x03F, 0x00000E2E,
		0x033, 0x00000065,
		0x03F, 0x00000E6B,
		0x033, 0x00000066,
		0x03F, 0x00000EE7,
		0x033, 0x00000067,
		0x03F, 0x00000EEA,
		0x033, 0x00000068,
		0x03F, 0x00000EED,
		0x033, 0x00000069,
		0x03F, 0x00000EF0,
		0x033, 0x0000006A,
		0x03F, 0x00000EF3,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000E09,
		0x033, 0x000000A1,
		0x03F, 0x00000E0C,
		0x033, 0x000000A2,
		0x03F, 0x00000E0F,
		0x033, 0x000000A3,
		0x03F, 0x00000E2C,
		0x033, 0x000000A4,
		0x03F, 0x00000E2F,
		0x033, 0x000000A5,
		0x03F, 0x00000E6C,
		0x033, 0x000000A6,
		0x03F, 0x00000EE9,
		0x033, 0x000000A7,
		0x03F, 0x00000EEC,
		0x033, 0x000000A8,
		0x03F, 0x00000EEF,
		0x033, 0x000000A9,
		0x03F, 0x00000EF2,
		0x033, 0x000000AA,
		0x03F, 0x00000EF5,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x000000A0,
		0x03F, 0x00000E09,
		0x033, 0x000000A1,
		0x03F, 0x00000E0C,
		0x033, 0x000000A2,
		0x03F, 0x00000E0F,
		0x033, 0x000000A3,
		0x03F, 0x00000E2C,
		0x033, 0x000000A4,
		0x03F, 0x00000E2F,
		0x033, 0x000000A5,
		0x03F, 0x00000E6C,
		0x033, 0x000000A6,
		0x03F, 0x00000EE9,
		0x033, 0x000000A7,
		0x03F, 0x00000EEC,
		0x033, 0x000000A8,
		0x03F, 0x00000EEF,
		0x033, 0x000000A9,
		0x03F, 0x00000EF2,
		0x033, 0x000000AA,
		0x03F, 0x00000EF5,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x0000267C,
		0x033, 0x00000001,
		0x03F, 0x0000267C,
		0x033, 0x00000002,
		0x03F, 0x0000267C,
		0x033, 0x00000003,
		0x03F, 0x0000267C,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000400,
		0x033, 0x00000000,
		0x03F, 0x0000267C,
		0x033, 0x00000001,
		0x03F, 0x0000267C,
		0x033, 0x00000002,
		0x03F, 0x0000267C,
		0x033, 0x00000003,
		0x03F, 0x0000267C,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000000,
		0x03F, 0x00000ED0,
		0x033, 0x00000001,
		0x03F, 0x00000ED0,
		0x033, 0x00000002,
		0x03F, 0x00000ED0,
		0x033, 0x00000003,
		0x03F, 0x00000ED0,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000100,
		0x033, 0x00000000,
		0x03F, 0x00000ED0,
		0x033, 0x00000001,
		0x03F, 0x00000ED0,
		0x033, 0x00000002,
		0x03F, 0x00000ED0,
		0x033, 0x00000003,
		0x03F, 0x00000ED0,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x051, 0x00000818,
		0x052, 0x0009E063,
		0x053, 0x00000DA1,
		0x054, 0x00070022,
		0x055, 0x00082000,
		0x056, 0x00051CCC,
		0x057, 0x0000CE16,
		0x058, 0x00072C10,
		0x059, 0x000A0000,
	0xA0000000,	0x00000000,
		0x051, 0x00000818,
		0x052, 0x0009E063,
		0x053, 0x00000DA1,
		0x054, 0x00070022,
		0x055, 0x00082000,
		0x056, 0x00051CCC,
		0x057, 0x0000CE16,
		0x058, 0x00072C10,
		0x059, 0x000A0000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000800,
		0x0DE, 0x00020200,
		0x05C, 0x00007FE0,
		0x033, 0x00000000,
		0x03F, 0x00051427,
		0x033, 0x00000001,
		0x03F, 0x00051446,
		0x033, 0x00000002,
		0x03F, 0x00051449,
		0x033, 0x00000003,
		0x03F, 0x0005144C,
		0x033, 0x00000004,
		0x03F, 0x00051C69,
		0x033, 0x00000005,
		0x03F, 0x00051C6C,
		0x033, 0x00000006,
		0x03F, 0x00051C8D,
		0x033, 0x00000007,
		0x03F, 0x00051CEB,
		0x033, 0x00000008,
		0x03F, 0x00051CEE,
		0x033, 0x00000009,
		0x03F, 0x00051CF1,
		0x033, 0x0000000A,
		0x03F, 0x00051CF4,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000800,
		0x0DE, 0x00020200,
		0x05C, 0x00007FE0,
		0x033, 0x00000000,
		0x03F, 0x00051427,
		0x033, 0x00000001,
		0x03F, 0x00051446,
		0x033, 0x00000002,
		0x03F, 0x00051449,
		0x033, 0x00000003,
		0x03F, 0x0005144C,
		0x033, 0x00000004,
		0x03F, 0x00051C69,
		0x033, 0x00000005,
		0x03F, 0x00051C6C,
		0x033, 0x00000006,
		0x03F, 0x00051C8D,
		0x033, 0x00000007,
		0x03F, 0x00051CEB,
		0x033, 0x00000008,
		0x03F, 0x00051CEE,
		0x033, 0x00000009,
		0x03F, 0x00051CF1,
		0x033, 0x0000000A,
		0x03F, 0x00051CF4,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000209D,
		0x033, 0x00000001,
		0x03F, 0x0000209D,
		0x033, 0x00000002,
		0x03F, 0x0000209D,
		0x033, 0x00000003,
		0x03F, 0x0000209D,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00004000,
		0x033, 0x00000000,
		0x03F, 0x0000209D,
		0x033, 0x00000001,
		0x03F, 0x0000209D,
		0x033, 0x00000002,
		0x03F, 0x0000209D,
		0x033, 0x00000003,
		0x03F, 0x0000209D,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00002000,
		0x033, 0x00000000,
		0x03F, 0x00000840,
		0x033, 0x00000001,
		0x03F, 0x00000840,
		0x033, 0x00000002,
		0x03F, 0x00000840,
		0x033, 0x00000003,
		0x03F, 0x00000840,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00002000,
		0x033, 0x00000000,
		0x03F, 0x00000840,
		0x033, 0x00000001,
		0x03F, 0x00000840,
		0x033, 0x00000002,
		0x03F, 0x00000840,
		0x033, 0x00000003,
		0x03F, 0x00000840,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x070, 0x00008000,
		0x075, 0x00002645,
		0x076, 0x0000E984,
		0x077, 0x00004408,
		0x078, 0x0003F000,
		0x07D, 0x00007600,
		0x07F, 0x00000000,
		0x06A, 0x000FCC00,
	0xA0000000,	0x00000000,
		0x070, 0x00008000,
		0x075, 0x00002645,
		0x076, 0x0000E984,
		0x077, 0x00004408,
		0x078, 0x0003F000,
		0x07D, 0x00007600,
		0x07F, 0x00000000,
		0x06A, 0x000FCC00,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EE, 0x00008000,
		0x033, 0x00000000,
		0x03F, 0x00051427,
		0x033, 0x00000001,
		0x03F, 0x00051446,
		0x033, 0x00000002,
		0x03F, 0x00051449,
		0x033, 0x00000003,
		0x03F, 0x0005144C,
		0x033, 0x00000004,
		0x03F, 0x00051C69,
		0x033, 0x00000005,
		0x03F, 0x00051C6C,
		0x033, 0x00000006,
		0x03F, 0x00051C8D,
		0x033, 0x00000007,
		0x03F, 0x00051CEB,
		0x033, 0x00000008,
		0x03F, 0x00051CEE,
		0x033, 0x00000009,
		0x03F, 0x00051CF1,
		0x033, 0x0000000A,
		0x03F, 0x00051CF4,
		0x0EE, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EE, 0x00008000,
		0x033, 0x00000000,
		0x03F, 0x00051427,
		0x033, 0x00000001,
		0x03F, 0x00051446,
		0x033, 0x00000002,
		0x03F, 0x00051449,
		0x033, 0x00000003,
		0x03F, 0x0005144C,
		0x033, 0x00000004,
		0x03F, 0x00051C69,
		0x033, 0x00000005,
		0x03F, 0x00051C6C,
		0x033, 0x00000006,
		0x03F, 0x00051C8D,
		0x033, 0x00000007,
		0x03F, 0x00051CEB,
		0x033, 0x00000008,
		0x03F, 0x00051CEE,
		0x033, 0x00000009,
		0x03F, 0x00051CF1,
		0x033, 0x0000000A,
		0x03F, 0x00051CF4,
		0x0EE, 0x00000000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x0EF, 0x00000010,
		0x033, 0x00000000,
		0x008, 0x0009C060,
		0x033, 0x00000001,
		0x008, 0x0009C060,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x0EF, 0x00000010,
		0x033, 0x00000000,
		0x008, 0x0009C060,
		0x033, 0x00000001,
		0x008, 0x0009C060,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A2,
		0x0EF, 0x00080000,
		0x03E, 0x0000593F,
		0x03F, 0x000C0F4F,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x000000A2,
		0x0EF, 0x00080000,
		0x03E, 0x0000593F,
		0x03F, 0x000C0F4F,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,
	0x80002000,	0x00000000,	0x40000000,	0x00000000,
		0x033, 0x000000A3,
		0x0EF, 0x00080000,
		0x03E, 0x00005934,
		0x03F, 0x0005AFCF,
		0x0EF, 0x00000000,
	0xA0000000,	0x00000000,
		0x033, 0x000000A3,
		0x0EF, 0x00080000,
		0x03E, 0x00005934,
		0x03F, 0x0005AFCF,
		0x0EF, 0x00000000,
	0xB0000000,	0x00000000,

};

void
ODM_ReadAndConfig_TC_8821C_RadioA(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i         = 0;
	u1Byte     cCond;
	BOOLEAN bMatched = TRUE, bSkipped = FALSE;
	u4Byte     ArrayLen    = sizeof(Array_TC_8821C_RadioA)/sizeof(u4Byte);
	pu4Byte    Array       = Array_TC_8821C_RadioA;
	
	u4Byte	v1 = 0, v2 = 0, pre_v1 = 0, pre_v2 = 0;

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_TC_8821C_RadioA\n"));

	while ((i + 1) < ArrayLen) {
		v1 = Array[i];
		v2 = Array[i + 1];

		if (v1 & (BIT31 | BIT30)) {/*positive & negative condition*/
			if (v1 & BIT31) {/* positive condition*/
				cCond  = (u1Byte)((v1 & (BIT29|BIT28)) >> 28);
				if (cCond == COND_ENDIF) {/*end*/
					bMatched = TRUE;
					bSkipped = FALSE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ENDIF\n"));
				} else if (cCond == COND_ELSE) { /*else*/
					bMatched = bSkipped?FALSE:TRUE;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("ELSE\n"));
				} else {/*if , else if*/
					pre_v1 = v1;
					pre_v2 = v2;
					ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("IF or ELSE IF\n"));
				}
			} else if (v1 & BIT30) { /*negative condition*/
				if (bSkipped == FALSE) {
					if (CheckPositive(pDM_Odm, pre_v1, pre_v2, v1, v2)) {
						bMatched = TRUE;
						bSkipped = TRUE;
					} else {
						bMatched = FALSE;
						bSkipped = FALSE;
					}
				} else
					bMatched = FALSE;
			}
		} else {
			if (bMatched)
				odm_ConfigRF_RadioA_8821C(pDM_Odm, v1, v2);
		}
		i = i + 2;
	}
}

u4Byte
ODM_GetVersion_TC_8821C_RadioA(void)
{
	   return 9;
}

/******************************************************************************
*                           TxPowerTrack.TXT
******************************************************************************/

u1Byte gDeltaSwingTableIdx_TC_5GA_N_TxPowerTrack_8821C[][DELTA_SWINGIDX_SIZE] = {
	{0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 11, 11, 11, 11, 12, 12, 13, 13, 14},
	{0, 1, 1, 2, 3, 4, 4, 5, 6, 6, 7, 8, 9, 9, 10, 11, 11, 12, 13, 14, 14, 15, 16, 16, 17, 18, 19, 19, 20, 21},
	{0, 1, 1, 2, 3, 3, 4, 5, 5, 6, 6, 7, 8, 8, 9, 10, 10, 11, 12, 12, 13, 14, 14, 15, 16, 16, 17, 17, 18, 19},
};
u1Byte gDeltaSwingTableIdx_TC_5GA_P_TxPowerTrack_8821C[][DELTA_SWINGIDX_SIZE] = {
	{0, 1, 2, 2, 3, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 12, 13, 14, 15, 16, 16, 17, 18, 19, 20, 21, 21, 22, 23, 24},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 23, 24, 25, 25, 25, 25},
	{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 17, 18, 19, 20, 21, 22, 23, 24, 25, 25, 25, 25},
};
u1Byte gDeltaSwingTableIdx_TC_2GA_N_TxPowerTrack_8821C[]    = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 4, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 11, 12, 12, 13};
u1Byte gDeltaSwingTableIdx_TC_2GA_P_TxPowerTrack_8821C[]    = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14};
u1Byte gDeltaSwingTableIdx_TC_2GCCKA_N_TxPowerTrack_8821C[] = {0, 0, 1, 1, 2, 2, 3, 3, 3, 4, 4, 5, 5, 5, 6, 6, 7, 7, 8, 8, 8, 9, 9, 10, 10, 11, 11, 11, 12, 12};
u1Byte gDeltaSwingTableIdx_TC_2GCCKA_P_TxPowerTrack_8821C[] = {0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14};

void
ODM_ReadAndConfig_TC_8821C_TxPowerTrack(
	IN   PDM_ODM_T  pDM_Odm
)
{
	PODM_RF_CAL_T  pRFCalibrateInfo = &(pDM_Odm->RFCalibrateInfo);

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_MP_TC_8821C\n"));


	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_P, gDeltaSwingTableIdx_TC_2GA_P_TxPowerTrack_8821C, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GA_N, gDeltaSwingTableIdx_TC_2GA_N_TxPowerTrack_8821C, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_P, gDeltaSwingTableIdx_TC_2GCCKA_P_TxPowerTrack_8821C, DELTA_SWINGIDX_SIZE);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_2GCCKA_N, gDeltaSwingTableIdx_TC_2GCCKA_N_TxPowerTrack_8821C, DELTA_SWINGIDX_SIZE);

	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_P, gDeltaSwingTableIdx_TC_5GA_P_TxPowerTrack_8821C, DELTA_SWINGIDX_SIZE*3);
	ODM_MoveMemory(pDM_Odm, pRFCalibrateInfo->DeltaSwingTableIdx_5GA_N, gDeltaSwingTableIdx_TC_5GA_N_TxPowerTrack_8821C, DELTA_SWINGIDX_SIZE*3);
}

/******************************************************************************
*                           TXPWR_LMT.TXT
******************************************************************************/

const char *Array_TC_8821C_TXPWR_LMT[] = { 
	"FCC", "2.4G", "20M", "CCK", "1T", "01", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "01", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "01", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "02", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "02", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "02", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "03", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "03", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "03", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "04", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "04", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "04", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "05", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "05", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "05", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "06", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "06", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "06", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "07", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "07", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "07", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "08", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "08", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "08", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "09", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "09", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "09", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "10", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "10", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "10", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "11", "36", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "11", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "11", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "12", "63", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "12", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "12", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "13", "63", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "13", "32", 
	"MKK", "2.4G", "20M", "CCK", "1T", "13", "32",
	"FCC", "2.4G", "20M", "CCK", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "CCK", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "CCK", "1T", "14", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "01", "34", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "01", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "01", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "02", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "02", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "02", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "03", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "03", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "03", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "04", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "04", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "04", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "05", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "05", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "05", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "06", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "06", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "06", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "07", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "07", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "07", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "08", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "08", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "08", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "09", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "09", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "09", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "10", "36", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "10", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "10", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "11", "32", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "11", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "11", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "12", "63", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "12", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "12", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "13", "63", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "13", "32", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "13", "32",
	"FCC", "2.4G", "20M", "OFDM", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "OFDM", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "OFDM", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "1T", "01", "34", 
	"ETSI", "2.4G", "20M", "HT", "1T", "01", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "01", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "02", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "02", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "02", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "03", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "03", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "03", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "04", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "04", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "04", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "05", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "05", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "05", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "06", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "06", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "06", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "07", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "07", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "07", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "08", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "08", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "08", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "09", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "09", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "09", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "10", "36", 
	"ETSI", "2.4G", "20M", "HT", "1T", "10", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "10", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "11", "32", 
	"ETSI", "2.4G", "20M", "HT", "1T", "11", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "11", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "1T", "12", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "12", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "1T", "13", "32", 
	"MKK", "2.4G", "20M", "HT", "1T", "13", "32",
	"FCC", "2.4G", "20M", "HT", "1T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "1T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "2T", "01", "32", 
	"ETSI", "2.4G", "20M", "HT", "2T", "01", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "01", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "02", "34", 
	"ETSI", "2.4G", "20M", "HT", "2T", "02", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "02", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "03", "34", 
	"ETSI", "2.4G", "20M", "HT", "2T", "03", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "04", "34", 
	"ETSI", "2.4G", "20M", "HT", "2T", "04", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "05", "34", 
	"ETSI", "2.4G", "20M", "HT", "2T", "05", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "06", "34", 
	"ETSI", "2.4G", "20M", "HT", "2T", "06", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "07", "34", 
	"ETSI", "2.4G", "20M", "HT", "2T", "07", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "08", "34", 
	"ETSI", "2.4G", "20M", "HT", "2T", "08", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "09", "34", 
	"ETSI", "2.4G", "20M", "HT", "2T", "09", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "10", "34", 
	"ETSI", "2.4G", "20M", "HT", "2T", "10", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "11", "30", 
	"ETSI", "2.4G", "20M", "HT", "2T", "11", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "2T", "12", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "12", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "2T", "13", "30", 
	"MKK", "2.4G", "20M", "HT", "2T", "13", "30",
	"FCC", "2.4G", "20M", "HT", "2T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "2T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "3T", "01", "30", 
	"ETSI", "2.4G", "20M", "HT", "3T", "01", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "01", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "02", "32", 
	"ETSI", "2.4G", "20M", "HT", "3T", "02", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "02", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "03", "32", 
	"ETSI", "2.4G", "20M", "HT", "3T", "03", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "03", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "04", "32", 
	"ETSI", "2.4G", "20M", "HT", "3T", "04", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "04", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "05", "32", 
	"ETSI", "2.4G", "20M", "HT", "3T", "05", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "05", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "06", "32", 
	"ETSI", "2.4G", "20M", "HT", "3T", "06", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "06", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "07", "32", 
	"ETSI", "2.4G", "20M", "HT", "3T", "07", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "07", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "08", "32", 
	"ETSI", "2.4G", "20M", "HT", "3T", "08", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "08", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "09", "32", 
	"ETSI", "2.4G", "20M", "HT", "3T", "09", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "09", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "10", "32", 
	"ETSI", "2.4G", "20M", "HT", "3T", "10", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "10", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "11", "28", 
	"ETSI", "2.4G", "20M", "HT", "3T", "11", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "11", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "3T", "12", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "12", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "3T", "13", "28", 
	"MKK", "2.4G", "20M", "HT", "3T", "13", "28",
	"FCC", "2.4G", "20M", "HT", "3T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "3T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "3T", "14", "63",
	"FCC", "2.4G", "20M", "HT", "4T", "01", "28", 
	"ETSI", "2.4G", "20M", "HT", "4T", "01", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "01", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "02", "30", 
	"ETSI", "2.4G", "20M", "HT", "4T", "02", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "02", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "03", "30", 
	"ETSI", "2.4G", "20M", "HT", "4T", "03", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "03", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "04", "30", 
	"ETSI", "2.4G", "20M", "HT", "4T", "04", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "04", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "05", "30", 
	"ETSI", "2.4G", "20M", "HT", "4T", "05", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "05", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "06", "30", 
	"ETSI", "2.4G", "20M", "HT", "4T", "06", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "06", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "07", "30", 
	"ETSI", "2.4G", "20M", "HT", "4T", "07", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "07", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "08", "30", 
	"ETSI", "2.4G", "20M", "HT", "4T", "08", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "08", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "09", "30", 
	"ETSI", "2.4G", "20M", "HT", "4T", "09", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "09", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "10", "30", 
	"ETSI", "2.4G", "20M", "HT", "4T", "10", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "10", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "11", "26", 
	"ETSI", "2.4G", "20M", "HT", "4T", "11", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "11", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "12", "63", 
	"ETSI", "2.4G", "20M", "HT", "4T", "12", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "12", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "13", "63", 
	"ETSI", "2.4G", "20M", "HT", "4T", "13", "26", 
	"MKK", "2.4G", "20M", "HT", "4T", "13", "26",
	"FCC", "2.4G", "20M", "HT", "4T", "14", "63", 
	"ETSI", "2.4G", "20M", "HT", "4T", "14", "63", 
	"MKK", "2.4G", "20M", "HT", "4T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "1T", "03", "32", 
	"ETSI", "2.4G", "40M", "HT", "1T", "03", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "03", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "04", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "04", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "04", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "05", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "05", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "05", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "06", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "06", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "06", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "07", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "07", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "07", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "08", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "08", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "08", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "09", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "09", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "09", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "10", "36", 
	"ETSI", "2.4G", "40M", "HT", "1T", "10", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "10", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "11", "32", 
	"ETSI", "2.4G", "40M", "HT", "1T", "11", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "11", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "12", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "12", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "13", "32", 
	"MKK", "2.4G", "40M", "HT", "1T", "13", "32",
	"FCC", "2.4G", "40M", "HT", "1T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "1T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "1T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "2T", "03", "30", 
	"ETSI", "2.4G", "40M", "HT", "2T", "03", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "03", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "04", "34", 
	"ETSI", "2.4G", "40M", "HT", "2T", "04", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "04", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "05", "34", 
	"ETSI", "2.4G", "40M", "HT", "2T", "05", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "05", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "06", "34", 
	"ETSI", "2.4G", "40M", "HT", "2T", "06", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "06", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "07", "34", 
	"ETSI", "2.4G", "40M", "HT", "2T", "07", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "07", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "08", "34", 
	"ETSI", "2.4G", "40M", "HT", "2T", "08", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "08", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "09", "34", 
	"ETSI", "2.4G", "40M", "HT", "2T", "09", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "09", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "10", "34", 
	"ETSI", "2.4G", "40M", "HT", "2T", "10", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "10", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "11", "30", 
	"ETSI", "2.4G", "40M", "HT", "2T", "11", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "11", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "12", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "12", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "13", "30", 
	"MKK", "2.4G", "40M", "HT", "2T", "13", "30",
	"FCC", "2.4G", "40M", "HT", "2T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "2T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "2T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "3T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "3T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "3T", "03", "28", 
	"ETSI", "2.4G", "40M", "HT", "3T", "03", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "03", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "04", "32", 
	"ETSI", "2.4G", "40M", "HT", "3T", "04", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "04", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "05", "32", 
	"ETSI", "2.4G", "40M", "HT", "3T", "05", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "05", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "06", "32", 
	"ETSI", "2.4G", "40M", "HT", "3T", "06", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "06", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "07", "32", 
	"ETSI", "2.4G", "40M", "HT", "3T", "07", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "07", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "08", "32", 
	"ETSI", "2.4G", "40M", "HT", "3T", "08", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "08", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "09", "32", 
	"ETSI", "2.4G", "40M", "HT", "3T", "09", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "09", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "10", "32", 
	"ETSI", "2.4G", "40M", "HT", "3T", "10", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "10", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "11", "28", 
	"ETSI", "2.4G", "40M", "HT", "3T", "11", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "11", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "12", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "12", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "13", "28", 
	"MKK", "2.4G", "40M", "HT", "3T", "13", "28",
	"FCC", "2.4G", "40M", "HT", "3T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "3T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "3T", "14", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "01", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "01", "63", 
	"MKK", "2.4G", "40M", "HT", "4T", "01", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "02", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "02", "63", 
	"MKK", "2.4G", "40M", "HT", "4T", "02", "63",
	"FCC", "2.4G", "40M", "HT", "4T", "03", "26", 
	"ETSI", "2.4G", "40M", "HT", "4T", "03", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "03", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "04", "30", 
	"ETSI", "2.4G", "40M", "HT", "4T", "04", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "04", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "05", "30", 
	"ETSI", "2.4G", "40M", "HT", "4T", "05", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "05", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "06", "30", 
	"ETSI", "2.4G", "40M", "HT", "4T", "06", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "06", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "07", "30", 
	"ETSI", "2.4G", "40M", "HT", "4T", "07", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "07", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "08", "30", 
	"ETSI", "2.4G", "40M", "HT", "4T", "08", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "08", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "09", "30", 
	"ETSI", "2.4G", "40M", "HT", "4T", "09", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "09", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "10", "30", 
	"ETSI", "2.4G", "40M", "HT", "4T", "10", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "10", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "11", "26", 
	"ETSI", "2.4G", "40M", "HT", "4T", "11", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "11", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "12", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "12", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "12", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "13", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "13", "26", 
	"MKK", "2.4G", "40M", "HT", "4T", "13", "26",
	"FCC", "2.4G", "40M", "HT", "4T", "14", "63", 
	"ETSI", "2.4G", "40M", "HT", "4T", "14", "63", 
	"MKK", "2.4G", "40M", "HT", "4T", "14", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "36", "30", 
	"ETSI", "5G", "20M", "OFDM", "1T", "36", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "36", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "40", "30", 
	"ETSI", "5G", "20M", "OFDM", "1T", "40", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "40", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "44", "30", 
	"ETSI", "5G", "20M", "OFDM", "1T", "44", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "44", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "48", "30", 
	"ETSI", "5G", "20M", "OFDM", "1T", "48", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "48", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "52", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "52", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "52", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "56", "34", 
	"ETSI", "5G", "20M", "OFDM", "1T", "56", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "56", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "60", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "60", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "60", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "64", "28", 
	"ETSI", "5G", "20M", "OFDM", "1T", "64", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "64", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "100", "30", 
	"ETSI", "5G", "20M", "OFDM", "1T", "100", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "100", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "104", "30", 
	"ETSI", "5G", "20M", "OFDM", "1T", "104", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "104", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "108", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "108", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "108", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "112", "34", 
	"ETSI", "5G", "20M", "OFDM", "1T", "112", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "112", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "116", "34", 
	"ETSI", "5G", "20M", "OFDM", "1T", "116", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "116", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "120", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "120", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "120", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "124", "34", 
	"ETSI", "5G", "20M", "OFDM", "1T", "124", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "124", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "128", "32", 
	"ETSI", "5G", "20M", "OFDM", "1T", "128", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "128", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "132", "30", 
	"ETSI", "5G", "20M", "OFDM", "1T", "132", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "132", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "136", "30", 
	"ETSI", "5G", "20M", "OFDM", "1T", "136", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "136", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "140", "28", 
	"ETSI", "5G", "20M", "OFDM", "1T", "140", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "140", "32",
	"FCC", "5G", "20M", "OFDM", "1T", "149", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "149", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "149", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "153", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "153", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "153", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "157", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "157", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "157", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "161", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "161", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "161", "63",
	"FCC", "5G", "20M", "OFDM", "1T", "165", "36", 
	"ETSI", "5G", "20M", "OFDM", "1T", "165", "32", 
	"MKK", "5G", "20M", "OFDM", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "1T", "36", "30", 
	"ETSI", "5G", "20M", "HT", "1T", "36", "32", 
	"MKK", "5G", "20M", "HT", "1T", "36", "32",
	"FCC", "5G", "20M", "HT", "1T", "40", "30", 
	"ETSI", "5G", "20M", "HT", "1T", "40", "32", 
	"MKK", "5G", "20M", "HT", "1T", "40", "32",
	"FCC", "5G", "20M", "HT", "1T", "44", "30", 
	"ETSI", "5G", "20M", "HT", "1T", "44", "32", 
	"MKK", "5G", "20M", "HT", "1T", "44", "32",
	"FCC", "5G", "20M", "HT", "1T", "48", "30", 
	"ETSI", "5G", "20M", "HT", "1T", "48", "32", 
	"MKK", "5G", "20M", "HT", "1T", "48", "32",
	"FCC", "5G", "20M", "HT", "1T", "52", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "52", "32", 
	"MKK", "5G", "20M", "HT", "1T", "52", "32",
	"FCC", "5G", "20M", "HT", "1T", "56", "34", 
	"ETSI", "5G", "20M", "HT", "1T", "56", "32", 
	"MKK", "5G", "20M", "HT", "1T", "56", "32",
	"FCC", "5G", "20M", "HT", "1T", "60", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "60", "32", 
	"MKK", "5G", "20M", "HT", "1T", "60", "32",
	"FCC", "5G", "20M", "HT", "1T", "64", "28", 
	"ETSI", "5G", "20M", "HT", "1T", "64", "32", 
	"MKK", "5G", "20M", "HT", "1T", "64", "32",
	"FCC", "5G", "20M", "HT", "1T", "100", "30", 
	"ETSI", "5G", "20M", "HT", "1T", "100", "32", 
	"MKK", "5G", "20M", "HT", "1T", "100", "32",
	"FCC", "5G", "20M", "HT", "1T", "104", "30", 
	"ETSI", "5G", "20M", "HT", "1T", "104", "32", 
	"MKK", "5G", "20M", "HT", "1T", "104", "32",
	"FCC", "5G", "20M", "HT", "1T", "108", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "108", "32", 
	"MKK", "5G", "20M", "HT", "1T", "108", "32",
	"FCC", "5G", "20M", "HT", "1T", "112", "34", 
	"ETSI", "5G", "20M", "HT", "1T", "112", "32", 
	"MKK", "5G", "20M", "HT", "1T", "112", "32",
	"FCC", "5G", "20M", "HT", "1T", "116", "34", 
	"ETSI", "5G", "20M", "HT", "1T", "116", "32", 
	"MKK", "5G", "20M", "HT", "1T", "116", "32",
	"FCC", "5G", "20M", "HT", "1T", "120", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "120", "32", 
	"MKK", "5G", "20M", "HT", "1T", "120", "32",
	"FCC", "5G", "20M", "HT", "1T", "124", "34", 
	"ETSI", "5G", "20M", "HT", "1T", "124", "32", 
	"MKK", "5G", "20M", "HT", "1T", "124", "32",
	"FCC", "5G", "20M", "HT", "1T", "128", "32", 
	"ETSI", "5G", "20M", "HT", "1T", "128", "32", 
	"MKK", "5G", "20M", "HT", "1T", "128", "32",
	"FCC", "5G", "20M", "HT", "1T", "132", "30", 
	"ETSI", "5G", "20M", "HT", "1T", "132", "32", 
	"MKK", "5G", "20M", "HT", "1T", "132", "32",
	"FCC", "5G", "20M", "HT", "1T", "136", "30", 
	"ETSI", "5G", "20M", "HT", "1T", "136", "32", 
	"MKK", "5G", "20M", "HT", "1T", "136", "32",
	"FCC", "5G", "20M", "HT", "1T", "140", "28", 
	"ETSI", "5G", "20M", "HT", "1T", "140", "32", 
	"MKK", "5G", "20M", "HT", "1T", "140", "32",
	"FCC", "5G", "20M", "HT", "1T", "149", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "149", "32", 
	"MKK", "5G", "20M", "HT", "1T", "149", "63",
	"FCC", "5G", "20M", "HT", "1T", "153", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "153", "32", 
	"MKK", "5G", "20M", "HT", "1T", "153", "63",
	"FCC", "5G", "20M", "HT", "1T", "157", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "157", "32", 
	"MKK", "5G", "20M", "HT", "1T", "157", "63",
	"FCC", "5G", "20M", "HT", "1T", "161", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "161", "32", 
	"MKK", "5G", "20M", "HT", "1T", "161", "63",
	"FCC", "5G", "20M", "HT", "1T", "165", "36", 
	"ETSI", "5G", "20M", "HT", "1T", "165", "32", 
	"MKK", "5G", "20M", "HT", "1T", "165", "63",
	"FCC", "5G", "20M", "HT", "2T", "36", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "36", "30", 
	"MKK", "5G", "20M", "HT", "2T", "36", "30",
	"FCC", "5G", "20M", "HT", "2T", "40", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "40", "30", 
	"MKK", "5G", "20M", "HT", "2T", "40", "30",
	"FCC", "5G", "20M", "HT", "2T", "44", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "44", "30", 
	"MKK", "5G", "20M", "HT", "2T", "44", "30",
	"FCC", "5G", "20M", "HT", "2T", "48", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "48", "30", 
	"MKK", "5G", "20M", "HT", "2T", "48", "30",
	"FCC", "5G", "20M", "HT", "2T", "52", "34", 
	"ETSI", "5G", "20M", "HT", "2T", "52", "30", 
	"MKK", "5G", "20M", "HT", "2T", "52", "30",
	"FCC", "5G", "20M", "HT", "2T", "56", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "56", "30", 
	"MKK", "5G", "20M", "HT", "2T", "56", "30",
	"FCC", "5G", "20M", "HT", "2T", "60", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "60", "30", 
	"MKK", "5G", "20M", "HT", "2T", "60", "30",
	"FCC", "5G", "20M", "HT", "2T", "64", "26", 
	"ETSI", "5G", "20M", "HT", "2T", "64", "30", 
	"MKK", "5G", "20M", "HT", "2T", "64", "30",
	"FCC", "5G", "20M", "HT", "2T", "100", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "100", "30", 
	"MKK", "5G", "20M", "HT", "2T", "100", "30",
	"FCC", "5G", "20M", "HT", "2T", "104", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "104", "30", 
	"MKK", "5G", "20M", "HT", "2T", "104", "30",
	"FCC", "5G", "20M", "HT", "2T", "108", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "108", "30", 
	"MKK", "5G", "20M", "HT", "2T", "108", "30",
	"FCC", "5G", "20M", "HT", "2T", "112", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "112", "30", 
	"MKK", "5G", "20M", "HT", "2T", "112", "30",
	"FCC", "5G", "20M", "HT", "2T", "116", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "116", "30", 
	"MKK", "5G", "20M", "HT", "2T", "116", "30",
	"FCC", "5G", "20M", "HT", "2T", "120", "34", 
	"ETSI", "5G", "20M", "HT", "2T", "120", "30", 
	"MKK", "5G", "20M", "HT", "2T", "120", "30",
	"FCC", "5G", "20M", "HT", "2T", "124", "32", 
	"ETSI", "5G", "20M", "HT", "2T", "124", "30", 
	"MKK", "5G", "20M", "HT", "2T", "124", "30",
	"FCC", "5G", "20M", "HT", "2T", "128", "30", 
	"ETSI", "5G", "20M", "HT", "2T", "128", "30", 
	"MKK", "5G", "20M", "HT", "2T", "128", "30",
	"FCC", "5G", "20M", "HT", "2T", "132", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "132", "30", 
	"MKK", "5G", "20M", "HT", "2T", "132", "30",
	"FCC", "5G", "20M", "HT", "2T", "136", "28", 
	"ETSI", "5G", "20M", "HT", "2T", "136", "30", 
	"MKK", "5G", "20M", "HT", "2T", "136", "30",
	"FCC", "5G", "20M", "HT", "2T", "140", "26", 
	"ETSI", "5G", "20M", "HT", "2T", "140", "30", 
	"MKK", "5G", "20M", "HT", "2T", "140", "30",
	"FCC", "5G", "20M", "HT", "2T", "149", "34", 
	"ETSI", "5G", "20M", "HT", "2T", "149", "30", 
	"MKK", "5G", "20M", "HT", "2T", "149", "63",
	"FCC", "5G", "20M", "HT", "2T", "153", "34", 
	"ETSI", "5G", "20M", "HT", "2T", "153", "30", 
	"MKK", "5G", "20M", "HT", "2T", "153", "63",
	"FCC", "5G", "20M", "HT", "2T", "157", "34", 
	"ETSI", "5G", "20M", "HT", "2T", "157", "30", 
	"MKK", "5G", "20M", "HT", "2T", "157", "63",
	"FCC", "5G", "20M", "HT", "2T", "161", "34", 
	"ETSI", "5G", "20M", "HT", "2T", "161", "30", 
	"MKK", "5G", "20M", "HT", "2T", "161", "63",
	"FCC", "5G", "20M", "HT", "2T", "165", "34", 
	"ETSI", "5G", "20M", "HT", "2T", "165", "30", 
	"MKK", "5G", "20M", "HT", "2T", "165", "63",
	"FCC", "5G", "20M", "HT", "3T", "36", "26", 
	"ETSI", "5G", "20M", "HT", "3T", "36", "28", 
	"MKK", "5G", "20M", "HT", "3T", "36", "28",
	"FCC", "5G", "20M", "HT", "3T", "40", "26", 
	"ETSI", "5G", "20M", "HT", "3T", "40", "28", 
	"MKK", "5G", "20M", "HT", "3T", "40", "28",
	"FCC", "5G", "20M", "HT", "3T", "44", "26", 
	"ETSI", "5G", "20M", "HT", "3T", "44", "28", 
	"MKK", "5G", "20M", "HT", "3T", "44", "28",
	"FCC", "5G", "20M", "HT", "3T", "48", "26", 
	"ETSI", "5G", "20M", "HT", "3T", "48", "28", 
	"MKK", "5G", "20M", "HT", "3T", "48", "28",
	"FCC", "5G", "20M", "HT", "3T", "52", "32", 
	"ETSI", "5G", "20M", "HT", "3T", "52", "28", 
	"MKK", "5G", "20M", "HT", "3T", "52", "28",
	"FCC", "5G", "20M", "HT", "3T", "56", "30", 
	"ETSI", "5G", "20M", "HT", "3T", "56", "28", 
	"MKK", "5G", "20M", "HT", "3T", "56", "28",
	"FCC", "5G", "20M", "HT", "3T", "60", "28", 
	"ETSI", "5G", "20M", "HT", "3T", "60", "28", 
	"MKK", "5G", "20M", "HT", "3T", "60", "28",
	"FCC", "5G", "20M", "HT", "3T", "64", "24", 
	"ETSI", "5G", "20M", "HT", "3T", "64", "28", 
	"MKK", "5G", "20M", "HT", "3T", "64", "28",
	"FCC", "5G", "20M", "HT", "3T", "100", "26", 
	"ETSI", "5G", "20M", "HT", "3T", "100", "28", 
	"MKK", "5G", "20M", "HT", "3T", "100", "28",
	"FCC", "5G", "20M", "HT", "3T", "104", "26", 
	"ETSI", "5G", "20M", "HT", "3T", "104", "28", 
	"MKK", "5G", "20M", "HT", "3T", "104", "28",
	"FCC", "5G", "20M", "HT", "3T", "108", "28", 
	"ETSI", "5G", "20M", "HT", "3T", "108", "28", 
	"MKK", "5G", "20M", "HT", "3T", "108", "28",
	"FCC", "5G", "20M", "HT", "3T", "112", "30", 
	"ETSI", "5G", "20M", "HT", "3T", "112", "28", 
	"MKK", "5G", "20M", "HT", "3T", "112", "28",
	"FCC", "5G", "20M", "HT", "3T", "116", "30", 
	"ETSI", "5G", "20M", "HT", "3T", "116", "28", 
	"MKK", "5G", "20M", "HT", "3T", "116", "28",
	"FCC", "5G", "20M", "HT", "3T", "120", "32", 
	"ETSI", "5G", "20M", "HT", "3T", "120", "28", 
	"MKK", "5G", "20M", "HT", "3T", "120", "28",
	"FCC", "5G", "20M", "HT", "3T", "124", "30", 
	"ETSI", "5G", "20M", "HT", "3T", "124", "28", 
	"MKK", "5G", "20M", "HT", "3T", "124", "28",
	"FCC", "5G", "20M", "HT", "3T", "128", "28", 
	"ETSI", "5G", "20M", "HT", "3T", "128", "28", 
	"MKK", "5G", "20M", "HT", "3T", "128", "28",
	"FCC", "5G", "20M", "HT", "3T", "132", "26", 
	"ETSI", "5G", "20M", "HT", "3T", "132", "28", 
	"MKK", "5G", "20M", "HT", "3T", "132", "28",
	"FCC", "5G", "20M", "HT", "3T", "136", "26", 
	"ETSI", "5G", "20M", "HT", "3T", "136", "28", 
	"MKK", "5G", "20M", "HT", "3T", "136", "28",
	"FCC", "5G", "20M", "HT", "3T", "140", "24", 
	"ETSI", "5G", "20M", "HT", "3T", "140", "28", 
	"MKK", "5G", "20M", "HT", "3T", "140", "28",
	"FCC", "5G", "20M", "HT", "3T", "149", "32", 
	"ETSI", "5G", "20M", "HT", "3T", "149", "28", 
	"MKK", "5G", "20M", "HT", "3T", "149", "63",
	"FCC", "5G", "20M", "HT", "3T", "153", "32", 
	"ETSI", "5G", "20M", "HT", "3T", "153", "28", 
	"MKK", "5G", "20M", "HT", "3T", "153", "63",
	"FCC", "5G", "20M", "HT", "3T", "157", "32", 
	"ETSI", "5G", "20M", "HT", "3T", "157", "28", 
	"MKK", "5G", "20M", "HT", "3T", "157", "63",
	"FCC", "5G", "20M", "HT", "3T", "161", "32", 
	"ETSI", "5G", "20M", "HT", "3T", "161", "28", 
	"MKK", "5G", "20M", "HT", "3T", "161", "63",
	"FCC", "5G", "20M", "HT", "3T", "165", "32", 
	"ETSI", "5G", "20M", "HT", "3T", "165", "28", 
	"MKK", "5G", "20M", "HT", "3T", "165", "63",
	"FCC", "5G", "20M", "HT", "4T", "36", "24", 
	"ETSI", "5G", "20M", "HT", "4T", "36", "26", 
	"MKK", "5G", "20M", "HT", "4T", "36", "26",
	"FCC", "5G", "20M", "HT", "4T", "40", "24", 
	"ETSI", "5G", "20M", "HT", "4T", "40", "26", 
	"MKK", "5G", "20M", "HT", "4T", "40", "26",
	"FCC", "5G", "20M", "HT", "4T", "44", "24", 
	"ETSI", "5G", "20M", "HT", "4T", "44", "26", 
	"MKK", "5G", "20M", "HT", "4T", "44", "26",
	"FCC", "5G", "20M", "HT", "4T", "48", "24", 
	"ETSI", "5G", "20M", "HT", "4T", "48", "26", 
	"MKK", "5G", "20M", "HT", "4T", "48", "26",
	"FCC", "5G", "20M", "HT", "4T", "52", "30", 
	"ETSI", "5G", "20M", "HT", "4T", "52", "26", 
	"MKK", "5G", "20M", "HT", "4T", "52", "26",
	"FCC", "5G", "20M", "HT", "4T", "56", "28", 
	"ETSI", "5G", "20M", "HT", "4T", "56", "26", 
	"MKK", "5G", "20M", "HT", "4T", "56", "26",
	"FCC", "5G", "20M", "HT", "4T", "60", "26", 
	"ETSI", "5G", "20M", "HT", "4T", "60", "26", 
	"MKK", "5G", "20M", "HT", "4T", "60", "26",
	"FCC", "5G", "20M", "HT", "4T", "64", "22", 
	"ETSI", "5G", "20M", "HT", "4T", "64", "26", 
	"MKK", "5G", "20M", "HT", "4T", "64", "26",
	"FCC", "5G", "20M", "HT", "4T", "100", "24", 
	"ETSI", "5G", "20M", "HT", "4T", "100", "26", 
	"MKK", "5G", "20M", "HT", "4T", "100", "26",
	"FCC", "5G", "20M", "HT", "4T", "104", "24", 
	"ETSI", "5G", "20M", "HT", "4T", "104", "26", 
	"MKK", "5G", "20M", "HT", "4T", "104", "26",
	"FCC", "5G", "20M", "HT", "4T", "108", "26", 
	"ETSI", "5G", "20M", "HT", "4T", "108", "26", 
	"MKK", "5G", "20M", "HT", "4T", "108", "26",
	"FCC", "5G", "20M", "HT", "4T", "112", "28", 
	"ETSI", "5G", "20M", "HT", "4T", "112", "26", 
	"MKK", "5G", "20M", "HT", "4T", "112", "26",
	"FCC", "5G", "20M", "HT", "4T", "116", "28", 
	"ETSI", "5G", "20M", "HT", "4T", "116", "26", 
	"MKK", "5G", "20M", "HT", "4T", "116", "26",
	"FCC", "5G", "20M", "HT", "4T", "120", "30", 
	"ETSI", "5G", "20M", "HT", "4T", "120", "26", 
	"MKK", "5G", "20M", "HT", "4T", "120", "26",
	"FCC", "5G", "20M", "HT", "4T", "124", "28", 
	"ETSI", "5G", "20M", "HT", "4T", "124", "26", 
	"MKK", "5G", "20M", "HT", "4T", "124", "26",
	"FCC", "5G", "20M", "HT", "4T", "128", "26", 
	"ETSI", "5G", "20M", "HT", "4T", "128", "26", 
	"MKK", "5G", "20M", "HT", "4T", "128", "26",
	"FCC", "5G", "20M", "HT", "4T", "132", "24", 
	"ETSI", "5G", "20M", "HT", "4T", "132", "26", 
	"MKK", "5G", "20M", "HT", "4T", "132", "26",
	"FCC", "5G", "20M", "HT", "4T", "136", "24", 
	"ETSI", "5G", "20M", "HT", "4T", "136", "26", 
	"MKK", "5G", "20M", "HT", "4T", "136", "26",
	"FCC", "5G", "20M", "HT", "4T", "140", "22", 
	"ETSI", "5G", "20M", "HT", "4T", "140", "26", 
	"MKK", "5G", "20M", "HT", "4T", "140", "26",
	"FCC", "5G", "20M", "HT", "4T", "149", "30", 
	"ETSI", "5G", "20M", "HT", "4T", "149", "26", 
	"MKK", "5G", "20M", "HT", "4T", "149", "63",
	"FCC", "5G", "20M", "HT", "4T", "153", "30", 
	"ETSI", "5G", "20M", "HT", "4T", "153", "26", 
	"MKK", "5G", "20M", "HT", "4T", "153", "63",
	"FCC", "5G", "20M", "HT", "4T", "157", "30", 
	"ETSI", "5G", "20M", "HT", "4T", "157", "26", 
	"MKK", "5G", "20M", "HT", "4T", "157", "63",
	"FCC", "5G", "20M", "HT", "4T", "161", "30", 
	"ETSI", "5G", "20M", "HT", "4T", "161", "26", 
	"MKK", "5G", "20M", "HT", "4T", "161", "63",
	"FCC", "5G", "20M", "HT", "4T", "165", "30", 
	"ETSI", "5G", "20M", "HT", "4T", "165", "26", 
	"MKK", "5G", "20M", "HT", "4T", "165", "63",
	"FCC", "5G", "40M", "HT", "1T", "38", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "38", "32", 
	"MKK", "5G", "40M", "HT", "1T", "38", "32",
	"FCC", "5G", "40M", "HT", "1T", "46", "30", 
	"ETSI", "5G", "40M", "HT", "1T", "46", "32", 
	"MKK", "5G", "40M", "HT", "1T", "46", "32",
	"FCC", "5G", "40M", "HT", "1T", "54", "32", 
	"ETSI", "5G", "40M", "HT", "1T", "54", "32", 
	"MKK", "5G", "40M", "HT", "1T", "54", "32",
	"FCC", "5G", "40M", "HT", "1T", "62", "32", 
	"ETSI", "5G", "40M", "HT", "1T", "62", "32", 
	"MKK", "5G", "40M", "HT", "1T", "62", "32",
	"FCC", "5G", "40M", "HT", "1T", "102", "28", 
	"ETSI", "5G", "40M", "HT", "1T", "102", "32", 
	"MKK", "5G", "40M", "HT", "1T", "102", "32",
	"FCC", "5G", "40M", "HT", "1T", "110", "32", 
	"ETSI", "5G", "40M", "HT", "1T", "110", "32", 
	"MKK", "5G", "40M", "HT", "1T", "110", "32",
	"FCC", "5G", "40M", "HT", "1T", "118", "36", 
	"ETSI", "5G", "40M", "HT", "1T", "118", "32", 
	"MKK", "5G", "40M", "HT", "1T", "118", "32",
	"FCC", "5G", "40M", "HT", "1T", "126", "34", 
	"ETSI", "5G", "40M", "HT", "1T", "126", "32", 
	"MKK", "5G", "40M", "HT", "1T", "126", "32",
	"FCC", "5G", "40M", "HT", "1T", "134", "32", 
	"ETSI", "5G", "40M", "HT", "1T", "134", "32", 
	"MKK", "5G", "40M", "HT", "1T", "134", "32",
	"FCC", "5G", "40M", "HT", "1T", "151", "36", 
	"ETSI", "5G", "40M", "HT", "1T", "151", "32", 
	"MKK", "5G", "40M", "HT", "1T", "151", "63",
	"FCC", "5G", "40M", "HT", "1T", "159", "36", 
	"ETSI", "5G", "40M", "HT", "1T", "159", "32", 
	"MKK", "5G", "40M", "HT", "1T", "159", "63",
	"FCC", "5G", "40M", "HT", "2T", "38", "28", 
	"ETSI", "5G", "40M", "HT", "2T", "38", "30", 
	"MKK", "5G", "40M", "HT", "2T", "38", "30",
	"FCC", "5G", "40M", "HT", "2T", "46", "28", 
	"ETSI", "5G", "40M", "HT", "2T", "46", "30", 
	"MKK", "5G", "40M", "HT", "2T", "46", "30",
	"FCC", "5G", "40M", "HT", "2T", "54", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "54", "30", 
	"MKK", "5G", "40M", "HT", "2T", "54", "30",
	"FCC", "5G", "40M", "HT", "2T", "62", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "62", "30", 
	"MKK", "5G", "40M", "HT", "2T", "62", "30",
	"FCC", "5G", "40M", "HT", "2T", "102", "26", 
	"ETSI", "5G", "40M", "HT", "2T", "102", "30", 
	"MKK", "5G", "40M", "HT", "2T", "102", "30",
	"FCC", "5G", "40M", "HT", "2T", "110", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "110", "30", 
	"MKK", "5G", "40M", "HT", "2T", "110", "30",
	"FCC", "5G", "40M", "HT", "2T", "118", "34", 
	"ETSI", "5G", "40M", "HT", "2T", "118", "30", 
	"MKK", "5G", "40M", "HT", "2T", "118", "30",
	"FCC", "5G", "40M", "HT", "2T", "126", "32", 
	"ETSI", "5G", "40M", "HT", "2T", "126", "30", 
	"MKK", "5G", "40M", "HT", "2T", "126", "30",
	"FCC", "5G", "40M", "HT", "2T", "134", "30", 
	"ETSI", "5G", "40M", "HT", "2T", "134", "30", 
	"MKK", "5G", "40M", "HT", "2T", "134", "30",
	"FCC", "5G", "40M", "HT", "2T", "151", "34", 
	"ETSI", "5G", "40M", "HT", "2T", "151", "30", 
	"MKK", "5G", "40M", "HT", "2T", "151", "63",
	"FCC", "5G", "40M", "HT", "2T", "159", "34", 
	"ETSI", "5G", "40M", "HT", "2T", "159", "30", 
	"MKK", "5G", "40M", "HT", "2T", "159", "63",
	"FCC", "5G", "40M", "HT", "3T", "38", "26", 
	"ETSI", "5G", "40M", "HT", "3T", "38", "28", 
	"MKK", "5G", "40M", "HT", "3T", "38", "28",
	"FCC", "5G", "40M", "HT", "3T", "46", "26", 
	"ETSI", "5G", "40M", "HT", "3T", "46", "28", 
	"MKK", "5G", "40M", "HT", "3T", "46", "28",
	"FCC", "5G", "40M", "HT", "3T", "54", "28", 
	"ETSI", "5G", "40M", "HT", "3T", "54", "28", 
	"MKK", "5G", "40M", "HT", "3T", "54", "28",
	"FCC", "5G", "40M", "HT", "3T", "62", "28", 
	"ETSI", "5G", "40M", "HT", "3T", "62", "28", 
	"MKK", "5G", "40M", "HT", "3T", "62", "28",
	"FCC", "5G", "40M", "HT", "3T", "102", "24", 
	"ETSI", "5G", "40M", "HT", "3T", "102", "28", 
	"MKK", "5G", "40M", "HT", "3T", "102", "28",
	"FCC", "5G", "40M", "HT", "3T", "110", "28", 
	"ETSI", "5G", "40M", "HT", "3T", "110", "28", 
	"MKK", "5G", "40M", "HT", "3T", "110", "28",
	"FCC", "5G", "40M", "HT", "3T", "118", "32", 
	"ETSI", "5G", "40M", "HT", "3T", "118", "28", 
	"MKK", "5G", "40M", "HT", "3T", "118", "28",
	"FCC", "5G", "40M", "HT", "3T", "126", "30", 
	"ETSI", "5G", "40M", "HT", "3T", "126", "28", 
	"MKK", "5G", "40M", "HT", "3T", "126", "28",
	"FCC", "5G", "40M", "HT", "3T", "134", "28", 
	"ETSI", "5G", "40M", "HT", "3T", "134", "28", 
	"MKK", "5G", "40M", "HT", "3T", "134", "28",
	"FCC", "5G", "40M", "HT", "3T", "151", "32", 
	"ETSI", "5G", "40M", "HT", "3T", "151", "28", 
	"MKK", "5G", "40M", "HT", "3T", "151", "63",
	"FCC", "5G", "40M", "HT", "3T", "159", "32", 
	"ETSI", "5G", "40M", "HT", "3T", "159", "28", 
	"MKK", "5G", "40M", "HT", "3T", "159", "63",
	"FCC", "5G", "40M", "HT", "4T", "38", "24", 
	"ETSI", "5G", "40M", "HT", "4T", "38", "26", 
	"MKK", "5G", "40M", "HT", "4T", "38", "26",
	"FCC", "5G", "40M", "HT", "4T", "46", "24", 
	"ETSI", "5G", "40M", "HT", "4T", "46", "26", 
	"MKK", "5G", "40M", "HT", "4T", "46", "26",
	"FCC", "5G", "40M", "HT", "4T", "54", "26", 
	"ETSI", "5G", "40M", "HT", "4T", "54", "26", 
	"MKK", "5G", "40M", "HT", "4T", "54", "26",
	"FCC", "5G", "40M", "HT", "4T", "62", "26", 
	"ETSI", "5G", "40M", "HT", "4T", "62", "26", 
	"MKK", "5G", "40M", "HT", "4T", "62", "26",
	"FCC", "5G", "40M", "HT", "4T", "102", "22", 
	"ETSI", "5G", "40M", "HT", "4T", "102", "26", 
	"MKK", "5G", "40M", "HT", "4T", "102", "26",
	"FCC", "5G", "40M", "HT", "4T", "110", "26", 
	"ETSI", "5G", "40M", "HT", "4T", "110", "26", 
	"MKK", "5G", "40M", "HT", "4T", "110", "26",
	"FCC", "5G", "40M", "HT", "4T", "118", "30", 
	"ETSI", "5G", "40M", "HT", "4T", "118", "26", 
	"MKK", "5G", "40M", "HT", "4T", "118", "26",
	"FCC", "5G", "40M", "HT", "4T", "126", "28", 
	"ETSI", "5G", "40M", "HT", "4T", "126", "26", 
	"MKK", "5G", "40M", "HT", "4T", "126", "26",
	"FCC", "5G", "40M", "HT", "4T", "134", "26", 
	"ETSI", "5G", "40M", "HT", "4T", "134", "26", 
	"MKK", "5G", "40M", "HT", "4T", "134", "26",
	"FCC", "5G", "40M", "HT", "4T", "151", "30", 
	"ETSI", "5G", "40M", "HT", "4T", "151", "26", 
	"MKK", "5G", "40M", "HT", "4T", "151", "63",
	"FCC", "5G", "40M", "HT", "4T", "159", "30", 
	"ETSI", "5G", "40M", "HT", "4T", "159", "26", 
	"MKK", "5G", "40M", "HT", "4T", "159", "63",
	"FCC", "5G", "80M", "VHT", "1T", "42", "30", 
	"ETSI", "5G", "80M", "VHT", "1T", "42", "32", 
	"MKK", "5G", "80M", "VHT", "1T", "42", "32",
	"FCC", "5G", "80M", "VHT", "1T", "58", "28", 
	"ETSI", "5G", "80M", "VHT", "1T", "58", "32", 
	"MKK", "5G", "80M", "VHT", "1T", "58", "32",
	"FCC", "5G", "80M", "VHT", "1T", "106", "30", 
	"ETSI", "5G", "80M", "VHT", "1T", "106", "32", 
	"MKK", "5G", "80M", "VHT", "1T", "106", "32",
	"FCC", "5G", "80M", "VHT", "1T", "122", "34", 
	"ETSI", "5G", "80M", "VHT", "1T", "122", "32", 
	"MKK", "5G", "80M", "VHT", "1T", "122", "32",
	"FCC", "5G", "80M", "VHT", "1T", "155", "36", 
	"ETSI", "5G", "80M", "VHT", "1T", "155", "32", 
	"MKK", "5G", "80M", "VHT", "1T", "155", "63",
	"FCC", "5G", "80M", "VHT", "2T", "42", "28", 
	"ETSI", "5G", "80M", "VHT", "2T", "42", "30", 
	"MKK", "5G", "80M", "VHT", "2T", "42", "30",
	"FCC", "5G", "80M", "VHT", "2T", "58", "26", 
	"ETSI", "5G", "80M", "VHT", "2T", "58", "30", 
	"MKK", "5G", "80M", "VHT", "2T", "58", "30",
	"FCC", "5G", "80M", "VHT", "2T", "106", "28", 
	"ETSI", "5G", "80M", "VHT", "2T", "106", "30", 
	"MKK", "5G", "80M", "VHT", "2T", "106", "30",
	"FCC", "5G", "80M", "VHT", "2T", "122", "32", 
	"ETSI", "5G", "80M", "VHT", "2T", "122", "30", 
	"MKK", "5G", "80M", "VHT", "2T", "122", "30",
	"FCC", "5G", "80M", "VHT", "2T", "155", "34", 
	"ETSI", "5G", "80M", "VHT", "2T", "155", "30", 
	"MKK", "5G", "80M", "VHT", "2T", "155", "63",
	"FCC", "5G", "80M", "VHT", "3T", "42", "26", 
	"ETSI", "5G", "80M", "VHT", "3T", "42", "28", 
	"MKK", "5G", "80M", "VHT", "3T", "42", "28",
	"FCC", "5G", "80M", "VHT", "3T", "58", "24", 
	"ETSI", "5G", "80M", "VHT", "3T", "58", "28", 
	"MKK", "5G", "80M", "VHT", "3T", "58", "28",
	"FCC", "5G", "80M", "VHT", "3T", "106", "26", 
	"ETSI", "5G", "80M", "VHT", "3T", "106", "28", 
	"MKK", "5G", "80M", "VHT", "3T", "106", "28",
	"FCC", "5G", "80M", "VHT", "3T", "122", "30", 
	"ETSI", "5G", "80M", "VHT", "3T", "122", "28", 
	"MKK", "5G", "80M", "VHT", "3T", "122", "28",
	"FCC", "5G", "80M", "VHT", "3T", "155", "32", 
	"ETSI", "5G", "80M", "VHT", "3T", "155", "28", 
	"MKK", "5G", "80M", "VHT", "3T", "155", "63",
	"FCC", "5G", "80M", "VHT", "4T", "42", "24", 
	"ETSI", "5G", "80M", "VHT", "4T", "42", "26", 
	"MKK", "5G", "80M", "VHT", "4T", "42", "26",
	"FCC", "5G", "80M", "VHT", "4T", "58", "22", 
	"ETSI", "5G", "80M", "VHT", "4T", "58", "26", 
	"MKK", "5G", "80M", "VHT", "4T", "58", "26",
	"FCC", "5G", "80M", "VHT", "4T", "106", "24", 
	"ETSI", "5G", "80M", "VHT", "4T", "106", "26", 
	"MKK", "5G", "80M", "VHT", "4T", "106", "26",
	"FCC", "5G", "80M", "VHT", "4T", "122", "28", 
	"ETSI", "5G", "80M", "VHT", "4T", "122", "26", 
	"MKK", "5G", "80M", "VHT", "4T", "122", "26",
	"FCC", "5G", "80M", "VHT", "4T", "155", "30", 
	"ETSI", "5G", "80M", "VHT", "4T", "155", "26", 
	"MKK", "5G", "80M", "VHT", "4T", "155", "63"
};

void
ODM_ReadAndConfig_TC_8821C_TXPWR_LMT(
	IN   PDM_ODM_T  pDM_Odm
)
{
	u4Byte     i           = 0;
	u4Byte     ArrayLen    = sizeof(Array_TC_8821C_TXPWR_LMT)/sizeof(pu1Byte);
	pu1Byte    *Array      = (pu1Byte *)Array_TC_8821C_TXPWR_LMT;

#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
	PADAPTER		Adapter = pDM_Odm->Adapter;
	HAL_DATA_TYPE	*pHalData = GET_HAL_DATA(Adapter);

	PlatformZeroMemory(pHalData->BufOfLinesPwrLmt, MAX_LINES_HWCONFIG_TXT*MAX_BYTES_LINE_HWCONFIG_TXT);
	pHalData->nLinesReadPwrLmt = ArrayLen/7;
#endif

	ODM_RT_TRACE(pDM_Odm, ODM_COMP_INIT, ODM_DBG_LOUD, ("===> ODM_ReadAndConfig_TC_8821C_TXPWR_LMT\n"));

	for (i = 0; i < ArrayLen; i += 7) {
		pu1Byte regulation = Array[i];
		pu1Byte band = Array[i+1];
		pu1Byte bandwidth = Array[i+2];
		pu1Byte rate = Array[i+3];
		pu1Byte rfPath = Array[i+4];
		pu1Byte chnl = Array[i+5];
		pu1Byte val = Array[i+6];
	
		odm_ConfigBB_TXPWR_LMT_8821C(pDM_Odm, regulation, band, bandwidth, rate, rfPath, chnl, val);
#if (DM_ODM_SUPPORT_TYPE == ODM_WIN)
		rsprintf((char *)pHalData->BufOfLinesPwrLmt[i/7], 100, "\"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\",",
			regulation, band, bandwidth, rate, rfPath, chnl, val);
#endif
	}

}

#endif /* end of HWIMG_SUPPORT*/

