#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/platform_device.h>
#include <asm/mach-ralink/rt_mmap.h>
#include <linux/gpio_keys.h>
#include <linux/input.h>

static struct gpio_keys_button mt7621_gpio_button[] = {
    {
        .gpio = 18,
        .code = KEY_WPS_BUTTON,
        .desc = "WPS_BUTTON",
		.debounce_interval = 5,
		.active_low = 1,
    },
	{
        .gpio = 6,
        .code = KEY_RESTART,
        .desc = "RESET_BUTTON",
		.debounce_interval = 5,
		.active_low = 1,
    },
	{
        .gpio = 7,
        .code = KEY_RMAINTE_BUTTON,
        .desc = "RMAINTE_BUTTON",
		.debounce_interval = 5,
		.active_low = 1,
    }
};

struct gpio_keys_platform_data mt7621_gpio_data = {
    .buttons = mt7621_gpio_button,
    .nbuttons = ARRAY_SIZE(mt7621_gpio_button),
};

static struct platform_device rt_gpio_dev = {
    .name = "gpio-keys",
    .id   = 0,
	.dev.platform_data = &mt7621_gpio_data,
};


int __init mtk_gpio_register(void)
{

	int retval = 0;

	retval = platform_device_register(&rt_gpio_dev);
	if (retval != 0) {
		printk(KERN_ERR "register gpio device fail\n");
		return retval;
	}


	return retval;
}
arch_initcall(mtk_gpio_register);
