#ifndef __LED_ROTARY_C__
#define __LED_ROTARY_C__

static const ledtype_t ledtype_alias[] = {
	[LEDT_ALL] = LEDT_ALL,
	[LEDT_DISC] = LEDT_DISC,
	[LEDT_POWER] = LEDT_POWER,
	[LEDT_PPP] = LEDT_PPP,
	[LEDT_DATA] = LEDT_DATA,
	[LEDT_VOIP] = LEDT_VOIP,
	[LEDT_AIR] = LEDT_AIR,
	[LEDT_UPDATE] = LEDT_UPDATE,
	[LEDT_LINE] = LEDT_LINE,
	[LEDT_LAN] = LEDT_LAN,
	[LEDT_AIR2] = LEDT_AIR2,
	[LEDT_TV_MODE] = LEDT_TV_MODE,
	[LEDT_CLIENT] = LEDT_CLIENT,
	[LEDT_LOGO] = LEDT_LOGO,
	[LEDT_REAL_MAX] = LEDT_REAL_MAX,
	[LEDT_ALIAS_DA] = LEDT_POWER,
	[LEDT_ALIAS_ACTIVE] = LEDT_PPP,
/* WZC */
	[LEDT_WZC_PROGRESS] = LEDT_POWER,
	[LEDT_WZC_ERROR] = LEDT_POWER,
/* サブネット補完機能 */
	[LEDT_AUTO_SUBNET_ERR] = LEDT_PPP,
/* IP アドレス設定/削除 */
	[LEDT_IP_ASSIGN] = LEDT_PPP,
	[LEDT_MAX] = LEDT_MAX
};

static const ledact_type_t ledact_alias[] = {
	/* oneshot green */
	[LEDACT_ONESHOT] = LEDACT_ONESHOT,
	/* GREEN */
	[LEDACT_NORMAL] = LEDACT_NORMAL,
	/* RED */
	[LEDACT_NORMAL_RED] = LEDACT_NORMAL_RED,
	/* ORANGE */
	[LEDACT_NORMAL_ORANGE] = LEDACT_NORMAL_ORANGE,
	/* 500ms GREEN/OFF */
	[LEDACT_BLINK1] = LEDACT_BLINK1,
	/* 1sec GREEN/OFF */
	[LEDACT_BLINK2] = LEDACT_BLINK2,
	/* 200ms GREEN/OFF */
	[LEDACT_BLINK3] = LEDACT_BLINK3,
	/* 400ms GREEN/OFF */
	[LEDACT_BLINK4] = LEDACT_BLINK4,
	/* 500ms ORANGE/OFF */
	[LEDACT_BLINK1_ORANGE] = LEDACT_BLINK1_ORANGE,
	/* 500ms GREEN/ORANGE */
	[LEDACT_BLINK1_GREEN_ORANGE] = LEDACT_BLINK1_GREEN_ORANGE,
	/* 500ms RED/OFF */
	[LEDACT_BLINK1_RED] = LEDACT_BLINK1_RED,
	/* 500ms ORANGE/OFF sync oneshot flush */
	[LEDACT_FLUSH] = LEDACT_FLUSH,
	/* 500ms GREEN/OFF sync oneshot flush */
	[LEDACT_FLUSH_GREEN] = LEDACT_FLUSH_GREEN,
	/* oneshot orange */
	[LEDACT_ONESHOT_ORANGE] = LEDACT_ONESHOT_ORANGE,
	/* RED: high priority */
	[LEDACT_NORMAL_RED2] = LEDACT_NORMAL_RED2,
	/* 500ms ORANGE/OFF: high priority */
	[LEDACT_BLINK1_ORANGE2] = LEDACT_BLINK1_ORANGE2,
	/* 500ms GREEN/ORANGE: high priority */
	[LEDACT_BLINK1_GREEN_ORANGE2] = LEDACT_BLINK1_GREEN_ORANGE2,
	/* 100ms RED/OFF */
	[LEDACT_BLINK3_RED] = LEDACT_BLINK3_RED,
	/* 200ms/100ms ORANGE/OFF */
	[LEDACT_BLINK1_ORANGE3] = LEDACT_BLINK1_ORANGE3,
	/* ORANGE: high priority */
	[LEDACT_NORMAL_ORANGE2] = LEDACT_NORMAL_ORANGE2,
	/* 200ms ORANGE, 100ms GREEN : high priority */
	[LEDACT_BLINK7_ORANGE_GREEN] = LEDACT_BLINK7_ORANGE_GREEN,
	/* 200ms ORANGE, 100ms GREEN */
	[LEDACT_BLINK7_ORANGE_GREEN2] = LEDACT_BLINK7_ORANGE_GREEN2,
	/* 1000ms BLINK RED(100ms RED/OFF), 500ms OFF */
	[LEDACT_BLINK8_RED] = LEDACT_BLINK8_RED,
	/* OFF */
	[LEDACT_INACTIVATE] = LEDACT_INACTIVATE,
	/* 1sec ORANGE */
	[LEDACT_1SEC_ORANGE] = LEDACT_1SEC_ORANGE,
	/* oneshot red */
	[LEDACT_ONESHOT_RED] = LEDACT_ONESHOT_RED,
	/* 100ms GREEN, 900msec OFF */
	[LEDACT_BLINK5] = LEDACT_BLINK5,
	/* BLUE */
	[LEDACT_NORMAL_BLUE] = 0,
	/* 100ms RED/OFF: high priority */
	[LEDACT_BLINK3_RED2] = LEDACT_BLINK3_RED2,
	/* OFF: high priority */
	[LEDACT_INACTIVATE2] = LEDACT_INACTIVATE2,
	/* LEDACT_REAL_MAX */
	[LEDACT_REAL_MAX] = LEDACT_REAL_MAX,
/* for VoIP module */
	[LEDACT_VOIP_AVAILABLE] = LEDACT_NORMAL,
	[LEDACT_VOIP_UNAVAILABLE] = LEDACT_NORMAL_RED,
	[LEDACT_VOIP_IP_ACT] = LEDACT_BLINK1,
	[LEDACT_VOIP_IP_PSTN_ACT1] = LEDACT_BLINK2,
	[LEDACT_VOIP_IP_PSTN_ACT2] = LEDACT_BLINK1_GREEN_ORANGE,
	[LEDACT_VOIP_PSTN_ACT] = LEDACT_BLINK1_ORANGE,
	[LEDACT_VOIP_STOP] = LEDACT_NORMAL_ORANGE,
	[LEDACT_VOIP_INIT] = 0, /* LEDACT_MAX */
/* for PPP module */
	[LEDACT_PPP_IDLE] = LEDACT_FLUSH_GREEN,
	[LEDACT_LCP_STARTING] = LEDACT_BLINK3,
	[LEDACT_AUTH_STARTING] = LEDACT_BLINK2,
	[LEDACT_AUTH_SUCCESSED] = LEDACT_BLINK1,
	[LEDACT_IPCP_STARTING] = LEDACT_BLINK1,
	[LEDACT_IPCP_OPENED] = LEDACT_NORMAL,
	[LEDACT_IPV6CP_STARTING] = LEDACT_BLINK1,
	[LEDACT_IPV6CP_OPENED] = LEDACT_NORMAL,
/* DA (device agent) */
	[LEDACT_DA_CONNECTING] = LEDACT_BLINK1_RED,
	[LEDACT_DA_CONFIG_WRITING] = LEDACT_NORMAL_RED,
	[LEDACT_DA_DMS_CONNECT_WAIT] = LEDACT_BLINK1_ORANGE,
	[LEDACT_ALIAS_DMS_CONNECT_WAIT] = LEDACT_BLINK1_ORANGE,
	[LEDACT_DA_SLEEPING] = 0, /* LEDACT_MAX */
/* VUP (version up) */
	[LEDACT_VUP_FIRMWARE_UPDATE] = LEDACT_NORMAL_ORANGE,
	[LEDACT_VUP_EMERGENCY_COPY] = LEDACT_NORMAL_ORANGE,
/* ADSL */
	[LEDACT_ADSL_LINKUP] = LEDACT_NORMAL,
	[LEDACT_ADSL_TRAINING] = LEDACT_BLINK3,
	[LEDACT_ADSL_ACTIVATING] = LEDACT_BLINK4,
/* WZC */
	[LEDACT_WZC_SEARCHING_STA] = LEDACT_BLINK1,
	[LEDACT_WZC_WAITING_BUTTON_2ND_PUSH_CARD] = LEDACT_BLINK1_ORANGE2,
	[LEDACT_WZC_WAITING_BUTTON_2ND_PUSH_ETHERBOX] = LEDACT_BLINK1_GREEN_ORANGE2,
	[LEDACT_WZC_COMPLETE] = LEDACT_NORMAL_ORANGE,
	[LEDACT_WZC_FAIL] = LEDACT_NORMAL_RED2,
/*サブネット補完機能*/
	[LEDACT_AUTO_SUBNET_ERR] = LEDACT_BLINK1_ORANGE,
/* IP アドレス設定/削除 */
	[LEDACT_IP_ASSIGN] = LEDACT_NORMAL,
/* for WPS */
	[LEDACT_WPS_COMPLETE] = LEDACT_NORMAL_ORANGE2,
	[LEDACT_WPS_FAIL] = LEDACT_NORMAL_RED,
	[LEDACT_WPS_SETTING] = LEDACT_BLINK1,
	[LEDACT_WPS_SETTING_M5] = 0,
	[LEDACT_WPS_SESSION_OVERLAP] = LEDACT_BLINK8_RED,
	[LEDACT_WPS_START] = 0,
/* らくらくネットスタート wan select */
	[LEDACT_WS_NONE] = LEDACT_BLINK1_ORANGE,
	[LEDACT_WS_START] = LEDACT_BLINK2,
	[LEDACT_WS_PPPOE] = LEDACT_BLINK1_ORANGE,
	[LEDACT_WS_FAIL] = LEDACT_BLINK1_RED,
/* USB */
	[LEDACT_USB_MEMORY_WRITING] = LEDACT_1SEC_ORANGE,
/* 子機モード */
	[LEDACT_CLIENT_MODE] = LEDACT_NORMAL,
	[LEDACT_CLIENT_DHCP_MODE] = LEDACT_BLINK5,
	[LEDACT_DETECT_CONFLICTED_IPADDR] = LEDACT_BLINK1_ORANGE,
/* Thermal Mitigation */
	[LEDACT_THERMAL_ALARM] = LEDACT_BLINK3_RED2,
	[LEDACT_MAX] = LEDACT_MAX,
};

static const action_list_t action_list[] = {
	/* priority order */
	{LEDST_BLINK_RED,
	 (ledact_bitmap_t) 1 << (LEDACT_BLINK3_RED2 - 1),
	 LEDFUNC_ACT_BLINK6, LEDCOLOR_RED, 0, 0, 1},
	{LEDST_OFF,
	 (ledact_bitmap_t) 1 << (LEDACT_INACTIVATE2 - 1),
	 LEDFUNC_ACT_OFF, 0, 0, 0, 0},
	{LEDST_OFF,
	 (ledact_bitmap_t) 1 << (LEDACT_INACTIVATE - 1),
	 LEDFUNC_ACT_OFF, 0, 0, 0, 0},
	{LEDST_NONE,
	 (ledact_bitmap_t) 1 << (LEDACT_FLUSH - 1),
	 LEDFUNC_ACT_FLUSH, LEDCOLOR_ORANGE, 0, 0, 0},
	{LEDST_NONE,
	 (ledact_bitmap_t) 1 << (LEDACT_FLUSH_GREEN - 1),
	 LEDFUNC_ACT_FLUSH_GREEN, LEDCOLOR_GREEN, 0, 0, 0},
	{LEDST_NONE,
	 (ledact_bitmap_t) 1 << (LEDACT_ONESHOT_RED - 1),
	 LEDFUNC_ACT_ONESHOT_RED, LEDCOLOR_RED, 0, 0, 0},
	{LEDST_NONE,
	 (ledact_bitmap_t) 1 << (LEDACT_ONESHOT - 1),
	 LEDFUNC_ACT_ONESHOT, LEDCOLOR_GREEN, 0, 0, 0},
	{LEDST_NONE,
	 (ledact_bitmap_t) 1 << (LEDACT_ONESHOT_ORANGE - 1),
	 LEDFUNC_ACT_ONESHOT_ORANGE, LEDCOLOR_ORANGE, 0, 0, 0},
	{LEDST_BLINK_GREEN,
	 (ledact_bitmap_t) 1 << (LEDACT_BLINK3 - 1),
	 LEDFUNC_ACT_BLINK3, LEDCOLOR_GREEN, 0, 0, 1},
	{LEDST_BLINK_GREEN,
	 (ledact_bitmap_t) 1 << (LEDACT_BLINK4 - 1),
	 LEDFUNC_ACT_BLINK4, LEDCOLOR_GREEN, 0, 0, 1},
	{LEDST_BLINK_RED,
	 (ledact_bitmap_t) 1 << (LEDACT_BLINK3_RED - 1),
	 LEDFUNC_ACT_BLINK6, LEDCOLOR_RED, 0, 0, 1},
	{LEDST_BLINK_RED,
	 (ledact_bitmap_t) 1 << (LEDACT_BLINK8_RED - 1),
	 LEDFUNC_ACT_BLINK8, LEDCOLOR_RED, 0, 0, 1},
	{LEDST_ORANGE,
	 (ledact_bitmap_t) 1 << (LEDACT_NORMAL_ORANGE2 - 1),
	 LEDFUNC_ACT_ON, LEDCOLOR_ORANGE, 0, 0, 0},
	{LEDST_BLINK_ORANGE,
	 (ledact_bitmap_t) 1 << (LEDACT_BLINK1_ORANGE3 - 1),
	 LEDFUNC_ACT_BLINK7, LEDCOLOR_ORANGE, 0, 0, 1},
	{LEDST_BLINK_ORANGE,
	 (ledact_bitmap_t) 1 << (LEDACT_BLINK7_ORANGE_GREEN - 1),
	 LEDFUNC_ACT_BLINK7, LEDCOLOR_ORANGE, LEDCOLOR_GREEN, 0, 1},
	{LEDST_BLINK_GREEN,
	 (ledact_bitmap_t) 1 << (LEDACT_BLINK5 - 1),
	 LEDFUNC_ACT_BLINK5, LEDCOLOR_GREEN, 0, 0, 1},
	{LEDST_RED,
	 (ledact_bitmap_t) 1 << (LEDACT_NORMAL_RED2 - 1),
	 LEDFUNC_ACT_ON, LEDCOLOR_RED, 0, 0, 0},
	{LEDST_RED,
	 (ledact_bitmap_t) 1 << (LEDACT_NORMAL_RED - 1),
	 LEDFUNC_ACT_ON, LEDCOLOR_RED, 0, 0, 0},
	{LEDST_BLINK_RED,
	 (ledact_bitmap_t) 1 << (LEDACT_BLINK1_RED - 1),
	 LEDFUNC_ACT_BLINK1, LEDCOLOR_RED, 0, 0, 1},
	{LEDST_ORANGE,
	 (ledact_bitmap_t) 1 << (LEDACT_NORMAL_ORANGE - 1),
	 LEDFUNC_ACT_ON, LEDCOLOR_ORANGE, 0, 0, 0},
	{LEDST_BLINK_GREEN,
	 (ledact_bitmap_t) 1 << (LEDACT_BLINK1 - 1),
	 LEDFUNC_ACT_BLINK1, LEDCOLOR_GREEN, 0, 0, 1},
	{LEDST_BLINK_GREEN,
	 (ledact_bitmap_t) 1 << (LEDACT_BLINK1_GREEN_ORANGE2 - 1),
	 LEDFUNC_ACT_BLINK1, LEDCOLOR_GREEN, LEDCOLOR_ORANGE, 0, 1},
	{LEDST_BLINK_ORANGE,
	 (ledact_bitmap_t) 1 << (LEDACT_BLINK1_ORANGE2 - 1),
	 LEDFUNC_ACT_BLINK1, LEDCOLOR_ORANGE, 0, 0, 1},
	{LEDST_BLINK_ORANGE,
	 (ledact_bitmap_t) 1 << (LEDACT_BLINK7_ORANGE_GREEN2 - 1),
	 LEDFUNC_ACT_BLINK7, LEDCOLOR_ORANGE, LEDCOLOR_GREEN, 0, 1},
	{LEDST_BLINK_ORANGE,
	 (ledact_bitmap_t) 1 << (LEDACT_BLINK1_ORANGE - 1),
	 LEDFUNC_ACT_BLINK1, LEDCOLOR_ORANGE, 0, 0, 1},
	{LEDST_BLINK_ORANGE,
	 (ledact_bitmap_t) 1 << (LEDACT_BLINK1_GREEN_ORANGE - 1),
	 LEDFUNC_ACT_BLINK1, LEDCOLOR_GREEN, LEDCOLOR_ORANGE, 0, 1},
	{LEDST_NONE,
	 (ledact_bitmap_t) 1 << (LEDACT_1SEC_ORANGE - 1),
	 LEDFUNC_ACT_1SEC_ORANGE, LEDCOLOR_ORANGE, 0, 0, 0},
	{LEDST_BLINK_GREEN,
	 (ledact_bitmap_t) 1 << (LEDACT_BLINK2 - 1),
	 LEDFUNC_ACT_BLINK2, LEDCOLOR_GREEN, 0, 0, 1},
	{LEDST_GREEN,
	 (ledact_bitmap_t) 1 << (LEDACT_NORMAL - 1),
	 LEDFUNC_ACT_ON, LEDCOLOR_GREEN, 0, 0, 0},
	{LEDST_BLUE,
	 (ledact_bitmap_t) 1 << (LEDACT_NORMAL_BLUE - 1),
	 LEDFUNC_ACT_ON, LEDCOLOR_BLUE, 0, 0, 0},
	{LEDST_OFF,
	 (ledact_bitmap_t) 0,
	 LEDFUNC_ACT_OFF, 0, 0, 0, 0}
};

#if 0 /* NO USE */
#define LEDACT_BITMAP(x) ((ledact_bitmap_t) 1 << ((x) - 1))
static const blinkspeed_list_t blinkspeed_list[] = {
};
#endif /* NO USE */

static const struct led_bitmap led_rotary_bitmap[LEDT_REAL_MAX] = {
	/* LEDT_ALL:SPECIAL LED TYPE */
	[LEDT_ALL] = {
		.color = {0, LED_ALL_GRN, LED_ALL_RED, LED_ALL_ORANGE,
			  0, 0, 0, 0},
		.mask = LED_ALL,
	},
	[LEDT_POWER] = {
		.color = {0, LED_POWER_GRN, LED_POWER_RED, LED_POWER_ORANGE,
			  0, 0, 0, 0},
		.mask = LED_POWER_ORANGE,
	},
	[LEDT_PPP] = {
		.color = {0, LED_ACTIVE_GRN, LED_ACTIVE_RED, LED_ACTIVE_ORANGE,
			  0, 0, 0, 0},
		.mask = LED_ACTIVE_ORANGE,
	},
	[LEDT_AIR] = {
		.color = {0, LED_AIR_GRN, LED_AIR_RED, LED_AIR_ORANGE,
			  0, 0, 0, 0},
		.mask = LED_AIR_ORANGE,
	},
	[LEDT_AIR2] = {
		.color = {0, LED_AIR2_GRN, LED_AIR2_RED, LED_AIR2_ORANGE,
			  0, 0, 0 ,0},
		.mask = LED_AIR2_ORANGE,
	},
	[LEDT_TV_MODE] = {
		.color = {0, LED_TV_GRN, LED_TV_RED, LED_TV_ORANGE,
			  0, 0, 0, 0},
		.mask = LED_TV_ORANGE,
	},
        [LEDT_CLIENT] = {
		.color = {0, LED_CL_GRN, LED_CL_RED, LED_CL_ORANGE,
			  0, 0, 0, 0},
		.mask = LED_CL_ORANGE,
	},
};

static const type_name_list_t type_name_list[] = {
	{"all", LEDT_ALL},
	{"disc", LEDT_DISC},
	{"power", LEDT_POWER},
	{"ppp", LEDT_PPP},
	{"data", LEDT_DATA},
	{"voip", LEDT_VOIP},
	{"air", LEDT_AIR},
	{"update", LEDT_UPDATE},
	{"line", LEDT_LINE},
	{"lan", LEDT_LAN},
	{"air2", LEDT_AIR2},
	{"tv", LEDT_TV_MODE},
	{"da", LEDT_ALIAS_DA},
	{"active", LEDT_ALIAS_ACTIVE},
	{"auto_subnet_err_type", LEDT_AUTO_SUBNET_ERR},
	{"client", LEDT_CLIENT},
	{"logo", LEDT_LOGO},
	{NULL, LEDT_MAX}
};

static const act_name_list_t act_name_list[] = {
	{"oneshot", LEDACT_ONESHOT},
	{"normal", LEDACT_NORMAL},
	{"normal_red", LEDACT_NORMAL_RED},
	{"normal_orange", LEDACT_NORMAL_ORANGE},
	{"blink1", LEDACT_BLINK1},
	{"blink2", LEDACT_BLINK2},
	{"blink3", LEDACT_BLINK3},
	{"blink4", LEDACT_BLINK4},
	{"blink1_orange", LEDACT_BLINK1_ORANGE},
	{"blink1_green_orange", LEDACT_BLINK1_GREEN_ORANGE},
	{"blink1_red", LEDACT_BLINK1_RED},
	{"flush", LEDACT_FLUSH},
	{"flush_green", LEDACT_FLUSH_GREEN},
	{"oneshot_orange", LEDACT_ONESHOT_ORANGE},
	{"dms_connect_wait", LEDACT_ALIAS_DMS_CONNECT_WAIT},
	{"normal_red2", LEDACT_NORMAL_RED2}, /* high priority */
	{"blink1_orange2", LEDACT_BLINK1_ORANGE2}, /* high priority */
	{"blink1_green_orange2", LEDACT_BLINK1_GREEN_ORANGE2}, /* high prio */
	{"auto_subnet_err_act", LEDACT_AUTO_SUBNET_ERR},
	{"blink8_red", LEDACT_BLINK8_RED},
	{"inactivate", LEDACT_INACTIVATE},
	{"1sec_orange", LEDACT_1SEC_ORANGE},
	{"oneshot_red", LEDACT_ONESHOT_RED},
	{"blink5", LEDACT_BLINK5},
	{"client_mode", LEDACT_CLIENT_MODE},
	{"client_dhcp_mode", LEDACT_CLIENT_DHCP_MODE},
	{"detect_conflicted_ipaddr", LEDACT_DETECT_CONFLICTED_IPADDR},
	{"normal_blue", LEDACT_NORMAL_BLUE},
	{"blink3_red", LEDACT_BLINK3_RED},
	{"thermal_alarm", LEDACT_THERMAL_ALARM},
	{"blink3_red2", LEDACT_BLINK3_RED2},
	{NULL, LEDACT_MAX}
};

static struct led_softc led_softc = {
	.type_alias = ledtype_alias,
	.act_alias = ledact_alias,
	.action_list = action_list,
	.blinkspeed_list = NULL,
	.type_name_list = type_name_list,
	.act_name_list = act_name_list,
	.bitmap = led_rotary_bitmap,
	.ledwrite = (void (*)(uint32_t, int)) akroled_write,
};

struct led_softc *led_sc = &led_softc;

static struct htled_platform_data rotary_htled_data = {
	.sc = &led_softc,
};

static struct platform_device htled_device = {
	.name = "htled",
	.id = -1,
	.dev            = {
		.platform_data  = &rotary_htled_data,
	},
};

#endif /* __LED_ROTARY_C__ */
