#ifndef __HTLEDPROFILE_H__
#define __HTLEDPROFILE_H__

typedef enum {
	LEDT_ALL = 1,		/* ALL LED */
	LEDT_DISC,
	LEDT_POWER,
	LEDT_PPP,
	LEDT_DATA,
	LEDT_VOIP,
	LEDT_AIR,
	LEDT_UPDATE,
	LEDT_LINE,
	LEDT_LAN,
	LEDT_AIR2,
	LEDT_TV_MODE,
	LEDT_CLIENT,
	LEDT_LOGO,
	LEDT_REAL_MAX,		/* REAL MAX */
	LEDT_ALIAS_DA,		/* ALIAS DA (device agent) LED */
	LEDT_ALIAS_ACTIVE,
/* WZC */
	LEDT_WZC_PROGRESS,
	LEDT_WZC_ERROR,
/* サブネット補完機能 */
	LEDT_AUTO_SUBNET_ERR,
/* IP アドレス設定/削除 */
	LEDT_IP_ASSIGN,
	LEDT_MAX
} ledtype_t;

typedef enum {
	LEDACT_ONESHOT = 1,	/* oneshot green */
	LEDACT_NORMAL,		/* GREEN */
	LEDACT_NORMAL_RED,	/* RED */
	LEDACT_NORMAL_ORANGE,	/* ORANGE */
	LEDACT_BLINK1,		/* 500ms GREEN/OFF */
	LEDACT_BLINK2,		/* 1sec GREEN/OFF */
	LEDACT_BLINK3,		/* 200ms GREEN/OFF */
	LEDACT_BLINK4,		/* 400ms GREEN/OFF */
	LEDACT_BLINK1_ORANGE,	/* 500ms ORANGE/OFF */
	LEDACT_BLINK1_GREEN_ORANGE, /* 500ms GREEN/ORANGE */
	LEDACT_BLINK1_RED,	/* 500ms RED/OFF */
	LEDACT_FLUSH,		/* 500ms ORANGE/OFF sync oneshot flush */
	LEDACT_FLUSH_GREEN,	/* 500ms GREEN/OFF sync oneshot flush */
	LEDACT_ONESHOT_ORANGE,  /* oneshot orange */
	LEDACT_NORMAL_RED2,     /* RED: high priority */
	LEDACT_BLINK1_ORANGE2,	/* 500ms ORANGE/OFF: high priority */
	LEDACT_BLINK1_GREEN_ORANGE2, /* 500ms GREEN/ORANGE: high priority */
	LEDACT_BLINK3_RED,	/* 100ms RED/OFF */
	LEDACT_BLINK1_ORANGE3, /* 200ms/100ms ORANGE/OFF */
	LEDACT_NORMAL_ORANGE2, 	/* ORANGE: high priority */
	LEDACT_BLINK7_ORANGE_GREEN, /* 200ms ORANGE, 100ms GREEN : high priority */
	LEDACT_BLINK7_ORANGE_GREEN2, 	/* 200ms ORANGE, 100ms GREEN */
	LEDACT_BLINK8_RED, 	/* 1000ms BLINK RED(100ms RED/OFF), 500ms OFF */
	LEDACT_INACTIVATE,	/* OFF */
	LEDACT_1SEC_ORANGE, 	/* 1sec ORANGE */
	LEDACT_ONESHOT_RED, 	/* oneshot red */
	LEDACT_BLINK5, 		/* 100ms GREEN, 900msec OFF */
	LEDACT_NORMAL_BLUE, 	/* BLUE */
	LEDACT_BLINK3_RED2,	/* 100ms RED/OFF: high priority */
	LEDACT_INACTIVATE2,	/* OFF: high priority */
	LEDACT_REAL_MAX,
/* for VoIP module */
	LEDACT_VOIP_AVAILABLE,
	LEDACT_VOIP_UNAVAILABLE,
	LEDACT_VOIP_IP_ACT,
	LEDACT_VOIP_IP_PSTN_ACT1,
	LEDACT_VOIP_IP_PSTN_ACT2,
	LEDACT_VOIP_PSTN_ACT,
	LEDACT_VOIP_STOP,
	LEDACT_VOIP_INIT, /* VoIPでは消灯と定義する */
/* for PPP module */
	LEDACT_PPP_IDLE, /* PPP では消灯と定義する */
	LEDACT_LCP_STARTING,
	LEDACT_AUTH_STARTING,
	LEDACT_AUTH_SUCCESSED,
	LEDACT_IPCP_STARTING,
	LEDACT_IPCP_OPENED,
	LEDACT_IPV6CP_STARTING,
	LEDACT_IPV6CP_OPENED,
/* DA (device agent) */
	LEDACT_DA_CONNECTING,
	LEDACT_DA_CONFIG_WRITING,
	LEDACT_ALIAS_DMS_CONNECT_WAIT,
	LEDACT_DA_DMS_CONNECT_WAIT,
	LEDACT_DA_SLEEPING, /* ignore */
/* VUP (version up) */
	LEDACT_VUP_FIRMWARE_UPDATE,
	LEDACT_VUP_EMERGENCY_COPY,
/* ADSL */
	LEDACT_ADSL_LINKUP,
	LEDACT_ADSL_TRAINING,
	LEDACT_ADSL_ACTIVATING, /* 信号検出待ち */
/* WZC */
	LEDACT_WZC_SEARCHING_STA, /* 子機検索中 */
	LEDACT_WZC_WAITING_BUTTON_2ND_PUSH_CARD, /* 子機(card)検索完了し、2回目の無線Setボタン押下待ち */
	LEDACT_WZC_WAITING_BUTTON_2ND_PUSH_ETHERBOX, /* 子機(EtherBox)検索完了し、2回目の無線Setボタン押下待ち */
	LEDACT_WZC_COMPLETE, /* 無線ZeroConfig処理完了 */
	LEDACT_WZC_FAIL, /* 無線ZeroConfig処理失敗 */
/*サブネット補完機能*/
	LEDACT_AUTO_SUBNET_ERR,
/* IP アドレス設定/削除 */
	LEDACT_IP_ASSIGN,
/* for WPS */
	LEDACT_WPS_COMPLETE, /* WPS成功 */
	LEDACT_WPS_FAIL, /* 失敗 */
	LEDACT_WPS_SETTING, /* 設定処理中 */
	LEDACT_WPS_SETTING_M5, /* 設定処理中(M5) */
	LEDACT_WPS_SESSION_OVERLAP, /* セッションオーバーラップ検出 */
	LEDACT_WPS_START, /* WPS開始 */
/* らくらくネットスタート wan select */
	LEDACT_WS_NONE, /* 判別実施しない */
	LEDACT_WS_START, /* 判別開始 */
	LEDACT_WS_PPPOE, /* 判別結果:PPPoE */
	LEDACT_WS_FAIL, /* 判別結果:判別不能 */
/* USB */
	LEDACT_USB_MEMORY_WRITING,
/* 子機モード */
	LEDACT_CLIENT_MODE,
	LEDACT_CLIENT_DHCP_MODE,
	LEDACT_DETECT_CONFLICTED_IPADDR,
/* Thermal Mitigation */
	LEDACT_THERMAL_ALARM,
	LEDACT_MAX
} ledact_type_t;

#define LEDACT_DUMMY 0
#define LEDACT_FLUSH_1 LEDACT_ONESHOT
#define LEDACT_FLUSH_2 LEDACT_ONESHOT_ORANGE
#define LEDACT_FLUSH_3 LEDACT_1SEC_ORANGE
#define LEDACT_FLUSH_4 LEDACT_DUMMY
#define LEDACT_FLUSH_5 LEDACT_DUMMY
#define LEDACT_FLUSH_6 LEDACT_FLUSH
#define LEDACT_FLUSH_7 LEDACT_FLUSH_GREEN
#define LEDACT_FLUSH_8 LEDACT_DUMMY
#define LEDACT_FLUSH_9 LEDACT_DUMMY
#define LEDACT_FLUSH_10 LEDACT_ONESHOT_RED

#if defined(__KERNEL__)
typedef uint64_t ledact_bitmap_t;

struct multi_type_list {
	ledtype_t type;
	ledact_type_t action;
	const ledact_type_t *acts;
};

#if defined(LED_NIGHTMODE)
static const struct multi_type_list nm_all_list[] = {
	{LEDT_POWER, LEDACT_INACTIVATE2, NULL},
	{LEDT_AIR, LEDACT_INACTIVATE2, NULL},
	{LEDT_ALIAS_ACTIVE, LEDACT_INACTIVATE2, NULL},
	{LEDT_AIR2, LEDACT_INACTIVATE2, NULL},
	{LEDT_TV_MODE, LEDACT_INACTIVATE2, NULL},
	{LEDT_CLIENT, LEDACT_INACTIVATE2, NULL},
	{LEDT_LOGO, LEDACT_INACTIVATE2, NULL},
	{LEDT_MAX, LEDACT_MAX, NULL}
};
#endif /* LED_NIGHTMODE */

#else /* !__KERNEL__ */
int ledwrite_eco(int);

typedef enum {
	LED_ROUTER_OFF_MODE_1 = 0,
	LED_ROUTER_OFF_MODE_2,
	LED_ROUTER_OFF_MODE_MAX
} led_router_off_mode_t;

int ledwrite_router_off(led_router_off_mode_t, int);

#if defined(LIBLED_MULTIACT_LIST)
#define HAVE_MULTIACT_LIST
struct multiact_list {
	ledact_type_t action;
	const ledact_type_t *acts;
};

struct eco_list {
	ledtype_t type;
	ledact_type_t action;
	const ledact_type_t *acts;
};

int ledwrite_multi_type(const struct eco_list *, int);

static ledact_type_t multiact_eew[] = {
	LEDACT_MAX
};

static struct multiact_list multiact_list[] = {
	{LEDACT_MAX, NULL}
};

#define HAVE_ECO_LIST
static ledact_type_t multiact_eco_option[] = {
	LEDACT_MAX
};

static ledact_type_t multiact_eco_alarm[] = {
	LEDACT_MAX
};

static struct eco_list eco_list[] = {
	{LEDT_POWER, LEDACT_BLINK2, NULL},
	{LEDT_AIR, LEDACT_INACTIVATE, NULL},
	{LEDT_ALIAS_ACTIVE, LEDACT_INACTIVATE, NULL},
	{LEDT_AIR2, LEDACT_INACTIVATE, NULL},
	{LEDT_TV_MODE, LEDACT_INACTIVATE, NULL},
	{LEDT_CLIENT, LEDACT_INACTIVATE, NULL},
	{LEDT_LOGO, LEDACT_INACTIVATE, NULL},
	{LEDT_MAX, LEDACT_MAX, NULL}
};

#if 0 /* NO USE */
#define HAVE_ROUTER_OFF_LIST
struct router_off_mode_name_list {
	const char *name;
	led_router_off_mode_t mode;
};

static struct router_off_mode_name_list mode_name_list[] = {
	{"mode1", LED_ROUTER_OFF_MODE_1},
	{"mode2", LED_ROUTER_OFF_MODE_2},
	{NULL, LED_ROUTER_OFF_MODE_MAX}
};

static struct eco_list router_off_list_0[] = {
	{LEDT_MAX, LEDACT_MAX, NULL}
};

static struct eco_list router_off_list_1[] = {
	{LEDT_MAX, LEDACT_MAX, NULL}
};
#endif /* NO USE */

#endif /* LIBLED_MULTIACT_LIST */
#endif /* __KERNEL__ */

#endif /* _HTLEDPROFILE_H_ */
