#ifndef __AKROLED_C__
#define __AKROLED_C__

#include "akroled.h"

#if 1 /* for gpio access */
#include "akro_gpioport.h"
#define GPIO_PORT_LEDMAX -1

struct led_gpio_arg {
	union {
		int pin;
		int *pin_tbl;
	} u;
};

static void led_write_gpio(led_t, int);
static void gpio_write_one(const struct led_gpio_arg *, int);
static void gpio_write_multi(const struct led_gpio_arg *, int);

struct led_gpio {
	void (*io)(const struct led_gpio_arg *, int);
	const struct led_gpio_arg arg;
} led_gpio_tbl[] = {
	[LED_ALL_GRN] = {.io = gpio_write_multi,
			 .arg ={.u = {.pin_tbl = (int []){
					GPIO_PORT_LEDPWRG,
					GPIO_PORT_LEDPPPG,
					GPIO_PORT_LEDAIRG,
					GPIO_PORT_LEDAIR2G,
					GPIO_PORT_LEDTVG,
					GPIO_PORT_LEDCLG,
					GPIO_PORT_LEDMAX}}}},
	[LED_ALL_RED] = {.io = gpio_write_multi,
			 .arg ={.u = {.pin_tbl = (int []){
					GPIO_PORT_LEDPWRR,
					GPIO_PORT_LEDPPPR,
					GPIO_PORT_LEDAIRR,
					GPIO_PORT_LEDAIR2R,
					GPIO_PORT_LEDTVR,
					GPIO_PORT_LEDCLR,
					GPIO_PORT_LEDMAX}}}},
	[LED_ALL_ORANGE] = {.io = gpio_write_multi,
			    .arg ={.u = {.pin_tbl = (int []){
					GPIO_PORT_LEDPWRG,
					GPIO_PORT_LEDPPPG,
					GPIO_PORT_LEDAIRG,
					GPIO_PORT_LEDAIR2G,
					GPIO_PORT_LEDTVG,
					GPIO_PORT_LEDCLG,
					GPIO_PORT_LEDPWRR,
					GPIO_PORT_LEDPPPR,
					GPIO_PORT_LEDAIRR,
					GPIO_PORT_LEDAIR2R,
					GPIO_PORT_LEDTVR,
					GPIO_PORT_LEDCLR,
					GPIO_PORT_LEDMAX}}}},
	[LED_ALL] = {.io = gpio_write_multi,
		     .arg ={.u = {.pin_tbl = (int []){
					GPIO_PORT_LEDPWRG,
					GPIO_PORT_LEDPPPG,
					GPIO_PORT_LEDAIRG,
					GPIO_PORT_LEDAIR2G,
					GPIO_PORT_LEDTVG,
					GPIO_PORT_LEDCLG,
					GPIO_PORT_LEDPWRR,
					GPIO_PORT_LEDPPPR,
					GPIO_PORT_LEDAIRR,
					GPIO_PORT_LEDAIR2R,
					GPIO_PORT_LEDTVR,
					GPIO_PORT_LEDCLR,
					GPIO_PORT_LEDMAX}}}},
	[LED_POWER_GRN] = {.io = gpio_write_one,
			   .arg = {.u = {.pin = GPIO_PORT_LEDPWRG}}},
	[LED_POWER_RED] = {.io = gpio_write_one,
			   .arg = {.u = {.pin = GPIO_PORT_LEDPWRR}}},
	[LED_POWER_ORANGE] = {.io = gpio_write_multi,
			     .arg ={.u = {.pin_tbl = (int []){
					GPIO_PORT_LEDPWRG,
					GPIO_PORT_LEDPWRR,
					GPIO_PORT_LEDMAX}}}},
	[LED_ACTIVE_GRN] = {.io = gpio_write_one,
			   .arg = {.u = {.pin = GPIO_PORT_LEDPPPG}}},
	[LED_ACTIVE_RED] = {.io = gpio_write_one,
			   .arg = {.u = {.pin = GPIO_PORT_LEDPPPR}}},
	[LED_ACTIVE_ORANGE] = {.io = gpio_write_multi,
			       .arg ={.u = {.pin_tbl = (int []){
					GPIO_PORT_LEDPPPG,
					GPIO_PORT_LEDPPPR,
					GPIO_PORT_LEDMAX}}}},
	[LED_AIR_GRN] = {.io = gpio_write_one,
			   .arg = {.u = {.pin = GPIO_PORT_LEDAIRG}}},
	[LED_AIR_RED] = {.io = gpio_write_one,
			   .arg = {.u = {.pin = GPIO_PORT_LEDAIRR}}},
	[LED_AIR_ORANGE] = {.io = gpio_write_multi,
		     .arg ={.u = {.pin_tbl = (int []){
					GPIO_PORT_LEDAIRG,
					GPIO_PORT_LEDAIRR,
					GPIO_PORT_LEDMAX}}}},
	[LED_AIR2_GRN] = {.io = gpio_write_one,
			   .arg = {.u = {.pin = GPIO_PORT_LEDAIR2G}}},
	[LED_AIR2_RED] = {.io = gpio_write_one,
			   .arg = {.u = {.pin = GPIO_PORT_LEDAIR2R}}},
	[LED_AIR2_ORANGE] = {.io = gpio_write_multi,
		     .arg ={.u = {.pin_tbl = (int []){
					GPIO_PORT_LEDAIR2G,
					GPIO_PORT_LEDAIR2R,
					GPIO_PORT_LEDMAX}}}},
	[LED_TV_GRN] = {.io = gpio_write_one,
			   .arg = {.u = {.pin = GPIO_PORT_LEDTVG}}},
	[LED_TV_RED] = {.io = gpio_write_one,
			   .arg = {.u = {.pin = GPIO_PORT_LEDTVR}}},
	[LED_TV_ORANGE] = {.io = gpio_write_multi,
		     .arg ={.u = {.pin_tbl = (int []){
					GPIO_PORT_LEDTVG,
					GPIO_PORT_LEDTVR,
					GPIO_PORT_LEDMAX}}}},
	[LED_CL_GRN] = {.io = gpio_write_one,
			   .arg = {.u = {.pin = GPIO_PORT_LEDCLG}}},
	[LED_CL_RED] = {.io = gpio_write_one,
			   .arg = {.u = {.pin = GPIO_PORT_LEDCLR}}},
	[LED_CL_ORANGE] = {.io = gpio_write_multi,
		     .arg ={.u = {.pin_tbl = (int []){
					GPIO_PORT_LEDCLG,
					GPIO_PORT_LEDCLR,
					GPIO_PORT_LEDMAX}}}},
};

static void
led_write_gpio(led_t type, int on)
{
	const struct led_gpio *tbl = led_gpio_tbl;

	if (type != 0)
		tbl[type].io(&tbl[type].arg, (on ? 1 : 0));
}

static void
gpio_write_one(const struct led_gpio_arg *arg, int on)
{
	gpio_set_value(arg->u.pin, on);
}

static void
gpio_write_multi(const struct led_gpio_arg *arg, int on)
{
	int *pin_tbl;

	for (pin_tbl = arg->u.pin_tbl;
	     *pin_tbl != GPIO_PORT_LEDMAX; pin_tbl++) {
		gpio_set_value(*pin_tbl, on);
	}
}
#endif /* for gpio access */

void
akroled_write(uint32_t type, int on)
{
#if 1 /* for gpio access */
	led_write_gpio(type, on);
#else /* for gpio access */
	/* others (memory mapped, i2c, etc.) */
#endif /* for gpio access */
}

#endif /* __AKROLED_C__ */
