#ifndef __LINUX_MACUTIL_H__
#define __LINUX_MACUTIL_H__

#define __PACKED__ __attribute__ ((__packed__))

#define CONFIG_MACUTIL_OFFSET           0
#define CONFIG_FLASH_SIZE               (2 * 1024)
#define CONFIG_MAC_INFO_ADDR            CONFIG_MACUTIL_OFFSET /* Reserved 48byte */
#define CONFIG_CONFIG_ID_ADDR           (CONFIG_MACUTIL_OFFSET + 48) /* Reserved 16byte */
#define CONFIG_ADDITIONAL_INFO_ADDR     (CONFIG_MACUTIL_OFFSET + 64) /* reserved 64bytes */
#define ADDITIONAL_INFO_LENGTH          64
#define CONFIG_RANDOM_KEY_ADDR \
        (CONFIG_ADDITIONAL_INFO_ADDR + ADDITIONAL_INFO_LENGTH) /* reserved 4bytes */
#define CONFIG_SERIAL_NUM_ADDR          (CONFIG_RANDOM_KEY_ADDR + 4) /* reserved 32bytes */
#define SERIAL_NUM_LENGTH               32
#define CONFIG_PRESET_ID_ADDR \
        (CONFIG_SERIAL_NUM_ADDR + SERIAL_NUM_LENGTH) /* reserved 32bytes */
#define PRESET_ID_LENGTH                32

#ifdef USE_NECPF_FACTORY_2ND
#define FACTORY_2ND_AREA (CONFIG_MACUTIL_OFFSET + 256)

#define MAGIC_LENGTH		8
#define FACTORY_2ND_MAGIC	0x32434146
#define SSID_NUM		5
#define SSID_LENGTH		33
#define SSID_AREA_SIZE		64
#define CONFIG_SSID1_ADDR	FACTORY_2ND_AREA /* reserved 64bytes */

#define DEFKEY_LENGTH		14
#define DEFKEY_AREA_SIZE	32
#define DEFKEY_NUM		3
#define CONFIG_DEFKEY1_ADDR	\
	(CONFIG_SSID1_ADDR + (SSID_AREA_SIZE + MAGIC_LENGTH)	\
	 * SSID_NUM) /* reserved 32bytes */

#define WEBPW_LENGTH		9
#define WEBPW_AREA_SIZE		16
#define CONFIG_WEBPW_ADDR	\
	(CONFIG_DEFKEY1_ADDR + (DEFKEY_AREA_SIZE + MAGIC_LENGTH)	\
	 * DEFKEY_NUM) /* reserved 16bytes */
#define WPSPIN_LENGTH		9
#define WPSPIN_AREA_SIZE	16
#define CONFIG_WPSPIN_ADDR	\
	(CONFIG_WEBPW_ADDR + WEBPW_AREA_SIZE + MAGIC_LENGTH) /* reserved 16bytes */

#define IDX_SSID1 0
#define IDX_SSID2 1
#define IDX_SSID3 2
#define IDX_SSID4 3
#define IDX_SSID5 4
#define IDX_DEFKEY1 0
#define IDX_DEFKEY2 1
#define IDX_DEFKEY3 2
#endif	/* USE_NECPF_FACTORY_2ND */

typedef struct {
	u_int8_t mac_address[6];
} __PACKED__ mac_addr;

#define MAC_ADDR_ETHER 1
#define MAC_ADDR_USB 2
#define MAC_ADDR_WLAN 3
#define MAC_ADDR_ATM 4
#define MAC_ADDR_WAN 5
#define MAC_ADDR_WLAN_2ND 6
#define MAC_ADDR_XMAC 7

#define is_group_mac_addr(mac) ((mac)->mac_address[0] & 0x01)
#define is_local_mac_addr(mac) ((mac)->mac_address[0] & 0x02)

static __inline int compare_mac_addr(const mac_addr * a,
                                     const mac_addr * b)
{
	register int i = sizeof(*a);
	register int v;

	while (i-- > 0) {
		if ((v = a->mac_address[i] - b->mac_address[i]) != 0)
			return v;
	}
	return v;
}

void macutil_init(struct mtd_info *);

int get_mac_addr(int, mac_addr *);
int parse_mac(mac_addr *, const char *);

int get_config_id(void);
const char *get_additional_info(void);
int get_random_key(void);
const char *get_serial_num(void);
const char *get_preset_id(void);
#ifdef USE_NECPF_FACTORY_2ND
const char *get_ssid(int);
const char *get_defkey(int);
const char *get_webpw(void);
const char *get_wpspin(void);
#endif	/* USE_NECPF_FACTORY_2ND */

#endif /* __LINUX_MACUTIL_H__ */
