#include <linux/module.h>
#include <linux/capability.h>
#include <linux/errno.h>
#include <linux/types.h>
#include <linux/sockios.h>
#include <linux/if.h>
#include <linux/in.h>
#include <linux/ip.h>
#include <linux/if_tunnel.h>
#include <linux/net.h>
#include <linux/in6.h>
#include <linux/netdevice.h>
#include <linux/if_arp.h>
#include <linux/icmpv6.h>
#include <linux/init.h>
#include <linux/route.h>
#include <linux/rtnetlink.h>
#include <linux/netfilter_ipv6.h>
#include <linux/slab.h>

#include <net/ip.h>
#include <net/ipv6.h>
#include <net/route.h>
#include <net/ip6_route.h>
#include <net/addrconf.h>
#include <net/ip6_tunnel.h>
#include <net/xfrm.h>

#define DSLITE_ON	1
#define DSLITE_OFF	0
#define DSLITE_OK	0
#define DSLITE_NG	1

#define DSLITE_MTU     65535

/*
 * Debug output ON/OFF
 */
//#define DSLITE_DEBUG

#ifdef DSLITE_DEBUG
#define DSLITE_TRACE(s, ...) \
do { \
	char trace_buf[256]; \
	snprintf(trace_buf, sizeof(trace_buf), s, ##__VA_ARGS__); \
	printk(KERN_WARNING "%s[%u]: %s", __func__, __LINE__, trace_buf); \
} while (0)
#else
#define DSLITE_TRACE(s, ...) do {;} while(0)
#endif	/* DSLITE_DEBUG */

/*
 * shortcut-fe (Qualcom FastPath) 有効
 */
#define CONFIG_SFE_FAST_DS_LITE

#ifdef CONFIG_SFE_FAST_DS_LITE
extern void sfe_cm_create_rule_dslite(struct sk_buff *skb, struct ipv6hdr *ip6h, struct iphdr *ip4h, int direction);
extern void sfe_ipv4_destroy_all_rules_for_dev(struct net_device *dev);

#include "../../../shortcut-fe/shortcut-fe/sfe_cm.h"

#define FTP_CTL_PORT 21
#endif


extern int dslite_option_ioctl(struct ifreq *ifr, int cmd);
extern int dslite_check_aftr(struct ip6_tnl *tnl, const struct in6_addr *remote, const struct in6_addr *local);
/* nobori */
#if 0
extern int dslite_check_localnet(struct ip6_tnl *t, struct sk_buff *skb);
#endif
extern u8 dslite_hoplimit(struct ip6_tnl *t, struct sk_buff *skb);
extern int dslite_check_mtu(struct sk_buff *skb, __u32 *pmtu, __u32 mtu);
