#ifndef _MAP_E_H
#define _MAP_E_H

#ifdef __KERNEL__
#include <linux/skbuff.h>
#include <linux/string.h>
#include <net/flow.h>
#else
#include <linux/string.h>
#include <sys/types.h>
#endif /* __KERNEL__ */

#if 0
#define MAP_DEBUG	/* デバッグしている間は定義しておく(リリース時にはコメントアウトする) */
#endif

/*
 * shortcut-fe (Qualcom FastPath) 有効
 */
#define CONFIG_SFE_FAST_MAP_E

#ifdef __KERNEL__
#ifdef MAP_DEBUG
extern uint8_t g_debug;
#define MAP_TRACE(format, args...)							\
	do { if (g_debug) {								\
		char trace_buf[256];							\
		snprintf(trace_buf, sizeof(trace_buf), format, ## args);		\
		printk(KERN_WARNING "[%s:%d] %s\n", __func__, __LINE__, trace_buf);	\
	} } while (0)
#else
#define MAP_TRACE(x...) do {;} while(0)
#endif	/* MAP_DEBUG */
#endif /* __KERNEL__ */

#ifdef __KERNEL__
#ifdef MAP_DEBUG
#define KMALLOC(size, flags)	debug_kmalloc((size), (flags), __func__, __LINE__)
static inline void *
debug_kmalloc(size_t size, gfp_t flags, const char *fname, int lineno)
{
	void *p;
	p = kmalloc(size, flags);
	MAP_TRACE("*** kmalloc(%u, %x) -> 0x%08x, <%s:%d>\n",
	    size, (int)flags, (int)p, fname, lineno);
	return p;
}
#define KFREE(p)	debug_kfree((p), __func__, __LINE__)
static inline void
debug_kfree(void *p, const char *fname, int lineno)
{
	MAP_TRACE("*** kfree(0x%08x), <%s:%d>\n",
	    (int)p, fname, lineno);
	kfree(p);
}
#else
#define KMALLOC(size, flags)	kmalloc(size, flags)
#define KFREE(p)		kfree(p)
#endif	/* MAP_DEBUG */
#endif /* __KERNEL__ */


/* GREヘッダ定義 */
struct pptp_grehdr {
	uint16_t flags;
	uint16_t ptype;
	uint16_t len;
	uint16_t call_id;
	uint32_t seq;
	uint32_t ack;
};

/*
 * MAP-E関連の定義
 */
/* MAP-Eルール(カーネル用) */
typedef struct map_e_rule {
	struct list_head list;

	uint32_t id;			/* Rule Identifier */
	uint32_t bmr;                   /* BMR Identifier */
	struct in6_addr v6_prefix;	/* Rule IPv6 prefix */
	struct in_addr v4_prefix;	/* Rule IPv4 prefix */

	uint8_t v6_prefix_len;		/* Rule IPv6 prefix length */
	uint8_t v4_prefix_len;		/* Rule IPv4 prefix length */
	uint8_t eabits_len;		/* Rule EA-bits length */
	uint8_t psid_offset;		/* Rule Port Parameters(PSID offset) */
} map_e_rule_list;

/* セッション情報(カーネル用) */
typedef struct map_e_session {
	struct list_head list;

	/* network(IPv6) info */
	struct in6_addr dst6;	/* 宛先IPv6アドレス */
	struct in6_addr src6;	/* 送信元IPv6アドレス */

	/* network(IPv4) info */
	struct in_addr src4;	/* 変換前の送信元IPv4アドレス */
	struct in_addr c_src4;	/* 変換後の送信元IPv4アドレス */
	struct in_addr dst4;	/* 宛先IPv4アドレス */

	/* transport info */
	uint16_t sport;		/* 変換前の送信元ポート番号(または ICMP-ID) */
	uint16_t c_sport;	/* 変換後の送信元ポート番号 */
	uint16_t dport;		/* 宛先ポート番号 */
	uint8_t  protocol;	/* TCP/UDP/ICMP etc... */
	uint8_t  icmp_type;	/* ICMP type */

	/* TCP timer */
	uint32_t tcp_flag; /* TCPヘッダ内のフラグ */
#define F_TCP_FIN	(0x00000001)
#define F_TCP_SYN	(0x00000002)
#define F_TCP_RST	(0x00000004)
#define F_TCP_PSH	(0x00000008)
#define F_TCP_ACK	(0x00000010)
#define F_TCP_URQ	(0x00000020)

	/* FTP ALG */
	uint32_t correction_pos;	/* position of the last TCP sequence number modification (if any) */
	int16_t  offset_before;		/* sequence number offset before and after last modification */
	int16_t  offset_after;		/* sequence number offset before and after last modification */

	int32_t expire;	/* タイムアウト(秒) ※※ とりあえず、適当に大きい値にしておく！ ※※ */
} map_e_session_list;

/* 静的NAPT情報(カーネル用) */
typedef struct map_e_staticnapt {
	struct list_head list;

	struct in_addr lan_addr;	/* LANのIPv4アドレス */
	uint16_t lan_port;		/* LANのポート番号 */
	uint16_t lan_toport;	/* LANのポート番号(範囲指定) */
	uint16_t sam_port;		/* SAMのポート番号 */
	uint8_t protocol;		/* プロトコル */
} map_e_staticnapt_list;


/* Portset情報(カーネル用) */
typedef struct map_e_portset {
	struct list_head list;

	uint32_t id;		/* Port-setの識別子 */
	uint16_t port_min;	/* ポート番号の下限値 */
	uint16_t port_max;	/* ポート番号の上限値 */
} map_e_portset_list;

/* Portset情報(ユーザランド用) */
typedef struct map_e_portset_user {
	uint16_t port_min;	/* ポート番号の下限値 */
	uint16_t port_max;	/* ポート番号の上限値 */
} map_e_portset_array;

/* MAP-Eルール/ルールの解析結果 etc... */
struct map_e_info {
	/*
	 * MAP-E rule info
	 */
	struct in6_addr wan_addr;	/* MAP IPv6 address(WAN-IF address) */
	struct in_addr shared_addr4;	/* shared IPv4 address */
	struct in6_addr dmr_addr;	/* default mapping rule(BR address) */

	map_e_rule_list fmr_list;		/* forward mapping rule list */
	int fmr_num;			/* forward mapping rule count */
	struct map_e_rule *bmr;		/* basic mapping rule */

	/*
	 * portset info
	 */
	map_e_portset_list portset_list;	/* portset list */
	uint16_t portset_num;		/* portset count */
	uint16_t portset_id;		/* portset id */

	uint16_t current_portset_id;	/* ip_id(ip_id取得用) */
	uint16_t current_portset_index;	/* ip_id の Port-set index(ip_id取得用) */

#if 0
	uint16_t mode;                  /* CE/BR mode */
#endif

	/*
	 * session info
	 */
#define MAP_E_HASH_SIZE           (0xff)
#define MAP_E_HASH_MASK           (0xff)
	map_e_session_list ses_list[MAP_E_HASH_SIZE];
	uint16_t ses_num;
#if 0
	uint32_t timeout[MAP_TO_MAX];	/* (SPI的な)タイムアウトの設定 */
#endif

	/*
	 * static napt info
	 */
	map_e_staticnapt_list staticnapt_list;
	uint16_t staticnapt_num;

	uint16_t debug;
};


#ifdef __KERNEL__
static inline void debug_skb_printk(const char *fname, struct sk_buff *skb)
{
        char src[60], dst[60];
        char devname[20];
        struct iphdr *ip = NULL;
        struct ipv6hdr *ip6 = NULL;
#if 0
        struct sam_ipv6hdr *ip6 = NULL;
#endif

        if (skb == NULL)
                return;

        ip6 = (struct ipv6hdr *)skb_network_header(skb);
        if (ip6->version != 6) {
                ip = (struct iphdr *)skb_network_header(skb);
        }
        if (ip) {
                snprintf(src, sizeof(src), "%d.%d.%d.%d",
                    (ip->saddr & 0x000000FF) >>0,
                    (ip->saddr & 0x0000FF00) >>8,
                    (ip->saddr & 0x00FF0000) >>16,
                    (ip->saddr & 0xFF000000) >>24);
                snprintf(dst, sizeof(dst), "%d.%d.%d.%d",
                    (ip->daddr & 0x000000FF) >>0,
                    (ip->daddr & 0x0000FF00) >>8,
                    (ip->daddr & 0x00FF0000) >>16,
                    (ip->daddr & 0xFF000000) >>24);
        } else {
                snprintf(src, sizeof(src), "%04x:%04x:%04x:%04x:%04x:%04x:%04x:%04x",
                    ntohs(ip6->saddr.s6_addr16[0]),
                    ntohs(ip6->saddr.s6_addr16[1]),
                    ntohs(ip6->saddr.s6_addr16[2]),
                    ntohs(ip6->saddr.s6_addr16[3]),
                    ntohs(ip6->saddr.s6_addr16[4]),
                    ntohs(ip6->saddr.s6_addr16[5]),
                    ntohs(ip6->saddr.s6_addr16[6]),
                    ntohs(ip6->saddr.s6_addr16[7]));
  		 snprintf(dst, sizeof(dst), "%04x:%04x:%04x:%04x:%04x:%04x:%04x:%04x",
                    ntohs(ip6->daddr.s6_addr16[0]),
                    ntohs(ip6->daddr.s6_addr16[1]),
                    ntohs(ip6->daddr.s6_addr16[2]),
                    ntohs(ip6->daddr.s6_addr16[3]),
                    ntohs(ip6->daddr.s6_addr16[4]),
                    ntohs(ip6->daddr.s6_addr16[5]),
                    ntohs(ip6->daddr.s6_addr16[6]),
                    ntohs(ip6->daddr.s6_addr16[7]));
        }
        if (skb->dev) {
                unsigned char *p;
                p = (unsigned char *)skb->dev;
                memcpy(&devname[0], p, 16);
        } else {
                devname[0] = '\0';
        }
        MAP_TRACE(KERN_INFO "[%s] skb->dev->name : %s, src : %s, dst : %s\n",
            fname,
            &devname[0],
            &src[0], &dst[0]);
}
#endif	/* __KERNEL__ */

/*
 * MAP-Eデバイス専用のIOCTL定義
 */
#define SIOCGET_MAPE   (SIOCDEVPRIVATE + 0)
#define SIOCADD_MAPE   (SIOCDEVPRIVATE + 1)
#define SIOCDEL_MAPE   (SIOCDEVPRIVATE + 2)
#define SIOCGET_STATICNAPT   (SIOCDEVPRIVATE + 3)
#define SIOCADD_STATICNAPT   (SIOCDEVPRIVATE + 4)
#define SIOCDEL_STATICNAPT   (SIOCDEVPRIVATE + 5)
#define SIOCFLSH_STATICNAPT  (SIOCDEVPRIVATE + 6)
#define SIOCCHGPRL     (SIOCDEVPRIVATE + 7)
#define SIOCGET6RD     (SIOCDEVPRIVATE + 8)
#define SIOCADD6RD     (SIOCDEVPRIVATE + 9)
#define SIOCDEL6RD     (SIOCDEVPRIVATE + 10)
#define SIOCCHG6RD     (SIOCDEVPRIVATE + 11)

/* IOCTLのパラメータ */
struct map_e_parm {
	char name[IFNAMSIZ];    /* name of tunnel device */
	int link;               /* ifindex of underlying L2 interface */
	__u8 proto;             /* tunnel protocol */
	__u8 encap_limit;       /* encapsulation limit for tunnel */
	__u8 hop_limit;         /* hop limit for tunnel */
	__be32 flowinfo;        /* traffic class and flowlabel for tunnel */
	__u32 flags;            /* tunnel flags */
#define MAP_E_MAX_ENCAPLIMIT	(4)
#define MAP_E_MAX_HOPLIMIT	(64)

	struct in6_addr enduser_v6;	/* EndUser Prefix */
	struct in6_addr map_e_v6;		/* MAP-E IPv6 address <--> local tunnel end-point? */
	struct in_addr shared_v4;	/* SharedIPv4 address */
	struct in6_addr dmr_v6;		/* DMR IPv6 address(BR IPv6 address) <--> remote tunnel end-point? */

	uint16_t rule_max;		/* MAX number of MAP-E Rule */
	uint16_t session_max;		/* MAX number of MAP-E session */
#define MAP_E_MAX_RULE		(512)
#define MAP_E_MAX_SESSION	(4096)

	uint32_t tcp_expire;		/* TCP session timer */
	uint32_t udp_expire;		/* UDP session timer */
	uint16_t ps_id;			/* Portset ID */
	uint16_t ps_len;		/* Portset ID length */
	uint16_t rule_num;		/* number of MAP-E Rule */
	uint16_t ps_num;		/* number of Portset-list */
	uint8_t  enduser_v6_len;
	uint8_t  map_e_v6_len;
	uint8_t  bmr_index;		/* Basic Mapping Rule */
	uint8_t debug;			/* debug mode */
	uint32_t show_cmd;		/* show command id */
#define MAP_E_SHOW_RULE		(0x0001)
#define MAP_E_SHOW_PORTSET	(0x0002)
#define MAP_E_SHOW_SESSION	(0x0004)
#define MAP_E_SHOW_PARAM	(0x0008)
#define MAP_E_SHOW_STATUS	(0x0010)
#define MAP_E_SHOW_STATICNAPT	(0x0020)
#define MAP_E_SHOW_PORTSET2	(0x0040)
#define MAP_E_SHOW_USERLAND	(0x8000)
	struct map_e_rule rule[MAP_E_MAX_RULE];
	uint16_t portset_num;
	uint16_t pad16;
	map_e_portset_array *port_set; /* Don't insert member after this. */
};

/* IOCTLのパラメータ(静的NAPT専用) */
struct map_e_parm_staticnapt {
	char name[IFNAMSIZ];    /* name of tunnel device */
#define MAP_E_MAX_STATICNAPT		(512)
	struct map_e_staticnapt staticnapt[MAP_E_MAX_STATICNAPT];
	uint16_t staticnapt_num;
	struct in6_addr map_e_v6;
};

#ifdef __KERNEL__
/*
 * tunnel情報のリスト
 */
struct ip6_tnl_map_e {
	struct ip6_tnl_map_e *next;	/* next tunnel in list */
	struct net_device *dev;	/* virtual device associated with tunnel */
	struct map_e_parm parms;	/* tunnel configuration parameters */
	struct map_e_info *map_e_info;	/* MAP-E configuration values */
	struct flowi fl;	/* flowi template for xmit */
	struct dst_entry *dst_cache;	/* cached dst */
	u32 dst_cookie;
};

#ifdef CONFIG_RTL_MAP_E_FASTPATH_SUPPORT_DPI_ENGINE
extern struct ip6_tnl_map_e *map_e_dpi_t;
#endif

#endif /* __KERNEL__ */

#endif /* _MAP_E_H */
