#ifndef   _IPQ806X_BOARD_AKRO_PARAM_H_
#define   _IPQ806X_BOARD_AKRO_PARAM_H_

#ifdef CONFIG_GPIO_INIT

enum gpio_dir {
	GPIO_IN = 0,
	GPIO_OUT_H,
	GPIO_OUT_L,
};

/* GPIO_CFG Reg FUNC_SEL(bit5:2) */
#define FUNC_SEL_GPIO 0

/* GPIO_IN_OUT Reg GPIO_OUT(bit1) */
#define GPIO_OUT_BIT 1

#define gpio_cfg(g, f, o, p, dr, oen)	\
{			\
	.gpio   = g,	\
	.func   = f,	\
	.out    = o,	\
	.pull   = p,	\
	.drvstr = dr,	\
	.oe     = oen	\
}

/* Board Akro GPIO parameters */
gpio_func_data_t gpio_params[] = {
	/* L2SW INT */
	gpio_cfg(2, FUNC_SEL_GPIO, GPIO_IN, GPIO_NO_PULL, GPIO_8MA, GPIO_OE_DISABLE),
	/* CNV G */
	gpio_cfg(6, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA, GPIO_OE_ENABLE),
	/* POWER R */
	gpio_cfg(7, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA, GPIO_OE_ENABLE),
	/* ACTIVE G */
	gpio_cfg(8, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA, GPIO_OE_ENABLE),
	/* ACTIVE R */
	gpio_cfg(9, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA, GPIO_OE_ENABLE),
	/* POWER G */
	gpio_cfg(14, FUNC_SEL_GPIO, GPIO_OUT_H, GPIO_PULL_DOWN, GPIO_4MA, GPIO_OE_ENABLE),
	/* CNV R */
	gpio_cfg(15, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA, GPIO_OE_ENABLE),
	/* RAKURAKU SW */
	gpio_cfg(16, FUNC_SEL_GPIO, GPIO_IN, GPIO_PULL_UP, GPIO_2MA, GPIO_OE_DISABLE),
	/* ECO SW */
	gpio_cfg(17, FUNC_SEL_GPIO, GPIO_IN, GPIO_PULL_UP, GPIO_2MA, GPIO_OE_DISABLE),
	/* USB EN */
	gpio_cfg(22, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA, GPIO_OE_ENABLE),
	/* USB INT */
	gpio_cfg(23, FUNC_SEL_GPIO, GPIO_IN, GPIO_PULL_UP, GPIO_2MA, GPIO_OE_DISABLE),
	/* MODE 0 */
	gpio_cfg(24, FUNC_SEL_GPIO, GPIO_IN, GPIO_PULL_UP, GPIO_2MA, GPIO_OE_DISABLE),
	/* MODE 1 */
	gpio_cfg(25, FUNC_SEL_GPIO, GPIO_IN, GPIO_PULL_UP, GPIO_2MA, GPIO_OE_DISABLE),
	/* MODEL 2 */
	gpio_cfg(26, FUNC_SEL_GPIO, GPIO_IN, GPIO_PULL_DOWN, GPIO_2MA, GPIO_OE_DISABLE),
	/* 予備 */
	gpio_cfg(33, FUNC_SEL_GPIO, GPIO_IN, GPIO_PULL_DOWN, GPIO_2MA, GPIO_OE_DISABLE),
	/* HOSHU SW */
	gpio_cfg(53, FUNC_SEL_GPIO, GPIO_IN, GPIO_PULL_UP, GPIO_2MA, GPIO_OE_DISABLE),
	/* RESET SW */
	gpio_cfg(54, FUNC_SEL_GPIO, GPIO_IN, GPIO_PULL_UP, GPIO_2MA, GPIO_OE_DISABLE),
	/* 2.4G G */
	gpio_cfg(55, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA, GPIO_OE_ENABLE),
	/* 2.4G R */
	gpio_cfg(56, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA, GPIO_OE_ENABLE),
	/* 5G G */
	gpio_cfg(57, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA, GPIO_OE_ENABLE),
	/* 5G R */
	gpio_cfg(58, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA, GPIO_OE_ENABLE),
	/* L2SW RESET */
	gpio_cfg(63, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_NO_PULL, GPIO_2MA, GPIO_OE_ENABLE),
	/* TV G */
	gpio_cfg(64, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA, GPIO_OE_ENABLE),
	/* TV R */
	gpio_cfg(65, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_4MA, GPIO_OE_ENABLE),
	/* MODEL 0 */
	gpio_cfg(67, FUNC_SEL_GPIO, GPIO_IN, GPIO_PULL_DOWN, GPIO_2MA, GPIO_OE_DISABLE),
	/* MODEL 1 */
	gpio_cfg(68, FUNC_SEL_GPIO, GPIO_IN, GPIO_PULL_DOWN, GPIO_2MA, GPIO_OE_DISABLE),
};

#define NUM_GPIO ARRAY_SIZE(gpio_params)
#endif /* CONFIG_GPIO_INIT */
#endif /* _IPQ806X_BOARD_AKRO_PARAM_H_ */
