#ifndef   _IPQ806X_BOARD_PYTHON_PARAM_H_
#define   _IPQ806X_BOARD_PYTHON_PARAM_H_

#ifdef CONFIG_GPIO_INIT

enum gpio_dir {
	GPIO_IN = 0,
	GPIO_OUT_H,
	GPIO_OUT_L,
};

/* GPIO_CFG Reg FUNC_SEL(bit5:2) */
#define FUNC_SEL_GPIO 0

/* GPIO_IN_OUT Reg GPIO_OUT(bit1) */
#define GPIO_OUT_BIT 1

#define gpio_cfg(g, f, o, p, dr, oen)	\
{			\
	.gpio   = g,	\
	.func   = f,	\
	.out    = o,	\
	.pull   = p,	\
	.drvstr = dr,	\
	.oe     = oen	\
}

/* Board Python GPIO parameters */
gpio_func_data_t gpio_params[] = {
	/* GPIO2は未使用, RGMII系端子の設定(DRVSTR,PULL) */
	gpio_cfg(2, FUNC_SEL_GPIO, GPIO_IN, GPIO_NO_PULL, GPIO_8MA,
							GPIO_OE_DISABLE),
	/* POWER G */
	gpio_cfg(14, FUNC_SEL_GPIO, GPIO_OUT_H, GPIO_PULL_DOWN, GPIO_2MA,
							GPIO_OE_ENABLE),
	/* CNV R */
	gpio_cfg(15, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA,
							GPIO_OE_ENABLE),
	/* MODEL 0 */
	gpio_cfg(17, FUNC_SEL_GPIO, GPIO_IN, GPIO_PULL_DOWN, GPIO_2MA,
							GPIO_OE_DISABLE),
	/* RAKURAKU SW */
	gpio_cfg(22, FUNC_SEL_GPIO, GPIO_IN, GPIO_PULL_UP, GPIO_2MA,
							GPIO_OE_DISABLE),
	/* RESET SW */
	gpio_cfg(24, FUNC_SEL_GPIO, GPIO_IN, GPIO_PULL_UP, GPIO_2MA,
							GPIO_OE_DISABLE),
	/* L2SW INT */
	gpio_cfg(25, FUNC_SEL_GPIO, GPIO_IN, GPIO_NO_PULL, GPIO_8MA,
							GPIO_OE_DISABLE),
	/* MODEL 1 */
	gpio_cfg(26, FUNC_SEL_GPIO, GPIO_IN, GPIO_PULL_DOWN, GPIO_2MA,
							GPIO_OE_DISABLE),
	/* POWER R */
	gpio_cfg(35, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA,
							GPIO_OE_ENABLE),
	/* TV R */
	gpio_cfg(36, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA,
							GPIO_OE_ENABLE),
	/* ACTIVE R */
	gpio_cfg(38, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA,
							GPIO_OE_ENABLE),
	/* MODE 0 */
	gpio_cfg(40, FUNC_SEL_GPIO, GPIO_IN, GPIO_PULL_UP, GPIO_2MA,
							GPIO_OE_DISABLE),
	/* MODE 1 */
	gpio_cfg(41, FUNC_SEL_GPIO, GPIO_IN, GPIO_PULL_UP, GPIO_2MA,
							GPIO_OE_DISABLE),
	/* ACTIVE G */
	gpio_cfg(42, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA,
							GPIO_OE_ENABLE),
	/* CNV G */
	gpio_cfg(43, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA,
							GPIO_OE_ENABLE),
	/* L2SW RESET */
	gpio_cfg(45, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_NO_PULL, GPIO_2MA,
							GPIO_OE_ENABLE),
	/* TV G */
	gpio_cfg(46, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA,
							GPIO_OE_ENABLE),
	/* MODEL 2 */
	gpio_cfg(47, FUNC_SEL_GPIO, GPIO_IN, GPIO_PULL_DOWN, GPIO_2MA,
							GPIO_OE_DISABLE),
	/* 2.4G G */
	gpio_cfg(55, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA,
							GPIO_OE_ENABLE),
	/* 2.4G R */
	gpio_cfg(56, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA,
							GPIO_OE_ENABLE),
	/* 5G G */
	gpio_cfg(57, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA,
							GPIO_OE_ENABLE),
	/* 5G R */
	gpio_cfg(58, FUNC_SEL_GPIO, GPIO_OUT_L, GPIO_PULL_DOWN, GPIO_2MA,
							GPIO_OE_ENABLE),
};

#define NUM_GPIO ARRAY_SIZE(gpio_params)
#endif /* CONFIG_GPIO_INIT */
#endif /* _IPQ806X_BOARD_PYTHON_PARAM_H_ */
