/* CONFIG_CMD_CKCRC */

#include <common.h>
#include <command.h>
#include <configs/ipq806x_cdp.h>
#include <linux/crc32.h>

//#define DEBUG_EN
#if defined(DEBUG_EN)
#define DEBUGOUT(fmt, ...) do {		\
	printf(fmt, __VA_ARGS__);	\
	} while (0)
#else
#define DEBUGOUT(fmt, ...)
#endif	/* DEBUG_EN */

static int
do_ckcrc(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	char *faddr;
	const unsigned char *f_addr;
	char *fsize;
	size_t f_size;
	uint32_t fcrc32;
	uint32_t f_crc32;
	uint32_t calc_crc32;

	/* データの先頭アドレスを環境変数から取得 */
	if ((faddr = getenv("fileaddr")) != NULL) {
		f_addr = (const unsigned char *)simple_strtoul(faddr, NULL, 16);
		DEBUGOUT("fddr : %s\n", faddr);
		DEBUGOUT("file_addr : 0x%p\n", f_addr);
	} else {
		goto error;
	}

	/* データのサイズを環境変数から取得 */
	if ((fsize = getenv("filesize")) != NULL) {
		f_size = (int)simple_strtoul(fsize, NULL, 16);
		DEBUGOUT("fsize : %s\n", fsize);
		DEBUGOUT("file_size : 0x%x\n", f_size);
	} else {
		goto error;
	}

	/* データの crc32 値を取得 */
	fcrc32 = *(uint32_t *)(f_addr + f_size - sizeof(f_crc32));
	DEBUGOUT("fcrc32 : 0x%08x\n", fcrc32);
	if (fcrc32 == 0) {
		printf("CRC32 is not found.\n");
		return CMD_RET_FAILURE;
	}
	f_crc32 = ntohl(fcrc32);
	DEBUGOUT("file_crc32 : 0x%08x\n", f_crc32);

	/* データから crc32 を計算 */
	calc_crc32 = (uint32_t)crc32_wd(0, f_addr,
				f_size - sizeof(f_crc32), CHUNKSZ_CRC32);
	DEBUGOUT("calc_crc32 : 0x%08x\n", calc_crc32);

	/* crc32 比較 */
	printf("CRC32 CHECK ... %s\n", (f_crc32 == calc_crc32) ? "OK" : "NG");
	return (f_crc32 == calc_crc32) ? CMD_RET_SUCCESS : CMD_RET_FAILURE;

 error:
 	puts("[CAUTION]\n");
 	puts(" This command is check the CRC32 in RAM.\n");
	puts(" Please set the 'fileaddr' and 'filesize' in enviroment variable.\n");
	return CMD_RET_FAILURE;
}

U_BOOT_CMD(ckcrc, CONFIG_SYS_MAXARGS , 0, do_ckcrc,
	   "[NECPF] check the crc32 in RAM", "");
