#include <common.h>
#include <command.h>

#if defined(CONFIG_NECPF_HW_WATCHDOG)

#include <watchdog.h>

#define strtoul(n, e, b) simple_strtoul((n), (e), (b))

static int
do_debug_watchdog_enable(
	cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{

	hw_watchdog_enable();
	return CMD_RET_SUCCESS;
}

static int
do_debug_watchdog_disable(
	cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{

	hw_watchdog_disable();
	return CMD_RET_SUCCESS;
}

static int
do_debug_watchdog_settime(
	cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	uint32_t sec;

	if (argc < 2) {
		printf("settime SEC\n");
		printf("  SEC : watchdog time\n");
		return CMD_RET_FAILURE;
	}

	sec = strtoul(argv[1], NULL, 0);

	hw_watchdog_settime(sec);
	return CMD_RET_SUCCESS;
}

static int
do_debug_watchdog_reboot(
	cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{

	printf("watchdog wait...");
	for (;;)
		;

	return CMD_RET_FAILURE;	/* NOTREACHED */
}

static cmd_tbl_t cmd_debug_watchdog_sub[] = {
	U_BOOT_CMD_MKENT(enable, 0, 0, (void *)do_debug_watchdog_enable,
			 "", ""),
	U_BOOT_CMD_MKENT(disable, 0, 0, (void *)do_debug_watchdog_disable,
			 "", ""),
	U_BOOT_CMD_MKENT(reboot, 0, 0, (void *)do_debug_watchdog_reboot,
			 "", ""),
	U_BOOT_CMD_MKENT(settime, 1, 0, (void *)do_debug_watchdog_settime,
			 "", ""),
};

static int
do_debug_watchdog(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	cmd_tbl_t *c;

	if (argc < 2)
		return CMD_RET_USAGE;

	/* Strip off leading 'watchdog' command argument */
	argc--;
	argv++;

	c = find_cmd_tbl(argv[0], &cmd_debug_watchdog_sub[0],
			 ARRAY_SIZE(cmd_debug_watchdog_sub));

	if (c)
		return c->cmd(cmdtp, flag, argc, argv);
	else
		return CMD_RET_USAGE;
}

#endif	/* CONFIG_NECPF_HW_WATCHDOG */

#if defined(CONFIG_CMD_DEBUG_FLASH)
extern int do_debug_flash(cmd_tbl_t *, int, int, char * const []);
#endif	/* CONFIG_CMD_DEBUG_FLASH */
#if defined(CONFIG_CMD_DEBUG_L2SW)
extern int do_debug_l2sw(cmd_tbl_t *, int, int, char * const []);
#endif	/* CONFIG_CMD_DEBUG_L2SW */
#if defined(CONFIG_CMD_DEBUG_PPS)
extern int do_debug_pps(cmd_tbl_t *, int, int, char * const []);
#endif	/* CONFIG_CMD_DEBUG_PPS */

static cmd_tbl_t cmd_debug_sub[] = {
#if defined(CONFIG_NECPF_HW_WATCHDOG)
	U_BOOT_CMD_MKENT(watchdog, 1, 0, (void *)do_debug_watchdog, "", ""),
#endif	/* CONFIG_NECPF_HW_WATCHDOG */
#if defined(CONFIG_CMD_DEBUG_FLASH)
	U_BOOT_CMD_MKENT(flash, 1, 0, (void *)do_debug_flash, "", ""),
#endif	/* CONFIG_CMD_DEBUG_FLASH */
#if defined(CONFIG_CMD_DEBUG_L2SW)
	U_BOOT_CMD_MKENT(l2sw, 1, 0, (void *)do_debug_l2sw, "", ""),
#endif	/* CONFIG_CMD_DEBUG_L2SW */
#if defined(CONFIG_CMD_DEBUG_PPS)
	U_BOOT_CMD_MKENT(pps, 1, 0, (void *)do_debug_pps, "", ""),
#endif	/* CONFIG_CMD_DEBUG_PPS */
};

static int
do_debug(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	cmd_tbl_t *c;

	if (argc < 2)
		return CMD_RET_USAGE;

	/* Strip off leading 'debug' command argument */
	argc--;
	argv++;

	c = find_cmd_tbl(
		argv[0], &cmd_debug_sub[0], ARRAY_SIZE(cmd_debug_sub));

	if (c)
		return c->cmd(cmdtp, flag, argc, argv);
	else
		return CMD_RET_USAGE;
}

U_BOOT_CMD(debug, CONFIG_SYS_MAXARGS , 0, do_debug, "[NECPF] debug command",
	   "- [NECPF] debug command\n"
#if defined(CONFIG_NECPF_HW_WATCHDOG)
	   "debug watchdog enable  - Enable watchdog timer.\n"
	   "debug watchdog disable - Disable watchdog timer.\n"
	   "debug watchdog reboot  - Wait for a watchdog timer to expire.\n"
	   "debug watchdog settime - Set a watchdog time. [sec]\n"
#endif	/* CONFIG_NECPF_HW_WATCHDOG */
#if defined(CONFIG_CMD_DEBUG_FLASH)
	   "debug flash read  - flash read.\n"
	   "debug flash write - flash write.\n"
	   "debug flash erase - flash erase.\n"
	   "debug flash info  - flash information.\n"
	   "debug flash diag  - self diagnostic for flash device.\n"
#endif	/* CONFIG_CMD_DEBUG_FLASH */
#if defined(CONFIG_CMD_DEBUG_L2SW)
	   "debug l2sw read  - l2sw register read.\n"
	   "debug l2sw write - l2sw register write.\n"
	   "debug l2sw dump  - l2sw register dump.\n"
#endif	/* CONFIG_CMD_DEBUG_L2SW */
	);
