#include <common.h>
#include <command.h>
#include "cmd_debug_l2sw.h"

static int cmd_read_l2sw_reg(cmd_tbl_t *, int, int, char * const []);
static int cmd_write_l2sw_reg(cmd_tbl_t *, int, int, char * const []);
static int cmd_dump_l2sw_reg(cmd_tbl_t *, int, int, char * const []);
int do_debug_l2sw(cmd_tbl_t *, int, int, char * const []);

static cmd_tbl_t cmd_debug_l2sw_sub[] = {
	U_BOOT_CMD_MKENT(read, 0, 0, (void *)cmd_read_l2sw_reg,
			 "", ""),
	U_BOOT_CMD_MKENT(write, 0, 0, (void *)cmd_write_l2sw_reg,
			 "", ""),
	U_BOOT_CMD_MKENT(dump, 0, 0, (void *)cmd_dump_l2sw_reg,
			 "", ""),
};

static const l2swreg_access_t *debug_l2swreg = NULL;

int
regist_debug_l2sw_info(const l2swreg_access_t *l2swreg)
{
	if (debug_l2swreg == NULL) {
		debug_l2swreg = l2swreg;
	}

	return 0;
}

static int
cmd_read_l2sw_reg(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	if (debug_l2swreg == NULL || debug_l2swreg->read == NULL) {
		printf("Error\n");
		return 1;
	}

	debug_l2swreg->read(argc, argv);
	return 0;
}

static int
cmd_write_l2sw_reg(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	if (debug_l2swreg == NULL || debug_l2swreg->write == NULL) {
		printf("Error\n");
		return 1;
	}

	debug_l2swreg->write(argc, argv);
	return 0;
}

static int
cmd_dump_l2sw_reg(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	if (debug_l2swreg == NULL || debug_l2swreg->dump == NULL) {
		printf("Error\n");
		return 1;
	}

	debug_l2swreg->dump(argc, argv);
	return 0;
}

int
do_debug_l2sw(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	cmd_tbl_t *c;

	if (argc < 2)
		return CMD_RET_USAGE;

	argc--;
	argv++;

	c = find_cmd_tbl(argv[0], &cmd_debug_l2sw_sub[0],
			 ARRAY_SIZE(cmd_debug_l2sw_sub));

	if (c)
		return c->cmd(cmdtp, flag, argc, argv);
	else
		return CMD_RET_USAGE;
}
