/* CONFIG_CMD_PKG_INFO */

#include <common.h>
#include <command.h>
#include <configs/ipq806x_cdp.h>
#include <asm/arch-ipq806x/gpio.h>
#include <linux/flashmng.h>

DECLARE_GLOBAL_DATA_PTR;

static int
do_pkg_info(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{

	printf("  PKG NAME : %s\n", md_get_pkg_name(md_get_pkg_type()));
	printf("  CPU : ARMv7 Processor [%08x] revision %x\n",
	       md_read_cpuid(), md_read_cpuid() & 0xf);
	printf("  RAM : ");
	print_size(gd->ram_size, "\n");
	printf("  Flash : ");
	print_size(flsize(), "\n");
	printf("    Device         : %s\n", fldev_name(NULL));
	printf("    Sector size    : ");
	print_size(flbank_size(NULL), "\n");
	printf("  DIPSW : 0x%x\n", md_get_dipsw());

	return 0;
}

U_BOOT_CMD(pkg_info, CONFIG_SYS_MAXARGS , 0, do_pkg_info,
	   "[NECPF] show package information", "");
