/* CONFIG_CMD_RF_REGDMN */

#include <common.h>
#include <command.h>
#include <linux/flashmng.h>

static void
rf_regdmn_read(uint16_t *regdmn, uint32_t addr, uint32_t offset)
{
	flread(regdmn, (const uint8_t *)addr + offset, sizeof(*regdmn));

	/* 国別コードの flash 上での格納形式 (Little/Big Endian) により、
	 * swap が必要 */
	*regdmn = rf_swap16(*regdmn);
}

static int
cmd_rf_regdmn_read(int flag, int argc, char * const argv[])
{

	uint16_t regdmn;

	rf_regdmn_read(&regdmn,
		       CALIBRATION_FLASH_ADDR, CALIBRATION_REGDMN_OFFSET);
	printf("0x%04x", regdmn);

#if defined(USE_WLAN_2ND)
	printf(" ");
	rf_regdmn_read(&regdmn,
		       CALIBRATION_FLASH_ADDR_2ND, CALIBRATION_REGDMN_OFFSET_2ND);
	printf("0x%04x", regdmn);
#endif /* USE_WLAN_2ND */

	printf("\n");
	return 0;
}

static int
do_rf_regdmn(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{

	const char *cmd;
	int ret = 0;

	cmd = argv[1];
	--argc;
	++argv;

	if (strncmp(cmd, "read", 1) == 0) {
		ret = cmd_rf_regdmn_read(flag, argc, argv);
	} else {
		return CMD_RET_USAGE;
	}

	return ret;
}

U_BOOT_CMD(
	rf_regdmn, CONFIG_SYS_MAXARGS, 0,      do_rf_regdmn,
	"[NECPF] rf_regdmn read command",
	"read\n"
	"    - rf_regdmn read\n"
	);
