#include <common.h>
#include <command.h>
#include <linux/compiler.h>
#include <linux/macutil.h>
#include <linux/flashmng.h>

static const char *
get_macaddrstr(char *s, int n, const macaddr_t *mac)
{
	snprintf(s, n,
		 "%02x:%02x:%02x:%02x:%02x:%02x",
		 mac->mac_address[0], mac->mac_address[1],
		 mac->mac_address[2], mac->mac_address[3],
		 mac->mac_address[4], mac->mac_address[5]);
	return s;
}

static int
cmd_rf_macaddr_read(int flag, int argc, char * const argv[])
{
	macaddr_t mac;
	char s[sizeof(mac) * (2 + 1)];
	int ret = 0;

	if (flread(&mac, (const void *)(uint32_t)(CALIBRATION_FLASH_ADDR +
						  CALIBRATION_MAC_OFFSET),
		   sizeof(mac)) != sizeof(mac)) {
		printf("%s", "error read 1st fail");
		ret = 1;
	}
	else {
		printf("%s", get_macaddrstr(s, sizeof(s), &mac));
	}
#if defined(USE_WLAN_2ND)
	printf(" ");
	if (flread(&mac, (const void *)(uint32_t)(CALIBRATION_FLASH_ADDR_2ND +
						  CALIBRATION_MAC_OFFSET_2ND),
		   sizeof(mac)) != sizeof(mac)) {
		printf("%s", "error read 2nd fail");
		ret = 1;
	}
	else {
		printf("%s", get_macaddrstr(s, sizeof(s), &mac));
	}
#endif /* USE_WLAN_2ND */
	printf("\n");
	return ret;
}

static int
do_rf_serial(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	const char *cmd;
	int ret = 0;

	cmd = argv[1];
	--argc;
	++argv;

	if (strncmp(cmd, "read", 1) == 0) {
		ret = cmd_rf_macaddr_read(flag, argc, argv);
	} else {
		return CMD_RET_USAGE;
	}

	return ret;
}

U_BOOT_CMD(
	rf_serial, CONFIG_SYS_MAXARGS, 0,      do_rf_serial,
	"[NECPF] rf_serial read command",
	"read\n"
	"    - rf_serial read\n"
	);
