/* CONFIG_CMD_SHOW_VERSION */

#include <common.h>
#include <command.h>
#include <configs/ipq806x_cdp.h>
#include <image.h>
#include <linux/ctype.h>
#include <linux/flashmng.h>
#include <img_write.h>

#define LOAD_RAM_ADDR	CONFIG_SYS_LOAD_ADDR
#define FLPART_OFFSET	(uint32_t)(CONFIG_KERNEL_OFFSET)
#define FLPART_SIZE	(uint32_t)(CONFIG_KERNEL_SIZE)

#define IMAGE_HEAD_SIZE	0x40	/* 64byte */

#define ADDRESS_ALIGN(a, l) (((((uint32_t)(a)) + ((l) - 1)) / (l)) * (l))
#define ALIGN_SIZE	0x800	/* 2048byte */

//#define DEBUG_EN
#if defined(DEBUG_EN)
#define DEBUGOUT(fmt, ...) do {		\
	printf(fmt, __VA_ARGS__);	\
	} while (0)
#else
#define DEBUGOUT(fmt, ...)
#endif	/* DEBUG_EN */

static int sys_version_len = 0;
static char sys_version_str[IMAGE_HEAD_SIZE + 1];

static int
do_boot_version(void)
{
#ifdef BOOT_VERSION_N
	puts("Boot Version = "BOOT_VERSION_N "\n");
#endif	/* BOOT_VERSION_N */
	return 0;
}

static int
do_tp_version(void)
{
#ifdef CONFIG_TP_LOAD_CMD
	char cmd[16];

	snprintf(cmd, sizeof(cmd), "tp ver");
	run_command(cmd, 0);
#endif	/* CONFIG_TP_LOAD_CMD */
	return 0;
}

/*
 *           4byte           4byte                 8byte
 *      +--------------+--------------+-----------------------------+
 * 0x00 | magic number |    length    |          reserved           |
 *      +--------------+--------------+-----------------------------+
 * 0x10 |                     data (length byte)                    |
 *      +-----------------------------------------------------------+
 * 0x20 |                            ...                            |
 *      +-----------------------------------------------------------+
 */
static int
do_sys_version(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	void *hdr = (void *)LOAD_RAM_ADDR;
	uint32_t *addr;
	uint32_t size;
	uint32_t magic;
	uint32_t len;

	sys_version_len = 0;

	flread(hdr, (const void *)FLPART_OFFSET, FLPART_SIZE);

	size = image_get_data_size(hdr);
	if (size > FLPART_SIZE) {
		printf("Invalid Image Size !\n");
		goto error;
	}
	printf("System (Kernel) Size : %d Bytes (0x%08x)\n", size, size);
	size += IMAGE_HEAD_SIZE;

	addr = (uint32_t *)ADDRESS_ALIGN(LOAD_RAM_ADDR + size, ALIGN_SIZE);
	DEBUGOUT("Version Strings Addr : 0x%p\n", addr);

	magic = ntohl(*addr);
	len = ntohl(*(addr + 1));
	DEBUGOUT("magic number = 0x%08x\n", magic);
	DEBUGOUT("length       = 0x%08x\n", len);

	if (magic != CONFIG_VER_MAGIC) {
		printf("Invalid Magic Number !\n");
		goto error;
	}
	if (len == 0) {
		printf("Invalid Length !\n");
		goto error;
	}
	printf("%.*s\n", len, (char *)(addr + 4));

	sys_version_len = len;
	snprintf(sys_version_str, sizeof(sys_version_str), "%.*s\n", len,
							(char *)(addr + 4));
	return 0;

 error:
	printf("System Version not found.\n");
	return 1;
}

const char *
get_sys_version(void)
{
	return (sys_version_len > 0) ? sys_version_str : NULL;
}

static int
do_show_version(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
	do_tp_version();
#if defined(CONFIG_CMD_IMG_WRITE)
	if ((argc >= 2) && (strcmp(argv[1], "iwled") == 0))
		md_img_write_led(LED_IW_VERSION);
#endif	/* CONFIG_CMD_IMG_WRITE */
	do_boot_version();
	do_sys_version(cmdtp, flag, argc, argv);

	return 0;
}

U_BOOT_CMD(show_version, CONFIG_SYS_MAXARGS , 0, do_show_version,
	   "[NECPF] show boot/tp/system version", "");
