/* Copyright(c) NEC Platforms, Ltd. 2001-2016 */
/*
 * $Id: videomgr.h,v 1.1.44.3 2010/10/29 12:10:46 haishi Exp $
 */

#ifndef _VIDEOMGR_H_
#define _VIDEOMGR_H_

#include "avilib.h"

#define VMGR_LOCATION videomgr_location(__FILE__, __LINE__)
#define VMGR_LOG videomgr_syslog
#define VMGR_LOG_SYSERR(msg) \
VMGR_LOG(LOG_ERR, VMGR_LOCATION, "%s:%s\n", msg, strerror(errno))

#if 0
#define VMGR_OK		0
#define VMGR_NG		-1
#define VMGR_FATAL	-2
#endif

#define VMGR_SOCK_PATH  "/tmp/videomgr.sock"
#define VMGR_PID        "/tmp/videomgr.pid"

#define VMGR_DAYOFWEEK_NONE		0
#define VMGR_DAYOFWEEK_EVERYDAY		1
#define VMGR_DAYOFWEEK_SUN		2
#define VMGR_DAYOFWEEK_MON		3
#define VMGR_DAYOFWEEK_TUE		4
#define VMGR_DAYOFWEEK_WED		5
#define VMGR_DAYOFWEEK_THU		6
#define VMGR_DAYOFWEEK_FRI		7
#define VMGR_DAYOFWEEK_SAT		8

#define VMGR_DISABLE			0
#define VMGR_ENABLE			1

#define VMGR_LOG_DISABLE		0
#define VMGR_LOG_ENABLE			1

#define VMGR_TIMER_DISABLE		0
#define VMGR_TIMER_ENABLE		1

#if 0
#define VMGR_CAP_OFF			0
#define VMGR_CAP_1SHOT			1
#define VMGR_CAP_CONTINUOUS		2
#endif

#define VMGR_DEF_AVI_SIZE_MAX		(512)
#define VMGR_MEGA_BYTE			(1024*1024)

#define VMGR_RETRY_OPEN_TIMER		1	/* 1sec */
#define VMGR_BEFORE_TIMER_WAKEUP	3	/* 3sec */
#define VMGR_YUV_CAPTURE_TIME		1000000	/* 1sec */
#if 0
#define VMGR_JPG_CAPTURE_TIME1		125000	/* 125msec */
#define VMGR_JPG_CAPTURE_TIME2		72000	/* 72msec */

#else
/* BUG19684 対応により画像サイズによらず更新間隔を一定にする */
#define VMGR_JPG_CAPTURE_TIME1		250000	/* 250msec */
#define VMGR_JPG_CAPTURE_TIME2		250000	/* 250msec */
#endif
#define VMGR_FREE_IDLE_TIMER		1	/* 1sec */

#define VMGR_TIMER_DISABLE		0
#define VMGR_TIMER_ENABLE		1

#define VMGR_SAVE_FTYPE_AVI		1
#define VMGR_SAVE_FTYPE_JPG		2

#define VMGR_SAVE_MODE_STOP		1
#define VMGR_SAVE_MODE_CYCLIC		2

#define VMGR_SAVE_MEDIA_PRIVATE		1
#define VMGR_SAVE_MEDIA_PUBLIC		2

#define VMGR_SAVE_TIMER_ENTRY		20

#define USBD_ERROR_MAX			(19)

/* struct v4l2_capability cards[]/bus_info[]のサイズ */
#define VMGR_CAP_CNSIZE			(32)

/* default setting */
#define	VMGR_DEF_LOG_ENABLE	VMGR_LOG_ENABLE
#define	VMGR_DEF_LOG_LEVEL	LOG_ERR
#define	VMGR_DEF_FORMAT		V4L2_PIX_FMT_MJPEG
#define	VMGR_DEF_WIDTH		640
#define	VMGR_DEF_HEIGHT		480
#define	VMGR_DEF_YUV_WIDTH	352
#define	VMGR_DEF_YUV_HEIGHT	288
#define	VMGR_DEF_FPS_NUM	1		/* numerator 分子 */
#define	VMGR_DEF_FPS_DEN	30		/* denominator 分母 */
#define	VMGR_DEF_SAVE_FTYPE	VMGR_SAVE_FTYPE_JPG
#define	VMGR_DEF_SAVE_MODE	VMGR_SAVE_MODE_STOP
#define	VMGR_DEF_SAVE_CYCLE	60
#define	VMGR_DEF_SAVE_MEDIA	VMGR_SAVE_MEDIA_PRIVATE
#define	VMGR_DEF_VBUF_INDEX	0xffffffff
#define	VMGR_DEF_VBUF_COUNT	4

#define VMGR_PATH_LEN		256
#define STILL_FNAME_TMP		"/tmp/usr/local/www/usbcam_tmp"
#define STILL_FNAME		"/tmp/usr/local/www/usbcam"

#define VMGR_SAVE_MEDIA		"/tmp/usr/local/www/media/usbdisk1"
#define VMGR_SAVE_FOLDER	"/tmp/usr/local/www/media/usbdisk1/contents"
#define VMGR_SAVE_FOLDER_OPN	"/tmp/usr/local/www/media/usbdisk1/contents/usbcamera"
#define VMGR_SAVE_FOLDER_CLS	"/tmp/usr/local/www/media/usbdisk1/usbcamera"

#define VMGR_DEF_DEVNAME	"/dev/video0"

/* streaming state	*/
#define	VMGR_STREAM_OFF		0x00
#define	VMGR_STREAM_ON		0x01
#define	VMGR_STREAM_SAVE	0x02
#define	VMGR_STREAM_TIMER	0x04
#define	VMGR_STREAM_NUM		3

/* mode operation macro */
#define current_state()         (vd_in->stream_state)
#define new_state()             (vd_in->stream_state_new)
#define is_current_state(state) (vd_in->stream_state & (state))
#define is_new_state(state)     (vd_in->stream_state_new & (state))
#define set_state(state)        (vd_in->stream_state_new |= (state))
#define clear_state(state)      (vd_in->stream_state_new &= ~(state))
#define get_current_mode()      (is_current_state(VMGR_STREAM_TIMER) == \
                                                        VMGR_STREAM_TIMER)
#define get_new_mode()          (is_new_state(VMGR_STREAM_TIMER) == \
                                                        VMGR_STREAM_TIMER)

/* CLI command kind */
enum vmgr_cmd_kind {
	VMGR_CMD_ENABLE = 1,
	VMGR_CMD_DISABLE,
	VMGR_CMD_STREAMING_START,
	VMGR_CMD_STREAMING_STOP,
	VMGR_CMD_PARAM_SET_P_FMT,
	VMGR_CMD_PARAM_SET_P_SIZE,
	VMGR_CMD_PARAM_SET_P_FPS,
	VMGR_CMD_PARAM_SET_S_FMT,
	VMGR_CMD_PARAM_SET_S_SIZE,
	VMGR_CMD_PARAM_SET_S_FPS,
	VMGR_CMD_PARAM_SET_DEVICE,
	VMGR_CMD_PARAM_SET_DEFAULT,
	VMGR_CMD_LOG_ENABLE,
	VMGR_CMD_LOG_LEVEL,
	VMGR_CMD_SHOW_VIDEOMGR,
	VMGR_CMD_SHOW_USB_DEVINFO,
	VMGR_CMD_SHOW_CAMINFO,
	VMGR_CMD_CONTROL_GET,
	VMGR_CMD_CONTROL_RESET,
	VMGR_CMD_CONTROL_DIRECT,
#if 0
	VMGR_CMD_CAPTURE_REQ,
	VMGR_CMD_CAP_START,
	VMGR_CMD_CAP_STOP,
#endif
	VMGR_CMD_SAVE_START,
	VMGR_CMD_SAVE_STOP,
	VMGR_CMD_PARAM_SET_P_CYCLE,
	VMGR_CMD_PARAM_SET_S_CYCLE,
	VMGR_CMD_PARAM_SET_P_MODE,
	VMGR_CMD_PARAM_SET_S_MODE,
	VMGR_CMD_PARAM_SET_TIMER,
	VMGR_CMD_PARAM_DELETE_TIMER,
	VMGR_CMD_PARAM_SET_P_FTYPE,
	VMGR_CMD_PARAM_SET_S_FTYPE,
	VMGR_CMD_PARAM_SET_MEDIA,
	VMGR_CMD_PARAM_SET_AVIMAX,
	VMGR_CMD_RESPONSE,
	VMGR_CMD_BROWSER_TIMER,
	VMGR_CMD_BROWSER_ACCESSED,
	VMGR_CMD_DISCONNECT_PORT,
	VMGR_CMD_BUFFER_COUNT,
	VMGR_CMD_STREAMING_STATUS,
	VMGR_CMD_CAMINFO_SETTABLE_COUNT,
	VMGR_CMD_CAMINFO_SETTABLE,
	VMGR_CMD_CAMINFO_CURRENT_SETTING
};

enum vmgr_cmd_ctrl {
	VMGR_CMD_SUB_BRIGHTNESS = 1,
	VMGR_CMD_SUB_CONTRAST,
	VMGR_CMD_SUB_SATURATION,
	VMGR_CMD_SUB_HUE,
	VMGR_CMD_SUB_BLUE,
	VMGR_CMD_SUB_RED,
	VMGR_CMD_SUB_WHITE,
	VMGR_CMD_SUB_GAMMA,
	VMGR_CMD_SUB_GAIN,
	VMGR_CMD_SUB_BACKLIGHT,
	VMGR_CMD_SUB_POWER_LINE,
	VMGR_CMD_SUB_SHARPNESS,
	VMGR_CMD_SUB_SCANNING,
	VMGR_CMD_SUB_FOCUS,
	VMGR_CMD_SUB_FOCUS_RELATIVE,
	VMGR_CMD_SUB_IRIS,
	VMGR_CMD_SUB_IRIS_RELATIVE,
	VMGR_CMD_SUB_ZOOM,
	VMGR_CMD_SUB_ZOOM_RELATIVE,
	VMGR_CMD_SUB_DIGITAL,
	VMGR_CMD_SUB_DIGITAL_LIMIT,
	VMGR_CMD_SUB_PAN,
	VMGR_CMD_SUB_PAN_RELATIVE,
	VMGR_CMD_SUB_TILT,
	VMGR_CMD_SUB_TILT_RELATIVE,
	VMGR_CMD_SUB_ROLL,
	VMGR_CMD_SUB_ROLL_RELATIVE,
	VMGR_CMD_SUB_PRIVACY,
	VMGR_CMD_SUB_EXPOSURE,
	VMGR_CMD_SUB_EXPOSURE_RELATIVE,
	VMGR_CMD_SUB_NUM = VMGR_CMD_SUB_EXPOSURE_RELATIVE
};

struct vmgr_cnf_info {
	unsigned int width;
	unsigned int height;
	int fps[2];
	int cycle;
	int mode;
	int ftype;
};

struct vmgr_set_info {
	unsigned int format;
	unsigned int width;
	unsigned int height;
	int fps[2];
	int cycle;
	int mode;
	int ftype;
};

struct vmgr_set_timer_info {
	int dayofweek;
	struct tm start;
	struct tm end;
};

struct vmgr_set_control {
	int valid;
	long value;
};

struct vmgr_control {
	long max;
	long min;
	long default_value;
	long step;
	long current;
	unsigned long flags;
};

struct vmgr_buffer {
	char *mem;
	unsigned int len;
};

typedef struct video_in {
	int fd;
	char *video_devname;
	struct v4l2_capability cap;
	struct v4l2_format fmt;
	struct vmgr_buffer *vbuf;
	unsigned int vbuf_count;
	unsigned int vbuf_index;
	int stream_state;
	int stream_state_new;
	int timer_enable;
	unsigned int newlen;
	struct vmgr_set_info info[2];
	int get_pict;
#if 0
	int is_recv_conf;
#endif
	int media;
	char filename[2][VMGR_PATH_LEN];
	avi_t *avifile[2];
	int framecount[2];
	int recordstart[2];
	int recordtime[2];
	unsigned long avisize[2];
	unsigned long avisizemax;
	struct vmgr_set_timer_info timer[VMGR_SAVE_TIMER_ENTRY];
	int timer_wakeup;
	struct vmgr_set_control control[VMGR_CMD_SUB_NUM];
	unsigned long yuv_cap;
	unsigned long jpg_cap[2];
	int first_pic;
	unsigned int browser_timer;
	unsigned char *jpg_buf;
} video_in_t;

struct vmgr_cmd_hdr {
        int kind;
	int portno;
        int len;
	int sub;
};

struct vmgr_config {
	char devname[32];
	struct vmgr_set_info info;
	int log_enable;
	int log_level;
	int media;
	unsigned long avi_max;
	struct vmgr_set_timer_info timer;
	long ctrl;
	unsigned int browser_timer;
	unsigned int buffer_count;
};

struct vmgr_cmd {
	struct vmgr_cmd_hdr hdr;
        struct vmgr_config conf;
};

extern video_in_t	*vd_in;
extern int		is_changed;
extern struct vmgr_cnf_info	cnf_info[];
extern struct vmgr_set_info	tmp_info[];
extern int		videomgr_log_level;
extern int		videomgr_log_enable;
extern unsigned int 	videomgr_vbuf_count;

void videomgr_syslog(int, const char *, const char *, ...);
const char * videomgr_location(const char *, int);

#endif /* _VIDEOMGR_H_ */
