/*	$KAME: prefixconf.h,v 1.6 2005/03/02 07:20:14 suz Exp $	*/

/*
 * Copyright (C) 2002 WIDE Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE PROJECT AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE PROJECT OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

typedef enum { PREFIX6S_ACTIVE, PREFIX6S_RENEW,
	       PREFIX6S_REBIND} prefix6state_t;

/*
 * PREFIX_TIMER_SET_LATER: later set up or update the associated timer (IA-PD/IA-NA received)
 * PREFIX_TIMER_SET_NOW  : update_prefix() set up or update the associated timer
 */
enum {PREFIX_TIMER_SET_LATER, PREFIX_TIMER_SET_NOW};

#ifdef RTK_AP_IPV6
#define DHCP6PD_CONF_FILE	"/var/dhcp6pd.conf"
#endif	/* RTK_AP_IPV6 */
#define PD_LAN_ADDRESS_FILE	"/tmp/new_ipv6_lan_address"
#ifdef USE_NWCTL
#define LAN_3_UP_FILE		"/var/run/LAN-3.UP"
#endif	/* USE_NWCTL */

TAILQ_HEAD(siteprefix_list, siteprefix);
struct iactl_pd {
	struct iactl common;
	struct pifc_list *pifc_head;
	struct siteprefix_list siteprefix_head;
};

#define iacpd_ia common.iactl_ia
#define iacpd_callback common.callback
#define iacpd_isvalid common.isvalid
#define iacpd_duration common.duration
#define iacpd_renew_data common.renew_data
#define iacpd_rebind_data common.rebind_data
#define iacpd_reestablish_data common.reestablish_data
#define iacpd_release_data common.release_data
#define iacpd_cleanup common.cleanup

struct siteprefix {
	TAILQ_ENTRY (siteprefix) link;

	struct dhcp6_prefix prefix;
	time_t updatetime;
	struct dhcp6_timer *timer;
	struct iactl_pd *ctl;
	TAILQ_HEAD(, dhcp6_ifprefix) ifprefix_list; /* interface prefixes */
};

struct dhcp6_ifprefix {
	TAILQ_ENTRY(dhcp6_ifprefix) plink;

	/* interface configuration */
	struct prefix_ifconf *ifconf;

	/* interface prefix parameters */
	struct sockaddr_in6 paddr;
	int plen;

	/* address assigned on the interface based on the prefix */
	struct sockaddr_in6 ifaddr;
};

extern int update_prefix __P((struct ia *, struct dhcp6_prefix *,
    struct pifc_list *, struct dhcp6_if *, struct iactl **,
    void (*)__P((struct ia *)), struct siteprefix **, int));
extern void call_remove_siteprefix __P((struct siteprefix *));
extern int prefix6_add __P((struct dhcp6_if *, struct dhcp6_prefix *,
			       struct duid *));
extern int prefix6_update __P((struct dhcp6_event *, struct dhcp6_list *,
				  struct duid *));
