

#define _GNU_SOURCE 1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <signal.h>
#include <getopt.h>
#include <unistd.h>
#include <syslog.h>
#include <stdarg.h>
#include <setjmp.h>

#include "pppoe.h"
#include "kpppoe.h"

#include "ctl_comm.h"

//#include "version.h"
#define	VERSION	"0.0.1"
#include "eloop.h" //paul add, v2
#include <syslog.h>//paul
#include <asyslog.h>//paul
extern char	gm_linkname[NAME_MAX];
extern int	gm_got_sigterm;

/******************************************************************************/
/******************************************************************************/
static int	zm_debug;


void  DBGOUT_0( char*  sss, ... )
{
	va_list	ap;

	va_start( ap, sss );

	vsyslog( LOG_NDELAY | LOG_PID | LOG_USER, sss, ap );

	va_end( ap );

  l_exit:;
}


void  DBGOUT( char*  sss, ... )
{
	va_list	ap;

	if( zm_debug <= 0 ){
		goto l_exit;
	}

	va_start( ap, sss );

	vsyslog( LOG_NDELAY | LOG_PID | LOG_USER, sss, ap );

	va_end( ap );

  l_exit:;
}


/******************************************************************************/
/******************************************************************************/
static comm_msg_t*	zm_ptxbuf;


#define	TMOUT_MSEC_RESP_TX	(1000)



/*
 */
static int  ctl_app_init( void )
{
	int	res = 0;

	if( (zm_ptxbuf = malloc( sizeof(*zm_ptxbuf) )) == NULL ){
		res = errno;
	}

	return res;
}

/*
 */
static int  ctl_rx_dispatch( int  conn_sock, comm_msg_t*  p_msg )
{
	int		restmp;
	int		fd = CTL_COMM_NO_FD;
	comm_msg_t*	txbuf = zm_ptxbuf;
	int		res = 0;

	txbuf->cmd = p_msg->cmd;

	DBGOUT("%s: cmd = %d\n", __FUNCTION__, p_msg->cmd );

	switch( p_msg->cmd ){

	case COMM_CMD_IPC_PING:
		txbuf->u.ping.val = p_msg->u.ping.val;
		restmp = ctl_comm_send_msg( conn_sock, fd, txbuf, TMOUT_MSEC_RESP_TX );
		break;

	case COMM_CMD_CONNECT:
		memset( gm_linkname, 0, sizeof(gm_linkname) );
		strncpy( gm_linkname, p_msg->u.conn.linkname, sizeof(gm_linkname) - 1 );
		gm_sts_session_id = p_msg->u.conn.sts_session_id;
		gm_sts_mtu = p_msg->u.conn.sts_mtu;
		gm_got_sigterm = p_msg->u.conn.got_sigterm;
		fd = PPPOEConnectDevice();
		DBGOUT("%s: conn fd = %d\n", __FUNCTION__, fd );
		/* should set time-out */

		if( fd >= 0 ){
			int	sz;

			sz = sizeof(txbuf->u.conn.remote_number);
			memset( txbuf->u.conn.remote_number, 0, sz );
			strncpy( txbuf->u.conn.remote_number, gm_remote_number, sz - 1 );

			sz = sizeof(txbuf->u.conn.ppp_devname);
			memset( txbuf->u.conn.ppp_devname, 0, sz );
			strncpy( txbuf->u.conn.ppp_devname, gm_ppp_devnam, sz - 1 );
			
			txbuf->u.conn.sts_session_id = gm_sts_session_id;
			txbuf->u.conn.sts_mtu = gm_sts_mtu;
		}
		txbuf->err = (fd < 0) ? errno : 0;
		restmp = ctl_comm_send_msg( conn_sock, fd, txbuf, TMOUT_MSEC_RESP_TX );
		eloop_run();//paul add for detect PADT receiving, v2
		break;

	case COMM_CMD_DISCONNECT:
		PPPOEDisconnectDevice();
		txbuf->err = 0;
		restmp = ctl_comm_send_msg( conn_sock, fd, txbuf, TMOUT_MSEC_RESP_TX );
		break;
		
	case COMM_CMD_CHK_OPTIONS:
		memcpy( &(txbuf->u.chkopt), &(p_msg->u.chkopt), sizeof(txbuf->u.chkopt) );

		txbuf->u.chkopt.lcp.neg_accompression	= 0;
		txbuf->u.chkopt.lcp.neg_asyncmap	= 0;
		txbuf->u.chkopt.lcp.neg_pcompression	= 0;
		//txbuf->u.chkopt.lcp.mru			= MAX_PPPOE_MTU;
		txbuf->u.chkopt.ccp.deflate		= 0;
		txbuf->u.chkopt.ccp.bsd_compress	= 0;
		txbuf->u.chkopt.ipcp.neg_vj		= 0;

		txbuf->err = 0;
		restmp = ctl_comm_send_msg( conn_sock, fd, txbuf, TMOUT_MSEC_RESP_TX );
		break;

	case COMM_CMD_EXTRA_OPTIONS:
		txbuf->err = 0;
		restmp = ctl_comm_send_msg( conn_sock, fd, txbuf, TMOUT_MSEC_RESP_TX );
		break;

	case COMM_CMD_SEND_CONFIG:
		memset( gm_ifname, 0, sizeof(gm_ifname) );
		strncpy( gm_ifname, p_msg->u.conn.ifname, sizeof(gm_ifname) - 1 );
				
		PPPOESendConfig(p_msg->u.conn.sts_mtu);
		txbuf->u.conn.sts_mtu = gm_sts_mtu;
		txbuf->err = 0;
		DBGOUT("%s: send gm_sts_mtu = %d\n", __FUNCTION__, txbuf->u.conn.sts_mtu );
		restmp = ctl_comm_send_msg( conn_sock, fd, txbuf, TMOUT_MSEC_RESP_TX );
		break;
		
	case COMM_CMD_RECV_CONFIG:
		PPPOERecvConfig(p_msg->u.conn.sts_mtu);
		txbuf->err = 0;
		DBGOUT("%s: recv gm_sts_mtu = %d\n", __FUNCTION__, txbuf->u.conn.sts_mtu );
		restmp = ctl_comm_send_msg( conn_sock, fd, txbuf, TMOUT_MSEC_RESP_TX );
		break;
		
	case COMM_CMD_SEND_SIGTERM:
		gm_got_sigterm = p_msg->u.conn.got_sigterm;
		txbuf->err = 0;
		restmp = ctl_comm_send_msg( conn_sock, fd, txbuf, TMOUT_MSEC_RESP_TX );
		break;
		
	default:
		break;
	}

	return res;
}


/******************************************************************************/
/******************************************************************************/
static int		sig_no;
static int		zm_can_jump;
static sigjmp_buf	zm_jmpbuf;


/*
 */
static void  sig_hand( int  arg )
{
	sig_no = arg;

	if( zm_can_jump ){
		siglongjmp( zm_jmpbuf, 1 );
	}
}


/******************************************************************************/
/******************************************************************************/


/* from rp-pppoe/src/common.c */
extern void	switchToRealID( void );
extern void	switchToEffectiveID( void );
extern int	IsSetID;


/* from rp-pppoe/src/pppoe.c */
static void  usage(char const *argv0)
{
    fprintf(stderr, "Usage: %s [options]\n", argv0);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "   -I if_name     -- Specify interface (REQUIRED)\n");
#ifdef DEBUGGING_ENABLED
    fprintf(stderr, "   -D filename    -- Log debugging information in filename.\n");
#endif
    fprintf(stderr,
//	    "   -t timeout     -- Initial timeout for discovery packets in seconds\n"
	    "   -V             -- Print version and exit.\n"
	    "   -A             -- Print access concentrator names.\n"
	    "   -S name        -- Set desired service name.\n"
	    "   -C name        -- Set desired access concentrator name.\n"
	    "   -U             -- Use Host-Unique to allow multiple PPPoE sessions.\n"
	    "   -p pidfile     -- Write process-ID to pidfile.\n"
	    "   -d             -- enable debug output.\n"
	    "   -h             -- Print usage information.\n\n"
	    "PPPoE Version %s, Copyright (C) 2001-2006 Roaring Penguin Software Inc.\n"
	    "PPPoE comes with ABSOLUTELY NO WARRANTY.\n"
	    "This is free software, and you are welcome to redistribute it under the terms\n"
	    "of the GNU General Public License, version 2 or any later version.\n"
	    "http://www.roaringpenguin.com\n", VERSION);
    exit(EXIT_SUCCESS);
}


/*
 */
int  main( int  argc, char*  argv[] )
{
	struct sigaction	sigact;
	char const*		options;
	int			opt;
	int			n;
	unsigned int		m[6];		/* MAC address in -e option */
	unsigned int		s;		/* Temporary to hold session */
	FILE*			pidfile;
	char*			tmpopt_I = NULL;
	char*			tmpopt_S = NULL;
	char*			tmpopt_C = NULL;
//	int			tmpopt_t = -1;
	int			tmpopt_U = -1;
	int			tmpopt_A = -1;
	PPPoEConnection*	conn;
	int			res = 0;

	/******************************************/
	/* from rp-pppoe/src/pppoe.c */
	/*
	 * parse option arguments
	 */

	if (getuid() != geteuid() ||
			getgid() != getegid()) {
		IsSetID = 1;
	}

//	options = "I:VAhS:C:Up:t:d";
	options = "I:VAhS:C:Up:d";

	while( (opt = getopt( argc, argv, options )) != -1 ){
		switch(opt) {
/*
		case 't':
			if (sscanf(optarg, "%d", &tmpopt_t) != 1) {
				fprintf(stderr, "Illegal argument to -t: Should be -t timeout\n");
				exit(EXIT_FAILURE);
			}
			if (tmpopt_t < 1) {
				tmpopt_t = 1;
			}
			break;
*/
		case 'p':
			switchToRealID();
			pidfile = fopen(optarg, "w");
			if (pidfile) {
				fprintf(pidfile, "%lu\n", (unsigned long) getpid());
				fclose(pidfile);
			}
			switchToEffectiveID();
			break;
		case 'S':
			if( tmpopt_S == NULL ){
				if( (tmpopt_S = strdup( optarg )) == NULL ){
					res = errno;
					goto l_exit;
				}
			}
			break;
		case 'C':
			if( tmpopt_C == NULL ){
				if( (tmpopt_C = strdup( optarg )) == NULL ){
					res = errno;
					goto l_exit;
				}
			}
			break;
		case 'U':
			tmpopt_U = 1;
			break;
		case 'I':
			if( tmpopt_I == NULL ){
				if( (tmpopt_I = strdup( optarg )) == NULL ){
					res = errno;
					goto l_exit;
				}
			}
			break;
		case 'V':
			printf("Roaring Penguin PPPoE Version %s\n", VERSION);
			exit(EXIT_SUCCESS);
		case 'A':
			tmpopt_A = 1;
			break;
		case 'h':
			usage(argv[0]);
			break;
		case 'd':
			zm_debug = 1;
			break;
		default:
			usage(argv[0]);
		}
	}

	if( tmpopt_I == NULL ){
		printf( "-I <device name> is required.\n" );
		res = 1;
		goto l_exit;
	}

	openlog( basename( argv[0] ), LOG_NDELAY | LOG_PID, LOG_USER );

	/******************************************/
	
	//conn = pppoe_init( tmpopt_I );
	conn = kpppoe_init( tmpopt_I );
	if( conn == NULL ){
		res = 1;
		goto l_exit;
	}

	/*
	 * override parameters with option specified ones
	 */
/*
	if( tmpopt_t > 0 ){
		conn->discoveryTimeout = tmpopt_t;
	}
*/
	if( tmpopt_U >= 0 ){
		conn->useHostUniq = tmpopt_U;
	}
	if( tmpopt_A >= 0 ){
		conn->printACNames = tmpopt_A;
	}
	if( tmpopt_S ){
		conn->serviceName = tmpopt_S;
	}
	if( tmpopt_C ){
		conn->acName = tmpopt_C;
	}

	free( tmpopt_I );
	/*
	 * do not free tmpopt_S, tmpopt_C
	 */

	/******************************************/
	res = ctl_app_init();
	if( res ){
		goto l_exit;
	}

	/* register signal handlers to graceful process termination */
	sigemptyset( &(sigact.sa_mask) );
	sigact.sa_flags		= 0;
	sigact.sa_handler	= sig_hand;
	sigaction( SIGHUP, &sigact, NULL );
	sigaction( SIGINT, &sigact, NULL );
	sigaction( SIGTERM, &sigact, NULL );
	sigaction( SIGABRT, &sigact, NULL );
	sigaction( SIGFPE, &sigact, NULL );
	sigaction( SIGPIPE, &sigact, NULL );
	sigaction( SIGQUIT, &sigact, NULL );
	sigaction( SIGSEGV, &sigact, NULL );

	if( sigsetjmp( zm_jmpbuf, 1 ) == 0 ){
		zm_can_jump = 1;
	} else{
		res = EINTR;
		goto l_exit;
	}

	if( sig_no == 0 ){
		res = ctl_comm_slv_init( ctl_rx_dispatch );
		if( res ){
			goto l_exit;
		}

		/* IPC command/response loop */
		res = ctl_comm_slv_loop();
	} else{
		res = EINTR;
	}

  l_exit:;
	if( sig_no ){
		DBGOUT_0( "received SIG(%d)", sig_no );
	}

	ctl_comm_slv_exit();
	if( tmpopt_I ){
		free( tmpopt_I );
	}
	if( tmpopt_S ){
		free( tmpopt_S );
	}
	if( tmpopt_C ){
		free( tmpopt_C );
	}

	DBGOUT_0( "terminated. return = %d", res );

	return res;
}


/*
 * EOF
 */
