#ifndef __CMD_K_ERRORLOG_H__
#define __CMD_K_ERRORLOG_H__

/* Kernel Crashlog */
#define NECPF_K_ERRLOG           0x0008aa22 /* K_ERRLOG Address */
#define NECPF_K_ERRLOG_ADDR      (NECPF_K_ERRLOG * CONFIG_NECPF_EMMC_BLOCK_SIZE)

#define ERRORLOG_MAX             5
#define ERRORLOG_INFO_LEN        0x10000
#define ERRORLOG_DATA_LEN        0x30000

/* MAX_UNAME_SIZE + MAX_XTIME_LEN = 512 byte (EMMC 1block 分のサイズ) */
#define XTIME_OFFSET             CONFIG_CPU_CONTEXT_DUMP_SIZE
#define MAX_XTIME_LEN            32
#define UNAME_OFFSET             (XTIME_OFFSET + MAX_XTIME_LEN)
#define MAX_UNAME_SIZE           480
#define DMESG_OFFSET             (UNAME_OFFSET + MAX_UNAME_SIZE)

#define K_ERRORLOG_MAGIC         0x9a67b23f
#define K_ERRORLOG_VERSION       0x1

enum {
	TYPE_INVALID,
	TYPE_XTIME,
	TYPE_UNAME,
	TYPE_DMESG,
};

struct errorlog_head {
	uint32_t magic;
	uint32_t version;
	uint32_t count;
	uint32_t count_inv;
	uint32_t count_max;
	uint32_t k_errorlog_addr;
	uint32_t info_size;
	uint32_t head_size;
	uint32_t block_size;
	uint32_t zero[3 + 7 * 4];
	struct error_log_block {
		uint32_t type;
		uint32_t offset;
		uint32_t size;
		uint32_t zero[1];
	} xtime, uname, dmesg;
};

/* include/uapi/linux/utsname.h の struct new_utsname に合わせる */
#define __NEW_UTS_LEN    64
struct uname {
	char sysname[__NEW_UTS_LEN + 1];
	char nodename[__NEW_UTS_LEN + 1];
	char release[__NEW_UTS_LEN + 1];
	char version[__NEW_UTS_LEN + 1];
	char machine[__NEW_UTS_LEN + 1];
	char domainname[__NEW_UTS_LEN + 1];
};

/* kernel/printk/printk.c の struct printk_log に合わせる */
struct printk_log {
	u64 ts_nsec;            /* timestamp in nanoseconds */
	u16 len;                /* length of entire record */
	u16 text_len;           /* length of text buffer */
	u16 dict_len;           /* length of dictionary buffer */
	u8 facility;            /* syslog facility */
	u8 flags:5;             /* internal record flags */
	u8 level:3;             /* syslog level */
};

struct dmesg_h {
	unsigned int log_buf_first;
	unsigned int log_buf_next;
	unsigned int log_buf_length;
};

/* ram dump */
/*
 * 全体サイズ : 0x21000000(528MB)
 *   (block数 : 0x108000)
 *
 * LBA     (addr)
 * 0x18bc22(0x31784400) +---------------------+
 *                      |HEAD  0x4000 (16KB)  |
 *                      |                     |
 * 0x18bc42(0x31788400) +---------------------+
 *                      |DATA  0x20FFC000     |
 *                      |      (528MB-16KB)   |
 * 0x293c22(0x52784400) +---------------------+
*/

#define NECPF_RAMDUMP            0x0018bc22 /* RAMDUMP Address */
#define NECPF_RAMDUMP_ADDR       (NECPF_RAMDUMP * CONFIG_NECPF_EMMC_BLOCK_SIZE)

#define RAMDUMP_VERSION          0x1
#define RAMDUMP_SIZE             0x21000000
#define RAMDUMP_HEAD_SIZE        0x4000
#define MAX_TFTP_RAMDUMP_SIZE    0x4000000
#define TEMP_RAMDUMP_ADDR        0x42000000

struct ramdump_t {
	char name[16];
	uint32_t start;
	uint32_t size;
};

struct ramdump_head {
	uint32_t magic;
	uint32_t version;
	uint32_t head_size;
	uint32_t ramdump_data_addr;
	uint32_t data_size;
	uint32_t block_count;
	uint32_t k_num;
	uint32_t zero[1];
	char xtime[MAX_XTIME_LEN];
	struct uname uname;
	struct ramdump_t ramdump[16];
};

int save_k_errorlog(int);
int save_ramdump(void);

#endif  /* __CMD_K_ERRORLOG_H__ */
