#if !defined(__MD_LED_H__)
#define __MD_LED_H__

struct led_gpio {
	const char *name;
	int gpio;
	int active;
};

struct led_gpio * md_get_led_gpio(void);
const unsigned int md_get_led_bit_tbl(int);
const unsigned int md_get_iw_led_tbl(int);

#define LED_BIT(no) (1 << no)

#if defined(NECPF_BOARD_CASSIS) || defined(NECPF_BOARD_KIWANO) || defined(NECPF_BOARD_NAVEL)
#define LED_NO_POWER_GREEN	0
#define LED_NO_POWER_RED	1
#define LED_NO_ALARM_GREEN	2
#define LED_NO_ALARM_RED	3
#define LED_NO_NET_GREEN	4
#define LED_NO_NET_RED		5
#define LED_NO_AIR2G_GREEN	6
#define LED_NO_AIR2G_RED	7
#define LED_NO_AIR5G_GREEN	8
#define LED_NO_AIR5G_RED	9
#define LED_NO_VOIP_GREEN	10
#define LED_NO_VOIP_RED		11
#define LED_NO_TEL1_GREEN	12
#define LED_NO_TEL1_RED		13
#define LED_NO_TEL2_GREEN	14
#define LED_NO_TEL2_RED		15
#define LED_NO_PHY_LAN1_GREEN	16
#define LED_NO_PHY_LAN1_RED	17
#define LED_NO_PHY_LAN2_GREEN	18
#define LED_NO_PHY_LAN2_RED	19
#define LED_NO_PHY_LAN3_GREEN	20
#define LED_NO_PHY_LAN3_RED	21
#define LED_NO_PHY_LAN4_GREEN	22
#define LED_NO_PHY_LAN4_RED	23
#define LED_NO_PHY_WAN_GREEN	24
#define LED_NO_PHY_WAN_RED	25
#define LED_NO_MAX		26

#define LED_BIT_PHY_LED_ALL_GREEN \
	(LED_BIT(LED_NO_PHY_LAN1_GREEN) | LED_BIT(LED_NO_PHY_LAN2_GREEN) | LED_BIT(LED_NO_PHY_LAN3_GREEN) | \
	 LED_BIT(LED_NO_PHY_LAN4_GREEN) | LED_BIT(LED_NO_PHY_WAN_GREEN))

#define LED_BIT_PHY_LED_ALL_RED \
	(LED_BIT(LED_NO_PHY_LAN1_RED) | LED_BIT(LED_NO_PHY_LAN2_RED) | LED_BIT(LED_NO_PHY_LAN3_RED) | \
	 LED_BIT(LED_NO_PHY_LAN4_RED) | LED_BIT(LED_NO_PHY_WAN_RED))

#define LED_BIT_PHY_LED_ALL (LED_BIT_PHY_LED_ALL_GREEN | LED_BIT_PHY_LED_ALL_RED)

#define LED_BIT_ALL_GREEN \
	(LED_BIT(LED_NO_POWER_GREEN) | LED_BIT(LED_NO_ALARM_GREEN) | LED_BIT(LED_NO_NET_GREEN) | \
	 LED_BIT(LED_NO_AIR2G_GREEN) | LED_BIT(LED_NO_AIR5G_GREEN) | LED_BIT(LED_NO_VOIP_GREEN) | \
	 LED_BIT(LED_NO_TEL1_GREEN) | LED_BIT(LED_NO_TEL2_GREEN))
#define LED_BIT_ALL_RED \
	(LED_BIT(LED_NO_POWER_RED) | LED_BIT(LED_NO_ALARM_RED) | LED_BIT(LED_NO_NET_RED) | \
	 LED_BIT(LED_NO_AIR2G_RED) | LED_BIT(LED_NO_AIR5G_RED) | LED_BIT(LED_NO_VOIP_RED) | \
	 LED_BIT(LED_NO_TEL1_RED) | LED_BIT(LED_NO_TEL2_RED))

#define LED_BIT_ALL_ORANGE (LED_BIT_ALL_GREEN | LED_BIT_ALL_RED)
#define LED_BIT_ALL (LED_BIT_ALL_ORANGE | LED_BIT_PHY_LED_ALL)
#elif defined(NECPF_BOARD_RAPID) || defined(NECPF_BOARD_SWIFT)
#define LED_NO_POWER_GREEN	0
#define LED_NO_POWER_RED	1
#define LED_NO_ACT_GREEN	2
#define LED_NO_ACT_RED		3
#define LED_NO_AIR2G_GREEN	4
#define LED_NO_AIR2G_RED	5
#define LED_NO_AIR5G_GREEN	6
#define LED_NO_AIR5G_RED	7
#define LED_NO_TV_GREEN		8
#define LED_NO_TV_RED		9
#define LED_NO_CNV_GREEN	10
#define LED_NO_CNV_RED		11
#define LED_NO_WANLAN_GREEN	12
#define LED_NO_MAX		13

#define LED_BIT_ALL_GREEN \
	(LED_BIT(LED_NO_POWER_GREEN) | LED_BIT(LED_NO_ACT_GREEN) | LED_BIT(LED_NO_AIR2G_GREEN) | \
	 LED_BIT(LED_NO_AIR5G_GREEN) | LED_BIT(LED_NO_TV_GREEN) | LED_BIT(LED_NO_CNV_GREEN))

#define LED_BIT_ALL_RED \
	(LED_BIT(LED_NO_POWER_RED) | LED_BIT(LED_NO_ACT_RED) | LED_BIT(LED_NO_AIR2G_RED) | \
	 LED_BIT(LED_NO_AIR5G_RED) | LED_BIT(LED_NO_TV_RED) | LED_BIT(LED_NO_CNV_RED))

#define LED_BIT_ALL_ORANGE (LED_BIT_ALL_GREEN | LED_BIT_ALL_RED)
#define LED_BIT_ALL LED_BIT_ALL_ORANGE | LED_BIT(LED_NO_WANLAN_GREEN)
#else	/* MIHAWK */
#define LED_NO_POWER_GREEN	0
#define LED_NO_POWER_RED	1
#define LED_NO_WAN_GREEN	2
#define LED_NO_WAN_RED		3
#define LED_NO_AIR_GREEN	4
#define LED_NO_AIR_RED		5
#define LED_NO_VOIP_GREEN	6
#define LED_NO_VOIP_RED		7
#define LED_NO_NET_GREEN	8
#define LED_NO_NET_RED		9
#define LED_NO_UPDATE_GREEN	10
#define LED_NO_UPDATE_RED	11
#define LED_NO_OPT_GREEN	12
#define LED_NO_OPT_RED		13
#define LED_NO_OPT2_GREEN	14
#define LED_NO_OPT2_RED		15
#define LED_NO_MAX		16

#define LED_BIT_ALL_GREEN \
	(LED_BIT(LED_NO_POWER_GREEN) | LED_BIT(LED_NO_WAN_GREEN) | LED_BIT(LED_NO_AIR_GREEN) | \
	 LED_BIT(LED_NO_VOIP_GREEN) | LED_BIT(LED_NO_NET_GREEN) | LED_BIT(LED_NO_UPDATE_GREEN) | \
	 LED_BIT(LED_NO_OPT_GREEN) | LED_BIT(LED_NO_OPT2_GREEN))
#define LED_BIT_ALL_RED \
	(LED_BIT(LED_NO_POWER_RED) | LED_BIT(LED_NO_WAN_RED) | LED_BIT(LED_NO_AIR_RED) | \
	 LED_BIT(LED_NO_VOIP_RED) | LED_BIT(LED_NO_NET_RED) | LED_BIT(LED_NO_UPDATE_RED) | \
	 LED_BIT(LED_NO_OPT_RED) | LED_BIT(LED_NO_OPT2_RED))

#define LED_BIT_ALL_ORANGE (LED_BIT_ALL_GREEN | LED_BIT_ALL_RED)
#define LED_BIT_ALL LED_BIT_ALL_ORANGE
#endif	/* NECPF_BOARD_CASSIS || NECPF_BOARD_KIWANO || NECPF_BOARD_NAVEL */

#define LED_BIT_POWER_ORANGE (LED_BIT(LED_NO_POWER_GREEN) | LED_BIT(LED_NO_POWER_RED))

#endif	/* __MD_LED_H__ */
