#if !defined(__PROSLIC_H__)
#define __PROSLIC_H__

#include <linux/types.h>

#define SLIC_SI3218X 18
#define SLIC_SI3228X 28

#define SI3218X_MIHAWK 0
#define SI3218X_MAX_PRESET 1

#define SI3228X_CASSIS 0
#define SI3228X_KIWANO 1
#define SI3228X_NAVEL 2
#define SI3228X_MAX_PRESET 3

struct proslic_config {
#define LBCAL_DEFAULT 0
#define LBCAL_SKIP 1
#define LBCAL_LOAD 2
#define LBCAL_RUN 3
	int lbcal;
	int pcm_only;
	int silent;
};

struct proslic_lbcal {
	int32_t cfwd;	/* RAM 1476 */
	int32_t crev;	/* RAM 1477 */
	int32_t dact;	/* RAM 1458 */
	int32_t dacr;	/* RAM 1459 */
};

int proslic_init_if(void);
int proslic_configure(const struct proslic_config *);
int proslic_run_lbcal(void);
int proslic_read_lbcal(int, struct proslic_lbcal *);
int proslic_start_lbcal(void);
int proslic_result_lbcal(void);

int md_proslic_chip_type(void);
int md_proslic_config_no(void);
int md_proslic_workaround(int, int);
int md_lbcal_get_from_env(int, struct proslic_lbcal *);
int md_lbcal_save_to_env(int, const struct proslic_lbcal *);
int md_lbcal_erase_from_env(int);

#endif	/* !__PROSLIC_H__ */
