#ifndef __IOEXP_H__
#define __IOEXP_H__

#define OFFSET_NUM 2
#define PORT_NUM 8

#define IOEXP_ACTIVE 1
#define IOEXP_INACTIVE 0

struct ioexp_platform_data {
	struct ioexp_set_t *set_value_tbl;
	struct ioexp_set_t *setting_value_tbl;
};

typedef enum {
	IOEXP_BUS0 = 0,
	IOEXP_BUS1,
	IOEXP_BUS_MAX,
} ioexp_bus_t;

typedef enum {
	IOEXP1 = 1,
	IOEXP2,
	IOEXP_MAX,
} ioexp_device_t;

struct ioexp_param {
	char *name;
	ioexp_device_t device;
	u8 bus_addr;
	u8 config_pin[OFFSET_NUM];
	u8 config_value[OFFSET_NUM];
	u8 output_pin[OFFSET_NUM];
	u8 output_value[OFFSET_NUM];
	int next_output_value[OFFSET_NUM][PORT_NUM];
	bool active;
};

extern int ioexp_set_value(ioexp_device_t device, int port, int value);
extern int ioexp_set_value_sync(ioexp_device_t device, int port, int value);

#endif  /* __IOEXP_H__ */
