/*
 * ----------------------------------------------------------------------------
 * "THE BEER-WARE LICENSE" (Revision 42):
 * <m-asama@ginzado.co.jp> wrote this file. As long as you retain this notice
 * you can do whatever you want with this stuff. If we meet some day, and you
 * think this stuff is worth it, you can buy me a beer in return Masakazu Asama
 *
 * (C) 2020 Albert Chan <Albert_Chan@alphanetworks.com>
 * ----------------------------------------------------------------------------
 */

#ifndef _IF_MAP_H_
#define _IF_MAP_H_

#include <linux/types.h>
#include <asm/byteorder.h>

#define SIOCGETTUNNEL   (SIOCDEVPRIVATE + 0)
#define SIOCADDTUNNEL   (SIOCDEVPRIVATE + 1)
#define SIOCDELTUNNEL   (SIOCDEVPRIVATE + 2)
#define SIOCCHGTUNNEL   (SIOCDEVPRIVATE + 3)
#define SIOCGETPRL      (SIOCDEVPRIVATE + 4)
#define SIOCADDPRL      (SIOCDEVPRIVATE + 5)
#define SIOCDELPRL      (SIOCDEVPRIVATE + 6)
#define SIOCCHGPRL      (SIOCDEVPRIVATE + 7)
#define SIOCGET6RD      (SIOCDEVPRIVATE + 8)
#define SIOCADD6RD      (SIOCDEVPRIVATE + 9)
#define SIOCDEL6RD      (SIOCDEVPRIVATE + 10)
#define SIOCCHG6RD      (SIOCDEVPRIVATE + 11)
#define SIOCGETMAP      (SIOCDEVPRIVATE + 12)
#define SIOCGETMAPRULES	(SIOCDEVPRIVATE + 13)
#define SIOCADDMAPRULES	(SIOCDEVPRIVATE + 14)
#define SIOCDELMAPRULES	(SIOCDEVPRIVATE + 15)

/* IPv6 tunnel FMR */
struct ip6_tnl_fmr {
	struct ip6_tnl_fmr *next; /* next fmr in list */
	struct in6_addr ip6_prefix;
	struct in_addr ip4_prefix;

	__u8 ip6_prefix_len;
	__u8 ip4_prefix_len;
	__u8 ea_len;
	__u8 offset;
};

struct map_parm {
	char			name[IFNAMSIZ];
	unsigned long		rule_num;
	struct ip6_tnl_fmr	rule[0];
};

#endif /* _IF_MAP_H_ */
