#ifndef __Emerald_Env_regs_H__
#define __Emerald_Env_regs_H__

/* UART_WRITE_DATA */
#define REG_UART_WRITE_DATA          0xc
#define REG_UART_WRITE_DATA_MASK     0x000000ff
#define REG_UART_WRITE_DATA_SHIFT    0
#define REG_UART_WRITE_DATA_WIDTH    8

/* UART_READ_DATA */
#define REG_UART_READ_DATA          0x10
#define REG_UART_READ_DATA_MASK     0x000000ff
#define REG_UART_READ_DATA_SHIFT    0
#define REG_UART_READ_DATA_WIDTH    8

/* UART_READ_PARITY_ERROR_BIT */
#define REG_UART_READ_PARITY_ERROR_BIT          0x10
#define REG_UART_READ_PARITY_ERROR_BIT_MASK     0x00000100
#define REG_UART_READ_PARITY_ERROR_BIT_SHIFT    8
#define REG_UART_READ_PARITY_ERROR_BIT_WIDTH    1

/* UART_CLOCK_DIVISION_RATIO */
#define REG_UART_CLOCK_DIVISION_RATIO          0x14
#define REG_UART_CLOCK_DIVISION_RATIO_MASK     0x00003fff
#define REG_UART_CLOCK_DIVISION_RATIO_SHIFT    0
#define REG_UART_CLOCK_DIVISION_RATIO_WIDTH    14

/* UART_RX_FIFO_WATER_LEVEL */
#define REG_UART_RX_FIFO_WATER_LEVEL          0x18
#define REG_UART_RX_FIFO_WATER_LEVEL_MASK     0x0000001f
#define REG_UART_RX_FIFO_WATER_LEVEL_SHIFT    0
#define REG_UART_RX_FIFO_WATER_LEVEL_WIDTH    5

/* UART_TX_FIFO_WATER_LEVEL */
#define REG_UART_TX_FIFO_WATER_LEVEL          0x18
#define REG_UART_TX_FIFO_WATER_LEVEL_MASK     0x000003e0
#define REG_UART_TX_FIFO_WATER_LEVEL_SHIFT    5
#define REG_UART_TX_FIFO_WATER_LEVEL_WIDTH    5

/* UART_INT */
#define REG_UART_INT          0x1c
#define REG_UART_INT_MASK     0x0
#define REG_UART_INT_SHIFT    0
#define REG_UART_INT_WIDTH    0

/* UART_OVERRUN_IRQ_ENABLE */
#define REG_UART_OVERRUN_IRQ_ENABLE          0x1c
#define REG_UART_OVERRUN_IRQ_ENABLE_MASK     0x00000001
#define REG_UART_OVERRUN_IRQ_ENABLE_SHIFT    0
#define REG_UART_OVERRUN_IRQ_ENABLE_WIDTH    1

/* UART_FRAMING_ERROR_IRQ_ENABLE */
#define REG_UART_FRAMING_ERROR_IRQ_ENABLE          0x1c
#define REG_UART_FRAMING_ERROR_IRQ_ENABLE_MASK     0x00000002
#define REG_UART_FRAMING_ERROR_IRQ_ENABLE_SHIFT    1
#define REG_UART_FRAMING_ERROR_IRQ_ENABLE_WIDTH    1

/* UART_PARITY_ERROR_IRQ_ENABLE */
#define REG_UART_PARITY_ERROR_IRQ_ENABLE          0x1c
#define REG_UART_PARITY_ERROR_IRQ_ENABLE_MASK     0x00000004
#define REG_UART_PARITY_ERROR_IRQ_ENABLE_SHIFT    2
#define REG_UART_PARITY_ERROR_IRQ_ENABLE_WIDTH    1

/* UART_READ_COLLAPSE_BUFFER_IRQ_ENABLE */
#define REG_UART_READ_COLLAPSE_BUFFER_IRQ_ENABLE          0x1c
#define REG_UART_READ_COLLAPSE_BUFFER_IRQ_ENABLE_MASK     0x00000008
#define REG_UART_READ_COLLAPSE_BUFFER_IRQ_ENABLE_SHIFT    3
#define REG_UART_READ_COLLAPSE_BUFFER_IRQ_ENABLE_WIDTH    1

/* UART_WRITE_COLLAPSE_BUFFER_IRQ_ENABLE */
#define REG_UART_WRITE_COLLAPSE_BUFFER_IRQ_ENABLE          0x1c
#define REG_UART_WRITE_COLLAPSE_BUFFER_IRQ_ENABLE_MASK     0x00000010
#define REG_UART_WRITE_COLLAPSE_BUFFER_IRQ_ENABLE_SHIFT    4
#define REG_UART_WRITE_COLLAPSE_BUFFER_IRQ_ENABLE_WIDTH    1

/* UART_READ_FIFO_WATER_LEVEL_IRQ_ENABLE */
#define REG_UART_READ_FIFO_WATER_LEVEL_IRQ_ENABLE          0x1c
#define REG_UART_READ_FIFO_WATER_LEVEL_IRQ_ENABLE_MASK     0x00000020
#define REG_UART_READ_FIFO_WATER_LEVEL_IRQ_ENABLE_SHIFT    5
#define REG_UART_READ_FIFO_WATER_LEVEL_IRQ_ENABLE_WIDTH    1

/* UART_WRITE_FIFO_WATER_LEVEL_IRQ_ENABLE */
#define REG_UART_WRITE_FIFO_WATER_LEVEL_IRQ_ENABLE          0x1c
#define REG_UART_WRITE_FIFO_WATER_LEVEL_IRQ_ENABLE_MASK     0x00000040
#define REG_UART_WRITE_FIFO_WATER_LEVEL_IRQ_ENABLE_SHIFT    6
#define REG_UART_WRITE_FIFO_WATER_LEVEL_IRQ_ENABLE_WIDTH    1

/* UART_IDLE_IRQ_ENABLE */
#define REG_UART_IDLE_IRQ_ENABLE          0x1c
#define REG_UART_IDLE_IRQ_ENABLE_MASK     0x00000080
#define REG_UART_IDLE_IRQ_ENABLE_SHIFT    7
#define REG_UART_IDLE_IRQ_ENABLE_WIDTH    1

/* UART_OVERRUN_IRQ */
/* Clear the IRQ by writing "1" to this bit. */
#define REG_UART_OVERRUN_IRQ          0x1c
#define REG_UART_OVERRUN_IRQ_MASK     0x00000100
#define REG_UART_OVERRUN_IRQ_SHIFT    8
#define REG_UART_OVERRUN_IRQ_WIDTH    1

/* UART_FRAMING_ERROR_IRQ */
/* Clear the IRQ by writing "1" to this bit. */
#define REG_UART_FRAMING_ERROR_IRQ          0x1c
#define REG_UART_FRAMING_ERROR_IRQ_MASK     0x00000200
#define REG_UART_FRAMING_ERROR_IRQ_SHIFT    9
#define REG_UART_FRAMING_ERROR_IRQ_WIDTH    1

/* UART_PARITY_ERROR_IRQ */
/* Clear the IRQ by writing "1" to this bit. */
#define REG_UART_PARITY_ERROR_IRQ          0x1c
#define REG_UART_PARITY_ERROR_IRQ_MASK     0x00000400
#define REG_UART_PARITY_ERROR_IRQ_SHIFT    10
#define REG_UART_PARITY_ERROR_IRQ_WIDTH    1

/* UART_READ_COLLAPSE_BUFFER_IRQ */
/* Clear the IRQ by writing "1" to this bit. */
#define REG_UART_READ_COLLAPSE_BUFFER_IRQ          0x1c
#define REG_UART_READ_COLLAPSE_BUFFER_IRQ_MASK     0x00000800
#define REG_UART_READ_COLLAPSE_BUFFER_IRQ_SHIFT    11
#define REG_UART_READ_COLLAPSE_BUFFER_IRQ_WIDTH    1

/* UART_WRITE_COLLAPSE_BUFFER_IRQ */
/* Clear the IRQ by writing "1" to this bit. */
#define REG_UART_WRITE_COLLAPSE_BUFFER_IRQ          0x1c
#define REG_UART_WRITE_COLLAPSE_BUFFER_IRQ_MASK     0x00001000
#define REG_UART_WRITE_COLLAPSE_BUFFER_IRQ_SHIFT    12
#define REG_UART_WRITE_COLLAPSE_BUFFER_IRQ_WIDTH    1

/* UART_READ_FIFO_WATER_LEVEL_IRQ */
/* Clear the IRQ by writing "1" to this bit. */
#define REG_UART_READ_FIFO_WATER_LEVEL_IRQ          0x1c
#define REG_UART_READ_FIFO_WATER_LEVEL_IRQ_MASK     0x00002000
#define REG_UART_READ_FIFO_WATER_LEVEL_IRQ_SHIFT    13
#define REG_UART_READ_FIFO_WATER_LEVEL_IRQ_WIDTH    1

/* UART_WRITE_FIFO_WATER_LEVEL_IRQ */
/* Clear the IRQ by writing "1" to this bit. */
#define REG_UART_WRITE_FIFO_WATER_LEVEL_IRQ          0x1c
#define REG_UART_WRITE_FIFO_WATER_LEVEL_IRQ_MASK     0x00004000
#define REG_UART_WRITE_FIFO_WATER_LEVEL_IRQ_SHIFT    14
#define REG_UART_WRITE_FIFO_WATER_LEVEL_IRQ_WIDTH    1

/* UART_IDLE_IRQ */
/* Clear the IRQ by writing "1" to this bit. */
#define REG_UART_IDLE_IRQ          0x1c
#define REG_UART_IDLE_IRQ_MASK     0x00008000
#define REG_UART_IDLE_IRQ_SHIFT    15
#define REG_UART_IDLE_IRQ_WIDTH    1

/* UART_CONTROL */
#define REG_UART_CONTROL          0x20
#define REG_UART_CONTROL_MASK     0x0
#define REG_UART_CONTROL_SHIFT    0
#define REG_UART_CONTROL_WIDTH    0

/* UART_TX_OUTPUT_ENABLE */
#define REG_UART_TX_OUTPUT_ENABLE          0x20
#define REG_UART_TX_OUTPUT_ENABLE_MASK     0x00000001
#define REG_UART_TX_OUTPUT_ENABLE_SHIFT    0
#define REG_UART_TX_OUTPUT_ENABLE_WIDTH    1

/* UART_RX_PARITY_MODE */
#define REG_UART_RX_PARITY_MODE          0x20
#define REG_UART_RX_PARITY_MODE_MASK     0x00000006
#define REG_UART_RX_PARITY_MODE_SHIFT    1
#define REG_UART_RX_PARITY_MODE_WIDTH    2

/* UART_TX_PARITY_MODE */
#define REG_UART_TX_PARITY_MODE          0x20
#define REG_UART_TX_PARITY_MODE_MASK     0x00000018
#define REG_UART_TX_PARITY_MODE_SHIFT    3
#define REG_UART_TX_PARITY_MODE_WIDTH    2

/* UART_RX_STOP */
#define REG_UART_RX_STOP          0x20
#define REG_UART_RX_STOP_MASK     0x00000020
#define REG_UART_RX_STOP_SHIFT    5
#define REG_UART_RX_STOP_WIDTH    1

/* UART_TX_STOP */
#define REG_UART_TX_STOP          0x20
#define REG_UART_TX_STOP_MASK     0x00000040
#define REG_UART_TX_STOP_SHIFT    6
#define REG_UART_TX_STOP_WIDTH    1

/* UART_LOOPBACK_MODE */
#define REG_UART_LOOPBACK_MODE          0x20
#define REG_UART_LOOPBACK_MODE_MASK     0x00000080
#define REG_UART_LOOPBACK_MODE_SHIFT    7
#define REG_UART_LOOPBACK_MODE_WIDTH    1

/* UART_NOISE_COUNTER */
#define REG_UART_NOISE_COUNTER          0x24
#define REG_UART_NOISE_COUNTER_MASK     0x10000000
#define REG_UART_NOISE_COUNTER_SHIFT    28
#define REG_UART_NOISE_COUNTER_WIDTH    1

/* UART_RX_IDLE_COUNTER */
#define REG_UART_RX_IDLE_COUNTER          0x28
#define REG_UART_RX_IDLE_COUNTER_MASK     0x000000ff
#define REG_UART_RX_IDLE_COUNTER_SHIFT    0
#define REG_UART_RX_IDLE_COUNTER_WIDTH    8

/* UART_BYTES_IN_RX_FIFO */
#define REG_UART_BYTES_IN_RX_FIFO          0x2c
#define REG_UART_BYTES_IN_RX_FIFO_MASK     0x0000001f
#define REG_UART_BYTES_IN_RX_FIFO_SHIFT    0
#define REG_UART_BYTES_IN_RX_FIFO_WIDTH    5

/* UART_BYTES_IN_TX_FIFO */
#define REG_UART_BYTES_IN_TX_FIFO          0x2c
#define REG_UART_BYTES_IN_TX_FIFO_MASK     0x000003e0
#define REG_UART_BYTES_IN_TX_FIFO_SHIFT    5
#define REG_UART_BYTES_IN_TX_FIFO_WIDTH    5

/* UART_TX_INTERRUPT_MODE */
#define REG_UART_TX_INTERRUPT_MODE          0x30
#define REG_UART_TX_INTERRUPT_MODE_MASK     0x00000001
#define REG_UART_TX_INTERRUPT_MODE_SHIFT    0
#define REG_UART_TX_INTERRUPT_MODE_WIDTH    1


#define REG_IRQ_MASK                       0x140

/* IRQ_SOURCE_01_MAPPING */
#define REG_IRQ_SOURCE_01_MAPPING          0x148
#define REG_IRQ_SOURCE_01_MAPPING_MASK     0x0000001f
#define REG_IRQ_SOURCE_01_MAPPING_SHIFT    0
#define REG_IRQ_SOURCE_01_MAPPING_WIDTH    5

/* IRQ_SOURCE_02_MAPPING */
#define REG_IRQ_SOURCE_02_MAPPING          0x148
#define REG_IRQ_SOURCE_02_MAPPING_MASK     0x000003e0
#define REG_IRQ_SOURCE_02_MAPPING_SHIFT    5
#define REG_IRQ_SOURCE_02_MAPPING_WIDTH    5

/* IRQ_SOURCE_03_MAPPING */
#define REG_IRQ_SOURCE_03_MAPPING          0x148
#define REG_IRQ_SOURCE_03_MAPPING_MASK     0x00007c00
#define REG_IRQ_SOURCE_03_MAPPING_SHIFT    10
#define REG_IRQ_SOURCE_03_MAPPING_WIDTH    5

/* IRQ_SOURCE_04_MAPPING */
#define REG_IRQ_SOURCE_04_MAPPING          0x148
#define REG_IRQ_SOURCE_04_MAPPING_MASK     0x000f8000
#define REG_IRQ_SOURCE_04_MAPPING_SHIFT    15
#define REG_IRQ_SOURCE_04_MAPPING_WIDTH    5

/* IRQ_SOURCE_05_MAPPING */
#define REG_IRQ_SOURCE_05_MAPPING          0x148
#define REG_IRQ_SOURCE_05_MAPPING_MASK     0x01f00000
#define REG_IRQ_SOURCE_05_MAPPING_SHIFT    20
#define REG_IRQ_SOURCE_05_MAPPING_WIDTH    5

/* IRQ_SOURCE_06_MAPPING */
#define REG_IRQ_SOURCE_06_MAPPING          0x148
#define REG_IRQ_SOURCE_06_MAPPING_MASK     0x3e000000
#define REG_IRQ_SOURCE_06_MAPPING_SHIFT    25
#define REG_IRQ_SOURCE_06_MAPPING_WIDTH    5

/* IRQ_SOURCE_07_MAPPING */
#define REG_IRQ_SOURCE_07_MAPPING          0x14c
#define REG_IRQ_SOURCE_07_MAPPING_MASK     0x0000001f
#define REG_IRQ_SOURCE_07_MAPPING_SHIFT    0
#define REG_IRQ_SOURCE_07_MAPPING_WIDTH    5

/* IRQ_SOURCE_08_MAPPING */
#define REG_IRQ_SOURCE_08_MAPPING          0x14c
#define REG_IRQ_SOURCE_08_MAPPING_MASK     0x000003e0
#define REG_IRQ_SOURCE_08_MAPPING_SHIFT    5
#define REG_IRQ_SOURCE_08_MAPPING_WIDTH    5

/* IRQ_SOURCE_09_MAPPING */
#define REG_IRQ_SOURCE_09_MAPPING          0x14c
#define REG_IRQ_SOURCE_09_MAPPING_MASK     0x00007c00
#define REG_IRQ_SOURCE_09_MAPPING_SHIFT    10
#define REG_IRQ_SOURCE_09_MAPPING_WIDTH    5

/* IRQ_SOURCE_10_MAPPING */
#define REG_IRQ_SOURCE_10_MAPPING          0x14c
#define REG_IRQ_SOURCE_10_MAPPING_MASK     0x000f8000
#define REG_IRQ_SOURCE_10_MAPPING_SHIFT    15
#define REG_IRQ_SOURCE_10_MAPPING_WIDTH    5

/* IRQ_SOURCE_11_MAPPING */
#define REG_IRQ_SOURCE_11_MAPPING          0x14c
#define REG_IRQ_SOURCE_11_MAPPING_MASK     0x01f00000
#define REG_IRQ_SOURCE_11_MAPPING_SHIFT    20
#define REG_IRQ_SOURCE_11_MAPPING_WIDTH    5

/* IRQ_SOURCE_12_MAPPING */
#define REG_IRQ_SOURCE_12_MAPPING          0x14c
#define REG_IRQ_SOURCE_12_MAPPING_MASK     0x3e000000
#define REG_IRQ_SOURCE_12_MAPPING_SHIFT    25
#define REG_IRQ_SOURCE_12_MAPPING_WIDTH    5

/* IRQ_SOURCE_13_MAPPING */
#define REG_IRQ_SOURCE_13_MAPPING          0x150
#define REG_IRQ_SOURCE_13_MAPPING_MASK     0x0000001f
#define REG_IRQ_SOURCE_13_MAPPING_SHIFT    0
#define REG_IRQ_SOURCE_13_MAPPING_WIDTH    5

/* IRQ_SOURCE_14_MAPPING */
#define REG_IRQ_SOURCE_14_MAPPING          0x150
#define REG_IRQ_SOURCE_14_MAPPING_MASK     0x000003e0
#define REG_IRQ_SOURCE_14_MAPPING_SHIFT    5
#define REG_IRQ_SOURCE_14_MAPPING_WIDTH    5

/* IRQ_SOURCE_15_MAPPING */
#define REG_IRQ_SOURCE_15_MAPPING          0x150
#define REG_IRQ_SOURCE_15_MAPPING_MASK     0x00007c00
#define REG_IRQ_SOURCE_15_MAPPING_SHIFT    10
#define REG_IRQ_SOURCE_15_MAPPING_WIDTH    5

/* IRQ_SOURCE_16_MAPPING */
#define REG_IRQ_SOURCE_16_MAPPING          0x150
#define REG_IRQ_SOURCE_16_MAPPING_MASK     0x000f8000
#define REG_IRQ_SOURCE_16_MAPPING_SHIFT    15
#define REG_IRQ_SOURCE_16_MAPPING_WIDTH    5

/* IRQ_SOURCE_17_MAPPING */
#define REG_IRQ_SOURCE_17_MAPPING          0x150
#define REG_IRQ_SOURCE_17_MAPPING_MASK     0x01f00000
#define REG_IRQ_SOURCE_17_MAPPING_SHIFT    20
#define REG_IRQ_SOURCE_17_MAPPING_WIDTH    5

/* IRQ_SOURCE_18_MAPPING */
#define REG_IRQ_SOURCE_18_MAPPING          0x150
#define REG_IRQ_SOURCE_18_MAPPING_MASK     0x3e000000
#define REG_IRQ_SOURCE_18_MAPPING_SHIFT    25
#define REG_IRQ_SOURCE_18_MAPPING_WIDTH    5

/* IRQ_SOURCE_19_MAPPING */
#define REG_IRQ_SOURCE_19_MAPPING          0x154
#define REG_IRQ_SOURCE_19_MAPPING_MASK     0x0000001f
#define REG_IRQ_SOURCE_19_MAPPING_SHIFT    0
#define REG_IRQ_SOURCE_19_MAPPING_WIDTH    5

/* IRQ_SOURCE_20_MAPPING */
#define REG_IRQ_SOURCE_20_MAPPING          0x154
#define REG_IRQ_SOURCE_20_MAPPING_MASK     0x000003e0
#define REG_IRQ_SOURCE_20_MAPPING_SHIFT    5
#define REG_IRQ_SOURCE_20_MAPPING_WIDTH    5

/* IRQ_SOURCE_21_MAPPING */
#define REG_IRQ_SOURCE_21_MAPPING          0x154
#define REG_IRQ_SOURCE_21_MAPPING_MASK     0x00007c00
#define REG_IRQ_SOURCE_21_MAPPING_SHIFT    10
#define REG_IRQ_SOURCE_21_MAPPING_WIDTH    5

/* IRQ_SOURCE_22_MAPPING */
#define REG_IRQ_SOURCE_22_MAPPING          0x154
#define REG_IRQ_SOURCE_22_MAPPING_MASK     0x000f8000
#define REG_IRQ_SOURCE_22_MAPPING_SHIFT    15
#define REG_IRQ_SOURCE_22_MAPPING_WIDTH    5

/* IRQ_SOURCE_23_MAPPING */
#define REG_IRQ_SOURCE_23_MAPPING          0x154
#define REG_IRQ_SOURCE_23_MAPPING_MASK     0x01f00000
#define REG_IRQ_SOURCE_23_MAPPING_SHIFT    20
#define REG_IRQ_SOURCE_23_MAPPING_WIDTH    5

/* IRQ_SOURCE_24_MAPPING */
#define REG_IRQ_SOURCE_24_MAPPING          0x154
#define REG_IRQ_SOURCE_24_MAPPING_MASK     0x3e000000
#define REG_IRQ_SOURCE_24_MAPPING_SHIFT    25
#define REG_IRQ_SOURCE_24_MAPPING_WIDTH    5

/* IRQ_SOURCE_25_MAPPING */
#define REG_IRQ_SOURCE_25_MAPPING          0x158
#define REG_IRQ_SOURCE_25_MAPPING_MASK     0x0000001f
#define REG_IRQ_SOURCE_25_MAPPING_SHIFT    0
#define REG_IRQ_SOURCE_25_MAPPING_WIDTH    5

/* IRQ_SOURCE_26_MAPPING */
#define REG_IRQ_SOURCE_26_MAPPING          0x158
#define REG_IRQ_SOURCE_26_MAPPING_MASK     0x000003e0
#define REG_IRQ_SOURCE_26_MAPPING_SHIFT    5
#define REG_IRQ_SOURCE_26_MAPPING_WIDTH    5

/* IRQ_SOURCE_27_MAPPING */
#define REG_IRQ_SOURCE_27_MAPPING          0x158
#define REG_IRQ_SOURCE_27_MAPPING_MASK     0x00007c00
#define REG_IRQ_SOURCE_27_MAPPING_SHIFT    10
#define REG_IRQ_SOURCE_27_MAPPING_WIDTH    5

/* IRQ_SOURCE_28_MAPPING */
#define REG_IRQ_SOURCE_28_MAPPING          0x158
#define REG_IRQ_SOURCE_28_MAPPING_MASK     0x000f8000
#define REG_IRQ_SOURCE_28_MAPPING_SHIFT    15
#define REG_IRQ_SOURCE_28_MAPPING_WIDTH    5

/* IRQ_SOURCE_29_MAPPING */
#define REG_IRQ_SOURCE_29_MAPPING          0x158
#define REG_IRQ_SOURCE_29_MAPPING_MASK     0x01f00000
#define REG_IRQ_SOURCE_29_MAPPING_SHIFT    20
#define REG_IRQ_SOURCE_29_MAPPING_WIDTH    5

/* IRQ_SOURCE_30_MAPPING */
#define REG_IRQ_SOURCE_30_MAPPING          0x158
#define REG_IRQ_SOURCE_30_MAPPING_MASK     0x3e000000
#define REG_IRQ_SOURCE_30_MAPPING_SHIFT    25
#define REG_IRQ_SOURCE_30_MAPPING_WIDTH    5

/* IRQ_SOURCE_31_MAPPING */
#define REG_IRQ_SOURCE_31_MAPPING          0x15c
#define REG_IRQ_SOURCE_31_MAPPING_MASK     0x0000001f
#define REG_IRQ_SOURCE_31_MAPPING_SHIFT    0
#define REG_IRQ_SOURCE_31_MAPPING_WIDTH    5

/* MAPPED_IRQS_FROM_MAPPER */
#define REG_MAPPED_IRQS_FROM_MAPPER          0x160
#define REG_MAPPED_IRQS_FROM_MAPPER_MASK     0x7fffffff
#define REG_MAPPED_IRQS_FROM_MAPPER_SHIFT    0
#define REG_MAPPED_IRQS_FROM_MAPPER_WIDTH    31

/* UNMAPPED_IRQS_TO_MAPPER */
#define REG_UNMAPPED_IRQS_TO_MAPPER          0x164
#define REG_UNMAPPED_IRQS_TO_MAPPER_MASK     0x7fffffff
#define REG_UNMAPPED_IRQS_TO_MAPPER_SHIFT    0
#define REG_UNMAPPED_IRQS_TO_MAPPER_WIDTH    31

/* TIMER_0_MAX_COUNT */
#define REG_TIMER_0_MAX_COUNT          0x180
#define REG_TIMER_0_MAX_COUNT_MASK     0xffffffff
#define REG_TIMER_0_MAX_COUNT_SHIFT    0
#define REG_TIMER_0_MAX_COUNT_WIDTH    32

/* TIMER_1_MAX_COUNT */
#define REG_TIMER_1_MAX_COUNT          0x184
#define REG_TIMER_1_MAX_COUNT_MASK     0xffffffff
#define REG_TIMER_1_MAX_COUNT_SHIFT    0
#define REG_TIMER_1_MAX_COUNT_WIDTH    32

/* TIMER_2_MAX_COUNT */
#define REG_TIMER_2_MAX_COUNT          0x188
#define REG_TIMER_2_MAX_COUNT_MASK     0xffffffff
#define REG_TIMER_2_MAX_COUNT_SHIFT    0
#define REG_TIMER_2_MAX_COUNT_WIDTH    32

/* TIMER_3_MAX_COUNT */
#define REG_TIMER_3_MAX_COUNT          0x18c
#define REG_TIMER_3_MAX_COUNT_MASK     0xffffffff
#define REG_TIMER_3_MAX_COUNT_SHIFT    0
#define REG_TIMER_3_MAX_COUNT_WIDTH    32

/* TIMER_0_COUNT_VALUE */
#define REG_TIMER_0_COUNT_VALUE          0x190
#define REG_TIMER_0_COUNT_VALUE_MASK     0xffffffff
#define REG_TIMER_0_COUNT_VALUE_SHIFT    0
#define REG_TIMER_0_COUNT_VALUE_WIDTH    32

/* TIMER_1_COUNT_VALUE */
#define REG_TIMER_1_COUNT_VALUE          0x194
#define REG_TIMER_1_COUNT_VALUE_MASK     0xffffffff
#define REG_TIMER_1_COUNT_VALUE_SHIFT    0
#define REG_TIMER_1_COUNT_VALUE_WIDTH    32

/* TIMER_2_COUNT_VALUE */
#define REG_TIMER_2_COUNT_VALUE          0x198
#define REG_TIMER_2_COUNT_VALUE_MASK     0xffffffff
#define REG_TIMER_2_COUNT_VALUE_SHIFT    0
#define REG_TIMER_2_COUNT_VALUE_WIDTH    32

/* TIMER_3_COUNT_VALUE */
#define REG_TIMER_3_COUNT_VALUE          0x19c
#define REG_TIMER_3_COUNT_VALUE_MASK     0xffffffff
#define REG_TIMER_3_COUNT_VALUE_SHIFT    0
#define REG_TIMER_3_COUNT_VALUE_WIDTH    32

/* TIMER0_EXPIRED */
#define REG_TIMER0_EXPIRED          0x1a0
#define REG_TIMER0_EXPIRED_MASK     0x00000001
#define REG_TIMER0_EXPIRED_SHIFT    0
#define REG_TIMER0_EXPIRED_WIDTH    1

/* TIMER1_EXPIRED */
#define REG_TIMER1_EXPIRED          0x1a0
#define REG_TIMER1_EXPIRED_MASK     0x00000002
#define REG_TIMER1_EXPIRED_SHIFT    1
#define REG_TIMER1_EXPIRED_WIDTH    1

/* TIMER2_EXPIRED */
#define REG_TIMER2_EXPIRED          0x1a0
#define REG_TIMER2_EXPIRED_MASK     0x00000004
#define REG_TIMER2_EXPIRED_SHIFT    2
#define REG_TIMER2_EXPIRED_WIDTH    1

/* TIMER3_EXPIRED */
#define REG_TIMER3_EXPIRED          0x1a0
#define REG_TIMER3_EXPIRED_MASK     0x00000008
#define REG_TIMER3_EXPIRED_SHIFT    3
#define REG_TIMER3_EXPIRED_WIDTH    1

/* TIMER_0_ONESHOT_MODE */
#define REG_TIMER_0_ONESHOT_MODE          0x1a4
#define REG_TIMER_0_ONESHOT_MODE_MASK     0x00000001
#define REG_TIMER_0_ONESHOT_MODE_SHIFT    0
#define REG_TIMER_0_ONESHOT_MODE_WIDTH    1

/* TIMER_1_ONESHOT_MODE */
#define REG_TIMER_1_ONESHOT_MODE          0x1a4
#define REG_TIMER_1_ONESHOT_MODE_MASK     0x00000002
#define REG_TIMER_1_ONESHOT_MODE_SHIFT    1
#define REG_TIMER_1_ONESHOT_MODE_WIDTH    1

/* TIMER_2_ONESHOT_MODE */
#define REG_TIMER_2_ONESHOT_MODE          0x1a4
#define REG_TIMER_2_ONESHOT_MODE_MASK     0x00000004
#define REG_TIMER_2_ONESHOT_MODE_SHIFT    2
#define REG_TIMER_2_ONESHOT_MODE_WIDTH    1

/* TIMER_3_ONESHOT_MODE */
#define REG_TIMER_3_ONESHOT_MODE          0x1a4
#define REG_TIMER_3_ONESHOT_MODE_MASK     0x00000008
#define REG_TIMER_3_ONESHOT_MODE_SHIFT    3
#define REG_TIMER_3_ONESHOT_MODE_WIDTH    1

/* TIMER_0_ENABLE */
#define REG_TIMER_0_ENABLE          0x1a4
#define REG_TIMER_0_ENABLE_MASK     0x00000010
#define REG_TIMER_0_ENABLE_SHIFT    4
#define REG_TIMER_0_ENABLE_WIDTH    1

/* TIMER_1_ENABLE */
#define REG_TIMER_1_ENABLE          0x1a4
#define REG_TIMER_1_ENABLE_MASK     0x00000020
#define REG_TIMER_1_ENABLE_SHIFT    5
#define REG_TIMER_1_ENABLE_WIDTH    1

/* TIMER_2_ENABLE */
#define REG_TIMER_2_ENABLE          0x1a4
#define REG_TIMER_2_ENABLE_MASK     0x00000040
#define REG_TIMER_2_ENABLE_SHIFT    6
#define REG_TIMER_2_ENABLE_WIDTH    1

/* TIMER_3_ENABLE */
#define REG_TIMER_3_ENABLE          0x1a4
#define REG_TIMER_3_ENABLE_MASK     0x00000080
#define REG_TIMER_3_ENABLE_SHIFT    7
#define REG_TIMER_3_ENABLE_WIDTH    1

/*Prescale */
#define REG_TIMER_PRESCALER_MIN     2
#define REG_TIMER_PRESCALER_MAX     3

/* TIMER_0_PRESCALER - N/A*/

/* TIMER_1_PRESCALER - N/A*/

/* TIMER_2_PRESCALER */
#define REG_TIMER_2_PRESCALER       0x1a8
#define REG_TIMER_2_PRESCALER_MASK  0x000000ff
#define REG_TIMER_2_PRESCALER_SHIFT 0
#define REG_TIMER_2_PRESCALER_WIDTH 8

/* TIMER_3_PRESCALER */
#define REG_TIMER_3_PRESCALER       0x1ac
#define REG_TIMER_3_PRESCALER_MASK  0x000000ff
#define REG_TIMER_3_PRESCALER_SHIFT 0
#define REG_TIMER_3_PRESCALER_WIDTH 8


#endif /* __Emerald_Env_regs_H__ */
