//-----------------------------------------------------------------------------
// LSD Generator
//-----------------------------------------------------------------------------
// Perl Package        : LSD::generator::targetC (v1.1)
// LSD Source          : C:/Users/huchunfe/Perforce/huchunfe_huchunfe-MOBL1_dev.FalcONT/ipg_lsd/lsd_sys/source/xml/reg_files/CBM_DQM.xml
// Register File Name  : CQEM_DEQ
// Register File Title : Central QoS Manager - Dequeue Register Description
// Register Width      : 32
// Note                : Doxygen compliant comments
//-----------------------------------------------------------------------------

#ifndef _CQEM_DEQ_H
#define _CQEM_DEQ_H

//! \defgroup CQEM_DEQ Register File CQEM_DEQ - Central QoS Manager - Dequeue Register Description
//! @{

//! Base Address of CQEM_DEQ
#define CQEM_DEQ_MODULE_BASE 0x190C0000u

//! \defgroup CBM_DQM_CTRL Register CBM_DQM_CTRL - CBM Dequeue Manager Control Register
//! @{

//! Register Offset (relative)
#define CBM_DQM_CTRL 0x0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CBM_DQM_CTRL 0x190C0000u

//! Register Reset Value
#define CBM_DQM_CTRL_RST 0x00000000u

//! Field DQM_EN - Enable Dequeue Manager Core State Machine
#define CBM_DQM_CTRL_DQM_EN_POS 0
//! Field DQM_EN - Enable Dequeue Manager Core State Machine
#define CBM_DQM_CTRL_DQM_EN_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CBM_DQM_CTRL_DQM_EN_DIS 0x0
//! Constant EN - EN
#define CONST_CBM_DQM_CTRL_DQM_EN_EN 0x1

//! Field DQM_FRZ - Freeze Dequeue Manager Core State Machine
#define CBM_DQM_CTRL_DQM_FRZ_POS 1
//! Field DQM_FRZ - Freeze Dequeue Manager Core State Machine
#define CBM_DQM_CTRL_DQM_FRZ_MASK 0x2u
//! Constant DIS - DIS
#define CONST_CBM_DQM_CTRL_DQM_FRZ_DIS 0x0
//! Constant EN - EN
#define CONST_CBM_DQM_CTRL_DQM_FRZ_EN 0x1

//! Field DQM_ACT - Dequeue Manager Activity Status
#define CBM_DQM_CTRL_DQM_ACT_POS 2
//! Field DQM_ACT - Dequeue Manager Activity Status
#define CBM_DQM_CTRL_DQM_ACT_MASK 0x4u
//! Constant INACTIVE - Inactive
#define CONST_CBM_DQM_CTRL_DQM_ACT_INACTIVE 0x0
//! Constant ACTIVE - Active
#define CONST_CBM_DQM_CTRL_DQM_ACT_ACTIVE 0x1

//! @}

//! \defgroup DBG_DQM_0 Register DBG_DQM_0 - Hardware Debug Register
//! @{

//! Register Offset (relative)
#define DBG_DQM_0 0x10
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DBG_DQM_0 0x190C0010u

//! Register Reset Value
#define DBG_DQM_0_RST 0x00000000u

//! Field DBG - Debug
#define DBG_DQM_0_DBG_POS 0
//! Field DBG - Debug
#define DBG_DQM_0_DBG_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DBG_DQM_1 Register DBG_DQM_1 - Hardware Debug Register
//! @{

//! Register Offset (relative)
#define DBG_DQM_1 0x14
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DBG_DQM_1 0x190C0014u

//! Register Reset Value
#define DBG_DQM_1_RST 0x00000000u

//! Field DBG - Debug
#define DBG_DQM_1_DBG_POS 0
//! Field DBG - Debug
#define DBG_DQM_1_DBG_MASK 0xFFFFFFFFu

//! @}

//! \defgroup TEST_DQM_0 Register TEST_DQM_0 - Hardware Test Register
//! @{

//! Register Offset (relative)
#define TEST_DQM_0 0x20
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_TEST_DQM_0 0x190C0020u

//! Register Reset Value
#define TEST_DQM_0_RST 0x00000000u

//! Field TEST - Test
#define TEST_DQM_0_TEST_POS 0
//! Field TEST - Test
#define TEST_DQM_0_TEST_MASK 0xFFFFFFFFu

//! @}

//! \defgroup TEST_DQM_1 Register TEST_DQM_1 - Hardware Test Register
//! @{

//! Register Offset (relative)
#define TEST_DQM_1 0x24
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_TEST_DQM_1 0x190C0024u

//! Register Reset Value
#define TEST_DQM_1_RST 0x00000000u

//! Field TEST - Test
#define TEST_DQM_1_TEST_POS 0
//! Field TEST - Test
#define TEST_DQM_1_TEST_MASK 0xFFFFFFFFu

//! @}

//! \defgroup CFG_CPU_EGP_0 Register CFG_CPU_EGP_0 - CPU Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_CPU_EGP_0 0x10000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_CPU_EGP_0 0x190D0000u

//! Register Reset Value
#define CFG_CPU_EGP_0_RST 0x00000000u

//! Field DQREQ - Enable CPU Dequeue Request
#define CFG_CPU_EGP_0_DQREQ_POS 0
//! Field DQREQ - Enable CPU Dequeue Request
#define CFG_CPU_EGP_0_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_CPU_EGP_0_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_CPU_EGP_0_DQREQ_EN 0x1

//! Field BUFRTN - Enable CPU Buffer Return
#define CFG_CPU_EGP_0_BUFRTN_POS 1
//! Field BUFRTN - Enable CPU Buffer Return
#define CFG_CPU_EGP_0_BUFRTN_MASK 0x2u
//! Constant DIS - DIS
#define CONST_CFG_CPU_EGP_0_BUFRTN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_CPU_EGP_0_BUFRTN_EN 0x1

//! Field BFBPEN - Buffer Return Back Pressure Enable
#define CFG_CPU_EGP_0_BFBPEN_POS 2
//! Field BFBPEN - Buffer Return Back Pressure Enable
#define CFG_CPU_EGP_0_BFBPEN_MASK 0x4u
//! Constant DIS - DIS
#define CONST_CFG_CPU_EGP_0_BFBPEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_CPU_EGP_0_BFBPEN_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_CPU_EGP_0_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_CPU_EGP_0_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_CPU_EGP_0_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_CPU_EGP_0_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_CPU_EGP_0_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_CPU_EGP_0_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_CPU_EGP_0 Register DQPC_CPU_EGP_0 - CPU Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_CPU_EGP_0 0x10004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_CPU_EGP_0 0x190D0004u

//! Register Reset Value
#define DQPC_CPU_EGP_0_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_CPU_EGP_0_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_CPU_EGP_0_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_CPU_EGP_0 Register IRNCR_CPU_EGP_0 - CPU Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_CPU_EGP_0 0x10020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_CPU_EGP_0 0x190D0020u

//! Register Reset Value
#define IRNCR_CPU_EGP_0_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNCR_CPU_EGP_0_PR_POS 0
//! Field PR - Pointer Ready
#define IRNCR_CPU_EGP_0_PR_MASK 0x1u
//! Constant NUL - NULL
#define CONST_IRNCR_CPU_EGP_0_PR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_CPU_EGP_0_PR_INTOCC 0x1

//! Field DR - Descriptor Ready
#define IRNCR_CPU_EGP_0_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_CPU_EGP_0_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_CPU_EGP_0_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_CPU_EGP_0_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_CPU_EGP_0 Register IRNICR_CPU_EGP_0 - CPU Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_CPU_EGP_0 0x10024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_CPU_EGP_0 0x190D0024u

//! Register Reset Value
#define IRNICR_CPU_EGP_0_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNICR_CPU_EGP_0_PR_POS 0
//! Field PR - Pointer Ready
#define IRNICR_CPU_EGP_0_PR_MASK 0x1u

//! Field DR - Descriptor Ready
#define IRNICR_CPU_EGP_0_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_CPU_EGP_0_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_CPU_EGP_0 Register IRNEN_CPU_EGP_0 - CPU Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_CPU_EGP_0 0x10028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_CPU_EGP_0 0x190D0028u

//! Register Reset Value
#define IRNEN_CPU_EGP_0_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNEN_CPU_EGP_0_PR_POS 0
//! Field PR - Pointer Ready
#define IRNEN_CPU_EGP_0_PR_MASK 0x1u
//! Constant DIS - DIS
#define CONST_IRNEN_CPU_EGP_0_PR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_CPU_EGP_0_PR_EN 0x1

//! Field DR - Descriptor Ready
#define IRNEN_CPU_EGP_0_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_CPU_EGP_0_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_CPU_EGP_0_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_CPU_EGP_0_DR_EN 0x1

//! @}

//! \defgroup DPTR_CPU_EGP_0 Register DPTR_CPU_EGP_0 - CPU Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_CPU_EGP_0 0x10030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_CPU_EGP_0 0x190D0030u

//! Register Reset Value
#define DPTR_CPU_EGP_0_RST 0x00000001u

//! Field ND - Number of Descriptors
#define DPTR_CPU_EGP_0_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_CPU_EGP_0_ND_MASK 0x1u

//! Field DPTR - Descriptor Pointer
#define DPTR_CPU_EGP_0_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_CPU_EGP_0_DPTR_MASK 0x10000u

//! @}

//! \defgroup BPRC_CPU_EGP_0 Register BPRC_CPU_EGP_0 - Egress Port Buffer Pointer Return counter
//! @{

//! Register Offset (relative)
#define BPRC_CPU_EGP_0 0x10034
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_BPRC_CPU_EGP_0 0x190D0034u

//! Register Reset Value
#define BPRC_CPU_EGP_0_RST 0x00000000u

//! Field BPRC - Per Port Buffer Pointer Return Counter
#define BPRC_CPU_EGP_0_BPRC_POS 0
//! Field BPRC - Per Port Buffer Pointer Return Counter
#define BPRC_CPU_EGP_0_BPRC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup PTR_RTN_CPU_DW2_EGP_0 Register PTR_RTN_CPU_DW2_EGP_0 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_CPU_DW2_EGP_0 0x10100
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_CPU_DW2_EGP_0 0x190D0100u

//! Register Reset Value
#define PTR_RTN_CPU_DW2_EGP_0_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_CPU_DW2_EGP_0_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_CPU_DW2_EGP_0_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_CPU_DW3_EGP_0 Register PTR_RTN_CPU_DW3_EGP_0 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_CPU_DW3_EGP_0 0x10104
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_CPU_DW3_EGP_0 0x190D0104u

//! Register Reset Value
#define PTR_RTN_CPU_DW3_EGP_0_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_CPU_DW3_EGP_0_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_CPU_DW3_EGP_0_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_CPU_DW3_EGP_0_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_CPU_DW3_EGP_0_POLICY_MASK 0x700000u

//! @}

//! \defgroup DESC0_0_CPU_EGP_0 Register DESC0_0_CPU_EGP_0 - CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_CPU_EGP_0 0x10200
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_CPU_EGP_0 0x190D0200u

//! Register Reset Value
#define DESC0_0_CPU_EGP_0_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_0_CPU_EGP_0_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_0_CPU_EGP_0_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_CPU_EGP_0 Register DESC1_0_CPU_EGP_0 - CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_CPU_EGP_0 0x10204
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_CPU_EGP_0 0x190D0204u

//! Register Reset Value
#define DESC1_0_CPU_EGP_0_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_0_CPU_EGP_0_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_0_CPU_EGP_0_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_CPU_EGP_0 Register DESC2_0_CPU_EGP_0 - CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_CPU_EGP_0 0x10208
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_CPU_EGP_0 0x190D0208u

//! Register Reset Value
#define DESC2_0_CPU_EGP_0_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_0_CPU_EGP_0_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_0_CPU_EGP_0_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_CPU_EGP_0 Register DESC3_0_CPU_EGP_0 - CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_CPU_EGP_0 0x1020C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_CPU_EGP_0 0x190D020Cu

//! Register Reset Value
#define DESC3_0_CPU_EGP_0_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_0_CPU_EGP_0_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_0_CPU_EGP_0_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_1_CPU_EGP_0 Register DESC0_1_CPU_EGP_0 - CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_CPU_EGP_0 0x10210
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_CPU_EGP_0 0x190D0210u

//! Register Reset Value
#define DESC0_1_CPU_EGP_0_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_1_CPU_EGP_0_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_1_CPU_EGP_0_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_CPU_EGP_0 Register DESC1_1_CPU_EGP_0 - CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_CPU_EGP_0 0x10214
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_CPU_EGP_0 0x190D0214u

//! Register Reset Value
#define DESC1_1_CPU_EGP_0_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_1_CPU_EGP_0_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_1_CPU_EGP_0_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_CPU_EGP_0 Register DESC2_1_CPU_EGP_0 - CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_CPU_EGP_0 0x10218
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_CPU_EGP_0 0x190D0218u

//! Register Reset Value
#define DESC2_1_CPU_EGP_0_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_1_CPU_EGP_0_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_1_CPU_EGP_0_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_CPU_EGP_0 Register DESC3_1_CPU_EGP_0 - CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_CPU_EGP_0 0x1021C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_CPU_EGP_0 0x190D021Cu

//! Register Reset Value
#define DESC3_1_CPU_EGP_0_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_1_CPU_EGP_0_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_1_CPU_EGP_0_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup CFG_CPU_EGP_1 Register CFG_CPU_EGP_1 - CPU Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_CPU_EGP_1 0x11000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_CPU_EGP_1 0x190D1000u

//! Register Reset Value
#define CFG_CPU_EGP_1_RST 0x00000000u

//! Field DQREQ - Enable CPU Dequeue Request
#define CFG_CPU_EGP_1_DQREQ_POS 0
//! Field DQREQ - Enable CPU Dequeue Request
#define CFG_CPU_EGP_1_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_CPU_EGP_1_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_CPU_EGP_1_DQREQ_EN 0x1

//! Field BUFRTN - Enable CPU Buffer Return
#define CFG_CPU_EGP_1_BUFRTN_POS 1
//! Field BUFRTN - Enable CPU Buffer Return
#define CFG_CPU_EGP_1_BUFRTN_MASK 0x2u
//! Constant DIS - DIS
#define CONST_CFG_CPU_EGP_1_BUFRTN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_CPU_EGP_1_BUFRTN_EN 0x1

//! Field BFBPEN - Buffer Return Back Pressure Enable
#define CFG_CPU_EGP_1_BFBPEN_POS 2
//! Field BFBPEN - Buffer Return Back Pressure Enable
#define CFG_CPU_EGP_1_BFBPEN_MASK 0x4u
//! Constant DIS - DIS
#define CONST_CFG_CPU_EGP_1_BFBPEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_CPU_EGP_1_BFBPEN_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_CPU_EGP_1_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_CPU_EGP_1_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_CPU_EGP_1_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_CPU_EGP_1_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_CPU_EGP_1_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_CPU_EGP_1_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_CPU_EGP_1 Register DQPC_CPU_EGP_1 - CPU Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_CPU_EGP_1 0x11004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_CPU_EGP_1 0x190D1004u

//! Register Reset Value
#define DQPC_CPU_EGP_1_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_CPU_EGP_1_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_CPU_EGP_1_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_CPU_EGP_1 Register IRNCR_CPU_EGP_1 - CPU Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_CPU_EGP_1 0x11020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_CPU_EGP_1 0x190D1020u

//! Register Reset Value
#define IRNCR_CPU_EGP_1_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNCR_CPU_EGP_1_PR_POS 0
//! Field PR - Pointer Ready
#define IRNCR_CPU_EGP_1_PR_MASK 0x1u
//! Constant NUL - NULL
#define CONST_IRNCR_CPU_EGP_1_PR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_CPU_EGP_1_PR_INTOCC 0x1

//! Field DR - Descriptor Ready
#define IRNCR_CPU_EGP_1_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_CPU_EGP_1_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_CPU_EGP_1_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_CPU_EGP_1_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_CPU_EGP_1 Register IRNICR_CPU_EGP_1 - CPU Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_CPU_EGP_1 0x11024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_CPU_EGP_1 0x190D1024u

//! Register Reset Value
#define IRNICR_CPU_EGP_1_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNICR_CPU_EGP_1_PR_POS 0
//! Field PR - Pointer Ready
#define IRNICR_CPU_EGP_1_PR_MASK 0x1u

//! Field DR - Descriptor Ready
#define IRNICR_CPU_EGP_1_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_CPU_EGP_1_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_CPU_EGP_1 Register IRNEN_CPU_EGP_1 - CPU Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_CPU_EGP_1 0x11028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_CPU_EGP_1 0x190D1028u

//! Register Reset Value
#define IRNEN_CPU_EGP_1_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNEN_CPU_EGP_1_PR_POS 0
//! Field PR - Pointer Ready
#define IRNEN_CPU_EGP_1_PR_MASK 0x1u
//! Constant DIS - DIS
#define CONST_IRNEN_CPU_EGP_1_PR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_CPU_EGP_1_PR_EN 0x1

//! Field DR - Descriptor Ready
#define IRNEN_CPU_EGP_1_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_CPU_EGP_1_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_CPU_EGP_1_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_CPU_EGP_1_DR_EN 0x1

//! @}

//! \defgroup DPTR_CPU_EGP_1 Register DPTR_CPU_EGP_1 - CPU Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_CPU_EGP_1 0x11030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_CPU_EGP_1 0x190D1030u

//! Register Reset Value
#define DPTR_CPU_EGP_1_RST 0x00000001u

//! Field ND - Number of Descriptors
#define DPTR_CPU_EGP_1_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_CPU_EGP_1_ND_MASK 0x1u

//! Field DPTR - Descriptor Pointer
#define DPTR_CPU_EGP_1_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_CPU_EGP_1_DPTR_MASK 0x10000u

//! @}

//! \defgroup BPRC_CPU_EGP_1 Register BPRC_CPU_EGP_1 - Egress Port Buffer Pointer Return counter
//! @{

//! Register Offset (relative)
#define BPRC_CPU_EGP_1 0x11034
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_BPRC_CPU_EGP_1 0x190D1034u

//! Register Reset Value
#define BPRC_CPU_EGP_1_RST 0x00000000u

//! Field BPRC - Per Port Buffer Pointer Return Counter
#define BPRC_CPU_EGP_1_BPRC_POS 0
//! Field BPRC - Per Port Buffer Pointer Return Counter
#define BPRC_CPU_EGP_1_BPRC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup PTR_RTN_CPU_DW2_EGP_1 Register PTR_RTN_CPU_DW2_EGP_1 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_CPU_DW2_EGP_1 0x11100
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_CPU_DW2_EGP_1 0x190D1100u

//! Register Reset Value
#define PTR_RTN_CPU_DW2_EGP_1_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_CPU_DW2_EGP_1_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_CPU_DW2_EGP_1_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_CPU_DW3_EGP_1 Register PTR_RTN_CPU_DW3_EGP_1 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_CPU_DW3_EGP_1 0x11104
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_CPU_DW3_EGP_1 0x190D1104u

//! Register Reset Value
#define PTR_RTN_CPU_DW3_EGP_1_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_CPU_DW3_EGP_1_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_CPU_DW3_EGP_1_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_CPU_DW3_EGP_1_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_CPU_DW3_EGP_1_POLICY_MASK 0x700000u

//! @}

//! \defgroup DESC0_0_CPU_EGP_1 Register DESC0_0_CPU_EGP_1 - CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_CPU_EGP_1 0x11200
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_CPU_EGP_1 0x190D1200u

//! Register Reset Value
#define DESC0_0_CPU_EGP_1_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_0_CPU_EGP_1_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_0_CPU_EGP_1_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_CPU_EGP_1 Register DESC1_0_CPU_EGP_1 - CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_CPU_EGP_1 0x11204
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_CPU_EGP_1 0x190D1204u

//! Register Reset Value
#define DESC1_0_CPU_EGP_1_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_0_CPU_EGP_1_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_0_CPU_EGP_1_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_CPU_EGP_1 Register DESC2_0_CPU_EGP_1 - CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_CPU_EGP_1 0x11208
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_CPU_EGP_1 0x190D1208u

//! Register Reset Value
#define DESC2_0_CPU_EGP_1_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_0_CPU_EGP_1_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_0_CPU_EGP_1_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_CPU_EGP_1 Register DESC3_0_CPU_EGP_1 - CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_CPU_EGP_1 0x1120C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_CPU_EGP_1 0x190D120Cu

//! Register Reset Value
#define DESC3_0_CPU_EGP_1_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_0_CPU_EGP_1_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_0_CPU_EGP_1_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_1_CPU_EGP_1 Register DESC0_1_CPU_EGP_1 - CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_CPU_EGP_1 0x11210
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_CPU_EGP_1 0x190D1210u

//! Register Reset Value
#define DESC0_1_CPU_EGP_1_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_1_CPU_EGP_1_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_1_CPU_EGP_1_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_CPU_EGP_1 Register DESC1_1_CPU_EGP_1 - CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_CPU_EGP_1 0x11214
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_CPU_EGP_1 0x190D1214u

//! Register Reset Value
#define DESC1_1_CPU_EGP_1_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_1_CPU_EGP_1_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_1_CPU_EGP_1_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_CPU_EGP_1 Register DESC2_1_CPU_EGP_1 - CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_CPU_EGP_1 0x11218
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_CPU_EGP_1 0x190D1218u

//! Register Reset Value
#define DESC2_1_CPU_EGP_1_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_1_CPU_EGP_1_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_1_CPU_EGP_1_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_CPU_EGP_1 Register DESC3_1_CPU_EGP_1 - CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_CPU_EGP_1 0x1121C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_CPU_EGP_1 0x190D121Cu

//! Register Reset Value
#define DESC3_1_CPU_EGP_1_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_1_CPU_EGP_1_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_1_CPU_EGP_1_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup CFG_CPU_EGP_2 Register CFG_CPU_EGP_2 - CPU Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_CPU_EGP_2 0x12000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_CPU_EGP_2 0x190D2000u

//! Register Reset Value
#define CFG_CPU_EGP_2_RST 0x00000000u

//! Field DQREQ - Enable CPU Dequeue Request
#define CFG_CPU_EGP_2_DQREQ_POS 0
//! Field DQREQ - Enable CPU Dequeue Request
#define CFG_CPU_EGP_2_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_CPU_EGP_2_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_CPU_EGP_2_DQREQ_EN 0x1

//! Field BUFRTN - Enable CPU Buffer Return
#define CFG_CPU_EGP_2_BUFRTN_POS 1
//! Field BUFRTN - Enable CPU Buffer Return
#define CFG_CPU_EGP_2_BUFRTN_MASK 0x2u
//! Constant DIS - DIS
#define CONST_CFG_CPU_EGP_2_BUFRTN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_CPU_EGP_2_BUFRTN_EN 0x1

//! Field BFBPEN - Buffer Return Back Pressure Enable
#define CFG_CPU_EGP_2_BFBPEN_POS 2
//! Field BFBPEN - Buffer Return Back Pressure Enable
#define CFG_CPU_EGP_2_BFBPEN_MASK 0x4u
//! Constant DIS - DIS
#define CONST_CFG_CPU_EGP_2_BFBPEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_CPU_EGP_2_BFBPEN_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_CPU_EGP_2_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_CPU_EGP_2_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_CPU_EGP_2_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_CPU_EGP_2_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_CPU_EGP_2_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_CPU_EGP_2_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_CPU_EGP_2 Register DQPC_CPU_EGP_2 - CPU Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_CPU_EGP_2 0x12004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_CPU_EGP_2 0x190D2004u

//! Register Reset Value
#define DQPC_CPU_EGP_2_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_CPU_EGP_2_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_CPU_EGP_2_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_CPU_EGP_2 Register IRNCR_CPU_EGP_2 - CPU Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_CPU_EGP_2 0x12020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_CPU_EGP_2 0x190D2020u

//! Register Reset Value
#define IRNCR_CPU_EGP_2_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNCR_CPU_EGP_2_PR_POS 0
//! Field PR - Pointer Ready
#define IRNCR_CPU_EGP_2_PR_MASK 0x1u
//! Constant NUL - NULL
#define CONST_IRNCR_CPU_EGP_2_PR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_CPU_EGP_2_PR_INTOCC 0x1

//! Field DR - Descriptor Ready
#define IRNCR_CPU_EGP_2_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_CPU_EGP_2_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_CPU_EGP_2_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_CPU_EGP_2_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_CPU_EGP_2 Register IRNICR_CPU_EGP_2 - CPU Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_CPU_EGP_2 0x12024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_CPU_EGP_2 0x190D2024u

//! Register Reset Value
#define IRNICR_CPU_EGP_2_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNICR_CPU_EGP_2_PR_POS 0
//! Field PR - Pointer Ready
#define IRNICR_CPU_EGP_2_PR_MASK 0x1u

//! Field DR - Descriptor Ready
#define IRNICR_CPU_EGP_2_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_CPU_EGP_2_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_CPU_EGP_2 Register IRNEN_CPU_EGP_2 - CPU Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_CPU_EGP_2 0x12028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_CPU_EGP_2 0x190D2028u

//! Register Reset Value
#define IRNEN_CPU_EGP_2_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNEN_CPU_EGP_2_PR_POS 0
//! Field PR - Pointer Ready
#define IRNEN_CPU_EGP_2_PR_MASK 0x1u
//! Constant DIS - DIS
#define CONST_IRNEN_CPU_EGP_2_PR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_CPU_EGP_2_PR_EN 0x1

//! Field DR - Descriptor Ready
#define IRNEN_CPU_EGP_2_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_CPU_EGP_2_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_CPU_EGP_2_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_CPU_EGP_2_DR_EN 0x1

//! @}

//! \defgroup DPTR_CPU_EGP_2 Register DPTR_CPU_EGP_2 - CPU Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_CPU_EGP_2 0x12030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_CPU_EGP_2 0x190D2030u

//! Register Reset Value
#define DPTR_CPU_EGP_2_RST 0x00000001u

//! Field ND - Number of Descriptors
#define DPTR_CPU_EGP_2_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_CPU_EGP_2_ND_MASK 0x1u

//! Field DPTR - Descriptor Pointer
#define DPTR_CPU_EGP_2_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_CPU_EGP_2_DPTR_MASK 0x10000u

//! @}

//! \defgroup BPRC_CPU_EGP_2 Register BPRC_CPU_EGP_2 - Egress Port Buffer Pointer Return counter
//! @{

//! Register Offset (relative)
#define BPRC_CPU_EGP_2 0x12034
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_BPRC_CPU_EGP_2 0x190D2034u

//! Register Reset Value
#define BPRC_CPU_EGP_2_RST 0x00000000u

//! Field BPRC - Per Port Buffer Pointer Return Counter
#define BPRC_CPU_EGP_2_BPRC_POS 0
//! Field BPRC - Per Port Buffer Pointer Return Counter
#define BPRC_CPU_EGP_2_BPRC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup PTR_RTN_CPU_DW2_EGP_2 Register PTR_RTN_CPU_DW2_EGP_2 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_CPU_DW2_EGP_2 0x12100
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_CPU_DW2_EGP_2 0x190D2100u

//! Register Reset Value
#define PTR_RTN_CPU_DW2_EGP_2_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_CPU_DW2_EGP_2_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_CPU_DW2_EGP_2_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_CPU_DW3_EGP_2 Register PTR_RTN_CPU_DW3_EGP_2 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_CPU_DW3_EGP_2 0x12104
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_CPU_DW3_EGP_2 0x190D2104u

//! Register Reset Value
#define PTR_RTN_CPU_DW3_EGP_2_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_CPU_DW3_EGP_2_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_CPU_DW3_EGP_2_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_CPU_DW3_EGP_2_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_CPU_DW3_EGP_2_POLICY_MASK 0x700000u

//! @}

//! \defgroup DESC0_0_CPU_EGP_2 Register DESC0_0_CPU_EGP_2 - CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_CPU_EGP_2 0x12200
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_CPU_EGP_2 0x190D2200u

//! Register Reset Value
#define DESC0_0_CPU_EGP_2_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_0_CPU_EGP_2_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_0_CPU_EGP_2_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_CPU_EGP_2 Register DESC1_0_CPU_EGP_2 - CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_CPU_EGP_2 0x12204
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_CPU_EGP_2 0x190D2204u

//! Register Reset Value
#define DESC1_0_CPU_EGP_2_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_0_CPU_EGP_2_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_0_CPU_EGP_2_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_CPU_EGP_2 Register DESC2_0_CPU_EGP_2 - CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_CPU_EGP_2 0x12208
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_CPU_EGP_2 0x190D2208u

//! Register Reset Value
#define DESC2_0_CPU_EGP_2_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_0_CPU_EGP_2_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_0_CPU_EGP_2_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_CPU_EGP_2 Register DESC3_0_CPU_EGP_2 - CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_CPU_EGP_2 0x1220C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_CPU_EGP_2 0x190D220Cu

//! Register Reset Value
#define DESC3_0_CPU_EGP_2_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_0_CPU_EGP_2_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_0_CPU_EGP_2_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_1_CPU_EGP_2 Register DESC0_1_CPU_EGP_2 - CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_CPU_EGP_2 0x12210
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_CPU_EGP_2 0x190D2210u

//! Register Reset Value
#define DESC0_1_CPU_EGP_2_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_1_CPU_EGP_2_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_1_CPU_EGP_2_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_CPU_EGP_2 Register DESC1_1_CPU_EGP_2 - CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_CPU_EGP_2 0x12214
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_CPU_EGP_2 0x190D2214u

//! Register Reset Value
#define DESC1_1_CPU_EGP_2_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_1_CPU_EGP_2_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_1_CPU_EGP_2_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_CPU_EGP_2 Register DESC2_1_CPU_EGP_2 - CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_CPU_EGP_2 0x12218
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_CPU_EGP_2 0x190D2218u

//! Register Reset Value
#define DESC2_1_CPU_EGP_2_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_1_CPU_EGP_2_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_1_CPU_EGP_2_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_CPU_EGP_2 Register DESC3_1_CPU_EGP_2 - CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_CPU_EGP_2 0x1221C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_CPU_EGP_2 0x190D221Cu

//! Register Reset Value
#define DESC3_1_CPU_EGP_2_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_1_CPU_EGP_2_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_1_CPU_EGP_2_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup CFG_CPU_EGP_3 Register CFG_CPU_EGP_3 - CPU Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_CPU_EGP_3 0x13000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_CPU_EGP_3 0x190D3000u

//! Register Reset Value
#define CFG_CPU_EGP_3_RST 0x00000000u

//! Field DQREQ - Enable CPU Dequeue Request
#define CFG_CPU_EGP_3_DQREQ_POS 0
//! Field DQREQ - Enable CPU Dequeue Request
#define CFG_CPU_EGP_3_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_CPU_EGP_3_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_CPU_EGP_3_DQREQ_EN 0x1

//! Field BUFRTN - Enable CPU Buffer Return
#define CFG_CPU_EGP_3_BUFRTN_POS 1
//! Field BUFRTN - Enable CPU Buffer Return
#define CFG_CPU_EGP_3_BUFRTN_MASK 0x2u
//! Constant DIS - DIS
#define CONST_CFG_CPU_EGP_3_BUFRTN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_CPU_EGP_3_BUFRTN_EN 0x1

//! Field BFBPEN - Buffer Return Back Pressure Enable
#define CFG_CPU_EGP_3_BFBPEN_POS 2
//! Field BFBPEN - Buffer Return Back Pressure Enable
#define CFG_CPU_EGP_3_BFBPEN_MASK 0x4u
//! Constant DIS - DIS
#define CONST_CFG_CPU_EGP_3_BFBPEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_CPU_EGP_3_BFBPEN_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_CPU_EGP_3_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_CPU_EGP_3_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_CPU_EGP_3_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_CPU_EGP_3_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_CPU_EGP_3_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_CPU_EGP_3_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_CPU_EGP_3 Register DQPC_CPU_EGP_3 - CPU Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_CPU_EGP_3 0x13004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_CPU_EGP_3 0x190D3004u

//! Register Reset Value
#define DQPC_CPU_EGP_3_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_CPU_EGP_3_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_CPU_EGP_3_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_CPU_EGP_3 Register IRNCR_CPU_EGP_3 - CPU Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_CPU_EGP_3 0x13020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_CPU_EGP_3 0x190D3020u

//! Register Reset Value
#define IRNCR_CPU_EGP_3_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNCR_CPU_EGP_3_PR_POS 0
//! Field PR - Pointer Ready
#define IRNCR_CPU_EGP_3_PR_MASK 0x1u
//! Constant NUL - NULL
#define CONST_IRNCR_CPU_EGP_3_PR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_CPU_EGP_3_PR_INTOCC 0x1

//! Field DR - Descriptor Ready
#define IRNCR_CPU_EGP_3_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_CPU_EGP_3_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_CPU_EGP_3_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_CPU_EGP_3_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_CPU_EGP_3 Register IRNICR_CPU_EGP_3 - CPU Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_CPU_EGP_3 0x13024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_CPU_EGP_3 0x190D3024u

//! Register Reset Value
#define IRNICR_CPU_EGP_3_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNICR_CPU_EGP_3_PR_POS 0
//! Field PR - Pointer Ready
#define IRNICR_CPU_EGP_3_PR_MASK 0x1u

//! Field DR - Descriptor Ready
#define IRNICR_CPU_EGP_3_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_CPU_EGP_3_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_CPU_EGP_3 Register IRNEN_CPU_EGP_3 - CPU Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_CPU_EGP_3 0x13028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_CPU_EGP_3 0x190D3028u

//! Register Reset Value
#define IRNEN_CPU_EGP_3_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNEN_CPU_EGP_3_PR_POS 0
//! Field PR - Pointer Ready
#define IRNEN_CPU_EGP_3_PR_MASK 0x1u
//! Constant DIS - DIS
#define CONST_IRNEN_CPU_EGP_3_PR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_CPU_EGP_3_PR_EN 0x1

//! Field DR - Descriptor Ready
#define IRNEN_CPU_EGP_3_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_CPU_EGP_3_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_CPU_EGP_3_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_CPU_EGP_3_DR_EN 0x1

//! @}

//! \defgroup DPTR_CPU_EGP_3 Register DPTR_CPU_EGP_3 - CPU Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_CPU_EGP_3 0x13030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_CPU_EGP_3 0x190D3030u

//! Register Reset Value
#define DPTR_CPU_EGP_3_RST 0x00000001u

//! Field ND - Number of Descriptors
#define DPTR_CPU_EGP_3_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_CPU_EGP_3_ND_MASK 0x1u

//! Field DPTR - Descriptor Pointer
#define DPTR_CPU_EGP_3_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_CPU_EGP_3_DPTR_MASK 0x10000u

//! @}

//! \defgroup BPRC_CPU_EGP_3 Register BPRC_CPU_EGP_3 - Egress Port Buffer Pointer Return counter
//! @{

//! Register Offset (relative)
#define BPRC_CPU_EGP_3 0x13034
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_BPRC_CPU_EGP_3 0x190D3034u

//! Register Reset Value
#define BPRC_CPU_EGP_3_RST 0x00000000u

//! Field BPRC - Per Port Buffer Pointer Return Counter
#define BPRC_CPU_EGP_3_BPRC_POS 0
//! Field BPRC - Per Port Buffer Pointer Return Counter
#define BPRC_CPU_EGP_3_BPRC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup PTR_RTN_CPU_DW2_EGP_3 Register PTR_RTN_CPU_DW2_EGP_3 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_CPU_DW2_EGP_3 0x13100
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_CPU_DW2_EGP_3 0x190D3100u

//! Register Reset Value
#define PTR_RTN_CPU_DW2_EGP_3_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_CPU_DW2_EGP_3_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_CPU_DW2_EGP_3_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_CPU_DW3_EGP_3 Register PTR_RTN_CPU_DW3_EGP_3 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_CPU_DW3_EGP_3 0x13104
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_CPU_DW3_EGP_3 0x190D3104u

//! Register Reset Value
#define PTR_RTN_CPU_DW3_EGP_3_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_CPU_DW3_EGP_3_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_CPU_DW3_EGP_3_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_CPU_DW3_EGP_3_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_CPU_DW3_EGP_3_POLICY_MASK 0x700000u

//! @}

//! \defgroup DESC0_0_CPU_EGP_3 Register DESC0_0_CPU_EGP_3 - CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_CPU_EGP_3 0x13200
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_CPU_EGP_3 0x190D3200u

//! Register Reset Value
#define DESC0_0_CPU_EGP_3_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_0_CPU_EGP_3_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_0_CPU_EGP_3_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_CPU_EGP_3 Register DESC1_0_CPU_EGP_3 - CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_CPU_EGP_3 0x13204
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_CPU_EGP_3 0x190D3204u

//! Register Reset Value
#define DESC1_0_CPU_EGP_3_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_0_CPU_EGP_3_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_0_CPU_EGP_3_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_CPU_EGP_3 Register DESC2_0_CPU_EGP_3 - CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_CPU_EGP_3 0x13208
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_CPU_EGP_3 0x190D3208u

//! Register Reset Value
#define DESC2_0_CPU_EGP_3_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_0_CPU_EGP_3_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_0_CPU_EGP_3_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_CPU_EGP_3 Register DESC3_0_CPU_EGP_3 - CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_CPU_EGP_3 0x1320C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_CPU_EGP_3 0x190D320Cu

//! Register Reset Value
#define DESC3_0_CPU_EGP_3_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_0_CPU_EGP_3_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_0_CPU_EGP_3_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_1_CPU_EGP_3 Register DESC0_1_CPU_EGP_3 - CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_CPU_EGP_3 0x13210
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_CPU_EGP_3 0x190D3210u

//! Register Reset Value
#define DESC0_1_CPU_EGP_3_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_1_CPU_EGP_3_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_1_CPU_EGP_3_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_CPU_EGP_3 Register DESC1_1_CPU_EGP_3 - CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_CPU_EGP_3 0x13214
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_CPU_EGP_3 0x190D3214u

//! Register Reset Value
#define DESC1_1_CPU_EGP_3_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_1_CPU_EGP_3_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_1_CPU_EGP_3_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_CPU_EGP_3 Register DESC2_1_CPU_EGP_3 - CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_CPU_EGP_3 0x13218
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_CPU_EGP_3 0x190D3218u

//! Register Reset Value
#define DESC2_1_CPU_EGP_3_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_1_CPU_EGP_3_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_1_CPU_EGP_3_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_CPU_EGP_3 Register DESC3_1_CPU_EGP_3 - CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_CPU_EGP_3 0x1321C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_CPU_EGP_3 0x190D321Cu

//! Register Reset Value
#define DESC3_1_CPU_EGP_3_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_1_CPU_EGP_3_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_1_CPU_EGP_3_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup CFG_ACA_EGP_4 Register CFG_ACA_EGP_4 - CPU ACA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_ACA_EGP_4 0x14000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_ACA_EGP_4 0x190D4000u

//! Register Reset Value
#define CFG_ACA_EGP_4_RST 0x00000000u

//! Field DQREQ - Enable CPU Dequeue Request
#define CFG_ACA_EGP_4_DQREQ_POS 0
//! Field DQREQ - Enable CPU Dequeue Request
#define CFG_ACA_EGP_4_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_ACA_EGP_4_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_ACA_EGP_4_DQREQ_EN 0x1

//! Field BUFRTN - Enable CPU Buffer Return
#define CFG_ACA_EGP_4_BUFRTN_POS 1
//! Field BUFRTN - Enable CPU Buffer Return
#define CFG_ACA_EGP_4_BUFRTN_MASK 0x2u
//! Constant DIS - DIS
#define CONST_CFG_ACA_EGP_4_BUFRTN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_ACA_EGP_4_BUFRTN_EN 0x1

//! Field BFBPEN - Buffer Return Back Pressure Enable
#define CFG_ACA_EGP_4_BFBPEN_POS 2
//! Field BFBPEN - Buffer Return Back Pressure Enable
#define CFG_ACA_EGP_4_BFBPEN_MASK 0x4u
//! Constant DIS - DIS
#define CONST_CFG_ACA_EGP_4_BFBPEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_ACA_EGP_4_BFBPEN_EN 0x1

//! Field DQBPEN - Dequeue Back Pressure Enable
#define CFG_ACA_EGP_4_DQBPEN_POS 3
//! Field DQBPEN - Dequeue Back Pressure Enable
#define CFG_ACA_EGP_4_DQBPEN_MASK 0x8u
//! Constant DIS - DIS
#define CONST_CFG_ACA_EGP_4_DQBPEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_ACA_EGP_4_DQBPEN_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_ACA_EGP_4_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_ACA_EGP_4_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_ACA_EGP_4_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_ACA_EGP_4_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_ACA_EGP_4_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_ACA_EGP_4_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_CPU_EGP_4 Register DQPC_CPU_EGP_4 - CPU Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_CPU_EGP_4 0x14004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_CPU_EGP_4 0x190D4004u

//! Register Reset Value
#define DQPC_CPU_EGP_4_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_CPU_EGP_4_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_CPU_EGP_4_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_CPU_EGP_4 Register IRNCR_CPU_EGP_4 - CPU Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_CPU_EGP_4 0x14020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_CPU_EGP_4 0x190D4020u

//! Register Reset Value
#define IRNCR_CPU_EGP_4_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNCR_CPU_EGP_4_PR_POS 0
//! Field PR - Pointer Ready
#define IRNCR_CPU_EGP_4_PR_MASK 0x1u
//! Constant NUL - NULL
#define CONST_IRNCR_CPU_EGP_4_PR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_CPU_EGP_4_PR_INTOCC 0x1

//! Field DR - Descriptor Ready
#define IRNCR_CPU_EGP_4_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_CPU_EGP_4_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_CPU_EGP_4_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_CPU_EGP_4_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_CPU_EGP_4 Register IRNICR_CPU_EGP_4 - CPU Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_CPU_EGP_4 0x14024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_CPU_EGP_4 0x190D4024u

//! Register Reset Value
#define IRNICR_CPU_EGP_4_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNICR_CPU_EGP_4_PR_POS 0
//! Field PR - Pointer Ready
#define IRNICR_CPU_EGP_4_PR_MASK 0x1u

//! Field DR - Descriptor Ready
#define IRNICR_CPU_EGP_4_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_CPU_EGP_4_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_CPU_EGP_4 Register IRNEN_CPU_EGP_4 - CPU Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_CPU_EGP_4 0x14028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_CPU_EGP_4 0x190D4028u

//! Register Reset Value
#define IRNEN_CPU_EGP_4_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNEN_CPU_EGP_4_PR_POS 0
//! Field PR - Pointer Ready
#define IRNEN_CPU_EGP_4_PR_MASK 0x1u
//! Constant DIS - DIS
#define CONST_IRNEN_CPU_EGP_4_PR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_CPU_EGP_4_PR_EN 0x1

//! Field DR - Descriptor Ready
#define IRNEN_CPU_EGP_4_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_CPU_EGP_4_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_CPU_EGP_4_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_CPU_EGP_4_DR_EN 0x1

//! @}

//! \defgroup DPTR_CPU_EGP_4 Register DPTR_CPU_EGP_4 - Special CPU Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_CPU_EGP_4 0x14030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_CPU_EGP_4 0x190D4030u

//! Register Reset Value
#define DPTR_CPU_EGP_4_RST 0x0000001Fu

//! Field ND - Number of Descriptors
#define DPTR_CPU_EGP_4_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_CPU_EGP_4_ND_MASK 0x1Fu

//! Field DPTR - Descriptor Pointer
#define DPTR_CPU_EGP_4_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_CPU_EGP_4_DPTR_MASK 0x1F0000u

//! @}

//! \defgroup BPRC_CPU_EGP_4 Register BPRC_CPU_EGP_4 - Egress Port Buffer Pointer Return counter
//! @{

//! Register Offset (relative)
#define BPRC_CPU_EGP_4 0x14034
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_BPRC_CPU_EGP_4 0x190D4034u

//! Register Reset Value
#define BPRC_CPU_EGP_4_RST 0x00000000u

//! Field BPRC - Per Port Buffer Pointer Return Counter
#define BPRC_CPU_EGP_4_BPRC_POS 0
//! Field BPRC - Per Port Buffer Pointer Return Counter
#define BPRC_CPU_EGP_4_BPRC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup BRPTR_SCPU_EGP_4 Register BRPTR_SCPU_EGP_4 - Special CPU Egress Port Buffer Return Pointer
//! @{

//! Register Offset (relative)
#define BRPTR_SCPU_EGP_4 0x14038
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_BRPTR_SCPU_EGP_4 0x190D4038u

//! Register Reset Value
#define BRPTR_SCPU_EGP_4_RST 0x00000000u

//! Field PTRBR - Pointer of Buffer Return
#define BRPTR_SCPU_EGP_4_PTRBR_POS 0
//! Field PTRBR - Pointer of Buffer Return
#define BRPTR_SCPU_EGP_4_PTRBR_MASK 0x1Fu

//! @}

//! \defgroup PTR_RTN_DW2_EP2_0_CPU_EGP_4 Register PTR_RTN_DW2_EP2_0_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_0_CPU_EGP_4 0x14100
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_0_CPU_EGP_4 0x190D4100u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_0_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_0_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_0_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_0_CPU_EGP_4 Register PTR_RTN_DW3_EP2_0_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_0_CPU_EGP_4 0x14104
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_0_CPU_EGP_4 0x190D4104u

//! Register Reset Value
#define PTR_RTN_DW3_EP2_0_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_0_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_0_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_0_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_0_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_1_CPU_EGP_4 Register PTR_RTN_DW2_EP2_1_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_1_CPU_EGP_4 0x14108
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_1_CPU_EGP_4 0x190D4108u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_1_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_1_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_1_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_1_CPU_EGP_4 Register PTR_RTN_DW3_EP2_1_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_1_CPU_EGP_4 0x1410C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_1_CPU_EGP_4 0x190D410Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP2_1_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_1_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_1_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_1_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_1_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_2_CPU_EGP_4 Register PTR_RTN_DW2_EP2_2_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_2_CPU_EGP_4 0x14110
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_2_CPU_EGP_4 0x190D4110u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_2_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_2_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_2_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_2_CPU_EGP_4 Register PTR_RTN_DW3_EP2_2_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_2_CPU_EGP_4 0x14114
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_2_CPU_EGP_4 0x190D4114u

//! Register Reset Value
#define PTR_RTN_DW3_EP2_2_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_2_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_2_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_2_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_2_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_3_CPU_EGP_4 Register PTR_RTN_DW2_EP2_3_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_3_CPU_EGP_4 0x14118
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_3_CPU_EGP_4 0x190D4118u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_3_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_3_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_3_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_3_CPU_EGP_4 Register PTR_RTN_DW3_EP2_3_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_3_CPU_EGP_4 0x1411C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_3_CPU_EGP_4 0x190D411Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP2_3_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_3_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_3_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_3_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_3_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_4_CPU_EGP_4 Register PTR_RTN_DW2_EP2_4_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_4_CPU_EGP_4 0x14120
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_4_CPU_EGP_4 0x190D4120u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_4_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_4_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_4_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_4_CPU_EGP_4 Register PTR_RTN_DW3_EP2_4_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_4_CPU_EGP_4 0x14124
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_4_CPU_EGP_4 0x190D4124u

//! Register Reset Value
#define PTR_RTN_DW3_EP2_4_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_4_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_4_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_4_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_4_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_5_CPU_EGP_4 Register PTR_RTN_DW2_EP2_5_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_5_CPU_EGP_4 0x14128
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_5_CPU_EGP_4 0x190D4128u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_5_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_5_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_5_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_5_CPU_EGP_4 Register PTR_RTN_DW3_EP2_5_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_5_CPU_EGP_4 0x1412C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_5_CPU_EGP_4 0x190D412Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP2_5_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_5_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_5_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_5_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_5_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_6_CPU_EGP_4 Register PTR_RTN_DW2_EP2_6_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_6_CPU_EGP_4 0x14130
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_6_CPU_EGP_4 0x190D4130u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_6_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_6_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_6_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_6_CPU_EGP_4 Register PTR_RTN_DW3_EP2_6_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_6_CPU_EGP_4 0x14134
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_6_CPU_EGP_4 0x190D4134u

//! Register Reset Value
#define PTR_RTN_DW3_EP2_6_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_6_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_6_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_6_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_6_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_7_CPU_EGP_4 Register PTR_RTN_DW2_EP2_7_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_7_CPU_EGP_4 0x14138
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_7_CPU_EGP_4 0x190D4138u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_7_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_7_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_7_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_7_CPU_EGP_4 Register PTR_RTN_DW3_EP2_7_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_7_CPU_EGP_4 0x1413C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_7_CPU_EGP_4 0x190D413Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP2_7_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_7_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_7_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_7_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_7_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_8_CPU_EGP_4 Register PTR_RTN_DW2_EP2_8_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_8_CPU_EGP_4 0x14140
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_8_CPU_EGP_4 0x190D4140u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_8_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_8_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_8_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_8_CPU_EGP_4 Register PTR_RTN_DW3_EP2_8_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_8_CPU_EGP_4 0x14144
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_8_CPU_EGP_4 0x190D4144u

//! Register Reset Value
#define PTR_RTN_DW3_EP2_8_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_8_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_8_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_8_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_8_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_9_CPU_EGP_4 Register PTR_RTN_DW2_EP2_9_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_9_CPU_EGP_4 0x14148
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_9_CPU_EGP_4 0x190D4148u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_9_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_9_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_9_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_9_CPU_EGP_4 Register PTR_RTN_DW3_EP2_9_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_9_CPU_EGP_4 0x1414C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_9_CPU_EGP_4 0x190D414Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP2_9_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_9_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_9_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_9_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_9_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_10_CPU_EGP_4 Register PTR_RTN_DW2_EP2_10_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_10_CPU_EGP_4 0x14150
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_10_CPU_EGP_4 0x190D4150u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_10_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_10_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_10_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_10_CPU_EGP_4 Register PTR_RTN_DW3_EP2_10_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_10_CPU_EGP_4 0x14154
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_10_CPU_EGP_4 0x190D4154u

//! Register Reset Value
#define PTR_RTN_DW3_EP2_10_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_10_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_10_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_10_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_10_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_11_CPU_EGP_4 Register PTR_RTN_DW2_EP2_11_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_11_CPU_EGP_4 0x14158
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_11_CPU_EGP_4 0x190D4158u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_11_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_11_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_11_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_11_CPU_EGP_4 Register PTR_RTN_DW3_EP2_11_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_11_CPU_EGP_4 0x1415C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_11_CPU_EGP_4 0x190D415Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP2_11_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_11_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_11_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_11_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_11_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_12_CPU_EGP_4 Register PTR_RTN_DW2_EP2_12_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_12_CPU_EGP_4 0x14160
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_12_CPU_EGP_4 0x190D4160u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_12_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_12_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_12_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_12_CPU_EGP_4 Register PTR_RTN_DW3_EP2_12_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_12_CPU_EGP_4 0x14164
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_12_CPU_EGP_4 0x190D4164u

//! Register Reset Value
#define PTR_RTN_DW3_EP2_12_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_12_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_12_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_12_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_12_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_13_CPU_EGP_4 Register PTR_RTN_DW2_EP2_13_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_13_CPU_EGP_4 0x14168
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_13_CPU_EGP_4 0x190D4168u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_13_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_13_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_13_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_13_CPU_EGP_4 Register PTR_RTN_DW3_EP2_13_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_13_CPU_EGP_4 0x1416C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_13_CPU_EGP_4 0x190D416Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP2_13_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_13_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_13_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_13_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_13_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_14_CPU_EGP_4 Register PTR_RTN_DW2_EP2_14_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_14_CPU_EGP_4 0x14170
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_14_CPU_EGP_4 0x190D4170u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_14_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_14_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_14_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_14_CPU_EGP_4 Register PTR_RTN_DW3_EP2_14_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_14_CPU_EGP_4 0x14174
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_14_CPU_EGP_4 0x190D4174u

//! Register Reset Value
#define PTR_RTN_DW3_EP2_14_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_14_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_14_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_14_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_14_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_15_CPU_EGP_4 Register PTR_RTN_DW2_EP2_15_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_15_CPU_EGP_4 0x14178
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_15_CPU_EGP_4 0x190D4178u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_15_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_15_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_15_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_15_CPU_EGP_4 Register PTR_RTN_DW3_EP2_15_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_15_CPU_EGP_4 0x1417C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_15_CPU_EGP_4 0x190D417Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP2_15_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_15_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_15_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_15_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_15_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_16_CPU_EGP_4 Register PTR_RTN_DW2_EP2_16_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_16_CPU_EGP_4 0x14180
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_16_CPU_EGP_4 0x190D4180u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_16_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_16_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_16_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_16_CPU_EGP_4 Register PTR_RTN_DW3_EP2_16_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_16_CPU_EGP_4 0x14184
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_16_CPU_EGP_4 0x190D4184u

//! Register Reset Value
#define PTR_RTN_DW3_EP2_16_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_16_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_16_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_16_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_16_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_17_CPU_EGP_4 Register PTR_RTN_DW2_EP2_17_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_17_CPU_EGP_4 0x14188
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_17_CPU_EGP_4 0x190D4188u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_17_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_17_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_17_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_17_CPU_EGP_4 Register PTR_RTN_DW3_EP2_17_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_17_CPU_EGP_4 0x1418C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_17_CPU_EGP_4 0x190D418Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP2_17_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_17_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_17_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_17_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_17_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_18_CPU_EGP_4 Register PTR_RTN_DW2_EP2_18_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_18_CPU_EGP_4 0x14190
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_18_CPU_EGP_4 0x190D4190u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_18_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_18_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_18_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_18_CPU_EGP_4 Register PTR_RTN_DW3_EP2_18_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_18_CPU_EGP_4 0x14194
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_18_CPU_EGP_4 0x190D4194u

//! Register Reset Value
#define PTR_RTN_DW3_EP2_18_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_18_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_18_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_18_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_18_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_19_CPU_EGP_4 Register PTR_RTN_DW2_EP2_19_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_19_CPU_EGP_4 0x14198
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_19_CPU_EGP_4 0x190D4198u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_19_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_19_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_19_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_19_CPU_EGP_4 Register PTR_RTN_DW3_EP2_19_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_19_CPU_EGP_4 0x1419C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_19_CPU_EGP_4 0x190D419Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP2_19_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_19_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_19_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_19_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_19_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_20_CPU_EGP_4 Register PTR_RTN_DW2_EP2_20_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_20_CPU_EGP_4 0x141A0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_20_CPU_EGP_4 0x190D41A0u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_20_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_20_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_20_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_20_CPU_EGP_4 Register PTR_RTN_DW3_EP2_20_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_20_CPU_EGP_4 0x141A4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_20_CPU_EGP_4 0x190D41A4u

//! Register Reset Value
#define PTR_RTN_DW3_EP2_20_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_20_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_20_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_20_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_20_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_21_CPU_EGP_4 Register PTR_RTN_DW2_EP2_21_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_21_CPU_EGP_4 0x141A8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_21_CPU_EGP_4 0x190D41A8u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_21_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_21_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_21_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_21_CPU_EGP_4 Register PTR_RTN_DW3_EP2_21_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_21_CPU_EGP_4 0x141AC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_21_CPU_EGP_4 0x190D41ACu

//! Register Reset Value
#define PTR_RTN_DW3_EP2_21_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_21_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_21_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_21_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_21_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_22_CPU_EGP_4 Register PTR_RTN_DW2_EP2_22_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_22_CPU_EGP_4 0x141B0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_22_CPU_EGP_4 0x190D41B0u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_22_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_22_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_22_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_22_CPU_EGP_4 Register PTR_RTN_DW3_EP2_22_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_22_CPU_EGP_4 0x141B4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_22_CPU_EGP_4 0x190D41B4u

//! Register Reset Value
#define PTR_RTN_DW3_EP2_22_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_22_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_22_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_22_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_22_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_23_CPU_EGP_4 Register PTR_RTN_DW2_EP2_23_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_23_CPU_EGP_4 0x141B8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_23_CPU_EGP_4 0x190D41B8u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_23_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_23_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_23_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_23_CPU_EGP_4 Register PTR_RTN_DW3_EP2_23_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_23_CPU_EGP_4 0x141BC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_23_CPU_EGP_4 0x190D41BCu

//! Register Reset Value
#define PTR_RTN_DW3_EP2_23_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_23_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_23_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_23_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_23_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_24_CPU_EGP_4 Register PTR_RTN_DW2_EP2_24_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_24_CPU_EGP_4 0x141C0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_24_CPU_EGP_4 0x190D41C0u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_24_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_24_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_24_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_24_CPU_EGP_4 Register PTR_RTN_DW3_EP2_24_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_24_CPU_EGP_4 0x141C4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_24_CPU_EGP_4 0x190D41C4u

//! Register Reset Value
#define PTR_RTN_DW3_EP2_24_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_24_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_24_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_24_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_24_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_25_CPU_EGP_4 Register PTR_RTN_DW2_EP2_25_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_25_CPU_EGP_4 0x141C8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_25_CPU_EGP_4 0x190D41C8u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_25_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_25_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_25_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_25_CPU_EGP_4 Register PTR_RTN_DW3_EP2_25_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_25_CPU_EGP_4 0x141CC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_25_CPU_EGP_4 0x190D41CCu

//! Register Reset Value
#define PTR_RTN_DW3_EP2_25_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_25_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_25_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_25_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_25_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_26_CPU_EGP_4 Register PTR_RTN_DW2_EP2_26_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_26_CPU_EGP_4 0x141D0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_26_CPU_EGP_4 0x190D41D0u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_26_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_26_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_26_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_26_CPU_EGP_4 Register PTR_RTN_DW3_EP2_26_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_26_CPU_EGP_4 0x141D4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_26_CPU_EGP_4 0x190D41D4u

//! Register Reset Value
#define PTR_RTN_DW3_EP2_26_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_26_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_26_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_26_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_26_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_27_CPU_EGP_4 Register PTR_RTN_DW2_EP2_27_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_27_CPU_EGP_4 0x141D8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_27_CPU_EGP_4 0x190D41D8u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_27_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_27_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_27_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_27_CPU_EGP_4 Register PTR_RTN_DW3_EP2_27_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_27_CPU_EGP_4 0x141DC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_27_CPU_EGP_4 0x190D41DCu

//! Register Reset Value
#define PTR_RTN_DW3_EP2_27_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_27_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_27_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_27_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_27_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_28_CPU_EGP_4 Register PTR_RTN_DW2_EP2_28_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_28_CPU_EGP_4 0x141E0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_28_CPU_EGP_4 0x190D41E0u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_28_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_28_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_28_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_28_CPU_EGP_4 Register PTR_RTN_DW3_EP2_28_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_28_CPU_EGP_4 0x141E4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_28_CPU_EGP_4 0x190D41E4u

//! Register Reset Value
#define PTR_RTN_DW3_EP2_28_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_28_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_28_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_28_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_28_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_29_CPU_EGP_4 Register PTR_RTN_DW2_EP2_29_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_29_CPU_EGP_4 0x141E8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_29_CPU_EGP_4 0x190D41E8u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_29_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_29_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_29_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_29_CPU_EGP_4 Register PTR_RTN_DW3_EP2_29_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_29_CPU_EGP_4 0x141EC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_29_CPU_EGP_4 0x190D41ECu

//! Register Reset Value
#define PTR_RTN_DW3_EP2_29_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_29_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_29_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_29_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_29_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_30_CPU_EGP_4 Register PTR_RTN_DW2_EP2_30_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_30_CPU_EGP_4 0x141F0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_30_CPU_EGP_4 0x190D41F0u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_30_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_30_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_30_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_30_CPU_EGP_4 Register PTR_RTN_DW3_EP2_30_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_30_CPU_EGP_4 0x141F4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_30_CPU_EGP_4 0x190D41F4u

//! Register Reset Value
#define PTR_RTN_DW3_EP2_30_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_30_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_30_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_30_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_30_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP2_31_CPU_EGP_4 Register PTR_RTN_DW2_EP2_31_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP2_31_CPU_EGP_4 0x141F8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP2_31_CPU_EGP_4 0x190D41F8u

//! Register Reset Value
#define PTR_RTN_DW2_EP2_31_CPU_EGP_4_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_31_CPU_EGP_4_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP2_31_CPU_EGP_4_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP2_31_CPU_EGP_4 Register PTR_RTN_DW3_EP2_31_CPU_EGP_4 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP2_31_CPU_EGP_4 0x141FC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP2_31_CPU_EGP_4 0x190D41FCu

//! Register Reset Value
#define PTR_RTN_DW3_EP2_31_CPU_EGP_4_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_31_CPU_EGP_4_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_31_CPU_EGP_4_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_31_CPU_EGP_4_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP2_31_CPU_EGP_4_POLICY_MASK 0x700000u

//! @}

//! \defgroup DESC0_EP4_0_CPU_EGP_4 Register DESC0_EP4_0_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_0_CPU_EGP_4 0x14200
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_0_CPU_EGP_4 0x190D4200u

//! Register Reset Value
#define DESC0_EP4_0_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_0_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_0_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_0_CPU_EGP_4 Register DESC1_EP4_0_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_0_CPU_EGP_4 0x14204
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_0_CPU_EGP_4 0x190D4204u

//! Register Reset Value
#define DESC1_EP4_0_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_0_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_0_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_0_CPU_EGP_4 Register DESC2_EP4_0_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_0_CPU_EGP_4 0x14208
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_0_CPU_EGP_4 0x190D4208u

//! Register Reset Value
#define DESC2_EP4_0_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_0_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_0_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_0_CPU_EGP_4 Register DESC3_EP4_0_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_0_CPU_EGP_4 0x1420C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_0_CPU_EGP_4 0x190D420Cu

//! Register Reset Value
#define DESC3_EP4_0_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_0_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_0_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_1_CPU_EGP_4 Register DESC0_EP4_1_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_1_CPU_EGP_4 0x14210
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_1_CPU_EGP_4 0x190D4210u

//! Register Reset Value
#define DESC0_EP4_1_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_1_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_1_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_1_CPU_EGP_4 Register DESC1_EP4_1_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_1_CPU_EGP_4 0x14214
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_1_CPU_EGP_4 0x190D4214u

//! Register Reset Value
#define DESC1_EP4_1_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_1_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_1_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_1_CPU_EGP_4 Register DESC2_EP4_1_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_1_CPU_EGP_4 0x14218
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_1_CPU_EGP_4 0x190D4218u

//! Register Reset Value
#define DESC2_EP4_1_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_1_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_1_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_1_CPU_EGP_4 Register DESC3_EP4_1_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_1_CPU_EGP_4 0x1421C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_1_CPU_EGP_4 0x190D421Cu

//! Register Reset Value
#define DESC3_EP4_1_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_1_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_1_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_2_CPU_EGP_4 Register DESC0_EP4_2_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_2_CPU_EGP_4 0x14220
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_2_CPU_EGP_4 0x190D4220u

//! Register Reset Value
#define DESC0_EP4_2_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_2_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_2_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_2_CPU_EGP_4 Register DESC1_EP4_2_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_2_CPU_EGP_4 0x14224
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_2_CPU_EGP_4 0x190D4224u

//! Register Reset Value
#define DESC1_EP4_2_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_2_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_2_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_2_CPU_EGP_4 Register DESC2_EP4_2_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_2_CPU_EGP_4 0x14228
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_2_CPU_EGP_4 0x190D4228u

//! Register Reset Value
#define DESC2_EP4_2_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_2_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_2_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_2_CPU_EGP_4 Register DESC3_EP4_2_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_2_CPU_EGP_4 0x1422C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_2_CPU_EGP_4 0x190D422Cu

//! Register Reset Value
#define DESC3_EP4_2_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_2_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_2_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_3_CPU_EGP_4 Register DESC0_EP4_3_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_3_CPU_EGP_4 0x14230
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_3_CPU_EGP_4 0x190D4230u

//! Register Reset Value
#define DESC0_EP4_3_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_3_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_3_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_3_CPU_EGP_4 Register DESC1_EP4_3_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_3_CPU_EGP_4 0x14234
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_3_CPU_EGP_4 0x190D4234u

//! Register Reset Value
#define DESC1_EP4_3_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_3_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_3_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_3_CPU_EGP_4 Register DESC2_EP4_3_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_3_CPU_EGP_4 0x14238
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_3_CPU_EGP_4 0x190D4238u

//! Register Reset Value
#define DESC2_EP4_3_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_3_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_3_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_3_CPU_EGP_4 Register DESC3_EP4_3_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_3_CPU_EGP_4 0x1423C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_3_CPU_EGP_4 0x190D423Cu

//! Register Reset Value
#define DESC3_EP4_3_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_3_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_3_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_4_CPU_EGP_4 Register DESC0_EP4_4_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_4_CPU_EGP_4 0x14240
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_4_CPU_EGP_4 0x190D4240u

//! Register Reset Value
#define DESC0_EP4_4_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_4_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_4_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_4_CPU_EGP_4 Register DESC1_EP4_4_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_4_CPU_EGP_4 0x14244
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_4_CPU_EGP_4 0x190D4244u

//! Register Reset Value
#define DESC1_EP4_4_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_4_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_4_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_4_CPU_EGP_4 Register DESC2_EP4_4_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_4_CPU_EGP_4 0x14248
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_4_CPU_EGP_4 0x190D4248u

//! Register Reset Value
#define DESC2_EP4_4_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_4_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_4_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_4_CPU_EGP_4 Register DESC3_EP4_4_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_4_CPU_EGP_4 0x1424C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_4_CPU_EGP_4 0x190D424Cu

//! Register Reset Value
#define DESC3_EP4_4_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_4_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_4_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_5_CPU_EGP_4 Register DESC0_EP4_5_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_5_CPU_EGP_4 0x14250
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_5_CPU_EGP_4 0x190D4250u

//! Register Reset Value
#define DESC0_EP4_5_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_5_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_5_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_5_CPU_EGP_4 Register DESC1_EP4_5_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_5_CPU_EGP_4 0x14254
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_5_CPU_EGP_4 0x190D4254u

//! Register Reset Value
#define DESC1_EP4_5_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_5_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_5_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_5_CPU_EGP_4 Register DESC2_EP4_5_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_5_CPU_EGP_4 0x14258
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_5_CPU_EGP_4 0x190D4258u

//! Register Reset Value
#define DESC2_EP4_5_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_5_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_5_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_5_CPU_EGP_4 Register DESC3_EP4_5_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_5_CPU_EGP_4 0x1425C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_5_CPU_EGP_4 0x190D425Cu

//! Register Reset Value
#define DESC3_EP4_5_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_5_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_5_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_6_CPU_EGP_4 Register DESC0_EP4_6_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_6_CPU_EGP_4 0x14260
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_6_CPU_EGP_4 0x190D4260u

//! Register Reset Value
#define DESC0_EP4_6_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_6_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_6_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_6_CPU_EGP_4 Register DESC1_EP4_6_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_6_CPU_EGP_4 0x14264
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_6_CPU_EGP_4 0x190D4264u

//! Register Reset Value
#define DESC1_EP4_6_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_6_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_6_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_6_CPU_EGP_4 Register DESC2_EP4_6_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_6_CPU_EGP_4 0x14268
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_6_CPU_EGP_4 0x190D4268u

//! Register Reset Value
#define DESC2_EP4_6_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_6_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_6_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_6_CPU_EGP_4 Register DESC3_EP4_6_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_6_CPU_EGP_4 0x1426C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_6_CPU_EGP_4 0x190D426Cu

//! Register Reset Value
#define DESC3_EP4_6_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_6_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_6_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_7_CPU_EGP_4 Register DESC0_EP4_7_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_7_CPU_EGP_4 0x14270
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_7_CPU_EGP_4 0x190D4270u

//! Register Reset Value
#define DESC0_EP4_7_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_7_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_7_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_7_CPU_EGP_4 Register DESC1_EP4_7_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_7_CPU_EGP_4 0x14274
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_7_CPU_EGP_4 0x190D4274u

//! Register Reset Value
#define DESC1_EP4_7_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_7_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_7_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_7_CPU_EGP_4 Register DESC2_EP4_7_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_7_CPU_EGP_4 0x14278
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_7_CPU_EGP_4 0x190D4278u

//! Register Reset Value
#define DESC2_EP4_7_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_7_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_7_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_7_CPU_EGP_4 Register DESC3_EP4_7_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_7_CPU_EGP_4 0x1427C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_7_CPU_EGP_4 0x190D427Cu

//! Register Reset Value
#define DESC3_EP4_7_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_7_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_7_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_8_CPU_EGP_4 Register DESC0_EP4_8_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_8_CPU_EGP_4 0x14280
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_8_CPU_EGP_4 0x190D4280u

//! Register Reset Value
#define DESC0_EP4_8_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_8_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_8_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_8_CPU_EGP_4 Register DESC1_EP4_8_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_8_CPU_EGP_4 0x14284
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_8_CPU_EGP_4 0x190D4284u

//! Register Reset Value
#define DESC1_EP4_8_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_8_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_8_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_8_CPU_EGP_4 Register DESC2_EP4_8_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_8_CPU_EGP_4 0x14288
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_8_CPU_EGP_4 0x190D4288u

//! Register Reset Value
#define DESC2_EP4_8_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_8_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_8_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_8_CPU_EGP_4 Register DESC3_EP4_8_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_8_CPU_EGP_4 0x1428C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_8_CPU_EGP_4 0x190D428Cu

//! Register Reset Value
#define DESC3_EP4_8_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_8_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_8_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_9_CPU_EGP_4 Register DESC0_EP4_9_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_9_CPU_EGP_4 0x14290
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_9_CPU_EGP_4 0x190D4290u

//! Register Reset Value
#define DESC0_EP4_9_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_9_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_9_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_9_CPU_EGP_4 Register DESC1_EP4_9_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_9_CPU_EGP_4 0x14294
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_9_CPU_EGP_4 0x190D4294u

//! Register Reset Value
#define DESC1_EP4_9_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_9_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_9_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_9_CPU_EGP_4 Register DESC2_EP4_9_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_9_CPU_EGP_4 0x14298
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_9_CPU_EGP_4 0x190D4298u

//! Register Reset Value
#define DESC2_EP4_9_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_9_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_9_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_9_CPU_EGP_4 Register DESC3_EP4_9_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_9_CPU_EGP_4 0x1429C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_9_CPU_EGP_4 0x190D429Cu

//! Register Reset Value
#define DESC3_EP4_9_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_9_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_9_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_10_CPU_EGP_4 Register DESC0_EP4_10_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_10_CPU_EGP_4 0x142A0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_10_CPU_EGP_4 0x190D42A0u

//! Register Reset Value
#define DESC0_EP4_10_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_10_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_10_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_10_CPU_EGP_4 Register DESC1_EP4_10_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_10_CPU_EGP_4 0x142A4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_10_CPU_EGP_4 0x190D42A4u

//! Register Reset Value
#define DESC1_EP4_10_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_10_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_10_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_10_CPU_EGP_4 Register DESC2_EP4_10_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_10_CPU_EGP_4 0x142A8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_10_CPU_EGP_4 0x190D42A8u

//! Register Reset Value
#define DESC2_EP4_10_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_10_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_10_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_10_CPU_EGP_4 Register DESC3_EP4_10_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_10_CPU_EGP_4 0x142AC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_10_CPU_EGP_4 0x190D42ACu

//! Register Reset Value
#define DESC3_EP4_10_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_10_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_10_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_11_CPU_EGP_4 Register DESC0_EP4_11_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_11_CPU_EGP_4 0x142B0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_11_CPU_EGP_4 0x190D42B0u

//! Register Reset Value
#define DESC0_EP4_11_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_11_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_11_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_11_CPU_EGP_4 Register DESC1_EP4_11_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_11_CPU_EGP_4 0x142B4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_11_CPU_EGP_4 0x190D42B4u

//! Register Reset Value
#define DESC1_EP4_11_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_11_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_11_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_11_CPU_EGP_4 Register DESC2_EP4_11_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_11_CPU_EGP_4 0x142B8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_11_CPU_EGP_4 0x190D42B8u

//! Register Reset Value
#define DESC2_EP4_11_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_11_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_11_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_11_CPU_EGP_4 Register DESC3_EP4_11_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_11_CPU_EGP_4 0x142BC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_11_CPU_EGP_4 0x190D42BCu

//! Register Reset Value
#define DESC3_EP4_11_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_11_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_11_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_12_CPU_EGP_4 Register DESC0_EP4_12_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_12_CPU_EGP_4 0x142C0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_12_CPU_EGP_4 0x190D42C0u

//! Register Reset Value
#define DESC0_EP4_12_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_12_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_12_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_12_CPU_EGP_4 Register DESC1_EP4_12_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_12_CPU_EGP_4 0x142C4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_12_CPU_EGP_4 0x190D42C4u

//! Register Reset Value
#define DESC1_EP4_12_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_12_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_12_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_12_CPU_EGP_4 Register DESC2_EP4_12_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_12_CPU_EGP_4 0x142C8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_12_CPU_EGP_4 0x190D42C8u

//! Register Reset Value
#define DESC2_EP4_12_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_12_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_12_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_12_CPU_EGP_4 Register DESC3_EP4_12_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_12_CPU_EGP_4 0x142CC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_12_CPU_EGP_4 0x190D42CCu

//! Register Reset Value
#define DESC3_EP4_12_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_12_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_12_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_13_CPU_EGP_4 Register DESC0_EP4_13_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_13_CPU_EGP_4 0x142D0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_13_CPU_EGP_4 0x190D42D0u

//! Register Reset Value
#define DESC0_EP4_13_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_13_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_13_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_13_CPU_EGP_4 Register DESC1_EP4_13_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_13_CPU_EGP_4 0x142D4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_13_CPU_EGP_4 0x190D42D4u

//! Register Reset Value
#define DESC1_EP4_13_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_13_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_13_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_13_CPU_EGP_4 Register DESC2_EP4_13_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_13_CPU_EGP_4 0x142D8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_13_CPU_EGP_4 0x190D42D8u

//! Register Reset Value
#define DESC2_EP4_13_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_13_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_13_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_13_CPU_EGP_4 Register DESC3_EP4_13_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_13_CPU_EGP_4 0x142DC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_13_CPU_EGP_4 0x190D42DCu

//! Register Reset Value
#define DESC3_EP4_13_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_13_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_13_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_14_CPU_EGP_4 Register DESC0_EP4_14_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_14_CPU_EGP_4 0x142E0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_14_CPU_EGP_4 0x190D42E0u

//! Register Reset Value
#define DESC0_EP4_14_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_14_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_14_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_14_CPU_EGP_4 Register DESC1_EP4_14_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_14_CPU_EGP_4 0x142E4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_14_CPU_EGP_4 0x190D42E4u

//! Register Reset Value
#define DESC1_EP4_14_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_14_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_14_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_14_CPU_EGP_4 Register DESC2_EP4_14_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_14_CPU_EGP_4 0x142E8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_14_CPU_EGP_4 0x190D42E8u

//! Register Reset Value
#define DESC2_EP4_14_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_14_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_14_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_14_CPU_EGP_4 Register DESC3_EP4_14_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_14_CPU_EGP_4 0x142EC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_14_CPU_EGP_4 0x190D42ECu

//! Register Reset Value
#define DESC3_EP4_14_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_14_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_14_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_15_CPU_EGP_4 Register DESC0_EP4_15_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_15_CPU_EGP_4 0x142F0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_15_CPU_EGP_4 0x190D42F0u

//! Register Reset Value
#define DESC0_EP4_15_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_15_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_15_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_15_CPU_EGP_4 Register DESC1_EP4_15_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_15_CPU_EGP_4 0x142F4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_15_CPU_EGP_4 0x190D42F4u

//! Register Reset Value
#define DESC1_EP4_15_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_15_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_15_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_15_CPU_EGP_4 Register DESC2_EP4_15_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_15_CPU_EGP_4 0x142F8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_15_CPU_EGP_4 0x190D42F8u

//! Register Reset Value
#define DESC2_EP4_15_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_15_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_15_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_15_CPU_EGP_4 Register DESC3_EP4_15_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_15_CPU_EGP_4 0x142FC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_15_CPU_EGP_4 0x190D42FCu

//! Register Reset Value
#define DESC3_EP4_15_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_15_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_15_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_16_CPU_EGP_4 Register DESC0_EP4_16_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_16_CPU_EGP_4 0x14300
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_16_CPU_EGP_4 0x190D4300u

//! Register Reset Value
#define DESC0_EP4_16_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_16_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_16_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_16_CPU_EGP_4 Register DESC1_EP4_16_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_16_CPU_EGP_4 0x14304
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_16_CPU_EGP_4 0x190D4304u

//! Register Reset Value
#define DESC1_EP4_16_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_16_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_16_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_16_CPU_EGP_4 Register DESC2_EP4_16_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_16_CPU_EGP_4 0x14308
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_16_CPU_EGP_4 0x190D4308u

//! Register Reset Value
#define DESC2_EP4_16_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_16_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_16_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_16_CPU_EGP_4 Register DESC3_EP4_16_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_16_CPU_EGP_4 0x1430C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_16_CPU_EGP_4 0x190D430Cu

//! Register Reset Value
#define DESC3_EP4_16_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_16_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_16_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_17_CPU_EGP_4 Register DESC0_EP4_17_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_17_CPU_EGP_4 0x14310
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_17_CPU_EGP_4 0x190D4310u

//! Register Reset Value
#define DESC0_EP4_17_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_17_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_17_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_17_CPU_EGP_4 Register DESC1_EP4_17_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_17_CPU_EGP_4 0x14314
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_17_CPU_EGP_4 0x190D4314u

//! Register Reset Value
#define DESC1_EP4_17_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_17_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_17_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_17_CPU_EGP_4 Register DESC2_EP4_17_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_17_CPU_EGP_4 0x14318
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_17_CPU_EGP_4 0x190D4318u

//! Register Reset Value
#define DESC2_EP4_17_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_17_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_17_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_17_CPU_EGP_4 Register DESC3_EP4_17_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_17_CPU_EGP_4 0x1431C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_17_CPU_EGP_4 0x190D431Cu

//! Register Reset Value
#define DESC3_EP4_17_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_17_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_17_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_18_CPU_EGP_4 Register DESC0_EP4_18_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_18_CPU_EGP_4 0x14320
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_18_CPU_EGP_4 0x190D4320u

//! Register Reset Value
#define DESC0_EP4_18_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_18_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_18_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_18_CPU_EGP_4 Register DESC1_EP4_18_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_18_CPU_EGP_4 0x14324
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_18_CPU_EGP_4 0x190D4324u

//! Register Reset Value
#define DESC1_EP4_18_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_18_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_18_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_18_CPU_EGP_4 Register DESC2_EP4_18_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_18_CPU_EGP_4 0x14328
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_18_CPU_EGP_4 0x190D4328u

//! Register Reset Value
#define DESC2_EP4_18_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_18_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_18_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_18_CPU_EGP_4 Register DESC3_EP4_18_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_18_CPU_EGP_4 0x1432C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_18_CPU_EGP_4 0x190D432Cu

//! Register Reset Value
#define DESC3_EP4_18_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_18_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_18_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_19_CPU_EGP_4 Register DESC0_EP4_19_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_19_CPU_EGP_4 0x14330
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_19_CPU_EGP_4 0x190D4330u

//! Register Reset Value
#define DESC0_EP4_19_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_19_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_19_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_19_CPU_EGP_4 Register DESC1_EP4_19_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_19_CPU_EGP_4 0x14334
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_19_CPU_EGP_4 0x190D4334u

//! Register Reset Value
#define DESC1_EP4_19_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_19_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_19_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_19_CPU_EGP_4 Register DESC2_EP4_19_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_19_CPU_EGP_4 0x14338
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_19_CPU_EGP_4 0x190D4338u

//! Register Reset Value
#define DESC2_EP4_19_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_19_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_19_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_19_CPU_EGP_4 Register DESC3_EP4_19_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_19_CPU_EGP_4 0x1433C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_19_CPU_EGP_4 0x190D433Cu

//! Register Reset Value
#define DESC3_EP4_19_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_19_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_19_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_20_CPU_EGP_4 Register DESC0_EP4_20_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_20_CPU_EGP_4 0x14340
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_20_CPU_EGP_4 0x190D4340u

//! Register Reset Value
#define DESC0_EP4_20_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_20_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_20_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_20_CPU_EGP_4 Register DESC1_EP4_20_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_20_CPU_EGP_4 0x14344
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_20_CPU_EGP_4 0x190D4344u

//! Register Reset Value
#define DESC1_EP4_20_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_20_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_20_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_20_CPU_EGP_4 Register DESC2_EP4_20_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_20_CPU_EGP_4 0x14348
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_20_CPU_EGP_4 0x190D4348u

//! Register Reset Value
#define DESC2_EP4_20_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_20_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_20_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_20_CPU_EGP_4 Register DESC3_EP4_20_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_20_CPU_EGP_4 0x1434C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_20_CPU_EGP_4 0x190D434Cu

//! Register Reset Value
#define DESC3_EP4_20_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_20_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_20_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_21_CPU_EGP_4 Register DESC0_EP4_21_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_21_CPU_EGP_4 0x14350
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_21_CPU_EGP_4 0x190D4350u

//! Register Reset Value
#define DESC0_EP4_21_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_21_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_21_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_21_CPU_EGP_4 Register DESC1_EP4_21_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_21_CPU_EGP_4 0x14354
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_21_CPU_EGP_4 0x190D4354u

//! Register Reset Value
#define DESC1_EP4_21_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_21_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_21_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_21_CPU_EGP_4 Register DESC2_EP4_21_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_21_CPU_EGP_4 0x14358
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_21_CPU_EGP_4 0x190D4358u

//! Register Reset Value
#define DESC2_EP4_21_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_21_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_21_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_21_CPU_EGP_4 Register DESC3_EP4_21_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_21_CPU_EGP_4 0x1435C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_21_CPU_EGP_4 0x190D435Cu

//! Register Reset Value
#define DESC3_EP4_21_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_21_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_21_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_22_CPU_EGP_4 Register DESC0_EP4_22_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_22_CPU_EGP_4 0x14360
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_22_CPU_EGP_4 0x190D4360u

//! Register Reset Value
#define DESC0_EP4_22_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_22_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_22_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_22_CPU_EGP_4 Register DESC1_EP4_22_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_22_CPU_EGP_4 0x14364
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_22_CPU_EGP_4 0x190D4364u

//! Register Reset Value
#define DESC1_EP4_22_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_22_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_22_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_22_CPU_EGP_4 Register DESC2_EP4_22_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_22_CPU_EGP_4 0x14368
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_22_CPU_EGP_4 0x190D4368u

//! Register Reset Value
#define DESC2_EP4_22_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_22_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_22_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_22_CPU_EGP_4 Register DESC3_EP4_22_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_22_CPU_EGP_4 0x1436C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_22_CPU_EGP_4 0x190D436Cu

//! Register Reset Value
#define DESC3_EP4_22_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_22_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_22_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_23_CPU_EGP_4 Register DESC0_EP4_23_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_23_CPU_EGP_4 0x14370
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_23_CPU_EGP_4 0x190D4370u

//! Register Reset Value
#define DESC0_EP4_23_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_23_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_23_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_23_CPU_EGP_4 Register DESC1_EP4_23_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_23_CPU_EGP_4 0x14374
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_23_CPU_EGP_4 0x190D4374u

//! Register Reset Value
#define DESC1_EP4_23_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_23_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_23_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_23_CPU_EGP_4 Register DESC2_EP4_23_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_23_CPU_EGP_4 0x14378
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_23_CPU_EGP_4 0x190D4378u

//! Register Reset Value
#define DESC2_EP4_23_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_23_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_23_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_23_CPU_EGP_4 Register DESC3_EP4_23_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_23_CPU_EGP_4 0x1437C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_23_CPU_EGP_4 0x190D437Cu

//! Register Reset Value
#define DESC3_EP4_23_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_23_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_23_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_24_CPU_EGP_4 Register DESC0_EP4_24_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_24_CPU_EGP_4 0x14380
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_24_CPU_EGP_4 0x190D4380u

//! Register Reset Value
#define DESC0_EP4_24_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_24_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_24_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_24_CPU_EGP_4 Register DESC1_EP4_24_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_24_CPU_EGP_4 0x14384
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_24_CPU_EGP_4 0x190D4384u

//! Register Reset Value
#define DESC1_EP4_24_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_24_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_24_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_24_CPU_EGP_4 Register DESC2_EP4_24_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_24_CPU_EGP_4 0x14388
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_24_CPU_EGP_4 0x190D4388u

//! Register Reset Value
#define DESC2_EP4_24_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_24_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_24_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_24_CPU_EGP_4 Register DESC3_EP4_24_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_24_CPU_EGP_4 0x1438C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_24_CPU_EGP_4 0x190D438Cu

//! Register Reset Value
#define DESC3_EP4_24_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_24_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_24_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_25_CPU_EGP_4 Register DESC0_EP4_25_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_25_CPU_EGP_4 0x14390
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_25_CPU_EGP_4 0x190D4390u

//! Register Reset Value
#define DESC0_EP4_25_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_25_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_25_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_25_CPU_EGP_4 Register DESC1_EP4_25_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_25_CPU_EGP_4 0x14394
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_25_CPU_EGP_4 0x190D4394u

//! Register Reset Value
#define DESC1_EP4_25_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_25_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_25_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_25_CPU_EGP_4 Register DESC2_EP4_25_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_25_CPU_EGP_4 0x14398
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_25_CPU_EGP_4 0x190D4398u

//! Register Reset Value
#define DESC2_EP4_25_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_25_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_25_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_25_CPU_EGP_4 Register DESC3_EP4_25_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_25_CPU_EGP_4 0x1439C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_25_CPU_EGP_4 0x190D439Cu

//! Register Reset Value
#define DESC3_EP4_25_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_25_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_25_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_26_CPU_EGP_4 Register DESC0_EP4_26_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_26_CPU_EGP_4 0x143A0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_26_CPU_EGP_4 0x190D43A0u

//! Register Reset Value
#define DESC0_EP4_26_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_26_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_26_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_26_CPU_EGP_4 Register DESC1_EP4_26_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_26_CPU_EGP_4 0x143A4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_26_CPU_EGP_4 0x190D43A4u

//! Register Reset Value
#define DESC1_EP4_26_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_26_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_26_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_26_CPU_EGP_4 Register DESC2_EP4_26_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_26_CPU_EGP_4 0x143A8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_26_CPU_EGP_4 0x190D43A8u

//! Register Reset Value
#define DESC2_EP4_26_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_26_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_26_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_26_CPU_EGP_4 Register DESC3_EP4_26_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_26_CPU_EGP_4 0x143AC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_26_CPU_EGP_4 0x190D43ACu

//! Register Reset Value
#define DESC3_EP4_26_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_26_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_26_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_27_CPU_EGP_4 Register DESC0_EP4_27_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_27_CPU_EGP_4 0x143B0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_27_CPU_EGP_4 0x190D43B0u

//! Register Reset Value
#define DESC0_EP4_27_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_27_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_27_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_27_CPU_EGP_4 Register DESC1_EP4_27_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_27_CPU_EGP_4 0x143B4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_27_CPU_EGP_4 0x190D43B4u

//! Register Reset Value
#define DESC1_EP4_27_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_27_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_27_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_27_CPU_EGP_4 Register DESC2_EP4_27_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_27_CPU_EGP_4 0x143B8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_27_CPU_EGP_4 0x190D43B8u

//! Register Reset Value
#define DESC2_EP4_27_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_27_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_27_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_27_CPU_EGP_4 Register DESC3_EP4_27_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_27_CPU_EGP_4 0x143BC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_27_CPU_EGP_4 0x190D43BCu

//! Register Reset Value
#define DESC3_EP4_27_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_27_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_27_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_28_CPU_EGP_4 Register DESC0_EP4_28_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_28_CPU_EGP_4 0x143C0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_28_CPU_EGP_4 0x190D43C0u

//! Register Reset Value
#define DESC0_EP4_28_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_28_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_28_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_28_CPU_EGP_4 Register DESC1_EP4_28_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_28_CPU_EGP_4 0x143C4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_28_CPU_EGP_4 0x190D43C4u

//! Register Reset Value
#define DESC1_EP4_28_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_28_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_28_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_28_CPU_EGP_4 Register DESC2_EP4_28_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_28_CPU_EGP_4 0x143C8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_28_CPU_EGP_4 0x190D43C8u

//! Register Reset Value
#define DESC2_EP4_28_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_28_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_28_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_28_CPU_EGP_4 Register DESC3_EP4_28_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_28_CPU_EGP_4 0x143CC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_28_CPU_EGP_4 0x190D43CCu

//! Register Reset Value
#define DESC3_EP4_28_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_28_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_28_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_29_CPU_EGP_4 Register DESC0_EP4_29_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_29_CPU_EGP_4 0x143D0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_29_CPU_EGP_4 0x190D43D0u

//! Register Reset Value
#define DESC0_EP4_29_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_29_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_29_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_29_CPU_EGP_4 Register DESC1_EP4_29_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_29_CPU_EGP_4 0x143D4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_29_CPU_EGP_4 0x190D43D4u

//! Register Reset Value
#define DESC1_EP4_29_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_29_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_29_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_29_CPU_EGP_4 Register DESC2_EP4_29_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_29_CPU_EGP_4 0x143D8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_29_CPU_EGP_4 0x190D43D8u

//! Register Reset Value
#define DESC2_EP4_29_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_29_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_29_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_29_CPU_EGP_4 Register DESC3_EP4_29_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_29_CPU_EGP_4 0x143DC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_29_CPU_EGP_4 0x190D43DCu

//! Register Reset Value
#define DESC3_EP4_29_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_29_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_29_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_30_CPU_EGP_4 Register DESC0_EP4_30_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_30_CPU_EGP_4 0x143E0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_30_CPU_EGP_4 0x190D43E0u

//! Register Reset Value
#define DESC0_EP4_30_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_30_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_30_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_30_CPU_EGP_4 Register DESC1_EP4_30_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_30_CPU_EGP_4 0x143E4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_30_CPU_EGP_4 0x190D43E4u

//! Register Reset Value
#define DESC1_EP4_30_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_30_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_30_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_30_CPU_EGP_4 Register DESC2_EP4_30_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_30_CPU_EGP_4 0x143E8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_30_CPU_EGP_4 0x190D43E8u

//! Register Reset Value
#define DESC2_EP4_30_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_30_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_30_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_30_CPU_EGP_4 Register DESC3_EP4_30_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_30_CPU_EGP_4 0x143EC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_30_CPU_EGP_4 0x190D43ECu

//! Register Reset Value
#define DESC3_EP4_30_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_30_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_30_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP4_31_CPU_EGP_4 Register DESC0_EP4_31_CPU_EGP_4 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP4_31_CPU_EGP_4 0x143F0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP4_31_CPU_EGP_4 0x190D43F0u

//! Register Reset Value
#define DESC0_EP4_31_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_31_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP4_31_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP4_31_CPU_EGP_4 Register DESC1_EP4_31_CPU_EGP_4 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP4_31_CPU_EGP_4 0x143F4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP4_31_CPU_EGP_4 0x190D43F4u

//! Register Reset Value
#define DESC1_EP4_31_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_31_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP4_31_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP4_31_CPU_EGP_4 Register DESC2_EP4_31_CPU_EGP_4 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP4_31_CPU_EGP_4 0x143F8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP4_31_CPU_EGP_4 0x190D43F8u

//! Register Reset Value
#define DESC2_EP4_31_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_31_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP4_31_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP4_31_CPU_EGP_4 Register DESC3_EP4_31_CPU_EGP_4 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP4_31_CPU_EGP_4 0x143FC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP4_31_CPU_EGP_4 0x190D43FCu

//! Register Reset Value
#define DESC3_EP4_31_CPU_EGP_4_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_31_CPU_EGP_4_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP4_31_CPU_EGP_4_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup CFG_ACA_EGP_5 Register CFG_ACA_EGP_5 - CPU ACA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_ACA_EGP_5 0x15000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_ACA_EGP_5 0x190D5000u

//! Register Reset Value
#define CFG_ACA_EGP_5_RST 0x00000000u

//! Field DQREQ - Enable CPU Dequeue Request
#define CFG_ACA_EGP_5_DQREQ_POS 0
//! Field DQREQ - Enable CPU Dequeue Request
#define CFG_ACA_EGP_5_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_ACA_EGP_5_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_ACA_EGP_5_DQREQ_EN 0x1

//! Field BUFRTN - Enable CPU Buffer Return
#define CFG_ACA_EGP_5_BUFRTN_POS 1
//! Field BUFRTN - Enable CPU Buffer Return
#define CFG_ACA_EGP_5_BUFRTN_MASK 0x2u
//! Constant DIS - DIS
#define CONST_CFG_ACA_EGP_5_BUFRTN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_ACA_EGP_5_BUFRTN_EN 0x1

//! Field BFBPEN - Buffer Return Back Pressure Enable
#define CFG_ACA_EGP_5_BFBPEN_POS 2
//! Field BFBPEN - Buffer Return Back Pressure Enable
#define CFG_ACA_EGP_5_BFBPEN_MASK 0x4u
//! Constant DIS - DIS
#define CONST_CFG_ACA_EGP_5_BFBPEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_ACA_EGP_5_BFBPEN_EN 0x1

//! Field DQBPEN - Dequeue Back Pressure Enable
#define CFG_ACA_EGP_5_DQBPEN_POS 3
//! Field DQBPEN - Dequeue Back Pressure Enable
#define CFG_ACA_EGP_5_DQBPEN_MASK 0x8u
//! Constant DIS - DIS
#define CONST_CFG_ACA_EGP_5_DQBPEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_ACA_EGP_5_DQBPEN_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_ACA_EGP_5_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_ACA_EGP_5_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_ACA_EGP_5_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_ACA_EGP_5_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_ACA_EGP_5_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_ACA_EGP_5_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_CPU_EGP_5 Register DQPC_CPU_EGP_5 - CPU Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_CPU_EGP_5 0x15004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_CPU_EGP_5 0x190D5004u

//! Register Reset Value
#define DQPC_CPU_EGP_5_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_CPU_EGP_5_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_CPU_EGP_5_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_CPU_EGP_5 Register IRNCR_CPU_EGP_5 - CPU Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_CPU_EGP_5 0x15020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_CPU_EGP_5 0x190D5020u

//! Register Reset Value
#define IRNCR_CPU_EGP_5_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNCR_CPU_EGP_5_PR_POS 0
//! Field PR - Pointer Ready
#define IRNCR_CPU_EGP_5_PR_MASK 0x1u
//! Constant NUL - NULL
#define CONST_IRNCR_CPU_EGP_5_PR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_CPU_EGP_5_PR_INTOCC 0x1

//! Field DR - Descriptor Ready
#define IRNCR_CPU_EGP_5_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_CPU_EGP_5_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_CPU_EGP_5_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_CPU_EGP_5_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_CPU_EGP_5 Register IRNICR_CPU_EGP_5 - CPU Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_CPU_EGP_5 0x15024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_CPU_EGP_5 0x190D5024u

//! Register Reset Value
#define IRNICR_CPU_EGP_5_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNICR_CPU_EGP_5_PR_POS 0
//! Field PR - Pointer Ready
#define IRNICR_CPU_EGP_5_PR_MASK 0x1u

//! Field DR - Descriptor Ready
#define IRNICR_CPU_EGP_5_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_CPU_EGP_5_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_CPU_EGP_5 Register IRNEN_CPU_EGP_5 - CPU Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_CPU_EGP_5 0x15028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_CPU_EGP_5 0x190D5028u

//! Register Reset Value
#define IRNEN_CPU_EGP_5_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNEN_CPU_EGP_5_PR_POS 0
//! Field PR - Pointer Ready
#define IRNEN_CPU_EGP_5_PR_MASK 0x1u
//! Constant DIS - DIS
#define CONST_IRNEN_CPU_EGP_5_PR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_CPU_EGP_5_PR_EN 0x1

//! Field DR - Descriptor Ready
#define IRNEN_CPU_EGP_5_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_CPU_EGP_5_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_CPU_EGP_5_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_CPU_EGP_5_DR_EN 0x1

//! @}

//! \defgroup DPTR_CPU_EGP_5 Register DPTR_CPU_EGP_5 - Special CPU Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_CPU_EGP_5 0x15030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_CPU_EGP_5 0x190D5030u

//! Register Reset Value
#define DPTR_CPU_EGP_5_RST 0x0000001Fu

//! Field ND - Number of Descriptors
#define DPTR_CPU_EGP_5_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_CPU_EGP_5_ND_MASK 0x1Fu

//! Field DPTR - Descriptor Pointer
#define DPTR_CPU_EGP_5_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_CPU_EGP_5_DPTR_MASK 0x1F0000u

//! @}

//! \defgroup BPRC_CPU_EGP_5 Register BPRC_CPU_EGP_5 - Egress Port Buffer Pointer Return counter
//! @{

//! Register Offset (relative)
#define BPRC_CPU_EGP_5 0x15034
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_BPRC_CPU_EGP_5 0x190D5034u

//! Register Reset Value
#define BPRC_CPU_EGP_5_RST 0x00000000u

//! Field BPRC - Per Port Buffer Pointer Return Counter
#define BPRC_CPU_EGP_5_BPRC_POS 0
//! Field BPRC - Per Port Buffer Pointer Return Counter
#define BPRC_CPU_EGP_5_BPRC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup BRPTR_SCPU_EGP_5 Register BRPTR_SCPU_EGP_5 - Special CPU Egress Port Buffer Return Pointer
//! @{

//! Register Offset (relative)
#define BRPTR_SCPU_EGP_5 0x15038
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_BRPTR_SCPU_EGP_5 0x190D5038u

//! Register Reset Value
#define BRPTR_SCPU_EGP_5_RST 0x00000000u

//! Field PTRBR - Pointer of Buffer Return
#define BRPTR_SCPU_EGP_5_PTRBR_POS 0
//! Field PTRBR - Pointer of Buffer Return
#define BRPTR_SCPU_EGP_5_PTRBR_MASK 0x1Fu

//! @}

//! \defgroup PTR_RTN_DW2_EP3_0_CPU_EGP_5 Register PTR_RTN_DW2_EP3_0_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_0_CPU_EGP_5 0x15100
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_0_CPU_EGP_5 0x190D5100u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_0_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_0_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_0_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_0_CPU_EGP_5 Register PTR_RTN_DW3_EP3_0_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_0_CPU_EGP_5 0x15104
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_0_CPU_EGP_5 0x190D5104u

//! Register Reset Value
#define PTR_RTN_DW3_EP3_0_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_0_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_0_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_0_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_0_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_1_CPU_EGP_5 Register PTR_RTN_DW2_EP3_1_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_1_CPU_EGP_5 0x15108
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_1_CPU_EGP_5 0x190D5108u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_1_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_1_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_1_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_1_CPU_EGP_5 Register PTR_RTN_DW3_EP3_1_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_1_CPU_EGP_5 0x1510C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_1_CPU_EGP_5 0x190D510Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP3_1_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_1_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_1_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_1_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_1_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_2_CPU_EGP_5 Register PTR_RTN_DW2_EP3_2_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_2_CPU_EGP_5 0x15110
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_2_CPU_EGP_5 0x190D5110u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_2_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_2_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_2_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_2_CPU_EGP_5 Register PTR_RTN_DW3_EP3_2_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_2_CPU_EGP_5 0x15114
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_2_CPU_EGP_5 0x190D5114u

//! Register Reset Value
#define PTR_RTN_DW3_EP3_2_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_2_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_2_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_2_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_2_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_3_CPU_EGP_5 Register PTR_RTN_DW2_EP3_3_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_3_CPU_EGP_5 0x15118
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_3_CPU_EGP_5 0x190D5118u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_3_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_3_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_3_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_3_CPU_EGP_5 Register PTR_RTN_DW3_EP3_3_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_3_CPU_EGP_5 0x1511C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_3_CPU_EGP_5 0x190D511Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP3_3_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_3_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_3_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_3_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_3_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_4_CPU_EGP_5 Register PTR_RTN_DW2_EP3_4_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_4_CPU_EGP_5 0x15120
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_4_CPU_EGP_5 0x190D5120u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_4_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_4_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_4_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_4_CPU_EGP_5 Register PTR_RTN_DW3_EP3_4_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_4_CPU_EGP_5 0x15124
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_4_CPU_EGP_5 0x190D5124u

//! Register Reset Value
#define PTR_RTN_DW3_EP3_4_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_4_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_4_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_4_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_4_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_5_CPU_EGP_5 Register PTR_RTN_DW2_EP3_5_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_5_CPU_EGP_5 0x15128
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_5_CPU_EGP_5 0x190D5128u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_5_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_5_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_5_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_5_CPU_EGP_5 Register PTR_RTN_DW3_EP3_5_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_5_CPU_EGP_5 0x1512C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_5_CPU_EGP_5 0x190D512Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP3_5_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_5_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_5_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_5_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_5_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_6_CPU_EGP_5 Register PTR_RTN_DW2_EP3_6_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_6_CPU_EGP_5 0x15130
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_6_CPU_EGP_5 0x190D5130u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_6_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_6_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_6_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_6_CPU_EGP_5 Register PTR_RTN_DW3_EP3_6_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_6_CPU_EGP_5 0x15134
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_6_CPU_EGP_5 0x190D5134u

//! Register Reset Value
#define PTR_RTN_DW3_EP3_6_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_6_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_6_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_6_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_6_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_7_CPU_EGP_5 Register PTR_RTN_DW2_EP3_7_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_7_CPU_EGP_5 0x15138
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_7_CPU_EGP_5 0x190D5138u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_7_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_7_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_7_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_7_CPU_EGP_5 Register PTR_RTN_DW3_EP3_7_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_7_CPU_EGP_5 0x1513C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_7_CPU_EGP_5 0x190D513Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP3_7_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_7_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_7_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_7_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_7_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_8_CPU_EGP_5 Register PTR_RTN_DW2_EP3_8_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_8_CPU_EGP_5 0x15140
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_8_CPU_EGP_5 0x190D5140u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_8_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_8_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_8_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_8_CPU_EGP_5 Register PTR_RTN_DW3_EP3_8_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_8_CPU_EGP_5 0x15144
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_8_CPU_EGP_5 0x190D5144u

//! Register Reset Value
#define PTR_RTN_DW3_EP3_8_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_8_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_8_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_8_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_8_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_9_CPU_EGP_5 Register PTR_RTN_DW2_EP3_9_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_9_CPU_EGP_5 0x15148
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_9_CPU_EGP_5 0x190D5148u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_9_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_9_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_9_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_9_CPU_EGP_5 Register PTR_RTN_DW3_EP3_9_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_9_CPU_EGP_5 0x1514C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_9_CPU_EGP_5 0x190D514Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP3_9_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_9_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_9_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_9_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_9_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_10_CPU_EGP_5 Register PTR_RTN_DW2_EP3_10_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_10_CPU_EGP_5 0x15150
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_10_CPU_EGP_5 0x190D5150u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_10_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_10_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_10_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_10_CPU_EGP_5 Register PTR_RTN_DW3_EP3_10_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_10_CPU_EGP_5 0x15154
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_10_CPU_EGP_5 0x190D5154u

//! Register Reset Value
#define PTR_RTN_DW3_EP3_10_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_10_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_10_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_10_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_10_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_11_CPU_EGP_5 Register PTR_RTN_DW2_EP3_11_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_11_CPU_EGP_5 0x15158
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_11_CPU_EGP_5 0x190D5158u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_11_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_11_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_11_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_11_CPU_EGP_5 Register PTR_RTN_DW3_EP3_11_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_11_CPU_EGP_5 0x1515C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_11_CPU_EGP_5 0x190D515Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP3_11_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_11_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_11_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_11_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_11_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_12_CPU_EGP_5 Register PTR_RTN_DW2_EP3_12_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_12_CPU_EGP_5 0x15160
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_12_CPU_EGP_5 0x190D5160u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_12_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_12_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_12_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_12_CPU_EGP_5 Register PTR_RTN_DW3_EP3_12_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_12_CPU_EGP_5 0x15164
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_12_CPU_EGP_5 0x190D5164u

//! Register Reset Value
#define PTR_RTN_DW3_EP3_12_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_12_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_12_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_12_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_12_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_13_CPU_EGP_5 Register PTR_RTN_DW2_EP3_13_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_13_CPU_EGP_5 0x15168
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_13_CPU_EGP_5 0x190D5168u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_13_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_13_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_13_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_13_CPU_EGP_5 Register PTR_RTN_DW3_EP3_13_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_13_CPU_EGP_5 0x1516C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_13_CPU_EGP_5 0x190D516Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP3_13_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_13_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_13_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_13_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_13_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_14_CPU_EGP_5 Register PTR_RTN_DW2_EP3_14_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_14_CPU_EGP_5 0x15170
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_14_CPU_EGP_5 0x190D5170u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_14_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_14_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_14_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_14_CPU_EGP_5 Register PTR_RTN_DW3_EP3_14_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_14_CPU_EGP_5 0x15174
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_14_CPU_EGP_5 0x190D5174u

//! Register Reset Value
#define PTR_RTN_DW3_EP3_14_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_14_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_14_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_14_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_14_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_15_CPU_EGP_5 Register PTR_RTN_DW2_EP3_15_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_15_CPU_EGP_5 0x15178
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_15_CPU_EGP_5 0x190D5178u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_15_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_15_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_15_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_15_CPU_EGP_5 Register PTR_RTN_DW3_EP3_15_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_15_CPU_EGP_5 0x1517C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_15_CPU_EGP_5 0x190D517Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP3_15_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_15_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_15_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_15_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_15_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_16_CPU_EGP_5 Register PTR_RTN_DW2_EP3_16_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_16_CPU_EGP_5 0x15180
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_16_CPU_EGP_5 0x190D5180u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_16_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_16_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_16_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_16_CPU_EGP_5 Register PTR_RTN_DW3_EP3_16_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_16_CPU_EGP_5 0x15184
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_16_CPU_EGP_5 0x190D5184u

//! Register Reset Value
#define PTR_RTN_DW3_EP3_16_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_16_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_16_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_16_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_16_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_17_CPU_EGP_5 Register PTR_RTN_DW2_EP3_17_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_17_CPU_EGP_5 0x15188
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_17_CPU_EGP_5 0x190D5188u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_17_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_17_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_17_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_17_CPU_EGP_5 Register PTR_RTN_DW3_EP3_17_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_17_CPU_EGP_5 0x1518C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_17_CPU_EGP_5 0x190D518Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP3_17_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_17_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_17_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_17_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_17_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_18_CPU_EGP_5 Register PTR_RTN_DW2_EP3_18_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_18_CPU_EGP_5 0x15190
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_18_CPU_EGP_5 0x190D5190u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_18_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_18_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_18_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_18_CPU_EGP_5 Register PTR_RTN_DW3_EP3_18_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_18_CPU_EGP_5 0x15194
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_18_CPU_EGP_5 0x190D5194u

//! Register Reset Value
#define PTR_RTN_DW3_EP3_18_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_18_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_18_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_18_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_18_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_19_CPU_EGP_5 Register PTR_RTN_DW2_EP3_19_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_19_CPU_EGP_5 0x15198
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_19_CPU_EGP_5 0x190D5198u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_19_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_19_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_19_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_19_CPU_EGP_5 Register PTR_RTN_DW3_EP3_19_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_19_CPU_EGP_5 0x1519C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_19_CPU_EGP_5 0x190D519Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP3_19_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_19_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_19_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_19_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_19_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_20_CPU_EGP_5 Register PTR_RTN_DW2_EP3_20_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_20_CPU_EGP_5 0x151A0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_20_CPU_EGP_5 0x190D51A0u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_20_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_20_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_20_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_20_CPU_EGP_5 Register PTR_RTN_DW3_EP3_20_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_20_CPU_EGP_5 0x151A4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_20_CPU_EGP_5 0x190D51A4u

//! Register Reset Value
#define PTR_RTN_DW3_EP3_20_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_20_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_20_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_20_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_20_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_21_CPU_EGP_5 Register PTR_RTN_DW2_EP3_21_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_21_CPU_EGP_5 0x151A8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_21_CPU_EGP_5 0x190D51A8u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_21_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_21_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_21_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_21_CPU_EGP_5 Register PTR_RTN_DW3_EP3_21_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_21_CPU_EGP_5 0x151AC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_21_CPU_EGP_5 0x190D51ACu

//! Register Reset Value
#define PTR_RTN_DW3_EP3_21_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_21_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_21_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_21_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_21_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_22_CPU_EGP_5 Register PTR_RTN_DW2_EP3_22_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_22_CPU_EGP_5 0x151B0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_22_CPU_EGP_5 0x190D51B0u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_22_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_22_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_22_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_22_CPU_EGP_5 Register PTR_RTN_DW3_EP3_22_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_22_CPU_EGP_5 0x151B4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_22_CPU_EGP_5 0x190D51B4u

//! Register Reset Value
#define PTR_RTN_DW3_EP3_22_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_22_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_22_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_22_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_22_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_23_CPU_EGP_5 Register PTR_RTN_DW2_EP3_23_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_23_CPU_EGP_5 0x151B8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_23_CPU_EGP_5 0x190D51B8u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_23_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_23_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_23_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_23_CPU_EGP_5 Register PTR_RTN_DW3_EP3_23_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_23_CPU_EGP_5 0x151BC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_23_CPU_EGP_5 0x190D51BCu

//! Register Reset Value
#define PTR_RTN_DW3_EP3_23_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_23_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_23_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_23_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_23_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_24_CPU_EGP_5 Register PTR_RTN_DW2_EP3_24_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_24_CPU_EGP_5 0x151C0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_24_CPU_EGP_5 0x190D51C0u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_24_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_24_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_24_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_24_CPU_EGP_5 Register PTR_RTN_DW3_EP3_24_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_24_CPU_EGP_5 0x151C4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_24_CPU_EGP_5 0x190D51C4u

//! Register Reset Value
#define PTR_RTN_DW3_EP3_24_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_24_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_24_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_24_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_24_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_25_CPU_EGP_5 Register PTR_RTN_DW2_EP3_25_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_25_CPU_EGP_5 0x151C8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_25_CPU_EGP_5 0x190D51C8u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_25_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_25_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_25_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_25_CPU_EGP_5 Register PTR_RTN_DW3_EP3_25_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_25_CPU_EGP_5 0x151CC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_25_CPU_EGP_5 0x190D51CCu

//! Register Reset Value
#define PTR_RTN_DW3_EP3_25_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_25_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_25_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_25_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_25_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_26_CPU_EGP_5 Register PTR_RTN_DW2_EP3_26_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_26_CPU_EGP_5 0x151D0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_26_CPU_EGP_5 0x190D51D0u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_26_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_26_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_26_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_26_CPU_EGP_5 Register PTR_RTN_DW3_EP3_26_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_26_CPU_EGP_5 0x151D4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_26_CPU_EGP_5 0x190D51D4u

//! Register Reset Value
#define PTR_RTN_DW3_EP3_26_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_26_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_26_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_26_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_26_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_27_CPU_EGP_5 Register PTR_RTN_DW2_EP3_27_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_27_CPU_EGP_5 0x151D8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_27_CPU_EGP_5 0x190D51D8u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_27_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_27_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_27_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_27_CPU_EGP_5 Register PTR_RTN_DW3_EP3_27_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_27_CPU_EGP_5 0x151DC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_27_CPU_EGP_5 0x190D51DCu

//! Register Reset Value
#define PTR_RTN_DW3_EP3_27_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_27_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_27_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_27_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_27_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_28_CPU_EGP_5 Register PTR_RTN_DW2_EP3_28_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_28_CPU_EGP_5 0x151E0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_28_CPU_EGP_5 0x190D51E0u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_28_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_28_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_28_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_28_CPU_EGP_5 Register PTR_RTN_DW3_EP3_28_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_28_CPU_EGP_5 0x151E4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_28_CPU_EGP_5 0x190D51E4u

//! Register Reset Value
#define PTR_RTN_DW3_EP3_28_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_28_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_28_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_28_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_28_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_29_CPU_EGP_5 Register PTR_RTN_DW2_EP3_29_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_29_CPU_EGP_5 0x151E8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_29_CPU_EGP_5 0x190D51E8u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_29_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_29_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_29_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_29_CPU_EGP_5 Register PTR_RTN_DW3_EP3_29_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_29_CPU_EGP_5 0x151EC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_29_CPU_EGP_5 0x190D51ECu

//! Register Reset Value
#define PTR_RTN_DW3_EP3_29_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_29_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_29_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_29_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_29_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_30_CPU_EGP_5 Register PTR_RTN_DW2_EP3_30_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_30_CPU_EGP_5 0x151F0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_30_CPU_EGP_5 0x190D51F0u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_30_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_30_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_30_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_30_CPU_EGP_5 Register PTR_RTN_DW3_EP3_30_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_30_CPU_EGP_5 0x151F4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_30_CPU_EGP_5 0x190D51F4u

//! Register Reset Value
#define PTR_RTN_DW3_EP3_30_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_30_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_30_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_30_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_30_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP3_31_CPU_EGP_5 Register PTR_RTN_DW2_EP3_31_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP3_31_CPU_EGP_5 0x151F8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP3_31_CPU_EGP_5 0x190D51F8u

//! Register Reset Value
#define PTR_RTN_DW2_EP3_31_CPU_EGP_5_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_31_CPU_EGP_5_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP3_31_CPU_EGP_5_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP3_31_CPU_EGP_5 Register PTR_RTN_DW3_EP3_31_CPU_EGP_5 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP3_31_CPU_EGP_5 0x151FC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP3_31_CPU_EGP_5 0x190D51FCu

//! Register Reset Value
#define PTR_RTN_DW3_EP3_31_CPU_EGP_5_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_31_CPU_EGP_5_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_31_CPU_EGP_5_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_31_CPU_EGP_5_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP3_31_CPU_EGP_5_POLICY_MASK 0x700000u

//! @}

//! \defgroup DESC0_EP5_0_CPU_EGP_5 Register DESC0_EP5_0_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_0_CPU_EGP_5 0x15200
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_0_CPU_EGP_5 0x190D5200u

//! Register Reset Value
#define DESC0_EP5_0_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_0_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_0_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_0_CPU_EGP_5 Register DESC1_EP5_0_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_0_CPU_EGP_5 0x15204
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_0_CPU_EGP_5 0x190D5204u

//! Register Reset Value
#define DESC1_EP5_0_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_0_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_0_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_0_CPU_EGP_5 Register DESC2_EP5_0_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_0_CPU_EGP_5 0x15208
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_0_CPU_EGP_5 0x190D5208u

//! Register Reset Value
#define DESC2_EP5_0_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_0_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_0_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_0_CPU_EGP_5 Register DESC3_EP5_0_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_0_CPU_EGP_5 0x1520C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_0_CPU_EGP_5 0x190D520Cu

//! Register Reset Value
#define DESC3_EP5_0_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_0_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_0_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_1_CPU_EGP_5 Register DESC0_EP5_1_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_1_CPU_EGP_5 0x15210
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_1_CPU_EGP_5 0x190D5210u

//! Register Reset Value
#define DESC0_EP5_1_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_1_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_1_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_1_CPU_EGP_5 Register DESC1_EP5_1_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_1_CPU_EGP_5 0x15214
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_1_CPU_EGP_5 0x190D5214u

//! Register Reset Value
#define DESC1_EP5_1_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_1_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_1_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_1_CPU_EGP_5 Register DESC2_EP5_1_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_1_CPU_EGP_5 0x15218
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_1_CPU_EGP_5 0x190D5218u

//! Register Reset Value
#define DESC2_EP5_1_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_1_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_1_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_1_CPU_EGP_5 Register DESC3_EP5_1_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_1_CPU_EGP_5 0x1521C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_1_CPU_EGP_5 0x190D521Cu

//! Register Reset Value
#define DESC3_EP5_1_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_1_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_1_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_2_CPU_EGP_5 Register DESC0_EP5_2_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_2_CPU_EGP_5 0x15220
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_2_CPU_EGP_5 0x190D5220u

//! Register Reset Value
#define DESC0_EP5_2_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_2_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_2_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_2_CPU_EGP_5 Register DESC1_EP5_2_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_2_CPU_EGP_5 0x15224
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_2_CPU_EGP_5 0x190D5224u

//! Register Reset Value
#define DESC1_EP5_2_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_2_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_2_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_2_CPU_EGP_5 Register DESC2_EP5_2_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_2_CPU_EGP_5 0x15228
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_2_CPU_EGP_5 0x190D5228u

//! Register Reset Value
#define DESC2_EP5_2_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_2_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_2_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_2_CPU_EGP_5 Register DESC3_EP5_2_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_2_CPU_EGP_5 0x1522C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_2_CPU_EGP_5 0x190D522Cu

//! Register Reset Value
#define DESC3_EP5_2_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_2_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_2_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_3_CPU_EGP_5 Register DESC0_EP5_3_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_3_CPU_EGP_5 0x15230
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_3_CPU_EGP_5 0x190D5230u

//! Register Reset Value
#define DESC0_EP5_3_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_3_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_3_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_3_CPU_EGP_5 Register DESC1_EP5_3_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_3_CPU_EGP_5 0x15234
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_3_CPU_EGP_5 0x190D5234u

//! Register Reset Value
#define DESC1_EP5_3_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_3_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_3_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_3_CPU_EGP_5 Register DESC2_EP5_3_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_3_CPU_EGP_5 0x15238
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_3_CPU_EGP_5 0x190D5238u

//! Register Reset Value
#define DESC2_EP5_3_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_3_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_3_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_3_CPU_EGP_5 Register DESC3_EP5_3_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_3_CPU_EGP_5 0x1523C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_3_CPU_EGP_5 0x190D523Cu

//! Register Reset Value
#define DESC3_EP5_3_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_3_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_3_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_4_CPU_EGP_5 Register DESC0_EP5_4_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_4_CPU_EGP_5 0x15240
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_4_CPU_EGP_5 0x190D5240u

//! Register Reset Value
#define DESC0_EP5_4_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_4_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_4_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_4_CPU_EGP_5 Register DESC1_EP5_4_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_4_CPU_EGP_5 0x15244
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_4_CPU_EGP_5 0x190D5244u

//! Register Reset Value
#define DESC1_EP5_4_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_4_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_4_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_4_CPU_EGP_5 Register DESC2_EP5_4_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_4_CPU_EGP_5 0x15248
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_4_CPU_EGP_5 0x190D5248u

//! Register Reset Value
#define DESC2_EP5_4_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_4_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_4_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_4_CPU_EGP_5 Register DESC3_EP5_4_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_4_CPU_EGP_5 0x1524C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_4_CPU_EGP_5 0x190D524Cu

//! Register Reset Value
#define DESC3_EP5_4_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_4_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_4_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_5_CPU_EGP_5 Register DESC0_EP5_5_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_5_CPU_EGP_5 0x15250
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_5_CPU_EGP_5 0x190D5250u

//! Register Reset Value
#define DESC0_EP5_5_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_5_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_5_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_5_CPU_EGP_5 Register DESC1_EP5_5_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_5_CPU_EGP_5 0x15254
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_5_CPU_EGP_5 0x190D5254u

//! Register Reset Value
#define DESC1_EP5_5_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_5_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_5_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_5_CPU_EGP_5 Register DESC2_EP5_5_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_5_CPU_EGP_5 0x15258
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_5_CPU_EGP_5 0x190D5258u

//! Register Reset Value
#define DESC2_EP5_5_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_5_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_5_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_5_CPU_EGP_5 Register DESC3_EP5_5_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_5_CPU_EGP_5 0x1525C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_5_CPU_EGP_5 0x190D525Cu

//! Register Reset Value
#define DESC3_EP5_5_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_5_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_5_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_6_CPU_EGP_5 Register DESC0_EP5_6_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_6_CPU_EGP_5 0x15260
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_6_CPU_EGP_5 0x190D5260u

//! Register Reset Value
#define DESC0_EP5_6_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_6_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_6_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_6_CPU_EGP_5 Register DESC1_EP5_6_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_6_CPU_EGP_5 0x15264
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_6_CPU_EGP_5 0x190D5264u

//! Register Reset Value
#define DESC1_EP5_6_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_6_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_6_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_6_CPU_EGP_5 Register DESC2_EP5_6_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_6_CPU_EGP_5 0x15268
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_6_CPU_EGP_5 0x190D5268u

//! Register Reset Value
#define DESC2_EP5_6_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_6_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_6_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_6_CPU_EGP_5 Register DESC3_EP5_6_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_6_CPU_EGP_5 0x1526C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_6_CPU_EGP_5 0x190D526Cu

//! Register Reset Value
#define DESC3_EP5_6_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_6_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_6_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_7_CPU_EGP_5 Register DESC0_EP5_7_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_7_CPU_EGP_5 0x15270
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_7_CPU_EGP_5 0x190D5270u

//! Register Reset Value
#define DESC0_EP5_7_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_7_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_7_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_7_CPU_EGP_5 Register DESC1_EP5_7_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_7_CPU_EGP_5 0x15274
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_7_CPU_EGP_5 0x190D5274u

//! Register Reset Value
#define DESC1_EP5_7_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_7_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_7_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_7_CPU_EGP_5 Register DESC2_EP5_7_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_7_CPU_EGP_5 0x15278
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_7_CPU_EGP_5 0x190D5278u

//! Register Reset Value
#define DESC2_EP5_7_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_7_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_7_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_7_CPU_EGP_5 Register DESC3_EP5_7_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_7_CPU_EGP_5 0x1527C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_7_CPU_EGP_5 0x190D527Cu

//! Register Reset Value
#define DESC3_EP5_7_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_7_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_7_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_8_CPU_EGP_5 Register DESC0_EP5_8_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_8_CPU_EGP_5 0x15280
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_8_CPU_EGP_5 0x190D5280u

//! Register Reset Value
#define DESC0_EP5_8_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_8_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_8_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_8_CPU_EGP_5 Register DESC1_EP5_8_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_8_CPU_EGP_5 0x15284
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_8_CPU_EGP_5 0x190D5284u

//! Register Reset Value
#define DESC1_EP5_8_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_8_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_8_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_8_CPU_EGP_5 Register DESC2_EP5_8_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_8_CPU_EGP_5 0x15288
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_8_CPU_EGP_5 0x190D5288u

//! Register Reset Value
#define DESC2_EP5_8_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_8_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_8_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_8_CPU_EGP_5 Register DESC3_EP5_8_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_8_CPU_EGP_5 0x1528C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_8_CPU_EGP_5 0x190D528Cu

//! Register Reset Value
#define DESC3_EP5_8_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_8_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_8_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_9_CPU_EGP_5 Register DESC0_EP5_9_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_9_CPU_EGP_5 0x15290
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_9_CPU_EGP_5 0x190D5290u

//! Register Reset Value
#define DESC0_EP5_9_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_9_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_9_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_9_CPU_EGP_5 Register DESC1_EP5_9_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_9_CPU_EGP_5 0x15294
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_9_CPU_EGP_5 0x190D5294u

//! Register Reset Value
#define DESC1_EP5_9_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_9_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_9_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_9_CPU_EGP_5 Register DESC2_EP5_9_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_9_CPU_EGP_5 0x15298
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_9_CPU_EGP_5 0x190D5298u

//! Register Reset Value
#define DESC2_EP5_9_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_9_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_9_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_9_CPU_EGP_5 Register DESC3_EP5_9_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_9_CPU_EGP_5 0x1529C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_9_CPU_EGP_5 0x190D529Cu

//! Register Reset Value
#define DESC3_EP5_9_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_9_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_9_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_10_CPU_EGP_5 Register DESC0_EP5_10_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_10_CPU_EGP_5 0x152A0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_10_CPU_EGP_5 0x190D52A0u

//! Register Reset Value
#define DESC0_EP5_10_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_10_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_10_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_10_CPU_EGP_5 Register DESC1_EP5_10_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_10_CPU_EGP_5 0x152A4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_10_CPU_EGP_5 0x190D52A4u

//! Register Reset Value
#define DESC1_EP5_10_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_10_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_10_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_10_CPU_EGP_5 Register DESC2_EP5_10_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_10_CPU_EGP_5 0x152A8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_10_CPU_EGP_5 0x190D52A8u

//! Register Reset Value
#define DESC2_EP5_10_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_10_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_10_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_10_CPU_EGP_5 Register DESC3_EP5_10_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_10_CPU_EGP_5 0x152AC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_10_CPU_EGP_5 0x190D52ACu

//! Register Reset Value
#define DESC3_EP5_10_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_10_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_10_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_11_CPU_EGP_5 Register DESC0_EP5_11_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_11_CPU_EGP_5 0x152B0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_11_CPU_EGP_5 0x190D52B0u

//! Register Reset Value
#define DESC0_EP5_11_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_11_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_11_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_11_CPU_EGP_5 Register DESC1_EP5_11_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_11_CPU_EGP_5 0x152B4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_11_CPU_EGP_5 0x190D52B4u

//! Register Reset Value
#define DESC1_EP5_11_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_11_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_11_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_11_CPU_EGP_5 Register DESC2_EP5_11_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_11_CPU_EGP_5 0x152B8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_11_CPU_EGP_5 0x190D52B8u

//! Register Reset Value
#define DESC2_EP5_11_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_11_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_11_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_11_CPU_EGP_5 Register DESC3_EP5_11_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_11_CPU_EGP_5 0x152BC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_11_CPU_EGP_5 0x190D52BCu

//! Register Reset Value
#define DESC3_EP5_11_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_11_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_11_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_12_CPU_EGP_5 Register DESC0_EP5_12_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_12_CPU_EGP_5 0x152C0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_12_CPU_EGP_5 0x190D52C0u

//! Register Reset Value
#define DESC0_EP5_12_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_12_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_12_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_12_CPU_EGP_5 Register DESC1_EP5_12_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_12_CPU_EGP_5 0x152C4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_12_CPU_EGP_5 0x190D52C4u

//! Register Reset Value
#define DESC1_EP5_12_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_12_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_12_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_12_CPU_EGP_5 Register DESC2_EP5_12_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_12_CPU_EGP_5 0x152C8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_12_CPU_EGP_5 0x190D52C8u

//! Register Reset Value
#define DESC2_EP5_12_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_12_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_12_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_12_CPU_EGP_5 Register DESC3_EP5_12_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_12_CPU_EGP_5 0x152CC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_12_CPU_EGP_5 0x190D52CCu

//! Register Reset Value
#define DESC3_EP5_12_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_12_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_12_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_13_CPU_EGP_5 Register DESC0_EP5_13_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_13_CPU_EGP_5 0x152D0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_13_CPU_EGP_5 0x190D52D0u

//! Register Reset Value
#define DESC0_EP5_13_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_13_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_13_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_13_CPU_EGP_5 Register DESC1_EP5_13_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_13_CPU_EGP_5 0x152D4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_13_CPU_EGP_5 0x190D52D4u

//! Register Reset Value
#define DESC1_EP5_13_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_13_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_13_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_13_CPU_EGP_5 Register DESC2_EP5_13_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_13_CPU_EGP_5 0x152D8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_13_CPU_EGP_5 0x190D52D8u

//! Register Reset Value
#define DESC2_EP5_13_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_13_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_13_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_13_CPU_EGP_5 Register DESC3_EP5_13_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_13_CPU_EGP_5 0x152DC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_13_CPU_EGP_5 0x190D52DCu

//! Register Reset Value
#define DESC3_EP5_13_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_13_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_13_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_14_CPU_EGP_5 Register DESC0_EP5_14_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_14_CPU_EGP_5 0x152E0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_14_CPU_EGP_5 0x190D52E0u

//! Register Reset Value
#define DESC0_EP5_14_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_14_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_14_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_14_CPU_EGP_5 Register DESC1_EP5_14_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_14_CPU_EGP_5 0x152E4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_14_CPU_EGP_5 0x190D52E4u

//! Register Reset Value
#define DESC1_EP5_14_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_14_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_14_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_14_CPU_EGP_5 Register DESC2_EP5_14_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_14_CPU_EGP_5 0x152E8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_14_CPU_EGP_5 0x190D52E8u

//! Register Reset Value
#define DESC2_EP5_14_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_14_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_14_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_14_CPU_EGP_5 Register DESC3_EP5_14_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_14_CPU_EGP_5 0x152EC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_14_CPU_EGP_5 0x190D52ECu

//! Register Reset Value
#define DESC3_EP5_14_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_14_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_14_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_15_CPU_EGP_5 Register DESC0_EP5_15_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_15_CPU_EGP_5 0x152F0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_15_CPU_EGP_5 0x190D52F0u

//! Register Reset Value
#define DESC0_EP5_15_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_15_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_15_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_15_CPU_EGP_5 Register DESC1_EP5_15_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_15_CPU_EGP_5 0x152F4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_15_CPU_EGP_5 0x190D52F4u

//! Register Reset Value
#define DESC1_EP5_15_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_15_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_15_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_15_CPU_EGP_5 Register DESC2_EP5_15_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_15_CPU_EGP_5 0x152F8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_15_CPU_EGP_5 0x190D52F8u

//! Register Reset Value
#define DESC2_EP5_15_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_15_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_15_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_15_CPU_EGP_5 Register DESC3_EP5_15_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_15_CPU_EGP_5 0x152FC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_15_CPU_EGP_5 0x190D52FCu

//! Register Reset Value
#define DESC3_EP5_15_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_15_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_15_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_16_CPU_EGP_5 Register DESC0_EP5_16_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_16_CPU_EGP_5 0x15300
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_16_CPU_EGP_5 0x190D5300u

//! Register Reset Value
#define DESC0_EP5_16_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_16_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_16_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_16_CPU_EGP_5 Register DESC1_EP5_16_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_16_CPU_EGP_5 0x15304
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_16_CPU_EGP_5 0x190D5304u

//! Register Reset Value
#define DESC1_EP5_16_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_16_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_16_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_16_CPU_EGP_5 Register DESC2_EP5_16_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_16_CPU_EGP_5 0x15308
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_16_CPU_EGP_5 0x190D5308u

//! Register Reset Value
#define DESC2_EP5_16_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_16_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_16_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_16_CPU_EGP_5 Register DESC3_EP5_16_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_16_CPU_EGP_5 0x1530C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_16_CPU_EGP_5 0x190D530Cu

//! Register Reset Value
#define DESC3_EP5_16_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_16_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_16_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_17_CPU_EGP_5 Register DESC0_EP5_17_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_17_CPU_EGP_5 0x15310
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_17_CPU_EGP_5 0x190D5310u

//! Register Reset Value
#define DESC0_EP5_17_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_17_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_17_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_17_CPU_EGP_5 Register DESC1_EP5_17_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_17_CPU_EGP_5 0x15314
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_17_CPU_EGP_5 0x190D5314u

//! Register Reset Value
#define DESC1_EP5_17_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_17_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_17_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_17_CPU_EGP_5 Register DESC2_EP5_17_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_17_CPU_EGP_5 0x15318
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_17_CPU_EGP_5 0x190D5318u

//! Register Reset Value
#define DESC2_EP5_17_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_17_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_17_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_17_CPU_EGP_5 Register DESC3_EP5_17_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_17_CPU_EGP_5 0x1531C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_17_CPU_EGP_5 0x190D531Cu

//! Register Reset Value
#define DESC3_EP5_17_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_17_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_17_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_18_CPU_EGP_5 Register DESC0_EP5_18_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_18_CPU_EGP_5 0x15320
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_18_CPU_EGP_5 0x190D5320u

//! Register Reset Value
#define DESC0_EP5_18_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_18_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_18_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_18_CPU_EGP_5 Register DESC1_EP5_18_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_18_CPU_EGP_5 0x15324
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_18_CPU_EGP_5 0x190D5324u

//! Register Reset Value
#define DESC1_EP5_18_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_18_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_18_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_18_CPU_EGP_5 Register DESC2_EP5_18_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_18_CPU_EGP_5 0x15328
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_18_CPU_EGP_5 0x190D5328u

//! Register Reset Value
#define DESC2_EP5_18_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_18_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_18_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_18_CPU_EGP_5 Register DESC3_EP5_18_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_18_CPU_EGP_5 0x1532C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_18_CPU_EGP_5 0x190D532Cu

//! Register Reset Value
#define DESC3_EP5_18_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_18_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_18_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_19_CPU_EGP_5 Register DESC0_EP5_19_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_19_CPU_EGP_5 0x15330
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_19_CPU_EGP_5 0x190D5330u

//! Register Reset Value
#define DESC0_EP5_19_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_19_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_19_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_19_CPU_EGP_5 Register DESC1_EP5_19_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_19_CPU_EGP_5 0x15334
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_19_CPU_EGP_5 0x190D5334u

//! Register Reset Value
#define DESC1_EP5_19_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_19_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_19_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_19_CPU_EGP_5 Register DESC2_EP5_19_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_19_CPU_EGP_5 0x15338
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_19_CPU_EGP_5 0x190D5338u

//! Register Reset Value
#define DESC2_EP5_19_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_19_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_19_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_19_CPU_EGP_5 Register DESC3_EP5_19_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_19_CPU_EGP_5 0x1533C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_19_CPU_EGP_5 0x190D533Cu

//! Register Reset Value
#define DESC3_EP5_19_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_19_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_19_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_20_CPU_EGP_5 Register DESC0_EP5_20_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_20_CPU_EGP_5 0x15340
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_20_CPU_EGP_5 0x190D5340u

//! Register Reset Value
#define DESC0_EP5_20_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_20_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_20_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_20_CPU_EGP_5 Register DESC1_EP5_20_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_20_CPU_EGP_5 0x15344
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_20_CPU_EGP_5 0x190D5344u

//! Register Reset Value
#define DESC1_EP5_20_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_20_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_20_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_20_CPU_EGP_5 Register DESC2_EP5_20_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_20_CPU_EGP_5 0x15348
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_20_CPU_EGP_5 0x190D5348u

//! Register Reset Value
#define DESC2_EP5_20_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_20_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_20_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_20_CPU_EGP_5 Register DESC3_EP5_20_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_20_CPU_EGP_5 0x1534C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_20_CPU_EGP_5 0x190D534Cu

//! Register Reset Value
#define DESC3_EP5_20_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_20_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_20_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_21_CPU_EGP_5 Register DESC0_EP5_21_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_21_CPU_EGP_5 0x15350
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_21_CPU_EGP_5 0x190D5350u

//! Register Reset Value
#define DESC0_EP5_21_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_21_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_21_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_21_CPU_EGP_5 Register DESC1_EP5_21_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_21_CPU_EGP_5 0x15354
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_21_CPU_EGP_5 0x190D5354u

//! Register Reset Value
#define DESC1_EP5_21_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_21_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_21_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_21_CPU_EGP_5 Register DESC2_EP5_21_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_21_CPU_EGP_5 0x15358
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_21_CPU_EGP_5 0x190D5358u

//! Register Reset Value
#define DESC2_EP5_21_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_21_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_21_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_21_CPU_EGP_5 Register DESC3_EP5_21_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_21_CPU_EGP_5 0x1535C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_21_CPU_EGP_5 0x190D535Cu

//! Register Reset Value
#define DESC3_EP5_21_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_21_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_21_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_22_CPU_EGP_5 Register DESC0_EP5_22_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_22_CPU_EGP_5 0x15360
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_22_CPU_EGP_5 0x190D5360u

//! Register Reset Value
#define DESC0_EP5_22_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_22_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_22_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_22_CPU_EGP_5 Register DESC1_EP5_22_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_22_CPU_EGP_5 0x15364
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_22_CPU_EGP_5 0x190D5364u

//! Register Reset Value
#define DESC1_EP5_22_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_22_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_22_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_22_CPU_EGP_5 Register DESC2_EP5_22_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_22_CPU_EGP_5 0x15368
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_22_CPU_EGP_5 0x190D5368u

//! Register Reset Value
#define DESC2_EP5_22_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_22_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_22_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_22_CPU_EGP_5 Register DESC3_EP5_22_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_22_CPU_EGP_5 0x1536C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_22_CPU_EGP_5 0x190D536Cu

//! Register Reset Value
#define DESC3_EP5_22_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_22_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_22_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_23_CPU_EGP_5 Register DESC0_EP5_23_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_23_CPU_EGP_5 0x15370
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_23_CPU_EGP_5 0x190D5370u

//! Register Reset Value
#define DESC0_EP5_23_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_23_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_23_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_23_CPU_EGP_5 Register DESC1_EP5_23_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_23_CPU_EGP_5 0x15374
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_23_CPU_EGP_5 0x190D5374u

//! Register Reset Value
#define DESC1_EP5_23_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_23_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_23_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_23_CPU_EGP_5 Register DESC2_EP5_23_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_23_CPU_EGP_5 0x15378
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_23_CPU_EGP_5 0x190D5378u

//! Register Reset Value
#define DESC2_EP5_23_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_23_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_23_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_23_CPU_EGP_5 Register DESC3_EP5_23_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_23_CPU_EGP_5 0x1537C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_23_CPU_EGP_5 0x190D537Cu

//! Register Reset Value
#define DESC3_EP5_23_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_23_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_23_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_24_CPU_EGP_5 Register DESC0_EP5_24_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_24_CPU_EGP_5 0x15380
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_24_CPU_EGP_5 0x190D5380u

//! Register Reset Value
#define DESC0_EP5_24_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_24_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_24_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_24_CPU_EGP_5 Register DESC1_EP5_24_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_24_CPU_EGP_5 0x15384
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_24_CPU_EGP_5 0x190D5384u

//! Register Reset Value
#define DESC1_EP5_24_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_24_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_24_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_24_CPU_EGP_5 Register DESC2_EP5_24_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_24_CPU_EGP_5 0x15388
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_24_CPU_EGP_5 0x190D5388u

//! Register Reset Value
#define DESC2_EP5_24_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_24_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_24_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_24_CPU_EGP_5 Register DESC3_EP5_24_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_24_CPU_EGP_5 0x1538C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_24_CPU_EGP_5 0x190D538Cu

//! Register Reset Value
#define DESC3_EP5_24_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_24_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_24_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_25_CPU_EGP_5 Register DESC0_EP5_25_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_25_CPU_EGP_5 0x15390
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_25_CPU_EGP_5 0x190D5390u

//! Register Reset Value
#define DESC0_EP5_25_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_25_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_25_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_25_CPU_EGP_5 Register DESC1_EP5_25_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_25_CPU_EGP_5 0x15394
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_25_CPU_EGP_5 0x190D5394u

//! Register Reset Value
#define DESC1_EP5_25_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_25_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_25_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_25_CPU_EGP_5 Register DESC2_EP5_25_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_25_CPU_EGP_5 0x15398
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_25_CPU_EGP_5 0x190D5398u

//! Register Reset Value
#define DESC2_EP5_25_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_25_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_25_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_25_CPU_EGP_5 Register DESC3_EP5_25_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_25_CPU_EGP_5 0x1539C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_25_CPU_EGP_5 0x190D539Cu

//! Register Reset Value
#define DESC3_EP5_25_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_25_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_25_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_26_CPU_EGP_5 Register DESC0_EP5_26_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_26_CPU_EGP_5 0x153A0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_26_CPU_EGP_5 0x190D53A0u

//! Register Reset Value
#define DESC0_EP5_26_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_26_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_26_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_26_CPU_EGP_5 Register DESC1_EP5_26_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_26_CPU_EGP_5 0x153A4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_26_CPU_EGP_5 0x190D53A4u

//! Register Reset Value
#define DESC1_EP5_26_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_26_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_26_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_26_CPU_EGP_5 Register DESC2_EP5_26_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_26_CPU_EGP_5 0x153A8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_26_CPU_EGP_5 0x190D53A8u

//! Register Reset Value
#define DESC2_EP5_26_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_26_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_26_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_26_CPU_EGP_5 Register DESC3_EP5_26_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_26_CPU_EGP_5 0x153AC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_26_CPU_EGP_5 0x190D53ACu

//! Register Reset Value
#define DESC3_EP5_26_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_26_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_26_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_27_CPU_EGP_5 Register DESC0_EP5_27_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_27_CPU_EGP_5 0x153B0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_27_CPU_EGP_5 0x190D53B0u

//! Register Reset Value
#define DESC0_EP5_27_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_27_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_27_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_27_CPU_EGP_5 Register DESC1_EP5_27_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_27_CPU_EGP_5 0x153B4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_27_CPU_EGP_5 0x190D53B4u

//! Register Reset Value
#define DESC1_EP5_27_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_27_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_27_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_27_CPU_EGP_5 Register DESC2_EP5_27_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_27_CPU_EGP_5 0x153B8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_27_CPU_EGP_5 0x190D53B8u

//! Register Reset Value
#define DESC2_EP5_27_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_27_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_27_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_27_CPU_EGP_5 Register DESC3_EP5_27_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_27_CPU_EGP_5 0x153BC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_27_CPU_EGP_5 0x190D53BCu

//! Register Reset Value
#define DESC3_EP5_27_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_27_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_27_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_28_CPU_EGP_5 Register DESC0_EP5_28_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_28_CPU_EGP_5 0x153C0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_28_CPU_EGP_5 0x190D53C0u

//! Register Reset Value
#define DESC0_EP5_28_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_28_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_28_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_28_CPU_EGP_5 Register DESC1_EP5_28_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_28_CPU_EGP_5 0x153C4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_28_CPU_EGP_5 0x190D53C4u

//! Register Reset Value
#define DESC1_EP5_28_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_28_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_28_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_28_CPU_EGP_5 Register DESC2_EP5_28_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_28_CPU_EGP_5 0x153C8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_28_CPU_EGP_5 0x190D53C8u

//! Register Reset Value
#define DESC2_EP5_28_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_28_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_28_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_28_CPU_EGP_5 Register DESC3_EP5_28_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_28_CPU_EGP_5 0x153CC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_28_CPU_EGP_5 0x190D53CCu

//! Register Reset Value
#define DESC3_EP5_28_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_28_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_28_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_29_CPU_EGP_5 Register DESC0_EP5_29_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_29_CPU_EGP_5 0x153D0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_29_CPU_EGP_5 0x190D53D0u

//! Register Reset Value
#define DESC0_EP5_29_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_29_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_29_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_29_CPU_EGP_5 Register DESC1_EP5_29_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_29_CPU_EGP_5 0x153D4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_29_CPU_EGP_5 0x190D53D4u

//! Register Reset Value
#define DESC1_EP5_29_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_29_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_29_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_29_CPU_EGP_5 Register DESC2_EP5_29_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_29_CPU_EGP_5 0x153D8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_29_CPU_EGP_5 0x190D53D8u

//! Register Reset Value
#define DESC2_EP5_29_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_29_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_29_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_29_CPU_EGP_5 Register DESC3_EP5_29_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_29_CPU_EGP_5 0x153DC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_29_CPU_EGP_5 0x190D53DCu

//! Register Reset Value
#define DESC3_EP5_29_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_29_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_29_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_30_CPU_EGP_5 Register DESC0_EP5_30_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_30_CPU_EGP_5 0x153E0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_30_CPU_EGP_5 0x190D53E0u

//! Register Reset Value
#define DESC0_EP5_30_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_30_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_30_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_30_CPU_EGP_5 Register DESC1_EP5_30_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_30_CPU_EGP_5 0x153E4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_30_CPU_EGP_5 0x190D53E4u

//! Register Reset Value
#define DESC1_EP5_30_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_30_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_30_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_30_CPU_EGP_5 Register DESC2_EP5_30_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_30_CPU_EGP_5 0x153E8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_30_CPU_EGP_5 0x190D53E8u

//! Register Reset Value
#define DESC2_EP5_30_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_30_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_30_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_30_CPU_EGP_5 Register DESC3_EP5_30_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_30_CPU_EGP_5 0x153EC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_30_CPU_EGP_5 0x190D53ECu

//! Register Reset Value
#define DESC3_EP5_30_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_30_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_30_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP5_31_CPU_EGP_5 Register DESC0_EP5_31_CPU_EGP_5 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP5_31_CPU_EGP_5 0x153F0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP5_31_CPU_EGP_5 0x190D53F0u

//! Register Reset Value
#define DESC0_EP5_31_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_31_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP5_31_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP5_31_CPU_EGP_5 Register DESC1_EP5_31_CPU_EGP_5 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP5_31_CPU_EGP_5 0x153F4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP5_31_CPU_EGP_5 0x190D53F4u

//! Register Reset Value
#define DESC1_EP5_31_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_31_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP5_31_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP5_31_CPU_EGP_5 Register DESC2_EP5_31_CPU_EGP_5 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP5_31_CPU_EGP_5 0x153F8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP5_31_CPU_EGP_5 0x190D53F8u

//! Register Reset Value
#define DESC2_EP5_31_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_31_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP5_31_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP5_31_CPU_EGP_5 Register DESC3_EP5_31_CPU_EGP_5 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP5_31_CPU_EGP_5 0x153FC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP5_31_CPU_EGP_5 0x190D53FCu

//! Register Reset Value
#define DESC3_EP5_31_CPU_EGP_5_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_31_CPU_EGP_5_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP5_31_CPU_EGP_5_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup CFG_ACA_EGP_6 Register CFG_ACA_EGP_6 - CPU ACA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_ACA_EGP_6 0x16000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_ACA_EGP_6 0x190D6000u

//! Register Reset Value
#define CFG_ACA_EGP_6_RST 0x00000000u

//! Field DQREQ - Enable CPU Dequeue Request
#define CFG_ACA_EGP_6_DQREQ_POS 0
//! Field DQREQ - Enable CPU Dequeue Request
#define CFG_ACA_EGP_6_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_ACA_EGP_6_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_ACA_EGP_6_DQREQ_EN 0x1

//! Field BUFRTN - Enable CPU Buffer Return
#define CFG_ACA_EGP_6_BUFRTN_POS 1
//! Field BUFRTN - Enable CPU Buffer Return
#define CFG_ACA_EGP_6_BUFRTN_MASK 0x2u
//! Constant DIS - DIS
#define CONST_CFG_ACA_EGP_6_BUFRTN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_ACA_EGP_6_BUFRTN_EN 0x1

//! Field BFBPEN - Buffer Return Back Pressure Enable
#define CFG_ACA_EGP_6_BFBPEN_POS 2
//! Field BFBPEN - Buffer Return Back Pressure Enable
#define CFG_ACA_EGP_6_BFBPEN_MASK 0x4u
//! Constant DIS - DIS
#define CONST_CFG_ACA_EGP_6_BFBPEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_ACA_EGP_6_BFBPEN_EN 0x1

//! Field DQBPEN - Dequeue Back Pressure Enable
#define CFG_ACA_EGP_6_DQBPEN_POS 3
//! Field DQBPEN - Dequeue Back Pressure Enable
#define CFG_ACA_EGP_6_DQBPEN_MASK 0x8u
//! Constant DIS - DIS
#define CONST_CFG_ACA_EGP_6_DQBPEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_ACA_EGP_6_DQBPEN_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_ACA_EGP_6_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_ACA_EGP_6_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_ACA_EGP_6_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_ACA_EGP_6_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_ACA_EGP_6_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_ACA_EGP_6_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_CPU_EGP_6 Register DQPC_CPU_EGP_6 - CPU Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_CPU_EGP_6 0x16004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_CPU_EGP_6 0x190D6004u

//! Register Reset Value
#define DQPC_CPU_EGP_6_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_CPU_EGP_6_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_CPU_EGP_6_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_CPU_EGP_6 Register IRNCR_CPU_EGP_6 - CPU Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_CPU_EGP_6 0x16020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_CPU_EGP_6 0x190D6020u

//! Register Reset Value
#define IRNCR_CPU_EGP_6_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNCR_CPU_EGP_6_PR_POS 0
//! Field PR - Pointer Ready
#define IRNCR_CPU_EGP_6_PR_MASK 0x1u
//! Constant NUL - NULL
#define CONST_IRNCR_CPU_EGP_6_PR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_CPU_EGP_6_PR_INTOCC 0x1

//! Field DR - Descriptor Ready
#define IRNCR_CPU_EGP_6_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_CPU_EGP_6_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_CPU_EGP_6_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_CPU_EGP_6_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_CPU_EGP_6 Register IRNICR_CPU_EGP_6 - CPU Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_CPU_EGP_6 0x16024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_CPU_EGP_6 0x190D6024u

//! Register Reset Value
#define IRNICR_CPU_EGP_6_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNICR_CPU_EGP_6_PR_POS 0
//! Field PR - Pointer Ready
#define IRNICR_CPU_EGP_6_PR_MASK 0x1u

//! Field DR - Descriptor Ready
#define IRNICR_CPU_EGP_6_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_CPU_EGP_6_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_CPU_EGP_6 Register IRNEN_CPU_EGP_6 - CPU Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_CPU_EGP_6 0x16028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_CPU_EGP_6 0x190D6028u

//! Register Reset Value
#define IRNEN_CPU_EGP_6_RST 0x00000000u

//! Field PR - Pointer Ready
#define IRNEN_CPU_EGP_6_PR_POS 0
//! Field PR - Pointer Ready
#define IRNEN_CPU_EGP_6_PR_MASK 0x1u
//! Constant DIS - DIS
#define CONST_IRNEN_CPU_EGP_6_PR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_CPU_EGP_6_PR_EN 0x1

//! Field DR - Descriptor Ready
#define IRNEN_CPU_EGP_6_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_CPU_EGP_6_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_CPU_EGP_6_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_CPU_EGP_6_DR_EN 0x1

//! @}

//! \defgroup DPTR_CPU_EGP_6 Register DPTR_CPU_EGP_6 - Special CPU Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_CPU_EGP_6 0x16030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_CPU_EGP_6 0x190D6030u

//! Register Reset Value
#define DPTR_CPU_EGP_6_RST 0x0000001Fu

//! Field ND - Number of Descriptors
#define DPTR_CPU_EGP_6_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_CPU_EGP_6_ND_MASK 0x1Fu

//! Field DPTR - Descriptor Pointer
#define DPTR_CPU_EGP_6_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_CPU_EGP_6_DPTR_MASK 0x1F0000u

//! @}

//! \defgroup BPRC_CPU_EGP_6 Register BPRC_CPU_EGP_6 - Egress Port Buffer Pointer Return counter
//! @{

//! Register Offset (relative)
#define BPRC_CPU_EGP_6 0x16034
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_BPRC_CPU_EGP_6 0x190D6034u

//! Register Reset Value
#define BPRC_CPU_EGP_6_RST 0x00000000u

//! Field BPRC - Per Port Buffer Pointer Return Counter
#define BPRC_CPU_EGP_6_BPRC_POS 0
//! Field BPRC - Per Port Buffer Pointer Return Counter
#define BPRC_CPU_EGP_6_BPRC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup BRPTR_SCPU_EGP_6 Register BRPTR_SCPU_EGP_6 - Special CPU Egress Port Buffer Return Pointer
//! @{

//! Register Offset (relative)
#define BRPTR_SCPU_EGP_6 0x16038
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_BRPTR_SCPU_EGP_6 0x190D6038u

//! Register Reset Value
#define BRPTR_SCPU_EGP_6_RST 0x00000000u

//! Field PTRBR - Pointer of Buffer Return
#define BRPTR_SCPU_EGP_6_PTRBR_POS 0
//! Field PTRBR - Pointer of Buffer Return
#define BRPTR_SCPU_EGP_6_PTRBR_MASK 0x1Fu

//! @}

//! \defgroup PTR_RTN_DW2_EP4_0_CPU_EGP_6 Register PTR_RTN_DW2_EP4_0_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_0_CPU_EGP_6 0x16100
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_0_CPU_EGP_6 0x190D6100u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_0_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_0_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_0_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_0_CPU_EGP_6 Register PTR_RTN_DW3_EP4_0_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_0_CPU_EGP_6 0x16104
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_0_CPU_EGP_6 0x190D6104u

//! Register Reset Value
#define PTR_RTN_DW3_EP4_0_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_0_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_0_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_0_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_0_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_1_CPU_EGP_6 Register PTR_RTN_DW2_EP4_1_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_1_CPU_EGP_6 0x16108
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_1_CPU_EGP_6 0x190D6108u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_1_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_1_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_1_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_1_CPU_EGP_6 Register PTR_RTN_DW3_EP4_1_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_1_CPU_EGP_6 0x1610C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_1_CPU_EGP_6 0x190D610Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP4_1_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_1_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_1_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_1_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_1_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_2_CPU_EGP_6 Register PTR_RTN_DW2_EP4_2_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_2_CPU_EGP_6 0x16110
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_2_CPU_EGP_6 0x190D6110u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_2_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_2_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_2_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_2_CPU_EGP_6 Register PTR_RTN_DW3_EP4_2_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_2_CPU_EGP_6 0x16114
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_2_CPU_EGP_6 0x190D6114u

//! Register Reset Value
#define PTR_RTN_DW3_EP4_2_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_2_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_2_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_2_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_2_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_3_CPU_EGP_6 Register PTR_RTN_DW2_EP4_3_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_3_CPU_EGP_6 0x16118
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_3_CPU_EGP_6 0x190D6118u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_3_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_3_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_3_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_3_CPU_EGP_6 Register PTR_RTN_DW3_EP4_3_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_3_CPU_EGP_6 0x1611C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_3_CPU_EGP_6 0x190D611Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP4_3_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_3_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_3_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_3_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_3_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_4_CPU_EGP_6 Register PTR_RTN_DW2_EP4_4_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_4_CPU_EGP_6 0x16120
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_4_CPU_EGP_6 0x190D6120u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_4_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_4_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_4_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_4_CPU_EGP_6 Register PTR_RTN_DW3_EP4_4_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_4_CPU_EGP_6 0x16124
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_4_CPU_EGP_6 0x190D6124u

//! Register Reset Value
#define PTR_RTN_DW3_EP4_4_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_4_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_4_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_4_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_4_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_5_CPU_EGP_6 Register PTR_RTN_DW2_EP4_5_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_5_CPU_EGP_6 0x16128
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_5_CPU_EGP_6 0x190D6128u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_5_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_5_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_5_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_5_CPU_EGP_6 Register PTR_RTN_DW3_EP4_5_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_5_CPU_EGP_6 0x1612C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_5_CPU_EGP_6 0x190D612Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP4_5_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_5_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_5_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_5_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_5_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_6_CPU_EGP_6 Register PTR_RTN_DW2_EP4_6_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_6_CPU_EGP_6 0x16130
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_6_CPU_EGP_6 0x190D6130u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_6_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_6_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_6_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_6_CPU_EGP_6 Register PTR_RTN_DW3_EP4_6_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_6_CPU_EGP_6 0x16134
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_6_CPU_EGP_6 0x190D6134u

//! Register Reset Value
#define PTR_RTN_DW3_EP4_6_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_6_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_6_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_6_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_6_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_7_CPU_EGP_6 Register PTR_RTN_DW2_EP4_7_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_7_CPU_EGP_6 0x16138
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_7_CPU_EGP_6 0x190D6138u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_7_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_7_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_7_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_7_CPU_EGP_6 Register PTR_RTN_DW3_EP4_7_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_7_CPU_EGP_6 0x1613C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_7_CPU_EGP_6 0x190D613Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP4_7_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_7_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_7_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_7_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_7_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_8_CPU_EGP_6 Register PTR_RTN_DW2_EP4_8_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_8_CPU_EGP_6 0x16140
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_8_CPU_EGP_6 0x190D6140u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_8_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_8_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_8_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_8_CPU_EGP_6 Register PTR_RTN_DW3_EP4_8_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_8_CPU_EGP_6 0x16144
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_8_CPU_EGP_6 0x190D6144u

//! Register Reset Value
#define PTR_RTN_DW3_EP4_8_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_8_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_8_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_8_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_8_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_9_CPU_EGP_6 Register PTR_RTN_DW2_EP4_9_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_9_CPU_EGP_6 0x16148
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_9_CPU_EGP_6 0x190D6148u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_9_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_9_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_9_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_9_CPU_EGP_6 Register PTR_RTN_DW3_EP4_9_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_9_CPU_EGP_6 0x1614C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_9_CPU_EGP_6 0x190D614Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP4_9_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_9_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_9_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_9_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_9_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_10_CPU_EGP_6 Register PTR_RTN_DW2_EP4_10_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_10_CPU_EGP_6 0x16150
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_10_CPU_EGP_6 0x190D6150u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_10_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_10_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_10_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_10_CPU_EGP_6 Register PTR_RTN_DW3_EP4_10_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_10_CPU_EGP_6 0x16154
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_10_CPU_EGP_6 0x190D6154u

//! Register Reset Value
#define PTR_RTN_DW3_EP4_10_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_10_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_10_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_10_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_10_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_11_CPU_EGP_6 Register PTR_RTN_DW2_EP4_11_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_11_CPU_EGP_6 0x16158
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_11_CPU_EGP_6 0x190D6158u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_11_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_11_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_11_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_11_CPU_EGP_6 Register PTR_RTN_DW3_EP4_11_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_11_CPU_EGP_6 0x1615C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_11_CPU_EGP_6 0x190D615Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP4_11_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_11_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_11_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_11_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_11_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_12_CPU_EGP_6 Register PTR_RTN_DW2_EP4_12_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_12_CPU_EGP_6 0x16160
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_12_CPU_EGP_6 0x190D6160u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_12_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_12_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_12_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_12_CPU_EGP_6 Register PTR_RTN_DW3_EP4_12_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_12_CPU_EGP_6 0x16164
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_12_CPU_EGP_6 0x190D6164u

//! Register Reset Value
#define PTR_RTN_DW3_EP4_12_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_12_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_12_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_12_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_12_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_13_CPU_EGP_6 Register PTR_RTN_DW2_EP4_13_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_13_CPU_EGP_6 0x16168
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_13_CPU_EGP_6 0x190D6168u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_13_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_13_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_13_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_13_CPU_EGP_6 Register PTR_RTN_DW3_EP4_13_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_13_CPU_EGP_6 0x1616C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_13_CPU_EGP_6 0x190D616Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP4_13_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_13_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_13_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_13_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_13_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_14_CPU_EGP_6 Register PTR_RTN_DW2_EP4_14_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_14_CPU_EGP_6 0x16170
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_14_CPU_EGP_6 0x190D6170u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_14_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_14_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_14_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_14_CPU_EGP_6 Register PTR_RTN_DW3_EP4_14_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_14_CPU_EGP_6 0x16174
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_14_CPU_EGP_6 0x190D6174u

//! Register Reset Value
#define PTR_RTN_DW3_EP4_14_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_14_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_14_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_14_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_14_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_15_CPU_EGP_6 Register PTR_RTN_DW2_EP4_15_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_15_CPU_EGP_6 0x16178
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_15_CPU_EGP_6 0x190D6178u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_15_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_15_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_15_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_15_CPU_EGP_6 Register PTR_RTN_DW3_EP4_15_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_15_CPU_EGP_6 0x1617C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_15_CPU_EGP_6 0x190D617Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP4_15_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_15_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_15_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_15_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_15_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_16_CPU_EGP_6 Register PTR_RTN_DW2_EP4_16_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_16_CPU_EGP_6 0x16180
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_16_CPU_EGP_6 0x190D6180u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_16_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_16_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_16_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_16_CPU_EGP_6 Register PTR_RTN_DW3_EP4_16_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_16_CPU_EGP_6 0x16184
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_16_CPU_EGP_6 0x190D6184u

//! Register Reset Value
#define PTR_RTN_DW3_EP4_16_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_16_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_16_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_16_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_16_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_17_CPU_EGP_6 Register PTR_RTN_DW2_EP4_17_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_17_CPU_EGP_6 0x16188
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_17_CPU_EGP_6 0x190D6188u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_17_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_17_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_17_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_17_CPU_EGP_6 Register PTR_RTN_DW3_EP4_17_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_17_CPU_EGP_6 0x1618C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_17_CPU_EGP_6 0x190D618Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP4_17_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_17_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_17_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_17_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_17_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_18_CPU_EGP_6 Register PTR_RTN_DW2_EP4_18_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_18_CPU_EGP_6 0x16190
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_18_CPU_EGP_6 0x190D6190u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_18_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_18_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_18_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_18_CPU_EGP_6 Register PTR_RTN_DW3_EP4_18_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_18_CPU_EGP_6 0x16194
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_18_CPU_EGP_6 0x190D6194u

//! Register Reset Value
#define PTR_RTN_DW3_EP4_18_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_18_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_18_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_18_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_18_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_19_CPU_EGP_6 Register PTR_RTN_DW2_EP4_19_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_19_CPU_EGP_6 0x16198
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_19_CPU_EGP_6 0x190D6198u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_19_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_19_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_19_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_19_CPU_EGP_6 Register PTR_RTN_DW3_EP4_19_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_19_CPU_EGP_6 0x1619C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_19_CPU_EGP_6 0x190D619Cu

//! Register Reset Value
#define PTR_RTN_DW3_EP4_19_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_19_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_19_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_19_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_19_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_20_CPU_EGP_6 Register PTR_RTN_DW2_EP4_20_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_20_CPU_EGP_6 0x161A0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_20_CPU_EGP_6 0x190D61A0u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_20_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_20_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_20_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_20_CPU_EGP_6 Register PTR_RTN_DW3_EP4_20_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_20_CPU_EGP_6 0x161A4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_20_CPU_EGP_6 0x190D61A4u

//! Register Reset Value
#define PTR_RTN_DW3_EP4_20_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_20_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_20_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_20_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_20_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_21_CPU_EGP_6 Register PTR_RTN_DW2_EP4_21_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_21_CPU_EGP_6 0x161A8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_21_CPU_EGP_6 0x190D61A8u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_21_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_21_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_21_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_21_CPU_EGP_6 Register PTR_RTN_DW3_EP4_21_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_21_CPU_EGP_6 0x161AC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_21_CPU_EGP_6 0x190D61ACu

//! Register Reset Value
#define PTR_RTN_DW3_EP4_21_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_21_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_21_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_21_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_21_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_22_CPU_EGP_6 Register PTR_RTN_DW2_EP4_22_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_22_CPU_EGP_6 0x161B0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_22_CPU_EGP_6 0x190D61B0u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_22_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_22_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_22_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_22_CPU_EGP_6 Register PTR_RTN_DW3_EP4_22_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_22_CPU_EGP_6 0x161B4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_22_CPU_EGP_6 0x190D61B4u

//! Register Reset Value
#define PTR_RTN_DW3_EP4_22_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_22_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_22_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_22_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_22_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_23_CPU_EGP_6 Register PTR_RTN_DW2_EP4_23_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_23_CPU_EGP_6 0x161B8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_23_CPU_EGP_6 0x190D61B8u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_23_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_23_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_23_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_23_CPU_EGP_6 Register PTR_RTN_DW3_EP4_23_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_23_CPU_EGP_6 0x161BC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_23_CPU_EGP_6 0x190D61BCu

//! Register Reset Value
#define PTR_RTN_DW3_EP4_23_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_23_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_23_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_23_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_23_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_24_CPU_EGP_6 Register PTR_RTN_DW2_EP4_24_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_24_CPU_EGP_6 0x161C0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_24_CPU_EGP_6 0x190D61C0u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_24_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_24_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_24_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_24_CPU_EGP_6 Register PTR_RTN_DW3_EP4_24_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_24_CPU_EGP_6 0x161C4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_24_CPU_EGP_6 0x190D61C4u

//! Register Reset Value
#define PTR_RTN_DW3_EP4_24_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_24_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_24_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_24_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_24_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_25_CPU_EGP_6 Register PTR_RTN_DW2_EP4_25_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_25_CPU_EGP_6 0x161C8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_25_CPU_EGP_6 0x190D61C8u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_25_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_25_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_25_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_25_CPU_EGP_6 Register PTR_RTN_DW3_EP4_25_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_25_CPU_EGP_6 0x161CC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_25_CPU_EGP_6 0x190D61CCu

//! Register Reset Value
#define PTR_RTN_DW3_EP4_25_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_25_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_25_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_25_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_25_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_26_CPU_EGP_6 Register PTR_RTN_DW2_EP4_26_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_26_CPU_EGP_6 0x161D0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_26_CPU_EGP_6 0x190D61D0u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_26_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_26_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_26_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_26_CPU_EGP_6 Register PTR_RTN_DW3_EP4_26_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_26_CPU_EGP_6 0x161D4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_26_CPU_EGP_6 0x190D61D4u

//! Register Reset Value
#define PTR_RTN_DW3_EP4_26_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_26_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_26_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_26_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_26_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_27_CPU_EGP_6 Register PTR_RTN_DW2_EP4_27_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_27_CPU_EGP_6 0x161D8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_27_CPU_EGP_6 0x190D61D8u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_27_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_27_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_27_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_27_CPU_EGP_6 Register PTR_RTN_DW3_EP4_27_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_27_CPU_EGP_6 0x161DC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_27_CPU_EGP_6 0x190D61DCu

//! Register Reset Value
#define PTR_RTN_DW3_EP4_27_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_27_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_27_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_27_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_27_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_28_CPU_EGP_6 Register PTR_RTN_DW2_EP4_28_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_28_CPU_EGP_6 0x161E0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_28_CPU_EGP_6 0x190D61E0u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_28_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_28_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_28_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_28_CPU_EGP_6 Register PTR_RTN_DW3_EP4_28_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_28_CPU_EGP_6 0x161E4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_28_CPU_EGP_6 0x190D61E4u

//! Register Reset Value
#define PTR_RTN_DW3_EP4_28_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_28_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_28_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_28_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_28_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_29_CPU_EGP_6 Register PTR_RTN_DW2_EP4_29_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_29_CPU_EGP_6 0x161E8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_29_CPU_EGP_6 0x190D61E8u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_29_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_29_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_29_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_29_CPU_EGP_6 Register PTR_RTN_DW3_EP4_29_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_29_CPU_EGP_6 0x161EC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_29_CPU_EGP_6 0x190D61ECu

//! Register Reset Value
#define PTR_RTN_DW3_EP4_29_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_29_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_29_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_29_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_29_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_30_CPU_EGP_6 Register PTR_RTN_DW2_EP4_30_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_30_CPU_EGP_6 0x161F0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_30_CPU_EGP_6 0x190D61F0u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_30_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_30_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_30_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_30_CPU_EGP_6 Register PTR_RTN_DW3_EP4_30_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_30_CPU_EGP_6 0x161F4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_30_CPU_EGP_6 0x190D61F4u

//! Register Reset Value
#define PTR_RTN_DW3_EP4_30_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_30_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_30_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_30_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_30_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup PTR_RTN_DW2_EP4_31_CPU_EGP_6 Register PTR_RTN_DW2_EP4_31_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW2_EP4_31_CPU_EGP_6 0x161F8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW2_EP4_31_CPU_EGP_6 0x190D61F8u

//! Register Reset Value
#define PTR_RTN_DW2_EP4_31_CPU_EGP_6_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_31_CPU_EGP_6_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_DW2_EP4_31_CPU_EGP_6_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_DW3_EP4_31_CPU_EGP_6 Register PTR_RTN_DW3_EP4_31_CPU_EGP_6 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_DW3_EP4_31_CPU_EGP_6 0x161FC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_DW3_EP4_31_CPU_EGP_6 0x190D61FCu

//! Register Reset Value
#define PTR_RTN_DW3_EP4_31_CPU_EGP_6_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_31_CPU_EGP_6_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_31_CPU_EGP_6_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_31_CPU_EGP_6_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_DW3_EP4_31_CPU_EGP_6_POLICY_MASK 0x700000u

//! @}

//! \defgroup DESC0_EP6_0_CPU_EGP_6 Register DESC0_EP6_0_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_0_CPU_EGP_6 0x16200
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_0_CPU_EGP_6 0x190D6200u

//! Register Reset Value
#define DESC0_EP6_0_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_0_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_0_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_0_CPU_EGP_6 Register DESC1_EP6_0_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_0_CPU_EGP_6 0x16204
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_0_CPU_EGP_6 0x190D6204u

//! Register Reset Value
#define DESC1_EP6_0_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_0_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_0_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_0_CPU_EGP_6 Register DESC2_EP6_0_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_0_CPU_EGP_6 0x16208
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_0_CPU_EGP_6 0x190D6208u

//! Register Reset Value
#define DESC2_EP6_0_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_0_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_0_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_0_CPU_EGP_6 Register DESC3_EP6_0_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_0_CPU_EGP_6 0x1620C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_0_CPU_EGP_6 0x190D620Cu

//! Register Reset Value
#define DESC3_EP6_0_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_0_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_0_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_1_CPU_EGP_6 Register DESC0_EP6_1_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_1_CPU_EGP_6 0x16210
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_1_CPU_EGP_6 0x190D6210u

//! Register Reset Value
#define DESC0_EP6_1_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_1_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_1_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_1_CPU_EGP_6 Register DESC1_EP6_1_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_1_CPU_EGP_6 0x16214
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_1_CPU_EGP_6 0x190D6214u

//! Register Reset Value
#define DESC1_EP6_1_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_1_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_1_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_1_CPU_EGP_6 Register DESC2_EP6_1_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_1_CPU_EGP_6 0x16218
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_1_CPU_EGP_6 0x190D6218u

//! Register Reset Value
#define DESC2_EP6_1_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_1_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_1_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_1_CPU_EGP_6 Register DESC3_EP6_1_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_1_CPU_EGP_6 0x1621C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_1_CPU_EGP_6 0x190D621Cu

//! Register Reset Value
#define DESC3_EP6_1_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_1_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_1_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_2_CPU_EGP_6 Register DESC0_EP6_2_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_2_CPU_EGP_6 0x16220
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_2_CPU_EGP_6 0x190D6220u

//! Register Reset Value
#define DESC0_EP6_2_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_2_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_2_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_2_CPU_EGP_6 Register DESC1_EP6_2_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_2_CPU_EGP_6 0x16224
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_2_CPU_EGP_6 0x190D6224u

//! Register Reset Value
#define DESC1_EP6_2_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_2_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_2_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_2_CPU_EGP_6 Register DESC2_EP6_2_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_2_CPU_EGP_6 0x16228
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_2_CPU_EGP_6 0x190D6228u

//! Register Reset Value
#define DESC2_EP6_2_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_2_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_2_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_2_CPU_EGP_6 Register DESC3_EP6_2_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_2_CPU_EGP_6 0x1622C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_2_CPU_EGP_6 0x190D622Cu

//! Register Reset Value
#define DESC3_EP6_2_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_2_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_2_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_3_CPU_EGP_6 Register DESC0_EP6_3_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_3_CPU_EGP_6 0x16230
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_3_CPU_EGP_6 0x190D6230u

//! Register Reset Value
#define DESC0_EP6_3_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_3_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_3_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_3_CPU_EGP_6 Register DESC1_EP6_3_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_3_CPU_EGP_6 0x16234
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_3_CPU_EGP_6 0x190D6234u

//! Register Reset Value
#define DESC1_EP6_3_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_3_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_3_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_3_CPU_EGP_6 Register DESC2_EP6_3_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_3_CPU_EGP_6 0x16238
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_3_CPU_EGP_6 0x190D6238u

//! Register Reset Value
#define DESC2_EP6_3_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_3_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_3_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_3_CPU_EGP_6 Register DESC3_EP6_3_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_3_CPU_EGP_6 0x1623C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_3_CPU_EGP_6 0x190D623Cu

//! Register Reset Value
#define DESC3_EP6_3_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_3_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_3_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_4_CPU_EGP_6 Register DESC0_EP6_4_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_4_CPU_EGP_6 0x16240
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_4_CPU_EGP_6 0x190D6240u

//! Register Reset Value
#define DESC0_EP6_4_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_4_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_4_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_4_CPU_EGP_6 Register DESC1_EP6_4_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_4_CPU_EGP_6 0x16244
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_4_CPU_EGP_6 0x190D6244u

//! Register Reset Value
#define DESC1_EP6_4_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_4_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_4_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_4_CPU_EGP_6 Register DESC2_EP6_4_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_4_CPU_EGP_6 0x16248
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_4_CPU_EGP_6 0x190D6248u

//! Register Reset Value
#define DESC2_EP6_4_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_4_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_4_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_4_CPU_EGP_6 Register DESC3_EP6_4_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_4_CPU_EGP_6 0x1624C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_4_CPU_EGP_6 0x190D624Cu

//! Register Reset Value
#define DESC3_EP6_4_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_4_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_4_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_5_CPU_EGP_6 Register DESC0_EP6_5_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_5_CPU_EGP_6 0x16250
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_5_CPU_EGP_6 0x190D6250u

//! Register Reset Value
#define DESC0_EP6_5_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_5_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_5_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_5_CPU_EGP_6 Register DESC1_EP6_5_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_5_CPU_EGP_6 0x16254
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_5_CPU_EGP_6 0x190D6254u

//! Register Reset Value
#define DESC1_EP6_5_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_5_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_5_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_5_CPU_EGP_6 Register DESC2_EP6_5_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_5_CPU_EGP_6 0x16258
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_5_CPU_EGP_6 0x190D6258u

//! Register Reset Value
#define DESC2_EP6_5_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_5_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_5_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_5_CPU_EGP_6 Register DESC3_EP6_5_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_5_CPU_EGP_6 0x1625C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_5_CPU_EGP_6 0x190D625Cu

//! Register Reset Value
#define DESC3_EP6_5_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_5_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_5_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_6_CPU_EGP_6 Register DESC0_EP6_6_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_6_CPU_EGP_6 0x16260
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_6_CPU_EGP_6 0x190D6260u

//! Register Reset Value
#define DESC0_EP6_6_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_6_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_6_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_6_CPU_EGP_6 Register DESC1_EP6_6_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_6_CPU_EGP_6 0x16264
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_6_CPU_EGP_6 0x190D6264u

//! Register Reset Value
#define DESC1_EP6_6_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_6_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_6_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_6_CPU_EGP_6 Register DESC2_EP6_6_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_6_CPU_EGP_6 0x16268
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_6_CPU_EGP_6 0x190D6268u

//! Register Reset Value
#define DESC2_EP6_6_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_6_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_6_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_6_CPU_EGP_6 Register DESC3_EP6_6_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_6_CPU_EGP_6 0x1626C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_6_CPU_EGP_6 0x190D626Cu

//! Register Reset Value
#define DESC3_EP6_6_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_6_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_6_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_7_CPU_EGP_6 Register DESC0_EP6_7_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_7_CPU_EGP_6 0x16270
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_7_CPU_EGP_6 0x190D6270u

//! Register Reset Value
#define DESC0_EP6_7_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_7_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_7_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_7_CPU_EGP_6 Register DESC1_EP6_7_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_7_CPU_EGP_6 0x16274
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_7_CPU_EGP_6 0x190D6274u

//! Register Reset Value
#define DESC1_EP6_7_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_7_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_7_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_7_CPU_EGP_6 Register DESC2_EP6_7_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_7_CPU_EGP_6 0x16278
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_7_CPU_EGP_6 0x190D6278u

//! Register Reset Value
#define DESC2_EP6_7_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_7_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_7_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_7_CPU_EGP_6 Register DESC3_EP6_7_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_7_CPU_EGP_6 0x1627C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_7_CPU_EGP_6 0x190D627Cu

//! Register Reset Value
#define DESC3_EP6_7_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_7_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_7_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_8_CPU_EGP_6 Register DESC0_EP6_8_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_8_CPU_EGP_6 0x16280
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_8_CPU_EGP_6 0x190D6280u

//! Register Reset Value
#define DESC0_EP6_8_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_8_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_8_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_8_CPU_EGP_6 Register DESC1_EP6_8_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_8_CPU_EGP_6 0x16284
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_8_CPU_EGP_6 0x190D6284u

//! Register Reset Value
#define DESC1_EP6_8_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_8_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_8_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_8_CPU_EGP_6 Register DESC2_EP6_8_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_8_CPU_EGP_6 0x16288
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_8_CPU_EGP_6 0x190D6288u

//! Register Reset Value
#define DESC2_EP6_8_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_8_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_8_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_8_CPU_EGP_6 Register DESC3_EP6_8_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_8_CPU_EGP_6 0x1628C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_8_CPU_EGP_6 0x190D628Cu

//! Register Reset Value
#define DESC3_EP6_8_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_8_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_8_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_9_CPU_EGP_6 Register DESC0_EP6_9_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_9_CPU_EGP_6 0x16290
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_9_CPU_EGP_6 0x190D6290u

//! Register Reset Value
#define DESC0_EP6_9_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_9_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_9_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_9_CPU_EGP_6 Register DESC1_EP6_9_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_9_CPU_EGP_6 0x16294
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_9_CPU_EGP_6 0x190D6294u

//! Register Reset Value
#define DESC1_EP6_9_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_9_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_9_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_9_CPU_EGP_6 Register DESC2_EP6_9_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_9_CPU_EGP_6 0x16298
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_9_CPU_EGP_6 0x190D6298u

//! Register Reset Value
#define DESC2_EP6_9_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_9_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_9_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_9_CPU_EGP_6 Register DESC3_EP6_9_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_9_CPU_EGP_6 0x1629C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_9_CPU_EGP_6 0x190D629Cu

//! Register Reset Value
#define DESC3_EP6_9_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_9_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_9_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_10_CPU_EGP_6 Register DESC0_EP6_10_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_10_CPU_EGP_6 0x162A0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_10_CPU_EGP_6 0x190D62A0u

//! Register Reset Value
#define DESC0_EP6_10_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_10_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_10_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_10_CPU_EGP_6 Register DESC1_EP6_10_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_10_CPU_EGP_6 0x162A4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_10_CPU_EGP_6 0x190D62A4u

//! Register Reset Value
#define DESC1_EP6_10_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_10_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_10_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_10_CPU_EGP_6 Register DESC2_EP6_10_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_10_CPU_EGP_6 0x162A8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_10_CPU_EGP_6 0x190D62A8u

//! Register Reset Value
#define DESC2_EP6_10_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_10_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_10_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_10_CPU_EGP_6 Register DESC3_EP6_10_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_10_CPU_EGP_6 0x162AC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_10_CPU_EGP_6 0x190D62ACu

//! Register Reset Value
#define DESC3_EP6_10_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_10_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_10_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_11_CPU_EGP_6 Register DESC0_EP6_11_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_11_CPU_EGP_6 0x162B0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_11_CPU_EGP_6 0x190D62B0u

//! Register Reset Value
#define DESC0_EP6_11_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_11_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_11_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_11_CPU_EGP_6 Register DESC1_EP6_11_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_11_CPU_EGP_6 0x162B4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_11_CPU_EGP_6 0x190D62B4u

//! Register Reset Value
#define DESC1_EP6_11_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_11_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_11_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_11_CPU_EGP_6 Register DESC2_EP6_11_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_11_CPU_EGP_6 0x162B8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_11_CPU_EGP_6 0x190D62B8u

//! Register Reset Value
#define DESC2_EP6_11_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_11_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_11_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_11_CPU_EGP_6 Register DESC3_EP6_11_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_11_CPU_EGP_6 0x162BC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_11_CPU_EGP_6 0x190D62BCu

//! Register Reset Value
#define DESC3_EP6_11_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_11_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_11_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_12_CPU_EGP_6 Register DESC0_EP6_12_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_12_CPU_EGP_6 0x162C0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_12_CPU_EGP_6 0x190D62C0u

//! Register Reset Value
#define DESC0_EP6_12_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_12_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_12_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_12_CPU_EGP_6 Register DESC1_EP6_12_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_12_CPU_EGP_6 0x162C4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_12_CPU_EGP_6 0x190D62C4u

//! Register Reset Value
#define DESC1_EP6_12_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_12_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_12_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_12_CPU_EGP_6 Register DESC2_EP6_12_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_12_CPU_EGP_6 0x162C8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_12_CPU_EGP_6 0x190D62C8u

//! Register Reset Value
#define DESC2_EP6_12_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_12_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_12_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_12_CPU_EGP_6 Register DESC3_EP6_12_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_12_CPU_EGP_6 0x162CC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_12_CPU_EGP_6 0x190D62CCu

//! Register Reset Value
#define DESC3_EP6_12_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_12_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_12_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_13_CPU_EGP_6 Register DESC0_EP6_13_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_13_CPU_EGP_6 0x162D0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_13_CPU_EGP_6 0x190D62D0u

//! Register Reset Value
#define DESC0_EP6_13_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_13_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_13_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_13_CPU_EGP_6 Register DESC1_EP6_13_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_13_CPU_EGP_6 0x162D4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_13_CPU_EGP_6 0x190D62D4u

//! Register Reset Value
#define DESC1_EP6_13_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_13_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_13_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_13_CPU_EGP_6 Register DESC2_EP6_13_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_13_CPU_EGP_6 0x162D8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_13_CPU_EGP_6 0x190D62D8u

//! Register Reset Value
#define DESC2_EP6_13_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_13_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_13_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_13_CPU_EGP_6 Register DESC3_EP6_13_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_13_CPU_EGP_6 0x162DC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_13_CPU_EGP_6 0x190D62DCu

//! Register Reset Value
#define DESC3_EP6_13_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_13_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_13_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_14_CPU_EGP_6 Register DESC0_EP6_14_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_14_CPU_EGP_6 0x162E0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_14_CPU_EGP_6 0x190D62E0u

//! Register Reset Value
#define DESC0_EP6_14_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_14_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_14_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_14_CPU_EGP_6 Register DESC1_EP6_14_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_14_CPU_EGP_6 0x162E4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_14_CPU_EGP_6 0x190D62E4u

//! Register Reset Value
#define DESC1_EP6_14_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_14_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_14_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_14_CPU_EGP_6 Register DESC2_EP6_14_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_14_CPU_EGP_6 0x162E8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_14_CPU_EGP_6 0x190D62E8u

//! Register Reset Value
#define DESC2_EP6_14_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_14_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_14_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_14_CPU_EGP_6 Register DESC3_EP6_14_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_14_CPU_EGP_6 0x162EC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_14_CPU_EGP_6 0x190D62ECu

//! Register Reset Value
#define DESC3_EP6_14_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_14_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_14_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_15_CPU_EGP_6 Register DESC0_EP6_15_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_15_CPU_EGP_6 0x162F0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_15_CPU_EGP_6 0x190D62F0u

//! Register Reset Value
#define DESC0_EP6_15_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_15_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_15_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_15_CPU_EGP_6 Register DESC1_EP6_15_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_15_CPU_EGP_6 0x162F4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_15_CPU_EGP_6 0x190D62F4u

//! Register Reset Value
#define DESC1_EP6_15_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_15_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_15_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_15_CPU_EGP_6 Register DESC2_EP6_15_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_15_CPU_EGP_6 0x162F8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_15_CPU_EGP_6 0x190D62F8u

//! Register Reset Value
#define DESC2_EP6_15_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_15_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_15_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_15_CPU_EGP_6 Register DESC3_EP6_15_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_15_CPU_EGP_6 0x162FC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_15_CPU_EGP_6 0x190D62FCu

//! Register Reset Value
#define DESC3_EP6_15_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_15_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_15_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_16_CPU_EGP_6 Register DESC0_EP6_16_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_16_CPU_EGP_6 0x16300
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_16_CPU_EGP_6 0x190D6300u

//! Register Reset Value
#define DESC0_EP6_16_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_16_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_16_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_16_CPU_EGP_6 Register DESC1_EP6_16_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_16_CPU_EGP_6 0x16304
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_16_CPU_EGP_6 0x190D6304u

//! Register Reset Value
#define DESC1_EP6_16_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_16_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_16_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_16_CPU_EGP_6 Register DESC2_EP6_16_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_16_CPU_EGP_6 0x16308
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_16_CPU_EGP_6 0x190D6308u

//! Register Reset Value
#define DESC2_EP6_16_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_16_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_16_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_16_CPU_EGP_6 Register DESC3_EP6_16_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_16_CPU_EGP_6 0x1630C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_16_CPU_EGP_6 0x190D630Cu

//! Register Reset Value
#define DESC3_EP6_16_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_16_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_16_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_17_CPU_EGP_6 Register DESC0_EP6_17_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_17_CPU_EGP_6 0x16310
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_17_CPU_EGP_6 0x190D6310u

//! Register Reset Value
#define DESC0_EP6_17_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_17_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_17_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_17_CPU_EGP_6 Register DESC1_EP6_17_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_17_CPU_EGP_6 0x16314
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_17_CPU_EGP_6 0x190D6314u

//! Register Reset Value
#define DESC1_EP6_17_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_17_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_17_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_17_CPU_EGP_6 Register DESC2_EP6_17_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_17_CPU_EGP_6 0x16318
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_17_CPU_EGP_6 0x190D6318u

//! Register Reset Value
#define DESC2_EP6_17_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_17_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_17_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_17_CPU_EGP_6 Register DESC3_EP6_17_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_17_CPU_EGP_6 0x1631C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_17_CPU_EGP_6 0x190D631Cu

//! Register Reset Value
#define DESC3_EP6_17_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_17_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_17_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_18_CPU_EGP_6 Register DESC0_EP6_18_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_18_CPU_EGP_6 0x16320
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_18_CPU_EGP_6 0x190D6320u

//! Register Reset Value
#define DESC0_EP6_18_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_18_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_18_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_18_CPU_EGP_6 Register DESC1_EP6_18_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_18_CPU_EGP_6 0x16324
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_18_CPU_EGP_6 0x190D6324u

//! Register Reset Value
#define DESC1_EP6_18_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_18_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_18_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_18_CPU_EGP_6 Register DESC2_EP6_18_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_18_CPU_EGP_6 0x16328
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_18_CPU_EGP_6 0x190D6328u

//! Register Reset Value
#define DESC2_EP6_18_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_18_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_18_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_18_CPU_EGP_6 Register DESC3_EP6_18_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_18_CPU_EGP_6 0x1632C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_18_CPU_EGP_6 0x190D632Cu

//! Register Reset Value
#define DESC3_EP6_18_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_18_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_18_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_19_CPU_EGP_6 Register DESC0_EP6_19_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_19_CPU_EGP_6 0x16330
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_19_CPU_EGP_6 0x190D6330u

//! Register Reset Value
#define DESC0_EP6_19_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_19_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_19_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_19_CPU_EGP_6 Register DESC1_EP6_19_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_19_CPU_EGP_6 0x16334
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_19_CPU_EGP_6 0x190D6334u

//! Register Reset Value
#define DESC1_EP6_19_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_19_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_19_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_19_CPU_EGP_6 Register DESC2_EP6_19_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_19_CPU_EGP_6 0x16338
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_19_CPU_EGP_6 0x190D6338u

//! Register Reset Value
#define DESC2_EP6_19_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_19_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_19_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_19_CPU_EGP_6 Register DESC3_EP6_19_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_19_CPU_EGP_6 0x1633C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_19_CPU_EGP_6 0x190D633Cu

//! Register Reset Value
#define DESC3_EP6_19_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_19_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_19_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_20_CPU_EGP_6 Register DESC0_EP6_20_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_20_CPU_EGP_6 0x16340
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_20_CPU_EGP_6 0x190D6340u

//! Register Reset Value
#define DESC0_EP6_20_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_20_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_20_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_20_CPU_EGP_6 Register DESC1_EP6_20_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_20_CPU_EGP_6 0x16344
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_20_CPU_EGP_6 0x190D6344u

//! Register Reset Value
#define DESC1_EP6_20_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_20_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_20_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_20_CPU_EGP_6 Register DESC2_EP6_20_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_20_CPU_EGP_6 0x16348
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_20_CPU_EGP_6 0x190D6348u

//! Register Reset Value
#define DESC2_EP6_20_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_20_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_20_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_20_CPU_EGP_6 Register DESC3_EP6_20_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_20_CPU_EGP_6 0x1634C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_20_CPU_EGP_6 0x190D634Cu

//! Register Reset Value
#define DESC3_EP6_20_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_20_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_20_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_21_CPU_EGP_6 Register DESC0_EP6_21_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_21_CPU_EGP_6 0x16350
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_21_CPU_EGP_6 0x190D6350u

//! Register Reset Value
#define DESC0_EP6_21_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_21_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_21_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_21_CPU_EGP_6 Register DESC1_EP6_21_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_21_CPU_EGP_6 0x16354
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_21_CPU_EGP_6 0x190D6354u

//! Register Reset Value
#define DESC1_EP6_21_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_21_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_21_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_21_CPU_EGP_6 Register DESC2_EP6_21_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_21_CPU_EGP_6 0x16358
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_21_CPU_EGP_6 0x190D6358u

//! Register Reset Value
#define DESC2_EP6_21_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_21_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_21_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_21_CPU_EGP_6 Register DESC3_EP6_21_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_21_CPU_EGP_6 0x1635C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_21_CPU_EGP_6 0x190D635Cu

//! Register Reset Value
#define DESC3_EP6_21_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_21_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_21_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_22_CPU_EGP_6 Register DESC0_EP6_22_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_22_CPU_EGP_6 0x16360
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_22_CPU_EGP_6 0x190D6360u

//! Register Reset Value
#define DESC0_EP6_22_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_22_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_22_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_22_CPU_EGP_6 Register DESC1_EP6_22_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_22_CPU_EGP_6 0x16364
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_22_CPU_EGP_6 0x190D6364u

//! Register Reset Value
#define DESC1_EP6_22_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_22_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_22_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_22_CPU_EGP_6 Register DESC2_EP6_22_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_22_CPU_EGP_6 0x16368
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_22_CPU_EGP_6 0x190D6368u

//! Register Reset Value
#define DESC2_EP6_22_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_22_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_22_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_22_CPU_EGP_6 Register DESC3_EP6_22_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_22_CPU_EGP_6 0x1636C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_22_CPU_EGP_6 0x190D636Cu

//! Register Reset Value
#define DESC3_EP6_22_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_22_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_22_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_23_CPU_EGP_6 Register DESC0_EP6_23_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_23_CPU_EGP_6 0x16370
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_23_CPU_EGP_6 0x190D6370u

//! Register Reset Value
#define DESC0_EP6_23_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_23_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_23_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_23_CPU_EGP_6 Register DESC1_EP6_23_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_23_CPU_EGP_6 0x16374
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_23_CPU_EGP_6 0x190D6374u

//! Register Reset Value
#define DESC1_EP6_23_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_23_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_23_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_23_CPU_EGP_6 Register DESC2_EP6_23_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_23_CPU_EGP_6 0x16378
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_23_CPU_EGP_6 0x190D6378u

//! Register Reset Value
#define DESC2_EP6_23_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_23_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_23_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_23_CPU_EGP_6 Register DESC3_EP6_23_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_23_CPU_EGP_6 0x1637C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_23_CPU_EGP_6 0x190D637Cu

//! Register Reset Value
#define DESC3_EP6_23_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_23_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_23_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_24_CPU_EGP_6 Register DESC0_EP6_24_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_24_CPU_EGP_6 0x16380
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_24_CPU_EGP_6 0x190D6380u

//! Register Reset Value
#define DESC0_EP6_24_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_24_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_24_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_24_CPU_EGP_6 Register DESC1_EP6_24_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_24_CPU_EGP_6 0x16384
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_24_CPU_EGP_6 0x190D6384u

//! Register Reset Value
#define DESC1_EP6_24_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_24_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_24_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_24_CPU_EGP_6 Register DESC2_EP6_24_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_24_CPU_EGP_6 0x16388
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_24_CPU_EGP_6 0x190D6388u

//! Register Reset Value
#define DESC2_EP6_24_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_24_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_24_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_24_CPU_EGP_6 Register DESC3_EP6_24_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_24_CPU_EGP_6 0x1638C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_24_CPU_EGP_6 0x190D638Cu

//! Register Reset Value
#define DESC3_EP6_24_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_24_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_24_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_25_CPU_EGP_6 Register DESC0_EP6_25_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_25_CPU_EGP_6 0x16390
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_25_CPU_EGP_6 0x190D6390u

//! Register Reset Value
#define DESC0_EP6_25_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_25_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_25_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_25_CPU_EGP_6 Register DESC1_EP6_25_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_25_CPU_EGP_6 0x16394
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_25_CPU_EGP_6 0x190D6394u

//! Register Reset Value
#define DESC1_EP6_25_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_25_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_25_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_25_CPU_EGP_6 Register DESC2_EP6_25_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_25_CPU_EGP_6 0x16398
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_25_CPU_EGP_6 0x190D6398u

//! Register Reset Value
#define DESC2_EP6_25_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_25_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_25_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_25_CPU_EGP_6 Register DESC3_EP6_25_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_25_CPU_EGP_6 0x1639C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_25_CPU_EGP_6 0x190D639Cu

//! Register Reset Value
#define DESC3_EP6_25_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_25_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_25_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_26_CPU_EGP_6 Register DESC0_EP6_26_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_26_CPU_EGP_6 0x163A0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_26_CPU_EGP_6 0x190D63A0u

//! Register Reset Value
#define DESC0_EP6_26_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_26_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_26_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_26_CPU_EGP_6 Register DESC1_EP6_26_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_26_CPU_EGP_6 0x163A4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_26_CPU_EGP_6 0x190D63A4u

//! Register Reset Value
#define DESC1_EP6_26_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_26_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_26_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_26_CPU_EGP_6 Register DESC2_EP6_26_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_26_CPU_EGP_6 0x163A8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_26_CPU_EGP_6 0x190D63A8u

//! Register Reset Value
#define DESC2_EP6_26_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_26_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_26_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_26_CPU_EGP_6 Register DESC3_EP6_26_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_26_CPU_EGP_6 0x163AC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_26_CPU_EGP_6 0x190D63ACu

//! Register Reset Value
#define DESC3_EP6_26_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_26_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_26_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_27_CPU_EGP_6 Register DESC0_EP6_27_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_27_CPU_EGP_6 0x163B0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_27_CPU_EGP_6 0x190D63B0u

//! Register Reset Value
#define DESC0_EP6_27_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_27_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_27_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_27_CPU_EGP_6 Register DESC1_EP6_27_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_27_CPU_EGP_6 0x163B4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_27_CPU_EGP_6 0x190D63B4u

//! Register Reset Value
#define DESC1_EP6_27_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_27_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_27_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_27_CPU_EGP_6 Register DESC2_EP6_27_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_27_CPU_EGP_6 0x163B8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_27_CPU_EGP_6 0x190D63B8u

//! Register Reset Value
#define DESC2_EP6_27_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_27_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_27_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_27_CPU_EGP_6 Register DESC3_EP6_27_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_27_CPU_EGP_6 0x163BC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_27_CPU_EGP_6 0x190D63BCu

//! Register Reset Value
#define DESC3_EP6_27_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_27_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_27_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_28_CPU_EGP_6 Register DESC0_EP6_28_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_28_CPU_EGP_6 0x163C0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_28_CPU_EGP_6 0x190D63C0u

//! Register Reset Value
#define DESC0_EP6_28_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_28_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_28_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_28_CPU_EGP_6 Register DESC1_EP6_28_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_28_CPU_EGP_6 0x163C4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_28_CPU_EGP_6 0x190D63C4u

//! Register Reset Value
#define DESC1_EP6_28_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_28_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_28_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_28_CPU_EGP_6 Register DESC2_EP6_28_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_28_CPU_EGP_6 0x163C8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_28_CPU_EGP_6 0x190D63C8u

//! Register Reset Value
#define DESC2_EP6_28_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_28_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_28_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_28_CPU_EGP_6 Register DESC3_EP6_28_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_28_CPU_EGP_6 0x163CC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_28_CPU_EGP_6 0x190D63CCu

//! Register Reset Value
#define DESC3_EP6_28_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_28_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_28_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_29_CPU_EGP_6 Register DESC0_EP6_29_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_29_CPU_EGP_6 0x163D0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_29_CPU_EGP_6 0x190D63D0u

//! Register Reset Value
#define DESC0_EP6_29_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_29_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_29_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_29_CPU_EGP_6 Register DESC1_EP6_29_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_29_CPU_EGP_6 0x163D4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_29_CPU_EGP_6 0x190D63D4u

//! Register Reset Value
#define DESC1_EP6_29_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_29_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_29_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_29_CPU_EGP_6 Register DESC2_EP6_29_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_29_CPU_EGP_6 0x163D8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_29_CPU_EGP_6 0x190D63D8u

//! Register Reset Value
#define DESC2_EP6_29_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_29_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_29_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_29_CPU_EGP_6 Register DESC3_EP6_29_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_29_CPU_EGP_6 0x163DC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_29_CPU_EGP_6 0x190D63DCu

//! Register Reset Value
#define DESC3_EP6_29_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_29_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_29_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_30_CPU_EGP_6 Register DESC0_EP6_30_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_30_CPU_EGP_6 0x163E0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_30_CPU_EGP_6 0x190D63E0u

//! Register Reset Value
#define DESC0_EP6_30_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_30_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_30_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_30_CPU_EGP_6 Register DESC1_EP6_30_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_30_CPU_EGP_6 0x163E4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_30_CPU_EGP_6 0x190D63E4u

//! Register Reset Value
#define DESC1_EP6_30_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_30_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_30_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_30_CPU_EGP_6 Register DESC2_EP6_30_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_30_CPU_EGP_6 0x163E8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_30_CPU_EGP_6 0x190D63E8u

//! Register Reset Value
#define DESC2_EP6_30_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_30_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_30_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_30_CPU_EGP_6 Register DESC3_EP6_30_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_30_CPU_EGP_6 0x163EC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_30_CPU_EGP_6 0x190D63ECu

//! Register Reset Value
#define DESC3_EP6_30_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_30_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_30_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC0_EP6_31_CPU_EGP_6 Register DESC0_EP6_31_CPU_EGP_6 - Special CPU Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_EP6_31_CPU_EGP_6 0x163F0
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_EP6_31_CPU_EGP_6 0x190D63F0u

//! Register Reset Value
#define DESC0_EP6_31_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_31_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_EP6_31_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_EP6_31_CPU_EGP_6 Register DESC1_EP6_31_CPU_EGP_6 - Special CPU Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_EP6_31_CPU_EGP_6 0x163F4
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_EP6_31_CPU_EGP_6 0x190D63F4u

//! Register Reset Value
#define DESC1_EP6_31_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_31_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_EP6_31_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_EP6_31_CPU_EGP_6 Register DESC2_EP6_31_CPU_EGP_6 - Special CPU Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_EP6_31_CPU_EGP_6 0x163F8
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_EP6_31_CPU_EGP_6 0x190D63F8u

//! Register Reset Value
#define DESC2_EP6_31_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_31_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_EP6_31_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_EP6_31_CPU_EGP_6 Register DESC3_EP6_31_CPU_EGP_6 - Special CPU Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_EP6_31_CPU_EGP_6 0x163FC
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_EP6_31_CPU_EGP_6 0x190D63FCu

//! Register Reset Value
#define DESC3_EP6_31_CPU_EGP_6_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_31_CPU_EGP_6_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_EP6_31_CPU_EGP_6_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup CFG_DMA_EGP_7 Register CFG_DMA_EGP_7 - DMA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_DMA_EGP_7 0x17000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_DMA_EGP_7 0x190D7000u

//! Register Reset Value
#define CFG_DMA_EGP_7_RST 0x00000000u

//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_7_DQREQ_POS 0
//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_7_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_7_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_7_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_7_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_7_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_7_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_7_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_7_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_7_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_DMA_EGP_7 Register DQPC_DMA_EGP_7 - DMA Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_DMA_EGP_7 0x17004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_DMA_EGP_7 0x190D7004u

//! Register Reset Value
#define DQPC_DMA_EGP_7_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_7_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_7_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_DMA_EGP_7 Register IRNCR_DMA_EGP_7 - DMA Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_DMA_EGP_7 0x17020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_DMA_EGP_7 0x190D7020u

//! Register Reset Value
#define IRNCR_DMA_EGP_7_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_7_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_7_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_DMA_EGP_7_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_DMA_EGP_7_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_DMA_EGP_7 Register IRNICR_DMA_EGP_7 - DMA Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_DMA_EGP_7 0x17024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_DMA_EGP_7 0x190D7024u

//! Register Reset Value
#define IRNICR_DMA_EGP_7_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_7_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_7_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_DMA_EGP_7 Register IRNEN_DMA_EGP_7 - DMA Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_DMA_EGP_7 0x17028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_DMA_EGP_7 0x190D7028u

//! Register Reset Value
#define IRNEN_DMA_EGP_7_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_7_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_7_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_DMA_EGP_7_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_DMA_EGP_7_DR_EN 0x1

//! @}

//! \defgroup DPTR_DMA_EGP_7 Register DPTR_DMA_EGP_7 - DMA Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_DMA_EGP_7 0x17030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_DMA_EGP_7 0x190D7030u

//! Register Reset Value
#define DPTR_DMA_EGP_7_RST 0x00000007u

//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_7_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_7_ND_MASK 0x7u

//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_7_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_7_DPTR_MASK 0x70000u

//! @}

//! \defgroup CFG_DMA_EGP_8 Register CFG_DMA_EGP_8 - DMA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_DMA_EGP_8 0x18000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_DMA_EGP_8 0x190D8000u

//! Register Reset Value
#define CFG_DMA_EGP_8_RST 0x00000000u

//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_8_DQREQ_POS 0
//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_8_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_8_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_8_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_8_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_8_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_8_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_8_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_8_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_8_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_DMA_EGP_8 Register DQPC_DMA_EGP_8 - DMA Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_DMA_EGP_8 0x18004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_DMA_EGP_8 0x190D8004u

//! Register Reset Value
#define DQPC_DMA_EGP_8_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_8_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_8_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_DMA_EGP_8 Register IRNCR_DMA_EGP_8 - DMA Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_DMA_EGP_8 0x18020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_DMA_EGP_8 0x190D8020u

//! Register Reset Value
#define IRNCR_DMA_EGP_8_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_8_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_8_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_DMA_EGP_8_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_DMA_EGP_8_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_DMA_EGP_8 Register IRNICR_DMA_EGP_8 - DMA Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_DMA_EGP_8 0x18024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_DMA_EGP_8 0x190D8024u

//! Register Reset Value
#define IRNICR_DMA_EGP_8_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_8_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_8_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_DMA_EGP_8 Register IRNEN_DMA_EGP_8 - DMA Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_DMA_EGP_8 0x18028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_DMA_EGP_8 0x190D8028u

//! Register Reset Value
#define IRNEN_DMA_EGP_8_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_8_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_8_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_DMA_EGP_8_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_DMA_EGP_8_DR_EN 0x1

//! @}

//! \defgroup DPTR_DMA_EGP_8 Register DPTR_DMA_EGP_8 - DMA Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_DMA_EGP_8 0x18030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_DMA_EGP_8 0x190D8030u

//! Register Reset Value
#define DPTR_DMA_EGP_8_RST 0x00000007u

//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_8_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_8_ND_MASK 0x7u

//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_8_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_8_DPTR_MASK 0x70000u

//! @}

//! \defgroup CFG_DMA_EGP_9 Register CFG_DMA_EGP_9 - DMA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_DMA_EGP_9 0x19000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_DMA_EGP_9 0x190D9000u

//! Register Reset Value
#define CFG_DMA_EGP_9_RST 0x00000000u

//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_9_DQREQ_POS 0
//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_9_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_9_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_9_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_9_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_9_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_9_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_9_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_9_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_9_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_DMA_EGP_9 Register DQPC_DMA_EGP_9 - DMA Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_DMA_EGP_9 0x19004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_DMA_EGP_9 0x190D9004u

//! Register Reset Value
#define DQPC_DMA_EGP_9_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_9_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_9_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_DMA_EGP_9 Register IRNCR_DMA_EGP_9 - DMA Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_DMA_EGP_9 0x19020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_DMA_EGP_9 0x190D9020u

//! Register Reset Value
#define IRNCR_DMA_EGP_9_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_9_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_9_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_DMA_EGP_9_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_DMA_EGP_9_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_DMA_EGP_9 Register IRNICR_DMA_EGP_9 - DMA Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_DMA_EGP_9 0x19024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_DMA_EGP_9 0x190D9024u

//! Register Reset Value
#define IRNICR_DMA_EGP_9_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_9_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_9_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_DMA_EGP_9 Register IRNEN_DMA_EGP_9 - DMA Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_DMA_EGP_9 0x19028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_DMA_EGP_9 0x190D9028u

//! Register Reset Value
#define IRNEN_DMA_EGP_9_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_9_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_9_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_DMA_EGP_9_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_DMA_EGP_9_DR_EN 0x1

//! @}

//! \defgroup DPTR_DMA_EGP_9 Register DPTR_DMA_EGP_9 - DMA Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_DMA_EGP_9 0x19030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_DMA_EGP_9 0x190D9030u

//! Register Reset Value
#define DPTR_DMA_EGP_9_RST 0x00000007u

//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_9_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_9_ND_MASK 0x7u

//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_9_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_9_DPTR_MASK 0x70000u

//! @}

//! \defgroup CFG_DMA_EGP_10 Register CFG_DMA_EGP_10 - DMA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_DMA_EGP_10 0x1A000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_DMA_EGP_10 0x190DA000u

//! Register Reset Value
#define CFG_DMA_EGP_10_RST 0x00000000u

//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_10_DQREQ_POS 0
//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_10_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_10_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_10_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_10_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_10_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_10_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_10_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_10_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_10_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_DMA_EGP_10 Register DQPC_DMA_EGP_10 - DMA Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_DMA_EGP_10 0x1A004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_DMA_EGP_10 0x190DA004u

//! Register Reset Value
#define DQPC_DMA_EGP_10_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_10_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_10_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_DMA_EGP_10 Register IRNCR_DMA_EGP_10 - DMA Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_DMA_EGP_10 0x1A020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_DMA_EGP_10 0x190DA020u

//! Register Reset Value
#define IRNCR_DMA_EGP_10_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_10_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_10_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_DMA_EGP_10_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_DMA_EGP_10_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_DMA_EGP_10 Register IRNICR_DMA_EGP_10 - DMA Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_DMA_EGP_10 0x1A024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_DMA_EGP_10 0x190DA024u

//! Register Reset Value
#define IRNICR_DMA_EGP_10_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_10_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_10_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_DMA_EGP_10 Register IRNEN_DMA_EGP_10 - DMA Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_DMA_EGP_10 0x1A028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_DMA_EGP_10 0x190DA028u

//! Register Reset Value
#define IRNEN_DMA_EGP_10_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_10_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_10_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_DMA_EGP_10_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_DMA_EGP_10_DR_EN 0x1

//! @}

//! \defgroup DPTR_DMA_EGP_10 Register DPTR_DMA_EGP_10 - DMA Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_DMA_EGP_10 0x1A030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_DMA_EGP_10 0x190DA030u

//! Register Reset Value
#define DPTR_DMA_EGP_10_RST 0x00000007u

//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_10_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_10_ND_MASK 0x7u

//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_10_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_10_DPTR_MASK 0x70000u

//! @}

//! \defgroup CFG_DMA_EGP_11 Register CFG_DMA_EGP_11 - DMA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_DMA_EGP_11 0x1B000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_DMA_EGP_11 0x190DB000u

//! Register Reset Value
#define CFG_DMA_EGP_11_RST 0x00000000u

//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_11_DQREQ_POS 0
//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_11_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_11_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_11_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_11_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_11_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_11_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_11_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_11_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_11_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_DMA_EGP_11 Register DQPC_DMA_EGP_11 - DMA Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_DMA_EGP_11 0x1B004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_DMA_EGP_11 0x190DB004u

//! Register Reset Value
#define DQPC_DMA_EGP_11_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_11_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_11_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_DMA_EGP_11 Register IRNCR_DMA_EGP_11 - DMA Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_DMA_EGP_11 0x1B020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_DMA_EGP_11 0x190DB020u

//! Register Reset Value
#define IRNCR_DMA_EGP_11_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_11_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_11_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_DMA_EGP_11_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_DMA_EGP_11_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_DMA_EGP_11 Register IRNICR_DMA_EGP_11 - DMA Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_DMA_EGP_11 0x1B024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_DMA_EGP_11 0x190DB024u

//! Register Reset Value
#define IRNICR_DMA_EGP_11_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_11_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_11_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_DMA_EGP_11 Register IRNEN_DMA_EGP_11 - DMA Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_DMA_EGP_11 0x1B028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_DMA_EGP_11 0x190DB028u

//! Register Reset Value
#define IRNEN_DMA_EGP_11_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_11_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_11_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_DMA_EGP_11_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_DMA_EGP_11_DR_EN 0x1

//! @}

//! \defgroup DPTR_DMA_EGP_11 Register DPTR_DMA_EGP_11 - DMA Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_DMA_EGP_11 0x1B030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_DMA_EGP_11 0x190DB030u

//! Register Reset Value
#define DPTR_DMA_EGP_11_RST 0x00000007u

//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_11_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_11_ND_MASK 0x7u

//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_11_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_11_DPTR_MASK 0x70000u

//! @}

//! \defgroup CFG_DMA_EGP_12 Register CFG_DMA_EGP_12 - DMA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_DMA_EGP_12 0x1C000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_DMA_EGP_12 0x190DC000u

//! Register Reset Value
#define CFG_DMA_EGP_12_RST 0x00000000u

//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_12_DQREQ_POS 0
//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_12_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_12_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_12_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_12_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_12_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_12_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_12_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_12_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_12_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_DMA_EGP_12 Register DQPC_DMA_EGP_12 - DMA Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_DMA_EGP_12 0x1C004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_DMA_EGP_12 0x190DC004u

//! Register Reset Value
#define DQPC_DMA_EGP_12_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_12_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_12_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_DMA_EGP_12 Register IRNCR_DMA_EGP_12 - DMA Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_DMA_EGP_12 0x1C020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_DMA_EGP_12 0x190DC020u

//! Register Reset Value
#define IRNCR_DMA_EGP_12_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_12_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_12_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_DMA_EGP_12_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_DMA_EGP_12_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_DMA_EGP_12 Register IRNICR_DMA_EGP_12 - DMA Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_DMA_EGP_12 0x1C024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_DMA_EGP_12 0x190DC024u

//! Register Reset Value
#define IRNICR_DMA_EGP_12_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_12_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_12_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_DMA_EGP_12 Register IRNEN_DMA_EGP_12 - DMA Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_DMA_EGP_12 0x1C028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_DMA_EGP_12 0x190DC028u

//! Register Reset Value
#define IRNEN_DMA_EGP_12_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_12_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_12_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_DMA_EGP_12_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_DMA_EGP_12_DR_EN 0x1

//! @}

//! \defgroup DPTR_DMA_EGP_12 Register DPTR_DMA_EGP_12 - DMA Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_DMA_EGP_12 0x1C030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_DMA_EGP_12 0x190DC030u

//! Register Reset Value
#define DPTR_DMA_EGP_12_RST 0x00000007u

//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_12_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_12_ND_MASK 0x7u

//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_12_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_12_DPTR_MASK 0x70000u

//! @}

//! \defgroup CFG_DMA_EGP_13 Register CFG_DMA_EGP_13 - DMA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_DMA_EGP_13 0x1D000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_DMA_EGP_13 0x190DD000u

//! Register Reset Value
#define CFG_DMA_EGP_13_RST 0x00000000u

//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_13_DQREQ_POS 0
//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_13_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_13_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_13_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_13_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_13_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_13_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_13_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_13_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_13_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_DMA_EGP_13 Register DQPC_DMA_EGP_13 - DMA Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_DMA_EGP_13 0x1D004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_DMA_EGP_13 0x190DD004u

//! Register Reset Value
#define DQPC_DMA_EGP_13_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_13_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_13_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_DMA_EGP_13 Register IRNCR_DMA_EGP_13 - DMA Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_DMA_EGP_13 0x1D020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_DMA_EGP_13 0x190DD020u

//! Register Reset Value
#define IRNCR_DMA_EGP_13_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_13_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_13_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_DMA_EGP_13_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_DMA_EGP_13_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_DMA_EGP_13 Register IRNICR_DMA_EGP_13 - DMA Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_DMA_EGP_13 0x1D024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_DMA_EGP_13 0x190DD024u

//! Register Reset Value
#define IRNICR_DMA_EGP_13_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_13_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_13_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_DMA_EGP_13 Register IRNEN_DMA_EGP_13 - DMA Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_DMA_EGP_13 0x1D028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_DMA_EGP_13 0x190DD028u

//! Register Reset Value
#define IRNEN_DMA_EGP_13_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_13_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_13_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_DMA_EGP_13_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_DMA_EGP_13_DR_EN 0x1

//! @}

//! \defgroup DPTR_DMA_EGP_13 Register DPTR_DMA_EGP_13 - DMA Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_DMA_EGP_13 0x1D030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_DMA_EGP_13 0x190DD030u

//! Register Reset Value
#define DPTR_DMA_EGP_13_RST 0x00000007u

//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_13_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_13_ND_MASK 0x7u

//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_13_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_13_DPTR_MASK 0x70000u

//! @}

//! \defgroup CFG_DMA_EGP_14 Register CFG_DMA_EGP_14 - DMA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_DMA_EGP_14 0x1E000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_DMA_EGP_14 0x190DE000u

//! Register Reset Value
#define CFG_DMA_EGP_14_RST 0x00000000u

//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_14_DQREQ_POS 0
//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_14_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_14_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_14_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_14_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_14_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_14_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_14_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_14_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_14_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_DMA_EGP_14 Register DQPC_DMA_EGP_14 - DMA Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_DMA_EGP_14 0x1E004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_DMA_EGP_14 0x190DE004u

//! Register Reset Value
#define DQPC_DMA_EGP_14_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_14_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_14_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_DMA_EGP_14 Register IRNCR_DMA_EGP_14 - DMA Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_DMA_EGP_14 0x1E020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_DMA_EGP_14 0x190DE020u

//! Register Reset Value
#define IRNCR_DMA_EGP_14_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_14_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_14_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_DMA_EGP_14_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_DMA_EGP_14_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_DMA_EGP_14 Register IRNICR_DMA_EGP_14 - DMA Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_DMA_EGP_14 0x1E024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_DMA_EGP_14 0x190DE024u

//! Register Reset Value
#define IRNICR_DMA_EGP_14_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_14_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_14_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_DMA_EGP_14 Register IRNEN_DMA_EGP_14 - DMA Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_DMA_EGP_14 0x1E028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_DMA_EGP_14 0x190DE028u

//! Register Reset Value
#define IRNEN_DMA_EGP_14_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_14_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_14_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_DMA_EGP_14_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_DMA_EGP_14_DR_EN 0x1

//! @}

//! \defgroup DPTR_DMA_EGP_14 Register DPTR_DMA_EGP_14 - DMA Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_DMA_EGP_14 0x1E030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_DMA_EGP_14 0x190DE030u

//! Register Reset Value
#define DPTR_DMA_EGP_14_RST 0x00000007u

//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_14_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_14_ND_MASK 0x7u

//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_14_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_14_DPTR_MASK 0x70000u

//! @}

//! \defgroup CFG_DMA_EGP_15 Register CFG_DMA_EGP_15 - DMA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_DMA_EGP_15 0x1F000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_DMA_EGP_15 0x190DF000u

//! Register Reset Value
#define CFG_DMA_EGP_15_RST 0x00000000u

//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_15_DQREQ_POS 0
//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_15_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_15_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_15_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_15_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_15_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_15_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_15_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_15_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_15_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_DMA_EGP_15 Register DQPC_DMA_EGP_15 - DMA Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_DMA_EGP_15 0x1F004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_DMA_EGP_15 0x190DF004u

//! Register Reset Value
#define DQPC_DMA_EGP_15_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_15_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_15_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_DMA_EGP_15 Register IRNCR_DMA_EGP_15 - DMA Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_DMA_EGP_15 0x1F020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_DMA_EGP_15 0x190DF020u

//! Register Reset Value
#define IRNCR_DMA_EGP_15_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_15_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_15_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_DMA_EGP_15_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_DMA_EGP_15_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_DMA_EGP_15 Register IRNICR_DMA_EGP_15 - DMA Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_DMA_EGP_15 0x1F024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_DMA_EGP_15 0x190DF024u

//! Register Reset Value
#define IRNICR_DMA_EGP_15_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_15_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_15_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_DMA_EGP_15 Register IRNEN_DMA_EGP_15 - DMA Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_DMA_EGP_15 0x1F028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_DMA_EGP_15 0x190DF028u

//! Register Reset Value
#define IRNEN_DMA_EGP_15_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_15_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_15_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_DMA_EGP_15_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_DMA_EGP_15_DR_EN 0x1

//! @}

//! \defgroup DPTR_DMA_EGP_15 Register DPTR_DMA_EGP_15 - DMA Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_DMA_EGP_15 0x1F030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_DMA_EGP_15 0x190DF030u

//! Register Reset Value
#define DPTR_DMA_EGP_15_RST 0x00000007u

//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_15_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_15_ND_MASK 0x7u

//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_15_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_15_DPTR_MASK 0x70000u

//! @}

//! \defgroup CFG_DMA_EGP_16 Register CFG_DMA_EGP_16 - DMA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_DMA_EGP_16 0x20000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_DMA_EGP_16 0x190E0000u

//! Register Reset Value
#define CFG_DMA_EGP_16_RST 0x00000000u

//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_16_DQREQ_POS 0
//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_16_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_16_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_16_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_16_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_16_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_16_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_16_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_16_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_16_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_DMA_EGP_16 Register DQPC_DMA_EGP_16 - DMA Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_DMA_EGP_16 0x20004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_DMA_EGP_16 0x190E0004u

//! Register Reset Value
#define DQPC_DMA_EGP_16_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_16_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_16_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_DMA_EGP_16 Register IRNCR_DMA_EGP_16 - DMA Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_DMA_EGP_16 0x20020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_DMA_EGP_16 0x190E0020u

//! Register Reset Value
#define IRNCR_DMA_EGP_16_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_16_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_16_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_DMA_EGP_16_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_DMA_EGP_16_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_DMA_EGP_16 Register IRNICR_DMA_EGP_16 - DMA Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_DMA_EGP_16 0x20024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_DMA_EGP_16 0x190E0024u

//! Register Reset Value
#define IRNICR_DMA_EGP_16_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_16_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_16_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_DMA_EGP_16 Register IRNEN_DMA_EGP_16 - DMA Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_DMA_EGP_16 0x20028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_DMA_EGP_16 0x190E0028u

//! Register Reset Value
#define IRNEN_DMA_EGP_16_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_16_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_16_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_DMA_EGP_16_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_DMA_EGP_16_DR_EN 0x1

//! @}

//! \defgroup DPTR_DMA_EGP_16 Register DPTR_DMA_EGP_16 - DMA Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_DMA_EGP_16 0x20030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_DMA_EGP_16 0x190E0030u

//! Register Reset Value
#define DPTR_DMA_EGP_16_RST 0x00000007u

//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_16_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_16_ND_MASK 0x7u

//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_16_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_16_DPTR_MASK 0x70000u

//! @}

//! \defgroup CFG_DMA_EGP_17 Register CFG_DMA_EGP_17 - DMA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_DMA_EGP_17 0x21000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_DMA_EGP_17 0x190E1000u

//! Register Reset Value
#define CFG_DMA_EGP_17_RST 0x00000000u

//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_17_DQREQ_POS 0
//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_17_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_17_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_17_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_17_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_17_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_17_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_17_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_17_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_17_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_DMA_EGP_17 Register DQPC_DMA_EGP_17 - DMA Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_DMA_EGP_17 0x21004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_DMA_EGP_17 0x190E1004u

//! Register Reset Value
#define DQPC_DMA_EGP_17_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_17_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_17_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_DMA_EGP_17 Register IRNCR_DMA_EGP_17 - DMA Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_DMA_EGP_17 0x21020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_DMA_EGP_17 0x190E1020u

//! Register Reset Value
#define IRNCR_DMA_EGP_17_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_17_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_17_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_DMA_EGP_17_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_DMA_EGP_17_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_DMA_EGP_17 Register IRNICR_DMA_EGP_17 - DMA Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_DMA_EGP_17 0x21024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_DMA_EGP_17 0x190E1024u

//! Register Reset Value
#define IRNICR_DMA_EGP_17_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_17_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_17_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_DMA_EGP_17 Register IRNEN_DMA_EGP_17 - DMA Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_DMA_EGP_17 0x21028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_DMA_EGP_17 0x190E1028u

//! Register Reset Value
#define IRNEN_DMA_EGP_17_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_17_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_17_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_DMA_EGP_17_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_DMA_EGP_17_DR_EN 0x1

//! @}

//! \defgroup DPTR_DMA_EGP_17 Register DPTR_DMA_EGP_17 - DMA Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_DMA_EGP_17 0x21030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_DMA_EGP_17 0x190E1030u

//! Register Reset Value
#define DPTR_DMA_EGP_17_RST 0x00000007u

//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_17_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_17_ND_MASK 0x7u

//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_17_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_17_DPTR_MASK 0x70000u

//! @}

//! \defgroup CFG_DMA_EGP_18 Register CFG_DMA_EGP_18 - DMA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_DMA_EGP_18 0x22000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_DMA_EGP_18 0x190E2000u

//! Register Reset Value
#define CFG_DMA_EGP_18_RST 0x00000000u

//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_18_DQREQ_POS 0
//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_18_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_18_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_18_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_18_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_18_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_18_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_18_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_18_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_18_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_DMA_EGP_18 Register DQPC_DMA_EGP_18 - DMA Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_DMA_EGP_18 0x22004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_DMA_EGP_18 0x190E2004u

//! Register Reset Value
#define DQPC_DMA_EGP_18_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_18_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_18_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_DMA_EGP_18 Register IRNCR_DMA_EGP_18 - DMA Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_DMA_EGP_18 0x22020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_DMA_EGP_18 0x190E2020u

//! Register Reset Value
#define IRNCR_DMA_EGP_18_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_18_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_18_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_DMA_EGP_18_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_DMA_EGP_18_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_DMA_EGP_18 Register IRNICR_DMA_EGP_18 - DMA Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_DMA_EGP_18 0x22024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_DMA_EGP_18 0x190E2024u

//! Register Reset Value
#define IRNICR_DMA_EGP_18_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_18_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_18_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_DMA_EGP_18 Register IRNEN_DMA_EGP_18 - DMA Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_DMA_EGP_18 0x22028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_DMA_EGP_18 0x190E2028u

//! Register Reset Value
#define IRNEN_DMA_EGP_18_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_18_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_18_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_DMA_EGP_18_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_DMA_EGP_18_DR_EN 0x1

//! @}

//! \defgroup DPTR_DMA_EGP_18 Register DPTR_DMA_EGP_18 - DMA Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_DMA_EGP_18 0x22030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_DMA_EGP_18 0x190E2030u

//! Register Reset Value
#define DPTR_DMA_EGP_18_RST 0x00000007u

//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_18_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_18_ND_MASK 0x7u

//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_18_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_18_DPTR_MASK 0x70000u

//! @}

//! \defgroup CFG_DMA_EGP_19 Register CFG_DMA_EGP_19 - DMA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_DMA_EGP_19 0x23000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_DMA_EGP_19 0x190E3000u

//! Register Reset Value
#define CFG_DMA_EGP_19_RST 0x00000000u

//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_19_DQREQ_POS 0
//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_19_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_19_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_19_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_19_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_19_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_19_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_19_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_19_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_19_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_DMA_EGP_19 Register DQPC_DMA_EGP_19 - DMA Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_DMA_EGP_19 0x23004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_DMA_EGP_19 0x190E3004u

//! Register Reset Value
#define DQPC_DMA_EGP_19_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_19_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_19_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_DMA_EGP_19 Register IRNCR_DMA_EGP_19 - DMA Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_DMA_EGP_19 0x23020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_DMA_EGP_19 0x190E3020u

//! Register Reset Value
#define IRNCR_DMA_EGP_19_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_19_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_19_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_DMA_EGP_19_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_DMA_EGP_19_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_DMA_EGP_19 Register IRNICR_DMA_EGP_19 - DMA Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_DMA_EGP_19 0x23024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_DMA_EGP_19 0x190E3024u

//! Register Reset Value
#define IRNICR_DMA_EGP_19_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_19_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_19_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_DMA_EGP_19 Register IRNEN_DMA_EGP_19 - DMA Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_DMA_EGP_19 0x23028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_DMA_EGP_19 0x190E3028u

//! Register Reset Value
#define IRNEN_DMA_EGP_19_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_19_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_19_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_DMA_EGP_19_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_DMA_EGP_19_DR_EN 0x1

//! @}

//! \defgroup DPTR_DMA_EGP_19 Register DPTR_DMA_EGP_19 - DMA Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_DMA_EGP_19 0x23030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_DMA_EGP_19 0x190E3030u

//! Register Reset Value
#define DPTR_DMA_EGP_19_RST 0x00000007u

//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_19_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_19_ND_MASK 0x7u

//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_19_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_19_DPTR_MASK 0x70000u

//! @}

//! \defgroup CFG_DMA_EGP_20 Register CFG_DMA_EGP_20 - DMA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_DMA_EGP_20 0x24000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_DMA_EGP_20 0x190E4000u

//! Register Reset Value
#define CFG_DMA_EGP_20_RST 0x00000000u

//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_20_DQREQ_POS 0
//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_20_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_20_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_20_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_20_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_20_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_20_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_20_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_20_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_20_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_DMA_EGP_20 Register DQPC_DMA_EGP_20 - DMA Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_DMA_EGP_20 0x24004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_DMA_EGP_20 0x190E4004u

//! Register Reset Value
#define DQPC_DMA_EGP_20_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_20_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_20_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_DMA_EGP_20 Register IRNCR_DMA_EGP_20 - DMA Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_DMA_EGP_20 0x24020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_DMA_EGP_20 0x190E4020u

//! Register Reset Value
#define IRNCR_DMA_EGP_20_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_20_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_20_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_DMA_EGP_20_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_DMA_EGP_20_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_DMA_EGP_20 Register IRNICR_DMA_EGP_20 - DMA Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_DMA_EGP_20 0x24024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_DMA_EGP_20 0x190E4024u

//! Register Reset Value
#define IRNICR_DMA_EGP_20_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_20_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_20_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_DMA_EGP_20 Register IRNEN_DMA_EGP_20 - DMA Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_DMA_EGP_20 0x24028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_DMA_EGP_20 0x190E4028u

//! Register Reset Value
#define IRNEN_DMA_EGP_20_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_20_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_20_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_DMA_EGP_20_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_DMA_EGP_20_DR_EN 0x1

//! @}

//! \defgroup DPTR_DMA_EGP_20 Register DPTR_DMA_EGP_20 - DMA Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_DMA_EGP_20 0x24030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_DMA_EGP_20 0x190E4030u

//! Register Reset Value
#define DPTR_DMA_EGP_20_RST 0x00000007u

//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_20_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_20_ND_MASK 0x7u

//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_20_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_20_DPTR_MASK 0x70000u

//! @}

//! \defgroup CFG_DMA_EGP_21 Register CFG_DMA_EGP_21 - DMA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_DMA_EGP_21 0x25000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_DMA_EGP_21 0x190E5000u

//! Register Reset Value
#define CFG_DMA_EGP_21_RST 0x00000000u

//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_21_DQREQ_POS 0
//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_21_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_21_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_21_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_21_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_21_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_21_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_21_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_21_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_21_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_DMA_EGP_21 Register DQPC_DMA_EGP_21 - DMA Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_DMA_EGP_21 0x25004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_DMA_EGP_21 0x190E5004u

//! Register Reset Value
#define DQPC_DMA_EGP_21_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_21_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_21_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_DMA_EGP_21 Register IRNCR_DMA_EGP_21 - DMA Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_DMA_EGP_21 0x25020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_DMA_EGP_21 0x190E5020u

//! Register Reset Value
#define IRNCR_DMA_EGP_21_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_21_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_21_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_DMA_EGP_21_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_DMA_EGP_21_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_DMA_EGP_21 Register IRNICR_DMA_EGP_21 - DMA Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_DMA_EGP_21 0x25024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_DMA_EGP_21 0x190E5024u

//! Register Reset Value
#define IRNICR_DMA_EGP_21_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_21_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_21_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_DMA_EGP_21 Register IRNEN_DMA_EGP_21 - DMA Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_DMA_EGP_21 0x25028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_DMA_EGP_21 0x190E5028u

//! Register Reset Value
#define IRNEN_DMA_EGP_21_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_21_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_21_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_DMA_EGP_21_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_DMA_EGP_21_DR_EN 0x1

//! @}

//! \defgroup DPTR_DMA_EGP_21 Register DPTR_DMA_EGP_21 - DMA Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_DMA_EGP_21 0x25030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_DMA_EGP_21 0x190E5030u

//! Register Reset Value
#define DPTR_DMA_EGP_21_RST 0x00000007u

//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_21_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_21_ND_MASK 0x7u

//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_21_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_21_DPTR_MASK 0x70000u

//! @}

//! \defgroup CFG_DMA_EGP_22 Register CFG_DMA_EGP_22 - DMA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_DMA_EGP_22 0x26000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_DMA_EGP_22 0x190E6000u

//! Register Reset Value
#define CFG_DMA_EGP_22_RST 0x00000000u

//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_22_DQREQ_POS 0
//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_22_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_22_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_22_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_22_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_22_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_22_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_22_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_22_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_22_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_DMA_EGP_22 Register DQPC_DMA_EGP_22 - DMA Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_DMA_EGP_22 0x26004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_DMA_EGP_22 0x190E6004u

//! Register Reset Value
#define DQPC_DMA_EGP_22_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_22_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_22_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_DMA_EGP_22 Register IRNCR_DMA_EGP_22 - DMA Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_DMA_EGP_22 0x26020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_DMA_EGP_22 0x190E6020u

//! Register Reset Value
#define IRNCR_DMA_EGP_22_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_22_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_22_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_DMA_EGP_22_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_DMA_EGP_22_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_DMA_EGP_22 Register IRNICR_DMA_EGP_22 - DMA Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_DMA_EGP_22 0x26024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_DMA_EGP_22 0x190E6024u

//! Register Reset Value
#define IRNICR_DMA_EGP_22_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_22_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_22_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_DMA_EGP_22 Register IRNEN_DMA_EGP_22 - DMA Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_DMA_EGP_22 0x26028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_DMA_EGP_22 0x190E6028u

//! Register Reset Value
#define IRNEN_DMA_EGP_22_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_22_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_22_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_DMA_EGP_22_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_DMA_EGP_22_DR_EN 0x1

//! @}

//! \defgroup DPTR_DMA_EGP_22 Register DPTR_DMA_EGP_22 - DMA Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_DMA_EGP_22 0x26030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_DMA_EGP_22 0x190E6030u

//! Register Reset Value
#define DPTR_DMA_EGP_22_RST 0x00000007u

//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_22_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_22_ND_MASK 0x7u

//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_22_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_22_DPTR_MASK 0x70000u

//! @}

//! \defgroup CFG_DMA_EGP_23 Register CFG_DMA_EGP_23 - DMA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_DMA_EGP_23 0x27000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_DMA_EGP_23 0x190E7000u

//! Register Reset Value
#define CFG_DMA_EGP_23_RST 0x00000000u

//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_23_DQREQ_POS 0
//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_23_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_23_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_23_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_23_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_23_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_23_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_23_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_23_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_23_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_DMA_EGP_23 Register DQPC_DMA_EGP_23 - DMA Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_DMA_EGP_23 0x27004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_DMA_EGP_23 0x190E7004u

//! Register Reset Value
#define DQPC_DMA_EGP_23_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_23_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_23_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_DMA_EGP_23 Register IRNCR_DMA_EGP_23 - DMA Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_DMA_EGP_23 0x27020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_DMA_EGP_23 0x190E7020u

//! Register Reset Value
#define IRNCR_DMA_EGP_23_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_23_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_23_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_DMA_EGP_23_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_DMA_EGP_23_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_DMA_EGP_23 Register IRNICR_DMA_EGP_23 - DMA Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_DMA_EGP_23 0x27024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_DMA_EGP_23 0x190E7024u

//! Register Reset Value
#define IRNICR_DMA_EGP_23_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_23_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_23_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_DMA_EGP_23 Register IRNEN_DMA_EGP_23 - DMA Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_DMA_EGP_23 0x27028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_DMA_EGP_23 0x190E7028u

//! Register Reset Value
#define IRNEN_DMA_EGP_23_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_23_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_23_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_DMA_EGP_23_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_DMA_EGP_23_DR_EN 0x1

//! @}

//! \defgroup DPTR_DMA_EGP_23 Register DPTR_DMA_EGP_23 - DMA Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_DMA_EGP_23 0x27030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_DMA_EGP_23 0x190E7030u

//! Register Reset Value
#define DPTR_DMA_EGP_23_RST 0x00000007u

//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_23_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_23_ND_MASK 0x7u

//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_23_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_23_DPTR_MASK 0x70000u

//! @}

//! \defgroup CFG_DMA_EGP_24 Register CFG_DMA_EGP_24 - DMA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_DMA_EGP_24 0x28000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_DMA_EGP_24 0x190E8000u

//! Register Reset Value
#define CFG_DMA_EGP_24_RST 0x00000000u

//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_24_DQREQ_POS 0
//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_24_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_24_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_24_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_24_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_24_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_24_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_24_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_24_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_24_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_DMA_EGP_24 Register DQPC_DMA_EGP_24 - DMA Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_DMA_EGP_24 0x28004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_DMA_EGP_24 0x190E8004u

//! Register Reset Value
#define DQPC_DMA_EGP_24_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_24_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_24_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_DMA_EGP_24 Register IRNCR_DMA_EGP_24 - DMA Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_DMA_EGP_24 0x28020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_DMA_EGP_24 0x190E8020u

//! Register Reset Value
#define IRNCR_DMA_EGP_24_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_24_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_24_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_DMA_EGP_24_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_DMA_EGP_24_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_DMA_EGP_24 Register IRNICR_DMA_EGP_24 - DMA Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_DMA_EGP_24 0x28024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_DMA_EGP_24 0x190E8024u

//! Register Reset Value
#define IRNICR_DMA_EGP_24_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_24_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_24_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_DMA_EGP_24 Register IRNEN_DMA_EGP_24 - DMA Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_DMA_EGP_24 0x28028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_DMA_EGP_24 0x190E8028u

//! Register Reset Value
#define IRNEN_DMA_EGP_24_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_24_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_24_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_DMA_EGP_24_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_DMA_EGP_24_DR_EN 0x1

//! @}

//! \defgroup DPTR_DMA_EGP_24 Register DPTR_DMA_EGP_24 - DMA Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_DMA_EGP_24 0x28030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_DMA_EGP_24 0x190E8030u

//! Register Reset Value
#define DPTR_DMA_EGP_24_RST 0x00000007u

//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_24_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_24_ND_MASK 0x7u

//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_24_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_24_DPTR_MASK 0x70000u

//! @}

//! \defgroup CFG_DMA_EGP_25 Register CFG_DMA_EGP_25 - DMA Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_DMA_EGP_25 0x29000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_DMA_EGP_25 0x190E9000u

//! Register Reset Value
#define CFG_DMA_EGP_25_RST 0x00000000u

//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_25_DQREQ_POS 0
//! Field DQREQ - Enable DMA Dequeue Request
#define CFG_DMA_EGP_25_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_25_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_25_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_25_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_DMA_EGP_25_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_DMA_EGP_25_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_DMA_EGP_25_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_25_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_DMA_EGP_25_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup DQPC_DMA_EGP_25 Register DQPC_DMA_EGP_25 - DMA Egress Port dequeue packet counter
//! @{

//! Register Offset (relative)
#define DQPC_DMA_EGP_25 0x29004
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DQPC_DMA_EGP_25 0x190E9004u

//! Register Reset Value
#define DQPC_DMA_EGP_25_RST 0x00000000u

//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_25_PC_POS 0
//! Field PC - Per Port Packet Counter
#define DQPC_DMA_EGP_25_PC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup IRNCR_DMA_EGP_25 Register IRNCR_DMA_EGP_25 - DMA Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_DMA_EGP_25 0x29020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_DMA_EGP_25 0x190E9020u

//! Register Reset Value
#define IRNCR_DMA_EGP_25_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_25_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_DMA_EGP_25_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_DMA_EGP_25_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_DMA_EGP_25_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_DMA_EGP_25 Register IRNICR_DMA_EGP_25 - DMA Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_DMA_EGP_25 0x29024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_DMA_EGP_25 0x190E9024u

//! Register Reset Value
#define IRNICR_DMA_EGP_25_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_25_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_DMA_EGP_25_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_DMA_EGP_25 Register IRNEN_DMA_EGP_25 - DMA Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_DMA_EGP_25 0x29028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_DMA_EGP_25 0x190E9028u

//! Register Reset Value
#define IRNEN_DMA_EGP_25_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_25_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_DMA_EGP_25_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_DMA_EGP_25_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_DMA_EGP_25_DR_EN 0x1

//! @}

//! \defgroup DPTR_DMA_EGP_25 Register DPTR_DMA_EGP_25 - DMA Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_DMA_EGP_25 0x29030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_DMA_EGP_25 0x190E9030u

//! Register Reset Value
#define DPTR_DMA_EGP_25_RST 0x00000007u

//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_25_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_DMA_EGP_25_ND_MASK 0x7u

//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_25_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_DMA_EGP_25_DPTR_MASK 0x70000u

//! @}

//! \defgroup CFG_PON_EGP_26 Register CFG_PON_EGP_26 - PON Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_PON_EGP_26 0x2A000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_PON_EGP_26 0x190EA000u

//! Register Reset Value
#define CFG_PON_EGP_26_RST 0x00000000u

//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_26_DQREQ_POS 0
//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_26_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_26_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_26_DQREQ_EN 0x1

//! Field BUFRTN - Enable PON Buffer Return
#define CFG_PON_EGP_26_BUFRTN_POS 1
//! Field BUFRTN - Enable PON Buffer Return
#define CFG_PON_EGP_26_BUFRTN_MASK 0x2u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_26_BUFRTN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_26_BUFRTN_EN 0x1

//! Field BFBPEN - Buffer Return Back Pressure Enable
#define CFG_PON_EGP_26_BFBPEN_POS 2
//! Field BFBPEN - Buffer Return Back Pressure Enable
#define CFG_PON_EGP_26_BFBPEN_MASK 0x4u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_26_BFBPEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_26_BFBPEN_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_26_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_26_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_26_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_26_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_26_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_26_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup IRNCR_PON_EGP_26 Register IRNCR_PON_EGP_26 - PON Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_PON_EGP_26 0x2A020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_PON_EGP_26 0x190EA020u

//! Register Reset Value
#define IRNCR_PON_EGP_26_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_26_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_26_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_PON_EGP_26_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_PON_EGP_26_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_PON_EGP_26 Register IRNICR_PON_EGP_26 - PON Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_PON_EGP_26 0x2A024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_PON_EGP_26 0x190EA024u

//! Register Reset Value
#define IRNICR_PON_EGP_26_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_26_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_26_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_PON_EGP_26 Register IRNEN_PON_EGP_26 - PON Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_PON_EGP_26 0x2A028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_PON_EGP_26 0x190EA028u

//! Register Reset Value
#define IRNEN_PON_EGP_26_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_26_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_26_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_PON_EGP_26_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_PON_EGP_26_DR_EN 0x1

//! @}

//! \defgroup DPTR_PON_EGP_26 Register DPTR_PON_EGP_26 - PON Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_PON_EGP_26 0x2A030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_PON_EGP_26 0x190EA030u

//! Register Reset Value
#define DPTR_PON_EGP_26_RST 0x00000707u

//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_26_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_26_ND_MASK 0x7u

//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_26_NSD_POS 8
//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_26_NSD_MASK 0x700u

//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_26_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_26_DPTR_MASK 0x70000u

//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_26_SDPTR_POS 24
//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_26_SDPTR_MASK 0x7000000u

//! @}

//! \defgroup BPRC_PON_EGP Register BPRC_PON_EGP - Egress Port Buffer Pointer Return counter
//! @{

//! Register Offset (relative)
#define BPRC_PON_EGP 0x2A034
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_BPRC_PON_EGP 0x190EA034u

//! Register Reset Value
#define BPRC_PON_EGP_RST 0x00000000u

//! Field BPRC - Per Port Buffer Pointer Return Counter
#define BPRC_PON_EGP_BPRC_POS 0
//! Field BPRC - Per Port Buffer Pointer Return Counter
#define BPRC_PON_EGP_BPRC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup PTR_RTN_PON_DW2 Register PTR_RTN_PON_DW2 - CPU Egress Port Buffer Pointer Return DW2
//! @{

//! Register Offset (relative)
#define PTR_RTN_PON_DW2 0x2A080
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_PON_DW2 0x190EA080u

//! Register Reset Value
#define PTR_RTN_PON_DW2_RST 0xFFFFFF80u

//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_PON_DW2_BPTR_POS 7
//! Field BPTR - Buffer Pointer (DW2 of the Descriptor)
#define PTR_RTN_PON_DW2_BPTR_MASK 0xFFFFFF80u

//! @}

//! \defgroup PTR_RTN_PON_DW3 Register PTR_RTN_PON_DW3 - CPU Egress Port Buffer Pointer Return DW3
//! @{

//! Register Offset (relative)
#define PTR_RTN_PON_DW3 0x2A084
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_PTR_RTN_PON_DW3 0x190EA084u

//! Register Reset Value
#define PTR_RTN_PON_DW3_RST 0x00700000u

//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_PON_DW3_POOL_POS 16
//! Field POOL - Pool ID of the buffer to be returned provided in DW2
#define PTR_RTN_PON_DW3_POOL_MASK 0x70000u

//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_PON_DW3_POLICY_POS 20
//! Field POLICY - Policy ID of the buffer to be returned provided in DW2
#define PTR_RTN_PON_DW3_POLICY_MASK 0x700000u

//! @}

//! \defgroup DESC0_0_PON_EGP_26 Register DESC0_0_PON_EGP_26 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_26 0x2A100
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_26 0x190EA100u

//! Register Reset Value
#define DESC0_0_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_26 Register DESC1_0_PON_EGP_26 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_26 0x2A104
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_26 0x190EA104u

//! Register Reset Value
#define DESC1_0_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_26 Register DESC2_0_PON_EGP_26 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_26 0x2A108
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_26 0x190EA108u

//! Register Reset Value
#define DESC2_0_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_26 Register DESC3_0_PON_EGP_26 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_26 0x2A10C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_26 0x190EA10Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_26_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_26_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_26_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_26 Register DESC0_1_PON_EGP_26 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_26 0x2A110
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_26 0x190EA110u

//! Register Reset Value
#define DESC0_1_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_26 Register DESC1_1_PON_EGP_26 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_26 0x2A114
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_26 0x190EA114u

//! Register Reset Value
#define DESC1_1_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_26 Register DESC2_1_PON_EGP_26 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_26 0x2A118
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_26 0x190EA118u

//! Register Reset Value
#define DESC2_1_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_26 Register DESC3_1_PON_EGP_26 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_26 0x2A11C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_26 0x190EA11Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_26_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_26_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_26_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_26 Register DESC0_2_PON_EGP_26 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_26 0x2A120
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_26 0x190EA120u

//! Register Reset Value
#define DESC0_2_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_26 Register DESC1_2_PON_EGP_26 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_26 0x2A124
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_26 0x190EA124u

//! Register Reset Value
#define DESC1_2_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_26 Register DESC2_2_PON_EGP_26 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_26 0x2A128
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_26 0x190EA128u

//! Register Reset Value
#define DESC2_2_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_26 Register DESC3_2_PON_EGP_26 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_26 0x2A12C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_26 0x190EA12Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_26_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_26_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_26_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_26 Register DESC0_3_PON_EGP_26 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_26 0x2A130
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_26 0x190EA130u

//! Register Reset Value
#define DESC0_3_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_26 Register DESC1_3_PON_EGP_26 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_26 0x2A134
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_26 0x190EA134u

//! Register Reset Value
#define DESC1_3_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_26 Register DESC2_3_PON_EGP_26 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_26 0x2A138
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_26 0x190EA138u

//! Register Reset Value
#define DESC2_3_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_26 Register DESC3_3_PON_EGP_26 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_26 0x2A13C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_26 0x190EA13Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_26_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_26_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_26_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_26 Register DESC0_4_PON_EGP_26 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_26 0x2A140
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_26 0x190EA140u

//! Register Reset Value
#define DESC0_4_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_26 Register DESC1_4_PON_EGP_26 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_26 0x2A144
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_26 0x190EA144u

//! Register Reset Value
#define DESC1_4_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_26 Register DESC2_4_PON_EGP_26 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_26 0x2A148
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_26 0x190EA148u

//! Register Reset Value
#define DESC2_4_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_26 Register DESC3_4_PON_EGP_26 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_26 0x2A14C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_26 0x190EA14Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_26_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_26_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_26_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_26 Register DESC0_5_PON_EGP_26 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_26 0x2A150
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_26 0x190EA150u

//! Register Reset Value
#define DESC0_5_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_26 Register DESC1_5_PON_EGP_26 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_26 0x2A154
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_26 0x190EA154u

//! Register Reset Value
#define DESC1_5_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_26 Register DESC2_5_PON_EGP_26 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_26 0x2A158
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_26 0x190EA158u

//! Register Reset Value
#define DESC2_5_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_26 Register DESC3_5_PON_EGP_26 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_26 0x2A15C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_26 0x190EA15Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_26_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_26_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_26_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_26 Register DESC0_6_PON_EGP_26 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_26 0x2A160
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_26 0x190EA160u

//! Register Reset Value
#define DESC0_6_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_26 Register DESC1_6_PON_EGP_26 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_26 0x2A164
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_26 0x190EA164u

//! Register Reset Value
#define DESC1_6_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_26 Register DESC2_6_PON_EGP_26 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_26 0x2A168
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_26 0x190EA168u

//! Register Reset Value
#define DESC2_6_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_26 Register DESC3_6_PON_EGP_26 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_26 0x2A16C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_26 0x190EA16Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_26_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_26_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_26_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_26 Register DESC0_7_PON_EGP_26 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_26 0x2A170
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_26 0x190EA170u

//! Register Reset Value
#define DESC0_7_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_26 Register DESC1_7_PON_EGP_26 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_26 0x2A174
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_26 0x190EA174u

//! Register Reset Value
#define DESC1_7_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_26 Register DESC2_7_PON_EGP_26 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_26 0x2A178
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_26 0x190EA178u

//! Register Reset Value
#define DESC2_7_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_26 Register DESC3_7_PON_EGP_26 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_26 0x2A17C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_26 0x190EA17Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_26_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_26_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_26_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_26_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_26_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_S_26 Register DESC0_0_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_S_26 0x2A200
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_S_26 0x190EA200u

//! Register Reset Value
#define DESC0_0_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_S_26 Register DESC1_0_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_S_26 0x2A204
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_S_26 0x190EA204u

//! Register Reset Value
#define DESC1_0_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_S_26 Register DESC2_0_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_S_26 0x2A208
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_S_26 0x190EA208u

//! Register Reset Value
#define DESC2_0_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_S_26 Register DESC3_0_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_S_26 0x2A20C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_S_26 0x190EA20Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_26_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_26_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_26_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_S_26 Register DESC0_1_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_S_26 0x2A210
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_S_26 0x190EA210u

//! Register Reset Value
#define DESC0_1_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_S_26 Register DESC1_1_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_S_26 0x2A214
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_S_26 0x190EA214u

//! Register Reset Value
#define DESC1_1_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_S_26 Register DESC2_1_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_S_26 0x2A218
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_S_26 0x190EA218u

//! Register Reset Value
#define DESC2_1_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_S_26 Register DESC3_1_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_S_26 0x2A21C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_S_26 0x190EA21Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_26_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_26_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_26_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_S_26 Register DESC0_2_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_S_26 0x2A220
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_S_26 0x190EA220u

//! Register Reset Value
#define DESC0_2_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_S_26 Register DESC1_2_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_S_26 0x2A224
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_S_26 0x190EA224u

//! Register Reset Value
#define DESC1_2_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_S_26 Register DESC2_2_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_S_26 0x2A228
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_S_26 0x190EA228u

//! Register Reset Value
#define DESC2_2_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_S_26 Register DESC3_2_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_S_26 0x2A22C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_S_26 0x190EA22Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_26_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_26_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_26_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_S_26 Register DESC0_3_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_S_26 0x2A230
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_S_26 0x190EA230u

//! Register Reset Value
#define DESC0_3_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_S_26 Register DESC1_3_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_S_26 0x2A234
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_S_26 0x190EA234u

//! Register Reset Value
#define DESC1_3_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_S_26 Register DESC2_3_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_S_26 0x2A238
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_S_26 0x190EA238u

//! Register Reset Value
#define DESC2_3_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_S_26 Register DESC3_3_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_S_26 0x2A23C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_S_26 0x190EA23Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_26_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_26_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_26_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_S_26 Register DESC0_4_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_S_26 0x2A240
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_S_26 0x190EA240u

//! Register Reset Value
#define DESC0_4_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_S_26 Register DESC1_4_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_S_26 0x2A244
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_S_26 0x190EA244u

//! Register Reset Value
#define DESC1_4_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_S_26 Register DESC2_4_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_S_26 0x2A248
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_S_26 0x190EA248u

//! Register Reset Value
#define DESC2_4_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_S_26 Register DESC3_4_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_S_26 0x2A24C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_S_26 0x190EA24Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_26_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_26_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_26_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_S_26 Register DESC0_5_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_S_26 0x2A250
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_S_26 0x190EA250u

//! Register Reset Value
#define DESC0_5_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_S_26 Register DESC1_5_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_S_26 0x2A254
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_S_26 0x190EA254u

//! Register Reset Value
#define DESC1_5_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_S_26 Register DESC2_5_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_S_26 0x2A258
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_S_26 0x190EA258u

//! Register Reset Value
#define DESC2_5_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_S_26 Register DESC3_5_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_S_26 0x2A25C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_S_26 0x190EA25Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_26_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_26_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_26_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_S_26 Register DESC0_6_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_S_26 0x2A260
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_S_26 0x190EA260u

//! Register Reset Value
#define DESC0_6_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_S_26 Register DESC1_6_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_S_26 0x2A264
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_S_26 0x190EA264u

//! Register Reset Value
#define DESC1_6_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_S_26 Register DESC2_6_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_S_26 0x2A268
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_S_26 0x190EA268u

//! Register Reset Value
#define DESC2_6_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_S_26 Register DESC3_6_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_S_26 0x2A26C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_S_26 0x190EA26Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_26_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_26_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_26_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_S_26 Register DESC0_7_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_S_26 0x2A270
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_S_26 0x190EA270u

//! Register Reset Value
#define DESC0_7_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_S_26 Register DESC1_7_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_S_26 0x2A274
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_S_26 0x190EA274u

//! Register Reset Value
#define DESC1_7_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_S_26 Register DESC2_7_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_S_26 0x2A278
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_S_26 0x190EA278u

//! Register Reset Value
#define DESC2_7_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_26_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_S_26 Register DESC3_7_PON_EGP_S_26 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_S_26 0x2A27C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_S_26 0x190EA27Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_S_26_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_26_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_26_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_26_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_26_OWN_MASK 0x80000000u

//! @}

//! \defgroup CFG_PON_EGP_27 Register CFG_PON_EGP_27 - PON Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_PON_EGP_27 0x2A400
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_PON_EGP_27 0x190EA400u

//! Register Reset Value
#define CFG_PON_EGP_27_RST 0x00000000u

//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_27_DQREQ_POS 0
//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_27_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_27_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_27_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_27_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_27_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_27_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_27_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_27_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_27_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup IRNCR_PON_EGP_27 Register IRNCR_PON_EGP_27 - PON Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_PON_EGP_27 0x2A420
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_PON_EGP_27 0x190EA420u

//! Register Reset Value
#define IRNCR_PON_EGP_27_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_27_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_27_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_PON_EGP_27_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_PON_EGP_27_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_PON_EGP_27 Register IRNICR_PON_EGP_27 - PON Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_PON_EGP_27 0x2A424
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_PON_EGP_27 0x190EA424u

//! Register Reset Value
#define IRNICR_PON_EGP_27_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_27_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_27_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_PON_EGP_27 Register IRNEN_PON_EGP_27 - PON Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_PON_EGP_27 0x2A428
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_PON_EGP_27 0x190EA428u

//! Register Reset Value
#define IRNEN_PON_EGP_27_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_27_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_27_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_PON_EGP_27_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_PON_EGP_27_DR_EN 0x1

//! @}

//! \defgroup DPTR_PON_EGP_27 Register DPTR_PON_EGP_27 - PON Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_PON_EGP_27 0x2A430
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_PON_EGP_27 0x190EA430u

//! Register Reset Value
#define DPTR_PON_EGP_27_RST 0x00000707u

//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_27_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_27_ND_MASK 0x7u

//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_27_NSD_POS 8
//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_27_NSD_MASK 0x700u

//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_27_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_27_DPTR_MASK 0x70000u

//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_27_SDPTR_POS 24
//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_27_SDPTR_MASK 0x7000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_27 Register DESC0_0_PON_EGP_27 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_27 0x2A500
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_27 0x190EA500u

//! Register Reset Value
#define DESC0_0_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_27 Register DESC1_0_PON_EGP_27 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_27 0x2A504
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_27 0x190EA504u

//! Register Reset Value
#define DESC1_0_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_27 Register DESC2_0_PON_EGP_27 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_27 0x2A508
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_27 0x190EA508u

//! Register Reset Value
#define DESC2_0_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_27 Register DESC3_0_PON_EGP_27 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_27 0x2A50C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_27 0x190EA50Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_27_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_27_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_27_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_27 Register DESC0_1_PON_EGP_27 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_27 0x2A510
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_27 0x190EA510u

//! Register Reset Value
#define DESC0_1_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_27 Register DESC1_1_PON_EGP_27 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_27 0x2A514
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_27 0x190EA514u

//! Register Reset Value
#define DESC1_1_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_27 Register DESC2_1_PON_EGP_27 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_27 0x2A518
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_27 0x190EA518u

//! Register Reset Value
#define DESC2_1_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_27 Register DESC3_1_PON_EGP_27 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_27 0x2A51C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_27 0x190EA51Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_27_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_27_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_27_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_27 Register DESC0_2_PON_EGP_27 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_27 0x2A520
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_27 0x190EA520u

//! Register Reset Value
#define DESC0_2_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_27 Register DESC1_2_PON_EGP_27 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_27 0x2A524
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_27 0x190EA524u

//! Register Reset Value
#define DESC1_2_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_27 Register DESC2_2_PON_EGP_27 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_27 0x2A528
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_27 0x190EA528u

//! Register Reset Value
#define DESC2_2_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_27 Register DESC3_2_PON_EGP_27 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_27 0x2A52C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_27 0x190EA52Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_27_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_27_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_27_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_27 Register DESC0_3_PON_EGP_27 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_27 0x2A530
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_27 0x190EA530u

//! Register Reset Value
#define DESC0_3_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_27 Register DESC1_3_PON_EGP_27 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_27 0x2A534
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_27 0x190EA534u

//! Register Reset Value
#define DESC1_3_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_27 Register DESC2_3_PON_EGP_27 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_27 0x2A538
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_27 0x190EA538u

//! Register Reset Value
#define DESC2_3_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_27 Register DESC3_3_PON_EGP_27 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_27 0x2A53C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_27 0x190EA53Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_27_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_27_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_27_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_27 Register DESC0_4_PON_EGP_27 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_27 0x2A540
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_27 0x190EA540u

//! Register Reset Value
#define DESC0_4_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_27 Register DESC1_4_PON_EGP_27 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_27 0x2A544
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_27 0x190EA544u

//! Register Reset Value
#define DESC1_4_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_27 Register DESC2_4_PON_EGP_27 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_27 0x2A548
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_27 0x190EA548u

//! Register Reset Value
#define DESC2_4_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_27 Register DESC3_4_PON_EGP_27 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_27 0x2A54C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_27 0x190EA54Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_27_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_27_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_27_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_27 Register DESC0_5_PON_EGP_27 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_27 0x2A550
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_27 0x190EA550u

//! Register Reset Value
#define DESC0_5_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_27 Register DESC1_5_PON_EGP_27 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_27 0x2A554
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_27 0x190EA554u

//! Register Reset Value
#define DESC1_5_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_27 Register DESC2_5_PON_EGP_27 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_27 0x2A558
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_27 0x190EA558u

//! Register Reset Value
#define DESC2_5_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_27 Register DESC3_5_PON_EGP_27 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_27 0x2A55C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_27 0x190EA55Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_27_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_27_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_27_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_27 Register DESC0_6_PON_EGP_27 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_27 0x2A560
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_27 0x190EA560u

//! Register Reset Value
#define DESC0_6_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_27 Register DESC1_6_PON_EGP_27 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_27 0x2A564
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_27 0x190EA564u

//! Register Reset Value
#define DESC1_6_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_27 Register DESC2_6_PON_EGP_27 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_27 0x2A568
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_27 0x190EA568u

//! Register Reset Value
#define DESC2_6_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_27 Register DESC3_6_PON_EGP_27 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_27 0x2A56C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_27 0x190EA56Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_27_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_27_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_27_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_27 Register DESC0_7_PON_EGP_27 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_27 0x2A570
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_27 0x190EA570u

//! Register Reset Value
#define DESC0_7_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_27 Register DESC1_7_PON_EGP_27 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_27 0x2A574
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_27 0x190EA574u

//! Register Reset Value
#define DESC1_7_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_27 Register DESC2_7_PON_EGP_27 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_27 0x2A578
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_27 0x190EA578u

//! Register Reset Value
#define DESC2_7_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_27 Register DESC3_7_PON_EGP_27 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_27 0x2A57C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_27 0x190EA57Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_27_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_27_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_27_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_27_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_27_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_S_27 Register DESC0_0_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_S_27 0x2A600
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_S_27 0x190EA600u

//! Register Reset Value
#define DESC0_0_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_S_27 Register DESC1_0_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_S_27 0x2A604
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_S_27 0x190EA604u

//! Register Reset Value
#define DESC1_0_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_S_27 Register DESC2_0_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_S_27 0x2A608
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_S_27 0x190EA608u

//! Register Reset Value
#define DESC2_0_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_S_27 Register DESC3_0_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_S_27 0x2A60C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_S_27 0x190EA60Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_27_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_27_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_27_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_S_27 Register DESC0_1_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_S_27 0x2A610
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_S_27 0x190EA610u

//! Register Reset Value
#define DESC0_1_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_S_27 Register DESC1_1_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_S_27 0x2A614
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_S_27 0x190EA614u

//! Register Reset Value
#define DESC1_1_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_S_27 Register DESC2_1_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_S_27 0x2A618
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_S_27 0x190EA618u

//! Register Reset Value
#define DESC2_1_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_S_27 Register DESC3_1_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_S_27 0x2A61C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_S_27 0x190EA61Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_27_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_27_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_27_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_S_27 Register DESC0_2_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_S_27 0x2A620
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_S_27 0x190EA620u

//! Register Reset Value
#define DESC0_2_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_S_27 Register DESC1_2_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_S_27 0x2A624
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_S_27 0x190EA624u

//! Register Reset Value
#define DESC1_2_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_S_27 Register DESC2_2_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_S_27 0x2A628
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_S_27 0x190EA628u

//! Register Reset Value
#define DESC2_2_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_S_27 Register DESC3_2_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_S_27 0x2A62C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_S_27 0x190EA62Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_27_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_27_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_27_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_S_27 Register DESC0_3_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_S_27 0x2A630
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_S_27 0x190EA630u

//! Register Reset Value
#define DESC0_3_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_S_27 Register DESC1_3_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_S_27 0x2A634
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_S_27 0x190EA634u

//! Register Reset Value
#define DESC1_3_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_S_27 Register DESC2_3_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_S_27 0x2A638
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_S_27 0x190EA638u

//! Register Reset Value
#define DESC2_3_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_S_27 Register DESC3_3_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_S_27 0x2A63C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_S_27 0x190EA63Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_27_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_27_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_27_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_S_27 Register DESC0_4_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_S_27 0x2A640
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_S_27 0x190EA640u

//! Register Reset Value
#define DESC0_4_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_S_27 Register DESC1_4_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_S_27 0x2A644
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_S_27 0x190EA644u

//! Register Reset Value
#define DESC1_4_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_S_27 Register DESC2_4_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_S_27 0x2A648
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_S_27 0x190EA648u

//! Register Reset Value
#define DESC2_4_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_S_27 Register DESC3_4_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_S_27 0x2A64C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_S_27 0x190EA64Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_27_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_27_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_27_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_S_27 Register DESC0_5_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_S_27 0x2A650
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_S_27 0x190EA650u

//! Register Reset Value
#define DESC0_5_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_S_27 Register DESC1_5_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_S_27 0x2A654
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_S_27 0x190EA654u

//! Register Reset Value
#define DESC1_5_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_S_27 Register DESC2_5_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_S_27 0x2A658
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_S_27 0x190EA658u

//! Register Reset Value
#define DESC2_5_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_S_27 Register DESC3_5_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_S_27 0x2A65C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_S_27 0x190EA65Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_27_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_27_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_27_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_S_27 Register DESC0_6_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_S_27 0x2A660
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_S_27 0x190EA660u

//! Register Reset Value
#define DESC0_6_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_S_27 Register DESC1_6_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_S_27 0x2A664
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_S_27 0x190EA664u

//! Register Reset Value
#define DESC1_6_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_S_27 Register DESC2_6_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_S_27 0x2A668
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_S_27 0x190EA668u

//! Register Reset Value
#define DESC2_6_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_S_27 Register DESC3_6_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_S_27 0x2A66C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_S_27 0x190EA66Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_27_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_27_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_27_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_S_27 Register DESC0_7_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_S_27 0x2A670
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_S_27 0x190EA670u

//! Register Reset Value
#define DESC0_7_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_S_27 Register DESC1_7_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_S_27 0x2A674
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_S_27 0x190EA674u

//! Register Reset Value
#define DESC1_7_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_S_27 Register DESC2_7_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_S_27 0x2A678
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_S_27 0x190EA678u

//! Register Reset Value
#define DESC2_7_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_27_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_S_27 Register DESC3_7_PON_EGP_S_27 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_S_27 0x2A67C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_S_27 0x190EA67Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_S_27_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_27_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_27_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_27_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_27_OWN_MASK 0x80000000u

//! @}

//! \defgroup CFG_PON_EGP_28 Register CFG_PON_EGP_28 - PON Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_PON_EGP_28 0x2A800
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_PON_EGP_28 0x190EA800u

//! Register Reset Value
#define CFG_PON_EGP_28_RST 0x00000000u

//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_28_DQREQ_POS 0
//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_28_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_28_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_28_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_28_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_28_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_28_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_28_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_28_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_28_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup IRNCR_PON_EGP_28 Register IRNCR_PON_EGP_28 - PON Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_PON_EGP_28 0x2A820
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_PON_EGP_28 0x190EA820u

//! Register Reset Value
#define IRNCR_PON_EGP_28_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_28_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_28_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_PON_EGP_28_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_PON_EGP_28_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_PON_EGP_28 Register IRNICR_PON_EGP_28 - PON Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_PON_EGP_28 0x2A824
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_PON_EGP_28 0x190EA824u

//! Register Reset Value
#define IRNICR_PON_EGP_28_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_28_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_28_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_PON_EGP_28 Register IRNEN_PON_EGP_28 - PON Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_PON_EGP_28 0x2A828
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_PON_EGP_28 0x190EA828u

//! Register Reset Value
#define IRNEN_PON_EGP_28_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_28_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_28_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_PON_EGP_28_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_PON_EGP_28_DR_EN 0x1

//! @}

//! \defgroup DPTR_PON_EGP_28 Register DPTR_PON_EGP_28 - PON Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_PON_EGP_28 0x2A830
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_PON_EGP_28 0x190EA830u

//! Register Reset Value
#define DPTR_PON_EGP_28_RST 0x00000707u

//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_28_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_28_ND_MASK 0x7u

//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_28_NSD_POS 8
//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_28_NSD_MASK 0x700u

//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_28_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_28_DPTR_MASK 0x70000u

//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_28_SDPTR_POS 24
//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_28_SDPTR_MASK 0x7000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_28 Register DESC0_0_PON_EGP_28 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_28 0x2A900
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_28 0x190EA900u

//! Register Reset Value
#define DESC0_0_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_28 Register DESC1_0_PON_EGP_28 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_28 0x2A904
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_28 0x190EA904u

//! Register Reset Value
#define DESC1_0_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_28 Register DESC2_0_PON_EGP_28 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_28 0x2A908
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_28 0x190EA908u

//! Register Reset Value
#define DESC2_0_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_28 Register DESC3_0_PON_EGP_28 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_28 0x2A90C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_28 0x190EA90Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_28_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_28_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_28_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_28 Register DESC0_1_PON_EGP_28 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_28 0x2A910
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_28 0x190EA910u

//! Register Reset Value
#define DESC0_1_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_28 Register DESC1_1_PON_EGP_28 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_28 0x2A914
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_28 0x190EA914u

//! Register Reset Value
#define DESC1_1_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_28 Register DESC2_1_PON_EGP_28 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_28 0x2A918
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_28 0x190EA918u

//! Register Reset Value
#define DESC2_1_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_28 Register DESC3_1_PON_EGP_28 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_28 0x2A91C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_28 0x190EA91Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_28_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_28_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_28_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_28 Register DESC0_2_PON_EGP_28 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_28 0x2A920
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_28 0x190EA920u

//! Register Reset Value
#define DESC0_2_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_28 Register DESC1_2_PON_EGP_28 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_28 0x2A924
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_28 0x190EA924u

//! Register Reset Value
#define DESC1_2_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_28 Register DESC2_2_PON_EGP_28 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_28 0x2A928
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_28 0x190EA928u

//! Register Reset Value
#define DESC2_2_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_28 Register DESC3_2_PON_EGP_28 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_28 0x2A92C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_28 0x190EA92Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_28_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_28_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_28_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_28 Register DESC0_3_PON_EGP_28 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_28 0x2A930
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_28 0x190EA930u

//! Register Reset Value
#define DESC0_3_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_28 Register DESC1_3_PON_EGP_28 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_28 0x2A934
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_28 0x190EA934u

//! Register Reset Value
#define DESC1_3_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_28 Register DESC2_3_PON_EGP_28 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_28 0x2A938
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_28 0x190EA938u

//! Register Reset Value
#define DESC2_3_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_28 Register DESC3_3_PON_EGP_28 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_28 0x2A93C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_28 0x190EA93Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_28_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_28_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_28_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_28 Register DESC0_4_PON_EGP_28 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_28 0x2A940
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_28 0x190EA940u

//! Register Reset Value
#define DESC0_4_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_28 Register DESC1_4_PON_EGP_28 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_28 0x2A944
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_28 0x190EA944u

//! Register Reset Value
#define DESC1_4_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_28 Register DESC2_4_PON_EGP_28 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_28 0x2A948
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_28 0x190EA948u

//! Register Reset Value
#define DESC2_4_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_28 Register DESC3_4_PON_EGP_28 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_28 0x2A94C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_28 0x190EA94Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_28_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_28_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_28_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_28 Register DESC0_5_PON_EGP_28 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_28 0x2A950
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_28 0x190EA950u

//! Register Reset Value
#define DESC0_5_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_28 Register DESC1_5_PON_EGP_28 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_28 0x2A954
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_28 0x190EA954u

//! Register Reset Value
#define DESC1_5_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_28 Register DESC2_5_PON_EGP_28 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_28 0x2A958
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_28 0x190EA958u

//! Register Reset Value
#define DESC2_5_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_28 Register DESC3_5_PON_EGP_28 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_28 0x2A95C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_28 0x190EA95Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_28_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_28_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_28_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_28 Register DESC0_6_PON_EGP_28 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_28 0x2A960
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_28 0x190EA960u

//! Register Reset Value
#define DESC0_6_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_28 Register DESC1_6_PON_EGP_28 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_28 0x2A964
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_28 0x190EA964u

//! Register Reset Value
#define DESC1_6_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_28 Register DESC2_6_PON_EGP_28 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_28 0x2A968
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_28 0x190EA968u

//! Register Reset Value
#define DESC2_6_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_28 Register DESC3_6_PON_EGP_28 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_28 0x2A96C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_28 0x190EA96Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_28_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_28_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_28_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_28 Register DESC0_7_PON_EGP_28 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_28 0x2A970
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_28 0x190EA970u

//! Register Reset Value
#define DESC0_7_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_28 Register DESC1_7_PON_EGP_28 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_28 0x2A974
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_28 0x190EA974u

//! Register Reset Value
#define DESC1_7_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_28 Register DESC2_7_PON_EGP_28 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_28 0x2A978
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_28 0x190EA978u

//! Register Reset Value
#define DESC2_7_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_28 Register DESC3_7_PON_EGP_28 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_28 0x2A97C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_28 0x190EA97Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_28_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_28_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_28_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_28_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_28_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_S_28 Register DESC0_0_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_S_28 0x2AA00
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_S_28 0x190EAA00u

//! Register Reset Value
#define DESC0_0_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_S_28 Register DESC1_0_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_S_28 0x2AA04
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_S_28 0x190EAA04u

//! Register Reset Value
#define DESC1_0_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_S_28 Register DESC2_0_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_S_28 0x2AA08
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_S_28 0x190EAA08u

//! Register Reset Value
#define DESC2_0_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_S_28 Register DESC3_0_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_S_28 0x2AA0C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_S_28 0x190EAA0Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_28_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_28_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_28_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_S_28 Register DESC0_1_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_S_28 0x2AA10
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_S_28 0x190EAA10u

//! Register Reset Value
#define DESC0_1_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_S_28 Register DESC1_1_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_S_28 0x2AA14
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_S_28 0x190EAA14u

//! Register Reset Value
#define DESC1_1_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_S_28 Register DESC2_1_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_S_28 0x2AA18
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_S_28 0x190EAA18u

//! Register Reset Value
#define DESC2_1_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_S_28 Register DESC3_1_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_S_28 0x2AA1C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_S_28 0x190EAA1Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_28_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_28_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_28_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_S_28 Register DESC0_2_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_S_28 0x2AA20
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_S_28 0x190EAA20u

//! Register Reset Value
#define DESC0_2_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_S_28 Register DESC1_2_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_S_28 0x2AA24
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_S_28 0x190EAA24u

//! Register Reset Value
#define DESC1_2_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_S_28 Register DESC2_2_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_S_28 0x2AA28
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_S_28 0x190EAA28u

//! Register Reset Value
#define DESC2_2_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_S_28 Register DESC3_2_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_S_28 0x2AA2C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_S_28 0x190EAA2Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_28_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_28_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_28_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_S_28 Register DESC0_3_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_S_28 0x2AA30
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_S_28 0x190EAA30u

//! Register Reset Value
#define DESC0_3_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_S_28 Register DESC1_3_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_S_28 0x2AA34
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_S_28 0x190EAA34u

//! Register Reset Value
#define DESC1_3_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_S_28 Register DESC2_3_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_S_28 0x2AA38
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_S_28 0x190EAA38u

//! Register Reset Value
#define DESC2_3_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_S_28 Register DESC3_3_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_S_28 0x2AA3C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_S_28 0x190EAA3Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_28_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_28_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_28_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_S_28 Register DESC0_4_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_S_28 0x2AA40
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_S_28 0x190EAA40u

//! Register Reset Value
#define DESC0_4_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_S_28 Register DESC1_4_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_S_28 0x2AA44
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_S_28 0x190EAA44u

//! Register Reset Value
#define DESC1_4_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_S_28 Register DESC2_4_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_S_28 0x2AA48
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_S_28 0x190EAA48u

//! Register Reset Value
#define DESC2_4_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_S_28 Register DESC3_4_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_S_28 0x2AA4C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_S_28 0x190EAA4Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_28_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_28_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_28_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_S_28 Register DESC0_5_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_S_28 0x2AA50
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_S_28 0x190EAA50u

//! Register Reset Value
#define DESC0_5_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_S_28 Register DESC1_5_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_S_28 0x2AA54
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_S_28 0x190EAA54u

//! Register Reset Value
#define DESC1_5_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_S_28 Register DESC2_5_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_S_28 0x2AA58
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_S_28 0x190EAA58u

//! Register Reset Value
#define DESC2_5_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_S_28 Register DESC3_5_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_S_28 0x2AA5C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_S_28 0x190EAA5Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_28_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_28_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_28_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_S_28 Register DESC0_6_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_S_28 0x2AA60
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_S_28 0x190EAA60u

//! Register Reset Value
#define DESC0_6_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_S_28 Register DESC1_6_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_S_28 0x2AA64
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_S_28 0x190EAA64u

//! Register Reset Value
#define DESC1_6_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_S_28 Register DESC2_6_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_S_28 0x2AA68
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_S_28 0x190EAA68u

//! Register Reset Value
#define DESC2_6_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_S_28 Register DESC3_6_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_S_28 0x2AA6C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_S_28 0x190EAA6Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_28_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_28_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_28_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_S_28 Register DESC0_7_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_S_28 0x2AA70
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_S_28 0x190EAA70u

//! Register Reset Value
#define DESC0_7_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_S_28 Register DESC1_7_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_S_28 0x2AA74
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_S_28 0x190EAA74u

//! Register Reset Value
#define DESC1_7_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_S_28 Register DESC2_7_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_S_28 0x2AA78
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_S_28 0x190EAA78u

//! Register Reset Value
#define DESC2_7_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_28_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_S_28 Register DESC3_7_PON_EGP_S_28 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_S_28 0x2AA7C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_S_28 0x190EAA7Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_S_28_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_28_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_28_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_28_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_28_OWN_MASK 0x80000000u

//! @}

//! \defgroup CFG_PON_EGP_29 Register CFG_PON_EGP_29 - PON Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_PON_EGP_29 0x2AC00
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_PON_EGP_29 0x190EAC00u

//! Register Reset Value
#define CFG_PON_EGP_29_RST 0x00000000u

//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_29_DQREQ_POS 0
//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_29_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_29_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_29_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_29_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_29_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_29_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_29_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_29_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_29_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup IRNCR_PON_EGP_29 Register IRNCR_PON_EGP_29 - PON Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_PON_EGP_29 0x2AC20
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_PON_EGP_29 0x190EAC20u

//! Register Reset Value
#define IRNCR_PON_EGP_29_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_29_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_29_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_PON_EGP_29_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_PON_EGP_29_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_PON_EGP_29 Register IRNICR_PON_EGP_29 - PON Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_PON_EGP_29 0x2AC24
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_PON_EGP_29 0x190EAC24u

//! Register Reset Value
#define IRNICR_PON_EGP_29_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_29_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_29_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_PON_EGP_29 Register IRNEN_PON_EGP_29 - PON Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_PON_EGP_29 0x2AC28
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_PON_EGP_29 0x190EAC28u

//! Register Reset Value
#define IRNEN_PON_EGP_29_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_29_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_29_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_PON_EGP_29_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_PON_EGP_29_DR_EN 0x1

//! @}

//! \defgroup DPTR_PON_EGP_29 Register DPTR_PON_EGP_29 - PON Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_PON_EGP_29 0x2AC30
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_PON_EGP_29 0x190EAC30u

//! Register Reset Value
#define DPTR_PON_EGP_29_RST 0x00000707u

//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_29_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_29_ND_MASK 0x7u

//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_29_NSD_POS 8
//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_29_NSD_MASK 0x700u

//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_29_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_29_DPTR_MASK 0x70000u

//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_29_SDPTR_POS 24
//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_29_SDPTR_MASK 0x7000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_29 Register DESC0_0_PON_EGP_29 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_29 0x2AD00
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_29 0x190EAD00u

//! Register Reset Value
#define DESC0_0_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_29 Register DESC1_0_PON_EGP_29 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_29 0x2AD04
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_29 0x190EAD04u

//! Register Reset Value
#define DESC1_0_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_29 Register DESC2_0_PON_EGP_29 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_29 0x2AD08
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_29 0x190EAD08u

//! Register Reset Value
#define DESC2_0_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_29 Register DESC3_0_PON_EGP_29 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_29 0x2AD0C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_29 0x190EAD0Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_29_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_29_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_29_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_29 Register DESC0_1_PON_EGP_29 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_29 0x2AD10
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_29 0x190EAD10u

//! Register Reset Value
#define DESC0_1_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_29 Register DESC1_1_PON_EGP_29 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_29 0x2AD14
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_29 0x190EAD14u

//! Register Reset Value
#define DESC1_1_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_29 Register DESC2_1_PON_EGP_29 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_29 0x2AD18
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_29 0x190EAD18u

//! Register Reset Value
#define DESC2_1_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_29 Register DESC3_1_PON_EGP_29 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_29 0x2AD1C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_29 0x190EAD1Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_29_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_29_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_29_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_29 Register DESC0_2_PON_EGP_29 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_29 0x2AD20
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_29 0x190EAD20u

//! Register Reset Value
#define DESC0_2_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_29 Register DESC1_2_PON_EGP_29 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_29 0x2AD24
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_29 0x190EAD24u

//! Register Reset Value
#define DESC1_2_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_29 Register DESC2_2_PON_EGP_29 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_29 0x2AD28
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_29 0x190EAD28u

//! Register Reset Value
#define DESC2_2_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_29 Register DESC3_2_PON_EGP_29 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_29 0x2AD2C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_29 0x190EAD2Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_29_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_29_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_29_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_29 Register DESC0_3_PON_EGP_29 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_29 0x2AD30
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_29 0x190EAD30u

//! Register Reset Value
#define DESC0_3_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_29 Register DESC1_3_PON_EGP_29 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_29 0x2AD34
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_29 0x190EAD34u

//! Register Reset Value
#define DESC1_3_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_29 Register DESC2_3_PON_EGP_29 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_29 0x2AD38
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_29 0x190EAD38u

//! Register Reset Value
#define DESC2_3_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_29 Register DESC3_3_PON_EGP_29 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_29 0x2AD3C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_29 0x190EAD3Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_29_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_29_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_29_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_29 Register DESC0_4_PON_EGP_29 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_29 0x2AD40
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_29 0x190EAD40u

//! Register Reset Value
#define DESC0_4_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_29 Register DESC1_4_PON_EGP_29 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_29 0x2AD44
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_29 0x190EAD44u

//! Register Reset Value
#define DESC1_4_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_29 Register DESC2_4_PON_EGP_29 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_29 0x2AD48
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_29 0x190EAD48u

//! Register Reset Value
#define DESC2_4_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_29 Register DESC3_4_PON_EGP_29 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_29 0x2AD4C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_29 0x190EAD4Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_29_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_29_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_29_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_29 Register DESC0_5_PON_EGP_29 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_29 0x2AD50
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_29 0x190EAD50u

//! Register Reset Value
#define DESC0_5_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_29 Register DESC1_5_PON_EGP_29 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_29 0x2AD54
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_29 0x190EAD54u

//! Register Reset Value
#define DESC1_5_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_29 Register DESC2_5_PON_EGP_29 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_29 0x2AD58
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_29 0x190EAD58u

//! Register Reset Value
#define DESC2_5_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_29 Register DESC3_5_PON_EGP_29 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_29 0x2AD5C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_29 0x190EAD5Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_29_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_29_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_29_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_29 Register DESC0_6_PON_EGP_29 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_29 0x2AD60
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_29 0x190EAD60u

//! Register Reset Value
#define DESC0_6_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_29 Register DESC1_6_PON_EGP_29 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_29 0x2AD64
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_29 0x190EAD64u

//! Register Reset Value
#define DESC1_6_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_29 Register DESC2_6_PON_EGP_29 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_29 0x2AD68
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_29 0x190EAD68u

//! Register Reset Value
#define DESC2_6_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_29 Register DESC3_6_PON_EGP_29 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_29 0x2AD6C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_29 0x190EAD6Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_29_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_29_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_29_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_29 Register DESC0_7_PON_EGP_29 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_29 0x2AD70
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_29 0x190EAD70u

//! Register Reset Value
#define DESC0_7_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_29 Register DESC1_7_PON_EGP_29 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_29 0x2AD74
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_29 0x190EAD74u

//! Register Reset Value
#define DESC1_7_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_29 Register DESC2_7_PON_EGP_29 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_29 0x2AD78
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_29 0x190EAD78u

//! Register Reset Value
#define DESC2_7_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_29 Register DESC3_7_PON_EGP_29 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_29 0x2AD7C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_29 0x190EAD7Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_29_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_29_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_29_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_29_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_29_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_S_29 Register DESC0_0_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_S_29 0x2AE00
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_S_29 0x190EAE00u

//! Register Reset Value
#define DESC0_0_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_S_29 Register DESC1_0_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_S_29 0x2AE04
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_S_29 0x190EAE04u

//! Register Reset Value
#define DESC1_0_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_S_29 Register DESC2_0_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_S_29 0x2AE08
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_S_29 0x190EAE08u

//! Register Reset Value
#define DESC2_0_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_S_29 Register DESC3_0_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_S_29 0x2AE0C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_S_29 0x190EAE0Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_29_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_29_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_29_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_S_29 Register DESC0_1_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_S_29 0x2AE10
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_S_29 0x190EAE10u

//! Register Reset Value
#define DESC0_1_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_S_29 Register DESC1_1_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_S_29 0x2AE14
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_S_29 0x190EAE14u

//! Register Reset Value
#define DESC1_1_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_S_29 Register DESC2_1_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_S_29 0x2AE18
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_S_29 0x190EAE18u

//! Register Reset Value
#define DESC2_1_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_S_29 Register DESC3_1_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_S_29 0x2AE1C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_S_29 0x190EAE1Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_29_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_29_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_29_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_S_29 Register DESC0_2_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_S_29 0x2AE20
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_S_29 0x190EAE20u

//! Register Reset Value
#define DESC0_2_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_S_29 Register DESC1_2_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_S_29 0x2AE24
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_S_29 0x190EAE24u

//! Register Reset Value
#define DESC1_2_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_S_29 Register DESC2_2_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_S_29 0x2AE28
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_S_29 0x190EAE28u

//! Register Reset Value
#define DESC2_2_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_S_29 Register DESC3_2_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_S_29 0x2AE2C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_S_29 0x190EAE2Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_29_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_29_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_29_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_S_29 Register DESC0_3_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_S_29 0x2AE30
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_S_29 0x190EAE30u

//! Register Reset Value
#define DESC0_3_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_S_29 Register DESC1_3_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_S_29 0x2AE34
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_S_29 0x190EAE34u

//! Register Reset Value
#define DESC1_3_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_S_29 Register DESC2_3_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_S_29 0x2AE38
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_S_29 0x190EAE38u

//! Register Reset Value
#define DESC2_3_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_S_29 Register DESC3_3_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_S_29 0x2AE3C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_S_29 0x190EAE3Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_29_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_29_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_29_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_S_29 Register DESC0_4_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_S_29 0x2AE40
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_S_29 0x190EAE40u

//! Register Reset Value
#define DESC0_4_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_S_29 Register DESC1_4_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_S_29 0x2AE44
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_S_29 0x190EAE44u

//! Register Reset Value
#define DESC1_4_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_S_29 Register DESC2_4_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_S_29 0x2AE48
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_S_29 0x190EAE48u

//! Register Reset Value
#define DESC2_4_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_S_29 Register DESC3_4_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_S_29 0x2AE4C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_S_29 0x190EAE4Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_29_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_29_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_29_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_S_29 Register DESC0_5_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_S_29 0x2AE50
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_S_29 0x190EAE50u

//! Register Reset Value
#define DESC0_5_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_S_29 Register DESC1_5_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_S_29 0x2AE54
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_S_29 0x190EAE54u

//! Register Reset Value
#define DESC1_5_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_S_29 Register DESC2_5_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_S_29 0x2AE58
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_S_29 0x190EAE58u

//! Register Reset Value
#define DESC2_5_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_S_29 Register DESC3_5_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_S_29 0x2AE5C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_S_29 0x190EAE5Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_29_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_29_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_29_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_S_29 Register DESC0_6_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_S_29 0x2AE60
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_S_29 0x190EAE60u

//! Register Reset Value
#define DESC0_6_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_S_29 Register DESC1_6_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_S_29 0x2AE64
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_S_29 0x190EAE64u

//! Register Reset Value
#define DESC1_6_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_S_29 Register DESC2_6_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_S_29 0x2AE68
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_S_29 0x190EAE68u

//! Register Reset Value
#define DESC2_6_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_S_29 Register DESC3_6_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_S_29 0x2AE6C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_S_29 0x190EAE6Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_29_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_29_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_29_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_S_29 Register DESC0_7_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_S_29 0x2AE70
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_S_29 0x190EAE70u

//! Register Reset Value
#define DESC0_7_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_S_29 Register DESC1_7_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_S_29 0x2AE74
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_S_29 0x190EAE74u

//! Register Reset Value
#define DESC1_7_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_S_29 Register DESC2_7_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_S_29 0x2AE78
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_S_29 0x190EAE78u

//! Register Reset Value
#define DESC2_7_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_29_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_S_29 Register DESC3_7_PON_EGP_S_29 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_S_29 0x2AE7C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_S_29 0x190EAE7Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_S_29_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_29_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_29_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_29_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_29_OWN_MASK 0x80000000u

//! @}

//! \defgroup CFG_PON_EGP_30 Register CFG_PON_EGP_30 - PON Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_PON_EGP_30 0x2B000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_PON_EGP_30 0x190EB000u

//! Register Reset Value
#define CFG_PON_EGP_30_RST 0x00000000u

//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_30_DQREQ_POS 0
//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_30_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_30_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_30_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_30_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_30_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_30_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_30_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_30_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_30_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup IRNCR_PON_EGP_30 Register IRNCR_PON_EGP_30 - PON Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_PON_EGP_30 0x2B020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_PON_EGP_30 0x190EB020u

//! Register Reset Value
#define IRNCR_PON_EGP_30_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_30_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_30_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_PON_EGP_30_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_PON_EGP_30_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_PON_EGP_30 Register IRNICR_PON_EGP_30 - PON Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_PON_EGP_30 0x2B024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_PON_EGP_30 0x190EB024u

//! Register Reset Value
#define IRNICR_PON_EGP_30_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_30_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_30_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_PON_EGP_30 Register IRNEN_PON_EGP_30 - PON Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_PON_EGP_30 0x2B028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_PON_EGP_30 0x190EB028u

//! Register Reset Value
#define IRNEN_PON_EGP_30_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_30_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_30_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_PON_EGP_30_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_PON_EGP_30_DR_EN 0x1

//! @}

//! \defgroup DPTR_PON_EGP_30 Register DPTR_PON_EGP_30 - PON Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_PON_EGP_30 0x2B030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_PON_EGP_30 0x190EB030u

//! Register Reset Value
#define DPTR_PON_EGP_30_RST 0x00000707u

//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_30_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_30_ND_MASK 0x7u

//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_30_NSD_POS 8
//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_30_NSD_MASK 0x700u

//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_30_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_30_DPTR_MASK 0x70000u

//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_30_SDPTR_POS 24
//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_30_SDPTR_MASK 0x7000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_30 Register DESC0_0_PON_EGP_30 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_30 0x2B100
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_30 0x190EB100u

//! Register Reset Value
#define DESC0_0_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_30 Register DESC1_0_PON_EGP_30 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_30 0x2B104
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_30 0x190EB104u

//! Register Reset Value
#define DESC1_0_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_30 Register DESC2_0_PON_EGP_30 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_30 0x2B108
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_30 0x190EB108u

//! Register Reset Value
#define DESC2_0_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_30 Register DESC3_0_PON_EGP_30 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_30 0x2B10C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_30 0x190EB10Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_30_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_30_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_30_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_30 Register DESC0_1_PON_EGP_30 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_30 0x2B110
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_30 0x190EB110u

//! Register Reset Value
#define DESC0_1_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_30 Register DESC1_1_PON_EGP_30 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_30 0x2B114
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_30 0x190EB114u

//! Register Reset Value
#define DESC1_1_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_30 Register DESC2_1_PON_EGP_30 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_30 0x2B118
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_30 0x190EB118u

//! Register Reset Value
#define DESC2_1_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_30 Register DESC3_1_PON_EGP_30 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_30 0x2B11C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_30 0x190EB11Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_30_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_30_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_30_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_30 Register DESC0_2_PON_EGP_30 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_30 0x2B120
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_30 0x190EB120u

//! Register Reset Value
#define DESC0_2_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_30 Register DESC1_2_PON_EGP_30 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_30 0x2B124
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_30 0x190EB124u

//! Register Reset Value
#define DESC1_2_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_30 Register DESC2_2_PON_EGP_30 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_30 0x2B128
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_30 0x190EB128u

//! Register Reset Value
#define DESC2_2_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_30 Register DESC3_2_PON_EGP_30 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_30 0x2B12C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_30 0x190EB12Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_30_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_30_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_30_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_30 Register DESC0_3_PON_EGP_30 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_30 0x2B130
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_30 0x190EB130u

//! Register Reset Value
#define DESC0_3_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_30 Register DESC1_3_PON_EGP_30 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_30 0x2B134
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_30 0x190EB134u

//! Register Reset Value
#define DESC1_3_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_30 Register DESC2_3_PON_EGP_30 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_30 0x2B138
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_30 0x190EB138u

//! Register Reset Value
#define DESC2_3_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_30 Register DESC3_3_PON_EGP_30 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_30 0x2B13C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_30 0x190EB13Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_30_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_30_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_30_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_30 Register DESC0_4_PON_EGP_30 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_30 0x2B140
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_30 0x190EB140u

//! Register Reset Value
#define DESC0_4_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_30 Register DESC1_4_PON_EGP_30 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_30 0x2B144
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_30 0x190EB144u

//! Register Reset Value
#define DESC1_4_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_30 Register DESC2_4_PON_EGP_30 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_30 0x2B148
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_30 0x190EB148u

//! Register Reset Value
#define DESC2_4_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_30 Register DESC3_4_PON_EGP_30 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_30 0x2B14C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_30 0x190EB14Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_30_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_30_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_30_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_30 Register DESC0_5_PON_EGP_30 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_30 0x2B150
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_30 0x190EB150u

//! Register Reset Value
#define DESC0_5_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_30 Register DESC1_5_PON_EGP_30 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_30 0x2B154
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_30 0x190EB154u

//! Register Reset Value
#define DESC1_5_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_30 Register DESC2_5_PON_EGP_30 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_30 0x2B158
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_30 0x190EB158u

//! Register Reset Value
#define DESC2_5_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_30 Register DESC3_5_PON_EGP_30 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_30 0x2B15C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_30 0x190EB15Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_30_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_30_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_30_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_30 Register DESC0_6_PON_EGP_30 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_30 0x2B160
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_30 0x190EB160u

//! Register Reset Value
#define DESC0_6_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_30 Register DESC1_6_PON_EGP_30 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_30 0x2B164
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_30 0x190EB164u

//! Register Reset Value
#define DESC1_6_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_30 Register DESC2_6_PON_EGP_30 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_30 0x2B168
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_30 0x190EB168u

//! Register Reset Value
#define DESC2_6_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_30 Register DESC3_6_PON_EGP_30 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_30 0x2B16C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_30 0x190EB16Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_30_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_30_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_30_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_30 Register DESC0_7_PON_EGP_30 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_30 0x2B170
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_30 0x190EB170u

//! Register Reset Value
#define DESC0_7_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_30 Register DESC1_7_PON_EGP_30 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_30 0x2B174
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_30 0x190EB174u

//! Register Reset Value
#define DESC1_7_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_30 Register DESC2_7_PON_EGP_30 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_30 0x2B178
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_30 0x190EB178u

//! Register Reset Value
#define DESC2_7_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_30 Register DESC3_7_PON_EGP_30 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_30 0x2B17C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_30 0x190EB17Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_30_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_30_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_30_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_30_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_30_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_S_30 Register DESC0_0_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_S_30 0x2B200
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_S_30 0x190EB200u

//! Register Reset Value
#define DESC0_0_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_S_30 Register DESC1_0_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_S_30 0x2B204
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_S_30 0x190EB204u

//! Register Reset Value
#define DESC1_0_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_S_30 Register DESC2_0_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_S_30 0x2B208
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_S_30 0x190EB208u

//! Register Reset Value
#define DESC2_0_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_S_30 Register DESC3_0_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_S_30 0x2B20C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_S_30 0x190EB20Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_30_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_30_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_30_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_S_30 Register DESC0_1_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_S_30 0x2B210
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_S_30 0x190EB210u

//! Register Reset Value
#define DESC0_1_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_S_30 Register DESC1_1_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_S_30 0x2B214
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_S_30 0x190EB214u

//! Register Reset Value
#define DESC1_1_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_S_30 Register DESC2_1_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_S_30 0x2B218
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_S_30 0x190EB218u

//! Register Reset Value
#define DESC2_1_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_S_30 Register DESC3_1_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_S_30 0x2B21C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_S_30 0x190EB21Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_30_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_30_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_30_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_S_30 Register DESC0_2_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_S_30 0x2B220
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_S_30 0x190EB220u

//! Register Reset Value
#define DESC0_2_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_S_30 Register DESC1_2_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_S_30 0x2B224
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_S_30 0x190EB224u

//! Register Reset Value
#define DESC1_2_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_S_30 Register DESC2_2_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_S_30 0x2B228
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_S_30 0x190EB228u

//! Register Reset Value
#define DESC2_2_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_S_30 Register DESC3_2_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_S_30 0x2B22C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_S_30 0x190EB22Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_30_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_30_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_30_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_S_30 Register DESC0_3_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_S_30 0x2B230
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_S_30 0x190EB230u

//! Register Reset Value
#define DESC0_3_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_S_30 Register DESC1_3_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_S_30 0x2B234
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_S_30 0x190EB234u

//! Register Reset Value
#define DESC1_3_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_S_30 Register DESC2_3_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_S_30 0x2B238
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_S_30 0x190EB238u

//! Register Reset Value
#define DESC2_3_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_S_30 Register DESC3_3_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_S_30 0x2B23C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_S_30 0x190EB23Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_30_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_30_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_30_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_S_30 Register DESC0_4_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_S_30 0x2B240
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_S_30 0x190EB240u

//! Register Reset Value
#define DESC0_4_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_S_30 Register DESC1_4_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_S_30 0x2B244
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_S_30 0x190EB244u

//! Register Reset Value
#define DESC1_4_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_S_30 Register DESC2_4_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_S_30 0x2B248
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_S_30 0x190EB248u

//! Register Reset Value
#define DESC2_4_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_S_30 Register DESC3_4_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_S_30 0x2B24C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_S_30 0x190EB24Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_30_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_30_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_30_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_S_30 Register DESC0_5_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_S_30 0x2B250
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_S_30 0x190EB250u

//! Register Reset Value
#define DESC0_5_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_S_30 Register DESC1_5_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_S_30 0x2B254
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_S_30 0x190EB254u

//! Register Reset Value
#define DESC1_5_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_S_30 Register DESC2_5_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_S_30 0x2B258
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_S_30 0x190EB258u

//! Register Reset Value
#define DESC2_5_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_S_30 Register DESC3_5_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_S_30 0x2B25C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_S_30 0x190EB25Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_30_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_30_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_30_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_S_30 Register DESC0_6_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_S_30 0x2B260
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_S_30 0x190EB260u

//! Register Reset Value
#define DESC0_6_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_S_30 Register DESC1_6_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_S_30 0x2B264
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_S_30 0x190EB264u

//! Register Reset Value
#define DESC1_6_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_S_30 Register DESC2_6_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_S_30 0x2B268
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_S_30 0x190EB268u

//! Register Reset Value
#define DESC2_6_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_S_30 Register DESC3_6_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_S_30 0x2B26C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_S_30 0x190EB26Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_30_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_30_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_30_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_S_30 Register DESC0_7_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_S_30 0x2B270
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_S_30 0x190EB270u

//! Register Reset Value
#define DESC0_7_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_S_30 Register DESC1_7_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_S_30 0x2B274
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_S_30 0x190EB274u

//! Register Reset Value
#define DESC1_7_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_S_30 Register DESC2_7_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_S_30 0x2B278
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_S_30 0x190EB278u

//! Register Reset Value
#define DESC2_7_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_30_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_S_30 Register DESC3_7_PON_EGP_S_30 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_S_30 0x2B27C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_S_30 0x190EB27Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_S_30_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_30_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_30_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_30_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_30_OWN_MASK 0x80000000u

//! @}

//! \defgroup CFG_PON_EGP_31 Register CFG_PON_EGP_31 - PON Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_PON_EGP_31 0x2B400
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_PON_EGP_31 0x190EB400u

//! Register Reset Value
#define CFG_PON_EGP_31_RST 0x00000000u

//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_31_DQREQ_POS 0
//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_31_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_31_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_31_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_31_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_31_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_31_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_31_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_31_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_31_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup IRNCR_PON_EGP_31 Register IRNCR_PON_EGP_31 - PON Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_PON_EGP_31 0x2B420
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_PON_EGP_31 0x190EB420u

//! Register Reset Value
#define IRNCR_PON_EGP_31_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_31_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_31_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_PON_EGP_31_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_PON_EGP_31_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_PON_EGP_31 Register IRNICR_PON_EGP_31 - PON Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_PON_EGP_31 0x2B424
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_PON_EGP_31 0x190EB424u

//! Register Reset Value
#define IRNICR_PON_EGP_31_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_31_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_31_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_PON_EGP_31 Register IRNEN_PON_EGP_31 - PON Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_PON_EGP_31 0x2B428
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_PON_EGP_31 0x190EB428u

//! Register Reset Value
#define IRNEN_PON_EGP_31_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_31_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_31_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_PON_EGP_31_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_PON_EGP_31_DR_EN 0x1

//! @}

//! \defgroup DPTR_PON_EGP_31 Register DPTR_PON_EGP_31 - PON Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_PON_EGP_31 0x2B430
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_PON_EGP_31 0x190EB430u

//! Register Reset Value
#define DPTR_PON_EGP_31_RST 0x00000707u

//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_31_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_31_ND_MASK 0x7u

//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_31_NSD_POS 8
//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_31_NSD_MASK 0x700u

//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_31_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_31_DPTR_MASK 0x70000u

//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_31_SDPTR_POS 24
//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_31_SDPTR_MASK 0x7000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_31 Register DESC0_0_PON_EGP_31 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_31 0x2B500
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_31 0x190EB500u

//! Register Reset Value
#define DESC0_0_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_31 Register DESC1_0_PON_EGP_31 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_31 0x2B504
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_31 0x190EB504u

//! Register Reset Value
#define DESC1_0_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_31 Register DESC2_0_PON_EGP_31 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_31 0x2B508
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_31 0x190EB508u

//! Register Reset Value
#define DESC2_0_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_31 Register DESC3_0_PON_EGP_31 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_31 0x2B50C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_31 0x190EB50Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_31_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_31_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_31_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_31 Register DESC0_1_PON_EGP_31 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_31 0x2B510
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_31 0x190EB510u

//! Register Reset Value
#define DESC0_1_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_31 Register DESC1_1_PON_EGP_31 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_31 0x2B514
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_31 0x190EB514u

//! Register Reset Value
#define DESC1_1_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_31 Register DESC2_1_PON_EGP_31 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_31 0x2B518
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_31 0x190EB518u

//! Register Reset Value
#define DESC2_1_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_31 Register DESC3_1_PON_EGP_31 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_31 0x2B51C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_31 0x190EB51Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_31_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_31_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_31_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_31 Register DESC0_2_PON_EGP_31 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_31 0x2B520
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_31 0x190EB520u

//! Register Reset Value
#define DESC0_2_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_31 Register DESC1_2_PON_EGP_31 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_31 0x2B524
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_31 0x190EB524u

//! Register Reset Value
#define DESC1_2_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_31 Register DESC2_2_PON_EGP_31 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_31 0x2B528
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_31 0x190EB528u

//! Register Reset Value
#define DESC2_2_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_31 Register DESC3_2_PON_EGP_31 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_31 0x2B52C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_31 0x190EB52Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_31_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_31_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_31_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_31 Register DESC0_3_PON_EGP_31 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_31 0x2B530
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_31 0x190EB530u

//! Register Reset Value
#define DESC0_3_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_31 Register DESC1_3_PON_EGP_31 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_31 0x2B534
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_31 0x190EB534u

//! Register Reset Value
#define DESC1_3_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_31 Register DESC2_3_PON_EGP_31 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_31 0x2B538
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_31 0x190EB538u

//! Register Reset Value
#define DESC2_3_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_31 Register DESC3_3_PON_EGP_31 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_31 0x2B53C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_31 0x190EB53Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_31_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_31_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_31_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_31 Register DESC0_4_PON_EGP_31 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_31 0x2B540
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_31 0x190EB540u

//! Register Reset Value
#define DESC0_4_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_31 Register DESC1_4_PON_EGP_31 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_31 0x2B544
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_31 0x190EB544u

//! Register Reset Value
#define DESC1_4_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_31 Register DESC2_4_PON_EGP_31 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_31 0x2B548
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_31 0x190EB548u

//! Register Reset Value
#define DESC2_4_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_31 Register DESC3_4_PON_EGP_31 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_31 0x2B54C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_31 0x190EB54Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_31_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_31_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_31_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_31 Register DESC0_5_PON_EGP_31 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_31 0x2B550
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_31 0x190EB550u

//! Register Reset Value
#define DESC0_5_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_31 Register DESC1_5_PON_EGP_31 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_31 0x2B554
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_31 0x190EB554u

//! Register Reset Value
#define DESC1_5_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_31 Register DESC2_5_PON_EGP_31 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_31 0x2B558
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_31 0x190EB558u

//! Register Reset Value
#define DESC2_5_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_31 Register DESC3_5_PON_EGP_31 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_31 0x2B55C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_31 0x190EB55Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_31_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_31_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_31_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_31 Register DESC0_6_PON_EGP_31 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_31 0x2B560
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_31 0x190EB560u

//! Register Reset Value
#define DESC0_6_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_31 Register DESC1_6_PON_EGP_31 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_31 0x2B564
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_31 0x190EB564u

//! Register Reset Value
#define DESC1_6_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_31 Register DESC2_6_PON_EGP_31 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_31 0x2B568
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_31 0x190EB568u

//! Register Reset Value
#define DESC2_6_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_31 Register DESC3_6_PON_EGP_31 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_31 0x2B56C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_31 0x190EB56Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_31_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_31_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_31_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_31 Register DESC0_7_PON_EGP_31 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_31 0x2B570
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_31 0x190EB570u

//! Register Reset Value
#define DESC0_7_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_31 Register DESC1_7_PON_EGP_31 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_31 0x2B574
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_31 0x190EB574u

//! Register Reset Value
#define DESC1_7_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_31 Register DESC2_7_PON_EGP_31 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_31 0x2B578
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_31 0x190EB578u

//! Register Reset Value
#define DESC2_7_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_31 Register DESC3_7_PON_EGP_31 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_31 0x2B57C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_31 0x190EB57Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_31_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_31_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_31_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_31_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_31_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_S_31 Register DESC0_0_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_S_31 0x2B600
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_S_31 0x190EB600u

//! Register Reset Value
#define DESC0_0_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_S_31 Register DESC1_0_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_S_31 0x2B604
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_S_31 0x190EB604u

//! Register Reset Value
#define DESC1_0_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_S_31 Register DESC2_0_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_S_31 0x2B608
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_S_31 0x190EB608u

//! Register Reset Value
#define DESC2_0_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_S_31 Register DESC3_0_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_S_31 0x2B60C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_S_31 0x190EB60Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_31_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_31_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_31_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_S_31 Register DESC0_1_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_S_31 0x2B610
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_S_31 0x190EB610u

//! Register Reset Value
#define DESC0_1_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_S_31 Register DESC1_1_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_S_31 0x2B614
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_S_31 0x190EB614u

//! Register Reset Value
#define DESC1_1_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_S_31 Register DESC2_1_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_S_31 0x2B618
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_S_31 0x190EB618u

//! Register Reset Value
#define DESC2_1_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_S_31 Register DESC3_1_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_S_31 0x2B61C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_S_31 0x190EB61Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_31_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_31_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_31_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_S_31 Register DESC0_2_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_S_31 0x2B620
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_S_31 0x190EB620u

//! Register Reset Value
#define DESC0_2_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_S_31 Register DESC1_2_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_S_31 0x2B624
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_S_31 0x190EB624u

//! Register Reset Value
#define DESC1_2_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_S_31 Register DESC2_2_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_S_31 0x2B628
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_S_31 0x190EB628u

//! Register Reset Value
#define DESC2_2_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_S_31 Register DESC3_2_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_S_31 0x2B62C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_S_31 0x190EB62Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_31_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_31_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_31_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_S_31 Register DESC0_3_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_S_31 0x2B630
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_S_31 0x190EB630u

//! Register Reset Value
#define DESC0_3_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_S_31 Register DESC1_3_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_S_31 0x2B634
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_S_31 0x190EB634u

//! Register Reset Value
#define DESC1_3_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_S_31 Register DESC2_3_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_S_31 0x2B638
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_S_31 0x190EB638u

//! Register Reset Value
#define DESC2_3_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_S_31 Register DESC3_3_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_S_31 0x2B63C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_S_31 0x190EB63Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_31_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_31_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_31_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_S_31 Register DESC0_4_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_S_31 0x2B640
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_S_31 0x190EB640u

//! Register Reset Value
#define DESC0_4_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_S_31 Register DESC1_4_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_S_31 0x2B644
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_S_31 0x190EB644u

//! Register Reset Value
#define DESC1_4_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_S_31 Register DESC2_4_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_S_31 0x2B648
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_S_31 0x190EB648u

//! Register Reset Value
#define DESC2_4_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_S_31 Register DESC3_4_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_S_31 0x2B64C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_S_31 0x190EB64Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_31_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_31_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_31_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_S_31 Register DESC0_5_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_S_31 0x2B650
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_S_31 0x190EB650u

//! Register Reset Value
#define DESC0_5_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_S_31 Register DESC1_5_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_S_31 0x2B654
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_S_31 0x190EB654u

//! Register Reset Value
#define DESC1_5_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_S_31 Register DESC2_5_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_S_31 0x2B658
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_S_31 0x190EB658u

//! Register Reset Value
#define DESC2_5_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_S_31 Register DESC3_5_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_S_31 0x2B65C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_S_31 0x190EB65Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_31_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_31_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_31_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_S_31 Register DESC0_6_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_S_31 0x2B660
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_S_31 0x190EB660u

//! Register Reset Value
#define DESC0_6_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_S_31 Register DESC1_6_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_S_31 0x2B664
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_S_31 0x190EB664u

//! Register Reset Value
#define DESC1_6_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_S_31 Register DESC2_6_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_S_31 0x2B668
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_S_31 0x190EB668u

//! Register Reset Value
#define DESC2_6_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_S_31 Register DESC3_6_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_S_31 0x2B66C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_S_31 0x190EB66Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_31_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_31_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_31_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_S_31 Register DESC0_7_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_S_31 0x2B670
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_S_31 0x190EB670u

//! Register Reset Value
#define DESC0_7_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_S_31 Register DESC1_7_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_S_31 0x2B674
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_S_31 0x190EB674u

//! Register Reset Value
#define DESC1_7_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_S_31 Register DESC2_7_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_S_31 0x2B678
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_S_31 0x190EB678u

//! Register Reset Value
#define DESC2_7_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_31_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_S_31 Register DESC3_7_PON_EGP_S_31 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_S_31 0x2B67C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_S_31 0x190EB67Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_S_31_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_31_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_31_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_31_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_31_OWN_MASK 0x80000000u

//! @}

//! \defgroup CFG_PON_EGP_32 Register CFG_PON_EGP_32 - PON Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_PON_EGP_32 0x2B800
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_PON_EGP_32 0x190EB800u

//! Register Reset Value
#define CFG_PON_EGP_32_RST 0x00000000u

//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_32_DQREQ_POS 0
//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_32_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_32_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_32_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_32_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_32_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_32_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_32_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_32_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_32_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup IRNCR_PON_EGP_32 Register IRNCR_PON_EGP_32 - PON Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_PON_EGP_32 0x2B820
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_PON_EGP_32 0x190EB820u

//! Register Reset Value
#define IRNCR_PON_EGP_32_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_32_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_32_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_PON_EGP_32_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_PON_EGP_32_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_PON_EGP_32 Register IRNICR_PON_EGP_32 - PON Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_PON_EGP_32 0x2B824
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_PON_EGP_32 0x190EB824u

//! Register Reset Value
#define IRNICR_PON_EGP_32_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_32_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_32_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_PON_EGP_32 Register IRNEN_PON_EGP_32 - PON Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_PON_EGP_32 0x2B828
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_PON_EGP_32 0x190EB828u

//! Register Reset Value
#define IRNEN_PON_EGP_32_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_32_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_32_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_PON_EGP_32_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_PON_EGP_32_DR_EN 0x1

//! @}

//! \defgroup DPTR_PON_EGP_32 Register DPTR_PON_EGP_32 - PON Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_PON_EGP_32 0x2B830
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_PON_EGP_32 0x190EB830u

//! Register Reset Value
#define DPTR_PON_EGP_32_RST 0x00000707u

//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_32_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_32_ND_MASK 0x7u

//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_32_NSD_POS 8
//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_32_NSD_MASK 0x700u

//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_32_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_32_DPTR_MASK 0x70000u

//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_32_SDPTR_POS 24
//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_32_SDPTR_MASK 0x7000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_32 Register DESC0_0_PON_EGP_32 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_32 0x2B900
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_32 0x190EB900u

//! Register Reset Value
#define DESC0_0_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_32 Register DESC1_0_PON_EGP_32 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_32 0x2B904
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_32 0x190EB904u

//! Register Reset Value
#define DESC1_0_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_32 Register DESC2_0_PON_EGP_32 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_32 0x2B908
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_32 0x190EB908u

//! Register Reset Value
#define DESC2_0_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_32 Register DESC3_0_PON_EGP_32 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_32 0x2B90C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_32 0x190EB90Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_32_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_32_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_32_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_32 Register DESC0_1_PON_EGP_32 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_32 0x2B910
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_32 0x190EB910u

//! Register Reset Value
#define DESC0_1_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_32 Register DESC1_1_PON_EGP_32 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_32 0x2B914
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_32 0x190EB914u

//! Register Reset Value
#define DESC1_1_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_32 Register DESC2_1_PON_EGP_32 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_32 0x2B918
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_32 0x190EB918u

//! Register Reset Value
#define DESC2_1_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_32 Register DESC3_1_PON_EGP_32 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_32 0x2B91C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_32 0x190EB91Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_32_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_32_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_32_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_32 Register DESC0_2_PON_EGP_32 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_32 0x2B920
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_32 0x190EB920u

//! Register Reset Value
#define DESC0_2_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_32 Register DESC1_2_PON_EGP_32 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_32 0x2B924
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_32 0x190EB924u

//! Register Reset Value
#define DESC1_2_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_32 Register DESC2_2_PON_EGP_32 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_32 0x2B928
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_32 0x190EB928u

//! Register Reset Value
#define DESC2_2_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_32 Register DESC3_2_PON_EGP_32 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_32 0x2B92C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_32 0x190EB92Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_32_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_32_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_32_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_32 Register DESC0_3_PON_EGP_32 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_32 0x2B930
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_32 0x190EB930u

//! Register Reset Value
#define DESC0_3_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_32 Register DESC1_3_PON_EGP_32 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_32 0x2B934
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_32 0x190EB934u

//! Register Reset Value
#define DESC1_3_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_32 Register DESC2_3_PON_EGP_32 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_32 0x2B938
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_32 0x190EB938u

//! Register Reset Value
#define DESC2_3_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_32 Register DESC3_3_PON_EGP_32 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_32 0x2B93C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_32 0x190EB93Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_32_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_32_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_32_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_32 Register DESC0_4_PON_EGP_32 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_32 0x2B940
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_32 0x190EB940u

//! Register Reset Value
#define DESC0_4_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_32 Register DESC1_4_PON_EGP_32 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_32 0x2B944
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_32 0x190EB944u

//! Register Reset Value
#define DESC1_4_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_32 Register DESC2_4_PON_EGP_32 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_32 0x2B948
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_32 0x190EB948u

//! Register Reset Value
#define DESC2_4_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_32 Register DESC3_4_PON_EGP_32 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_32 0x2B94C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_32 0x190EB94Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_32_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_32_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_32_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_32 Register DESC0_5_PON_EGP_32 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_32 0x2B950
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_32 0x190EB950u

//! Register Reset Value
#define DESC0_5_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_32 Register DESC1_5_PON_EGP_32 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_32 0x2B954
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_32 0x190EB954u

//! Register Reset Value
#define DESC1_5_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_32 Register DESC2_5_PON_EGP_32 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_32 0x2B958
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_32 0x190EB958u

//! Register Reset Value
#define DESC2_5_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_32 Register DESC3_5_PON_EGP_32 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_32 0x2B95C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_32 0x190EB95Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_32_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_32_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_32_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_32 Register DESC0_6_PON_EGP_32 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_32 0x2B960
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_32 0x190EB960u

//! Register Reset Value
#define DESC0_6_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_32 Register DESC1_6_PON_EGP_32 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_32 0x2B964
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_32 0x190EB964u

//! Register Reset Value
#define DESC1_6_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_32 Register DESC2_6_PON_EGP_32 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_32 0x2B968
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_32 0x190EB968u

//! Register Reset Value
#define DESC2_6_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_32 Register DESC3_6_PON_EGP_32 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_32 0x2B96C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_32 0x190EB96Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_32_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_32_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_32_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_32 Register DESC0_7_PON_EGP_32 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_32 0x2B970
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_32 0x190EB970u

//! Register Reset Value
#define DESC0_7_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_32 Register DESC1_7_PON_EGP_32 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_32 0x2B974
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_32 0x190EB974u

//! Register Reset Value
#define DESC1_7_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_32 Register DESC2_7_PON_EGP_32 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_32 0x2B978
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_32 0x190EB978u

//! Register Reset Value
#define DESC2_7_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_32 Register DESC3_7_PON_EGP_32 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_32 0x2B97C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_32 0x190EB97Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_32_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_32_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_32_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_32_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_32_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_S_32 Register DESC0_0_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_S_32 0x2BA00
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_S_32 0x190EBA00u

//! Register Reset Value
#define DESC0_0_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_S_32 Register DESC1_0_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_S_32 0x2BA04
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_S_32 0x190EBA04u

//! Register Reset Value
#define DESC1_0_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_S_32 Register DESC2_0_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_S_32 0x2BA08
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_S_32 0x190EBA08u

//! Register Reset Value
#define DESC2_0_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_S_32 Register DESC3_0_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_S_32 0x2BA0C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_S_32 0x190EBA0Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_32_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_32_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_32_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_S_32 Register DESC0_1_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_S_32 0x2BA10
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_S_32 0x190EBA10u

//! Register Reset Value
#define DESC0_1_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_S_32 Register DESC1_1_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_S_32 0x2BA14
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_S_32 0x190EBA14u

//! Register Reset Value
#define DESC1_1_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_S_32 Register DESC2_1_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_S_32 0x2BA18
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_S_32 0x190EBA18u

//! Register Reset Value
#define DESC2_1_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_S_32 Register DESC3_1_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_S_32 0x2BA1C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_S_32 0x190EBA1Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_32_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_32_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_32_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_S_32 Register DESC0_2_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_S_32 0x2BA20
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_S_32 0x190EBA20u

//! Register Reset Value
#define DESC0_2_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_S_32 Register DESC1_2_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_S_32 0x2BA24
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_S_32 0x190EBA24u

//! Register Reset Value
#define DESC1_2_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_S_32 Register DESC2_2_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_S_32 0x2BA28
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_S_32 0x190EBA28u

//! Register Reset Value
#define DESC2_2_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_S_32 Register DESC3_2_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_S_32 0x2BA2C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_S_32 0x190EBA2Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_32_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_32_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_32_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_S_32 Register DESC0_3_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_S_32 0x2BA30
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_S_32 0x190EBA30u

//! Register Reset Value
#define DESC0_3_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_S_32 Register DESC1_3_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_S_32 0x2BA34
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_S_32 0x190EBA34u

//! Register Reset Value
#define DESC1_3_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_S_32 Register DESC2_3_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_S_32 0x2BA38
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_S_32 0x190EBA38u

//! Register Reset Value
#define DESC2_3_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_S_32 Register DESC3_3_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_S_32 0x2BA3C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_S_32 0x190EBA3Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_32_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_32_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_32_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_S_32 Register DESC0_4_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_S_32 0x2BA40
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_S_32 0x190EBA40u

//! Register Reset Value
#define DESC0_4_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_S_32 Register DESC1_4_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_S_32 0x2BA44
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_S_32 0x190EBA44u

//! Register Reset Value
#define DESC1_4_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_S_32 Register DESC2_4_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_S_32 0x2BA48
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_S_32 0x190EBA48u

//! Register Reset Value
#define DESC2_4_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_S_32 Register DESC3_4_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_S_32 0x2BA4C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_S_32 0x190EBA4Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_32_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_32_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_32_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_S_32 Register DESC0_5_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_S_32 0x2BA50
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_S_32 0x190EBA50u

//! Register Reset Value
#define DESC0_5_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_S_32 Register DESC1_5_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_S_32 0x2BA54
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_S_32 0x190EBA54u

//! Register Reset Value
#define DESC1_5_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_S_32 Register DESC2_5_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_S_32 0x2BA58
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_S_32 0x190EBA58u

//! Register Reset Value
#define DESC2_5_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_S_32 Register DESC3_5_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_S_32 0x2BA5C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_S_32 0x190EBA5Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_32_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_32_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_32_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_S_32 Register DESC0_6_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_S_32 0x2BA60
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_S_32 0x190EBA60u

//! Register Reset Value
#define DESC0_6_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_S_32 Register DESC1_6_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_S_32 0x2BA64
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_S_32 0x190EBA64u

//! Register Reset Value
#define DESC1_6_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_S_32 Register DESC2_6_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_S_32 0x2BA68
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_S_32 0x190EBA68u

//! Register Reset Value
#define DESC2_6_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_S_32 Register DESC3_6_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_S_32 0x2BA6C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_S_32 0x190EBA6Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_32_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_32_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_32_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_S_32 Register DESC0_7_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_S_32 0x2BA70
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_S_32 0x190EBA70u

//! Register Reset Value
#define DESC0_7_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_S_32 Register DESC1_7_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_S_32 0x2BA74
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_S_32 0x190EBA74u

//! Register Reset Value
#define DESC1_7_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_S_32 Register DESC2_7_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_S_32 0x2BA78
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_S_32 0x190EBA78u

//! Register Reset Value
#define DESC2_7_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_32_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_S_32 Register DESC3_7_PON_EGP_S_32 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_S_32 0x2BA7C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_S_32 0x190EBA7Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_S_32_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_32_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_32_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_32_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_32_OWN_MASK 0x80000000u

//! @}

//! \defgroup CFG_PON_EGP_33 Register CFG_PON_EGP_33 - PON Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_PON_EGP_33 0x2BC00
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_PON_EGP_33 0x190EBC00u

//! Register Reset Value
#define CFG_PON_EGP_33_RST 0x00000000u

//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_33_DQREQ_POS 0
//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_33_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_33_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_33_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_33_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_33_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_33_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_33_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_33_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_33_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup IRNCR_PON_EGP_33 Register IRNCR_PON_EGP_33 - PON Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_PON_EGP_33 0x2BC20
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_PON_EGP_33 0x190EBC20u

//! Register Reset Value
#define IRNCR_PON_EGP_33_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_33_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_33_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_PON_EGP_33_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_PON_EGP_33_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_PON_EGP_33 Register IRNICR_PON_EGP_33 - PON Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_PON_EGP_33 0x2BC24
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_PON_EGP_33 0x190EBC24u

//! Register Reset Value
#define IRNICR_PON_EGP_33_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_33_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_33_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_PON_EGP_33 Register IRNEN_PON_EGP_33 - PON Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_PON_EGP_33 0x2BC28
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_PON_EGP_33 0x190EBC28u

//! Register Reset Value
#define IRNEN_PON_EGP_33_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_33_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_33_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_PON_EGP_33_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_PON_EGP_33_DR_EN 0x1

//! @}

//! \defgroup DPTR_PON_EGP_33 Register DPTR_PON_EGP_33 - PON Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_PON_EGP_33 0x2BC30
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_PON_EGP_33 0x190EBC30u

//! Register Reset Value
#define DPTR_PON_EGP_33_RST 0x00000707u

//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_33_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_33_ND_MASK 0x7u

//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_33_NSD_POS 8
//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_33_NSD_MASK 0x700u

//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_33_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_33_DPTR_MASK 0x70000u

//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_33_SDPTR_POS 24
//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_33_SDPTR_MASK 0x7000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_33 Register DESC0_0_PON_EGP_33 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_33 0x2BD00
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_33 0x190EBD00u

//! Register Reset Value
#define DESC0_0_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_33 Register DESC1_0_PON_EGP_33 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_33 0x2BD04
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_33 0x190EBD04u

//! Register Reset Value
#define DESC1_0_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_33 Register DESC2_0_PON_EGP_33 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_33 0x2BD08
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_33 0x190EBD08u

//! Register Reset Value
#define DESC2_0_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_33 Register DESC3_0_PON_EGP_33 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_33 0x2BD0C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_33 0x190EBD0Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_33_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_33_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_33_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_33 Register DESC0_1_PON_EGP_33 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_33 0x2BD10
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_33 0x190EBD10u

//! Register Reset Value
#define DESC0_1_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_33 Register DESC1_1_PON_EGP_33 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_33 0x2BD14
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_33 0x190EBD14u

//! Register Reset Value
#define DESC1_1_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_33 Register DESC2_1_PON_EGP_33 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_33 0x2BD18
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_33 0x190EBD18u

//! Register Reset Value
#define DESC2_1_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_33 Register DESC3_1_PON_EGP_33 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_33 0x2BD1C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_33 0x190EBD1Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_33_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_33_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_33_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_33 Register DESC0_2_PON_EGP_33 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_33 0x2BD20
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_33 0x190EBD20u

//! Register Reset Value
#define DESC0_2_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_33 Register DESC1_2_PON_EGP_33 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_33 0x2BD24
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_33 0x190EBD24u

//! Register Reset Value
#define DESC1_2_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_33 Register DESC2_2_PON_EGP_33 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_33 0x2BD28
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_33 0x190EBD28u

//! Register Reset Value
#define DESC2_2_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_33 Register DESC3_2_PON_EGP_33 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_33 0x2BD2C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_33 0x190EBD2Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_33_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_33_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_33_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_33 Register DESC0_3_PON_EGP_33 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_33 0x2BD30
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_33 0x190EBD30u

//! Register Reset Value
#define DESC0_3_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_33 Register DESC1_3_PON_EGP_33 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_33 0x2BD34
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_33 0x190EBD34u

//! Register Reset Value
#define DESC1_3_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_33 Register DESC2_3_PON_EGP_33 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_33 0x2BD38
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_33 0x190EBD38u

//! Register Reset Value
#define DESC2_3_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_33 Register DESC3_3_PON_EGP_33 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_33 0x2BD3C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_33 0x190EBD3Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_33_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_33_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_33_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_33 Register DESC0_4_PON_EGP_33 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_33 0x2BD40
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_33 0x190EBD40u

//! Register Reset Value
#define DESC0_4_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_33 Register DESC1_4_PON_EGP_33 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_33 0x2BD44
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_33 0x190EBD44u

//! Register Reset Value
#define DESC1_4_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_33 Register DESC2_4_PON_EGP_33 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_33 0x2BD48
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_33 0x190EBD48u

//! Register Reset Value
#define DESC2_4_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_33 Register DESC3_4_PON_EGP_33 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_33 0x2BD4C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_33 0x190EBD4Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_33_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_33_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_33_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_33 Register DESC0_5_PON_EGP_33 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_33 0x2BD50
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_33 0x190EBD50u

//! Register Reset Value
#define DESC0_5_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_33 Register DESC1_5_PON_EGP_33 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_33 0x2BD54
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_33 0x190EBD54u

//! Register Reset Value
#define DESC1_5_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_33 Register DESC2_5_PON_EGP_33 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_33 0x2BD58
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_33 0x190EBD58u

//! Register Reset Value
#define DESC2_5_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_33 Register DESC3_5_PON_EGP_33 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_33 0x2BD5C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_33 0x190EBD5Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_33_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_33_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_33_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_33 Register DESC0_6_PON_EGP_33 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_33 0x2BD60
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_33 0x190EBD60u

//! Register Reset Value
#define DESC0_6_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_33 Register DESC1_6_PON_EGP_33 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_33 0x2BD64
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_33 0x190EBD64u

//! Register Reset Value
#define DESC1_6_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_33 Register DESC2_6_PON_EGP_33 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_33 0x2BD68
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_33 0x190EBD68u

//! Register Reset Value
#define DESC2_6_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_33 Register DESC3_6_PON_EGP_33 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_33 0x2BD6C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_33 0x190EBD6Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_33_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_33_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_33_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_33 Register DESC0_7_PON_EGP_33 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_33 0x2BD70
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_33 0x190EBD70u

//! Register Reset Value
#define DESC0_7_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_33 Register DESC1_7_PON_EGP_33 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_33 0x2BD74
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_33 0x190EBD74u

//! Register Reset Value
#define DESC1_7_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_33 Register DESC2_7_PON_EGP_33 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_33 0x2BD78
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_33 0x190EBD78u

//! Register Reset Value
#define DESC2_7_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_33 Register DESC3_7_PON_EGP_33 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_33 0x2BD7C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_33 0x190EBD7Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_33_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_33_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_33_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_33_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_33_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_S_33 Register DESC0_0_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_S_33 0x2BE00
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_S_33 0x190EBE00u

//! Register Reset Value
#define DESC0_0_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_S_33 Register DESC1_0_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_S_33 0x2BE04
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_S_33 0x190EBE04u

//! Register Reset Value
#define DESC1_0_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_S_33 Register DESC2_0_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_S_33 0x2BE08
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_S_33 0x190EBE08u

//! Register Reset Value
#define DESC2_0_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_S_33 Register DESC3_0_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_S_33 0x2BE0C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_S_33 0x190EBE0Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_33_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_33_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_33_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_S_33 Register DESC0_1_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_S_33 0x2BE10
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_S_33 0x190EBE10u

//! Register Reset Value
#define DESC0_1_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_S_33 Register DESC1_1_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_S_33 0x2BE14
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_S_33 0x190EBE14u

//! Register Reset Value
#define DESC1_1_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_S_33 Register DESC2_1_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_S_33 0x2BE18
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_S_33 0x190EBE18u

//! Register Reset Value
#define DESC2_1_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_S_33 Register DESC3_1_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_S_33 0x2BE1C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_S_33 0x190EBE1Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_33_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_33_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_33_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_S_33 Register DESC0_2_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_S_33 0x2BE20
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_S_33 0x190EBE20u

//! Register Reset Value
#define DESC0_2_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_S_33 Register DESC1_2_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_S_33 0x2BE24
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_S_33 0x190EBE24u

//! Register Reset Value
#define DESC1_2_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_S_33 Register DESC2_2_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_S_33 0x2BE28
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_S_33 0x190EBE28u

//! Register Reset Value
#define DESC2_2_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_S_33 Register DESC3_2_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_S_33 0x2BE2C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_S_33 0x190EBE2Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_33_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_33_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_33_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_S_33 Register DESC0_3_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_S_33 0x2BE30
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_S_33 0x190EBE30u

//! Register Reset Value
#define DESC0_3_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_S_33 Register DESC1_3_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_S_33 0x2BE34
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_S_33 0x190EBE34u

//! Register Reset Value
#define DESC1_3_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_S_33 Register DESC2_3_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_S_33 0x2BE38
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_S_33 0x190EBE38u

//! Register Reset Value
#define DESC2_3_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_S_33 Register DESC3_3_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_S_33 0x2BE3C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_S_33 0x190EBE3Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_33_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_33_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_33_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_S_33 Register DESC0_4_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_S_33 0x2BE40
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_S_33 0x190EBE40u

//! Register Reset Value
#define DESC0_4_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_S_33 Register DESC1_4_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_S_33 0x2BE44
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_S_33 0x190EBE44u

//! Register Reset Value
#define DESC1_4_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_S_33 Register DESC2_4_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_S_33 0x2BE48
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_S_33 0x190EBE48u

//! Register Reset Value
#define DESC2_4_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_S_33 Register DESC3_4_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_S_33 0x2BE4C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_S_33 0x190EBE4Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_33_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_33_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_33_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_S_33 Register DESC0_5_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_S_33 0x2BE50
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_S_33 0x190EBE50u

//! Register Reset Value
#define DESC0_5_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_S_33 Register DESC1_5_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_S_33 0x2BE54
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_S_33 0x190EBE54u

//! Register Reset Value
#define DESC1_5_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_S_33 Register DESC2_5_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_S_33 0x2BE58
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_S_33 0x190EBE58u

//! Register Reset Value
#define DESC2_5_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_S_33 Register DESC3_5_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_S_33 0x2BE5C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_S_33 0x190EBE5Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_33_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_33_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_33_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_S_33 Register DESC0_6_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_S_33 0x2BE60
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_S_33 0x190EBE60u

//! Register Reset Value
#define DESC0_6_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_S_33 Register DESC1_6_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_S_33 0x2BE64
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_S_33 0x190EBE64u

//! Register Reset Value
#define DESC1_6_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_S_33 Register DESC2_6_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_S_33 0x2BE68
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_S_33 0x190EBE68u

//! Register Reset Value
#define DESC2_6_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_S_33 Register DESC3_6_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_S_33 0x2BE6C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_S_33 0x190EBE6Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_33_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_33_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_33_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_S_33 Register DESC0_7_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_S_33 0x2BE70
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_S_33 0x190EBE70u

//! Register Reset Value
#define DESC0_7_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_S_33 Register DESC1_7_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_S_33 0x2BE74
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_S_33 0x190EBE74u

//! Register Reset Value
#define DESC1_7_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_S_33 Register DESC2_7_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_S_33 0x2BE78
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_S_33 0x190EBE78u

//! Register Reset Value
#define DESC2_7_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_33_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_S_33 Register DESC3_7_PON_EGP_S_33 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_S_33 0x2BE7C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_S_33 0x190EBE7Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_S_33_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_33_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_33_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_33_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_33_OWN_MASK 0x80000000u

//! @}

//! \defgroup CFG_PON_EGP_34 Register CFG_PON_EGP_34 - PON Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_PON_EGP_34 0x2C000
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_PON_EGP_34 0x190EC000u

//! Register Reset Value
#define CFG_PON_EGP_34_RST 0x00000000u

//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_34_DQREQ_POS 0
//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_34_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_34_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_34_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_34_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_34_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_34_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_34_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_34_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_34_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup IRNCR_PON_EGP_34 Register IRNCR_PON_EGP_34 - PON Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_PON_EGP_34 0x2C020
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_PON_EGP_34 0x190EC020u

//! Register Reset Value
#define IRNCR_PON_EGP_34_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_34_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_34_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_PON_EGP_34_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_PON_EGP_34_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_PON_EGP_34 Register IRNICR_PON_EGP_34 - PON Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_PON_EGP_34 0x2C024
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_PON_EGP_34 0x190EC024u

//! Register Reset Value
#define IRNICR_PON_EGP_34_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_34_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_34_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_PON_EGP_34 Register IRNEN_PON_EGP_34 - PON Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_PON_EGP_34 0x2C028
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_PON_EGP_34 0x190EC028u

//! Register Reset Value
#define IRNEN_PON_EGP_34_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_34_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_34_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_PON_EGP_34_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_PON_EGP_34_DR_EN 0x1

//! @}

//! \defgroup DPTR_PON_EGP_34 Register DPTR_PON_EGP_34 - PON Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_PON_EGP_34 0x2C030
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_PON_EGP_34 0x190EC030u

//! Register Reset Value
#define DPTR_PON_EGP_34_RST 0x00000707u

//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_34_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_34_ND_MASK 0x7u

//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_34_NSD_POS 8
//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_34_NSD_MASK 0x700u

//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_34_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_34_DPTR_MASK 0x70000u

//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_34_SDPTR_POS 24
//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_34_SDPTR_MASK 0x7000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_34 Register DESC0_0_PON_EGP_34 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_34 0x2C100
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_34 0x190EC100u

//! Register Reset Value
#define DESC0_0_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_34 Register DESC1_0_PON_EGP_34 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_34 0x2C104
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_34 0x190EC104u

//! Register Reset Value
#define DESC1_0_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_34 Register DESC2_0_PON_EGP_34 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_34 0x2C108
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_34 0x190EC108u

//! Register Reset Value
#define DESC2_0_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_34 Register DESC3_0_PON_EGP_34 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_34 0x2C10C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_34 0x190EC10Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_34_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_34_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_34_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_34 Register DESC0_1_PON_EGP_34 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_34 0x2C110
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_34 0x190EC110u

//! Register Reset Value
#define DESC0_1_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_34 Register DESC1_1_PON_EGP_34 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_34 0x2C114
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_34 0x190EC114u

//! Register Reset Value
#define DESC1_1_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_34 Register DESC2_1_PON_EGP_34 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_34 0x2C118
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_34 0x190EC118u

//! Register Reset Value
#define DESC2_1_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_34 Register DESC3_1_PON_EGP_34 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_34 0x2C11C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_34 0x190EC11Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_34_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_34_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_34_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_34 Register DESC0_2_PON_EGP_34 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_34 0x2C120
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_34 0x190EC120u

//! Register Reset Value
#define DESC0_2_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_34 Register DESC1_2_PON_EGP_34 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_34 0x2C124
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_34 0x190EC124u

//! Register Reset Value
#define DESC1_2_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_34 Register DESC2_2_PON_EGP_34 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_34 0x2C128
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_34 0x190EC128u

//! Register Reset Value
#define DESC2_2_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_34 Register DESC3_2_PON_EGP_34 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_34 0x2C12C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_34 0x190EC12Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_34_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_34_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_34_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_34 Register DESC0_3_PON_EGP_34 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_34 0x2C130
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_34 0x190EC130u

//! Register Reset Value
#define DESC0_3_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_34 Register DESC1_3_PON_EGP_34 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_34 0x2C134
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_34 0x190EC134u

//! Register Reset Value
#define DESC1_3_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_34 Register DESC2_3_PON_EGP_34 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_34 0x2C138
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_34 0x190EC138u

//! Register Reset Value
#define DESC2_3_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_34 Register DESC3_3_PON_EGP_34 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_34 0x2C13C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_34 0x190EC13Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_34_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_34_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_34_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_34 Register DESC0_4_PON_EGP_34 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_34 0x2C140
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_34 0x190EC140u

//! Register Reset Value
#define DESC0_4_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_34 Register DESC1_4_PON_EGP_34 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_34 0x2C144
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_34 0x190EC144u

//! Register Reset Value
#define DESC1_4_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_34 Register DESC2_4_PON_EGP_34 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_34 0x2C148
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_34 0x190EC148u

//! Register Reset Value
#define DESC2_4_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_34 Register DESC3_4_PON_EGP_34 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_34 0x2C14C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_34 0x190EC14Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_34_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_34_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_34_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_34 Register DESC0_5_PON_EGP_34 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_34 0x2C150
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_34 0x190EC150u

//! Register Reset Value
#define DESC0_5_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_34 Register DESC1_5_PON_EGP_34 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_34 0x2C154
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_34 0x190EC154u

//! Register Reset Value
#define DESC1_5_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_34 Register DESC2_5_PON_EGP_34 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_34 0x2C158
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_34 0x190EC158u

//! Register Reset Value
#define DESC2_5_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_34 Register DESC3_5_PON_EGP_34 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_34 0x2C15C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_34 0x190EC15Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_34_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_34_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_34_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_34 Register DESC0_6_PON_EGP_34 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_34 0x2C160
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_34 0x190EC160u

//! Register Reset Value
#define DESC0_6_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_34 Register DESC1_6_PON_EGP_34 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_34 0x2C164
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_34 0x190EC164u

//! Register Reset Value
#define DESC1_6_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_34 Register DESC2_6_PON_EGP_34 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_34 0x2C168
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_34 0x190EC168u

//! Register Reset Value
#define DESC2_6_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_34 Register DESC3_6_PON_EGP_34 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_34 0x2C16C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_34 0x190EC16Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_34_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_34_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_34_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_34 Register DESC0_7_PON_EGP_34 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_34 0x2C170
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_34 0x190EC170u

//! Register Reset Value
#define DESC0_7_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_34 Register DESC1_7_PON_EGP_34 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_34 0x2C174
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_34 0x190EC174u

//! Register Reset Value
#define DESC1_7_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_34 Register DESC2_7_PON_EGP_34 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_34 0x2C178
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_34 0x190EC178u

//! Register Reset Value
#define DESC2_7_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_34 Register DESC3_7_PON_EGP_34 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_34 0x2C17C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_34 0x190EC17Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_34_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_34_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_34_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_34_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_34_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_S_34 Register DESC0_0_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_S_34 0x2C200
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_S_34 0x190EC200u

//! Register Reset Value
#define DESC0_0_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_S_34 Register DESC1_0_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_S_34 0x2C204
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_S_34 0x190EC204u

//! Register Reset Value
#define DESC1_0_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_S_34 Register DESC2_0_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_S_34 0x2C208
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_S_34 0x190EC208u

//! Register Reset Value
#define DESC2_0_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_S_34 Register DESC3_0_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_S_34 0x2C20C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_S_34 0x190EC20Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_34_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_34_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_34_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_S_34 Register DESC0_1_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_S_34 0x2C210
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_S_34 0x190EC210u

//! Register Reset Value
#define DESC0_1_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_S_34 Register DESC1_1_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_S_34 0x2C214
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_S_34 0x190EC214u

//! Register Reset Value
#define DESC1_1_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_S_34 Register DESC2_1_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_S_34 0x2C218
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_S_34 0x190EC218u

//! Register Reset Value
#define DESC2_1_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_S_34 Register DESC3_1_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_S_34 0x2C21C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_S_34 0x190EC21Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_34_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_34_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_34_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_S_34 Register DESC0_2_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_S_34 0x2C220
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_S_34 0x190EC220u

//! Register Reset Value
#define DESC0_2_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_S_34 Register DESC1_2_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_S_34 0x2C224
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_S_34 0x190EC224u

//! Register Reset Value
#define DESC1_2_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_S_34 Register DESC2_2_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_S_34 0x2C228
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_S_34 0x190EC228u

//! Register Reset Value
#define DESC2_2_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_S_34 Register DESC3_2_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_S_34 0x2C22C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_S_34 0x190EC22Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_34_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_34_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_34_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_S_34 Register DESC0_3_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_S_34 0x2C230
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_S_34 0x190EC230u

//! Register Reset Value
#define DESC0_3_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_S_34 Register DESC1_3_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_S_34 0x2C234
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_S_34 0x190EC234u

//! Register Reset Value
#define DESC1_3_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_S_34 Register DESC2_3_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_S_34 0x2C238
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_S_34 0x190EC238u

//! Register Reset Value
#define DESC2_3_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_S_34 Register DESC3_3_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_S_34 0x2C23C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_S_34 0x190EC23Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_34_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_34_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_34_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_S_34 Register DESC0_4_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_S_34 0x2C240
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_S_34 0x190EC240u

//! Register Reset Value
#define DESC0_4_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_S_34 Register DESC1_4_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_S_34 0x2C244
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_S_34 0x190EC244u

//! Register Reset Value
#define DESC1_4_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_S_34 Register DESC2_4_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_S_34 0x2C248
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_S_34 0x190EC248u

//! Register Reset Value
#define DESC2_4_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_S_34 Register DESC3_4_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_S_34 0x2C24C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_S_34 0x190EC24Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_34_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_34_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_34_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_S_34 Register DESC0_5_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_S_34 0x2C250
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_S_34 0x190EC250u

//! Register Reset Value
#define DESC0_5_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_S_34 Register DESC1_5_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_S_34 0x2C254
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_S_34 0x190EC254u

//! Register Reset Value
#define DESC1_5_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_S_34 Register DESC2_5_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_S_34 0x2C258
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_S_34 0x190EC258u

//! Register Reset Value
#define DESC2_5_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_S_34 Register DESC3_5_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_S_34 0x2C25C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_S_34 0x190EC25Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_34_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_34_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_34_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_S_34 Register DESC0_6_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_S_34 0x2C260
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_S_34 0x190EC260u

//! Register Reset Value
#define DESC0_6_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_S_34 Register DESC1_6_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_S_34 0x2C264
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_S_34 0x190EC264u

//! Register Reset Value
#define DESC1_6_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_S_34 Register DESC2_6_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_S_34 0x2C268
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_S_34 0x190EC268u

//! Register Reset Value
#define DESC2_6_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_S_34 Register DESC3_6_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_S_34 0x2C26C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_S_34 0x190EC26Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_34_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_34_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_34_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_S_34 Register DESC0_7_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_S_34 0x2C270
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_S_34 0x190EC270u

//! Register Reset Value
#define DESC0_7_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_S_34 Register DESC1_7_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_S_34 0x2C274
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_S_34 0x190EC274u

//! Register Reset Value
#define DESC1_7_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_S_34 Register DESC2_7_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_S_34 0x2C278
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_S_34 0x190EC278u

//! Register Reset Value
#define DESC2_7_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_34_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_S_34 Register DESC3_7_PON_EGP_S_34 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_S_34 0x2C27C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_S_34 0x190EC27Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_S_34_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_34_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_34_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_34_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_34_OWN_MASK 0x80000000u

//! @}

//! \defgroup CFG_PON_EGP_35 Register CFG_PON_EGP_35 - PON Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_PON_EGP_35 0x2C400
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_PON_EGP_35 0x190EC400u

//! Register Reset Value
#define CFG_PON_EGP_35_RST 0x00000000u

//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_35_DQREQ_POS 0
//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_35_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_35_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_35_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_35_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_35_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_35_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_35_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_35_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_35_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup IRNCR_PON_EGP_35 Register IRNCR_PON_EGP_35 - PON Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_PON_EGP_35 0x2C420
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_PON_EGP_35 0x190EC420u

//! Register Reset Value
#define IRNCR_PON_EGP_35_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_35_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_35_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_PON_EGP_35_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_PON_EGP_35_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_PON_EGP_35 Register IRNICR_PON_EGP_35 - PON Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_PON_EGP_35 0x2C424
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_PON_EGP_35 0x190EC424u

//! Register Reset Value
#define IRNICR_PON_EGP_35_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_35_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_35_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_PON_EGP_35 Register IRNEN_PON_EGP_35 - PON Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_PON_EGP_35 0x2C428
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_PON_EGP_35 0x190EC428u

//! Register Reset Value
#define IRNEN_PON_EGP_35_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_35_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_35_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_PON_EGP_35_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_PON_EGP_35_DR_EN 0x1

//! @}

//! \defgroup DPTR_PON_EGP_35 Register DPTR_PON_EGP_35 - PON Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_PON_EGP_35 0x2C430
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_PON_EGP_35 0x190EC430u

//! Register Reset Value
#define DPTR_PON_EGP_35_RST 0x00000707u

//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_35_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_35_ND_MASK 0x7u

//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_35_NSD_POS 8
//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_35_NSD_MASK 0x700u

//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_35_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_35_DPTR_MASK 0x70000u

//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_35_SDPTR_POS 24
//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_35_SDPTR_MASK 0x7000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_35 Register DESC0_0_PON_EGP_35 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_35 0x2C500
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_35 0x190EC500u

//! Register Reset Value
#define DESC0_0_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_35 Register DESC1_0_PON_EGP_35 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_35 0x2C504
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_35 0x190EC504u

//! Register Reset Value
#define DESC1_0_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_35 Register DESC2_0_PON_EGP_35 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_35 0x2C508
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_35 0x190EC508u

//! Register Reset Value
#define DESC2_0_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_35 Register DESC3_0_PON_EGP_35 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_35 0x2C50C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_35 0x190EC50Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_35_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_35_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_35_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_35 Register DESC0_1_PON_EGP_35 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_35 0x2C510
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_35 0x190EC510u

//! Register Reset Value
#define DESC0_1_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_35 Register DESC1_1_PON_EGP_35 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_35 0x2C514
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_35 0x190EC514u

//! Register Reset Value
#define DESC1_1_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_35 Register DESC2_1_PON_EGP_35 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_35 0x2C518
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_35 0x190EC518u

//! Register Reset Value
#define DESC2_1_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_35 Register DESC3_1_PON_EGP_35 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_35 0x2C51C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_35 0x190EC51Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_35_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_35_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_35_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_35 Register DESC0_2_PON_EGP_35 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_35 0x2C520
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_35 0x190EC520u

//! Register Reset Value
#define DESC0_2_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_35 Register DESC1_2_PON_EGP_35 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_35 0x2C524
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_35 0x190EC524u

//! Register Reset Value
#define DESC1_2_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_35 Register DESC2_2_PON_EGP_35 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_35 0x2C528
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_35 0x190EC528u

//! Register Reset Value
#define DESC2_2_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_35 Register DESC3_2_PON_EGP_35 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_35 0x2C52C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_35 0x190EC52Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_35_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_35_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_35_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_35 Register DESC0_3_PON_EGP_35 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_35 0x2C530
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_35 0x190EC530u

//! Register Reset Value
#define DESC0_3_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_35 Register DESC1_3_PON_EGP_35 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_35 0x2C534
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_35 0x190EC534u

//! Register Reset Value
#define DESC1_3_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_35 Register DESC2_3_PON_EGP_35 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_35 0x2C538
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_35 0x190EC538u

//! Register Reset Value
#define DESC2_3_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_35 Register DESC3_3_PON_EGP_35 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_35 0x2C53C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_35 0x190EC53Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_35_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_35_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_35_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_35 Register DESC0_4_PON_EGP_35 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_35 0x2C540
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_35 0x190EC540u

//! Register Reset Value
#define DESC0_4_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_35 Register DESC1_4_PON_EGP_35 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_35 0x2C544
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_35 0x190EC544u

//! Register Reset Value
#define DESC1_4_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_35 Register DESC2_4_PON_EGP_35 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_35 0x2C548
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_35 0x190EC548u

//! Register Reset Value
#define DESC2_4_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_35 Register DESC3_4_PON_EGP_35 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_35 0x2C54C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_35 0x190EC54Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_35_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_35_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_35_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_35 Register DESC0_5_PON_EGP_35 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_35 0x2C550
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_35 0x190EC550u

//! Register Reset Value
#define DESC0_5_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_35 Register DESC1_5_PON_EGP_35 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_35 0x2C554
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_35 0x190EC554u

//! Register Reset Value
#define DESC1_5_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_35 Register DESC2_5_PON_EGP_35 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_35 0x2C558
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_35 0x190EC558u

//! Register Reset Value
#define DESC2_5_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_35 Register DESC3_5_PON_EGP_35 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_35 0x2C55C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_35 0x190EC55Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_35_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_35_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_35_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_35 Register DESC0_6_PON_EGP_35 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_35 0x2C560
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_35 0x190EC560u

//! Register Reset Value
#define DESC0_6_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_35 Register DESC1_6_PON_EGP_35 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_35 0x2C564
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_35 0x190EC564u

//! Register Reset Value
#define DESC1_6_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_35 Register DESC2_6_PON_EGP_35 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_35 0x2C568
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_35 0x190EC568u

//! Register Reset Value
#define DESC2_6_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_35 Register DESC3_6_PON_EGP_35 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_35 0x2C56C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_35 0x190EC56Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_35_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_35_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_35_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_35 Register DESC0_7_PON_EGP_35 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_35 0x2C570
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_35 0x190EC570u

//! Register Reset Value
#define DESC0_7_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_35 Register DESC1_7_PON_EGP_35 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_35 0x2C574
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_35 0x190EC574u

//! Register Reset Value
#define DESC1_7_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_35 Register DESC2_7_PON_EGP_35 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_35 0x2C578
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_35 0x190EC578u

//! Register Reset Value
#define DESC2_7_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_35 Register DESC3_7_PON_EGP_35 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_35 0x2C57C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_35 0x190EC57Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_35_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_35_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_35_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_35_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_35_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_S_35 Register DESC0_0_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_S_35 0x2C600
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_S_35 0x190EC600u

//! Register Reset Value
#define DESC0_0_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_S_35 Register DESC1_0_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_S_35 0x2C604
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_S_35 0x190EC604u

//! Register Reset Value
#define DESC1_0_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_S_35 Register DESC2_0_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_S_35 0x2C608
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_S_35 0x190EC608u

//! Register Reset Value
#define DESC2_0_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_S_35 Register DESC3_0_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_S_35 0x2C60C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_S_35 0x190EC60Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_35_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_35_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_35_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_S_35 Register DESC0_1_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_S_35 0x2C610
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_S_35 0x190EC610u

//! Register Reset Value
#define DESC0_1_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_S_35 Register DESC1_1_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_S_35 0x2C614
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_S_35 0x190EC614u

//! Register Reset Value
#define DESC1_1_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_S_35 Register DESC2_1_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_S_35 0x2C618
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_S_35 0x190EC618u

//! Register Reset Value
#define DESC2_1_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_S_35 Register DESC3_1_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_S_35 0x2C61C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_S_35 0x190EC61Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_35_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_35_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_35_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_S_35 Register DESC0_2_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_S_35 0x2C620
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_S_35 0x190EC620u

//! Register Reset Value
#define DESC0_2_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_S_35 Register DESC1_2_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_S_35 0x2C624
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_S_35 0x190EC624u

//! Register Reset Value
#define DESC1_2_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_S_35 Register DESC2_2_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_S_35 0x2C628
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_S_35 0x190EC628u

//! Register Reset Value
#define DESC2_2_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_S_35 Register DESC3_2_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_S_35 0x2C62C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_S_35 0x190EC62Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_35_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_35_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_35_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_S_35 Register DESC0_3_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_S_35 0x2C630
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_S_35 0x190EC630u

//! Register Reset Value
#define DESC0_3_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_S_35 Register DESC1_3_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_S_35 0x2C634
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_S_35 0x190EC634u

//! Register Reset Value
#define DESC1_3_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_S_35 Register DESC2_3_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_S_35 0x2C638
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_S_35 0x190EC638u

//! Register Reset Value
#define DESC2_3_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_S_35 Register DESC3_3_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_S_35 0x2C63C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_S_35 0x190EC63Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_35_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_35_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_35_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_S_35 Register DESC0_4_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_S_35 0x2C640
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_S_35 0x190EC640u

//! Register Reset Value
#define DESC0_4_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_S_35 Register DESC1_4_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_S_35 0x2C644
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_S_35 0x190EC644u

//! Register Reset Value
#define DESC1_4_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_S_35 Register DESC2_4_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_S_35 0x2C648
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_S_35 0x190EC648u

//! Register Reset Value
#define DESC2_4_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_S_35 Register DESC3_4_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_S_35 0x2C64C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_S_35 0x190EC64Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_35_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_35_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_35_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_S_35 Register DESC0_5_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_S_35 0x2C650
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_S_35 0x190EC650u

//! Register Reset Value
#define DESC0_5_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_S_35 Register DESC1_5_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_S_35 0x2C654
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_S_35 0x190EC654u

//! Register Reset Value
#define DESC1_5_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_S_35 Register DESC2_5_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_S_35 0x2C658
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_S_35 0x190EC658u

//! Register Reset Value
#define DESC2_5_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_S_35 Register DESC3_5_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_S_35 0x2C65C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_S_35 0x190EC65Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_35_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_35_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_35_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_S_35 Register DESC0_6_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_S_35 0x2C660
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_S_35 0x190EC660u

//! Register Reset Value
#define DESC0_6_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_S_35 Register DESC1_6_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_S_35 0x2C664
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_S_35 0x190EC664u

//! Register Reset Value
#define DESC1_6_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_S_35 Register DESC2_6_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_S_35 0x2C668
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_S_35 0x190EC668u

//! Register Reset Value
#define DESC2_6_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_S_35 Register DESC3_6_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_S_35 0x2C66C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_S_35 0x190EC66Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_35_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_35_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_35_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_S_35 Register DESC0_7_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_S_35 0x2C670
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_S_35 0x190EC670u

//! Register Reset Value
#define DESC0_7_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_S_35 Register DESC1_7_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_S_35 0x2C674
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_S_35 0x190EC674u

//! Register Reset Value
#define DESC1_7_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_S_35 Register DESC2_7_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_S_35 0x2C678
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_S_35 0x190EC678u

//! Register Reset Value
#define DESC2_7_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_35_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_S_35 Register DESC3_7_PON_EGP_S_35 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_S_35 0x2C67C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_S_35 0x190EC67Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_S_35_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_35_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_35_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_35_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_35_OWN_MASK 0x80000000u

//! @}

//! \defgroup CFG_PON_EGP_36 Register CFG_PON_EGP_36 - PON Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_PON_EGP_36 0x2C800
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_PON_EGP_36 0x190EC800u

//! Register Reset Value
#define CFG_PON_EGP_36_RST 0x00000000u

//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_36_DQREQ_POS 0
//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_36_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_36_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_36_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_36_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_36_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_36_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_36_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_36_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_36_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup IRNCR_PON_EGP_36 Register IRNCR_PON_EGP_36 - PON Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_PON_EGP_36 0x2C820
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_PON_EGP_36 0x190EC820u

//! Register Reset Value
#define IRNCR_PON_EGP_36_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_36_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_36_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_PON_EGP_36_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_PON_EGP_36_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_PON_EGP_36 Register IRNICR_PON_EGP_36 - PON Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_PON_EGP_36 0x2C824
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_PON_EGP_36 0x190EC824u

//! Register Reset Value
#define IRNICR_PON_EGP_36_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_36_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_36_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_PON_EGP_36 Register IRNEN_PON_EGP_36 - PON Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_PON_EGP_36 0x2C828
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_PON_EGP_36 0x190EC828u

//! Register Reset Value
#define IRNEN_PON_EGP_36_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_36_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_36_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_PON_EGP_36_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_PON_EGP_36_DR_EN 0x1

//! @}

//! \defgroup DPTR_PON_EGP_36 Register DPTR_PON_EGP_36 - PON Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_PON_EGP_36 0x2C830
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_PON_EGP_36 0x190EC830u

//! Register Reset Value
#define DPTR_PON_EGP_36_RST 0x00000707u

//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_36_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_36_ND_MASK 0x7u

//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_36_NSD_POS 8
//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_36_NSD_MASK 0x700u

//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_36_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_36_DPTR_MASK 0x70000u

//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_36_SDPTR_POS 24
//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_36_SDPTR_MASK 0x7000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_36 Register DESC0_0_PON_EGP_36 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_36 0x2C900
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_36 0x190EC900u

//! Register Reset Value
#define DESC0_0_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_36 Register DESC1_0_PON_EGP_36 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_36 0x2C904
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_36 0x190EC904u

//! Register Reset Value
#define DESC1_0_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_36 Register DESC2_0_PON_EGP_36 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_36 0x2C908
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_36 0x190EC908u

//! Register Reset Value
#define DESC2_0_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_36 Register DESC3_0_PON_EGP_36 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_36 0x2C90C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_36 0x190EC90Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_36_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_36_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_36_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_36 Register DESC0_1_PON_EGP_36 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_36 0x2C910
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_36 0x190EC910u

//! Register Reset Value
#define DESC0_1_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_36 Register DESC1_1_PON_EGP_36 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_36 0x2C914
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_36 0x190EC914u

//! Register Reset Value
#define DESC1_1_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_36 Register DESC2_1_PON_EGP_36 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_36 0x2C918
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_36 0x190EC918u

//! Register Reset Value
#define DESC2_1_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_36 Register DESC3_1_PON_EGP_36 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_36 0x2C91C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_36 0x190EC91Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_36_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_36_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_36_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_36 Register DESC0_2_PON_EGP_36 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_36 0x2C920
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_36 0x190EC920u

//! Register Reset Value
#define DESC0_2_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_36 Register DESC1_2_PON_EGP_36 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_36 0x2C924
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_36 0x190EC924u

//! Register Reset Value
#define DESC1_2_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_36 Register DESC2_2_PON_EGP_36 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_36 0x2C928
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_36 0x190EC928u

//! Register Reset Value
#define DESC2_2_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_36 Register DESC3_2_PON_EGP_36 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_36 0x2C92C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_36 0x190EC92Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_36_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_36_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_36_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_36 Register DESC0_3_PON_EGP_36 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_36 0x2C930
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_36 0x190EC930u

//! Register Reset Value
#define DESC0_3_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_36 Register DESC1_3_PON_EGP_36 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_36 0x2C934
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_36 0x190EC934u

//! Register Reset Value
#define DESC1_3_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_36 Register DESC2_3_PON_EGP_36 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_36 0x2C938
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_36 0x190EC938u

//! Register Reset Value
#define DESC2_3_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_36 Register DESC3_3_PON_EGP_36 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_36 0x2C93C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_36 0x190EC93Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_36_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_36_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_36_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_36 Register DESC0_4_PON_EGP_36 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_36 0x2C940
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_36 0x190EC940u

//! Register Reset Value
#define DESC0_4_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_36 Register DESC1_4_PON_EGP_36 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_36 0x2C944
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_36 0x190EC944u

//! Register Reset Value
#define DESC1_4_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_36 Register DESC2_4_PON_EGP_36 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_36 0x2C948
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_36 0x190EC948u

//! Register Reset Value
#define DESC2_4_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_36 Register DESC3_4_PON_EGP_36 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_36 0x2C94C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_36 0x190EC94Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_36_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_36_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_36_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_36 Register DESC0_5_PON_EGP_36 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_36 0x2C950
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_36 0x190EC950u

//! Register Reset Value
#define DESC0_5_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_36 Register DESC1_5_PON_EGP_36 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_36 0x2C954
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_36 0x190EC954u

//! Register Reset Value
#define DESC1_5_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_36 Register DESC2_5_PON_EGP_36 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_36 0x2C958
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_36 0x190EC958u

//! Register Reset Value
#define DESC2_5_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_36 Register DESC3_5_PON_EGP_36 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_36 0x2C95C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_36 0x190EC95Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_36_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_36_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_36_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_36 Register DESC0_6_PON_EGP_36 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_36 0x2C960
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_36 0x190EC960u

//! Register Reset Value
#define DESC0_6_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_36 Register DESC1_6_PON_EGP_36 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_36 0x2C964
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_36 0x190EC964u

//! Register Reset Value
#define DESC1_6_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_36 Register DESC2_6_PON_EGP_36 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_36 0x2C968
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_36 0x190EC968u

//! Register Reset Value
#define DESC2_6_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_36 Register DESC3_6_PON_EGP_36 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_36 0x2C96C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_36 0x190EC96Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_36_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_36_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_36_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_36 Register DESC0_7_PON_EGP_36 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_36 0x2C970
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_36 0x190EC970u

//! Register Reset Value
#define DESC0_7_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_36 Register DESC1_7_PON_EGP_36 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_36 0x2C974
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_36 0x190EC974u

//! Register Reset Value
#define DESC1_7_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_36 Register DESC2_7_PON_EGP_36 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_36 0x2C978
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_36 0x190EC978u

//! Register Reset Value
#define DESC2_7_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_36 Register DESC3_7_PON_EGP_36 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_36 0x2C97C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_36 0x190EC97Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_36_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_36_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_36_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_36_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_36_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_S_36 Register DESC0_0_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_S_36 0x2CA00
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_S_36 0x190ECA00u

//! Register Reset Value
#define DESC0_0_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_S_36 Register DESC1_0_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_S_36 0x2CA04
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_S_36 0x190ECA04u

//! Register Reset Value
#define DESC1_0_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_S_36 Register DESC2_0_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_S_36 0x2CA08
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_S_36 0x190ECA08u

//! Register Reset Value
#define DESC2_0_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_S_36 Register DESC3_0_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_S_36 0x2CA0C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_S_36 0x190ECA0Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_36_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_36_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_36_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_S_36 Register DESC0_1_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_S_36 0x2CA10
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_S_36 0x190ECA10u

//! Register Reset Value
#define DESC0_1_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_S_36 Register DESC1_1_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_S_36 0x2CA14
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_S_36 0x190ECA14u

//! Register Reset Value
#define DESC1_1_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_S_36 Register DESC2_1_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_S_36 0x2CA18
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_S_36 0x190ECA18u

//! Register Reset Value
#define DESC2_1_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_S_36 Register DESC3_1_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_S_36 0x2CA1C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_S_36 0x190ECA1Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_36_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_36_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_36_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_S_36 Register DESC0_2_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_S_36 0x2CA20
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_S_36 0x190ECA20u

//! Register Reset Value
#define DESC0_2_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_S_36 Register DESC1_2_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_S_36 0x2CA24
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_S_36 0x190ECA24u

//! Register Reset Value
#define DESC1_2_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_S_36 Register DESC2_2_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_S_36 0x2CA28
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_S_36 0x190ECA28u

//! Register Reset Value
#define DESC2_2_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_S_36 Register DESC3_2_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_S_36 0x2CA2C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_S_36 0x190ECA2Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_36_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_36_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_36_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_S_36 Register DESC0_3_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_S_36 0x2CA30
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_S_36 0x190ECA30u

//! Register Reset Value
#define DESC0_3_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_S_36 Register DESC1_3_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_S_36 0x2CA34
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_S_36 0x190ECA34u

//! Register Reset Value
#define DESC1_3_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_S_36 Register DESC2_3_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_S_36 0x2CA38
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_S_36 0x190ECA38u

//! Register Reset Value
#define DESC2_3_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_S_36 Register DESC3_3_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_S_36 0x2CA3C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_S_36 0x190ECA3Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_36_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_36_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_36_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_S_36 Register DESC0_4_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_S_36 0x2CA40
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_S_36 0x190ECA40u

//! Register Reset Value
#define DESC0_4_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_S_36 Register DESC1_4_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_S_36 0x2CA44
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_S_36 0x190ECA44u

//! Register Reset Value
#define DESC1_4_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_S_36 Register DESC2_4_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_S_36 0x2CA48
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_S_36 0x190ECA48u

//! Register Reset Value
#define DESC2_4_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_S_36 Register DESC3_4_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_S_36 0x2CA4C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_S_36 0x190ECA4Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_36_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_36_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_36_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_S_36 Register DESC0_5_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_S_36 0x2CA50
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_S_36 0x190ECA50u

//! Register Reset Value
#define DESC0_5_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_S_36 Register DESC1_5_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_S_36 0x2CA54
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_S_36 0x190ECA54u

//! Register Reset Value
#define DESC1_5_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_S_36 Register DESC2_5_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_S_36 0x2CA58
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_S_36 0x190ECA58u

//! Register Reset Value
#define DESC2_5_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_5_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_S_36 Register DESC3_5_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_S_36 0x2CA5C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_S_36 0x190ECA5Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_5_PON_EGP_S_36_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_36_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_5_PON_EGP_S_36_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_S_36 Register DESC0_6_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_S_36 0x2CA60
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_S_36 0x190ECA60u

//! Register Reset Value
#define DESC0_6_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_6_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_S_36 Register DESC1_6_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_S_36 0x2CA64
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_S_36 0x190ECA64u

//! Register Reset Value
#define DESC1_6_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_6_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_S_36 Register DESC2_6_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_S_36 0x2CA68
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_S_36 0x190ECA68u

//! Register Reset Value
#define DESC2_6_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_6_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_S_36 Register DESC3_6_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_S_36 0x2CA6C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_S_36 0x190ECA6Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_6_PON_EGP_S_36_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_36_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_6_PON_EGP_S_36_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_S_36 Register DESC0_7_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_S_36 0x2CA70
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_S_36 0x190ECA70u

//! Register Reset Value
#define DESC0_7_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_7_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_S_36 Register DESC1_7_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_S_36 0x2CA74
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_S_36 0x190ECA74u

//! Register Reset Value
#define DESC1_7_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_7_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_S_36 Register DESC2_7_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_S_36 0x2CA78
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_S_36 0x190ECA78u

//! Register Reset Value
#define DESC2_7_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_7_PON_EGP_S_36_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_S_36 Register DESC3_7_PON_EGP_S_36 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_S_36 0x2CA7C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_S_36 0x190ECA7Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_S_36_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_36_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_7_PON_EGP_S_36_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_36_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_7_PON_EGP_S_36_OWN_MASK 0x80000000u

//! @}

//! \defgroup CFG_PON_EGP_37 Register CFG_PON_EGP_37 - PON Egress Port Configuration
//! @{

//! Register Offset (relative)
#define CFG_PON_EGP_37 0x2CC00
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_CFG_PON_EGP_37 0x190ECC00u

//! Register Reset Value
#define CFG_PON_EGP_37_RST 0x00000000u

//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_37_DQREQ_POS 0
//! Field DQREQ - Enable PON Dequeue Request
#define CFG_PON_EGP_37_DQREQ_MASK 0x1u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_37_DQREQ_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_37_DQREQ_EN 0x1

//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_37_DQPCEN_POS 8
//! Field DQPCEN - Dequeue Counter Enable
#define CFG_PON_EGP_37_DQPCEN_MASK 0x100u
//! Constant DIS - DIS
#define CONST_CFG_PON_EGP_37_DQPCEN_DIS 0x0
//! Constant EN - EN
#define CONST_CFG_PON_EGP_37_DQPCEN_EN 0x1

//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_37_EPMAP_POS 16
//! Field EPMAP - Egress port mapping
#define CFG_PON_EGP_37_EPMAP_MASK 0x7F0000u

//! @}

//! \defgroup IRNCR_PON_EGP_37 Register IRNCR_PON_EGP_37 - PON Egress Port IRN Capture Register
//! @{

//! Register Offset (relative)
#define IRNCR_PON_EGP_37 0x2CC20
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNCR_PON_EGP_37 0x190ECC20u

//! Register Reset Value
#define IRNCR_PON_EGP_37_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_37_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNCR_PON_EGP_37_DR_MASK 0x2u
//! Constant NUL - NULL
#define CONST_IRNCR_PON_EGP_37_DR_NUL 0x0
//! Constant INTOCC - INTOCC
#define CONST_IRNCR_PON_EGP_37_DR_INTOCC 0x1

//! @}

//! \defgroup IRNICR_PON_EGP_37 Register IRNICR_PON_EGP_37 - PON Egress Port IRN Interrupt Control Register
//! @{

//! Register Offset (relative)
#define IRNICR_PON_EGP_37 0x2CC24
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNICR_PON_EGP_37 0x190ECC24u

//! Register Reset Value
#define IRNICR_PON_EGP_37_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_37_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNICR_PON_EGP_37_DR_MASK 0x2u

//! @}

//! \defgroup IRNEN_PON_EGP_37 Register IRNEN_PON_EGP_37 - PON Egress Port IRN Interrupt Enable Register
//! @{

//! Register Offset (relative)
#define IRNEN_PON_EGP_37 0x2CC28
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_IRNEN_PON_EGP_37 0x190ECC28u

//! Register Reset Value
#define IRNEN_PON_EGP_37_RST 0x00000000u

//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_37_DR_POS 1
//! Field DR - Descriptor Ready
#define IRNEN_PON_EGP_37_DR_MASK 0x2u
//! Constant DIS - DIS
#define CONST_IRNEN_PON_EGP_37_DR_DIS 0x0
//! Constant EN - EN
#define CONST_IRNEN_PON_EGP_37_DR_EN 0x1

//! @}

//! \defgroup DPTR_PON_EGP_37 Register DPTR_PON_EGP_37 - PON Egress Port Descriptor Pointer
//! @{

//! Register Offset (relative)
#define DPTR_PON_EGP_37 0x2CC30
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DPTR_PON_EGP_37 0x190ECC30u

//! Register Reset Value
#define DPTR_PON_EGP_37_RST 0x00000707u

//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_37_ND_POS 0
//! Field ND - Number of Descriptors
#define DPTR_PON_EGP_37_ND_MASK 0x7u

//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_37_NSD_POS 8
//! Field NSD - Number of Segmented Descriptors
#define DPTR_PON_EGP_37_NSD_MASK 0x700u

//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_37_DPTR_POS 16
//! Field DPTR - Descriptor Pointer
#define DPTR_PON_EGP_37_DPTR_MASK 0x70000u

//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_37_SDPTR_POS 24
//! Field SDPTR - Descriptor Pointer
#define DPTR_PON_EGP_37_SDPTR_MASK 0x7000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_37 Register DESC0_0_PON_EGP_37 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_37 0x2CD00
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_37 0x190ECD00u

//! Register Reset Value
#define DESC0_0_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_0_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_37 Register DESC1_0_PON_EGP_37 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_37 0x2CD04
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_37 0x190ECD04u

//! Register Reset Value
#define DESC1_0_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_0_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_37 Register DESC2_0_PON_EGP_37 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_37 0x2CD08
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_37 0x190ECD08u

//! Register Reset Value
#define DESC2_0_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_0_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_37 Register DESC3_0_PON_EGP_37 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_37 0x2CD0C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_37 0x190ECD0Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_0_PON_EGP_37_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_37_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_0_PON_EGP_37_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_37 Register DESC0_1_PON_EGP_37 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_37 0x2CD10
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_37 0x190ECD10u

//! Register Reset Value
#define DESC0_1_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_1_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_37 Register DESC1_1_PON_EGP_37 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_37 0x2CD14
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_37 0x190ECD14u

//! Register Reset Value
#define DESC1_1_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_1_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_37 Register DESC2_1_PON_EGP_37 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_37 0x2CD18
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_37 0x190ECD18u

//! Register Reset Value
#define DESC2_1_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_1_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_37 Register DESC3_1_PON_EGP_37 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_37 0x2CD1C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_37 0x190ECD1Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_1_PON_EGP_37_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_37_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_1_PON_EGP_37_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_37 Register DESC0_2_PON_EGP_37 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_37 0x2CD20
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_37 0x190ECD20u

//! Register Reset Value
#define DESC0_2_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_2_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_37 Register DESC1_2_PON_EGP_37 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_37 0x2CD24
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_37 0x190ECD24u

//! Register Reset Value
#define DESC1_2_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_2_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_37 Register DESC2_2_PON_EGP_37 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_37 0x2CD28
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_37 0x190ECD28u

//! Register Reset Value
#define DESC2_2_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_2_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_37 Register DESC3_2_PON_EGP_37 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_37 0x2CD2C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_37 0x190ECD2Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_2_PON_EGP_37_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_37_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_2_PON_EGP_37_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_37 Register DESC0_3_PON_EGP_37 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_37 0x2CD30
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_37 0x190ECD30u

//! Register Reset Value
#define DESC0_3_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_3_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_37 Register DESC1_3_PON_EGP_37 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_37 0x2CD34
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_37 0x190ECD34u

//! Register Reset Value
#define DESC1_3_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_3_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_37 Register DESC2_3_PON_EGP_37 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_37 0x2CD38
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_37 0x190ECD38u

//! Register Reset Value
#define DESC2_3_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_3_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_37 Register DESC3_3_PON_EGP_37 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_37 0x2CD3C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_37 0x190ECD3Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_3_PON_EGP_37_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_37_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_3_PON_EGP_37_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_37 Register DESC0_4_PON_EGP_37 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_37 0x2CD40
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_37 0x190ECD40u

//! Register Reset Value
#define DESC0_4_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_4_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_37 Register DESC1_4_PON_EGP_37 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_37 0x2CD44
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_37 0x190ECD44u

//! Register Reset Value
#define DESC1_4_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_4_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_37 Register DESC2_4_PON_EGP_37 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_37 0x2CD48
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_37 0x190ECD48u

//! Register Reset Value
#define DESC2_4_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_4_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_37 Register DESC3_4_PON_EGP_37 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_37 0x2CD4C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_37 0x190ECD4Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_4_PON_EGP_37_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_37_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_4_PON_EGP_37_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_37 Register DESC0_5_PON_EGP_37 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_37 0x2CD50
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_37 0x190ECD50u

//! Register Reset Value
#define DESC0_5_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_5_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_37 Register DESC1_5_PON_EGP_37 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_37 0x2CD54
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_37 0x190ECD54u

//! Register Reset Value
#define DESC1_5_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_5_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_37 Register DESC2_5_PON_EGP_37 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_37 0x2CD58
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_37 0x190ECD58u

//! Register Reset Value
#define DESC2_5_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_5_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_5_PON_EGP_37 Register DESC3_5_PON_EGP_37 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_5_PON_EGP_37 0x2CD5C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_5_PON_EGP_37 0x190ECD5Cu

//! Register Reset Value
#define DESC3_5_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_5_PON_EGP_37_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_37_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_5_PON_EGP_37_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_6_PON_EGP_37 Register DESC0_6_PON_EGP_37 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_6_PON_EGP_37 0x2CD60
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_6_PON_EGP_37 0x190ECD60u

//! Register Reset Value
#define DESC0_6_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_6_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_6_PON_EGP_37 Register DESC1_6_PON_EGP_37 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_6_PON_EGP_37 0x2CD64
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_6_PON_EGP_37 0x190ECD64u

//! Register Reset Value
#define DESC1_6_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_6_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_6_PON_EGP_37 Register DESC2_6_PON_EGP_37 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_6_PON_EGP_37 0x2CD68
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_6_PON_EGP_37 0x190ECD68u

//! Register Reset Value
#define DESC2_6_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_6_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_6_PON_EGP_37 Register DESC3_6_PON_EGP_37 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_6_PON_EGP_37 0x2CD6C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_6_PON_EGP_37 0x190ECD6Cu

//! Register Reset Value
#define DESC3_6_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_6_PON_EGP_37_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_37_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_6_PON_EGP_37_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_7_PON_EGP_37 Register DESC0_7_PON_EGP_37 - PON Egress Port Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_7_PON_EGP_37 0x2CD70
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_7_PON_EGP_37 0x190ECD70u

//! Register Reset Value
#define DESC0_7_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 0
#define DESC0_7_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_7_PON_EGP_37 Register DESC1_7_PON_EGP_37 - PON Egress Port Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_7_PON_EGP_37 0x2CD74
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_7_PON_EGP_37 0x190ECD74u

//! Register Reset Value
#define DESC1_7_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 1
#define DESC1_7_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_7_PON_EGP_37 Register DESC2_7_PON_EGP_37 - PON Egress Port Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_7_PON_EGP_37 0x2CD78
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_7_PON_EGP_37 0x190ECD78u

//! Register Reset Value
#define DESC2_7_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 2
#define DESC2_7_PON_EGP_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_7_PON_EGP_37 Register DESC3_7_PON_EGP_37 - PON Egress Port Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_7_PON_EGP_37 0x2CD7C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_7_PON_EGP_37 0x190ECD7Cu

//! Register Reset Value
#define DESC3_7_PON_EGP_37_RST 0x00000000u

//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_37_DESC_POS 0
//! Field DESC - Descriptor Double Word 3
#define DESC3_7_PON_EGP_37_DESC_MASK 0x7FFFFFFFu

//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_37_OWN_POS 31
//! Field OWN - Descriptor OWN bit
#define DESC3_7_PON_EGP_37_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_0_PON_EGP_S_37 Register DESC0_0_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_0_PON_EGP_S_37 0x2CE00
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_0_PON_EGP_S_37 0x190ECE00u

//! Register Reset Value
#define DESC0_0_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_0_PON_EGP_S_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_0_PON_EGP_S_37 Register DESC1_0_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_0_PON_EGP_S_37 0x2CE04
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_0_PON_EGP_S_37 0x190ECE04u

//! Register Reset Value
#define DESC1_0_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_0_PON_EGP_S_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_0_PON_EGP_S_37 Register DESC2_0_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_0_PON_EGP_S_37 0x2CE08
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_0_PON_EGP_S_37 0x190ECE08u

//! Register Reset Value
#define DESC2_0_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_0_PON_EGP_S_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_0_PON_EGP_S_37 Register DESC3_0_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_0_PON_EGP_S_37 0x2CE0C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_0_PON_EGP_S_37 0x190ECE0Cu

//! Register Reset Value
#define DESC3_0_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_0_PON_EGP_S_37_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_37_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_0_PON_EGP_S_37_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_1_PON_EGP_S_37 Register DESC0_1_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_1_PON_EGP_S_37 0x2CE10
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_1_PON_EGP_S_37 0x190ECE10u

//! Register Reset Value
#define DESC0_1_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_1_PON_EGP_S_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_1_PON_EGP_S_37 Register DESC1_1_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_1_PON_EGP_S_37 0x2CE14
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_1_PON_EGP_S_37 0x190ECE14u

//! Register Reset Value
#define DESC1_1_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_1_PON_EGP_S_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_1_PON_EGP_S_37 Register DESC2_1_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_1_PON_EGP_S_37 0x2CE18
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_1_PON_EGP_S_37 0x190ECE18u

//! Register Reset Value
#define DESC2_1_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_1_PON_EGP_S_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_1_PON_EGP_S_37 Register DESC3_1_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_1_PON_EGP_S_37 0x2CE1C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_1_PON_EGP_S_37 0x190ECE1Cu

//! Register Reset Value
#define DESC3_1_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_1_PON_EGP_S_37_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_37_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_1_PON_EGP_S_37_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_2_PON_EGP_S_37 Register DESC0_2_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_2_PON_EGP_S_37 0x2CE20
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_2_PON_EGP_S_37 0x190ECE20u

//! Register Reset Value
#define DESC0_2_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_2_PON_EGP_S_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_2_PON_EGP_S_37 Register DESC1_2_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_2_PON_EGP_S_37 0x2CE24
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_2_PON_EGP_S_37 0x190ECE24u

//! Register Reset Value
#define DESC1_2_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_2_PON_EGP_S_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_2_PON_EGP_S_37 Register DESC2_2_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_2_PON_EGP_S_37 0x2CE28
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_2_PON_EGP_S_37 0x190ECE28u

//! Register Reset Value
#define DESC2_2_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_2_PON_EGP_S_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_2_PON_EGP_S_37 Register DESC3_2_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_2_PON_EGP_S_37 0x2CE2C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_2_PON_EGP_S_37 0x190ECE2Cu

//! Register Reset Value
#define DESC3_2_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_2_PON_EGP_S_37_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_37_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_2_PON_EGP_S_37_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_3_PON_EGP_S_37 Register DESC0_3_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_3_PON_EGP_S_37 0x2CE30
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_3_PON_EGP_S_37 0x190ECE30u

//! Register Reset Value
#define DESC0_3_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_3_PON_EGP_S_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_3_PON_EGP_S_37 Register DESC1_3_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_3_PON_EGP_S_37 0x2CE34
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_3_PON_EGP_S_37 0x190ECE34u

//! Register Reset Value
#define DESC1_3_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_3_PON_EGP_S_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_3_PON_EGP_S_37 Register DESC2_3_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_3_PON_EGP_S_37 0x2CE38
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_3_PON_EGP_S_37 0x190ECE38u

//! Register Reset Value
#define DESC2_3_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_3_PON_EGP_S_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_3_PON_EGP_S_37 Register DESC3_3_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_3_PON_EGP_S_37 0x2CE3C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_3_PON_EGP_S_37 0x190ECE3Cu

//! Register Reset Value
#define DESC3_3_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_3_PON_EGP_S_37_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_37_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_3_PON_EGP_S_37_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_4_PON_EGP_S_37 Register DESC0_4_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_4_PON_EGP_S_37 0x2CE40
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_4_PON_EGP_S_37 0x190ECE40u

//! Register Reset Value
#define DESC0_4_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_4_PON_EGP_S_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_4_PON_EGP_S_37 Register DESC1_4_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_4_PON_EGP_S_37 0x2CE44
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_4_PON_EGP_S_37 0x190ECE44u

//! Register Reset Value
#define DESC1_4_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_4_PON_EGP_S_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_4_PON_EGP_S_37 Register DESC2_4_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_4_PON_EGP_S_37 0x2CE48
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_4_PON_EGP_S_37 0x190ECE48u

//! Register Reset Value
#define DESC2_4_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 2
#define DESC2_4_PON_EGP_S_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC3_4_PON_EGP_S_37 Register DESC3_4_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW3
//! @{

//! Register Offset (relative)
#define DESC3_4_PON_EGP_S_37 0x2CE4C
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC3_4_PON_EGP_S_37 0x190ECE4Cu

//! Register Reset Value
#define DESC3_4_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 3
#define DESC3_4_PON_EGP_S_37_DESC_MASK 0x7FFFFFFFu

//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_37_OWN_POS 31
//! Field OWN - OWN Bit for the Segmented Descriptor
#define DESC3_4_PON_EGP_S_37_OWN_MASK 0x80000000u

//! @}

//! \defgroup DESC0_5_PON_EGP_S_37 Register DESC0_5_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW0
//! @{

//! Register Offset (relative)
#define DESC0_5_PON_EGP_S_37 0x2CE50
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC0_5_PON_EGP_S_37 0x190ECE50u

//! Register Reset Value
#define DESC0_5_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 0
#define DESC0_5_PON_EGP_S_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC1_5_PON_EGP_S_37 Register DESC1_5_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW1
//! @{

//! Register Offset (relative)
#define DESC1_5_PON_EGP_S_37 0x2CE54
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC1_5_PON_EGP_S_37 0x190ECE54u

//! Register Reset Value
#define DESC1_5_PON_EGP_S_37_RST 0x00000000u

//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_37_DESC_POS 0
//! Field DESC - Segmented Descriptor Double Word 1
#define DESC1_5_PON_EGP_S_37_DESC_MASK 0xFFFFFFFFu

//! @}

//! \defgroup DESC2_5_PON_EGP_S_37 Register DESC2_5_PON_EGP_S_37 - PON Egress Port Segmented Descriptor DW2
//! @{

//! Register Offset (relative)
#define DESC2_5_PON_EGP_S_37 0x2CE58
//! Register Offset (absolute) for 1st Instance CQEM_DEQ
#define CQEM_DEQ_DESC2_5_PON_EGP_S_37 0x190ECE58u

//! Register Reset Value
#define DESC2_5_PON