/*
 * Description:
 *     PP registers and memories list to be used for testing
 *     the registers and memories access
 *
 * SPDX-License-Identifier: GPL-2.0-only
 * Copyright (C) 2019 Intel Corporation
 */

#ifndef __PP_DEV_TEST_H__
#define __PP_DEV_TEST_H__

#include <linux/types.h>

#include "pp_common.h"

#if IS_ENABLED(PP_POWER_ON_REGS_TEST)

struct test_reg {
	u64 addr;
	u32 val;
};

const struct test_reg reg_dflt[] = {
	{ .addr = 0x0f000110c, .val = 0x00000020 },
	{ .addr = 0x0f0000000, .val = 0x00000001 },
	{ .addr = 0x0f0000004, .val = 0x00000000 },
	{ .addr = 0x0f000000c, .val = 0x00000101 },
	{ .addr = 0x0f0002000, .val = 0x00000000 },
	{ .addr = 0x0f0002008, .val = 0x00000000 },
	{ .addr = 0x0f000200c, .val = 0x00000000 },
	{ .addr = 0x0f0002010, .val = 0x00000000 },
	{ .addr = 0x0f0002014, .val = 0x00000000 },
	{ .addr = 0x0f0018000, .val = 0x00000000 },
	{ .addr = 0x0f0018004, .val = 0x00000000 },
	{ .addr = 0x0f0018008, .val = 0x00000000 },
	{ .addr = 0x0f001800c, .val = 0x00000000 },
	{ .addr = 0x0f0018020, .val = 0x00000000 },
	{ .addr = 0x0f0018024, .val = 0x00000000 },
	{ .addr = 0x0f0018028, .val = 0x00000000 },
	{ .addr = 0x0f001802c, .val = 0x00000000 },
	{ .addr = 0x0f0018040, .val = 0x00000000 },
	{ .addr = 0x0f0018044, .val = 0x00000000 },
	{ .addr = 0x0f0018048, .val = 0x00000000 },
	{ .addr = 0x0f001804c, .val = 0x00000000 },
	{ .addr = 0x0f0018060, .val = 0x00000000 },
	{ .addr = 0x0f0018064, .val = 0x00000000 },
	{ .addr = 0x0f0018068, .val = 0x00000000 },
	{ .addr = 0x0f001806c, .val = 0x00000000 },
	{ .addr = 0x0f0018100, .val = 0x00000000 },
	{ .addr = 0x0f0018104, .val = 0x00000000 },
	{ .addr = 0x0f0018108, .val = 0x00000000 },
	{ .addr = 0x0f001810c, .val = 0x00000000 },
	{ .addr = 0x0f0018120, .val = 0x00000000 },
	{ .addr = 0x0f0018124, .val = 0x00000000 },
	{ .addr = 0x0f0018128, .val = 0x00000000 },
	{ .addr = 0x0f001812c, .val = 0x00000000 },
	{ .addr = 0x0f0018140, .val = 0x00000000 },
	{ .addr = 0x0f0018144, .val = 0x00000000 },
	{ .addr = 0x0f0018148, .val = 0x00000000 },
	{ .addr = 0x0f001814c, .val = 0x00000000 },
	{ .addr = 0x0f0018160, .val = 0x00000000 },
	{ .addr = 0x0f0018164, .val = 0x00000000 },
	{ .addr = 0x0f0018168, .val = 0x00000000 },
	{ .addr = 0x0f001816c, .val = 0x00000000 },
	{ .addr = 0x0f0018200, .val = 0x00000000 },
	{ .addr = 0x0f0018204, .val = 0x00000000 },
	{ .addr = 0x0f0018208, .val = 0x00000000 },
	{ .addr = 0x0f001820c, .val = 0x00000000 },
	{ .addr = 0x0f0018220, .val = 0x00000000 },
	{ .addr = 0x0f0018224, .val = 0x00000000 },
	{ .addr = 0x0f0018228, .val = 0x00000000 },
	{ .addr = 0x0f001822c, .val = 0x00000000 },
	{ .addr = 0x0f0018240, .val = 0x00000000 },
	{ .addr = 0x0f0018244, .val = 0x00000000 },
	{ .addr = 0x0f0018248, .val = 0x00000000 },
	{ .addr = 0x0f001824c, .val = 0x00000000 },
	{ .addr = 0x0f0018260, .val = 0x00000000 },
	{ .addr = 0x0f0018264, .val = 0x00000000 },
	{ .addr = 0x0f0018268, .val = 0x00000000 },
	{ .addr = 0x0f001826c, .val = 0x00000000 },
	{ .addr = 0x0f0018280, .val = 0x00000000 },
	{ .addr = 0x0f0018284, .val = 0x00000000 },
	{ .addr = 0x0f0018288, .val = 0x00000000 },
	{ .addr = 0x0f001828c, .val = 0x00000000 },
	{ .addr = 0x0f0018320, .val = 0x00000000 },
	{ .addr = 0x0f0018324, .val = 0x00000000 },
	{ .addr = 0x0f0018328, .val = 0x00000000 },
	{ .addr = 0x0f001832c, .val = 0x00000000 },
	{ .addr = 0x0f0018340, .val = 0x00000000 },
	{ .addr = 0x0f0018344, .val = 0x00000000 },
	{ .addr = 0x0f0018348, .val = 0x00000000 },
	{ .addr = 0x0f001834c, .val = 0x00000000 },
	{ .addr = 0x0f0018360, .val = 0x00000000 },
	{ .addr = 0x0f0018364, .val = 0x00000000 },
	{ .addr = 0x0f0018368, .val = 0x00000000 },
	{ .addr = 0x0f001836c, .val = 0x00000000 },
	{ .addr = 0x0f0018380, .val = 0x00000000 },
	{ .addr = 0x0f0018384, .val = 0x00000000 },
	{ .addr = 0x0f0018388, .val = 0x00000000 },
	{ .addr = 0x0f001838c, .val = 0x00000000 },
	{ .addr = 0x0f0018420, .val = 0x00000000 },
	{ .addr = 0x0f0018424, .val = 0x00000000 },
	{ .addr = 0x0f0018428, .val = 0x00000000 },
	{ .addr = 0x0f001842c, .val = 0x00000000 },
	{ .addr = 0x0f0018440, .val = 0x00000000 },
	{ .addr = 0x0f0018444, .val = 0x00000000 },
	{ .addr = 0x0f0018448, .val = 0x00000000 },
	{ .addr = 0x0f001844c, .val = 0x00000000 },
	{ .addr = 0x0f0018460, .val = 0x00000000 },
	{ .addr = 0x0f0018464, .val = 0x00000000 },
	{ .addr = 0x0f0018468, .val = 0x00000000 },
	{ .addr = 0x0f001846c, .val = 0x00000000 },
	{ .addr = 0x0f0018480, .val = 0x00010000 },
	{ .addr = 0x0f0018484, .val = 0x00010000 },
	{ .addr = 0x0f0018488, .val = 0x00010000 },
	{ .addr = 0x0f001848c, .val = 0x00010000 },
	{ .addr = 0x0f00184a0, .val = 0x00010000 },
	{ .addr = 0x0f00184a4, .val = 0x00010000 },
	{ .addr = 0x0f00184a8, .val = 0x00010000 },
	{ .addr = 0x0f00184ac, .val = 0x00010000 },
	{ .addr = 0x0f00184c0, .val = 0x00010000 },
	{ .addr = 0x0f00184c4, .val = 0x00010000 },
	{ .addr = 0x0f00184c8, .val = 0x00010000 },
	{ .addr = 0x0f00184cc, .val = 0x00010000 },
	{ .addr = 0x0f00184e0, .val = 0x00010000 },
	{ .addr = 0x0f00184e4, .val = 0x00010000 },
	{ .addr = 0x0f00184e8, .val = 0x00010000 },
	{ .addr = 0x0f00184ec, .val = 0x00010000 },
	{ .addr = 0x0f0018580, .val = 0x00010000 },
	{ .addr = 0x0f0018584, .val = 0x00010000 },
	{ .addr = 0x0f0018588, .val = 0x00010000 },
	{ .addr = 0x0f001858c, .val = 0x00010000 },
	{ .addr = 0x0f00185a0, .val = 0x00000000 },
	{ .addr = 0x0f00185a4, .val = 0x00000000 },
	{ .addr = 0x0f00185a8, .val = 0x00000000 },
	{ .addr = 0x0f00185ac, .val = 0x00000000 },
	{ .addr = 0x0f00185c0, .val = 0x00000000 },
	{ .addr = 0x0f00185c4, .val = 0x00000000 },
	{ .addr = 0x0f00185c8, .val = 0x00000000 },
	{ .addr = 0x0f00185cc, .val = 0x00000000 },
	{ .addr = 0x0f00185e0, .val = 0x00000000 },
	{ .addr = 0x0f00185e4, .val = 0x00000000 },
	{ .addr = 0x0f00185e8, .val = 0x00000000 },
	{ .addr = 0x0f00185ec, .val = 0x00000000 },
	{ .addr = 0x0f0018600, .val = 0x00000000 },
	{ .addr = 0x0f0018604, .val = 0x00000000 },
	{ .addr = 0x0f0018608, .val = 0x00000000 },
	{ .addr = 0x0f001860c, .val = 0x00000000 },
	{ .addr = 0x0f00186a0, .val = 0x00000000 },
	{ .addr = 0x0f00186a4, .val = 0x00000000 },
	{ .addr = 0x0f00186a8, .val = 0x00000000 },
	{ .addr = 0x0f00186ac, .val = 0x00000000 },
	{ .addr = 0x0f00186c0, .val = 0x00000000 },
	{ .addr = 0x0f00186c4, .val = 0x00000000 },
	{ .addr = 0x0f00186c8, .val = 0x00000000 },
	{ .addr = 0x0f00186cc, .val = 0x00000000 },
	{ .addr = 0x0f00186e0, .val = 0x00000000 },
	{ .addr = 0x0f00186e4, .val = 0x00000000 },
	{ .addr = 0x0f00186e8, .val = 0x00000000 },
	{ .addr = 0x0f00186ec, .val = 0x00000000 },
	{ .addr = 0x0f0018700, .val = 0x00000000 },
	{ .addr = 0x0f0018704, .val = 0x00000000 },
	{ .addr = 0x0f0018708, .val = 0x00000000 },
	{ .addr = 0x0f001870c, .val = 0x00000000 },
	{ .addr = 0x0f0018720, .val = 0x00000000 },
	{ .addr = 0x0f0018724, .val = 0x00000000 },
	{ .addr = 0x0f0018728, .val = 0x00000000 },
	{ .addr = 0x0f001872c, .val = 0x00000000 },
	{ .addr = 0x0f00187c0, .val = 0x00010000 },
	{ .addr = 0x0f00187c4, .val = 0x00010000 },
	{ .addr = 0x0f00187c8, .val = 0x00010000 },
	{ .addr = 0x0f00187cc, .val = 0x00010000 },
	{ .addr = 0x0f00187e0, .val = 0x00000010 },
	{ .addr = 0x0f00187e4, .val = 0x00000000 },
	{ .addr = 0x0f0018800, .val = 0x00000000 },
	{ .addr = 0x0f0018804, .val = 0x00000000 },
	{ .addr = 0x0f0018808, .val = 0x00000000 },
	{ .addr = 0x0f001880c, .val = 0x00000000 },
	{ .addr = 0x0f0018820, .val = 0x0003ffff },
	{ .addr = 0x0f0018824, .val = 0x00000000 },
	{ .addr = 0x0f0018828, .val = 0x00000000 },
	{ .addr = 0x0f001882c, .val = 0x00000000 },
	{ .addr = 0x0f0018830, .val = 0x0003ffff },
	{ .addr = 0x0f0018834, .val = 0x00000000 },
	{ .addr = 0x0f0018838, .val = 0x00000000 },
	{ .addr = 0x0f001883c, .val = 0x00000000 },
	{ .addr = 0x0f0018840, .val = 0x00000000 },
	{ .addr = 0x0f0018844, .val = 0x000004d6 },
	{ .addr = 0x0f0018848, .val = 0x00000230 },
	{ .addr = 0x0f001884c, .val = 0x0003ffff },
	{ .addr = 0x0f0018850, .val = 0x0003ffff },
	{ .addr = 0x0f0018854, .val = 0x00000000 },
	{ .addr = 0x0f0018858, .val = 0x00000000 },
	{ .addr = 0x0f001885c, .val = 0x0003ffff },
	{ .addr = 0x0f0018860, .val = 0x00020311 },
	{ .addr = 0x0f0018864, .val = 0x0000000c },
	{ .addr = 0x0f0018868, .val = 0x00020311 },
	{ .addr = 0x0f001886c, .val = 0x0000000c },
	{ .addr = 0x0f0018870, .val = 0x00020311 },
	{ .addr = 0x0f0018874, .val = 0x0000000c },
	{ .addr = 0x0f0018878, .val = 0x00220311 },
	{ .addr = 0x0f0018880, .val = 0x00020311 },
	{ .addr = 0x0f0018884, .val = 0x0000000c },
	{ .addr = 0x0f0018888, .val = 0x00020311 },
	{ .addr = 0x0f0018890, .val = 0x00020311 },
	{ .addr = 0x0f0018898, .val = 0x00020311 },
	{ .addr = 0x0f001889c, .val = 0x00020311 },
	{ .addr = 0x0f00188a0, .val = 0x00020311 },
	{ .addr = 0x0f00188a4, .val = 0x00020311 },
	{ .addr = 0x0f00188b8, .val = 0x0000000c },
	{ .addr = 0x0f00188bc, .val = 0x0000000c },
	{ .addr = 0x0f00188c0, .val = 0x0000000c },
	{ .addr = 0x0f00188c4, .val = 0x0000000c },
	{ .addr = 0x0f00188d8, .val = 0x00000000 },
	{ .addr = 0x0f00188dc, .val = 0x00000000 },
	{ .addr = 0x0f00188e0, .val = 0x00000000 },
	{ .addr = 0x0f00188e4, .val = 0x00000000 },
	{ .addr = 0x0f00188e8, .val = 0x00000000 },
	{ .addr = 0x0f00188ec, .val = 0x00000000 },
	{ .addr = 0x0f00188f0, .val = 0x00000000 },
	{ .addr = 0x0f00188f4, .val = 0x00000000 },
	{ .addr = 0x0f00188f8, .val = 0x00000000 },
	{ .addr = 0x0f001890c, .val = 0x00000000 },
	{ .addr = 0x0f0018910, .val = 0x00000000 },
	{ .addr = 0x0f0018914, .val = 0x00000000 },
	{ .addr = 0x0f0018918, .val = 0x00000000 },
	{ .addr = 0x0f001891c, .val = 0x00000000 },
	{ .addr = 0x0f0018920, .val = 0x00000000 },
	{ .addr = 0x0f0018924, .val = 0x00000000 },
	{ .addr = 0x0f0018928, .val = 0x00000000 },
	{ .addr = 0x0f001892c, .val = 0x00000000 },
	{ .addr = 0x0f0018940, .val = 0x18f00000 },
	{ .addr = 0x0f0018948, .val = 0x00000f00 },
	{ .addr = 0x0f001894c, .val = 0x00000000 },
	{ .addr = 0x0f0018950, .val = 0x00000000 },
	{ .addr = 0x0f0018954, .val = 0x00000000 },
	{ .addr = 0x0f0018980, .val = 0x00000000 },
	{ .addr = 0x0f0018984, .val = 0x00000000 },
	{ .addr = 0x0f0018988, .val = 0x00000000 },
	{ .addr = 0x0f001898c, .val = 0x00000000 },
	{ .addr = 0x0f0018990, .val = 0x00000000 },
	{ .addr = 0x0f0018998, .val = 0x00000000 },
	{ .addr = 0x0f001899c, .val = 0x00000000 },
	{ .addr = 0x0f00189a0, .val = 0x00000000 },
	{ .addr = 0x0f00189a4, .val = 0x00000000 },
	{ .addr = 0x0f00189c0, .val = 0x00000000 },
	{ .addr = 0x0f00189c4, .val = 0x00000000 },
	{ .addr = 0x0f0010000, .val = 0x00000000 },
	{ .addr = 0x0f0010004, .val = 0x00000000 },
	{ .addr = 0x0f0010008, .val = 0x00000000 },
	{ .addr = 0x0f001000c, .val = 0x00000000 },
	{ .addr = 0x0f0010010, .val = 0x00000000 },
	{ .addr = 0x0f0010014, .val = 0x00000000 },
	{ .addr = 0x0f0010018, .val = 0x00000000 },
	{ .addr = 0x0f001001c, .val = 0x00000000 },
	{ .addr = 0x0f0010020, .val = 0x00000000 },
	{ .addr = 0x0f0010024, .val = 0x00000000 },
	{ .addr = 0x0f0010028, .val = 0x00000000 },
	{ .addr = 0x0f001002c, .val = 0x00000000 },
	{ .addr = 0x0f0010030, .val = 0x00000000 },
	{ .addr = 0x0f0010034, .val = 0x00000000 },
	{ .addr = 0x0f0010038, .val = 0x00000000 },
	{ .addr = 0x0f001003c, .val = 0x00000000 },
	{ .addr = 0x0f0010040, .val = 0x00000000 },
	{ .addr = 0x0f0010044, .val = 0x00000000 },
	{ .addr = 0x0f0010048, .val = 0x00000000 },
	{ .addr = 0x0f001004c, .val = 0x00000000 },
	{ .addr = 0x0f0010050, .val = 0x00000000 },
	{ .addr = 0x0f0010054, .val = 0x00000000 },
	{ .addr = 0x0f0010058, .val = 0x00000000 },
	{ .addr = 0x0f001005c, .val = 0x00000000 },
	{ .addr = 0x0f0010060, .val = 0x00000000 },
	{ .addr = 0x0f0010064, .val = 0x00000000 },
	{ .addr = 0x0f0010068, .val = 0x00000000 },
	{ .addr = 0x0f001006c, .val = 0x00000000 },
	{ .addr = 0x0f0010070, .val = 0x00000000 },
	{ .addr = 0x0f0010074, .val = 0x00000000 },
	{ .addr = 0x0f0010078, .val = 0x00000000 },
	{ .addr = 0x0f001007c, .val = 0x00000000 },
	{ .addr = 0x0f0010080, .val = 0x0000000f },
	{ .addr = 0x0f0010084, .val = 0xfe080000 },
	{ .addr = 0x0f0004000, .val = 0x00000000 },
	{ .addr = 0x0f0004004, .val = 0x00000000 },
	{ .addr = 0x0f0004008, .val = 0x00000000 },
	{ .addr = 0x0f000400c, .val = 0x00000000 },
	{ .addr = 0x0f0004010, .val = 0x00000000 },
	{ .addr = 0x0f0004014, .val = 0x00000000 },
	{ .addr = 0x0f0004018, .val = 0x00000000 },
	{ .addr = 0x0f000401c, .val = 0x00000000 },
	{ .addr = 0x0f0004020, .val = 0x00000000 },
	{ .addr = 0x0f0004024, .val = 0x00000000 },
	{ .addr = 0x0f0004028, .val = 0x00000000 },
	{ .addr = 0x0f000402c, .val = 0x00000000 },
	{ .addr = 0x0f0004030, .val = 0x00000000 },
	{ .addr = 0x0f0004034, .val = 0x00000000 },
	{ .addr = 0x0f0004038, .val = 0x00000000 },
	{ .addr = 0x0f000403c, .val = 0x00000000 },
	{ .addr = 0x0f0004040, .val = 0x00000000 },
	{ .addr = 0x0f0004044, .val = 0x00000000 },
	{ .addr = 0x0f0004048, .val = 0x00000000 },
	{ .addr = 0x0f000404c, .val = 0x00000000 },
	{ .addr = 0x0f0004050, .val = 0x00000000 },
	{ .addr = 0x0f0004054, .val = 0x00000000 },
	{ .addr = 0x0f0004058, .val = 0x00000000 },
	{ .addr = 0x0f000405c, .val = 0x00000000 },
	{ .addr = 0x0f0004060, .val = 0x00000000 },
	{ .addr = 0x0f0004064, .val = 0x00000000 },
	{ .addr = 0x0f0004068, .val = 0x00000000 },
	{ .addr = 0x0f000406c, .val = 0x00000000 },
	{ .addr = 0x0f0004070, .val = 0x00000000 },
	{ .addr = 0x0f0004074, .val = 0x00000000 },
	{ .addr = 0x0f0004078, .val = 0x00000000 },
	{ .addr = 0x0f000407c, .val = 0x00000000 },
	{ .addr = 0x0f0004080, .val = 0x00000000 },
	{ .addr = 0x0f0004084, .val = 0x00000000 },
	{ .addr = 0x0f0004088, .val = 0x00000000 },
	{ .addr = 0x0f000408c, .val = 0x00000000 },
	{ .addr = 0x0f0004090, .val = 0x00000000 },
	{ .addr = 0x0f0004094, .val = 0x00000000 },
	{ .addr = 0x0f0004098, .val = 0x00000000 },
	{ .addr = 0x0f000409c, .val = 0x00000000 },
	{ .addr = 0x0f00040a0, .val = 0x00000000 },
	{ .addr = 0x0f00040a4, .val = 0x00000000 },
	{ .addr = 0x0f00040a8, .val = 0x00000000 },
	{ .addr = 0x0f00040ac, .val = 0x00000000 },
	{ .addr = 0x0f00040b0, .val = 0x00000000 },
	{ .addr = 0x0f00040b4, .val = 0x00000000 },
	{ .addr = 0x0f00040b8, .val = 0x00000000 },
	{ .addr = 0x0f00040bc, .val = 0x00000000 },
	{ .addr = 0x0f00040c0, .val = 0x00000000 },
	{ .addr = 0x0f00040c4, .val = 0x00000000 },
	{ .addr = 0x0f00040c8, .val = 0x00000000 },
	{ .addr = 0x0f00040cc, .val = 0x00000000 },
	{ .addr = 0x0f00040d0, .val = 0x00000000 },
	{ .addr = 0x0f00040d4, .val = 0x00000000 },
	{ .addr = 0x0f00040d8, .val = 0x00000000 },
	{ .addr = 0x0f00040dc, .val = 0x00000000 },
	{ .addr = 0x0f00040e0, .val = 0x00000000 },
	{ .addr = 0x0f00040e4, .val = 0x00000000 },
	{ .addr = 0x0f00040e8, .val = 0x00000000 },
	{ .addr = 0x0f00040ec, .val = 0x00000000 },
	{ .addr = 0x0f00040f0, .val = 0x00000000 },
	{ .addr = 0x0f00040f4, .val = 0x00000000 },
	{ .addr = 0x0f00040f8, .val = 0x00000000 },
	{ .addr = 0x0f00040fc, .val = 0x00000000 },
	{ .addr = 0x0f0004100, .val = 0x00000000 },
	{ .addr = 0x0f0004104, .val = 0x00000000 },
	{ .addr = 0x0f0004108, .val = 0x00000000 },
	{ .addr = 0x0f000410c, .val = 0x00000000 },
	{ .addr = 0x0f0004110, .val = 0x00000000 },
	{ .addr = 0x0f0004114, .val = 0x00000000 },
	{ .addr = 0x0f0004118, .val = 0x00000000 },
	{ .addr = 0x0f000411c, .val = 0x00000000 },
	{ .addr = 0x0f0004120, .val = 0x00000000 },
	{ .addr = 0x0f0004124, .val = 0x00000000 },
	{ .addr = 0x0f0004128, .val = 0x00000000 },
	{ .addr = 0x0f000412c, .val = 0x00000000 },
	{ .addr = 0x0f0004130, .val = 0x00000000 },
	{ .addr = 0x0f0004134, .val = 0x00000000 },
	{ .addr = 0x0f0004138, .val = 0x00000000 },
	{ .addr = 0x0f000413c, .val = 0x00000000 },
	{ .addr = 0x0f0004140, .val = 0x00000000 },
	{ .addr = 0x0f0004144, .val = 0x00000000 },
	{ .addr = 0x0f0004148, .val = 0x00000000 },
	{ .addr = 0x0f000414c, .val = 0x00000000 },
	{ .addr = 0x0f0004150, .val = 0x00000000 },
	{ .addr = 0x0f0004154, .val = 0x00000000 },
	{ .addr = 0x0f0004158, .val = 0x00000000 },
	{ .addr = 0x0f000415c, .val = 0x00000000 },
	{ .addr = 0x0f0004160, .val = 0x00000000 },
	{ .addr = 0x0f0004164, .val = 0x00000000 },
	{ .addr = 0x0f0004168, .val = 0x00000000 },
	{ .addr = 0x0f000416c, .val = 0x00000000 },
	{ .addr = 0x0f0004170, .val = 0x00000000 },
	{ .addr = 0x0f0004174, .val = 0x00000000 },
	{ .addr = 0x0f0004178, .val = 0x00000000 },
	{ .addr = 0x0f000417c, .val = 0x00000000 },
	{ .addr = 0x0f0004180, .val = 0x00000000 },
	{ .addr = 0x0f0004184, .val = 0x00000000 },
	{ .addr = 0x0f0004188, .val = 0x00000000 },
	{ .addr = 0x0f000418c, .val = 0x00000000 },
	{ .addr = 0x0f0004190, .val = 0x00000000 },
	{ .addr = 0x0f0004194, .val = 0x00000000 },
	{ .addr = 0x0f0004198, .val = 0x00000000 },
	{ .addr = 0x0f000419c, .val = 0x00000000 },
	{ .addr = 0x0f00041a0, .val = 0x00000000 },
	{ .addr = 0x0f00041a4, .val = 0x00000000 },
	{ .addr = 0x0f00041a8, .val = 0x00000000 },
	{ .addr = 0x0f00041ac, .val = 0x00000000 },
	{ .addr = 0x0f00041b0, .val = 0x00000000 },
	{ .addr = 0x0f00041b4, .val = 0x00000000 },
	{ .addr = 0x0f00041b8, .val = 0x00000000 },
	{ .addr = 0x0f00041bc, .val = 0x00000000 },
	{ .addr = 0x0f00041c0, .val = 0x00000000 },
	{ .addr = 0x0f00041c4, .val = 0x00000000 },
	{ .addr = 0x0f00041c8, .val = 0x00000000 },
	{ .addr = 0x0f00041cc, .val = 0x00000000 },
	{ .addr = 0x0f00041d0, .val = 0x00000000 },
	{ .addr = 0x0f00041d4, .val = 0x00000000 },
	{ .addr = 0x0f00041d8, .val = 0x00000000 },
	{ .addr = 0x0f00041dc, .val = 0x00000000 },
	{ .addr = 0x0f00041e0, .val = 0x00000000 },
	{ .addr = 0x0f00041e4, .val = 0x00000000 },
	{ .addr = 0x0f00041e8, .val = 0x00000000 },
	{ .addr = 0x0f00041ec, .val = 0x00000000 },
	{ .addr = 0x0f00041f0, .val = 0x00000000 },
	{ .addr = 0x0f00041f4, .val = 0x00000000 },
	{ .addr = 0x0f00041f8, .val = 0x00000000 },
	{ .addr = 0x0f00041fc, .val = 0x00000000 },
	{ .addr = 0x0f0004200, .val = 0x00000000 },
	{ .addr = 0x0f0004204, .val = 0x00000000 },
	{ .addr = 0x0f0004208, .val = 0x00000000 },
	{ .addr = 0x0f000420c, .val = 0x00000000 },
	{ .addr = 0x0f0004210, .val = 0x00000000 },
	{ .addr = 0x0f0004214, .val = 0x00000000 },
	{ .addr = 0x0f0004218, .val = 0x00000000 },
	{ .addr = 0x0f000421c, .val = 0x00000000 },
	{ .addr = 0x0f0004220, .val = 0x00000000 },
	{ .addr = 0x0f0004224, .val = 0x00000000 },
	{ .addr = 0x0f0004228, .val = 0x00000000 },
	{ .addr = 0x0f000422c, .val = 0x00000000 },
	{ .addr = 0x0f0004230, .val = 0x00000000 },
	{ .addr = 0x0f0004234, .val = 0x00000000 },
	{ .addr = 0x0f0004238, .val = 0x00000000 },
	{ .addr = 0x0f000423c, .val = 0x00000000 },
	{ .addr = 0x0f0004240, .val = 0x00000000 },
	{ .addr = 0x0f0004244, .val = 0x00000000 },
	{ .addr = 0x0f0004248, .val = 0x00000000 },
	{ .addr = 0x0f000424c, .val = 0x00000000 },
	{ .addr = 0x0f0004250, .val = 0x00000000 },
	{ .addr = 0x0f0004254, .val = 0x00000000 },
	{ .addr = 0x0f0004258, .val = 0x00000000 },
	{ .addr = 0x0f000425c, .val = 0x00000000 },
	{ .addr = 0x0f0004260, .val = 0x00000000 },
	{ .addr = 0x0f0004264, .val = 0x00000000 },
	{ .addr = 0x0f0004268, .val = 0x00000000 },
	{ .addr = 0x0f000426c, .val = 0x00000000 },
	{ .addr = 0x0f0004270, .val = 0x00000000 },
	{ .addr = 0x0f0004274, .val = 0x00000000 },
	{ .addr = 0x0f0004278, .val = 0x00000000 },
	{ .addr = 0x0f000427c, .val = 0x00000000 },
	{ .addr = 0x0f0004280, .val = 0x00000000 },
	{ .addr = 0x0f0004284, .val = 0x00000000 },
	{ .addr = 0x0f0004288, .val = 0x00000000 },
	{ .addr = 0x0f000428c, .val = 0x00000000 },
	{ .addr = 0x0f0004290, .val = 0x00000000 },
	{ .addr = 0x0f0004294, .val = 0x00000000 },
	{ .addr = 0x0f0004298, .val = 0x00000000 },
	{ .addr = 0x0f000429c, .val = 0x00000000 },
	{ .addr = 0x0f00042a0, .val = 0x00000000 },
	{ .addr = 0x0f00042a4, .val = 0x00000000 },
	{ .addr = 0x0f00042a8, .val = 0x00000000 },
	{ .addr = 0x0f00042ac, .val = 0x00000000 },
	{ .addr = 0x0f00042b0, .val = 0x00000000 },
	{ .addr = 0x0f00042b4, .val = 0x00000000 },
	{ .addr = 0x0f00042b8, .val = 0x00000000 },
	{ .addr = 0x0f00042bc, .val = 0x00000000 },
	{ .addr = 0x0f00042c0, .val = 0x00000000 },
	{ .addr = 0x0f00042c4, .val = 0x00000000 },
	{ .addr = 0x0f00042c8, .val = 0x00000000 },
	{ .addr = 0x0f00042cc, .val = 0x00000000 },
	{ .addr = 0x0f00042d0, .val = 0x00000000 },
	{ .addr = 0x0f00042d4, .val = 0x00000000 },
	{ .addr = 0x0f00042d8, .val = 0x00000000 },
	{ .addr = 0x0f00042dc, .val = 0x00000000 },
	{ .addr = 0x0f00042e0, .val = 0x00000000 },
	{ .addr = 0x0f00042e4, .val = 0x00000000 },
	{ .addr = 0x0f00042e8, .val = 0x00000000 },
	{ .addr = 0x0f00042ec, .val = 0x00000000 },
	{ .addr = 0x0f00042f0, .val = 0x00000000 },
	{ .addr = 0x0f00042f4, .val = 0x00000000 },
	{ .addr = 0x0f00042f8, .val = 0x00000000 },
	{ .addr = 0x0f00042fc, .val = 0x00000000 },
	{ .addr = 0x0f0004300, .val = 0x00000000 },
	{ .addr = 0x0f0004304, .val = 0x00000000 },
	{ .addr = 0x0f0004308, .val = 0x00000000 },
	{ .addr = 0x0f000430c, .val = 0x00000000 },
	{ .addr = 0x0f0004310, .val = 0x00000000 },
	{ .addr = 0x0f0004314, .val = 0x00000000 },
	{ .addr = 0x0f0004318, .val = 0x00000000 },
	{ .addr = 0x0f000431c, .val = 0x00000000 },
	{ .addr = 0x0f0004320, .val = 0x00000000 },
	{ .addr = 0x0f0004324, .val = 0x00000000 },
	{ .addr = 0x0f0004328, .val = 0x00000000 },
	{ .addr = 0x0f000432c, .val = 0x00000000 },
	{ .addr = 0x0f0004330, .val = 0x00000000 },
	{ .addr = 0x0f0004334, .val = 0x00000000 },
	{ .addr = 0x0f0004338, .val = 0x00000000 },
	{ .addr = 0x0f000433c, .val = 0x00000000 },
	{ .addr = 0x0f0004340, .val = 0x00000000 },
	{ .addr = 0x0f0004344, .val = 0x00000000 },
	{ .addr = 0x0f0004348, .val = 0x00000000 },
	{ .addr = 0x0f000434c, .val = 0x00000000 },
	{ .addr = 0x0f0004350, .val = 0x00000000 },
	{ .addr = 0x0f0004354, .val = 0x00000000 },
	{ .addr = 0x0f0004358, .val = 0x00000000 },
	{ .addr = 0x0f000435c, .val = 0x00000000 },
	{ .addr = 0x0f0004360, .val = 0x00000000 },
	{ .addr = 0x0f0004364, .val = 0x00000000 },
	{ .addr = 0x0f0004368, .val = 0x00000000 },
	{ .addr = 0x0f000436c, .val = 0x00000000 },
	{ .addr = 0x0f0004370, .val = 0x00000000 },
	{ .addr = 0x0f0004374, .val = 0x00000000 },
	{ .addr = 0x0f0004378, .val = 0x00000000 },
	{ .addr = 0x0f000437c, .val = 0x00000000 },
	{ .addr = 0x0f0004380, .val = 0x00000000 },
	{ .addr = 0x0f0004384, .val = 0x00000000 },
	{ .addr = 0x0f0004388, .val = 0x00000000 },
	{ .addr = 0x0f000438c, .val = 0x00000000 },
	{ .addr = 0x0f0004390, .val = 0x00000000 },
	{ .addr = 0x0f0004394, .val = 0x00000000 },
	{ .addr = 0x0f0004398, .val = 0x00000000 },
	{ .addr = 0x0f000439c, .val = 0x00000000 },
	{ .addr = 0x0f00043a0, .val = 0x00000000 },
	{ .addr = 0x0f00043a4, .val = 0x00000000 },
	{ .addr = 0x0f00043a8, .val = 0x00000000 },
	{ .addr = 0x0f00043ac, .val = 0x00000000 },
	{ .addr = 0x0f00043b0, .val = 0x00000000 },
	{ .addr = 0x0f00043b4, .val = 0x00000000 },
	{ .addr = 0x0f00043b8, .val = 0x00000000 },
	{ .addr = 0x0f00043bc, .val = 0x00000000 },
	{ .addr = 0x0f00043c0, .val = 0x00000000 },
	{ .addr = 0x0f00043c4, .val = 0x00000000 },
	{ .addr = 0x0f00043c8, .val = 0x00000000 },
	{ .addr = 0x0f00043cc, .val = 0x00000000 },
	{ .addr = 0x0f00043d0, .val = 0x00000000 },
	{ .addr = 0x0f00043d4, .val = 0x00000000 },
	{ .addr = 0x0f00043d8, .val = 0x00000000 },
	{ .addr = 0x0f00043dc, .val = 0x00000000 },
	{ .addr = 0x0f00043e0, .val = 0x00000000 },
	{ .addr = 0x0f00043e4, .val = 0x00000000 },
	{ .addr = 0x0f00043e8, .val = 0x00000000 },
	{ .addr = 0x0f00043ec, .val = 0x00000000 },
	{ .addr = 0x0f00043f0, .val = 0x00000000 },
	{ .addr = 0x0f00043f4, .val = 0x00000000 },
	{ .addr = 0x0f00043f8, .val = 0x00000000 },
	{ .addr = 0x0f00043fc, .val = 0x00000000 },
	{ .addr = 0x0f0004400, .val = 0x00000000 },
	{ .addr = 0x0f0004404, .val = 0x00000000 },
	{ .addr = 0x0f0004408, .val = 0x00000000 },
	{ .addr = 0x0f000440c, .val = 0x00000000 },
	{ .addr = 0x0f0004410, .val = 0x00000000 },
	{ .addr = 0x0f0004414, .val = 0x00000000 },
	{ .addr = 0x0f0004418, .val = 0x00000000 },
	{ .addr = 0x0f000441c, .val = 0x00000000 },
	{ .addr = 0x0f0004420, .val = 0x00000000 },
	{ .addr = 0x0f0004424, .val = 0x00000000 },
	{ .addr = 0x0f0004428, .val = 0x00000000 },
	{ .addr = 0x0f000442c, .val = 0x00000000 },
	{ .addr = 0x0f0004430, .val = 0x00000000 },
	{ .addr = 0x0f0004434, .val = 0x00000000 },
	{ .addr = 0x0f0004438, .val = 0x00000000 },
	{ .addr = 0x0f000443c, .val = 0x00000000 },
	{ .addr = 0x0f0004440, .val = 0x00000000 },
	{ .addr = 0x0f0004444, .val = 0x00000000 },
	{ .addr = 0x0f0004448, .val = 0x00000000 },
	{ .addr = 0x0f000444c, .val = 0x00000000 },
	{ .addr = 0x0f0004450, .val = 0x00000000 },
	{ .addr = 0x0f0004454, .val = 0x00000000 },
	{ .addr = 0x0f0004458, .val = 0x00000000 },
	{ .addr = 0x0f000445c, .val = 0x00000000 },
	{ .addr = 0x0f0004460, .val = 0x00000000 },
	{ .addr = 0x0f0004464, .val = 0x00000000 },
	{ .addr = 0x0f0004468, .val = 0x00000000 },
	{ .addr = 0x0f000446c, .val = 0x00000000 },
	{ .addr = 0x0f0004470, .val = 0x00000000 },
	{ .addr = 0x0f0004474, .val = 0x00000000 },
	{ .addr = 0x0f0004478, .val = 0x00000000 },
	{ .addr = 0x0f000447c, .val = 0x00000000 },
	{ .addr = 0x0f0004500, .val = 0x00000000 },
	{ .addr = 0x0f0004504, .val = 0x00000000 },
	{ .addr = 0x0f0004508, .val = 0x00000000 },
	{ .addr = 0x0f000450c, .val = 0x00000000 },
	{ .addr = 0x0f0004510, .val = 0x00000000 },
	{ .addr = 0x0f0004514, .val = 0x00000000 },
	{ .addr = 0x0f0004518, .val = 0x00000000 },
	{ .addr = 0x0f000451c, .val = 0x00000000 },
	{ .addr = 0x0f0004520, .val = 0x00000000 },
	{ .addr = 0x0f0004524, .val = 0x00000000 },
	{ .addr = 0x0f0004528, .val = 0x00000000 },
	{ .addr = 0x0f000452c, .val = 0x00000000 },
	{ .addr = 0x0f0004530, .val = 0x00000000 },
	{ .addr = 0x0f0004534, .val = 0x00000000 },
	{ .addr = 0x0f0004538, .val = 0x00000000 },
	{ .addr = 0x0f000453c, .val = 0x00000000 },
	{ .addr = 0x0f0004540, .val = 0x00000000 },
	{ .addr = 0x0f0004544, .val = 0x00000000 },
	{ .addr = 0x0f0004548, .val = 0x00000000 },
	{ .addr = 0x0f000454c, .val = 0x00000000 },
	{ .addr = 0x0f0004550, .val = 0x00000000 },
	{ .addr = 0x0f0004554, .val = 0x00000000 },
	{ .addr = 0x0f0004558, .val = 0x00000000 },
	{ .addr = 0x0f000455c, .val = 0x00000000 },
	{ .addr = 0x0f0004560, .val = 0x00000000 },
	{ .addr = 0x0f0004564, .val = 0x00000000 },
	{ .addr = 0x0f0004568, .val = 0x00000000 },
	{ .addr = 0x0f000456c, .val = 0x00000000 },
	{ .addr = 0x0f0004570, .val = 0x00000000 },
	{ .addr = 0x0f0004574, .val = 0x00000000 },
	{ .addr = 0x0f0004578, .val = 0x00000000 },
	{ .addr = 0x0f000457c, .val = 0x00000000 },
	{ .addr = 0x0f0004580, .val = 0x00000000 },
	{ .addr = 0x0f0004584, .val = 0x00000000 },
	{ .addr = 0x0f0004588, .val = 0x00000000 },
	{ .addr = 0x0f000458c, .val = 0x00000000 },
	{ .addr = 0x0f0004590, .val = 0x00000000 },
	{ .addr = 0x0f0004594, .val = 0x00000000 },
	{ .addr = 0x0f0004598, .val = 0x00000000 },
	{ .addr = 0x0f000459c, .val = 0x00000000 },
	{ .addr = 0x0f00045a0, .val = 0x00000000 },
	{ .addr = 0x0f00045a4, .val = 0x00000000 },
	{ .addr = 0x0f00045a8, .val = 0x00000000 },
	{ .addr = 0x0f00045ac, .val = 0x00000000 },
	{ .addr = 0x0f00045b0, .val = 0x00000000 },
	{ .addr = 0x0f00045b4, .val = 0x00000000 },
	{ .addr = 0x0f00045b8, .val = 0x00000000 },
	{ .addr = 0x0f00045bc, .val = 0x00000000 },
	{ .addr = 0x0f00045c0, .val = 0x00000000 },
	{ .addr = 0x0f00045c4, .val = 0x00000000 },
	{ .addr = 0x0f00045c8, .val = 0x00000000 },
	{ .addr = 0x0f00045cc, .val = 0x00000000 },
	{ .addr = 0x0f00045d0, .val = 0x00000000 },
	{ .addr = 0x0f00045d4, .val = 0x00000000 },
	{ .addr = 0x0f00045d8, .val = 0x00000000 },
	{ .addr = 0x0f00045dc, .val = 0x00000000 },
	{ .addr = 0x0f00045e0, .val = 0x00000000 },
	{ .addr = 0x0f00045e4, .val = 0x00000000 },
	{ .addr = 0x0f00045e8, .val = 0x00000000 },
	{ .addr = 0x0f00045ec, .val = 0x00000000 },
	{ .addr = 0x0f00045f0, .val = 0x00000000 },
	{ .addr = 0x0f00045f4, .val = 0x00000000 },
	{ .addr = 0x0f00045f8, .val = 0x00000000 },
	{ .addr = 0x0f00045fc, .val = 0x00000000 },
	{ .addr = 0x0f0004600, .val = 0x00000000 },
	{ .addr = 0x0f0004604, .val = 0x00000000 },
	{ .addr = 0x0f0004608, .val = 0x00000000 },
	{ .addr = 0x0f000460c, .val = 0x00000000 },
	{ .addr = 0x0f0004610, .val = 0x00000000 },
	{ .addr = 0x0f0004614, .val = 0x00000000 },
	{ .addr = 0x0f0004618, .val = 0x00000000 },
	{ .addr = 0x0f000461c, .val = 0x00000000 },
	{ .addr = 0x0f0004620, .val = 0x00000000 },
	{ .addr = 0x0f0004624, .val = 0x00000000 },
	{ .addr = 0x0f0004628, .val = 0x00000000 },
	{ .addr = 0x0f000462c, .val = 0x00000000 },
	{ .addr = 0x0f0004630, .val = 0x00000000 },
	{ .addr = 0x0f0004634, .val = 0x00000000 },
	{ .addr = 0x0f0004638, .val = 0x00000000 },
	{ .addr = 0x0f000463c, .val = 0x00000000 },
	{ .addr = 0x0f0004640, .val = 0x00000000 },
	{ .addr = 0x0f0004644, .val = 0x00000000 },
	{ .addr = 0x0f0004648, .val = 0x00000000 },
	{ .addr = 0x0f000464c, .val = 0x00000000 },
	{ .addr = 0x0f0004650, .val = 0x00000000 },
	{ .addr = 0x0f0004654, .val = 0x00000000 },
	{ .addr = 0x0f0004658, .val = 0x00000000 },
	{ .addr = 0x0f000465c, .val = 0x00000000 },
	{ .addr = 0x0f0004660, .val = 0x00000000 },
	{ .addr = 0x0f0004664, .val = 0x00000000 },
	{ .addr = 0x0f0004668, .val = 0x00000000 },
	{ .addr = 0x0f000466c, .val = 0x00000000 },
	{ .addr = 0x0f0004670, .val = 0x00000000 },
	{ .addr = 0x0f0004674, .val = 0x00000000 },
	{ .addr = 0x0f0004678, .val = 0x00000000 },
	{ .addr = 0x0f000467c, .val = 0x00000000 },
	{ .addr = 0x0f0004680, .val = 0x00000000 },
	{ .addr = 0x0f0004684, .val = 0x00000000 },
	{ .addr = 0x0f0004688, .val = 0x00000000 },
	{ .addr = 0x0f000468c, .val = 0x00000000 },
	{ .addr = 0x0f0004690, .val = 0x00000000 },
	{ .addr = 0x0f0004694, .val = 0x00000000 },
	{ .addr = 0x0f0004698, .val = 0x00000000 },
	{ .addr = 0x0f000469c, .val = 0x00000000 },
	{ .addr = 0x0f00046a0, .val = 0x00000000 },
	{ .addr = 0x0f00046a4, .val = 0x00000000 },
	{ .addr = 0x0f00046a8, .val = 0x00000000 },
	{ .addr = 0x0f00046ac, .val = 0x00000000 },
	{ .addr = 0x0f00046b0, .val = 0x00000000 },
	{ .addr = 0x0f00046b4, .val = 0x00000000 },
	{ .addr = 0x0f00046b8, .val = 0x00000000 },
	{ .addr = 0x0f00046bc, .val = 0x00000000 },
	{ .addr = 0x0f00046c0, .val = 0x00000000 },
	{ .addr = 0x0f00046c4, .val = 0x00000000 },
	{ .addr = 0x0f00046c8, .val = 0x00000000 },
	{ .addr = 0x0f00046cc, .val = 0x00000000 },
	{ .addr = 0x0f00046d0, .val = 0x00000000 },
	{ .addr = 0x0f00046d4, .val = 0x00000000 },
	{ .addr = 0x0f00046d8, .val = 0x00000000 },
	{ .addr = 0x0f00046dc, .val = 0x00000000 },
	{ .addr = 0x0f00046e0, .val = 0x00000000 },
	{ .addr = 0x0f00046e4, .val = 0x00000000 },
	{ .addr = 0x0f00046e8, .val = 0x00000000 },
	{ .addr = 0x0f00046ec, .val = 0x00000000 },
	{ .addr = 0x0f00046f0, .val = 0x00000000 },
	{ .addr = 0x0f00046f4, .val = 0x00000000 },
	{ .addr = 0x0f00046f8, .val = 0x00000000 },
	{ .addr = 0x0f00046fc, .val = 0x00000000 },
	{ .addr = 0x0f0004700, .val = 0x00000000 },
	{ .addr = 0x0f0004704, .val = 0x00000000 },
	{ .addr = 0x0f0004708, .val = 0x00000000 },
	{ .addr = 0x0f000470c, .val = 0x00000000 },
	{ .addr = 0x0f0004710, .val = 0x00000000 },
	{ .addr = 0x0f0004714, .val = 0x00000000 },
	{ .addr = 0x0f0004718, .val = 0x00000000 },
	{ .addr = 0x0f000471c, .val = 0x00000000 },
	{ .addr = 0x0f0004720, .val = 0x00000000 },
	{ .addr = 0x0f0004724, .val = 0x00000000 },
	{ .addr = 0x0f0004728, .val = 0x00000000 },
	{ .addr = 0x0f000472c, .val = 0x00000000 },
	{ .addr = 0x0f0004730, .val = 0x00000000 },
	{ .addr = 0x0f0004734, .val = 0x00000000 },
	{ .addr = 0x0f0004738, .val = 0x00000000 },
	{ .addr = 0x0f000473c, .val = 0x00000000 },
	{ .addr = 0x0f0004740, .val = 0x00000000 },
	{ .addr = 0x0f0004744, .val = 0x00000000 },
	{ .addr = 0x0f0004748, .val = 0x00000000 },
	{ .addr = 0x0f000474c, .val = 0x00000000 },
	{ .addr = 0x0f0004750, .val = 0x00000000 },
	{ .addr = 0x0f0004754, .val = 0x00000000 },
	{ .addr = 0x0f0004758, .val = 0x00000000 },
	{ .addr = 0x0f000475c, .val = 0x00000000 },
	{ .addr = 0x0f0004760, .val = 0x00000000 },
	{ .addr = 0x0f0004764, .val = 0x00000000 },
	{ .addr = 0x0f0004768, .val = 0x00000000 },
	{ .addr = 0x0f000476c, .val = 0x00000000 },
	{ .addr = 0x0f0004770, .val = 0x00000000 },
	{ .addr = 0x0f0004774, .val = 0x00000000 },
	{ .addr = 0x0f0004778, .val = 0x00000000 },
	{ .addr = 0x0f000477c, .val = 0x00000000 },
	{ .addr = 0x0f0004780, .val = 0x00000000 },
	{ .addr = 0x0f0004784, .val = 0x00000000 },
	{ .addr = 0x0f0004788, .val = 0x00000000 },
	{ .addr = 0x0f000478c, .val = 0x00000000 },
	{ .addr = 0x0f0004790, .val = 0x00000000 },
	{ .addr = 0x0f0004794, .val = 0x00000000 },
	{ .addr = 0x0f0004798, .val = 0x00000000 },
	{ .addr = 0x0f000479c, .val = 0x00000000 },
	{ .addr = 0x0f00047a0, .val = 0x00000000 },
	{ .addr = 0x0f00047a4, .val = 0x00000000 },
	{ .addr = 0x0f00047a8, .val = 0x00000000 },
	{ .addr = 0x0f00047ac, .val = 0x00000000 },
	{ .addr = 0x0f00047b0, .val = 0x00000000 },
	{ .addr = 0x0f00047b4, .val = 0x00000000 },
	{ .addr = 0x0f00047b8, .val = 0x00000000 },
	{ .addr = 0x0f00047bc, .val = 0x00000000 },
	{ .addr = 0x0f00047c0, .val = 0x00000000 },
	{ .addr = 0x0f00047c4, .val = 0x00000000 },
	{ .addr = 0x0f00047c8, .val = 0x00000000 },
	{ .addr = 0x0f00047cc, .val = 0x00000000 },
	{ .addr = 0x0f00047d0, .val = 0x00000000 },
	{ .addr = 0x0f00047d4, .val = 0x00000000 },
	{ .addr = 0x0f00047d8, .val = 0x00000000 },
	{ .addr = 0x0f00047dc, .val = 0x00000000 },
	{ .addr = 0x0f00047e0, .val = 0x00000000 },
	{ .addr = 0x0f00047e4, .val = 0x00000000 },
	{ .addr = 0x0f00047e8, .val = 0x00000000 },
	{ .addr = 0x0f00047ec, .val = 0x00000000 },
	{ .addr = 0x0f00047f0, .val = 0x00000000 },
	{ .addr = 0x0f00047f4, .val = 0x00000000 },
	{ .addr = 0x0f00047f8, .val = 0x00000000 },
	{ .addr = 0x0f00047fc, .val = 0x00000000 },
	{ .addr = 0x0f0004800, .val = 0x00000000 },
	{ .addr = 0x0f0004804, .val = 0x00000000 },
	{ .addr = 0x0f0004808, .val = 0x00000000 },
	{ .addr = 0x0f000480c, .val = 0x00000000 },
	{ .addr = 0x0f0004810, .val = 0x00000000 },
	{ .addr = 0x0f0004814, .val = 0x00000000 },
	{ .addr = 0x0f0004818, .val = 0x00000000 },
	{ .addr = 0x0f000481c, .val = 0x00000000 },
	{ .addr = 0x0f0004820, .val = 0x00000000 },
	{ .addr = 0x0f0004824, .val = 0x00000000 },
	{ .addr = 0x0f0004828, .val = 0x00000000 },
	{ .addr = 0x0f000482c, .val = 0x00000000 },
	{ .addr = 0x0f0004830, .val = 0x00000000 },
	{ .addr = 0x0f0004834, .val = 0x00000000 },
	{ .addr = 0x0f0004838, .val = 0x00000000 },
	{ .addr = 0x0f000483c, .val = 0x00000000 },
	{ .addr = 0x0f0004840, .val = 0x00000000 },
	{ .addr = 0x0f0004844, .val = 0x00000000 },
	{ .addr = 0x0f0004848, .val = 0x00000000 },
	{ .addr = 0x0f000484c, .val = 0x00000000 },
	{ .addr = 0x0f0004850, .val = 0x00000000 },
	{ .addr = 0x0f0004854, .val = 0x00000000 },
	{ .addr = 0x0f0004858, .val = 0x00000000 },
	{ .addr = 0x0f000485c, .val = 0x00000000 },
	{ .addr = 0x0f0004860, .val = 0x00000000 },
	{ .addr = 0x0f0004864, .val = 0x00000000 },
	{ .addr = 0x0f0004868, .val = 0x00000000 },
	{ .addr = 0x0f000486c, .val = 0x00000000 },
	{ .addr = 0x0f0004870, .val = 0x00000000 },
	{ .addr = 0x0f0004874, .val = 0x00000000 },
	{ .addr = 0x0f0004878, .val = 0x00000000 },
	{ .addr = 0x0f000487c, .val = 0x00000000 },
	{ .addr = 0x0f0004880, .val = 0x00000000 },
	{ .addr = 0x0f0004884, .val = 0x00000000 },
	{ .addr = 0x0f0004888, .val = 0x00000000 },
	{ .addr = 0x0f000488c, .val = 0x00000000 },
	{ .addr = 0x0f0004890, .val = 0x00000000 },
	{ .addr = 0x0f0004894, .val = 0x00000000 },
	{ .addr = 0x0f0004898, .val = 0x00000000 },
	{ .addr = 0x0f000489c, .val = 0x00000000 },
	{ .addr = 0x0f00048a0, .val = 0x00000000 },
	{ .addr = 0x0f00048a4, .val = 0x00000000 },
	{ .addr = 0x0f00048a8, .val = 0x00000000 },
	{ .addr = 0x0f00048ac, .val = 0x00000000 },
	{ .addr = 0x0f00048b0, .val = 0x00000000 },
	{ .addr = 0x0f00048b4, .val = 0x00000000 },
	{ .addr = 0x0f00048b8, .val = 0x00000000 },
	{ .addr = 0x0f00048bc, .val = 0x00000000 },
	{ .addr = 0x0f00048c0, .val = 0x00000000 },
	{ .addr = 0x0f00048c4, .val = 0x00000000 },
	{ .addr = 0x0f00048c8, .val = 0x00000000 },
	{ .addr = 0x0f00048cc, .val = 0x00000000 },
	{ .addr = 0x0f00048d0, .val = 0x00000000 },
	{ .addr = 0x0f00048d4, .val = 0x00000000 },
	{ .addr = 0x0f00048d8, .val = 0x00000000 },
	{ .addr = 0x0f00048dc, .val = 0x00000000 },
	{ .addr = 0x0f00048e0, .val = 0x00000000 },
	{ .addr = 0x0f00048e4, .val = 0x00000000 },
	{ .addr = 0x0f00048e8, .val = 0x00000000 },
	{ .addr = 0x0f00048ec, .val = 0x00000000 },
	{ .addr = 0x0f00048f0, .val = 0x00000000 },
	{ .addr = 0x0f00048f4, .val = 0x00000000 },
	{ .addr = 0x0f00048f8, .val = 0x00000000 },
	{ .addr = 0x0f00048fc, .val = 0x00000000 },
	{ .addr = 0x0f0004900, .val = 0x00000000 },
	{ .addr = 0x0f0004904, .val = 0x00000000 },
	{ .addr = 0x0f0004908, .val = 0x00000000 },
	{ .addr = 0x0f000490c, .val = 0x00000000 },
	{ .addr = 0x0f0004910, .val = 0x00000000 },
	{ .addr = 0x0f0004914, .val = 0x00000000 },
	{ .addr = 0x0f0004918, .val = 0x00000000 },
	{ .addr = 0x0f000491c, .val = 0x00000000 },
	{ .addr = 0x0f0004920, .val = 0x00000000 },
	{ .addr = 0x0f0004924, .val = 0x00000000 },
	{ .addr = 0x0f0004928, .val = 0x00000000 },
	{ .addr = 0x0f000492c, .val = 0x00000000 },
	{ .addr = 0x0f0004930, .val = 0x00000000 },
	{ .addr = 0x0f0004934, .val = 0x00000000 },
	{ .addr = 0x0f0004938, .val = 0x00000000 },
	{ .addr = 0x0f000493c, .val = 0x00000000 },
	{ .addr = 0x0f0004940, .val = 0x00000000 },
	{ .addr = 0x0f0004944, .val = 0x00000000 },
	{ .addr = 0x0f0004948, .val = 0x00000000 },
	{ .addr = 0x0f000494c, .val = 0x00000000 },
	{ .addr = 0x0f0004950, .val = 0x00000000 },
	{ .addr = 0x0f0004954, .val = 0x00000000 },
	{ .addr = 0x0f0004958, .val = 0x00000000 },
	{ .addr = 0x0f000495c, .val = 0x00000000 },
	{ .addr = 0x0f0004960, .val = 0x00000000 },
	{ .addr = 0x0f0004964, .val = 0x00000000 },
	{ .addr = 0x0f0004968, .val = 0x00000000 },
	{ .addr = 0x0f000496c, .val = 0x00000000 },
	{ .addr = 0x0f0004970, .val = 0x00000000 },
	{ .addr = 0x0f0004974, .val = 0x00000000 },
	{ .addr = 0x0f0004978, .val = 0x00000000 },
	{ .addr = 0x0f000497c, .val = 0x00000000 },
	{ .addr = 0x0f0004980, .val = 0x00000000 },
	{ .addr = 0x0f0004984, .val = 0x00000000 },
	{ .addr = 0x0f0004988, .val = 0x00000000 },
	{ .addr = 0x0f000498c, .val = 0x00000000 },
	{ .addr = 0x0f0004990, .val = 0x00000000 },
	{ .addr = 0x0f0004994, .val = 0x00000000 },
	{ .addr = 0x0f0004998, .val = 0x00000000 },
	{ .addr = 0x0f000499c, .val = 0x00000000 },
	{ .addr = 0x0f00049a0, .val = 0x00000000 },
	{ .addr = 0x0f00049a4, .val = 0x00000000 },
	{ .addr = 0x0f00049a8, .val = 0x00000000 },
	{ .addr = 0x0f00049ac, .val = 0x00000000 },
	{ .addr = 0x0f00049b0, .val = 0x00000000 },
	{ .addr = 0x0f00049b4, .val = 0x00000000 },
	{ .addr = 0x0f00049b8, .val = 0x00000000 },
	{ .addr = 0x0f00049bc, .val = 0x00000000 },
	{ .addr = 0x0f00049c0, .val = 0x00000000 },
	{ .addr = 0x0f00049c4, .val = 0x00000000 },
	{ .addr = 0x0f00049c8, .val = 0x00000000 },
	{ .addr = 0x0f00049cc, .val = 0x00000000 },
	{ .addr = 0x0f00049d0, .val = 0x00000000 },
	{ .addr = 0x0f00049d4, .val = 0x00000000 },
	{ .addr = 0x0f00049d8, .val = 0x00000000 },
	{ .addr = 0x0f00049dc, .val = 0x00000000 },
	{ .addr = 0x0f00049e0, .val = 0x00000000 },
	{ .addr = 0x0f00049e4, .val = 0x00000000 },
	{ .addr = 0x0f00049e8, .val = 0x00000000 },
	{ .addr = 0x0f00049ec, .val = 0x00000000 },
	{ .addr = 0x0f00049f0, .val = 0x00000000 },
	{ .addr = 0x0f00049f4, .val = 0x00000000 },
	{ .addr = 0x0f00049f8, .val = 0x00000000 },
	{ .addr = 0x0f00049fc, .val = 0x00000000 },
	{ .addr = 0x0f0004a00, .val = 0x00000000 },
	{ .addr = 0x0f0004a04, .val = 0x00000000 },
	{ .addr = 0x0f0004a08, .val = 0x00000000 },
	{ .addr = 0x0f0004a0c, .val = 0x00000000 },
	{ .addr = 0x0f0004a10, .val = 0x00000000 },
	{ .addr = 0x0f0004a14, .val = 0x00000000 },
	{ .addr = 0x0f0004a18, .val = 0x00000000 },
	{ .addr = 0x0f0004a1c, .val = 0x00000000 },
	{ .addr = 0x0f0004a20, .val = 0x00000000 },
	{ .addr = 0x0f0004a24, .val = 0x00000000 },
	{ .addr = 0x0f0004a28, .val = 0x00000000 },
	{ .addr = 0x0f0004a2c, .val = 0x00000000 },
	{ .addr = 0x0f0004a30, .val = 0x00000000 },
	{ .addr = 0x0f0004a34, .val = 0x00000000 },
	{ .addr = 0x0f0004a38, .val = 0x00000000 },
	{ .addr = 0x0f0004a3c, .val = 0x00000000 },
	{ .addr = 0x0f0004a40, .val = 0x00000000 },
	{ .addr = 0x0f0004a44, .val = 0x00000000 },
	{ .addr = 0x0f0004a48, .val = 0x00000000 },
	{ .addr = 0x0f0004a4c, .val = 0x00000000 },
	{ .addr = 0x0f0004a50, .val = 0x00000000 },
	{ .addr = 0x0f0004a54, .val = 0x00000000 },
	{ .addr = 0x0f0004a58, .val = 0x00000000 },
	{ .addr = 0x0f0004a5c, .val = 0x00000000 },
	{ .addr = 0x0f0004a60, .val = 0x00000000 },
	{ .addr = 0x0f0004a64, .val = 0x00000000 },
	{ .addr = 0x0f0004a68, .val = 0x00000000 },
	{ .addr = 0x0f0004a6c, .val = 0x00000000 },
	{ .addr = 0x0f0004a70, .val = 0x00000000 },
	{ .addr = 0x0f0004a74, .val = 0x00000000 },
	{ .addr = 0x0f0004a78, .val = 0x00000000 },
	{ .addr = 0x0f0004a7c, .val = 0x00000000 },
	{ .addr = 0x0f0004a80, .val = 0x00000000 },
	{ .addr = 0x0f0004a84, .val = 0x00000000 },
	{ .addr = 0x0f0004a88, .val = 0x00000000 },
	{ .addr = 0x0f0004a8c, .val = 0x00000000 },
	{ .addr = 0x0f0004a90, .val = 0x00000000 },
	{ .addr = 0x0f0004a94, .val = 0x00000000 },
	{ .addr = 0x0f0004a98, .val = 0x00000000 },
	{ .addr = 0x0f0004a9c, .val = 0x00000000 },
	{ .addr = 0x0f0004aa0, .val = 0x00000000 },
	{ .addr = 0x0f0004aa4, .val = 0x00000000 },
	{ .addr = 0x0f0004aa8, .val = 0x00000000 },
	{ .addr = 0x0f0004aac, .val = 0x00000000 },
	{ .addr = 0x0f0004ab0, .val = 0x00000000 },
	{ .addr = 0x0f0004ab4, .val = 0x00000000 },
	{ .addr = 0x0f0004ab8, .val = 0x00000000 },
	{ .addr = 0x0f0004abc, .val = 0x00000000 },
	{ .addr = 0x0f0004ac0, .val = 0x00000000 },
	{ .addr = 0x0f0004ac4, .val = 0x00000000 },
	{ .addr = 0x0f0004ac8, .val = 0x00000000 },
	{ .addr = 0x0f0004acc, .val = 0x00000000 },
	{ .addr = 0x0f0004ad0, .val = 0x00000000 },
	{ .addr = 0x0f0004ad4, .val = 0x00000000 },
	{ .addr = 0x0f0004ad8, .val = 0x00000000 },
	{ .addr = 0x0f0004adc, .val = 0x00000000 },
	{ .addr = 0x0f0004ae0, .val = 0x00000000 },
	{ .addr = 0x0f0004ae4, .val = 0x00000000 },
	{ .addr = 0x0f0004ae8, .val = 0x00000000 },
	{ .addr = 0x0f0004aec, .val = 0x00000000 },
	{ .addr = 0x0f0004af0, .val = 0x00000000 },
	{ .addr = 0x0f0004af4, .val = 0x00000000 },
	{ .addr = 0x0f0004af8, .val = 0x00000000 },
	{ .addr = 0x0f0004afc, .val = 0x00000000 },
	{ .addr = 0x0f0004b00, .val = 0x00000000 },
	{ .addr = 0x0f0004b04, .val = 0x00000000 },
	{ .addr = 0x0f0004b08, .val = 0x00000000 },
	{ .addr = 0x0f0004b0c, .val = 0x00000000 },
	{ .addr = 0x0f0004b10, .val = 0x00000000 },
	{ .addr = 0x0f0004b14, .val = 0x00000000 },
	{ .addr = 0x0f0004b18, .val = 0x00000000 },
	{ .addr = 0x0f0004b1c, .val = 0x00000000 },
	{ .addr = 0x0f0004b20, .val = 0x00000000 },
	{ .addr = 0x0f0004b24, .val = 0x00000000 },
	{ .addr = 0x0f0004b28, .val = 0x00000000 },
	{ .addr = 0x0f0004b2c, .val = 0x00000000 },
	{ .addr = 0x0f0004b30, .val = 0x00000000 },
	{ .addr = 0x0f0004b34, .val = 0x00000000 },
	{ .addr = 0x0f0004b38, .val = 0x00000000 },
	{ .addr = 0x0f0004b3c, .val = 0x00000000 },
	{ .addr = 0x0f0004b40, .val = 0x00000000 },
	{ .addr = 0x0f0004b44, .val = 0x00000000 },
	{ .addr = 0x0f0004b48, .val = 0x00000000 },
	{ .addr = 0x0f0004b4c, .val = 0x00000000 },
	{ .addr = 0x0f0004b50, .val = 0x00000000 },
	{ .addr = 0x0f0004b54, .val = 0x00000000 },
	{ .addr = 0x0f0004b58, .val = 0x00000000 },
	{ .addr = 0x0f0004b5c, .val = 0x00000000 },
	{ .addr = 0x0f0004b60, .val = 0x00000000 },
	{ .addr = 0x0f0004b64, .val = 0x00000000 },
	{ .addr = 0x0f0004b68, .val = 0x00000000 },
	{ .addr = 0x0f0004b6c, .val = 0x00000000 },
	{ .addr = 0x0f0004b70, .val = 0x00000000 },
	{ .addr = 0x0f0004b74, .val = 0x00000000 },
	{ .addr = 0x0f0004b78, .val = 0x00000000 },
	{ .addr = 0x0f0004b7c, .val = 0x00000000 },
	{ .addr = 0x0f0004b80, .val = 0x00000000 },
	{ .addr = 0x0f0004b84, .val = 0x00000000 },
	{ .addr = 0x0f0004b88, .val = 0x00000000 },
	{ .addr = 0x0f0004b8c, .val = 0x00000000 },
	{ .addr = 0x0f0004b90, .val = 0x00000000 },
	{ .addr = 0x0f0004b94, .val = 0x00000000 },
	{ .addr = 0x0f0004b98, .val = 0x00000000 },
	{ .addr = 0x0f0004b9c, .val = 0x00000000 },
	{ .addr = 0x0f0004ba0, .val = 0x00000000 },
	{ .addr = 0x0f0004ba4, .val = 0x00000000 },
	{ .addr = 0x0f0004ba8, .val = 0x00000000 },
	{ .addr = 0x0f0004bac, .val = 0x00000000 },
	{ .addr = 0x0f0004bb0, .val = 0x00000000 },
	{ .addr = 0x0f0004bb4, .val = 0x00000000 },
	{ .addr = 0x0f0004bb8, .val = 0x00000000 },
	{ .addr = 0x0f0004bbc, .val = 0x00000000 },
	{ .addr = 0x0f0004bc0, .val = 0x00000000 },
	{ .addr = 0x0f0004bc4, .val = 0x00000000 },
	{ .addr = 0x0f0004bc8, .val = 0x00000000 },
	{ .addr = 0x0f0004bcc, .val = 0x00000000 },
	{ .addr = 0x0f0004bd0, .val = 0x00000000 },
	{ .addr = 0x0f0004bd4, .val = 0x00000000 },
	{ .addr = 0x0f0004bd8, .val = 0x00000000 },
	{ .addr = 0x0f0004bdc, .val = 0x00000000 },
	{ .addr = 0x0f0004be0, .val = 0x00000000 },
	{ .addr = 0x0f0004be4, .val = 0x00000000 },
	{ .addr = 0x0f0004be8, .val = 0x00000000 },
	{ .addr = 0x0f0004bec, .val = 0x00000000 },
	{ .addr = 0x0f0004bf0, .val = 0x00000000 },
	{ .addr = 0x0f0004bf4, .val = 0x00000000 },
	{ .addr = 0x0f0004bf8, .val = 0x00000000 },
	{ .addr = 0x0f0004bfc, .val = 0x00000000 },
	{ .addr = 0x0f0004c00, .val = 0x00000000 },
	{ .addr = 0x0f0004c04, .val = 0x00000000 },
	{ .addr = 0x0f0004c08, .val = 0x00000000 },
	{ .addr = 0x0f0004c0c, .val = 0x00000000 },
	{ .addr = 0x0f0004c10, .val = 0x00000000 },
	{ .addr = 0x0f0004c14, .val = 0x00000000 },
	{ .addr = 0x0f0004c18, .val = 0x00000000 },
	{ .addr = 0x0f0004c1c, .val = 0x00000000 },
	{ .addr = 0x0f0004c20, .val = 0x00000000 },
	{ .addr = 0x0f0004c24, .val = 0x00000000 },
	{ .addr = 0x0f0004c28, .val = 0x00000000 },
	{ .addr = 0x0f0004c2c, .val = 0x00000000 },
	{ .addr = 0x0f0004c30, .val = 0x00000000 },
	{ .addr = 0x0f0004c34, .val = 0x00000000 },
	{ .addr = 0x0f0004c38, .val = 0x00000000 },
	{ .addr = 0x0f0004c3c, .val = 0x00000000 },
	{ .addr = 0x0f0004c40, .val = 0x00000000 },
	{ .addr = 0x0f0004c44, .val = 0x00000000 },
	{ .addr = 0x0f0004c48, .val = 0x00000000 },
	{ .addr = 0x0f0004c4c, .val = 0x00000000 },
	{ .addr = 0x0f0004c50, .val = 0x00000000 },
	{ .addr = 0x0f0004c54, .val = 0x00000000 },
	{ .addr = 0x0f0004c58, .val = 0x00000000 },
	{ .addr = 0x0f0004c5c, .val = 0x00000000 },
	{ .addr = 0x0f0004c60, .val = 0x00000000 },
	{ .addr = 0x0f0004c64, .val = 0x00000000 },
	{ .addr = 0x0f0004c68, .val = 0x00000000 },
	{ .addr = 0x0f0004c6c, .val = 0x00000000 },
	{ .addr = 0x0f0004c70, .val = 0x00000000 },
	{ .addr = 0x0f0004c74, .val = 0x00000000 },
	{ .addr = 0x0f0004c78, .val = 0x00000000 },
	{ .addr = 0x0f0004c7c, .val = 0x00000000 },
	{ .addr = 0x0f0004c80, .val = 0x00000000 },
	{ .addr = 0x0f0004c84, .val = 0x00000000 },
	{ .addr = 0x0f0004c88, .val = 0x00000000 },
	{ .addr = 0x0f0004c8c, .val = 0x00000000 },
	{ .addr = 0x0f0004c90, .val = 0x00000000 },
	{ .addr = 0x0f0004c94, .val = 0x00000000 },
	{ .addr = 0x0f0004c98, .val = 0x00000000 },
	{ .addr = 0x0f0004c9c, .val = 0x00000000 },
	{ .addr = 0x0f0004ca0, .val = 0x00000000 },
	{ .addr = 0x0f0004ca4, .val = 0x00000000 },
	{ .addr = 0x0f0004ca8, .val = 0x00000000 },
	{ .addr = 0x0f0004cac, .val = 0x00000000 },
	{ .addr = 0x0f0004cb0, .val = 0x00000000 },
	{ .addr = 0x0f0004cb4, .val = 0x00000000 },
	{ .addr = 0x0f0004cb8, .val = 0x00000000 },
	{ .addr = 0x0f0004cbc, .val = 0x00000000 },
	{ .addr = 0x0f0004cc0, .val = 0x00000000 },
	{ .addr = 0x0f0004cc4, .val = 0x00000000 },
	{ .addr = 0x0f0004cc8, .val = 0x00000000 },
	{ .addr = 0x0f0004ccc, .val = 0x00000000 },
	{ .addr = 0x0f0004cd0, .val = 0x00000000 },
	{ .addr = 0x0f0004cd4, .val = 0x00000000 },
	{ .addr = 0x0f0004cd8, .val = 0x00000000 },
	{ .addr = 0x0f0004cdc, .val = 0x00000000 },
	{ .addr = 0x0f0004ce0, .val = 0x00000000 },
	{ .addr = 0x0f0004ce4, .val = 0x00000000 },
	{ .addr = 0x0f0004ce8, .val = 0x00000000 },
	{ .addr = 0x0f0004cec, .val = 0x00000000 },
	{ .addr = 0x0f0004cf0, .val = 0x00000000 },
	{ .addr = 0x0f0004cf4, .val = 0x00000000 },
	{ .addr = 0x0f0004cf8, .val = 0x00000000 },
	{ .addr = 0x0f0004cfc, .val = 0x00000000 },
	{ .addr = 0x0f0004d00, .val = 0x00000000 },
	{ .addr = 0x0f0004d04, .val = 0x00000000 },
	{ .addr = 0x0f0004d08, .val = 0x00000000 },
	{ .addr = 0x0f0004d0c, .val = 0x00000000 },
	{ .addr = 0x0f0004d10, .val = 0x00000000 },
	{ .addr = 0x0f0004d14, .val = 0x00000000 },
	{ .addr = 0x0f0004d18, .val = 0x00000000 },
	{ .addr = 0x0f0004d1c, .val = 0x00000000 },
	{ .addr = 0x0f0004d20, .val = 0x00000000 },
	{ .addr = 0x0f0004d24, .val = 0x00000000 },
	{ .addr = 0x0f0004d28, .val = 0x00000000 },
	{ .addr = 0x0f0004d2c, .val = 0x00000000 },
	{ .addr = 0x0f0004d30, .val = 0x00000000 },
	{ .addr = 0x0f0004d34, .val = 0x00000000 },
	{ .addr = 0x0f0004d38, .val = 0x00000000 },
	{ .addr = 0x0f0004d3c, .val = 0x00000000 },
	{ .addr = 0x0f0004d40, .val = 0x00000000 },
	{ .addr = 0x0f0004d44, .val = 0x00000000 },
	{ .addr = 0x0f0004d48, .val = 0x00000000 },
	{ .addr = 0x0f0004d4c, .val = 0x00000000 },
	{ .addr = 0x0f0004d50, .val = 0x00000000 },
	{ .addr = 0x0f0004d54, .val = 0x00000000 },
	{ .addr = 0x0f0004d58, .val = 0x00000000 },
	{ .addr = 0x0f0004d5c, .val = 0x00000000 },
	{ .addr = 0x0f0004d60, .val = 0x00000000 },
	{ .addr = 0x0f0004d64, .val = 0x00000000 },
	{ .addr = 0x0f0004d68, .val = 0x00000000 },
	{ .addr = 0x0f0004d6c, .val = 0x00000000 },
	{ .addr = 0x0f0004d70, .val = 0x00000000 },
	{ .addr = 0x0f0004d74, .val = 0x00000000 },
	{ .addr = 0x0f0004d78, .val = 0x00000000 },
	{ .addr = 0x0f0004d7c, .val = 0x00000000 },
	{ .addr = 0x0f0004d80, .val = 0x00000000 },
	{ .addr = 0x0f0004d84, .val = 0x00000000 },
	{ .addr = 0x0f0004d88, .val = 0x00000000 },
	{ .addr = 0x0f0004d8c, .val = 0x00000000 },
	{ .addr = 0x0f0004d90, .val = 0x00000000 },
	{ .addr = 0x0f0004d94, .val = 0x00000000 },
	{ .addr = 0x0f0004d98, .val = 0x00000000 },
	{ .addr = 0x0f0004d9c, .val = 0x00000000 },
	{ .addr = 0x0f0004da0, .val = 0x00000000 },
	{ .addr = 0x0f0004da4, .val = 0x00000000 },
	{ .addr = 0x0f0004da8, .val = 0x00000000 },
	{ .addr = 0x0f0004dac, .val = 0x00000000 },
	{ .addr = 0x0f0004db0, .val = 0x00000000 },
	{ .addr = 0x0f0004db4, .val = 0x00000000 },
	{ .addr = 0x0f0004db8, .val = 0x00000000 },
	{ .addr = 0x0f0004dbc, .val = 0x00000000 },
	{ .addr = 0x0f0004dc0, .val = 0x00000000 },
	{ .addr = 0x0f0004dc4, .val = 0x00000000 },
	{ .addr = 0x0f0004dc8, .val = 0x00000000 },
	{ .addr = 0x0f0004dcc, .val = 0x00000000 },
	{ .addr = 0x0f0004dd0, .val = 0x00000000 },
	{ .addr = 0x0f0004dd4, .val = 0x00000000 },
	{ .addr = 0x0f0004dd8, .val = 0x00000000 },
	{ .addr = 0x0f0004ddc, .val = 0x00000000 },
	{ .addr = 0x0f0004de0, .val = 0x00000000 },
	{ .addr = 0x0f0004de4, .val = 0x00000000 },
	{ .addr = 0x0f0004de8, .val = 0x00000000 },
	{ .addr = 0x0f0004dec, .val = 0x00000000 },
	{ .addr = 0x0f0004df0, .val = 0x00000000 },
	{ .addr = 0x0f0004df4, .val = 0x00000000 },
	{ .addr = 0x0f0004df8, .val = 0x00000000 },
	{ .addr = 0x0f0004dfc, .val = 0x00000000 },
	{ .addr = 0x0f0004e00, .val = 0x00000000 },
	{ .addr = 0x0f0004e04, .val = 0x00000000 },
	{ .addr = 0x0f0004e08, .val = 0x00000000 },
	{ .addr = 0x0f0004e0c, .val = 0x00000000 },
	{ .addr = 0x0f0004e10, .val = 0x00000000 },
	{ .addr = 0x0f0004e14, .val = 0x00000000 },
	{ .addr = 0x0f0004e18, .val = 0x00000000 },
	{ .addr = 0x0f0004e1c, .val = 0x00000000 },
	{ .addr = 0x0f0004e20, .val = 0x00000000 },
	{ .addr = 0x0f0004e24, .val = 0x00000000 },
	{ .addr = 0x0f0004e28, .val = 0x00000000 },
	{ .addr = 0x0f0004e2c, .val = 0x00000000 },
	{ .addr = 0x0f0004e30, .val = 0x00000000 },
	{ .addr = 0x0f0004e34, .val = 0x00000000 },
	{ .addr = 0x0f0004e38, .val = 0x00000000 },
	{ .addr = 0x0f0004e3c, .val = 0x00000000 },
	{ .addr = 0x0f0004e40, .val = 0x00000000 },
	{ .addr = 0x0f0004e44, .val = 0x00000000 },
	{ .addr = 0x0f0004e48, .val = 0x00000000 },
	{ .addr = 0x0f0004e4c, .val = 0x00000000 },
	{ .addr = 0x0f0004e50, .val = 0x00000000 },
	{ .addr = 0x0f0004e54, .val = 0x00000000 },
	{ .addr = 0x0f0004e58, .val = 0x00000000 },
	{ .addr = 0x0f0004e5c, .val = 0x00000000 },
	{ .addr = 0x0f0004e60, .val = 0x00000000 },
	{ .addr = 0x0f0004e64, .val = 0x00000000 },
	{ .addr = 0x0f0004e68, .val = 0x00000000 },
	{ .addr = 0x0f0004e6c, .val = 0x00000000 },
	{ .addr = 0x0f0004e70, .val = 0x00000000 },
	{ .addr = 0x0f0004e74, .val = 0x00000000 },
	{ .addr = 0x0f0004e78, .val = 0x00000000 },
	{ .addr = 0x0f0004e7c, .val = 0x00000000 },
	{ .addr = 0x0f0004e80, .val = 0x00000000 },
	{ .addr = 0x0f0004e84, .val = 0x00000000 },
	{ .addr = 0x0f0004e88, .val = 0x00000000 },
	{ .addr = 0x0f0004e8c, .val = 0x00000000 },
	{ .addr = 0x0f0004e90, .val = 0x00000000 },
	{ .addr = 0x0f0004e94, .val = 0x00000000 },
	{ .addr = 0x0f0004e98, .val = 0x00000000 },
	{ .addr = 0x0f0004e9c, .val = 0x00000000 },
	{ .addr = 0x0f0004ea0, .val = 0x00000000 },
	{ .addr = 0x0f0004ea4, .val = 0x00000000 },
	{ .addr = 0x0f0004ea8, .val = 0x00000000 },
	{ .addr = 0x0f0004eac, .val = 0x00000000 },
	{ .addr = 0x0f0004eb0, .val = 0x00000000 },
	{ .addr = 0x0f0004eb4, .val = 0x00000000 },
	{ .addr = 0x0f0004eb8, .val = 0x00000000 },
	{ .addr = 0x0f0004ebc, .val = 0x00000000 },
	{ .addr = 0x0f0004ec0, .val = 0x00000000 },
	{ .addr = 0x0f0004ec4, .val = 0x00000000 },
	{ .addr = 0x0f0004ec8, .val = 0x00000000 },
	{ .addr = 0x0f0004ecc, .val = 0x00000000 },
	{ .addr = 0x0f0004ed0, .val = 0x00000000 },
	{ .addr = 0x0f0004ed4, .val = 0x00000000 },
	{ .addr = 0x0f0004ed8, .val = 0x00000000 },
	{ .addr = 0x0f0004edc, .val = 0x00000000 },
	{ .addr = 0x0f0004ee0, .val = 0x00000000 },
	{ .addr = 0x0f0004ee4, .val = 0x00000000 },
	{ .addr = 0x0f0004ee8, .val = 0x00000000 },
	{ .addr = 0x0f0004eec, .val = 0x00000000 },
	{ .addr = 0x0f0004ef0, .val = 0x00000000 },
	{ .addr = 0x0f0004ef4, .val = 0x00000000 },
	{ .addr = 0x0f0004ef8, .val = 0x00000000 },
	{ .addr = 0x0f0004efc, .val = 0x00000000 },
	{ .addr = 0x0f0004f00, .val = 0x00000000 },
	{ .addr = 0x0f0004f04, .val = 0x00000000 },
	{ .addr = 0x0f0004f08, .val = 0x00000000 },
	{ .addr = 0x0f0004f0c, .val = 0x00000000 },
	{ .addr = 0x0f0004f10, .val = 0x00000000 },
	{ .addr = 0x0f0004f14, .val = 0x00000000 },
	{ .addr = 0x0f0004f18, .val = 0x00000000 },
	{ .addr = 0x0f0004f1c, .val = 0x00000000 },
	{ .addr = 0x0f0004f20, .val = 0x00000000 },
	{ .addr = 0x0f0004f24, .val = 0x00000000 },
	{ .addr = 0x0f0004f28, .val = 0x00000000 },
	{ .addr = 0x0f0004f2c, .val = 0x00000000 },
	{ .addr = 0x0f0004f30, .val = 0x00000000 },
	{ .addr = 0x0f0004f34, .val = 0x00000000 },
	{ .addr = 0x0f0004f38, .val = 0x00000000 },
	{ .addr = 0x0f0004f3c, .val = 0x00000000 },
	{ .addr = 0x0f0004f40, .val = 0x00000000 },
	{ .addr = 0x0f0004f44, .val = 0x00000000 },
	{ .addr = 0x0f0004f48, .val = 0x00000000 },
	{ .addr = 0x0f0004f4c, .val = 0x00000000 },
	{ .addr = 0x0f0004f50, .val = 0x00000000 },
	{ .addr = 0x0f0004f54, .val = 0x00000000 },
	{ .addr = 0x0f0004f58, .val = 0x00000000 },
	{ .addr = 0x0f0004f5c, .val = 0x00000000 },
	{ .addr = 0x0f0004f60, .val = 0x00000000 },
	{ .addr = 0x0f0004f64, .val = 0x00000000 },
	{ .addr = 0x0f0004f68, .val = 0x00000000 },
	{ .addr = 0x0f0004f6c, .val = 0x00000000 },
	{ .addr = 0x0f0004f70, .val = 0x00000000 },
	{ .addr = 0x0f0004f74, .val = 0x00000000 },
	{ .addr = 0x0f0004f78, .val = 0x00000000 },
	{ .addr = 0x0f0004f7c, .val = 0x00000000 },
	{ .addr = 0x0f0004f80, .val = 0x00000000 },
	{ .addr = 0x0f0004f84, .val = 0x00000000 },
	{ .addr = 0x0f0004f88, .val = 0x00000000 },
	{ .addr = 0x0f0004f8c, .val = 0x00000000 },
	{ .addr = 0x0f0004f90, .val = 0x00000000 },
	{ .addr = 0x0f0004f94, .val = 0x00000000 },
	{ .addr = 0x0f0004f98, .val = 0x00000000 },
	{ .addr = 0x0f0004f9c, .val = 0x00000000 },
	{ .addr = 0x0f0004fa0, .val = 0x00000000 },
	{ .addr = 0x0f0004fa4, .val = 0x00000000 },
	{ .addr = 0x0f0004fa8, .val = 0x00000000 },
	{ .addr = 0x0f0004fac, .val = 0x00000000 },
	{ .addr = 0x0f0004fb0, .val = 0x00000000 },
	{ .addr = 0x0f0004fb4, .val = 0x00000000 },
	{ .addr = 0x0f0004fb8, .val = 0x00000000 },
	{ .addr = 0x0f0004fbc, .val = 0x00000000 },
	{ .addr = 0x0f0004fc0, .val = 0x00000000 },
	{ .addr = 0x0f0004fc4, .val = 0x00000000 },
	{ .addr = 0x0f0004fc8, .val = 0x00000000 },
	{ .addr = 0x0f0004fcc, .val = 0x00000000 },
	{ .addr = 0x0f0004fd0, .val = 0x00000000 },
	{ .addr = 0x0f0004fd4, .val = 0x00000000 },
	{ .addr = 0x0f0004fd8, .val = 0x00000000 },
	{ .addr = 0x0f0004fdc, .val = 0x00000000 },
	{ .addr = 0x0f0004fe0, .val = 0x00000000 },
	{ .addr = 0x0f0004fe4, .val = 0x00000000 },
	{ .addr = 0x0f0004fe8, .val = 0x00000000 },
	{ .addr = 0x0f0004fec, .val = 0x00000000 },
	{ .addr = 0x0f0004ff0, .val = 0x00000000 },
	{ .addr = 0x0f0004ff4, .val = 0x00000000 },
	{ .addr = 0x0f0004ff8, .val = 0x00000000 },
	{ .addr = 0x0f0004ffc, .val = 0x00000000 },
	{ .addr = 0x0f0005000, .val = 0x00000000 },
	{ .addr = 0x0f0005004, .val = 0x00000000 },
	{ .addr = 0x0f0005008, .val = 0x00000000 },
	{ .addr = 0x0f000500c, .val = 0x00000000 },
	{ .addr = 0x0f0005010, .val = 0x00000000 },
	{ .addr = 0x0f0005014, .val = 0x00000000 },
	{ .addr = 0x0f0005018, .val = 0x00000000 },
	{ .addr = 0x0f000501c, .val = 0x00000000 },
	{ .addr = 0x0f0005020, .val = 0x00000000 },
	{ .addr = 0x0f0005024, .val = 0x00000000 },
	{ .addr = 0x0f0005028, .val = 0x00000000 },
	{ .addr = 0x0f000502c, .val = 0x00000000 },
	{ .addr = 0x0f0005030, .val = 0x00000000 },
	{ .addr = 0x0f0005034, .val = 0x00000000 },
	{ .addr = 0x0f0005038, .val = 0x00000000 },
	{ .addr = 0x0f000503c, .val = 0x00000000 },
	{ .addr = 0x0f0005040, .val = 0x00000000 },
	{ .addr = 0x0f0005044, .val = 0x00000000 },
	{ .addr = 0x0f0005048, .val = 0x00000000 },
	{ .addr = 0x0f000504c, .val = 0x00000000 },
	{ .addr = 0x0f0005050, .val = 0x00000000 },
	{ .addr = 0x0f0005054, .val = 0x00000000 },
	{ .addr = 0x0f0005058, .val = 0x00000000 },
	{ .addr = 0x0f000505c, .val = 0x00000000 },
	{ .addr = 0x0f0005060, .val = 0x00000000 },
	{ .addr = 0x0f0005064, .val = 0x00000000 },
	{ .addr = 0x0f0005068, .val = 0x00000000 },
	{ .addr = 0x0f000506c, .val = 0x00000000 },
	{ .addr = 0x0f0005070, .val = 0x00000000 },
	{ .addr = 0x0f0005074, .val = 0x00000000 },
	{ .addr = 0x0f0005078, .val = 0x00000000 },
	{ .addr = 0x0f000507c, .val = 0x00000000 },
	{ .addr = 0x0f0005080, .val = 0x00000000 },
	{ .addr = 0x0f0005084, .val = 0x00000000 },
	{ .addr = 0x0f0005088, .val = 0x00000000 },
	{ .addr = 0x0f000508c, .val = 0x00000000 },
	{ .addr = 0x0f0005090, .val = 0x00000000 },
	{ .addr = 0x0f0005094, .val = 0x00000000 },
	{ .addr = 0x0f0005098, .val = 0x00000000 },
	{ .addr = 0x0f000509c, .val = 0x00000000 },
	{ .addr = 0x0f00050a0, .val = 0x00000000 },
	{ .addr = 0x0f00050a4, .val = 0x00000000 },
	{ .addr = 0x0f00050a8, .val = 0x00000000 },
	{ .addr = 0x0f00050ac, .val = 0x00000000 },
	{ .addr = 0x0f00050b0, .val = 0x00000000 },
	{ .addr = 0x0f00050b4, .val = 0x00000000 },
	{ .addr = 0x0f00050b8, .val = 0x00000000 },
	{ .addr = 0x0f00050bc, .val = 0x00000000 },
	{ .addr = 0x0f00050c0, .val = 0x00000000 },
	{ .addr = 0x0f00050c4, .val = 0x00000000 },
	{ .addr = 0x0f00050c8, .val = 0x00000000 },
	{ .addr = 0x0f00050cc, .val = 0x00000000 },
	{ .addr = 0x0f00050d0, .val = 0x00000000 },
	{ .addr = 0x0f00050d4, .val = 0x00000000 },
	{ .addr = 0x0f00050d8, .val = 0x00000000 },
	{ .addr = 0x0f00050dc, .val = 0x00000000 },
	{ .addr = 0x0f00050e0, .val = 0x00000000 },
	{ .addr = 0x0f00050e4, .val = 0x00000000 },
	{ .addr = 0x0f00050e8, .val = 0x00000000 },
	{ .addr = 0x0f00050ec, .val = 0x00000000 },
	{ .addr = 0x0f00050f0, .val = 0x00000000 },
	{ .addr = 0x0f00050f4, .val = 0x00000000 },
	{ .addr = 0x0f00050f8, .val = 0x00000000 },
	{ .addr = 0x0f00050fc, .val = 0x00000000 },
	{ .addr = 0x0f0005100, .val = 0x00000000 },
	{ .addr = 0x0f0005104, .val = 0x00000000 },
	{ .addr = 0x0f0005108, .val = 0x00000000 },
	{ .addr = 0x0f000510c, .val = 0x00000000 },
	{ .addr = 0x0f0005110, .val = 0x00000000 },
	{ .addr = 0x0f0005114, .val = 0x00000000 },
	{ .addr = 0x0f0005118, .val = 0x00000000 },
	{ .addr = 0x0f000511c, .val = 0x00000000 },
	{ .addr = 0x0f0005120, .val = 0x00000000 },
	{ .addr = 0x0f0005124, .val = 0x00000000 },
	{ .addr = 0x0f0005128, .val = 0x00000000 },
	{ .addr = 0x0f000512c, .val = 0x00000000 },
	{ .addr = 0x0f0005130, .val = 0x00000000 },
	{ .addr = 0x0f0005134, .val = 0x00000000 },
	{ .addr = 0x0f0005138, .val = 0x00000000 },
	{ .addr = 0x0f000513c, .val = 0x00000000 },
	{ .addr = 0x0f0005140, .val = 0x00000000 },
	{ .addr = 0x0f0005144, .val = 0x00000000 },
	{ .addr = 0x0f0005148, .val = 0x00000000 },
	{ .addr = 0x0f000514c, .val = 0x00000000 },
	{ .addr = 0x0f0005150, .val = 0x00000000 },
	{ .addr = 0x0f0005154, .val = 0x00000000 },
	{ .addr = 0x0f0005158, .val = 0x00000000 },
	{ .addr = 0x0f000515c, .val = 0x00000000 },
	{ .addr = 0x0f0005160, .val = 0x00000000 },
	{ .addr = 0x0f0005164, .val = 0x00000000 },
	{ .addr = 0x0f0005168, .val = 0x00000000 },
	{ .addr = 0x0f000516c, .val = 0x00000000 },
	{ .addr = 0x0f0005170, .val = 0x00000000 },
	{ .addr = 0x0f0005174, .val = 0x00000000 },
	{ .addr = 0x0f0005178, .val = 0x00000000 },
	{ .addr = 0x0f000517c, .val = 0x00000000 },
	{ .addr = 0x0f0005180, .val = 0x00000000 },
	{ .addr = 0x0f0005184, .val = 0x00000000 },
	{ .addr = 0x0f0005188, .val = 0x00000000 },
	{ .addr = 0x0f000518c, .val = 0x00000000 },
	{ .addr = 0x0f0005190, .val = 0x00000000 },
	{ .addr = 0x0f0005194, .val = 0x00000000 },
	{ .addr = 0x0f0005198, .val = 0x00000000 },
	{ .addr = 0x0f000519c, .val = 0x00000000 },
	{ .addr = 0x0f00051a0, .val = 0x00000000 },
	{ .addr = 0x0f00051a4, .val = 0x00000000 },
	{ .addr = 0x0f00051a8, .val = 0x00000000 },
	{ .addr = 0x0f00051ac, .val = 0x00000000 },
	{ .addr = 0x0f00051b0, .val = 0x00000000 },
	{ .addr = 0x0f00051b4, .val = 0x00000000 },
	{ .addr = 0x0f00051b8, .val = 0x00000000 },
	{ .addr = 0x0f00051bc, .val = 0x00000000 },
	{ .addr = 0x0f00051c0, .val = 0x00000000 },
	{ .addr = 0x0f00051c4, .val = 0x00000000 },
	{ .addr = 0x0f00051c8, .val = 0x00000000 },
	{ .addr = 0x0f00051cc, .val = 0x00000000 },
	{ .addr = 0x0f00051d0, .val = 0x00000000 },
	{ .addr = 0x0f00051d4, .val = 0x00000000 },
	{ .addr = 0x0f00051d8, .val = 0x00000000 },
	{ .addr = 0x0f00051dc, .val = 0x00000000 },
	{ .addr = 0x0f00051e0, .val = 0x00000000 },
	{ .addr = 0x0f00051e4, .val = 0x00000000 },
	{ .addr = 0x0f00051e8, .val = 0x00000000 },
	{ .addr = 0x0f00051ec, .val = 0x00000000 },
	{ .addr = 0x0f00051f0, .val = 0x00000000 },
	{ .addr = 0x0f00051f4, .val = 0x00000000 },
	{ .addr = 0x0f00051f8, .val = 0x00000000 },
	{ .addr = 0x0f00051fc, .val = 0x00000000 },
	{ .addr = 0x0f0005200, .val = 0x00000000 },
	{ .addr = 0x0f0005204, .val = 0x00000000 },
	{ .addr = 0x0f0005208, .val = 0x00000000 },
	{ .addr = 0x0f000520c, .val = 0x00000000 },
	{ .addr = 0x0f0005210, .val = 0x00000000 },
	{ .addr = 0x0f0005214, .val = 0x00000000 },
	{ .addr = 0x0f0005218, .val = 0x00000000 },
	{ .addr = 0x0f000521c, .val = 0x00000000 },
	{ .addr = 0x0f0005220, .val = 0x00000000 },
	{ .addr = 0x0f0005224, .val = 0x00000000 },
	{ .addr = 0x0f0005228, .val = 0x00000000 },
	{ .addr = 0x0f000522c, .val = 0x00000000 },
	{ .addr = 0x0f0005230, .val = 0x00000000 },
	{ .addr = 0x0f0005234, .val = 0x00000000 },
	{ .addr = 0x0f0005238, .val = 0x00000000 },
	{ .addr = 0x0f000523c, .val = 0x00000000 },
	{ .addr = 0x0f0005240, .val = 0x00000000 },
	{ .addr = 0x0f0005244, .val = 0x00000000 },
	{ .addr = 0x0f0005248, .val = 0x00000000 },
	{ .addr = 0x0f000524c, .val = 0x00000000 },
	{ .addr = 0x0f0005250, .val = 0x00000000 },
	{ .addr = 0x0f0005254, .val = 0x00000000 },
	{ .addr = 0x0f0005258, .val = 0x00000000 },
	{ .addr = 0x0f000525c, .val = 0x00000000 },
	{ .addr = 0x0f0005260, .val = 0x00000000 },
	{ .addr = 0x0f0005264, .val = 0x00000000 },
	{ .addr = 0x0f0005268, .val = 0x00000000 },
	{ .addr = 0x0f000526c, .val = 0x00000000 },
	{ .addr = 0x0f0005270, .val = 0x00000000 },
	{ .addr = 0x0f0005274, .val = 0x00000000 },
	{ .addr = 0x0f0005278, .val = 0x00000000 },
	{ .addr = 0x0f000527c, .val = 0x00000000 },
	{ .addr = 0x0f0005280, .val = 0x00000000 },
	{ .addr = 0x0f0005284, .val = 0x00000000 },
	{ .addr = 0x0f0005288, .val = 0x00000000 },
	{ .addr = 0x0f000528c, .val = 0x00000000 },
	{ .addr = 0x0f0005290, .val = 0x00000000 },
	{ .addr = 0x0f0005294, .val = 0x00000000 },
	{ .addr = 0x0f0005298, .val = 0x00000000 },
	{ .addr = 0x0f000529c, .val = 0x00000000 },
	{ .addr = 0x0f00052a0, .val = 0x00000000 },
	{ .addr = 0x0f00052a4, .val = 0x00000000 },
	{ .addr = 0x0f00052a8, .val = 0x00000000 },
	{ .addr = 0x0f00052ac, .val = 0x00000000 },
	{ .addr = 0x0f00052b0, .val = 0x00000000 },
	{ .addr = 0x0f00052b4, .val = 0x00000000 },
	{ .addr = 0x0f00052b8, .val = 0x00000000 },
	{ .addr = 0x0f00052bc, .val = 0x00000000 },
	{ .addr = 0x0f00052c0, .val = 0x00000000 },
	{ .addr = 0x0f00052c4, .val = 0x00000000 },
	{ .addr = 0x0f00052c8, .val = 0x00000000 },
	{ .addr = 0x0f00052cc, .val = 0x00000000 },
	{ .addr = 0x0f00052d0, .val = 0x00000000 },
	{ .addr = 0x0f00052d4, .val = 0x00000000 },
	{ .addr = 0x0f00052d8, .val = 0x00000000 },
	{ .addr = 0x0f00052dc, .val = 0x00000000 },
	{ .addr = 0x0f00052e0, .val = 0x00000000 },
	{ .addr = 0x0f00052e4, .val = 0x00000000 },
	{ .addr = 0x0f00052e8, .val = 0x00000000 },
	{ .addr = 0x0f00052ec, .val = 0x00000000 },
	{ .addr = 0x0f00052f0, .val = 0x00000000 },
	{ .addr = 0x0f00052f4, .val = 0x00000000 },
	{ .addr = 0x0f00052f8, .val = 0x00000000 },
	{ .addr = 0x0f00052fc, .val = 0x00000000 },
	{ .addr = 0x0f0005300, .val = 0x00000000 },
	{ .addr = 0x0f0005304, .val = 0x00000000 },
	{ .addr = 0x0f0005308, .val = 0x00000000 },
	{ .addr = 0x0f000530c, .val = 0x00000000 },
	{ .addr = 0x0f0005310, .val = 0x00000000 },
	{ .addr = 0x0f0005314, .val = 0x00000000 },
	{ .addr = 0x0f0005318, .val = 0x00000000 },
	{ .addr = 0x0f000531c, .val = 0x00000000 },
	{ .addr = 0x0f0005320, .val = 0x00000000 },
	{ .addr = 0x0f0005324, .val = 0x00000000 },
	{ .addr = 0x0f0005328, .val = 0x00000000 },
	{ .addr = 0x0f000532c, .val = 0x00000000 },
	{ .addr = 0x0f0005330, .val = 0x00000000 },
	{ .addr = 0x0f0005334, .val = 0x00000000 },
	{ .addr = 0x0f0005338, .val = 0x00000000 },
	{ .addr = 0x0f000533c, .val = 0x00000000 },
	{ .addr = 0x0f0005340, .val = 0x00000000 },
	{ .addr = 0x0f0005344, .val = 0x00000000 },
	{ .addr = 0x0f0005348, .val = 0x00000000 },
	{ .addr = 0x0f000534c, .val = 0x00000000 },
	{ .addr = 0x0f0005350, .val = 0x00000000 },
	{ .addr = 0x0f0005354, .val = 0x00000000 },
	{ .addr = 0x0f0005358, .val = 0x00000000 },
	{ .addr = 0x0f000535c, .val = 0x00000000 },
	{ .addr = 0x0f0005360, .val = 0x00000000 },
	{ .addr = 0x0f0005364, .val = 0x00000000 },
	{ .addr = 0x0f0005368, .val = 0x00000000 },
	{ .addr = 0x0f000536c, .val = 0x00000000 },
	{ .addr = 0x0f0005370, .val = 0x00000000 },
	{ .addr = 0x0f0005374, .val = 0x00000000 },
	{ .addr = 0x0f0005378, .val = 0x00000000 },
	{ .addr = 0x0f000537c, .val = 0x00000000 },
	{ .addr = 0x0f0005380, .val = 0x00000000 },
	{ .addr = 0x0f0005384, .val = 0x00000000 },
	{ .addr = 0x0f0005388, .val = 0x00000000 },
	{ .addr = 0x0f000538c, .val = 0x00000000 },
	{ .addr = 0x0f0005390, .val = 0x00000000 },
	{ .addr = 0x0f0005394, .val = 0x00000000 },
	{ .addr = 0x0f0005398, .val = 0x00000000 },
	{ .addr = 0x0f000539c, .val = 0x00000000 },
	{ .addr = 0x0f00053a0, .val = 0x00000000 },
	{ .addr = 0x0f00053a4, .val = 0x00000000 },
	{ .addr = 0x0f00053a8, .val = 0x00000000 },
	{ .addr = 0x0f00053ac, .val = 0x00000000 },
	{ .addr = 0x0f00053b0, .val = 0x00000000 },
	{ .addr = 0x0f00053b4, .val = 0x00000000 },
	{ .addr = 0x0f00053b8, .val = 0x00000000 },
	{ .addr = 0x0f00053bc, .val = 0x00000000 },
	{ .addr = 0x0f00053c0, .val = 0x00000000 },
	{ .addr = 0x0f00053c4, .val = 0x00000000 },
	{ .addr = 0x0f00053c8, .val = 0x00000000 },
	{ .addr = 0x0f00053cc, .val = 0x00000000 },
	{ .addr = 0x0f00053d0, .val = 0x00000000 },
	{ .addr = 0x0f00053d4, .val = 0x00000000 },
	{ .addr = 0x0f00053d8, .val = 0x00000000 },
	{ .addr = 0x0f00053dc, .val = 0x00000000 },
	{ .addr = 0x0f00053e0, .val = 0x00000000 },
	{ .addr = 0x0f00053e4, .val = 0x00000000 },
	{ .addr = 0x0f00053e8, .val = 0x00000000 },
	{ .addr = 0x0f00053ec, .val = 0x00000000 },
	{ .addr = 0x0f00053f0, .val = 0x00000000 },
	{ .addr = 0x0f00053f4, .val = 0x00000000 },
	{ .addr = 0x0f00053f8, .val = 0x00000000 },
	{ .addr = 0x0f00053fc, .val = 0x00000000 },
	{ .addr = 0x0f0005400, .val = 0x00000000 },
	{ .addr = 0x0f0005404, .val = 0x00000000 },
	{ .addr = 0x0f0005408, .val = 0x00000000 },
	{ .addr = 0x0f000540c, .val = 0x00000000 },
	{ .addr = 0x0f0005410, .val = 0x00000000 },
	{ .addr = 0x0f0005414, .val = 0x00000000 },
	{ .addr = 0x0f0005418, .val = 0x00000000 },
	{ .addr = 0x0f000541c, .val = 0x00000000 },
	{ .addr = 0x0f0005420, .val = 0x00000000 },
	{ .addr = 0x0f0005424, .val = 0x00000000 },
	{ .addr = 0x0f0005428, .val = 0x00000000 },
	{ .addr = 0x0f000542c, .val = 0x00000000 },
	{ .addr = 0x0f0005430, .val = 0x00000000 },
	{ .addr = 0x0f0005434, .val = 0x00000000 },
	{ .addr = 0x0f0005438, .val = 0x00000000 },
	{ .addr = 0x0f000543c, .val = 0x00000000 },
	{ .addr = 0x0f0005440, .val = 0x00000000 },
	{ .addr = 0x0f0005444, .val = 0x00000000 },
	{ .addr = 0x0f0005448, .val = 0x00000000 },
	{ .addr = 0x0f000544c, .val = 0x00000000 },
	{ .addr = 0x0f0005450, .val = 0x00000000 },
	{ .addr = 0x0f0005454, .val = 0x00000000 },
	{ .addr = 0x0f0005458, .val = 0x00000000 },
	{ .addr = 0x0f000545c, .val = 0x00000000 },
	{ .addr = 0x0f0005460, .val = 0x00000000 },
	{ .addr = 0x0f0005464, .val = 0x00000000 },
	{ .addr = 0x0f0005468, .val = 0x00000000 },
	{ .addr = 0x0f000546c, .val = 0x00000000 },
	{ .addr = 0x0f0005470, .val = 0x00000000 },
	{ .addr = 0x0f0005474, .val = 0x00000000 },
	{ .addr = 0x0f0005478, .val = 0x00000000 },
	{ .addr = 0x0f000547c, .val = 0x00000000 },
	{ .addr = 0x0f0005480, .val = 0x00000000 },
	{ .addr = 0x0f0005484, .val = 0x00000000 },
	{ .addr = 0x0f0005488, .val = 0x00000000 },
	{ .addr = 0x0f000548c, .val = 0x00000000 },
	{ .addr = 0x0f0005490, .val = 0x00000000 },
	{ .addr = 0x0f0005494, .val = 0x00000000 },
	{ .addr = 0x0f0005498, .val = 0x00000000 },
	{ .addr = 0x0f000549c, .val = 0x00000000 },
	{ .addr = 0x0f00054a0, .val = 0x00000000 },
	{ .addr = 0x0f00054a4, .val = 0x00000000 },
	{ .addr = 0x0f00054a8, .val = 0x00000000 },
	{ .addr = 0x0f00054ac, .val = 0x00000000 },
	{ .addr = 0x0f00054b0, .val = 0x00000000 },
	{ .addr = 0x0f00054b4, .val = 0x00000000 },
	{ .addr = 0x0f00054b8, .val = 0x00000000 },
	{ .addr = 0x0f00054bc, .val = 0x00000000 },
	{ .addr = 0x0f00054c0, .val = 0x00000000 },
	{ .addr = 0x0f00054c4, .val = 0x00000000 },
	{ .addr = 0x0f00054c8, .val = 0x00000000 },
	{ .addr = 0x0f00054cc, .val = 0x00000000 },
	{ .addr = 0x0f00054d0, .val = 0x00000000 },
	{ .addr = 0x0f00054d4, .val = 0x00000000 },
	{ .addr = 0x0f00054d8, .val = 0x00000000 },
	{ .addr = 0x0f00054dc, .val = 0x00000000 },
	{ .addr = 0x0f00054e0, .val = 0x00000000 },
	{ .addr = 0x0f00054e4, .val = 0x00000000 },
	{ .addr = 0x0f00054e8, .val = 0x00000000 },
	{ .addr = 0x0f00054ec, .val = 0x00000000 },
	{ .addr = 0x0f00054f0, .val = 0x00000000 },
	{ .addr = 0x0f00054f4, .val = 0x00000000 },
	{ .addr = 0x0f00054f8, .val = 0x00000000 },
	{ .addr = 0x0f00054fc, .val = 0x00000000 },
	{ .addr = 0x0f0005500, .val = 0x00000000 },
	{ .addr = 0x0f0005504, .val = 0x00000000 },
	{ .addr = 0x0f0120000, .val = 0x00000003 },
	{ .addr = 0x0f0120004, .val = 0x00000000 },
	{ .addr = 0x0f0120008, .val = 0x00000000 },
	{ .addr = 0x0f012000c, .val = 0x0000200c },
	{ .addr = 0x0f0120010, .val = 0x0000101f },
	{ .addr = 0x0f0120014, .val = 0x00061843 },
	{ .addr = 0x0f0120018, .val = 0x00000000 },
	{ .addr = 0x0f012001c, .val = 0x00000000 },
	{ .addr = 0x0f0120020, .val = 0x00c30c31 },
	{ .addr = 0x0f0120024, .val = 0x00050000 },
	{ .addr = 0x0f0120028, .val = 0x0e802dff },
	{ .addr = 0x0f012002c, .val = 0x17dffe3f },
	{ .addr = 0x0f0120050, .val = 0x00000000 },
	{ .addr = 0x0f0120054, .val = 0x00000000 },
	{ .addr = 0x0f0120058, .val = 0x00000000 },
	{ .addr = 0x0f012005c, .val = 0x00000000 },
	{ .addr = 0x0f0120060, .val = 0x00000000 },
	{ .addr = 0x0f0120064, .val = 0x00000000 },
	{ .addr = 0x0f0120068, .val = 0x00000000 },
	{ .addr = 0x0f012006c, .val = 0x00000000 },
	{ .addr = 0x0f0120070, .val = 0x00000000 },
	{ .addr = 0x0f0120074, .val = 0x00000000 },
	{ .addr = 0x0f0120078, .val = 0x00000000 },
	{ .addr = 0x0f012007c, .val = 0x00000000 },
	{ .addr = 0x0f0120080, .val = 0x00000000 },
	{ .addr = 0x0f0120084, .val = 0x00000000 },
	{ .addr = 0x0f0120088, .val = 0x00000000 },
	{ .addr = 0x0f012008c, .val = 0x00000000 },
	{ .addr = 0x0f01200a0, .val = 0x00000000 },
	{ .addr = 0x0f01200a4, .val = 0x00000000 },
	{ .addr = 0x0f01200a8, .val = 0x00000000 },
	{ .addr = 0x0f01200ac, .val = 0x00000000 },
	{ .addr = 0x0f01200b0, .val = 0x00000000 },
	{ .addr = 0x0f01200b4, .val = 0x00000000 },
	{ .addr = 0x0f01200b8, .val = 0x00000000 },
	{ .addr = 0x0f01200bc, .val = 0x00000000 },
	{ .addr = 0x0f01200c0, .val = 0x00000000 },
	{ .addr = 0x0f01200c4, .val = 0x00000000 },
	{ .addr = 0x0f01200c8, .val = 0x00000000 },
	{ .addr = 0x0f01200dc, .val = 0x00000000 },
	{ .addr = 0x0f01200e0, .val = 0x00000000 },
	{ .addr = 0x0f01200e4, .val = 0x00000000 },
	{ .addr = 0x0f01200e8, .val = 0x00000000 },
	{ .addr = 0x0f01200ec, .val = 0x00000000 },
	{ .addr = 0x0f01200f0, .val = 0x00000000 },
	{ .addr = 0x0f01200f4, .val = 0x00000000 },
	{ .addr = 0x0f01200f8, .val = 0x00000000 },
	{ .addr = 0x0f01200fc, .val = 0x00000000 },
	{ .addr = 0x0f0120100, .val = 0x20820600 },
	{ .addr = 0x0f0120104, .val = 0x20828100 },
	{ .addr = 0x0f0120108, .val = 0x208288a8 },
	{ .addr = 0x0f012010c, .val = 0x21028100 },
	{ .addr = 0x0f0120110, .val = 0x2e868864 },
	{ .addr = 0x0f0120114, .val = 0x00000000 },
	{ .addr = 0x0f0120118, .val = 0x00000000 },
	{ .addr = 0x0f012011c, .val = 0x00000000 },
	{ .addr = 0x0f0120120, .val = 0x00000000 },
	{ .addr = 0x0f0120124, .val = 0x00000000 },
	{ .addr = 0x0f0120128, .val = 0x00000000 },
	{ .addr = 0x0f012012c, .val = 0x00000000 },
	{ .addr = 0x0f0120130, .val = 0x00000000 },
	{ .addr = 0x0f0120134, .val = 0x00000000 },
	{ .addr = 0x0f0120138, .val = 0x00000000 },
	{ .addr = 0x0f012013c, .val = 0x00000000 },
	{ .addr = 0x0f0120150, .val = 0x30000000 },
	{ .addr = 0x0f0120154, .val = 0x00000300 },
	{ .addr = 0x0f0120180, .val = 0x000188f7 },
	{ .addr = 0x0f0120184, .val = 0x00030800 },
	{ .addr = 0x0f0120188, .val = 0x000586dd },
	{ .addr = 0x0f012018c, .val = 0x00070021 },
	{ .addr = 0x0f0120190, .val = 0x00090057 },
	{ .addr = 0x0f0120194, .val = 0x00000000 },
	{ .addr = 0x0f0120198, .val = 0x00000000 },
	{ .addr = 0x0f012019c, .val = 0x00000000 },
	{ .addr = 0x0f01201a0, .val = 0x00000000 },
	{ .addr = 0x0f01201a4, .val = 0x00000000 },
	{ .addr = 0x0f01201a8, .val = 0x00000000 },
	{ .addr = 0x0f01201ac, .val = 0x00000000 },
	{ .addr = 0x0f01201b0, .val = 0x00000000 },
	{ .addr = 0x0f01201b4, .val = 0x00000000 },
	{ .addr = 0x0f01201b8, .val = 0x00000000 },
	{ .addr = 0x0f01201bc, .val = 0x00000000 },
	{ .addr = 0x0f0120200, .val = 0x00000000 },
	{ .addr = 0x0f0120204, .val = 0x00000000 },
	{ .addr = 0x0f0120208, .val = 0x00000000 },
	{ .addr = 0x0f012020c, .val = 0x00000000 },
	{ .addr = 0x0f0120210, .val = 0x00000000 },
	{ .addr = 0x0f0120214, .val = 0x00000000 },
	{ .addr = 0x0f0120218, .val = 0x00000000 },
	{ .addr = 0x0f012021c, .val = 0x00000000 },
	{ .addr = 0x0f0120220, .val = 0x00000000 },
	{ .addr = 0x0f0120224, .val = 0x00000000 },
	{ .addr = 0x0f0120228, .val = 0x00000000 },
	{ .addr = 0x0f012022c, .val = 0x00000000 },
	{ .addr = 0x0f0120230, .val = 0x00000000 },
	{ .addr = 0x0f0120234, .val = 0x00000000 },
	{ .addr = 0x0f0120238, .val = 0x00000000 },
	{ .addr = 0x0f012023c, .val = 0x00000000 },
	{ .addr = 0x0f0120240, .val = 0x00000000 },
	{ .addr = 0x0f0120244, .val = 0x00000000 },
	{ .addr = 0x0f0120248, .val = 0x00000000 },
	{ .addr = 0x0f012024c, .val = 0x00000000 },
	{ .addr = 0x0f0120250, .val = 0x00000000 },
	{ .addr = 0x0f0120254, .val = 0x00000000 },
	{ .addr = 0x0f0120258, .val = 0x00000000 },
	{ .addr = 0x0f012025c, .val = 0x00000000 },
	{ .addr = 0x0f0120260, .val = 0x00000000 },
	{ .addr = 0x0f0120264, .val = 0x00000000 },
	{ .addr = 0x0f0120268, .val = 0x00000000 },
	{ .addr = 0x0f012026c, .val = 0x00000000 },
	{ .addr = 0x0f0120270, .val = 0x00000000 },
	{ .addr = 0x0f0120274, .val = 0x00000000 },
	{ .addr = 0x0f0120278, .val = 0x00000000 },
	{ .addr = 0x0f012027c, .val = 0x00000000 },
	{ .addr = 0x0f0120280, .val = 0x00000000 },
	{ .addr = 0x0f0120284, .val = 0x00000000 },
	{ .addr = 0x0f0120288, .val = 0x00000000 },
	{ .addr = 0x0f012028c, .val = 0x00000000 },
	{ .addr = 0x0f0120290, .val = 0x00000000 },
	{ .addr = 0x0f0120294, .val = 0x00000000 },
	{ .addr = 0x0f0120298, .val = 0x00000000 },
	{ .addr = 0x0f012029c, .val = 0x00000000 },
	{ .addr = 0x0f01202a0, .val = 0x00000000 },
	{ .addr = 0x0f01202a4, .val = 0x00000000 },
	{ .addr = 0x0f01202a8, .val = 0x00000000 },
	{ .addr = 0x0f01202ac, .val = 0x00000000 },
	{ .addr = 0x0f01202b0, .val = 0x00000000 },
	{ .addr = 0x0f01202b4, .val = 0x00000000 },
	{ .addr = 0x0f01202b8, .val = 0x00000000 },
	{ .addr = 0x0f01202bc, .val = 0x00000000 },
	{ .addr = 0x0f01202c0, .val = 0x00000000 },
	{ .addr = 0x0f01202c4, .val = 0x00000000 },
	{ .addr = 0x0f01202c8, .val = 0x00000000 },
	{ .addr = 0x0f01202cc, .val = 0x00000000 },
	{ .addr = 0x0f01202d0, .val = 0x00000000 },
	{ .addr = 0x0f01202d4, .val = 0x00000000 },
	{ .addr = 0x0f01202d8, .val = 0x00000000 },
	{ .addr = 0x0f01202dc, .val = 0x00000000 },
	{ .addr = 0x0f01202e0, .val = 0x00000000 },
	{ .addr = 0x0f01202e4, .val = 0x00000000 },
	{ .addr = 0x0f01202e8, .val = 0x00000000 },
	{ .addr = 0x0f01202ec, .val = 0x00000000 },
	{ .addr = 0x0f01202f0, .val = 0x00000000 },
	{ .addr = 0x0f01202f4, .val = 0x00000000 },
	{ .addr = 0x0f01202f8, .val = 0x00000000 },
	{ .addr = 0x0f01202fc, .val = 0x00000000 },
	{ .addr = 0x0f0120300, .val = 0x000008c0 },
	{ .addr = 0x0f0120304, .val = 0x00002021 },
	{ .addr = 0x0f0120308, .val = 0x00002421 },
	{ .addr = 0x0f012030c, .val = 0x00002c20 },
	{ .addr = 0x0f0120310, .val = 0x000030a0 },
	{ .addr = 0x0f0120314, .val = 0x00004486 },
	{ .addr = 0x0f0120318, .val = 0x00003040 },
	{ .addr = 0x0f012031c, .val = 0x00003a04 },
	{ .addr = 0x0f0120320, .val = 0x00003000 },
	{ .addr = 0x0f0120324, .val = 0x00007840 },
	{ .addr = 0x0f0120328, .val = 0x00007880 },
	{ .addr = 0x0f012032c, .val = 0x00007820 },
	{ .addr = 0x0f0120330, .val = 0x00007800 },
	{ .addr = 0x0f0120334, .val = 0x00002821 },
	{ .addr = 0x0f0120338, .val = 0x00008046 },
	{ .addr = 0x0f012033c, .val = 0x00007840 },
	{ .addr = 0x0f0120340, .val = 0x00000000 },
	{ .addr = 0x0f0120344, .val = 0x000090c0 },
	{ .addr = 0x0f0120348, .val = 0x0000a827 },
	{ .addr = 0x0f012034c, .val = 0x0000ac28 },
	{ .addr = 0x0f0120350, .val = 0x0000b0a0 },
	{ .addr = 0x0f0120354, .val = 0x0000c486 },
	{ .addr = 0x0f0120358, .val = 0x0000b040 },
	{ .addr = 0x0f012035c, .val = 0x0000ba04 },
	{ .addr = 0x0f0120360, .val = 0x0000b000 },
	{ .addr = 0x0f0120364, .val = 0x0000f840 },
	{ .addr = 0x0f0120368, .val = 0x00000000 },
	{ .addr = 0x0f012036c, .val = 0x0000f820 },
	{ .addr = 0x0f0120370, .val = 0x0000f820 },
	{ .addr = 0x0f0120374, .val = 0x00002822 },
	{ .addr = 0x0f0120378, .val = 0x00000000 },
	{ .addr = 0x0f012037c, .val = 0x00000000 },
	{ .addr = 0x0f0120380, .val = 0x00000000 },
	{ .addr = 0x0f0120384, .val = 0x00000000 },
	{ .addr = 0x0f0120388, .val = 0x00000000 },
	{ .addr = 0x0f012038c, .val = 0x00000000 },
	{ .addr = 0x0f0120390, .val = 0x00000000 },
	{ .addr = 0x0f0120394, .val = 0x00000000 },
	{ .addr = 0x0f0120398, .val = 0x00000000 },
	{ .addr = 0x0f012039c, .val = 0x00000000 },
	{ .addr = 0x0f01203a0, .val = 0x00000000 },
	{ .addr = 0x0f01203a4, .val = 0x00000000 },
	{ .addr = 0x0f01203a8, .val = 0x00000000 },
	{ .addr = 0x0f01203ac, .val = 0x00000000 },
	{ .addr = 0x0f01203b0, .val = 0x00000000 },
	{ .addr = 0x0f01203b4, .val = 0x00000000 },
	{ .addr = 0x0f01203b8, .val = 0x00000000 },
	{ .addr = 0x0f01203bc, .val = 0x00000000 },
	{ .addr = 0x0f01203c0, .val = 0x00000000 },
	{ .addr = 0x0f01203c4, .val = 0x00000000 },
	{ .addr = 0x0f01203c8, .val = 0x00000000 },
	{ .addr = 0x0f01203cc, .val = 0x00000000 },
	{ .addr = 0x0f01203d0, .val = 0x00000000 },
	{ .addr = 0x0f01203d4, .val = 0x00000000 },
	{ .addr = 0x0f01203d8, .val = 0x00000000 },
	{ .addr = 0x0f01203dc, .val = 0x00000000 },
	{ .addr = 0x0f01203e0, .val = 0x00000000 },
	{ .addr = 0x0f01203e4, .val = 0x00000000 },
	{ .addr = 0x0f01203e8, .val = 0x00000000 },
	{ .addr = 0x0f01203ec, .val = 0x00000000 },
	{ .addr = 0x0f01203f0, .val = 0x00000000 },
	{ .addr = 0x0f01203f4, .val = 0x00000000 },
	{ .addr = 0x0f01203f8, .val = 0x00000000 },
	{ .addr = 0x0f01203fc, .val = 0x00000000 },
	{ .addr = 0x0f0120400, .val = 0x0000003f },
	{ .addr = 0x0f0120404, .val = 0x0000003f },
	{ .addr = 0x0f0120408, .val = 0x0000003f },
	{ .addr = 0x0f012040c, .val = 0x0000003f },
	{ .addr = 0x0f0120410, .val = 0x0000003f },
	{ .addr = 0x0f0120414, .val = 0x0000003f },
	{ .addr = 0x0f0120418, .val = 0x0000003f },
	{ .addr = 0x0f012041c, .val = 0x0000003f },
	{ .addr = 0x0f0120420, .val = 0x0000003f },
	{ .addr = 0x0f0120424, .val = 0x0000003f },
	{ .addr = 0x0f0120428, .val = 0x0000003f },
	{ .addr = 0x0f012042c, .val = 0x0000003f },
	{ .addr = 0x0f0120430, .val = 0x0000003f },
	{ .addr = 0x0f0120434, .val = 0x0000003f },
	{ .addr = 0x0f0120438, .val = 0x0000003f },
	{ .addr = 0x0f012043c, .val = 0x0000003f },
	{ .addr = 0x0f0120440, .val = 0x0000003f },
	{ .addr = 0x0f0120444, .val = 0x0000003f },
	{ .addr = 0x0f0120448, .val = 0x0000003f },
	{ .addr = 0x0f012044c, .val = 0x0000003f },
	{ .addr = 0x0f0120450, .val = 0x0000003f },
	{ .addr = 0x0f0120454, .val = 0x0000003f },
	{ .addr = 0x0f0120458, .val = 0x0000003f },
	{ .addr = 0x0f012045c, .val = 0x0000003f },
	{ .addr = 0x0f0120460, .val = 0x0000003f },
	{ .addr = 0x0f0120464, .val = 0x0000003f },
	{ .addr = 0x0f0120468, .val = 0x0000003f },
	{ .addr = 0x0f012046c, .val = 0x0000003f },
	{ .addr = 0x0f0120470, .val = 0x0000003f },
	{ .addr = 0x0f0120474, .val = 0x0000003f },
	{ .addr = 0x0f0120478, .val = 0x0000003f },
	{ .addr = 0x0f012047c, .val = 0x0000003f },
	{ .addr = 0x0f0120480, .val = 0x0000003f },
	{ .addr = 0x0f0120484, .val = 0x0000003f },
	{ .addr = 0x0f0120488, .val = 0x0000003f },
	{ .addr = 0x0f012048c, .val = 0x0000003f },
	{ .addr = 0x0f0120490, .val = 0x0000003f },
	{ .addr = 0x0f0120494, .val = 0x0000003f },
	{ .addr = 0x0f0120498, .val = 0x0000003f },
	{ .addr = 0x0f012049c, .val = 0x0000003f },
	{ .addr = 0x0f01204a0, .val = 0x0000003f },
	{ .addr = 0x0f01204a4, .val = 0x0000003f },
	{ .addr = 0x0f01204a8, .val = 0x0000003f },
	{ .addr = 0x0f01204ac, .val = 0x0000003f },
	{ .addr = 0x0f01204b0, .val = 0x0000003f },
	{ .addr = 0x0f01204b4, .val = 0x0000003f },
	{ .addr = 0x0f01204b8, .val = 0x0000003f },
	{ .addr = 0x0f01204bc, .val = 0x0000003f },
	{ .addr = 0x0f01204c0, .val = 0x0000003f },
	{ .addr = 0x0f01204c4, .val = 0x0000003f },
	{ .addr = 0x0f01204c8, .val = 0x0000003f },
	{ .addr = 0x0f01204cc, .val = 0x0000003f },
	{ .addr = 0x0f01204d0, .val = 0x0000003f },
	{ .addr = 0x0f01204d4, .val = 0x0000003f },
	{ .addr = 0x0f01204d8, .val = 0x0000003f },
	{ .addr = 0x0f01204dc, .val = 0x0000003f },
	{ .addr = 0x0f01204e0, .val = 0x0000003f },
	{ .addr = 0x0f01204e4, .val = 0x0000003f },
	{ .addr = 0x0f01204e8, .val = 0x0000003f },
	{ .addr = 0x0f01204ec, .val = 0x0000003f },
	{ .addr = 0x0f01204f0, .val = 0x0000003f },
	{ .addr = 0x0f01204f4, .val = 0x0000003f },
	{ .addr = 0x0f01204f8, .val = 0x0000003f },
	{ .addr = 0x0f01204fc, .val = 0x0000003f },
	{ .addr = 0x0f0120500, .val = 0x0000003f },
	{ .addr = 0x0f0120504, .val = 0x0000003f },
	{ .addr = 0x0f0120508, .val = 0x0000003f },
	{ .addr = 0x0f012050c, .val = 0x0000003f },
	{ .addr = 0x0f0120510, .val = 0x0000003f },
	{ .addr = 0x0f0120514, .val = 0x0000003f },
	{ .addr = 0x0f0120518, .val = 0x0000003f },
	{ .addr = 0x0f012051c, .val = 0x0000003f },
	{ .addr = 0x0f0120520, .val = 0x0000003f },
	{ .addr = 0x0f0120524, .val = 0x0000003f },
	{ .addr = 0x0f0120528, .val = 0x0000003f },
	{ .addr = 0x0f012052c, .val = 0x0000003f },
	{ .addr = 0x0f0120530, .val = 0x0000003f },
	{ .addr = 0x0f0120534, .val = 0x0000003f },
	{ .addr = 0x0f0120538, .val = 0x0000003f },
	{ .addr = 0x0f012053c, .val = 0x0000003f },
	{ .addr = 0x0f0120540, .val = 0x0000003f },
	{ .addr = 0x0f0120544, .val = 0x0000003f },
	{ .addr = 0x0f0120548, .val = 0x0000003f },
	{ .addr = 0x0f012054c, .val = 0x0000003f },
	{ .addr = 0x0f0120550, .val = 0x0000003f },
	{ .addr = 0x0f0120554, .val = 0x0000003f },
	{ .addr = 0x0f0120558, .val = 0x0000003f },
	{ .addr = 0x0f012055c, .val = 0x0000003f },
	{ .addr = 0x0f0120560, .val = 0x0000003f },
	{ .addr = 0x0f0120564, .val = 0x0000003f },
	{ .addr = 0x0f0120568, .val = 0x0000003f },
	{ .addr = 0x0f012056c, .val = 0x0000003f },
	{ .addr = 0x0f0120570, .val = 0x0000003f },
	{ .addr = 0x0f0120574, .val = 0x0000003f },
	{ .addr = 0x0f0120578, .val = 0x0000003f },
	{ .addr = 0x0f012057c, .val = 0x0000003f },
	{ .addr = 0x0f0120580, .val = 0x0000003f },
	{ .addr = 0x0f0120584, .val = 0x0000003f },
	{ .addr = 0x0f0120588, .val = 0x0000003f },
	{ .addr = 0x0f012058c, .val = 0x0000003f },
	{ .addr = 0x0f0120590, .val = 0x0000003f },
	{ .addr = 0x0f0120594, .val = 0x0000003f },
	{ .addr = 0x0f0120598, .val = 0x0000003f },
	{ .addr = 0x0f012059c, .val = 0x0000003f },
	{ .addr = 0x0f01205a0, .val = 0x0000003f },
	{ .addr = 0x0f01205a4, .val = 0x0000003f },
	{ .addr = 0x0f01205a8, .val = 0x0000003f },
	{ .addr = 0x0f01205ac, .val = 0x0000003f },
	{ .addr = 0x0f01205b0, .val = 0x0000003f },
	{ .addr = 0x0f01205b4, .val = 0x0000003f },
	{ .addr = 0x0f01205b8, .val = 0x0000003f },
	{ .addr = 0x0f01205bc, .val = 0x0000003f },
	{ .addr = 0x0f01205c0, .val = 0x0000003f },
	{ .addr = 0x0f01205c4, .val = 0x0000003f },
	{ .addr = 0x0f01205c8, .val = 0x0000003f },
	{ .addr = 0x0f01205cc, .val = 0x0000003f },
	{ .addr = 0x0f01205d0, .val = 0x0000003f },
	{ .addr = 0x0f01205d4, .val = 0x0000003f },
	{ .addr = 0x0f01205d8, .val = 0x0000003f },
	{ .addr = 0x0f01205dc, .val = 0x0000003f },
	{ .addr = 0x0f01205e0, .val = 0x0000003f },
	{ .addr = 0x0f01205e4, .val = 0x0000003f },
	{ .addr = 0x0f01205e8, .val = 0x0000003f },
	{ .addr = 0x0f01205ec, .val = 0x0000003f },
	{ .addr = 0x0f01205f0, .val = 0x0000003f },
	{ .addr = 0x0f01205f4, .val = 0x0000003f },
	{ .addr = 0x0f01205f8, .val = 0x0000003f },
	{ .addr = 0x0f01205fc, .val = 0x0000003f },
	{ .addr = 0x0f0120600, .val = 0x0000003f },
	{ .addr = 0x0f0120604, .val = 0x0000003f },
	{ .addr = 0x0f0120608, .val = 0x0000003f },
	{ .addr = 0x0f012060c, .val = 0x0000003f },
	{ .addr = 0x0f0120610, .val = 0x0000003f },
	{ .addr = 0x0f0120614, .val = 0x0000003f },
	{ .addr = 0x0f0120618, .val = 0x0000003f },
	{ .addr = 0x0f012061c, .val = 0x0000003f },
	{ .addr = 0x0f0120620, .val = 0x0000003f },
	{ .addr = 0x0f0120624, .val = 0x0000003f },
	{ .addr = 0x0f0120628, .val = 0x0000003f },
	{ .addr = 0x0f012062c, .val = 0x0000003f },
	{ .addr = 0x0f0120630, .val = 0x0000003f },
	{ .addr = 0x0f0120634, .val = 0x0000003f },
	{ .addr = 0x0f0120638, .val = 0x0000003f },
	{ .addr = 0x0f012063c, .val = 0x0000003f },
	{ .addr = 0x0f0120640, .val = 0x0000003f },
	{ .addr = 0x0f0120644, .val = 0x0000003f },
	{ .addr = 0x0f0120648, .val = 0x0000003f },
	{ .addr = 0x0f012064c, .val = 0x0000003f },
	{ .addr = 0x0f0120650, .val = 0x0000003f },
	{ .addr = 0x0f0120654, .val = 0x0000003f },
	{ .addr = 0x0f0120658, .val = 0x0000003f },
	{ .addr = 0x0f012065c, .val = 0x0000003f },
	{ .addr = 0x0f0120660, .val = 0x0000003f },
	{ .addr = 0x0f0120664, .val = 0x0000003f },
	{ .addr = 0x0f0120668, .val = 0x0000003f },
	{ .addr = 0x0f012066c, .val = 0x0000003f },
	{ .addr = 0x0f0120670, .val = 0x0000003f },
	{ .addr = 0x0f0120674, .val = 0x0000003f },
	{ .addr = 0x0f0120678, .val = 0x0000003f },
	{ .addr = 0x0f012067c, .val = 0x0000003f },
	{ .addr = 0x0f0120680, .val = 0x0000003f },
	{ .addr = 0x0f0120684, .val = 0x0000003f },
	{ .addr = 0x0f0120688, .val = 0x0000003f },
	{ .addr = 0x0f012068c, .val = 0x0000003f },
	{ .addr = 0x0f0120690, .val = 0x0000003f },
	{ .addr = 0x0f0120694, .val = 0x0000003f },
	{ .addr = 0x0f0120698, .val = 0x0000003f },
	{ .addr = 0x0f012069c, .val = 0x0000003f },
	{ .addr = 0x0f01206a0, .val = 0x0000003f },
	{ .addr = 0x0f01206a4, .val = 0x0000003f },
	{ .addr = 0x0f01206a8, .val = 0x0000003f },
	{ .addr = 0x0f01206ac, .val = 0x0000003f },
	{ .addr = 0x0f01206b0, .val = 0x0000003f },
	{ .addr = 0x0f01206b4, .val = 0x0000003f },
	{ .addr = 0x0f01206b8, .val = 0x0000003f },
	{ .addr = 0x0f01206bc, .val = 0x0000003f },
	{ .addr = 0x0f01206c0, .val = 0x0000003f },
	{ .addr = 0x0f01206c4, .val = 0x0000003f },
	{ .addr = 0x0f01206c8, .val = 0x0000003f },
	{ .addr = 0x0f01206cc, .val = 0x0000003f },
	{ .addr = 0x0f01206d0, .val = 0x0000003f },
	{ .addr = 0x0f01206d4, .val = 0x0000003f },
	{ .addr = 0x0f01206d8, .val = 0x0000003f },
	{ .addr = 0x0f01206dc, .val = 0x0000003f },
	{ .addr = 0x0f01206e0, .val = 0x0000003f },
	{ .addr = 0x0f01206e4, .val = 0x0000003f },
	{ .addr = 0x0f01206e8, .val = 0x0000003f },
	{ .addr = 0x0f01206ec, .val = 0x0000003f },
	{ .addr = 0x0f01206f0, .val = 0x0000003f },
	{ .addr = 0x0f01206f4, .val = 0x0000003f },
	{ .addr = 0x0f01206f8, .val = 0x0000003f },
	{ .addr = 0x0f01206fc, .val = 0x0000003f },
	{ .addr = 0x0f0120700, .val = 0x0000003f },
	{ .addr = 0x0f0120704, .val = 0x0000003f },
	{ .addr = 0x0f0120708, .val = 0x0000003f },
	{ .addr = 0x0f012070c, .val = 0x0000003f },
	{ .addr = 0x0f0120710, .val = 0x0000003f },
	{ .addr = 0x0f0120714, .val = 0x0000003f },
	{ .addr = 0x0f0120718, .val = 0x0000003f },
	{ .addr = 0x0f012071c, .val = 0x0000003f },
	{ .addr = 0x0f0120720, .val = 0x0000003f },
	{ .addr = 0x0f0120724, .val = 0x0000003f },
	{ .addr = 0x0f0120728, .val = 0x0000003f },
	{ .addr = 0x0f012072c, .val = 0x0000003f },
	{ .addr = 0x0f0120730, .val = 0x0000003f },
	{ .addr = 0x0f0120734, .val = 0x0000003f },
	{ .addr = 0x0f0120738, .val = 0x0000003f },
	{ .addr = 0x0f012073c, .val = 0x0000003f },
	{ .addr = 0x0f0120740, .val = 0x0000003f },
	{ .addr = 0x0f0120744, .val = 0x0000003f },
	{ .addr = 0x0f0120748, .val = 0x0000003f },
	{ .addr = 0x0f012074c, .val = 0x0000003f },
	{ .addr = 0x0f0120750, .val = 0x0000003f },
	{ .addr = 0x0f0120754, .val = 0x0000003f },
	{ .addr = 0x0f0120758, .val = 0x0000003f },
	{ .addr = 0x0f012075c, .val = 0x0000003f },
	{ .addr = 0x0f0120760, .val = 0x0000003f },
	{ .addr = 0x0f0120764, .val = 0x0000003f },
	{ .addr = 0x0f0120768, .val = 0x0000003f },
	{ .addr = 0x0f012076c, .val = 0x0000003f },
	{ .addr = 0x0f0120770, .val = 0x0000003f },
	{ .addr = 0x0f0120774, .val = 0x0000003f },
	{ .addr = 0x0f0120778, .val = 0x0000003f },
	{ .addr = 0x0f012077c, .val = 0x0000003f },
	{ .addr = 0x0f0120780, .val = 0x0000003f },
	{ .addr = 0x0f0120784, .val = 0x0000003f },
	{ .addr = 0x0f0120788, .val = 0x0000003f },
	{ .addr = 0x0f012078c, .val = 0x0000003f },
	{ .addr = 0x0f0120790, .val = 0x0000003f },
	{ .addr = 0x0f0120794, .val = 0x0000003f },
	{ .addr = 0x0f0120798, .val = 0x0000003f },
	{ .addr = 0x0f012079c, .val = 0x0000003f },
	{ .addr = 0x0f01207a0, .val = 0x0000003f },
	{ .addr = 0x0f01207a4, .val = 0x0000003f },
	{ .addr = 0x0f01207a8, .val = 0x0000003f },
	{ .addr = 0x0f01207ac, .val = 0x0000003f },
	{ .addr = 0x0f01207b0, .val = 0x0000003f },
	{ .addr = 0x0f01207b4, .val = 0x0000003f },
	{ .addr = 0x0f01207b8, .val = 0x0000003f },
	{ .addr = 0x0f01207bc, .val = 0x0000003f },
	{ .addr = 0x0f01207c0, .val = 0x0000003f },
	{ .addr = 0x0f01207c4, .val = 0x0000003f },
	{ .addr = 0x0f01207c8, .val = 0x0000003f },
	{ .addr = 0x0f01207cc, .val = 0x0000003f },
	{ .addr = 0x0f01207d0, .val = 0x0000003f },
	{ .addr = 0x0f01207d4, .val = 0x0000003f },
	{ .addr = 0x0f01207d8, .val = 0x0000003f },
	{ .addr = 0x0f01207dc, .val = 0x0000003f },
	{ .addr = 0x0f01207e0, .val = 0x0000003f },
	{ .addr = 0x0f01207e4, .val = 0x0000003f },
	{ .addr = 0x0f01207e8, .val = 0x0000003f },
	{ .addr = 0x0f01207ec, .val = 0x0000003f },
	{ .addr = 0x0f01207f0, .val = 0x0000003f },
	{ .addr = 0x0f01207f4, .val = 0x0000003f },
	{ .addr = 0x0f01207f8, .val = 0x0000003f },
	{ .addr = 0x0f01207fc, .val = 0x0000003f },
	{ .addr = 0x0f0120800, .val = 0x00002000 },
	{ .addr = 0x0f0120804, .val = 0x00007082 },
	{ .addr = 0x0f0120808, .val = 0x0000b0c4 },
	{ .addr = 0x0f012080c, .val = 0x0000f082 },
	{ .addr = 0x0f0120810, .val = 0x000130c4 },
	{ .addr = 0x0f0120814, .val = 0x00014000 },
	{ .addr = 0x0f0120818, .val = 0x00018000 },
	{ .addr = 0x0f012081c, .val = 0x0001c000 },
	{ .addr = 0x0f0120820, .val = 0x00020000 },
	{ .addr = 0x0f0120824, .val = 0x00024000 },
	{ .addr = 0x0f0120828, .val = 0x00028000 },
	{ .addr = 0x0f012082c, .val = 0x0002c000 },
	{ .addr = 0x0f0120830, .val = 0x00030000 },
	{ .addr = 0x0f0120834, .val = 0x00034000 },
	{ .addr = 0x0f0120838, .val = 0x00038000 },
	{ .addr = 0x0f012083c, .val = 0x0003c000 },
	{ .addr = 0x0f0120840, .val = 0x00040000 },
	{ .addr = 0x0f0120844, .val = 0x00046960 },
	{ .addr = 0x0f0120848, .val = 0x0004a980 },
	{ .addr = 0x0f012084c, .val = 0x0004f282 },
	{ .addr = 0x0f0120850, .val = 0x0005292a },
	{ .addr = 0x0f0120854, .val = 0x00056928 },
	{ .addr = 0x0f0120858, .val = 0x0005b2c4 },
	{ .addr = 0x0f012085c, .val = 0x0005e000 },
	{ .addr = 0x0f0120860, .val = 0x00062000 },
	{ .addr = 0x0f0120864, .val = 0x000669e0 },
	{ .addr = 0x0f0120868, .val = 0x0006a940 },
	{ .addr = 0x0f012086c, .val = 0x0006e000 },
	{ .addr = 0x0f0120870, .val = 0x00072016 },
	{ .addr = 0x0f0120874, .val = 0x00076014 },
	{ .addr = 0x0f0120878, .val = 0x0007a000 },
	{ .addr = 0x0f012087c, .val = 0x0007eb80 },
	{ .addr = 0x0f0120880, .val = 0x00080000 },
	{ .addr = 0x0f0120884, .val = 0x000869c0 },
	{ .addr = 0x0f0120888, .val = 0x0008a9c0 },
	{ .addr = 0x0f012088c, .val = 0x0008f1a0 },
	{ .addr = 0x0f0120890, .val = 0x000931a0 },
	{ .addr = 0x0f0120894, .val = 0x00096b2a },
	{ .addr = 0x0f0120898, .val = 0x0009ab28 },
	{ .addr = 0x0f012089c, .val = 0x0009e00e },
	{ .addr = 0x0f01208a0, .val = 0x000a2000 },
	{ .addr = 0x0f01208a4, .val = 0x000a6000 },
	{ .addr = 0x0f01208a8, .val = 0x000aaa20 },
	{ .addr = 0x0f01208ac, .val = 0x000af220 },
	{ .addr = 0x0f01208b0, .val = 0x000b3a20 },
	{ .addr = 0x0f01208b4, .val = 0x000b6000 },
	{ .addr = 0x0f01208b8, .val = 0x000bab20 },
	{ .addr = 0x0f01208bc, .val = 0x000bc000 },
	{ .addr = 0x0f01208c0, .val = 0x000c2012 },
	{ .addr = 0x0f01208c4, .val = 0x000c6000 },
	{ .addr = 0x0f01208c8, .val = 0x000b4000 },
	{ .addr = 0x0f01208cc, .val = 0x000cc000 },
	{ .addr = 0x0f01208d0, .val = 0x000d0000 },
	{ .addr = 0x0f01208d4, .val = 0x000d4000 },
	{ .addr = 0x0f01208d8, .val = 0x000d8000 },
	{ .addr = 0x0f01208dc, .val = 0x000dc000 },
	{ .addr = 0x0f01208e0, .val = 0x000e0000 },
	{ .addr = 0x0f01208e4, .val = 0x000e4000 },
	{ .addr = 0x0f01208e8, .val = 0x000e8000 },
	{ .addr = 0x0f01208ec, .val = 0x000ec000 },
	{ .addr = 0x0f01208f0, .val = 0x000f0016 },
	{ .addr = 0x0f01208f4, .val = 0x000f4014 },
	{ .addr = 0x0f01208f8, .val = 0x000f8000 },
	{ .addr = 0x0f01208fc, .val = 0x000fc000 },
	{ .addr = 0x0f0120900, .val = 0x0000001e },
	{ .addr = 0x0f0120904, .val = 0x01048004 },
	{ .addr = 0x0f0120908, .val = 0x0000050a },
	{ .addr = 0x0f012090c, .val = 0x01048004 },
	{ .addr = 0x0f0120910, .val = 0x0000050a },
	{ .addr = 0x0f0120914, .val = 0x00000000 },
	{ .addr = 0x0f0120918, .val = 0x00000000 },
	{ .addr = 0x0f012091c, .val = 0x00000000 },
	{ .addr = 0x0f0120920, .val = 0x00000000 },
	{ .addr = 0x0f0120924, .val = 0x00000000 },
	{ .addr = 0x0f0120928, .val = 0x00000000 },
	{ .addr = 0x0f012092c, .val = 0x00000000 },
	{ .addr = 0x0f0120930, .val = 0x00000000 },
	{ .addr = 0x0f0120934, .val = 0x00000000 },
	{ .addr = 0x0f0120938, .val = 0x00000000 },
	{ .addr = 0x0f012093c, .val = 0x00000000 },
	{ .addr = 0x0f0120940, .val = 0x0000000e },
	{ .addr = 0x0f0120944, .val = 0x0000009e },
	{ .addr = 0x0f0120948, .val = 0x00000000 },
	{ .addr = 0x0f012094c, .val = 0x01048010 },
	{ .addr = 0x0f0120950, .val = 0x0c84801c },
	{ .addr = 0x0f0120954, .val = 0x04100101 },
	{ .addr = 0x0f0120958, .val = 0x00000516 },
	{ .addr = 0x0f012095c, .val = 0x0108e000 },
	{ .addr = 0x0f0120960, .val = 0x00000000 },
	{ .addr = 0x0f0120964, .val = 0x0000021e },
	{ .addr = 0x0f0120968, .val = 0x0000019e },
	{ .addr = 0x0f012096c, .val = 0x00000000 },
	{ .addr = 0x0f0120970, .val = 0x0208a108 },
	{ .addr = 0x0f0120974, .val = 0x0000a10a },
	{ .addr = 0x0f0120978, .val = 0x0000009e },
	{ .addr = 0x0f012097c, .val = 0x0000009e },
	{ .addr = 0x0f0120980, .val = 0x00000002 },
	{ .addr = 0x0f0120984, .val = 0x00004142 },
	{ .addr = 0x0f0120988, .val = 0x0000029e },
	{ .addr = 0x0f012098c, .val = 0x0000011e },
	{ .addr = 0x0f0120990, .val = 0x0106811c },
	{ .addr = 0x0f0120994, .val = 0x0c84801c },
	{ .addr = 0x0f0120998, .val = 0x0410011d },
	{ .addr = 0x0f012099c, .val = 0x00000000 },
	{ .addr = 0x0f01209a0, .val = 0x0208a114 },
	{ .addr = 0x0f01209a4, .val = 0x0000a116 },
	{ .addr = 0x0f01209a8, .val = 0x0e10a1c1 },
	{ .addr = 0x0f01209ac, .val = 0x000000c2 },
	{ .addr = 0x0f01209b0, .val = 0x00000142 },
	{ .addr = 0x0f01209b4, .val = 0x0000009e },
	{ .addr = 0x0f01209b8, .val = 0x0000019e },
	{ .addr = 0x0f01209bc, .val = 0x00000000 },
	{ .addr = 0x0f01209c0, .val = 0x0000001c },
	{ .addr = 0x0f01209c4, .val = 0x0000001c },
	{ .addr = 0x0f01209c8, .val = 0x00000000 },
	{ .addr = 0x0f01209cc, .val = 0x00000000 },
	{ .addr = 0x0f01209d0, .val = 0x00000000 },
	{ .addr = 0x0f01209d4, .val = 0x00000000 },
	{ .addr = 0x0f01209d8, .val = 0x00000000 },
	{ .addr = 0x0f01209dc, .val = 0x00000000 },
	{ .addr = 0x0f01209e0, .val = 0x00000000 },
	{ .addr = 0x0f01209e4, .val = 0x00000000 },
	{ .addr = 0x0f01209e8, .val = 0x00000000 },
	{ .addr = 0x0f01209ec, .val = 0x00000000 },
	{ .addr = 0x0f01209f0, .val = 0x00000000 },
	{ .addr = 0x0f01209f4, .val = 0x00000000 },
	{ .addr = 0x0f01209f8, .val = 0x00000000 },
	{ .addr = 0x0f01209fc, .val = 0x00000000 },
	{ .addr = 0x0f0120a00, .val = 0x00000030 },
	{ .addr = 0x0f0120a04, .val = 0x00528230 },
	{ .addr = 0x0f0120a08, .val = 0x0039c230 },
	{ .addr = 0x0f0120a0c, .val = 0x00528230 },
	{ .addr = 0x0f0120a10, .val = 0x0039c230 },
	{ .addr = 0x0f0120a14, .val = 0x00000000 },
	{ .addr = 0x0f0120a18, .val = 0x00000000 },
	{ .addr = 0x0f0120a1c, .val = 0x00000000 },
	{ .addr = 0x0f0120a20, .val = 0x00000000 },
	{ .addr = 0x0f0120a24, .val = 0x00000000 },
	{ .addr = 0x0f0120a28, .val = 0x00000000 },
	{ .addr = 0x0f0120a2c, .val = 0x00000000 },
	{ .addr = 0x0f0120a30, .val = 0x00000000 },
	{ .addr = 0x0f0120a34, .val = 0x00000000 },
	{ .addr = 0x0f0120a38, .val = 0x00000000 },
	{ .addr = 0x0f0120a3c, .val = 0x00000000 },
	{ .addr = 0x0f0120a40, .val = 0x00082130 },
	{ .addr = 0x0f0120a44, .val = 0x00000030 },
	{ .addr = 0x0f0120a48, .val = 0x00000000 },
	{ .addr = 0x0f0120a4c, .val = 0x00528230 },
	{ .addr = 0x0f0120a50, .val = 0x00700030 },
	{ .addr = 0x0f0120a54, .val = 0x00210430 },
	{ .addr = 0x0f0120a58, .val = 0x0039c230 },
	{ .addr = 0x0f0120a5c, .val = 0x00210430 },
	{ .addr = 0x0f0120a60, .val = 0x00000000 },
	{ .addr = 0x0f0120a64, .val = 0x0078002a },
	{ .addr = 0x0f0120a68, .val = 0x00000030 },
	{ .addr = 0x0f0120a6c, .val = 0x00000000 },
	{ .addr = 0x0f0120a70, .val = 0x00104230 },
	{ .addr = 0x0f0120a74, .val = 0x00204230 },
	{ .addr = 0x0f0120a78, .val = 0x00000030 },
	{ .addr = 0x0f0120a7c, .val = 0x00000030 },
	{ .addr = 0x0f0120a80, .val = 0x00108230 },
	{ .addr = 0x0f0120a84, .val = 0x00528430 },
	{ .addr = 0x0f0120a88, .val = 0x0078002a },
	{ .addr = 0x0f0120a8c, .val = 0x0000002a },
	{ .addr = 0x0f0120a90, .val = 0x0021042a },
	{ .addr = 0x0f0120a94, .val = 0x00700030 },
	{ .addr = 0x0f0120a98, .val = 0x00200030 },
	{ .addr = 0x0f0120a9c, .val = 0x00000000 },
	{ .addr = 0x0f0120aa0, .val = 0x00104230 },
	{ .addr = 0x0f0120aa4, .val = 0x00204230 },
	{ .addr = 0x0f0120aa8, .val = 0x00738430 },
	{ .addr = 0x0f0120aac, .val = 0x00318430 },
	{ .addr = 0x0f0120ab0, .val = 0x00528430 },
	{ .addr = 0x0f0120ab4, .val = 0x00000030 },
	{ .addr = 0x0f0120ab8, .val = 0x00000030 },
	{ .addr = 0x0f0120abc, .val = 0x00000000 },
	{ .addr = 0x0f0120ac0, .val = 0x00000031 },
	{ .addr = 0x0f0120ac4, .val = 0x00000031 },
	{ .addr = 0x0f0120ac8, .val = 0x00000000 },
	{ .addr = 0x0f0120acc, .val = 0x00000000 },
	{ .addr = 0x0f0120ad0, .val = 0x00000000 },
	{ .addr = 0x0f0120ad4, .val = 0x00000000 },
	{ .addr = 0x0f0120ad8, .val = 0x00000000 },
	{ .addr = 0x0f0120adc, .val = 0x00000000 },
	{ .addr = 0x0f0120ae0, .val = 0x00000000 },
	{ .addr = 0x0f0120ae4, .val = 0x00000000 },
	{ .addr = 0x0f0120ae8, .val = 0x00000000 },
	{ .addr = 0x0f0120aec, .val = 0x00000000 },
	{ .addr = 0x0f0120af0, .val = 0x00000000 },
	{ .addr = 0x0f0120af4, .val = 0x00000000 },
	{ .addr = 0x0f0120af8, .val = 0x00000000 },
	{ .addr = 0x0f0120afc, .val = 0x00000000 },
	{ .addr = 0x0f0120b00, .val = 0x01800203 },
	{ .addr = 0x0f0120b04, .val = 0x01800305 },
	{ .addr = 0x0f0120b08, .val = 0x008000a3 },
	{ .addr = 0x0f0120b0c, .val = 0x00800124 },
	{ .addr = 0x0f0120b10, .val = 0x00800227 },
	{ .addr = 0x0f0120b14, .val = 0x00800329 },
	{ .addr = 0x0f0120b18, .val = 0x008008ab },
	{ .addr = 0x0f0120b1c, .val = 0x008014ad },
	{ .addr = 0x0f0120b20, .val = 0x008017af },
	{ .addr = 0x0f0120b24, .val = 0x00801930 },
	{ .addr = 0x0f0120b28, .val = 0x008039b3 },
	{ .addr = 0x0f0120b2c, .val = 0x00804235 },
	{ .addr = 0x0f0120b30, .val = 0x00804436 },
	{ .addr = 0x0f0120b34, .val = 0x01000039 },
	{ .addr = 0x0f0120b38, .val = 0x01000227 },
	{ .addr = 0x0f0120b3c, .val = 0x01000329 },
	{ .addr = 0x0f0120b40, .val = 0x010008ab },
	{ .addr = 0x0f0120b44, .val = 0x010014ad },
	{ .addr = 0x0f0120b48, .val = 0x010015b9 },
	{ .addr = 0x0f0120b4c, .val = 0x0100163b },
	{ .addr = 0x0f0120b50, .val = 0x010017af },
	{ .addr = 0x0f0120b54, .val = 0x01001930 },
	{ .addr = 0x0f0120b58, .val = 0x01001d3d },
	{ .addr = 0x0f0120b5c, .val = 0x01001de1 },
	{ .addr = 0x0f0120b60, .val = 0x01001e39 },
	{ .addr = 0x0f0120b64, .val = 0x010039b3 },
	{ .addr = 0x0f0120b68, .val = 0x01004235 },
	{ .addr = 0x0f0120b6c, .val = 0x01004436 },
	{ .addr = 0x0f0120b70, .val = 0x000352c1 },
	{ .addr = 0x0f0120b74, .val = 0x00000143 },
	{ .addr = 0x0f0120b78, .val = 0x000001c5 },
	{ .addr = 0x0f0120b7c, .val = 0x00040027 },
	{ .addr = 0x0f0120b80, .val = 0x00095ac7 },
	{ .addr = 0x0f0120b84, .val = 0x000be0c9 },
	{ .addr = 0x0f0120b88, .val = 0x0032ac55 },
	{ .addr = 0x0f0120b8c, .val = 0x00408057 },
	{ .addr = 0x0f0120b90, .val = 0x00436ead },
	{ .addr = 0x0f0120b94, .val = 0x00445459 },
	{ .addr = 0x0f0120b98, .val = 0x020000bf },
	{ .addr = 0x0f0120b9c, .val = 0x02000124 },
	{ .addr = 0x0f0120ba0, .val = 0x0200034b },
	{ .addr = 0x0f0120ba4, .val = 0x020008cd },
	{ .addr = 0x0f0120ba8, .val = 0x0200425d },
	{ .addr = 0x0f0120bac, .val = 0x0200444e },
	{ .addr = 0x0f0120bb0, .val = 0x02800051 },
	{ .addr = 0x0f0120bb4, .val = 0x0280034b },
	{ .addr = 0x0f0120bb8, .val = 0x028008cd },
	{ .addr = 0x0f0120bbc, .val = 0x028015d1 },
	{ .addr = 0x0f0120bc0, .val = 0x02801653 },
	{ .addr = 0x0f0120bc4, .val = 0x02801d5b },
	{ .addr = 0x0f0120bc8, .val = 0x02801de1 },
	{ .addr = 0x0f0120bcc, .val = 0x02801e51 },
	{ .addr = 0x0f0120bd0, .val = 0x0280425d },
	{ .addr = 0x0f0120bd4, .val = 0x0280444e },
	{ .addr = 0x0f0120bd8, .val = 0x010043b9 },
	{ .addr = 0x0f0120bdc, .val = 0x028043d1 },
	{ .addr = 0x0f0120be0, .val = 0x00000000 },
	{ .addr = 0x0f0120be4, .val = 0x00000000 },
	{ .addr = 0x0f0120be8, .val = 0x00000000 },
	{ .addr = 0x0f0120bec, .val = 0x00000000 },
	{ .addr = 0x0f0120bf0, .val = 0x00000000 },
	{ .addr = 0x0f0120bf4, .val = 0x00000000 },
	{ .addr = 0x0f0120bf8, .val = 0x00000000 },
	{ .addr = 0x0f0120bfc, .val = 0x00000000 },
	{ .addr = 0x0f0120c00, .val = 0x0b115019 },
	{ .addr = 0x0f0120c04, .val = 0x0b020019 },
	{ .addr = 0x0f0120c08, .val = 0x0a10001d },
	{ .addr = 0x0f0120c0c, .val = 0x0b0db01d },
	{ .addr = 0x0f0120c10, .val = 0x00000000 },
	{ .addr = 0x0f0120c14, .val = 0x00000000 },
	{ .addr = 0x0f0120c18, .val = 0x00000000 },
	{ .addr = 0x0f0120c1c, .val = 0x00000000 },
	{ .addr = 0x0f0120c20, .val = 0x00000000 },
	{ .addr = 0x0f0120c24, .val = 0x00000000 },
	{ .addr = 0x0f0120c28, .val = 0x00000000 },
	{ .addr = 0x0f0120c2c, .val = 0x00000000 },
	{ .addr = 0x0f0120c30, .val = 0x00000000 },
	{ .addr = 0x0f0120c34, .val = 0x00000000 },
	{ .addr = 0x0f0120c38, .val = 0x00000000 },
	{ .addr = 0x0f0120c3c, .val = 0x00000000 },
	{ .addr = 0x0f0120c40, .val = 0x00000000 },
	{ .addr = 0x0f0120c44, .val = 0x00000000 },
	{ .addr = 0x0f0120c48, .val = 0x00000000 },
	{ .addr = 0x0f0120c4c, .val = 0x00000000 },
	{ .addr = 0x0f0120c50, .val = 0x00000000 },
	{ .addr = 0x0f0120c54, .val = 0x00000000 },
	{ .addr = 0x0f0120c58, .val = 0x00000000 },
	{ .addr = 0x0f0120c5c, .val = 0x00000000 },
	{ .addr = 0x0f0120c60, .val = 0x00000000 },
	{ .addr = 0x0f0120c64, .val = 0x00000000 },
	{ .addr = 0x0f0120c68, .val = 0x00000000 },
	{ .addr = 0x0f0120c6c, .val = 0x00000000 },
	{ .addr = 0x0f0120c70, .val = 0x00000000 },
	{ .addr = 0x0f0120c74, .val = 0x00000000 },
	{ .addr = 0x0f0120c78, .val = 0x00000000 },
	{ .addr = 0x0f0120c7c, .val = 0x00000000 },
	{ .addr = 0x0f0120c80, .val = 0x000555d7 },
	{ .addr = 0x0f0120c84, .val = 0x00055659 },
	{ .addr = 0x0f0120c88, .val = 0x0002b1c7 },
	{ .addr = 0x0f0120c8c, .val = 0x0002b249 },
	{ .addr = 0x0f0120c90, .val = 0x00000000 },
	{ .addr = 0x0f0120c94, .val = 0x00000000 },
	{ .addr = 0x0f0120c98, .val = 0x00000000 },
	{ .addr = 0x0f0120c9c, .val = 0x00000000 },
	{ .addr = 0x0f0120ca0, .val = 0x00000000 },
	{ .addr = 0x0f0120ca4, .val = 0x00000000 },
	{ .addr = 0x0f0120ca8, .val = 0x00000000 },
	{ .addr = 0x0f0120cac, .val = 0x00000000 },
	{ .addr = 0x0f0120cb0, .val = 0x00000000 },
	{ .addr = 0x0f0120cb4, .val = 0x00000000 },
	{ .addr = 0x0f0120cb8, .val = 0x00000000 },
	{ .addr = 0x0f0120cbc, .val = 0x00000000 },
	{ .addr = 0x0f0120d00, .val = 0x00000000 },
	{ .addr = 0x0f0120d04, .val = 0x00000000 },
	{ .addr = 0x0f0120d08, .val = 0x00000000 },
	{ .addr = 0x0f0120d0c, .val = 0x00000000 },
	{ .addr = 0x0f0120d10, .val = 0x00000000 },
	{ .addr = 0x0f0120d14, .val = 0x00000000 },
	{ .addr = 0x0f0120d18, .val = 0x00000000 },
	{ .addr = 0x0f0120d1c, .val = 0x00000000 },
	{ .addr = 0x0f0120d20, .val = 0x00000000 },
	{ .addr = 0x0f0120d24, .val = 0x00000000 },
	{ .addr = 0x0f0120d28, .val = 0x00000000 },
	{ .addr = 0x0f0120d2c, .val = 0x00000000 },
	{ .addr = 0x0f0120d30, .val = 0x00000000 },
	{ .addr = 0x0f0120d34, .val = 0x00000000 },
	{ .addr = 0x0f0120d38, .val = 0x00000000 },
	{ .addr = 0x0f0120d3c, .val = 0x00000000 },
	{ .addr = 0x0f0120d40, .val = 0x00000000 },
	{ .addr = 0x0f0120d44, .val = 0x00000000 },
	{ .addr = 0x0f0120d48, .val = 0x00000000 },
	{ .addr = 0x0f0120d4c, .val = 0x00000000 },
	{ .addr = 0x0f0120d50, .val = 0x00000000 },
	{ .addr = 0x0f0120d54, .val = 0x00000000 },
	{ .addr = 0x0f0120d58, .val = 0x00000000 },
	{ .addr = 0x0f0120d5c, .val = 0x00000000 },
	{ .addr = 0x0f0120d60, .val = 0x00000000 },
	{ .addr = 0x0f0120d64, .val = 0x00000000 },
	{ .addr = 0x0f0120d68, .val = 0x00000000 },
	{ .addr = 0x0f0120d6c, .val = 0x00000000 },
	{ .addr = 0x0f0120d70, .val = 0x00000000 },
	{ .addr = 0x0f0120d74, .val = 0x00000000 },
	{ .addr = 0x0f0120d78, .val = 0x00000000 },
	{ .addr = 0x0f0120d7c, .val = 0x00000000 },
	{ .addr = 0x0f0120d80, .val = 0x00000000 },
	{ .addr = 0x0f0120d84, .val = 0x00000000 },
	{ .addr = 0x0f0120d88, .val = 0x00000000 },
	{ .addr = 0x0f0120d8c, .val = 0x00000000 },
	{ .addr = 0x0f0120d90, .val = 0x00000000 },
	{ .addr = 0x0f0120d94, .val = 0x00000000 },
	{ .addr = 0x0f0120d98, .val = 0x00000000 },
	{ .addr = 0x0f0120d9c, .val = 0x00000000 },
	{ .addr = 0x0f0120da0, .val = 0x00000000 },
	{ .addr = 0x0f0120da4, .val = 0x00000000 },
	{ .addr = 0x0f0120da8, .val = 0x00000000 },
	{ .addr = 0x0f0120dac, .val = 0x00000000 },
	{ .addr = 0x0f0120db0, .val = 0x00000000 },
	{ .addr = 0x0f0120db4, .val = 0x00000000 },
	{ .addr = 0x0f0120db8, .val = 0x00000000 },
	{ .addr = 0x0f0120dbc, .val = 0x00000000 },
	{ .addr = 0x0f0120dc0, .val = 0x00000000 },
	{ .addr = 0x0f0120dc4, .val = 0x00000000 },
	{ .addr = 0x0f0120dc8, .val = 0x00000000 },
	{ .addr = 0x0f0120dcc, .val = 0x00000000 },
	{ .addr = 0x0f0120dd0, .val = 0x00000000 },
	{ .addr = 0x0f0120dd4, .val = 0x00000000 },
	{ .addr = 0x0f0120dd8, .val = 0x00000000 },
	{ .addr = 0x0f0120ddc, .val = 0x00000000 },
	{ .addr = 0x0f0120de0, .val = 0x00000000 },
	{ .addr = 0x0f0120de4, .val = 0x00000000 },
	{ .addr = 0x0f0120de8, .val = 0x00000000 },
	{ .addr = 0x0f0120dec, .val = 0x00000000 },
	{ .addr = 0x0f0120df0, .val = 0x00000000 },
	{ .addr = 0x0f0120df4, .val = 0x00000000 },
	{ .addr = 0x0f0120df8, .val = 0x00000000 },
	{ .addr = 0x0f0120dfc, .val = 0x00000000 },
	{ .addr = 0x0f0120e00, .val = 0x00000000 },
	{ .addr = 0x0f0120e04, .val = 0x00000000 },
	{ .addr = 0x0f0120e08, .val = 0x00000000 },
	{ .addr = 0x0f0120e0c, .val = 0x00000000 },
	{ .addr = 0x0f0120e10, .val = 0x00000000 },
	{ .addr = 0x0f0120e14, .val = 0x00000000 },
	{ .addr = 0x0f0120e18, .val = 0x00000000 },
	{ .addr = 0x0f0120e1c, .val = 0x00000000 },
	{ .addr = 0x0f0120e20, .val = 0x00000000 },
	{ .addr = 0x0f0120e24, .val = 0x00000000 },
	{ .addr = 0x0f0120e28, .val = 0x00000000 },
	{ .addr = 0x0f0120e2c, .val = 0x00000000 },
	{ .addr = 0x0f0120e30, .val = 0x00000000 },
	{ .addr = 0x0f0120e34, .val = 0x00000000 },
	{ .addr = 0x0f0120e38, .val = 0x00000000 },
	{ .addr = 0x0f0120e3c, .val = 0x00000000 },
	{ .addr = 0x0f0120e40, .val = 0x00000000 },
	{ .addr = 0x0f0120e44, .val = 0x00000000 },
	{ .addr = 0x0f0120e48, .val = 0x00000000 },
	{ .addr = 0x0f0120e4c, .val = 0x00000000 },
	{ .addr = 0x0f0120e50, .val = 0x00000000 },
	{ .addr = 0x0f0120e54, .val = 0x00000000 },
	{ .addr = 0x0f0120e58, .val = 0x00000000 },
	{ .addr = 0x0f0120e5c, .val = 0x00000000 },
	{ .addr = 0x0f0120e60, .val = 0x00000000 },
	{ .addr = 0x0f0120e64, .val = 0x00000000 },
	{ .addr = 0x0f0120e68, .val = 0x00000000 },
	{ .addr = 0x0f0120e6c, .val = 0x00000000 },
	{ .addr = 0x0f0120e70, .val = 0x00000000 },
	{ .addr = 0x0f0120e74, .val = 0x00000000 },
	{ .addr = 0x0f0120e78, .val = 0x00000000 },
	{ .addr = 0x0f0120e7c, .val = 0x00000000 },
	{ .addr = 0x0f0120e80, .val = 0x00000000 },
	{ .addr = 0x0f0120e84, .val = 0x00000000 },
	{ .addr = 0x0f0120e88, .val = 0x00000000 },
	{ .addr = 0x0f0120e8c, .val = 0x00000000 },
	{ .addr = 0x0f1c00000, .val = 0x00000001 },
	{ .addr = 0x0f1c00004, .val = 0x00000000 },
	{ .addr = 0x0f1c00008, .val = 0x00000000 },
	{ .addr = 0x0f1c0000c, .val = 0x00000000 },
	{ .addr = 0x0f1c00010, .val = 0x00000000 },
	{ .addr = 0x0f1c00014, .val = 0x00000000 },
	{ .addr = 0x0f1c00018, .val = 0x00000000 },
	{ .addr = 0x0f1c0001c, .val = 0x00000000 },
	{ .addr = 0x0f1c00020, .val = 0x00000000 },
	{ .addr = 0x0f1c00024, .val = 0x00000000 },
	{ .addr = 0x0f1c00028, .val = 0x00000000 },
	{ .addr = 0x0f1c0002c, .val = 0x00000000 },
	{ .addr = 0x0f1c00030, .val = 0x00000000 },
	{ .addr = 0x0f1c00034, .val = 0x00000000 },
	{ .addr = 0x0f1c00038, .val = 0x00000000 },
	{ .addr = 0x0f1c0003c, .val = 0x00000000 },
	{ .addr = 0x0f1c00040, .val = 0x00000000 },
	{ .addr = 0x0f1c00044, .val = 0x00000000 },
	{ .addr = 0x0f1c00048, .val = 0x00000000 },
	{ .addr = 0x0f1c0004c, .val = 0x00000000 },
	{ .addr = 0x0f1c00050, .val = 0x00000000 },
	{ .addr = 0x0f1c00054, .val = 0x00000000 },
	{ .addr = 0x0f1c00058, .val = 0x00000000 },
	{ .addr = 0x0f1c0005c, .val = 0x00000000 },
	{ .addr = 0x0f1c00060, .val = 0x00000000 },
	{ .addr = 0x0f1c00064, .val = 0x00000000 },
	{ .addr = 0x0f1c00068, .val = 0x00000000 },
	{ .addr = 0x0f1c0006c, .val = 0x00000000 },
	{ .addr = 0x0f1c00070, .val = 0x00000000 },
	{ .addr = 0x0f1c00074, .val = 0x00000000 },
	{ .addr = 0x0f1c00078, .val = 0x00000000 },
	{ .addr = 0x0f1c0007c, .val = 0x00000000 },
	{ .addr = 0x0f1c00080, .val = 0x00000000 },
	{ .addr = 0x0f1c00084, .val = 0x00000000 },
	{ .addr = 0x0f1c00088, .val = 0x00000000 },
	{ .addr = 0x0f1c0008c, .val = 0x00000000 },
	{ .addr = 0x0f1c00090, .val = 0x00000000 },
	{ .addr = 0x0f1c00094, .val = 0x00000000 },
	{ .addr = 0x0f1c00098, .val = 0x00000000 },
	{ .addr = 0x0f1c0009c, .val = 0x00000000 },
	{ .addr = 0x0f1c000a0, .val = 0x00000000 },
	{ .addr = 0x0f1c000a4, .val = 0x00000000 },
	{ .addr = 0x0f1c000a8, .val = 0x00000000 },
	{ .addr = 0x0f1c000ac, .val = 0x00000000 },
	{ .addr = 0x0f1c000b0, .val = 0x00000000 },
	{ .addr = 0x0f1c000b4, .val = 0x00000000 },
	{ .addr = 0x0f1c000b8, .val = 0x00000000 },
	{ .addr = 0x0f1c000bc, .val = 0x00000000 },
	{ .addr = 0x0f1c000c0, .val = 0x00000000 },
	{ .addr = 0x0f1c000c4, .val = 0x00000000 },
	{ .addr = 0x0f1c000c8, .val = 0x00000000 },
	{ .addr = 0x0f1c000cc, .val = 0x00000000 },
	{ .addr = 0x0f1c000d0, .val = 0x00000000 },
	{ .addr = 0x0f1c000d4, .val = 0x00000000 },
	{ .addr = 0x0f1c000d8, .val = 0x00000000 },
	{ .addr = 0x0f1c000dc, .val = 0x00000000 },
	{ .addr = 0x0f1c000e0, .val = 0x00000000 },
	{ .addr = 0x0f1c000e4, .val = 0x00000000 },
	{ .addr = 0x0f1c000e8, .val = 0x00000000 },
	{ .addr = 0x0f1c000ec, .val = 0x00000000 },
	{ .addr = 0x0f1c000f0, .val = 0x00000000 },
	{ .addr = 0x0f1c000f4, .val = 0x00000000 },
	{ .addr = 0x0f1c000f8, .val = 0x00000000 },
	{ .addr = 0x0f1c000fc, .val = 0x00000000 },
	{ .addr = 0x0f1c00100, .val = 0x00000000 },
	{ .addr = 0x0f1c00104, .val = 0x00000000 },
	{ .addr = 0x0f1c00108, .val = 0x00000000 },
	{ .addr = 0x0f1c0010c, .val = 0x00000000 },
	{ .addr = 0x0f1c00110, .val = 0x00000000 },
	{ .addr = 0x0f1c00114, .val = 0x00000000 },
	{ .addr = 0x0f1c00118, .val = 0x00000000 },
	{ .addr = 0x0f1c0011c, .val = 0x00000000 },
	{ .addr = 0x0f1c00120, .val = 0x00000000 },
	{ .addr = 0x0f1c00124, .val = 0x00000000 },
	{ .addr = 0x0f1c00128, .val = 0x00000000 },
	{ .addr = 0x0f1c0012c, .val = 0x00000000 },
	{ .addr = 0x0f1c00130, .val = 0x00000000 },
	{ .addr = 0x0f1c00134, .val = 0x00000000 },
	{ .addr = 0x0f1c00138, .val = 0x00000000 },
	{ .addr = 0x0f1c0013c, .val = 0x00000000 },
	{ .addr = 0x0f1c00140, .val = 0x00000000 },
	{ .addr = 0x0f1c00144, .val = 0x00000000 },
	{ .addr = 0x0f1c00148, .val = 0x00000000 },
	{ .addr = 0x0f1c0014c, .val = 0x00000000 },
	{ .addr = 0x0f1c00150, .val = 0x00000000 },
	{ .addr = 0x0f1c00154, .val = 0x00000000 },
	{ .addr = 0x0f1c00158, .val = 0x00000000 },
	{ .addr = 0x0f1c0015c, .val = 0x00000000 },
	{ .addr = 0x0f1c00160, .val = 0x00000000 },
	{ .addr = 0x0f1c00164, .val = 0x00000000 },
	{ .addr = 0x0f1c00168, .val = 0x00000000 },
	{ .addr = 0x0f1c0016c, .val = 0x00000000 },
	{ .addr = 0x0f1c00170, .val = 0x00000000 },
	{ .addr = 0x0f1c00174, .val = 0x00000000 },
	{ .addr = 0x0f1c00178, .val = 0x00000000 },
	{ .addr = 0x0f1c0017c, .val = 0x00000000 },
	{ .addr = 0x0f1c00180, .val = 0x00000000 },
	{ .addr = 0x0f1c00184, .val = 0x00000000 },
	{ .addr = 0x0f1c00188, .val = 0x00000000 },
	{ .addr = 0x0f1c0018c, .val = 0x00000000 },
	{ .addr = 0x0f1c00190, .val = 0x00000000 },
	{ .addr = 0x0f1c00194, .val = 0x00000000 },
	{ .addr = 0x0f1c00198, .val = 0x00000000 },
	{ .addr = 0x0f1c0019c, .val = 0x00000000 },
	{ .addr = 0x0f1c001a0, .val = 0x00000000 },
	{ .addr = 0x0f1c001a4, .val = 0x00000000 },
	{ .addr = 0x0f1c001a8, .val = 0x00000000 },
	{ .addr = 0x0f1c001ac, .val = 0x00000000 },
	{ .addr = 0x0f1c001b0, .val = 0x00000000 },
	{ .addr = 0x0f1c001b4, .val = 0x00000000 },
	{ .addr = 0x0f1c001b8, .val = 0x00000000 },
	{ .addr = 0x0f1c001bc, .val = 0x00000000 },
	{ .addr = 0x0f1c001c0, .val = 0x00000000 },
	{ .addr = 0x0f1c001c4, .val = 0x00000000 },
	{ .addr = 0x0f1c001c8, .val = 0x00000000 },
	{ .addr = 0x0f1c001cc, .val = 0x00000000 },
	{ .addr = 0x0f1c001d0, .val = 0x00000000 },
	{ .addr = 0x0f1c001d4, .val = 0x00000000 },
	{ .addr = 0x0f1c001d8, .val = 0x00000000 },
	{ .addr = 0x0f1c001dc, .val = 0x00000000 },
	{ .addr = 0x0f1c001e0, .val = 0x00000000 },
	{ .addr = 0x0f1c001e4, .val = 0x00000000 },
	{ .addr = 0x0f1c001e8, .val = 0x00000000 },
	{ .addr = 0x0f1c001ec, .val = 0x00000000 },
	{ .addr = 0x0f1c001f0, .val = 0x00000000 },
	{ .addr = 0x0f1c001f4, .val = 0x00000000 },
	{ .addr = 0x0f1c001f8, .val = 0x00000000 },
	{ .addr = 0x0f1c001fc, .val = 0x00000000 },
	{ .addr = 0x0f1c00200, .val = 0x00000000 },
	{ .addr = 0x0f1c00204, .val = 0x00000000 },
	{ .addr = 0x0f1c00208, .val = 0x00000000 },
	{ .addr = 0x0f1c0020c, .val = 0x00000000 },
	{ .addr = 0x0f1c00210, .val = 0x00000000 },
	{ .addr = 0x0f1c00214, .val = 0x00000000 },
	{ .addr = 0x0f1c00218, .val = 0x00000000 },
	{ .addr = 0x0f1c0021c, .val = 0x00000000 },
	{ .addr = 0x0f1c00220, .val = 0x00000000 },
	{ .addr = 0x0f1c00224, .val = 0x00000000 },
	{ .addr = 0x0f1c00228, .val = 0x00000000 },
	{ .addr = 0x0f1c0022c, .val = 0x00000000 },
	{ .addr = 0x0f1c00230, .val = 0x00000000 },
	{ .addr = 0x0f1c00234, .val = 0x00000000 },
	{ .addr = 0x0f1c00238, .val = 0x00000000 },
	{ .addr = 0x0f1c0023c, .val = 0x00000000 },
	{ .addr = 0x0f1c00240, .val = 0x00000000 },
	{ .addr = 0x0f1c00244, .val = 0x00000000 },
	{ .addr = 0x0f1c00248, .val = 0x00000000 },
	{ .addr = 0x0f1c0024c, .val = 0x00000000 },
	{ .addr = 0x0f1c00250, .val = 0x00000000 },
	{ .addr = 0x0f1c00254, .val = 0x00000000 },
	{ .addr = 0x0f1c00258, .val = 0x00000000 },
	{ .addr = 0x0f1c0025c, .val = 0x00000000 },
	{ .addr = 0x0f1c00260, .val = 0x00000000 },
	{ .addr = 0x0f1c00264, .val = 0x00000000 },
	{ .addr = 0x0f1c00268, .val = 0x00000000 },
	{ .addr = 0x0f1c0026c, .val = 0x00000000 },
	{ .addr = 0x0f1c00270, .val = 0x00000000 },
	{ .addr = 0x0f1c00274, .val = 0x00000000 },
	{ .addr = 0x0f1c00278, .val = 0x00000000 },
	{ .addr = 0x0f1c0027c, .val = 0x00000000 },
	{ .addr = 0x0f1c00280, .val = 0x00000000 },
	{ .addr = 0x0f1c00284, .val = 0x00000000 },
	{ .addr = 0x0f1c00288, .val = 0x00000000 },
	{ .addr = 0x0f1c0028c, .val = 0x00000000 },
	{ .addr = 0x0f1c00290, .val = 0x00000000 },
	{ .addr = 0x0f1c00294, .val = 0x00000000 },
	{ .addr = 0x0f1c00298, .val = 0x00000000 },
	{ .addr = 0x0f1c0029c, .val = 0x00000000 },
	{ .addr = 0x0f1c002a0, .val = 0x00000000 },
	{ .addr = 0x0f1c002a4, .val = 0x00000000 },
	{ .addr = 0x0f1c002a8, .val = 0x00000000 },
	{ .addr = 0x0f1c002ac, .val = 0x00000000 },
	{ .addr = 0x0f1c002b0, .val = 0x00000000 },
	{ .addr = 0x0f1c002b4, .val = 0x00000000 },
	{ .addr = 0x0f1c002b8, .val = 0x00000000 },
	{ .addr = 0x0f1c002bc, .val = 0x00000000 },
	{ .addr = 0x0f1c002c0, .val = 0x00000000 },
	{ .addr = 0x0f1c002c4, .val = 0x00000000 },
	{ .addr = 0x0f1c002c8, .val = 0x00000000 },
	{ .addr = 0x0f1c002cc, .val = 0x00000000 },
	{ .addr = 0x0f1c002d0, .val = 0x00000000 },
	{ .addr = 0x0f1c002d4, .val = 0x00000000 },
	{ .addr = 0x0f1c002d8, .val = 0x00000000 },
	{ .addr = 0x0f1c002dc, .val = 0x00000000 },
	{ .addr = 0x0f1c002e0, .val = 0x00000000 },
	{ .addr = 0x0f1c002e4, .val = 0x00000000 },
	{ .addr = 0x0f1c002e8, .val = 0x00000000 },
	{ .addr = 0x0f1c002ec, .val = 0x00000000 },
	{ .addr = 0x0f1c002f0, .val = 0x00000000 },
	{ .addr = 0x0f1c002f4, .val = 0x00000000 },
	{ .addr = 0x0f1c002f8, .val = 0x00000000 },
	{ .addr = 0x0f1c002fc, .val = 0x00000000 },
	{ .addr = 0x0f1c00300, .val = 0x00000000 },
	{ .addr = 0x0f1c00304, .val = 0x00000000 },
	{ .addr = 0x0f1c00308, .val = 0x00000000 },
	{ .addr = 0x0f1c0030c, .val = 0x00000000 },
	{ .addr = 0x0f1c00310, .val = 0x00000000 },
	{ .addr = 0x0f1c00314, .val = 0x00000000 },
	{ .addr = 0x0f1c00318, .val = 0x00000000 },
	{ .addr = 0x0f1c0031c, .val = 0x00000000 },
	{ .addr = 0x0f1c00320, .val = 0x00000000 },
	{ .addr = 0x0f1c00324, .val = 0x00000000 },
	{ .addr = 0x0f1c00328, .val = 0x00000000 },
	{ .addr = 0x0f1c0032c, .val = 0x00000100 },
	{ .addr = 0x0f1c00330, .val = 0x00000000 },
	{ .addr = 0x0f1c00334, .val = 0x00000000 },
	{ .addr = 0x0f1c00338, .val = 0x00000000 },
	{ .addr = 0x0f1c0033c, .val = 0x00000000 },
	{ .addr = 0x0f1c00340, .val = 0x00000000 },
	{ .addr = 0x0f1c00344, .val = 0x00000000 },
	{ .addr = 0x0f1c00348, .val = 0x00000000 },
	{ .addr = 0x0f1c0034c, .val = 0x00000000 },
	{ .addr = 0x0f1c00350, .val = 0x00000000 },
	{ .addr = 0x0f1c00354, .val = 0x00000000 },
	{ .addr = 0x0f1c00358, .val = 0x00000000 },
	{ .addr = 0x0f1c0035c, .val = 0x00000000 },
	{ .addr = 0x0f1c00360, .val = 0x00000000 },
	{ .addr = 0x0f1c00364, .val = 0x00000000 },
	{ .addr = 0x0f1c00368, .val = 0x00000000 },
	{ .addr = 0x0f1c0036c, .val = 0x00000000 },
	{ .addr = 0x0f1c00370, .val = 0x00000000 },
	{ .addr = 0x0f1c00374, .val = 0x00000000 },
	{ .addr = 0x0f1c00378, .val = 0x00000000 },
	{ .addr = 0x0f1c0037c, .val = 0x00000000 },
	{ .addr = 0x0f1c00380, .val = 0x00000000 },
	{ .addr = 0x0f1c00384, .val = 0x00000000 },
	{ .addr = 0x0f1c00388, .val = 0x00000000 },
	{ .addr = 0x0f1c0038c, .val = 0x00000000 },
	{ .addr = 0x0f1c00390, .val = 0x00000000 },
	{ .addr = 0x0f1c00394, .val = 0x00000000 },
	{ .addr = 0x0f1c00398, .val = 0x00000000 },
	{ .addr = 0x0f1c0039c, .val = 0x00000000 },
	{ .addr = 0x0f1c003a0, .val = 0x00000000 },
	{ .addr = 0x0f1c003a4, .val = 0x00000000 },
	{ .addr = 0x0f1c003a8, .val = 0x00000000 },
	{ .addr = 0x0f1c003ac, .val = 0x00000000 },
	{ .addr = 0x0f1c003b0, .val = 0x00000000 },
	{ .addr = 0x0f1c003b4, .val = 0x00000000 },
	{ .addr = 0x0f1c003b8, .val = 0x00000000 },
	{ .addr = 0x0f1c003bc, .val = 0x00000000 },
	{ .addr = 0x0f1c003c0, .val = 0x00000000 },
	{ .addr = 0x0f1c003c4, .val = 0x00000000 },
	{ .addr = 0x0f1c003c8, .val = 0x00000000 },
	{ .addr = 0x0f1c003cc, .val = 0x00000000 },
	{ .addr = 0x0f1c003d0, .val = 0x00000000 },
	{ .addr = 0x0f1c003d4, .val = 0x00000000 },
	{ .addr = 0x0f1c003d8, .val = 0x00000000 },
	{ .addr = 0x0f1c003dc, .val = 0x00000000 },
	{ .addr = 0x0f1c003e0, .val = 0x00000000 },
	{ .addr = 0x0f1c003e4, .val = 0x00041041 },
	{ .addr = 0x0f1c003e8, .val = 0x00041041 },
	{ .addr = 0x0f1c003ec, .val = 0x00041041 },
	{ .addr = 0x0f1c003f0, .val = 0x00041041 },
	{ .addr = 0x0f1c003fc, .val = 0x00000000 },
	{ .addr = 0x0f1c00400, .val = 0x00000000 },
	{ .addr = 0x0f1c00404, .val = 0x00000000 },
	{ .addr = 0x0f1c00408, .val = 0x00000000 },
	{ .addr = 0x0f1c0040c, .val = 0x00000000 },
	{ .addr = 0x0f1c00410, .val = 0x00000000 },
	{ .addr = 0x0f1c00414, .val = 0x00000000 },
	{ .addr = 0x0f1c00418, .val = 0x00000000 },
	{ .addr = 0x0f1c0041c, .val = 0x00000000 },
	{ .addr = 0x0f1800000, .val = 0x00000000 },
	{ .addr = 0x0f1800004, .val = 0x00000000 },
	{ .addr = 0x0f1800008, .val = 0x00000000 },
	{ .addr = 0x0f180000c, .val = 0x00000000 },
	{ .addr = 0x0f1800010, .val = 0x00000000 },
	{ .addr = 0x0f1800014, .val = 0x00000000 },
	{ .addr = 0x0f1800018, .val = 0x00000000 },
	{ .addr = 0x0f180001c, .val = 0x00000000 },
	{ .addr = 0x0f180002c, .val = 0x00000000 },
	{ .addr = 0x0f1800030, .val = 0x00000000 },
	{ .addr = 0x0f1800034, .val = 0x00000000 },
	{ .addr = 0x0f1800044, .val = 0x00000000 },
	{ .addr = 0x0f1800048, .val = 0x00000000 },
	{ .addr = 0x0f180004c, .val = 0x00000000 },
	{ .addr = 0x0f180005c, .val = 0x00000000 },
	{ .addr = 0x0f1800060, .val = 0x00000000 },
	{ .addr = 0x0f1800064, .val = 0x00000000 },
	{ .addr = 0x0f1800074, .val = 0x00000000 },
	{ .addr = 0x0f1800078, .val = 0x00000000 },
	{ .addr = 0x0f180007c, .val = 0x00000400 },
	{ .addr = 0x0f1800080, .val = 0x00000400 },
	{ .addr = 0x0f18000ac, .val = 0x00000001 },
	{ .addr = 0x0f1800100, .val = 0x00000000 },
	{ .addr = 0x0f1800104, .val = 0x00000000 },
	{ .addr = 0x0f1800108, .val = 0x00000000 },
	{ .addr = 0x0f180010c, .val = 0x00000000 },
	{ .addr = 0x0f1800118, .val = 0x00000001 },
	{ .addr = 0x0f1d00000, .val = 0x00000001 },
	{ .addr = 0x0f1d00008, .val = 0x00000000 },
	{ .addr = 0x0f1d00010, .val = 0x00000000 },
	{ .addr = 0x0f1d00014, .val = 0x00000000 },
	{ .addr = 0x0f1d00018, .val = 0x00000000 },
	{ .addr = 0x0f1d0001c, .val = 0x00000000 },
	{ .addr = 0x0f1d00020, .val = 0x00000000 },
	{ .addr = 0x0f1d00024, .val = 0x00000000 },
	{ .addr = 0x0f1d00028, .val = 0x00000000 },
	{ .addr = 0x0f1d0002c, .val = 0x00000000 },
	{ .addr = 0x0f1d00030, .val = 0x00000000 },
	{ .addr = 0x0f1d00034, .val = 0x00000000 },
	{ .addr = 0x0f1d00038, .val = 0x00000000 },
	{ .addr = 0x0f1d0003c, .val = 0x00000000 },
	{ .addr = 0x0f1d00040, .val = 0x00000000 },
	{ .addr = 0x0f1d00044, .val = 0x00000000 },
	{ .addr = 0x0f1d00048, .val = 0x00000000 },
	{ .addr = 0x0f1d0004c, .val = 0x00000000 },
	{ .addr = 0x0f1d00050, .val = 0x00000000 },
	{ .addr = 0x0f1d00054, .val = 0x00000000 },
	{ .addr = 0x0f1d00058, .val = 0x00000000 },
	{ .addr = 0x0f1d0005c, .val = 0x00000000 },
	{ .addr = 0x0f1d00060, .val = 0x00000000 },
	{ .addr = 0x0f1d00064, .val = 0x00000000 },
	{ .addr = 0x0f1d00068, .val = 0x00000000 },
	{ .addr = 0x0f1d0006c, .val = 0x00000000 },
	{ .addr = 0x0f1e00c00, .val = 0x00000001 },
	{ .addr = 0x0f1e00c08, .val = 0x00000000 },
	{ .addr = 0x0f1e00c10, .val = 0x00000000 },
	{ .addr = 0x0f1e00c14, .val = 0x00000000 },
	{ .addr = 0x0f1e00c18, .val = 0x00000000 },
	{ .addr = 0x0f1e00c1c, .val = 0x00000000 },
	{ .addr = 0x0f1e00c20, .val = 0x00000000 },
	{ .addr = 0x0f1e00c24, .val = 0x00000000 },
	{ .addr = 0x0f1e00c28, .val = 0x00000000 },
	{ .addr = 0x0f1e00c2c, .val = 0x00000000 },
	{ .addr = 0x0f1e00c30, .val = 0x00000000 },
	{ .addr = 0x0f1e00c34, .val = 0x00000000 },
	{ .addr = 0x0f1e00c38, .val = 0x00000000 },
	{ .addr = 0x0f1e00c3c, .val = 0x00000000 },
	{ .addr = 0x0f1e00c40, .val = 0x00000000 },
	{ .addr = 0x0f1e00c44, .val = 0x00000000 },
	{ .addr = 0x0f1e00c48, .val = 0x00000000 },
	{ .addr = 0x0f1e00c4c, .val = 0x00000000 },
	{ .addr = 0x0f1e00c50, .val = 0x00000000 },
	{ .addr = 0x0f1e00c54, .val = 0x00000000 },
	{ .addr = 0x0f1e00c58, .val = 0x00000000 },
	{ .addr = 0x0f1e00c5c, .val = 0x00000000 },
	{ .addr = 0x0f1e00c60, .val = 0x00000000 },
	{ .addr = 0x0f1e00c64, .val = 0x00000000 },
	{ .addr = 0x0f1e00c68, .val = 0x00000000 },
	{ .addr = 0x0f1e00c6c, .val = 0x00000000 },
	{ .addr = 0x0f2000000, .val = 0x0000006c },
	{ .addr = 0x0f2000004, .val = 0x00000000 },
	{ .addr = 0x0f2000008, .val = 0x00000000 },
	{ .addr = 0x0f200000c, .val = 0x00000000 },
	{ .addr = 0x0f2000010, .val = 0x00000000 },
	{ .addr = 0x0f2000014, .val = 0x00000000 },
	{ .addr = 0x0f2000018, .val = 0x00000000 },
	{ .addr = 0x0f200001c, .val = 0x00000000 },
	{ .addr = 0x0f2000020, .val = 0x00000000 },
	{ .addr = 0x0f2000024, .val = 0x00000000 },
	{ .addr = 0x0f2000028, .val = 0x00000000 },
	{ .addr = 0x0f200002c, .val = 0x00000000 },
	{ .addr = 0x0f2000030, .val = 0x00000000 },
	{ .addr = 0x0f2000034, .val = 0x00000000 },
	{ .addr = 0x0f2000038, .val = 0x00000000 },
	{ .addr = 0x0f200003c, .val = 0x00000000 },
	{ .addr = 0x0f2000040, .val = 0x00000000 },
	{ .addr = 0x0f2000044, .val = 0x00000000 },
	{ .addr = 0x0f2000048, .val = 0x00000000 },
	{ .addr = 0x0f0006000, .val = 0x00000001 },
	{ .addr = 0x0f0006004, .val = 0x00000000 },
	{ .addr = 0x0f0006008, .val = 0x00000000 },
	{ .addr = 0x0f000600c, .val = 0x00000000 },
	{ .addr = 0x0f0006010, .val = 0x00000000 },
	{ .addr = 0x0f0006014, .val = 0x00000000 },
	{ .addr = 0x0f0006020, .val = 0x00000000 },
	{ .addr = 0x0f0006024, .val = 0x00088080 },
	{ .addr = 0x0f0006028, .val = 0x00000000 },
	{ .addr = 0x0f000602c, .val = 0x00000000 },
	{ .addr = 0x0f0006030, .val = 0x00000000 },
	{ .addr = 0x0f0006034, .val = 0x00000000 },
	{ .addr = 0x0f0006038, .val = 0x00000000 },
	{ .addr = 0x0f0006040, .val = 0x00000000 },
	{ .addr = 0x0f0006044, .val = 0x00000000 },
	{ .addr = 0x0f0006048, .val = 0x00000000 },
	{ .addr = 0x0f000604c, .val = 0x00000000 },
	{ .addr = 0x0f0006050, .val = 0x00000000 },
	{ .addr = 0x0f0006054, .val = 0x00000000 },
	{ .addr = 0x0f0006058, .val = 0x00000000 },
	{ .addr = 0x0f000605c, .val = 0x00000000 },
	{ .addr = 0x0f0006060, .val = 0x00000000 },
	{ .addr = 0x0f0006064, .val = 0x00000000 },
	{ .addr = 0x0f0006068, .val = 0x00000000 },
	{ .addr = 0x0f000606c, .val = 0x00000000 },
	{ .addr = 0x0f0006070, .val = 0x00000000 },
	{ .addr = 0x0f0006074, .val = 0x00000000 },
	{ .addr = 0x0f0006078, .val = 0x00000000 },
	{ .addr = 0x0f000607c, .val = 0x00000000 },
	{ .addr = 0x0f0006080, .val = 0x00000000 },
	{ .addr = 0x0f0006084, .val = 0x00000000 },
	{ .addr = 0x0f0006088, .val = 0x00000000 },
	{ .addr = 0x0f000608c, .val = 0x00000000 },
	{ .addr = 0x0f0006090, .val = 0x00000000 },
	{ .addr = 0x0f0006094, .val = 0x00000000 },
	{ .addr = 0x0f0006098, .val = 0x00000000 },
	{ .addr = 0x0f000609c, .val = 0x00000000 },
	{ .addr = 0x0f00060a0, .val = 0x00000000 },
	{ .addr = 0x0f00060a4, .val = 0x00000000 },
	{ .addr = 0x0f00060a8, .val = 0x00000000 },
	{ .addr = 0x0f00060ac, .val = 0x00000000 },
	{ .addr = 0x0f00060b0, .val = 0x00000000 },
	{ .addr = 0x0f00060b4, .val = 0x00000000 },
	{ .addr = 0x0f00060b8, .val = 0x00000000 },
	{ .addr = 0x0f00060bc, .val = 0x00000000 },
	{ .addr = 0x0f00060c0, .val = 0x00000000 },
	{ .addr = 0x0f00060c4, .val = 0x00000000 },
	{ .addr = 0x0f00060c8, .val = 0x00000000 },
	{ .addr = 0x0f00060cc, .val = 0x00000000 },
	{ .addr = 0x0f00060d0, .val = 0x00000000 },
	{ .addr = 0x0f00060d4, .val = 0x00000000 },
	{ .addr = 0x0f00060d8, .val = 0x00000000 },
	{ .addr = 0x0f00060dc, .val = 0x00000000 },
	{ .addr = 0x0f00060e0, .val = 0x00000000 },
	{ .addr = 0x0f00060e4, .val = 0x00000000 },
	{ .addr = 0x0f00060e8, .val = 0x00000000 },
	{ .addr = 0x0f00060ec, .val = 0x00000000 },
	{ .addr = 0x0f00060f0, .val = 0x00000000 },
	{ .addr = 0x0f00060f4, .val = 0x00000000 },
	{ .addr = 0x0f00060f8, .val = 0x00000000 },
	{ .addr = 0x0f00060fc, .val = 0x00000000 },
	{ .addr = 0x0f0006100, .val = 0x00000000 },
	{ .addr = 0x0f0006104, .val = 0x00000000 },
	{ .addr = 0x0f0006108, .val = 0x00000000 },
	{ .addr = 0x0f000610c, .val = 0x00000000 },
	{ .addr = 0x0f0006110, .val = 0x00000000 },
	{ .addr = 0x0f0006114, .val = 0x00000000 },
	{ .addr = 0x0f0006118, .val = 0x00000000 },
	{ .addr = 0x0f000611c, .val = 0x00000000 },
	{ .addr = 0x0f0006120, .val = 0x00000000 },
	{ .addr = 0x0f0006124, .val = 0x00000000 },
	{ .addr = 0x0f0006128, .val = 0x00000000 },
	{ .addr = 0x0f000612c, .val = 0x00000000 },
	{ .addr = 0x0f0006130, .val = 0x00000000 },
	{ .addr = 0x0f0006134, .val = 0x00000000 },
	{ .addr = 0x0f0006138, .val = 0x00000000 },
	{ .addr = 0x0f000613c, .val = 0x00000000 },
	{ .addr = 0x0f0006140, .val = 0x00000000 },
	{ .addr = 0x0f0006144, .val = 0x00000000 },
	{ .addr = 0x0f0006148, .val = 0x00000000 },
	{ .addr = 0x0f000614c, .val = 0x00000000 },
	{ .addr = 0x0f0006150, .val = 0x00000000 },
	{ .addr = 0x0f0006154, .val = 0x00000000 },
	{ .addr = 0x0f0006158, .val = 0x00000000 },
	{ .addr = 0x0f000615c, .val = 0x00000000 },
	{ .addr = 0x0f0006160, .val = 0x00000000 },
	{ .addr = 0x0f0006164, .val = 0x00000000 },
	{ .addr = 0x0f0006168, .val = 0x00000000 },
	{ .addr = 0x0f000616c, .val = 0x00000000 },
	{ .addr = 0x0f0006170, .val = 0x00000000 },
	{ .addr = 0x0f0006174, .val = 0x00000000 },
	{ .addr = 0x0f0006178, .val = 0x00000000 },
	{ .addr = 0x0f000617c, .val = 0x00000000 },
	{ .addr = 0x0f0006180, .val = 0x00000000 },
	{ .addr = 0x0f0006184, .val = 0x00000000 },
	{ .addr = 0x0f0006188, .val = 0x00000000 },
	{ .addr = 0x0f000618c, .val = 0x00000000 },
	{ .addr = 0x0f0006190, .val = 0x00000000 },
	{ .addr = 0x0f0006194, .val = 0x00000000 },
	{ .addr = 0x0f0006198, .val = 0x00000000 },
	{ .addr = 0x0f000619c, .val = 0x00000000 },
	{ .addr = 0x0f00061a0, .val = 0x00000000 },
	{ .addr = 0x0f00061a4, .val = 0x00000000 },
	{ .addr = 0x0f00061a8, .val = 0x00000000 },
	{ .addr = 0x0f00061ac, .val = 0x00000000 },
	{ .addr = 0x0f00061b0, .val = 0x00000000 },
	{ .addr = 0x0f00061b4, .val = 0x00000000 },
	{ .addr = 0x0f00061b8, .val = 0x00000000 },
	{ .addr = 0x0f00061bc, .val = 0x00000000 },
	{ .addr = 0x0f00061c0, .val = 0x00000000 },
	{ .addr = 0x0f00061c4, .val = 0x00000000 },
	{ .addr = 0x0f00061c8, .val = 0x00000000 },
	{ .addr = 0x0f00061cc, .val = 0x00000000 },
	{ .addr = 0x0f00061d0, .val = 0x00000000 },
	{ .addr = 0x0f00061d4, .val = 0x00000000 },
	{ .addr = 0x0f00061d8, .val = 0x00000000 },
	{ .addr = 0x0f00061dc, .val = 0x00000000 },
	{ .addr = 0x0f00061e0, .val = 0x00000000 },
	{ .addr = 0x0f00061e4, .val = 0x00000000 },
	{ .addr = 0x0f00061e8, .val = 0x00000000 },
	{ .addr = 0x0f00061ec, .val = 0x00000000 },
	{ .addr = 0x0f00061f0, .val = 0x00000000 },
	{ .addr = 0x0f00061f4, .val = 0x00000000 },
	{ .addr = 0x0f00061f8, .val = 0x00000000 },
	{ .addr = 0x0f00061fc, .val = 0x00000000 },
	{ .addr = 0x0f0006200, .val = 0x00000000 },
	{ .addr = 0x0f0006204, .val = 0x00000000 },
	{ .addr = 0x0f0006208, .val = 0x00000000 },
	{ .addr = 0x0f000620c, .val = 0x00000000 },
	{ .addr = 0x0f0006210, .val = 0x00000000 },
	{ .addr = 0x0f0006214, .val = 0x00000000 },
	{ .addr = 0x0f0006218, .val = 0x00000000 },
	{ .addr = 0x0f000621c, .val = 0x00000000 },
	{ .addr = 0x0f0006220, .val = 0x00000000 },
	{ .addr = 0x0f0006224, .val = 0x00000000 },
	{ .addr = 0x0f0006228, .val = 0x00000000 },
	{ .addr = 0x0f000622c, .val = 0x00000000 },
	{ .addr = 0x0f0006230, .val = 0x00000000 },
	{ .addr = 0x0f0006234, .val = 0x00000000 },
	{ .addr = 0x0f0006238, .val = 0x00000000 },
	{ .addr = 0x0f000623c, .val = 0x00000000 },
	{ .addr = 0x0f0006240, .val = 0x00000000 },
	{ .addr = 0x0f0006244, .val = 0x00000000 },
	{ .addr = 0x0f0006248, .val = 0x00000000 },
	{ .addr = 0x0f000624c, .val = 0x00000000 },
	{ .addr = 0x0f0006250, .val = 0x00000000 },
	{ .addr = 0x0f0006254, .val = 0x00000000 },
	{ .addr = 0x0f0006258, .val = 0x00000000 },
	{ .addr = 0x0f000625c, .val = 0x00000000 },
	{ .addr = 0x0f0006260, .val = 0x00000000 },
	{ .addr = 0x0f0006264, .val = 0x00000000 },
	{ .addr = 0x0f0006268, .val = 0x00000000 },
	{ .addr = 0x0f000626c, .val = 0x00000000 },
	{ .addr = 0x0f0006270, .val = 0x00000000 },
	{ .addr = 0x0f0006274, .val = 0x00000000 },
	{ .addr = 0x0f0006278, .val = 0x00000000 },
	{ .addr = 0x0f000627c, .val = 0x00000000 },
	{ .addr = 0x0f0006280, .val = 0x00000000 },
	{ .addr = 0x0f0006284, .val = 0x00000000 },
	{ .addr = 0x0f0006288, .val = 0x00000000 },
	{ .addr = 0x0f000628c, .val = 0x00000000 },
	{ .addr = 0x0f0006290, .val = 0x00000000 },
	{ .addr = 0x0f0006294, .val = 0x00000000 },
	{ .addr = 0x0f0006298, .val = 0x00000000 },
	{ .addr = 0x0f000629c, .val = 0x00000000 },
	{ .addr = 0x0f00062a0, .val = 0x00000000 },
	{ .addr = 0x0f00062a4, .val = 0x00000000 },
	{ .addr = 0x0f00062a8, .val = 0x00000000 },
	{ .addr = 0x0f00062ac, .val = 0x00000000 },
	{ .addr = 0x0f00062b0, .val = 0x00000000 },
	{ .addr = 0x0f00062b4, .val = 0x00000000 },
	{ .addr = 0x0f00062b8, .val = 0x00000000 },
	{ .addr = 0x0f00062bc, .val = 0x00000000 },
	{ .addr = 0x0f00062c0, .val = 0x00000000 },
	{ .addr = 0x0f00062c4, .val = 0x00000000 },
	{ .addr = 0x0f00062c8, .val = 0x00000000 },
	{ .addr = 0x0f00062cc, .val = 0x00000000 },
	{ .addr = 0x0f00062d0, .val = 0x00000000 },
	{ .addr = 0x0f00062d4, .val = 0x00000000 },
	{ .addr = 0x0f00062d8, .val = 0x00000000 },
	{ .addr = 0x0f00062dc, .val = 0x00000000 },
	{ .addr = 0x0f00062e0, .val = 0x00000000 },
	{ .addr = 0x0f00062e4, .val = 0x00000000 },
	{ .addr = 0x0f00062e8, .val = 0x00000000 },
	{ .addr = 0x0f00062ec, .val = 0x00000000 },
	{ .addr = 0x0f00062f0, .val = 0x00000000 },
	{ .addr = 0x0f00062f4, .val = 0x00000000 },
	{ .addr = 0x0f00062f8, .val = 0x00000000 },
	{ .addr = 0x0f00062fc, .val = 0x00000000 },
	{ .addr = 0x0f0006300, .val = 0x00000000 },
	{ .addr = 0x0f0006304, .val = 0x00000000 },
	{ .addr = 0x0f0006308, .val = 0x00000000 },
	{ .addr = 0x0f000630c, .val = 0x00000000 },
	{ .addr = 0x0f0006310, .val = 0x00000000 },
	{ .addr = 0x0f0006314, .val = 0x00000000 },
	{ .addr = 0x0f0006318, .val = 0x00000000 },
	{ .addr = 0x0f000631c, .val = 0x00000000 },
	{ .addr = 0x0f0006320, .val = 0x00000000 },
	{ .addr = 0x0f0006324, .val = 0x00000000 },
	{ .addr = 0x0f0006328, .val = 0x00000000 },
	{ .addr = 0x0f000632c, .val = 0x00000000 },
	{ .addr = 0x0f0006330, .val = 0x00000000 },
	{ .addr = 0x0f0006334, .val = 0x00000000 },
	{ .addr = 0x0f0006338, .val = 0x00000000 },
	{ .addr = 0x0f000633c, .val = 0x00000000 },
	{ .addr = 0x0f0006340, .val = 0x00000000 },
	{ .addr = 0x0f0006344, .val = 0x00000000 },
	{ .addr = 0x0f0006348, .val = 0x00000000 },
	{ .addr = 0x0f000634c, .val = 0x00000000 },
	{ .addr = 0x0f0006350, .val = 0x00000000 },
	{ .addr = 0x0f0006354, .val = 0x00000000 },
	{ .addr = 0x0f0006358, .val = 0x00000000 },
	{ .addr = 0x0f000635c, .val = 0x00000000 },
	{ .addr = 0x0f0006360, .val = 0x00000000 },
	{ .addr = 0x0f0006364, .val = 0x00000000 },
	{ .addr = 0x0f0006368, .val = 0x00000000 },
	{ .addr = 0x0f000636c, .val = 0x00000000 },
	{ .addr = 0x0f0006370, .val = 0x00000000 },
	{ .addr = 0x0f0006374, .val = 0x00000000 },
	{ .addr = 0x0f0006378, .val = 0x00000000 },
	{ .addr = 0x0f000637c, .val = 0x00000000 },
	{ .addr = 0x0f0006380, .val = 0x00000000 },
	{ .addr = 0x0f0006384, .val = 0x00000000 },
	{ .addr = 0x0f0006388, .val = 0x00000000 },
	{ .addr = 0x0f000638c, .val = 0x00000000 },
	{ .addr = 0x0f0006390, .val = 0x00000000 },
	{ .addr = 0x0f0006394, .val = 0x00000000 },
	{ .addr = 0x0f0006398, .val = 0x00000000 },
	{ .addr = 0x0f000639c, .val = 0x00000000 },
	{ .addr = 0x0f00063a0, .val = 0x00000000 },
	{ .addr = 0x0f00063a4, .val = 0x00000000 },
	{ .addr = 0x0f00063a8, .val = 0x00000000 },
	{ .addr = 0x0f00063ac, .val = 0x00000000 },
	{ .addr = 0x0f00063b0, .val = 0x00000000 },
	{ .addr = 0x0f00063b4, .val = 0x00000000 },
	{ .addr = 0x0f00063b8, .val = 0x00000000 },
	{ .addr = 0x0f00063bc, .val = 0x00000000 },
	{ .addr = 0x0f00063c0, .val = 0x00000000 },
	{ .addr = 0x0f00063c4, .val = 0x00000000 },
	{ .addr = 0x0f00063c8, .val = 0x00000000 },
	{ .addr = 0x0f00063cc, .val = 0x00000000 },
	{ .addr = 0x0f00063d0, .val = 0x00000000 },
	{ .addr = 0x0f00063d4, .val = 0x00000000 },
	{ .addr = 0x0f00063d8, .val = 0x00000000 },
	{ .addr = 0x0f00063dc, .val = 0x00000000 },
	{ .addr = 0x0f00063e0, .val = 0x00000000 },
	{ .addr = 0x0f00063e4, .val = 0x00000000 },
	{ .addr = 0x0f00063e8, .val = 0x00000000 },
	{ .addr = 0x0f00063ec, .val = 0x00000000 },
	{ .addr = 0x0f00063f0, .val = 0x00000000 },
	{ .addr = 0x0f00063f4, .val = 0x00000000 },
	{ .addr = 0x0f00063f8, .val = 0x00000000 },
	{ .addr = 0x0f00063fc, .val = 0x00000000 },
	{ .addr = 0x0f0006400, .val = 0x00000000 },
	{ .addr = 0x0f0006404, .val = 0x00000000 },
	{ .addr = 0x0f0006408, .val = 0x00000000 },
	{ .addr = 0x0f000640c, .val = 0x00000000 },
	{ .addr = 0x0f0006410, .val = 0x00000000 },
	{ .addr = 0x0f0006414, .val = 0x00000000 },
	{ .addr = 0x0f0006418, .val = 0x00000000 },
	{ .addr = 0x0f000641c, .val = 0x00000000 },
	{ .addr = 0x0f0006420, .val = 0x00000000 },
	{ .addr = 0x0f0006424, .val = 0x00000000 },
	{ .addr = 0x0f0006428, .val = 0x00000000 },
	{ .addr = 0x0f000642c, .val = 0x00000000 },
	{ .addr = 0x0f0006430, .val = 0x00000000 },
	{ .addr = 0x0f0006434, .val = 0x00000000 },
	{ .addr = 0x0f0006438, .val = 0x00000000 },
	{ .addr = 0x0f000643c, .val = 0x00000000 },
	{ .addr = 0x0f0006534, .val = 0x00000000 },
	{ .addr = 0x0f0006938, .val = 0x00000000 },
	{ .addr = 0x0f000693c, .val = 0x00000000 },
	{ .addr = 0x0f0006940, .val = 0x00000000 },
	{ .addr = 0x0f0006944, .val = 0x00000000 },
	{ .addr = 0x0f0006948, .val = 0x00000000 },
	{ .addr = 0x0f000694c, .val = 0x10000008 },
	{ .addr = 0x0f000695c, .val = 0x00000000 },
	{ .addr = 0x0f0006960, .val = 0x00000000 },
	{ .addr = 0x0f0006964, .val = 0x00000000 },
	{ .addr = 0x0f0006968, .val = 0x00000000 },
	{ .addr = 0x0f000696c, .val = 0x00000000 },
	{ .addr = 0x0f0006970, .val = 0x00000000 },
	{ .addr = 0x0f0006974, .val = 0x00000000 },
	{ .addr = 0x0f0006978, .val = 0x00000000 },
	{ .addr = 0x0f000697c, .val = 0x00000000 },
	{ .addr = 0x0f0006990, .val = 0x00003f80 },
	{ .addr = 0x0f000699c, .val = 0x00000000 },
	{ .addr = 0x0f00069a0, .val = 0x00000000 },
	{ .addr = 0x0f00069a4, .val = 0x00000000 },
	{ .addr = 0x0f00069a8, .val = 0x00000000 },
	{ .addr = 0x0f00069ac, .val = 0x00000000 },
	{ .addr = 0x0f00069b0, .val = 0x00000000 },
	{ .addr = 0x0f00069b4, .val = 0x00000000 },
	{ .addr = 0x0f1000000, .val = 0x0000ffff },
	{ .addr = 0x0f1000004, .val = 0x0000ffff },
	{ .addr = 0x0f1000008, .val = 0x0000ffff },
	{ .addr = 0x0f100000c, .val = 0x0000ffff },
	{ .addr = 0x0f1000010, .val = 0x0000ffff },
	{ .addr = 0x0f1000014, .val = 0x0000ffff },
	{ .addr = 0x0f1000018, .val = 0x0000ffff },
	{ .addr = 0x0f100001c, .val = 0x0000ffff },
	{ .addr = 0x0f1000020, .val = 0x0000ffff },
	{ .addr = 0x0f1000024, .val = 0x0000ffff },
	{ .addr = 0x0f1000028, .val = 0x0000ffff },
	{ .addr = 0x0f100002c, .val = 0x0000ffff },
	{ .addr = 0x0f1000030, .val = 0x0000ffff },
	{ .addr = 0x0f1000034, .val = 0x0000ffff },
	{ .addr = 0x0f1000038, .val = 0x0000ffff },
	{ .addr = 0x0f100003c, .val = 0x0000ffff },
	{ .addr = 0x0f1000040, .val = 0x00000000 },
	{ .addr = 0x0f1000044, .val = 0x00000000 },
	{ .addr = 0x0f100004c, .val = 0x00000000 },
	{ .addr = 0x0f1000080, .val = 0x00000002 },
	{ .addr = 0x0f10000a4, .val = 0x0000003f },
	{ .addr = 0x0f10000ac, .val = 0x00000000 },
	{ .addr = 0x0f10000b0, .val = 0x00000000 },
	{ .addr = 0x0f10000b4, .val = 0x00000000 },
	{ .addr = 0x0f10000b8, .val = 0x00000000 },
	{ .addr = 0x0f10000bc, .val = 0x00000000 },
	{ .addr = 0x0f10000c0, .val = 0x00000000 },
	{ .addr = 0x0f10000c4, .val = 0x00000000 },
	{ .addr = 0x0f10000c8, .val = 0x00000000 },
	{ .addr = 0x0f10000cc, .val = 0x00000000 },
	{ .addr = 0x0f10000d0, .val = 0x00000000 },
	{ .addr = 0x0f10000d4, .val = 0x00000000 },
	{ .addr = 0x0f10000d8, .val = 0x00000000 },
	{ .addr = 0x0f10000dc, .val = 0x00000000 },
	{ .addr = 0x0f10000e0, .val = 0x00000000 },
	{ .addr = 0x0f10000e4, .val = 0x00000000 },
	{ .addr = 0x0f10000e8, .val = 0x00000000 },
	{ .addr = 0x0f10000ec, .val = 0x00000000 },
	{ .addr = 0x0f10000f0, .val = 0x00000000 },
	{ .addr = 0x0f10000f4, .val = 0x00000000 },
	{ .addr = 0x0f10000f8, .val = 0x00000000 },
	{ .addr = 0x0f10000fc, .val = 0x00000000 },
	{ .addr = 0x0f1000100, .val = 0x00000000 },
	{ .addr = 0x0f1000104, .val = 0x00000000 },
	{ .addr = 0x0f1000108, .val = 0x00000000 },
	{ .addr = 0x0f100010c, .val = 0x00000000 },
	{ .addr = 0x0f1000110, .val = 0x00000000 },
	{ .addr = 0x0f1000114, .val = 0x00000000 },
	{ .addr = 0x0f1000118, .val = 0x00000000 },
	{ .addr = 0x0f100011c, .val = 0x00000000 },
	{ .addr = 0x0f1000120, .val = 0x00000000 },
	{ .addr = 0x0f1000124, .val = 0x00000000 },
	{ .addr = 0x0f1000128, .val = 0x00000000 },
	{ .addr = 0x0f100012c, .val = 0x00000000 },
	{ .addr = 0x0f1000130, .val = 0x00000000 },
	{ .addr = 0x0f1000134, .val = 0x00000000 },
	{ .addr = 0x0f1000138, .val = 0x00000000 },
	{ .addr = 0x0f100013c, .val = 0x00000003 },
	{ .addr = 0x0f1000140, .val = 0x00000000 },
	{ .addr = 0x0f1000144, .val = 0x00000040 },
	{ .addr = 0x0f1000148, .val = 0x00000000 },
	{ .addr = 0x0f100014c, .val = 0x00000001 },
	{ .addr = 0x0f1000150, .val = 0x00000000 },
	{ .addr = 0x0f1000154, .val = 0x00000000 },
	{ .addr = 0x0f1000158, .val = 0x00000000 },
	{ .addr = 0x0f100015c, .val = 0x00000000 },
	{ .addr = 0x0f1000160, .val = 0x00000000 },
	{ .addr = 0x0f1000164, .val = 0x00000000 },
	{ .addr = 0x0f1000168, .val = 0x00000000 },
	{ .addr = 0x0f1000200, .val = 0x00020311 },
	{ .addr = 0x0f1000204, .val = 0x00020311 },
	{ .addr = 0x0f1000210, .val = 0x00020311 },
	{ .addr = 0x0f1000214, .val = 0x00020311 },
	{ .addr = 0x0f1000218, .val = 0x00020311 },
	{ .addr = 0x0f1000220, .val = 0x0000000c },
	{ .addr = 0x0f1000224, .val = 0x0000000c },
	{ .addr = 0x0f1000228, .val = 0x0000000c },
	{ .addr = 0x0f1000230, .val = 0x0000000c },
	{ .addr = 0x0f1000234, .val = 0x0000000c },
	{ .addr = 0x0f1000238, .val = 0x00000000 },
	{ .addr = 0x0f100023c, .val = 0x00000000 },
	{ .addr = 0x0f1000240, .val = 0x00000000 },
	{ .addr = 0x0f1000244, .val = 0x00000000 },
	{ .addr = 0x0f1000248, .val = 0x00000000 },
	{ .addr = 0x0f100024c, .val = 0x00000000 },
	{ .addr = 0x0f1000250, .val = 0x00000000 },
	{ .addr = 0x0f1000254, .val = 0x00000000 },
	{ .addr = 0x0f1000258, .val = 0x00000000 },
	{ .addr = 0x0f100025c, .val = 0x00000000 },
	{ .addr = 0x0f1000260, .val = 0x00000000 },
	{ .addr = 0x0f1000264, .val = 0x00000000 },
	{ .addr = 0x0f1000268, .val = 0x00000000 },
	{ .addr = 0x0f100026c, .val = 0x00000000 },
	{ .addr = 0x0f1000270, .val = 0x00000000 },
	{ .addr = 0x0f1000274, .val = 0x00000000 },
	{ .addr = 0x0f1000278, .val = 0x00000000 },
	{ .addr = 0x0f100027c, .val = 0x00000000 },
	{ .addr = 0x0f1000280, .val = 0x00000000 },
	{ .addr = 0x0f1000284, .val = 0x00000000 },
	{ .addr = 0x0f1000288, .val = 0x00000000 },
	{ .addr = 0x0f100028c, .val = 0x00000000 },
	{ .addr = 0x0f1000290, .val = 0x00000000 },
	{ .addr = 0x0f1000294, .val = 0x00000000 },
	{ .addr = 0x0f1000298, .val = 0x00000000 },
	{ .addr = 0x0f100029c, .val = 0x00000000 },
	{ .addr = 0x0f10002a0, .val = 0x00000000 },
	{ .addr = 0x0f10002a4, .val = 0x00000000 },
	{ .addr = 0x0f10002a8, .val = 0x00000000 },
	{ .addr = 0x0f10002ac, .val = 0x00000000 },
	{ .addr = 0x0f10002b0, .val = 0x00000000 },
	{ .addr = 0x0f10002b4, .val = 0x00000000 },
	{ .addr = 0x0f10002b8, .val = 0x00000000 },
	{ .addr = 0x0f10002bc, .val = 0x00000000 },
	{ .addr = 0x0f10002c0, .val = 0x00000000 },
	{ .addr = 0x0f10002c4, .val = 0x00000000 },
	{ .addr = 0x0f10002c8, .val = 0x00000000 },
	{ .addr = 0x0f10002cc, .val = 0x00000000 },
	{ .addr = 0x0f10002d0, .val = 0x00000000 },
	{ .addr = 0x0f10002d4, .val = 0x00000000 },
	{ .addr = 0x0f10002d8, .val = 0x00000000 },
	{ .addr = 0x0f10002dc, .val = 0x00000000 },
	{ .addr = 0x0f10002e0, .val = 0x00000000 },
	{ .addr = 0x0f10002e4, .val = 0x00000000 },
	{ .addr = 0x0f10002e8, .val = 0x00000000 },
	{ .addr = 0x0f10002ec, .val = 0x00000000 },
	{ .addr = 0x0f10002f0, .val = 0x00000000 },
	{ .addr = 0x0f10002f4, .val = 0x00000000 },
	{ .addr = 0x0f10002f8, .val = 0x00000000 },
	{ .addr = 0x0f10002fc, .val = 0x00000000 },
	{ .addr = 0x0f1000300, .val = 0x00000000 },
	{ .addr = 0x0f1000304, .val = 0x00000000 },
	{ .addr = 0x0f1000308, .val = 0x00000000 },
	{ .addr = 0x0f100030c, .val = 0x00000000 },
	{ .addr = 0x0f1000310, .val = 0x00000000 },
	{ .addr = 0x0f1000314, .val = 0x00000000 },
	{ .addr = 0x0f1000318, .val = 0x00000000 },
	{ .addr = 0x0f100031c, .val = 0x00000000 },
	{ .addr = 0x0f1000320, .val = 0x00000000 },
	{ .addr = 0x0f1000324, .val = 0x00000000 },
	{ .addr = 0x0f1000328, .val = 0x00000000 },
	{ .addr = 0x0f100032c, .val = 0x00000000 },
	{ .addr = 0x0f1000330, .val = 0x00000000 },
	{ .addr = 0x0f1000334, .val = 0x00000000 },
	{ .addr = 0x0f1000338, .val = 0x00000000 },
	{ .addr = 0x0f100033c, .val = 0x00000000 },
	{ .addr = 0x0f1000340, .val = 0x00000000 },
	{ .addr = 0x0f1000344, .val = 0x00000000 },
	{ .addr = 0x0f1000348, .val = 0x00000000 },
	{ .addr = 0x0f100034c, .val = 0x00000000 },
	{ .addr = 0x0f1000350, .val = 0x00000000 },
	{ .addr = 0x0f1000354, .val = 0x00000000 },
	{ .addr = 0x0f1000358, .val = 0x00000000 },
	{ .addr = 0x0f100035c, .val = 0x00000000 },
	{ .addr = 0x0f1000360, .val = 0x00000000 },
	{ .addr = 0x0f1000364, .val = 0x00000000 },
	{ .addr = 0x0f1000368, .val = 0x00000000 },
	{ .addr = 0x0f100036c, .val = 0x00000000 },
	{ .addr = 0x0f1000370, .val = 0x00000000 },
	{ .addr = 0x0f1000374, .val = 0x00000000 },
	{ .addr = 0x0f1000378, .val = 0x00000000 },
	{ .addr = 0x0f100037c, .val = 0x00000000 },
	{ .addr = 0x0f1000380, .val = 0x00000000 },
	{ .addr = 0x0f1000384, .val = 0x00000000 },
	{ .addr = 0x0f1000388, .val = 0x00000000 },
	{ .addr = 0x0f100038c, .val = 0x00000000 },
	{ .addr = 0x0f1000390, .val = 0x00000000 },
	{ .addr = 0x0f1000394, .val = 0x00000000 },
	{ .addr = 0x0f1000398, .val = 0x00000000 },
	{ .addr = 0x0f100039c, .val = 0x00000000 },
	{ .addr = 0x0f10003a0, .val = 0x00000000 },
	{ .addr = 0x0f10003a4, .val = 0x00000000 },
	{ .addr = 0x0f10003a8, .val = 0x00000000 },
	{ .addr = 0x0f10003ac, .val = 0x00000000 },
	{ .addr = 0x0f10003b0, .val = 0x00000000 },
	{ .addr = 0x0f10003b4, .val = 0x00000000 },
	{ .addr = 0x0f10003b8, .val = 0x00000000 },
	{ .addr = 0x0f10003bc, .val = 0x00000000 },
	{ .addr = 0x0f10003c0, .val = 0x00000000 },
	{ .addr = 0x0f10003c4, .val = 0x00000000 },
	{ .addr = 0x0f10003c8, .val = 0x00000000 },
	{ .addr = 0x0f10003cc, .val = 0x00000000 },
	{ .addr = 0x0f10003d0, .val = 0x00000000 },
	{ .addr = 0x0f10003d4, .val = 0x00000000 },
	{ .addr = 0x0f10003d8, .val = 0x00000000 },
	{ .addr = 0x0f10003dc, .val = 0x00000000 },
	{ .addr = 0x0f10003e0, .val = 0x00000000 },
	{ .addr = 0x0f10003e4, .val = 0x00000000 },
	{ .addr = 0x0f10003e8, .val = 0x00000000 },
	{ .addr = 0x0f10003ec, .val = 0x00000000 },
	{ .addr = 0x0f10003f0, .val = 0x00000000 },
	{ .addr = 0x0f10003f4, .val = 0x00000000 },
	{ .addr = 0x0f10003f8, .val = 0x00000000 },
	{ .addr = 0x0f10003fc, .val = 0x00000000 },
	{ .addr = 0x0f1000400, .val = 0x00000000 },
	{ .addr = 0x0f1000404, .val = 0x00000000 },
	{ .addr = 0x0f1000408, .val = 0x00000000 },
	{ .addr = 0x0f100040c, .val = 0x00000000 },
	{ .addr = 0x0f1000410, .val = 0x00000000 },
	{ .addr = 0x0f1000414, .val = 0x00000000 },
	{ .addr = 0x0f1000418, .val = 0x00000000 },
	{ .addr = 0x0f100041c, .val = 0x00000000 },
	{ .addr = 0x0f1000420, .val = 0x00000000 },
	{ .addr = 0x0f1000424, .val = 0x00000000 },
	{ .addr = 0x0f1000428, .val = 0x00000000 },
	{ .addr = 0x0f100042c, .val = 0x00000000 },
	{ .addr = 0x0f1000430, .val = 0x00000000 },
	{ .addr = 0x0f1000434, .val = 0x00000000 },
	{ .addr = 0x0f1000438, .val = 0x00000000 },
	{ .addr = 0x0f100043c, .val = 0x00000000 },
	{ .addr = 0x0f1000440, .val = 0x00000000 },
	{ .addr = 0x0f1000444, .val = 0x00000000 },
	{ .addr = 0x0f1000448, .val = 0x00000000 },
	{ .addr = 0x0f100044c, .val = 0x00000000 },
	{ .addr = 0x0f1000450, .val = 0x00000000 },
	{ .addr = 0x0f1000454, .val = 0x00000000 },
	{ .addr = 0x0f1000458, .val = 0x00000000 },
	{ .addr = 0x0f100045c, .val = 0x00000000 },
	{ .addr = 0x0f1000460, .val = 0x00000000 },
	{ .addr = 0x0f1000464, .val = 0x00000000 },
	{ .addr = 0x0f1000468, .val = 0x00000000 },
	{ .addr = 0x0f100046c, .val = 0x00000000 },
	{ .addr = 0x0f1000470, .val = 0x00000000 },
	{ .addr = 0x0f1000474, .val = 0x00000000 },
	{ .addr = 0x0f1000478, .val = 0x00000000 },
	{ .addr = 0x0f100047c, .val = 0x00000000 },
	{ .addr = 0x0f1000480, .val = 0x00000000 },
	{ .addr = 0x0f1000484, .val = 0x00000000 },
	{ .addr = 0x0f1000488, .val = 0x00000000 },
	{ .addr = 0x0f100048c, .val = 0x00000000 },
	{ .addr = 0x0f1000490, .val = 0x00000000 },
	{ .addr = 0x0f1000494, .val = 0x00000000 },
	{ .addr = 0x0f1000498, .val = 0x00000000 },
	{ .addr = 0x0f100049c, .val = 0x00000000 },
	{ .addr = 0x0f10004a0, .val = 0x00000000 },
	{ .addr = 0x0f10004a4, .val = 0x00000000 },
	{ .addr = 0x0f10004a8, .val = 0x00000000 },
	{ .addr = 0x0f10004ac, .val = 0x00000000 },
	{ .addr = 0x0f10004b0, .val = 0x00000000 },
	{ .addr = 0x0f10004b4, .val = 0x00000000 },
	{ .addr = 0x0f10004b8, .val = 0x00000000 },
	{ .addr = 0x0f10004bc, .val = 0x00000000 },
	{ .addr = 0x0f10004c0, .val = 0x00000000 },
	{ .addr = 0x0f10004c4, .val = 0x00000000 },
	{ .addr = 0x0f10004c8, .val = 0x00000000 },
	{ .addr = 0x0f10004cc, .val = 0x00000000 },
	{ .addr = 0x0f10004d0, .val = 0x00000000 },
	{ .addr = 0x0f10004d4, .val = 0x00000000 },
	{ .addr = 0x0f10004d8, .val = 0x00000000 },
	{ .addr = 0x0f10004dc, .val = 0x00000000 },
	{ .addr = 0x0f10004e0, .val = 0x00000000 },
	{ .addr = 0x0f10004e4, .val = 0x00000000 },
	{ .addr = 0x0f10004e8, .val = 0x00000000 },
	{ .addr = 0x0f10004ec, .val = 0x00000000 },
	{ .addr = 0x0f10004f0, .val = 0x00000000 },
	{ .addr = 0x0f10004f4, .val = 0x00000000 },
	{ .addr = 0x0f10004f8, .val = 0x00000000 },
	{ .addr = 0x0f10004fc, .val = 0x00000000 },
	{ .addr = 0x0f1000500, .val = 0x00000000 },
	{ .addr = 0x0f1000504, .val = 0x00000000 },
	{ .addr = 0x0f1000508, .val = 0x00000000 },
	{ .addr = 0x0f100050c, .val = 0x00000000 },
	{ .addr = 0x0f1000510, .val = 0x00000000 },
	{ .addr = 0x0f1000514, .val = 0x00000000 },
	{ .addr = 0x0f1000518, .val = 0x00000000 },
	{ .addr = 0x0f100051c, .val = 0x00000000 },
	{ .addr = 0x0f1000520, .val = 0x00000000 },
	{ .addr = 0x0f1000524, .val = 0x00000000 },
	{ .addr = 0x0f1000528, .val = 0x00000000 },
	{ .addr = 0x0f100052c, .val = 0x00000000 },
	{ .addr = 0x0f1000530, .val = 0x00000000 },
	{ .addr = 0x0f1000534, .val = 0x00000000 },
	{ .addr = 0x0f1000538, .val = 0x00000000 },
	{ .addr = 0x0f100053c, .val = 0x00000000 },
	{ .addr = 0x0f1000540, .val = 0x00000000 },
	{ .addr = 0x0f1000544, .val = 0x00000000 },
	{ .addr = 0x0f1000548, .val = 0x00000000 },
	{ .addr = 0x0f100054c, .val = 0x00000000 },
	{ .addr = 0x0f1000550, .val = 0x00000000 },
	{ .addr = 0x0f1000554, .val = 0x00000000 },
	{ .addr = 0x0f1000558, .val = 0x00000000 },
	{ .addr = 0x0f100055c, .val = 0x00000000 },
	{ .addr = 0x0f1000560, .val = 0x00000000 },
	{ .addr = 0x0f1000564, .val = 0x00000000 },
	{ .addr = 0x0f1000568, .val = 0x00000000 },
	{ .addr = 0x0f100056c, .val = 0x00000000 },
	{ .addr = 0x0f1000570, .val = 0x00000000 },
	{ .addr = 0x0f1000574, .val = 0x00000000 },
	{ .addr = 0x0f1000578, .val = 0x00000000 },
	{ .addr = 0x0f100057c, .val = 0x00000000 },
	{ .addr = 0x0f1000580, .val = 0x00000000 },
	{ .addr = 0x0f1000584, .val = 0x00000000 },
	{ .addr = 0x0f1000588, .val = 0x00000000 },
	{ .addr = 0x0f100058c, .val = 0x00000000 },
	{ .addr = 0x0f1000590, .val = 0x00000000 },
	{ .addr = 0x0f1000594, .val = 0x00000000 },
	{ .addr = 0x0f1000598, .val = 0x00000000 },
	{ .addr = 0x0f100059c, .val = 0x00000000 },
	{ .addr = 0x0f10005a0, .val = 0x00000000 },
	{ .addr = 0x0f10005a4, .val = 0x00000000 },
	{ .addr = 0x0f10005a8, .val = 0x00000000 },
	{ .addr = 0x0f10005ac, .val = 0x00000000 },
	{ .addr = 0x0f10005b0, .val = 0x00000000 },
	{ .addr = 0x0f10005b4, .val = 0x00000000 },
	{ .addr = 0x0f10005b8, .val = 0x00000000 },
	{ .addr = 0x0f10005bc, .val = 0x00000000 },
	{ .addr = 0x0f10005c0, .val = 0x00000000 },
	{ .addr = 0x0f10005c4, .val = 0x00000000 },
	{ .addr = 0x0f10005c8, .val = 0x00000000 },
	{ .addr = 0x0f10005cc, .val = 0x00000000 },
	{ .addr = 0x0f10005d0, .val = 0x00000000 },
	{ .addr = 0x0f10005d4, .val = 0x00000000 },
	{ .addr = 0x0f10005d8, .val = 0x00000000 },
	{ .addr = 0x0f10005dc, .val = 0x00000000 },
	{ .addr = 0x0f10005e0, .val = 0x00000000 },
	{ .addr = 0x0f10005e4, .val = 0x00000000 },
	{ .addr = 0x0f10005e8, .val = 0x00000000 },
	{ .addr = 0x0f10005ec, .val = 0x00000000 },
	{ .addr = 0x0f10005f0, .val = 0x00000000 },
	{ .addr = 0x0f10005f4, .val = 0x00000000 },
	{ .addr = 0x0f10005f8, .val = 0x00000000 },
	{ .addr = 0x0f10005fc, .val = 0x00000000 },
	{ .addr = 0x0f1000600, .val = 0x00000000 },
	{ .addr = 0x0f1000604, .val = 0x00000000 },
	{ .addr = 0x0f1000608, .val = 0x00000000 },
	{ .addr = 0x0f100060c, .val = 0x00000000 },
	{ .addr = 0x0f1000610, .val = 0x00000000 },
	{ .addr = 0x0f1000614, .val = 0x00000000 },
	{ .addr = 0x0f1000618, .val = 0x00000000 },
	{ .addr = 0x0f100061c, .val = 0x00000000 },
	{ .addr = 0x0f1000620, .val = 0x00000000 },
	{ .addr = 0x0f1000624, .val = 0x00000000 },
	{ .addr = 0x0f1000628, .val = 0x00000000 },
	{ .addr = 0x0f100062c, .val = 0x00000000 },
	{ .addr = 0x0f1000630, .val = 0x00000000 },
	{ .addr = 0x0f1000634, .val = 0x00000000 },
	{ .addr = 0x0f1000638, .val = 0x00000000 },
	{ .addr = 0x0f100063c, .val = 0x00000000 },
	{ .addr = 0x0f1000640, .val = 0x00000000 },
	{ .addr = 0x0f1000644, .val = 0x00000000 },
	{ .addr = 0x0f1000648, .val = 0x00000000 },
	{ .addr = 0x0f100064c, .val = 0x00000000 },
	{ .addr = 0x0f1000650, .val = 0x00000000 },
	{ .addr = 0x0f1000654, .val = 0x00000000 },
	{ .addr = 0x0f1000658, .val = 0x00000000 },
	{ .addr = 0x0f100065c, .val = 0x00000000 },
	{ .addr = 0x0f1000660, .val = 0x00000000 },
	{ .addr = 0x0f1000664, .val = 0x00000000 },
	{ .addr = 0x0f1000668, .val = 0x00000000 },
	{ .addr = 0x0f100066c, .val = 0x00000000 },
	{ .addr = 0x0f1000670, .val = 0x00000000 },
	{ .addr = 0x0f1000674, .val = 0x00000000 },
	{ .addr = 0x0f1000678, .val = 0x00000000 },
	{ .addr = 0x0f100067c, .val = 0x00000000 },
	{ .addr = 0x0f1000680, .val = 0x00000000 },
	{ .addr = 0x0f1000684, .val = 0x00000000 },
	{ .addr = 0x0f1000688, .val = 0x00000000 },
	{ .addr = 0x0f100068c, .val = 0x00000000 },
	{ .addr = 0x0f1000690, .val = 0x00000000 },
	{ .addr = 0x0f1000694, .val = 0x00000000 },
	{ .addr = 0x0f1000698, .val = 0x00000000 },
	{ .addr = 0x0f100069c, .val = 0x00000000 },
	{ .addr = 0x0f10006a0, .val = 0x00000000 },
	{ .addr = 0x0f10006a4, .val = 0x00000000 },
	{ .addr = 0x0f10006a8, .val = 0x00000000 },
	{ .addr = 0x0f10006ac, .val = 0x00000000 },
	{ .addr = 0x0f10006b0, .val = 0x00000000 },
	{ .addr = 0x0f10006b4, .val = 0x00000000 },
	{ .addr = 0x0f10006b8, .val = 0x00000000 },
	{ .addr = 0x0f10006bc, .val = 0x00000000 },
	{ .addr = 0x0f10006c0, .val = 0x00000000 },
	{ .addr = 0x0f10006c4, .val = 0x00000000 },
	{ .addr = 0x0f10006c8, .val = 0x00000000 },
	{ .addr = 0x0f10006cc, .val = 0x00000000 },
	{ .addr = 0x0f10006d0, .val = 0x00000000 },
	{ .addr = 0x0f10006d4, .val = 0x00000000 },
	{ .addr = 0x0f10006d8, .val = 0x00000000 },
	{ .addr = 0x0f10006dc, .val = 0x00000000 },
	{ .addr = 0x0f10006e0, .val = 0x00000000 },
	{ .addr = 0x0f10006e4, .val = 0x00000000 },
	{ .addr = 0x0f10006e8, .val = 0x00000000 },
	{ .addr = 0x0f10006ec, .val = 0x00000000 },
	{ .addr = 0x0f10006f0, .val = 0x00000000 },
	{ .addr = 0x0f10006f4, .val = 0x00000000 },
	{ .addr = 0x0f10006f8, .val = 0x00000000 },
	{ .addr = 0x0f10006fc, .val = 0x00000000 },
	{ .addr = 0x0f1000700, .val = 0x00000000 },
	{ .addr = 0x0f1000704, .val = 0x00000000 },
	{ .addr = 0x0f1000708, .val = 0x00000000 },
	{ .addr = 0x0f100070c, .val = 0x00000000 },
	{ .addr = 0x0f1000710, .val = 0x00000000 },
	{ .addr = 0x0f1000714, .val = 0x00000000 },
	{ .addr = 0x0f1000718, .val = 0x00000000 },
	{ .addr = 0x0f100071c, .val = 0x00000000 },
	{ .addr = 0x0f1000720, .val = 0x00000000 },
	{ .addr = 0x0f1000724, .val = 0x00000000 },
	{ .addr = 0x0f1000728, .val = 0x00000000 },
	{ .addr = 0x0f100072c, .val = 0x00000000 },
	{ .addr = 0x0f1000730, .val = 0x00000000 },
	{ .addr = 0x0f1000734, .val = 0x00000000 },
	{ .addr = 0x0f1000738, .val = 0x00000000 },
	{ .addr = 0x0f100073c, .val = 0x00000000 },
	{ .addr = 0x0f1000740, .val = 0x00000000 },
	{ .addr = 0x0f1000744, .val = 0x00000000 },
	{ .addr = 0x0f1000748, .val = 0x00000000 },
	{ .addr = 0x0f100074c, .val = 0x00000000 },
	{ .addr = 0x0f1000750, .val = 0x00000000 },
	{ .addr = 0x0f1000754, .val = 0x00000000 },
	{ .addr = 0x0f1000758, .val = 0x00000000 },
	{ .addr = 0x0f100075c, .val = 0x00000000 },
	{ .addr = 0x0f1000760, .val = 0x00000000 },
	{ .addr = 0x0f1000764, .val = 0x00000000 },
	{ .addr = 0x0f1000768, .val = 0x00000000 },
	{ .addr = 0x0f100076c, .val = 0x00000000 },
	{ .addr = 0x0f1000770, .val = 0x00000000 },
	{ .addr = 0x0f1000774, .val = 0x00000000 },
	{ .addr = 0x0f1000778, .val = 0x00000000 },
	{ .addr = 0x0f100077c, .val = 0x00000000 },
	{ .addr = 0x0f1000780, .val = 0x00000000 },
	{ .addr = 0x0f1000784, .val = 0x00000000 },
	{ .addr = 0x0f1000788, .val = 0x00000000 },
	{ .addr = 0x0f100078c, .val = 0x00000000 },
	{ .addr = 0x0f1000790, .val = 0x00000000 },
	{ .addr = 0x0f1000794, .val = 0x00000000 },
	{ .addr = 0x0f1000798, .val = 0x00000000 },
	{ .addr = 0x0f100079c, .val = 0x00000000 },
	{ .addr = 0x0f10007a0, .val = 0x00000000 },
	{ .addr = 0x0f10007a4, .val = 0x00000000 },
	{ .addr = 0x0f10007a8, .val = 0x00000000 },
	{ .addr = 0x0f10007ac, .val = 0x00000000 },
	{ .addr = 0x0f10007b0, .val = 0x00000000 },
	{ .addr = 0x0f10007b4, .val = 0x00000000 },
	{ .addr = 0x0f10007b8, .val = 0x00000000 },
	{ .addr = 0x0f10007bc, .val = 0x00000000 },
	{ .addr = 0x0f10007c0, .val = 0x00000000 },
	{ .addr = 0x0f10007c4, .val = 0x00000000 },
	{ .addr = 0x0f10007c8, .val = 0x00000000 },
	{ .addr = 0x0f10007cc, .val = 0x00000000 },
	{ .addr = 0x0f10007d0, .val = 0x00000000 },
	{ .addr = 0x0f10007d4, .val = 0x00000000 },
	{ .addr = 0x0f10007d8, .val = 0x00000000 },
	{ .addr = 0x0f10007dc, .val = 0x00000000 },
	{ .addr = 0x0f10007e0, .val = 0x00000000 },
	{ .addr = 0x0f10007e4, .val = 0x00000000 },
	{ .addr = 0x0f10007e8, .val = 0x00000000 },
	{ .addr = 0x0f10007ec, .val = 0x00000000 },
	{ .addr = 0x0f10007f0, .val = 0x00000000 },
	{ .addr = 0x0f10007f4, .val = 0x00000000 },
	{ .addr = 0x0f10007f8, .val = 0x00000000 },
	{ .addr = 0x0f10007fc, .val = 0x00000000 },
	{ .addr = 0x0f1000800, .val = 0x00000000 },
	{ .addr = 0x0f1000804, .val = 0x00000000 },
	{ .addr = 0x0f1000808, .val = 0x00000000 },
	{ .addr = 0x0f100080c, .val = 0x00000000 },
	{ .addr = 0x0f1000810, .val = 0x00000000 },
	{ .addr = 0x0f1000814, .val = 0x00000000 },
	{ .addr = 0x0f1000818, .val = 0x00000000 },
	{ .addr = 0x0f100081c, .val = 0x00000000 },
	{ .addr = 0x0f1000820, .val = 0x00000000 },
	{ .addr = 0x0f1000824, .val = 0x00000000 },
	{ .addr = 0x0f1000828, .val = 0x00000000 },
	{ .addr = 0x0f100082c, .val = 0x00000000 },
	{ .addr = 0x0f1000830, .val = 0x00000000 },
	{ .addr = 0x0f1000834, .val = 0x00000000 },
	{ .addr = 0x0f1000838, .val = 0x00000000 },
	{ .addr = 0x0f100083c, .val = 0x00000000 },
	{ .addr = 0x0f1000840, .val = 0x00000000 },
	{ .addr = 0x0f1000844, .val = 0x00000000 },
	{ .addr = 0x0f1000848, .val = 0x00000000 },
	{ .addr = 0x0f100084c, .val = 0x00000000 },
	{ .addr = 0x0f1000850, .val = 0x00000000 },
	{ .addr = 0x0f1000854, .val = 0x00000000 },
	{ .addr = 0x0f1000858, .val = 0x00000000 },
	{ .addr = 0x0f100085c, .val = 0x00000000 },
	{ .addr = 0x0f1000860, .val = 0x00000000 },
	{ .addr = 0x0f1000864, .val = 0x00000000 },
	{ .addr = 0x0f1000868, .val = 0x00000000 },
	{ .addr = 0x0f100086c, .val = 0x00000000 },
	{ .addr = 0x0f1000870, .val = 0x00000000 },
	{ .addr = 0x0f1000874, .val = 0x00000000 },
	{ .addr = 0x0f1000878, .val = 0x00000000 },
	{ .addr = 0x0f100087c, .val = 0x00000000 },
	{ .addr = 0x0f1000880, .val = 0x00000000 },
	{ .addr = 0x0f1000884, .val = 0x00000000 },
	{ .addr = 0x0f1000888, .val = 0x00000000 },
	{ .addr = 0x0f100088c, .val = 0x00000000 },
	{ .addr = 0x0f1000890, .val = 0x00000000 },
	{ .addr = 0x0f1000894, .val = 0x00000000 },
	{ .addr = 0x0f1000898, .val = 0x00000000 },
	{ .addr = 0x0f100089c, .val = 0x00000000 },
	{ .addr = 0x0f10008a0, .val = 0x00000000 },
	{ .addr = 0x0f10008a4, .val = 0x00000000 },
	{ .addr = 0x0f10008a8, .val = 0x00000000 },
	{ .addr = 0x0f10008ac, .val = 0x00000000 },
	{ .addr = 0x0f10008b0, .val = 0x00000000 },
	{ .addr = 0x0f10008b4, .val = 0x00000000 },
	{ .addr = 0x0f10008b8, .val = 0x00000000 },
	{ .addr = 0x0f10008bc, .val = 0x00000000 },
	{ .addr = 0x0f10008c0, .val = 0x80000000 },
	{ .addr = 0x0f10008c4, .val = 0x80000000 },
	{ .addr = 0x0f10008c8, .val = 0x80000000 },
	{ .addr = 0x0f10008cc, .val = 0x80000000 },
	{ .addr = 0x0f10008d0, .val = 0x80000000 },
	{ .addr = 0x0f10008d4, .val = 0x80000000 },
	{ .addr = 0x0f10008d8, .val = 0x80000000 },
	{ .addr = 0x0f10008dc, .val = 0x80000000 },
	{ .addr = 0x0f10008e0, .val = 0x80000000 },
	{ .addr = 0x0f10008e8, .val = 0x00000000 },
	{ .addr = 0x0f10008ec, .val = 0x00000000 },
	{ .addr = 0x0f10008f0, .val = 0x00000000 },
	{ .addr = 0x0f10008f4, .val = 0x00000000 },
	{ .addr = 0x0f10008f8, .val = 0x00000000 },
	{ .addr = 0x0f10008fc, .val = 0x00000000 },
	{ .addr = 0x0f1000900, .val = 0x00000000 },
	{ .addr = 0x0f1000904, .val = 0x00000000 },
	{ .addr = 0x0f1000908, .val = 0x00000000 },
	{ .addr = 0x0f1000910, .val = 0x00000000 },
	{ .addr = 0x0f1000914, .val = 0x00000000 },
	{ .addr = 0x0f1000918, .val = 0x00000000 },
	{ .addr = 0x0f100091c, .val = 0x00000000 },
	{ .addr = 0x0f1000920, .val = 0x00000000 },
	{ .addr = 0x0f1000924, .val = 0x00000000 },
	{ .addr = 0x0f1000928, .val = 0x00000000 },
	{ .addr = 0x0f100092c, .val = 0x00000000 },
	{ .addr = 0x0f1000930, .val = 0x00000000 },
	{ .addr = 0x0f1000934, .val = 0x00000000 },
	{ .addr = 0x0f1000938, .val = 0x00000000 },
	{ .addr = 0x0f100093c, .val = 0x00000000 },
	{ .addr = 0x0f1000940, .val = 0x00000000 },
	{ .addr = 0x0f1000944, .val = 0x00000000 },
	{ .addr = 0x0f1000948, .val = 0x00000000 },
	{ .addr = 0x0f100094c, .val = 0x00000000 },
	{ .addr = 0x0f1000950, .val = 0x00000000 },
	{ .addr = 0x0f1000954, .val = 0x00000000 },
	{ .addr = 0x0f1000958, .val = 0x00000000 },
	{ .addr = 0x0f100095c, .val = 0x00000000 },
	{ .addr = 0x0f1000960, .val = 0x00000000 },
	{ .addr = 0x0f1000964, .val = 0x00000000 },
	{ .addr = 0x0f1000968, .val = 0x00000000 },
	{ .addr = 0x0f100096c, .val = 0x00000000 },
	{ .addr = 0x0f1000970, .val = 0x00000000 },
	{ .addr = 0x0f1000974, .val = 0x00000000 },
	{ .addr = 0x0f1000978, .val = 0x00000000 },
	{ .addr = 0x0f100097c, .val = 0x00000000 },
	{ .addr = 0x0f1000980, .val = 0x00000000 },
	{ .addr = 0x0f1000984, .val = 0x00000000 },
	{ .addr = 0x0f1000988, .val = 0x00000000 },
	{ .addr = 0x0f100098c, .val = 0x00000000 },
	{ .addr = 0x0f1000990, .val = 0x00000000 },
	{ .addr = 0x0f1000994, .val = 0x00000000 },
	{ .addr = 0x0f1000998, .val = 0x00000000 },
	{ .addr = 0x0f100099c, .val = 0x00000000 },
	{ .addr = 0x0f10009a0, .val = 0x00000000 },
	{ .addr = 0x0f10009a4, .val = 0x00000000 },
	{ .addr = 0x0f10009a8, .val = 0x00000000 },
	{ .addr = 0x0f10009ac, .val = 0x00000000 },
	{ .addr = 0x0f10009b0, .val = 0x00000000 },
	{ .addr = 0x0f10009b4, .val = 0x00000000 },
	{ .addr = 0x0f10009b8, .val = 0x00000000 },
	{ .addr = 0x0f10009bc, .val = 0x00000000 },
	{ .addr = 0x0f10009c0, .val = 0x00000000 },
	{ .addr = 0x0f10009c4, .val = 0x00000000 },
	{ .addr = 0x0f10009c8, .val = 0x00000000 },
	{ .addr = 0x0f10009cc, .val = 0x00000000 },
	{ .addr = 0x0f1010000, .val = 0x00000000 },
	{ .addr = 0x0f1010004, .val = 0x00000000 },
	{ .addr = 0x0f1010008, .val = 0x00000000 },
	{ .addr = 0x0f101000c, .val = 0x00000000 },
	{ .addr = 0x0f1010010, .val = 0x00000000 },
	{ .addr = 0x0f1010014, .val = 0x00000000 },
	{ .addr = 0x0f1010018, .val = 0x00000000 },
	{ .addr = 0x0f101001c, .val = 0x00000000 },
	{ .addr = 0x0f1010050, .val = 0x00000000 },
	{ .addr = 0x0f1010054, .val = 0x00000000 },
	{ .addr = 0x0f1010058, .val = 0x00000000 },
	{ .addr = 0x0f101005c, .val = 0x00000000 },
	{ .addr = 0x0f1010060, .val = 0x00000000 },
	{ .addr = 0x0f1010064, .val = 0x00000000 },
	{ .addr = 0x0f1010068, .val = 0x00000000 },
	{ .addr = 0x0f101006c, .val = 0x00000000 },
	{ .addr = 0x0f1010070, .val = 0x00000000 },
	{ .addr = 0x0f1010074, .val = 0x00000000 },
	{ .addr = 0x0f1010078, .val = 0x00000000 },
	{ .addr = 0x0f101007c, .val = 0x00000000 },
	{ .addr = 0x0f1010080, .val = 0x00000000 },
	{ .addr = 0x0f1010084, .val = 0x00000000 },
	{ .addr = 0x0f1010088, .val = 0x00000000 },
	{ .addr = 0x0f101008c, .val = 0x00000000 },
	{ .addr = 0x0f1010090, .val = 0x00000000 },
	{ .addr = 0x0f1010094, .val = 0x00000000 },
	{ .addr = 0x0f1010098, .val = 0x00000000 },
	{ .addr = 0x0f101009c, .val = 0x00000000 },
	{ .addr = 0x0f10100a0, .val = 0x00000000 },
	{ .addr = 0x0f10100a4, .val = 0x00000000 },
	{ .addr = 0x0f10100a8, .val = 0x00000000 },
	{ .addr = 0x0f10100ac, .val = 0x00000000 },
	{ .addr = 0x0f10100b0, .val = 0x00000000 },
	{ .addr = 0x0f10100b4, .val = 0x00000000 },
	{ .addr = 0x0f10100b8, .val = 0x00000000 },
	{ .addr = 0x0f10100bc, .val = 0x00000000 },
	{ .addr = 0x0f10100c0, .val = 0x00000000 },
	{ .addr = 0x0f10100c4, .val = 0x00000000 },
	{ .addr = 0x0f10100c8, .val = 0x00000000 },
	{ .addr = 0x0f10100cc, .val = 0x00000000 },
	{ .addr = 0x0f10100d0, .val = 0x00000000 },
	{ .addr = 0x0f10100d4, .val = 0x00000000 },
	{ .addr = 0x0f10100d8, .val = 0x00000000 },
	{ .addr = 0x0f10100dc, .val = 0x00000000 },
	{ .addr = 0x0f10100e0, .val = 0x00000000 },
	{ .addr = 0x0f10100e4, .val = 0x00000000 },
	{ .addr = 0x0f10100e8, .val = 0x00000000 },
	{ .addr = 0x0f10100ec, .val = 0x00000000 },
	{ .addr = 0x0f10100f0, .val = 0x00000000 },
	{ .addr = 0x0f10100f4, .val = 0x00000000 },
	{ .addr = 0x0f10100f8, .val = 0x00000000 },
	{ .addr = 0x0f10100fc, .val = 0x00000000 },
	{ .addr = 0x0f1010100, .val = 0x00000000 },
	{ .addr = 0x0f1010104, .val = 0x00000000 },
	{ .addr = 0x0f1010108, .val = 0x00000000 },
	{ .addr = 0x0f101010c, .val = 0x00000000 },
	{ .addr = 0x0f1010110, .val = 0x00000000 },
	{ .addr = 0x0f1010114, .val = 0x00000000 },
	{ .addr = 0x0f1010118, .val = 0x00000000 },
	{ .addr = 0x0f101011c, .val = 0x00000000 },
	{ .addr = 0x0f1010120, .val = 0x00000000 },
	{ .addr = 0x0f1010124, .val = 0x00000000 },
	{ .addr = 0x0f1010128, .val = 0x00000000 },
	{ .addr = 0x0f101012c, .val = 0x00000000 },
	{ .addr = 0x0f1010130, .val = 0x00000000 },
	{ .addr = 0x0f1010134, .val = 0x00000000 },
	{ .addr = 0x0f1010138, .val = 0x00000000 },
	{ .addr = 0x0f101013c, .val = 0x00000000 },
	{ .addr = 0x0f1010140, .val = 0x00000000 },
	{ .addr = 0x0f1010144, .val = 0x00000000 },
	{ .addr = 0x0f1010148, .val = 0x00000000 },
	{ .addr = 0x0f101014c, .val = 0x00000000 },
	{ .addr = 0x0f1010150, .val = 0x00000000 },
	{ .addr = 0x0f1010154, .val = 0x00000000 },
	{ .addr = 0x0f1010158, .val = 0x00000000 },
	{ .addr = 0x0f101015c, .val = 0x00000000 },
	{ .addr = 0x0f1010160, .val = 0x00000000 },
	{ .addr = 0x0f1010164, .val = 0x00000000 },
	{ .addr = 0x0f1010168, .val = 0x00000000 },
	{ .addr = 0x0f101016c, .val = 0x00000000 },
	{ .addr = 0x0f1010170, .val = 0x00000000 },
	{ .addr = 0x0f1010174, .val = 0x00000000 },
	{ .addr = 0x0f1010178, .val = 0x00000000 },
	{ .addr = 0x0f101017c, .val = 0x00000000 },
	{ .addr = 0x0f1010180, .val = 0x00000000 },
	{ .addr = 0x0f1010184, .val = 0x00000000 },
	{ .addr = 0x0f1010188, .val = 0x00000000 },
	{ .addr = 0x0f101018c, .val = 0x00000000 },
	{ .addr = 0x0f1010190, .val = 0x00000000 },
	{ .addr = 0x0f1010194, .val = 0x00000000 },
	{ .addr = 0x0f1010198, .val = 0x00000000 },
	{ .addr = 0x0f101019c, .val = 0x00000000 },
	{ .addr = 0x0f10101a0, .val = 0x00000000 },
	{ .addr = 0x0f10101a4, .val = 0x00000000 },
	{ .addr = 0x0f10101a8, .val = 0x00000000 },
	{ .addr = 0x0f10101ac, .val = 0x00000000 },
	{ .addr = 0x0f10101b0, .val = 0x00000000 },
	{ .addr = 0x0f10101b4, .val = 0x00000000 },
	{ .addr = 0x0f10101b8, .val = 0x00000000 },
	{ .addr = 0x0f10101bc, .val = 0x00000000 },
	{ .addr = 0x0f10101c0, .val = 0x00000000 },
	{ .addr = 0x0f10101c4, .val = 0x00000000 },
	{ .addr = 0x0f10101c8, .val = 0x00000000 },
	{ .addr = 0x0f10101cc, .val = 0x00000000 },
	{ .addr = 0x0f10101d0, .val = 0x00000000 },
	{ .addr = 0x0f10101d4, .val = 0x00000000 },
	{ .addr = 0x0f10101d8, .val = 0x00000000 },
	{ .addr = 0x0f10101dc, .val = 0x00000000 },
	{ .addr = 0x0f10101e0, .val = 0x00000000 },
	{ .addr = 0x0f10101e4, .val = 0x00000000 },
	{ .addr = 0x0f10101e8, .val = 0x00000000 },
	{ .addr = 0x0f10101ec, .val = 0x00000000 },
	{ .addr = 0x0f10101f0, .val = 0x00000000 },
	{ .addr = 0x0f10101f4, .val = 0x00000000 },
	{ .addr = 0x0f10101f8, .val = 0x00000000 },
	{ .addr = 0x0f10101fc, .val = 0x00000000 },
	{ .addr = 0x0f1010200, .val = 0x00000000 },
	{ .addr = 0x0f1010204, .val = 0x00000000 },
	{ .addr = 0x0f1010208, .val = 0x00000000 },
	{ .addr = 0x0f101020c, .val = 0x00000000 },
	{ .addr = 0x0f1010210, .val = 0x00000000 },
	{ .addr = 0x0f1010214, .val = 0x00000000 },
	{ .addr = 0x0f1010218, .val = 0x00000000 },
	{ .addr = 0x0f101021c, .val = 0x00000000 },
	{ .addr = 0x0f1010220, .val = 0x00000000 },
	{ .addr = 0x0f1010224, .val = 0x00000000 },
	{ .addr = 0x0f1010228, .val = 0x00000000 },
	{ .addr = 0x0f101022c, .val = 0x00000000 },
	{ .addr = 0x0f1010230, .val = 0x00000000 },
	{ .addr = 0x0f1010234, .val = 0x00000000 },
	{ .addr = 0x0f1010238, .val = 0x00000000 },
	{ .addr = 0x0f101023c, .val = 0x00000000 },
	{ .addr = 0x0f1010240, .val = 0x00000000 },
	{ .addr = 0x0f1010244, .val = 0x00000000 },
	{ .addr = 0x0f1010248, .val = 0x00000000 },
	{ .addr = 0x0f101024c, .val = 0x00000000 },
	{ .addr = 0x0f1010250, .val = 0x00000000 },
	{ .addr = 0x0f1010254, .val = 0x00000000 },
	{ .addr = 0x0f1010258, .val = 0x00000000 },
	{ .addr = 0x0f101025c, .val = 0x00000000 },
	{ .addr = 0x0f1010260, .val = 0x00000000 },
	{ .addr = 0x0f1010264, .val = 0x00000000 },
	{ .addr = 0x0f1010268, .val = 0x00000000 },
	{ .addr = 0x0f101026c, .val = 0x00000000 },
	{ .addr = 0x0f1010270, .val = 0x00000000 },
	{ .addr = 0x0f1010274, .val = 0x00000000 },
	{ .addr = 0x0f1010278, .val = 0x00000000 },
	{ .addr = 0x0f101027c, .val = 0x00000000 },
	{ .addr = 0x0f1010280, .val = 0x00000000 },
	{ .addr = 0x0f1010284, .val = 0x00000000 },
	{ .addr = 0x0f1010288, .val = 0x00000000 },
	{ .addr = 0x0f101028c, .val = 0x00000000 },
	{ .addr = 0x0f1010290, .val = 0x00000000 },
	{ .addr = 0x0f1010294, .val = 0x00000000 },
	{ .addr = 0x0f1010298, .val = 0x00000000 },
	{ .addr = 0x0f101029c, .val = 0x00000000 },
	{ .addr = 0x0f10102a0, .val = 0x00000000 },
	{ .addr = 0x0f10102a4, .val = 0x00000000 },
	{ .addr = 0x0f10102a8, .val = 0x00000000 },
	{ .addr = 0x0f10102ac, .val = 0x00000000 },
	{ .addr = 0x0f10102b0, .val = 0x00000000 },
	{ .addr = 0x0f10102b4, .val = 0x00000000 },
	{ .addr = 0x0f10102b8, .val = 0x00000000 },
	{ .addr = 0x0f10102bc, .val = 0x00000000 },
	{ .addr = 0x0f10102c0, .val = 0x00000000 },
	{ .addr = 0x0f10102c4, .val = 0x00000000 },
	{ .addr = 0x0f10102c8, .val = 0x00000000 },
	{ .addr = 0x0f10102cc, .val = 0x00000000 },
	{ .addr = 0x0f10102d0, .val = 0x00000000 },
	{ .addr = 0x0f10102d4, .val = 0x00000000 },
	{ .addr = 0x0f10102d8, .val = 0x00000000 },
	{ .addr = 0x0f10102dc, .val = 0x00000000 },
	{ .addr = 0x0f10102e0, .val = 0x00000000 },
	{ .addr = 0x0f10102e4, .val = 0x00000000 },
	{ .addr = 0x0f10102e8, .val = 0x00000000 },
	{ .addr = 0x0f10102ec, .val = 0x00000000 },
	{ .addr = 0x0f10102f0, .val = 0x00000000 },
	{ .addr = 0x0f10102f4, .val = 0x00000000 },
	{ .addr = 0x0f10102f8, .val = 0x00000000 },
	{ .addr = 0x0f10102fc, .val = 0x00000000 },
	{ .addr = 0x0f1010300, .val = 0x00000000 },
	{ .addr = 0x0f1010304, .val = 0x00000000 },
	{ .addr = 0x0f1010308, .val = 0x00000000 },
	{ .addr = 0x0f101030c, .val = 0x00000000 },
	{ .addr = 0x0f1010310, .val = 0x00000000 },
	{ .addr = 0x0f1010314, .val = 0x00000000 },
	{ .addr = 0x0f1010318, .val = 0x00000000 },
	{ .addr = 0x0f101031c, .val = 0x00000000 },
	{ .addr = 0x0f1010320, .val = 0x00000000 },
	{ .addr = 0x0f1010324, .val = 0x00000000 },
	{ .addr = 0x0f1010328, .val = 0x00000000 },
	{ .addr = 0x0f101032c, .val = 0x00000000 },
	{ .addr = 0x0f1010330, .val = 0x00000000 },
	{ .addr = 0x0f1010334, .val = 0x00000000 },
	{ .addr = 0x0f1010338, .val = 0x00000000 },
	{ .addr = 0x0f101033c, .val = 0x00000000 },
	{ .addr = 0x0f1010340, .val = 0x00000000 },
	{ .addr = 0x0f1010344, .val = 0x00000000 },
	{ .addr = 0x0f1010348, .val = 0x00000000 },
	{ .addr = 0x0f101034c, .val = 0x00000000 },
	{ .addr = 0x0f1010350, .val = 0x00000000 },
	{ .addr = 0x0f1010354, .val = 0x00000000 },
	{ .addr = 0x0f1010358, .val = 0x00000000 },
	{ .addr = 0x0f101035c, .val = 0x00000000 },
	{ .addr = 0x0f1010360, .val = 0x00000000 },
	{ .addr = 0x0f1010364, .val = 0x00000000 },
	{ .addr = 0x0f1010368, .val = 0x00000000 },
	{ .addr = 0x0f101036c, .val = 0x00000000 },
	{ .addr = 0x0f1010370, .val = 0x00000000 },
	{ .addr = 0x0f1010374, .val = 0x00000000 },
	{ .addr = 0x0f1010378, .val = 0x00000000 },
	{ .addr = 0x0f101037c, .val = 0x00000000 },
	{ .addr = 0x0f1010380, .val = 0x00000000 },
	{ .addr = 0x0f1010384, .val = 0x00000000 },
	{ .addr = 0x0f1010388, .val = 0x00000000 },
	{ .addr = 0x0f101038c, .val = 0x00000000 },
	{ .addr = 0x0f1010390, .val = 0x00000000 },
	{ .addr = 0x0f1010394, .val = 0x00000000 },
	{ .addr = 0x0f1010398, .val = 0x00000000 },
	{ .addr = 0x0f101039c, .val = 0x00000000 },
	{ .addr = 0x0f10103a0, .val = 0x00000000 },
	{ .addr = 0x0f10103a4, .val = 0x00000000 },
	{ .addr = 0x0f10103a8, .val = 0x00000000 },
	{ .addr = 0x0f10103ac, .val = 0x00000000 },
	{ .addr = 0x0f10103b0, .val = 0x00000000 },
	{ .addr = 0x0f10103b4, .val = 0x00000000 },
	{ .addr = 0x0f10103b8, .val = 0x00000000 },
	{ .addr = 0x0f10103bc, .val = 0x00000000 },
	{ .addr = 0x0f10103c0, .val = 0x00000000 },
	{ .addr = 0x0f10103c4, .val = 0x00000000 },
	{ .addr = 0x0f10103c8, .val = 0x00000000 },
	{ .addr = 0x0f10103cc, .val = 0x00000000 },
	{ .addr = 0x0f10103d0, .val = 0x00000000 },
	{ .addr = 0x0f10103d4, .val = 0x00000000 },
	{ .addr = 0x0f10103d8, .val = 0x00000000 },
	{ .addr = 0x0f10103dc, .val = 0x00000000 },
	{ .addr = 0x0f10103e0, .val = 0x00000000 },
	{ .addr = 0x0f10103e4, .val = 0x00000000 },
	{ .addr = 0x0f10103e8, .val = 0x00000000 },
	{ .addr = 0x0f10103ec, .val = 0x00000000 },
	{ .addr = 0x0f10103f0, .val = 0x00000000 },
	{ .addr = 0x0f10103f4, .val = 0x00000000 },
	{ .addr = 0x0f10103f8, .val = 0x00000000 },
	{ .addr = 0x0f10103fc, .val = 0x00000000 },
	{ .addr = 0x0f1010400, .val = 0x00000000 },
	{ .addr = 0x0f1010404, .val = 0x00000000 },
	{ .addr = 0x0f1010408, .val = 0x00000000 },
	{ .addr = 0x0f101040c, .val = 0x00000000 },
	{ .addr = 0x0f1010410, .val = 0x00000000 },
	{ .addr = 0x0f1010414, .val = 0x00000000 },
	{ .addr = 0x0f1010418, .val = 0x00000000 },
	{ .addr = 0x0f101041c, .val = 0x00000000 },
	{ .addr = 0x0f1010420, .val = 0x00000000 },
	{ .addr = 0x0f1010424, .val = 0x00000000 },
	{ .addr = 0x0f1010428, .val = 0x00000000 },
	{ .addr = 0x0f101042c, .val = 0x00000000 },
	{ .addr = 0x0f1010430, .val = 0x00000000 },
	{ .addr = 0x0f1010434, .val = 0x00000000 },
	{ .addr = 0x0f1010438, .val = 0x00000000 },
	{ .addr = 0x0f101043c, .val = 0x00000000 },
	{ .addr = 0x0f1010440, .val = 0x00000000 },
	{ .addr = 0x0f1010444, .val = 0x00000000 },
	{ .addr = 0x0f1010448, .val = 0x00000000 },
	{ .addr = 0x0f101044c, .val = 0x00000000 },
	{ .addr = 0x0f1010450, .val = 0x00000000 },
	{ .addr = 0x0f1010454, .val = 0x00000000 },
	{ .addr = 0x0f1010458, .val = 0x00000000 },
	{ .addr = 0x0f101045c, .val = 0x00000000 },
	{ .addr = 0x0f1010460, .val = 0x00000000 },
	{ .addr = 0x0f1010464, .val = 0x00000000 },
	{ .addr = 0x0f1010468, .val = 0x00000000 },
	{ .addr = 0x0f101046c, .val = 0x00000000 },
	{ .addr = 0x0f1010470, .val = 0x00000000 },
	{ .addr = 0x0f1010474, .val = 0x00000000 },
	{ .addr = 0x0f1010478, .val = 0x00000000 },
	{ .addr = 0x0f101047c, .val = 0x00000000 },
	{ .addr = 0x0f1010480, .val = 0x00000000 },
	{ .addr = 0x0f1010484, .val = 0x00000000 },
	{ .addr = 0x0f1010488, .val = 0x00000000 },
	{ .addr = 0x0f101048c, .val = 0x00000000 },
	{ .addr = 0x0f1010490, .val = 0x00000000 },
	{ .addr = 0x0f1010494, .val = 0x00000000 },
	{ .addr = 0x0f1010498, .val = 0x00000000 },
	{ .addr = 0x0f101049c, .val = 0x00000000 },
	{ .addr = 0x0f10104a0, .val = 0x00000000 },
	{ .addr = 0x0f10104a4, .val = 0x00000000 },
	{ .addr = 0x0f10104a8, .val = 0x00000000 },
	{ .addr = 0x0f10104ac, .val = 0x00000000 },
	{ .addr = 0x0f10104b0, .val = 0x00000000 },
	{ .addr = 0x0f10104b4, .val = 0x00000000 },
	{ .addr = 0x0f10104b8, .val = 0x00000000 },
	{ .addr = 0x0f10104bc, .val = 0x00000000 },
	{ .addr = 0x0f10104c0, .val = 0x00000000 },
	{ .addr = 0x0f10104c4, .val = 0x00000000 },
	{ .addr = 0x0f10104c8, .val = 0x00000000 },
	{ .addr = 0x0f10104cc, .val = 0x00000000 },
	{ .addr = 0x0f10104d0, .val = 0x00000000 },
	{ .addr = 0x0f10104d4, .val = 0x00000000 },
	{ .addr = 0x0f10104d8, .val = 0x00000000 },
	{ .addr = 0x0f10104dc, .val = 0x00000000 },
	{ .addr = 0x0f10104e0, .val = 0x00000000 },
	{ .addr = 0x0f10104e4, .val = 0x00000000 },
	{ .addr = 0x0f10104e8, .val = 0x00000000 },
	{ .addr = 0x0f10104ec, .val = 0x00000000 },
	{ .addr = 0x0f10104f0, .val = 0x00000000 },
	{ .addr = 0x0f10104f4, .val = 0x00000000 },
	{ .addr = 0x0f10104f8, .val = 0x00000000 },
	{ .addr = 0x0f10104fc, .val = 0x00000000 },
	{ .addr = 0x0f1010500, .val = 0x00000000 },
	{ .addr = 0x0f1010504, .val = 0x00000000 },
	{ .addr = 0x0f1010508, .val = 0x00000000 },
	{ .addr = 0x0f101050c, .val = 0x00000000 },
	{ .addr = 0x0f1010510, .val = 0x00000000 },
	{ .addr = 0x0f1010514, .val = 0x00000000 },
	{ .addr = 0x0f1010518, .val = 0x00000000 },
	{ .addr = 0x0f101051c, .val = 0x00000000 },
	{ .addr = 0x0f1010520, .val = 0x00000000 },
	{ .addr = 0x0f1010524, .val = 0x00000000 },
	{ .addr = 0x0f1010528, .val = 0x00000000 },
	{ .addr = 0x0f101052c, .val = 0x00000000 },
	{ .addr = 0x0f1010530, .val = 0x00000000 },
	{ .addr = 0x0f1010534, .val = 0x00000000 },
	{ .addr = 0x0f1010538, .val = 0x00000000 },
	{ .addr = 0x0f101053c, .val = 0x00000000 },
	{ .addr = 0x0f1010540, .val = 0x00000000 },
	{ .addr = 0x0f1010544, .val = 0x00000000 },
	{ .addr = 0x0f1010548, .val = 0x00000000 },
	{ .addr = 0x0f101054c, .val = 0x00000000 },
	{ .addr = 0x0f1010550, .val = 0x00000000 },
	{ .addr = 0x0f1010554, .val = 0x00000000 },
	{ .addr = 0x0f1010558, .val = 0x00000000 },
	{ .addr = 0x0f101055c, .val = 0x00000000 },
	{ .addr = 0x0f1010560, .val = 0x00000000 },
	{ .addr = 0x0f1010564, .val = 0x00000000 },
	{ .addr = 0x0f1010568, .val = 0x00000000 },
	{ .addr = 0x0f101056c, .val = 0x00000000 },
	{ .addr = 0x0f1010570, .val = 0x00000000 },
	{ .addr = 0x0f1010574, .val = 0x00000000 },
	{ .addr = 0x0f1010578, .val = 0x00000000 },
	{ .addr = 0x0f101057c, .val = 0x00000000 },
	{ .addr = 0x0f1010580, .val = 0x00000000 },
	{ .addr = 0x0f1010584, .val = 0x00000000 },
	{ .addr = 0x0f1010588, .val = 0x00000000 },
	{ .addr = 0x0f101058c, .val = 0x00000000 },
	{ .addr = 0x0f1010590, .val = 0x00000000 },
	{ .addr = 0x0f1010594, .val = 0x00000000 },
	{ .addr = 0x0f1010598, .val = 0x00000000 },
	{ .addr = 0x0f101059c, .val = 0x00000000 },
	{ .addr = 0x0f10105a0, .val = 0x00000000 },
	{ .addr = 0x0f10105a4, .val = 0x00000000 },
	{ .addr = 0x0f10105a8, .val = 0x00000000 },
	{ .addr = 0x0f10105ac, .val = 0x00000000 },
	{ .addr = 0x0f10105b0, .val = 0x00000000 },
	{ .addr = 0x0f10105b4, .val = 0x00000000 },
	{ .addr = 0x0f10105b8, .val = 0x00000000 },
	{ .addr = 0x0f10105bc, .val = 0x00000000 },
	{ .addr = 0x0f10105c0, .val = 0x00000000 },
	{ .addr = 0x0f10105c4, .val = 0x00000000 },
	{ .addr = 0x0f10105c8, .val = 0x00000000 },
	{ .addr = 0x0f10105cc, .val = 0x00000000 },
	{ .addr = 0x0f10105d0, .val = 0x00000000 },
	{ .addr = 0x0f10105d4, .val = 0x00000000 },
	{ .addr = 0x0f10105d8, .val = 0x00000000 },
	{ .addr = 0x0f10105dc, .val = 0x00000000 },
	{ .addr = 0x0f10105e0, .val = 0x00000000 },
	{ .addr = 0x0f10105e4, .val = 0x00000000 },
	{ .addr = 0x0f10105e8, .val = 0x00000000 },
	{ .addr = 0x0f10105ec, .val = 0x00000000 },
	{ .addr = 0x0f10105f0, .val = 0x00000000 },
	{ .addr = 0x0f10105f4, .val = 0x00000000 },
	{ .addr = 0x0f10105f8, .val = 0x00000000 },
	{ .addr = 0x0f10105fc, .val = 0x00000000 },
	{ .addr = 0x0f1010600, .val = 0x00000000 },
	{ .addr = 0x0f1010604, .val = 0x00000000 },
	{ .addr = 0x0f1010608, .val = 0x00000000 },
	{ .addr = 0x0f101060c, .val = 0x00000000 },
	{ .addr = 0x0f1010610, .val = 0x00000000 },
	{ .addr = 0x0f1010614, .val = 0x00000000 },
	{ .addr = 0x0f1010618, .val = 0x00000000 },
	{ .addr = 0x0f101061c, .val = 0x00000000 },
	{ .addr = 0x0f1010620, .val = 0x00000000 },
	{ .addr = 0x0f1010624, .val = 0x00000000 },
	{ .addr = 0x0f1010628, .val = 0x00000000 },
	{ .addr = 0x0f101062c, .val = 0x00000000 },
	{ .addr = 0x0f1010630, .val = 0x00000000 },
	{ .addr = 0x0f1010634, .val = 0x00000000 },
	{ .addr = 0x0f1010638, .val = 0x00000000 },
	{ .addr = 0x0f101063c, .val = 0x00000000 },
	{ .addr = 0x0f1010640, .val = 0x00000000 },
	{ .addr = 0x0f1010644, .val = 0x00000000 },
	{ .addr = 0x0f1010648, .val = 0x00000000 },
	{ .addr = 0x0f101064c, .val = 0x00000000 },
	{ .addr = 0x0f1010650, .val = 0x00000000 },
	{ .addr = 0x0f1010654, .val = 0x00000000 },
	{ .addr = 0x0f1010658, .val = 0x00000000 },
	{ .addr = 0x0f101065c, .val = 0x00000000 },
	{ .addr = 0x0f1010660, .val = 0x00000000 },
	{ .addr = 0x0f1010664, .val = 0x00000000 },
	{ .addr = 0x0f1010668, .val = 0x00000000 },
	{ .addr = 0x0f101066c, .val = 0x00000000 },
	{ .addr = 0x0f1010670, .val = 0x00000000 },
	{ .addr = 0x0f1010674, .val = 0x00000000 },
	{ .addr = 0x0f1010678, .val = 0x00000000 },
	{ .addr = 0x0f101067c, .val = 0x00000000 },
	{ .addr = 0x0f1010680, .val = 0x00000000 },
	{ .addr = 0x0f1010684, .val = 0x00000000 },
	{ .addr = 0x0f1010688, .val = 0x00000000 },
	{ .addr = 0x0f101068c, .val = 0x00000000 },
	{ .addr = 0x0f1010690, .val = 0x00000000 },
	{ .addr = 0x0f1010694, .val = 0x00000000 },
	{ .addr = 0x0f1010698, .val = 0x00000000 },
	{ .addr = 0x0f101069c, .val = 0x00000000 },
	{ .addr = 0x0f10106a0, .val = 0x00000000 },
	{ .addr = 0x0f10106a4, .val = 0x00000000 },
	{ .addr = 0x0f10106a8, .val = 0x00000000 },
	{ .addr = 0x0f10106ac, .val = 0x00000000 },
	{ .addr = 0x0f10106b0, .val = 0x00000000 },
	{ .addr = 0x0f10106b4, .val = 0x00000000 },
	{ .addr = 0x0f10106b8, .val = 0x00000000 },
	{ .addr = 0x0f10106bc, .val = 0x00000000 },
	{ .addr = 0x0f10106c0, .val = 0x00000000 },
	{ .addr = 0x0f10106c4, .val = 0x00000000 },
	{ .addr = 0x0f10106c8, .val = 0x00000000 },
	{ .addr = 0x0f10106cc, .val = 0x00000000 },
	{ .addr = 0x0f10106d0, .val = 0x00000000 },
	{ .addr = 0x0f10106d4, .val = 0x00000000 },
	{ .addr = 0x0f10106d8, .val = 0x00000000 },
	{ .addr = 0x0f10106dc, .val = 0x00000000 },
	{ .addr = 0x0f10106e0, .val = 0x00000000 },
	{ .addr = 0x0f10106e4, .val = 0x00000000 },
	{ .addr = 0x0f10106e8, .val = 0x00000000 },
	{ .addr = 0x0f10106ec, .val = 0x00000000 },
	{ .addr = 0x0f10106f0, .val = 0x00000000 },
	{ .addr = 0x0f10106f4, .val = 0x00000000 },
	{ .addr = 0x0f10106f8, .val = 0x00000000 },
	{ .addr = 0x0f10106fc, .val = 0x00000000 },
	{ .addr = 0x0f1010700, .val = 0x00000000 },
	{ .addr = 0x0f1010704, .val = 0x00000000 },
	{ .addr = 0x0f1010708, .val = 0x00000000 },
	{ .addr = 0x0f101070c, .val = 0x00000000 },
	{ .addr = 0x0f1010710, .val = 0x00000000 },
	{ .addr = 0x0f1010714, .val = 0x00000000 },
	{ .addr = 0x0f1010718, .val = 0x00000000 },
	{ .addr = 0x0f101071c, .val = 0x00000000 },
	{ .addr = 0x0f1010720, .val = 0x00000000 },
	{ .addr = 0x0f1010724, .val = 0x00000000 },
	{ .addr = 0x0f1010728, .val = 0x00000000 },
	{ .addr = 0x0f101072c, .val = 0x00000000 },
	{ .addr = 0x0f1010730, .val = 0x00000000 },
	{ .addr = 0x0f1010734, .val = 0x00000000 },
	{ .addr = 0x0f1010738, .val = 0x00000000 },
	{ .addr = 0x0f101073c, .val = 0x00000000 },
	{ .addr = 0x0f1010740, .val = 0x00000000 },
	{ .addr = 0x0f1010744, .val = 0x00000000 },
	{ .addr = 0x0f1010748, .val = 0x00000000 },
	{ .addr = 0x0f101074c, .val = 0x00000000 },
	{ .addr = 0x0f1010750, .val = 0x00000000 },
	{ .addr = 0x0f1010754, .val = 0x00000000 },
	{ .addr = 0x0f1010758, .val = 0x00000000 },
	{ .addr = 0x0f101075c, .val = 0x00000000 },
	{ .addr = 0x0f1010760, .val = 0x00000000 },
	{ .addr = 0x0f1010764, .val = 0x00000000 },
	{ .addr = 0x0f1010768, .val = 0x00000000 },
	{ .addr = 0x0f101076c, .val = 0x00000000 },
	{ .addr = 0x0f1010770, .val = 0x00000000 },
	{ .addr = 0x0f1010774, .val = 0x00000000 },
	{ .addr = 0x0f1010778, .val = 0x00000000 },
	{ .addr = 0x0f101077c, .val = 0x00000000 },
	{ .addr = 0x0f1010780, .val = 0x00000000 },
	{ .addr = 0x0f1010784, .val = 0x00000000 },
	{ .addr = 0x0f1010788, .val = 0x00000000 },
	{ .addr = 0x0f101078c, .val = 0x00000000 },
	{ .addr = 0x0f1010790, .val = 0x00000000 },
	{ .addr = 0x0f1010794, .val = 0x00000000 },
	{ .addr = 0x0f1010798, .val = 0x00000000 },
	{ .addr = 0x0f101079c, .val = 0x00000000 },
	{ .addr = 0x0f10107a0, .val = 0x00000000 },
	{ .addr = 0x0f10107a4, .val = 0x00000000 },
	{ .addr = 0x0f10107a8, .val = 0x00000000 },
	{ .addr = 0x0f10107ac, .val = 0x00000000 },
	{ .addr = 0x0f10107b0, .val = 0x00000000 },
	{ .addr = 0x0f10107b4, .val = 0x00000000 },
	{ .addr = 0x0f10107b8, .val = 0x00000000 },
	{ .addr = 0x0f10107bc, .val = 0x00000000 },
	{ .addr = 0x0f10107c0, .val = 0x00000000 },
	{ .addr = 0x0f10107c4, .val = 0x00000000 },
	{ .addr = 0x0f10107c8, .val = 0x00000000 },
	{ .addr = 0x0f10107cc, .val = 0x00000000 },
	{ .addr = 0x0f10107d0, .val = 0x00000000 },
	{ .addr = 0x0f10107d4, .val = 0x00000000 },
	{ .addr = 0x0f10107d8, .val = 0x00000000 },
	{ .addr = 0x0f10107dc, .val = 0x00000000 },
	{ .addr = 0x0f10107e0, .val = 0x00000000 },
	{ .addr = 0x0f10107e4, .val = 0x00000000 },
	{ .addr = 0x0f10107e8, .val = 0x00000000 },
	{ .addr = 0x0f10107ec, .val = 0x00000000 },
	{ .addr = 0x0f10107f0, .val = 0x00000000 },
	{ .addr = 0x0f10107f4, .val = 0x00000000 },
	{ .addr = 0x0f10107f8, .val = 0x00000000 },
	{ .addr = 0x0f10107fc, .val = 0x00000000 },
	{ .addr = 0x0f1010800, .val = 0x00000000 },
	{ .addr = 0x0f1010804, .val = 0x00000000 },
	{ .addr = 0x0f1010808, .val = 0x00000000 },
	{ .addr = 0x0f101080c, .val = 0x00000000 },
	{ .addr = 0x0f1010810, .val = 0x00000000 },
	{ .addr = 0x0f1010814, .val = 0x00000000 },
	{ .addr = 0x0f1010818, .val = 0x00000000 },
	{ .addr = 0x0f101081c, .val = 0x00000000 },
	{ .addr = 0x0f1010820, .val = 0x00000000 },
	{ .addr = 0x0f1010824, .val = 0x00000000 },
	{ .addr = 0x0f1010828, .val = 0x00000000 },
	{ .addr = 0x0f101082c, .val = 0x00000000 },
	{ .addr = 0x0f1010830, .val = 0x00000000 },
	{ .addr = 0x0f1010834, .val = 0x00000000 },
	{ .addr = 0x0f1010838, .val = 0x00000000 },
	{ .addr = 0x0f101083c, .val = 0x00000000 },
	{ .addr = 0x0f1010840, .val = 0x00000000 },
	{ .addr = 0x0f1010844, .val = 0x00000000 },
	{ .addr = 0x0f1010848, .val = 0x00000000 },
	{ .addr = 0x0f101084c, .val = 0x00000000 },
	{ .addr = 0x0f1010850, .val = 0x00000000 },
	{ .addr = 0x0f1010854, .val = 0x00000000 },
	{ .addr = 0x0f1010858, .val = 0x00000000 },
	{ .addr = 0x0f101085c, .val = 0x00000000 },
	{ .addr = 0x0f1010860, .val = 0x00000000 },
	{ .addr = 0x0f1010864, .val = 0x00000000 },
	{ .addr = 0x0f1010868, .val = 0x00000000 },
	{ .addr = 0x0f101086c, .val = 0x00000000 },
	{ .addr = 0x0f1010870, .val = 0x00000000 },
	{ .addr = 0x0f1010874, .val = 0x00000000 },
	{ .addr = 0x0f1010878, .val = 0x00000000 },
	{ .addr = 0x0f101087c, .val = 0x00000003 },
	{ .addr = 0x0f1010880, .val = 0x00000000 },
	{ .addr = 0x0f1010884, .val = 0x00000000 },
	{ .addr = 0x0f1010888, .val = 0x00000000 },
	{ .addr = 0x0f101088c, .val = 0x00000000 },
	{ .addr = 0x0f1010890, .val = 0x00000000 },
	{ .addr = 0x0f1010894, .val = 0x00000000 },
	{ .addr = 0x0f1010898, .val = 0x00000000 },
	{ .addr = 0x0f101089c, .val = 0x00000000 },
	{ .addr = 0x0f10108a0, .val = 0x00000000 },
	{ .addr = 0x0f10108a4, .val = 0x00000000 },
	{ .addr = 0x0f10108a8, .val = 0x00000000 },
	{ .addr = 0x0f10108ac, .val = 0x00000000 },
	{ .addr = 0x0f10108b0, .val = 0x00000000 },
	{ .addr = 0x0f10108b4, .val = 0x00000000 },
	{ .addr = 0x0f10108b8, .val = 0x00000000 },
	{ .addr = 0x0f10108bc, .val = 0x00000000 },
	{ .addr = 0x0f10108c0, .val = 0x00000000 },
	{ .addr = 0x0f10108c4, .val = 0x00000000 },
	{ .addr = 0x0f10108c8, .val = 0x00000000 },
	{ .addr = 0x0f10108d0, .val = 0x00000000 },
	{ .addr = 0x0f10108d4, .val = 0x00000000 },
	{ .addr = 0x0f10108d8, .val = 0x00000000 },
	{ .addr = 0x0f10108e0, .val = 0x00000000 },
	{ .addr = 0x0f10108e4, .val = 0x00000000 },
	{ .addr = 0x0f10108e8, .val = 0x00000000 },
	{ .addr = 0x0f10108f0, .val = 0x00000000 },
	{ .addr = 0x0f10108f4, .val = 0x00000000 },
	{ .addr = 0x0f10108f8, .val = 0x00000000 },
	{ .addr = 0x0f1010900, .val = 0x00000000 },
	{ .addr = 0x0f1010904, .val = 0x00000000 },
	{ .addr = 0x0f1010908, .val = 0x00000000 },
	{ .addr = 0x0f101090c, .val = 0x00000000 },
	{ .addr = 0x0f1010910, .val = 0x00000000 },
	{ .addr = 0x0f1010914, .val = 0x00000000 },
	{ .addr = 0x0f1010918, .val = 0x00000000 },
	{ .addr = 0x0f101091c, .val = 0x00000000 },
	{ .addr = 0x0f1010920, .val = 0x00000000 },
	{ .addr = 0x0f1010924, .val = 0x00000000 },
	{ .addr = 0x0f1010928, .val = 0x00000000 },
	{ .addr = 0x0f1010930, .val = 0x00000000 },
	{ .addr = 0x0f1010938, .val = 0x00000000 },
	{ .addr = 0x0f1010940, .val = 0x00000000 },
	{ .addr = 0x0f1010948, .val = 0x00000000 },
	{ .addr = 0x0f1010950, .val = 0x00000000 },
	{ .addr = 0x0f1010954, .val = 0x00000000 },
	{ .addr = 0x0f1010958, .val = 0x00000000 },
	{ .addr = 0x0f101095c, .val = 0x00000000 },
	{ .addr = 0x0f1010960, .val = 0x00000000 },
	{ .addr = 0x0f1010964, .val = 0x00000000 },
	{ .addr = 0x0f1010968, .val = 0x00000000 },
	{ .addr = 0x0f101096c, .val = 0x00000000 },
	{ .addr = 0x0f1010970, .val = 0x00000000 },
	{ .addr = 0x0f1010974, .val = 0x00000000 },
	{ .addr = 0x0f1010978, .val = 0x00000000 },
	{ .addr = 0x0f101097c, .val = 0x00000000 },
	{ .addr = 0x0f1010980, .val = 0x00000000 },
	{ .addr = 0x0f1010984, .val = 0x00000000 },
	{ .addr = 0x0f1010988, .val = 0x00000000 },
	{ .addr = 0x0f101098c, .val = 0x00000000 },
	{ .addr = 0x0f1010990, .val = 0x00000000 },
	{ .addr = 0x0f1010994, .val = 0x00000000 },
	{ .addr = 0x0f1010998, .val = 0x00000000 },
	{ .addr = 0x0f101099c, .val = 0x00000000 },
	{ .addr = 0x0f10109a0, .val = 0x00000000 },
	{ .addr = 0x0f10109a4, .val = 0x00000000 },
	{ .addr = 0x0f10109a8, .val = 0x00000000 },
	{ .addr = 0x0f10109ac, .val = 0x00000000 },
	{ .addr = 0x0f10109b0, .val = 0x00000000 },
	{ .addr = 0x0f10109b4, .val = 0x00000000 },
	{ .addr = 0x0f10109b8, .val = 0x00000000 },
	{ .addr = 0x0f10109bc, .val = 0x00000000 },
	{ .addr = 0x0f10109c0, .val = 0x00000000 },
	{ .addr = 0x0f10109c4, .val = 0x00000000 },
	{ .addr = 0x0f10109c8, .val = 0x00000000 },
	{ .addr = 0x0f10109cc, .val = 0x00000000 },
	{ .addr = 0x0f10109d0, .val = 0x00000000 },
	{ .addr = 0x0f10109d4, .val = 0x00000000 },
	{ .addr = 0x0f10109d8, .val = 0x00000000 },
	{ .addr = 0x0f10109dc, .val = 0x00000000 },
	{ .addr = 0x0f10109e0, .val = 0x00000000 },
	{ .addr = 0x0f10109e4, .val = 0x00000000 },
	{ .addr = 0x0f10109e8, .val = 0x00000000 },
	{ .addr = 0x0f10109ec, .val = 0x00000000 },
	{ .addr = 0x0f10109f0, .val = 0x00000000 },
	{ .addr = 0x0f10109f4, .val = 0x00000000 },
	{ .addr = 0x0f10109f8, .val = 0x00000000 },
	{ .addr = 0x0f10109fc, .val = 0x00000000 },
	{ .addr = 0x0f1010a00, .val = 0x00000000 },
	{ .addr = 0x0f1010a04, .val = 0x00000000 },
	{ .addr = 0x0f1010a08, .val = 0x00000000 },
	{ .addr = 0x0f1010a0c, .val = 0x00000000 },
	{ .addr = 0x0f1010a10, .val = 0x00000000 },
	{ .addr = 0x0f1010a14, .val = 0x00000000 },
	{ .addr = 0x0f1010a18, .val = 0x00000000 },
	{ .addr = 0x0f1010a1c, .val = 0x00000000 },
	{ .addr = 0x0f1010a20, .val = 0x00000000 },
	{ .addr = 0x0f1010a24, .val = 0x00000000 },
	{ .addr = 0x0f1010a28, .val = 0x00000000 },
	{ .addr = 0x0f1010a2c, .val = 0x00000000 },
	{ .addr = 0x0f1010a30, .val = 0x00000000 },
	{ .addr = 0x0f1010a34, .val = 0x00000000 },
	{ .addr = 0x0f1010a38, .val = 0x00000000 },
	{ .addr = 0x0f1010a3c, .val = 0x00000000 },
	{ .addr = 0x0f1010a40, .val = 0x00000000 },
	{ .addr = 0x0f1010a44, .val = 0x00000000 },
	{ .addr = 0x0f1010a48, .val = 0x00000000 },
	{ .addr = 0x0f1010a4c, .val = 0x00000000 },
	{ .addr = 0x0f1010a50, .val = 0x00000000 },
	{ .addr = 0x0f1010a54, .val = 0x00000000 },
	{ .addr = 0x0f1010a58, .val = 0x00000000 },
	{ .addr = 0x0f1010a5c, .val = 0x00000000 },
	{ .addr = 0x0f1010a60, .val = 0x00000000 },
	{ .addr = 0x0f1010a64, .val = 0x00000000 },
	{ .addr = 0x0f1010a68, .val = 0x00000000 },
	{ .addr = 0x0f1010a6c, .val = 0x00000000 },
	{ .addr = 0x0f1010a70, .val = 0x00000000 },
	{ .addr = 0x0f1010a74, .val = 0x00000000 },
	{ .addr = 0x0f1010a78, .val = 0x00000000 },
	{ .addr = 0x0f1010a7c, .val = 0x00000000 },
	{ .addr = 0x0f1010a80, .val = 0x00000000 },
	{ .addr = 0x0f1010a84, .val = 0x00000000 },
	{ .addr = 0x0f1010a88, .val = 0x00000000 },
	{ .addr = 0x0f1010a8c, .val = 0x00000000 },
	{ .addr = 0x0f1010a90, .val = 0x00000000 },
	{ .addr = 0x0f1010a94, .val = 0x00000000 },
	{ .addr = 0x0f1010a98, .val = 0x00000000 },
	{ .addr = 0x0f1010a9c, .val = 0x00000000 },
	{ .addr = 0x0f1010aa0, .val = 0x00000000 },
	{ .addr = 0x0f1010aa4, .val = 0x00000000 },
	{ .addr = 0x0f1010aa8, .val = 0x00000000 },
	{ .addr = 0x0f1010aac, .val = 0x00000000 },
	{ .addr = 0x0f1010ab0, .val = 0x00000000 },
	{ .addr = 0x0f1010ab4, .val = 0x00000000 },
	{ .addr = 0x0f1010ab8, .val = 0x00000000 },
	{ .addr = 0x0f1010abc, .val = 0x00000000 },
	{ .addr = 0x0f1010ac0, .val = 0x00000000 },
	{ .addr = 0x0f1010ac4, .val = 0x00000000 },
	{ .addr = 0x0f1010ac8, .val = 0x00000000 },
	{ .addr = 0x0f1010acc, .val = 0x00000000 },
	{ .addr = 0x0f1010ad0, .val = 0x00000000 },
	{ .addr = 0x0f1010ad4, .val = 0x00000000 },
	{ .addr = 0x0f1010ad8, .val = 0x00000000 },
	{ .addr = 0x0f1010adc, .val = 0x00000000 },
	{ .addr = 0x0f1010ae0, .val = 0x00000000 },
	{ .addr = 0x0f1010ae4, .val = 0x00000000 },
	{ .addr = 0x0f1010ae8, .val = 0x00000000 },
	{ .addr = 0x0f1010aec, .val = 0x00000000 },
	{ .addr = 0x0f1010af0, .val = 0x00000000 },
	{ .addr = 0x0f1010af4, .val = 0x00000000 },
	{ .addr = 0x0f1010af8, .val = 0x00000000 },
	{ .addr = 0x0f1010afc, .val = 0x00000000 },
	{ .addr = 0x0f1010b00, .val = 0x00000000 },
	{ .addr = 0x0f1010b04, .val = 0x00000000 },
	{ .addr = 0x0f1010b08, .val = 0x00000000 },
	{ .addr = 0x0f1010b0c, .val = 0x00000000 },
	{ .addr = 0x0f1010b10, .val = 0x00000000 },
	{ .addr = 0x0f1010b14, .val = 0x00000000 },
	{ .addr = 0x0f1010b18, .val = 0x00000000 },
	{ .addr = 0x0f1010b1c, .val = 0x00000000 },
	{ .addr = 0x0f1010b20, .val = 0x00000000 },
	{ .addr = 0x0f1010b24, .val = 0x00000000 },
	{ .addr = 0x0f1010b28, .val = 0x00000000 },
	{ .addr = 0x0f1010b2c, .val = 0x00000000 },
	{ .addr = 0x0f1010b30, .val = 0x00000000 },
	{ .addr = 0x0f1010b34, .val = 0x00000000 },
	{ .addr = 0x0f1010b38, .val = 0x00000000 },
	{ .addr = 0x0f1010b3c, .val = 0x00000000 },
	{ .addr = 0x0f1010b40, .val = 0x00000000 },
	{ .addr = 0x0f1010b44, .val = 0x00000000 },
	{ .addr = 0x0f1010b48, .val = 0x00000000 },
	{ .addr = 0x0f1010b4c, .val = 0x00000000 },
	{ .addr = 0x0f1010b50, .val = 0x00000000 },
	{ .addr = 0x0f1010b54, .val = 0x00000000 },
	{ .addr = 0x0f1010b58, .val = 0x00000000 },
	{ .addr = 0x0f1010b5c, .val = 0x00000000 },
	{ .addr = 0x0f1010b60, .val = 0x00000000 },
	{ .addr = 0x0f1010b64, .val = 0x00000000 },
	{ .addr = 0x0f1010b68, .val = 0x00000000 },
	{ .addr = 0x0f1010b6c, .val = 0x00000000 },
	{ .addr = 0x0f1010b70, .val = 0x00000000 },
	{ .addr = 0x0f1010b74, .val = 0x00000000 },
	{ .addr = 0x0f1010b78, .val = 0x00000000 },
	{ .addr = 0x0f1010b7c, .val = 0x00000000 },
	{ .addr = 0x0f1010b80, .val = 0x00000000 },
	{ .addr = 0x0f1010b84, .val = 0x00000000 },
	{ .addr = 0x0f1010b88, .val = 0x00000000 },
	{ .addr = 0x0f1010b8c, .val = 0x00000000 },
	{ .addr = 0x0f1010b90, .val = 0x00000000 },
	{ .addr = 0x0f1010b94, .val = 0x00000000 },
	{ .addr = 0x0f1010b98, .val = 0x00000000 },
	{ .addr = 0x0f1010b9c, .val = 0x00000000 },
	{ .addr = 0x0f1010ba0, .val = 0x00000000 },
	{ .addr = 0x0f1010ba4, .val = 0x00000000 },
	{ .addr = 0x0f1010ba8, .val = 0x00000000 },
	{ .addr = 0x0f1010bac, .val = 0x00000000 },
	{ .addr = 0x0f1010bb0, .val = 0x00000000 },
	{ .addr = 0x0f1010bb4, .val = 0x00000000 },
	{ .addr = 0x0f1010bb8, .val = 0x00000000 },
	{ .addr = 0x0f1010bbc, .val = 0x00000000 },
	{ .addr = 0x0f1010bc0, .val = 0x00000000 },
	{ .addr = 0x0f1010bc4, .val = 0x00000000 },
	{ .addr = 0x0f1010bc8, .val = 0x00000000 },
	{ .addr = 0x0f1010bcc, .val = 0x00000000 },
	{ .addr = 0x0f1010bd0, .val = 0x00000000 },
	{ .addr = 0x0f1010bd4, .val = 0x00000000 },
	{ .addr = 0x0f1010bd8, .val = 0x00000000 },
	{ .addr = 0x0f1010bdc, .val = 0x00000000 },
	{ .addr = 0x0f1010be0, .val = 0x00000000 },
	{ .addr = 0x0f1010be4, .val = 0x00000000 },
	{ .addr = 0x0f1010be8, .val = 0x00000000 },
	{ .addr = 0x0f1010bec, .val = 0x00000000 },
	{ .addr = 0x0f1010bf0, .val = 0x00000000 },
	{ .addr = 0x0f1010bf4, .val = 0x00000000 },
	{ .addr = 0x0f1010bf8, .val = 0x00000000 },
	{ .addr = 0x0f1010bfc, .val = 0x00000000 },
	{ .addr = 0x0f1010c00, .val = 0x00000000 },
	{ .addr = 0x0f1010c04, .val = 0x00000000 },
	{ .addr = 0x0f1010c08, .val = 0x00000000 },
	{ .addr = 0x0f1010c0c, .val = 0x00000000 },
	{ .addr = 0x0f1010c10, .val = 0x00000000 },
	{ .addr = 0x0f1010c14, .val = 0x00000000 },
	{ .addr = 0x0f1010c18, .val = 0x00000000 },
	{ .addr = 0x0f1010c1c, .val = 0x00000000 },
	{ .addr = 0x0f1010c20, .val = 0x00000000 },
	{ .addr = 0x0f1010c24, .val = 0x00000000 },
	{ .addr = 0x0f1010c28, .val = 0x00000000 },
	{ .addr = 0x0f1010c2c, .val = 0x00000000 },
	{ .addr = 0x0f1010c30, .val = 0x00000000 },
	{ .addr = 0x0f1010c34, .val = 0x00000000 },
	{ .addr = 0x0f1010c38, .val = 0x00000000 },
	{ .addr = 0x0f1010c3c, .val = 0x00000000 },
	{ .addr = 0x0f1010c40, .val = 0x00000000 },
	{ .addr = 0x0f1010c44, .val = 0x00000000 },
	{ .addr = 0x0f1010c48, .val = 0x00000000 },
	{ .addr = 0x0f1010c4c, .val = 0x00000000 },
	{ .addr = 0x0f1010c50, .val = 0x00000000 },
	{ .addr = 0x0f1010c54, .val = 0x00000000 },
	{ .addr = 0x0f1010c58, .val = 0x00000000 },
	{ .addr = 0x0f1010c5c, .val = 0x00000000 },
	{ .addr = 0x0f1010c60, .val = 0x00000000 },
	{ .addr = 0x0f1010c64, .val = 0x00000000 },
	{ .addr = 0x0f1010c68, .val = 0x00000000 },
	{ .addr = 0x0f1010c6c, .val = 0x00000000 },
	{ .addr = 0x0f1010c70, .val = 0x00000000 },
	{ .addr = 0x0f1010c74, .val = 0x00000000 },
	{ .addr = 0x0f1010c78, .val = 0x00000000 },
	{ .addr = 0x0f1010c7c, .val = 0x00000000 },
	{ .addr = 0x0f1010c80, .val = 0x00000000 },
	{ .addr = 0x0f1010c84, .val = 0x00000000 },
	{ .addr = 0x0f1010c88, .val = 0x00000000 },
	{ .addr = 0x0f1010c8c, .val = 0x00000000 },
	{ .addr = 0x0f1010c90, .val = 0x00000000 },
	{ .addr = 0x0f1010c94, .val = 0x00000000 },
	{ .addr = 0x0f1010c98, .val = 0x00000000 },
	{ .addr = 0x0f1010c9c, .val = 0x00000000 },
	{ .addr = 0x0f1010ca0, .val = 0x00000000 },
	{ .addr = 0x0f1010ca4, .val = 0x00000000 },
	{ .addr = 0x0f1010ca8, .val = 0x00000000 },
	{ .addr = 0x0f1010cac, .val = 0x00000000 },
	{ .addr = 0x0f1010cb0, .val = 0x00000000 },
	{ .addr = 0x0f1010cb4, .val = 0x00000000 },
	{ .addr = 0x0f1010cb8, .val = 0x00000000 },
	{ .addr = 0x0f1010cbc, .val = 0x00000000 },
	{ .addr = 0x0f1010cc0, .val = 0x00000000 },
	{ .addr = 0x0f1010cc4, .val = 0x00000000 },
	{ .addr = 0x0f1010cc8, .val = 0x00000000 },
	{ .addr = 0x0f1010ccc, .val = 0x00000000 },
	{ .addr = 0x0f1010cd0, .val = 0x00000000 },
	{ .addr = 0x0f1010cd4, .val = 0x00000000 },
	{ .addr = 0x0f1010cd8, .val = 0x00000000 },
	{ .addr = 0x0f1010cdc, .val = 0x00000000 },
	{ .addr = 0x0f1010ce0, .val = 0x00000000 },
	{ .addr = 0x0f1010ce4, .val = 0x00000000 },
	{ .addr = 0x0f1010ce8, .val = 0x00000000 },
	{ .addr = 0x0f1010cec, .val = 0x00000000 },
	{ .addr = 0x0f1010cf0, .val = 0x00000000 },
	{ .addr = 0x0f1010cf4, .val = 0x00000000 },
	{ .addr = 0x0f1010cf8, .val = 0x00000000 },
	{ .addr = 0x0f1010cfc, .val = 0x00000000 },
	{ .addr = 0x0f1010d00, .val = 0x00000000 },
	{ .addr = 0x0f1010d04, .val = 0x00000000 },
	{ .addr = 0x0f1010d08, .val = 0x00000000 },
	{ .addr = 0x0f1010d0c, .val = 0x00000000 },
	{ .addr = 0x0f1010d10, .val = 0x00000000 },
	{ .addr = 0x0f1010d14, .val = 0x00000000 },
	{ .addr = 0x0f1010d18, .val = 0x00000000 },
	{ .addr = 0x0f1010d1c, .val = 0x00000000 },
	{ .addr = 0x0f1010d20, .val = 0x00000000 },
	{ .addr = 0x0f1010d24, .val = 0x00000000 },
	{ .addr = 0x0f1010d28, .val = 0x00000000 },
	{ .addr = 0x0f1010d2c, .val = 0x00000000 },
	{ .addr = 0x0f1010d30, .val = 0x00000000 },
	{ .addr = 0x0f1010d34, .val = 0x00000000 },
	{ .addr = 0x0f1010d38, .val = 0x00000000 },
	{ .addr = 0x0f1010d3c, .val = 0x00000000 },
	{ .addr = 0x0f1010d40, .val = 0x00000000 },
	{ .addr = 0x0f1010d44, .val = 0x00000000 },
	{ .addr = 0x0f1010d48, .val = 0x00000000 },
	{ .addr = 0x0f1010d4c, .val = 0x00000000 },
	{ .addr = 0x0f1010d50, .val = 0x00000000 },
	{ .addr = 0x0f1010d54, .val = 0x00000000 },
	{ .addr = 0x0f1010d58, .val = 0x00000000 },
	{ .addr = 0x0f1010d5c, .val = 0x00000000 },
	{ .addr = 0x0f1010d60, .val = 0x00000000 },
	{ .addr = 0x0f1010d64, .val = 0x00000000 },
	{ .addr = 0x0f1010d68, .val = 0x00000000 },
	{ .addr = 0x0f1010d6c, .val = 0x00000000 },
	{ .addr = 0x0f1010d70, .val = 0x00000000 },
	{ .addr = 0x0f1010d74, .val = 0x00000000 },
	{ .addr = 0x0f1010d78, .val = 0x00000000 },
	{ .addr = 0x0f1010d7c, .val = 0x00000000 },
	{ .addr = 0x0f1010d80, .val = 0x00000000 },
	{ .addr = 0x0f1010d84, .val = 0x00000000 },
	{ .addr = 0x0f1010d88, .val = 0x00000000 },
	{ .addr = 0x0f1010d8c, .val = 0x00000000 },
	{ .addr = 0x0f1010d90, .val = 0x00000000 },
	{ .addr = 0x0f1010d94, .val = 0x00000000 },
	{ .addr = 0x0f1010d98, .val = 0x00000000 },
	{ .addr = 0x0f1010d9c, .val = 0x00000000 },
	{ .addr = 0x0f1010da0, .val = 0x00000000 },
	{ .addr = 0x0f1010da4, .val = 0x00000000 },
	{ .addr = 0x0f1010da8, .val = 0x00000000 },
	{ .addr = 0x0f1010dac, .val = 0x00000000 },
	{ .addr = 0x0f1010db0, .val = 0x00000000 },
	{ .addr = 0x0f1010db4, .val = 0x00000000 },
	{ .addr = 0x0f1010db8, .val = 0x00000000 },
	{ .addr = 0x0f1010dbc, .val = 0x00000000 },
	{ .addr = 0x0f1010dc0, .val = 0x00000000 },
	{ .addr = 0x0f1010dc4, .val = 0x00000000 },
	{ .addr = 0x0f1010dc8, .val = 0x00000000 },
	{ .addr = 0x0f1010dcc, .val = 0x00000000 },
	{ .addr = 0x0f1010dd0, .val = 0x00000000 },
	{ .addr = 0x0f1010dd4, .val = 0x00000000 },
	{ .addr = 0x0f1010dd8, .val = 0x00000000 },
	{ .addr = 0x0f1010ddc, .val = 0x00000000 },
	{ .addr = 0x0f1010de0, .val = 0x00000000 },
	{ .addr = 0x0f1010de4, .val = 0x00000000 },
	{ .addr = 0x0f1010de8, .val = 0x00000000 },
	{ .addr = 0x0f1010dec, .val = 0x00000000 },
	{ .addr = 0x0f1010df0, .val = 0x00000000 },
	{ .addr = 0x0f1010df4, .val = 0x00000000 },
	{ .addr = 0x0f1010df8, .val = 0x00000000 },
	{ .addr = 0x0f1010dfc, .val = 0x00000000 },
	{ .addr = 0x0f1010e00, .val = 0x00000000 },
	{ .addr = 0x0f1010e04, .val = 0x00000000 },
	{ .addr = 0x0f1010e08, .val = 0x00000000 },
	{ .addr = 0x0f1010e0c, .val = 0x00000000 },
	{ .addr = 0x0f1010e10, .val = 0x00000000 },
	{ .addr = 0x0f1010e14, .val = 0x00000000 },
	{ .addr = 0x0f1010e18, .val = 0x00000000 },
	{ .addr = 0x0f1010e1c, .val = 0x00000000 },
	{ .addr = 0x0f1010e20, .val = 0x00000000 },
	{ .addr = 0x0f1010e24, .val = 0x00000000 },
	{ .addr = 0x0f1010e28, .val = 0x00000000 },
	{ .addr = 0x0f1010e2c, .val = 0x00000000 },
	{ .addr = 0x0f1010e30, .val = 0x00000000 },
	{ .addr = 0x0f1010e34, .val = 0x00000000 },
	{ .addr = 0x0f1010e38, .val = 0x00000000 },
	{ .addr = 0x0f1010e3c, .val = 0x00000000 },
	{ .addr = 0x0f1010e40, .val = 0x00000000 },
	{ .addr = 0x0f1010e44, .val = 0x00000000 },
	{ .addr = 0x0f1010e48, .val = 0x00000000 },
	{ .addr = 0x0f1010e4c, .val = 0x00000000 },
	{ .addr = 0x0f1010e50, .val = 0x00000000 },
	{ .addr = 0x0f1010e54, .val = 0x00000000 },
	{ .addr = 0x0f1010e58, .val = 0x00000000 },
	{ .addr = 0x0f1010e5c, .val = 0x00000000 },
	{ .addr = 0x0f1010e60, .val = 0x00000000 },
	{ .addr = 0x0f1010e64, .val = 0x00000000 },
	{ .addr = 0x0f1010e68, .val = 0x00000000 },
	{ .addr = 0x0f1010e6c, .val = 0x00000000 },
	{ .addr = 0x0f1010e70, .val = 0x00000000 },
	{ .addr = 0x0f1010e74, .val = 0x00000000 },
	{ .addr = 0x0f1010e78, .val = 0x00000000 },
	{ .addr = 0x0f1010e7c, .val = 0x00000000 },
	{ .addr = 0x0f1010e80, .val = 0x00000000 },
	{ .addr = 0x0f1010e84, .val = 0x00000000 },
	{ .addr = 0x0f1010e88, .val = 0x00000000 },
	{ .addr = 0x0f1010e8c, .val = 0x00000000 },
	{ .addr = 0x0f1010e90, .val = 0x00000000 },
	{ .addr = 0x0f1010e94, .val = 0x00000000 },
	{ .addr = 0x0f1010e98, .val = 0x00000000 },
	{ .addr = 0x0f1010e9c, .val = 0x00000000 },
	{ .addr = 0x0f1010ea0, .val = 0x00000000 },
	{ .addr = 0x0f1010ea4, .val = 0x00000000 },
	{ .addr = 0x0f1010ea8, .val = 0x00000000 },
	{ .addr = 0x0f1010eac, .val = 0x00000000 },
	{ .addr = 0x0f1010eb0, .val = 0x00000000 },
	{ .addr = 0x0f1010eb4, .val = 0x00000000 },
	{ .addr = 0x0f1010eb8, .val = 0x00000000 },
	{ .addr = 0x0f1010ebc, .val = 0x00000000 },
	{ .addr = 0x0f1010ec0, .val = 0x00000000 },
	{ .addr = 0x0f1010ec4, .val = 0x00000000 },
	{ .addr = 0x0f1010ec8, .val = 0x00000000 },
	{ .addr = 0x0f1010ecc, .val = 0x00000000 },
	{ .addr = 0x0f1010ed0, .val = 0x00000000 },
	{ .addr = 0x0f1010ed4, .val = 0x00000000 },
	{ .addr = 0x0f1010ed8, .val = 0x00000000 },
	{ .addr = 0x0f1010edc, .val = 0x00000000 },
	{ .addr = 0x0f1010ee0, .val = 0x00000000 },
	{ .addr = 0x0f1010ee4, .val = 0x00000000 },
	{ .addr = 0x0f1010ee8, .val = 0x00000000 },
	{ .addr = 0x0f1010eec, .val = 0x00000000 },
	{ .addr = 0x0f1010ef0, .val = 0x00000000 },
	{ .addr = 0x0f1010ef4, .val = 0x00000000 },
	{ .addr = 0x0f1010ef8, .val = 0x00000000 },
	{ .addr = 0x0f1010efc, .val = 0x00000000 },
	{ .addr = 0x0f1010f00, .val = 0x00000000 },
	{ .addr = 0x0f1010f04, .val = 0x00000000 },
	{ .addr = 0x0f1010f08, .val = 0x00000000 },
	{ .addr = 0x0f1010f0c, .val = 0x00000000 },
	{ .addr = 0x0f1010f10, .val = 0x00000000 },
	{ .addr = 0x0f1010f14, .val = 0x00000000 },
	{ .addr = 0x0f1010f18, .val = 0x00000000 },
	{ .addr = 0x0f1010f1c, .val = 0x00000000 },
	{ .addr = 0x0f1010f20, .val = 0x00000000 },
	{ .addr = 0x0f1010f24, .val = 0x00000000 },
	{ .addr = 0x0f1010f28, .val = 0x00000000 },
	{ .addr = 0x0f1010f2c, .val = 0x00000000 },
	{ .addr = 0x0f1010f30, .val = 0x00000000 },
	{ .addr = 0x0f1010f34, .val = 0x00000000 },
	{ .addr = 0x0f1010f38, .val = 0x00000000 },
	{ .addr = 0x0f1010f3c, .val = 0x00000000 },
	{ .addr = 0x0f1010f40, .val = 0x00000000 },
	{ .addr = 0x0f1010f44, .val = 0x00000000 },
	{ .addr = 0x0f1010f48, .val = 0x00000000 },
	{ .addr = 0x0f1010f4c, .val = 0x00000000 },
	{ .addr = 0x0f1010f50, .val = 0x00000000 },
	{ .addr = 0x0f1010f54, .val = 0x00000000 },
	{ .addr = 0x0f1010f58, .val = 0x00000000 },
	{ .addr = 0x0f1010f5c, .val = 0x00000000 },
	{ .addr = 0x0f1010f60, .val = 0x00000000 },
	{ .addr = 0x0f1010f64, .val = 0x00000000 },
	{ .addr = 0x0f1010f68, .val = 0x00000000 },
	{ .addr = 0x0f1010f6c, .val = 0x00000000 },
	{ .addr = 0x0f1010f70, .val = 0x00000000 },
	{ .addr = 0x0f1010f74, .val = 0x00000000 },
	{ .addr = 0x0f1010f78, .val = 0x00000000 },
	{ .addr = 0x0f1010f7c, .val = 0x00000000 },
	{ .addr = 0x0f1010f80, .val = 0x00000000 },
	{ .addr = 0x0f1010f84, .val = 0x00000000 },
	{ .addr = 0x0f1010f88, .val = 0x00000000 },
	{ .addr = 0x0f1010f8c, .val = 0x00000000 },
	{ .addr = 0x0f1010f90, .val = 0x00000000 },
	{ .addr = 0x0f1010f94, .val = 0x00000000 },
	{ .addr = 0x0f1010f98, .val = 0x00000000 },
	{ .addr = 0x0f1010f9c, .val = 0x00000000 },
	{ .addr = 0x0f1010fa0, .val = 0x00000000 },
	{ .addr = 0x0f1010fa4, .val = 0x00000000 },
	{ .addr = 0x0f1010fa8, .val = 0x00000000 },
	{ .addr = 0x0f1010fac, .val = 0x00000000 },
	{ .addr = 0x0f1010fb0, .val = 0x00000000 },
	{ .addr = 0x0f1010fb4, .val = 0x00000000 },
	{ .addr = 0x0f1010fb8, .val = 0x00000000 },
	{ .addr = 0x0f1010fbc, .val = 0x00000000 },
	{ .addr = 0x0f1010fc0, .val = 0x00000000 },
	{ .addr = 0x0f1010fc4, .val = 0x00000000 },
	{ .addr = 0x0f1010fc8, .val = 0x00000000 },
	{ .addr = 0x0f1010fcc, .val = 0x00000000 },
	{ .addr = 0x0f1010fd0, .val = 0x00000000 },
	{ .addr = 0x0f1010fd4, .val = 0x00000000 },
	{ .addr = 0x0f1010fd8, .val = 0x00000000 },
	{ .addr = 0x0f1010fdc, .val = 0x00000000 },
	{ .addr = 0x0f1010fe0, .val = 0x00000000 },
	{ .addr = 0x0f1010fe4, .val = 0x00000000 },
	{ .addr = 0x0f1010fe8, .val = 0x00000000 },
	{ .addr = 0x0f1010fec, .val = 0x00000000 },
	{ .addr = 0x0f1010ff0, .val = 0x00000000 },
	{ .addr = 0x0f1010ff4, .val = 0x00000000 },
	{ .addr = 0x0f1010ff8, .val = 0x00000000 },
	{ .addr = 0x0f1010ffc, .val = 0x00000000 },
	{ .addr = 0x0f1011000, .val = 0x00000000 },
	{ .addr = 0x0f1011004, .val = 0x00000000 },
	{ .addr = 0x0f1011008, .val = 0x00000000 },
	{ .addr = 0x0f101100c, .val = 0x00000000 },
	{ .addr = 0x0f1011010, .val = 0x00000000 },
	{ .addr = 0x0f1011014, .val = 0x00000000 },
	{ .addr = 0x0f1011018, .val = 0x00000000 },
	{ .addr = 0x0f101101c, .val = 0x00000000 },
	{ .addr = 0x0f1011020, .val = 0x00000000 },
	{ .addr = 0x0f1011024, .val = 0x00000000 },
	{ .addr = 0x0f1011028, .val = 0x00000000 },
	{ .addr = 0x0f101102c, .val = 0x00000000 },
	{ .addr = 0x0f1011030, .val = 0x00000000 },
	{ .addr = 0x0f1011034, .val = 0x00000000 },
	{ .addr = 0x0f1011038, .val = 0x00000000 },
	{ .addr = 0x0f101103c, .val = 0x00000000 },
	{ .addr = 0x0f1011040, .val = 0x00000000 },
	{ .addr = 0x0f1011044, .val = 0x00000000 },
	{ .addr = 0x0f1011048, .val = 0x00000000 },
	{ .addr = 0x0f101104c, .val = 0x00000000 },
	{ .addr = 0x0f1011050, .val = 0x00000000 },
	{ .addr = 0x0f1011054, .val = 0x00000000 },
	{ .addr = 0x0f1011058, .val = 0x00000000 },
	{ .addr = 0x0f101105c, .val = 0x00000000 },
	{ .addr = 0x0f1011060, .val = 0x00000000 },
	{ .addr = 0x0f1011064, .val = 0x00000000 },
	{ .addr = 0x0f1011068, .val = 0x00000000 },
	{ .addr = 0x0f101106c, .val = 0x00000000 },
	{ .addr = 0x0f1011070, .val = 0x00000000 },
	{ .addr = 0x0f1011074, .val = 0x00000000 },
	{ .addr = 0x0f1011078, .val = 0x00000000 },
	{ .addr = 0x0f101107c, .val = 0x00000000 },
	{ .addr = 0x0f1011080, .val = 0x00000000 },
	{ .addr = 0x0f1011084, .val = 0x00000000 },
	{ .addr = 0x0f1011088, .val = 0x00000000 },
	{ .addr = 0x0f101108c, .val = 0x00000000 },
	{ .addr = 0x0f1011090, .val = 0x00000000 },
	{ .addr = 0x0f1011094, .val = 0x00000000 },
	{ .addr = 0x0f1011098, .val = 0x00000000 },
	{ .addr = 0x0f101109c, .val = 0x00000000 },
	{ .addr = 0x0f10110a0, .val = 0x00000000 },
	{ .addr = 0x0f10110a4, .val = 0x00000000 },
	{ .addr = 0x0f10110a8, .val = 0x00000000 },
	{ .addr = 0x0f10110ac, .val = 0x00000000 },
	{ .addr = 0x0f10110b0, .val = 0x00000000 },
	{ .addr = 0x0f10110b4, .val = 0x00000000 },
	{ .addr = 0x0f10110b8, .val = 0x00000000 },
	{ .addr = 0x0f10110bc, .val = 0x00000000 },
	{ .addr = 0x0f10110c0, .val = 0x00000000 },
	{ .addr = 0x0f10110c4, .val = 0x00000000 },
	{ .addr = 0x0f10110c8, .val = 0x00000000 },
	{ .addr = 0x0f10110cc, .val = 0x00000000 },
	{ .addr = 0x0f10110d0, .val = 0x00000000 },
	{ .addr = 0x0f10110d4, .val = 0x00000000 },
	{ .addr = 0x0f10110d8, .val = 0x00000000 },
	{ .addr = 0x0f10110dc, .val = 0x00000000 },
	{ .addr = 0x0f10110e0, .val = 0x00000000 },
	{ .addr = 0x0f10110e4, .val = 0x00000000 },
	{ .addr = 0x0f10110e8, .val = 0x00000000 },
	{ .addr = 0x0f10110ec, .val = 0x00000000 },
	{ .addr = 0x0f10110f0, .val = 0x00000000 },
	{ .addr = 0x0f10110f4, .val = 0x00000000 },
	{ .addr = 0x0f10110f8, .val = 0x00000000 },
	{ .addr = 0x0f10110fc, .val = 0x00000000 },
	{ .addr = 0x0f1011100, .val = 0x00000000 },
	{ .addr = 0x0f1011104, .val = 0x00000000 },
	{ .addr = 0x0f1011108, .val = 0x00000000 },
	{ .addr = 0x0f101110c, .val = 0x00000000 },
	{ .addr = 0x0f1011110, .val = 0x00000000 },
	{ .addr = 0x0f1011114, .val = 0x00000000 },
	{ .addr = 0x0f1011118, .val = 0x00000000 },
	{ .addr = 0x0f101111c, .val = 0x00000000 },
	{ .addr = 0x0f1011120, .val = 0x00000000 },
	{ .addr = 0x0f1011124, .val = 0x00000000 },
	{ .addr = 0x0f1011128, .val = 0x00000000 },
	{ .addr = 0x0f101112c, .val = 0x00000000 },
	{ .addr = 0x0f1011130, .val = 0x00000000 },
	{ .addr = 0x0f1011134, .val = 0x00000000 },
	{ .addr = 0x0f1011138, .val = 0x00000000 },
	{ .addr = 0x0f101113c, .val = 0x00000000 },
	{ .addr = 0x0f1011140, .val = 0x00000000 },
	{ .addr = 0x0f1011144, .val = 0x00000000 },
	{ .addr = 0x0f1011148, .val = 0x00000000 },
	{ .addr = 0x0f101114c, .val = 0x00000000 },
	{ .addr = 0x0f1011150, .val = 0xffffffff },
	{ .addr = 0x0f1011154, .val = 0xffffffff },
	{ .addr = 0x0f1011158, .val = 0xffffffff },
	{ .addr = 0x0f101115c, .val = 0xffffffff },
	{ .addr = 0x0f1011160, .val = 0xffffffff },
	{ .addr = 0x0f1011164, .val = 0xffffffff },
	{ .addr = 0x0f1011168, .val = 0xffffffff },
	{ .addr = 0x0f101116c, .val = 0xffffffff },
	{ .addr = 0x0f1011170, .val = 0x00000000 },
	{ .addr = 0x0f1011174, .val = 0x00000000 },
	{ .addr = 0x0f1011178, .val = 0x00000000 },
	{ .addr = 0x0f101117c, .val = 0x00000000 },
	{ .addr = 0x0f1011180, .val = 0x00000000 },
	{ .addr = 0x0f1011184, .val = 0x00000000 },
	{ .addr = 0x0f1011188, .val = 0x00000000 },
	{ .addr = 0x0f101118c, .val = 0x00000000 },
	{ .addr = 0x0f1011190, .val = 0x00000000 },
	{ .addr = 0x0f1011194, .val = 0x00000000 },
	{ .addr = 0x0f1011198, .val = 0x00000000 },
	{ .addr = 0x0f101119c, .val = 0x00000000 },
	{ .addr = 0x0f10111a0, .val = 0x00000000 },
	{ .addr = 0x0f10111a4, .val = 0x00000000 },
	{ .addr = 0x0f10111a8, .val = 0x00000000 },
	{ .addr = 0x0f10111ac, .val = 0x00000000 },
	{ .addr = 0x0f10111b0, .val = 0x00000000 },
	{ .addr = 0x0f10111b4, .val = 0x00000000 },
	{ .addr = 0x0f10111b8, .val = 0x00000001 },
	{ .addr = 0x0f10111bc, .val = 0x000493e0 },
	{ .addr = 0x0f10111c4, .val = 0x00000000 },
	{ .addr = 0x0f10111c8, .val = 0x00000000 },
	{ .addr = 0x0f10111cc, .val = 0x00000000 },
	{ .addr = 0x0f1011200, .val = 0x00000000 },
	{ .addr = 0x0f1011204, .val = 0x00000000 },
	{ .addr = 0x0f1011208, .val = 0x00000000 },
	{ .addr = 0x0f101120c, .val = 0x00000000 },
	{ .addr = 0x0f1011210, .val = 0x00000000 },
	{ .addr = 0x0f1011214, .val = 0x00000000 },
	{ .addr = 0x0f1011218, .val = 0x00000000 },
	{ .addr = 0x0f101121c, .val = 0x00000000 },
	{ .addr = 0x0f1011220, .val = 0x00000000 },
	{ .addr = 0x0f1011224, .val = 0x00000000 },
	{ .addr = 0x0f1011228, .val = 0x00000000 },
	{ .addr = 0x0f101122c, .val = 0x00000000 },
	{ .addr = 0x0f1011230, .val = 0x00000000 },
	{ .addr = 0x0f1011234, .val = 0x00000000 },
	{ .addr = 0x0f1011238, .val = 0x00000000 },
	{ .addr = 0x0f101123c, .val = 0x00000000 },
	{ .addr = 0x0f1011240, .val = 0x00000000 },
	{ .addr = 0x0f1011244, .val = 0x00000000 },
	{ .addr = 0x0f1011248, .val = 0x00000000 },
	{ .addr = 0x0f101124c, .val = 0x00000000 },
	{ .addr = 0x0f1011250, .val = 0x00000000 },
	{ .addr = 0x0f1011254, .val = 0x00000000 },
	{ .addr = 0x0f1011258, .val = 0x00000000 },
	{ .addr = 0x0f101125c, .val = 0x00000000 },
	{ .addr = 0x0f1011260, .val = 0x00000000 },
	{ .addr = 0x0f1011264, .val = 0x00000000 },
	{ .addr = 0x0f1011268, .val = 0x00000000 },
	{ .addr = 0x0f101126c, .val = 0x00000000 },
	{ .addr = 0x0f1011270, .val = 0x00000000 },
	{ .addr = 0x0f1011274, .val = 0x00000000 },
	{ .addr = 0x0f1011278, .val = 0x00000000 },
	{ .addr = 0x0f101127c, .val = 0x00000000 },
	{ .addr = 0x0f1011280, .val = 0x00000000 },
	{ .addr = 0x0f1011284, .val = 0x00000000 },
	{ .addr = 0x0f1011288, .val = 0x00000000 },
	{ .addr = 0x0f101128c, .val = 0x00000000 },
	{ .addr = 0x0f1011290, .val = 0x00000000 },
	{ .addr = 0x0f1011294, .val = 0x00000000 },
	{ .addr = 0x0f1011298, .val = 0x00000000 },
	{ .addr = 0x0f101129c, .val = 0x00000000 },
	{ .addr = 0x0f10112a0, .val = 0x00000000 },
	{ .addr = 0x0f10112a4, .val = 0x00000000 },
	{ .addr = 0x0f10112a8, .val = 0x00000000 },
	{ .addr = 0x0f10112ac, .val = 0x00000000 },
	{ .addr = 0x0f10112b0, .val = 0x00000000 },
	{ .addr = 0x0f10112b4, .val = 0x00000000 },
	{ .addr = 0x0f10112b8, .val = 0x00000000 },
	{ .addr = 0x0f10112bc, .val = 0x00000000 },
	{ .addr = 0x0f10112c0, .val = 0x00000000 },
	{ .addr = 0x0f10112c4, .val = 0x00000000 },
	{ .addr = 0x0f10112c8, .val = 0x00000000 },
	{ .addr = 0x0f10112cc, .val = 0x00000000 },
	{ .addr = 0x0f10112d0, .val = 0x00000000 },
	{ .addr = 0x0f10112d4, .val = 0x00000000 },
	{ .addr = 0x0f10112d8, .val = 0x00000000 },
	{ .addr = 0x0f10112dc, .val = 0x00000000 },
	{ .addr = 0x0f10112e0, .val = 0x00000000 },
	{ .addr = 0x0f10112e4, .val = 0x00000000 },
	{ .addr = 0x0f10112e8, .val = 0x00000000 },
	{ .addr = 0x0f10112ec, .val = 0x00000000 },
	{ .addr = 0x0f10112f0, .val = 0x00000000 },
	{ .addr = 0x0f10112f4, .val = 0x00000000 },
	{ .addr = 0x0f10112f8, .val = 0x00000000 },
	{ .addr = 0x0f10112fc, .val = 0x00000000 },
	{ .addr = 0x0f1011300, .val = 0x00000000 },
	{ .addr = 0x0f1011304, .val = 0x00000000 },
	{ .addr = 0x0f1011308, .val = 0x00000000 },
	{ .addr = 0x0f101130c, .val = 0x00000000 },
	{ .addr = 0x0f1011310, .val = 0x00000000 },
	{ .addr = 0x0f1011314, .val = 0x00000000 },
	{ .addr = 0x0f1011318, .val = 0x00000000 },
	{ .addr = 0x0f101131c, .val = 0x00000000 },
	{ .addr = 0x0f1011320, .val = 0x00000000 },
	{ .addr = 0x0f1011324, .val = 0x00000000 },
	{ .addr = 0x0f1011328, .val = 0x00000000 },
	{ .addr = 0x0f101132c, .val = 0x00000000 },
	{ .addr = 0x0f1011330, .val = 0x00000000 },
	{ .addr = 0x0f1011334, .val = 0x00000000 },
	{ .addr = 0x0f1011338, .val = 0x00000000 },
	{ .addr = 0x0f101133c, .val = 0x00000000 },
	{ .addr = 0x0f1011340, .val = 0x00000000 },
	{ .addr = 0x0f1011344, .val = 0x00000000 },
	{ .addr = 0x0f1011348, .val = 0x00000000 },
	{ .addr = 0x0f101134c, .val = 0x00000000 },
	{ .addr = 0x0f1011350, .val = 0x00000000 },
	{ .addr = 0x0f1011354, .val = 0x00000000 },
	{ .addr = 0x0f1011358, .val = 0x00000000 },
	{ .addr = 0x0f101135c, .val = 0x00000000 },
	{ .addr = 0x0f1011360, .val = 0x00000000 },
	{ .addr = 0x0f1011364, .val = 0x00000000 },
	{ .addr = 0x0f1011368, .val = 0x00000000 },
	{ .addr = 0x0f101136c, .val = 0x00000000 },
	{ .addr = 0x0f1011370, .val = 0x00000000 },
	{ .addr = 0x0f1011374, .val = 0x00000000 },
	{ .addr = 0x0f1011378, .val = 0x00000000 },
	{ .addr = 0x0f101137c, .val = 0x00000000 },
	{ .addr = 0x0f1011380, .val = 0x00000000 },
	{ .addr = 0x0f1011384, .val = 0x00000000 },
	{ .addr = 0x0f1011388, .val = 0x00000000 },
	{ .addr = 0x0f101138c, .val = 0x00000000 },
	{ .addr = 0x0f1011390, .val = 0x00000000 },
	{ .addr = 0x0f1011394, .val = 0x00000000 },
	{ .addr = 0x0f1011398, .val = 0x00000000 },
	{ .addr = 0x0f101139c, .val = 0x00000000 },
	{ .addr = 0x0f10113a0, .val = 0x00000000 },
	{ .addr = 0x0f10113a4, .val = 0x00000000 },
	{ .addr = 0x0f10113a8, .val = 0x00000000 },
	{ .addr = 0x0f10113ac, .val = 0x00000000 },
	{ .addr = 0x0f10113b0, .val = 0x00000000 },
	{ .addr = 0x0f10113b4, .val = 0x00000000 },
	{ .addr = 0x0f10113b8, .val = 0x00000000 },
	{ .addr = 0x0f10113bc, .val = 0x00000000 },
	{ .addr = 0x0f10113c0, .val = 0x00000000 },
	{ .addr = 0x0f10113c4, .val = 0x00000000 },
	{ .addr = 0x0f10113c8, .val = 0x00000000 },
	{ .addr = 0x0f10113cc, .val = 0x00000000 },
	{ .addr = 0x0f10113d0, .val = 0x00000000 },
	{ .addr = 0x0f10113d4, .val = 0x00000000 },
	{ .addr = 0x0f10113d8, .val = 0x00000000 },
	{ .addr = 0x0f10113dc, .val = 0x00000000 },
	{ .addr = 0x0f10113e0, .val = 0x00000000 },
	{ .addr = 0x0f10113e4, .val = 0x00000000 },
	{ .addr = 0x0f10113e8, .val = 0x00000000 },
	{ .addr = 0x0f10113ec, .val = 0x00000000 },
	{ .addr = 0x0f10113f0, .val = 0x00000000 },
	{ .addr = 0x0f10113f4, .val = 0x00000000 },
	{ .addr = 0x0f10113f8, .val = 0x00000000 },
	{ .addr = 0x0f10113fc, .val = 0x00000000 },
	{ .addr = 0x0f1020000, .val = 0x00000000 },
	{ .addr = 0x0f1020008, .val = 0x00000000 },
	{ .addr = 0x0f102000c, .val = 0x00000000 },
	{ .addr = 0x0f1020010, .val = 0x00000000 },
	{ .addr = 0x0f1020014, .val = 0x00000000 },
	{ .addr = 0x0f1020018, .val = 0x00000000 },
	{ .addr = 0x0f102001c, .val = 0x00000000 },
	{ .addr = 0x0f1020020, .val = 0x00000000 },
	{ .addr = 0x0f1020024, .val = 0x00000000 },
	{ .addr = 0x0f1020028, .val = 0x00000000 },
	{ .addr = 0x0f102002c, .val = 0x00000000 },
	{ .addr = 0x0f1020030, .val = 0x00000000 },
	{ .addr = 0x0f1020034, .val = 0x00000000 },
	{ .addr = 0x0f1020038, .val = 0x00000000 },
	{ .addr = 0x0f102003c, .val = 0x00000000 },
	{ .addr = 0x0f1020040, .val = 0x00000000 },
	{ .addr = 0x0f1020044, .val = 0x00000000 },
	{ .addr = 0x0f1020048, .val = 0x00000000 },
	{ .addr = 0x0f102004c, .val = 0x00000000 },
	{ .addr = 0x0f1020050, .val = 0x00000000 },
	{ .addr = 0x0f1020054, .val = 0x00000000 },
	{ .addr = 0x0f1020058, .val = 0x00000000 },
	{ .addr = 0x0f102005c, .val = 0x00000000 },
	{ .addr = 0x0f1020060, .val = 0x00000000 },
	{ .addr = 0x0f1020064, .val = 0x00000000 },
	{ .addr = 0x0f1020068, .val = 0x00000000 },
	{ .addr = 0x0f102006c, .val = 0x00000000 },
	{ .addr = 0x0f1020070, .val = 0x00000000 },
	{ .addr = 0x0f1020074, .val = 0x00000000 },
	{ .addr = 0x0f1020078, .val = 0x00000000 },
	{ .addr = 0x0f102007c, .val = 0x00000000 },
	{ .addr = 0x0f1020080, .val = 0x00000000 },
	{ .addr = 0x0f1020084, .val = 0x00000000 },
	{ .addr = 0x0f1020088, .val = 0x00000000 },
	{ .addr = 0x0f102008c, .val = 0x00000000 },
	{ .addr = 0x0f1020090, .val = 0x00000000 },
	{ .addr = 0x0f1020094, .val = 0x00000000 },
	{ .addr = 0x0f1020098, .val = 0x00000000 },
	{ .addr = 0x0f102009c, .val = 0x00000000 },
	{ .addr = 0x0f10200a0, .val = 0x00000000 },
	{ .addr = 0x0f10200a4, .val = 0x00000000 },
	{ .addr = 0x0f10200a8, .val = 0x00000000 },
	{ .addr = 0x0f10200ac, .val = 0x00000000 },
	{ .addr = 0x0f10200b0, .val = 0x00000000 },
	{ .addr = 0x0f10200b4, .val = 0x00000000 },
	{ .addr = 0x0f10200b8, .val = 0x00000000 },
	{ .addr = 0x0f10200bc, .val = 0x00000000 },
	{ .addr = 0x0f10200c4, .val = 0x00000000 },
	{ .addr = 0x0f10200c8, .val = 0x00000000 },
	{ .addr = 0x0f10200cc, .val = 0x00000000 },
	{ .addr = 0x0f10200d0, .val = 0x00000000 },
	{ .addr = 0x0f10200d4, .val = 0x00000000 },
	{ .addr = 0x0f10200d8, .val = 0x00000000 },
	{ .addr = 0x0f10200dc, .val = 0x00000000 },
	{ .addr = 0x0f10200e0, .val = 0x00000000 },
	{ .addr = 0x0f10200e4, .val = 0x00000000 },
	{ .addr = 0x0f10200e8, .val = 0x00000000 },
	{ .addr = 0x0f10200ec, .val = 0x00000000 },
	{ .addr = 0x0f10200f0, .val = 0x00000000 },
	{ .addr = 0x0f10200f4, .val = 0x00000000 },
	{ .addr = 0x0f10200fc, .val = 0x00000000 },
	{ .addr = 0x0f1020108, .val = 0x00000001 },
	{ .addr = 0x0f102010c, .val = 0x000005ea },
	{ .addr = 0x0f1020110, .val = 0x00000000 },
	{ .addr = 0x0f1020114, .val = 0x00000000 },
	{ .addr = 0x0f1020118, .val = 0x00000000 },
	{ .addr = 0x0f102011c, .val = 0x00000000 },
	{ .addr = 0x0f1020120, .val = 0x00000000 },
	{ .addr = 0x0f1020124, .val = 0x00000000 },
	{ .addr = 0x0f1020130, .val = 0x00000000 },
	{ .addr = 0x0f1020134, .val = 0x00000000 },
	{ .addr = 0x0f1020138, .val = 0x00000000 },
	{ .addr = 0x0f102013c, .val = 0x00000000 },
	{ .addr = 0x0f1020140, .val = 0x00000000 },
	{ .addr = 0x0f1020144, .val = 0x00000000 },
	{ .addr = 0x0f1020150, .val = 0x00000000 },
	{ .addr = 0x0f1020154, .val = 0x00000000 },
	{ .addr = 0x0f1020158, .val = 0x00000000 },
	{ .addr = 0x0f102015c, .val = 0x00000000 },
	{ .addr = 0x0f1020160, .val = 0x00000000 },
	{ .addr = 0x0f1020164, .val = 0x00000000 },
	{ .addr = 0x0f1020170, .val = 0x00000000 },
	{ .addr = 0x0f1020174, .val = 0x00000000 },
	{ .addr = 0x0f1020178, .val = 0x00000000 },
	{ .addr = 0x0f102017c, .val = 0x00000000 },
	{ .addr = 0x0f1020180, .val = 0x00000000 },
	{ .addr = 0x0f1020184, .val = 0x00000000 },
	{ .addr = 0x0f1020190, .val = 0x00000000 },
	{ .addr = 0x0f1020194, .val = 0x00000000 },
	{ .addr = 0x0f1020198, .val = 0x00000000 },
	{ .addr = 0x0f102019c, .val = 0x00000000 },
	{ .addr = 0x0f10201a0, .val = 0x00000000 },
	{ .addr = 0x0f10201a4, .val = 0x00000000 },
	{ .addr = 0x0f10201b0, .val = 0x00000000 },
	{ .addr = 0x0f10201b4, .val = 0x00000000 },
	{ .addr = 0x0f10201b8, .val = 0x00000000 },
	{ .addr = 0x0f10201bc, .val = 0x00000000 },
	{ .addr = 0x0f10201c0, .val = 0x00000000 },
	{ .addr = 0x0f10201c4, .val = 0x00000000 },
	{ .addr = 0x0f10201d0, .val = 0x00000000 },
	{ .addr = 0x0f10201d4, .val = 0x00000000 },
	{ .addr = 0x0f10201d8, .val = 0x00000000 },
	{ .addr = 0x0f10201dc, .val = 0x00000000 },
	{ .addr = 0x0f10201e0, .val = 0x00000000 },
	{ .addr = 0x0f10201e4, .val = 0x00000000 },
	{ .addr = 0x0f10201f0, .val = 0x00000000 },
	{ .addr = 0x0f10201f4, .val = 0x00000000 },
	{ .addr = 0x0f10201f8, .val = 0x00000000 },
	{ .addr = 0x0f10201fc, .val = 0x00000000 },
	{ .addr = 0x0f1020200, .val = 0x00000000 },
	{ .addr = 0x0f1020204, .val = 0x00000000 },
	{ .addr = 0x0f1020210, .val = 0x00000000 },
	{ .addr = 0x0f1020214, .val = 0x00000000 },
	{ .addr = 0x0f1020218, .val = 0x00000000 },
	{ .addr = 0x0f102021c, .val = 0x00000000 },
	{ .addr = 0x0f1020220, .val = 0x00000000 },
	{ .addr = 0x0f1020224, .val = 0x00000000 },
	{ .addr = 0x0f1020230, .val = 0x00000000 },
	{ .addr = 0x0f1020234, .val = 0x00000000 },
	{ .addr = 0x0f1020238, .val = 0x00000000 },
	{ .addr = 0x0f102023c, .val = 0x00000000 },
	{ .addr = 0x0f1020240, .val = 0x00000000 },
	{ .addr = 0x0f1020244, .val = 0x00000000 },
	{ .addr = 0x0f1020250, .val = 0x00000000 },
	{ .addr = 0x0f1020254, .val = 0x00000000 },
	{ .addr = 0x0f1020258, .val = 0x00000000 },
	{ .addr = 0x0f102025c, .val = 0x00000000 },
	{ .addr = 0x0f1020260, .val = 0x00000000 },
	{ .addr = 0x0f1020264, .val = 0x00000000 },
	{ .addr = 0x0f1020270, .val = 0x00000000 },
	{ .addr = 0x0f1020274, .val = 0x00000000 },
	{ .addr = 0x0f1020278, .val = 0x00000000 },
	{ .addr = 0x0f102027c, .val = 0x00000000 },
	{ .addr = 0x0f1020280, .val = 0x00000000 },
	{ .addr = 0x0f1020284, .val = 0x00000000 },
	{ .addr = 0x0f1020290, .val = 0x00000000 },
	{ .addr = 0x0f1020294, .val = 0x00000000 },
	{ .addr = 0x0f1020298, .val = 0x00000000 },
	{ .addr = 0x0f102029c, .val = 0x00000000 },
	{ .addr = 0x0f10202a0, .val = 0x00000000 },
	{ .addr = 0x0f10202a4, .val = 0x00000000 },
	{ .addr = 0x0f10202b0, .val = 0x00000000 },
	{ .addr = 0x0f10202b4, .val = 0x00000000 },
	{ .addr = 0x0f10202b8, .val = 0x00000000 },
	{ .addr = 0x0f10202bc, .val = 0x00000000 },
	{ .addr = 0x0f10202c0, .val = 0x00000000 },
	{ .addr = 0x0f10202c4, .val = 0x00000000 },
	{ .addr = 0x0f10202d0, .val = 0x00000000 },
	{ .addr = 0x0f10202d4, .val = 0x00000000 },
	{ .addr = 0x0f10202d8, .val = 0x00000000 },
	{ .addr = 0x0f10202dc, .val = 0x00000000 },
	{ .addr = 0x0f10202e0, .val = 0x00000000 },
	{ .addr = 0x0f10202e4, .val = 0x00000000 },
	{ .addr = 0x0f10202f0, .val = 0x00000000 },
	{ .addr = 0x0f10202f4, .val = 0x00000000 },
	{ .addr = 0x0f10202f8, .val = 0x00000000 },
	{ .addr = 0x0f10202fc, .val = 0x00000000 },
	{ .addr = 0x0f1020300, .val = 0x00000000 },
	{ .addr = 0x0f1020304, .val = 0x00000000 },
	{ .addr = 0x0f1020314, .val = 0x000005dc },
	{ .addr = 0x0f1020318, .val = 0x00000000 },
	{ .addr = 0x0f102031c, .val = 0x00000000 },
	{ .addr = 0x0f1020320, .val = 0x00000000 },
	{ .addr = 0x0f1020324, .val = 0x00000000 },
	{ .addr = 0x0f10203c0, .val = 0x00000000 },
	{ .addr = 0x0f10203c4, .val = 0x00000000 },
	{ .addr = 0x0f10203c8, .val = 0x00000000 },
	{ .addr = 0x0f10203cc, .val = 0x00000000 },
	{ .addr = 0x0f10203d0, .val = 0x00000000 },
	{ .addr = 0x0f10203d4, .val = 0x00000000 },
	{ .addr = 0x0f10203d8, .val = 0x00000000 },
	{ .addr = 0x0f10203dc, .val = 0x00000000 },
	{ .addr = 0x0f10203e0, .val = 0x00000000 },
	{ .addr = 0x0f10203e4, .val = 0x00000000 },
	{ .addr = 0x0f10203e8, .val = 0x00000000 },
	{ .addr = 0x0f10203ec, .val = 0x00000000 },
	{ .addr = 0x0f10203f0, .val = 0x00000000 },
	{ .addr = 0x0f10203f4, .val = 0x00000000 },
	{ .addr = 0x0f10203f8, .val = 0x00000000 },
	{ .addr = 0x0f10203fc, .val = 0x00000000 },
	{ .addr = 0x0f11c0004, .val = 0x00000000 },
	{ .addr = 0x0f11c0008, .val = 0x00000000 },
	{ .addr = 0x0f11c000c, .val = 0x00000010 },
	{ .addr = 0x0f11c0010, .val = 0x00000000 },
	{ .addr = 0x0f11c0014, .val = 0x00000020 },
	{ .addr = 0x0f11c0018, .val = 0x00000480 },
	{ .addr = 0x0f11c0020, .val = 0x00000000 },
	{ .addr = 0x0f11c0024, .val = 0x00000000 },
	{ .addr = 0x0f11c0028, .val = 0x00000000 },
	{ .addr = 0x0f11c0030, .val = 0x00000000 },
	{ .addr = 0x0f11c0034, .val = 0x00000000 },
	{ .addr = 0x0f11c0038, .val = 0x00000000 },
	{ .addr = 0x0f11c003c, .val = 0x00000000 },
	{ .addr = 0x0f11c0040, .val = 0x00000000 },
	{ .addr = 0x0f11c0044, .val = 0x00000000 },
	{ .addr = 0x0f11c0048, .val = 0x00000000 },
	{ .addr = 0x0f11c004c, .val = 0x00000020 },
	{ .addr = 0x0f11c0050, .val = 0x00000000 },
	{ .addr = 0x0f11c0054, .val = 0x00000000 },
	{ .addr = 0x0f11c0058, .val = 0x00000000 },
	{ .addr = 0x0f11c005c, .val = 0x00000000 },
	{ .addr = 0x0f11c0060, .val = 0x00000000 },
	{ .addr = 0x0f11c0100, .val = 0x00000000 },
	{ .addr = 0x0f11c0104, .val = 0x00000000 },
	{ .addr = 0x0f11c0108, .val = 0x00000000 },
	{ .addr = 0x0f11c010c, .val = 0x00000000 },
	{ .addr = 0x0f11c0110, .val = 0x00000000 },
	{ .addr = 0x0f11c0114, .val = 0x00000000 },
	{ .addr = 0x0f11c0118, .val = 0x00000000 },
	{ .addr = 0x0f11c011c, .val = 0x00000000 },
	{ .addr = 0x0f11c0120, .val = 0x00000000 },
	{ .addr = 0x0f11c0124, .val = 0x00000000 },
	{ .addr = 0x0f11c0128, .val = 0x00000000 },
	{ .addr = 0x0f11c012c, .val = 0x00000000 },
	{ .addr = 0x0f11c0130, .val = 0x00000000 },
	{ .addr = 0x0f11c0134, .val = 0x00000000 },
	{ .addr = 0x0f11c0138, .val = 0x00000000 },
	{ .addr = 0x0f11c013c, .val = 0x00000000 },
	{ .addr = 0x0f11c0200, .val = 0x000001ff },
	{ .addr = 0x0f11c0204, .val = 0x000001ff },
	{ .addr = 0x0f11c0208, .val = 0x000001ff },
	{ .addr = 0x0f11c020c, .val = 0x000001ff },
	{ .addr = 0x0f11c0210, .val = 0x000001ff },
	{ .addr = 0x0f11c0214, .val = 0x000001ff },
	{ .addr = 0x0f11c0218, .val = 0x000001ff },
	{ .addr = 0x0f11c021c, .val = 0x000001ff },
	{ .addr = 0x0f11c0220, .val = 0x000001ff },
	{ .addr = 0x0f11c0224, .val = 0x000001ff },
	{ .addr = 0x0f11c0228, .val = 0x000001ff },
	{ .addr = 0x0f11c022c, .val = 0x000001ff },
	{ .addr = 0x0f11c0230, .val = 0x000001ff },
	{ .addr = 0x0f11c0234, .val = 0x000001ff },
	{ .addr = 0x0f11c0238, .val = 0x000001ff },
	{ .addr = 0x0f11c023c, .val = 0x000001ff },
	{ .addr = 0x0f11c0300, .val = 0xffffffff },
	{ .addr = 0x0f11c0304, .val = 0xffffffff },
	{ .addr = 0x0f11c0308, .val = 0xffffffff },
	{ .addr = 0x0f11c030c, .val = 0xffffffff },
	{ .addr = 0x0f11c0310, .val = 0x00000000 },
	{ .addr = 0x0f11c0314, .val = 0x00000000 },
	{ .addr = 0x0f11c0318, .val = 0x00000000 },
	{ .addr = 0x0f11c031c, .val = 0x00000000 },
	{ .addr = 0x0f11c0320, .val = 0x00000000 },
	{ .addr = 0x0f11c0324, .val = 0x00000000 },
	{ .addr = 0x0f11c0328, .val = 0x00000000 },
	{ .addr = 0x0f11c032c, .val = 0x00000000 },
	{ .addr = 0x0f11c0330, .val = 0x00000000 },
	{ .addr = 0x0f11c0334, .val = 0x00000000 },
	{ .addr = 0x0f11c0338, .val = 0x00000000 },
	{ .addr = 0x0f11c033c, .val = 0x00000000 },
	{ .addr = 0x0f11c0400, .val = 0xffffffff },
	{ .addr = 0x0f11c0404, .val = 0xffffffff },
	{ .addr = 0x0f11c0408, .val = 0xffffffff },
	{ .addr = 0x0f11c040c, .val = 0xffffffff },
	{ .addr = 0x0f11c0410, .val = 0xffffffff },
	{ .addr = 0x0f11c0414, .val = 0xffffffff },
	{ .addr = 0x0f11c0418, .val = 0xffffffff },
	{ .addr = 0x0f11c041c, .val = 0xffffffff },
	{ .addr = 0x0f11c0420, .val = 0xffffffff },
	{ .addr = 0x0f11c0424, .val = 0xffffffff },
	{ .addr = 0x0f11c0428, .val = 0xffffffff },
	{ .addr = 0x0f11c042c, .val = 0xffffffff },
	{ .addr = 0x0f11c0430, .val = 0xffffffff },
	{ .addr = 0x0f11c0434, .val = 0xffffffff },
	{ .addr = 0x0f11c0438, .val = 0xffffffff },
	{ .addr = 0x0f11c043c, .val = 0xffffffff },
	{ .addr = 0x0f0080004, .val = 0x00000000 },
	{ .addr = 0x0f008000c, .val = 0x0000ffff },
	{ .addr = 0x0f0080010, .val = 0x00000000 },
	{ .addr = 0x0f0080014, .val = 0x00000000 },
	{ .addr = 0x0f008001c, .val = 0x0000ffff },
	{ .addr = 0x0f0080020, .val = 0x00000000 },
	{ .addr = 0x0f0080024, .val = 0x00000000 },
	{ .addr = 0x0f0080028, .val = 0x00000000 },
	{ .addr = 0x0f008002c, .val = 0x00000000 },
	{ .addr = 0x0f0080030, .val = 0x00000000 },
	{ .addr = 0x0f0080034, .val = 0x00000000 },
	{ .addr = 0x0f0080038, .val = 0x00000000 },
	{ .addr = 0x0f008003c, .val = 0x00000000 },
	{ .addr = 0x0f0080040, .val = 0x00000000 },
	{ .addr = 0x0f0080044, .val = 0x00000000 },
	{ .addr = 0x0f0080048, .val = 0x00000000 },
	{ .addr = 0x0f008004c, .val = 0x00000000 },
	{ .addr = 0x0f0080050, .val = 0x00000000 },
	{ .addr = 0x0f0080054, .val = 0x00000000 },
	{ .addr = 0x0f0080058, .val = 0x00000000 },
	{ .addr = 0x0f008005c, .val = 0x00000000 },
	{ .addr = 0x0f0080400, .val = 0x00000000 },
	{ .addr = 0x0f0080404, .val = 0x00000000 },
	{ .addr = 0x0f0080408, .val = 0x00000000 },
	{ .addr = 0x0f008040c, .val = 0x00000000 },
	{ .addr = 0x0f0080410, .val = 0x00000000 },
	{ .addr = 0x0f0080414, .val = 0x00000000 },
	{ .addr = 0x0f0080418, .val = 0x00000000 },
	{ .addr = 0x0f008041c, .val = 0x00000000 },
	{ .addr = 0x0f0080420, .val = 0x00000000 },
	{ .addr = 0x0f0080424, .val = 0x00000000 },
	{ .addr = 0x0f0080428, .val = 0x00000000 },
	{ .addr = 0x0f008042c, .val = 0x00000000 },
	{ .addr = 0x0f0080430, .val = 0x00000000 },
	{ .addr = 0x0f0080434, .val = 0x00000000 },
	{ .addr = 0x0f0080438, .val = 0x00000000 },
	{ .addr = 0x0f008043c, .val = 0x00000000 },
	{ .addr = 0x0f0080440, .val = 0x00000100 },
	{ .addr = 0x0f0080444, .val = 0x00000100 },
	{ .addr = 0x0f0080448, .val = 0x00000100 },
	{ .addr = 0x0f008044c, .val = 0x00000100 },
	{ .addr = 0x0f0080450, .val = 0x00000100 },
	{ .addr = 0x0f0080454, .val = 0x00000100 },
	{ .addr = 0x0f0080458, .val = 0x00000100 },
	{ .addr = 0x0f008045c, .val = 0x00000100 },
	{ .addr = 0x0f0080460, .val = 0x00000100 },
	{ .addr = 0x0f0080464, .val = 0x00000100 },
	{ .addr = 0x0f0080468, .val = 0x00000100 },
	{ .addr = 0x0f008046c, .val = 0x00000100 },
	{ .addr = 0x0f0080470, .val = 0x00000100 },
	{ .addr = 0x0f0080474, .val = 0x00000100 },
	{ .addr = 0x0f0080478, .val = 0x00000100 },
	{ .addr = 0x0f008047c, .val = 0x00000100 },
	{ .addr = 0x0f00804c0, .val = 0x00000055 },
	{ .addr = 0x0f00804c4, .val = 0x00000055 },
	{ .addr = 0x0f00804c8, .val = 0x00000055 },
	{ .addr = 0x0f00804cc, .val = 0x00000055 },
	{ .addr = 0x0f00804d0, .val = 0x00000055 },
	{ .addr = 0x0f00804d4, .val = 0x00000055 },
	{ .addr = 0x0f00804d8, .val = 0x00000055 },
	{ .addr = 0x0f00804dc, .val = 0x00000055 },
	{ .addr = 0x0f00804e0, .val = 0x00000055 },
	{ .addr = 0x0f00804e4, .val = 0x00000055 },
	{ .addr = 0x0f00804e8, .val = 0x00000055 },
	{ .addr = 0x0f00804ec, .val = 0x00000055 },
	{ .addr = 0x0f00804f0, .val = 0x00000055 },
	{ .addr = 0x0f00804f4, .val = 0x00000055 },
	{ .addr = 0x0f00804f8, .val = 0x00000055 },
	{ .addr = 0x0f00804fc, .val = 0x00000055 },
	{ .addr = 0x0f0080500, .val = 0x000000aa },
	{ .addr = 0x0f0080504, .val = 0x000000aa },
	{ .addr = 0x0f0080508, .val = 0x000000aa },
	{ .addr = 0x0f008050c, .val = 0x000000aa },
	{ .addr = 0x0f0080510, .val = 0x000000aa },
	{ .addr = 0x0f0080514, .val = 0x000000aa },
	{ .addr = 0x0f0080518, .val = 0x000000aa },
	{ .addr = 0x0f008051c, .val = 0x000000aa },
	{ .addr = 0x0f0080520, .val = 0x000000aa },
	{ .addr = 0x0f0080524, .val = 0x000000aa },
	{ .addr = 0x0f0080528, .val = 0x000000aa },
	{ .addr = 0x0f008052c, .val = 0x000000aa },
	{ .addr = 0x0f0080530, .val = 0x000000aa },
	{ .addr = 0x0f0080534, .val = 0x000000aa },
	{ .addr = 0x0f0080538, .val = 0x000000aa },
	{ .addr = 0x0f008053c, .val = 0x000000aa },
	{ .addr = 0x0f0080540, .val = 0x00000000 },
	{ .addr = 0x0f0080544, .val = 0x00000000 },
	{ .addr = 0x0f0080548, .val = 0x00000000 },
	{ .addr = 0x0f008054c, .val = 0x00000000 },
	{ .addr = 0x0f0080550, .val = 0x00000000 },
	{ .addr = 0x0f0080554, .val = 0x00000000 },
	{ .addr = 0x0f0080558, .val = 0x00000000 },
	{ .addr = 0x0f008055c, .val = 0x00000000 },
	{ .addr = 0x0f0080560, .val = 0x00000000 },
	{ .addr = 0x0f0080564, .val = 0x00000000 },
	{ .addr = 0x0f0080568, .val = 0x00000000 },
	{ .addr = 0x0f008056c, .val = 0x00000000 },
	{ .addr = 0x0f0080570, .val = 0x00000000 },
	{ .addr = 0x0f0080574, .val = 0x00000000 },
	{ .addr = 0x0f0080578, .val = 0x00000000 },
	{ .addr = 0x0f008057c, .val = 0x00000000 },
	{ .addr = 0x0f0080580, .val = 0x00000000 },
	{ .addr = 0x0f0080584, .val = 0x00000000 },
	{ .addr = 0x0f0080588, .val = 0x00000000 },
	{ .addr = 0x0f008058c, .val = 0x00000000 },
	{ .addr = 0x0f0080590, .val = 0x00000000 },
	{ .addr = 0x0f0080594, .val = 0x00000000 },
	{ .addr = 0x0f0080598, .val = 0x00000000 },
	{ .addr = 0x0f008059c, .val = 0x00000000 },
	{ .addr = 0x0f00805a0, .val = 0x00000000 },
	{ .addr = 0x0f00805a4, .val = 0x00000000 },
	{ .addr = 0x0f00805a8, .val = 0x00000000 },
	{ .addr = 0x0f00805ac, .val = 0x00000000 },
	{ .addr = 0x0f00805b0, .val = 0x00000000 },
	{ .addr = 0x0f00805b4, .val = 0x00000000 },
	{ .addr = 0x0f00805b8, .val = 0x00000000 },
	{ .addr = 0x0f00805bc, .val = 0x00000000 },
	{ .addr = 0x0f0080600, .val = 0x00000000 },
	{ .addr = 0x0f0080604, .val = 0x00000000 },
	{ .addr = 0x0f0080608, .val = 0x00000000 },
	{ .addr = 0x0f008060c, .val = 0x00000000 },
	{ .addr = 0x0f0080610, .val = 0x00000000 },
	{ .addr = 0x0f0080614, .val = 0x00000000 },
	{ .addr = 0x0f0080618, .val = 0x00000000 },
	{ .addr = 0x0f008061c, .val = 0x00000000 },
	{ .addr = 0x0f0080620, .val = 0x00000000 },
	{ .addr = 0x0f0080624, .val = 0x00000000 },
	{ .addr = 0x0f0080628, .val = 0x00000000 },
	{ .addr = 0x0f008062c, .val = 0x00000000 },
	{ .addr = 0x0f0080630, .val = 0x00000000 },
	{ .addr = 0x0f0080634, .val = 0x00000000 },
	{ .addr = 0x0f0080638, .val = 0x00000000 },
	{ .addr = 0x0f008063c, .val = 0x00000000 },
	{ .addr = 0x0f0080640, .val = 0x00000000 },
	{ .addr = 0x0f0080644, .val = 0x00000000 },
	{ .addr = 0x0f0080648, .val = 0x00000000 },
	{ .addr = 0x0f008064c, .val = 0x00000000 },
	{ .addr = 0x0f0080650, .val = 0x00000000 },
	{ .addr = 0x0f0080654, .val = 0x00000000 },
	{ .addr = 0x0f0080658, .val = 0x00000000 },
	{ .addr = 0x0f008065c, .val = 0x00000000 },
	{ .addr = 0x0f0080660, .val = 0x00000000 },
	{ .addr = 0x0f0080664, .val = 0x00000000 },
	{ .addr = 0x0f0080668, .val = 0x00000000 },
	{ .addr = 0x0f008066c, .val = 0x00000000 },
	{ .addr = 0x0f0080670, .val = 0x00000000 },
	{ .addr = 0x0f0080674, .val = 0x00000000 },
	{ .addr = 0x0f0080678, .val = 0x00000000 },
	{ .addr = 0x0f008067c, .val = 0x00000000 },
	{ .addr = 0x0f0080680, .val = 0x00000000 },
	{ .addr = 0x0f0080684, .val = 0x00000000 },
	{ .addr = 0x0f0080688, .val = 0x00000000 },
	{ .addr = 0x0f008068c, .val = 0x00000000 },
	{ .addr = 0x0f0080690, .val = 0x00000000 },
	{ .addr = 0x0f0080694, .val = 0x00000000 },
	{ .addr = 0x0f0080698, .val = 0x00000000 },
	{ .addr = 0x0f008069c, .val = 0x00000000 },
	{ .addr = 0x0f00806a0, .val = 0x00000000 },
	{ .addr = 0x0f00806a4, .val = 0x00000000 },
	{ .addr = 0x0f00806a8, .val = 0x00000000 },
	{ .addr = 0x0f00806ac, .val = 0x00000000 },
	{ .addr = 0x0f00806b0, .val = 0x00000000 },
	{ .addr = 0x0f00806b4, .val = 0x00000000 },
	{ .addr = 0x0f00806b8, .val = 0x00000000 },
	{ .addr = 0x0f00806bc, .val = 0x00000000 },
	{ .addr = 0x0f00806c0, .val = 0x00000000 },
	{ .addr = 0x0f00806c4, .val = 0x00000000 },
	{ .addr = 0x0f00806c8, .val = 0x00000000 },
	{ .addr = 0x0f00806cc, .val = 0x00000000 },
	{ .addr = 0x0f00806d0, .val = 0x00000000 },
	{ .addr = 0x0f00806d4, .val = 0x00000000 },
	{ .addr = 0x0f00806d8, .val = 0x00000000 },
	{ .addr = 0x0f00806dc, .val = 0x00000000 },
	{ .addr = 0x0f00806e0, .val = 0x00000000 },
	{ .addr = 0x0f00806e4, .val = 0x00000000 },
	{ .addr = 0x0f00806e8, .val = 0x00000000 },
	{ .addr = 0x0f00806ec, .val = 0x00000000 },
	{ .addr = 0x0f00806f0, .val = 0x00000000 },
	{ .addr = 0x0f00806f4, .val = 0x00000000 },
	{ .addr = 0x0f00806f8, .val = 0x00000000 },
	{ .addr = 0x0f00806fc, .val = 0x00000000 },
	{ .addr = 0x0f0080700, .val = 0x00000000 },
	{ .addr = 0x0f0080704, .val = 0x00000000 },
	{ .addr = 0x0f0080708, .val = 0x00000000 },
	{ .addr = 0x0f008070c, .val = 0x00000000 },
	{ .addr = 0x0f0080710, .val = 0x00000000 },
	{ .addr = 0x0f0080714, .val = 0x00000000 },
	{ .addr = 0x0f0080718, .val = 0x00000000 },
	{ .addr = 0x0f008071c, .val = 0x00000000 },
	{ .addr = 0x0f0080720, .val = 0x00000000 },
	{ .addr = 0x0f0080724, .val = 0x00000000 },
	{ .addr = 0x0f0080728, .val = 0x00000000 },
	{ .addr = 0x0f008072c, .val = 0x00000000 },
	{ .addr = 0x0f0080730, .val = 0x00000000 },
	{ .addr = 0x0f0080734, .val = 0x00000000 },
	{ .addr = 0x0f0080738, .val = 0x00000000 },
	{ .addr = 0x0f008073c, .val = 0x00000000 },
	{ .addr = 0x0f0080740, .val = 0x00000000 },
	{ .addr = 0x0f0080744, .val = 0x00000000 },
	{ .addr = 0x0f0080748, .val = 0x00000000 },
	{ .addr = 0x0f008074c, .val = 0x00000000 },
	{ .addr = 0x0f0080750, .val = 0x00000000 },
	{ .addr = 0x0f0080754, .val = 0x00000000 },
	{ .addr = 0x0f0080758, .val = 0x00000000 },
	{ .addr = 0x0f008075c, .val = 0x00000000 },
	{ .addr = 0x0f0080760, .val = 0x00000000 },
	{ .addr = 0x0f0080764, .val = 0x00000000 },
	{ .addr = 0x0f0080768, .val = 0x00000000 },
	{ .addr = 0x0f008076c, .val = 0x00000000 },
	{ .addr = 0x0f0080770, .val = 0x00000000 },
	{ .addr = 0x0f0080774, .val = 0x00000000 },
	{ .addr = 0x0f0080778, .val = 0x00000000 },
	{ .addr = 0x0f008077c, .val = 0x00000000 },
	{ .addr = 0x0f0080780, .val = 0x00000000 },
	{ .addr = 0x0f0080784, .val = 0x00000000 },
	{ .addr = 0x0f0080788, .val = 0x00000000 },
	{ .addr = 0x0f008078c, .val = 0x00000000 },
	{ .addr = 0x0f0080790, .val = 0x00000000 },
	{ .addr = 0x0f0080794, .val = 0x00000000 },
	{ .addr = 0x0f0080798, .val = 0x00000000 },
	{ .addr = 0x0f008079c, .val = 0x00000000 },
	{ .addr = 0x0f00807a0, .val = 0x00000000 },
	{ .addr = 0x0f00807a4, .val = 0x00000000 },
	{ .addr = 0x0f00807a8, .val = 0x00000000 },
	{ .addr = 0x0f00807ac, .val = 0x00000000 },
	{ .addr = 0x0f00807b0, .val = 0x00000000 },
	{ .addr = 0x0f00807b4, .val = 0x00000000 },
	{ .addr = 0x0f00807b8, .val = 0x00000000 },
	{ .addr = 0x0f00807bc, .val = 0x00000000 },
	{ .addr = 0x0f0080800, .val = 0x00000000 },
	{ .addr = 0x0f0080804, .val = 0x00000000 },
	{ .addr = 0x0f0080808, .val = 0x00000000 },
	{ .addr = 0x0f008080c, .val = 0x00000000 },
	{ .addr = 0x0f0080810, .val = 0x00000000 },
	{ .addr = 0x0f0080814, .val = 0x00000000 },
	{ .addr = 0x0f0080818, .val = 0x00000000 },
	{ .addr = 0x0f008081c, .val = 0x00000000 },
	{ .addr = 0x0f0080820, .val = 0x00000000 },
	{ .addr = 0x0f0080824, .val = 0x00000000 },
	{ .addr = 0x0f0080828, .val = 0x00000000 },
	{ .addr = 0x0f008082c, .val = 0x00000000 },
	{ .addr = 0x0f0080830, .val = 0x00000000 },
	{ .addr = 0x0f0080834, .val = 0x00000000 },
	{ .addr = 0x0f0080838, .val = 0x00000000 },
	{ .addr = 0x0f008083c, .val = 0x00000000 },
	{ .addr = 0x0f0080840, .val = 0x00000000 },
	{ .addr = 0x0f0080844, .val = 0x00000000 },
	{ .addr = 0x0f0080848, .val = 0x00000000 },
	{ .addr = 0x0f008084c, .val = 0x00000000 },
	{ .addr = 0x0f0080850, .val = 0x00000000 },
	{ .addr = 0x0f0080854, .val = 0x00000000 },
	{ .addr = 0x0f0080858, .val = 0x00000000 },
	{ .addr = 0x0f008085c, .val = 0x00000000 },
	{ .addr = 0x0f0080860, .val = 0x00000000 },
	{ .addr = 0x0f0080864, .val = 0x00000000 },
	{ .addr = 0x0f0080868, .val = 0x00000000 },
	{ .addr = 0x0f008086c, .val = 0x00000000 },
	{ .addr = 0x0f0080870, .val = 0x00000000 },
	{ .addr = 0x0f0080874, .val = 0x00000000 },
	{ .addr = 0x0f0080878, .val = 0x00000000 },
	{ .addr = 0x0f008087c, .val = 0x00000000 },
	{ .addr = 0x0f0080880, .val = 0x00000000 },
	{ .addr = 0x0f0080884, .val = 0x00000000 },
	{ .addr = 0x0f0080888, .val = 0x00000000 },
	{ .addr = 0x0f008088c, .val = 0x00000000 },
	{ .addr = 0x0f0080890, .val = 0x00000000 },
	{ .addr = 0x0f0080894, .val = 0x00000000 },
	{ .addr = 0x0f0080898, .val = 0x00000000 },
	{ .addr = 0x0f008089c, .val = 0x00000000 },
	{ .addr = 0x0f00808a0, .val = 0x00000000 },
	{ .addr = 0x0f00808a4, .val = 0x00000000 },
	{ .addr = 0x0f00808a8, .val = 0x00000000 },
	{ .addr = 0x0f00808ac, .val = 0x00000000 },
	{ .addr = 0x0f00808b0, .val = 0x00000000 },
	{ .addr = 0x0f00808b4, .val = 0x00000000 },
	{ .addr = 0x0f00808b8, .val = 0x00000000 },
	{ .addr = 0x0f00808bc, .val = 0x00000000 },
	{ .addr = 0x0f00808c0, .val = 0x00000000 },
	{ .addr = 0x0f00808c4, .val = 0x00000000 },
	{ .addr = 0x0f00808c8, .val = 0x00000000 },
	{ .addr = 0x0f00808cc, .val = 0x00000000 },
	{ .addr = 0x0f00808d0, .val = 0x00000000 },
	{ .addr = 0x0f00808d4, .val = 0x00000000 },
	{ .addr = 0x0f00808d8, .val = 0x00000000 },
	{ .addr = 0x0f00808dc, .val = 0x00000000 },
	{ .addr = 0x0f00808e0, .val = 0x00000000 },
	{ .addr = 0x0f00808e4, .val = 0x00000000 },
	{ .addr = 0x0f00808e8, .val = 0x00000000 },
	{ .addr = 0x0f00808ec, .val = 0x00000000 },
	{ .addr = 0x0f00808f0, .val = 0x00000000 },
	{ .addr = 0x0f00808f4, .val = 0x00000000 },
	{ .addr = 0x0f00808f8, .val = 0x00000000 },
	{ .addr = 0x0f00808fc, .val = 0x00000000 },
	{ .addr = 0x0f0080900, .val = 0x00000000 },
	{ .addr = 0x0f0080904, .val = 0x00000000 },
	{ .addr = 0x0f0080908, .val = 0x00000000 },
	{ .addr = 0x0f008090c, .val = 0x00000000 },
	{ .addr = 0x0f0080910, .val = 0x00000000 },
	{ .addr = 0x0f0080914, .val = 0x00000000 },
	{ .addr = 0x0f0080918, .val = 0x00000000 },
	{ .addr = 0x0f008091c, .val = 0x00000000 },
	{ .addr = 0x0f0080920, .val = 0x00000000 },
	{ .addr = 0x0f0080924, .val = 0x00000000 },
	{ .addr = 0x0f0080928, .val = 0x00000000 },
	{ .addr = 0x0f008092c, .val = 0x00000000 },
	{ .addr = 0x0f0080930, .val = 0x00000000 },
	{ .addr = 0x0f0080934, .val = 0x00000000 },
	{ .addr = 0x0f0080938, .val = 0x00000000 },
	{ .addr = 0x0f008093c, .val = 0x00000000 },
	{ .addr = 0x0f0080940, .val = 0x00000000 },
	{ .addr = 0x0f0080944, .val = 0x00000000 },
	{ .addr = 0x0f0080948, .val = 0x00000000 },
	{ .addr = 0x0f008094c, .val = 0x00000000 },
	{ .addr = 0x0f0080950, .val = 0x00000000 },
	{ .addr = 0x0f0080954, .val = 0x00000000 },
	{ .addr = 0x0f0080958, .val = 0x00000000 },
	{ .addr = 0x0f008095c, .val = 0x00000000 },
	{ .addr = 0x0f0080960, .val = 0x00000000 },
	{ .addr = 0x0f0080964, .val = 0x00000000 },
	{ .addr = 0x0f0080968, .val = 0x00000000 },
	{ .addr = 0x0f008096c, .val = 0x00000000 },
	{ .addr = 0x0f0080970, .val = 0x00000000 },
	{ .addr = 0x0f0080974, .val = 0x00000000 },
	{ .addr = 0x0f0080978, .val = 0x00000000 },
	{ .addr = 0x0f008097c, .val = 0x00000000 },
	{ .addr = 0x0f0080980, .val = 0x00000000 },
	{ .addr = 0x0f0080984, .val = 0x00000000 },
	{ .addr = 0x0f0080988, .val = 0x00000000 },
	{ .addr = 0x0f008098c, .val = 0x00000000 },
	{ .addr = 0x0f0080990, .val = 0x00000000 },
	{ .addr = 0x0f0080994, .val = 0x00000000 },
	{ .addr = 0x0f0080998, .val = 0x00000000 },
	{ .addr = 0x0f008099c, .val = 0x00000000 },
	{ .addr = 0x0f00809a0, .val = 0x00000000 },
	{ .addr = 0x0f00809a4, .val = 0x00000000 },
	{ .addr = 0x0f00809a8, .val = 0x00000000 },
	{ .addr = 0x0f00809ac, .val = 0x00000000 },
	{ .addr = 0x0f00809b0, .val = 0x00000000 },
	{ .addr = 0x0f00809b4, .val = 0x00000000 },
	{ .addr = 0x0f00809b8, .val = 0x00000000 },
	{ .addr = 0x0f00809bc, .val = 0x00000000 },
	{ .addr = 0x0f00809c0, .val = 0x00000000 },
	{ .addr = 0x0f00809c4, .val = 0x00000000 },
	{ .addr = 0x0f00809c8, .val = 0x00000000 },
	{ .addr = 0x0f00809cc, .val = 0x00000000 },
	{ .addr = 0x0f00809d0, .val = 0x00000000 },
	{ .addr = 0x0f00809d4, .val = 0x00000000 },
	{ .addr = 0x0f00809d8, .val = 0x00000000 },
	{ .addr = 0x0f00809dc, .val = 0x00000000 },
	{ .addr = 0x0f00809e0, .val = 0x00000000 },
	{ .addr = 0x0f00809e4, .val = 0x00000000 },
	{ .addr = 0x0f00809e8, .val = 0x00000000 },
	{ .addr = 0x0f00809ec, .val = 0x00000000 },
	{ .addr = 0x0f00809f0, .val = 0x00000000 },
	{ .addr = 0x0f00809f4, .val = 0x00000000 },
	{ .addr = 0x0f00809f8, .val = 0x00000000 },
	{ .addr = 0x0f00809fc, .val = 0x00000000 },
	{ .addr = 0x0f0a08400, .val = 0x00000000 },
	{ .addr = 0x0f0a48400, .val = 0x00000000 },
	{ .addr = 0x0f0a88400, .val = 0x00000000 },
	{ .addr = 0x0f0ac8400, .val = 0x00000000 },
	{ .addr = 0x0f0b08000, .val = 0x00000000 },
	{ .addr = 0x0f0b08004, .val = 0x00000000 },
	{ .addr = 0x0f0b08008, .val = 0x00000000 },
	{ .addr = 0x0f0b0800c, .val = 0x00000000 },
	{ .addr = 0x0f0b08010, .val = 0x00000000 },
	{ .addr = 0x0f0b08014, .val = 0x00000000 },
	{ .addr = 0x0f0b08800, .val = 0x00000000 },
	{ .addr = 0x0f0b08804, .val = 0x00000000 },
	{ .addr = 0x0f0b08808, .val = 0x00000000 },
	{ .addr = 0x0f0b0880c, .val = 0x00000000 },
	{ .addr = 0x0f0b08810, .val = 0x00000000 },
	{ .addr = 0x0f0b08814, .val = 0x00000000 },
	{ .addr = 0x0f0b08818, .val = 0x00000000 },
	{ .addr = 0x0f0b0881c, .val = 0x00000000 },
	{ .addr = 0x0f0b08820, .val = 0x00000000 },
	{ .addr = 0x0f0b08824, .val = 0x00000000 },
	{ .addr = 0x0f0b08828, .val = 0x00000000 },
	{ .addr = 0x0f0b0882c, .val = 0x00000000 },
	{ .addr = 0x0f0b08830, .val = 0x00000000 },
	{ .addr = 0x0f0b08834, .val = 0x00000000 },
	{ .addr = 0x0f0b08838, .val = 0x00000000 },
	{ .addr = 0x0f0b0883c, .val = 0x00000000 },
	{ .addr = 0x0f0b09400, .val = 0x00000000 },
	{ .addr = 0x0f0b09800, .val = 0x00000000 },
	{ .addr = 0x0f0b09804, .val = 0x00000000 },
	{ .addr = 0x0f0b09808, .val = 0x00000000 },
	{ .addr = 0x0f0b0980c, .val = 0x00000000 },
	{ .addr = 0x0f0b09810, .val = 0x00000000 },
	{ .addr = 0x0f0b09814, .val = 0x00000000 },
	{ .addr = 0x0f0b09818, .val = 0x00000000 },
	{ .addr = 0x0f0b0981c, .val = 0x00000000 },
	{ .addr = 0x0f0b09820, .val = 0x00000000 },
	{ .addr = 0x0f0b09824, .val = 0x00000000 },
	{ .addr = 0x0f0b09828, .val = 0x00000000 },
	{ .addr = 0x0f0b0982c, .val = 0x00000000 },
	{ .addr = 0x0f0b09830, .val = 0x00000000 },
	{ .addr = 0x0f0b09834, .val = 0x00000000 },
	{ .addr = 0x0f0b09838, .val = 0x00000000 },
	{ .addr = 0x0f0b0983c, .val = 0x00000000 },
	{ .addr = 0x0f0b0a000, .val = 0x00000000 },
	{ .addr = 0x0f0b0a004, .val = 0x00000000 },
	{ .addr = 0x0f0b0a008, .val = 0x00000000 },
	{ .addr = 0x0f0b0a00c, .val = 0x00000000 },
	{ .addr = 0x0f0b0a010, .val = 0x00000000 },
	{ .addr = 0x0f0b0a014, .val = 0x00000000 },
	{ .addr = 0x0f0b0a018, .val = 0x00000000 },
	{ .addr = 0x0f0b0a01c, .val = 0x00000000 },
	{ .addr = 0x0f0b0a020, .val = 0x00000000 },
	{ .addr = 0x0f0b0a024, .val = 0x00000000 },
	{ .addr = 0x0f0b0a028, .val = 0x00000000 },
	{ .addr = 0x0f0b0a02c, .val = 0x00000000 },
	{ .addr = 0x0f0b0a030, .val = 0x00000000 },
	{ .addr = 0x0f0b0a034, .val = 0x00000000 },
	{ .addr = 0x0f0b0a038, .val = 0x00000000 },
	{ .addr = 0x0f0b0a03c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b000, .val = 0x00000000 },
	{ .addr = 0x0f0b0b004, .val = 0x00000000 },
	{ .addr = 0x0f0b0b008, .val = 0x00000000 },
	{ .addr = 0x0f0b0b00c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b010, .val = 0x00000000 },
	{ .addr = 0x0f0b0b014, .val = 0x00000000 },
	{ .addr = 0x0f0b0b018, .val = 0x00000000 },
	{ .addr = 0x0f0b0b01c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b020, .val = 0x00000000 },
	{ .addr = 0x0f0b0b024, .val = 0x00000000 },
	{ .addr = 0x0f0b0b028, .val = 0x00000000 },
	{ .addr = 0x0f0b0b02c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b030, .val = 0x00000000 },
	{ .addr = 0x0f0b0b034, .val = 0x00000000 },
	{ .addr = 0x0f0b0b038, .val = 0x00000000 },
	{ .addr = 0x0f0b0b03c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b040, .val = 0x00000000 },
	{ .addr = 0x0f0b0b044, .val = 0x00000000 },
	{ .addr = 0x0f0b0b048, .val = 0x00000000 },
	{ .addr = 0x0f0b0b04c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b050, .val = 0x00000000 },
	{ .addr = 0x0f0b0b054, .val = 0x00000000 },
	{ .addr = 0x0f0b0b058, .val = 0x00000000 },
	{ .addr = 0x0f0b0b05c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b060, .val = 0x00000000 },
	{ .addr = 0x0f0b0b064, .val = 0x00000000 },
	{ .addr = 0x0f0b0b068, .val = 0x00000000 },
	{ .addr = 0x0f0b0b06c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b070, .val = 0x00000000 },
	{ .addr = 0x0f0b0b074, .val = 0x00000000 },
	{ .addr = 0x0f0b0b078, .val = 0x00000000 },
	{ .addr = 0x0f0b0b07c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b080, .val = 0x00000000 },
	{ .addr = 0x0f0b0b084, .val = 0x00000000 },
	{ .addr = 0x0f0b0b088, .val = 0x00000000 },
	{ .addr = 0x0f0b0b08c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b090, .val = 0x00000000 },
	{ .addr = 0x0f0b0b094, .val = 0x00000000 },
	{ .addr = 0x0f0b0b098, .val = 0x00000000 },
	{ .addr = 0x0f0b0b09c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0a0, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0a4, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0a8, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0ac, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0b0, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0b4, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0b8, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0bc, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0c0, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0c4, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0c8, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0cc, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0d0, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0d4, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0d8, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0dc, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0e0, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0e4, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0e8, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0ec, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0f0, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0f4, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0f8, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0fc, .val = 0x00000000 },
	{ .addr = 0x0f0b0b100, .val = 0x00000000 },
	{ .addr = 0x0f0b0b104, .val = 0x00000000 },
	{ .addr = 0x0f0b0b108, .val = 0x00000000 },
	{ .addr = 0x0f0b0b10c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b110, .val = 0x00000000 },
	{ .addr = 0x0f0b0b114, .val = 0x00000000 },
	{ .addr = 0x0f0b0b118, .val = 0x00000000 },
	{ .addr = 0x0f0b0b11c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b120, .val = 0x00000000 },
	{ .addr = 0x0f0b0b124, .val = 0x00000000 },
	{ .addr = 0x0f0b0b128, .val = 0x00000000 },
	{ .addr = 0x0f0b0b12c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b130, .val = 0x00000000 },
	{ .addr = 0x0f0b0b134, .val = 0x00000000 },
	{ .addr = 0x0f0b0b138, .val = 0x00000000 },
	{ .addr = 0x0f0b0b13c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b140, .val = 0x00000000 },
	{ .addr = 0x0f0b0b144, .val = 0x00000000 },
	{ .addr = 0x0f0b0b148, .val = 0x00000000 },
	{ .addr = 0x0f0b0b14c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b150, .val = 0x00000000 },
	{ .addr = 0x0f0b0b154, .val = 0x00000000 },
	{ .addr = 0x0f0b0b158, .val = 0x00000000 },
	{ .addr = 0x0f0b0b15c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b160, .val = 0x00000000 },
	{ .addr = 0x0f0b0b164, .val = 0x00000000 },
	{ .addr = 0x0f0b0b168, .val = 0x00000000 },
	{ .addr = 0x0f0b0b16c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b170, .val = 0x00000000 },
	{ .addr = 0x0f0b0b174, .val = 0x00000000 },
	{ .addr = 0x0f0b0b178, .val = 0x00000000 },
	{ .addr = 0x0f0b0b17c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b400, .val = 0x00000000 },
	{ .addr = 0x0f0b0b404, .val = 0x00000000 },
	{ .addr = 0x0f0b0b408, .val = 0x00000000 },
	{ .addr = 0x0f0b0b40c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b410, .val = 0x00000000 },
	{ .addr = 0x0f0b0b414, .val = 0x00000000 },
	{ .addr = 0x0f0b0b418, .val = 0x00000000 },
	{ .addr = 0x0f0b0b41c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b420, .val = 0x00000000 },
	{ .addr = 0x0f0b0b424, .val = 0x00000000 },
	{ .addr = 0x0f0b0b428, .val = 0x00000000 },
	{ .addr = 0x0f0b0b42c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b430, .val = 0x00000000 },
	{ .addr = 0x0f0b0b434, .val = 0x00000000 },
	{ .addr = 0x0f0b0b438, .val = 0x00000000 },
	{ .addr = 0x0f0b0b43c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b440, .val = 0x00000000 },
	{ .addr = 0x0f0b0b444, .val = 0x00000000 },
	{ .addr = 0x0f0b0b448, .val = 0x00000000 },
	{ .addr = 0x0f0b0b44c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b450, .val = 0x00000000 },
	{ .addr = 0x0f0b0b454, .val = 0x00000000 },
	{ .addr = 0x0f0b0b458, .val = 0x00000000 },
	{ .addr = 0x0f0b0b45c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b460, .val = 0x00000000 },
	{ .addr = 0x0f0b0b464, .val = 0x00000000 },
	{ .addr = 0x0f0b0b468, .val = 0x00000000 },
	{ .addr = 0x0f0b0b46c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b470, .val = 0x00000000 },
	{ .addr = 0x0f0b0b474, .val = 0x00000000 },
	{ .addr = 0x0f0b0b478, .val = 0x00000000 },
	{ .addr = 0x0f0b0b47c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b480, .val = 0x00000000 },
	{ .addr = 0x0f0b0b484, .val = 0x00000000 },
	{ .addr = 0x0f0b0b488, .val = 0x00000000 },
	{ .addr = 0x0f0b0b48c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b490, .val = 0x00000000 },
	{ .addr = 0x0f0b0b494, .val = 0x00000000 },
	{ .addr = 0x0f0b0b498, .val = 0x00000000 },
	{ .addr = 0x0f0b0b49c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4a0, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4a4, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4a8, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4ac, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4b0, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4b4, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4b8, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4bc, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4c0, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4c4, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4c8, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4cc, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4d0, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4d4, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4d8, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4dc, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4e0, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4e4, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4e8, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4ec, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4f0, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4f4, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4f8, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4fc, .val = 0x00000000 },
	{ .addr = 0x0f0b0b500, .val = 0x00000000 },
	{ .addr = 0x0f0b0b504, .val = 0x00000000 },
	{ .addr = 0x0f0b0b508, .val = 0x00000000 },
	{ .addr = 0x0f0b0b50c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b510, .val = 0x00000000 },
	{ .addr = 0x0f0b0b514, .val = 0x00000000 },
	{ .addr = 0x0f0b0b518, .val = 0x00000000 },
	{ .addr = 0x0f0b0b51c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b520, .val = 0x00000000 },
	{ .addr = 0x0f0b0b524, .val = 0x00000000 },
	{ .addr = 0x0f0b0b528, .val = 0x00000000 },
	{ .addr = 0x0f0b0b52c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b530, .val = 0x00000000 },
	{ .addr = 0x0f0b0b534, .val = 0x00000000 },
	{ .addr = 0x0f0b0b538, .val = 0x00000000 },
	{ .addr = 0x0f0b0b53c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b540, .val = 0x00000000 },
	{ .addr = 0x0f0b0b544, .val = 0x00000000 },
	{ .addr = 0x0f0b0b548, .val = 0x00000000 },
	{ .addr = 0x0f0b0b54c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b550, .val = 0x00000000 },
	{ .addr = 0x0f0b0b554, .val = 0x00000000 },
	{ .addr = 0x0f0b0b558, .val = 0x00000000 },
	{ .addr = 0x0f0b0b55c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b560, .val = 0x00000000 },
	{ .addr = 0x0f0b0b564, .val = 0x00000000 },
	{ .addr = 0x0f0b0b568, .val = 0x00000000 },
	{ .addr = 0x0f0b0b56c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b570, .val = 0x00000000 },
	{ .addr = 0x0f0b0b574, .val = 0x00000000 },
	{ .addr = 0x0f0b0b578, .val = 0x00000000 },
	{ .addr = 0x0f0b0b57c, .val = 0x00000000 },
	{ .addr = 0x0f0b0d000, .val = 0x00000000 },
	{ .addr = 0x0f0b0d004, .val = 0x00000000 },
	{ .addr = 0x0f0b0d008, .val = 0x00000000 },
	{ .addr = 0x0f0b0d00c, .val = 0x00000000 },
	{ .addr = 0x0f0b0d010, .val = 0x00000000 },
	{ .addr = 0x0f0b0d014, .val = 0x00000000 },
	{ .addr = 0x0f0b0d018, .val = 0x00000000 },
	{ .addr = 0x0f0b0d01c, .val = 0x00000000 },
	{ .addr = 0x0f0b0d020, .val = 0x00000000 },
	{ .addr = 0x0f0b0d024, .val = 0x00000000 },
	{ .addr = 0x0f0b0d028, .val = 0x00000000 },
	{ .addr = 0x0f0b0d02c, .val = 0x00000000 },
	{ .addr = 0x0f0b0d030, .val = 0x00000000 },
	{ .addr = 0x0f0b0d034, .val = 0x00000000 },
	{ .addr = 0x0f0b0d038, .val = 0x00000000 },
	{ .addr = 0x0f0b0d03c, .val = 0x00000000 },
	{ .addr = 0x0f0b0dc00, .val = 0x00000000 },
	{ .addr = 0x0f0b0dc04, .val = 0x00000000 },
	{ .addr = 0x0f0b0dc08, .val = 0x00000000 },
	{ .addr = 0x0f0b0dc0c, .val = 0x00000000 },
	{ .addr = 0x0f0b0dc10, .val = 0x00000000 },
	{ .addr = 0x0f0b0dc14, .val = 0x00000000 },
	{ .addr = 0x0f0b0dc18, .val = 0x00000000 },
	{ .addr = 0x0f0b0dc1c, .val = 0x00000000 },
	{ .addr = 0x0f0b0e000, .val = 0x00000000 },
	{ .addr = 0x0f0b0e004, .val = 0x00000000 },
	{ .addr = 0x0f0b0e008, .val = 0x00000000 },
	{ .addr = 0x0f0b0e00c, .val = 0x00000000 },
	{ .addr = 0x0f0b0e010, .val = 0x00000000 },
	{ .addr = 0x0f0b0e014, .val = 0x00000000 },
	{ .addr = 0x0f0b0e018, .val = 0x00000000 },
	{ .addr = 0x0f0b0e01c, .val = 0x00000000 },
	{ .addr = 0x0f0b0e400, .val = 0x00000000 },
	{ .addr = 0x0f0b0e404, .val = 0x00000000 },
	{ .addr = 0x0f0b0e408, .val = 0x00000000 },
	{ .addr = 0x0f0b0e40c, .val = 0x00000000 },
	{ .addr = 0x0f0b0e410, .val = 0x00000000 },
	{ .addr = 0x0f0b0e414, .val = 0x00000000 },
	{ .addr = 0x0f0b0e418, .val = 0x00000000 },
	{ .addr = 0x0f0b0e41c, .val = 0x00000000 },
	{ .addr = 0x0f0b0e800, .val = 0x00000000 },
	{ .addr = 0x0f0b0e804, .val = 0x00000000 },
	{ .addr = 0x0f0b0e808, .val = 0x00000000 },
	{ .addr = 0x0f0b0e80c, .val = 0x00000000 },
	{ .addr = 0x0f0b0e810, .val = 0x00000000 },
	{ .addr = 0x0f0b0e814, .val = 0x00000000 },
	{ .addr = 0x0f0b0e818, .val = 0x00000000 },
	{ .addr = 0x0f0b0e81c, .val = 0x00000000 },
	{ .addr = 0x0f0b0fc00, .val = 0x00000000 },
	{ .addr = 0x0f0b0fc04, .val = 0x00000000 },
	{ .addr = 0x0f0b0fc08, .val = 0x00000000 },
	{ .addr = 0x0f0b0fc0c, .val = 0x00000000 },
	{ .addr = 0x0f0b0fc10, .val = 0x00000000 },
	{ .addr = 0x0f0b0fc14, .val = 0x00000000 },
	{ .addr = 0x0f0b0fc18, .val = 0x00000000 },
	{ .addr = 0x0f0b0fc1c, .val = 0x00000000 },
	{ .addr = 0x0f0b10000, .val = 0x00000000 },
	{ .addr = 0x0f0b10400, .val = 0x00000000 },
	{ .addr = 0x0f0b10800, .val = 0x00000000 },
	{ .addr = 0x0f0b10c00, .val = 0x00000000 },
	{ .addr = 0x0f0b11000, .val = 0x00000000 },
	{ .addr = 0x0f0b11800, .val = 0x00000000 },
	{ .addr = 0x0f0b12000, .val = 0x00000000 },
	{ .addr = 0x0f0b12400, .val = 0x00000000 },
	{ .addr = 0x0f0b12800, .val = 0x00000000 },
	{ .addr = 0x0f0b12c00, .val = 0x00000000 },
	{ .addr = 0x0f0b13000, .val = 0x00000000 },
	{ .addr = 0x0f0b13004, .val = 0x00000000 },
	{ .addr = 0x0f0b13008, .val = 0x00000000 },
	{ .addr = 0x0f0b1300c, .val = 0x00000000 },
	{ .addr = 0x0f0b13010, .val = 0x00000000 },
	{ .addr = 0x0f0b13014, .val = 0x00000000 },
	{ .addr = 0x0f0b13018, .val = 0x00000000 },
	{ .addr = 0x0f0b1301c, .val = 0x00000000 },
	{ .addr = 0x0f0b13020, .val = 0x00000000 },
	{ .addr = 0x0f0b13024, .val = 0x00000000 },
	{ .addr = 0x0f0b13028, .val = 0x00000000 },
	{ .addr = 0x0f0b1302c, .val = 0x00000000 },
	{ .addr = 0x0f0b13030, .val = 0x00000000 },
	{ .addr = 0x0f0b13034, .val = 0x00000000 },
	{ .addr = 0x0f0b13038, .val = 0x00000000 },
	{ .addr = 0x0f0b1303c, .val = 0x00000000 },
	{ .addr = 0x0f0b13400, .val = 0x00000000 },
	{ .addr = 0x0f0b13404, .val = 0x00000000 },
	{ .addr = 0x0f0b13408, .val = 0x00000000 },
	{ .addr = 0x0f0b1340c, .val = 0x00000000 },
	{ .addr = 0x0f0b13410, .val = 0x00000000 },
	{ .addr = 0x0f0b13414, .val = 0x00000000 },
	{ .addr = 0x0f0b13418, .val = 0x00000000 },
	{ .addr = 0x0f0b1341c, .val = 0x00000000 },
	{ .addr = 0x0f0b13420, .val = 0x00000000 },
	{ .addr = 0x0f0b13424, .val = 0x00000000 },
	{ .addr = 0x0f0b13428, .val = 0x00000000 },
	{ .addr = 0x0f0b1342c, .val = 0x00000000 },
	{ .addr = 0x0f0b13430, .val = 0x00000000 },
	{ .addr = 0x0f0b13434, .val = 0x00000000 },
	{ .addr = 0x0f0b13438, .val = 0x00000000 },
	{ .addr = 0x0f0b1343c, .val = 0x00000000 },
	{ .addr = 0x0f0b13440, .val = 0x00000000 },
	{ .addr = 0x0f0b13444, .val = 0x00000000 },
	{ .addr = 0x0f0b13448, .val = 0x00000000 },
	{ .addr = 0x0f0b1344c, .val = 0x00000000 },
	{ .addr = 0x0f0b13450, .val = 0x00000000 },
	{ .addr = 0x0f0b13454, .val = 0x00000000 },
	{ .addr = 0x0f0b13458, .val = 0x00000000 },
	{ .addr = 0x0f0b1345c, .val = 0x00000000 },
	{ .addr = 0x0f0b13460, .val = 0x00000000 },
	{ .addr = 0x0f0b13464, .val = 0x00000000 },
	{ .addr = 0x0f0b13468, .val = 0x00000000 },
	{ .addr = 0x0f0b1346c, .val = 0x00000000 },
	{ .addr = 0x0f0b13470, .val = 0x00000000 },
	{ .addr = 0x0f0b13474, .val = 0x00000000 },
	{ .addr = 0x0f0b13478, .val = 0x00000000 },
	{ .addr = 0x0f0b1347c, .val = 0x00000000 },
	{ .addr = 0x0f0b16400, .val = 0x00000000 },
	{ .addr = 0x0f0b17000, .val = 0x00000000 },
	{ .addr = 0x0f0b18000, .val = 0x00000000 },
	{ .addr = 0x0f0b18400, .val = 0x00000000 },
	{ .addr = 0x0f0b18800, .val = 0x00000000 },
	{ .addr = 0x0f0b19400, .val = 0x00000000 },
	{ .addr = 0x0f0b19404, .val = 0x00000000 },
	{ .addr = 0x0f0b19408, .val = 0x00000000 },
	{ .addr = 0x0f0b1940c, .val = 0x00000000 },
	{ .addr = 0x0f0b19410, .val = 0x00000000 },
	{ .addr = 0x0f0b19414, .val = 0x00000000 },
	{ .addr = 0x0f0b19418, .val = 0x00000000 },
	{ .addr = 0x0f0b1941c, .val = 0x00000000 },
	{ .addr = 0x0f0b20800, .val = 0x00000000 },
	{ .addr = 0x0f0b20c00, .val = 0x00000000 },
	{ .addr = 0x0f0b21000, .val = 0x00000004 },
	{ .addr = 0x0f0b22400, .val = 0x00000000 },
	{ .addr = 0x0f0b23000, .val = 0x00000000 },
	{ .addr = 0x0f0b23004, .val = 0x00000000 },
	{ .addr = 0x0f0b23008, .val = 0x00000000 },
	{ .addr = 0x0f0b2300c, .val = 0x00000000 },
	{ .addr = 0x0f0b23400, .val = 0x00000000 },
	{ .addr = 0x0f0b23404, .val = 0x00000000 },
	{ .addr = 0x0f0b23408, .val = 0x00000000 },
	{ .addr = 0x0f0b2340c, .val = 0x00000000 },
	{ .addr = 0x0f0b23800, .val = 0x00000000 },
	{ .addr = 0x0f0b23804, .val = 0x00000000 },
	{ .addr = 0x0f0b23808, .val = 0x00000000 },
	{ .addr = 0x0f0b2380c, .val = 0x00000000 },
	{ .addr = 0x0f0b28000, .val = 0x00000000 },
	{ .addr = 0x0f0b28c00, .val = 0x00000000 },
	{ .addr = 0x0f0b29000, .val = 0x00000000 },
	{ .addr = 0x0f0b29400, .val = 0x00000000 },
	{ .addr = 0x0f0b29404, .val = 0x00000000 },
	{ .addr = 0x0f0b29408, .val = 0x00000000 },
	{ .addr = 0x0f0b2940c, .val = 0x00000000 },
	{ .addr = 0x0f0b29410, .val = 0x00000000 },
	{ .addr = 0x0f0b29414, .val = 0x00000000 },
	{ .addr = 0x0f0b29418, .val = 0x00000000 },
	{ .addr = 0x0f0b2941c, .val = 0x00000000 },
	{ .addr = 0x0f0b29420, .val = 0x00000000 },
	{ .addr = 0x0f0b29424, .val = 0x00000000 },
	{ .addr = 0x0f0b29428, .val = 0x00000000 },
	{ .addr = 0x0f0b2942c, .val = 0x00000000 },
	{ .addr = 0x0f0b29430, .val = 0x00000000 },
	{ .addr = 0x0f0b29434, .val = 0x00000000 },
	{ .addr = 0x0f0b29438, .val = 0x00000000 },
	{ .addr = 0x0f0b2943c, .val = 0x00000000 },
	{ .addr = 0x0f0b30800, .val = 0x00000000 },
	{ .addr = 0x0f0b30c00, .val = 0x00000000 },
	{ .addr = 0x0f0b31400, .val = 0x00000000 },
	{ .addr = 0x0f0b31404, .val = 0x00000000 },
	{ .addr = 0x0f0b31408, .val = 0x00000000 },
	{ .addr = 0x0f0b3140c, .val = 0x00000000 },
	{ .addr = 0x0f0b31410, .val = 0x00000000 },
	{ .addr = 0x0f0b31414, .val = 0x00000000 },
	{ .addr = 0x0f0b31418, .val = 0x00000000 },
	{ .addr = 0x0f0b3141c, .val = 0x00000000 },
	{ .addr = 0x0f0b31420, .val = 0x00000000 },
	{ .addr = 0x0f0b31424, .val = 0x00000000 },
	{ .addr = 0x0f0b31428, .val = 0x00000000 },
	{ .addr = 0x0f0b3142c, .val = 0x00000000 },
	{ .addr = 0x0f0b31430, .val = 0x00000000 },
	{ .addr = 0x0f0b31434, .val = 0x00000000 },
	{ .addr = 0x0f0b31438, .val = 0x00000000 },
	{ .addr = 0x0f0b3143c, .val = 0x00000000 },
	{ .addr = 0x0f0b31440, .val = 0x00000000 },
	{ .addr = 0x0f0b31444, .val = 0x00000000 },
	{ .addr = 0x0f0b31448, .val = 0x00000000 },
	{ .addr = 0x0f0b3144c, .val = 0x00000000 },
	{ .addr = 0x0f0b31450, .val = 0x00000000 },
	{ .addr = 0x0f0b31454, .val = 0x00000000 },
	{ .addr = 0x0f0b31458, .val = 0x00000000 },
	{ .addr = 0x0f0b3145c, .val = 0x00000000 },
	{ .addr = 0x0f0b31460, .val = 0x00000000 },
	{ .addr = 0x0f0b31464, .val = 0x00000000 },
	{ .addr = 0x0f0b31468, .val = 0x00000000 },
	{ .addr = 0x0f0b3146c, .val = 0x00000000 },
	{ .addr = 0x0f0b31470, .val = 0x00000000 },
	{ .addr = 0x0f0b31474, .val = 0x00000000 },
	{ .addr = 0x0f0b31478, .val = 0x00000000 },
	{ .addr = 0x0f0b3147c, .val = 0x00000000 },
	{ .addr = 0x0f0b31480, .val = 0x00000000 },
	{ .addr = 0x0f0b31484, .val = 0x00000000 },
	{ .addr = 0x0f0b31488, .val = 0x00000000 },
	{ .addr = 0x0f0b3148c, .val = 0x00000000 },
	{ .addr = 0x0f0b31490, .val = 0x00000000 },
	{ .addr = 0x0f0b31494, .val = 0x00000000 },
	{ .addr = 0x0f0b31498, .val = 0x00000000 },
	{ .addr = 0x0f0b3149c, .val = 0x00000000 },
	{ .addr = 0x0f0b314a0, .val = 0x00000000 },
	{ .addr = 0x0f0b314a4, .val = 0x00000000 },
	{ .addr = 0x0f0b314a8, .val = 0x00000000 },
	{ .addr = 0x0f0b314ac, .val = 0x00000000 },
	{ .addr = 0x0f0b314b0, .val = 0x00000000 },
	{ .addr = 0x0f0b314b4, .val = 0x00000000 },
	{ .addr = 0x0f0b314b8, .val = 0x00000000 },
	{ .addr = 0x0f0b314bc, .val = 0x00000000 },
	{ .addr = 0x0f0b314c0, .val = 0x00000000 },
	{ .addr = 0x0f0b314c4, .val = 0x00000000 },
	{ .addr = 0x0f0b314c8, .val = 0x00000000 },
	{ .addr = 0x0f0b314cc, .val = 0x00000000 },
	{ .addr = 0x0f0b314d0, .val = 0x00000000 },
	{ .addr = 0x0f0b314d4, .val = 0x00000000 },
	{ .addr = 0x0f0b314d8, .val = 0x00000000 },
	{ .addr = 0x0f0b314dc, .val = 0x00000000 },
	{ .addr = 0x0f0b314e0, .val = 0x00000000 },
	{ .addr = 0x0f0b314e4, .val = 0x00000000 },
	{ .addr = 0x0f0b314e8, .val = 0x00000000 },
	{ .addr = 0x0f0b314ec, .val = 0x00000000 },
	{ .addr = 0x0f0b314f0, .val = 0x00000000 },
	{ .addr = 0x0f0b314f4, .val = 0x00000000 },
	{ .addr = 0x0f0b314f8, .val = 0x00000000 },
	{ .addr = 0x0f0b314fc, .val = 0x00000000 },
	{ .addr = 0x0f0b31800, .val = 0x00000000 },
	{ .addr = 0x0f0b31804, .val = 0x00000000 },
	{ .addr = 0x0f0b31808, .val = 0x00000000 },
	{ .addr = 0x0f0b3180c, .val = 0x00000000 },
	{ .addr = 0x0f0b31810, .val = 0x00000000 },
	{ .addr = 0x0f0b31814, .val = 0x00000000 },
	{ .addr = 0x0f0b31818, .val = 0x00000000 },
	{ .addr = 0x0f0b3181c, .val = 0x00000000 },
	{ .addr = 0x0f0b31820, .val = 0x00000000 },
	{ .addr = 0x0f0b31824, .val = 0x00000000 },
	{ .addr = 0x0f0b31828, .val = 0x00000000 },
	{ .addr = 0x0f0b3182c, .val = 0x00000000 },
	{ .addr = 0x0f0b31830, .val = 0x00000000 },
	{ .addr = 0x0f0b31834, .val = 0x00000000 },
	{ .addr = 0x0f0b31838, .val = 0x00000000 },
	{ .addr = 0x0f0b3183c, .val = 0x00000000 },
	{ .addr = 0x0f0b31840, .val = 0x00000000 },
	{ .addr = 0x0f0b31844, .val = 0x00000000 },
	{ .addr = 0x0f0b31848, .val = 0x00000000 },
	{ .addr = 0x0f0b3184c, .val = 0x00000000 },
	{ .addr = 0x0f0b31850, .val = 0x00000000 },
	{ .addr = 0x0f0b31854, .val = 0x00000000 },
	{ .addr = 0x0f0b31858, .val = 0x00000000 },
	{ .addr = 0x0f0b3185c, .val = 0x00000000 },
	{ .addr = 0x0f0b31860, .val = 0x00000000 },
	{ .addr = 0x0f0b31864, .val = 0x00000000 },
	{ .addr = 0x0f0b31868, .val = 0x00000000 },
	{ .addr = 0x0f0b3186c, .val = 0x00000000 },
	{ .addr = 0x0f0b31870, .val = 0x00000000 },
	{ .addr = 0x0f0b31874, .val = 0x00000000 },
	{ .addr = 0x0f0b31878, .val = 0x00000000 },
	{ .addr = 0x0f0b3187c, .val = 0x00000000 },
	{ .addr = 0x0f0b31880, .val = 0x00000000 },
	{ .addr = 0x0f0b31884, .val = 0x00000000 },
	{ .addr = 0x0f0b31888, .val = 0x00000000 },
	{ .addr = 0x0f0b3188c, .val = 0x00000000 },
	{ .addr = 0x0f0b31890, .val = 0x00000000 },
	{ .addr = 0x0f0b31894, .val = 0x00000000 },
	{ .addr = 0x0f0b31898, .val = 0x00000000 },
	{ .addr = 0x0f0b3189c, .val = 0x00000000 },
	{ .addr = 0x0f0b318a0, .val = 0x00000000 },
	{ .addr = 0x0f0b318a4, .val = 0x00000000 },
	{ .addr = 0x0f0b318a8, .val = 0x00000000 },
	{ .addr = 0x0f0b318ac, .val = 0x00000000 },
	{ .addr = 0x0f0b318b0, .val = 0x00000000 },
	{ .addr = 0x0f0b318b4, .val = 0x00000000 },
	{ .addr = 0x0f0b318b8, .val = 0x00000000 },
	{ .addr = 0x0f0b318bc, .val = 0x00000000 },
	{ .addr = 0x0f0b318c0, .val = 0x00000000 },
	{ .addr = 0x0f0b318c4, .val = 0x00000000 },
	{ .addr = 0x0f0b318c8, .val = 0x00000000 },
	{ .addr = 0x0f0b318cc, .val = 0x00000000 },
	{ .addr = 0x0f0b318d0, .val = 0x00000000 },
	{ .addr = 0x0f0b318d4, .val = 0x00000000 },
	{ .addr = 0x0f0b318d8, .val = 0x00000000 },
	{ .addr = 0x0f0b318dc, .val = 0x00000000 },
	{ .addr = 0x0f0b318e0, .val = 0x00000000 },
	{ .addr = 0x0f0b318e4, .val = 0x00000000 },
	{ .addr = 0x0f0b318e8, .val = 0x00000000 },
	{ .addr = 0x0f0b318ec, .val = 0x00000000 },
	{ .addr = 0x0f0b318f0, .val = 0x00000000 },
	{ .addr = 0x0f0b318f4, .val = 0x00000000 },
	{ .addr = 0x0f0b318f8, .val = 0x00000000 },
	{ .addr = 0x0f0b318fc, .val = 0x00000000 },
	{ .addr = 0x0f0b31c00, .val = 0x00000000 },
	{ .addr = 0x0f0b31c04, .val = 0x00000000 },
	{ .addr = 0x0f0b31c08, .val = 0x00000000 },
	{ .addr = 0x0f0b31c0c, .val = 0x00000000 },
	{ .addr = 0x0f0b31c10, .val = 0x00000000 },
	{ .addr = 0x0f0b31c14, .val = 0x00000000 },
	{ .addr = 0x0f0b31c18, .val = 0x00000000 },
	{ .addr = 0x0f0b31c1c, .val = 0x00000000 },
	{ .addr = 0x0f0b31c20, .val = 0x00000000 },
	{ .addr = 0x0f0b31c24, .val = 0x00000000 },
	{ .addr = 0x0f0b31c28, .val = 0x00000000 },
	{ .addr = 0x0f0b31c2c, .val = 0x00000000 },
	{ .addr = 0x0f0b31c30, .val = 0x00000000 },
	{ .addr = 0x0f0b31c34, .val = 0x00000000 },
	{ .addr = 0x0f0b31c38, .val = 0x00000000 },
	{ .addr = 0x0f0b31c3c, .val = 0x00000000 },
	{ .addr = 0x0f0b31c40, .val = 0x00000000 },
	{ .addr = 0x0f0b31c44, .val = 0x00000000 },
	{ .addr = 0x0f0b31c48, .val = 0x00000000 },
	{ .addr = 0x0f0b31c4c, .val = 0x00000000 },
	{ .addr = 0x0f0b31c50, .val = 0x00000000 },
	{ .addr = 0x0f0b31c54, .val = 0x00000000 },
	{ .addr = 0x0f0b31c58, .val = 0x00000000 },
	{ .addr = 0x0f0b31c5c, .val = 0x00000000 },
	{ .addr = 0x0f0b31c60, .val = 0x00000000 },
	{ .addr = 0x0f0b31c64, .val = 0x00000000 },
	{ .addr = 0x0f0b31c68, .val = 0x00000000 },
	{ .addr = 0x0f0b31c6c, .val = 0x00000000 },
	{ .addr = 0x0f0b31c70, .val = 0x00000000 },
	{ .addr = 0x0f0b31c74, .val = 0x00000000 },
	{ .addr = 0x0f0b31c78, .val = 0x00000000 },
	{ .addr = 0x0f0b31c7c, .val = 0x00000000 },
	{ .addr = 0x0f0b38800, .val = 0x00000000 },
	{ .addr = 0x0f0b39000, .val = 0x00000000 },
	{ .addr = 0x0f0b39400, .val = 0x00000000 },
	{ .addr = 0x0f0b39404, .val = 0x00000000 },
	{ .addr = 0x0f0b39408, .val = 0x00000000 },
	{ .addr = 0x0f0b3940c, .val = 0x00000000 },
	{ .addr = 0x0f0b40000, .val = 0x00000000 },
	{ .addr = 0x0f0b40400, .val = 0x00000000 },
	{ .addr = 0x0f0b40800, .val = 0x00000000 },
	{ .addr = 0x0f0b40c00, .val = 0x00000000 },
	{ .addr = 0x0f0608400, .val = 0x00000000 },
	{ .addr = 0x0f0648400, .val = 0x00000000 },
	{ .addr = 0x0f0688400, .val = 0x00000000 },
	{ .addr = 0x0f06c8400, .val = 0x00000000 },
	{ .addr = 0x0f0708000, .val = 0x00000000 },
	{ .addr = 0x0f0708004, .val = 0x00000000 },
	{ .addr = 0x0f0708008, .val = 0x00000000 },
	{ .addr = 0x0f070800c, .val = 0x00000000 },
	{ .addr = 0x0f0708010, .val = 0x00000000 },
	{ .addr = 0x0f0708014, .val = 0x00000000 },
	{ .addr = 0x0f0708800, .val = 0x00000000 },
	{ .addr = 0x0f0708804, .val = 0x00000000 },
	{ .addr = 0x0f0708808, .val = 0x00000000 },
	{ .addr = 0x0f070880c, .val = 0x00000000 },
	{ .addr = 0x0f0708810, .val = 0x00000000 },
	{ .addr = 0x0f0708814, .val = 0x00000000 },
	{ .addr = 0x0f0708818, .val = 0x00000000 },
	{ .addr = 0x0f070881c, .val = 0x00000000 },
	{ .addr = 0x0f0708820, .val = 0x00000000 },
	{ .addr = 0x0f0708824, .val = 0x00000000 },
	{ .addr = 0x0f0708828, .val = 0x00000000 },
	{ .addr = 0x0f070882c, .val = 0x00000000 },
	{ .addr = 0x0f0708830, .val = 0x00000000 },
	{ .addr = 0x0f0708834, .val = 0x00000000 },
	{ .addr = 0x0f0708838, .val = 0x00000000 },
	{ .addr = 0x0f070883c, .val = 0x00000000 },
	{ .addr = 0x0f0709400, .val = 0x00000000 },
	{ .addr = 0x0f0709800, .val = 0x00000000 },
	{ .addr = 0x0f0709804, .val = 0x00000000 },
	{ .addr = 0x0f0709808, .val = 0x00000000 },
	{ .addr = 0x0f070980c, .val = 0x00000000 },
	{ .addr = 0x0f0709810, .val = 0x00000000 },
	{ .addr = 0x0f0709814, .val = 0x00000000 },
	{ .addr = 0x0f0709818, .val = 0x00000000 },
	{ .addr = 0x0f070981c, .val = 0x00000000 },
	{ .addr = 0x0f0709820, .val = 0x00000000 },
	{ .addr = 0x0f0709824, .val = 0x00000000 },
	{ .addr = 0x0f0709828, .val = 0x00000000 },
	{ .addr = 0x0f070982c, .val = 0x00000000 },
	{ .addr = 0x0f0709830, .val = 0x00000000 },
	{ .addr = 0x0f0709834, .val = 0x00000000 },
	{ .addr = 0x0f0709838, .val = 0x00000000 },
	{ .addr = 0x0f070983c, .val = 0x00000000 },
	{ .addr = 0x0f070a000, .val = 0x00000000 },
	{ .addr = 0x0f070a004, .val = 0x00000000 },
	{ .addr = 0x0f070a008, .val = 0x00000000 },
	{ .addr = 0x0f070a00c, .val = 0x00000000 },
	{ .addr = 0x0f070a010, .val = 0x00000000 },
	{ .addr = 0x0f070a014, .val = 0x00000000 },
	{ .addr = 0x0f070a018, .val = 0x00000000 },
	{ .addr = 0x0f070a01c, .val = 0x00000000 },
	{ .addr = 0x0f070a020, .val = 0x00000000 },
	{ .addr = 0x0f070a024, .val = 0x00000000 },
	{ .addr = 0x0f070a028, .val = 0x00000000 },
	{ .addr = 0x0f070a02c, .val = 0x00000000 },
	{ .addr = 0x0f070a030, .val = 0x00000000 },
	{ .addr = 0x0f070a034, .val = 0x00000000 },
	{ .addr = 0x0f070a038, .val = 0x00000000 },
	{ .addr = 0x0f070a03c, .val = 0x00000000 },
	{ .addr = 0x0f070b000, .val = 0x00000000 },
	{ .addr = 0x0f070b004, .val = 0x00000000 },
	{ .addr = 0x0f070b008, .val = 0x00000000 },
	{ .addr = 0x0f070b00c, .val = 0x00000000 },
	{ .addr = 0x0f070b010, .val = 0x00000000 },
	{ .addr = 0x0f070b014, .val = 0x00000000 },
	{ .addr = 0x0f070b018, .val = 0x00000000 },
	{ .addr = 0x0f070b01c, .val = 0x00000000 },
	{ .addr = 0x0f070b020, .val = 0x00000000 },
	{ .addr = 0x0f070b024, .val = 0x00000000 },
	{ .addr = 0x0f070b028, .val = 0x00000000 },
	{ .addr = 0x0f070b02c, .val = 0x00000000 },
	{ .addr = 0x0f070b030, .val = 0x00000000 },
	{ .addr = 0x0f070b034, .val = 0x00000000 },
	{ .addr = 0x0f070b038, .val = 0x00000000 },
	{ .addr = 0x0f070b03c, .val = 0x00000000 },
	{ .addr = 0x0f070b040, .val = 0x00000000 },
	{ .addr = 0x0f070b044, .val = 0x00000000 },
	{ .addr = 0x0f070b048, .val = 0x00000000 },
	{ .addr = 0x0f070b04c, .val = 0x00000000 },
	{ .addr = 0x0f070b050, .val = 0x00000000 },
	{ .addr = 0x0f070b054, .val = 0x00000000 },
	{ .addr = 0x0f070b058, .val = 0x00000000 },
	{ .addr = 0x0f070b05c, .val = 0x00000000 },
	{ .addr = 0x0f070b060, .val = 0x00000000 },
	{ .addr = 0x0f070b064, .val = 0x00000000 },
	{ .addr = 0x0f070b068, .val = 0x00000000 },
	{ .addr = 0x0f070b06c, .val = 0x00000000 },
	{ .addr = 0x0f070b070, .val = 0x00000000 },
	{ .addr = 0x0f070b074, .val = 0x00000000 },
	{ .addr = 0x0f070b078, .val = 0x00000000 },
	{ .addr = 0x0f070b07c, .val = 0x00000000 },
	{ .addr = 0x0f070b080, .val = 0x00000000 },
	{ .addr = 0x0f070b084, .val = 0x00000000 },
	{ .addr = 0x0f070b088, .val = 0x00000000 },
	{ .addr = 0x0f070b08c, .val = 0x00000000 },
	{ .addr = 0x0f070b090, .val = 0x00000000 },
	{ .addr = 0x0f070b094, .val = 0x00000000 },
	{ .addr = 0x0f070b098, .val = 0x00000000 },
	{ .addr = 0x0f070b09c, .val = 0x00000000 },
	{ .addr = 0x0f070b0a0, .val = 0x00000000 },
	{ .addr = 0x0f070b0a4, .val = 0x00000000 },
	{ .addr = 0x0f070b0a8, .val = 0x00000000 },
	{ .addr = 0x0f070b0ac, .val = 0x00000000 },
	{ .addr = 0x0f070b0b0, .val = 0x00000000 },
	{ .addr = 0x0f070b0b4, .val = 0x00000000 },
	{ .addr = 0x0f070b0b8, .val = 0x00000000 },
	{ .addr = 0x0f070b0bc, .val = 0x00000000 },
	{ .addr = 0x0f070b0c0, .val = 0x00000000 },
	{ .addr = 0x0f070b0c4, .val = 0x00000000 },
	{ .addr = 0x0f070b0c8, .val = 0x00000000 },
	{ .addr = 0x0f070b0cc, .val = 0x00000000 },
	{ .addr = 0x0f070b0d0, .val = 0x00000000 },
	{ .addr = 0x0f070b0d4, .val = 0x00000000 },
	{ .addr = 0x0f070b0d8, .val = 0x00000000 },
	{ .addr = 0x0f070b0dc, .val = 0x00000000 },
	{ .addr = 0x0f070b0e0, .val = 0x00000000 },
	{ .addr = 0x0f070b0e4, .val = 0x00000000 },
	{ .addr = 0x0f070b0e8, .val = 0x00000000 },
	{ .addr = 0x0f070b0ec, .val = 0x00000000 },
	{ .addr = 0x0f070b0f0, .val = 0x00000000 },
	{ .addr = 0x0f070b0f4, .val = 0x00000000 },
	{ .addr = 0x0f070b0f8, .val = 0x00000000 },
	{ .addr = 0x0f070b0fc, .val = 0x00000000 },
	{ .addr = 0x0f070b100, .val = 0x00000000 },
	{ .addr = 0x0f070b104, .val = 0x00000000 },
	{ .addr = 0x0f070b108, .val = 0x00000000 },
	{ .addr = 0x0f070b10c, .val = 0x00000000 },
	{ .addr = 0x0f070b110, .val = 0x00000000 },
	{ .addr = 0x0f070b114, .val = 0x00000000 },
	{ .addr = 0x0f070b118, .val = 0x00000000 },
	{ .addr = 0x0f070b11c, .val = 0x00000000 },
	{ .addr = 0x0f070b120, .val = 0x00000000 },
	{ .addr = 0x0f070b124, .val = 0x00000000 },
	{ .addr = 0x0f070b128, .val = 0x00000000 },
	{ .addr = 0x0f070b12c, .val = 0x00000000 },
	{ .addr = 0x0f070b130, .val = 0x00000000 },
	{ .addr = 0x0f070b134, .val = 0x00000000 },
	{ .addr = 0x0f070b138, .val = 0x00000000 },
	{ .addr = 0x0f070b13c, .val = 0x00000000 },
	{ .addr = 0x0f070b140, .val = 0x00000000 },
	{ .addr = 0x0f070b144, .val = 0x00000000 },
	{ .addr = 0x0f070b148, .val = 0x00000000 },
	{ .addr = 0x0f070b14c, .val = 0x00000000 },
	{ .addr = 0x0f070b150, .val = 0x00000000 },
	{ .addr = 0x0f070b154, .val = 0x00000000 },
	{ .addr = 0x0f070b158, .val = 0x00000000 },
	{ .addr = 0x0f070b15c, .val = 0x00000000 },
	{ .addr = 0x0f070b160, .val = 0x00000000 },
	{ .addr = 0x0f070b164, .val = 0x00000000 },
	{ .addr = 0x0f070b168, .val = 0x00000000 },
	{ .addr = 0x0f070b16c, .val = 0x00000000 },
	{ .addr = 0x0f070b170, .val = 0x00000000 },
	{ .addr = 0x0f070b174, .val = 0x00000000 },
	{ .addr = 0x0f070b178, .val = 0x00000000 },
	{ .addr = 0x0f070b17c, .val = 0x00000000 },
	{ .addr = 0x0f070b400, .val = 0x00000000 },
	{ .addr = 0x0f070b404, .val = 0x00000000 },
	{ .addr = 0x0f070b408, .val = 0x00000000 },
	{ .addr = 0x0f070b40c, .val = 0x00000000 },
	{ .addr = 0x0f070b410, .val = 0x00000000 },
	{ .addr = 0x0f070b414, .val = 0x00000000 },
	{ .addr = 0x0f070b418, .val = 0x00000000 },
	{ .addr = 0x0f070b41c, .val = 0x00000000 },
	{ .addr = 0x0f070b420, .val = 0x00000000 },
	{ .addr = 0x0f070b424, .val = 0x00000000 },
	{ .addr = 0x0f070b428, .val = 0x00000000 },
	{ .addr = 0x0f070b42c, .val = 0x00000000 },
	{ .addr = 0x0f070b430, .val = 0x00000000 },
	{ .addr = 0x0f070b434, .val = 0x00000000 },
	{ .addr = 0x0f070b438, .val = 0x00000000 },
	{ .addr = 0x0f070b43c, .val = 0x00000000 },
	{ .addr = 0x0f070b440, .val = 0x00000000 },
	{ .addr = 0x0f070b444, .val = 0x00000000 },
	{ .addr = 0x0f070b448, .val = 0x00000000 },
	{ .addr = 0x0f070b44c, .val = 0x00000000 },
	{ .addr = 0x0f070b450, .val = 0x00000000 },
	{ .addr = 0x0f070b454, .val = 0x00000000 },
	{ .addr = 0x0f070b458, .val = 0x00000000 },
	{ .addr = 0x0f070b45c, .val = 0x00000000 },
	{ .addr = 0x0f070b460, .val = 0x00000000 },
	{ .addr = 0x0f070b464, .val = 0x00000000 },
	{ .addr = 0x0f070b468, .val = 0x00000000 },
	{ .addr = 0x0f070b46c, .val = 0x00000000 },
	{ .addr = 0x0f070b470, .val = 0x00000000 },
	{ .addr = 0x0f070b474, .val = 0x00000000 },
	{ .addr = 0x0f070b478, .val = 0x00000000 },
	{ .addr = 0x0f070b47c, .val = 0x00000000 },
	{ .addr = 0x0f070b480, .val = 0x00000000 },
	{ .addr = 0x0f070b484, .val = 0x00000000 },
	{ .addr = 0x0f070b488, .val = 0x00000000 },
	{ .addr = 0x0f070b48c, .val = 0x00000000 },
	{ .addr = 0x0f070b490, .val = 0x00000000 },
	{ .addr = 0x0f070b494, .val = 0x00000000 },
	{ .addr = 0x0f070b498, .val = 0x00000000 },
	{ .addr = 0x0f070b49c, .val = 0x00000000 },
	{ .addr = 0x0f070b4a0, .val = 0x00000000 },
	{ .addr = 0x0f070b4a4, .val = 0x00000000 },
	{ .addr = 0x0f070b4a8, .val = 0x00000000 },
	{ .addr = 0x0f070b4ac, .val = 0x00000000 },
	{ .addr = 0x0f070b4b0, .val = 0x00000000 },
	{ .addr = 0x0f070b4b4, .val = 0x00000000 },
	{ .addr = 0x0f070b4b8, .val = 0x00000000 },
	{ .addr = 0x0f070b4bc, .val = 0x00000000 },
	{ .addr = 0x0f070b4c0, .val = 0x00000000 },
	{ .addr = 0x0f070b4c4, .val = 0x00000000 },
	{ .addr = 0x0f070b4c8, .val = 0x00000000 },
	{ .addr = 0x0f070b4cc, .val = 0x00000000 },
	{ .addr = 0x0f070b4d0, .val = 0x00000000 },
	{ .addr = 0x0f070b4d4, .val = 0x00000000 },
	{ .addr = 0x0f070b4d8, .val = 0x00000000 },
	{ .addr = 0x0f070b4dc, .val = 0x00000000 },
	{ .addr = 0x0f070b4e0, .val = 0x00000000 },
	{ .addr = 0x0f070b4e4, .val = 0x00000000 },
	{ .addr = 0x0f070b4e8, .val = 0x00000000 },
	{ .addr = 0x0f070b4ec, .val = 0x00000000 },
	{ .addr = 0x0f070b4f0, .val = 0x00000000 },
	{ .addr = 0x0f070b4f4, .val = 0x00000000 },
	{ .addr = 0x0f070b4f8, .val = 0x00000000 },
	{ .addr = 0x0f070b4fc, .val = 0x00000000 },
	{ .addr = 0x0f070b500, .val = 0x00000000 },
	{ .addr = 0x0f070b504, .val = 0x00000000 },
	{ .addr = 0x0f070b508, .val = 0x00000000 },
	{ .addr = 0x0f070b50c, .val = 0x00000000 },
	{ .addr = 0x0f070b510, .val = 0x00000000 },
	{ .addr = 0x0f070b514, .val = 0x00000000 },
	{ .addr = 0x0f070b518, .val = 0x00000000 },
	{ .addr = 0x0f070b51c, .val = 0x00000000 },
	{ .addr = 0x0f070b520, .val = 0x00000000 },
	{ .addr = 0x0f070b524, .val = 0x00000000 },
	{ .addr = 0x0f070b528, .val = 0x00000000 },
	{ .addr = 0x0f070b52c, .val = 0x00000000 },
	{ .addr = 0x0f070b530, .val = 0x00000000 },
	{ .addr = 0x0f070b534, .val = 0x00000000 },
	{ .addr = 0x0f070b538, .val = 0x00000000 },
	{ .addr = 0x0f070b53c, .val = 0x00000000 },
	{ .addr = 0x0f070b540, .val = 0x00000000 },
	{ .addr = 0x0f070b544, .val = 0x00000000 },
	{ .addr = 0x0f070b548, .val = 0x00000000 },
	{ .addr = 0x0f070b54c, .val = 0x00000000 },
	{ .addr = 0x0f070b550, .val = 0x00000000 },
	{ .addr = 0x0f070b554, .val = 0x00000000 },
	{ .addr = 0x0f070b558, .val = 0x00000000 },
	{ .addr = 0x0f070b55c, .val = 0x00000000 },
	{ .addr = 0x0f070b560, .val = 0x00000000 },
	{ .addr = 0x0f070b564, .val = 0x00000000 },
	{ .addr = 0x0f070b568, .val = 0x00000000 },
	{ .addr = 0x0f070b56c, .val = 0x00000000 },
	{ .addr = 0x0f070b570, .val = 0x00000000 },
	{ .addr = 0x0f070b574, .val = 0x00000000 },
	{ .addr = 0x0f070b578, .val = 0x00000000 },
	{ .addr = 0x0f070b57c, .val = 0x00000000 },
	{ .addr = 0x0f070d000, .val = 0x00000000 },
	{ .addr = 0x0f070d004, .val = 0x00000000 },
	{ .addr = 0x0f070d008, .val = 0x00000000 },
	{ .addr = 0x0f070d00c, .val = 0x00000000 },
	{ .addr = 0x0f070d010, .val = 0x00000000 },
	{ .addr = 0x0f070d014, .val = 0x00000000 },
	{ .addr = 0x0f070d018, .val = 0x00000000 },
	{ .addr = 0x0f070d01c, .val = 0x00000000 },
	{ .addr = 0x0f070d020, .val = 0x00000000 },
	{ .addr = 0x0f070d024, .val = 0x00000000 },
	{ .addr = 0x0f070d028, .val = 0x00000000 },
	{ .addr = 0x0f070d02c, .val = 0x00000000 },
	{ .addr = 0x0f070d030, .val = 0x00000000 },
	{ .addr = 0x0f070d034, .val = 0x00000000 },
	{ .addr = 0x0f070d038, .val = 0x00000000 },
	{ .addr = 0x0f070d03c, .val = 0x00000000 },
	{ .addr = 0x0f070dc00, .val = 0x00000000 },
	{ .addr = 0x0f070dc04, .val = 0x00000000 },
	{ .addr = 0x0f070dc08, .val = 0x00000000 },
	{ .addr = 0x0f070dc0c, .val = 0x00000000 },
	{ .addr = 0x0f070dc10, .val = 0x00000000 },
	{ .addr = 0x0f070dc14, .val = 0x00000000 },
	{ .addr = 0x0f070dc18, .val = 0x00000000 },
	{ .addr = 0x0f070dc1c, .val = 0x00000000 },
	{ .addr = 0x0f070e000, .val = 0x00000000 },
	{ .addr = 0x0f070e004, .val = 0x00000000 },
	{ .addr = 0x0f070e008, .val = 0x00000000 },
	{ .addr = 0x0f070e00c, .val = 0x00000000 },
	{ .addr = 0x0f070e010, .val = 0x00000000 },
	{ .addr = 0x0f070e014, .val = 0x00000000 },
	{ .addr = 0x0f070e018, .val = 0x00000000 },
	{ .addr = 0x0f070e01c, .val = 0x00000000 },
	{ .addr = 0x0f070e400, .val = 0x00000000 },
	{ .addr = 0x0f070e404, .val = 0x00000000 },
	{ .addr = 0x0f070e408, .val = 0x00000000 },
	{ .addr = 0x0f070e40c, .val = 0x00000000 },
	{ .addr = 0x0f070e410, .val = 0x00000000 },
	{ .addr = 0x0f070e414, .val = 0x00000000 },
	{ .addr = 0x0f070e418, .val = 0x00000000 },
	{ .addr = 0x0f070e41c, .val = 0x00000000 },
	{ .addr = 0x0f070e800, .val = 0x00000000 },
	{ .addr = 0x0f070e804, .val = 0x00000000 },
	{ .addr = 0x0f070e808, .val = 0x00000000 },
	{ .addr = 0x0f070e80c, .val = 0x00000000 },
	{ .addr = 0x0f070e810, .val = 0x00000000 },
	{ .addr = 0x0f070e814, .val = 0x00000000 },
	{ .addr = 0x0f070e818, .val = 0x00000000 },
	{ .addr = 0x0f070e81c, .val = 0x00000000 },
	{ .addr = 0x0f070fc00, .val = 0x00000000 },
	{ .addr = 0x0f070fc04, .val = 0x00000000 },
	{ .addr = 0x0f070fc08, .val = 0x00000000 },
	{ .addr = 0x0f070fc0c, .val = 0x00000000 },
	{ .addr = 0x0f070fc10, .val = 0x00000000 },
	{ .addr = 0x0f070fc14, .val = 0x00000000 },
	{ .addr = 0x0f070fc18, .val = 0x00000000 },
	{ .addr = 0x0f070fc1c, .val = 0x00000000 },
	{ .addr = 0x0f0710000, .val = 0x00000000 },
	{ .addr = 0x0f0710400, .val = 0x00000000 },
	{ .addr = 0x0f0710800, .val = 0x00000000 },
	{ .addr = 0x0f0710c00, .val = 0x00000000 },
	{ .addr = 0x0f0711000, .val = 0x00000000 },
	{ .addr = 0x0f0711800, .val = 0x00000000 },
	{ .addr = 0x0f0712000, .val = 0x00000000 },
	{ .addr = 0x0f0712400, .val = 0x00000000 },
	{ .addr = 0x0f0712800, .val = 0x00000000 },
	{ .addr = 0x0f0712c00, .val = 0x00000000 },
	{ .addr = 0x0f0713000, .val = 0x00000000 },
	{ .addr = 0x0f0713004, .val = 0x00000000 },
	{ .addr = 0x0f0713008, .val = 0x00000000 },
	{ .addr = 0x0f071300c, .val = 0x00000000 },
	{ .addr = 0x0f0713010, .val = 0x00000000 },
	{ .addr = 0x0f0713014, .val = 0x00000000 },
	{ .addr = 0x0f0713018, .val = 0x00000000 },
	{ .addr = 0x0f071301c, .val = 0x00000000 },
	{ .addr = 0x0f0713020, .val = 0x00000000 },
	{ .addr = 0x0f0713024, .val = 0x00000000 },
	{ .addr = 0x0f0713028, .val = 0x00000000 },
	{ .addr = 0x0f071302c, .val = 0x00000000 },
	{ .addr = 0x0f0713030, .val = 0x00000000 },
	{ .addr = 0x0f0713034, .val = 0x00000000 },
	{ .addr = 0x0f0713038, .val = 0x00000000 },
	{ .addr = 0x0f071303c, .val = 0x00000000 },
	{ .addr = 0x0f0713400, .val = 0x00000000 },
	{ .addr = 0x0f0713404, .val = 0x00000000 },
	{ .addr = 0x0f0713408, .val = 0x00000000 },
	{ .addr = 0x0f071340c, .val = 0x00000000 },
	{ .addr = 0x0f0713410, .val = 0x00000000 },
	{ .addr = 0x0f0713414, .val = 0x00000000 },
	{ .addr = 0x0f0713418, .val = 0x00000000 },
	{ .addr = 0x0f071341c, .val = 0x00000000 },
	{ .addr = 0x0f0713420, .val = 0x00000000 },
	{ .addr = 0x0f0713424, .val = 0x00000000 },
	{ .addr = 0x0f0713428, .val = 0x00000000 },
	{ .addr = 0x0f071342c, .val = 0x00000000 },
	{ .addr = 0x0f0713430, .val = 0x00000000 },
	{ .addr = 0x0f0713434, .val = 0x00000000 },
	{ .addr = 0x0f0713438, .val = 0x00000000 },
	{ .addr = 0x0f071343c, .val = 0x00000000 },
	{ .addr = 0x0f0713440, .val = 0x00000000 },
	{ .addr = 0x0f0713444, .val = 0x00000000 },
	{ .addr = 0x0f0713448, .val = 0x00000000 },
	{ .addr = 0x0f071344c, .val = 0x00000000 },
	{ .addr = 0x0f0713450, .val = 0x00000000 },
	{ .addr = 0x0f0713454, .val = 0x00000000 },
	{ .addr = 0x0f0713458, .val = 0x00000000 },
	{ .addr = 0x0f071345c, .val = 0x00000000 },
	{ .addr = 0x0f0713460, .val = 0x00000000 },
	{ .addr = 0x0f0713464, .val = 0x00000000 },
	{ .addr = 0x0f0713468, .val = 0x00000000 },
	{ .addr = 0x0f071346c, .val = 0x00000000 },
	{ .addr = 0x0f0713470, .val = 0x00000000 },
	{ .addr = 0x0f0713474, .val = 0x00000000 },
	{ .addr = 0x0f0713478, .val = 0x00000000 },
	{ .addr = 0x0f071347c, .val = 0x00000000 },
	{ .addr = 0x0f0716400, .val = 0x00000000 },
	{ .addr = 0x0f0717000, .val = 0x00000000 },
	{ .addr = 0x0f0718000, .val = 0x00000000 },
	{ .addr = 0x0f0718400, .val = 0x00000000 },
	{ .addr = 0x0f0718800, .val = 0x00000000 },
	{ .addr = 0x0f0719400, .val = 0x00000000 },
	{ .addr = 0x0f0719404, .val = 0x00000000 },
	{ .addr = 0x0f0719408, .val = 0x00000000 },
	{ .addr = 0x0f071940c, .val = 0x00000000 },
	{ .addr = 0x0f0719410, .val = 0x00000000 },
	{ .addr = 0x0f0719414, .val = 0x00000000 },
	{ .addr = 0x0f0719418, .val = 0x00000000 },
	{ .addr = 0x0f071941c, .val = 0x00000000 },
	{ .addr = 0x0f0720800, .val = 0x00000000 },
	{ .addr = 0x0f0720c00, .val = 0x00000000 },
	{ .addr = 0x0f0721000, .val = 0x00000004 },
	{ .addr = 0x0f0722400, .val = 0x00000000 },
	{ .addr = 0x0f0723000, .val = 0x00000000 },
	{ .addr = 0x0f0723004, .val = 0x00000000 },
	{ .addr = 0x0f0723008, .val = 0x00000000 },
	{ .addr = 0x0f072300c, .val = 0x00000000 },
	{ .addr = 0x0f0723400, .val = 0x00000000 },
	{ .addr = 0x0f0723404, .val = 0x00000000 },
	{ .addr = 0x0f0723408, .val = 0x00000000 },
	{ .addr = 0x0f072340c, .val = 0x00000000 },
	{ .addr = 0x0f0723800, .val = 0x00000000 },
	{ .addr = 0x0f0723804, .val = 0x00000000 },
	{ .addr = 0x0f0723808, .val = 0x00000000 },
	{ .addr = 0x0f072380c, .val = 0x00000000 },
	{ .addr = 0x0f0728000, .val = 0x00000000 },
	{ .addr = 0x0f0728c00, .val = 0x00000000 },
	{ .addr = 0x0f0729000, .val = 0x00000000 },
	{ .addr = 0x0f0729400, .val = 0x00000000 },
	{ .addr = 0x0f0729404, .val = 0x00000000 },
	{ .addr = 0x0f0729408, .val = 0x00000000 },
	{ .addr = 0x0f072940c, .val = 0x00000000 },
	{ .addr = 0x0f0729410, .val = 0x00000000 },
	{ .addr = 0x0f0729414, .val = 0x00000000 },
	{ .addr = 0x0f0729418, .val = 0x00000000 },
	{ .addr = 0x0f072941c, .val = 0x00000000 },
	{ .addr = 0x0f0729420, .val = 0x00000000 },
	{ .addr = 0x0f0729424, .val = 0x00000000 },
	{ .addr = 0x0f0729428, .val = 0x00000000 },
	{ .addr = 0x0f072942c, .val = 0x00000000 },
	{ .addr = 0x0f0729430, .val = 0x00000000 },
	{ .addr = 0x0f0729434, .val = 0x00000000 },
	{ .addr = 0x0f0729438, .val = 0x00000000 },
	{ .addr = 0x0f072943c, .val = 0x00000000 },
	{ .addr = 0x0f0730800, .val = 0x00000000 },
	{ .addr = 0x0f0730c00, .val = 0x00000000 },
	{ .addr = 0x0f0731400, .val = 0x00000000 },
	{ .addr = 0x0f0731404, .val = 0x00000000 },
	{ .addr = 0x0f0731408, .val = 0x00000000 },
	{ .addr = 0x0f073140c, .val = 0x00000000 },
	{ .addr = 0x0f0731410, .val = 0x00000000 },
	{ .addr = 0x0f0731414, .val = 0x00000000 },
	{ .addr = 0x0f0731418, .val = 0x00000000 },
	{ .addr = 0x0f073141c, .val = 0x00000000 },
	{ .addr = 0x0f0731420, .val = 0x00000000 },
	{ .addr = 0x0f0731424, .val = 0x00000000 },
	{ .addr = 0x0f0731428, .val = 0x00000000 },
	{ .addr = 0x0f073142c, .val = 0x00000000 },
	{ .addr = 0x0f0731430, .val = 0x00000000 },
	{ .addr = 0x0f0731434, .val = 0x00000000 },
	{ .addr = 0x0f0731438, .val = 0x00000000 },
	{ .addr = 0x0f073143c, .val = 0x00000000 },
	{ .addr = 0x0f0731440, .val = 0x00000000 },
	{ .addr = 0x0f0731444, .val = 0x00000000 },
	{ .addr = 0x0f0731448, .val = 0x00000000 },
	{ .addr = 0x0f073144c, .val = 0x00000000 },
	{ .addr = 0x0f0731450, .val = 0x00000000 },
	{ .addr = 0x0f0731454, .val = 0x00000000 },
	{ .addr = 0x0f0731458, .val = 0x00000000 },
	{ .addr = 0x0f073145c, .val = 0x00000000 },
	{ .addr = 0x0f0731460, .val = 0x00000000 },
	{ .addr = 0x0f0731464, .val = 0x00000000 },
	{ .addr = 0x0f0731468, .val = 0x00000000 },
	{ .addr = 0x0f073146c, .val = 0x00000000 },
	{ .addr = 0x0f0731470, .val = 0x00000000 },
	{ .addr = 0x0f0731474, .val = 0x00000000 },
	{ .addr = 0x0f0731478, .val = 0x00000000 },
	{ .addr = 0x0f073147c, .val = 0x00000000 },
	{ .addr = 0x0f0731480, .val = 0x00000000 },
	{ .addr = 0x0f0731484, .val = 0x00000000 },
	{ .addr = 0x0f0731488, .val = 0x00000000 },
	{ .addr = 0x0f073148c, .val = 0x00000000 },
	{ .addr = 0x0f0731490, .val = 0x00000000 },
	{ .addr = 0x0f0731494, .val = 0x00000000 },
	{ .addr = 0x0f0731498, .val = 0x00000000 },
	{ .addr = 0x0f073149c, .val = 0x00000000 },
	{ .addr = 0x0f07314a0, .val = 0x00000000 },
	{ .addr = 0x0f07314a4, .val = 0x00000000 },
	{ .addr = 0x0f07314a8, .val = 0x00000000 },
	{ .addr = 0x0f07314ac, .val = 0x00000000 },
	{ .addr = 0x0f07314b0, .val = 0x00000000 },
	{ .addr = 0x0f07314b4, .val = 0x00000000 },
	{ .addr = 0x0f07314b8, .val = 0x00000000 },
	{ .addr = 0x0f07314bc, .val = 0x00000000 },
	{ .addr = 0x0f07314c0, .val = 0x00000000 },
	{ .addr = 0x0f07314c4, .val = 0x00000000 },
	{ .addr = 0x0f07314c8, .val = 0x00000000 },
	{ .addr = 0x0f07314cc, .val = 0x00000000 },
	{ .addr = 0x0f07314d0, .val = 0x00000000 },
	{ .addr = 0x0f07314d4, .val = 0x00000000 },
	{ .addr = 0x0f07314d8, .val = 0x00000000 },
	{ .addr = 0x0f07314dc, .val = 0x00000000 },
	{ .addr = 0x0f07314e0, .val = 0x00000000 },
	{ .addr = 0x0f07314e4, .val = 0x00000000 },
	{ .addr = 0x0f07314e8, .val = 0x00000000 },
	{ .addr = 0x0f07314ec, .val = 0x00000000 },
	{ .addr = 0x0f07314f0, .val = 0x00000000 },
	{ .addr = 0x0f07314f4, .val = 0x00000000 },
	{ .addr = 0x0f07314f8, .val = 0x00000000 },
	{ .addr = 0x0f07314fc, .val = 0x00000000 },
	{ .addr = 0x0f0731800, .val = 0x00000000 },
	{ .addr = 0x0f0731804, .val = 0x00000000 },
	{ .addr = 0x0f0731808, .val = 0x00000000 },
	{ .addr = 0x0f073180c, .val = 0x00000000 },
	{ .addr = 0x0f0731810, .val = 0x00000000 },
	{ .addr = 0x0f0731814, .val = 0x00000000 },
	{ .addr = 0x0f0731818, .val = 0x00000000 },
	{ .addr = 0x0f073181c, .val = 0x00000000 },
	{ .addr = 0x0f0731820, .val = 0x00000000 },
	{ .addr = 0x0f0731824, .val = 0x00000000 },
	{ .addr = 0x0f0731828, .val = 0x00000000 },
	{ .addr = 0x0f073182c, .val = 0x00000000 },
	{ .addr = 0x0f0731830, .val = 0x00000000 },
	{ .addr = 0x0f0731834, .val = 0x00000000 },
	{ .addr = 0x0f0731838, .val = 0x00000000 },
	{ .addr = 0x0f073183c, .val = 0x00000000 },
	{ .addr = 0x0f0731840, .val = 0x00000000 },
	{ .addr = 0x0f0731844, .val = 0x00000000 },
	{ .addr = 0x0f0731848, .val = 0x00000000 },
	{ .addr = 0x0f073184c, .val = 0x00000000 },
	{ .addr = 0x0f0731850, .val = 0x00000000 },
	{ .addr = 0x0f0731854, .val = 0x00000000 },
	{ .addr = 0x0f0731858, .val = 0x00000000 },
	{ .addr = 0x0f073185c, .val = 0x00000000 },
	{ .addr = 0x0f0731860, .val = 0x00000000 },
	{ .addr = 0x0f0731864, .val = 0x00000000 },
	{ .addr = 0x0f0731868, .val = 0x00000000 },
	{ .addr = 0x0f073186c, .val = 0x00000000 },
	{ .addr = 0x0f0731870, .val = 0x00000000 },
	{ .addr = 0x0f0731874, .val = 0x00000000 },
	{ .addr = 0x0f0731878, .val = 0x00000000 },
	{ .addr = 0x0f073187c, .val = 0x00000000 },
	{ .addr = 0x0f0731880, .val = 0x00000000 },
	{ .addr = 0x0f0731884, .val = 0x00000000 },
	{ .addr = 0x0f0731888, .val = 0x00000000 },
	{ .addr = 0x0f073188c, .val = 0x00000000 },
	{ .addr = 0x0f0731890, .val = 0x00000000 },
	{ .addr = 0x0f0731894, .val = 0x00000000 },
	{ .addr = 0x0f0731898, .val = 0x00000000 },
	{ .addr = 0x0f073189c, .val = 0x00000000 },
	{ .addr = 0x0f07318a0, .val = 0x00000000 },
	{ .addr = 0x0f07318a4, .val = 0x00000000 },
	{ .addr = 0x0f07318a8, .val = 0x00000000 },
	{ .addr = 0x0f07318ac, .val = 0x00000000 },
	{ .addr = 0x0f07318b0, .val = 0x00000000 },
	{ .addr = 0x0f07318b4, .val = 0x00000000 },
	{ .addr = 0x0f07318b8, .val = 0x00000000 },
	{ .addr = 0x0f07318bc, .val = 0x00000000 },
	{ .addr = 0x0f07318c0, .val = 0x00000000 },
	{ .addr = 0x0f07318c4, .val = 0x00000000 },
	{ .addr = 0x0f07318c8, .val = 0x00000000 },
	{ .addr = 0x0f07318cc, .val = 0x00000000 },
	{ .addr = 0x0f07318d0, .val = 0x00000000 },
	{ .addr = 0x0f07318d4, .val = 0x00000000 },
	{ .addr = 0x0f07318d8, .val = 0x00000000 },
	{ .addr = 0x0f07318dc, .val = 0x00000000 },
	{ .addr = 0x0f07318e0, .val = 0x00000000 },
	{ .addr = 0x0f07318e4, .val = 0x00000000 },
	{ .addr = 0x0f07318e8, .val = 0x00000000 },
	{ .addr = 0x0f07318ec, .val = 0x00000000 },
	{ .addr = 0x0f07318f0, .val = 0x00000000 },
	{ .addr = 0x0f07318f4, .val = 0x00000000 },
	{ .addr = 0x0f07318f8, .val = 0x00000000 },
	{ .addr = 0x0f07318fc, .val = 0x00000000 },
	{ .addr = 0x0f0731c00, .val = 0x00000000 },
	{ .addr = 0x0f0731c04, .val = 0x00000000 },
	{ .addr = 0x0f0731c08, .val = 0x00000000 },
	{ .addr = 0x0f0731c0c, .val = 0x00000000 },
	{ .addr = 0x0f0731c10, .val = 0x00000000 },
	{ .addr = 0x0f0731c14, .val = 0x00000000 },
	{ .addr = 0x0f0731c18, .val = 0x00000000 },
	{ .addr = 0x0f0731c1c, .val = 0x00000000 },
	{ .addr = 0x0f0731c20, .val = 0x00000000 },
	{ .addr = 0x0f0731c24, .val = 0x00000000 },
	{ .addr = 0x0f0731c28, .val = 0x00000000 },
	{ .addr = 0x0f0731c2c, .val = 0x00000000 },
	{ .addr = 0x0f0731c30, .val = 0x00000000 },
	{ .addr = 0x0f0731c34, .val = 0x00000000 },
	{ .addr = 0x0f0731c38, .val = 0x00000000 },
	{ .addr = 0x0f0731c3c, .val = 0x00000000 },
	{ .addr = 0x0f0731c40, .val = 0x00000000 },
	{ .addr = 0x0f0731c44, .val = 0x00000000 },
	{ .addr = 0x0f0731c48, .val = 0x00000000 },
	{ .addr = 0x0f0731c4c, .val = 0x00000000 },
	{ .addr = 0x0f0731c50, .val = 0x00000000 },
	{ .addr = 0x0f0731c54, .val = 0x00000000 },
	{ .addr = 0x0f0731c58, .val = 0x00000000 },
	{ .addr = 0x0f0731c5c, .val = 0x00000000 },
	{ .addr = 0x0f0731c60, .val = 0x00000000 },
	{ .addr = 0x0f0731c64, .val = 0x00000000 },
	{ .addr = 0x0f0731c68, .val = 0x00000000 },
	{ .addr = 0x0f0731c6c, .val = 0x00000000 },
	{ .addr = 0x0f0731c70, .val = 0x00000000 },
	{ .addr = 0x0f0731c74, .val = 0x00000000 },
	{ .addr = 0x0f0731c78, .val = 0x00000000 },
	{ .addr = 0x0f0731c7c, .val = 0x00000000 },
	{ .addr = 0x0f0738800, .val = 0x00000000 },
	{ .addr = 0x0f0739000, .val = 0x00000000 },
	{ .addr = 0x0f0739400, .val = 0x00000000 },
	{ .addr = 0x0f0739404, .val = 0x00000000 },
	{ .addr = 0x0f0739408, .val = 0x00000000 },
	{ .addr = 0x0f073940c, .val = 0x00000000 },
	{ .addr = 0x0f0740000, .val = 0x00000000 },
	{ .addr = 0x0f0740400, .val = 0x00000000 },
	{ .addr = 0x0f0740800, .val = 0x00000000 },
	{ .addr = 0x0f0740c00, .val = 0x00000000 },
};

const struct test_reg reg_rand[] = {
	{ .addr = 0x0f000110c, .val = 0x00000340 },
	{ .addr = 0x0f0000004, .val = 0x00000011 },
	{ .addr = 0x0f000000c, .val = 0x00000101 },
	{ .addr = 0x0f0002000, .val = 0x0000003c },
	{ .addr = 0x0f0002008, .val = 0x0000002b },
	{ .addr = 0x0f000200c, .val = 0x00000009 },
	{ .addr = 0x0f0018100, .val = 0x000c80d6 },
	{ .addr = 0x0f0018104, .val = 0x000b39b0 },
	{ .addr = 0x0f0018108, .val = 0x000b4b73 },
	{ .addr = 0x0f001810c, .val = 0x00012a20 },
	{ .addr = 0x0f0018120, .val = 0x000cb3e4 },
	{ .addr = 0x0f0018124, .val = 0x00008843 },
	{ .addr = 0x0f0018128, .val = 0x000113f3 },
	{ .addr = 0x0f001812c, .val = 0x0005e2fb },
	{ .addr = 0x0f0018140, .val = 0x000f611a },
	{ .addr = 0x0f0018144, .val = 0x000ef396 },
	{ .addr = 0x0f0018148, .val = 0x0008d92b },
	{ .addr = 0x0f001814c, .val = 0x00056ba6 },
	{ .addr = 0x0f0018160, .val = 0x000bc291 },
	{ .addr = 0x0f0018164, .val = 0x0001342d },
	{ .addr = 0x0f0018168, .val = 0x00097963 },
	{ .addr = 0x0f001816c, .val = 0x000902d3 },
	{ .addr = 0x0f0018200, .val = 0x000000a0 },
	{ .addr = 0x0f0018204, .val = 0x0000008b },
	{ .addr = 0x0f0018208, .val = 0x000000f8 },
	{ .addr = 0x0f001820c, .val = 0x00000060 },
	{ .addr = 0x0f0018220, .val = 0x0006b3ae },
	{ .addr = 0x0f0018224, .val = 0x0009577c },
	{ .addr = 0x0f0018228, .val = 0x000b08a7 },
	{ .addr = 0x0f001822c, .val = 0x000b97f0 },
	{ .addr = 0x0f0018240, .val = 0x000015f0 },
	{ .addr = 0x0f0018244, .val = 0x00032cf6 },
	{ .addr = 0x0f0018248, .val = 0x0001e99f },
	{ .addr = 0x0f001824c, .val = 0x0004d465 },
	{ .addr = 0x0f0018260, .val = 0x0002abbd },
	{ .addr = 0x0f0018264, .val = 0x00032c88 },
	{ .addr = 0x0f0018268, .val = 0x000fa789 },
	{ .addr = 0x0f001826c, .val = 0x00007f53 },
	{ .addr = 0x0f0018280, .val = 0x000a4e07 },
	{ .addr = 0x0f0018284, .val = 0x000254c9 },
	{ .addr = 0x0f0018288, .val = 0x0001c092 },
	{ .addr = 0x0f001828c, .val = 0x000e7c60 },
	{ .addr = 0x0f0018320, .val = 0x000dd5e4 },
	{ .addr = 0x0f0018324, .val = 0x00002bcc },
	{ .addr = 0x0f0018328, .val = 0x000d41e0 },
	{ .addr = 0x0f001832c, .val = 0x000040e8 },
	{ .addr = 0x0f0018340, .val = 0x00004a38 },
	{ .addr = 0x0f0018344, .val = 0x000ded72 },
	{ .addr = 0x0f0018348, .val = 0x000c3bb1 },
	{ .addr = 0x0f001834c, .val = 0x0007a6b0 },
	{ .addr = 0x0f0018360, .val = 0x0009ca81 },
	{ .addr = 0x0f0018364, .val = 0x000236bb },
	{ .addr = 0x0f0018368, .val = 0x0002cf7c },
	{ .addr = 0x0f001836c, .val = 0x0005547c },
	{ .addr = 0x0f0018380, .val = 0x000d8878 },
	{ .addr = 0x0f0018384, .val = 0x000964d7 },
	{ .addr = 0x0f0018388, .val = 0x00087cb7 },
	{ .addr = 0x0f001838c, .val = 0x0002c67b },
	{ .addr = 0x0f0018440, .val = 0x000fd040 },
	{ .addr = 0x0f0018444, .val = 0x00741530 },
	{ .addr = 0x0f0018448, .val = 0x0016f03a },
	{ .addr = 0x0f001844c, .val = 0x00641d2e },
	{ .addr = 0x0f0018480, .val = 0x0004f17a },
	{ .addr = 0x0f0018484, .val = 0x0008be31 },
	{ .addr = 0x0f0018488, .val = 0x000b0290 },
	{ .addr = 0x0f001848c, .val = 0x000c15d6 },
	{ .addr = 0x0f00184a0, .val = 0x0007a657 },
	{ .addr = 0x0f00184a4, .val = 0x000e054d },
	{ .addr = 0x0f00184a8, .val = 0x00058660 },
	{ .addr = 0x0f00184ac, .val = 0x00056a20 },
	{ .addr = 0x0f00184c0, .val = 0x000af9ef },
	{ .addr = 0x0f00184c4, .val = 0x0009e6b5 },
	{ .addr = 0x0f00184c8, .val = 0x00008285 },
	{ .addr = 0x0f00184cc, .val = 0x000e71f8 },
	{ .addr = 0x0f00184e0, .val = 0x0005507f },
	{ .addr = 0x0f00184e4, .val = 0x000263a4 },
	{ .addr = 0x0f00184e8, .val = 0x00074b68 },
	{ .addr = 0x0f00184ec, .val = 0x00069b0a },
	{ .addr = 0x0f0018580, .val = 0x0003c9f6 },
	{ .addr = 0x0f0018584, .val = 0x0004d662 },
	{ .addr = 0x0f0018588, .val = 0x000e9d7b },
	{ .addr = 0x0f001858c, .val = 0x0004de74 },
	{ .addr = 0x0f00185a0, .val = 0x0003286c },
	{ .addr = 0x0f00185a4, .val = 0x000d2b5e },
	{ .addr = 0x0f00185a8, .val = 0x00065074 },
	{ .addr = 0x0f00185ac, .val = 0x0009e341 },
	{ .addr = 0x0f00185c0, .val = 0x0003a23a },
	{ .addr = 0x0f00185c4, .val = 0x00081cde },
	{ .addr = 0x0f00185c8, .val = 0x000a9eec },
	{ .addr = 0x0f00185cc, .val = 0x000988d2 },
	{ .addr = 0x0f00185e0, .val = 0x00061796 },
	{ .addr = 0x0f00185e4, .val = 0x000d7f87 },
	{ .addr = 0x0f00185e8, .val = 0x000b3165 },
	{ .addr = 0x0f00185ec, .val = 0x000f8d32 },
	{ .addr = 0x0f0018600, .val = 0x00093a08 },
	{ .addr = 0x0f0018604, .val = 0x000418f9 },
	{ .addr = 0x0f0018608, .val = 0x000e87ea },
	{ .addr = 0x0f001860c, .val = 0x00078ee2 },
	{ .addr = 0x0f00186a0, .val = 0x00096375 },
	{ .addr = 0x0f00186a4, .val = 0x000989f9 },
	{ .addr = 0x0f00186a8, .val = 0x000b37ed },
	{ .addr = 0x0f00186ac, .val = 0x000829dc },
	{ .addr = 0x0f00187c0, .val = 0x0007af59 },
	{ .addr = 0x0f00187c4, .val = 0x000253f0 },
	{ .addr = 0x0f00187c8, .val = 0x000c849c },
	{ .addr = 0x0f00187cc, .val = 0x000321e4 },
	{ .addr = 0x0f00187e0, .val = 0x0000001c },
	{ .addr = 0x0f00187e4, .val = 0x000003b9 },
	{ .addr = 0x0f0018800, .val = 0x000000d9 },
	{ .addr = 0x0f0018804, .val = 0x00000098 },
	{ .addr = 0x0f0018808, .val = 0x00000069 },
	{ .addr = 0x0f001880c, .val = 0x00000038 },
	{ .addr = 0x0f0018820, .val = 0x0002cc64 },
	{ .addr = 0x0f0018824, .val = 0x0008c378 },
	{ .addr = 0x0f0018828, .val = 0x000572d7 },
	{ .addr = 0x0f0018830, .val = 0x000e0f82 },
	{ .addr = 0x0f0018834, .val = 0x000baf6f },
	{ .addr = 0x0f001883c, .val = 0x0000015e },
	{ .addr = 0x0f0018844, .val = 0x000f2271 },
	{ .addr = 0x0f0018848, .val = 0x000a4f26 },
	{ .addr = 0x0f001884c, .val = 0x000631d8 },
	{ .addr = 0x0f0018850, .val = 0x000250ca },
	{ .addr = 0x0f0018854, .val = 0x000409b4 },
	{ .addr = 0x0f0018858, .val = 0x000e9b1b },
	{ .addr = 0x0f001885c, .val = 0x0008e98f },
	{ .addr = 0x0f0018860, .val = 0x000d020b },
	{ .addr = 0x0f0018868, .val = 0x000e032a },
	{ .addr = 0x0f0018870, .val = 0x000a011e },
	{ .addr = 0x0f0018878, .val = 0x00cb120f },
	{ .addr = 0x0f0018880, .val = 0x000a0213 },
	{ .addr = 0x0f0018888, .val = 0x000b0113 },
	{ .addr = 0x0f0018890, .val = 0x000e0328 },
	{ .addr = 0x0f0018898, .val = 0x0007132f },
	{ .addr = 0x0f001889c, .val = 0x00081206 },
	{ .addr = 0x0f00188a0, .val = 0x000c122d },
	{ .addr = 0x0f00188a4, .val = 0x000a021e },
	{ .addr = 0x0f00188e4, .val = 0x000716e2 },
	{ .addr = 0x0f0018940, .val = 0xe463d17c },
	{ .addr = 0x0f0010080, .val = 0x00000000 },
	{ .addr = 0x0f0010084, .val = 0xb75e1c0f },
	{ .addr = 0x0f0004000, .val = 0x0000001f },
	{ .addr = 0x0f0004004, .val = 0x0000000d },
	{ .addr = 0x0f0004008, .val = 0x0000000c },
	{ .addr = 0x0f000400c, .val = 0x0000001c },
	{ .addr = 0x0f0004010, .val = 0x0000001a },
	{ .addr = 0x0f0004014, .val = 0x0000001e },
	{ .addr = 0x0f0004018, .val = 0x0000001e },
	{ .addr = 0x0f000401c, .val = 0x00000016 },
	{ .addr = 0x0f0004020, .val = 0x00000009 },
	{ .addr = 0x0f0004024, .val = 0x00000006 },
	{ .addr = 0x0f0004028, .val = 0x00000016 },
	{ .addr = 0x0f000402c, .val = 0x00000006 },
	{ .addr = 0x0f0004030, .val = 0x00000014 },
	{ .addr = 0x0f0004034, .val = 0x0000001c },
	{ .addr = 0x0f0004038, .val = 0x00000014 },
	{ .addr = 0x0f000403c, .val = 0x00000004 },
	{ .addr = 0x0f0004040, .val = 0x00000000 },
	{ .addr = 0x0f0004044, .val = 0x00000019 },
	{ .addr = 0x0f0004048, .val = 0x0000000e },
	{ .addr = 0x0f000404c, .val = 0x0000000e },
	{ .addr = 0x0f0004050, .val = 0x0000001a },
	{ .addr = 0x0f0004054, .val = 0x0000000f },
	{ .addr = 0x0f0004058, .val = 0x00000006 },
	{ .addr = 0x0f000405c, .val = 0x0000001c },
	{ .addr = 0x0f0004060, .val = 0x00000005 },
	{ .addr = 0x0f0004064, .val = 0x00000004 },
	{ .addr = 0x0f0004068, .val = 0x00000015 },
	{ .addr = 0x0f000406c, .val = 0x00000010 },
	{ .addr = 0x0f0004070, .val = 0x0000000a },
	{ .addr = 0x0f0004074, .val = 0x00000007 },
	{ .addr = 0x0f0004078, .val = 0x00000019 },
	{ .addr = 0x0f000407c, .val = 0x00000002 },
	{ .addr = 0x0f0004080, .val = 0x00000003 },
	{ .addr = 0x0f0004084, .val = 0x00000017 },
	{ .addr = 0x0f0004088, .val = 0x0000001b },
	{ .addr = 0x0f000408c, .val = 0x00000004 },
	{ .addr = 0x0f0004090, .val = 0x0000001a },
	{ .addr = 0x0f0004094, .val = 0x00000018 },
	{ .addr = 0x0f0004098, .val = 0x0000000a },
	{ .addr = 0x0f000409c, .val = 0x00000017 },
	{ .addr = 0x0f00040a0, .val = 0x00000016 },
	{ .addr = 0x0f00040a4, .val = 0x0000000d },
	{ .addr = 0x0f00040a8, .val = 0x00000003 },
	{ .addr = 0x0f00040ac, .val = 0x00000014 },
	{ .addr = 0x0f00040b0, .val = 0x00000014 },
	{ .addr = 0x0f00040b4, .val = 0x00000011 },
	{ .addr = 0x0f00040b8, .val = 0x00000000 },
	{ .addr = 0x0f00040bc, .val = 0x00000000 },
	{ .addr = 0x0f00040c0, .val = 0x00000015 },
	{ .addr = 0x0f00040c4, .val = 0x00000001 },
	{ .addr = 0x0f00040c8, .val = 0x00000017 },
	{ .addr = 0x0f00040cc, .val = 0x00000012 },
	{ .addr = 0x0f00040d0, .val = 0x00000013 },
	{ .addr = 0x0f00040d4, .val = 0x0000001c },
	{ .addr = 0x0f00040d8, .val = 0x0000000e },
	{ .addr = 0x0f00040dc, .val = 0x00000000 },
	{ .addr = 0x0f00040e0, .val = 0x0000000d },
	{ .addr = 0x0f00040e4, .val = 0x0000001f },
	{ .addr = 0x0f00040e8, .val = 0x00000016 },
	{ .addr = 0x0f00040ec, .val = 0x00000013 },
	{ .addr = 0x0f00040f0, .val = 0x00000009 },
	{ .addr = 0x0f00040f4, .val = 0x00000015 },
	{ .addr = 0x0f00040f8, .val = 0x0000000c },
	{ .addr = 0x0f00040fc, .val = 0x00000001 },
	{ .addr = 0x0f0004100, .val = 0x00000015 },
	{ .addr = 0x0f0004104, .val = 0x0000000f },
	{ .addr = 0x0f0004108, .val = 0x00000009 },
	{ .addr = 0x0f000410c, .val = 0x0000000e },
	{ .addr = 0x0f0004110, .val = 0x00000004 },
	{ .addr = 0x0f0004114, .val = 0x0000001a },
	{ .addr = 0x0f0004118, .val = 0x00000006 },
	{ .addr = 0x0f000411c, .val = 0x00000019 },
	{ .addr = 0x0f0004120, .val = 0x0000001f },
	{ .addr = 0x0f0004124, .val = 0x00000012 },
	{ .addr = 0x0f0004128, .val = 0x0000001b },
	{ .addr = 0x0f000412c, .val = 0x0000001e },
	{ .addr = 0x0f0004130, .val = 0x0000000c },
	{ .addr = 0x0f0004134, .val = 0x00000015 },
	{ .addr = 0x0f0004138, .val = 0x00000005 },
	{ .addr = 0x0f000413c, .val = 0x00000018 },
	{ .addr = 0x0f0004140, .val = 0x00000013 },
	{ .addr = 0x0f0004144, .val = 0x0000000b },
	{ .addr = 0x0f0004148, .val = 0x0000001f },
	{ .addr = 0x0f000414c, .val = 0x0000000b },
	{ .addr = 0x0f0004150, .val = 0x00000017 },
	{ .addr = 0x0f0004154, .val = 0x00000017 },
	{ .addr = 0x0f0004158, .val = 0x00000011 },
	{ .addr = 0x0f000415c, .val = 0x0000000d },
	{ .addr = 0x0f0004160, .val = 0x00000015 },
	{ .addr = 0x0f0004164, .val = 0x00000018 },
	{ .addr = 0x0f0004168, .val = 0x00000015 },
	{ .addr = 0x0f000416c, .val = 0x00000003 },
	{ .addr = 0x0f0004170, .val = 0x0000001f },
	{ .addr = 0x0f0004174, .val = 0x00000005 },
	{ .addr = 0x0f0004178, .val = 0x0000000b },
	{ .addr = 0x0f000417c, .val = 0x00000000 },
	{ .addr = 0x0f0004180, .val = 0x00000012 },
	{ .addr = 0x0f0004184, .val = 0x0000000f },
	{ .addr = 0x0f0004188, .val = 0x0000000d },
	{ .addr = 0x0f000418c, .val = 0x0000001a },
	{ .addr = 0x0f0004190, .val = 0x0000001a },
	{ .addr = 0x0f0004194, .val = 0x00000016 },
	{ .addr = 0x0f0004198, .val = 0x0000000f },
	{ .addr = 0x0f000419c, .val = 0x0000001b },
	{ .addr = 0x0f00041a0, .val = 0x00000007 },
	{ .addr = 0x0f00041a4, .val = 0x0000000b },
	{ .addr = 0x0f00041a8, .val = 0x00000012 },
	{ .addr = 0x0f00041ac, .val = 0x0000000b },
	{ .addr = 0x0f00041b0, .val = 0x0000001f },
	{ .addr = 0x0f00041b4, .val = 0x0000000c },
	{ .addr = 0x0f00041b8, .val = 0x00000011 },
	{ .addr = 0x0f00041bc, .val = 0x00000004 },
	{ .addr = 0x0f00041c0, .val = 0x00000006 },
	{ .addr = 0x0f00041c4, .val = 0x0000001a },
	{ .addr = 0x0f00041c8, .val = 0x0000000b },
	{ .addr = 0x0f00041cc, .val = 0x0000000d },
	{ .addr = 0x0f00041d0, .val = 0x0000000b },
	{ .addr = 0x0f00041d4, .val = 0x0000000b },
	{ .addr = 0x0f00041d8, .val = 0x0000001d },
	{ .addr = 0x0f00041dc, .val = 0x00000006 },
	{ .addr = 0x0f00041e0, .val = 0x00000007 },
	{ .addr = 0x0f00041e4, .val = 0x00000010 },
	{ .addr = 0x0f00041e8, .val = 0x00000015 },
	{ .addr = 0x0f00041ec, .val = 0x00000007 },
	{ .addr = 0x0f00041f0, .val = 0x00000009 },
	{ .addr = 0x0f00041f4, .val = 0x0000001c },
	{ .addr = 0x0f00041f8, .val = 0x00000003 },
	{ .addr = 0x0f00041fc, .val = 0x0000001f },
	{ .addr = 0x0f0004200, .val = 0x0000001d },
	{ .addr = 0x0f0004204, .val = 0x00000013 },
	{ .addr = 0x0f0004208, .val = 0x00000005 },
	{ .addr = 0x0f000420c, .val = 0x00000018 },
	{ .addr = 0x0f0004210, .val = 0x0000001e },
	{ .addr = 0x0f0004214, .val = 0x00000003 },
	{ .addr = 0x0f0004218, .val = 0x00000019 },
	{ .addr = 0x0f000421c, .val = 0x00000000 },
	{ .addr = 0x0f0004220, .val = 0x00000010 },
	{ .addr = 0x0f0004224, .val = 0x00000014 },
	{ .addr = 0x0f0004228, .val = 0x00000004 },
	{ .addr = 0x0f000422c, .val = 0x00000007 },
	{ .addr = 0x0f0004230, .val = 0x0000000f },
	{ .addr = 0x0f0004234, .val = 0x00000012 },
	{ .addr = 0x0f0004238, .val = 0x00000010 },
	{ .addr = 0x0f000423c, .val = 0x00000000 },
	{ .addr = 0x0f0004240, .val = 0x0000000f },
	{ .addr = 0x0f0004244, .val = 0x00000017 },
	{ .addr = 0x0f0004248, .val = 0x00000016 },
	{ .addr = 0x0f000424c, .val = 0x0000000d },
	{ .addr = 0x0f0004250, .val = 0x0000000c },
	{ .addr = 0x0f0004254, .val = 0x0000001b },
	{ .addr = 0x0f0004258, .val = 0x00000017 },
	{ .addr = 0x0f000425c, .val = 0x0000001a },
	{ .addr = 0x0f0004260, .val = 0x0000001a },
	{ .addr = 0x0f0004264, .val = 0x00000006 },
	{ .addr = 0x0f0004268, .val = 0x0000000c },
	{ .addr = 0x0f000426c, .val = 0x00000004 },
	{ .addr = 0x0f0004270, .val = 0x00000017 },
	{ .addr = 0x0f0004274, .val = 0x0000000b },
	{ .addr = 0x0f0004278, .val = 0x0000000f },
	{ .addr = 0x0f000427c, .val = 0x0000000a },
	{ .addr = 0x0f0004280, .val = 0x0000000b },
	{ .addr = 0x0f0004284, .val = 0x00000018 },
	{ .addr = 0x0f0004288, .val = 0x00000004 },
	{ .addr = 0x0f000428c, .val = 0x0000001c },
	{ .addr = 0x0f0004290, .val = 0x00000008 },
	{ .addr = 0x0f0004294, .val = 0x0000000a },
	{ .addr = 0x0f0004298, .val = 0x00000004 },
	{ .addr = 0x0f000429c, .val = 0x0000000d },
	{ .addr = 0x0f00042a0, .val = 0x0000000a },
	{ .addr = 0x0f00042a4, .val = 0x0000001a },
	{ .addr = 0x0f00042a8, .val = 0x00000000 },
	{ .addr = 0x0f00042ac, .val = 0x0000000f },
	{ .addr = 0x0f00042b0, .val = 0x0000001e },
	{ .addr = 0x0f00042b4, .val = 0x0000000b },
	{ .addr = 0x0f00042b8, .val = 0x0000001a },
	{ .addr = 0x0f00042bc, .val = 0x00000015 },
	{ .addr = 0x0f00042c0, .val = 0x0000000e },
	{ .addr = 0x0f00042c4, .val = 0x00000010 },
	{ .addr = 0x0f00042c8, .val = 0x0000001d },
	{ .addr = 0x0f00042cc, .val = 0x00000002 },
	{ .addr = 0x0f00042d0, .val = 0x0000001a },
	{ .addr = 0x0f00042d4, .val = 0x00000018 },
	{ .addr = 0x0f00042d8, .val = 0x0000000f },
	{ .addr = 0x0f00042dc, .val = 0x00000007 },
	{ .addr = 0x0f00042e0, .val = 0x00000008 },
	{ .addr = 0x0f00042e4, .val = 0x0000001d },
	{ .addr = 0x0f00042e8, .val = 0x0000001a },
	{ .addr = 0x0f00042ec, .val = 0x00000008 },
	{ .addr = 0x0f00042f0, .val = 0x0000000f },
	{ .addr = 0x0f00042f4, .val = 0x00000010 },
	{ .addr = 0x0f00042f8, .val = 0x00000006 },
	{ .addr = 0x0f00042fc, .val = 0x0000000c },
	{ .addr = 0x0f0004300, .val = 0x00000015 },
	{ .addr = 0x0f0004304, .val = 0x0000000d },
	{ .addr = 0x0f0004308, .val = 0x00000003 },
	{ .addr = 0x0f000430c, .val = 0x00000009 },
	{ .addr = 0x0f0004310, .val = 0x00000009 },
	{ .addr = 0x0f0004314, .val = 0x0000000d },
	{ .addr = 0x0f0004318, .val = 0x0000000d },
	{ .addr = 0x0f000431c, .val = 0x00000006 },
	{ .addr = 0x0f0004320, .val = 0x0000000c },
	{ .addr = 0x0f0004324, .val = 0x00000014 },
	{ .addr = 0x0f0004328, .val = 0x00000017 },
	{ .addr = 0x0f000432c, .val = 0x00000016 },
	{ .addr = 0x0f0004330, .val = 0x00000011 },
	{ .addr = 0x0f0004334, .val = 0x0000000c },
	{ .addr = 0x0f0004338, .val = 0x00000013 },
	{ .addr = 0x0f000433c, .val = 0x00000014 },
	{ .addr = 0x0f0004340, .val = 0x00000002 },
	{ .addr = 0x0f0004344, .val = 0x00000006 },
	{ .addr = 0x0f0004348, .val = 0x00000009 },
	{ .addr = 0x0f000434c, .val = 0x00000008 },
	{ .addr = 0x0f0004350, .val = 0x00000006 },
	{ .addr = 0x0f0004354, .val = 0x00000005 },
	{ .addr = 0x0f0004358, .val = 0x0000001c },
	{ .addr = 0x0f000435c, .val = 0x00000013 },
	{ .addr = 0x0f0004360, .val = 0x0000000a },
	{ .addr = 0x0f0004364, .val = 0x0000001d },
	{ .addr = 0x0f0004368, .val = 0x00000005 },
	{ .addr = 0x0f000436c, .val = 0x0000000d },
	{ .addr = 0x0f0004370, .val = 0x0000000a },
	{ .addr = 0x0f0004374, .val = 0x0000000c },
	{ .addr = 0x0f0004378, .val = 0x00000013 },
	{ .addr = 0x0f000437c, .val = 0x00000016 },
	{ .addr = 0x0f0004380, .val = 0x0000000b },
	{ .addr = 0x0f0004384, .val = 0x00000014 },
	{ .addr = 0x0f0004388, .val = 0x0000001b },
	{ .addr = 0x0f000438c, .val = 0x0000000a },
	{ .addr = 0x0f0004390, .val = 0x00000016 },
	{ .addr = 0x0f0004394, .val = 0x00000017 },
	{ .addr = 0x0f0004398, .val = 0x00000011 },
	{ .addr = 0x0f000439c, .val = 0x0000000a },
	{ .addr = 0x0f00043a0, .val = 0x00000001 },
	{ .addr = 0x0f00043a4, .val = 0x00000011 },
	{ .addr = 0x0f00043a8, .val = 0x00000008 },
	{ .addr = 0x0f00043ac, .val = 0x00000011 },
	{ .addr = 0x0f00043b0, .val = 0x00000006 },
	{ .addr = 0x0f00043b4, .val = 0x0000001e },
	{ .addr = 0x0f00043b8, .val = 0x00000019 },
	{ .addr = 0x0f00043bc, .val = 0x0000001c },
	{ .addr = 0x0f00043c0, .val = 0x0000001d },
	{ .addr = 0x0f00043c4, .val = 0x00000016 },
	{ .addr = 0x0f00043c8, .val = 0x00000005 },
	{ .addr = 0x0f00043cc, .val = 0x00000000 },
	{ .addr = 0x0f00043d0, .val = 0x00000010 },
	{ .addr = 0x0f00043d4, .val = 0x00000002 },
	{ .addr = 0x0f00043d8, .val = 0x0000000a },
	{ .addr = 0x0f00043dc, .val = 0x00000018 },
	{ .addr = 0x0f00043e0, .val = 0x00000009 },
	{ .addr = 0x0f00043e4, .val = 0x0000000a },
	{ .addr = 0x0f00043e8, .val = 0x00000011 },
	{ .addr = 0x0f00043ec, .val = 0x00000018 },
	{ .addr = 0x0f00043f0, .val = 0x00000011 },
	{ .addr = 0x0f00043f4, .val = 0x00000001 },
	{ .addr = 0x0f00043f8, .val = 0x00000004 },
	{ .addr = 0x0f00043fc, .val = 0x00000014 },
	{ .addr = 0x0f0004400, .val = 0x5886e430 },
	{ .addr = 0x0f0004404, .val = 0x7cf6b467 },
	{ .addr = 0x0f0004408, .val = 0xeeceb0ff },
	{ .addr = 0x0f000440c, .val = 0x55d703d7 },
	{ .addr = 0x0f0004410, .val = 0xfbd14fbb },
	{ .addr = 0x0f0004414, .val = 0xeb6b8fc5 },
	{ .addr = 0x0f0004418, .val = 0x1f8c181a },
	{ .addr = 0x0f000441c, .val = 0x6a866e3e },
	{ .addr = 0x0f0004420, .val = 0x6c9dfccf },
	{ .addr = 0x0f0004424, .val = 0x77122c7c },
	{ .addr = 0x0f0004428, .val = 0x081e83fb },
	{ .addr = 0x0f000442c, .val = 0x36b2627b },
	{ .addr = 0x0f0004430, .val = 0xb29fcfad },
	{ .addr = 0x0f0004434, .val = 0x60581770 },
	{ .addr = 0x0f0004438, .val = 0x5b17b757 },
	{ .addr = 0x0f000443c, .val = 0x8fe904bb },
	{ .addr = 0x0f0004440, .val = 0x82495ea5 },
	{ .addr = 0x0f0004444, .val = 0xdaf924fe },
	{ .addr = 0x0f0004448, .val = 0x55707e2f },
	{ .addr = 0x0f000444c, .val = 0x37804399 },
	{ .addr = 0x0f0004450, .val = 0x655488e2 },
	{ .addr = 0x0f0004454, .val = 0x0ddce624 },
	{ .addr = 0x0f0004458, .val = 0x56e6f5a3 },
	{ .addr = 0x0f000445c, .val = 0x479be9e4 },
	{ .addr = 0x0f0004460, .val = 0x4c8cf237 },
	{ .addr = 0x0f0004464, .val = 0x4a37fd8b },
	{ .addr = 0x0f0004468, .val = 0x0966ac0c },
	{ .addr = 0x0f000446c, .val = 0x0b5103a1 },
	{ .addr = 0x0f0004470, .val = 0xfb3ad09a },
	{ .addr = 0x0f0004474, .val = 0xe28390fd },
	{ .addr = 0x0f0004478, .val = 0x4ffbbcd0 },
	{ .addr = 0x0f000447c, .val = 0x9599c046 },
	{ .addr = 0x0f0004500, .val = 0x1f9de016 },
	{ .addr = 0x0f0004504, .val = 0x00000905 },
	{ .addr = 0x0f0004508, .val = 0x1c39fc4a },
	{ .addr = 0x0f000450c, .val = 0x0000f4f6 },
	{ .addr = 0x0f0004510, .val = 0xc5883da0 },
	{ .addr = 0x0f0004514, .val = 0x0000b1f0 },
	{ .addr = 0x0f0004518, .val = 0x6f8e3e53 },
	{ .addr = 0x0f000451c, .val = 0x0000ca30 },
	{ .addr = 0x0f0004520, .val = 0x2b46fd4d },
	{ .addr = 0x0f0004524, .val = 0x00006b7f },
	{ .addr = 0x0f0004528, .val = 0xd91679f7 },
	{ .addr = 0x0f000452c, .val = 0x000000a4 },
	{ .addr = 0x0f0004530, .val = 0x062b3d74 },
	{ .addr = 0x0f0004534, .val = 0x00001c1a },
	{ .addr = 0x0f0004538, .val = 0xdb10286c },
	{ .addr = 0x0f000453c, .val = 0x0000703f },
	{ .addr = 0x0f0004540, .val = 0xedd4f09c },
	{ .addr = 0x0f0004544, .val = 0x00007e7d },
	{ .addr = 0x0f0004548, .val = 0xe1deda2d },
	{ .addr = 0x0f000454c, .val = 0x000029b1 },
	{ .addr = 0x0f0004550, .val = 0xef3210cd },
	{ .addr = 0x0f0004554, .val = 0x000079a4 },
	{ .addr = 0x0f0004558, .val = 0x071675fd },
	{ .addr = 0x0f000455c, .val = 0x00004a90 },
	{ .addr = 0x0f0004560, .val = 0x571a6853 },
	{ .addr = 0x0f0004564, .val = 0x0000a854 },
	{ .addr = 0x0f0004568, .val = 0x6d34de9d },
	{ .addr = 0x0f000456c, .val = 0x00005966 },
	{ .addr = 0x0f0004570, .val = 0xde4fd0c7 },
	{ .addr = 0x0f0004574, .val = 0x0000cbb3 },
	{ .addr = 0x0f0004578, .val = 0xe26ec233 },
	{ .addr = 0x0f000457c, .val = 0x000062dc },
	{ .addr = 0x0f0004580, .val = 0x6659e9aa },
	{ .addr = 0x0f0004584, .val = 0x000074cb },
	{ .addr = 0x0f0004588, .val = 0xe9a47b3c },
	{ .addr = 0x0f000458c, .val = 0x00008a33 },
	{ .addr = 0x0f0004590, .val = 0xd9a8ba95 },
	{ .addr = 0x0f0004594, .val = 0x00000ea2 },
	{ .addr = 0x0f0004598, .val = 0x1ffbe430 },
	{ .addr = 0x0f000459c, .val = 0x000038e7 },
	{ .addr = 0x0f00045a0, .val = 0x3ce284df },
	{ .addr = 0x0f00045a4, .val = 0x000099ec },
	{ .addr = 0x0f00045a8, .val = 0x5121e92d },
	{ .addr = 0x0f00045ac, .val = 0x00008851 },
	{ .addr = 0x0f00045b0, .val = 0xd1b4a52d },
	{ .addr = 0x0f00045b4, .val = 0x0000b9bd },
	{ .addr = 0x0f00045b8, .val = 0xc6376d72 },
	{ .addr = 0x0f00045bc, .val = 0x0000988c },
	{ .addr = 0x0f00045c0, .val = 0x0468ffa4 },
	{ .addr = 0x0f00045c4, .val = 0x0000ff6a },
	{ .addr = 0x0f00045c8, .val = 0xd1cf531d },
	{ .addr = 0x0f00045cc, .val = 0x0000d113 },
	{ .addr = 0x0f00045d0, .val = 0xa4e0fded },
	{ .addr = 0x0f00045d4, .val = 0x0000cfaf },
	{ .addr = 0x0f00045d8, .val = 0xd6aba5d0 },
	{ .addr = 0x0f00045dc, .val = 0x00006ded },
	{ .addr = 0x0f00045e0, .val = 0xee5aa602 },
	{ .addr = 0x0f00045e4, .val = 0x000052e8 },
	{ .addr = 0x0f00045e8, .val = 0x8c8b7128 },
	{ .addr = 0x0f00045ec, .val = 0x0000a5bd },
	{ .addr = 0x0f00045f0, .val = 0xb686ca07 },
	{ .addr = 0x0f00045f4, .val = 0x0000f65e },
	{ .addr = 0x0f00045f8, .val = 0x22d85ebf },
	{ .addr = 0x0f00045fc, .val = 0x00006ad3 },
	{ .addr = 0x0f0004600, .val = 0xe5c6c327 },
	{ .addr = 0x0f0004604, .val = 0x000058a7 },
	{ .addr = 0x0f0004608, .val = 0x981ff955 },
	{ .addr = 0x0f000460c, .val = 0x000026a2 },
	{ .addr = 0x0f0004610, .val = 0x7ad6ca34 },
	{ .addr = 0x0f0004614, .val = 0x000077e6 },
	{ .addr = 0x0f0004618, .val = 0x978a9417 },
	{ .addr = 0x0f000461c, .val = 0x0000fb36 },
	{ .addr = 0x0f0004620, .val = 0xda4b3c7d },
	{ .addr = 0x0f0004624, .val = 0x0000321b },
	{ .addr = 0x0f0004628, .val = 0x0e3016ce },
	{ .addr = 0x0f000462c, .val = 0x000063f5 },
	{ .addr = 0x0f0004630, .val = 0x0bf8abdd },
	{ .addr = 0x0f0004634, .val = 0x0000cf45 },
	{ .addr = 0x0f0004638, .val = 0x85b28eff },
	{ .addr = 0x0f000463c, .val = 0x0000de02 },
	{ .addr = 0x0f0004640, .val = 0x633934c5 },
	{ .addr = 0x0f0004644, .val = 0x0000e350 },
	{ .addr = 0x0f0004648, .val = 0x2465fa04 },
	{ .addr = 0x0f000464c, .val = 0x0000cce2 },
	{ .addr = 0x0f0004650, .val = 0x77212bb8 },
	{ .addr = 0x0f0004654, .val = 0x000015c6 },
	{ .addr = 0x0f0004658, .val = 0x08f80e32 },
	{ .addr = 0x0f000465c, .val = 0x00001980 },
	{ .addr = 0x0f0004660, .val = 0x863ae9e5 },
	{ .addr = 0x0f0004664, .val = 0x00007c61 },
	{ .addr = 0x0f0004668, .val = 0x712bf8c7 },
	{ .addr = 0x0f000466c, .val = 0x000074ab },
	{ .addr = 0x0f0004670, .val = 0x72c34790 },
	{ .addr = 0x0f0004674, .val = 0x0000358e },
	{ .addr = 0x0f0004678, .val = 0x9aee5e60 },
	{ .addr = 0x0f000467c, .val = 0x0000214e },
	{ .addr = 0x0f0004680, .val = 0x3a16c980 },
	{ .addr = 0x0f0004684, .val = 0x0000e2f1 },
	{ .addr = 0x0f0004688, .val = 0x62320432 },
	{ .addr = 0x0f000468c, .val = 0x00007abc },
	{ .addr = 0x0f0004690, .val = 0xceb635ea },
	{ .addr = 0x0f0004694, .val = 0x00000394 },
	{ .addr = 0x0f0004698, .val = 0x9773db79 },
	{ .addr = 0x0f000469c, .val = 0x0000d7b5 },
	{ .addr = 0x0f00046a0, .val = 0xea2a2093 },
	{ .addr = 0x0f00046a4, .val = 0x0000361a },
	{ .addr = 0x0f00046a8, .val = 0x74ea4c29 },
	{ .addr = 0x0f00046ac, .val = 0x0000a48d },
	{ .addr = 0x0f00046b0, .val = 0xb22cf295 },
	{ .addr = 0x0f00046b4, .val = 0x00001af8 },
	{ .addr = 0x0f00046b8, .val = 0xae3507f7 },
	{ .addr = 0x0f00046bc, .val = 0x000029ae },
	{ .addr = 0x0f00046c0, .val = 0x94655fff },
	{ .addr = 0x0f00046c4, .val = 0x000020ac },
	{ .addr = 0x0f00046c8, .val = 0xe85209fa },
	{ .addr = 0x0f00046cc, .val = 0x00000795 },
	{ .addr = 0x0f00046d0, .val = 0x9f541370 },
	{ .addr = 0x0f00046d4, .val = 0x00001565 },
	{ .addr = 0x0f00046d8, .val = 0xa458a409 },
	{ .addr = 0x0f00046dc, .val = 0x0000a3b7 },
	{ .addr = 0x0f00046e0, .val = 0x7a5ea53d },
	{ .addr = 0x0f00046e4, .val = 0x0000f0bf },
	{ .addr = 0x0f00046e8, .val = 0xa4c4f63d },
	{ .addr = 0x0f00046ec, .val = 0x0000f68a },
	{ .addr = 0x0f00046f0, .val = 0x8ad6e863 },
	{ .addr = 0x0f00046f4, .val = 0x000060ea },
	{ .addr = 0x0f00046f8, .val = 0x8be8c105 },
	{ .addr = 0x0f00046fc, .val = 0x0000d728 },
	{ .addr = 0x0f0004700, .val = 0xe3f0f162 },
	{ .addr = 0x0f0004704, .val = 0x000039c6 },
	{ .addr = 0x0f0004708, .val = 0xc030058b },
	{ .addr = 0x0f000470c, .val = 0x000037c5 },
	{ .addr = 0x0f0004710, .val = 0x121719b2 },
	{ .addr = 0x0f0004714, .val = 0x00005a31 },
	{ .addr = 0x0f0004718, .val = 0x559bddb3 },
	{ .addr = 0x0f000471c, .val = 0x00000ec0 },
	{ .addr = 0x0f0004720, .val = 0x512b2475 },
	{ .addr = 0x0f0004724, .val = 0x0000a306 },
	{ .addr = 0x0f0004728, .val = 0x590f56b4 },
	{ .addr = 0x0f000472c, .val = 0x0000efea },
	{ .addr = 0x0f0004730, .val = 0x3332da7d },
	{ .addr = 0x0f0004734, .val = 0x00004b08 },
	{ .addr = 0x0f0004738, .val = 0xef368a3f },
	{ .addr = 0x0f000473c, .val = 0x0000ce80 },
	{ .addr = 0x0f0004740, .val = 0x6bc828cb },
	{ .addr = 0x0f0004744, .val = 0x000064fc },
	{ .addr = 0x0f0004748, .val = 0xb69a7fd3 },
	{ .addr = 0x0f000474c, .val = 0x0000555c },
	{ .addr = 0x0f0004750, .val = 0x6db84b92 },
	{ .addr = 0x0f0004754, .val = 0x00003eb1 },
	{ .addr = 0x0f0004758, .val = 0x64ad10b0 },
	{ .addr = 0x0f000475c, .val = 0x00007e6c },
	{ .addr = 0x0f0004760, .val = 0xaf3c1f6a },
	{ .addr = 0x0f0004764, .val = 0x0000125a },
	{ .addr = 0x0f0004768, .val = 0x1ad1e4d6 },
	{ .addr = 0x0f000476c, .val = 0x00000ae5 },
	{ .addr = 0x0f0004770, .val = 0x6118f8d0 },
	{ .addr = 0x0f0004774, .val = 0x0000492b },
	{ .addr = 0x0f0004778, .val = 0x6d88ddde },
	{ .addr = 0x0f000477c, .val = 0x000082f1 },
	{ .addr = 0x0f0004780, .val = 0x9e844cc6 },
	{ .addr = 0x0f0004784, .val = 0x00002239 },
	{ .addr = 0x0f0004788, .val = 0xc888a7b9 },
	{ .addr = 0x0f000478c, .val = 0x0000f66a },
	{ .addr = 0x0f0004790, .val = 0x8a00a863 },
	{ .addr = 0x0f0004794, .val = 0x0000e54c },
	{ .addr = 0x0f0004798, .val = 0x9eeb5b64 },
	{ .addr = 0x0f000479c, .val = 0x00006ec1 },
	{ .addr = 0x0f00047a0, .val = 0x16f8c966 },
	{ .addr = 0x0f00047a4, .val = 0x0000c8b9 },
	{ .addr = 0x0f00047a8, .val = 0x2ee4d1e1 },
	{ .addr = 0x0f00047ac, .val = 0x00002a48 },
	{ .addr = 0x0f00047b0, .val = 0x7e062f9d },
	{ .addr = 0x0f00047b4, .val = 0x00008fa7 },
	{ .addr = 0x0f00047b8, .val = 0xc0c4ef8a },
	{ .addr = 0x0f00047bc, .val = 0x00007f71 },
	{ .addr = 0x0f00047c0, .val = 0x090a8cd4 },
	{ .addr = 0x0f00047c4, .val = 0x00001b37 },
	{ .addr = 0x0f00047c8, .val = 0xddd3c80b },
	{ .addr = 0x0f00047cc, .val = 0x0000f5ec },
	{ .addr = 0x0f00047d0, .val = 0x753bfebd },
	{ .addr = 0x0f00047d4, .val = 0x0000e926 },
	{ .addr = 0x0f00047d8, .val = 0x977f7f73 },
	{ .addr = 0x0f00047dc, .val = 0x000043f8 },
	{ .addr = 0x0f00047e0, .val = 0xddc993d9 },
	{ .addr = 0x0f00047e4, .val = 0x0000f80c },
	{ .addr = 0x0f00047e8, .val = 0x38cc42a7 },
	{ .addr = 0x0f00047ec, .val = 0x000017c8 },
	{ .addr = 0x0f00047f0, .val = 0xb2e317e9 },
	{ .addr = 0x0f00047f4, .val = 0x00008798 },
	{ .addr = 0x0f00047f8, .val = 0xdec19b9b },
	{ .addr = 0x0f00047fc, .val = 0x0000a031 },
	{ .addr = 0x0f0004800, .val = 0x0d2d4788 },
	{ .addr = 0x0f0004804, .val = 0x0000462a },
	{ .addr = 0x0f0004808, .val = 0x4b316ba6 },
	{ .addr = 0x0f000480c, .val = 0x00008ddf },
	{ .addr = 0x0f0004810, .val = 0x9e9548c4 },
	{ .addr = 0x0f0004814, .val = 0x00009887 },
	{ .addr = 0x0f0004818, .val = 0xcdf8cad8 },
	{ .addr = 0x0f000481c, .val = 0x00001669 },
	{ .addr = 0x0f0004820, .val = 0xc37521cb },
	{ .addr = 0x0f0004824, .val = 0x000040a0 },
	{ .addr = 0x0f0004828, .val = 0x35a3af7c },
	{ .addr = 0x0f000482c, .val = 0x0000c292 },
	{ .addr = 0x0f0004830, .val = 0x988b12bd },
	{ .addr = 0x0f0004834, .val = 0x000018d6 },
	{ .addr = 0x0f0004838, .val = 0x45a221eb },
	{ .addr = 0x0f000483c, .val = 0x00001a43 },
	{ .addr = 0x0f0004840, .val = 0xbda0cab6 },
	{ .addr = 0x0f0004844, .val = 0x00002fb4 },
	{ .addr = 0x0f0004848, .val = 0x1fdd2000 },
	{ .addr = 0x0f000484c, .val = 0x0000bcc6 },
	{ .addr = 0x0f0004850, .val = 0x095e0828 },
	{ .addr = 0x0f0004854, .val = 0x0000dfe6 },
	{ .addr = 0x0f0004858, .val = 0x4380a620 },
	{ .addr = 0x0f000485c, .val = 0x0000be95 },
	{ .addr = 0x0f0004860, .val = 0xc010c521 },
	{ .addr = 0x0f0004864, .val = 0x0000cf91 },
	{ .addr = 0x0f0004868, .val = 0x971740ef },
	{ .addr = 0x0f000486c, .val = 0x00009882 },
	{ .addr = 0x0f0004870, .val = 0x75a1dcbf },
	{ .addr = 0x0f0004874, .val = 0x0000264e },
	{ .addr = 0x0f0004878, .val = 0xfd2ca6c9 },
	{ .addr = 0x0f000487c, .val = 0x00002947 },
	{ .addr = 0x0f0004880, .val = 0x7f296264 },
	{ .addr = 0x0f0004884, .val = 0x00001e6d },
	{ .addr = 0x0f0004888, .val = 0xe70f42a5 },
	{ .addr = 0x0f000488c, .val = 0x00006e2a },
	{ .addr = 0x0f0004890, .val = 0xb39df34c },
	{ .addr = 0x0f0004894, .val = 0x00005970 },
	{ .addr = 0x0f0004898, .val = 0x56e55e85 },
	{ .addr = 0x0f000489c, .val = 0x000040b2 },
	{ .addr = 0x0f00048a0, .val = 0xf97651e0 },
	{ .addr = 0x0f00048a4, .val = 0x0000f3cd },
	{ .addr = 0x0f00048a8, .val = 0xcf04abe4 },
	{ .addr = 0x0f00048ac, .val = 0x0000d4e6 },
	{ .addr = 0x0f00048b0, .val = 0xe4fe55a8 },
	{ .addr = 0x0f00048b4, .val = 0x0000ef21 },
	{ .addr = 0x0f00048b8, .val = 0xf699af52 },
	{ .addr = 0x0f00048bc, .val = 0x00004ebe },
	{ .addr = 0x0f00048c0, .val = 0xbbf1c887 },
	{ .addr = 0x0f00048c4, .val = 0x00000e71 },
	{ .addr = 0x0f00048c8, .val = 0x06ac0185 },
	{ .addr = 0x0f00048cc, .val = 0x0000c55a },
	{ .addr = 0x0f00048d0, .val = 0x83c2c11a },
	{ .addr = 0x0f00048d4, .val = 0x0000af4d },
	{ .addr = 0x0f00048d8, .val = 0xd0bde98f },
	{ .addr = 0x0f00048dc, .val = 0x0000726b },
	{ .addr = 0x0f00048e0, .val = 0x9fa54c5d },
	{ .addr = 0x0f00048e4, .val = 0x0000ccee },
	{ .addr = 0x0f00048e8, .val = 0xc17966de },
	{ .addr = 0x0f00048ec, .val = 0x0000259d },
	{ .addr = 0x0f00048f0, .val = 0x0aab47d6 },
	{ .addr = 0x0f00048f4, .val = 0x0000b30a },
	{ .addr = 0x0f00048f8, .val = 0x439290c8 },
	{ .addr = 0x0f00048fc, .val = 0x00003b94 },
	{ .addr = 0x0f0004900, .val = 0xdfbb33c2 },
	{ .addr = 0x0f0004904, .val = 0x00007b42 },
	{ .addr = 0x0f0004908, .val = 0x80811520 },
	{ .addr = 0x0f000490c, .val = 0x00001de1 },
	{ .addr = 0x0f0004910, .val = 0x51fc1451 },
	{ .addr = 0x0f0004914, .val = 0x0000501c },
	{ .addr = 0x0f0004918, .val = 0x270941cd },
	{ .addr = 0x0f000491c, .val = 0x00007968 },
	{ .addr = 0x0f0004920, .val = 0x6ef8acf2 },
	{ .addr = 0x0f0004924, .val = 0x00000b02 },
	{ .addr = 0x0f0004928, .val = 0xaabbbf76 },
	{ .addr = 0x0f000492c, .val = 0x0000329f },
	{ .addr = 0x0f0004930, .val = 0xd6f4dd30 },
	{ .addr = 0x0f0004934, .val = 0x0000be21 },
	{ .addr = 0x0f0004938, .val = 0x934ce449 },
	{ .addr = 0x0f000493c, .val = 0x0000a3d7 },
	{ .addr = 0x0f0004940, .val = 0x42ad4f76 },
	{ .addr = 0x0f0004944, .val = 0x00001c73 },
	{ .addr = 0x0f0004948, .val = 0xe2c349b7 },
	{ .addr = 0x0f000494c, .val = 0x00006793 },
	{ .addr = 0x0f0004950, .val = 0x68814b2f },
	{ .addr = 0x0f0004954, .val = 0x0000680a },
	{ .addr = 0x0f0004958, .val = 0x07a19515 },
	{ .addr = 0x0f000495c, .val = 0x00004af9 },
	{ .addr = 0x0f0004960, .val = 0xdb6319dc },
	{ .addr = 0x0f0004964, .val = 0x000067c8 },
	{ .addr = 0x0f0004968, .val = 0x4cda161f },
	{ .addr = 0x0f000496c, .val = 0x000023f0 },
	{ .addr = 0x0f0004970, .val = 0xf28bd936 },
	{ .addr = 0x0f0004974, .val = 0x0000f7d8 },
	{ .addr = 0x0f0004978, .val = 0x46dde2e0 },
	{ .addr = 0x0f000497c, .val = 0x000048a1 },
	{ .addr = 0x0f0004980, .val = 0x585ead2e },
	{ .addr = 0x0f0004984, .val = 0x00000054 },
	{ .addr = 0x0f0004988, .val = 0xb2fdb459 },
	{ .addr = 0x0f000498c, .val = 0x000095d5 },
	{ .addr = 0x0f0004990, .val = 0xc7e4293f },
	{ .addr = 0x0f0004994, .val = 0x00007a23 },
	{ .addr = 0x0f0004998, .val = 0x70952499 },
	{ .addr = 0x0f000499c, .val = 0x0000bb54 },
	{ .addr = 0x0f00049a0, .val = 0x50e8e14c },
	{ .addr = 0x0f00049a4, .val = 0x00001251 },
	{ .addr = 0x0f00049a8, .val = 0x94e1dc6c },
	{ .addr = 0x0f00049ac, .val = 0x0000fd0f },
	{ .addr = 0x0f00049b0, .val = 0xddfa5a9b },
	{ .addr = 0x0f00049b4, .val = 0x0000b093 },
	{ .addr = 0x0f00049b8, .val = 0x5037b28a },
	{ .addr = 0x0f00049bc, .val = 0x00005b16 },
	{ .addr = 0x0f00049c0, .val = 0xa015b9e3 },
	{ .addr = 0x0f00049c4, .val = 0x0000a9d0 },
	{ .addr = 0x0f00049c8, .val = 0x069b8fbf },
	{ .addr = 0x0f00049cc, .val = 0x000007db },
	{ .addr = 0x0f00049d0, .val = 0x5ebc65d7 },
	{ .addr = 0x0f00049d4, .val = 0x00007c37 },
	{ .addr = 0x0f00049d8, .val = 0x3ce9b025 },
	{ .addr = 0x0f00049dc, .val = 0x0000a855 },
	{ .addr = 0x0f00049e0, .val = 0x02519385 },
	{ .addr = 0x0f00049e4, .val = 0x00000a2a },
	{ .addr = 0x0f00049e8, .val = 0x047be366 },
	{ .addr = 0x0f00049ec, .val = 0x00005e08 },
	{ .addr = 0x0f00049f0, .val = 0x96984964 },
	{ .addr = 0x0f00049f4, .val = 0x0000ae23 },
	{ .addr = 0x0f00049f8, .val = 0xad6dec83 },
	{ .addr = 0x0f00049fc, .val = 0x0000a6f3 },
	{ .addr = 0x0f0004a00, .val = 0x41722d55 },
	{ .addr = 0x0f0004a04, .val = 0x0000f236 },
	{ .addr = 0x0f0004a08, .val = 0xe676c603 },
	{ .addr = 0x0f0004a0c, .val = 0x00003d5c },
	{ .addr = 0x0f0004a10, .val = 0x73250746 },
	{ .addr = 0x0f0004a14, .val = 0x0000aabe },
	{ .addr = 0x0f0004a18, .val = 0x49e8c08f },
	{ .addr = 0x0f0004a1c, .val = 0x0000b19d },
	{ .addr = 0x0f0004a20, .val = 0x051f7fe2 },
	{ .addr = 0x0f0004a24, .val = 0x00000cfd },
	{ .addr = 0x0f0004a28, .val = 0x17e0ee66 },
	{ .addr = 0x0f0004a2c, .val = 0x000015d9 },
	{ .addr = 0x0f0004a30, .val = 0xad2d9e0f },
	{ .addr = 0x0f0004a34, .val = 0x0000abe8 },
	{ .addr = 0x0f0004a38, .val = 0x47aa6072 },
	{ .addr = 0x0f0004a3c, .val = 0x00009664 },
	{ .addr = 0x0f0004a40, .val = 0x294aed06 },
	{ .addr = 0x0f0004a44, .val = 0x0000ec30 },
	{ .addr = 0x0f0004a48, .val = 0xbafb3e53 },
	{ .addr = 0x0f0004a4c, .val = 0x00009d7a },
	{ .addr = 0x0f0004a50, .val = 0x19b891e1 },
	{ .addr = 0x0f0004a54, .val = 0x00004700 },
	{ .addr = 0x0f0004a58, .val = 0x9993582e },
	{ .addr = 0x0f0004a5c, .val = 0x0000afe0 },
	{ .addr = 0x0f0004a60, .val = 0xf6fe44a6 },
	{ .addr = 0x0f0004a64, .val = 0x00002e10 },
	{ .addr = 0x0f0004a68, .val = 0x64c6535e },
	{ .addr = 0x0f0004a6c, .val = 0x0000f2c1 },
	{ .addr = 0x0f0004a70, .val = 0xcab2dc3a },
	{ .addr = 0x0f0004a74, .val = 0x00005561 },
	{ .addr = 0x0f0004a78, .val = 0x5b4ecc5b },
	{ .addr = 0x0f0004a7c, .val = 0x00001580 },
	{ .addr = 0x0f0004a80, .val = 0x019a9e06 },
	{ .addr = 0x0f0004a84, .val = 0x000001bc },
	{ .addr = 0x0f0004a88, .val = 0x15e56f84 },
	{ .addr = 0x0f0004a8c, .val = 0x00009a52 },
	{ .addr = 0x0f0004a90, .val = 0xe6e573cb },
	{ .addr = 0x0f0004a94, .val = 0x0000d8cd },
	{ .addr = 0x0f0004a98, .val = 0x0aea8dbe },
	{ .addr = 0x0f0004a9c, .val = 0x0000b1f7 },
	{ .addr = 0x0f0004aa0, .val = 0xdb77287c },
	{ .addr = 0x0f0004aa4, .val = 0x00005f88 },
	{ .addr = 0x0f0004aa8, .val = 0x55dd8ce1 },
	{ .addr = 0x0f0004aac, .val = 0x00001500 },
	{ .addr = 0x0f0004ab0, .val = 0x8d8a0a72 },
	{ .addr = 0x0f0004ab4, .val = 0x0000efc3 },
	{ .addr = 0x0f0004ab8, .val = 0xf897b489 },
	{ .addr = 0x0f0004abc, .val = 0x00002122 },
	{ .addr = 0x0f0004ac0, .val = 0x5fa5156b },
	{ .addr = 0x0f0004ac4, .val = 0x0000cad4 },
	{ .addr = 0x0f0004ac8, .val = 0x357e11e4 },
	{ .addr = 0x0f0004acc, .val = 0x00002594 },
	{ .addr = 0x0f0004ad0, .val = 0xd69314c0 },
	{ .addr = 0x0f0004ad4, .val = 0x00009193 },
	{ .addr = 0x0f0004ad8, .val = 0x64fa0c28 },
	{ .addr = 0x0f0004adc, .val = 0x0000cbef },
	{ .addr = 0x0f0004ae0, .val = 0xfbdf9a49 },
	{ .addr = 0x0f0004ae4, .val = 0x00008996 },
	{ .addr = 0x0f0004ae8, .val = 0xa7382348 },
	{ .addr = 0x0f0004aec, .val = 0x00008ffd },
	{ .addr = 0x0f0004af0, .val = 0x5731cbb9 },
	{ .addr = 0x0f0004af4, .val = 0x0000cfb6 },
	{ .addr = 0x0f0004af8, .val = 0xa98ca75f },
	{ .addr = 0x0f0004afc, .val = 0x0000e1c3 },
	{ .addr = 0x0f0004b00, .val = 0xca7d02cc },
	{ .addr = 0x0f0004b04, .val = 0x0000e6e0 },
	{ .addr = 0x0f0004b08, .val = 0xe2a5ab63 },
	{ .addr = 0x0f0004b0c, .val = 0x0000026e },
	{ .addr = 0x0f0004b10, .val = 0x3acad4b4 },
	{ .addr = 0x0f0004b14, .val = 0x0000ff51 },
	{ .addr = 0x0f0004b18, .val = 0x474cc9c4 },
	{ .addr = 0x0f0004b1c, .val = 0x0000652f },
	{ .addr = 0x0f0004b20, .val = 0xc7f1ff83 },
	{ .addr = 0x0f0004b24, .val = 0x00006391 },
	{ .addr = 0x0f0004b28, .val = 0xe8c40bec },
	{ .addr = 0x0f0004b2c, .val = 0x00002825 },
	{ .addr = 0x0f0004b30, .val = 0x7c97fe22 },
	{ .addr = 0x0f0004b34, .val = 0x0000fdf1 },
	{ .addr = 0x0f0004b38, .val = 0xaa49155f },
	{ .addr = 0x0f0004b3c, .val = 0x000083d6 },
	{ .addr = 0x0f0004b40, .val = 0xaafe891e },
	{ .addr = 0x0f0004b44, .val = 0x00008206 },
	{ .addr = 0x0f0004b48, .val = 0x84abbd7e },
	{ .addr = 0x0f0004b4c, .val = 0x00004e8d },
	{ .addr = 0x0f0004b50, .val = 0xe1e81a8f },
	{ .addr = 0x0f0004b54, .val = 0x0000224d },
	{ .addr = 0x0f0004b58, .val = 0xf350be6f },
	{ .addr = 0x0f0004b5c, .val = 0x00007f68 },
	{ .addr = 0x0f0004b60, .val = 0x6c40033d },
	{ .addr = 0x0f0004b64, .val = 0x00001358 },
	{ .addr = 0x0f0004b68, .val = 0x36dc18f5 },
	{ .addr = 0x0f0004b6c, .val = 0x00004cb6 },
	{ .addr = 0x0f0004b70, .val = 0xab9a7946 },
	{ .addr = 0x0f0004b74, .val = 0x0000345f },
	{ .addr = 0x0f0004b78, .val = 0x14a9cc4d },
	{ .addr = 0x0f0004b7c, .val = 0x000015c2 },
	{ .addr = 0x0f0004b80, .val = 0xcf1937de },
	{ .addr = 0x0f0004b84, .val = 0x00009eb1 },
	{ .addr = 0x0f0004b88, .val = 0x1d3f6ee1 },
	{ .addr = 0x0f0004b8c, .val = 0x0000dd7a },
	{ .addr = 0x0f0004b90, .val = 0x967811b4 },
	{ .addr = 0x0f0004b94, .val = 0x0000aa86 },
	{ .addr = 0x0f0004b98, .val = 0xe3a849e4 },
	{ .addr = 0x0f0004b9c, .val = 0x00007043 },
	{ .addr = 0x0f0004ba0, .val = 0x4f77b54e },
	{ .addr = 0x0f0004ba4, .val = 0x0000446a },
	{ .addr = 0x0f0004ba8, .val = 0xbfcb92af },
	{ .addr = 0x0f0004bac, .val = 0x0000f74a },
	{ .addr = 0x0f0004bb0, .val = 0x4947112d },
	{ .addr = 0x0f0004bb4, .val = 0x0000c7c0 },
	{ .addr = 0x0f0004bb8, .val = 0x68683f6f },
	{ .addr = 0x0f0004bbc, .val = 0x00004bc9 },
	{ .addr = 0x0f0004bc0, .val = 0x51774b8f },
	{ .addr = 0x0f0004bc4, .val = 0x00002bdf },
	{ .addr = 0x0f0004bc8, .val = 0x7717690e },
	{ .addr = 0x0f0004bcc, .val = 0x00003360 },
	{ .addr = 0x0f0004bd0, .val = 0xbdaaf39a },
	{ .addr = 0x0f0004bd4, .val = 0x000089c8 },
	{ .addr = 0x0f0004bd8, .val = 0x663ab0f0 },
	{ .addr = 0x0f0004bdc, .val = 0x0000e608 },
	{ .addr = 0x0f0004be0, .val = 0xf45ca1e9 },
	{ .addr = 0x0f0004be4, .val = 0x0000aeb1 },
	{ .addr = 0x0f0004be8, .val = 0xeb62b333 },
	{ .addr = 0x0f0004bec, .val = 0x0000fed3 },
	{ .addr = 0x0f0004bf0, .val = 0x0b9455ef },
	{ .addr = 0x0f0004bf4, .val = 0x00003239 },
	{ .addr = 0x0f0004bf8, .val = 0x95567bfa },
	{ .addr = 0x0f0004bfc, .val = 0x0000fdb4 },
	{ .addr = 0x0f0004c00, .val = 0xc058eb2d },
	{ .addr = 0x0f0004c04, .val = 0x00006197 },
	{ .addr = 0x0f0004c08, .val = 0x93cabd29 },
	{ .addr = 0x0f0004c0c, .val = 0x00007804 },
	{ .addr = 0x0f0004c10, .val = 0x0e2b3f3e },
	{ .addr = 0x0f0004c14, .val = 0x0000b00f },
	{ .addr = 0x0f0004c18, .val = 0xf0eb2b90 },
	{ .addr = 0x0f0004c1c, .val = 0x00000a71 },
	{ .addr = 0x0f0004c20, .val = 0x1eed8736 },
	{ .addr = 0x0f0004c24, .val = 0x00006149 },
	{ .addr = 0x0f0004c28, .val = 0x5aa8cd0d },
	{ .addr = 0x0f0004c2c, .val = 0x0000af40 },
	{ .addr = 0x0f0004c30, .val = 0x8382db80 },
	{ .addr = 0x0f0004c34, .val = 0x000094ed },
	{ .addr = 0x0f0004c38, .val = 0xafda2e36 },
	{ .addr = 0x0f0004c3c, .val = 0x0000296c },
	{ .addr = 0x0f0004c40, .val = 0x691e0dea },
	{ .addr = 0x0f0004c44, .val = 0x00003cef },
	{ .addr = 0x0f0004c48, .val = 0xa936e79b },
	{ .addr = 0x0f0004c4c, .val = 0x0000120f },
	{ .addr = 0x0f0004c50, .val = 0x0d52d9f2 },
	{ .addr = 0x0f0004c54, .val = 0x0000556f },
	{ .addr = 0x0f0004c58, .val = 0xd55a1a75 },
	{ .addr = 0x0f0004c5c, .val = 0x000063e1 },
	{ .addr = 0x0f0004c60, .val = 0xd8e5de35 },
	{ .addr = 0x0f0004c64, .val = 0x000024c2 },
	{ .addr = 0x0f0004c68, .val = 0x7eb1588d },
	{ .addr = 0x0f0004c6c, .val = 0x0000e90b },
	{ .addr = 0x0f0004c70, .val = 0x35e801f6 },
	{ .addr = 0x0f0004c74, .val = 0x00000bcc },
	{ .addr = 0x0f0004c78, .val = 0xaba9cb3a },
	{ .addr = 0x0f0004c7c, .val = 0x0000a41d },
	{ .addr = 0x0f0004c80, .val = 0x28b4d7aa },
	{ .addr = 0x0f0004c84, .val = 0x00009a9e },
	{ .addr = 0x0f0004c88, .val = 0xa87cafdd },
	{ .addr = 0x0f0004c8c, .val = 0x0000e463 },
	{ .addr = 0x0f0004c90, .val = 0x7c692db4 },
	{ .addr = 0x0f0004c94, .val = 0x0000fd94 },
	{ .addr = 0x0f0004c98, .val = 0xe141f665 },
	{ .addr = 0x0f0004c9c, .val = 0x00006bd0 },
	{ .addr = 0x0f0004ca0, .val = 0x4a382469 },
	{ .addr = 0x0f0004ca4, .val = 0x0000f811 },
	{ .addr = 0x0f0004ca8, .val = 0x3accee70 },
	{ .addr = 0x0f0004cac, .val = 0x00007d37 },
	{ .addr = 0x0f0004cb0, .val = 0xc6531c3e },
	{ .addr = 0x0f0004cb4, .val = 0x0000ef3d },
	{ .addr = 0x0f0004cb8, .val = 0x7a8e83e8 },
	{ .addr = 0x0f0004cbc, .val = 0x0000d9b6 },
	{ .addr = 0x0f0004cc0, .val = 0x173077fe },
	{ .addr = 0x0f0004cc4, .val = 0x0000a896 },
	{ .addr = 0x0f0004cc8, .val = 0x53b1298e },
	{ .addr = 0x0f0004ccc, .val = 0x0000f686 },
	{ .addr = 0x0f0004cd0, .val = 0xde616ae9 },
	{ .addr = 0x0f0004cd4, .val = 0x0000521c },
	{ .addr = 0x0f0004cd8, .val = 0x6a4a785c },
	{ .addr = 0x0f0004cdc, .val = 0x00008062 },
	{ .addr = 0x0f0004ce0, .val = 0xf8ee7f41 },
	{ .addr = 0x0f0004ce4, .val = 0x0000d949 },
	{ .addr = 0x0f0004ce8, .val = 0x157b8aad },
	{ .addr = 0x0f0004cec, .val = 0x00009bd5 },
	{ .addr = 0x0f0004cf0, .val = 0xe90e1acc },
	{ .addr = 0x0f0004cf4, .val = 0x0000fc8d },
	{ .addr = 0x0f0004cf8, .val = 0x127b9f72 },
	{ .addr = 0x0f0004cfc, .val = 0x0000bd0d },
	{ .addr = 0x0f0004d00, .val = 0x98737e37 },
	{ .addr = 0x0f0004d04, .val = 0x000000b3 },
	{ .addr = 0x0f0004d08, .val = 0x7fa3c7a0 },
	{ .addr = 0x0f0004d0c, .val = 0x0000009e },
	{ .addr = 0x0f0004d10, .val = 0x8292a557 },
	{ .addr = 0x0f0004d14, .val = 0x00000068 },
	{ .addr = 0x0f0004d18, .val = 0x994fd504 },
	{ .addr = 0x0f0004d1c, .val = 0x000000d9 },
	{ .addr = 0x0f0004d20, .val = 0x59a4376c },
	{ .addr = 0x0f0004d24, .val = 0x000000fa },
	{ .addr = 0x0f0004d28, .val = 0x70199eb7 },
	{ .addr = 0x0f0004d2c, .val = 0x00000062 },
	{ .addr = 0x0f0004d30, .val = 0xad0da609 },
	{ .addr = 0x0f0004d34, .val = 0x0000001f },
	{ .addr = 0x0f0004d38, .val = 0x30e34cc0 },
	{ .addr = 0x0f0004d3c, .val = 0x0000009d },
	{ .addr = 0x0f0004d40, .val = 0x6bdcd783 },
	{ .addr = 0x0f0004d44, .val = 0x00000062 },
	{ .addr = 0x0f0004d48, .val = 0x6220a66c },
	{ .addr = 0x0f0004d4c, .val = 0x00000008 },
	{ .addr = 0x0f0004d50, .val = 0x141d4009 },
	{ .addr = 0x0f0004d54, .val = 0x000000ac },
	{ .addr = 0x0f0004d58, .val = 0x52223eab },
	{ .addr = 0x0f0004d5c, .val = 0x00000037 },
	{ .addr = 0x0f0004d60, .val = 0x3aabd48a },
	{ .addr = 0x0f0004d64, .val = 0x0000007f },
	{ .addr = 0x0f0004d68, .val = 0x44216b8f },
	{ .addr = 0x0f0004d6c, .val = 0x00000074 },
	{ .addr = 0x0f0004d70, .val = 0xcace4278 },
	{ .addr = 0x0f0004d74, .val = 0x000000e3 },
	{ .addr = 0x0f0004d78, .val = 0xaf91aaa0 },
	{ .addr = 0x0f0004d7c, .val = 0x000000bf },
	{ .addr = 0x0f0004d80, .val = 0xee669adf },
	{ .addr = 0x0f0004d84, .val = 0x000000ee },
	{ .addr = 0x0f0004d88, .val = 0x2dcd7608 },
	{ .addr = 0x0f0004d8c, .val = 0x00000062 },
	{ .addr = 0x0f0004d90, .val = 0x1f2d4de8 },
	{ .addr = 0x0f0004d94, .val = 0x000000d7 },
	{ .addr = 0x0f0004d98, .val = 0xa393f500 },
	{ .addr = 0x0f0004d9c, .val = 0x000000b6 },
	{ .addr = 0x0f0004da0, .val = 0xefee2c65 },
	{ .addr = 0x0f0004da4, .val = 0x000000f4 },
	{ .addr = 0x0f0004da8, .val = 0x84850676 },
	{ .addr = 0x0f0004dac, .val = 0x000000d8 },
	{ .addr = 0x0f0004db0, .val = 0x034fed53 },
	{ .addr = 0x0f0004db4, .val = 0x000000eb },
	{ .addr = 0x0f0004db8, .val = 0x1845042f },
	{ .addr = 0x0f0004dbc, .val = 0x000000ec },
	{ .addr = 0x0f0004dc0, .val = 0x69abb174 },
	{ .addr = 0x0f0004dc4, .val = 0x00000088 },
	{ .addr = 0x0f0004dc8, .val = 0x95115f40 },
	{ .addr = 0x0f0004dcc, .val = 0x000000a7 },
	{ .addr = 0x0f0004dd0, .val = 0x2d6341f0 },
	{ .addr = 0x0f0004dd4, .val = 0x000000c2 },
	{ .addr = 0x0f0004dd8, .val = 0xec949dc6 },
	{ .addr = 0x0f0004ddc, .val = 0x00000036 },
	{ .addr = 0x0f0004de0, .val = 0x30106ab7 },
	{ .addr = 0x0f0004de4, .val = 0x00000034 },
	{ .addr = 0x0f0004de8, .val = 0xa73e6356 },
	{ .addr = 0x0f0004dec, .val = 0x00000099 },
	{ .addr = 0x0f0004df0, .val = 0x340c5221 },
	{ .addr = 0x0f0004df4, .val = 0x000000d7 },
	{ .addr = 0x0f0004df8, .val = 0x225b2b0f },
	{ .addr = 0x0f0004dfc, .val = 0x000000c4 },
	{ .addr = 0x0f0004e00, .val = 0x67c65b97 },
	{ .addr = 0x0f0004e04, .val = 0x000000b8 },
	{ .addr = 0x0f0004e08, .val = 0x4fcbb36c },
	{ .addr = 0x0f0004e0c, .val = 0x0000000c },
	{ .addr = 0x0f0004e10, .val = 0x17eb919e },
	{ .addr = 0x0f0004e14, .val = 0x00000075 },
	{ .addr = 0x0f0004e18, .val = 0x293f5e4c },
	{ .addr = 0x0f0004e1c, .val = 0x000000ce },
	{ .addr = 0x0f0004e20, .val = 0x2a17ec77 },
	{ .addr = 0x0f0004e24, .val = 0x00000004 },
	{ .addr = 0x0f0004e28, .val = 0x4d49d725 },
	{ .addr = 0x0f0004e2c, .val = 0x000000f8 },
	{ .addr = 0x0f0004e30, .val = 0xdcfba4a1 },
	{ .addr = 0x0f0004e34, .val = 0x000000aa },
	{ .addr = 0x0f0004e38, .val = 0xd5065239 },
	{ .addr = 0x0f0004e3c, .val = 0x00000031 },
	{ .addr = 0x0f0004e40, .val = 0xee53936e },
	{ .addr = 0x0f0004e44, .val = 0x000000d1 },
	{ .addr = 0x0f0004e48, .val = 0xc31fd71f },
	{ .addr = 0x0f0004e4c, .val = 0x00000049 },
	{ .addr = 0x0f0004e50, .val = 0xc2d0dd9b },
	{ .addr = 0x0f0004e54, .val = 0x0000000c },
	{ .addr = 0x0f0004e58, .val = 0x838477d8 },
	{ .addr = 0x0f0004e5c, .val = 0x000000c6 },
	{ .addr = 0x0f0004e60, .val = 0x7703cb9a },
	{ .addr = 0x0f0004e64, .val = 0x000000de },
	{ .addr = 0x0f0004e68, .val = 0x26c7506d },
	{ .addr = 0x0f0004e6c, .val = 0x00000083 },
	{ .addr = 0x0f0004e70, .val = 0xbdbb4306 },
	{ .addr = 0x0f0004e74, .val = 0x000000fa },
	{ .addr = 0x0f0004e78, .val = 0xe3c2969a },
	{ .addr = 0x0f0004e7c, .val = 0x000000d9 },
	{ .addr = 0x0f0004e80, .val = 0x7439f299 },
	{ .addr = 0x0f0004e84, .val = 0x000000ae },
	{ .addr = 0x0f0004e88, .val = 0x253259a7 },
	{ .addr = 0x0f0004e8c, .val = 0x00000069 },
	{ .addr = 0x0f0004e90, .val = 0x3c3ba1b1 },
	{ .addr = 0x0f0004e94, .val = 0x000000c9 },
	{ .addr = 0x0f0004e98, .val = 0x1d987309 },
	{ .addr = 0x0f0004e9c, .val = 0x000000d4 },
	{ .addr = 0x0f0004ea0, .val = 0xc4cc9bc9 },
	{ .addr = 0x0f0004ea4, .val = 0x000000d0 },
	{ .addr = 0x0f0004ea8, .val = 0x34aa2544 },
	{ .addr = 0x0f0004eac, .val = 0x0000003d },
	{ .addr = 0x0f0004eb0, .val = 0x1c5879c6 },
	{ .addr = 0x0f0004eb4, .val = 0x000000d5 },
	{ .addr = 0x0f0004eb8, .val = 0x4b2f329e },
	{ .addr = 0x0f0004ebc, .val = 0x0000001e },
	{ .addr = 0x0f0004ec0, .val = 0xff7e9d86 },
	{ .addr = 0x0f0004ec4, .val = 0x00000011 },
	{ .addr = 0x0f0004ec8, .val = 0x96fa6e77 },
	{ .addr = 0x0f0004ecc, .val = 0x0000006a },
	{ .addr = 0x0f0004ed0, .val = 0xbb595691 },
	{ .addr = 0x0f0004ed4, .val = 0x000000ae },
	{ .addr = 0x0f0004ed8, .val = 0x00c99c3a },
	{ .addr = 0x0f0004edc, .val = 0x00000087 },
	{ .addr = 0x0f0004ee0, .val = 0xb1c8d857 },
	{ .addr = 0x0f0004ee4, .val = 0x0000007b },
	{ .addr = 0x0f0004ee8, .val = 0x01107364 },
	{ .addr = 0x0f0004eec, .val = 0x00000014 },
	{ .addr = 0x0f0004ef0, .val = 0xb36a24e8 },
	{ .addr = 0x0f0004ef4, .val = 0x000000c2 },
	{ .addr = 0x0f0004ef8, .val = 0xb26bbf7b },
	{ .addr = 0x0f0004efc, .val = 0x000000c9 },
	{ .addr = 0x0f0004f00, .val = 0x0a7fdfca },
	{ .addr = 0x0f0004f04, .val = 0x0000005c },
	{ .addr = 0x0f0004f08, .val = 0xf5dfdfc4 },
	{ .addr = 0x0f0004f0c, .val = 0x00000039 },
	{ .addr = 0x0f0004f10, .val = 0xf13a7552 },
	{ .addr = 0x0f0004f14, .val = 0x000000c0 },
	{ .addr = 0x0f0004f18, .val = 0xd71df7d6 },
	{ .addr = 0x0f0004f1c, .val = 0x000000eb },
	{ .addr = 0x0f0004f20, .val = 0xff915394 },
	{ .addr = 0x0f0004f24, .val = 0x000000d1 },
	{ .addr = 0x0f0004f28, .val = 0x046ed24a },
	{ .addr = 0x0f0004f2c, .val = 0x0000003f },
	{ .addr = 0x0f0004f30, .val = 0x5f2e37a1 },
	{ .addr = 0x0f0004f34, .val = 0x00000014 },
	{ .addr = 0x0f0004f38, .val = 0x67f9b5e3 },
	{ .addr = 0x0f0004f3c, .val = 0x000000ca },
	{ .addr = 0x0f0004f40, .val = 0xbe9c5343 },
	{ .addr = 0x0f0004f44, .val = 0x0000009a },
	{ .addr = 0x0f0004f48, .val = 0x4882e5b9 },
	{ .addr = 0x0f0004f4c, .val = 0x0000009d },
	{ .addr = 0x0f0004f50, .val = 0xd99b7f0b },
	{ .addr = 0x0f0004f54, .val = 0x00000052 },
	{ .addr = 0x0f0004f58, .val = 0xb9fcee33 },
	{ .addr = 0x0f0004f5c, .val = 0x0000003c },
	{ .addr = 0x0f0004f60, .val = 0xb1aff7f5 },
	{ .addr = 0x0f0004f64, .val = 0x00000057 },
	{ .addr = 0x0f0004f68, .val = 0xb8313d4e },
	{ .addr = 0x0f0004f6c, .val = 0x0000005c },
	{ .addr = 0x0f0004f70, .val = 0xf30891c9 },
	{ .addr = 0x0f0004f74, .val = 0x00000025 },
	{ .addr = 0x0f0004f78, .val = 0xbcdb20b6 },
	{ .addr = 0x0f0004f7c, .val = 0x00000002 },
	{ .addr = 0x0f0004f80, .val = 0x12c0bf9c },
	{ .addr = 0x0f0004f84, .val = 0x00000052 },
	{ .addr = 0x0f0004f88, .val = 0x3ee1845a },
	{ .addr = 0x0f0004f8c, .val = 0x00000097 },
	{ .addr = 0x0f0004f90, .val = 0x69d54af2 },
	{ .addr = 0x0f0004f94, .val = 0x000000c4 },
	{ .addr = 0x0f0004f98, .val = 0x9a17ff82 },
	{ .addr = 0x0f0004f9c, .val = 0x00000008 },
	{ .addr = 0x0f0004fa0, .val = 0x6397f21f },
	{ .addr = 0x0f0004fa4, .val = 0x00000083 },
	{ .addr = 0x0f0004fa8, .val = 0x112b73cf },
	{ .addr = 0x0f0004fac, .val = 0x000000b5 },
	{ .addr = 0x0f0004fb0, .val = 0x337248d3 },
	{ .addr = 0x0f0004fb4, .val = 0x000000e7 },
	{ .addr = 0x0f0004fb8, .val = 0xc0e06b8c },
	{ .addr = 0x0f0004fbc, .val = 0x000000c3 },
	{ .addr = 0x0f0004fc0, .val = 0x79436e29 },
	{ .addr = 0x0f0004fc4, .val = 0x000000e8 },
	{ .addr = 0x0f0004fc8, .val = 0xf3e47bd3 },
	{ .addr = 0x0f0004fcc, .val = 0x000000ef },
	{ .addr = 0x0f0004fd0, .val = 0xd8eb5cdf },
	{ .addr = 0x0f0004fd4, .val = 0x0000002f },
	{ .addr = 0x0f0004fd8, .val = 0x85660159 },
	{ .addr = 0x0f0004fdc, .val = 0x000000b2 },
	{ .addr = 0x0f0004fe0, .val = 0xafefd72c },
	{ .addr = 0x0f0004fe4, .val = 0x0000002f },
	{ .addr = 0x0f0004fe8, .val = 0x1bf84fe4 },
	{ .addr = 0x0f0004fec, .val = 0x000000e5 },
	{ .addr = 0x0f0004ff0, .val = 0x304a2cd0 },
	{ .addr = 0x0f0004ff4, .val = 0x0000004f },
	{ .addr = 0x0f0004ff8, .val = 0xb0eeb472 },
	{ .addr = 0x0f0004ffc, .val = 0x000000b1 },
	{ .addr = 0x0f0005000, .val = 0x0975905c },
	{ .addr = 0x0f0005004, .val = 0x0000005e },
	{ .addr = 0x0f0005008, .val = 0x23d789b2 },
	{ .addr = 0x0f000500c, .val = 0x000000e2 },
	{ .addr = 0x0f0005010, .val = 0x9f3233a4 },
	{ .addr = 0x0f0005014, .val = 0x00000023 },
	{ .addr = 0x0f0005018, .val = 0xa79ca448 },
	{ .addr = 0x0f000501c, .val = 0x00000023 },
	{ .addr = 0x0f0005020, .val = 0xbd65664c },
	{ .addr = 0x0f0005024, .val = 0x00000006 },
	{ .addr = 0x0f0005028, .val = 0xd7a4ab30 },
	{ .addr = 0x0f000502c, .val = 0x0000009e },
	{ .addr = 0x0f0005030, .val = 0x11cff778 },
	{ .addr = 0x0f0005034, .val = 0x00000020 },
	{ .addr = 0x0f0005038, .val = 0x68395209 },
	{ .addr = 0x0f000503c, .val = 0x00000013 },
	{ .addr = 0x0f0005040, .val = 0x58534304 },
	{ .addr = 0x0f0005044, .val = 0x00000016 },
	{ .addr = 0x0f0005048, .val = 0xa404c67b },
	{ .addr = 0x0f000504c, .val = 0x000000b0 },
	{ .addr = 0x0f0005050, .val = 0x7a93248a },
	{ .addr = 0x0f0005054, .val = 0x00000050 },
	{ .addr = 0x0f0005058, .val = 0xa1c566c3 },
	{ .addr = 0x0f000505c, .val = 0x00000053 },
	{ .addr = 0x0f0005060, .val = 0xd7cbb680 },
	{ .addr = 0x0f0005064, .val = 0x000000f3 },
	{ .addr = 0x0f0005068, .val = 0x2e6a4c09 },
	{ .addr = 0x0f000506c, .val = 0x000000a5 },
	{ .addr = 0x0f0005070, .val = 0xfea8d13a },
	{ .addr = 0x0f0005074, .val = 0x00000009 },
	{ .addr = 0x0f0005078, .val = 0x62eda28b },
	{ .addr = 0x0f000507c, .val = 0x0000002f },
	{ .addr = 0x0f0005080, .val = 0x91918d90 },
	{ .addr = 0x0f0005084, .val = 0x000000dc },
	{ .addr = 0x0f0005088, .val = 0x732b854a },
	{ .addr = 0x0f000508c, .val = 0x00000095 },
	{ .addr = 0x0f0005090, .val = 0x7e209ba7 },
	{ .addr = 0x0f0005094, .val = 0x00000088 },
	{ .addr = 0x0f0005098, .val = 0x85f607b7 },
	{ .addr = 0x0f000509c, .val = 0x0000004a },
	{ .addr = 0x0f00050a0, .val = 0x4a766276 },
	{ .addr = 0x0f00050a4, .val = 0x00000006 },
	{ .addr = 0x0f00050a8, .val = 0x22d772c5 },
	{ .addr = 0x0f00050ac, .val = 0x000000f8 },
	{ .addr = 0x0f00050b0, .val = 0x24ba3b08 },
	{ .addr = 0x0f00050b4, .val = 0x0000009b },
	{ .addr = 0x0f00050b8, .val = 0x65ca6458 },
	{ .addr = 0x0f00050bc, .val = 0x000000cc },
	{ .addr = 0x0f00050c0, .val = 0x7ccdb51f },
	{ .addr = 0x0f00050c4, .val = 0x000000c0 },
	{ .addr = 0x0f00050c8, .val = 0x611ab9be },
	{ .addr = 0x0f00050cc, .val = 0x000000d8 },
	{ .addr = 0x0f00050d0, .val = 0x6b80a567 },
	{ .addr = 0x0f00050d4, .val = 0x000000a6 },
	{ .addr = 0x0f00050d8, .val = 0xdd00b673 },
	{ .addr = 0x0f00050dc, .val = 0x000000a1 },
	{ .addr = 0x0f00050e0, .val = 0xa2bd6cdc },
	{ .addr = 0x0f00050e4, .val = 0x00000023 },
	{ .addr = 0x0f00050e8, .val = 0xda4d7691 },
	{ .addr = 0x0f00050ec, .val = 0x00000069 },
	{ .addr = 0x0f00050f0, .val = 0x0081eb34 },
	{ .addr = 0x0f00050f4, .val = 0x0000008c },
	{ .addr = 0x0f00050f8, .val = 0x6eed0b58 },
	{ .addr = 0x0f00050fc, .val = 0x00000006 },
	{ .addr = 0x0f0005100, .val = 0xf1556f2a },
	{ .addr = 0x0f0005104, .val = 0x0000009d },
	{ .addr = 0x0f0005108, .val = 0xcd2e13b7 },
	{ .addr = 0x0f000510c, .val = 0x00000054 },
	{ .addr = 0x0f0005110, .val = 0x6491c247 },
	{ .addr = 0x0f0005114, .val = 0x0000008f },
	{ .addr = 0x0f0005118, .val = 0x3e86c95c },
	{ .addr = 0x0f000511c, .val = 0x00000038 },
	{ .addr = 0x0f0005120, .val = 0x814f0f8f },
	{ .addr = 0x0f0005124, .val = 0x00000032 },
	{ .addr = 0x0f0005128, .val = 0x773639e6 },
	{ .addr = 0x0f000512c, .val = 0x000000f1 },
	{ .addr = 0x0f0005130, .val = 0x96d2010a },
	{ .addr = 0x0f0005134, .val = 0x00000007 },
	{ .addr = 0x0f0005138, .val = 0x7147bb1f },
	{ .addr = 0x0f000513c, .val = 0x000000cc },
	{ .addr = 0x0f0005140, .val = 0xa4483421 },
	{ .addr = 0x0f0005144, .val = 0x000000dc },
	{ .addr = 0x0f0005148, .val = 0xa619555b },
	{ .addr = 0x0f000514c, .val = 0x000000a8 },
	{ .addr = 0x0f0005150, .val = 0x1702c496 },
	{ .addr = 0x0f0005154, .val = 0x000000c3 },
	{ .addr = 0x0f0005158, .val = 0x465f42c2 },
	{ .addr = 0x0f000515c, .val = 0x0000007e },
	{ .addr = 0x0f0005160, .val = 0x89d724c5 },
	{ .addr = 0x0f0005164, .val = 0x00000024 },
	{ .addr = 0x0f0005168, .val = 0x64936455 },
	{ .addr = 0x0f000516c, .val = 0x0000003f },
	{ .addr = 0x0f0005170, .val = 0x3313a599 },
	{ .addr = 0x0f0005174, .val = 0x00000015 },
	{ .addr = 0x0f0005178, .val = 0x4dc6ff35 },
	{ .addr = 0x0f000517c, .val = 0x00000064 },
	{ .addr = 0x0f0005180, .val = 0x16e4515e },
	{ .addr = 0x0f0005184, .val = 0x000000a6 },
	{ .addr = 0x0f0005188, .val = 0x69c8d13e },
	{ .addr = 0x0f000518c, .val = 0x000000f1 },
	{ .addr = 0x0f0005190, .val = 0xa0343faf },
	{ .addr = 0x0f0005194, .val = 0x00000004 },
	{ .addr = 0x0f0005198, .val = 0xc6236afa },
	{ .addr = 0x0f000519c, .val = 0x00000042 },
	{ .addr = 0x0f00051a0, .val = 0x3b343a4f },
	{ .addr = 0x0f00051a4, .val = 0x0000005d },
	{ .addr = 0x0f00051a8, .val = 0x6c2fc2c5 },
	{ .addr = 0x0f00051ac, .val = 0x000000e1 },
	{ .addr = 0x0f00051b0, .val = 0x55d78687 },
	{ .addr = 0x0f00051b4, .val = 0x000000d8 },
	{ .addr = 0x0f00051b8, .val = 0xf98af89e },
	{ .addr = 0x0f00051bc, .val = 0x00000097 },
	{ .addr = 0x0f00051c0, .val = 0x2dd75f30 },
	{ .addr = 0x0f00051c4, .val = 0x0000008c },
	{ .addr = 0x0f00051c8, .val = 0x3e92082a },
	{ .addr = 0x0f00051cc, .val = 0x000000f9 },
	{ .addr = 0x0f00051d0, .val = 0x78ec9497 },
	{ .addr = 0x0f00051d4, .val = 0x000000ca },
	{ .addr = 0x0f00051d8, .val = 0xab7bc97a },
	{ .addr = 0x0f00051dc, .val = 0x000000d6 },
	{ .addr = 0x0f00051e0, .val = 0x3a9545f2 },
	{ .addr = 0x0f00051e4, .val = 0x00000010 },
	{ .addr = 0x0f00051e8, .val = 0xff0a48cc },
	{ .addr = 0x0f00051ec, .val = 0x000000d8 },
	{ .addr = 0x0f00051f0, .val = 0x583c7c8e },
	{ .addr = 0x0f00051f4, .val = 0x00000051 },
	{ .addr = 0x0f00051f8, .val = 0xa07cad6d },
	{ .addr = 0x0f00051fc, .val = 0x0000001f },
	{ .addr = 0x0f0005200, .val = 0x0ec1e722 },
	{ .addr = 0x0f0005204, .val = 0x0000007c },
	{ .addr = 0x0f0005208, .val = 0xe9cd3f1e },
	{ .addr = 0x0f000520c, .val = 0x00000086 },
	{ .addr = 0x0f0005210, .val = 0xc10257a2 },
	{ .addr = 0x0f0005214, .val = 0x00000032 },
	{ .addr = 0x0f0005218, .val = 0xc15de034 },
	{ .addr = 0x0f000521c, .val = 0x00000045 },
	{ .addr = 0x0f0005220, .val = 0xba895da5 },
	{ .addr = 0x0f0005224, .val = 0x00000099 },
	{ .addr = 0x0f0005228, .val = 0xf283af06 },
	{ .addr = 0x0f000522c, .val = 0x00000079 },
	{ .addr = 0x0f0005230, .val = 0x8f6b0dc5 },
	{ .addr = 0x0f0005234, .val = 0x000000ef },
	{ .addr = 0x0f0005238, .val = 0xfc9a1e3b },
	{ .addr = 0x0f000523c, .val = 0x0000006c },
	{ .addr = 0x0f0005240, .val = 0x23bb3b8a },
	{ .addr = 0x0f0005244, .val = 0x00000014 },
	{ .addr = 0x0f0005248, .val = 0x68c9ef7b },
	{ .addr = 0x0f000524c, .val = 0x0000002a },
	{ .addr = 0x0f0005250, .val = 0x47f8e976 },
	{ .addr = 0x0f0005254, .val = 0x000000f2 },
	{ .addr = 0x0f0005258, .val = 0x9b193398 },
	{ .addr = 0x0f000525c, .val = 0x00000081 },
	{ .addr = 0x0f0005260, .val = 0x8b8403d9 },
	{ .addr = 0x0f0005264, .val = 0x0000002a },
	{ .addr = 0x0f0005268, .val = 0xa804c0fa },
	{ .addr = 0x0f000526c, .val = 0x000000b0 },
	{ .addr = 0x0f0005270, .val = 0x853df886 },
	{ .addr = 0x0f0005274, .val = 0x00000082 },
	{ .addr = 0x0f0005278, .val = 0xe2c4b069 },
	{ .addr = 0x0f000527c, .val = 0x00000006 },
	{ .addr = 0x0f0005280, .val = 0xe206970b },
	{ .addr = 0x0f0005284, .val = 0x0000006a },
	{ .addr = 0x0f0005288, .val = 0x40c99b11 },
	{ .addr = 0x0f000528c, .val = 0x0000008e },
	{ .addr = 0x0f0005290, .val = 0x0f8e1211 },
	{ .addr = 0x0f0005294, .val = 0x000000b2 },
	{ .addr = 0x0f0005298, .val = 0x00a50ff4 },
	{ .addr = 0x0f000529c, .val = 0x0000000b },
	{ .addr = 0x0f00052a0, .val = 0x4813d59a },
	{ .addr = 0x0f00052a4, .val = 0x0000000c },
	{ .addr = 0x0f00052a8, .val = 0x933d1ddd },
	{ .addr = 0x0f00052ac, .val = 0x00000064 },
	{ .addr = 0x0f00052b0, .val = 0x0d27eaf8 },
	{ .addr = 0x0f00052b4, .val = 0x0000005b },
	{ .addr = 0x0f00052b8, .val = 0x5cbf239a },
	{ .addr = 0x0f00052bc, .val = 0x000000af },
	{ .addr = 0x0f00052c0, .val = 0xcc124a17 },
	{ .addr = 0x0f00052c4, .val = 0x00000052 },
	{ .addr = 0x0f00052c8, .val = 0x57294c91 },
	{ .addr = 0x0f00052cc, .val = 0x00000094 },
	{ .addr = 0x0f00052d0, .val = 0xffdb8287 },
	{ .addr = 0x0f00052d4, .val = 0x000000e5 },
	{ .addr = 0x0f00052d8, .val = 0xe76d1807 },
	{ .addr = 0x0f00052dc, .val = 0x000000b5 },
	{ .addr = 0x0f00052e0, .val = 0x5a0f8a7d },
	{ .addr = 0x0f00052e4, .val = 0x00000052 },
	{ .addr = 0x0f00052e8, .val = 0xa0b87da1 },
	{ .addr = 0x0f00052ec, .val = 0x0000000e },
	{ .addr = 0x0f00052f0, .val = 0x9004a7d7 },
	{ .addr = 0x0f00052f4, .val = 0x000000b3 },
	{ .addr = 0x0f00052f8, .val = 0xaab49ac8 },
	{ .addr = 0x0f00052fc, .val = 0x00000071 },
	{ .addr = 0x0f0005300, .val = 0xb642a0e3 },
	{ .addr = 0x0f0005304, .val = 0x000000ff },
	{ .addr = 0x0f0005308, .val = 0x04070c0b },
	{ .addr = 0x0f000530c, .val = 0x000000dc },
	{ .addr = 0x0f0005310, .val = 0xd2b0d836 },
	{ .addr = 0x0f0005314, .val = 0x00000014 },
	{ .addr = 0x0f0005318, .val = 0x4971970f },
	{ .addr = 0x0f000531c, .val = 0x00000067 },
	{ .addr = 0x0f0005320, .val = 0x2343be34 },
	{ .addr = 0x0f0005324, .val = 0x000000d6 },
	{ .addr = 0x0f0005328, .val = 0xf313264f },
	{ .addr = 0x0f000532c, .val = 0x00000088 },
	{ .addr = 0x0f0005330, .val = 0x7e2f6f2f },
	{ .addr = 0x0f0005334, .val = 0x00000096 },
	{ .addr = 0x0f0005338, .val = 0xab25bf8a },
	{ .addr = 0x0f000533c, .val = 0x00000083 },
	{ .addr = 0x0f0005340, .val = 0x935ae373 },
	{ .addr = 0x0f0005344, .val = 0x00000033 },
	{ .addr = 0x0f0005348, .val = 0x3c1e4a59 },
	{ .addr = 0x0f000534c, .val = 0x000000b6 },
	{ .addr = 0x0f0005350, .val = 0xfd004b7f },
	{ .addr = 0x0f0005354, .val = 0x0000002e },
	{ .addr = 0x0f0005358, .val = 0x223d2b8d },
	{ .addr = 0x0f000535c, .val = 0x000000d5 },
	{ .addr = 0x0f0005360, .val = 0x90373d09 },
	{ .addr = 0x0f0005364, .val = 0x000000dd },
	{ .addr = 0x0f0005368, .val = 0xef3b5d9d },
	{ .addr = 0x0f000536c, .val = 0x00000007 },
	{ .addr = 0x0f0005370, .val = 0x33adeaf1 },
	{ .addr = 0x0f0005374, .val = 0x0000006c },
	{ .addr = 0x0f0005378, .val = 0xd3f762de },
	{ .addr = 0x0f000537c, .val = 0x00000090 },
	{ .addr = 0x0f0005380, .val = 0xb8d3f3a6 },
	{ .addr = 0x0f0005384, .val = 0x00000033 },
	{ .addr = 0x0f0005388, .val = 0x937567bf },
	{ .addr = 0x0f000538c, .val = 0x0000008b },
	{ .addr = 0x0f0005390, .val = 0x11422fab },
	{ .addr = 0x0f0005394, .val = 0x000000ea },
	{ .addr = 0x0f0005398, .val = 0x78d38da3 },
	{ .addr = 0x0f000539c, .val = 0x00000061 },
	{ .addr = 0x0f00053a0, .val = 0x66860e8a },
	{ .addr = 0x0f00053a4, .val = 0x000000bc },
	{ .addr = 0x0f00053a8, .val = 0x628798e5 },
	{ .addr = 0x0f00053ac, .val = 0x000000a7 },
	{ .addr = 0x0f00053b0, .val = 0xb6696b3b },
	{ .addr = 0x0f00053b4, .val = 0x00000054 },
	{ .addr = 0x0f00053b8, .val = 0x052c65b0 },
	{ .addr = 0x0f00053bc, .val = 0x000000c5 },
	{ .addr = 0x0f00053c0, .val = 0xa02c9e03 },
	{ .addr = 0x0f00053c4, .val = 0x00000070 },
	{ .addr = 0x0f00053c8, .val = 0x22b71271 },
	{ .addr = 0x0f00053cc, .val = 0x00000035 },
	{ .addr = 0x0f00053d0, .val = 0xa96cbd83 },
	{ .addr = 0x0f00053d4, .val = 0x000000f5 },
	{ .addr = 0x0f00053d8, .val = 0x4d1a4891 },
	{ .addr = 0x0f00053dc, .val = 0x00000042 },
	{ .addr = 0x0f00053e0, .val = 0xb3139db3 },
	{ .addr = 0x0f00053e4, .val = 0x00000011 },
	{ .addr = 0x0f00053e8, .val = 0x6ca18713 },
	{ .addr = 0x0f00053ec, .val = 0x000000df },
	{ .addr = 0x0f00053f0, .val = 0x0a532248 },
	{ .addr = 0x0f00053f4, .val = 0x000000be },
	{ .addr = 0x0f00053f8, .val = 0xe015be44 },
	{ .addr = 0x0f00053fc, .val = 0x000000f9 },
	{ .addr = 0x0f0005400, .val = 0xe89bc3c4 },
	{ .addr = 0x0f0005404, .val = 0x000000ca },
	{ .addr = 0x0f0005408, .val = 0xe8e1a03c },
	{ .addr = 0x0f000540c, .val = 0x0000007e },
	{ .addr = 0x0f0005410, .val = 0x65dd5086 },
	{ .addr = 0x0f0005414, .val = 0x000000a9 },
	{ .addr = 0x0f0005418, .val = 0xdfa68dba },
	{ .addr = 0x0f000541c, .val = 0x00000097 },
	{ .addr = 0x0f0005420, .val = 0x352fa2dc },
	{ .addr = 0x0f0005424, .val = 0x000000c9 },
	{ .addr = 0x0f0005428, .val = 0xd4eb1fdb },
	{ .addr = 0x0f000542c, .val = 0x000000ee },
	{ .addr = 0x0f0005430, .val = 0xea076ce7 },
	{ .addr = 0x0f0005434, .val = 0x00000054 },
	{ .addr = 0x0f0005438, .val = 0xd6c77edc },
	{ .addr = 0x0f000543c, .val = 0x000000a8 },
	{ .addr = 0x0f0005440, .val = 0x5decd07c },
	{ .addr = 0x0f0005444, .val = 0x0000001e },
	{ .addr = 0x0f0005448, .val = 0x39a3ce84 },
	{ .addr = 0x0f000544c, .val = 0x00000097 },
	{ .addr = 0x0f0005450, .val = 0x43672bea },
	{ .addr = 0x0f0005454, .val = 0x00000033 },
	{ .addr = 0x0f0005458, .val = 0xa29568ec },
	{ .addr = 0x0f000545c, .val = 0x000000b7 },
	{ .addr = 0x0f0005460, .val = 0xa9e28605 },
	{ .addr = 0x0f0005464, .val = 0x00000094 },
	{ .addr = 0x0f0005468, .val = 0xb4d439da },
	{ .addr = 0x0f000546c, .val = 0x00000069 },
	{ .addr = 0x0f0005470, .val = 0x8e0c4876 },
	{ .addr = 0x0f0005474, .val = 0x0000000b },
	{ .addr = 0x0f0005478, .val = 0x6a3cdebe },
	{ .addr = 0x0f000547c, .val = 0x000000bf },
	{ .addr = 0x0f0005480, .val = 0xbd4b9ef6 },
	{ .addr = 0x0f0005484, .val = 0x00000028 },
	{ .addr = 0x0f0005488, .val = 0x00ae7cb6 },
	{ .addr = 0x0f000548c, .val = 0x00000013 },
	{ .addr = 0x0f0005490, .val = 0x9688c166 },
	{ .addr = 0x0f0005494, .val = 0x0000004c },
	{ .addr = 0x0f0005498, .val = 0x6e46043e },
	{ .addr = 0x0f000549c, .val = 0x00000067 },
	{ .addr = 0x0f00054a0, .val = 0xfff52269 },
	{ .addr = 0x0f00054a4, .val = 0x0000009c },
	{ .addr = 0x0f00054a8, .val = 0x81deb86d },
	{ .addr = 0x0f00054ac, .val = 0x0000005a },
	{ .addr = 0x0f00054b0, .val = 0x2f91188d },
	{ .addr = 0x0f00054b4, .val = 0x000000e9 },
	{ .addr = 0x0f00054b8, .val = 0x272d9f13 },
	{ .addr = 0x0f00054bc, .val = 0x000000ce },
	{ .addr = 0x0f00054c0, .val = 0xf78c12dd },
	{ .addr = 0x0f00054c4, .val = 0x000000bf },
	{ .addr = 0x0f00054c8, .val = 0x71957e53 },
	{ .addr = 0x0f00054cc, .val = 0x000000b9 },
	{ .addr = 0x0f00054d0, .val = 0x14963c67 },
	{ .addr = 0x0f00054d4, .val = 0x000000e2 },
	{ .addr = 0x0f00054d8, .val = 0x2e8ad2b5 },
	{ .addr = 0x0f00054dc, .val = 0x0000008a },
	{ .addr = 0x0f00054e0, .val = 0xfa57a764 },
	{ .addr = 0x0f00054e4, .val = 0x00000074 },
	{ .addr = 0x0f00054e8, .val = 0x5984d9e4 },
	{ .addr = 0x0f00054ec, .val = 0x0000001a },
	{ .addr = 0x0f00054f0, .val = 0xdefa8423 },
	{ .addr = 0x0f00054f4, .val = 0x0000008e },
	{ .addr = 0x0f00054f8, .val = 0x18315cbb },
	{ .addr = 0x0f00054fc, .val = 0x0000001e },
	{ .addr = 0x0f0005504, .val = 0xc9558e4a },
	{ .addr = 0x0f0120000, .val = 0x00000001 },
	{ .addr = 0x0f0120004, .val = 0xfa557cea },
	{ .addr = 0x0f0120008, .val = 0x0000005f },
	{ .addr = 0x0f012000c, .val = 0x0000148c },
	{ .addr = 0x0f0120010, .val = 0x0000fb65 },
	{ .addr = 0x0f0120014, .val = 0x05f97f1a },
	{ .addr = 0x0f0120018, .val = 0x00000001 },
	{ .addr = 0x0f012001c, .val = 0x000001ca },
	{ .addr = 0x0f0120020, .val = 0x00478d42 },
	{ .addr = 0x0f0120024, .val = 0x0033800c },
	{ .addr = 0x0f0120028, .val = 0x16d3e8c6 },
	{ .addr = 0x0f012002c, .val = 0x0a8d6437 },
	{ .addr = 0x0f0120080, .val = 0x00000100 },
	{ .addr = 0x0f0120084, .val = 0x010d060c },
	{ .addr = 0x0f0120088, .val = 0x0000351d },
	{ .addr = 0x0f012008c, .val = 0x00022636 },
	{ .addr = 0x0f0120100, .val = 0x3818a126 },
	{ .addr = 0x0f0120104, .val = 0x4b00a7d0 },
	{ .addr = 0x0f0120108, .val = 0x4b615886 },
	{ .addr = 0x0f012010c, .val = 0x380c3576 },
	{ .addr = 0x0f0120110, .val = 0x7ca9c6f1 },
	{ .addr = 0x0f0120114, .val = 0x28b36b12 },
	{ .addr = 0x0f0120118, .val = 0x44f44c73 },
	{ .addr = 0x0f012011c, .val = 0x54f1bbb6 },
	{ .addr = 0x0f0120120, .val = 0xeb703a49 },
	{ .addr = 0x0f0120124, .val = 0xdc58b620 },
	{ .addr = 0x0f0120128, .val = 0xd29755a4 },
	{ .addr = 0x0f012012c, .val = 0xf2ec6dff },
	{ .addr = 0x0f0120130, .val = 0xf6760b2a },
	{ .addr = 0x0f0120134, .val = 0xfb43e8b2 },
	{ .addr = 0x0f0120138, .val = 0xa9e31a5d },
	{ .addr = 0x0f012013c, .val = 0x27a08cd8 },
	{ .addr = 0x0f0120150, .val = 0x68885bbf },
	{ .addr = 0x0f0120154, .val = 0x5546c020 },
	{ .addr = 0x0f0120180, .val = 0x002df788 },
	{ .addr = 0x0f0120184, .val = 0x007b05fe },
	{ .addr = 0x0f0120188, .val = 0x0078058a },
	{ .addr = 0x0f012018c, .val = 0x003a4d9a },
	{ .addr = 0x0f0120190, .val = 0x0015c378 },
	{ .addr = 0x0f0120194, .val = 0x000ae648 },
	{ .addr = 0x0f0120198, .val = 0x00539d9c },
	{ .addr = 0x0f012019c, .val = 0x001e7108 },
	{ .addr = 0x0f01201a0, .val = 0x007dc5f2 },
	{ .addr = 0x0f01201a4, .val = 0x006018db },
	{ .addr = 0x0f01201a8, .val = 0x001f1f5d },
	{ .addr = 0x0f01201ac, .val = 0x003fab16 },
	{ .addr = 0x0f01201b0, .val = 0x007bfde9 },
	{ .addr = 0x0f01201b4, .val = 0x00396770 },
	{ .addr = 0x0f01201b8, .val = 0x00652e3e },
	{ .addr = 0x0f01201bc, .val = 0x000f3bff },
	{ .addr = 0x0f0120200, .val = 0xa3bbf3c2 },
	{ .addr = 0x0f0120204, .val = 0x995040ac },
	{ .addr = 0x0f0120208, .val = 0xae4fb781 },
	{ .addr = 0x0f012020c, .val = 0xd7e3cb0c },
	{ .addr = 0x0f0120210, .val = 0x42b7c78c },
	{ .addr = 0x0f0120214, .val = 0x511b8d2f },
	{ .addr = 0x0f0120218, .val = 0x28e00a04 },
	{ .addr = 0x0f012021c, .val = 0x45f72a97 },
	{ .addr = 0x0f0120220, .val = 0xf10e7e8c },
	{ .addr = 0x0f0120224, .val = 0xe1d6ba0b },
	{ .addr = 0x0f0120228, .val = 0x9cd8e4c5 },
	{ .addr = 0x0f012022c, .val = 0x974b0505 },
	{ .addr = 0x0f0120230, .val = 0xffc7f810 },
	{ .addr = 0x0f0120234, .val = 0xf4848953 },
	{ .addr = 0x0f0120238, .val = 0xea090c27 },
	{ .addr = 0x0f012023c, .val = 0x7cb9070b },
	{ .addr = 0x0f0120240, .val = 0xff74f522 },
	{ .addr = 0x0f0120244, .val = 0x1cbb4115 },
	{ .addr = 0x0f0120248, .val = 0x2c30818a },
	{ .addr = 0x0f012024c, .val = 0xc12ada58 },
	{ .addr = 0x0f0120250, .val = 0x5813edc2 },
	{ .addr = 0x0f0120254, .val = 0x577520b7 },
	{ .addr = 0x0f0120258, .val = 0xd3f64ab2 },
	{ .addr = 0x0f012025c, .val = 0xd38d6dc6 },
	{ .addr = 0x0f0120260, .val = 0xf46630f1 },
	{ .addr = 0x0f0120264, .val = 0xc5b95dc8 },
	{ .addr = 0x0f0120268, .val = 0xc28f9b90 },
	{ .addr = 0x0f012026c, .val = 0xf1161f9e },
	{ .addr = 0x0f0120270, .val = 0x3e677c9e },
	{ .addr = 0x0f0120274, .val = 0x1edc472e },
	{ .addr = 0x0f0120278, .val = 0x695d7582 },
	{ .addr = 0x0f012027c, .val = 0x94682ebb },
	{ .addr = 0x0f0120280, .val = 0x8a4ef75d },
	{ .addr = 0x0f0120284, .val = 0x5ee7fbfb },
	{ .addr = 0x0f0120288, .val = 0x65db4482 },
	{ .addr = 0x0f012028c, .val = 0x40bb7ff1 },
	{ .addr = 0x0f0120290, .val = 0x9feb2809 },
	{ .addr = 0x0f0120294, .val = 0xcd4fc9bd },
	{ .addr = 0x0f0120298, .val = 0x3cc4ea71 },
	{ .addr = 0x0f012029c, .val = 0x07e3460f },
	{ .addr = 0x0f01202a0, .val = 0x24890a6e },
	{ .addr = 0x0f01202a4, .val = 0xc08c64b8 },
	{ .addr = 0x0f01202a8, .val = 0x6996c976 },
	{ .addr = 0x0f01202ac, .val = 0xf59c59fe },
	{ .addr = 0x0f01202b0, .val = 0x991184a7 },
	{ .addr = 0x0f01202b4, .val = 0x9199a480 },
	{ .addr = 0x0f01202b8, .val = 0x1818fc85 },
	{ .addr = 0x0f01202bc, .val = 0xdb814264 },
	{ .addr = 0x0f01202c0, .val = 0xa53657f9 },
	{ .addr = 0x0f01202c4, .val = 0x4cb5415f },
	{ .addr = 0x0f01202c8, .val = 0x26deaea7 },
	{ .addr = 0x0f01202cc, .val = 0xd2c02fc0 },
	{ .addr = 0x0f01202d0, .val = 0x9a6630fa },
	{ .addr = 0x0f01202d4, .val = 0x7f7d2f42 },
	{ .addr = 0x0f01202d8, .val = 0x6871e33b },
	{ .addr = 0x0f01202dc, .val = 0xd9c9cbb3 },
	{ .addr = 0x0f01202e0, .val = 0x4e1a883d },
	{ .addr = 0x0f01202e4, .val = 0xb0cd07a0 },
	{ .addr = 0x0f01202e8, .val = 0x1c5fdd30 },
	{ .addr = 0x0f01202ec, .val = 0xb7f02776 },
	{ .addr = 0x0f01202f0, .val = 0x59c06ccd },
	{ .addr = 0x0f01202f4, .val = 0x0230a8d3 },
	{ .addr = 0x0f01202f8, .val = 0xabc0d858 },
	{ .addr = 0x0f01202fc, .val = 0x3ce756e3 },
	{ .addr = 0x0f0120300, .val = 0x0000f683 },
	{ .addr = 0x0f0120304, .val = 0x000024bf },
	{ .addr = 0x0f0120308, .val = 0x00009d6c },
	{ .addr = 0x0f012030c, .val = 0x00007b09 },
	{ .addr = 0x0f0120310, .val = 0x0000bfc9 },
	{ .addr = 0x0f0120314, .val = 0x0000803a },
	{ .addr = 0x0f0120318, .val = 0x000076d4 },
	{ .addr = 0x0f012031c, .val = 0x000011c5 },
	{ .addr = 0x0f0120320, .val = 0x0000972a },
	{ .addr = 0x0f0120324, .val = 0x0000f6c9 },
	{ .addr = 0x0f0120328, .val = 0x0000e537 },
	{ .addr = 0x0f012032c, .val = 0x0000b2c7 },
	{ .addr = 0x0f0120330, .val = 0x0000146d },
	{ .addr = 0x0f0120334, .val = 0x0000aa96 },
	{ .addr = 0x0f0120338, .val = 0x00008f32 },
	{ .addr = 0x0f012033c, .val = 0x0000a73d },
	{ .addr = 0x0f0120340, .val = 0x0000bf7d },
	{ .addr = 0x0f0120344, .val = 0x0000d06f },
	{ .addr = 0x0f0120348, .val = 0x0000a1f2 },
	{ .addr = 0x0f012034c, .val = 0x0000a672 },
	{ .addr = 0x0f0120350, .val = 0x0000b3e1 },
	{ .addr = 0x0f0120354, .val = 0x0000c6c0 },
	{ .addr = 0x0f0120358, .val = 0x0000158b },
	{ .addr = 0x0f012035c, .val = 0x000031e3 },
	{ .addr = 0x0f0120360, .val = 0x0000bb91 },
	{ .addr = 0x0f0120364, .val = 0x00006d6d },
	{ .addr = 0x0f0120368, .val = 0x0000ecd0 },
	{ .addr = 0x0f012036c, .val = 0x0000e1b8 },
	{ .addr = 0x0f0120370, .val = 0x0000c94d },
	{ .addr = 0x0f0120374, .val = 0x000040d3 },
	{ .addr = 0x0f0120378, .val = 0x0000b27b },
	{ .addr = 0x0f012037c, .val = 0x00005344 },
	{ .addr = 0x0f0120380, .val = 0x00002c9d },
	{ .addr = 0x0f0120384, .val = 0x00006be6 },
	{ .addr = 0x0f0120388, .val = 0x00005706 },
	{ .addr = 0x0f012038c, .val = 0x0000d1f6 },
	{ .addr = 0x0f0120390, .val = 0x0000ed9f },
	{ .addr = 0x0f0120394, .val = 0x00008cd8 },
	{ .addr = 0x0f0120398, .val = 0x00004669 },
	{ .addr = 0x0f012039c, .val = 0x000076a8 },
	{ .addr = 0x0f01203a0, .val = 0x0000e900 },
	{ .addr = 0x0f01203a4, .val = 0x0000be69 },
	{ .addr = 0x0f01203a8, .val = 0x00000f86 },
	{ .addr = 0x0f01203ac, .val = 0x00005699 },
	{ .addr = 0x0f01203b0, .val = 0x0000f5b6 },
	{ .addr = 0x0f01203b4, .val = 0x00001e75 },
	{ .addr = 0x0f01203b8, .val = 0x000008ea },
	{ .addr = 0x0f01203bc, .val = 0x00005d08 },
	{ .addr = 0x0f01203c0, .val = 0x0000227b },
	{ .addr = 0x0f01203c4, .val = 0x0000fcc0 },
	{ .addr = 0x0f01203c8, .val = 0x000015eb },
	{ .addr = 0x0f01203cc, .val = 0x000022d5 },
	{ .addr = 0x0f01203d0, .val = 0x000014bb },
	{ .addr = 0x0f01203d4, .val = 0x00000c1b },
	{ .addr = 0x0f01203d8, .val = 0x000069a6 },
	{ .addr = 0x0f01203dc, .val = 0x00003d8d },
	{ .addr = 0x0f01203e0, .val = 0x0000e9e2 },
	{ .addr = 0x0f01203e4, .val = 0x00005d88 },
	{ .addr = 0x0f01203e8, .val = 0x0000538a },
	{ .addr = 0x0f01203ec, .val = 0x00008772 },
	{ .addr = 0x0f01203f0, .val = 0x0000e9c8 },
	{ .addr = 0x0f01203f4, .val = 0x0000f87b },
	{ .addr = 0x0f01203f8, .val = 0x0000fd7a },
	{ .addr = 0x0f01203fc, .val = 0x0000b1e0 },
	{ .addr = 0x0f0120400, .val = 0x0000003f },
	{ .addr = 0x0f0120404, .val = 0x80000035 },
	{ .addr = 0x0f0120408, .val = 0x80000005 },
	{ .addr = 0x0f012040c, .val = 0x80000027 },
	{ .addr = 0x0f0120410, .val = 0x8000001e },
	{ .addr = 0x0f0120414, .val = 0x8000002c },
	{ .addr = 0x0f0120418, .val = 0x00000028 },
	{ .addr = 0x0f012041c, .val = 0x80000006 },
	{ .addr = 0x0f0120420, .val = 0x0000001d },
	{ .addr = 0x0f0120424, .val = 0x80000014 },
	{ .addr = 0x0f0120428, .val = 0x80000009 },
	{ .addr = 0x0f012042c, .val = 0x00000017 },
	{ .addr = 0x0f0120430, .val = 0x8000003a },
	{ .addr = 0x0f0120434, .val = 0x00000039 },
	{ .addr = 0x0f0120438, .val = 0x8000001b },
	{ .addr = 0x0f012043c, .val = 0x80000015 },
	{ .addr = 0x0f0120440, .val = 0x8000002f },
	{ .addr = 0x0f0120444, .val = 0x00000013 },
	{ .addr = 0x0f0120448, .val = 0x00000000 },
	{ .addr = 0x0f012044c, .val = 0x0000001b },
	{ .addr = 0x0f0120450, .val = 0x0000002d },
	{ .addr = 0x0f0120454, .val = 0x0000002e },
	{ .addr = 0x0f0120458, .val = 0x0000001d },
	{ .addr = 0x0f012045c, .val = 0x00000025 },
	{ .addr = 0x0f0120460, .val = 0x00000003 },
	{ .addr = 0x0f0120464, .val = 0x0000003e },
	{ .addr = 0x0f0120468, .val = 0x00000028 },
	{ .addr = 0x0f012046c, .val = 0x80000024 },
	{ .addr = 0x0f0120470, .val = 0x80000010 },
	{ .addr = 0x0f0120474, .val = 0x00000022 },
	{ .addr = 0x0f0120478, .val = 0x80000022 },
	{ .addr = 0x0f012047c, .val = 0x00000016 },
	{ .addr = 0x0f0120480, .val = 0x00000012 },
	{ .addr = 0x0f0120484, .val = 0x00000010 },
	{ .addr = 0x0f0120488, .val = 0x80000007 },
	{ .addr = 0x0f012048c, .val = 0x8000002c },
	{ .addr = 0x0f0120490, .val = 0x8000001d },
	{ .addr = 0x0f0120494, .val = 0x00000018 },
	{ .addr = 0x0f0120498, .val = 0x0000000a },
	{ .addr = 0x0f012049c, .val = 0x80000022 },
	{ .addr = 0x0f01204a0, .val = 0x80000036 },
	{ .addr = 0x0f01204a4, .val = 0x80000032 },
	{ .addr = 0x0f01204a8, .val = 0x80000035 },
	{ .addr = 0x0f01204ac, .val = 0x80000015 },
	{ .addr = 0x0f01204b0, .val = 0x80000019 },
	{ .addr = 0x0f01204b4, .val = 0x80000031 },
	{ .addr = 0x0f01204b8, .val = 0x8000002a },
	{ .addr = 0x0f01204bc, .val = 0x80000023 },
	{ .addr = 0x0f01204c0, .val = 0x80000027 },
	{ .addr = 0x0f01204c4, .val = 0x80000008 },
	{ .addr = 0x0f01204c8, .val = 0x80000010 },
	{ .addr = 0x0f01204cc, .val = 0x00000014 },
	{ .addr = 0x0f01204d0, .val = 0x00000002 },
	{ .addr = 0x0f01204d4, .val = 0x00000018 },
	{ .addr = 0x0f01204d8, .val = 0x00000025 },
	{ .addr = 0x0f01204dc, .val = 0x00000012 },
	{ .addr = 0x0f01204e0, .val = 0x00000022 },
	{ .addr = 0x0f01204e4, .val = 0x0000001e },
	{ .addr = 0x0f01204e8, .val = 0x80000030 },
	{ .addr = 0x0f01204ec, .val = 0x00000019 },
	{ .addr = 0x0f01204f0, .val = 0x8000000e },
	{ .addr = 0x0f01204f4, .val = 0x8000000b },
	{ .addr = 0x0f01204f8, .val = 0x8000001e },
	{ .addr = 0x0f01204fc, .val = 0x80000000 },
	{ .addr = 0x0f0120500, .val = 0x80000016 },
	{ .addr = 0x0f0120504, .val = 0x00000034 },
	{ .addr = 0x0f0120508, .val = 0x80000001 },
	{ .addr = 0x0f012050c, .val = 0x80000007 },
	{ .addr = 0x0f0120510, .val = 0x8000002a },
	{ .addr = 0x0f0120514, .val = 0x00000020 },
	{ .addr = 0x0f0120518, .val = 0x00000021 },
	{ .addr = 0x0f012051c, .val = 0x0000003d },
	{ .addr = 0x0f0120520, .val = 0x0000003f },
	{ .addr = 0x0f0120524, .val = 0x80000025 },
	{ .addr = 0x0f0120528, .val = 0x0000000c },
	{ .addr = 0x0f012052c, .val = 0x00000022 },
	{ .addr = 0x0f0120530, .val = 0x0000000b },
	{ .addr = 0x0f0120534, .val = 0x00000004 },
	{ .addr = 0x0f0120538, .val = 0x0000002c },
	{ .addr = 0x0f012053c, .val = 0x00000027 },
	{ .addr = 0x0f0120540, .val = 0x80000025 },
	{ .addr = 0x0f0120544, .val = 0x8000003a },
	{ .addr = 0x0f0120548, .val = 0x80000000 },
	{ .addr = 0x0f012054c, .val = 0x00000001 },
	{ .addr = 0x0f0120550, .val = 0x8000002d },
	{ .addr = 0x0f0120554, .val = 0x80000020 },
	{ .addr = 0x0f0120558, .val = 0x80000037 },
	{ .addr = 0x0f012055c, .val = 0x00000034 },
	{ .addr = 0x0f0120560, .val = 0x00000017 },
	{ .addr = 0x0f0120564, .val = 0x00000001 },
	{ .addr = 0x0f0120568, .val = 0x0000001b },
	{ .addr = 0x0f012056c, .val = 0x00000004 },
	{ .addr = 0x0f0120570, .val = 0x80000010 },
	{ .addr = 0x0f0120574, .val = 0x00000034 },
	{ .addr = 0x0f0120578, .val = 0x0000000f },
	{ .addr = 0x0f012057c, .val = 0x00000019 },
	{ .addr = 0x0f0120580, .val = 0x00000032 },
	{ .addr = 0x0f0120584, .val = 0x00000005 },
	{ .addr = 0x0f0120588, .val = 0x8000002e },
	{ .addr = 0x0f012058c, .val = 0x80000004 },
	{ .addr = 0x0f0120590, .val = 0x00000033 },
	{ .addr = 0x0f0120594, .val = 0x00000022 },
	{ .addr = 0x0f0120598, .val = 0x80000012 },
	{ .addr = 0x0f012059c, .val = 0x00000034 },
	{ .addr = 0x0f01205a0, .val = 0x0000000a },
	{ .addr = 0x0f01205a4, .val = 0x80000028 },
	{ .addr = 0x0f01205a8, .val = 0x8000001d },
	{ .addr = 0x0f01205ac, .val = 0x80000012 },
	{ .addr = 0x0f01205b0, .val = 0x80000013 },
	{ .addr = 0x0f01205b4, .val = 0x0000001b },
	{ .addr = 0x0f01205b8, .val = 0x80000016 },
	{ .addr = 0x0f01205bc, .val = 0x00000035 },
	{ .addr = 0x0f01205c0, .val = 0x00000029 },
	{ .addr = 0x0f01205c4, .val = 0x80000034 },
	{ .addr = 0x0f01205c8, .val = 0x8000003b },
	{ .addr = 0x0f01205cc, .val = 0x8000002e },
	{ .addr = 0x0f01205d0, .val = 0x8000003f },
	{ .addr = 0x0f01205d4, .val = 0x8000000f },
	{ .addr = 0x0f01205d8, .val = 0x8000000b },
	{ .addr = 0x0f01205dc, .val = 0x00000020 },
	{ .addr = 0x0f01205e0, .val = 0x80000026 },
	{ .addr = 0x0f01205e4, .val = 0x0000001c },
	{ .addr = 0x0f01205e8, .val = 0x0000003b },
	{ .addr = 0x0f01205ec, .val = 0x80000001 },
	{ .addr = 0x0f01205f0, .val = 0x00000002 },
	{ .addr = 0x0f01205f4, .val = 0x00000019 },
	{ .addr = 0x0f01205f8, .val = 0x00000011 },
	{ .addr = 0x0f01205fc, .val = 0x00000034 },
	{ .addr = 0x0f0120600, .val = 0x00000023 },
	{ .addr = 0x0f0120604, .val = 0x00000020 },
	{ .addr = 0x0f0120608, .val = 0x00000006 },
	{ .addr = 0x0f012060c, .val = 0x0000003a },
	{ .addr = 0x0f0120610, .val = 0x00000030 },
	{ .addr = 0x0f0120614, .val = 0x80000026 },
	{ .addr = 0x0f0120618, .val = 0x0000003a },
	{ .addr = 0x0f012061c, .val = 0x8000002f },
	{ .addr = 0x0f0120620, .val = 0x8000003e },
	{ .addr = 0x0f0120624, .val = 0x80000002 },
	{ .addr = 0x0f0120628, .val = 0x8000002e },
	{ .addr = 0x0f012062c, .val = 0x00000009 },
	{ .addr = 0x0f0120630, .val = 0x00000008 },
	{ .addr = 0x0f0120634, .val = 0x0000001f },
	{ .addr = 0x0f0120638, .val = 0x0000003c },
	{ .addr = 0x0f012063c, .val = 0x00000003 },
	{ .addr = 0x0f0120640, .val = 0x8000003b },
	{ .addr = 0x0f0120644, .val = 0x00000011 },
	{ .addr = 0x0f0120648, .val = 0x8000000e },
	{ .addr = 0x0f012064c, .val = 0x80000014 },
	{ .addr = 0x0f0120650, .val = 0x80000009 },
	{ .addr = 0x0f0120654, .val = 0x00000020 },
	{ .addr = 0x0f0120658, .val = 0x8000002b },
	{ .addr = 0x0f012065c, .val = 0x80000002 },
	{ .addr = 0x0f0120660, .val = 0x00000020 },
	{ .addr = 0x0f0120664, .val = 0x00000021 },
	{ .addr = 0x0f0120668, .val = 0x8000001a },
	{ .addr = 0x0f012066c, .val = 0x8000000c },
	{ .addr = 0x0f0120670, .val = 0x0000000e },
	{ .addr = 0x0f0120674, .val = 0x8000003a },
	{ .addr = 0x0f0120678, .val = 0x80000004 },
	{ .addr = 0x0f012067c, .val = 0x8000001d },
	{ .addr = 0x0f0120680, .val = 0x0000003f },
	{ .addr = 0x0f0120684, .val = 0x80000007 },
	{ .addr = 0x0f0120688, .val = 0x0000002c },
	{ .addr = 0x0f012068c, .val = 0x8000003c },
	{ .addr = 0x0f0120690, .val = 0x0000002f },
	{ .addr = 0x0f0120694, .val = 0x0000000d },
	{ .addr = 0x0f0120698, .val = 0x00000032 },
	{ .addr = 0x0f012069c, .val = 0x80000006 },
	{ .addr = 0x0f01206a0, .val = 0x8000000c },
	{ .addr = 0x0f01206a4, .val = 0x8000002a },
	{ .addr = 0x0f01206a8, .val = 0x0000003f },
	{ .addr = 0x0f01206ac, .val = 0x00000004 },
	{ .addr = 0x0f01206b0, .val = 0x00000034 },
	{ .addr = 0x0f01206b4, .val = 0x8000001b },
	{ .addr = 0x0f01206b8, .val = 0x8000002b },
	{ .addr = 0x0f01206bc, .val = 0x8000003e },
	{ .addr = 0x0f01206c0, .val = 0x80000009 },
	{ .addr = 0x0f01206c4, .val = 0x0000002b },
	{ .addr = 0x0f01206c8, .val = 0x80000006 },
	{ .addr = 0x0f01206cc, .val = 0x8000001d },
	{ .addr = 0x0f01206d0, .val = 0x0000001b },
	{ .addr = 0x0f01206d4, .val = 0x80000023 },
	{ .addr = 0x0f01206d8, .val = 0x80000039 },
	{ .addr = 0x0f01206dc, .val = 0x8000003c },
	{ .addr = 0x0f01206e0, .val = 0x0000003b },
	{ .addr = 0x0f01206e4, .val = 0x00000002 },
	{ .addr = 0x0f01206e8, .val = 0x8000001e },
	{ .addr = 0x0f01206ec, .val = 0x0000002e },
	{ .addr = 0x0f01206f0, .val = 0x80000037 },
	{ .addr = 0x0f01206f4, .val = 0x8000002b },
	{ .addr = 0x0f01206f8, .val = 0x00000018 },
	{ .addr = 0x0f01206fc, .val = 0x0000001c },
	{ .addr = 0x0f0120700, .val = 0x0000001f },
	{ .addr = 0x0f0120704, .val = 0x80000034 },
	{ .addr = 0x0f0120708, .val = 0x0000001b },
	{ .addr = 0x0f012070c, .val = 0x00000011 },
	{ .addr = 0x0f0120710, .val = 0x00000010 },
	{ .addr = 0x0f0120714, .val = 0x00000008 },
	{ .addr = 0x0f0120718, .val = 0x00000013 },
	{ .addr = 0x0f012071c, .val = 0x0000000b },
	{ .addr = 0x0f0120720, .val = 0x00000022 },
	{ .addr = 0x0f0120724, .val = 0x0000000e },
	{ .addr = 0x0f0120728, .val = 0x00000037 },
	{ .addr = 0x0f012072c, .val = 0x0000002c },
	{ .addr = 0x0f0120730, .val = 0x8000000a },
	{ .addr = 0x0f0120734, .val = 0x0000001d },
	{ .addr = 0x0f0120738, .val = 0x00000001 },
	{ .addr = 0x0f012073c, .val = 0x00000029 },
	{ .addr = 0x0f0120740, .val = 0x80000029 },
	{ .addr = 0x0f0120744, .val = 0x8000003a },
	{ .addr = 0x0f0120748, .val = 0x8000003a },
	{ .addr = 0x0f012074c, .val = 0x0000001b },
	{ .addr = 0x0f0120750, .val = 0x00000024 },
	{ .addr = 0x0f0120754, .val = 0x00000007 },
	{ .addr = 0x0f0120758, .val = 0x80000031 },
	{ .addr = 0x0f012075c, .val = 0x0000000c },
	{ .addr = 0x0f0120760, .val = 0x0000002b },
	{ .addr = 0x0f0120764, .val = 0x0000002f },
	{ .addr = 0x0f0120768, .val = 0x0000003b },
	{ .addr = 0x0f012076c, .val = 0x00000024 },
	{ .addr = 0x0f0120770, .val = 0x80000039 },
	{ .addr = 0x0f0120774, .val = 0x80000020 },
	{ .addr = 0x0f0120778, .val = 0x00000008 },
	{ .addr = 0x0f012077c, .val = 0x0000001b },
	{ .addr = 0x0f0120780, .val = 0x8000003d },
	{ .addr = 0x0f0120784, .val = 0x0000003f },
	{ .addr = 0x0f0120788, .val = 0x80000029 },
	{ .addr = 0x0f012078c, .val = 0x80000019 },
	{ .addr = 0x0f0120790, .val = 0x8000001a },
	{ .addr = 0x0f0120794, .val = 0x00000006 },
	{ .addr = 0x0f0120798, .val = 0x00000026 },
	{ .addr = 0x0f012079c, .val = 0x0000002c },
	{ .addr = 0x0f01207a0, .val = 0x00000011 },
	{ .addr = 0x0f01207a4, .val = 0x0000002f },
	{ .addr = 0x0f01207a8, .val = 0x80000022 },
	{ .addr = 0x0f01207ac, .val = 0x00000002 },
	{ .addr = 0x0f01207b0, .val = 0x00000025 },
	{ .addr = 0x0f01207b4, .val = 0x0000002e },
	{ .addr = 0x0f01207b8, .val = 0x80000034 },
	{ .addr = 0x0f01207bc, .val = 0x8000002f },
	{ .addr = 0x0f01207c0, .val = 0x80000002 },
	{ .addr = 0x0f01207c4, .val = 0x8000000b },
	{ .addr = 0x0f01207c8, .val = 0x80000031 },
	{ .addr = 0x0f01207cc, .val = 0x00000037 },
	{ .addr = 0x0f01207d0, .val = 0x80000038 },
	{ .addr = 0x0f01207d4, .val = 0x00000033 },
	{ .addr = 0x0f01207d8, .val = 0x80000038 },
	{ .addr = 0x0f01207dc, .val = 0x8000000b },
	{ .addr = 0x0f01207e0, .val = 0x00000006 },
	{ .addr = 0x0f01207e4, .val = 0x0000003e },
	{ .addr = 0x0f01207e8, .val = 0x80000025 },
	{ .addr = 0x0f01207ec, .val = 0x0000002e },
	{ .addr = 0x0f01207f0, .val = 0x0000002b },
	{ .addr = 0x0f01207f4, .val = 0x80000016 },
	{ .addr = 0x0f01207f8, .val = 0x80000021 },
	{ .addr = 0x0f01207fc, .val = 0x0000000a },
	{ .addr = 0x0f0120800, .val = 0x00056f83 },
	{ .addr = 0x0f0120804, .val = 0x0003914c },
	{ .addr = 0x0f0120808, .val = 0x000e3ff5 },
	{ .addr = 0x0f012080c, .val = 0x00014beb },
	{ .addr = 0x0f0120810, .val = 0x0004fff8 },
	{ .addr = 0x0f0120814, .val = 0x00069a82 },
	{ .addr = 0x0f0120818, .val = 0x000516c6 },
	{ .addr = 0x0f012081c, .val = 0x00007444 },
	{ .addr = 0x0f0120820, .val = 0x000010f9 },
	{ .addr = 0x0f0120824, .val = 0x000ffb3a },
	{ .addr = 0x0f0120828, .val = 0x0003adcf },
	{ .addr = 0x0f012082c, .val = 0x0007cf01 },
	{ .addr = 0x0f0120830, .val = 0x0000095d },
	{ .addr = 0x0f0120834, .val = 0x000dd160 },
	{ .addr = 0x0f0120838, .val = 0x00041a8a },
	{ .addr = 0x0f012083c, .val = 0x000f3e6f },
	{ .addr = 0x0f0120840, .val = 0x000b3d32 },
	{ .addr = 0x0f0120844, .val = 0x0001f0b6 },
	{ .addr = 0x0f0120848, .val = 0x000abb43 },
	{ .addr = 0x0f012084c, .val = 0x00042b82 },
	{ .addr = 0x0f0120850, .val = 0x000dcbde },
	{ .addr = 0x0f0120854, .val = 0x000ba1d9 },
	{ .addr = 0x0f0120858, .val = 0x00043e21 },
	{ .addr = 0x0f012085c, .val = 0x00006e1d },
	{ .addr = 0x0f0120860, .val = 0x000b532a },
	{ .addr = 0x0f0120864, .val = 0x000877f5 },
	{ .addr = 0x0f0120868, .val = 0x0008514c },
	{ .addr = 0x0f012086c, .val = 0x0005f592 },
	{ .addr = 0x0f0120870, .val = 0x000350ae },
	{ .addr = 0x0f0120874, .val = 0x000d0ce1 },
	{ .addr = 0x0f0120878, .val = 0x0002940c },
	{ .addr = 0x0f012087c, .val = 0x00033c7d },
	{ .addr = 0x0f0120880, .val = 0x00028ac0 },
	{ .addr = 0x0f0120884, .val = 0x000819ec },
	{ .addr = 0x0f0120888, .val = 0x000c6da7 },
	{ .addr = 0x0f012088c, .val = 0x000b07b6 },
	{ .addr = 0x0f0120890, .val = 0x000ad362 },
	{ .addr = 0x0f0120894, .val = 0x0002b43b },
	{ .addr = 0x0f0120898, .val = 0x000adf25 },
	{ .addr = 0x0f012089c, .val = 0x000fd208 },
	{ .addr = 0x0f01208a0, .val = 0x0004372c },
	{ .addr = 0x0f01208a4, .val = 0x000e6e33 },
	{ .addr = 0x0f01208a8, .val = 0x000483f7 },
	{ .addr = 0x0f01208ac, .val = 0x0002ce63 },
	{ .addr = 0x0f01208b0, .val = 0x00095545 },
	{ .addr = 0x0f01208b4, .val = 0x000a6f4c },
	{ .addr = 0x0f01208b8, .val = 0x0007081a },
	{ .addr = 0x0f01208bc, .val = 0x0009f6f2 },
	{ .addr = 0x0f01208c0, .val = 0x00077bcb },
	{ .addr = 0x0f01208c4, .val = 0x00024a1a },
	{ .addr = 0x0f01208c8, .val = 0x000ce5a4 },
	{ .addr = 0x0f01208cc, .val = 0x0008f278 },
	{ .addr = 0x0f01208d0, .val = 0x000d97a9 },
	{ .addr = 0x0f01208d4, .val = 0x000f3d01 },
	{ .addr = 0x0f01208d8, .val = 0x00084484 },
	{ .addr = 0x0f01208dc, .val = 0x00071010 },
	{ .addr = 0x0f01208e0, .val = 0x000e6248 },
	{ .addr = 0x0f01208e4, .val = 0x0006684f },
	{ .addr = 0x0f01208e8, .val = 0x000ea4f3 },
	{ .addr = 0x0f01208ec, .val = 0x000b9e1e },
	{ .addr = 0x0f01208f0, .val = 0x000e4723 },
	{ .addr = 0x0f01208f4, .val = 0x000afece },
	{ .addr = 0x0f01208f8, .val = 0x0007f7ab },
	{ .addr = 0x0f01208fc, .val = 0x00049c00 },
	{ .addr = 0x0f0120900, .val = 0x0a1a3071 },
	{ .addr = 0x0f0120904, .val = 0x0b695629 },
	{ .addr = 0x0f0120908, .val = 0x1be022b0 },
	{ .addr = 0x0f012090c, .val = 0x1e24f0ef },
	{ .addr = 0x0f0120910, .val = 0x1e700811 },
	{ .addr = 0x0f0120914, .val = 0x0a9b3bfb },
	{ .addr = 0x0f0120918, .val = 0x03a66d5c },
	{ .addr = 0x0f012091c, .val = 0x0d7519f6 },
	{ .addr = 0x0f0120920, .val = 0x159d8d77 },
	{ .addr = 0x0f0120924, .val = 0x19028445 },
	{ .addr = 0x0f0120928, .val = 0x15f755c1 },
	{ .addr = 0x0f012092c, .val = 0x101769a5 },
	{ .addr = 0x0f0120930, .val = 0x1fab3bf8 },
	{ .addr = 0x0f0120934, .val = 0x0fe427aa },
	{ .addr = 0x0f0120938, .val = 0x165ddba0 },
	{ .addr = 0x0f012093c, .val = 0x046237d2 },
	{ .addr = 0x0f0120940, .val = 0x01646090 },
	{ .addr = 0x0f0120944, .val = 0x0edbbb3e },
	{ .addr = 0x0f0120948, .val = 0x1710d66d },
	{ .addr = 0x0f012094c, .val = 0x12207242 },
	{ .addr = 0x0f0120950, .val = 0x0b3a446b },
	{ .addr = 0x0f0120954, .val = 0x0a99fc29 },
	{ .addr = 0x0f0120958, .val = 0x08c3d5a8 },
	{ .addr = 0x0f012095c, .val = 0x1a4921b2 },
	{ .addr = 0x0f0120960, .val = 0x12f77a7b },
	{ .addr = 0x0f0120964, .val = 0x08c52bc6 },
	{ .addr = 0x0f0120968, .val = 0x094b1570 },
	{ .addr = 0x0f012096c, .val = 0x1188c6b0 },
	{ .addr = 0x0f0120970, .val = 0x00fe88da },
	{ .addr = 0x0f0120974, .val = 0x1d4d733c },
	{ .addr = 0x0f0120978, .val = 0x132a325f },
	{ .addr = 0x0f012097c, .val = 0x1bf39201 },
	{ .addr = 0x0f0120980, .val = 0x1fab82de },
	{ .addr = 0x0f0120984, .val = 0x186fe234 },
	{ .addr = 0x0f0120988, .val = 0x160ff63d },
	{ .addr = 0x0f012098c, .val = 0x08e64834 },
	{ .addr = 0x0f0120990, .val = 0x164d1e5a },
	{ .addr = 0x0f0120994, .val = 0x1278e6dc },
	{ .addr = 0x0f0120998, .val = 0x1b2ff6ec },
	{ .addr = 0x0f012099c, .val = 0x1df2125a },
	{ .addr = 0x0f01209a0, .val = 0x0210b212 },
	{ .addr = 0x0f01209a4, .val = 0x1344eaab },
	{ .addr = 0x0f01209a8, .val = 0x00988550 },
	{ .addr = 0x0f01209ac, .val = 0x0a9a583a },
	{ .addr = 0x0f01209b0, .val = 0x0e9c33d5 },
	{ .addr = 0x0f01209b4, .val = 0x1a8127a9 },
	{ .addr = 0x0f01209b8, .val = 0x1101b3f0 },
	{ .addr = 0x0f01209bc, .val = 0x0442ce9d },
	{ .addr = 0x0f01209c0, .val = 0x0fe46555 },
	{ .addr = 0x0f01209c4, .val = 0x10e6211f },
	{ .addr = 0x0f01209c8, .val = 0x00b71594 },
	{ .addr = 0x0f01209cc, .val = 0x0f014cfe },
	{ .addr = 0x0f01209d0, .val = 0x0d05626c },
	{ .addr = 0x0f01209d4, .val = 0x044fca6f },
	{ .addr = 0x0f01209d8, .val = 0x12cf4745 },
	{ .addr = 0x0f01209dc, .val = 0x031cda93 },
	{ .addr = 0x0f01209e0, .val = 0x1a9a1749 },
	{ .addr = 0x0f01209e4, .val = 0x171a80e0 },
	{ .addr = 0x0f01209e8, .val = 0x10806e99 },
	{ .addr = 0x0f01209ec, .val = 0x1ba46a53 },
	{ .addr = 0x0f01209f0, .val = 0x04de2fbd },
	{ .addr = 0x0f01209f4, .val = 0x10b7c41b },
	{ .addr = 0x0f01209f8, .val = 0x14199413 },
	{ .addr = 0x0f01209fc, .val = 0x0bc934bd },
	{ .addr = 0x0f0120a00, .val = 0x004beb7c },
	{ .addr = 0x0f0120a04, .val = 0x0034b905 },
	{ .addr = 0x0f0120a08, .val = 0x002de281 },
	{ .addr = 0x0f0120a0c, .val = 0x00198ab4 },
	{ .addr = 0x0f0120a10, .val = 0x00234793 },
	{ .addr = 0x0f0120a14, .val = 0x001d3001 },
	{ .addr = 0x0f0120a18, .val = 0x001707bc },
	{ .addr = 0x0f0120a1c, .val = 0x00189b2b },
	{ .addr = 0x0f0120a20, .val = 0x0077d0cc },
	{ .addr = 0x0f0120a24, .val = 0x004ae08c },
	{ .addr = 0x0f0120a28, .val = 0x00312b93 },
	{ .addr = 0x0f0120a2c, .val = 0x0024094a },
	{ .addr = 0x0f0120a30, .val = 0x007d1e16 },
	{ .addr = 0x0f0120a34, .val = 0x00658b56 },
	{ .addr = 0x0f0120a38, .val = 0x0010786a },
	{ .addr = 0x0f0120a3c, .val = 0x0036e547 },
	{ .addr = 0x0f0120a40, .val = 0x004fad73 },
	{ .addr = 0x0f0120a44, .val = 0x004b579b },
	{ .addr = 0x0f0120a48, .val = 0x000ce982 },
	{ .addr = 0x0f0120a4c, .val = 0x0029866e },
	{ .addr = 0x0f0120a50, .val = 0x0036acb9 },
	{ .addr = 0x0f0120a54, .val = 0x001ad91c },
	{ .addr = 0x0f0120a58, .val = 0x00679d6f },
	{ .addr = 0x0f0120a5c, .val = 0x000b5a9a },
	{ .addr = 0x0f0120a60, .val = 0x00642bfa },
	{ .addr = 0x0f0120a64, .val = 0x007699d1 },
	{ .addr = 0x0f0120a68, .val = 0x00219d46 },
	{ .addr = 0x0f0120a6c, .val = 0x001c44b3 },
	{ .addr = 0x0f0120a70, .val = 0x002e3129 },
	{ .addr = 0x0f0120a74, .val = 0x000cd74f },
	{ .addr = 0x0f0120a78, .val = 0x0040024b },
	{ .addr = 0x0f0120a7c, .val = 0x00076483 },
	{ .addr = 0x0f0120a80, .val = 0x0034fe11 },
	{ .addr = 0x0f0120a84, .val = 0x0019a239 },
	{ .addr = 0x0f0120a88, .val = 0x0044054f },
	{ .addr = 0x0f0120a8c, .val = 0x002e1535 },
	{ .addr = 0x0f0120a90, .val = 0x005f6935 },
	{ .addr = 0x0f0120a94, .val = 0x001819a5 },
	{ .addr = 0x0f0120a98, .val = 0x0058f750 },
	{ .addr = 0x0f0120a9c, .val = 0x004c023d },
	{ .addr = 0x0f0120aa0, .val = 0x001fc48a },
	{ .addr = 0x0f0120aa4, .val = 0x000c5c6d },
	{ .addr = 0x0f0120aa8, .val = 0x0072c88c },
	{ .addr = 0x0f0120aac, .val = 0x004e3538 },
	{ .addr = 0x0f0120ab0, .val = 0x00122cc5 },
	{ .addr = 0x0f0120ab4, .val = 0x0043514d },
	{ .addr = 0x0f0120ab8, .val = 0x00664ee7 },
	{ .addr = 0x0f0120abc, .val = 0x0079e276 },
	{ .addr = 0x0f0120ac0, .val = 0x005e2dcf },
	{ .addr = 0x0f0120ac4, .val = 0x004c0be5 },
	{ .addr = 0x0f0120ac8, .val = 0x007d5e06 },
	{ .addr = 0x0f0120acc, .val = 0x0049be0d },
	{ .addr = 0x0f0120ad0, .val = 0x00146ab8 },
	{ .addr = 0x0f0120ad4, .val = 0x00513640 },
	{ .addr = 0x0f0120ad8, .val = 0x003ebe95 },
	{ .addr = 0x0f0120adc, .val = 0x006048bd },
	{ .addr = 0x0f0120ae0, .val = 0x0024798f },
	{ .addr = 0x0f0120ae4, .val = 0x003be3e6 },
	{ .addr = 0x0f0120ae8, .val = 0x0034aabb },
	{ .addr = 0x0f0120aec, .val = 0x00239fa7 },
	{ .addr = 0x0f0120af0, .val = 0x0037092b },
	{ .addr = 0x0f0120af4, .val = 0x00225550 },
	{ .addr = 0x0f0120af8, .val = 0x00731791 },
	{ .addr = 0x0f0120afc, .val = 0x0050387e },
	{ .addr = 0x0f0120b00, .val = 0x03d18f68 },
	{ .addr = 0x0f0120b04, .val = 0x01bce098 },
	{ .addr = 0x0f0120b08, .val = 0x01ffcac9 },
	{ .addr = 0x0f0120b0c, .val = 0x0701c2a3 },
	{ .addr = 0x0f0120b10, .val = 0x01a29a46 },
	{ .addr = 0x0f0120b14, .val = 0x0646e037 },
	{ .addr = 0x0f0120b18, .val = 0x07e7cc2a },
	{ .addr = 0x0f0120b1c, .val = 0x0430d40d },
	{ .addr = 0x0f0120b20, .val = 0x0072c78a },
	{ .addr = 0x0f0120b24, .val = 0x064f408d },
	{ .addr = 0x0f0120b28, .val = 0x03214abf },
	{ .addr = 0x0f0120b2c, .val = 0x0195e53c },
	{ .addr = 0x0f0120b30, .val = 0x03520a54 },
	{ .addr = 0x0f0120b34, .val = 0x01ee70ca },
	{ .addr = 0x0f0120b38, .val = 0x07a5dd71 },
	{ .addr = 0x0f0120b3c, .val = 0x0421a36e },
	{ .addr = 0x0f0120b40, .val = 0x0526d946 },
	{ .addr = 0x0f0120b44, .val = 0x05f93263 },
	{ .addr = 0x0f0120b48, .val = 0x04fc8143 },
	{ .addr = 0x0f0120b4c, .val = 0x0492369f },
	{ .addr = 0x0f0120b50, .val = 0x00b63ad8 },
	{ .addr = 0x0f0120b54, .val = 0x0466de6f },
	{ .addr = 0x0f0120b58, .val = 0x00ba3fbe },
	{ .addr = 0x0f0120b5c, .val = 0x05e15eae },
	{ .addr = 0x0f0120b60, .val = 0x06984bcf },
	{ .addr = 0x0f0120b64, .val = 0x021ad3d9 },
	{ .addr = 0x0f0120b68, .val = 0x059e9b6e },
	{ .addr = 0x0f0120b6c, .val = 0x01b195cd },
	{ .addr = 0x0f0120b70, .val = 0x064d2821 },
	{ .addr = 0x0f0120b74, .val = 0x02778db9 },
	{ .addr = 0x0f0120b78, .val = 0x0104cb3b },
	{ .addr = 0x0f0120b7c, .val = 0x05b4fa54 },
	{ .addr = 0x0f0120b80, .val = 0x0776fb60 },
	{ .addr = 0x0f0120b84, .val = 0x04e24d38 },
	{ .addr = 0x0f0120b88, .val = 0x033dfe70 },
	{ .addr = 0x0f0120b8c, .val = 0x04a7f740 },
	{ .addr = 0x0f0120b90, .val = 0x04490ea1 },
	{ .addr = 0x0f0120b94, .val = 0x073b1120 },
	{ .addr = 0x0f0120b98, .val = 0x06766be8 },
	{ .addr = 0x0f0120b9c, .val = 0x04ca2c4a },
	{ .addr = 0x0f0120ba0, .val = 0x07501256 },
	{ .addr = 0x0f0120ba4, .val = 0x03d88ffa },
	{ .addr = 0x0f0120ba8, .val = 0x0407d485 },
	{ .addr = 0x0f0120bac, .val = 0x07f7f945 },
	{ .addr = 0x0f0120bb0, .val = 0x062e1c13 },
	{ .addr = 0x0f0120bb4, .val = 0x04c00aa1 },
	{ .addr = 0x0f0120bb8, .val = 0x039b95ba },
	{ .addr = 0x0f0120bbc, .val = 0x039ebf44 },
	{ .addr = 0x0f0120bc0, .val = 0x058f56b9 },
	{ .addr = 0x0f0120bc4, .val = 0x0743aedd },
	{ .addr = 0x0f0120bc8, .val = 0x0403e132 },
	{ .addr = 0x0f0120bcc, .val = 0x072f610f },
	{ .addr = 0x0f0120bd0, .val = 0x069ce238 },
	{ .addr = 0x0f0120bd4, .val = 0x006c5901 },
	{ .addr = 0x0f0120bd8, .val = 0x05afcc93 },
	{ .addr = 0x0f0120bdc, .val = 0x065ad94b },
	{ .addr = 0x0f0120be0, .val = 0x0341dc2e },
	{ .addr = 0x0f0120be4, .val = 0x03afbaef },
	{ .addr = 0x0f0120be8, .val = 0x034372ba },
	{ .addr = 0x0f0120bec, .val = 0x03d2dd4d },
	{ .addr = 0x0f0120bf0, .val = 0x044e9f34 },
	{ .addr = 0x0f0120bf4, .val = 0x00ba4639 },
	{ .addr = 0x0f0120bf8, .val = 0x028a76d5 },
	{ .addr = 0x0f0120bfc, .val = 0x0490bb70 },
	{ .addr = 0x0f0120c00, .val = 0x0e6ae66a },
	{ .addr = 0x0f0120c04, .val = 0x02178b1c },
	{ .addr = 0x0f0120c08, .val = 0x09db9a58 },
	{ .addr = 0x0f0120c0c, .val = 0x0f8e7917 },
	{ .addr = 0x0f0120c10, .val = 0x0e33bcaf },
	{ .addr = 0x0f0120c14, .val = 0x0cd871de },
	{ .addr = 0x0f0120c18, .val = 0x0b919ce9 },
	{ .addr = 0x0f0120c1c, .val = 0x04e1a106 },
	{ .addr = 0x0f0120c20, .val = 0x02a384b5 },
	{ .addr = 0x0f0120c24, .val = 0x0d1d5dd7 },
	{ .addr = 0x0f0120c28, .val = 0x08145074 },
	{ .addr = 0x0f0120c2c, .val = 0x0c44af3e },
	{ .addr = 0x0f0120c30, .val = 0x00ea24c2 },
	{ .addr = 0x0f0120c34, .val = 0x0ddd327a },
	{ .addr = 0x0f0120c38, .val = 0x02d8cc14 },
	{ .addr = 0x0f0120c3c, .val = 0x07410ab5 },
	{ .addr = 0x0f0120c40, .val = 0x0cff71c0 },
	{ .addr = 0x0f0120c44, .val = 0x0d44394f },
	{ .addr = 0x0f0120c48, .val = 0x0a817d78 },
	{ .addr = 0x0f0120c4c, .val = 0x0eb0256c },
	{ .addr = 0x0f0120c50, .val = 0x0fbbed65 },
	{ .addr = 0x0f0120c54, .val = 0x02c25ca4 },
	{ .addr = 0x0f0120c58, .val = 0x0d0ad7a3 },
	{ .addr = 0x0f0120c5c, .val = 0x049c716a },
	{ .addr = 0x0f0120c60, .val = 0x048283a0 },
	{ .addr = 0x0f0120c64, .val = 0x079a71e9 },
	{ .addr = 0x0f0120c68, .val = 0x080251de },
	{ .addr = 0x0f0120c6c, .val = 0x02699da4 },
	{ .addr = 0x0f0120c70, .val = 0x017753ad },
	{ .addr = 0x0f0120c74, .val = 0x028be503 },
	{ .addr = 0x0f0120c78, .val = 0x078d54a6 },
	{ .addr = 0x0f0120c7c, .val = 0x01176ca6 },
	{ .addr = 0x0f0120c80, .val = 0x0006de74 },
	{ .addr = 0x0f0120c84, .val = 0x000187d1 },
	{ .addr = 0x0f0120c88, .val = 0x000424bd },
	{ .addr = 0x0f0120c8c, .val = 0x0005bd69 },
	{ .addr = 0x0f0120c90, .val = 0x000162ba },
	{ .addr = 0x0f0120c94, .val = 0x0005b2f6 },
	{ .addr = 0x0f0120c98, .val = 0x00025a39 },
	{ .addr = 0x0f0120c9c, .val = 0x00064db3 },
	{ .addr = 0x0f0120ca0, .val = 0x000296aa },
	{ .addr = 0x0f0120ca4, .val = 0x0007cab5 },
	{ .addr = 0x0f0120ca8, .val = 0x000591b4 },
	{ .addr = 0x0f0120cac, .val = 0x0002b543 },
	{ .addr = 0x0f0120cb0, .val = 0x0005e565 },
	{ .addr = 0x0f0120cb4, .val = 0x00064620 },
	{ .addr = 0x0f0120cb8, .val = 0x0003fd2a },
	{ .addr = 0x0f0120cbc, .val = 0x00010708 },
	{ .addr = 0x0f0120d00, .val = 0x000d8559 },
	{ .addr = 0x0f0120d04, .val = 0x001e02f0 },
	{ .addr = 0x0f0120d08, .val = 0x000e82b9 },
	{ .addr = 0x0f0120d0c, .val = 0x0013c5d1 },
	{ .addr = 0x0f0120d10, .val = 0x0003c7c0 },
	{ .addr = 0x0f0120d14, .val = 0x001de499 },
	{ .addr = 0x0f0120d18, .val = 0x00170758 },
	{ .addr = 0x0f0120d1c, .val = 0x000b2188 },
	{ .addr = 0x0f0120d20, .val = 0x001006e8 },
	{ .addr = 0x0f0120d24, .val = 0x00036341 },
	{ .addr = 0x0f0120d28, .val = 0x001ce2b9 },
	{ .addr = 0x0f0120d2c, .val = 0x000202d1 },
	{ .addr = 0x0f0120d30, .val = 0x000ee689 },
	{ .addr = 0x0f0120d34, .val = 0x000d0281 },
	{ .addr = 0x0f0120d38, .val = 0x0011e3a9 },
	{ .addr = 0x0f0120d3c, .val = 0x0013c1e1 },
	{ .addr = 0x0f0120d40, .val = 0x0006a790 },
	{ .addr = 0x0f0120d44, .val = 0x000b2309 },
	{ .addr = 0x0f0120d48, .val = 0x00016610 },
	{ .addr = 0x0f0120d4c, .val = 0x000ac1b0 },
	{ .addr = 0x0f0120d50, .val = 0x0017e288 },
	{ .addr = 0x0f0120d54, .val = 0x00132779 },
	{ .addr = 0x0f0120d58, .val = 0x0009a6b9 },
	{ .addr = 0x0f0120d5c, .val = 0x0017c249 },
	{ .addr = 0x0f0120d60, .val = 0x001644d0 },
	{ .addr = 0x0f0120d64, .val = 0x001be348 },
	{ .addr = 0x0f0120d68, .val = 0x001b64c9 },
	{ .addr = 0x0f0120d6c, .val = 0x0009a098 },
	{ .addr = 0x0f0120d70, .val = 0x0015c5e9 },
	{ .addr = 0x0f0120d74, .val = 0x0015c459 },
	{ .addr = 0x0f0120d78, .val = 0x0001e4d1 },
	{ .addr = 0x0f0120d7c, .val = 0x0005e161 },
	{ .addr = 0x0f0120d80, .val = 0x0010e0b9 },
	{ .addr = 0x0f0120d84, .val = 0x001320f1 },
	{ .addr = 0x0f0120d88, .val = 0x0014c240 },
	{ .addr = 0x0f0120d8c, .val = 0x0005e7d9 },
	{ .addr = 0x0f0120d90, .val = 0x001da7a9 },
	{ .addr = 0x0f0120d94, .val = 0x0013a301 },
	{ .addr = 0x0f0120d98, .val = 0x001ae2e8 },
	{ .addr = 0x0f0120d9c, .val = 0x001f4600 },
	{ .addr = 0x0f0120da0, .val = 0x00126018 },
	{ .addr = 0x0f0120da4, .val = 0x001f84f1 },
	{ .addr = 0x0f0120da8, .val = 0x000301f9 },
	{ .addr = 0x0f0120dac, .val = 0x0013e3f0 },
	{ .addr = 0x0f0120db0, .val = 0x001e8208 },
	{ .addr = 0x0f0120db4, .val = 0x000de4a8 },
	{ .addr = 0x0f0120db8, .val = 0x001aa739 },
	{ .addr = 0x0f0120dbc, .val = 0x000f2378 },
	{ .addr = 0x0f0120dc0, .val = 0x000e8019 },
	{ .addr = 0x0f0120dc4, .val = 0x000bc191 },
	{ .addr = 0x0f0120dc8, .val = 0x0008c4b0 },
	{ .addr = 0x0f0120dcc, .val = 0x001222c0 },
	{ .addr = 0x0f0120dd0, .val = 0x00020619 },
	{ .addr = 0x0f0120dd4, .val = 0x001fa7d9 },
	{ .addr = 0x0f0120dd8, .val = 0x0009c488 },
	{ .addr = 0x0f0120ddc, .val = 0x0011e631 },
	{ .addr = 0x0f0120de0, .val = 0x001dc1c9 },
	{ .addr = 0x0f0120de4, .val = 0x000cc5b8 },
	{ .addr = 0x0f0120de8, .val = 0x0002a648 },
	{ .addr = 0x0f0120dec, .val = 0x00048668 },
	{ .addr = 0x0f0120df0, .val = 0x001061a9 },
	{ .addr = 0x0f0120df4, .val = 0x000d8689 },
	{ .addr = 0x0f0120df8, .val = 0x000cc589 },
	{ .addr = 0x0f0120dfc, .val = 0x00116279 },
	{ .addr = 0x0f1c00004, .val = 0x41000100 },
	{ .addr = 0x0f1c00008, .val = 0x0000000c },
	{ .addr = 0x0f1c0000c, .val = 0xd79c6670 },
	{ .addr = 0x0f1c00010, .val = 0xf573bd7e },
	{ .addr = 0x0f1c00014, .val = 0x25d5aaef },
	{ .addr = 0x0f1c00018, .val = 0x48c9447d },
	{ .addr = 0x0f1c0001c, .val = 0x6223a328 },
	{ .addr = 0x0f1c00020, .val = 0xf8679439 },
	{ .addr = 0x0f1c00024, .val = 0xc3baceaf },
	{ .addr = 0x0f1c00028, .val = 0x530ea33b },
	{ .addr = 0x0f1c0002c, .val = 0xdee76f89 },
	{ .addr = 0x0f1c00030, .val = 0xf818c3b3 },
	{ .addr = 0x0f1c00034, .val = 0xd82c5be6 },
	{ .addr = 0x0f1c00038, .val = 0xd0cb467d },
	{ .addr = 0x0f1c0003c, .val = 0x8de43162 },
	{ .addr = 0x0f1c00040, .val = 0x59ac4761 },
	{ .addr = 0x0f1c00044, .val = 0x6f52b81a },
	{ .addr = 0x0f1c00048, .val = 0x61ccb9b0 },
	{ .addr = 0x0f1c0004c, .val = 0x76d0e08a },
	{ .addr = 0x0f1c00050, .val = 0xb3703ef0 },
	{ .addr = 0x0f1c00054, .val = 0x7fe1527e },
	{ .addr = 0x0f1c00058, .val = 0x11b4e6de },
	{ .addr = 0x0f1c0005c, .val = 0x0227c8c4 },
	{ .addr = 0x0f1c00060, .val = 0x751bba7b },
	{ .addr = 0x0f1c00064, .val = 0xc4ca708d },
	{ .addr = 0x0f1c00068, .val = 0x22da4411 },
	{ .addr = 0x0f1c0006c, .val = 0x46641092 },
	{ .addr = 0x0f1c00070, .val = 0x07c464b7 },
	{ .addr = 0x0f1c00074, .val = 0x626bf689 },
	{ .addr = 0x0f1c00078, .val = 0xdba387dc },
	{ .addr = 0x0f1c0007c, .val = 0x1441f2d5 },
	{ .addr = 0x0f1c00080, .val = 0x78908529 },
	{ .addr = 0x0f1c00084, .val = 0xbe77dcaf },
	{ .addr = 0x0f1c00088, .val = 0x0dd4efc4 },
	{ .addr = 0x0f1c0008c, .val = 0xe7bdc16b },
	{ .addr = 0x0f1c00090, .val = 0xd0746ed9 },
	{ .addr = 0x0f1c00094, .val = 0x00000000 },
	{ .addr = 0x0f1c0021c, .val = 0x0fb590a9 },
	{ .addr = 0x0f1c00220, .val = 0x1cea0179 },
	{ .addr = 0x0f1c00224, .val = 0x0b033a6f },
	{ .addr = 0x0f1c00228, .val = 0x7dd4c78f },
	{ .addr = 0x0f1c0022c, .val = 0xec47bc70 },
	{ .addr = 0x0f1c00230, .val = 0x2a3e9971 },
	{ .addr = 0x0f1c00234, .val = 0xc8b21d7f },
	{ .addr = 0x0f1c00238, .val = 0xcf4e7d20 },
	{ .addr = 0x0f1c0023c, .val = 0x11cdc12a },
	{ .addr = 0x0f1c00240, .val = 0x0cef4dcb },
	{ .addr = 0x0f1c00244, .val = 0xcbddb2c5 },
	{ .addr = 0x0f1c00248, .val = 0xd7880686 },
	{ .addr = 0x0f1c0024c, .val = 0xfaa57402 },
	{ .addr = 0x0f1c00250, .val = 0x1af9fe5a },
	{ .addr = 0x0f1c00254, .val = 0x1b09fa44 },
	{ .addr = 0x0f1c00258, .val = 0xa82d453a },
	{ .addr = 0x0f1c0025c, .val = 0x63b31d11 },
	{ .addr = 0x0f1c00260, .val = 0xbd8c460e },
	{ .addr = 0x0f1c00264, .val = 0xcb33fe72 },
	{ .addr = 0x0f1c00268, .val = 0x1654c1b4 },
	{ .addr = 0x0f1c0026c, .val = 0xd6421c4d },
	{ .addr = 0x0f1c00270, .val = 0x3c90fd7f },
	{ .addr = 0x0f1c00274, .val = 0xb0b42f90 },
	{ .addr = 0x0f1c00278, .val = 0x4d60aab3 },
	{ .addr = 0x0f1c0027c, .val = 0x32e033e1 },
	{ .addr = 0x0f1c00280, .val = 0x7b03a2f0 },
	{ .addr = 0x0f1c00284, .val = 0xe3d58dac },
	{ .addr = 0x0f1c00288, .val = 0x237fdd1e },
	{ .addr = 0x0f1c0028c, .val = 0x7cc8b6ab },
	{ .addr = 0x0f1c00290, .val = 0xa2134920 },
	{ .addr = 0x0f1c00294, .val = 0x04875c38 },
	{ .addr = 0x0f1c00298, .val = 0x5992a5a6 },
	{ .addr = 0x0f1c0029c, .val = 0xded37f47 },
	{ .addr = 0x0f1c002a0, .val = 0x8e02271c },
	{ .addr = 0x0f1c002a4, .val = 0xec840f58 },
	{ .addr = 0x0f1c002a8, .val = 0x0022b98a },
	{ .addr = 0x0f1c002ac, .val = 0x6d60ff20 },
	{ .addr = 0x0f1c002b0, .val = 0xd8221c52 },
	{ .addr = 0x0f1c002b4, .val = 0xf265fbfe },
	{ .addr = 0x0f1c002b8, .val = 0xe6561419 },
	{ .addr = 0x0f1c002bc, .val = 0x55bb0241 },
	{ .addr = 0x0f1c002c0, .val = 0xbb2833a3 },
	{ .addr = 0x0f1c002c4, .val = 0xabda5048 },
	{ .addr = 0x0f1c002c8, .val = 0x79195fbb },
	{ .addr = 0x0f1c002cc, .val = 0x95dc02ce },
	{ .addr = 0x0f1c002d0, .val = 0x5237ebfd },
	{ .addr = 0x0f1c002d4, .val = 0x9ff89309 },
	{ .addr = 0x0f1c002d8, .val = 0xa09416fb },
	{ .addr = 0x0f1c002dc, .val = 0x455b3a1d },
	{ .addr = 0x0f1c002e0, .val = 0x9c82cfc1 },
	{ .addr = 0x0f1c002e4, .val = 0x9117a1c0 },
	{ .addr = 0x0f1c002e8, .val = 0x0dc36ea6 },
	{ .addr = 0x0f1c002ec, .val = 0x39c705ea },
	{ .addr = 0x0f1c002f0, .val = 0x2473dc28 },
	{ .addr = 0x0f1c002f4, .val = 0x17bbfd66 },
	{ .addr = 0x0f1c002f8, .val = 0xac3f929e },
	{ .addr = 0x0f1c002fc, .val = 0x7b961258 },
	{ .addr = 0x0f1c00300, .val = 0xc910e28d },
	{ .addr = 0x0f1c00304, .val = 0x3afdfbba },
	{ .addr = 0x0f1c00308, .val = 0x4c02d28c },
	{ .addr = 0x0f1c0030c, .val = 0x8765a441 },
	{ .addr = 0x0f1c00310, .val = 0x826ef16f },
	{ .addr = 0x0f1c00314, .val = 0x333db52f },
	{ .addr = 0x0f1c00318, .val = 0xde42907b },
	{ .addr = 0x0f1c0031c, .val = 0xbec3a927 },
	{ .addr = 0x0f1c00320, .val = 0xf039feb7 },
	{ .addr = 0x0f1c00324, .val = 0x95876ac8 },
	{ .addr = 0x0f1c00328, .val = 0x000faaaa },
	{ .addr = 0x0f1c0032c, .val = 0x00000000 },
	{ .addr = 0x0f1c00330, .val = 0x02030200 },
	{ .addr = 0x0f1c00338, .val = 0x213f7cb5 },
	{ .addr = 0x0f1c0033c, .val = 0xf760e007 },
	{ .addr = 0x0f1c00340, .val = 0x7aeb44ec },
	{ .addr = 0x0f1c00344, .val = 0x2868a5bc },
	{ .addr = 0x0f1800000, .val = 0x00000002 },
	{ .addr = 0x0f1800004, .val = 0x00001c53 },
	{ .addr = 0x0f1800008, .val = 0x08620b8d },
	{ .addr = 0x0f180000c, .val = 0x08db0891 },
	{ .addr = 0x0f1800010, .val = 0x78329ef4 },
	{ .addr = 0x0f1800014, .val = 0xed1cb7fe },
	{ .addr = 0x0f1800018, .val = 0x054b0f4c },
	{ .addr = 0x0f180001c, .val = 0x179c5e62 },
	{ .addr = 0x0f180002c, .val = 0x9077671a },
	{ .addr = 0x0f1800030, .val = 0xd7f05640 },
	{ .addr = 0x0f1800034, .val = 0x506011e4 },
	{ .addr = 0x0f1800044, .val = 0x680c888f },
	{ .addr = 0x0f1800048, .val = 0xf0697559 },
	{ .addr = 0x0f180004c, .val = 0x7535ed35 },
	{ .addr = 0x0f180005c, .val = 0xbb815f63 },
	{ .addr = 0x0f1800060, .val = 0x2e975987 },
	{ .addr = 0x0f1800064, .val = 0xa3b2b32c },
	{ .addr = 0x0f1800074, .val = 0x00155831 },
	{ .addr = 0x0f1800078, .val = 0x6c856bad },
	{ .addr = 0x0f180007c, .val = 0x8c84dbae },
	{ .addr = 0x0f1800080, .val = 0x5a3a3dd7 },
	{ .addr = 0x0f18000ac, .val = 0x00000001 },
	{ .addr = 0x0f1800100, .val = 0x00008001 },
	{ .addr = 0x0f1800104, .val = 0x06080f05 },
	{ .addr = 0x0f1800108, .val = 0x00003a8f },
	{ .addr = 0x0f180010c, .val = 0x0006d87a },
	{ .addr = 0x0f1800118, .val = 0x80019f02 },
	{ .addr = 0x0f1d00008, .val = 0x00010001 },
	{ .addr = 0x0f1d00010, .val = 0x7f9ed27a },
	{ .addr = 0x0f1d00014, .val = 0xede8fac2 },
	{ .addr = 0x0f1d0002c, .val = 0x0000000b },
	{ .addr = 0x0f1d00030, .val = 0xbd325296 },
	{ .addr = 0x0f1d00034, .val = 0x1e51fd25 },
	{ .addr = 0x0f1d00038, .val = 0x3041da56 },
	{ .addr = 0x0f1d0003c, .val = 0xd55fcf59 },
	{ .addr = 0x0f1d00040, .val = 0x2defc707 },
	{ .addr = 0x0f1d00044, .val = 0xb08fc696 },
	{ .addr = 0x0f1d00048, .val = 0xd213af72 },
	{ .addr = 0x0f1d0004c, .val = 0x3cfc3131 },
	{ .addr = 0x0f1d00050, .val = 0xaf08b902 },
	{ .addr = 0x0f1d00054, .val = 0x1640f53c },
	{ .addr = 0x0f1d00058, .val = 0x58e2d54e },
	{ .addr = 0x0f1d0005c, .val = 0x3a2cab0a },
	{ .addr = 0x0f1d00060, .val = 0xc1737fe4 },
	{ .addr = 0x0f1d00064, .val = 0xd72c75da },
	{ .addr = 0x0f1d00068, .val = 0xbcee9c52 },
	{ .addr = 0x0f1d0006c, .val = 0xc74766e1 },
	{ .addr = 0x0f1e00c08, .val = 0x00000000 },
	{ .addr = 0x0f1e00c10, .val = 0x16fd5002 },
	{ .addr = 0x0f1e00c14, .val = 0x8e85327f },
	{ .addr = 0x0f1e00c2c, .val = 0x000000c2 },
	{ .addr = 0x0f1e00c30, .val = 0x7eaf3a2d },
	{ .addr = 0x0f1e00c34, .val = 0x282386e0 },
	{ .addr = 0x0f1e00c38, .val = 0x266653d9 },
	{ .addr = 0x0f1e00c3c, .val = 0xfb0fd734 },
	{ .addr = 0x0f1e00c40, .val = 0x64f5dca0 },
	{ .addr = 0x0f1e00c44, .val = 0x1bd5499c },
	{ .addr = 0x0f1e00c48, .val = 0x790a5f2b },
	{ .addr = 0x0f1e00c4c, .val = 0xd84df992 },
	{ .addr = 0x0f1e00c50, .val = 0xb4243780 },
	{ .addr = 0x0f1e00c54, .val = 0x4ab010dc },
	{ .addr = 0x0f1e00c58, .val = 0x8356e202 },
	{ .addr = 0x0f1e00c5c, .val = 0xbb0b8e81 },
	{ .addr = 0x0f1e00c60, .val = 0xe47ed5ea },
	{ .addr = 0x0f1e00c64, .val = 0x725ce25e },
	{ .addr = 0x0f1e00c68, .val = 0xd8e7e891 },
	{ .addr = 0x0f1e00c6c, .val = 0x72ba25a4 },
	{ .addr = 0x0f2000000, .val = 0x000001a2 },
	{ .addr = 0x0f2000004, .val = 0x000038db },
	{ .addr = 0x0f2000008, .val = 0x0000ee8b },
	{ .addr = 0x0f200000c, .val = 0x00001741 },
	{ .addr = 0x0f2000010, .val = 0x0000e3b9 },
	{ .addr = 0x0f2000014, .val = 0x00007069 },
	{ .addr = 0x0f2000018, .val = 0x00000b1f },
	{ .addr = 0x0f200001c, .val = 0x000050f5 },
	{ .addr = 0x0f2000020, .val = 0x00009f2e },
	{ .addr = 0x0f2000024, .val = 0x0000e45d },
	{ .addr = 0x0f2000028, .val = 0x0000f70a },
	{ .addr = 0x0f200002c, .val = 0x0000dc77 },
	{ .addr = 0x0f2000030, .val = 0x0000408c },
	{ .addr = 0x0f2000034, .val = 0x00003980 },
	{ .addr = 0x0f2000038, .val = 0x0000281d },
	{ .addr = 0x0f200003c, .val = 0x0000a870 },
	{ .addr = 0x0f2000040, .val = 0x000023ed },
	{ .addr = 0x0f2000044, .val = 0x000076df },
	{ .addr = 0x0f2000048, .val = 0x000023a7 },
	{ .addr = 0x0f0006004, .val = 0x98581511 },
	{ .addr = 0x0f0006008, .val = 0x31c33278 },
	{ .addr = 0x0f000600c, .val = 0x327f7173 },
	{ .addr = 0x0f0006010, .val = 0x5a8569b5 },
	{ .addr = 0x0f0006014, .val = 0xb379b632 },
	{ .addr = 0x0f0006020, .val = 0x0000043c },
	{ .addr = 0x0f0006024, .val = 0x0004c020 },
	{ .addr = 0x0f0006028, .val = 0x00000001 },
	{ .addr = 0x0f000602c, .val = 0x000051fc },
	{ .addr = 0x0f0006030, .val = 0x00000a6b },
	{ .addr = 0x0f0006034, .val = 0x00008d0e },
	{ .addr = 0x0f0006038, .val = 0x000034c5 },
	{ .addr = 0x0f0006040, .val = 0x89c1018a },
	{ .addr = 0x0f0006044, .val = 0x22530237 },
	{ .addr = 0x0f0006048, .val = 0x6abb0044 },
	{ .addr = 0x0f000604c, .val = 0x400d00c3 },
	{ .addr = 0x0f0006050, .val = 0x789d0364 },
	{ .addr = 0x0f0006054, .val = 0x90400315 },
	{ .addr = 0x0f0006058, .val = 0x6b2c017a },
	{ .addr = 0x0f000605c, .val = 0x3a450242 },
	{ .addr = 0x0f0006060, .val = 0x93b4023d },
	{ .addr = 0x0f0006064, .val = 0x490b010d },
	{ .addr = 0x0f0006068, .val = 0x83c90172 },
	{ .addr = 0x0f000606c, .val = 0x1aae0030 },
	{ .addr = 0x0f0006070, .val = 0xc8d2009b },
	{ .addr = 0x0f0006074, .val = 0xe39501f9 },
	{ .addr = 0x0f0006078, .val = 0x48c700f9 },
	{ .addr = 0x0f000607c, .val = 0xa2c50274 },
	{ .addr = 0x0f0006080, .val = 0x320f03ca },
	{ .addr = 0x0f0006084, .val = 0x430b0244 },
	{ .addr = 0x0f0006088, .val = 0x2b5c02c1 },
	{ .addr = 0x0f000608c, .val = 0x33aa001d },
	{ .addr = 0x0f0006090, .val = 0x2a5302fb },
	{ .addr = 0x0f0006094, .val = 0x890502ba },
	{ .addr = 0x0f0006098, .val = 0x22d0032d },
	{ .addr = 0x0f000609c, .val = 0xc8b70141 },
	{ .addr = 0x0f00060a0, .val = 0x2b610233 },
	{ .addr = 0x0f00060a4, .val = 0x61fd0032 },
	{ .addr = 0x0f00060a8, .val = 0x08250233 },
	{ .addr = 0x0f00060ac, .val = 0x31bb0178 },
	{ .addr = 0x0f00060b0, .val = 0x6861023b },
	{ .addr = 0x0f00060b4, .val = 0xc8e20063 },
	{ .addr = 0x0f00060b8, .val = 0x4bd700dc },
	{ .addr = 0x0f00060bc, .val = 0xdb1201cc },
	{ .addr = 0x0f00060c0, .val = 0x91b103a0 },
	{ .addr = 0x0f00060c4, .val = 0x537a00c6 },
	{ .addr = 0x0f00060c8, .val = 0xd15d0045 },
	{ .addr = 0x0f00060cc, .val = 0xf97f005c },
	{ .addr = 0x0f00060d0, .val = 0x50100156 },
	{ .addr = 0x0f00060d4, .val = 0x091b016e },
	{ .addr = 0x0f00060d8, .val = 0x480a011a },
	{ .addr = 0x0f00060dc, .val = 0xf3b0001d },
	{ .addr = 0x0f00060e0, .val = 0x82be00ed },
	{ .addr = 0x0f00060e4, .val = 0xb24303f7 },
	{ .addr = 0x0f00060e8, .val = 0x79e60369 },
	{ .addr = 0x0f00060ec, .val = 0x68c50367 },
	{ .addr = 0x0f00060f0, .val = 0xe380013b },
	{ .addr = 0x0f00060f4, .val = 0x625e0256 },
	{ .addr = 0x0f00060f8, .val = 0x085d03d3 },
	{ .addr = 0x0f00060fc, .val = 0x404802a3 },
	{ .addr = 0x0f0006100, .val = 0x22ce0009 },
	{ .addr = 0x0f0006104, .val = 0x99ac0096 },
	{ .addr = 0x0f0006108, .val = 0xe2f60231 },
	{ .addr = 0x0f000610c, .val = 0x403e007f },
	{ .addr = 0x0f0006110, .val = 0xfa5601d8 },
	{ .addr = 0x0f0006114, .val = 0xd8870056 },
	{ .addr = 0x0f0006118, .val = 0x68390101 },
	{ .addr = 0x0f000611c, .val = 0xf2390016 },
	{ .addr = 0x0f0006120, .val = 0xcaf6037e },
	{ .addr = 0x0f0006124, .val = 0x09e10290 },
	{ .addr = 0x0f0006128, .val = 0x40f20307 },
	{ .addr = 0x0f000612c, .val = 0xeaf2012b },
	{ .addr = 0x0f0006130, .val = 0x789602be },
	{ .addr = 0x0f0006134, .val = 0xda4d00db },
	{ .addr = 0x0f0006138, .val = 0x68e80129 },
	{ .addr = 0x0f000613c, .val = 0x913c035e },
	{ .addr = 0x0f0006140, .val = 0xa3d9019e },
	{ .addr = 0x0f0006144, .val = 0xa0f602ab },
	{ .addr = 0x0f0006148, .val = 0xa955025d },
	{ .addr = 0x0f000614c, .val = 0xd0b70127 },
	{ .addr = 0x0f0006150, .val = 0x01500202 },
	{ .addr = 0x0f0006154, .val = 0x69a000cc },
	{ .addr = 0x0f0006158, .val = 0x61f80378 },
	{ .addr = 0x0f000615c, .val = 0xc10d00fe },
	{ .addr = 0x0f0006160, .val = 0xcab20126 },
	{ .addr = 0x0f0006164, .val = 0x319b033e },
	{ .addr = 0x0f0006168, .val = 0x106c0115 },
	{ .addr = 0x0f000616c, .val = 0xf97a03e8 },
	{ .addr = 0x0f0006170, .val = 0x993b0116 },
	{ .addr = 0x0f0006174, .val = 0xabee0210 },
	{ .addr = 0x0f0006178, .val = 0xd3c203ce },
	{ .addr = 0x0f000617c, .val = 0x098500ba },
	{ .addr = 0x0f0006180, .val = 0x3bf50221 },
	{ .addr = 0x0f0006184, .val = 0xc2aa0110 },
	{ .addr = 0x0f0006188, .val = 0xa3d0026e },
	{ .addr = 0x0f000618c, .val = 0x11680125 },
	{ .addr = 0x0f0006190, .val = 0x2313019a },
	{ .addr = 0x0f0006194, .val = 0x00cf0062 },
	{ .addr = 0x0f0006198, .val = 0xea3d0220 },
	{ .addr = 0x0f000619c, .val = 0x535c01ea },
	{ .addr = 0x0f00061a0, .val = 0x51b20345 },
	{ .addr = 0x0f00061a4, .val = 0x61030176 },
	{ .addr = 0x0f00061a8, .val = 0xdada0361 },
	{ .addr = 0x0f00061ac, .val = 0x7174032d },
	{ .addr = 0x0f00061b0, .val = 0xf1360128 },
	{ .addr = 0x0f00061b4, .val = 0x1b01025e },
	{ .addr = 0x0f00061b8, .val = 0x8036008e },
	{ .addr = 0x0f00061bc, .val = 0xd14e0243 },
	{ .addr = 0x0f00061c0, .val = 0xe3330229 },
	{ .addr = 0x0f00061c4, .val = 0xd9d60171 },
	{ .addr = 0x0f00061c8, .val = 0x614301ee },
	{ .addr = 0x0f00061cc, .val = 0xa24900a0 },
	{ .addr = 0x0f00061d0, .val = 0x686a00d1 },
	{ .addr = 0x0f00061d4, .val = 0xf15800ee },
	{ .addr = 0x0f00061d8, .val = 0x40c00383 },
	{ .addr = 0x0f00061dc, .val = 0xc97f00e4 },
	{ .addr = 0x0f00061e0, .val = 0x4255030e },
	{ .addr = 0x0f00061e4, .val = 0xaa460331 },
	{ .addr = 0x0f00061e8, .val = 0x13ef0301 },
	{ .addr = 0x0f00061ec, .val = 0xd2c002b4 },
	{ .addr = 0x0f00061f0, .val = 0xcb4001e4 },
	{ .addr = 0x0f00061f4, .val = 0x38860263 },
	{ .addr = 0x0f00061f8, .val = 0x3b2500b0 },
	{ .addr = 0x0f00061fc, .val = 0xc99f0162 },
	{ .addr = 0x0f0006200, .val = 0x787d02e3 },
	{ .addr = 0x0f0006204, .val = 0xb86703e0 },
	{ .addr = 0x0f0006208, .val = 0xa9eb0119 },
	{ .addr = 0x0f000620c, .val = 0xc83e0149 },
	{ .addr = 0x0f0006210, .val = 0x929302d9 },
	{ .addr = 0x0f0006214, .val = 0x885902fe },
	{ .addr = 0x0f0006218, .val = 0x9283028c },
	{ .addr = 0x0f000621c, .val = 0x6b8b0053 },
	{ .addr = 0x0f0006220, .val = 0x135600b6 },
	{ .addr = 0x0f0006224, .val = 0x1b360276 },
	{ .addr = 0x0f0006228, .val = 0x318503ee },
	{ .addr = 0x0f000622c, .val = 0x882c0206 },
	{ .addr = 0x0f0006230, .val = 0xe33100cf },
	{ .addr = 0x0f0006234, .val = 0x70770091 },
	{ .addr = 0x0f0006238, .val = 0x198b01ff },
	{ .addr = 0x0f000623c, .val = 0x93820293 },
	{ .addr = 0x0f0006240, .val = 0x40df03c9 },
	{ .addr = 0x0f0006244, .val = 0xe1db0053 },
	{ .addr = 0x0f0006248, .val = 0xa9840381 },
	{ .addr = 0x0f000624c, .val = 0xfa6b01ee },
	{ .addr = 0x0f0006250, .val = 0x68d802ad },
	{ .addr = 0x0f0006254, .val = 0x500000fa },
	{ .addr = 0x0f0006258, .val = 0xaa14005d },
	{ .addr = 0x0f000625c, .val = 0xcaee021a },
	{ .addr = 0x0f0006260, .val = 0x2b450021 },
	{ .addr = 0x0f0006264, .val = 0xc8ab02a1 },
	{ .addr = 0x0f0006268, .val = 0x4a9b01c8 },
	{ .addr = 0x0f000626c, .val = 0x18c503cb },
	{ .addr = 0x0f0006270, .val = 0x61e80012 },
	{ .addr = 0x0f0006274, .val = 0xf05d0061 },
	{ .addr = 0x0f0006278, .val = 0xf0b50220 },
	{ .addr = 0x0f000627c, .val = 0x7b840364 },
	{ .addr = 0x0f0006280, .val = 0x184d0178 },
	{ .addr = 0x0f0006284, .val = 0x8b840357 },
	{ .addr = 0x0f0006288, .val = 0x291703c6 },
	{ .addr = 0x0f000628c, .val = 0x313003c6 },
	{ .addr = 0x0f0006290, .val = 0xb9ce0070 },
	{ .addr = 0x0f0006294, .val = 0x83680036 },
	{ .addr = 0x0f0006298, .val = 0x185d02bd },
	{ .addr = 0x0f000629c, .val = 0xe87c011e },
	{ .addr = 0x0f00062a0, .val = 0x610c03e2 },
	{ .addr = 0x0f00062a4, .val = 0x61f601a4 },
	{ .addr = 0x0f00062a8, .val = 0x03780225 },
	{ .addr = 0x0f00062ac, .val = 0xc9f90388 },
	{ .addr = 0x0f00062b0, .val = 0xf3ca0221 },
	{ .addr = 0x0f00062b4, .val = 0x6b01026e },
	{ .addr = 0x0f00062b8, .val = 0xe16600f1 },
	{ .addr = 0x0f00062bc, .val = 0xf9800349 },
	{ .addr = 0x0f00062c0, .val = 0x2a20010b },
	{ .addr = 0x0f00062c4, .val = 0xc1f0012e },
	{ .addr = 0x0f00062c8, .val = 0xeb660301 },
	{ .addr = 0x0f00062cc, .val = 0x4ab5006b },
	{ .addr = 0x0f00062d0, .val = 0xf38e01a9 },
	{ .addr = 0x0f00062d4, .val = 0xdaca01a2 },
	{ .addr = 0x0f00062d8, .val = 0x33640035 },
	{ .addr = 0x0f00062dc, .val = 0x028b0000 },
	{ .addr = 0x0f00062e0, .val = 0xa12300d1 },
	{ .addr = 0x0f00062e4, .val = 0x311903aa },
	{ .addr = 0x0f00062e8, .val = 0x2b3002e3 },
	{ .addr = 0x0f00062ec, .val = 0xc9e503dc },
	{ .addr = 0x0f00062f0, .val = 0xb940021c },
	{ .addr = 0x0f00062f4, .val = 0x9838014b },
	{ .addr = 0x0f00062f8, .val = 0x931a023d },
	{ .addr = 0x0f00062fc, .val = 0x12c40074 },
	{ .addr = 0x0f0006300, .val = 0xa0420331 },
	{ .addr = 0x0f0006304, .val = 0xcbe40223 },
	{ .addr = 0x0f0006308, .val = 0xf059010d },
	{ .addr = 0x0f000630c, .val = 0xf806013d },
	{ .addr = 0x0f0006310, .val = 0x0a290300 },
	{ .addr = 0x0f0006314, .val = 0xaa1603af },
	{ .addr = 0x0f0006318, .val = 0x9afb0376 },
	{ .addr = 0x0f000631c, .val = 0x636003eb },
	{ .addr = 0x0f0006320, .val = 0x69d001fc },
	{ .addr = 0x0f0006324, .val = 0x234d0197 },
	{ .addr = 0x0f0006328, .val = 0x1b5a00b2 },
	{ .addr = 0x0f000632c, .val = 0x51b4014b },
	{ .addr = 0x0f0006330, .val = 0xf32c027d },
	{ .addr = 0x0f0006334, .val = 0x3186024e },
	{ .addr = 0x0f0006338, .val = 0x80280380 },
	{ .addr = 0x0f000633c, .val = 0xf34901cb },
	{ .addr = 0x0f0006340, .val = 0xcad5029a },
	{ .addr = 0x0f0006344, .val = 0xbad30375 },
	{ .addr = 0x0f0006348, .val = 0xf283004a },
	{ .addr = 0x0f000634c, .val = 0x812d038d },
	{ .addr = 0x0f0006350, .val = 0x8ae00345 },
	{ .addr = 0x0f0006354, .val = 0xe91a0364 },
	{ .addr = 0x0f0006358, .val = 0xb046000e },
	{ .addr = 0x0f000635c, .val = 0x98640163 },
	{ .addr = 0x0f0006360, .val = 0xb81901f2 },
	{ .addr = 0x0f0006364, .val = 0x692400cd },
	{ .addr = 0x0f0006368, .val = 0x301a0347 },
	{ .addr = 0x0f000636c, .val = 0xab95025c },
	{ .addr = 0x0f0006370, .val = 0x18270351 },
	{ .addr = 0x0f0006374, .val = 0xa01a0103 },
	{ .addr = 0x0f0006378, .val = 0x21ab004f },
	{ .addr = 0x0f000637c, .val = 0x624f03f0 },
	{ .addr = 0x0f0006380, .val = 0x391903a0 },
	{ .addr = 0x0f0006384, .val = 0x98500341 },
	{ .addr = 0x0f0006388, .val = 0xdb490300 },
	{ .addr = 0x0f000638c, .val = 0x201103de },
	{ .addr = 0x0f0006390, .val = 0x409401d1 },
	{ .addr = 0x0f0006394, .val = 0x5959026a },
	{ .addr = 0x0f0006398, .val = 0xe26602c7 },
	{ .addr = 0x0f000639c, .val = 0xf14b0182 },
	{ .addr = 0x0f00063a0, .val = 0x6171001e },
	{ .addr = 0x0f00063a4, .val = 0xe38501de },
	{ .addr = 0x0f00063a8, .val = 0xa2f80332 },
	{ .addr = 0x0f00063ac, .val = 0x80ab021a },
	{ .addr = 0x0f00063b0, .val = 0xf9e103c8 },
	{ .addr = 0x0f00063b4, .val = 0x7ace0188 },
	{ .addr = 0x0f00063b8, .val = 0x52ab004f },
	{ .addr = 0x0f00063bc, .val = 0x601a039b },
	{ .addr = 0x0f00063c0, .val = 0x804b010c },
	{ .addr = 0x0f00063c4, .val = 0x40e802ff },
	{ .addr = 0x0f00063c8, .val = 0x737902e0 },
	{ .addr = 0x0f00063cc, .val = 0x326a02aa },
	{ .addr = 0x0f00063d0, .val = 0x3210006a },
	{ .addr = 0x0f00063d4, .val = 0x680403ed },
	{ .addr = 0x0f00063d8, .val = 0x59b803dc },
	{ .addr = 0x0f00063dc, .val = 0xc1b700d4 },
	{ .addr = 0x0f00063e0, .val = 0x280e02b0 },
	{ .addr = 0x0f00063e4, .val = 0x297c0200 },
	{ .addr = 0x0f00063e8, .val = 0x7a250311 },
	{ .addr = 0x0f00063ec, .val = 0x32f4021b },
	{ .addr = 0x0f00063f0, .val = 0xb156025b },
	{ .addr = 0x0f00063f4, .val = 0xb8eb03ec },
	{ .addr = 0x0f00063f8, .val = 0x10b60141 },
	{ .addr = 0x0f00063fc, .val = 0xf395029d },
	{ .addr = 0x0f0006400, .val = 0x41b202f1 },
	{ .addr = 0x0f0006404, .val = 0x7bbe036a },
	{ .addr = 0x0f0006408, .val = 0x0832031f },
	{ .addr = 0x0f000640c, .val = 0x82f90089 },
	{ .addr = 0x0f0006410, .val = 0xab21006e },
	{ .addr = 0x0f0006414, .val = 0x936700db },
	{ .addr = 0x0f0006418, .val = 0xca3b00d0 },
	{ .addr = 0x0f000641c, .val = 0x30a70140 },
	{ .addr = 0x0f0006420, .val = 0x5afd00f1 },
	{ .addr = 0x0f0006424, .val = 0x3a9c0176 },
	{ .addr = 0x0f0006428, .val = 0xe1680338 },
	{ .addr = 0x0f000642c, .val = 0x31b100f6 },
	{ .addr = 0x0f0006430, .val = 0xa14c00ff },
	{ .addr = 0x0f0006434, .val = 0x59b2005b },
	{ .addr = 0x0f0006438, .val = 0x0312032d },
	{ .addr = 0x0f000643c, .val = 0x21c90003 },
	{ .addr = 0x0f0006534, .val = 0x8b4fddb9 },
	{ .addr = 0x0f000694c, .val = 0x0281ba73 },
	{ .addr = 0x0f000695c, .val = 0x92e7ad7d },
	{ .addr = 0x0f0006960, .val = 0x4a3a0a91 },
	{ .addr = 0x0f0006964, .val = 0x186d5b37 },
	{ .addr = 0x0f0006968, .val = 0xf32a7701 },
	{ .addr = 0x0f000696c, .val = 0x00000002 },
	{ .addr = 0x0f0006970, .val = 0xa763ac34 },
	{ .addr = 0x0f0006974, .val = 0xf7d93df7 },
	{ .addr = 0x0f0006978, .val = 0x5d11c494 },
	{ .addr = 0x0f000697c, .val = 0x00000003 },
	{ .addr = 0x0f0006990, .val = 0x00003428 },
	{ .addr = 0x0f1000000, .val = 0x00000281 },
	{ .addr = 0x0f1000004, .val = 0x000057d5 },
	{ .addr = 0x0f1000008, .val = 0x00002564 },
	{ .addr = 0x0f100000c, .val = 0x00001c95 },
	{ .addr = 0x0f1000010, .val = 0x000068fd },
	{ .addr = 0x0f1000014, .val = 0x0000ff89 },
	{ .addr = 0x0f1000018, .val = 0x00006b0c },
	{ .addr = 0x0f100001c, .val = 0x00009693 },
	{ .addr = 0x0f1000020, .val = 0x00009f8e },
	{ .addr = 0x0f1000024, .val = 0x000023c4 },
	{ .addr = 0x0f1000028, .val = 0x00009043 },
	{ .addr = 0x0f100002c, .val = 0x0000a54d },
	{ .addr = 0x0f1000030, .val = 0x00001e39 },
	{ .addr = 0x0f1000034, .val = 0x000059e0 },
	{ .addr = 0x0f1000038, .val = 0x0000f2ce },
	{ .addr = 0x0f100003c, .val = 0x0000276b },
	{ .addr = 0x0f1000040, .val = 0x000001b2 },
	{ .addr = 0x0f1000044, .val = 0xf23f970c },
	{ .addr = 0x0f1000080, .val = 0x00000002 },
	{ .addr = 0x0f10000ac, .val = 0x000001c9 },
	{ .addr = 0x0f10000fc, .val = 0x15d5ed01 },
	{ .addr = 0x0f1000100, .val = 0x0dddab11 },
	{ .addr = 0x0f1000104, .val = 0x109f1d30 },
	{ .addr = 0x0f1000108, .val = 0x0de6c500 },
	{ .addr = 0x0f100010c, .val = 0x076ef705 },
	{ .addr = 0x0f1000110, .val = 0x05694132 },
	{ .addr = 0x0f1000114, .val = 0x0d20cf15 },
	{ .addr = 0x0f1000118, .val = 0x1c813115 },
	{ .addr = 0x0f100011c, .val = 0x036a9d35 },
	{ .addr = 0x0f1000120, .val = 0x066c1622 },
	{ .addr = 0x0f1000124, .val = 0x0541ff34 },
	{ .addr = 0x0f1000128, .val = 0x090c3501 },
	{ .addr = 0x0f100012c, .val = 0x13e57037 },
	{ .addr = 0x0f1000130, .val = 0x1f1db024 },
	{ .addr = 0x0f1000134, .val = 0x18252732 },
	{ .addr = 0x0f1000138, .val = 0x1cbed401 },
	{ .addr = 0x0f100013c, .val = 0x00000002 },
	{ .addr = 0x0f1000140, .val = 0x2112e43b },
	{ .addr = 0x0f1000144, .val = 0x0003daac },
	{ .addr = 0x0f1000148, .val = 0x8e6d0ce5 },
	{ .addr = 0x0f100014c, .val = 0x000001cd },
	{ .addr = 0x0f1000154, .val = 0x00000071 },
	{ .addr = 0x0f1000158, .val = 0x000002c6 },
	{ .addr = 0x0f1000200, .val = 0x000f0113 },
	{ .addr = 0x0f1000204, .val = 0x00060218 },
	{ .addr = 0x0f1000210, .val = 0x0005020b },
	{ .addr = 0x0f1000214, .val = 0x000d0226 },
	{ .addr = 0x0f1000218, .val = 0x000d0008 },
	{ .addr = 0x0f1000240, .val = 0x00000002 },
	{ .addr = 0x0f1000244, .val = 0x00000002 },
	{ .addr = 0x0f1000248, .val = 0x00000002 },
	{ .addr = 0x0f100024c, .val = 0x00000002 },
	{ .addr = 0x0f1000250, .val = 0x00000000 },
	{ .addr = 0x0f1000254, .val = 0x00000003 },
	{ .addr = 0x0f1000258, .val = 0x00000001 },
	{ .addr = 0x0f100025c, .val = 0x00000002 },
	{ .addr = 0x0f1000260, .val = 0x00000003 },
	{ .addr = 0x0f1000264, .val = 0x00000000 },
	{ .addr = 0x0f1000268, .val = 0x00000002 },
	{ .addr = 0x0f100026c, .val = 0x00000001 },
	{ .addr = 0x0f1000270, .val = 0x00000001 },
	{ .addr = 0x0f1000274, .val = 0x00000001 },
	{ .addr = 0x0f1000278, .val = 0x00000002 },
	{ .addr = 0x0f100027c, .val = 0x00000000 },
	{ .addr = 0x0f1000280, .val = 0x00007d09 },
	{ .addr = 0x0f1000284, .val = 0x0000420e },
	{ .addr = 0x0f1000288, .val = 0x00000016 },
	{ .addr = 0x0f100028c, .val = 0x800029d5 },
	{ .addr = 0x0f1000290, .val = 0x0000b2ce },
	{ .addr = 0x0f1000294, .val = 0x00001d61 },
	{ .addr = 0x0f1000298, .val = 0x00002d19 },
	{ .addr = 0x0f100029c, .val = 0x0000c409 },
	{ .addr = 0x0f10002a0, .val = 0x80008709 },
	{ .addr = 0x0f10002a4, .val = 0x00003973 },
	{ .addr = 0x0f10002a8, .val = 0x0000e1ae },
	{ .addr = 0x0f10002ac, .val = 0x8000cb91 },
	{ .addr = 0x0f10002b0, .val = 0x8000388d },
	{ .addr = 0x0f10002b4, .val = 0x8000f21b },
	{ .addr = 0x0f10002b8, .val = 0x80004cfc },
	{ .addr = 0x0f10002bc, .val = 0x000030d8 },
	{ .addr = 0x0f10002c0, .val = 0x00000001 },
	{ .addr = 0x0f10002c4, .val = 0x00000000 },
	{ .addr = 0x0f10002c8, .val = 0x00000001 },
	{ .addr = 0x0f10002cc, .val = 0x00000000 },
	{ .addr = 0x0f10002d0, .val = 0x00000000 },
	{ .addr = 0x0f10002d4, .val = 0x00000001 },
	{ .addr = 0x0f10002d8, .val = 0x00000000 },
	{ .addr = 0x0f10002dc, .val = 0x00000001 },
	{ .addr = 0x0f10002e0, .val = 0x00000000 },
	{ .addr = 0x0f10002e4, .val = 0x00000001 },
	{ .addr = 0x0f10002e8, .val = 0x00000003 },
	{ .addr = 0x0f10002ec, .val = 0x00000000 },
	{ .addr = 0x0f10002f0, .val = 0x00000003 },
	{ .addr = 0x0f10002f4, .val = 0x00000001 },
	{ .addr = 0x0f10002f8, .val = 0x00000002 },
	{ .addr = 0x0f10002fc, .val = 0x00000002 },
	{ .addr = 0x0f1000300, .val = 0x00000001 },
	{ .addr = 0x0f1000304, .val = 0x00000003 },
	{ .addr = 0x0f1000308, .val = 0x00000000 },
	{ .addr = 0x0f100030c, .val = 0x00000000 },
	{ .addr = 0x0f1000310, .val = 0x00000000 },
	{ .addr = 0x0f1000314, .val = 0x00000000 },
	{ .addr = 0x0f1000318, .val = 0x00000003 },
	{ .addr = 0x0f100031c, .val = 0x00000002 },
	{ .addr = 0x0f1000320, .val = 0x00000002 },
	{ .addr = 0x0f1000324, .val = 0x00000003 },
	{ .addr = 0x0f1000328, .val = 0x00000003 },
	{ .addr = 0x0f100032c, .val = 0x00000001 },
	{ .addr = 0x0f1000330, .val = 0x00000001 },
	{ .addr = 0x0f1000334, .val = 0x00000002 },
	{ .addr = 0x0f1000338, .val = 0x00000000 },
	{ .addr = 0x0f100033c, .val = 0x00000000 },
	{ .addr = 0x0f1000340, .val = 0x00000002 },
	{ .addr = 0x0f1000344, .val = 0x00000001 },
	{ .addr = 0x0f1000348, .val = 0x00000000 },
	{ .addr = 0x0f100034c, .val = 0x00000002 },
	{ .addr = 0x0f1000350, .val = 0x00000000 },
	{ .addr = 0x0f1000354, .val = 0x00000002 },
	{ .addr = 0x0f1000358, .val = 0x00000000 },
	{ .addr = 0x0f100035c, .val = 0x00000001 },
	{ .addr = 0x0f1000360, .val = 0x00000000 },
	{ .addr = 0x0f1000364, .val = 0x00000000 },
	{ .addr = 0x0f1000368, .val = 0x00000000 },
	{ .addr = 0x0f100036c, .val = 0x00000000 },
	{ .addr = 0x0f1000370, .val = 0x00000000 },
	{ .addr = 0x0f1000374, .val = 0x00000000 },
	{ .addr = 0x0f1000378, .val = 0x00000002 },
	{ .addr = 0x0f100037c, .val = 0x00000000 },
	{ .addr = 0x0f1000380, .val = 0x00000000 },
	{ .addr = 0x0f1000384, .val = 0x00000002 },
	{ .addr = 0x0f1000388, .val = 0x00000001 },
	{ .addr = 0x0f100038c, .val = 0x00000000 },
	{ .addr = 0x0f1000390, .val = 0x00000001 },
	{ .addr = 0x0f1000394, .val = 0x00000000 },
	{ .addr = 0x0f1000398, .val = 0x00000001 },
	{ .addr = 0x0f100039c, .val = 0x00000002 },
	{ .addr = 0x0f10003a0, .val = 0x00000003 },
	{ .addr = 0x0f10003a4, .val = 0x00000000 },
	{ .addr = 0x0f10003a8, .val = 0x00000001 },
	{ .addr = 0x0f10003ac, .val = 0x00000001 },
	{ .addr = 0x0f10003b0, .val = 0x00000001 },
	{ .addr = 0x0f10003b4, .val = 0x00000002 },
	{ .addr = 0x0f10003b8, .val = 0x00000000 },
	{ .addr = 0x0f10003bc, .val = 0x00000003 },
	{ .addr = 0x0f10003c0, .val = 0x00000001 },
	{ .addr = 0x0f10003c4, .val = 0x00000003 },
	{ .addr = 0x0f10003c8, .val = 0x00000003 },
	{ .addr = 0x0f10003cc, .val = 0x00000003 },
	{ .addr = 0x0f10003d0, .val = 0x00000001 },
	{ .addr = 0x0f10003d4, .val = 0x00000000 },
	{ .addr = 0x0f10003d8, .val = 0x00000001 },
	{ .addr = 0x0f10003dc, .val = 0x00000000 },
	{ .addr = 0x0f10003e0, .val = 0x00000000 },
	{ .addr = 0x0f10003e4, .val = 0x00000002 },
	{ .addr = 0x0f10003e8, .val = 0x00000003 },
	{ .addr = 0x0f10003ec, .val = 0x00000002 },
	{ .addr = 0x0f10003f0, .val = 0x00000000 },
	{ .addr = 0x0f10003f4, .val = 0x00000001 },
	{ .addr = 0x0f10003f8, .val = 0x00000003 },
	{ .addr = 0x0f10003fc, .val = 0x00000002 },
	{ .addr = 0x0f1000400, .val = 0x00000003 },
	{ .addr = 0x0f1000404, .val = 0x00000000 },
	{ .addr = 0x0f1000408, .val = 0x00000002 },
	{ .addr = 0x0f100040c, .val = 0x00000002 },
	{ .addr = 0x0f1000410, .val = 0x00000001 },
	{ .addr = 0x0f1000414, .val = 0x00000002 },
	{ .addr = 0x0f1000418, .val = 0x00000000 },
	{ .addr = 0x0f100041c, .val = 0x00000001 },
	{ .addr = 0x0f1000420, .val = 0x00000001 },
	{ .addr = 0x0f1000424, .val = 0x00000002 },
	{ .addr = 0x0f1000428, .val = 0x00000002 },
	{ .addr = 0x0f100042c, .val = 0x00000002 },
	{ .addr = 0x0f1000430, .val = 0x00000003 },
	{ .addr = 0x0f1000434, .val = 0x00000001 },
	{ .addr = 0x0f1000438, .val = 0x00000002 },
	{ .addr = 0x0f100043c, .val = 0x00000003 },
	{ .addr = 0x0f1000440, .val = 0x00000002 },
	{ .addr = 0x0f1000444, .val = 0x00000003 },
	{ .addr = 0x0f1000448, .val = 0x00000002 },
	{ .addr = 0x0f100044c, .val = 0x00000000 },
	{ .addr = 0x0f1000450, .val = 0x00000001 },
	{ .addr = 0x0f1000454, .val = 0x00000002 },
	{ .addr = 0x0f1000458, .val = 0x00000002 },
	{ .addr = 0x0f100045c, .val = 0x00000003 },
	{ .addr = 0x0f1000460, .val = 0x00000000 },
	{ .addr = 0x0f1000464, .val = 0x00000003 },
	{ .addr = 0x0f1000468, .val = 0x00000003 },
	{ .addr = 0x0f100046c, .val = 0x00000000 },
	{ .addr = 0x0f1000470, .val = 0x00000001 },
	{ .addr = 0x0f1000474, .val = 0x00000000 },
	{ .addr = 0x0f1000478, .val = 0x00000001 },
	{ .addr = 0x0f100047c, .val = 0x00000001 },
	{ .addr = 0x0f1000480, .val = 0x00000003 },
	{ .addr = 0x0f1000484, .val = 0x00000003 },
	{ .addr = 0x0f1000488, .val = 0x00000000 },
	{ .addr = 0x0f100048c, .val = 0x00000000 },
	{ .addr = 0x0f1000490, .val = 0x00000000 },
	{ .addr = 0x0f1000494, .val = 0x00000002 },
	{ .addr = 0x0f1000498, .val = 0x00000003 },
	{ .addr = 0x0f100049c, .val = 0x00000001 },
	{ .addr = 0x0f10004a0, .val = 0x00000002 },
	{ .addr = 0x0f10004a4, .val = 0x00000001 },
	{ .addr = 0x0f10004a8, .val = 0x00000001 },
	{ .addr = 0x0f10004ac, .val = 0x00000002 },
	{ .addr = 0x0f10004b0, .val = 0x00000003 },
	{ .addr = 0x0f10004b4, .val = 0x00000003 },
	{ .addr = 0x0f10004b8, .val = 0x00000000 },
	{ .addr = 0x0f10004bc, .val = 0x00000002 },
	{ .addr = 0x0f10004c0, .val = 0x00000003 },
	{ .addr = 0x0f10004c4, .val = 0x00000002 },
	{ .addr = 0x0f10004c8, .val = 0x00000002 },
	{ .addr = 0x0f10004cc, .val = 0x00000003 },
	{ .addr = 0x0f10004d0, .val = 0x00000000 },
	{ .addr = 0x0f10004d4, .val = 0x00000002 },
	{ .addr = 0x0f10004d8, .val = 0x00000001 },
	{ .addr = 0x0f10004dc, .val = 0x00000000 },
	{ .addr = 0x0f10004e0, .val = 0x00000003 },
	{ .addr = 0x0f10004e4, .val = 0x00000002 },
	{ .addr = 0x0f10004e8, .val = 0x00000002 },
	{ .addr = 0x0f10004ec, .val = 0x00000002 },
	{ .addr = 0x0f10004f0, .val = 0x00000001 },
	{ .addr = 0x0f10004f4, .val = 0x00000003 },
	{ .addr = 0x0f10004f8, .val = 0x00000001 },
	{ .addr = 0x0f10004fc, .val = 0x00000003 },
	{ .addr = 0x0f1000500, .val = 0x00000000 },
	{ .addr = 0x0f1000504, .val = 0x00000003 },
	{ .addr = 0x0f1000508, .val = 0x00000000 },
	{ .addr = 0x0f100050c, .val = 0x00000000 },
	{ .addr = 0x0f1000510, .val = 0x00000000 },
	{ .addr = 0x0f1000514, .val = 0x00000002 },
	{ .addr = 0x0f1000518, .val = 0x00000001 },
	{ .addr = 0x0f100051c, .val = 0x00000002 },
	{ .addr = 0x0f1000520, .val = 0x00000001 },
	{ .addr = 0x0f1000524, .val = 0x00000001 },
	{ .addr = 0x0f1000528, .val = 0x00000002 },
	{ .addr = 0x0f100052c, .val = 0x00000001 },
	{ .addr = 0x0f1000530, .val = 0x00000000 },
	{ .addr = 0x0f1000534, .val = 0x00000001 },
	{ .addr = 0x0f1000538, .val = 0x00000001 },
	{ .addr = 0x0f100053c, .val = 0x00000001 },
	{ .addr = 0x0f1000540, .val = 0x00000003 },
	{ .addr = 0x0f1000544, .val = 0x00000001 },
	{ .addr = 0x0f1000548, .val = 0x00000001 },
	{ .addr = 0x0f100054c, .val = 0x00000000 },
	{ .addr = 0x0f1000550, .val = 0x00000002 },
	{ .addr = 0x0f1000554, .val = 0x00000003 },
	{ .addr = 0x0f1000558, .val = 0x00000003 },
	{ .addr = 0x0f100055c, .val = 0x00000002 },
	{ .addr = 0x0f1000560, .val = 0x00000001 },
	{ .addr = 0x0f1000564, .val = 0x00000002 },
	{ .addr = 0x0f1000568, .val = 0x00000003 },
	{ .addr = 0x0f100056c, .val = 0x00000000 },
	{ .addr = 0x0f1000570, .val = 0x00000000 },
	{ .addr = 0x0f1000574, .val = 0x00000000 },
	{ .addr = 0x0f1000578, .val = 0x00000000 },
	{ .addr = 0x0f100057c, .val = 0x00000000 },
	{ .addr = 0x0f1000580, .val = 0x00000001 },
	{ .addr = 0x0f1000584, .val = 0x00000001 },
	{ .addr = 0x0f1000588, .val = 0x00000000 },
	{ .addr = 0x0f100058c, .val = 0x00000000 },
	{ .addr = 0x0f1000590, .val = 0x00000003 },
	{ .addr = 0x0f1000594, .val = 0x00000001 },
	{ .addr = 0x0f1000598, .val = 0x00000002 },
	{ .addr = 0x0f100059c, .val = 0x00000000 },
	{ .addr = 0x0f10005a0, .val = 0x00000002 },
	{ .addr = 0x0f10005a4, .val = 0x00000003 },
	{ .addr = 0x0f10005a8, .val = 0x00000003 },
	{ .addr = 0x0f10005ac, .val = 0x00000001 },
	{ .addr = 0x0f10005b0, .val = 0x00000001 },
	{ .addr = 0x0f10005b4, .val = 0x00000001 },
	{ .addr = 0x0f10005b8, .val = 0x00000002 },
	{ .addr = 0x0f10005bc, .val = 0x00000002 },
	{ .addr = 0x0f10005c0, .val = 0x00000000 },
	{ .addr = 0x0f10005c4, .val = 0x00000002 },
	{ .addr = 0x0f10005c8, .val = 0x00000000 },
	{ .addr = 0x0f10005cc, .val = 0x00000003 },
	{ .addr = 0x0f10005d0, .val = 0x00000003 },
	{ .addr = 0x0f10005d4, .val = 0x00000003 },
	{ .addr = 0x0f10005d8, .val = 0x00000002 },
	{ .addr = 0x0f10005dc, .val = 0x00000000 },
	{ .addr = 0x0f10005e0, .val = 0x00000000 },
	{ .addr = 0x0f10005e4, .val = 0x00000001 },
	{ .addr = 0x0f10005e8, .val = 0x00000001 },
	{ .addr = 0x0f10005ec, .val = 0x00000001 },
	{ .addr = 0x0f10005f0, .val = 0x00000001 },
	{ .addr = 0x0f10005f4, .val = 0x00000002 },
	{ .addr = 0x0f10005f8, .val = 0x00000003 },
	{ .addr = 0x0f10005fc, .val = 0x00000002 },
	{ .addr = 0x0f1000600, .val = 0x00000003 },
	{ .addr = 0x0f1000604, .val = 0x00000002 },
	{ .addr = 0x0f1000608, .val = 0x00000000 },
	{ .addr = 0x0f100060c, .val = 0x00000002 },
	{ .addr = 0x0f1000610, .val = 0x00000000 },
	{ .addr = 0x0f1000614, .val = 0x00000003 },
	{ .addr = 0x0f1000618, .val = 0x00000000 },
	{ .addr = 0x0f100061c, .val = 0x00000002 },
	{ .addr = 0x0f1000620, .val = 0x00000000 },
	{ .addr = 0x0f1000624, .val = 0x00000001 },
	{ .addr = 0x0f1000628, .val = 0x00000002 },
	{ .addr = 0x0f100062c, .val = 0x00000003 },
	{ .addr = 0x0f1000630, .val = 0x00000003 },
	{ .addr = 0x0f1000634, .val = 0x00000000 },
	{ .addr = 0x0f1000638, .val = 0x00000002 },
	{ .addr = 0x0f100063c, .val = 0x00000002 },
	{ .addr = 0x0f1000640, .val = 0x00000000 },
	{ .addr = 0x0f1000644, .val = 0x00000000 },
	{ .addr = 0x0f1000648, .val = 0x00000000 },
	{ .addr = 0x0f100064c, .val = 0x00000000 },
	{ .addr = 0x0f1000650, .val = 0x00000001 },
	{ .addr = 0x0f1000654, .val = 0x00000003 },
	{ .addr = 0x0f1000658, .val = 0x00000001 },
	{ .addr = 0x0f100065c, .val = 0x00000001 },
	{ .addr = 0x0f1000660, .val = 0x00000002 },
	{ .addr = 0x0f1000664, .val = 0x00000002 },
	{ .addr = 0x0f1000668, .val = 0x00000003 },
	{ .addr = 0x0f100066c, .val = 0x00000000 },
	{ .addr = 0x0f1000670, .val = 0x00000002 },
	{ .addr = 0x0f1000674, .val = 0x00000001 },
	{ .addr = 0x0f1000678, .val = 0x00000001 },
	{ .addr = 0x0f100067c, .val = 0x00000003 },
	{ .addr = 0x0f1000680, .val = 0x00000001 },
	{ .addr = 0x0f1000684, .val = 0x00000002 },
	{ .addr = 0x0f1000688, .val = 0x00000003 },
	{ .addr = 0x0f100068c, .val = 0x00000003 },
	{ .addr = 0x0f1000690, .val = 0x00000003 },
	{ .addr = 0x0f1000694, .val = 0x00000002 },
	{ .addr = 0x0f1000698, .val = 0x00000001 },
	{ .addr = 0x0f100069c, .val = 0x00000002 },
	{ .addr = 0x0f10006a0, .val = 0x00000003 },
	{ .addr = 0x0f10006a4, .val = 0x00000002 },
	{ .addr = 0x0f10006a8, .val = 0x00000002 },
	{ .addr = 0x0f10006ac, .val = 0x00000003 },
	{ .addr = 0x0f10006b0, .val = 0x00000002 },
	{ .addr = 0x0f10006b4, .val = 0x00000001 },
	{ .addr = 0x0f10006b8, .val = 0x00000000 },
	{ .addr = 0x0f10006bc, .val = 0x00000002 },
	{ .addr = 0x0f10006c0, .val = 0x00000000 },
	{ .addr = 0x0f10006c4, .val = 0x00000002 },
	{ .addr = 0x0f10006c8, .val = 0x00000003 },
	{ .addr = 0x0f10006cc, .val = 0x00000000 },
	{ .addr = 0x0f10006d0, .val = 0x00000002 },
	{ .addr = 0x0f10006d4, .val = 0x00000000 },
	{ .addr = 0x0f10006d8, .val = 0x00000001 },
	{ .addr = 0x0f10006dc, .val = 0x00000000 },
	{ .addr = 0x0f10006e0, .val = 0x00000003 },
	{ .addr = 0x0f10006e4, .val = 0x00000002 },
	{ .addr = 0x0f10006e8, .val = 0x00000002 },
	{ .addr = 0x0f10006ec, .val = 0x00000002 },
	{ .addr = 0x0f10006f0, .val = 0x00000003 },
	{ .addr = 0x0f10006f4, .val = 0x00000002 },
	{ .addr = 0x0f10006f8, .val = 0x00000000 },
	{ .addr = 0x0f10006fc, .val = 0x00000001 },
	{ .addr = 0x0f1000700, .val = 0x00000003 },
	{ .addr = 0x0f1000704, .val = 0x00000003 },
	{ .addr = 0x0f1000708, .val = 0x00000002 },
	{ .addr = 0x0f100070c, .val = 0x00000001 },
	{ .addr = 0x0f1000710, .val = 0x00000002 },
	{ .addr = 0x0f1000714, .val = 0x00000000 },
	{ .addr = 0x0f1000718, .val = 0x00000000 },
	{ .addr = 0x0f100071c, .val = 0x00000001 },
	{ .addr = 0x0f1000720, .val = 0x00000003 },
	{ .addr = 0x0f1000724, .val = 0x00000003 },
	{ .addr = 0x0f1000728, .val = 0x00000000 },
	{ .addr = 0x0f100072c, .val = 0x00000000 },
	{ .addr = 0x0f1000730, .val = 0x00000001 },
	{ .addr = 0x0f1000734, .val = 0x00000002 },
	{ .addr = 0x0f1000738, .val = 0x00000003 },
	{ .addr = 0x0f100073c, .val = 0x00000001 },
	{ .addr = 0x0f1000740, .val = 0x00000002 },
	{ .addr = 0x0f1000744, .val = 0x00000000 },
	{ .addr = 0x0f1000748, .val = 0x00000001 },
	{ .addr = 0x0f100074c, .val = 0x00000001 },
	{ .addr = 0x0f1000750, .val = 0x00000003 },
	{ .addr = 0x0f1000754, .val = 0x00000001 },
	{ .addr = 0x0f1000758, .val = 0x00000000 },
	{ .addr = 0x0f100075c, .val = 0x00000003 },
	{ .addr = 0x0f1000760, .val = 0x00000003 },
	{ .addr = 0x0f1000764, .val = 0x00000001 },
	{ .addr = 0x0f1000768, .val = 0x00000003 },
	{ .addr = 0x0f100076c, .val = 0x00000000 },
	{ .addr = 0x0f1000770, .val = 0x00000001 },
	{ .addr = 0x0f1000774, .val = 0x00000002 },
	{ .addr = 0x0f1000778, .val = 0x00000002 },
	{ .addr = 0x0f100077c, .val = 0x00000001 },
	{ .addr = 0x0f1000780, .val = 0x00000003 },
	{ .addr = 0x0f1000784, .val = 0x00000002 },
	{ .addr = 0x0f1000788, .val = 0x00000003 },
	{ .addr = 0x0f100078c, .val = 0x00000002 },
	{ .addr = 0x0f1000790, .val = 0x00000002 },
	{ .addr = 0x0f1000794, .val = 0x00000002 },
	{ .addr = 0x0f1000798, .val = 0x00000002 },
	{ .addr = 0x0f100079c, .val = 0x00000002 },
	{ .addr = 0x0f10007a0, .val = 0x00000001 },
	{ .addr = 0x0f10007a4, .val = 0x00000000 },
	{ .addr = 0x0f10007a8, .val = 0x00000000 },
	{ .addr = 0x0f10007ac, .val = 0x00000002 },
	{ .addr = 0x0f10007b0, .val = 0x00000000 },
	{ .addr = 0x0f10007b4, .val = 0x00000001 },
	{ .addr = 0x0f10007b8, .val = 0x00000000 },
	{ .addr = 0x0f10007bc, .val = 0x00000001 },
	{ .addr = 0x0f10007c0, .val = 0x00000002 },
	{ .addr = 0x0f10007c4, .val = 0x00000000 },
	{ .addr = 0x0f10007c8, .val = 0x00000001 },
	{ .addr = 0x0f10007cc, .val = 0x00000003 },
	{ .addr = 0x0f10007d0, .val = 0x00000000 },
	{ .addr = 0x0f10007d4, .val = 0x00000000 },
	{ .addr = 0x0f10007d8, .val = 0x00000000 },
	{ .addr = 0x0f10007dc, .val = 0x00000000 },
	{ .addr = 0x0f10007e0, .val = 0x00000000 },
	{ .addr = 0x0f10007e4, .val = 0x00000001 },
	{ .addr = 0x0f10007e8, .val = 0x00000002 },
	{ .addr = 0x0f10007ec, .val = 0x00000001 },
	{ .addr = 0x0f10007f0, .val = 0x00000002 },
	{ .addr = 0x0f10007f4, .val = 0x00000003 },
	{ .addr = 0x0f10007f8, .val = 0x00000003 },
	{ .addr = 0x0f10007fc, .val = 0x00000001 },
	{ .addr = 0x0f1000800, .val = 0x00000003 },
	{ .addr = 0x0f1000804, .val = 0x00000002 },
	{ .addr = 0x0f1000808, .val = 0x00000000 },
	{ .addr = 0x0f100080c, .val = 0x00000002 },
	{ .addr = 0x0f1000810, .val = 0x00000001 },
	{ .addr = 0x0f1000814, .val = 0x00000000 },
	{ .addr = 0x0f1000818, .val = 0x00000003 },
	{ .addr = 0x0f100081c, .val = 0x00000003 },
	{ .addr = 0x0f1000820, .val = 0x00000003 },
	{ .addr = 0x0f1000824, .val = 0x00000002 },
	{ .addr = 0x0f1000828, .val = 0x00000000 },
	{ .addr = 0x0f100082c, .val = 0x00000002 },
	{ .addr = 0x0f1000830, .val = 0x00000002 },
	{ .addr = 0x0f1000834, .val = 0x00000000 },
	{ .addr = 0x0f1000838, .val = 0x00000000 },
	{ .addr = 0x0f100083c, .val = 0x00000000 },
	{ .addr = 0x0f1000840, .val = 0x00000002 },
	{ .addr = 0x0f1000844, .val = 0x00000003 },
	{ .addr = 0x0f1000848, .val = 0x00000003 },
	{ .addr = 0x0f100084c, .val = 0x00000003 },
	{ .addr = 0x0f1000850, .val = 0x00000003 },
	{ .addr = 0x0f1000854, .val = 0x00000003 },
	{ .addr = 0x0f1000858, .val = 0x00000001 },
	{ .addr = 0x0f100085c, .val = 0x00000002 },
	{ .addr = 0x0f1000860, .val = 0x00000001 },
	{ .addr = 0x0f1000864, .val = 0x00000002 },
	{ .addr = 0x0f1000868, .val = 0x00000000 },
	{ .addr = 0x0f100086c, .val = 0x00000003 },
	{ .addr = 0x0f1000870, .val = 0x00000002 },
	{ .addr = 0x0f1000874, .val = 0x00000000 },
	{ .addr = 0x0f1000878, .val = 0x00000001 },
	{ .addr = 0x0f100087c, .val = 0x00000001 },
	{ .addr = 0x0f1000880, .val = 0x00000002 },
	{ .addr = 0x0f1000884, .val = 0x00000003 },
	{ .addr = 0x0f1000888, .val = 0x00000000 },
	{ .addr = 0x0f100088c, .val = 0x00000000 },
	{ .addr = 0x0f1000890, .val = 0x00000002 },
	{ .addr = 0x0f1000894, .val = 0x00000000 },
	{ .addr = 0x0f1000898, .val = 0x00000002 },
	{ .addr = 0x0f100089c, .val = 0x00000002 },
	{ .addr = 0x0f10008a0, .val = 0x00000000 },
	{ .addr = 0x0f10008a4, .val = 0x00000002 },
	{ .addr = 0x0f10008a8, .val = 0x00000000 },
	{ .addr = 0x0f10008ac, .val = 0x00000002 },
	{ .addr = 0x0f10008b0, .val = 0x00000000 },
	{ .addr = 0x0f10008b4, .val = 0x00000003 },
	{ .addr = 0x0f10008b8, .val = 0x00000001 },
	{ .addr = 0x0f10008bc, .val = 0x00000002 },
	{ .addr = 0x0f10008c0, .val = 0x8199d222 },
	{ .addr = 0x0f10008c4, .val = 0x82010acc },
	{ .addr = 0x0f10008c8, .val = 0x839fb278 },
	{ .addr = 0x0f10008cc, .val = 0x80de2d10 },
	{ .addr = 0x0f10008d0, .val = 0x81d887c3 },
	{ .addr = 0x0f10008d4, .val = 0x82a53cf9 },
	{ .addr = 0x0f10008d8, .val = 0x8180dece },
	{ .addr = 0x0f10008dc, .val = 0x810347e0 },
	{ .addr = 0x0f10008e0, .val = 0x809e3fc5 },
	{ .addr = 0x0f1000910, .val = 0x9238321a },
	{ .addr = 0x0f1000914, .val = 0x2a82637d },
	{ .addr = 0x0f1000918, .val = 0x9be6bcd5 },
	{ .addr = 0x0f100091c, .val = 0xdf60c270 },
	{ .addr = 0x0f1000920, .val = 0x15e4afd4 },
	{ .addr = 0x0f1000924, .val = 0xc14eb0be },
	{ .addr = 0x0f1000928, .val = 0xf1e2b4a0 },
	{ .addr = 0x0f100092c, .val = 0xd422385f },
	{ .addr = 0x0f1000930, .val = 0x3b41edc7 },
	{ .addr = 0x0f1000934, .val = 0x6c6601f9 },
	{ .addr = 0x0f1000938, .val = 0x5d275266 },
	{ .addr = 0x0f100093c, .val = 0xdb75163c },
	{ .addr = 0x0f1000940, .val = 0xcbb62b35 },
	{ .addr = 0x0f1000944, .val = 0x98cd7105 },
	{ .addr = 0x0f1000948, .val = 0x7550e5c3 },
	{ .addr = 0x0f100094c, .val = 0x2bcb6ed6 },
	{ .addr = 0x0f1000950, .val = 0x1c672494 },
	{ .addr = 0x0f1000954, .val = 0x8e8240ab },
	{ .addr = 0x0f1000958, .val = 0x8c900544 },
	{ .addr = 0x0f100095c, .val = 0x25a16c4d },
	{ .addr = 0x0f1000960, .val = 0xcd564c33 },
	{ .addr = 0x0f1000964, .val = 0xf089fba5 },
	{ .addr = 0x0f1000968, .val = 0x57c96d04 },
	{ .addr = 0x0f100096c, .val = 0x3f9a23e3 },
	{ .addr = 0x0f1000970, .val = 0x7b66d0d2 },
	{ .addr = 0x0f1000974, .val = 0x930565f9 },
	{ .addr = 0x0f1000978, .val = 0xf7ad8aff },
	{ .addr = 0x0f100097c, .val = 0xeb0b3f33 },
	{ .addr = 0x0f1000980, .val = 0x306141d8 },
	{ .addr = 0x0f1000984, .val = 0xab35978e },
	{ .addr = 0x0f1000988, .val = 0xe732c651 },
	{ .addr = 0x0f100098c, .val = 0x9ebcb0da },
	{ .addr = 0x0f1000990, .val = 0x51bc652b },
	{ .addr = 0x0f1000994, .val = 0xdd85ed3d },
	{ .addr = 0x0f1000998, .val = 0xa694d9e2 },
	{ .addr = 0x0f100099c, .val = 0x587cd194 },
	{ .addr = 0x0f10009a0, .val = 0x52cc364d },
	{ .addr = 0x0f10009a4, .val = 0x3494f634 },
	{ .addr = 0x0f10009a8, .val = 0xc479b333 },
	{ .addr = 0x0f10009ac, .val = 0x93a99b9f },
	{ .addr = 0x0f10009b0, .val = 0xdf50d646 },
	{ .addr = 0x0f10009b4, .val = 0xa334768c },
	{ .addr = 0x0f10009b8, .val = 0x1bac12ca },
	{ .addr = 0x0f10009bc, .val = 0x1978dedf },
	{ .addr = 0x0f10009c0, .val = 0x48a4036d },
	{ .addr = 0x0f10009c4, .val = 0xf46517d7 },
	{ .addr = 0x0f10009c8, .val = 0xfa9b838c },
	{ .addr = 0x0f10009cc, .val = 0xfa9ca0c0 },
	{ .addr = 0x0f1010000, .val = 0x392095ae },
	{ .addr = 0x0f1010004, .val = 0xde349651 },
	{ .addr = 0x0f1010008, .val = 0xa317a436 },
	{ .addr = 0x0f101000c, .val = 0xcd4efddb },
	{ .addr = 0x0f1010010, .val = 0x8226a2cd },
	{ .addr = 0x0f1010014, .val = 0xf03ac291 },
	{ .addr = 0x0f1010018, .val = 0x805bdc4e },
	{ .addr = 0x0f101001c, .val = 0x496138cd },
	{ .addr = 0x0f1010050, .val = 0x0000001a },
	{ .addr = 0x0f1010054, .val = 0x1dd86ca5 },
	{ .addr = 0x0f1010058, .val = 0x0000828c },
	{ .addr = 0x0f101005c, .val = 0x4ce88cb1 },
	{ .addr = 0x0f1010060, .val = 0x4463e955 },
	{ .addr = 0x0f1010064, .val = 0x113a769d },
	{ .addr = 0x0f1010068, .val = 0x2a6d9219 },
	{ .addr = 0x0f101006c, .val = 0xbd107cf0 },
	{ .addr = 0x0f1010070, .val = 0x3ca264b3 },
	{ .addr = 0x0f1010074, .val = 0x9d5e29e7 },
	{ .addr = 0x0f1010078, .val = 0xd63b820b },
	{ .addr = 0x0f101007c, .val = 0xfe267070 },
	{ .addr = 0x0f1010080, .val = 0x1b5b0644 },
	{ .addr = 0x0f1010084, .val = 0x3761bbb5 },
	{ .addr = 0x0f1010088, .val = 0x9ac420b0 },
	{ .addr = 0x0f101008c, .val = 0x6ebbcaa2 },
	{ .addr = 0x0f1010090, .val = 0x9b3fc474 },
	{ .addr = 0x0f1010094, .val = 0x9b65a891 },
	{ .addr = 0x0f1010098, .val = 0x28a5ea30 },
	{ .addr = 0x0f101009c, .val = 0xa6e49bc2 },
	{ .addr = 0x0f10100a0, .val = 0x3afd85ec },
	{ .addr = 0x0f10100a4, .val = 0xa6830292 },
	{ .addr = 0x0f10100a8, .val = 0xcc2bbe8d },
	{ .addr = 0x0f10100ac, .val = 0xa9f95d61 },
	{ .addr = 0x0f10100b0, .val = 0xdf62a0da },
	{ .addr = 0x0f10100b4, .val = 0xe902ab92 },
	{ .addr = 0x0f10100b8, .val = 0x31fbef16 },
	{ .addr = 0x0f10100bc, .val = 0x289ed670 },
	{ .addr = 0x0f10100c0, .val = 0x325b5a73 },
	{ .addr = 0x0f10100c4, .val = 0xe6b92c7d },
	{ .addr = 0x0f10100c8, .val = 0x3dec39e4 },
	{ .addr = 0x0f10100cc, .val = 0x1a783e02 },
	{ .addr = 0x0f10100d0, .val = 0x0bfda7ed },
	{ .addr = 0x0f10100d4, .val = 0x7bc637e6 },
	{ .addr = 0x0f10100d8, .val = 0x17983826 },
	{ .addr = 0x0f10100dc, .val = 0xa62e0387 },
	{ .addr = 0x0f10100e0, .val = 0x58ae0ac4 },
	{ .addr = 0x0f10100e4, .val = 0x3d7f1a32 },
	{ .addr = 0x0f10100e8, .val = 0x7d42c53d },
	{ .addr = 0x0f10100ec, .val = 0x75d3cb57 },
	{ .addr = 0x0f10100f0, .val = 0x2481dd4e },
	{ .addr = 0x0f10100f4, .val = 0x8884e076 },
	{ .addr = 0x0f10100f8, .val = 0x5efc905f },
	{ .addr = 0x0f10100fc, .val = 0xe800e74e },
	{ .addr = 0x0f1010100, .val = 0xc8fa5149 },
	{ .addr = 0x0f1010104, .val = 0x798378bd },
	{ .addr = 0x0f1010108, .val = 0x14e0ceef },
	{ .addr = 0x0f101010c, .val = 0xb48a1940 },
	{ .addr = 0x0f1010110, .val = 0xac471b72 },
	{ .addr = 0x0f1010114, .val = 0x8286107f },
	{ .addr = 0x0f1010118, .val = 0x0aa2c484 },
	{ .addr = 0x0f101011c, .val = 0x1f15b764 },
	{ .addr = 0x0f1010120, .val = 0x55fb7f65 },
	{ .addr = 0x0f1010124, .val = 0xa9b4c869 },
	{ .addr = 0x0f1010128, .val = 0x8adb2161 },
	{ .addr = 0x0f101012c, .val = 0x6127b0c2 },
	{ .addr = 0x0f1010130, .val = 0x1ed93c86 },
	{ .addr = 0x0f1010134, .val = 0x40ad251f },
	{ .addr = 0x0f1010138, .val = 0x70cb3023 },
	{ .addr = 0x0f101013c, .val = 0xae143167 },
	{ .addr = 0x0f1010140, .val = 0x3e5d5136 },
	{ .addr = 0x0f1010144, .val = 0x956226dc },
	{ .addr = 0x0f1010148, .val = 0x8456d92c },
	{ .addr = 0x0f101014c, .val = 0xfaf6e00e },
	{ .addr = 0x0f1010150, .val = 0xfc99bf69 },
	{ .addr = 0x0f1010154, .val = 0x44f93511 },
	{ .addr = 0x0f1010158, .val = 0x2cf1c024 },
	{ .addr = 0x0f101015c, .val = 0xc49c0151 },
	{ .addr = 0x0f1010160, .val = 0x3040fa22 },
	{ .addr = 0x0f1010164, .val = 0x8e21160c },
	{ .addr = 0x0f1010168, .val = 0x2ce256c6 },
	{ .addr = 0x0f101016c, .val = 0x8bc386d5 },
	{ .addr = 0x0f1010170, .val = 0x5ba1068b },
	{ .addr = 0x0f1010174, .val = 0xbb983313 },
	{ .addr = 0x0f1010178, .val = 0x64d9a954 },
	{ .addr = 0x0f101017c, .val = 0x8d55d166 },
	{ .addr = 0x0f1010180, .val = 0xe6b994f3 },
	{ .addr = 0x0f1010184, .val = 0x7262d9d6 },
	{ .addr = 0x0f1010188, .val = 0xaaf193e0 },
	{ .addr = 0x0f101018c, .val = 0xd66301bc },
	{ .addr = 0x0f1010190, .val = 0x1d003ac7 },
	{ .addr = 0x0f1010194, .val = 0xc4e55be8 },
	{ .addr = 0x0f1010198, .val = 0xe4ad7a80 },
	{ .addr = 0x0f101019c, .val = 0xa1ee57aa },
	{ .addr = 0x0f10101a0, .val = 0x17bd7e6c },
	{ .addr = 0x0f10101a4, .val = 0x90de4f24 },
	{ .addr = 0x0f10101a8, .val = 0x0bb4016d },
	{ .addr = 0x0f10101ac, .val = 0x46ae9a22 },
	{ .addr = 0x0f10101b0, .val = 0x63115ea5 },
	{ .addr = 0x0f10101b4, .val = 0xd953673d },
	{ .addr = 0x0f10101b8, .val = 0x2669acd3 },
	{ .addr = 0x0f10101bc, .val = 0xd4d7096f },
	{ .addr = 0x0f10101c0, .val = 0xfb20ceea },
	{ .addr = 0x0f10101c4, .val = 0xe3249703 },
	{ .addr = 0x0f10101c8, .val = 0xc1d2700a },
	{ .addr = 0x0f10101cc, .val = 0x19c81b8d },
	{ .addr = 0x0f10101d0, .val = 0x41d3bc20 },
	{ .addr = 0x0f10101d4, .val = 0x262c2c03 },
	{ .addr = 0x0f10101d8, .val = 0x64deec4a },
	{ .addr = 0x0f10101dc, .val = 0x731dc9d4 },
	{ .addr = 0x0f10101e0, .val = 0xcc615449 },
	{ .addr = 0x0f10101e4, .val = 0xf0186e0d },
	{ .addr = 0x0f10101e8, .val = 0x77d58746 },
	{ .addr = 0x0f10101ec, .val = 0xfb899fe3 },
	{ .addr = 0x0f10101f0, .val = 0xf31834a3 },
	{ .addr = 0x0f10101f4, .val = 0x1412dffb },
	{ .addr = 0x0f10101f8, .val = 0xecae3950 },
	{ .addr = 0x0f10101fc, .val = 0xe60d3793 },
	{ .addr = 0x0f1010200, .val = 0x6dd92b4a },
	{ .addr = 0x0f1010204, .val = 0x98424bcf },
	{ .addr = 0x0f1010208, .val = 0x90a83394 },
	{ .addr = 0x0f101020c, .val = 0x77f4f686 },
	{ .addr = 0x0f1010210, .val = 0xa6bddac6 },
	{ .addr = 0x0f1010214, .val = 0x573349b3 },
	{ .addr = 0x0f1010218, .val = 0xdb023132 },
	{ .addr = 0x0f101021c, .val = 0x5ff91495 },
	{ .addr = 0x0f1010220, .val = 0x3ff393c5 },
	{ .addr = 0x0f1010224, .val = 0xa7ba322e },
	{ .addr = 0x0f1010228, .val = 0xee2fff7c },
	{ .addr = 0x0f101022c, .val = 0xae90041d },
	{ .addr = 0x0f1010230, .val = 0xfd904e8b },
	{ .addr = 0x0f1010234, .val = 0x17772d00 },
	{ .addr = 0x0f1010238, .val = 0xc3cac0db },
	{ .addr = 0x0f101023c, .val = 0xfb13bd3a },
	{ .addr = 0x0f1010240, .val = 0x84fe62f8 },
	{ .addr = 0x0f1010244, .val = 0x58327080 },
	{ .addr = 0x0f1010248, .val = 0x6e48657a },
	{ .addr = 0x0f101024c, .val = 0xcf68f4a8 },
	{ .addr = 0x0f1010250, .val = 0x047e1db0 },
	{ .addr = 0x0f1010254, .val = 0x05643f14 },
	{ .addr = 0x0f1010258, .val = 0xa8601d5e },
	{ .addr = 0x0f101025c, .val = 0xa105c44f },
	{ .addr = 0x0f1010260, .val = 0x458b0dbf },
	{ .addr = 0x0f1010264, .val = 0x92873883 },
	{ .addr = 0x0f1010268, .val = 0x6e4fc15c },
	{ .addr = 0x0f101026c, .val = 0xde3ff8c9 },
	{ .addr = 0x0f1010270, .val = 0x6035d213 },
	{ .addr = 0x0f1010274, .val = 0xe7aa0957 },
	{ .addr = 0x0f1010278, .val = 0xfa3cf36a },
	{ .addr = 0x0f101027c, .val = 0x07e13b3f },
	{ .addr = 0x0f1010280, .val = 0x5ccd82d2 },
	{ .addr = 0x0f1010284, .val = 0xeb11ac6f },
	{ .addr = 0x0f1010288, .val = 0x46b76004 },
	{ .addr = 0x0f101028c, .val = 0xa6770916 },
	{ .addr = 0x0f1010290, .val = 0xe52902f6 },
	{ .addr = 0x0f1010294, .val = 0x0df9a71c },
	{ .addr = 0x0f1010298, .val = 0xcc1452d7 },
	{ .addr = 0x0f101029c, .val = 0xae479741 },
	{ .addr = 0x0f10102a0, .val = 0xde669c09 },
	{ .addr = 0x0f10102a4, .val = 0xd1e1810b },
	{ .addr = 0x0f10102a8, .val = 0x16f0af98 },
	{ .addr = 0x0f10102ac, .val = 0x8426dfc2 },
	{ .addr = 0x0f10102b0, .val = 0xea0802b3 },
	{ .addr = 0x0f10102b4, .val = 0x1f00cc92 },
	{ .addr = 0x0f10102b8, .val = 0xa75bc80a },
	{ .addr = 0x0f10102bc, .val = 0x6cf90b49 },
	{ .addr = 0x0f10102c0, .val = 0x018be036 },
	{ .addr = 0x0f10102c4, .val = 0x8d7f5dca },
	{ .addr = 0x0f10102c8, .val = 0xebc9c551 },
	{ .addr = 0x0f10102cc, .val = 0x00e6d614 },
	{ .addr = 0x0f10102d0, .val = 0x3af4dcb4 },
	{ .addr = 0x0f10102d4, .val = 0x1bf64e4e },
	{ .addr = 0x0f10102d8, .val = 0x5996a390 },
	{ .addr = 0x0f10102dc, .val = 0xc425395f },
	{ .addr = 0x0f10102e0, .val = 0x5496c68c },
	{ .addr = 0x0f10102e4, .val = 0x55423ace },
	{ .addr = 0x0f10102e8, .val = 0x76ff3102 },
	{ .addr = 0x0f10102ec, .val = 0xdd9af705 },
	{ .addr = 0x0f10102f0, .val = 0x7fe36d08 },
	{ .addr = 0x0f10102f4, .val = 0x6ce48427 },
	{ .addr = 0x0f10102f8, .val = 0x6c591d39 },
	{ .addr = 0x0f10102fc, .val = 0x66660f64 },
	{ .addr = 0x0f1010300, .val = 0x2e410e5b },
	{ .addr = 0x0f1010304, .val = 0x27dadc76 },
	{ .addr = 0x0f1010308, .val = 0x81be3ef3 },
	{ .addr = 0x0f101030c, .val = 0xeeca4aa5 },
	{ .addr = 0x0f1010310, .val = 0x1200fe5a },
	{ .addr = 0x0f1010314, .val = 0xf3204edf },
	{ .addr = 0x0f1010318, .val = 0x5294f7f5 },
	{ .addr = 0x0f101031c, .val = 0x3b39b7fb },
	{ .addr = 0x0f1010320, .val = 0xe6af7a4b },
	{ .addr = 0x0f1010324, .val = 0xa48ae7b5 },
	{ .addr = 0x0f1010328, .val = 0x329220ff },
	{ .addr = 0x0f101032c, .val = 0x79dcedef },
	{ .addr = 0x0f1010330, .val = 0x74c5e2f1 },
	{ .addr = 0x0f1010334, .val = 0x522458d5 },
	{ .addr = 0x0f1010338, .val = 0xcc95b031 },
	{ .addr = 0x0f101033c, .val = 0xdc160e42 },
	{ .addr = 0x0f1010340, .val = 0x59dd4943 },
	{ .addr = 0x0f1010344, .val = 0x616695ba },
	{ .addr = 0x0f1010348, .val = 0x424059c0 },
	{ .addr = 0x0f101034c, .val = 0x784a0d47 },
	{ .addr = 0x0f1010350, .val = 0x6865faa7 },
	{ .addr = 0x0f1010354, .val = 0xd35b13ba },
	{ .addr = 0x0f1010358, .val = 0x44652a57 },
	{ .addr = 0x0f101035c, .val = 0xe0f6e2c4 },
	{ .addr = 0x0f1010360, .val = 0x0983520c },
	{ .addr = 0x0f1010364, .val = 0x2ab34919 },
	{ .addr = 0x0f1010368, .val = 0x3965db94 },
	{ .addr = 0x0f101036c, .val = 0xd803f3d0 },
	{ .addr = 0x0f1010370, .val = 0xcba19645 },
	{ .addr = 0x0f1010374, .val = 0xeced1e4a },
	{ .addr = 0x0f1010378, .val = 0x1af58d1c },
	{ .addr = 0x0f101037c, .val = 0xe2630447 },
	{ .addr = 0x0f1010380, .val = 0xe5be7ccb },
	{ .addr = 0x0f1010384, .val = 0x9420922f },
	{ .addr = 0x0f1010388, .val = 0xc5f90306 },
	{ .addr = 0x0f101038c, .val = 0xbff79b5b },
	{ .addr = 0x0f1010390, .val = 0x9f0e435a },
	{ .addr = 0x0f1010394, .val = 0x2579d599 },
	{ .addr = 0x0f1010398, .val = 0x0e65366a },
	{ .addr = 0x0f101039c, .val = 0x868f1a6b },
	{ .addr = 0x0f10103a0, .val = 0x34b2f744 },
	{ .addr = 0x0f10103a4, .val = 0xafef84f0 },
	{ .addr = 0x0f10103a8, .val = 0xaad6aed8 },
	{ .addr = 0x0f10103ac, .val = 0x5bbfa167 },
	{ .addr = 0x0f10103b0, .val = 0x33a07d2d },
	{ .addr = 0x0f10103b4, .val = 0xd6ba8318 },
	{ .addr = 0x0f10103b8, .val = 0x9bbd5f01 },
	{ .addr = 0x0f10103bc, .val = 0xe4d51460 },
	{ .addr = 0x0f10103c0, .val = 0xd1201af5 },
	{ .addr = 0x0f10103c4, .val = 0x4dade5bb },
	{ .addr = 0x0f10103c8, .val = 0x83eb5058 },
	{ .addr = 0x0f10103cc, .val = 0xdd63c019 },
	{ .addr = 0x0f10103d0, .val = 0xa7da0164 },
	{ .addr = 0x0f10103d4, .val = 0xae44583f },
	{ .addr = 0x0f10103d8, .val = 0x5ccaa778 },
	{ .addr = 0x0f10103dc, .val = 0x0ff37797 },
	{ .addr = 0x0f10103e0, .val = 0x51e8a5fd },
	{ .addr = 0x0f10103e4, .val = 0x4fa083e6 },
	{ .addr = 0x0f10103e8, .val = 0xe0877b62 },
	{ .addr = 0x0f10103ec, .val = 0x89198aa2 },
	{ .addr = 0x0f10103f0, .val = 0xf9c9a7a6 },
	{ .addr = 0x0f10103f4, .val = 0x122ed58c },
	{ .addr = 0x0f10103f8, .val = 0x157b4831 },
	{ .addr = 0x0f10103fc, .val = 0x68fb3fa4 },
	{ .addr = 0x0f1010400, .val = 0x04b61cac },
	{ .addr = 0x0f1010404, .val = 0xb3a9dda2 },
	{ .addr = 0x0f1010408, .val = 0x1606ed62 },
	{ .addr = 0x0f101040c, .val = 0xb78d58d1 },
	{ .addr = 0x0f1010410, .val = 0xf3cd55c3 },
	{ .addr = 0x0f1010414, .val = 0x3612edb6 },
	{ .addr = 0x0f1010418, .val = 0xbbaa76fd },
	{ .addr = 0x0f101041c, .val = 0x9d2e6f51 },
	{ .addr = 0x0f1010420, .val = 0xf5d77d90 },
	{ .addr = 0x0f1010424, .val = 0x413ea2e5 },
	{ .addr = 0x0f1010428, .val = 0xb525e7a8 },
	{ .addr = 0x0f101042c, .val = 0x391a18a6 },
	{ .addr = 0x0f1010430, .val = 0x05aee60a },
	{ .addr = 0x0f1010434, .val = 0xf239bc46 },
	{ .addr = 0x0f1010438, .val = 0x549d8e56 },
	{ .addr = 0x0f101043c, .val = 0xa89f028d },
	{ .addr = 0x0f1010440, .val = 0xd8a92ddb },
	{ .addr = 0x0f1010444, .val = 0x1f59a6d0 },
	{ .addr = 0x0f1010448, .val = 0xe96a2e66 },
	{ .addr = 0x0f101044c, .val = 0x3a02a2ec },
	{ .addr = 0x0f1010450, .val = 0xb98fff56 },
	{ .addr = 0x0f1010454, .val = 0xa89bcf23 },
	{ .addr = 0x0f1010458, .val = 0x61e858d2 },
	{ .addr = 0x0f101045c, .val = 0x4e15bbb3 },
	{ .addr = 0x0f1010460, .val = 0x56d8379f },
	{ .addr = 0x0f1010464, .val = 0x8d023016 },
	{ .addr = 0x0f1010468, .val = 0x50851112 },
	{ .addr = 0x0f101046c, .val = 0x188d01b5 },
	{ .addr = 0x0f1010470, .val = 0xa8bfcaab },
	{ .addr = 0x0f1010474, .val = 0xdf426f34 },
	{ .addr = 0x0f1010478, .val = 0x5647bd7f },
	{ .addr = 0x0f101047c, .val = 0xc1140ff0 },
	{ .addr = 0x0f1010480, .val = 0x61e062e8 },
	{ .addr = 0x0f1010484, .val = 0x86a8046f },
	{ .addr = 0x0f1010488, .val = 0xe0b3019e },
	{ .addr = 0x0f101048c, .val = 0x9b4345a6 },
	{ .addr = 0x0f1010490, .val = 0x811770b5 },
	{ .addr = 0x0f1010494, .val = 0x30031395 },
	{ .addr = 0x0f1010498, .val = 0xff91402e },
	{ .addr = 0x0f101049c, .val = 0x022839ea },
	{ .addr = 0x0f10104a0, .val = 0xcf59f356 },
	{ .addr = 0x0f10104a4, .val = 0xec52bb7a },
	{ .addr = 0x0f10104a8, .val = 0x084c95ad },
	{ .addr = 0x0f10104ac, .val = 0xd9664f0d },
	{ .addr = 0x0f10104b0, .val = 0x18dd3cd1 },
	{ .addr = 0x0f10104b4, .val = 0x6e08e358 },
	{ .addr = 0x0f10104b8, .val = 0xc65ae1d6 },
	{ .addr = 0x0f10104bc, .val = 0xfda3a637 },
	{ .addr = 0x0f10104c0, .val = 0x83c479c0 },
	{ .addr = 0x0f10104c4, .val = 0x61551312 },
	{ .addr = 0x0f10104c8, .val = 0xfc156e61 },
	{ .addr = 0x0f10104cc, .val = 0x2a0821d5 },
	{ .addr = 0x0f10104d0, .val = 0x026412b7 },
	{ .addr = 0x0f10104d4, .val = 0xecc47fac },
	{ .addr = 0x0f10104d8, .val = 0x907fdde6 },
	{ .addr = 0x0f10104dc, .val = 0xd65323a2 },
	{ .addr = 0x0f10104e0, .val = 0xbf10a57b },
	{ .addr = 0x0f10104e4, .val = 0x2ac24847 },
	{ .addr = 0x0f10104e8, .val = 0xfe677da8 },
	{ .addr = 0x0f10104ec, .val = 0xcf09bf42 },
	{ .addr = 0x0f10104f0, .val = 0x2d7bf72c },
	{ .addr = 0x0f10104f4, .val = 0xd40cbc44 },
	{ .addr = 0x0f10104f8, .val = 0x2f20addd },
	{ .addr = 0x0f10104fc, .val = 0x36d9c70d },
	{ .addr = 0x0f1010500, .val = 0x7f161020 },
	{ .addr = 0x0f1010504, .val = 0x14615e39 },
	{ .addr = 0x0f1010508, .val = 0x397fb674 },
	{ .addr = 0x0f101050c, .val = 0xbcc0fac2 },
	{ .addr = 0x0f1010510, .val = 0x75363535 },
	{ .addr = 0x0f1010514, .val = 0xf4f0b070 },
	{ .addr = 0x0f1010518, .val = 0x174257d8 },
	{ .addr = 0x0f101051c, .val = 0x19551e75 },
	{ .addr = 0x0f1010520, .val = 0xc5e589b4 },
	{ .addr = 0x0f1010524, .val = 0x590cc7c8 },
	{ .addr = 0x0f1010528, .val = 0xfddc92e8 },
	{ .addr = 0x0f101052c, .val = 0xd46176b1 },
	{ .addr = 0x0f1010530, .val = 0x88477420 },
	{ .addr = 0x0f1010534, .val = 0xc7da2c5f },
	{ .addr = 0x0f1010538, .val = 0x98fbed7d },
	{ .addr = 0x0f101053c, .val = 0x003adc30 },
	{ .addr = 0x0f1010540, .val = 0x59d591e5 },
	{ .addr = 0x0f1010544, .val = 0x03b51c4d },
	{ .addr = 0x0f1010548, .val = 0xc35a3bdf },
	{ .addr = 0x0f101054c, .val = 0x29aa57ad },
	{ .addr = 0x0f1010550, .val = 0x0ea96c8a },
	{ .addr = 0x0f1010554, .val = 0xeba34715 },
	{ .addr = 0x0f1010558, .val = 0xc0ac920e },
	{ .addr = 0x0f101055c, .val = 0x7159bd61 },
	{ .addr = 0x0f1010560, .val = 0xe2eef795 },
	{ .addr = 0x0f1010564, .val = 0xe6603859 },
	{ .addr = 0x0f1010568, .val = 0xe5274a90 },
	{ .addr = 0x0f101056c, .val = 0x05562c70 },
	{ .addr = 0x0f1010570, .val = 0xbf4e36ad },
	{ .addr = 0x0f1010574, .val = 0xf7b271c1 },
	{ .addr = 0x0f1010578, .val = 0xf427f31b },
	{ .addr = 0x0f101057c, .val = 0xfc651983 },
	{ .addr = 0x0f1010580, .val = 0x408bd873 },
	{ .addr = 0x0f1010584, .val = 0x2ba5b2e9 },
	{ .addr = 0x0f1010588, .val = 0xa6aaaa12 },
	{ .addr = 0x0f101058c, .val = 0x8978c92c },
	{ .addr = 0x0f1010590, .val = 0x2b46c8ad },
	{ .addr = 0x0f1010594, .val = 0x653308aa },
	{ .addr = 0x0f1010598, .val = 0x4ee60938 },
	{ .addr = 0x0f101059c, .val = 0x0d2e020e },
	{ .addr = 0x0f10105a0, .val = 0x29be3f45 },
	{ .addr = 0x0f10105a4, .val = 0x982debfd },
	{ .addr = 0x0f10105a8, .val = 0x9ace028c },
	{ .addr = 0x0f10105ac, .val = 0xbe439d9f },
	{ .addr = 0x0f10105b0, .val = 0xade85ab3 },
	{ .addr = 0x0f10105b4, .val = 0x5a6fcbc1 },
	{ .addr = 0x0f10105b8, .val = 0xef0c6cdd },
	{ .addr = 0x0f10105bc, .val = 0x627fd893 },
	{ .addr = 0x0f10105c0, .val = 0xfdc23fba },
	{ .addr = 0x0f10105c4, .val = 0x99fe4c0c },
	{ .addr = 0x0f10105c8, .val = 0x9c4fa8ed },
	{ .addr = 0x0f10105cc, .val = 0x88766420 },
	{ .addr = 0x0f10105d0, .val = 0x1ad9de52 },
	{ .addr = 0x0f10105d4, .val = 0xc89ec51d },
	{ .addr = 0x0f10105d8, .val = 0xe13a89b4 },
	{ .addr = 0x0f10105dc, .val = 0xb720e27b },
	{ .addr = 0x0f10105e0, .val = 0xfb21d4e0 },
	{ .addr = 0x0f10105e4, .val = 0xfb6e0596 },
	{ .addr = 0x0f10105e8, .val = 0xdae1b202 },
	{ .addr = 0x0f10105ec, .val = 0x07b4d0dd },
	{ .addr = 0x0f10105f0, .val = 0xd8ef6ff9 },
	{ .addr = 0x0f10105f4, .val = 0x71a9ed07 },
	{ .addr = 0x0f10105f8, .val = 0xc3026821 },
	{ .addr = 0x0f10105fc, .val = 0xb7af5547 },
	{ .addr = 0x0f1010600, .val = 0xbfd1ae53 },
	{ .addr = 0x0f1010604, .val = 0x91eda776 },
	{ .addr = 0x0f1010608, .val = 0x309d58fc },
	{ .addr = 0x0f101060c, .val = 0x1d77514b },
	{ .addr = 0x0f1010610, .val = 0x90c0de40 },
	{ .addr = 0x0f1010614, .val = 0xd693d6ce },
	{ .addr = 0x0f1010618, .val = 0xdba2bf52 },
	{ .addr = 0x0f101061c, .val = 0x7dcc2d5d },
	{ .addr = 0x0f1010620, .val = 0xc109bd4a },
	{ .addr = 0x0f1010624, .val = 0x7fb5ce0e },
	{ .addr = 0x0f1010628, .val = 0x3bd9f989 },
	{ .addr = 0x0f101062c, .val = 0x79b100f1 },
	{ .addr = 0x0f1010630, .val = 0xadbcdf6d },
	{ .addr = 0x0f1010634, .val = 0xce4fe82e },
	{ .addr = 0x0f1010638, .val = 0xa27072d2 },
	{ .addr = 0x0f101063c, .val = 0x4e7dc819 },
	{ .addr = 0x0f1010640, .val = 0x75a38997 },
	{ .addr = 0x0f1010644, .val = 0xa4ea3503 },
	{ .addr = 0x0f1010648, .val = 0x58608fca },
	{ .addr = 0x0f101064c, .val = 0x97a3dc3d },
	{ .addr = 0x0f1010650, .val = 0x1f3eb30e },
	{ .addr = 0x0f1010654, .val = 0x54673412 },
	{ .addr = 0x0f1010658, .val = 0xcff0a381 },
	{ .addr = 0x0f101065c, .val = 0xab03ebc2 },
	{ .addr = 0x0f1010660, .val = 0xe22f7505 },
	{ .addr = 0x0f1010664, .val = 0x8b25f0eb },
	{ .addr = 0x0f1010668, .val = 0x4a3c681b },
	{ .addr = 0x0f101066c, .val = 0xf369b187 },
	{ .addr = 0x0f1010670, .val = 0x13589f84 },
	{ .addr = 0x0f1010674, .val = 0xb8516a0a },
	{ .addr = 0x0f1010678, .val = 0x9b7bc45f },
	{ .addr = 0x0f101067c, .val = 0x879c497e },
	{ .addr = 0x0f1010680, .val = 0x6a222f9c },
	{ .addr = 0x0f1010684, .val = 0x886b4d2a },
	{ .addr = 0x0f1010688, .val = 0x2b5daaef },
	{ .addr = 0x0f101068c, .val = 0x8976924e },
	{ .addr = 0x0f1010690, .val = 0xbdb8d98e },
	{ .addr = 0x0f1010694, .val = 0x24092470 },
	{ .addr = 0x0f1010698, .val = 0x4fa2a2ac },
	{ .addr = 0x0f101069c, .val = 0xadc094e9 },
	{ .addr = 0x0f10106a0, .val = 0xd77ea558 },
	{ .addr = 0x0f10106a4, .val = 0xa396054c },
	{ .addr = 0x0f10106a8, .val = 0x62cb04c1 },
	{ .addr = 0x0f10106ac, .val = 0x5227ee41 },
	{ .addr = 0x0f10106b0, .val = 0x6dbcee58 },
	{ .addr = 0x0f10106b4, .val = 0xe8e6dacc },
	{ .addr = 0x0f10106b8, .val = 0x8116c333 },
	{ .addr = 0x0f10106bc, .val = 0xf2db3c1d },
	{ .addr = 0x0f10106c0, .val = 0x5010ae12 },
	{ .addr = 0x0f10106c4, .val = 0x36fb5d8d },
	{ .addr = 0x0f10106c8, .val = 0xca43d08c },
	{ .addr = 0x0f10106cc, .val = 0x1c4cd6b8 },
	{ .addr = 0x0f10106d0, .val = 0x0c1937ff },
	{ .addr = 0x0f10106d4, .val = 0xcbb64713 },
	{ .addr = 0x0f10106d8, .val = 0x0bad7bc3 },
	{ .addr = 0x0f10106dc, .val = 0x680791bf },
	{ .addr = 0x0f10106e0, .val = 0x80187772 },
	{ .addr = 0x0f10106e4, .val = 0x4ba7adf8 },
	{ .addr = 0x0f10106e8, .val = 0x7b1ed522 },
	{ .addr = 0x0f10106ec, .val = 0x96cc2fce },
	{ .addr = 0x0f10106f0, .val = 0xcad17ab4 },
	{ .addr = 0x0f10106f4, .val = 0xc39879c7 },
	{ .addr = 0x0f10106f8, .val = 0x67b44101 },
	{ .addr = 0x0f10106fc, .val = 0x9637b270 },
	{ .addr = 0x0f1010700, .val = 0x0cdd0815 },
	{ .addr = 0x0f1010704, .val = 0x81283401 },
	{ .addr = 0x0f1010708, .val = 0x6e8547e0 },
	{ .addr = 0x0f101070c, .val = 0x1ee7006e },
	{ .addr = 0x0f1010710, .val = 0x9dac860c },
	{ .addr = 0x0f1010714, .val = 0x16628fca },
	{ .addr = 0x0f1010718, .val = 0x684c5419 },
	{ .addr = 0x0f101071c, .val = 0xb3d4912a },
	{ .addr = 0x0f1010720, .val = 0x61ebe266 },
	{ .addr = 0x0f1010724, .val = 0xa940a941 },
	{ .addr = 0x0f1010728, .val = 0xbae7affd },
	{ .addr = 0x0f101072c, .val = 0x38337c99 },
	{ .addr = 0x0f1010730, .val = 0x3ce90501 },
	{ .addr = 0x0f1010734, .val = 0x986a4a49 },
	{ .addr = 0x0f1010738, .val = 0x9f66a0d0 },
	{ .addr = 0x0f101073c, .val = 0x635339d3 },
	{ .addr = 0x0f1010740, .val = 0xd03802a9 },
	{ .addr = 0x0f1010744, .val = 0x69c7e86a },
	{ .addr = 0x0f1010748, .val = 0x19680df5 },
	{ .addr = 0x0f101074c, .val = 0x2f9068a5 },
	{ .addr = 0x0f1010750, .val = 0x792a06fb },
	{ .addr = 0x0f1010754, .val = 0xbf089e31 },
	{ .addr = 0x0f1010758, .val = 0xcc7125ad },
	{ .addr = 0x0f101075c, .val = 0x4c5e57e2 },
	{ .addr = 0x0f1010760, .val = 0xf3b8b679 },
	{ .addr = 0x0f1010764, .val = 0xd1bad349 },
	{ .addr = 0x0f1010768, .val = 0x4fd9c064 },
	{ .addr = 0x0f101076c, .val = 0x49b25487 },
	{ .addr = 0x0f1010770, .val = 0x1dede36d },
	{ .addr = 0x0f1010774, .val = 0x25ab7495 },
	{ .addr = 0x0f1010778, .val = 0x39ff3a6e },
	{ .addr = 0x0f101077c, .val = 0xd862b276 },
	{ .addr = 0x0f1010780, .val = 0xaf2ea488 },
	{ .addr = 0x0f1010784, .val = 0x8d05c2b8 },
	{ .addr = 0x0f1010788, .val = 0x2b95dd65 },
	{ .addr = 0x0f101078c, .val = 0x24fbb05c },
	{ .addr = 0x0f1010790, .val = 0x9a2e7946 },
	{ .addr = 0x0f1010794, .val = 0x9a1dd6d4 },
	{ .addr = 0x0f1010798, .val = 0x70e3fa29 },
	{ .addr = 0x0f101079c, .val = 0xa4fafcb3 },
	{ .addr = 0x0f10107a0, .val = 0x4f6f27d6 },
	{ .addr = 0x0f10107a4, .val = 0x29f95eb5 },
	{ .addr = 0x0f10107a8, .val = 0x62056e3c },
	{ .addr = 0x0f10107ac, .val = 0xd6239a67 },
	{ .addr = 0x0f10107b0, .val = 0x2b7f74f9 },
	{ .addr = 0x0f10107b4, .val = 0x512df491 },
	{ .addr = 0x0f10107b8, .val = 0xf6526fb4 },
	{ .addr = 0x0f10107bc, .val = 0x487f1645 },
	{ .addr = 0x0f10107c0, .val = 0xd2305be8 },
	{ .addr = 0x0f10107c4, .val = 0x4dd9ea91 },
	{ .addr = 0x0f10107c8, .val = 0x6f77ae00 },
	{ .addr = 0x0f10107cc, .val = 0xe4b4dff4 },
	{ .addr = 0x0f10107d0, .val = 0x94919c4b },
	{ .addr = 0x0f10107d4, .val = 0x29318de8 },
	{ .addr = 0x0f10107d8, .val = 0x5c1e1790 },
	{ .addr = 0x0f10107dc, .val = 0x527ba501 },
	{ .addr = 0x0f10107e0, .val = 0xc9b37944 },
	{ .addr = 0x0f10107e4, .val = 0x57dc3e9e },
	{ .addr = 0x0f10107e8, .val = 0x1f7baaaa },
	{ .addr = 0x0f10107ec, .val = 0xb620bd13 },
	{ .addr = 0x0f10107f0, .val = 0xa5f410ad },
	{ .addr = 0x0f10107f4, .val = 0xa3196922 },
	{ .addr = 0x0f10107f8, .val = 0x38e6787e },
	{ .addr = 0x0f10107fc, .val = 0x232cc0fa },
	{ .addr = 0x0f1010800, .val = 0xd41e9f76 },
	{ .addr = 0x0f1010804, .val = 0xc868477f },
	{ .addr = 0x0f1010808, .val = 0x5af03e8d },
	{ .addr = 0x0f101080c, .val = 0x2c71e0e6 },
	{ .addr = 0x0f1010810, .val = 0x8439e102 },
	{ .addr = 0x0f1010814, .val = 0xd0f96279 },
	{ .addr = 0x0f1010818, .val = 0xa55c5019 },
	{ .addr = 0x0f101081c, .val = 0x5ad2452d },
	{ .addr = 0x0f1010820, .val = 0x21fe12f5 },
	{ .addr = 0x0f1010824, .val = 0x29b4a26d },
	{ .addr = 0x0f1010828, .val = 0x54a4d9c2 },
	{ .addr = 0x0f101082c, .val = 0xf700d2fa },
	{ .addr = 0x0f1010830, .val = 0xb990f444 },
	{ .addr = 0x0f1010834, .val = 0xdd6c7ae7 },
	{ .addr = 0x0f1010838, .val = 0xc08e7a42 },
	{ .addr = 0x0f101083c, .val = 0xde557e8f },
	{ .addr = 0x0f1010840, .val = 0xe42a7d56 },
	{ .addr = 0x0f1010844, .val = 0xbdc81f96 },
	{ .addr = 0x0f1010848, .val = 0xa6f66d86 },
	{ .addr = 0x0f101084c, .val = 0x1fc0fd90 },
	{ .addr = 0x0f1010850, .val = 0x6b4ba03b },
	{ .addr = 0x0f1010854, .val = 0x4f261406 },
	{ .addr = 0x0f1010858, .val = 0xdb86913c },
	{ .addr = 0x0f101085c, .val = 0x39185bd0 },
	{ .addr = 0x0f101087c, .val = 0x0000030c },
	{ .addr = 0x0f1010880, .val = 0xfd7cafcb },
	{ .addr = 0x0f1010890, .val = 0xd6f1ee80 },
	{ .addr = 0x0f10108a0, .val = 0x79b0fae3 },
	{ .addr = 0x0f10108b0, .val = 0xd38d10f0 },
	{ .addr = 0x0f10108c0, .val = 0x05edd226 },
	{ .addr = 0x0f10108d0, .val = 0x03b8fb7c },
	{ .addr = 0x0f10108e0, .val = 0x0c50dbf4 },
	{ .addr = 0x0f10108f0, .val = 0x052d1084 },
	{ .addr = 0x0f1010920, .val = 0x643f0d43 },
	{ .addr = 0x0f1010924, .val = 0xc3c8f873 },
	{ .addr = 0x0f1010928, .val = 0x00000662 },
	{ .addr = 0x0f1011150, .val = 0xc4d00347 },
	{ .addr = 0x0f1011154, .val = 0xfa610b2e },
	{ .addr = 0x0f1011158, .val = 0x7ede65b0 },
	{ .addr = 0x0f101115c, .val = 0x5335eeae },
	{ .addr = 0x0f1011160, .val = 0xa5a4d7ff },
	{ .addr = 0x0f1011164, .val = 0x816e4c29 },
	{ .addr = 0x0f1011168, .val = 0x0efab5d8 },
	{ .addr = 0x0f101116c, .val = 0x7506f29f },
	{ .addr = 0x0f1011170, .val = 0xadb3fe4d },
	{ .addr = 0x0f1011174, .val = 0x5b07369f },
	{ .addr = 0x0f1011178, .val = 0x21bcdb61 },
	{ .addr = 0x0f101117c, .val = 0x09c7416a },
	{ .addr = 0x0f1011180, .val = 0x0a7578e4 },
	{ .addr = 0x0f1011184, .val = 0x72ab2d60 },
	{ .addr = 0x0f1011188, .val = 0x2496bcd8 },
	{ .addr = 0x0f101118c, .val = 0x4002a6b7 },
	{ .addr = 0x0f1011190, .val = 0x8bdb3f51 },
	{ .addr = 0x0f1011194, .val = 0x02d3a1b3 },
	{ .addr = 0x0f1011198, .val = 0x557a274f },
	{ .addr = 0x0f101119c, .val = 0x76daff44 },
	{ .addr = 0x0f10111a0, .val = 0x1e97d037 },
	{ .addr = 0x0f10111a4, .val = 0xf50a4726 },
	{ .addr = 0x0f10111a8, .val = 0x1a12feab },
	{ .addr = 0x0f10111ac, .val = 0xc4ac9f61 },
	{ .addr = 0x0f10111b0, .val = 0x4f11e9a6 },
	{ .addr = 0x0f10111b4, .val = 0xe5ed0855 },
	{ .addr = 0x0f10111b8, .val = 0x312b6cf8 },
	{ .addr = 0x0f10111bc, .val = 0x00dcbaaf },
	{ .addr = 0x0f10111c8, .val = 0x00000001 },
	{ .addr = 0x0f10111cc, .val = 0x1e13260b },
	{ .addr = 0x0f1011200, .val = 0x021500d6 },
	{ .addr = 0x0f1011204, .val = 0x035c0144 },
	{ .addr = 0x0f1011208, .val = 0x03e702c5 },
	{ .addr = 0x0f101120c, .val = 0x02940033 },
	{ .addr = 0x0f1011210, .val = 0x02b00034 },
	{ .addr = 0x0f1011214, .val = 0x008f01e9 },
	{ .addr = 0x0f1011218, .val = 0x02950042 },
	{ .addr = 0x0f101121c, .val = 0x01aa001c },
	{ .addr = 0x0f1011220, .val = 0x03da024f },
	{ .addr = 0x0f1011224, .val = 0x01ac0117 },
	{ .addr = 0x0f1011228, .val = 0x035e02b4 },
	{ .addr = 0x0f101122c, .val = 0x01f7031d },
	{ .addr = 0x0f1011230, .val = 0x01d2036b },
	{ .addr = 0x0f1011234, .val = 0x028302d1 },
	{ .addr = 0x0f1011238, .val = 0x03710379 },
	{ .addr = 0x0f101123c, .val = 0x00160315 },
	{ .addr = 0x0f1011240, .val = 0x0273004a },
	{ .addr = 0x0f1011244, .val = 0x02160092 },
	{ .addr = 0x0f1011248, .val = 0x02e5025b },
	{ .addr = 0x0f101124c, .val = 0x039a016e },
	{ .addr = 0x0f1011250, .val = 0x00b10180 },
	{ .addr = 0x0f1011254, .val = 0x02c50102 },
	{ .addr = 0x0f1011258, .val = 0x010f004b },
	{ .addr = 0x0f101125c, .val = 0x026f0060 },
	{ .addr = 0x0f1011260, .val = 0x034a0212 },
	{ .addr = 0x0f1011264, .val = 0x02f1023d },
	{ .addr = 0x0f1011268, .val = 0x02ba01f2 },
	{ .addr = 0x0f101126c, .val = 0x009001a7 },
	{ .addr = 0x0f1011270, .val = 0x03510258 },
	{ .addr = 0x0f1011274, .val = 0x00c601b4 },
	{ .addr = 0x0f1011278, .val = 0x02fd005c },
	{ .addr = 0x0f101127c, .val = 0x038d01bd },
	{ .addr = 0x0f1011280, .val = 0x00180357 },
	{ .addr = 0x0f1011284, .val = 0x039c025e },
	{ .addr = 0x0f1011288, .val = 0x013f01b5 },
	{ .addr = 0x0f101128c, .val = 0x01f2015a },
	{ .addr = 0x0f1011290, .val = 0x00d103fc },
	{ .addr = 0x0f1011294, .val = 0x02b70159 },
	{ .addr = 0x0f1011298, .val = 0x01530325 },
	{ .addr = 0x0f101129c, .val = 0x00fb005a },
	{ .addr = 0x0f10112a0, .val = 0x01340397 },
	{ .addr = 0x0f10112a4, .val = 0x01a603a3 },
	{ .addr = 0x0f10112a8, .val = 0x00f40225 },
	{ .addr = 0x0f10112ac, .val = 0x00cd01cd },
	{ .addr = 0x0f10112b0, .val = 0x024103c5 },
	{ .addr = 0x0f10112b4, .val = 0x00a00265 },
	{ .addr = 0x0f10112b8, .val = 0x028701fb },
	{ .addr = 0x0f10112bc, .val = 0x00d80361 },
	{ .addr = 0x0f10112c0, .val = 0x008b02fa },
	{ .addr = 0x0f10112c4, .val = 0x02bb025b },
	{ .addr = 0x0f10112c8, .val = 0x02e5009f },
	{ .addr = 0x0f10112cc, .val = 0x00df00aa },
	{ .addr = 0x0f10112d0, .val = 0x038402bb },
	{ .addr = 0x0f10112d4, .val = 0x013403cf },
	{ .addr = 0x0f10112d8, .val = 0x037703dd },
	{ .addr = 0x0f10112dc, .val = 0x028403fd },
	{ .addr = 0x0f10112e0, .val = 0x02e40037 },
	{ .addr = 0x0f10112e4, .val = 0x02610031 },
	{ .addr = 0x0f10112e8, .val = 0x0080006d },
	{ .addr = 0x0f10112ec, .val = 0x00470173 },
	{ .addr = 0x0f10112f0, .val = 0x00780136 },
	{ .addr = 0x0f10112f4, .val = 0x012e01d6 },
	{ .addr = 0x0f10112f8, .val = 0x01a0013b },
	{ .addr = 0x0f10112fc, .val = 0x03900102 },
	{ .addr = 0x0f1011300, .val = 0x03d30204 },
	{ .addr = 0x0f1011304, .val = 0x00be02c1 },
	{ .addr = 0x0f1011308, .val = 0x00fa0165 },
	{ .addr = 0x0f101130c, .val = 0x0198013a },
	{ .addr = 0x0f1011310, .val = 0x013002b7 },
	{ .addr = 0x0f1011314, .val = 0x010c01cd },
	{ .addr = 0x0f1011318, .val = 0x03b4009e },
	{ .addr = 0x0f101131c, .val = 0x037b019f },
	{ .addr = 0x0f1011320, .val = 0x0295032c },
	{ .addr = 0x0f1011324, .val = 0x01f10339 },
	{ .addr = 0x0f1011328, .val = 0x011d03c2 },
	{ .addr = 0x0f101132c, .val = 0x001d0023 },
	{ .addr = 0x0f1011330, .val = 0x01c300c6 },
	{ .addr = 0x0f1011334, .val = 0x00100217 },
	{ .addr = 0x0f1011338, .val = 0x017903fd },
	{ .addr = 0x0f101133c, .val = 0x029b014a },
	{ .addr = 0x0f1011340, .val = 0x015603a3 },
	{ .addr = 0x0f1011344, .val = 0x01a20242 },
	{ .addr = 0x0f1011348, .val = 0x0105029c },
	{ .addr = 0x0f101134c, .val = 0x01cd030e },
	{ .addr = 0x0f1011350, .val = 0x0167033b },
	{ .addr = 0x0f1011354, .val = 0x02a5028a },
	{ .addr = 0x0f1011358, .val = 0x013a03e5 },
	{ .addr = 0x0f101135c, .val = 0x004c02e6 },
	{ .addr = 0x0f1011360, .val = 0x017f03d9 },
	{ .addr = 0x0f1011364, .val = 0x03bb016b },
	{ .addr = 0x0f1011368, .val = 0x00fb01fa },
	{ .addr = 0x0f101136c, .val = 0x038a031e },
	{ .addr = 0x0f1011370, .val = 0x02ee0320 },
	{ .addr = 0x0f1011374, .val = 0x009b00c9 },
	{ .addr = 0x0f1011378, .val = 0x037d02eb },
	{ .addr = 0x0f101137c, .val = 0x00cb03ac },
	{ .addr = 0x0f1011380, .val = 0x035b009a },
	{ .addr = 0x0f1011384, .val = 0x032f01dd },
	{ .addr = 0x0f1011388, .val = 0x03ff03f8 },
	{ .addr = 0x0f101138c, .val = 0x02ee0140 },
	{ .addr = 0x0f1011390, .val = 0x03c6007a },
	{ .addr = 0x0f1011394, .val = 0x00fa007a },
	{ .addr = 0x0f1011398, .val = 0x029c012a },
	{ .addr = 0x0f101139c, .val = 0x01f2015b },
	{ .addr = 0x0f10113a0, .val = 0x00f700b2 },
	{ .addr = 0x0f10113a4, .val = 0x020d023c },
	{ .addr = 0x0f10113a8, .val = 0x01a80303 },
	{ .addr = 0x0f10113ac, .val = 0x00420092 },
	{ .addr = 0x0f10113b0, .val = 0x03340327 },
	{ .addr = 0x0f10113b4, .val = 0x00740058 },
	{ .addr = 0x0f10113b8, .val = 0x003f03dc },
	{ .addr = 0x0f10113bc, .val = 0x0032000f },
	{ .addr = 0x0f10113c0, .val = 0x02a30127 },
	{ .addr = 0x0f10113c4, .val = 0x01cc03f6 },
	{ .addr = 0x0f10113c8, .val = 0x006602fb },
	{ .addr = 0x0f10113cc, .val = 0x03f90016 },
	{ .addr = 0x0f10113d0, .val = 0x032d0365 },
	{ .addr = 0x0f10113d4, .val = 0x01b80098 },
	{ .addr = 0x0f10113d8, .val = 0x031c0198 },
	{ .addr = 0x0f10113dc, .val = 0x01d40164 },
	{ .addr = 0x0f10113e0, .val = 0x03e80299 },
	{ .addr = 0x0f10113e4, .val = 0x013f00b9 },
	{ .addr = 0x0f10113e8, .val = 0x03f301a3 },
	{ .addr = 0x0f10113ec, .val = 0x038e0028 },
	{ .addr = 0x0f10113f0, .val = 0x01120209 },
	{ .addr = 0x0f10113f4, .val = 0x030b0339 },
	{ .addr = 0x0f10113f8, .val = 0x024f01e4 },
	{ .addr = 0x0f10113fc, .val = 0x035c00ee },
	{ .addr = 0x0f1020000, .val = 0x00000001 },
	{ .addr = 0x0f1020008, .val = 0x00000376 },
	{ .addr = 0x0f102000c, .val = 0x00000003 },
	{ .addr = 0x0f1020010, .val = 0x1529aa4b },
	{ .addr = 0x0f1020014, .val = 0x10c6cc49 },
	{ .addr = 0x0f1020018, .val = 0xbfb2494b },
	{ .addr = 0x0f102001c, .val = 0x0467845a },
	{ .addr = 0x0f1020020, .val = 0x8ef09761 },
	{ .addr = 0x0f1020024, .val = 0xd58af2d7 },
	{ .addr = 0x0f1020028, .val = 0xaee8f2c9 },
	{ .addr = 0x0f102002c, .val = 0xc93e31fc },
	{ .addr = 0x0f1020030, .val = 0xa476ab0d },
	{ .addr = 0x0f102007c, .val = 0x000035c2 },
	{ .addr = 0x0f1020080, .val = 0x00000001 },
	{ .addr = 0x0f1020084, .val = 0x00000004 },
	{ .addr = 0x0f1020088, .val = 0x0000d4b9 },
	{ .addr = 0x0f102008c, .val = 0x000081f2 },
	{ .addr = 0x0f1020090, .val = 0x0004af59 },
	{ .addr = 0x0f1020094, .val = 0x000d0c79 },
	{ .addr = 0x0f1020098, .val = 0x0000001a },
	{ .addr = 0x0f102009c, .val = 0x0000001c },
	{ .addr = 0x0f10200a0, .val = 0x00046ae0 },
	{ .addr = 0x0f10200a4, .val = 0x00045429 },
	{ .addr = 0x0f10200a8, .val = 0x00000007 },
	{ .addr = 0x0f10200ac, .val = 0x00000015 },
	{ .addr = 0x0f10200b0, .val = 0x0000eae9 },
	{ .addr = 0x0f10200b4, .val = 0x0000d51d },
	{ .addr = 0x0f10200b8, .val = 0x00000006 },
	{ .addr = 0x0f10200bc, .val = 0x6b0e1890 },
	{ .addr = 0x0f1020108, .val = 0x00000002 },
	{ .addr = 0x0f102010c, .val = 0xcfd7b33b },
	{ .addr = 0x0f102011c, .val = 0x09b88c74 },
	{ .addr = 0x0f1020124, .val = 0x00000000 },
	{ .addr = 0x0f102013c, .val = 0x0acbc98a },
	{ .addr = 0x0f1020144, .val = 0x00000000 },
	{ .addr = 0x0f102015c, .val = 0x090d80cc },
	{ .addr = 0x0f1020164, .val = 0x00000000 },
	{ .addr = 0x0f102017c, .val = 0x02d70d5b },
	{ .addr = 0x0f1020184, .val = 0x00000001 },
	{ .addr = 0x0f102019c, .val = 0x052eaee6 },
	{ .addr = 0x0f10201a4, .val = 0x00000001 },
	{ .addr = 0x0f10201bc, .val = 0x07cba488 },
	{ .addr = 0x0f10201c4, .val = 0x00000001 },
	{ .addr = 0x0f10201dc, .val = 0x00f79fa6 },
	{ .addr = 0x0f10201e4, .val = 0x00000000 },
	{ .addr = 0x0f10201fc, .val = 0x0d3dfbcb },
	{ .addr = 0x0f1020204, .val = 0x00000000 },
	{ .addr = 0x0f102021c, .val = 0x007dc706 },
	{ .addr = 0x0f1020224, .val = 0x00000000 },
	{ .addr = 0x0f102023c, .val = 0x0e005105 },
	{ .addr = 0x0f1020244, .val = 0x00000000 },
	{ .addr = 0x0f102025c, .val = 0x0c00733a },
	{ .addr = 0x0f1020264, .val = 0x00000000 },
	{ .addr = 0x0f102027c, .val = 0x0bc53230 },
	{ .addr = 0x0f1020284, .val = 0x00000001 },
	{ .addr = 0x0f102029c, .val = 0x0685ed50 },
	{ .addr = 0x0f10202a4, .val = 0x00000000 },
	{ .addr = 0x0f10202bc, .val = 0x0c80ada3 },
	{ .addr = 0x0f10202c4, .val = 0x00000001 },
	{ .addr = 0x0f10202dc, .val = 0x0404b739 },
	{ .addr = 0x0f10202e4, .val = 0x00000001 },
	{ .addr = 0x0f10202fc, .val = 0x0c62341c },
	{ .addr = 0x0f1020304, .val = 0x00000000 },
	{ .addr = 0x0f1020314, .val = 0x0000023c },
	{ .addr = 0x0f102031c, .val = 0xbe6e734b },
	{ .addr = 0x0f1020320, .val = 0x00005316 },
	{ .addr = 0x0f10203c0, .val = 0x09fe341c },
	{ .addr = 0x0f10203c4, .val = 0xbfa7f543 },
	{ .addr = 0x0f10203c8, .val = 0x68d687a1 },
	{ .addr = 0x0f10203cc, .val = 0x1fb09f34 },
	{ .addr = 0x0f10203d0, .val = 0x48bc4813 },
	{ .addr = 0x0f10203d4, .val = 0x185b92a1 },
	{ .addr = 0x0f10203d8, .val = 0xc5657412 },
	{ .addr = 0x0f10203dc, .val = 0x035a9791 },
	{ .addr = 0x0f10203e0, .val = 0x3222d73e },
	{ .addr = 0x0f10203e4, .val = 0x1206450e },
	{ .addr = 0x0f10203e8, .val = 0xf4bacfb1 },
	{ .addr = 0x0f10203ec, .val = 0x9d1b9b0f },
	{ .addr = 0x0f10203f0, .val = 0x5b25e9df },
	{ .addr = 0x0f10203f4, .val = 0x78b7f175 },
	{ .addr = 0x0f10203f8, .val = 0x44b0b9cf },
	{ .addr = 0x0f10203fc, .val = 0xb53df490 },
	{ .addr = 0x0f11c0000, .val = 0x009fd041 },
	{ .addr = 0x0f11c0004, .val = 0x00000001 },
	{ .addr = 0x0f11c0008, .val = 0xf9e2f38e },
	{ .addr = 0x0f11c000c, .val = 0x00000010 },
	{ .addr = 0x0f11c0010, .val = 0x00000dd4 },
	{ .addr = 0x0f11c0014, .val = 0x0000dfbe },
	{ .addr = 0x0f11c0034, .val = 0x7b000000 },
	{ .addr = 0x0f11c003c, .val = 0x32c00000 },
	{ .addr = 0x0f11c0044, .val = 0x07800000 },
	{ .addr = 0x0f11c0048, .val = 0x00000002 },
	{ .addr = 0x0f11c004c, .val = 0x00000020 },
	{ .addr = 0x0f11c005c, .val = 0x74400000 },
	{ .addr = 0x0f11c0060, .val = 0x0000001d },
	{ .addr = 0x0f11c0300, .val = 0x39af96be },
	{ .addr = 0x0f11c0304, .val = 0x9a4add70 },
	{ .addr = 0x0f11c0308, .val = 0xe2bc1505 },
	{ .addr = 0x0f11c030c, .val = 0x5ec889ef },
	{ .addr = 0x0f11c0310, .val = 0x0a0b5206 },
	{ .addr = 0x0f11c0314, .val = 0x77a8c826 },
	{ .addr = 0x0f11c0318, .val = 0x488398c9 },
	{ .addr = 0x0f11c031c, .val = 0x650be3fe },
	{ .addr = 0x0f11c0320, .val = 0x7895c6b3 },
	{ .addr = 0x0f11c0324, .val = 0x3697e63e },
	{ .addr = 0x0f11c0328, .val = 0xe9b24d16 },
	{ .addr = 0x0f11c032c, .val = 0x641350cd },
	{ .addr = 0x0f11c0330, .val = 0x0e763576 },
	{ .addr = 0x0f11c0334, .val = 0xfafb68ce },
	{ .addr = 0x0f11c0338, .val = 0xfe735898 },
	{ .addr = 0x0f11c033c, .val = 0x439fd534 },
	{ .addr = 0x0f11c0400, .val = 0x0e006b20 },
	{ .addr = 0x0f11c0404, .val = 0x6abb3bac },
	{ .addr = 0x0f11c0408, .val = 0xe891ab04 },
	{ .addr = 0x0f11c040c, .val = 0x941a798b },
	{ .addr = 0x0f11c0410, .val = 0xc9a5d876 },
	{ .addr = 0x0f11c0414, .val = 0x16b5331c },
	{ .addr = 0x0f11c0418, .val = 0x11b2e620 },
	{ .addr = 0x0f11c041c, .val = 0x8ae06ca1 },
	{ .addr = 0x0f11c0420, .val = 0x8b6e0f97 },
	{ .addr = 0x0f11c0424, .val = 0x62c612ad },
	{ .addr = 0x0f11c0428, .val = 0xda895775 },
	{ .addr = 0x0f11c042c, .val = 0x4f1a0240 },
	{ .addr = 0x0f11c0430, .val = 0x20fa506f },
	{ .addr = 0x0f11c0434, .val = 0x7451b6a5 },
	{ .addr = 0x0f11c0438, .val = 0x4f0db7f6 },
	{ .addr = 0x0f11c043c, .val = 0x1c098592 },
	{ .addr = 0x0f0080004, .val = 0x0000bd39 },
	{ .addr = 0x0f008000c, .val = 0x00004baa },
	{ .addr = 0x0f0080010, .val = 0x0effcf3e },
	{ .addr = 0x0f0080014, .val = 0x98c7611b },
	{ .addr = 0x0f008001c, .val = 0x00006714 },
	{ .addr = 0x0f0080020, .val = 0x00b7554a },
	{ .addr = 0x0f0080024, .val = 0x00f58723 },
	{ .addr = 0x0f0080028, .val = 0x00c0265b },
	{ .addr = 0x0f008002c, .val = 0x000b8e2a },
	{ .addr = 0x0f0080030, .val = 0x0069dfe8 },
	{ .addr = 0x0f0080034, .val = 0x00508134 },
	{ .addr = 0x0f0080038, .val = 0x00a363ab },
	{ .addr = 0x0f008003c, .val = 0x006de8df },
	{ .addr = 0x0f0080040, .val = 0x0054a268 },
	{ .addr = 0x0f0080044, .val = 0x00531c53 },
	{ .addr = 0x0f0080048, .val = 0x00442166 },
	{ .addr = 0x0f008004c, .val = 0x004bb6b6 },
	{ .addr = 0x0f0080050, .val = 0x00b3275e },
	{ .addr = 0x0f0080054, .val = 0x00ae2c6b },
	{ .addr = 0x0f0080058, .val = 0x0019dfde },
	{ .addr = 0x0f008005c, .val = 0x0072002e },
	{ .addr = 0x0f0080400, .val = 0x00008eb5 },
	{ .addr = 0x0f0080404, .val = 0x0000c947 },
	{ .addr = 0x0f0080408, .val = 0x0000cfca },
	{ .addr = 0x0f008040c, .val = 0x0000e520 },
	{ .addr = 0x0f0080410, .val = 0x0000cd30 },
	{ .addr = 0x0f0080414, .val = 0x000074fe },
	{ .addr = 0x0f0080418, .val = 0x00005017 },
	{ .addr = 0x0f008041c, .val = 0x00007b0a },
	{ .addr = 0x0f0080420, .val = 0x0000c8ea },
	{ .addr = 0x0f0080424, .val = 0x0000bdee },
	{ .addr = 0x0f0080428, .val = 0x000007e0 },
	{ .addr = 0x0f008042c, .val = 0x00006746 },
	{ .addr = 0x0f0080430, .val = 0x000013f7 },
	{ .addr = 0x0f0080434, .val = 0x0000457c },
	{ .addr = 0x0f0080438, .val = 0x00000ca8 },
	{ .addr = 0x0f008043c, .val = 0x0000014e },
	{ .addr = 0x0f0080440, .val = 0x0000da50 },
	{ .addr = 0x0f0080444, .val = 0x000039e1 },
	{ .addr = 0x0f0080448, .val = 0x0000bf02 },
	{ .addr = 0x0f008044c, .val = 0x0000b883 },
	{ .addr = 0x0f0080450, .val = 0x00003e8f },
	{ .addr = 0x0f0080454, .val = 0x000096b8 },
	{ .addr = 0x0f0080458, .val = 0x0000808e },
	{ .addr = 0x0f008045c, .val = 0x0000d7ce },
	{ .addr = 0x0f0080460, .val = 0x00007dbe },
	{ .addr = 0x0f0080464, .val = 0x000048d5 },
	{ .addr = 0x0f0080468, .val = 0x00008b83 },
	{ .addr = 0x0f008046c, .val = 0x00009711 },
	{ .addr = 0x0f0080470, .val = 0x00004e77 },
	{ .addr = 0x0f0080474, .val = 0x000054c4 },
	{ .addr = 0x0f0080478, .val = 0x0000a1c2 },
	{ .addr = 0x0f008047c, .val = 0x0000a024 },
	{ .addr = 0x0f00804c0, .val = 0x0000d12f },
	{ .addr = 0x0f00804c4, .val = 0x000020ed },
	{ .addr = 0x0f00804c8, .val = 0x00005b74 },
	{ .addr = 0x0f00804cc, .val = 0x00003a91 },
	{ .addr = 0x0f00804d0, .val = 0x0000dc5f },
	{ .addr = 0x0f00804d4, .val = 0x0000ae88 },
	{ .addr = 0x0f00804d8, .val = 0x000050d0 },
	{ .addr = 0x0f00804dc, .val = 0x00002dea },
	{ .addr = 0x0f00804e0, .val = 0x0000df19 },
	{ .addr = 0x0f00804e4, .val = 0x0000c18b },
	{ .addr = 0x0f00804e8, .val = 0x0000f463 },
	{ .addr = 0x0f00804ec, .val = 0x00009879 },
	{ .addr = 0x0f00804f0, .val = 0x0000dcdb },
	{ .addr = 0x0f00804f4, .val = 0x000026cf },
	{ .addr = 0x0f00804f8, .val = 0x0000ad59 },
	{ .addr = 0x0f00804fc, .val = 0x00006b64 },
	{ .addr = 0x0f0080500, .val = 0x00005ab0 },
	{ .addr = 0x0f0080504, .val = 0x000017c3 },
	{ .addr = 0x0f0080508, .val = 0x00007bce },
	{ .addr = 0x0f008050c, .val = 0x0000ce1e },
	{ .addr = 0x0f0080510, .val = 0x0000bd30 },
	{ .addr = 0x0f0080514, .val = 0x000018d3 },
	{ .addr = 0x0f0080518, .val = 0x000005fd },
	{ .addr = 0x0f008051c, .val = 0x0000266a },
	{ .addr = 0x0f0080520, .val = 0x0000fc8b },
	{ .addr = 0x0f0080524, .val = 0x00008539 },
	{ .addr = 0x0f0080528, .val = 0x00007e43 },
	{ .addr = 0x0f008052c, .val = 0x00008a79 },
	{ .addr = 0x0f0080530, .val = 0x000040e5 },
	{ .addr = 0x0f0080534, .val = 0x0000b615 },
	{ .addr = 0x0f0080538, .val = 0x000051d7 },
	{ .addr = 0x0f008053c, .val = 0x00000b43 },
	{ .addr = 0x0f0080540, .val = 0xa2421bf6 },
	{ .addr = 0x0f0080544, .val = 0xe0e74416 },
	{ .addr = 0x0f0080548, .val = 0x92193cd4 },
	{ .addr = 0x0f008054c, .val = 0xdbe28606 },
	{ .addr = 0x0f0080550, .val = 0x14b456a1 },
	{ .addr = 0x0f0080554, .val = 0xfe0950ca },
	{ .addr = 0x0f0080558, .val = 0xe56a5fe8 },
	{ .addr = 0x0f008055c, .val = 0xc028833f },
	{ .addr = 0x0f0080560, .val = 0xd9d7610d },
	{ .addr = 0x0f0080564, .val = 0xd0e055c7 },
	{ .addr = 0x0f0080568, .val = 0x8a9e4d97 },
	{ .addr = 0x0f008056c, .val = 0x1361190a },
	{ .addr = 0x0f0080570, .val = 0x70f4b675 },
	{ .addr = 0x0f0080574, .val = 0x8ce1dada },
	{ .addr = 0x0f0080578, .val = 0x3467243d },
	{ .addr = 0x0f008057c, .val = 0x31d18e7e },
	{ .addr = 0x0f0080580, .val = 0x0000004e },
	{ .addr = 0x0f0080584, .val = 0x000000fb },
	{ .addr = 0x0f0080588, .val = 0x00000001 },
	{ .addr = 0x0f008058c, .val = 0x0000000f },
	{ .addr = 0x0f0080590, .val = 0x000000f9 },
	{ .addr = 0x0f0080594, .val = 0x00000030 },
	{ .addr = 0x0f0080598, .val = 0x000000d4 },
	{ .addr = 0x0f008059c, .val = 0x00000089 },
	{ .addr = 0x0f00805a0, .val = 0x00000099 },
	{ .addr = 0x0f00805a4, .val = 0x00000042 },
	{ .addr = 0x0f00805a8, .val = 0x000000a9 },
	{ .addr = 0x0f00805ac, .val = 0x00000007 },
	{ .addr = 0x0f00805b0, .val = 0x0000000f },
	{ .addr = 0x0f00805b4, .val = 0x00000032 },
	{ .addr = 0x0f00805b8, .val = 0x00000067 },
	{ .addr = 0x0f00805bc, .val = 0x000000cb },
	{ .addr = 0x0f0080740, .val = 0x63fd179f },
	{ .addr = 0x0f0080744, .val = 0xec5bcf0e },
	{ .addr = 0x0f0080748, .val = 0xae115ed5 },
	{ .addr = 0x0f008074c, .val = 0x34b94832 },
	{ .addr = 0x0f0080750, .val = 0xc7b1b6a5 },
	{ .addr = 0x0f0080754, .val = 0x3247e74c },
	{ .addr = 0x0f0080758, .val = 0x505e2338 },
	{ .addr = 0x0f008075c, .val = 0xab454c58 },
	{ .addr = 0x0f0080760, .val = 0x7cca5e8f },
	{ .addr = 0x0f0080764, .val = 0xa822a4b6 },
	{ .addr = 0x0f0080768, .val = 0x92c81765 },
	{ .addr = 0x0f008076c, .val = 0x7804e04e },
	{ .addr = 0x0f0080770, .val = 0xe61e24e3 },
	{ .addr = 0x0f0080774, .val = 0x9e2dc020 },
	{ .addr = 0x0f0080778, .val = 0x7426539d },
	{ .addr = 0x0f008077c, .val = 0x97096aeb },
	{ .addr = 0x0f0b08000, .val = 0x00000001 },
	{ .addr = 0x0f0b08004, .val = 0x00000000 },
	{ .addr = 0x0f0b08008, .val = 0x00000001 },
	{ .addr = 0x0f0b0800c, .val = 0x00000001 },
	{ .addr = 0x0f0b08010, .val = 0x00000001 },
	{ .addr = 0x0f0b08014, .val = 0x00000001 },
	{ .addr = 0x0f0b08800, .val = 0x00000000 },
	{ .addr = 0x0f0b08804, .val = 0x00000001 },
	{ .addr = 0x0f0b08808, .val = 0x00000001 },
	{ .addr = 0x0f0b0880c, .val = 0x00000000 },
	{ .addr = 0x0f0b08810, .val = 0x00000000 },
	{ .addr = 0x0f0b08814, .val = 0x00000001 },
	{ .addr = 0x0f0b08818, .val = 0x00000001 },
	{ .addr = 0x0f0b0881c, .val = 0x00000000 },
	{ .addr = 0x0f0b08820, .val = 0x00000000 },
	{ .addr = 0x0f0b08824, .val = 0x00000000 },
	{ .addr = 0x0f0b08828, .val = 0x00000000 },
	{ .addr = 0x0f0b0882c, .val = 0x00000000 },
	{ .addr = 0x0f0b08830, .val = 0x00000000 },
	{ .addr = 0x0f0b08834, .val = 0x00000000 },
	{ .addr = 0x0f0b08838, .val = 0x00000000 },
	{ .addr = 0x0f0b0883c, .val = 0x00000001 },
	{ .addr = 0x0f0b09400, .val = 0x00000001 },
	{ .addr = 0x0f0b09800, .val = 0x00000320 },
	{ .addr = 0x0f0b09804, .val = 0x00000380 },
	{ .addr = 0x0f0b09808, .val = 0x0000005a },
	{ .addr = 0x0f0b0980c, .val = 0x00000154 },
	{ .addr = 0x0f0b09810, .val = 0x000002db },
	{ .addr = 0x0f0b09814, .val = 0x0000030f },
	{ .addr = 0x0f0b09818, .val = 0x0000025e },
	{ .addr = 0x0f0b0981c, .val = 0x000000b7 },
	{ .addr = 0x0f0b09820, .val = 0x000001f9 },
	{ .addr = 0x0f0b09824, .val = 0x000002e8 },
	{ .addr = 0x0f0b09828, .val = 0x00000269 },
	{ .addr = 0x0f0b0982c, .val = 0x0000008d },
	{ .addr = 0x0f0b09830, .val = 0x00000035 },
	{ .addr = 0x0f0b09834, .val = 0x000000ae },
	{ .addr = 0x0f0b09838, .val = 0x0000010f },
	{ .addr = 0x0f0b0983c, .val = 0x000001f1 },
	{ .addr = 0x0f0b0a000, .val = 0xdc10858c },
	{ .addr = 0x0f0b0a004, .val = 0x4810fb12 },
	{ .addr = 0x0f0b0a008, .val = 0xb67bf39f },
	{ .addr = 0x0f0b0a00c, .val = 0x4019ad7d },
	{ .addr = 0x0f0b0a010, .val = 0x0ef97d14 },
	{ .addr = 0x0f0b0a014, .val = 0x1ea71248 },
	{ .addr = 0x0f0b0a018, .val = 0x4847b8cf },
	{ .addr = 0x0f0b0a01c, .val = 0x0130815c },
	{ .addr = 0x0f0b0a020, .val = 0xd0411735 },
	{ .addr = 0x0f0b0a024, .val = 0xbe846977 },
	{ .addr = 0x0f0b0a028, .val = 0x059f7614 },
	{ .addr = 0x0f0b0a02c, .val = 0x7104d5f9 },
	{ .addr = 0x0f0b0a030, .val = 0xb05c7bf2 },
	{ .addr = 0x0f0b0a034, .val = 0xf41bba6f },
	{ .addr = 0x0f0b0a038, .val = 0xbeb336a9 },
	{ .addr = 0x0f0b0a03c, .val = 0x07409be9 },
	{ .addr = 0x0f0b0b000, .val = 0x00000001 },
	{ .addr = 0x0f0b0b004, .val = 0x00000000 },
	{ .addr = 0x0f0b0b008, .val = 0x00000000 },
	{ .addr = 0x0f0b0b00c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b010, .val = 0x00000001 },
	{ .addr = 0x0f0b0b014, .val = 0x00000001 },
	{ .addr = 0x0f0b0b018, .val = 0x00000000 },
	{ .addr = 0x0f0b0b01c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b020, .val = 0x00000001 },
	{ .addr = 0x0f0b0b024, .val = 0x00000001 },
	{ .addr = 0x0f0b0b028, .val = 0x00000001 },
	{ .addr = 0x0f0b0b02c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b030, .val = 0x00000001 },
	{ .addr = 0x0f0b0b034, .val = 0x00000001 },
	{ .addr = 0x0f0b0b038, .val = 0x00000000 },
	{ .addr = 0x0f0b0b03c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b040, .val = 0x00000001 },
	{ .addr = 0x0f0b0b044, .val = 0x00000001 },
	{ .addr = 0x0f0b0b048, .val = 0x00000000 },
	{ .addr = 0x0f0b0b04c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b050, .val = 0x00000001 },
	{ .addr = 0x0f0b0b054, .val = 0x00000000 },
	{ .addr = 0x0f0b0b058, .val = 0x00000001 },
	{ .addr = 0x0f0b0b05c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b060, .val = 0x00000001 },
	{ .addr = 0x0f0b0b064, .val = 0x00000001 },
	{ .addr = 0x0f0b0b068, .val = 0x00000000 },
	{ .addr = 0x0f0b0b06c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b070, .val = 0x00000001 },
	{ .addr = 0x0f0b0b074, .val = 0x00000001 },
	{ .addr = 0x0f0b0b078, .val = 0x00000000 },
	{ .addr = 0x0f0b0b07c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b080, .val = 0x00000001 },
	{ .addr = 0x0f0b0b084, .val = 0x00000001 },
	{ .addr = 0x0f0b0b088, .val = 0x00000000 },
	{ .addr = 0x0f0b0b08c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b090, .val = 0x00000001 },
	{ .addr = 0x0f0b0b094, .val = 0x00000000 },
	{ .addr = 0x0f0b0b098, .val = 0x00000001 },
	{ .addr = 0x0f0b0b09c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0a0, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0a4, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0a8, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0ac, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0b0, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0b4, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0b8, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0bc, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0c0, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0c4, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0c8, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0cc, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0d0, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0d4, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0d8, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0dc, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0e0, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0e4, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0e8, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0ec, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0f0, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0f4, .val = 0x00000000 },
	{ .addr = 0x0f0b0b0f8, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0fc, .val = 0x00000000 },
	{ .addr = 0x0f0b0b100, .val = 0x00000000 },
	{ .addr = 0x0f0b0b104, .val = 0x00000001 },
	{ .addr = 0x0f0b0b108, .val = 0x00000000 },
	{ .addr = 0x0f0b0b10c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b110, .val = 0x00000001 },
	{ .addr = 0x0f0b0b114, .val = 0x00000000 },
	{ .addr = 0x0f0b0b118, .val = 0x00000000 },
	{ .addr = 0x0f0b0b11c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b120, .val = 0x00000001 },
	{ .addr = 0x0f0b0b124, .val = 0x00000001 },
	{ .addr = 0x0f0b0b128, .val = 0x00000000 },
	{ .addr = 0x0f0b0b12c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b130, .val = 0x00000001 },
	{ .addr = 0x0f0b0b134, .val = 0x00000001 },
	{ .addr = 0x0f0b0b138, .val = 0x00000001 },
	{ .addr = 0x0f0b0b13c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b140, .val = 0x00000001 },
	{ .addr = 0x0f0b0b144, .val = 0x00000001 },
	{ .addr = 0x0f0b0b148, .val = 0x00000000 },
	{ .addr = 0x0f0b0b14c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b150, .val = 0x00000000 },
	{ .addr = 0x0f0b0b154, .val = 0x00000000 },
	{ .addr = 0x0f0b0b158, .val = 0x00000000 },
	{ .addr = 0x0f0b0b15c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b160, .val = 0x00000000 },
	{ .addr = 0x0f0b0b164, .val = 0x00000000 },
	{ .addr = 0x0f0b0b168, .val = 0x00000001 },
	{ .addr = 0x0f0b0b16c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b170, .val = 0x00000001 },
	{ .addr = 0x0f0b0b174, .val = 0x00000001 },
	{ .addr = 0x0f0b0b178, .val = 0x00000000 },
	{ .addr = 0x0f0b0b17c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b400, .val = 0x00000000 },
	{ .addr = 0x0f0b0b404, .val = 0x00000001 },
	{ .addr = 0x0f0b0b408, .val = 0x00000006 },
	{ .addr = 0x0f0b0b40c, .val = 0x00000006 },
	{ .addr = 0x0f0b0b410, .val = 0x00000002 },
	{ .addr = 0x0f0b0b414, .val = 0x00000004 },
	{ .addr = 0x0f0b0b418, .val = 0x00000006 },
	{ .addr = 0x0f0b0b41c, .val = 0x00000003 },
	{ .addr = 0x0f0b0b420, .val = 0x00000001 },
	{ .addr = 0x0f0b0b424, .val = 0x00000006 },
	{ .addr = 0x0f0b0b428, .val = 0x00000001 },
	{ .addr = 0x0f0b0b42c, .val = 0x00000005 },
	{ .addr = 0x0f0b0b430, .val = 0x00000006 },
	{ .addr = 0x0f0b0b434, .val = 0x00000005 },
	{ .addr = 0x0f0b0b438, .val = 0x00000003 },
	{ .addr = 0x0f0b0b43c, .val = 0x00000007 },
	{ .addr = 0x0f0b0b440, .val = 0x00000004 },
	{ .addr = 0x0f0b0b444, .val = 0x00000003 },
	{ .addr = 0x0f0b0b448, .val = 0x00000002 },
	{ .addr = 0x0f0b0b44c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b450, .val = 0x00000000 },
	{ .addr = 0x0f0b0b454, .val = 0x00000002 },
	{ .addr = 0x0f0b0b458, .val = 0x00000004 },
	{ .addr = 0x0f0b0b45c, .val = 0x00000003 },
	{ .addr = 0x0f0b0b460, .val = 0x00000006 },
	{ .addr = 0x0f0b0b464, .val = 0x00000002 },
	{ .addr = 0x0f0b0b468, .val = 0x00000007 },
	{ .addr = 0x0f0b0b46c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b470, .val = 0x00000000 },
	{ .addr = 0x0f0b0b474, .val = 0x00000007 },
	{ .addr = 0x0f0b0b478, .val = 0x00000002 },
	{ .addr = 0x0f0b0b47c, .val = 0x00000003 },
	{ .addr = 0x0f0b0b480, .val = 0x00000005 },
	{ .addr = 0x0f0b0b484, .val = 0x00000005 },
	{ .addr = 0x0f0b0b488, .val = 0x00000001 },
	{ .addr = 0x0f0b0b48c, .val = 0x00000003 },
	{ .addr = 0x0f0b0b490, .val = 0x00000000 },
	{ .addr = 0x0f0b0b494, .val = 0x00000005 },
	{ .addr = 0x0f0b0b498, .val = 0x00000005 },
	{ .addr = 0x0f0b0b49c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4a0, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4a4, .val = 0x00000005 },
	{ .addr = 0x0f0b0b4a8, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4ac, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4b0, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4b4, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4b8, .val = 0x00000003 },
	{ .addr = 0x0f0b0b4bc, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4c0, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4c4, .val = 0x00000001 },
	{ .addr = 0x0f0b0b4c8, .val = 0x00000005 },
	{ .addr = 0x0f0b0b4cc, .val = 0x00000004 },
	{ .addr = 0x0f0b0b4d0, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4d4, .val = 0x00000002 },
	{ .addr = 0x0f0b0b4d8, .val = 0x00000000 },
	{ .addr = 0x0f0b0b4dc, .val = 0x00000004 },
	{ .addr = 0x0f0b0b4e0, .val = 0x00000002 },
	{ .addr = 0x0f0b0b4e4, .val = 0x00000006 },
	{ .addr = 0x0f0b0b4e8, .val = 0x00000003 },
	{ .addr = 0x0f0b0b4ec, .val = 0x00000002 },
	{ .addr = 0x0f0b0b4f0, .val = 0x00000002 },
	{ .addr = 0x0f0b0b4f4, .val = 0x00000003 },
	{ .addr = 0x0f0b0b4f8, .val = 0x00000006 },
	{ .addr = 0x0f0b0b4fc, .val = 0x00000003 },
	{ .addr = 0x0f0b0b500, .val = 0x00000005 },
	{ .addr = 0x0f0b0b504, .val = 0x00000001 },
	{ .addr = 0x0f0b0b508, .val = 0x00000004 },
	{ .addr = 0x0f0b0b50c, .val = 0x00000002 },
	{ .addr = 0x0f0b0b510, .val = 0x00000006 },
	{ .addr = 0x0f0b0b514, .val = 0x00000003 },
	{ .addr = 0x0f0b0b518, .val = 0x00000006 },
	{ .addr = 0x0f0b0b51c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b520, .val = 0x00000000 },
	{ .addr = 0x0f0b0b524, .val = 0x00000002 },
	{ .addr = 0x0f0b0b528, .val = 0x00000001 },
	{ .addr = 0x0f0b0b52c, .val = 0x00000004 },
	{ .addr = 0x0f0b0b530, .val = 0x00000001 },
	{ .addr = 0x0f0b0b534, .val = 0x00000005 },
	{ .addr = 0x0f0b0b538, .val = 0x00000007 },
	{ .addr = 0x0f0b0b53c, .val = 0x00000004 },
	{ .addr = 0x0f0b0b540, .val = 0x00000004 },
	{ .addr = 0x0f0b0b544, .val = 0x00000000 },
	{ .addr = 0x0f0b0b548, .val = 0x00000005 },
	{ .addr = 0x0f0b0b54c, .val = 0x00000000 },
	{ .addr = 0x0f0b0b550, .val = 0x00000000 },
	{ .addr = 0x0f0b0b554, .val = 0x00000004 },
	{ .addr = 0x0f0b0b558, .val = 0x00000005 },
	{ .addr = 0x0f0b0b55c, .val = 0x00000003 },
	{ .addr = 0x0f0b0b560, .val = 0x00000001 },
	{ .addr = 0x0f0b0b564, .val = 0x00000001 },
	{ .addr = 0x0f0b0b568, .val = 0x00000001 },
	{ .addr = 0x0f0b0b56c, .val = 0x00000003 },
	{ .addr = 0x0f0b0b570, .val = 0x00000002 },
	{ .addr = 0x0f0b0b574, .val = 0x00000006 },
	{ .addr = 0x0f0b0b578, .val = 0x00000003 },
	{ .addr = 0x0f0b0b57c, .val = 0x00000001 },
	{ .addr = 0x0f0b0d000, .val = 0x00000002 },
	{ .addr = 0x0f0b0d004, .val = 0x00000006 },
	{ .addr = 0x0f0b0d008, .val = 0x00000006 },
	{ .addr = 0x0f0b0d00c, .val = 0x00000000 },
	{ .addr = 0x0f0b0d010, .val = 0x00000007 },
	{ .addr = 0x0f0b0d014, .val = 0x00000003 },
	{ .addr = 0x0f0b0d018, .val = 0x00000007 },
	{ .addr = 0x0f0b0d01c, .val = 0x00000006 },
	{ .addr = 0x0f0b0d020, .val = 0x00000003 },
	{ .addr = 0x0f0b0d024, .val = 0x00000002 },
	{ .addr = 0x0f0b0d028, .val = 0x00000005 },
	{ .addr = 0x0f0b0d02c, .val = 0x00000004 },
	{ .addr = 0x0f0b0d030, .val = 0x00000001 },
	{ .addr = 0x0f0b0d034, .val = 0x00000001 },
	{ .addr = 0x0f0b0d038, .val = 0x00000007 },
	{ .addr = 0x0f0b0d03c, .val = 0x00000005 },
	{ .addr = 0x0f0b0dc00, .val = 0x00000000 },
	{ .addr = 0x0f0b0dc04, .val = 0x00000000 },
	{ .addr = 0x0f0b0dc08, .val = 0x00000000 },
	{ .addr = 0x0f0b0dc0c, .val = 0x00000000 },
	{ .addr = 0x0f0b0dc10, .val = 0x00000001 },
	{ .addr = 0x0f0b0dc14, .val = 0x00000000 },
	{ .addr = 0x0f0b0dc18, .val = 0x00000001 },
	{ .addr = 0x0f0b0dc1c, .val = 0x00000000 },
	{ .addr = 0x0f0b0e000, .val = 0x00000005 },
	{ .addr = 0x0f0b0e004, .val = 0x00000004 },
	{ .addr = 0x0f0b0e008, .val = 0x00000002 },
	{ .addr = 0x0f0b0e00c, .val = 0x00000000 },
	{ .addr = 0x0f0b0e010, .val = 0x00000000 },
	{ .addr = 0x0f0b0e014, .val = 0x00000006 },
	{ .addr = 0x0f0b0e018, .val = 0x00000004 },
	{ .addr = 0x0f0b0e01c, .val = 0x00000007 },
	{ .addr = 0x0f0b0e400, .val = 0x00000003 },
	{ .addr = 0x0f0b0e404, .val = 0x00000006 },
	{ .addr = 0x0f0b0e408, .val = 0x00000001 },
	{ .addr = 0x0f0b0e40c, .val = 0x00000002 },
	{ .addr = 0x0f0b0e410, .val = 0x00000001 },
	{ .addr = 0x0f0b0e414, .val = 0x00000005 },
	{ .addr = 0x0f0b0e418, .val = 0x00000003 },
	{ .addr = 0x0f0b0e41c, .val = 0x00000005 },
	{ .addr = 0x0f0b0e800, .val = 0x19f7b9b9 },
	{ .addr = 0x0f0b0e804, .val = 0xf93a65a1 },
	{ .addr = 0x0f0b0e808, .val = 0xef87b8af },
	{ .addr = 0x0f0b0e80c, .val = 0x0f01ed1a },
	{ .addr = 0x0f0b0e810, .val = 0x81ae71b7 },
	{ .addr = 0x0f0b0e814, .val = 0x801312d2 },
	{ .addr = 0x0f0b0e818, .val = 0xc9305b04 },
	{ .addr = 0x0f0b0e81c, .val = 0xd1f9e518 },
	{ .addr = 0x0f0b0fc00, .val = 0x00000001 },
	{ .addr = 0x0f0b0fc04, .val = 0x00000001 },
	{ .addr = 0x0f0b0fc08, .val = 0x00000001 },
	{ .addr = 0x0f0b0fc0c, .val = 0x00000001 },
	{ .addr = 0x0f0b0fc10, .val = 0x00000000 },
	{ .addr = 0x0f0b0fc14, .val = 0x00000001 },
	{ .addr = 0x0f0b0fc18, .val = 0x00000000 },
	{ .addr = 0x0f0b0fc1c, .val = 0x00000000 },
	{ .addr = 0x0f0b10000, .val = 0x0001f785 },
	{ .addr = 0x0f0b10800, .val = 0x4341ba9c },
	{ .addr = 0x0f0b11000, .val = 0x01baaa56 },
	{ .addr = 0x0f0b12000, .val = 0x00df05c9 },
	{ .addr = 0x0f0b12400, .val = 0xe570e48e },
	{ .addr = 0x0f0b12800, .val = 0x00005956 },
	{ .addr = 0x0f0b12c00, .val = 0x0000f847 },
	{ .addr = 0x0f0b13000, .val = 0x0000004c },
	{ .addr = 0x0f0b13004, .val = 0x00000056 },
	{ .addr = 0x0f0b13008, .val = 0x000000c7 },
	{ .addr = 0x0f0b1300c, .val = 0x000000be },
	{ .addr = 0x0f0b13010, .val = 0x00000015 },
	{ .addr = 0x0f0b13014, .val = 0x00000066 },
	{ .addr = 0x0f0b13018, .val = 0x00000078 },
	{ .addr = 0x0f0b1301c, .val = 0x00000014 },
	{ .addr = 0x0f0b13020, .val = 0x00000074 },
	{ .addr = 0x0f0b13024, .val = 0x000000b0 },
	{ .addr = 0x0f0b13028, .val = 0x000000e9 },
	{ .addr = 0x0f0b1302c, .val = 0x00000067 },
	{ .addr = 0x0f0b13030, .val = 0x00000034 },
	{ .addr = 0x0f0b13034, .val = 0x000000dc },
	{ .addr = 0x0f0b13038, .val = 0x000000d0 },
	{ .addr = 0x0f0b1303c, .val = 0x000000d8 },
	{ .addr = 0x0f0b13400, .val = 0x00000002 },
	{ .addr = 0x0f0b13404, .val = 0x00000077 },
	{ .addr = 0x0f0b13408, .val = 0x0000001c },
	{ .addr = 0x0f0b1340c, .val = 0x000000ce },
	{ .addr = 0x0f0b13410, .val = 0x000000e4 },
	{ .addr = 0x0f0b13414, .val = 0x000000fd },
	{ .addr = 0x0f0b13418, .val = 0x00000029 },
	{ .addr = 0x0f0b1341c, .val = 0x00000097 },
	{ .addr = 0x0f0b13420, .val = 0x0000001b },
	{ .addr = 0x0f0b13424, .val = 0x00000034 },
	{ .addr = 0x0f0b13428, .val = 0x000000e3 },
	{ .addr = 0x0f0b1342c, .val = 0x0000006c },
	{ .addr = 0x0f0b13430, .val = 0x00000047 },
	{ .addr = 0x0f0b13434, .val = 0x0000003f },
	{ .addr = 0x0f0b13438, .val = 0x0000000d },
	{ .addr = 0x0f0b1343c, .val = 0x0000000d },
	{ .addr = 0x0f0b13440, .val = 0x00000000 },
	{ .addr = 0x0f0b13444, .val = 0x00000048 },
	{ .addr = 0x0f0b13448, .val = 0x00000058 },
	{ .addr = 0x0f0b1344c, .val = 0x00000082 },
	{ .addr = 0x0f0b13450, .val = 0x0000005c },
	{ .addr = 0x0f0b13454, .val = 0x000000af },
	{ .addr = 0x0f0b13458, .val = 0x000000c6 },
	{ .addr = 0x0f0b1345c, .val = 0x000000ee },
	{ .addr = 0x0f0b13460, .val = 0x0000001b },
	{ .addr = 0x0f0b13464, .val = 0x00000032 },
	{ .addr = 0x0f0b13468, .val = 0x00000086 },
	{ .addr = 0x0f0b1346c, .val = 0x00000062 },
	{ .addr = 0x0f0b13470, .val = 0x00000076 },
	{ .addr = 0x0f0b13474, .val = 0x000000fd },
	{ .addr = 0x0f0b13478, .val = 0x00000005 },
	{ .addr = 0x0f0b1347c, .val = 0x0000007c },
	{ .addr = 0x0f0b16400, .val = 0x00000016 },
	{ .addr = 0x0f0b17000, .val = 0xad6d0b3f },
	{ .addr = 0x0f0b18400, .val = 0x6a5ef2ea },
	{ .addr = 0x0f0b19400, .val = 0x563e50c9 },
	{ .addr = 0x0f0b19404, .val = 0xed989008 },
	{ .addr = 0x0f0b19408, .val = 0xac1192fe },
	{ .addr = 0x0f0b1940c, .val = 0x4611bf80 },
	{ .addr = 0x0f0b19410, .val = 0x95919642 },
	{ .addr = 0x0f0b19414, .val = 0x7bbb802a },
	{ .addr = 0x0f0b19418, .val = 0x50107b2c },
	{ .addr = 0x0f0b1941c, .val = 0x85440bd4 },
	{ .addr = 0x0f0b20800, .val = 0x506be3ac },
	{ .addr = 0x0f0b20c00, .val = 0x170b69a0 },
	{ .addr = 0x0f0b21000, .val = 0x0000c256 },
	{ .addr = 0x0f0b28000, .val = 0x00001574 },
	{ .addr = 0x0f0b28c00, .val = 0x0000000d },
	{ .addr = 0x0f0b29000, .val = 0x0000000f },
	{ .addr = 0x0f0b29400, .val = 0x364b7856 },
	{ .addr = 0x0f0b29404, .val = 0x92ec5489 },
	{ .addr = 0x0f0b29408, .val = 0xd5ab7d07 },
	{ .addr = 0x0f0b2940c, .val = 0xfa8057bc },
	{ .addr = 0x0f0b29410, .val = 0xdc8b4090 },
	{ .addr = 0x0f0b29414, .val = 0x8cfeedce },
	{ .addr = 0x0f0b29418, .val = 0x4bc9c066 },
	{ .addr = 0x0f0b2941c, .val = 0x086d1d99 },
	{ .addr = 0x0f0b29420, .val = 0xbbbdaa77 },
	{ .addr = 0x0f0b29424, .val = 0xc3506761 },
	{ .addr = 0x0f0b29428, .val = 0xcd340e87 },
	{ .addr = 0x0f0b2942c, .val = 0x1b8ea1d0 },
	{ .addr = 0x0f0b29430, .val = 0xe9077e36 },
	{ .addr = 0x0f0b29434, .val = 0x2236df59 },
	{ .addr = 0x0f0b29438, .val = 0xd9ce3dd3 },
	{ .addr = 0x0f0b2943c, .val = 0xa5ff62c1 },
	{ .addr = 0x0f0b30800, .val = 0x00000015 },
	{ .addr = 0x0f0b30c00, .val = 0x4e0d82dd },
	{ .addr = 0x0f0b38800, .val = 0x00000000 },
	{ .addr = 0x0f0b40400, .val = 0x0000ecdf },
	{ .addr = 0x0f0b40800, .val = 0x00000001 },
	{ .addr = 0x0f0b40c00, .val = 0x00000000 },
	{ .addr = 0x0f0708000, .val = 0x00000001 },
	{ .addr = 0x0f0708004, .val = 0x00000001 },
	{ .addr = 0x0f0708008, .val = 0x00000000 },
	{ .addr = 0x0f070800c, .val = 0x00000000 },
	{ .addr = 0x0f0708010, .val = 0x00000000 },
	{ .addr = 0x0f0708014, .val = 0x00000001 },
	{ .addr = 0x0f0708800, .val = 0x00000001 },
	{ .addr = 0x0f0708804, .val = 0x00000000 },
	{ .addr = 0x0f0708808, .val = 0x00000000 },
	{ .addr = 0x0f070880c, .val = 0x00000001 },
	{ .addr = 0x0f0708810, .val = 0x00000000 },
	{ .addr = 0x0f0708814, .val = 0x00000001 },
	{ .addr = 0x0f0708818, .val = 0x00000001 },
	{ .addr = 0x0f070881c, .val = 0x00000000 },
	{ .addr = 0x0f0708820, .val = 0x00000000 },
	{ .addr = 0x0f0708824, .val = 0x00000001 },
	{ .addr = 0x0f0708828, .val = 0x00000000 },
	{ .addr = 0x0f070882c, .val = 0x00000001 },
	{ .addr = 0x0f0708830, .val = 0x00000001 },
	{ .addr = 0x0f0708834, .val = 0x00000001 },
	{ .addr = 0x0f0708838, .val = 0x00000000 },
	{ .addr = 0x0f070883c, .val = 0x00000000 },
	{ .addr = 0x0f0709400, .val = 0x00000000 },
	{ .addr = 0x0f0709800, .val = 0x00000218 },
	{ .addr = 0x0f0709804, .val = 0x000003f9 },
	{ .addr = 0x0f0709808, .val = 0x00000138 },
	{ .addr = 0x0f070980c, .val = 0x00000006 },
	{ .addr = 0x0f0709810, .val = 0x0000031b },
	{ .addr = 0x0f0709814, .val = 0x000002e1 },
	{ .addr = 0x0f0709818, .val = 0x0000024d },
	{ .addr = 0x0f070981c, .val = 0x000002bd },
	{ .addr = 0x0f0709820, .val = 0x00000250 },
	{ .addr = 0x0f0709824, .val = 0x000003e7 },
	{ .addr = 0x0f0709828, .val = 0x00000149 },
	{ .addr = 0x0f070982c, .val = 0x000000c0 },
	{ .addr = 0x0f0709830, .val = 0x00000239 },
	{ .addr = 0x0f0709834, .val = 0x00000057 },
	{ .addr = 0x0f0709838, .val = 0x0000014e },
	{ .addr = 0x0f070983c, .val = 0x000000e5 },
	{ .addr = 0x0f070a000, .val = 0x7374493e },
	{ .addr = 0x0f070a004, .val = 0x8cc72ae0 },
	{ .addr = 0x0f070a008, .val = 0x606eb5da },
	{ .addr = 0x0f070a00c, .val = 0xb1735925 },
	{ .addr = 0x0f070a010, .val = 0x9d5a2a8d },
	{ .addr = 0x0f070a014, .val = 0xfb2bb060 },
	{ .addr = 0x0f070a018, .val = 0xf5251eda },
	{ .addr = 0x0f070a01c, .val = 0x6469b4c9 },
	{ .addr = 0x0f070a020, .val = 0x1bd19088 },
	{ .addr = 0x0f070a024, .val = 0x62bff075 },
	{ .addr = 0x0f070a028, .val = 0x285f18d6 },
	{ .addr = 0x0f070a02c, .val = 0xd85ea75e },
	{ .addr = 0x0f070a030, .val = 0x890747e0 },
	{ .addr = 0x0f070a034, .val = 0x9252266e },
	{ .addr = 0x0f070a038, .val = 0xb1d54ea7 },
	{ .addr = 0x0f070a03c, .val = 0xbbfb0233 },
	{ .addr = 0x0f070b000, .val = 0x00000001 },
	{ .addr = 0x0f070b004, .val = 0x00000000 },
	{ .addr = 0x0f070b008, .val = 0x00000000 },
	{ .addr = 0x0f070b00c, .val = 0x00000000 },
	{ .addr = 0x0f070b010, .val = 0x00000000 },
	{ .addr = 0x0f070b014, .val = 0x00000001 },
	{ .addr = 0x0f070b018, .val = 0x00000000 },
	{ .addr = 0x0f070b01c, .val = 0x00000000 },
	{ .addr = 0x0f070b020, .val = 0x00000001 },
	{ .addr = 0x0f070b024, .val = 0x00000001 },
	{ .addr = 0x0f070b028, .val = 0x00000001 },
	{ .addr = 0x0f070b02c, .val = 0x00000000 },
	{ .addr = 0x0f070b030, .val = 0x00000000 },
	{ .addr = 0x0f070b034, .val = 0x00000000 },
	{ .addr = 0x0f070b038, .val = 0x00000001 },
	{ .addr = 0x0f070b03c, .val = 0x00000001 },
	{ .addr = 0x0f070b040, .val = 0x00000000 },
	{ .addr = 0x0f070b044, .val = 0x00000000 },
	{ .addr = 0x0f070b048, .val = 0x00000001 },
	{ .addr = 0x0f070b04c, .val = 0x00000000 },
	{ .addr = 0x0f070b050, .val = 0x00000000 },
	{ .addr = 0x0f070b054, .val = 0x00000000 },
	{ .addr = 0x0f070b058, .val = 0x00000000 },
	{ .addr = 0x0f070b05c, .val = 0x00000000 },
	{ .addr = 0x0f070b060, .val = 0x00000000 },
	{ .addr = 0x0f070b064, .val = 0x00000001 },
	{ .addr = 0x0f070b068, .val = 0x00000000 },
	{ .addr = 0x0f070b06c, .val = 0x00000000 },
	{ .addr = 0x0f070b070, .val = 0x00000001 },
	{ .addr = 0x0f070b074, .val = 0x00000001 },
	{ .addr = 0x0f070b078, .val = 0x00000000 },
	{ .addr = 0x0f070b07c, .val = 0x00000000 },
	{ .addr = 0x0f070b080, .val = 0x00000000 },
	{ .addr = 0x0f070b084, .val = 0x00000000 },
	{ .addr = 0x0f070b088, .val = 0x00000001 },
	{ .addr = 0x0f070b08c, .val = 0x00000000 },
	{ .addr = 0x0f070b090, .val = 0x00000000 },
	{ .addr = 0x0f070b094, .val = 0x00000000 },
	{ .addr = 0x0f070b098, .val = 0x00000000 },
	{ .addr = 0x0f070b09c, .val = 0x00000000 },
	{ .addr = 0x0f070b0a0, .val = 0x00000000 },
	{ .addr = 0x0f070b0a4, .val = 0x00000001 },
	{ .addr = 0x0f070b0a8, .val = 0x00000001 },
	{ .addr = 0x0f070b0ac, .val = 0x00000000 },
	{ .addr = 0x0f070b0b0, .val = 0x00000000 },
	{ .addr = 0x0f070b0b4, .val = 0x00000001 },
	{ .addr = 0x0f070b0b8, .val = 0x00000001 },
	{ .addr = 0x0f070b0bc, .val = 0x00000000 },
	{ .addr = 0x0f070b0c0, .val = 0x00000000 },
	{ .addr = 0x0f070b0c4, .val = 0x00000001 },
	{ .addr = 0x0f070b0c8, .val = 0x00000000 },
	{ .addr = 0x0f070b0cc, .val = 0x00000000 },
	{ .addr = 0x0f070b0d0, .val = 0x00000000 },
	{ .addr = 0x0f070b0d4, .val = 0x00000001 },
	{ .addr = 0x0f070b0d8, .val = 0x00000001 },
	{ .addr = 0x0f070b0dc, .val = 0x00000000 },
	{ .addr = 0x0f070b0e0, .val = 0x00000001 },
	{ .addr = 0x0f070b0e4, .val = 0x00000000 },
	{ .addr = 0x0f070b0e8, .val = 0x00000000 },
	{ .addr = 0x0f070b0ec, .val = 0x00000000 },
	{ .addr = 0x0f070b0f0, .val = 0x00000000 },
	{ .addr = 0x0f070b0f4, .val = 0x00000001 },
	{ .addr = 0x0f070b0f8, .val = 0x00000000 },
	{ .addr = 0x0f070b0fc, .val = 0x00000000 },
	{ .addr = 0x0f070b100, .val = 0x00000001 },
	{ .addr = 0x0f070b104, .val = 0x00000000 },
	{ .addr = 0x0f070b108, .val = 0x00000000 },
	{ .addr = 0x0f070b10c, .val = 0x00000000 },
	{ .addr = 0x0f070b110, .val = 0x00000001 },
	{ .addr = 0x0f070b114, .val = 0x00000001 },
	{ .addr = 0x0f070b118, .val = 0x00000000 },
	{ .addr = 0x0f070b11c, .val = 0x00000000 },
	{ .addr = 0x0f070b120, .val = 0x00000001 },
	{ .addr = 0x0f070b124, .val = 0x00000000 },
	{ .addr = 0x0f070b128, .val = 0x00000001 },
	{ .addr = 0x0f070b12c, .val = 0x00000001 },
	{ .addr = 0x0f070b130, .val = 0x00000001 },
	{ .addr = 0x0f070b134, .val = 0x00000000 },
	{ .addr = 0x0f070b138, .val = 0x00000001 },
	{ .addr = 0x0f070b13c, .val = 0x00000000 },
	{ .addr = 0x0f070b140, .val = 0x00000001 },
	{ .addr = 0x0f070b144, .val = 0x00000000 },
	{ .addr = 0x0f070b148, .val = 0x00000000 },
	{ .addr = 0x0f070b14c, .val = 0x00000001 },
	{ .addr = 0x0f070b150, .val = 0x00000001 },
	{ .addr = 0x0f070b154, .val = 0x00000000 },
	{ .addr = 0x0f070b158, .val = 0x00000001 },
	{ .addr = 0x0f070b15c, .val = 0x00000000 },
	{ .addr = 0x0f070b160, .val = 0x00000001 },
	{ .addr = 0x0f070b164, .val = 0x00000000 },
	{ .addr = 0x0f070b168, .val = 0x00000000 },
	{ .addr = 0x0f070b16c, .val = 0x00000000 },
	{ .addr = 0x0f070b170, .val = 0x00000001 },
	{ .addr = 0x0f070b174, .val = 0x00000000 },
	{ .addr = 0x0f070b178, .val = 0x00000000 },
	{ .addr = 0x0f070b17c, .val = 0x00000001 },
	{ .addr = 0x0f070b400, .val = 0x00000005 },
	{ .addr = 0x0f070b404, .val = 0x00000006 },
	{ .addr = 0x0f070b408, .val = 0x00000000 },
	{ .addr = 0x0f070b40c, .val = 0x00000007 },
	{ .addr = 0x0f070b410, .val = 0x00000000 },
	{ .addr = 0x0f070b414, .val = 0x00000003 },
	{ .addr = 0x0f070b418, .val = 0x00000007 },
	{ .addr = 0x0f070b41c, .val = 0x00000006 },
	{ .addr = 0x0f070b420, .val = 0x00000002 },
	{ .addr = 0x0f070b424, .val = 0x00000003 },
	{ .addr = 0x0f070b428, .val = 0x00000006 },
	{ .addr = 0x0f070b42c, .val = 0x00000006 },
	{ .addr = 0x0f070b430, .val = 0x00000000 },
	{ .addr = 0x0f070b434, .val = 0x00000003 },
	{ .addr = 0x0f070b438, .val = 0x00000002 },
	{ .addr = 0x0f070b43c, .val = 0x00000003 },
	{ .addr = 0x0f070b440, .val = 0x00000006 },
	{ .addr = 0x0f070b444, .val = 0x00000001 },
	{ .addr = 0x0f070b448, .val = 0x00000002 },
	{ .addr = 0x0f070b44c, .val = 0x00000004 },
	{ .addr = 0x0f070b450, .val = 0x00000007 },
	{ .addr = 0x0f070b454, .val = 0x00000003 },
	{ .addr = 0x0f070b458, .val = 0x00000006 },
	{ .addr = 0x0f070b45c, .val = 0x00000001 },
	{ .addr = 0x0f070b460, .val = 0x00000003 },
	{ .addr = 0x0f070b464, .val = 0x00000000 },
	{ .addr = 0x0f070b468, .val = 0x00000005 },
	{ .addr = 0x0f070b46c, .val = 0x00000005 },
	{ .addr = 0x0f070b470, .val = 0x00000006 },
	{ .addr = 0x0f070b474, .val = 0x00000004 },
	{ .addr = 0x0f070b478, .val = 0x00000001 },
	{ .addr = 0x0f070b47c, .val = 0x00000000 },
	{ .addr = 0x0f070b480, .val = 0x00000005 },
	{ .addr = 0x0f070b484, .val = 0x00000004 },
	{ .addr = 0x0f070b488, .val = 0x00000007 },
	{ .addr = 0x0f070b48c, .val = 0x00000005 },
	{ .addr = 0x0f070b490, .val = 0x00000002 },
	{ .addr = 0x0f070b494, .val = 0x00000006 },
	{ .addr = 0x0f070b498, .val = 0x00000001 },
	{ .addr = 0x0f070b49c, .val = 0x00000005 },
	{ .addr = 0x0f070b4a0, .val = 0x00000003 },
	{ .addr = 0x0f070b4a4, .val = 0x00000001 },
	{ .addr = 0x0f070b4a8, .val = 0x00000002 },
	{ .addr = 0x0f070b4ac, .val = 0x00000007 },
	{ .addr = 0x0f070b4b0, .val = 0x00000006 },
	{ .addr = 0x0f070b4b4, .val = 0x00000002 },
	{ .addr = 0x0f070b4b8, .val = 0x00000004 },
	{ .addr = 0x0f070b4bc, .val = 0x00000000 },
	{ .addr = 0x0f070b4c0, .val = 0x00000002 },
	{ .addr = 0x0f070b4c4, .val = 0x00000001 },
	{ .addr = 0x0f070b4c8, .val = 0x00000001 },
	{ .addr = 0x0f070b4cc, .val = 0x00000002 },
	{ .addr = 0x0f070b4d0, .val = 0x00000002 },
	{ .addr = 0x0f070b4d4, .val = 0x00000005 },
	{ .addr = 0x0f070b4d8, .val = 0x00000004 },
	{ .addr = 0x0f070b4dc, .val = 0x00000004 },
	{ .addr = 0x0f070b4e0, .val = 0x00000001 },
	{ .addr = 0x0f070b4e4, .val = 0x00000007 },
	{ .addr = 0x0f070b4e8, .val = 0x00000000 },
	{ .addr = 0x0f070b4ec, .val = 0x00000006 },
	{ .addr = 0x0f070b4f0, .val = 0x00000002 },
	{ .addr = 0x0f070b4f4, .val = 0x00000006 },
	{ .addr = 0x0f070b4f8, .val = 0x00000000 },
	{ .addr = 0x0f070b4fc, .val = 0x00000004 },
	{ .addr = 0x0f070b500, .val = 0x00000006 },
	{ .addr = 0x0f070b504, .val = 0x00000006 },
	{ .addr = 0x0f070b508, .val = 0x00000005 },
	{ .addr = 0x0f070b50c, .val = 0x00000000 },
	{ .addr = 0x0f070b510, .val = 0x00000004 },
	{ .addr = 0x0f070b514, .val = 0x00000002 },
	{ .addr = 0x0f070b518, .val = 0x00000001 },
	{ .addr = 0x0f070b51c, .val = 0x00000001 },
	{ .addr = 0x0f070b520, .val = 0x00000001 },
	{ .addr = 0x0f070b524, .val = 0x00000007 },
	{ .addr = 0x0f070b528, .val = 0x00000006 },
	{ .addr = 0x0f070b52c, .val = 0x00000007 },
	{ .addr = 0x0f070b530, .val = 0x00000005 },
	{ .addr = 0x0f070b534, .val = 0x00000007 },
	{ .addr = 0x0f070b538, .val = 0x00000007 },
	{ .addr = 0x0f070b53c, .val = 0x00000002 },
	{ .addr = 0x0f070b540, .val = 0x00000007 },
	{ .addr = 0x0f070b544, .val = 0x00000004 },
	{ .addr = 0x0f070b548, .val = 0x00000001 },
	{ .addr = 0x0f070b54c, .val = 0x00000005 },
	{ .addr = 0x0f070b550, .val = 0x00000000 },
	{ .addr = 0x0f070b554, .val = 0x00000004 },
	{ .addr = 0x0f070b558, .val = 0x00000003 },
	{ .addr = 0x0f070b55c, .val = 0x00000005 },
	{ .addr = 0x0f070b560, .val = 0x00000000 },
	{ .addr = 0x0f070b564, .val = 0x00000007 },
	{ .addr = 0x0f070b568, .val = 0x00000004 },
	{ .addr = 0x0f070b56c, .val = 0x00000002 },
	{ .addr = 0x0f070b570, .val = 0x00000003 },
	{ .addr = 0x0f070b574, .val = 0x00000004 },
	{ .addr = 0x0f070b578, .val = 0x00000000 },
	{ .addr = 0x0f070b57c, .val = 0x00000001 },
	{ .addr = 0x0f070d000, .val = 0x00000002 },
	{ .addr = 0x0f070d004, .val = 0x00000006 },
	{ .addr = 0x0f070d008, .val = 0x00000003 },
	{ .addr = 0x0f070d00c, .val = 0x00000002 },
	{ .addr = 0x0f070d010, .val = 0x00000000 },
	{ .addr = 0x0f070d014, .val = 0x00000006 },
	{ .addr = 0x0f070d018, .val = 0x00000001 },
	{ .addr = 0x0f070d01c, .val = 0x00000000 },
	{ .addr = 0x0f070d020, .val = 0x00000004 },
	{ .addr = 0x0f070d024, .val = 0x00000000 },
	{ .addr = 0x0f070d028, .val = 0x00000003 },
	{ .addr = 0x0f070d02c, .val = 0x00000002 },
	{ .addr = 0x0f070d030, .val = 0x00000004 },
	{ .addr = 0x0f070d034, .val = 0x00000007 },
	{ .addr = 0x0f070d038, .val = 0x00000005 },
	{ .addr = 0x0f070d03c, .val = 0x00000005 },
	{ .addr = 0x0f070dc00, .val = 0x00000000 },
	{ .addr = 0x0f070dc04, .val = 0x00000000 },
	{ .addr = 0x0f070dc08, .val = 0x00000000 },
	{ .addr = 0x0f070dc0c, .val = 0x00000000 },
	{ .addr = 0x0f070dc10, .val = 0x00000001 },
	{ .addr = 0x0f070dc14, .val = 0x00000000 },
	{ .addr = 0x0f070dc18, .val = 0x00000001 },
	{ .addr = 0x0f070dc1c, .val = 0x00000000 },
	{ .addr = 0x0f070e000, .val = 0x00000007 },
	{ .addr = 0x0f070e004, .val = 0x00000000 },
	{ .addr = 0x0f070e008, .val = 0x00000006 },
	{ .addr = 0x0f070e00c, .val = 0x00000000 },
	{ .addr = 0x0f070e010, .val = 0x00000003 },
	{ .addr = 0x0f070e014, .val = 0x00000004 },
	{ .addr = 0x0f070e018, .val = 0x00000000 },
	{ .addr = 0x0f070e01c, .val = 0x00000005 },
	{ .addr = 0x0f070e400, .val = 0x00000004 },
	{ .addr = 0x0f070e404, .val = 0x00000007 },
	{ .addr = 0x0f070e408, .val = 0x00000002 },
	{ .addr = 0x0f070e40c, .val = 0x00000005 },
	{ .addr = 0x0f070e410, .val = 0x00000003 },
	{ .addr = 0x0f070e414, .val = 0x00000006 },
	{ .addr = 0x0f070e418, .val = 0x00000006 },
	{ .addr = 0x0f070e41c, .val = 0x00000003 },
	{ .addr = 0x0f070e800, .val = 0xbd721786 },
	{ .addr = 0x0f070e804, .val = 0xbf678fe1 },
	{ .addr = 0x0f070e808, .val = 0x5014191e },
	{ .addr = 0x0f070e80c, .val = 0x27186c19 },
	{ .addr = 0x0f070e810, .val = 0x49985cdd },
	{ .addr = 0x0f070e814, .val = 0x38ac9ae7 },
	{ .addr = 0x0f070e818, .val = 0xfbf3189d },
	{ .addr = 0x0f070e81c, .val = 0x9c5b1069 },
	{ .addr = 0x0f070fc00, .val = 0x00000001 },
	{ .addr = 0x0f070fc04, .val = 0x00000000 },
	{ .addr = 0x0f070fc08, .val = 0x00000001 },
	{ .addr = 0x0f070fc0c, .val = 0x00000001 },
	{ .addr = 0x0f070fc10, .val = 0x00000001 },
	{ .addr = 0x0f070fc14, .val = 0x00000001 },
	{ .addr = 0x0f070fc18, .val = 0x00000001 },
	{ .addr = 0x0f070fc1c, .val = 0x00000001 },
	{ .addr = 0x0f0710000, .val = 0x00024fe1 },
	{ .addr = 0x0f0710800, .val = 0x8c33fbd4 },
	{ .addr = 0x0f0711000, .val = 0x6df75172 },
	{ .addr = 0x0f0712000, .val = 0x00fc8595 },
	{ .addr = 0x0f0712400, .val = 0xa5a2f4fd },
	{ .addr = 0x0f0712800, .val = 0x0000e705 },
	{ .addr = 0x0f0712c00, .val = 0x000093ac },
	{ .addr = 0x0f0713000, .val = 0x0000005a },
	{ .addr = 0x0f0713004, .val = 0x000000de },
	{ .addr = 0x0f0713008, .val = 0x00000053 },
	{ .addr = 0x0f071300c, .val = 0x00000002 },
	{ .addr = 0x0f0713010, .val = 0x00000044 },
	{ .addr = 0x0f0713014, .val = 0x000000b7 },
	{ .addr = 0x0f0713018, .val = 0x000000a0 },
	{ .addr = 0x0f071301c, .val = 0x000000d8 },
	{ .addr = 0x0f0713020, .val = 0x00000018 },
	{ .addr = 0x0f0713024, .val = 0x000000ef },
	{ .addr = 0x0f0713028, .val = 0x000000d3 },
	{ .addr = 0x0f071302c, .val = 0x0000003b },
	{ .addr = 0x0f0713030, .val = 0x000000ce },
	{ .addr = 0x0f0713034, .val = 0x0000000c },
	{ .addr = 0x0f0713038, .val = 0x000000ed },
	{ .addr = 0x0f071303c, .val = 0x0000000c },
	{ .addr = 0x0f0713400, .val = 0x000000b6 },
	{ .addr = 0x0f0713404, .val = 0x0000007a },
	{ .addr = 0x0f0713408, .val = 0x000000ab },
	{ .addr = 0x0f071340c, .val = 0x000000d2 },
	{ .addr = 0x0f0713410, .val = 0x00000027 },
	{ .addr = 0x0f0713414, .val = 0x00000031 },
	{ .addr = 0x0f0713418, .val = 0x00000049 },
	{ .addr = 0x0f071341c, .val = 0x000000b5 },
	{ .addr = 0x0f0713420, .val = 0x00000081 },
	{ .addr = 0x0f0713424, .val = 0x0000008c },
	{ .addr = 0x0f0713428, .val = 0x000000c0 },
	{ .addr = 0x0f071342c, .val = 0x00000053 },
	{ .addr = 0x0f0713430, .val = 0x0000007f },
	{ .addr = 0x0f0713434, .val = 0x00000055 },
	{ .addr = 0x0f0713438, .val = 0x0000000b },
	{ .addr = 0x0f071343c, .val = 0x0000001a },
	{ .addr = 0x0f0713440, .val = 0x00000009 },
	{ .addr = 0x0f0713444, .val = 0x0000002e },
	{ .addr = 0x0f0713448, .val = 0x00000085 },
	{ .addr = 0x0f071344c, .val = 0x000000fe },
	{ .addr = 0x0f0713450, .val = 0x0000007d },
	{ .addr = 0x0f0713454, .val = 0x000000bb },
	{ .addr = 0x0f0713458, .val = 0x00000040 },
	{ .addr = 0x0f071345c, .val = 0x000000a9 },
	{ .addr = 0x0f0713460, .val = 0x00000021 },
	{ .addr = 0x0f0713464, .val = 0x00000083 },
	{ .addr = 0x0f0713468, .val = 0x0000006f },
	{ .addr = 0x0f071346c, .val = 0x00000098 },
	{ .addr = 0x0f0713470, .val = 0x000000fb },
	{ .addr = 0x0f0713474, .val = 0x00000043 },
	{ .addr = 0x0f0713478, .val = 0x000000f0 },
	{ .addr = 0x0f071347c, .val = 0x0000009d },
	{ .addr = 0x0f0716400, .val = 0x000000e8 },
	{ .addr = 0x0f0717000, .val = 0xa334b5e4 },
	{ .addr = 0x0f0718400, .val = 0x8c5431f6 },
	{ .addr = 0x0f0719400, .val = 0xb14658ed },
	{ .addr = 0x0f0719404, .val = 0x9de0559e },
	{ .addr = 0x0f0719408, .val = 0xf6281efc },
	{ .addr = 0x0f071940c, .val = 0x12875dc6 },
	{ .addr = 0x0f0719410, .val = 0xe40d8098 },
	{ .addr = 0x0f0719414, .val = 0x0a127dcc },
	{ .addr = 0x0f0719418, .val = 0x7c159b90 },
	{ .addr = 0x0f071941c, .val = 0xa35cfeae },
	{ .addr = 0x0f0720800, .val = 0xb52a7ce0 },
	{ .addr = 0x0f0720c00, .val = 0x2f063d93 },
	{ .addr = 0x0f0721000, .val = 0x00001eb2 },
	{ .addr = 0x0f0728000, .val = 0x00003f68 },
	{ .addr = 0x0f0728c00, .val = 0x00000003 },
	{ .addr = 0x0f0729000, .val = 0x00000004 },
	{ .addr = 0x0f0729400, .val = 0x8823b31a },
	{ .addr = 0x0f0729404, .val = 0x754de71d },
	{ .addr = 0x0f0729408, .val = 0x2cac92ae },
	{ .addr = 0x0f072940c, .val = 0xfffb0433 },
	{ .addr = 0x0f0729410, .val = 0x72bb0efc },
	{ .addr = 0x0f0729414, .val = 0x271d48b5 },
	{ .addr = 0x0f0729418, .val = 0x18352b47 },
	{ .addr = 0x0f072941c, .val = 0xae2e5755 },
	{ .addr = 0x0f0729420, .val = 0x096f804c },
	{ .addr = 0x0f0729424, .val = 0x73b8de36 },
	{ .addr = 0x0f0729428, .val = 0x228a8931 },
	{ .addr = 0x0f072942c, .val = 0x7b23d584 },
	{ .addr = 0x0f0729430, .val = 0xeda46388 },
	{ .addr = 0x0f0729434, .val = 0xd7d3ca9e },
	{ .addr = 0x0f0729438, .val = 0x3cdc9161 },
	{ .addr = 0x0f072943c, .val = 0x60d7b4ba },
	{ .addr = 0x0f0730800, .val = 0x0000000a },
	{ .addr = 0x0f0730c00, .val = 0x0766bb77 },
	{ .addr = 0x0f0738800, .val = 0x00000001 },
	{ .addr = 0x0f0740400, .val = 0x000083d6 },
	{ .addr = 0x0f0740800, .val = 0x00000001 },
	{ .addr = 0x0f0740c00, .val = 0x00000001 },
};

const struct test_reg reg_mask[] = {
	{ .addr = 0x0f000110c, .val = 0x000003ff },
	{ .addr = 0x0f0000004, .val = 0x00000011 },
	{ .addr = 0x0f000000c, .val = 0x00000101 },
	{ .addr = 0x0f0002000, .val = 0x0000003f },
	{ .addr = 0x0f0002008, .val = 0x0000003f },
	{ .addr = 0x0f000200c, .val = 0x0000003f },
	{ .addr = 0x0f0018100, .val = 0x000fffff },
	{ .addr = 0x0f0018104, .val = 0x000fffff },
	{ .addr = 0x0f0018108, .val = 0x000fffff },
	{ .addr = 0x0f001810c, .val = 0x000fffff },
	{ .addr = 0x0f0018120, .val = 0x000fffff },
	{ .addr = 0x0f0018124, .val = 0x000fffff },
	{ .addr = 0x0f0018128, .val = 0x000fffff },
	{ .addr = 0x0f001812c, .val = 0x000fffff },
	{ .addr = 0x0f0018140, .val = 0x000fffff },
	{ .addr = 0x0f0018144, .val = 0x000fffff },
	{ .addr = 0x0f0018148, .val = 0x000fffff },
	{ .addr = 0x0f001814c, .val = 0x000fffff },
	{ .addr = 0x0f0018160, .val = 0x000fffff },
	{ .addr = 0x0f0018164, .val = 0x000fffff },
	{ .addr = 0x0f0018168, .val = 0x000fffff },
	{ .addr = 0x0f001816c, .val = 0x000fffff },
	{ .addr = 0x0f0018200, .val = 0x000000ff },
	{ .addr = 0x0f0018204, .val = 0x000000ff },
	{ .addr = 0x0f0018208, .val = 0x000000ff },
	{ .addr = 0x0f001820c, .val = 0x000000ff },
	{ .addr = 0x0f0018220, .val = 0x000fffff },
	{ .addr = 0x0f0018224, .val = 0x000fffff },
	{ .addr = 0x0f0018228, .val = 0x000fffff },
	{ .addr = 0x0f001822c, .val = 0x000fffff },
	{ .addr = 0x0f0018240, .val = 0x000fffff },
	{ .addr = 0x0f0018244, .val = 0x000fffff },
	{ .addr = 0x0f0018248, .val = 0x000fffff },
	{ .addr = 0x0f001824c, .val = 0x000fffff },
	{ .addr = 0x0f0018260, .val = 0x000fffff },
	{ .addr = 0x0f0018264, .val = 0x000fffff },
	{ .addr = 0x0f0018268, .val = 0x000fffff },
	{ .addr = 0x0f001826c, .val = 0x000fffff },
	{ .addr = 0x0f0018280, .val = 0x000fffff },
	{ .addr = 0x0f0018284, .val = 0x000fffff },
	{ .addr = 0x0f0018288, .val = 0x000fffff },
	{ .addr = 0x0f001828c, .val = 0x000fffff },
	{ .addr = 0x0f0018320, .val = 0x000fffff },
	{ .addr = 0x0f0018324, .val = 0x000fffff },
	{ .addr = 0x0f0018328, .val = 0x000fffff },
	{ .addr = 0x0f001832c, .val = 0x000fffff },
	{ .addr = 0x0f0018340, .val = 0x000fffff },
	{ .addr = 0x0f0018344, .val = 0x000fffff },
	{ .addr = 0x0f0018348, .val = 0x000fffff },
	{ .addr = 0x0f001834c, .val = 0x000fffff },
	{ .addr = 0x0f0018360, .val = 0x000fffff },
	{ .addr = 0x0f0018364, .val = 0x000fffff },
	{ .addr = 0x0f0018368, .val = 0x000fffff },
	{ .addr = 0x0f001836c, .val = 0x000fffff },
	{ .addr = 0x0f0018380, .val = 0x000fffff },
	{ .addr = 0x0f0018384, .val = 0x000fffff },
	{ .addr = 0x0f0018388, .val = 0x000fffff },
	{ .addr = 0x0f001838c, .val = 0x000fffff },
	{ .addr = 0x0f0018440, .val = 0x00ffffff },
	{ .addr = 0x0f0018444, .val = 0x00ffffff },
	{ .addr = 0x0f0018448, .val = 0x00ffffff },
	{ .addr = 0x0f001844c, .val = 0x00ffffff },
	{ .addr = 0x0f0018480, .val = 0x000fffff },
	{ .addr = 0x0f0018484, .val = 0x000fffff },
	{ .addr = 0x0f0018488, .val = 0x000fffff },
	{ .addr = 0x0f001848c, .val = 0x000fffff },
	{ .addr = 0x0f00184a0, .val = 0x000fffff },
	{ .addr = 0x0f00184a4, .val = 0x000fffff },
	{ .addr = 0x0f00184a8, .val = 0x000fffff },
	{ .addr = 0x0f00184ac, .val = 0x000fffff },
	{ .addr = 0x0f00184c0, .val = 0x000fffff },
	{ .addr = 0x0f00184c4, .val = 0x000fffff },
	{ .addr = 0x0f00184c8, .val = 0x000fffff },
	{ .addr = 0x0f00184cc, .val = 0x000fffff },
	{ .addr = 0x0f00184e0, .val = 0x000fffff },
	{ .addr = 0x0f00184e4, .val = 0x000fffff },
	{ .addr = 0x0f00184e8, .val = 0x000fffff },
	{ .addr = 0x0f00184ec, .val = 0x000fffff },
	{ .addr = 0x0f0018580, .val = 0x000fffff },
	{ .addr = 0x0f0018584, .val = 0x000fffff },
	{ .addr = 0x0f0018588, .val = 0x000fffff },
	{ .addr = 0x0f001858c, .val = 0x000fffff },
	{ .addr = 0x0f00185a0, .val = 0x000fffff },
	{ .addr = 0x0f00185a4, .val = 0x000fffff },
	{ .addr = 0x0f00185a8, .val = 0x000fffff },
	{ .addr = 0x0f00185ac, .val = 0x000fffff },
	{ .addr = 0x0f00185c0, .val = 0x000fffff },
	{ .addr = 0x0f00185c4, .val = 0x000fffff },
	{ .addr = 0x0f00185c8, .val = 0x000fffff },
	{ .addr = 0x0f00185cc, .val = 0x000fffff },
	{ .addr = 0x0f00185e0, .val = 0x000fffff },
	{ .addr = 0x0f00185e4, .val = 0x000fffff },
	{ .addr = 0x0f00185e8, .val = 0x000fffff },
	{ .addr = 0x0f00185ec, .val = 0x000fffff },
	{ .addr = 0x0f0018600, .val = 0x000fffff },
	{ .addr = 0x0f0018604, .val = 0x000fffff },
	{ .addr = 0x0f0018608, .val = 0x000fffff },
	{ .addr = 0x0f001860c, .val = 0x000fffff },
	{ .addr = 0x0f00186a0, .val = 0x000fffff },
	{ .addr = 0x0f00186a4, .val = 0x000fffff },
	{ .addr = 0x0f00186a8, .val = 0x000fffff },
	{ .addr = 0x0f00186ac, .val = 0x000fffff },
	{ .addr = 0x0f00187c0, .val = 0x000fffff },
	{ .addr = 0x0f00187c4, .val = 0x000fffff },
	{ .addr = 0x0f00187c8, .val = 0x000fffff },
	{ .addr = 0x0f00187cc, .val = 0x000fffff },
	{ .addr = 0x0f00187e0, .val = 0x0000001f },
	{ .addr = 0x0f00187e4, .val = 0x000003ff },
	{ .addr = 0x0f0018800, .val = 0x000000ff },
	{ .addr = 0x0f0018804, .val = 0x000000ff },
	{ .addr = 0x0f0018808, .val = 0x000000ff },
	{ .addr = 0x0f001880c, .val = 0x000000ff },
	{ .addr = 0x0f0018820, .val = 0x000fffff },
	{ .addr = 0x0f0018824, .val = 0x000fffff },
	{ .addr = 0x0f0018828, .val = 0x000fffff },
	{ .addr = 0x0f0018830, .val = 0x000fffff },
	{ .addr = 0x0f0018834, .val = 0x000fffff },
	{ .addr = 0x0f001883c, .val = 0x000003ff },
	{ .addr = 0x0f0018844, .val = 0x000fffff },
	{ .addr = 0x0f0018848, .val = 0x000fffff },
	{ .addr = 0x0f001884c, .val = 0x000fffff },
	{ .addr = 0x0f0018850, .val = 0x000fffff },
	{ .addr = 0x0f0018854, .val = 0x000fffff },
	{ .addr = 0x0f0018858, .val = 0x000fffff },
	{ .addr = 0x0f001885c, .val = 0x000fffff },
	{ .addr = 0x0f0018860, .val = 0x000f133f },
	{ .addr = 0x0f0018868, .val = 0x000f133f },
	{ .addr = 0x0f0018870, .val = 0x000f133f },
	{ .addr = 0x0f0018878, .val = 0x00ff333f },
	{ .addr = 0x0f0018880, .val = 0x000f133f },
	{ .addr = 0x0f0018888, .val = 0x000f133f },
	{ .addr = 0x0f0018890, .val = 0x000f133f },
	{ .addr = 0x0f0018898, .val = 0x000f133f },
	{ .addr = 0x0f001889c, .val = 0x000f133f },
	{ .addr = 0x0f00188a0, .val = 0x000f133f },
	{ .addr = 0x0f00188a4, .val = 0x000f133f },
	{ .addr = 0x0f00188e4, .val = 0x000fffff },
	{ .addr = 0x0f0018940, .val = 0xfff3ffff },
	{ .addr = 0x0f0010080, .val = 0x0000000f },
	{ .addr = 0x0f0010084, .val = 0xffffffff },
	{ .addr = 0x0f0004000, .val = 0x0000001f },
	{ .addr = 0x0f0004004, .val = 0x0000001f },
	{ .addr = 0x0f0004008, .val = 0x0000001f },
	{ .addr = 0x0f000400c, .val = 0x0000001f },
	{ .addr = 0x0f0004010, .val = 0x0000001f },
	{ .addr = 0x0f0004014, .val = 0x0000001f },
	{ .addr = 0x0f0004018, .val = 0x0000001f },
	{ .addr = 0x0f000401c, .val = 0x0000001f },
	{ .addr = 0x0f0004020, .val = 0x0000001f },
	{ .addr = 0x0f0004024, .val = 0x0000001f },
	{ .addr = 0x0f0004028, .val = 0x0000001f },
	{ .addr = 0x0f000402c, .val = 0x0000001f },
	{ .addr = 0x0f0004030, .val = 0x0000001f },
	{ .addr = 0x0f0004034, .val = 0x0000001f },
	{ .addr = 0x0f0004038, .val = 0x0000001f },
	{ .addr = 0x0f000403c, .val = 0x0000001f },
	{ .addr = 0x0f0004040, .val = 0x0000001f },
	{ .addr = 0x0f0004044, .val = 0x0000001f },
	{ .addr = 0x0f0004048, .val = 0x0000001f },
	{ .addr = 0x0f000404c, .val = 0x0000001f },
	{ .addr = 0x0f0004050, .val = 0x0000001f },
	{ .addr = 0x0f0004054, .val = 0x0000001f },
	{ .addr = 0x0f0004058, .val = 0x0000001f },
	{ .addr = 0x0f000405c, .val = 0x0000001f },
	{ .addr = 0x0f0004060, .val = 0x0000001f },
	{ .addr = 0x0f0004064, .val = 0x0000001f },
	{ .addr = 0x0f0004068, .val = 0x0000001f },
	{ .addr = 0x0f000406c, .val = 0x0000001f },
	{ .addr = 0x0f0004070, .val = 0x0000001f },
	{ .addr = 0x0f0004074, .val = 0x0000001f },
	{ .addr = 0x0f0004078, .val = 0x0000001f },
	{ .addr = 0x0f000407c, .val = 0x0000001f },
	{ .addr = 0x0f0004080, .val = 0x0000001f },
	{ .addr = 0x0f0004084, .val = 0x0000001f },
	{ .addr = 0x0f0004088, .val = 0x0000001f },
	{ .addr = 0x0f000408c, .val = 0x0000001f },
	{ .addr = 0x0f0004090, .val = 0x0000001f },
	{ .addr = 0x0f0004094, .val = 0x0000001f },
	{ .addr = 0x0f0004098, .val = 0x0000001f },
	{ .addr = 0x0f000409c, .val = 0x0000001f },
	{ .addr = 0x0f00040a0, .val = 0x0000001f },
	{ .addr = 0x0f00040a4, .val = 0x0000001f },
	{ .addr = 0x0f00040a8, .val = 0x0000001f },
	{ .addr = 0x0f00040ac, .val = 0x0000001f },
	{ .addr = 0x0f00040b0, .val = 0x0000001f },
	{ .addr = 0x0f00040b4, .val = 0x0000001f },
	{ .addr = 0x0f00040b8, .val = 0x0000001f },
	{ .addr = 0x0f00040bc, .val = 0x0000001f },
	{ .addr = 0x0f00040c0, .val = 0x0000001f },
	{ .addr = 0x0f00040c4, .val = 0x0000001f },
	{ .addr = 0x0f00040c8, .val = 0x0000001f },
	{ .addr = 0x0f00040cc, .val = 0x0000001f },
	{ .addr = 0x0f00040d0, .val = 0x0000001f },
	{ .addr = 0x0f00040d4, .val = 0x0000001f },
	{ .addr = 0x0f00040d8, .val = 0x0000001f },
	{ .addr = 0x0f00040dc, .val = 0x0000001f },
	{ .addr = 0x0f00040e0, .val = 0x0000001f },
	{ .addr = 0x0f00040e4, .val = 0x0000001f },
	{ .addr = 0x0f00040e8, .val = 0x0000001f },
	{ .addr = 0x0f00040ec, .val = 0x0000001f },
	{ .addr = 0x0f00040f0, .val = 0x0000001f },
	{ .addr = 0x0f00040f4, .val = 0x0000001f },
	{ .addr = 0x0f00040f8, .val = 0x0000001f },
	{ .addr = 0x0f00040fc, .val = 0x0000001f },
	{ .addr = 0x0f0004100, .val = 0x0000001f },
	{ .addr = 0x0f0004104, .val = 0x0000001f },
	{ .addr = 0x0f0004108, .val = 0x0000001f },
	{ .addr = 0x0f000410c, .val = 0x0000001f },
	{ .addr = 0x0f0004110, .val = 0x0000001f },
	{ .addr = 0x0f0004114, .val = 0x0000001f },
	{ .addr = 0x0f0004118, .val = 0x0000001f },
	{ .addr = 0x0f000411c, .val = 0x0000001f },
	{ .addr = 0x0f0004120, .val = 0x0000001f },
	{ .addr = 0x0f0004124, .val = 0x0000001f },
	{ .addr = 0x0f0004128, .val = 0x0000001f },
	{ .addr = 0x0f000412c, .val = 0x0000001f },
	{ .addr = 0x0f0004130, .val = 0x0000001f },
	{ .addr = 0x0f0004134, .val = 0x0000001f },
	{ .addr = 0x0f0004138, .val = 0x0000001f },
	{ .addr = 0x0f000413c, .val = 0x0000001f },
	{ .addr = 0x0f0004140, .val = 0x0000001f },
	{ .addr = 0x0f0004144, .val = 0x0000001f },
	{ .addr = 0x0f0004148, .val = 0x0000001f },
	{ .addr = 0x0f000414c, .val = 0x0000001f },
	{ .addr = 0x0f0004150, .val = 0x0000001f },
	{ .addr = 0x0f0004154, .val = 0x0000001f },
	{ .addr = 0x0f0004158, .val = 0x0000001f },
	{ .addr = 0x0f000415c, .val = 0x0000001f },
	{ .addr = 0x0f0004160, .val = 0x0000001f },
	{ .addr = 0x0f0004164, .val = 0x0000001f },
	{ .addr = 0x0f0004168, .val = 0x0000001f },
	{ .addr = 0x0f000416c, .val = 0x0000001f },
	{ .addr = 0x0f0004170, .val = 0x0000001f },
	{ .addr = 0x0f0004174, .val = 0x0000001f },
	{ .addr = 0x0f0004178, .val = 0x0000001f },
	{ .addr = 0x0f000417c, .val = 0x0000001f },
	{ .addr = 0x0f0004180, .val = 0x0000001f },
	{ .addr = 0x0f0004184, .val = 0x0000001f },
	{ .addr = 0x0f0004188, .val = 0x0000001f },
	{ .addr = 0x0f000418c, .val = 0x0000001f },
	{ .addr = 0x0f0004190, .val = 0x0000001f },
	{ .addr = 0x0f0004194, .val = 0x0000001f },
	{ .addr = 0x0f0004198, .val = 0x0000001f },
	{ .addr = 0x0f000419c, .val = 0x0000001f },
	{ .addr = 0x0f00041a0, .val = 0x0000001f },
	{ .addr = 0x0f00041a4, .val = 0x0000001f },
	{ .addr = 0x0f00041a8, .val = 0x0000001f },
	{ .addr = 0x0f00041ac, .val = 0x0000001f },
	{ .addr = 0x0f00041b0, .val = 0x0000001f },
	{ .addr = 0x0f00041b4, .val = 0x0000001f },
	{ .addr = 0x0f00041b8, .val = 0x0000001f },
	{ .addr = 0x0f00041bc, .val = 0x0000001f },
	{ .addr = 0x0f00041c0, .val = 0x0000001f },
	{ .addr = 0x0f00041c4, .val = 0x0000001f },
	{ .addr = 0x0f00041c8, .val = 0x0000001f },
	{ .addr = 0x0f00041cc, .val = 0x0000001f },
	{ .addr = 0x0f00041d0, .val = 0x0000001f },
	{ .addr = 0x0f00041d4, .val = 0x0000001f },
	{ .addr = 0x0f00041d8, .val = 0x0000001f },
	{ .addr = 0x0f00041dc, .val = 0x0000001f },
	{ .addr = 0x0f00041e0, .val = 0x0000001f },
	{ .addr = 0x0f00041e4, .val = 0x0000001f },
	{ .addr = 0x0f00041e8, .val = 0x0000001f },
	{ .addr = 0x0f00041ec, .val = 0x0000001f },
	{ .addr = 0x0f00041f0, .val = 0x0000001f },
	{ .addr = 0x0f00041f4, .val = 0x0000001f },
	{ .addr = 0x0f00041f8, .val = 0x0000001f },
	{ .addr = 0x0f00041fc, .val = 0x0000001f },
	{ .addr = 0x0f0004200, .val = 0x0000001f },
	{ .addr = 0x0f0004204, .val = 0x0000001f },
	{ .addr = 0x0f0004208, .val = 0x0000001f },
	{ .addr = 0x0f000420c, .val = 0x0000001f },
	{ .addr = 0x0f0004210, .val = 0x0000001f },
	{ .addr = 0x0f0004214, .val = 0x0000001f },
	{ .addr = 0x0f0004218, .val = 0x0000001f },
	{ .addr = 0x0f000421c, .val = 0x0000001f },
	{ .addr = 0x0f0004220, .val = 0x0000001f },
	{ .addr = 0x0f0004224, .val = 0x0000001f },
	{ .addr = 0x0f0004228, .val = 0x0000001f },
	{ .addr = 0x0f000422c, .val = 0x0000001f },
	{ .addr = 0x0f0004230, .val = 0x0000001f },
	{ .addr = 0x0f0004234, .val = 0x0000001f },
	{ .addr = 0x0f0004238, .val = 0x0000001f },
	{ .addr = 0x0f000423c, .val = 0x0000001f },
	{ .addr = 0x0f0004240, .val = 0x0000001f },
	{ .addr = 0x0f0004244, .val = 0x0000001f },
	{ .addr = 0x0f0004248, .val = 0x0000001f },
	{ .addr = 0x0f000424c, .val = 0x0000001f },
	{ .addr = 0x0f0004250, .val = 0x0000001f },
	{ .addr = 0x0f0004254, .val = 0x0000001f },
	{ .addr = 0x0f0004258, .val = 0x0000001f },
	{ .addr = 0x0f000425c, .val = 0x0000001f },
	{ .addr = 0x0f0004260, .val = 0x0000001f },
	{ .addr = 0x0f0004264, .val = 0x0000001f },
	{ .addr = 0x0f0004268, .val = 0x0000001f },
	{ .addr = 0x0f000426c, .val = 0x0000001f },
	{ .addr = 0x0f0004270, .val = 0x0000001f },
	{ .addr = 0x0f0004274, .val = 0x0000001f },
	{ .addr = 0x0f0004278, .val = 0x0000001f },
	{ .addr = 0x0f000427c, .val = 0x0000001f },
	{ .addr = 0x0f0004280, .val = 0x0000001f },
	{ .addr = 0x0f0004284, .val = 0x0000001f },
	{ .addr = 0x0f0004288, .val = 0x0000001f },
	{ .addr = 0x0f000428c, .val = 0x0000001f },
	{ .addr = 0x0f0004290, .val = 0x0000001f },
	{ .addr = 0x0f0004294, .val = 0x0000001f },
	{ .addr = 0x0f0004298, .val = 0x0000001f },
	{ .addr = 0x0f000429c, .val = 0x0000001f },
	{ .addr = 0x0f00042a0, .val = 0x0000001f },
	{ .addr = 0x0f00042a4, .val = 0x0000001f },
	{ .addr = 0x0f00042a8, .val = 0x0000001f },
	{ .addr = 0x0f00042ac, .val = 0x0000001f },
	{ .addr = 0x0f00042b0, .val = 0x0000001f },
	{ .addr = 0x0f00042b4, .val = 0x0000001f },
	{ .addr = 0x0f00042b8, .val = 0x0000001f },
	{ .addr = 0x0f00042bc, .val = 0x0000001f },
	{ .addr = 0x0f00042c0, .val = 0x0000001f },
	{ .addr = 0x0f00042c4, .val = 0x0000001f },
	{ .addr = 0x0f00042c8, .val = 0x0000001f },
	{ .addr = 0x0f00042cc, .val = 0x0000001f },
	{ .addr = 0x0f00042d0, .val = 0x0000001f },
	{ .addr = 0x0f00042d4, .val = 0x0000001f },
	{ .addr = 0x0f00042d8, .val = 0x0000001f },
	{ .addr = 0x0f00042dc, .val = 0x0000001f },
	{ .addr = 0x0f00042e0, .val = 0x0000001f },
	{ .addr = 0x0f00042e4, .val = 0x0000001f },
	{ .addr = 0x0f00042e8, .val = 0x0000001f },
	{ .addr = 0x0f00042ec, .val = 0x0000001f },
	{ .addr = 0x0f00042f0, .val = 0x0000001f },
	{ .addr = 0x0f00042f4, .val = 0x0000001f },
	{ .addr = 0x0f00042f8, .val = 0x0000001f },
	{ .addr = 0x0f00042fc, .val = 0x0000001f },
	{ .addr = 0x0f0004300, .val = 0x0000001f },
	{ .addr = 0x0f0004304, .val = 0x0000001f },
	{ .addr = 0x0f0004308, .val = 0x0000001f },
	{ .addr = 0x0f000430c, .val = 0x0000001f },
	{ .addr = 0x0f0004310, .val = 0x0000001f },
	{ .addr = 0x0f0004314, .val = 0x0000001f },
	{ .addr = 0x0f0004318, .val = 0x0000001f },
	{ .addr = 0x0f000431c, .val = 0x0000001f },
	{ .addr = 0x0f0004320, .val = 0x0000001f },
	{ .addr = 0x0f0004324, .val = 0x0000001f },
	{ .addr = 0x0f0004328, .val = 0x0000001f },
	{ .addr = 0x0f000432c, .val = 0x0000001f },
	{ .addr = 0x0f0004330, .val = 0x0000001f },
	{ .addr = 0x0f0004334, .val = 0x0000001f },
	{ .addr = 0x0f0004338, .val = 0x0000001f },
	{ .addr = 0x0f000433c, .val = 0x0000001f },
	{ .addr = 0x0f0004340, .val = 0x0000001f },
	{ .addr = 0x0f0004344, .val = 0x0000001f },
	{ .addr = 0x0f0004348, .val = 0x0000001f },
	{ .addr = 0x0f000434c, .val = 0x0000001f },
	{ .addr = 0x0f0004350, .val = 0x0000001f },
	{ .addr = 0x0f0004354, .val = 0x0000001f },
	{ .addr = 0x0f0004358, .val = 0x0000001f },
	{ .addr = 0x0f000435c, .val = 0x0000001f },
	{ .addr = 0x0f0004360, .val = 0x0000001f },
	{ .addr = 0x0f0004364, .val = 0x0000001f },
	{ .addr = 0x0f0004368, .val = 0x0000001f },
	{ .addr = 0x0f000436c, .val = 0x0000001f },
	{ .addr = 0x0f0004370, .val = 0x0000001f },
	{ .addr = 0x0f0004374, .val = 0x0000001f },
	{ .addr = 0x0f0004378, .val = 0x0000001f },
	{ .addr = 0x0f000437c, .val = 0x0000001f },
	{ .addr = 0x0f0004380, .val = 0x0000001f },
	{ .addr = 0x0f0004384, .val = 0x0000001f },
	{ .addr = 0x0f0004388, .val = 0x0000001f },
	{ .addr = 0x0f000438c, .val = 0x0000001f },
	{ .addr = 0x0f0004390, .val = 0x0000001f },
	{ .addr = 0x0f0004394, .val = 0x0000001f },
	{ .addr = 0x0f0004398, .val = 0x0000001f },
	{ .addr = 0x0f000439c, .val = 0x0000001f },
	{ .addr = 0x0f00043a0, .val = 0x0000001f },
	{ .addr = 0x0f00043a4, .val = 0x0000001f },
	{ .addr = 0x0f00043a8, .val = 0x0000001f },
	{ .addr = 0x0f00043ac, .val = 0x0000001f },
	{ .addr = 0x0f00043b0, .val = 0x0000001f },
	{ .addr = 0x0f00043b4, .val = 0x0000001f },
	{ .addr = 0x0f00043b8, .val = 0x0000001f },
	{ .addr = 0x0f00043bc, .val = 0x0000001f },
	{ .addr = 0x0f00043c0, .val = 0x0000001f },
	{ .addr = 0x0f00043c4, .val = 0x0000001f },
	{ .addr = 0x0f00043c8, .val = 0x0000001f },
	{ .addr = 0x0f00043cc, .val = 0x0000001f },
	{ .addr = 0x0f00043d0, .val = 0x0000001f },
	{ .addr = 0x0f00043d4, .val = 0x0000001f },
	{ .addr = 0x0f00043d8, .val = 0x0000001f },
	{ .addr = 0x0f00043dc, .val = 0x0000001f },
	{ .addr = 0x0f00043e0, .val = 0x0000001f },
	{ .addr = 0x0f00043e4, .val = 0x0000001f },
	{ .addr = 0x0f00043e8, .val = 0x0000001f },
	{ .addr = 0x0f00043ec, .val = 0x0000001f },
	{ .addr = 0x0f00043f0, .val = 0x0000001f },
	{ .addr = 0x0f00043f4, .val = 0x0000001f },
	{ .addr = 0x0f00043f8, .val = 0x0000001f },
	{ .addr = 0x0f00043fc, .val = 0x0000001f },
	{ .addr = 0x0f0004400, .val = 0xffffffff },
	{ .addr = 0x0f0004404, .val = 0xffffffff },
	{ .addr = 0x0f0004408, .val = 0xffffffff },
	{ .addr = 0x0f000440c, .val = 0xffffffff },
	{ .addr = 0x0f0004410, .val = 0xffffffff },
	{ .addr = 0x0f0004414, .val = 0xffffffff },
	{ .addr = 0x0f0004418, .val = 0xffffffff },
	{ .addr = 0x0f000441c, .val = 0xffffffff },
	{ .addr = 0x0f0004420, .val = 0xffffffff },
	{ .addr = 0x0f0004424, .val = 0xffffffff },
	{ .addr = 0x0f0004428, .val = 0xffffffff },
	{ .addr = 0x0f000442c, .val = 0xffffffff },
	{ .addr = 0x0f0004430, .val = 0xffffffff },
	{ .addr = 0x0f0004434, .val = 0xffffffff },
	{ .addr = 0x0f0004438, .val = 0xffffffff },
	{ .addr = 0x0f000443c, .val = 0xffffffff },
	{ .addr = 0x0f0004440, .val = 0xffffffff },
	{ .addr = 0x0f0004444, .val = 0xffffffff },
	{ .addr = 0x0f0004448, .val = 0xffffffff },
	{ .addr = 0x0f000444c, .val = 0xffffffff },
	{ .addr = 0x0f0004450, .val = 0xffffffff },
	{ .addr = 0x0f0004454, .val = 0xffffffff },
	{ .addr = 0x0f0004458, .val = 0xffffffff },
	{ .addr = 0x0f000445c, .val = 0xffffffff },
	{ .addr = 0x0f0004460, .val = 0xffffffff },
	{ .addr = 0x0f0004464, .val = 0xffffffff },
	{ .addr = 0x0f0004468, .val = 0xffffffff },
	{ .addr = 0x0f000446c, .val = 0xffffffff },
	{ .addr = 0x0f0004470, .val = 0xffffffff },
	{ .addr = 0x0f0004474, .val = 0xffffffff },
	{ .addr = 0x0f0004478, .val = 0xffffffff },
	{ .addr = 0x0f000447c, .val = 0xffffffff },
	{ .addr = 0x0f0004500, .val = 0xffffffff },
	{ .addr = 0x0f0004504, .val = 0x0000ffff },
	{ .addr = 0x0f0004508, .val = 0xffffffff },
	{ .addr = 0x0f000450c, .val = 0x0000ffff },
	{ .addr = 0x0f0004510, .val = 0xffffffff },
	{ .addr = 0x0f0004514, .val = 0x0000ffff },
	{ .addr = 0x0f0004518, .val = 0xffffffff },
	{ .addr = 0x0f000451c, .val = 0x0000ffff },
	{ .addr = 0x0f0004520, .val = 0xffffffff },
	{ .addr = 0x0f0004524, .val = 0x0000ffff },
	{ .addr = 0x0f0004528, .val = 0xffffffff },
	{ .addr = 0x0f000452c, .val = 0x0000ffff },
	{ .addr = 0x0f0004530, .val = 0xffffffff },
	{ .addr = 0x0f0004534, .val = 0x0000ffff },
	{ .addr = 0x0f0004538, .val = 0xffffffff },
	{ .addr = 0x0f000453c, .val = 0x0000ffff },
	{ .addr = 0x0f0004540, .val = 0xffffffff },
	{ .addr = 0x0f0004544, .val = 0x0000ffff },
	{ .addr = 0x0f0004548, .val = 0xffffffff },
	{ .addr = 0x0f000454c, .val = 0x0000ffff },
	{ .addr = 0x0f0004550, .val = 0xffffffff },
	{ .addr = 0x0f0004554, .val = 0x0000ffff },
	{ .addr = 0x0f0004558, .val = 0xffffffff },
	{ .addr = 0x0f000455c, .val = 0x0000ffff },
	{ .addr = 0x0f0004560, .val = 0xffffffff },
	{ .addr = 0x0f0004564, .val = 0x0000ffff },
	{ .addr = 0x0f0004568, .val = 0xffffffff },
	{ .addr = 0x0f000456c, .val = 0x0000ffff },
	{ .addr = 0x0f0004570, .val = 0xffffffff },
	{ .addr = 0x0f0004574, .val = 0x0000ffff },
	{ .addr = 0x0f0004578, .val = 0xffffffff },
	{ .addr = 0x0f000457c, .val = 0x0000ffff },
	{ .addr = 0x0f0004580, .val = 0xffffffff },
	{ .addr = 0x0f0004584, .val = 0x0000ffff },
	{ .addr = 0x0f0004588, .val = 0xffffffff },
	{ .addr = 0x0f000458c, .val = 0x0000ffff },
	{ .addr = 0x0f0004590, .val = 0xffffffff },
	{ .addr = 0x0f0004594, .val = 0x0000ffff },
	{ .addr = 0x0f0004598, .val = 0xffffffff },
	{ .addr = 0x0f000459c, .val = 0x0000ffff },
	{ .addr = 0x0f00045a0, .val = 0xffffffff },
	{ .addr = 0x0f00045a4, .val = 0x0000ffff },
	{ .addr = 0x0f00045a8, .val = 0xffffffff },
	{ .addr = 0x0f00045ac, .val = 0x0000ffff },
	{ .addr = 0x0f00045b0, .val = 0xffffffff },
	{ .addr = 0x0f00045b4, .val = 0x0000ffff },
	{ .addr = 0x0f00045b8, .val = 0xffffffff },
	{ .addr = 0x0f00045bc, .val = 0x0000ffff },
	{ .addr = 0x0f00045c0, .val = 0xffffffff },
	{ .addr = 0x0f00045c4, .val = 0x0000ffff },
	{ .addr = 0x0f00045c8, .val = 0xffffffff },
	{ .addr = 0x0f00045cc, .val = 0x0000ffff },
	{ .addr = 0x0f00045d0, .val = 0xffffffff },
	{ .addr = 0x0f00045d4, .val = 0x0000ffff },
	{ .addr = 0x0f00045d8, .val = 0xffffffff },
	{ .addr = 0x0f00045dc, .val = 0x0000ffff },
	{ .addr = 0x0f00045e0, .val = 0xffffffff },
	{ .addr = 0x0f00045e4, .val = 0x0000ffff },
	{ .addr = 0x0f00045e8, .val = 0xffffffff },
	{ .addr = 0x0f00045ec, .val = 0x0000ffff },
	{ .addr = 0x0f00045f0, .val = 0xffffffff },
	{ .addr = 0x0f00045f4, .val = 0x0000ffff },
	{ .addr = 0x0f00045f8, .val = 0xffffffff },
	{ .addr = 0x0f00045fc, .val = 0x0000ffff },
	{ .addr = 0x0f0004600, .val = 0xffffffff },
	{ .addr = 0x0f0004604, .val = 0x0000ffff },
	{ .addr = 0x0f0004608, .val = 0xffffffff },
	{ .addr = 0x0f000460c, .val = 0x0000ffff },
	{ .addr = 0x0f0004610, .val = 0xffffffff },
	{ .addr = 0x0f0004614, .val = 0x0000ffff },
	{ .addr = 0x0f0004618, .val = 0xffffffff },
	{ .addr = 0x0f000461c, .val = 0x0000ffff },
	{ .addr = 0x0f0004620, .val = 0xffffffff },
	{ .addr = 0x0f0004624, .val = 0x0000ffff },
	{ .addr = 0x0f0004628, .val = 0xffffffff },
	{ .addr = 0x0f000462c, .val = 0x0000ffff },
	{ .addr = 0x0f0004630, .val = 0xffffffff },
	{ .addr = 0x0f0004634, .val = 0x0000ffff },
	{ .addr = 0x0f0004638, .val = 0xffffffff },
	{ .addr = 0x0f000463c, .val = 0x0000ffff },
	{ .addr = 0x0f0004640, .val = 0xffffffff },
	{ .addr = 0x0f0004644, .val = 0x0000ffff },
	{ .addr = 0x0f0004648, .val = 0xffffffff },
	{ .addr = 0x0f000464c, .val = 0x0000ffff },
	{ .addr = 0x0f0004650, .val = 0xffffffff },
	{ .addr = 0x0f0004654, .val = 0x0000ffff },
	{ .addr = 0x0f0004658, .val = 0xffffffff },
	{ .addr = 0x0f000465c, .val = 0x0000ffff },
	{ .addr = 0x0f0004660, .val = 0xffffffff },
	{ .addr = 0x0f0004664, .val = 0x0000ffff },
	{ .addr = 0x0f0004668, .val = 0xffffffff },
	{ .addr = 0x0f000466c, .val = 0x0000ffff },
	{ .addr = 0x0f0004670, .val = 0xffffffff },
	{ .addr = 0x0f0004674, .val = 0x0000ffff },
	{ .addr = 0x0f0004678, .val = 0xffffffff },
	{ .addr = 0x0f000467c, .val = 0x0000ffff },
	{ .addr = 0x0f0004680, .val = 0xffffffff },
	{ .addr = 0x0f0004684, .val = 0x0000ffff },
	{ .addr = 0x0f0004688, .val = 0xffffffff },
	{ .addr = 0x0f000468c, .val = 0x0000ffff },
	{ .addr = 0x0f0004690, .val = 0xffffffff },
	{ .addr = 0x0f0004694, .val = 0x0000ffff },
	{ .addr = 0x0f0004698, .val = 0xffffffff },
	{ .addr = 0x0f000469c, .val = 0x0000ffff },
	{ .addr = 0x0f00046a0, .val = 0xffffffff },
	{ .addr = 0x0f00046a4, .val = 0x0000ffff },
	{ .addr = 0x0f00046a8, .val = 0xffffffff },
	{ .addr = 0x0f00046ac, .val = 0x0000ffff },
	{ .addr = 0x0f00046b0, .val = 0xffffffff },
	{ .addr = 0x0f00046b4, .val = 0x0000ffff },
	{ .addr = 0x0f00046b8, .val = 0xffffffff },
	{ .addr = 0x0f00046bc, .val = 0x0000ffff },
	{ .addr = 0x0f00046c0, .val = 0xffffffff },
	{ .addr = 0x0f00046c4, .val = 0x0000ffff },
	{ .addr = 0x0f00046c8, .val = 0xffffffff },
	{ .addr = 0x0f00046cc, .val = 0x0000ffff },
	{ .addr = 0x0f00046d0, .val = 0xffffffff },
	{ .addr = 0x0f00046d4, .val = 0x0000ffff },
	{ .addr = 0x0f00046d8, .val = 0xffffffff },
	{ .addr = 0x0f00046dc, .val = 0x0000ffff },
	{ .addr = 0x0f00046e0, .val = 0xffffffff },
	{ .addr = 0x0f00046e4, .val = 0x0000ffff },
	{ .addr = 0x0f00046e8, .val = 0xffffffff },
	{ .addr = 0x0f00046ec, .val = 0x0000ffff },
	{ .addr = 0x0f00046f0, .val = 0xffffffff },
	{ .addr = 0x0f00046f4, .val = 0x0000ffff },
	{ .addr = 0x0f00046f8, .val = 0xffffffff },
	{ .addr = 0x0f00046fc, .val = 0x0000ffff },
	{ .addr = 0x0f0004700, .val = 0xffffffff },
	{ .addr = 0x0f0004704, .val = 0x0000ffff },
	{ .addr = 0x0f0004708, .val = 0xffffffff },
	{ .addr = 0x0f000470c, .val = 0x0000ffff },
	{ .addr = 0x0f0004710, .val = 0xffffffff },
	{ .addr = 0x0f0004714, .val = 0x0000ffff },
	{ .addr = 0x0f0004718, .val = 0xffffffff },
	{ .addr = 0x0f000471c, .val = 0x0000ffff },
	{ .addr = 0x0f0004720, .val = 0xffffffff },
	{ .addr = 0x0f0004724, .val = 0x0000ffff },
	{ .addr = 0x0f0004728, .val = 0xffffffff },
	{ .addr = 0x0f000472c, .val = 0x0000ffff },
	{ .addr = 0x0f0004730, .val = 0xffffffff },
	{ .addr = 0x0f0004734, .val = 0x0000ffff },
	{ .addr = 0x0f0004738, .val = 0xffffffff },
	{ .addr = 0x0f000473c, .val = 0x0000ffff },
	{ .addr = 0x0f0004740, .val = 0xffffffff },
	{ .addr = 0x0f0004744, .val = 0x0000ffff },
	{ .addr = 0x0f0004748, .val = 0xffffffff },
	{ .addr = 0x0f000474c, .val = 0x0000ffff },
	{ .addr = 0x0f0004750, .val = 0xffffffff },
	{ .addr = 0x0f0004754, .val = 0x0000ffff },
	{ .addr = 0x0f0004758, .val = 0xffffffff },
	{ .addr = 0x0f000475c, .val = 0x0000ffff },
	{ .addr = 0x0f0004760, .val = 0xffffffff },
	{ .addr = 0x0f0004764, .val = 0x0000ffff },
	{ .addr = 0x0f0004768, .val = 0xffffffff },
	{ .addr = 0x0f000476c, .val = 0x0000ffff },
	{ .addr = 0x0f0004770, .val = 0xffffffff },
	{ .addr = 0x0f0004774, .val = 0x0000ffff },
	{ .addr = 0x0f0004778, .val = 0xffffffff },
	{ .addr = 0x0f000477c, .val = 0x0000ffff },
	{ .addr = 0x0f0004780, .val = 0xffffffff },
	{ .addr = 0x0f0004784, .val = 0x0000ffff },
	{ .addr = 0x0f0004788, .val = 0xffffffff },
	{ .addr = 0x0f000478c, .val = 0x0000ffff },
	{ .addr = 0x0f0004790, .val = 0xffffffff },
	{ .addr = 0x0f0004794, .val = 0x0000ffff },
	{ .addr = 0x0f0004798, .val = 0xffffffff },
	{ .addr = 0x0f000479c, .val = 0x0000ffff },
	{ .addr = 0x0f00047a0, .val = 0xffffffff },
	{ .addr = 0x0f00047a4, .val = 0x0000ffff },
	{ .addr = 0x0f00047a8, .val = 0xffffffff },
	{ .addr = 0x0f00047ac, .val = 0x0000ffff },
	{ .addr = 0x0f00047b0, .val = 0xffffffff },
	{ .addr = 0x0f00047b4, .val = 0x0000ffff },
	{ .addr = 0x0f00047b8, .val = 0xffffffff },
	{ .addr = 0x0f00047bc, .val = 0x0000ffff },
	{ .addr = 0x0f00047c0, .val = 0xffffffff },
	{ .addr = 0x0f00047c4, .val = 0x0000ffff },
	{ .addr = 0x0f00047c8, .val = 0xffffffff },
	{ .addr = 0x0f00047cc, .val = 0x0000ffff },
	{ .addr = 0x0f00047d0, .val = 0xffffffff },
	{ .addr = 0x0f00047d4, .val = 0x0000ffff },
	{ .addr = 0x0f00047d8, .val = 0xffffffff },
	{ .addr = 0x0f00047dc, .val = 0x0000ffff },
	{ .addr = 0x0f00047e0, .val = 0xffffffff },
	{ .addr = 0x0f00047e4, .val = 0x0000ffff },
	{ .addr = 0x0f00047e8, .val = 0xffffffff },
	{ .addr = 0x0f00047ec, .val = 0x0000ffff },
	{ .addr = 0x0f00047f0, .val = 0xffffffff },
	{ .addr = 0x0f00047f4, .val = 0x0000ffff },
	{ .addr = 0x0f00047f8, .val = 0xffffffff },
	{ .addr = 0x0f00047fc, .val = 0x0000ffff },
	{ .addr = 0x0f0004800, .val = 0xffffffff },
	{ .addr = 0x0f0004804, .val = 0x0000ffff },
	{ .addr = 0x0f0004808, .val = 0xffffffff },
	{ .addr = 0x0f000480c, .val = 0x0000ffff },
	{ .addr = 0x0f0004810, .val = 0xffffffff },
	{ .addr = 0x0f0004814, .val = 0x0000ffff },
	{ .addr = 0x0f0004818, .val = 0xffffffff },
	{ .addr = 0x0f000481c, .val = 0x0000ffff },
	{ .addr = 0x0f0004820, .val = 0xffffffff },
	{ .addr = 0x0f0004824, .val = 0x0000ffff },
	{ .addr = 0x0f0004828, .val = 0xffffffff },
	{ .addr = 0x0f000482c, .val = 0x0000ffff },
	{ .addr = 0x0f0004830, .val = 0xffffffff },
	{ .addr = 0x0f0004834, .val = 0x0000ffff },
	{ .addr = 0x0f0004838, .val = 0xffffffff },
	{ .addr = 0x0f000483c, .val = 0x0000ffff },
	{ .addr = 0x0f0004840, .val = 0xffffffff },
	{ .addr = 0x0f0004844, .val = 0x0000ffff },
	{ .addr = 0x0f0004848, .val = 0xffffffff },
	{ .addr = 0x0f000484c, .val = 0x0000ffff },
	{ .addr = 0x0f0004850, .val = 0xffffffff },
	{ .addr = 0x0f0004854, .val = 0x0000ffff },
	{ .addr = 0x0f0004858, .val = 0xffffffff },
	{ .addr = 0x0f000485c, .val = 0x0000ffff },
	{ .addr = 0x0f0004860, .val = 0xffffffff },
	{ .addr = 0x0f0004864, .val = 0x0000ffff },
	{ .addr = 0x0f0004868, .val = 0xffffffff },
	{ .addr = 0x0f000486c, .val = 0x0000ffff },
	{ .addr = 0x0f0004870, .val = 0xffffffff },
	{ .addr = 0x0f0004874, .val = 0x0000ffff },
	{ .addr = 0x0f0004878, .val = 0xffffffff },
	{ .addr = 0x0f000487c, .val = 0x0000ffff },
	{ .addr = 0x0f0004880, .val = 0xffffffff },
	{ .addr = 0x0f0004884, .val = 0x0000ffff },
	{ .addr = 0x0f0004888, .val = 0xffffffff },
	{ .addr = 0x0f000488c, .val = 0x0000ffff },
	{ .addr = 0x0f0004890, .val = 0xffffffff },
	{ .addr = 0x0f0004894, .val = 0x0000ffff },
	{ .addr = 0x0f0004898, .val = 0xffffffff },
	{ .addr = 0x0f000489c, .val = 0x0000ffff },
	{ .addr = 0x0f00048a0, .val = 0xffffffff },
	{ .addr = 0x0f00048a4, .val = 0x0000ffff },
	{ .addr = 0x0f00048a8, .val = 0xffffffff },
	{ .addr = 0x0f00048ac, .val = 0x0000ffff },
	{ .addr = 0x0f00048b0, .val = 0xffffffff },
	{ .addr = 0x0f00048b4, .val = 0x0000ffff },
	{ .addr = 0x0f00048b8, .val = 0xffffffff },
	{ .addr = 0x0f00048bc, .val = 0x0000ffff },
	{ .addr = 0x0f00048c0, .val = 0xffffffff },
	{ .addr = 0x0f00048c4, .val = 0x0000ffff },
	{ .addr = 0x0f00048c8, .val = 0xffffffff },
	{ .addr = 0x0f00048cc, .val = 0x0000ffff },
	{ .addr = 0x0f00048d0, .val = 0xffffffff },
	{ .addr = 0x0f00048d4, .val = 0x0000ffff },
	{ .addr = 0x0f00048d8, .val = 0xffffffff },
	{ .addr = 0x0f00048dc, .val = 0x0000ffff },
	{ .addr = 0x0f00048e0, .val = 0xffffffff },
	{ .addr = 0x0f00048e4, .val = 0x0000ffff },
	{ .addr = 0x0f00048e8, .val = 0xffffffff },
	{ .addr = 0x0f00048ec, .val = 0x0000ffff },
	{ .addr = 0x0f00048f0, .val = 0xffffffff },
	{ .addr = 0x0f00048f4, .val = 0x0000ffff },
	{ .addr = 0x0f00048f8, .val = 0xffffffff },
	{ .addr = 0x0f00048fc, .val = 0x0000ffff },
	{ .addr = 0x0f0004900, .val = 0xffffffff },
	{ .addr = 0x0f0004904, .val = 0x0000ffff },
	{ .addr = 0x0f0004908, .val = 0xffffffff },
	{ .addr = 0x0f000490c, .val = 0x0000ffff },
	{ .addr = 0x0f0004910, .val = 0xffffffff },
	{ .addr = 0x0f0004914, .val = 0x0000ffff },
	{ .addr = 0x0f0004918, .val = 0xffffffff },
	{ .addr = 0x0f000491c, .val = 0x0000ffff },
	{ .addr = 0x0f0004920, .val = 0xffffffff },
	{ .addr = 0x0f0004924, .val = 0x0000ffff },
	{ .addr = 0x0f0004928, .val = 0xffffffff },
	{ .addr = 0x0f000492c, .val = 0x0000ffff },
	{ .addr = 0x0f0004930, .val = 0xffffffff },
	{ .addr = 0x0f0004934, .val = 0x0000ffff },
	{ .addr = 0x0f0004938, .val = 0xffffffff },
	{ .addr = 0x0f000493c, .val = 0x0000ffff },
	{ .addr = 0x0f0004940, .val = 0xffffffff },
	{ .addr = 0x0f0004944, .val = 0x0000ffff },
	{ .addr = 0x0f0004948, .val = 0xffffffff },
	{ .addr = 0x0f000494c, .val = 0x0000ffff },
	{ .addr = 0x0f0004950, .val = 0xffffffff },
	{ .addr = 0x0f0004954, .val = 0x0000ffff },
	{ .addr = 0x0f0004958, .val = 0xffffffff },
	{ .addr = 0x0f000495c, .val = 0x0000ffff },
	{ .addr = 0x0f0004960, .val = 0xffffffff },
	{ .addr = 0x0f0004964, .val = 0x0000ffff },
	{ .addr = 0x0f0004968, .val = 0xffffffff },
	{ .addr = 0x0f000496c, .val = 0x0000ffff },
	{ .addr = 0x0f0004970, .val = 0xffffffff },
	{ .addr = 0x0f0004974, .val = 0x0000ffff },
	{ .addr = 0x0f0004978, .val = 0xffffffff },
	{ .addr = 0x0f000497c, .val = 0x0000ffff },
	{ .addr = 0x0f0004980, .val = 0xffffffff },
	{ .addr = 0x0f0004984, .val = 0x0000ffff },
	{ .addr = 0x0f0004988, .val = 0xffffffff },
	{ .addr = 0x0f000498c, .val = 0x0000ffff },
	{ .addr = 0x0f0004990, .val = 0xffffffff },
	{ .addr = 0x0f0004994, .val = 0x0000ffff },
	{ .addr = 0x0f0004998, .val = 0xffffffff },
	{ .addr = 0x0f000499c, .val = 0x0000ffff },
	{ .addr = 0x0f00049a0, .val = 0xffffffff },
	{ .addr = 0x0f00049a4, .val = 0x0000ffff },
	{ .addr = 0x0f00049a8, .val = 0xffffffff },
	{ .addr = 0x0f00049ac, .val = 0x0000ffff },
	{ .addr = 0x0f00049b0, .val = 0xffffffff },
	{ .addr = 0x0f00049b4, .val = 0x0000ffff },
	{ .addr = 0x0f00049b8, .val = 0xffffffff },
	{ .addr = 0x0f00049bc, .val = 0x0000ffff },
	{ .addr = 0x0f00049c0, .val = 0xffffffff },
	{ .addr = 0x0f00049c4, .val = 0x0000ffff },
	{ .addr = 0x0f00049c8, .val = 0xffffffff },
	{ .addr = 0x0f00049cc, .val = 0x0000ffff },
	{ .addr = 0x0f00049d0, .val = 0xffffffff },
	{ .addr = 0x0f00049d4, .val = 0x0000ffff },
	{ .addr = 0x0f00049d8, .val = 0xffffffff },
	{ .addr = 0x0f00049dc, .val = 0x0000ffff },
	{ .addr = 0x0f00049e0, .val = 0xffffffff },
	{ .addr = 0x0f00049e4, .val = 0x0000ffff },
	{ .addr = 0x0f00049e8, .val = 0xffffffff },
	{ .addr = 0x0f00049ec, .val = 0x0000ffff },
	{ .addr = 0x0f00049f0, .val = 0xffffffff },
	{ .addr = 0x0f00049f4, .val = 0x0000ffff },
	{ .addr = 0x0f00049f8, .val = 0xffffffff },
	{ .addr = 0x0f00049fc, .val = 0x0000ffff },
	{ .addr = 0x0f0004a00, .val = 0xffffffff },
	{ .addr = 0x0f0004a04, .val = 0x0000ffff },
	{ .addr = 0x0f0004a08, .val = 0xffffffff },
	{ .addr = 0x0f0004a0c, .val = 0x0000ffff },
	{ .addr = 0x0f0004a10, .val = 0xffffffff },
	{ .addr = 0x0f0004a14, .val = 0x0000ffff },
	{ .addr = 0x0f0004a18, .val = 0xffffffff },
	{ .addr = 0x0f0004a1c, .val = 0x0000ffff },
	{ .addr = 0x0f0004a20, .val = 0xffffffff },
	{ .addr = 0x0f0004a24, .val = 0x0000ffff },
	{ .addr = 0x0f0004a28, .val = 0xffffffff },
	{ .addr = 0x0f0004a2c, .val = 0x0000ffff },
	{ .addr = 0x0f0004a30, .val = 0xffffffff },
	{ .addr = 0x0f0004a34, .val = 0x0000ffff },
	{ .addr = 0x0f0004a38, .val = 0xffffffff },
	{ .addr = 0x0f0004a3c, .val = 0x0000ffff },
	{ .addr = 0x0f0004a40, .val = 0xffffffff },
	{ .addr = 0x0f0004a44, .val = 0x0000ffff },
	{ .addr = 0x0f0004a48, .val = 0xffffffff },
	{ .addr = 0x0f0004a4c, .val = 0x0000ffff },
	{ .addr = 0x0f0004a50, .val = 0xffffffff },
	{ .addr = 0x0f0004a54, .val = 0x0000ffff },
	{ .addr = 0x0f0004a58, .val = 0xffffffff },
	{ .addr = 0x0f0004a5c, .val = 0x0000ffff },
	{ .addr = 0x0f0004a60, .val = 0xffffffff },
	{ .addr = 0x0f0004a64, .val = 0x0000ffff },
	{ .addr = 0x0f0004a68, .val = 0xffffffff },
	{ .addr = 0x0f0004a6c, .val = 0x0000ffff },
	{ .addr = 0x0f0004a70, .val = 0xffffffff },
	{ .addr = 0x0f0004a74, .val = 0x0000ffff },
	{ .addr = 0x0f0004a78, .val = 0xffffffff },
	{ .addr = 0x0f0004a7c, .val = 0x0000ffff },
	{ .addr = 0x0f0004a80, .val = 0xffffffff },
	{ .addr = 0x0f0004a84, .val = 0x0000ffff },
	{ .addr = 0x0f0004a88, .val = 0xffffffff },
	{ .addr = 0x0f0004a8c, .val = 0x0000ffff },
	{ .addr = 0x0f0004a90, .val = 0xffffffff },
	{ .addr = 0x0f0004a94, .val = 0x0000ffff },
	{ .addr = 0x0f0004a98, .val = 0xffffffff },
	{ .addr = 0x0f0004a9c, .val = 0x0000ffff },
	{ .addr = 0x0f0004aa0, .val = 0xffffffff },
	{ .addr = 0x0f0004aa4, .val = 0x0000ffff },
	{ .addr = 0x0f0004aa8, .val = 0xffffffff },
	{ .addr = 0x0f0004aac, .val = 0x0000ffff },
	{ .addr = 0x0f0004ab0, .val = 0xffffffff },
	{ .addr = 0x0f0004ab4, .val = 0x0000ffff },
	{ .addr = 0x0f0004ab8, .val = 0xffffffff },
	{ .addr = 0x0f0004abc, .val = 0x0000ffff },
	{ .addr = 0x0f0004ac0, .val = 0xffffffff },
	{ .addr = 0x0f0004ac4, .val = 0x0000ffff },
	{ .addr = 0x0f0004ac8, .val = 0xffffffff },
	{ .addr = 0x0f0004acc, .val = 0x0000ffff },
	{ .addr = 0x0f0004ad0, .val = 0xffffffff },
	{ .addr = 0x0f0004ad4, .val = 0x0000ffff },
	{ .addr = 0x0f0004ad8, .val = 0xffffffff },
	{ .addr = 0x0f0004adc, .val = 0x0000ffff },
	{ .addr = 0x0f0004ae0, .val = 0xffffffff },
	{ .addr = 0x0f0004ae4, .val = 0x0000ffff },
	{ .addr = 0x0f0004ae8, .val = 0xffffffff },
	{ .addr = 0x0f0004aec, .val = 0x0000ffff },
	{ .addr = 0x0f0004af0, .val = 0xffffffff },
	{ .addr = 0x0f0004af4, .val = 0x0000ffff },
	{ .addr = 0x0f0004af8, .val = 0xffffffff },
	{ .addr = 0x0f0004afc, .val = 0x0000ffff },
	{ .addr = 0x0f0004b00, .val = 0xffffffff },
	{ .addr = 0x0f0004b04, .val = 0x0000ffff },
	{ .addr = 0x0f0004b08, .val = 0xffffffff },
	{ .addr = 0x0f0004b0c, .val = 0x0000ffff },
	{ .addr = 0x0f0004b10, .val = 0xffffffff },
	{ .addr = 0x0f0004b14, .val = 0x0000ffff },
	{ .addr = 0x0f0004b18, .val = 0xffffffff },
	{ .addr = 0x0f0004b1c, .val = 0x0000ffff },
	{ .addr = 0x0f0004b20, .val = 0xffffffff },
	{ .addr = 0x0f0004b24, .val = 0x0000ffff },
	{ .addr = 0x0f0004b28, .val = 0xffffffff },
	{ .addr = 0x0f0004b2c, .val = 0x0000ffff },
	{ .addr = 0x0f0004b30, .val = 0xffffffff },
	{ .addr = 0x0f0004b34, .val = 0x0000ffff },
	{ .addr = 0x0f0004b38, .val = 0xffffffff },
	{ .addr = 0x0f0004b3c, .val = 0x0000ffff },
	{ .addr = 0x0f0004b40, .val = 0xffffffff },
	{ .addr = 0x0f0004b44, .val = 0x0000ffff },
	{ .addr = 0x0f0004b48, .val = 0xffffffff },
	{ .addr = 0x0f0004b4c, .val = 0x0000ffff },
	{ .addr = 0x0f0004b50, .val = 0xffffffff },
	{ .addr = 0x0f0004b54, .val = 0x0000ffff },
	{ .addr = 0x0f0004b58, .val = 0xffffffff },
	{ .addr = 0x0f0004b5c, .val = 0x0000ffff },
	{ .addr = 0x0f0004b60, .val = 0xffffffff },
	{ .addr = 0x0f0004b64, .val = 0x0000ffff },
	{ .addr = 0x0f0004b68, .val = 0xffffffff },
	{ .addr = 0x0f0004b6c, .val = 0x0000ffff },
	{ .addr = 0x0f0004b70, .val = 0xffffffff },
	{ .addr = 0x0f0004b74, .val = 0x0000ffff },
	{ .addr = 0x0f0004b78, .val = 0xffffffff },
	{ .addr = 0x0f0004b7c, .val = 0x0000ffff },
	{ .addr = 0x0f0004b80, .val = 0xffffffff },
	{ .addr = 0x0f0004b84, .val = 0x0000ffff },
	{ .addr = 0x0f0004b88, .val = 0xffffffff },
	{ .addr = 0x0f0004b8c, .val = 0x0000ffff },
	{ .addr = 0x0f0004b90, .val = 0xffffffff },
	{ .addr = 0x0f0004b94, .val = 0x0000ffff },
	{ .addr = 0x0f0004b98, .val = 0xffffffff },
	{ .addr = 0x0f0004b9c, .val = 0x0000ffff },
	{ .addr = 0x0f0004ba0, .val = 0xffffffff },
	{ .addr = 0x0f0004ba4, .val = 0x0000ffff },
	{ .addr = 0x0f0004ba8, .val = 0xffffffff },
	{ .addr = 0x0f0004bac, .val = 0x0000ffff },
	{ .addr = 0x0f0004bb0, .val = 0xffffffff },
	{ .addr = 0x0f0004bb4, .val = 0x0000ffff },
	{ .addr = 0x0f0004bb8, .val = 0xffffffff },
	{ .addr = 0x0f0004bbc, .val = 0x0000ffff },
	{ .addr = 0x0f0004bc0, .val = 0xffffffff },
	{ .addr = 0x0f0004bc4, .val = 0x0000ffff },
	{ .addr = 0x0f0004bc8, .val = 0xffffffff },
	{ .addr = 0x0f0004bcc, .val = 0x0000ffff },
	{ .addr = 0x0f0004bd0, .val = 0xffffffff },
	{ .addr = 0x0f0004bd4, .val = 0x0000ffff },
	{ .addr = 0x0f0004bd8, .val = 0xffffffff },
	{ .addr = 0x0f0004bdc, .val = 0x0000ffff },
	{ .addr = 0x0f0004be0, .val = 0xffffffff },
	{ .addr = 0x0f0004be4, .val = 0x0000ffff },
	{ .addr = 0x0f0004be8, .val = 0xffffffff },
	{ .addr = 0x0f0004bec, .val = 0x0000ffff },
	{ .addr = 0x0f0004bf0, .val = 0xffffffff },
	{ .addr = 0x0f0004bf4, .val = 0x0000ffff },
	{ .addr = 0x0f0004bf8, .val = 0xffffffff },
	{ .addr = 0x0f0004bfc, .val = 0x0000ffff },
	{ .addr = 0x0f0004c00, .val = 0xffffffff },
	{ .addr = 0x0f0004c04, .val = 0x0000ffff },
	{ .addr = 0x0f0004c08, .val = 0xffffffff },
	{ .addr = 0x0f0004c0c, .val = 0x0000ffff },
	{ .addr = 0x0f0004c10, .val = 0xffffffff },
	{ .addr = 0x0f0004c14, .val = 0x0000ffff },
	{ .addr = 0x0f0004c18, .val = 0xffffffff },
	{ .addr = 0x0f0004c1c, .val = 0x0000ffff },
	{ .addr = 0x0f0004c20, .val = 0xffffffff },
	{ .addr = 0x0f0004c24, .val = 0x0000ffff },
	{ .addr = 0x0f0004c28, .val = 0xffffffff },
	{ .addr = 0x0f0004c2c, .val = 0x0000ffff },
	{ .addr = 0x0f0004c30, .val = 0xffffffff },
	{ .addr = 0x0f0004c34, .val = 0x0000ffff },
	{ .addr = 0x0f0004c38, .val = 0xffffffff },
	{ .addr = 0x0f0004c3c, .val = 0x0000ffff },
	{ .addr = 0x0f0004c40, .val = 0xffffffff },
	{ .addr = 0x0f0004c44, .val = 0x0000ffff },
	{ .addr = 0x0f0004c48, .val = 0xffffffff },
	{ .addr = 0x0f0004c4c, .val = 0x0000ffff },
	{ .addr = 0x0f0004c50, .val = 0xffffffff },
	{ .addr = 0x0f0004c54, .val = 0x0000ffff },
	{ .addr = 0x0f0004c58, .val = 0xffffffff },
	{ .addr = 0x0f0004c5c, .val = 0x0000ffff },
	{ .addr = 0x0f0004c60, .val = 0xffffffff },
	{ .addr = 0x0f0004c64, .val = 0x0000ffff },
	{ .addr = 0x0f0004c68, .val = 0xffffffff },
	{ .addr = 0x0f0004c6c, .val = 0x0000ffff },
	{ .addr = 0x0f0004c70, .val = 0xffffffff },
	{ .addr = 0x0f0004c74, .val = 0x0000ffff },
	{ .addr = 0x0f0004c78, .val = 0xffffffff },
	{ .addr = 0x0f0004c7c, .val = 0x0000ffff },
	{ .addr = 0x0f0004c80, .val = 0xffffffff },
	{ .addr = 0x0f0004c84, .val = 0x0000ffff },
	{ .addr = 0x0f0004c88, .val = 0xffffffff },
	{ .addr = 0x0f0004c8c, .val = 0x0000ffff },
	{ .addr = 0x0f0004c90, .val = 0xffffffff },
	{ .addr = 0x0f0004c94, .val = 0x0000ffff },
	{ .addr = 0x0f0004c98, .val = 0xffffffff },
	{ .addr = 0x0f0004c9c, .val = 0x0000ffff },
	{ .addr = 0x0f0004ca0, .val = 0xffffffff },
	{ .addr = 0x0f0004ca4, .val = 0x0000ffff },
	{ .addr = 0x0f0004ca8, .val = 0xffffffff },
	{ .addr = 0x0f0004cac, .val = 0x0000ffff },
	{ .addr = 0x0f0004cb0, .val = 0xffffffff },
	{ .addr = 0x0f0004cb4, .val = 0x0000ffff },
	{ .addr = 0x0f0004cb8, .val = 0xffffffff },
	{ .addr = 0x0f0004cbc, .val = 0x0000ffff },
	{ .addr = 0x0f0004cc0, .val = 0xffffffff },
	{ .addr = 0x0f0004cc4, .val = 0x0000ffff },
	{ .addr = 0x0f0004cc8, .val = 0xffffffff },
	{ .addr = 0x0f0004ccc, .val = 0x0000ffff },
	{ .addr = 0x0f0004cd0, .val = 0xffffffff },
	{ .addr = 0x0f0004cd4, .val = 0x0000ffff },
	{ .addr = 0x0f0004cd8, .val = 0xffffffff },
	{ .addr = 0x0f0004cdc, .val = 0x0000ffff },
	{ .addr = 0x0f0004ce0, .val = 0xffffffff },
	{ .addr = 0x0f0004ce4, .val = 0x0000ffff },
	{ .addr = 0x0f0004ce8, .val = 0xffffffff },
	{ .addr = 0x0f0004cec, .val = 0x0000ffff },
	{ .addr = 0x0f0004cf0, .val = 0xffffffff },
	{ .addr = 0x0f0004cf4, .val = 0x0000ffff },
	{ .addr = 0x0f0004cf8, .val = 0xffffffff },
	{ .addr = 0x0f0004cfc, .val = 0x0000ffff },
	{ .addr = 0x0f0004d00, .val = 0xffffffff },
	{ .addr = 0x0f0004d04, .val = 0x000000ff },
	{ .addr = 0x0f0004d08, .val = 0xffffffff },
	{ .addr = 0x0f0004d0c, .val = 0x000000ff },
	{ .addr = 0x0f0004d10, .val = 0xffffffff },
	{ .addr = 0x0f0004d14, .val = 0x000000ff },
	{ .addr = 0x0f0004d18, .val = 0xffffffff },
	{ .addr = 0x0f0004d1c, .val = 0x000000ff },
	{ .addr = 0x0f0004d20, .val = 0xffffffff },
	{ .addr = 0x0f0004d24, .val = 0x000000ff },
	{ .addr = 0x0f0004d28, .val = 0xffffffff },
	{ .addr = 0x0f0004d2c, .val = 0x000000ff },
	{ .addr = 0x0f0004d30, .val = 0xffffffff },
	{ .addr = 0x0f0004d34, .val = 0x000000ff },
	{ .addr = 0x0f0004d38, .val = 0xffffffff },
	{ .addr = 0x0f0004d3c, .val = 0x000000ff },
	{ .addr = 0x0f0004d40, .val = 0xffffffff },
	{ .addr = 0x0f0004d44, .val = 0x000000ff },
	{ .addr = 0x0f0004d48, .val = 0xffffffff },
	{ .addr = 0x0f0004d4c, .val = 0x000000ff },
	{ .addr = 0x0f0004d50, .val = 0xffffffff },
	{ .addr = 0x0f0004d54, .val = 0x000000ff },
	{ .addr = 0x0f0004d58, .val = 0xffffffff },
	{ .addr = 0x0f0004d5c, .val = 0x000000ff },
	{ .addr = 0x0f0004d60, .val = 0xffffffff },
	{ .addr = 0x0f0004d64, .val = 0x000000ff },
	{ .addr = 0x0f0004d68, .val = 0xffffffff },
	{ .addr = 0x0f0004d6c, .val = 0x000000ff },
	{ .addr = 0x0f0004d70, .val = 0xffffffff },
	{ .addr = 0x0f0004d74, .val = 0x000000ff },
	{ .addr = 0x0f0004d78, .val = 0xffffffff },
	{ .addr = 0x0f0004d7c, .val = 0x000000ff },
	{ .addr = 0x0f0004d80, .val = 0xffffffff },
	{ .addr = 0x0f0004d84, .val = 0x000000ff },
	{ .addr = 0x0f0004d88, .val = 0xffffffff },
	{ .addr = 0x0f0004d8c, .val = 0x000000ff },
	{ .addr = 0x0f0004d90, .val = 0xffffffff },
	{ .addr = 0x0f0004d94, .val = 0x000000ff },
	{ .addr = 0x0f0004d98, .val = 0xffffffff },
	{ .addr = 0x0f0004d9c, .val = 0x000000ff },
	{ .addr = 0x0f0004da0, .val = 0xffffffff },
	{ .addr = 0x0f0004da4, .val = 0x000000ff },
	{ .addr = 0x0f0004da8, .val = 0xffffffff },
	{ .addr = 0x0f0004dac, .val = 0x000000ff },
	{ .addr = 0x0f0004db0, .val = 0xffffffff },
	{ .addr = 0x0f0004db4, .val = 0x000000ff },
	{ .addr = 0x0f0004db8, .val = 0xffffffff },
	{ .addr = 0x0f0004dbc, .val = 0x000000ff },
	{ .addr = 0x0f0004dc0, .val = 0xffffffff },
	{ .addr = 0x0f0004dc4, .val = 0x000000ff },
	{ .addr = 0x0f0004dc8, .val = 0xffffffff },
	{ .addr = 0x0f0004dcc, .val = 0x000000ff },
	{ .addr = 0x0f0004dd0, .val = 0xffffffff },
	{ .addr = 0x0f0004dd4, .val = 0x000000ff },
	{ .addr = 0x0f0004dd8, .val = 0xffffffff },
	{ .addr = 0x0f0004ddc, .val = 0x000000ff },
	{ .addr = 0x0f0004de0, .val = 0xffffffff },
	{ .addr = 0x0f0004de4, .val = 0x000000ff },
	{ .addr = 0x0f0004de8, .val = 0xffffffff },
	{ .addr = 0x0f0004dec, .val = 0x000000ff },
	{ .addr = 0x0f0004df0, .val = 0xffffffff },
	{ .addr = 0x0f0004df4, .val = 0x000000ff },
	{ .addr = 0x0f0004df8, .val = 0xffffffff },
	{ .addr = 0x0f0004dfc, .val = 0x000000ff },
	{ .addr = 0x0f0004e00, .val = 0xffffffff },
	{ .addr = 0x0f0004e04, .val = 0x000000ff },
	{ .addr = 0x0f0004e08, .val = 0xffffffff },
	{ .addr = 0x0f0004e0c, .val = 0x000000ff },
	{ .addr = 0x0f0004e10, .val = 0xffffffff },
	{ .addr = 0x0f0004e14, .val = 0x000000ff },
	{ .addr = 0x0f0004e18, .val = 0xffffffff },
	{ .addr = 0x0f0004e1c, .val = 0x000000ff },
	{ .addr = 0x0f0004e20, .val = 0xffffffff },
	{ .addr = 0x0f0004e24, .val = 0x000000ff },
	{ .addr = 0x0f0004e28, .val = 0xffffffff },
	{ .addr = 0x0f0004e2c, .val = 0x000000ff },
	{ .addr = 0x0f0004e30, .val = 0xffffffff },
	{ .addr = 0x0f0004e34, .val = 0x000000ff },
	{ .addr = 0x0f0004e38, .val = 0xffffffff },
	{ .addr = 0x0f0004e3c, .val = 0x000000ff },
	{ .addr = 0x0f0004e40, .val = 0xffffffff },
	{ .addr = 0x0f0004e44, .val = 0x000000ff },
	{ .addr = 0x0f0004e48, .val = 0xffffffff },
	{ .addr = 0x0f0004e4c, .val = 0x000000ff },
	{ .addr = 0x0f0004e50, .val = 0xffffffff },
	{ .addr = 0x0f0004e54, .val = 0x000000ff },
	{ .addr = 0x0f0004e58, .val = 0xffffffff },
	{ .addr = 0x0f0004e5c, .val = 0x000000ff },
	{ .addr = 0x0f0004e60, .val = 0xffffffff },
	{ .addr = 0x0f0004e64, .val = 0x000000ff },
	{ .addr = 0x0f0004e68, .val = 0xffffffff },
	{ .addr = 0x0f0004e6c, .val = 0x000000ff },
	{ .addr = 0x0f0004e70, .val = 0xffffffff },
	{ .addr = 0x0f0004e74, .val = 0x000000ff },
	{ .addr = 0x0f0004e78, .val = 0xffffffff },
	{ .addr = 0x0f0004e7c, .val = 0x000000ff },
	{ .addr = 0x0f0004e80, .val = 0xffffffff },
	{ .addr = 0x0f0004e84, .val = 0x000000ff },
	{ .addr = 0x0f0004e88, .val = 0xffffffff },
	{ .addr = 0x0f0004e8c, .val = 0x000000ff },
	{ .addr = 0x0f0004e90, .val = 0xffffffff },
	{ .addr = 0x0f0004e94, .val = 0x000000ff },
	{ .addr = 0x0f0004e98, .val = 0xffffffff },
	{ .addr = 0x0f0004e9c, .val = 0x000000ff },
	{ .addr = 0x0f0004ea0, .val = 0xffffffff },
	{ .addr = 0x0f0004ea4, .val = 0x000000ff },
	{ .addr = 0x0f0004ea8, .val = 0xffffffff },
	{ .addr = 0x0f0004eac, .val = 0x000000ff },
	{ .addr = 0x0f0004eb0, .val = 0xffffffff },
	{ .addr = 0x0f0004eb4, .val = 0x000000ff },
	{ .addr = 0x0f0004eb8, .val = 0xffffffff },
	{ .addr = 0x0f0004ebc, .val = 0x000000ff },
	{ .addr = 0x0f0004ec0, .val = 0xffffffff },
	{ .addr = 0x0f0004ec4, .val = 0x000000ff },
	{ .addr = 0x0f0004ec8, .val = 0xffffffff },
	{ .addr = 0x0f0004ecc, .val = 0x000000ff },
	{ .addr = 0x0f0004ed0, .val = 0xffffffff },
	{ .addr = 0x0f0004ed4, .val = 0x000000ff },
	{ .addr = 0x0f0004ed8, .val = 0xffffffff },
	{ .addr = 0x0f0004edc, .val = 0x000000ff },
	{ .addr = 0x0f0004ee0, .val = 0xffffffff },
	{ .addr = 0x0f0004ee4, .val = 0x000000ff },
	{ .addr = 0x0f0004ee8, .val = 0xffffffff },
	{ .addr = 0x0f0004eec, .val = 0x000000ff },
	{ .addr = 0x0f0004ef0, .val = 0xffffffff },
	{ .addr = 0x0f0004ef4, .val = 0x000000ff },
	{ .addr = 0x0f0004ef8, .val = 0xffffffff },
	{ .addr = 0x0f0004efc, .val = 0x000000ff },
	{ .addr = 0x0f0004f00, .val = 0xffffffff },
	{ .addr = 0x0f0004f04, .val = 0x000000ff },
	{ .addr = 0x0f0004f08, .val = 0xffffffff },
	{ .addr = 0x0f0004f0c, .val = 0x000000ff },
	{ .addr = 0x0f0004f10, .val = 0xffffffff },
	{ .addr = 0x0f0004f14, .val = 0x000000ff },
	{ .addr = 0x0f0004f18, .val = 0xffffffff },
	{ .addr = 0x0f0004f1c, .val = 0x000000ff },
	{ .addr = 0x0f0004f20, .val = 0xffffffff },
	{ .addr = 0x0f0004f24, .val = 0x000000ff },
	{ .addr = 0x0f0004f28, .val = 0xffffffff },
	{ .addr = 0x0f0004f2c, .val = 0x000000ff },
	{ .addr = 0x0f0004f30, .val = 0xffffffff },
	{ .addr = 0x0f0004f34, .val = 0x000000ff },
	{ .addr = 0x0f0004f38, .val = 0xffffffff },
	{ .addr = 0x0f0004f3c, .val = 0x000000ff },
	{ .addr = 0x0f0004f40, .val = 0xffffffff },
	{ .addr = 0x0f0004f44, .val = 0x000000ff },
	{ .addr = 0x0f0004f48, .val = 0xffffffff },
	{ .addr = 0x0f0004f4c, .val = 0x000000ff },
	{ .addr = 0x0f0004f50, .val = 0xffffffff },
	{ .addr = 0x0f0004f54, .val = 0x000000ff },
	{ .addr = 0x0f0004f58, .val = 0xffffffff },
	{ .addr = 0x0f0004f5c, .val = 0x000000ff },
	{ .addr = 0x0f0004f60, .val = 0xffffffff },
	{ .addr = 0x0f0004f64, .val = 0x000000ff },
	{ .addr = 0x0f0004f68, .val = 0xffffffff },
	{ .addr = 0x0f0004f6c, .val = 0x000000ff },
	{ .addr = 0x0f0004f70, .val = 0xffffffff },
	{ .addr = 0x0f0004f74, .val = 0x000000ff },
	{ .addr = 0x0f0004f78, .val = 0xffffffff },
	{ .addr = 0x0f0004f7c, .val = 0x000000ff },
	{ .addr = 0x0f0004f80, .val = 0xffffffff },
	{ .addr = 0x0f0004f84, .val = 0x000000ff },
	{ .addr = 0x0f0004f88, .val = 0xffffffff },
	{ .addr = 0x0f0004f8c, .val = 0x000000ff },
	{ .addr = 0x0f0004f90, .val = 0xffffffff },
	{ .addr = 0x0f0004f94, .val = 0x000000ff },
	{ .addr = 0x0f0004f98, .val = 0xffffffff },
	{ .addr = 0x0f0004f9c, .val = 0x000000ff },
	{ .addr = 0x0f0004fa0, .val = 0xffffffff },
	{ .addr = 0x0f0004fa4, .val = 0x000000ff },
	{ .addr = 0x0f0004fa8, .val = 0xffffffff },
	{ .addr = 0x0f0004fac, .val = 0x000000ff },
	{ .addr = 0x0f0004fb0, .val = 0xffffffff },
	{ .addr = 0x0f0004fb4, .val = 0x000000ff },
	{ .addr = 0x0f0004fb8, .val = 0xffffffff },
	{ .addr = 0x0f0004fbc, .val = 0x000000ff },
	{ .addr = 0x0f0004fc0, .val = 0xffffffff },
	{ .addr = 0x0f0004fc4, .val = 0x000000ff },
	{ .addr = 0x0f0004fc8, .val = 0xffffffff },
	{ .addr = 0x0f0004fcc, .val = 0x000000ff },
	{ .addr = 0x0f0004fd0, .val = 0xffffffff },
	{ .addr = 0x0f0004fd4, .val = 0x000000ff },
	{ .addr = 0x0f0004fd8, .val = 0xffffffff },
	{ .addr = 0x0f0004fdc, .val = 0x000000ff },
	{ .addr = 0x0f0004fe0, .val = 0xffffffff },
	{ .addr = 0x0f0004fe4, .val = 0x000000ff },
	{ .addr = 0x0f0004fe8, .val = 0xffffffff },
	{ .addr = 0x0f0004fec, .val = 0x000000ff },
	{ .addr = 0x0f0004ff0, .val = 0xffffffff },
	{ .addr = 0x0f0004ff4, .val = 0x000000ff },
	{ .addr = 0x0f0004ff8, .val = 0xffffffff },
	{ .addr = 0x0f0004ffc, .val = 0x000000ff },
	{ .addr = 0x0f0005000, .val = 0xffffffff },
	{ .addr = 0x0f0005004, .val = 0x000000ff },
	{ .addr = 0x0f0005008, .val = 0xffffffff },
	{ .addr = 0x0f000500c, .val = 0x000000ff },
	{ .addr = 0x0f0005010, .val = 0xffffffff },
	{ .addr = 0x0f0005014, .val = 0x000000ff },
	{ .addr = 0x0f0005018, .val = 0xffffffff },
	{ .addr = 0x0f000501c, .val = 0x000000ff },
	{ .addr = 0x0f0005020, .val = 0xffffffff },
	{ .addr = 0x0f0005024, .val = 0x000000ff },
	{ .addr = 0x0f0005028, .val = 0xffffffff },
	{ .addr = 0x0f000502c, .val = 0x000000ff },
	{ .addr = 0x0f0005030, .val = 0xffffffff },
	{ .addr = 0x0f0005034, .val = 0x000000ff },
	{ .addr = 0x0f0005038, .val = 0xffffffff },
	{ .addr = 0x0f000503c, .val = 0x000000ff },
	{ .addr = 0x0f0005040, .val = 0xffffffff },
	{ .addr = 0x0f0005044, .val = 0x000000ff },
	{ .addr = 0x0f0005048, .val = 0xffffffff },
	{ .addr = 0x0f000504c, .val = 0x000000ff },
	{ .addr = 0x0f0005050, .val = 0xffffffff },
	{ .addr = 0x0f0005054, .val = 0x000000ff },
	{ .addr = 0x0f0005058, .val = 0xffffffff },
	{ .addr = 0x0f000505c, .val = 0x000000ff },
	{ .addr = 0x0f0005060, .val = 0xffffffff },
	{ .addr = 0x0f0005064, .val = 0x000000ff },
	{ .addr = 0x0f0005068, .val = 0xffffffff },
	{ .addr = 0x0f000506c, .val = 0x000000ff },
	{ .addr = 0x0f0005070, .val = 0xffffffff },
	{ .addr = 0x0f0005074, .val = 0x000000ff },
	{ .addr = 0x0f0005078, .val = 0xffffffff },
	{ .addr = 0x0f000507c, .val = 0x000000ff },
	{ .addr = 0x0f0005080, .val = 0xffffffff },
	{ .addr = 0x0f0005084, .val = 0x000000ff },
	{ .addr = 0x0f0005088, .val = 0xffffffff },
	{ .addr = 0x0f000508c, .val = 0x000000ff },
	{ .addr = 0x0f0005090, .val = 0xffffffff },
	{ .addr = 0x0f0005094, .val = 0x000000ff },
	{ .addr = 0x0f0005098, .val = 0xffffffff },
	{ .addr = 0x0f000509c, .val = 0x000000ff },
	{ .addr = 0x0f00050a0, .val = 0xffffffff },
	{ .addr = 0x0f00050a4, .val = 0x000000ff },
	{ .addr = 0x0f00050a8, .val = 0xffffffff },
	{ .addr = 0x0f00050ac, .val = 0x000000ff },
	{ .addr = 0x0f00050b0, .val = 0xffffffff },
	{ .addr = 0x0f00050b4, .val = 0x000000ff },
	{ .addr = 0x0f00050b8, .val = 0xffffffff },
	{ .addr = 0x0f00050bc, .val = 0x000000ff },
	{ .addr = 0x0f00050c0, .val = 0xffffffff },
	{ .addr = 0x0f00050c4, .val = 0x000000ff },
	{ .addr = 0x0f00050c8, .val = 0xffffffff },
	{ .addr = 0x0f00050cc, .val = 0x000000ff },
	{ .addr = 0x0f00050d0, .val = 0xffffffff },
	{ .addr = 0x0f00050d4, .val = 0x000000ff },
	{ .addr = 0x0f00050d8, .val = 0xffffffff },
	{ .addr = 0x0f00050dc, .val = 0x000000ff },
	{ .addr = 0x0f00050e0, .val = 0xffffffff },
	{ .addr = 0x0f00050e4, .val = 0x000000ff },
	{ .addr = 0x0f00050e8, .val = 0xffffffff },
	{ .addr = 0x0f00050ec, .val = 0x000000ff },
	{ .addr = 0x0f00050f0, .val = 0xffffffff },
	{ .addr = 0x0f00050f4, .val = 0x000000ff },
	{ .addr = 0x0f00050f8, .val = 0xffffffff },
	{ .addr = 0x0f00050fc, .val = 0x000000ff },
	{ .addr = 0x0f0005100, .val = 0xffffffff },
	{ .addr = 0x0f0005104, .val = 0x000000ff },
	{ .addr = 0x0f0005108, .val = 0xffffffff },
	{ .addr = 0x0f000510c, .val = 0x000000ff },
	{ .addr = 0x0f0005110, .val = 0xffffffff },
	{ .addr = 0x0f0005114, .val = 0x000000ff },
	{ .addr = 0x0f0005118, .val = 0xffffffff },
	{ .addr = 0x0f000511c, .val = 0x000000ff },
	{ .addr = 0x0f0005120, .val = 0xffffffff },
	{ .addr = 0x0f0005124, .val = 0x000000ff },
	{ .addr = 0x0f0005128, .val = 0xffffffff },
	{ .addr = 0x0f000512c, .val = 0x000000ff },
	{ .addr = 0x0f0005130, .val = 0xffffffff },
	{ .addr = 0x0f0005134, .val = 0x000000ff },
	{ .addr = 0x0f0005138, .val = 0xffffffff },
	{ .addr = 0x0f000513c, .val = 0x000000ff },
	{ .addr = 0x0f0005140, .val = 0xffffffff },
	{ .addr = 0x0f0005144, .val = 0x000000ff },
	{ .addr = 0x0f0005148, .val = 0xffffffff },
	{ .addr = 0x0f000514c, .val = 0x000000ff },
	{ .addr = 0x0f0005150, .val = 0xffffffff },
	{ .addr = 0x0f0005154, .val = 0x000000ff },
	{ .addr = 0x0f0005158, .val = 0xffffffff },
	{ .addr = 0x0f000515c, .val = 0x000000ff },
	{ .addr = 0x0f0005160, .val = 0xffffffff },
	{ .addr = 0x0f0005164, .val = 0x000000ff },
	{ .addr = 0x0f0005168, .val = 0xffffffff },
	{ .addr = 0x0f000516c, .val = 0x000000ff },
	{ .addr = 0x0f0005170, .val = 0xffffffff },
	{ .addr = 0x0f0005174, .val = 0x000000ff },
	{ .addr = 0x0f0005178, .val = 0xffffffff },
	{ .addr = 0x0f000517c, .val = 0x000000ff },
	{ .addr = 0x0f0005180, .val = 0xffffffff },
	{ .addr = 0x0f0005184, .val = 0x000000ff },
	{ .addr = 0x0f0005188, .val = 0xffffffff },
	{ .addr = 0x0f000518c, .val = 0x000000ff },
	{ .addr = 0x0f0005190, .val = 0xffffffff },
	{ .addr = 0x0f0005194, .val = 0x000000ff },
	{ .addr = 0x0f0005198, .val = 0xffffffff },
	{ .addr = 0x0f000519c, .val = 0x000000ff },
	{ .addr = 0x0f00051a0, .val = 0xffffffff },
	{ .addr = 0x0f00051a4, .val = 0x000000ff },
	{ .addr = 0x0f00051a8, .val = 0xffffffff },
	{ .addr = 0x0f00051ac, .val = 0x000000ff },
	{ .addr = 0x0f00051b0, .val = 0xffffffff },
	{ .addr = 0x0f00051b4, .val = 0x000000ff },
	{ .addr = 0x0f00051b8, .val = 0xffffffff },
	{ .addr = 0x0f00051bc, .val = 0x000000ff },
	{ .addr = 0x0f00051c0, .val = 0xffffffff },
	{ .addr = 0x0f00051c4, .val = 0x000000ff },
	{ .addr = 0x0f00051c8, .val = 0xffffffff },
	{ .addr = 0x0f00051cc, .val = 0x000000ff },
	{ .addr = 0x0f00051d0, .val = 0xffffffff },
	{ .addr = 0x0f00051d4, .val = 0x000000ff },
	{ .addr = 0x0f00051d8, .val = 0xffffffff },
	{ .addr = 0x0f00051dc, .val = 0x000000ff },
	{ .addr = 0x0f00051e0, .val = 0xffffffff },
	{ .addr = 0x0f00051e4, .val = 0x000000ff },
	{ .addr = 0x0f00051e8, .val = 0xffffffff },
	{ .addr = 0x0f00051ec, .val = 0x000000ff },
	{ .addr = 0x0f00051f0, .val = 0xffffffff },
	{ .addr = 0x0f00051f4, .val = 0x000000ff },
	{ .addr = 0x0f00051f8, .val = 0xffffffff },
	{ .addr = 0x0f00051fc, .val = 0x000000ff },
	{ .addr = 0x0f0005200, .val = 0xffffffff },
	{ .addr = 0x0f0005204, .val = 0x000000ff },
	{ .addr = 0x0f0005208, .val = 0xffffffff },
	{ .addr = 0x0f000520c, .val = 0x000000ff },
	{ .addr = 0x0f0005210, .val = 0xffffffff },
	{ .addr = 0x0f0005214, .val = 0x000000ff },
	{ .addr = 0x0f0005218, .val = 0xffffffff },
	{ .addr = 0x0f000521c, .val = 0x000000ff },
	{ .addr = 0x0f0005220, .val = 0xffffffff },
	{ .addr = 0x0f0005224, .val = 0x000000ff },
	{ .addr = 0x0f0005228, .val = 0xffffffff },
	{ .addr = 0x0f000522c, .val = 0x000000ff },
	{ .addr = 0x0f0005230, .val = 0xffffffff },
	{ .addr = 0x0f0005234, .val = 0x000000ff },
	{ .addr = 0x0f0005238, .val = 0xffffffff },
	{ .addr = 0x0f000523c, .val = 0x000000ff },
	{ .addr = 0x0f0005240, .val = 0xffffffff },
	{ .addr = 0x0f0005244, .val = 0x000000ff },
	{ .addr = 0x0f0005248, .val = 0xffffffff },
	{ .addr = 0x0f000524c, .val = 0x000000ff },
	{ .addr = 0x0f0005250, .val = 0xffffffff },
	{ .addr = 0x0f0005254, .val = 0x000000ff },
	{ .addr = 0x0f0005258, .val = 0xffffffff },
	{ .addr = 0x0f000525c, .val = 0x000000ff },
	{ .addr = 0x0f0005260, .val = 0xffffffff },
	{ .addr = 0x0f0005264, .val = 0x000000ff },
	{ .addr = 0x0f0005268, .val = 0xffffffff },
	{ .addr = 0x0f000526c, .val = 0x000000ff },
	{ .addr = 0x0f0005270, .val = 0xffffffff },
	{ .addr = 0x0f0005274, .val = 0x000000ff },
	{ .addr = 0x0f0005278, .val = 0xffffffff },
	{ .addr = 0x0f000527c, .val = 0x000000ff },
	{ .addr = 0x0f0005280, .val = 0xffffffff },
	{ .addr = 0x0f0005284, .val = 0x000000ff },
	{ .addr = 0x0f0005288, .val = 0xffffffff },
	{ .addr = 0x0f000528c, .val = 0x000000ff },
	{ .addr = 0x0f0005290, .val = 0xffffffff },
	{ .addr = 0x0f0005294, .val = 0x000000ff },
	{ .addr = 0x0f0005298, .val = 0xffffffff },
	{ .addr = 0x0f000529c, .val = 0x000000ff },
	{ .addr = 0x0f00052a0, .val = 0xffffffff },
	{ .addr = 0x0f00052a4, .val = 0x000000ff },
	{ .addr = 0x0f00052a8, .val = 0xffffffff },
	{ .addr = 0x0f00052ac, .val = 0x000000ff },
	{ .addr = 0x0f00052b0, .val = 0xffffffff },
	{ .addr = 0x0f00052b4, .val = 0x000000ff },
	{ .addr = 0x0f00052b8, .val = 0xffffffff },
	{ .addr = 0x0f00052bc, .val = 0x000000ff },
	{ .addr = 0x0f00052c0, .val = 0xffffffff },
	{ .addr = 0x0f00052c4, .val = 0x000000ff },
	{ .addr = 0x0f00052c8, .val = 0xffffffff },
	{ .addr = 0x0f00052cc, .val = 0x000000ff },
	{ .addr = 0x0f00052d0, .val = 0xffffffff },
	{ .addr = 0x0f00052d4, .val = 0x000000ff },
	{ .addr = 0x0f00052d8, .val = 0xffffffff },
	{ .addr = 0x0f00052dc, .val = 0x000000ff },
	{ .addr = 0x0f00052e0, .val = 0xffffffff },
	{ .addr = 0x0f00052e4, .val = 0x000000ff },
	{ .addr = 0x0f00052e8, .val = 0xffffffff },
	{ .addr = 0x0f00052ec, .val = 0x000000ff },
	{ .addr = 0x0f00052f0, .val = 0xffffffff },
	{ .addr = 0x0f00052f4, .val = 0x000000ff },
	{ .addr = 0x0f00052f8, .val = 0xffffffff },
	{ .addr = 0x0f00052fc, .val = 0x000000ff },
	{ .addr = 0x0f0005300, .val = 0xffffffff },
	{ .addr = 0x0f0005304, .val = 0x000000ff },
	{ .addr = 0x0f0005308, .val = 0xffffffff },
	{ .addr = 0x0f000530c, .val = 0x000000ff },
	{ .addr = 0x0f0005310, .val = 0xffffffff },
	{ .addr = 0x0f0005314, .val = 0x000000ff },
	{ .addr = 0x0f0005318, .val = 0xffffffff },
	{ .addr = 0x0f000531c, .val = 0x000000ff },
	{ .addr = 0x0f0005320, .val = 0xffffffff },
	{ .addr = 0x0f0005324, .val = 0x000000ff },
	{ .addr = 0x0f0005328, .val = 0xffffffff },
	{ .addr = 0x0f000532c, .val = 0x000000ff },
	{ .addr = 0x0f0005330, .val = 0xffffffff },
	{ .addr = 0x0f0005334, .val = 0x000000ff },
	{ .addr = 0x0f0005338, .val = 0xffffffff },
	{ .addr = 0x0f000533c, .val = 0x000000ff },
	{ .addr = 0x0f0005340, .val = 0xffffffff },
	{ .addr = 0x0f0005344, .val = 0x000000ff },
	{ .addr = 0x0f0005348, .val = 0xffffffff },
	{ .addr = 0x0f000534c, .val = 0x000000ff },
	{ .addr = 0x0f0005350, .val = 0xffffffff },
	{ .addr = 0x0f0005354, .val = 0x000000ff },
	{ .addr = 0x0f0005358, .val = 0xffffffff },
	{ .addr = 0x0f000535c, .val = 0x000000ff },
	{ .addr = 0x0f0005360, .val = 0xffffffff },
	{ .addr = 0x0f0005364, .val = 0x000000ff },
	{ .addr = 0x0f0005368, .val = 0xffffffff },
	{ .addr = 0x0f000536c, .val = 0x000000ff },
	{ .addr = 0x0f0005370, .val = 0xffffffff },
	{ .addr = 0x0f0005374, .val = 0x000000ff },
	{ .addr = 0x0f0005378, .val = 0xffffffff },
	{ .addr = 0x0f000537c, .val = 0x000000ff },
	{ .addr = 0x0f0005380, .val = 0xffffffff },
	{ .addr = 0x0f0005384, .val = 0x000000ff },
	{ .addr = 0x0f0005388, .val = 0xffffffff },
	{ .addr = 0x0f000538c, .val = 0x000000ff },
	{ .addr = 0x0f0005390, .val = 0xffffffff },
	{ .addr = 0x0f0005394, .val = 0x000000ff },
	{ .addr = 0x0f0005398, .val = 0xffffffff },
	{ .addr = 0x0f000539c, .val = 0x000000ff },
	{ .addr = 0x0f00053a0, .val = 0xffffffff },
	{ .addr = 0x0f00053a4, .val = 0x000000ff },
	{ .addr = 0x0f00053a8, .val = 0xffffffff },
	{ .addr = 0x0f00053ac, .val = 0x000000ff },
	{ .addr = 0x0f00053b0, .val = 0xffffffff },
	{ .addr = 0x0f00053b4, .val = 0x000000ff },
	{ .addr = 0x0f00053b8, .val = 0xffffffff },
	{ .addr = 0x0f00053bc, .val = 0x000000ff },
	{ .addr = 0x0f00053c0, .val = 0xffffffff },
	{ .addr = 0x0f00053c4, .val = 0x000000ff },
	{ .addr = 0x0f00053c8, .val = 0xffffffff },
	{ .addr = 0x0f00053cc, .val = 0x000000ff },
	{ .addr = 0x0f00053d0, .val = 0xffffffff },
	{ .addr = 0x0f00053d4, .val = 0x000000ff },
	{ .addr = 0x0f00053d8, .val = 0xffffffff },
	{ .addr = 0x0f00053dc, .val = 0x000000ff },
	{ .addr = 0x0f00053e0, .val = 0xffffffff },
	{ .addr = 0x0f00053e4, .val = 0x000000ff },
	{ .addr = 0x0f00053e8, .val = 0xffffffff },
	{ .addr = 0x0f00053ec, .val = 0x000000ff },
	{ .addr = 0x0f00053f0, .val = 0xffffffff },
	{ .addr = 0x0f00053f4, .val = 0x000000ff },
	{ .addr = 0x0f00053f8, .val = 0xffffffff },
	{ .addr = 0x0f00053fc, .val = 0x000000ff },
	{ .addr = 0x0f0005400, .val = 0xffffffff },
	{ .addr = 0x0f0005404, .val = 0x000000ff },
	{ .addr = 0x0f0005408, .val = 0xffffffff },
	{ .addr = 0x0f000540c, .val = 0x000000ff },
	{ .addr = 0x0f0005410, .val = 0xffffffff },
	{ .addr = 0x0f0005414, .val = 0x000000ff },
	{ .addr = 0x0f0005418, .val = 0xffffffff },
	{ .addr = 0x0f000541c, .val = 0x000000ff },
	{ .addr = 0x0f0005420, .val = 0xffffffff },
	{ .addr = 0x0f0005424, .val = 0x000000ff },
	{ .addr = 0x0f0005428, .val = 0xffffffff },
	{ .addr = 0x0f000542c, .val = 0x000000ff },
	{ .addr = 0x0f0005430, .val = 0xffffffff },
	{ .addr = 0x0f0005434, .val = 0x000000ff },
	{ .addr = 0x0f0005438, .val = 0xffffffff },
	{ .addr = 0x0f000543c, .val = 0x000000ff },
	{ .addr = 0x0f0005440, .val = 0xffffffff },
	{ .addr = 0x0f0005444, .val = 0x000000ff },
	{ .addr = 0x0f0005448, .val = 0xffffffff },
	{ .addr = 0x0f000544c, .val = 0x000000ff },
	{ .addr = 0x0f0005450, .val = 0xffffffff },
	{ .addr = 0x0f0005454, .val = 0x000000ff },
	{ .addr = 0x0f0005458, .val = 0xffffffff },
	{ .addr = 0x0f000545c, .val = 0x000000ff },
	{ .addr = 0x0f0005460, .val = 0xffffffff },
	{ .addr = 0x0f0005464, .val = 0x000000ff },
	{ .addr = 0x0f0005468, .val = 0xffffffff },
	{ .addr = 0x0f000546c, .val = 0x000000ff },
	{ .addr = 0x0f0005470, .val = 0xffffffff },
	{ .addr = 0x0f0005474, .val = 0x000000ff },
	{ .addr = 0x0f0005478, .val = 0xffffffff },
	{ .addr = 0x0f000547c, .val = 0x000000ff },
	{ .addr = 0x0f0005480, .val = 0xffffffff },
	{ .addr = 0x0f0005484, .val = 0x000000ff },
	{ .addr = 0x0f0005488, .val = 0xffffffff },
	{ .addr = 0x0f000548c, .val = 0x000000ff },
	{ .addr = 0x0f0005490, .val = 0xffffffff },
	{ .addr = 0x0f0005494, .val = 0x000000ff },
	{ .addr = 0x0f0005498, .val = 0xffffffff },
	{ .addr = 0x0f000549c, .val = 0x000000ff },
	{ .addr = 0x0f00054a0, .val = 0xffffffff },
	{ .addr = 0x0f00054a4, .val = 0x000000ff },
	{ .addr = 0x0f00054a8, .val = 0xffffffff },
	{ .addr = 0x0f00054ac, .val = 0x000000ff },
	{ .addr = 0x0f00054b0, .val = 0xffffffff },
	{ .addr = 0x0f00054b4, .val = 0x000000ff },
	{ .addr = 0x0f00054b8, .val = 0xffffffff },
	{ .addr = 0x0f00054bc, .val = 0x000000ff },
	{ .addr = 0x0f00054c0, .val = 0xffffffff },
	{ .addr = 0x0f00054c4, .val = 0x000000ff },
	{ .addr = 0x0f00054c8, .val = 0xffffffff },
	{ .addr = 0x0f00054cc, .val = 0x000000ff },
	{ .addr = 0x0f00054d0, .val = 0xffffffff },
	{ .addr = 0x0f00054d4, .val = 0x000000ff },
	{ .addr = 0x0f00054d8, .val = 0xffffffff },
	{ .addr = 0x0f00054dc, .val = 0x000000ff },
	{ .addr = 0x0f00054e0, .val = 0xffffffff },
	{ .addr = 0x0f00054e4, .val = 0x000000ff },
	{ .addr = 0x0f00054e8, .val = 0xffffffff },
	{ .addr = 0x0f00054ec, .val = 0x000000ff },
	{ .addr = 0x0f00054f0, .val = 0xffffffff },
	{ .addr = 0x0f00054f4, .val = 0x000000ff },
	{ .addr = 0x0f00054f8, .val = 0xffffffff },
	{ .addr = 0x0f00054fc, .val = 0x000000ff },
	{ .addr = 0x0f0005504, .val = 0xffffffff },
	{ .addr = 0x0f0120000, .val = 0x00000007 },
	{ .addr = 0x0f0120004, .val = 0xffffffff },
	{ .addr = 0x0f0120008, .val = 0x000003ff },
	{ .addr = 0x0f012000c, .val = 0x00007f8c },
	{ .addr = 0x0f0120010, .val = 0x0000ffff },
	{ .addr = 0x0f0120014, .val = 0x1fffffff },
	{ .addr = 0x0f0120018, .val = 0x00000001 },
	{ .addr = 0x0f012001c, .val = 0x000003ff },
	{ .addr = 0x0f0120020, .val = 0x00ffffff },
	{ .addr = 0x0f0120024, .val = 0x003f801f },
	{ .addr = 0x0f0120028, .val = 0x7fffffff },
	{ .addr = 0x0f012002c, .val = 0x9ffffe3f },
	{ .addr = 0x0f0120080, .val = 0x00018101 },
	{ .addr = 0x0f0120084, .val = 0x0f0f0f0f },
	{ .addr = 0x0f0120088, .val = 0x00003fff },
	{ .addr = 0x0f012008c, .val = 0x0007ffff },
	{ .addr = 0x0f0120100, .val = 0x7fffffff },
	{ .addr = 0x0f0120104, .val = 0x7fffffff },
	{ .addr = 0x0f0120108, .val = 0x7fffffff },
	{ .addr = 0x0f012010c, .val = 0x7fffffff },
	{ .addr = 0x0f0120110, .val = 0x7fffffff },
	{ .addr = 0x0f0120114, .val = 0x7fffffff },
	{ .addr = 0x0f0120118, .val = 0x7fffffff },
	{ .addr = 0x0f012011c, .val = 0x7fffffff },
	{ .addr = 0x0f0120120, .val = 0xffffffff },
	{ .addr = 0x0f0120124, .val = 0xffffffff },
	{ .addr = 0x0f0120128, .val = 0xffffffff },
	{ .addr = 0x0f012012c, .val = 0xffffffff },
	{ .addr = 0x0f0120130, .val = 0xffffffff },
	{ .addr = 0x0f0120134, .val = 0xffffffff },
	{ .addr = 0x0f0120138, .val = 0xffffffff },
	{ .addr = 0x0f012013c, .val = 0xffffffff },
	{ .addr = 0x0f0120150, .val = 0xffffffff },
	{ .addr = 0x0f0120154, .val = 0xffffffff },
	{ .addr = 0x0f0120180, .val = 0x007fffff },
	{ .addr = 0x0f0120184, .val = 0x007fffff },
	{ .addr = 0x0f0120188, .val = 0x007fffff },
	{ .addr = 0x0f012018c, .val = 0x007fffff },
	{ .addr = 0x0f0120190, .val = 0x007fffff },
	{ .addr = 0x0f0120194, .val = 0x007fffff },
	{ .addr = 0x0f0120198, .val = 0x007fffff },
	{ .addr = 0x0f012019c, .val = 0x007fffff },
	{ .addr = 0x0f01201a0, .val = 0x007fffff },
	{ .addr = 0x0f01201a4, .val = 0x007fffff },
	{ .addr = 0x0f01201a8, .val = 0x007fffff },
	{ .addr = 0x0f01201ac, .val = 0x007fffff },
	{ .addr = 0x0f01201b0, .val = 0x007fffff },
	{ .addr = 0x0f01201b4, .val = 0x007fffff },
	{ .addr = 0x0f01201b8, .val = 0x007fffff },
	{ .addr = 0x0f01201bc, .val = 0x007fffff },
	{ .addr = 0x0f0120200, .val = 0xffffffff },
	{ .addr = 0x0f0120204, .val = 0xffffffff },
	{ .addr = 0x0f0120208, .val = 0xffffffff },
	{ .addr = 0x0f012020c, .val = 0xffffffff },
	{ .addr = 0x0f0120210, .val = 0xffffffff },
	{ .addr = 0x0f0120214, .val = 0xffffffff },
	{ .addr = 0x0f0120218, .val = 0xffffffff },
	{ .addr = 0x0f012021c, .val = 0xffffffff },
	{ .addr = 0x0f0120220, .val = 0xffffffff },
	{ .addr = 0x0f0120224, .val = 0xffffffff },
	{ .addr = 0x0f0120228, .val = 0xffffffff },
	{ .addr = 0x0f012022c, .val = 0xffffffff },
	{ .addr = 0x0f0120230, .val = 0xffffffff },
	{ .addr = 0x0f0120234, .val = 0xffffffff },
	{ .addr = 0x0f0120238, .val = 0xffffffff },
	{ .addr = 0x0f012023c, .val = 0xffffffff },
	{ .addr = 0x0f0120240, .val = 0xffffffff },
	{ .addr = 0x0f0120244, .val = 0xffffffff },
	{ .addr = 0x0f0120248, .val = 0xffffffff },
	{ .addr = 0x0f012024c, .val = 0xffffffff },
	{ .addr = 0x0f0120250, .val = 0xffffffff },
	{ .addr = 0x0f0120254, .val = 0xffffffff },
	{ .addr = 0x0f0120258, .val = 0xffffffff },
	{ .addr = 0x0f012025c, .val = 0xffffffff },
	{ .addr = 0x0f0120260, .val = 0xffffffff },
	{ .addr = 0x0f0120264, .val = 0xffffffff },
	{ .addr = 0x0f0120268, .val = 0xffffffff },
	{ .addr = 0x0f012026c, .val = 0xffffffff },
	{ .addr = 0x0f0120270, .val = 0xffffffff },
	{ .addr = 0x0f0120274, .val = 0xffffffff },
	{ .addr = 0x0f0120278, .val = 0xffffffff },
	{ .addr = 0x0f012027c, .val = 0xffffffff },
	{ .addr = 0x0f0120280, .val = 0xffffffff },
	{ .addr = 0x0f0120284, .val = 0xffffffff },
	{ .addr = 0x0f0120288, .val = 0xffffffff },
	{ .addr = 0x0f012028c, .val = 0xffffffff },
	{ .addr = 0x0f0120290, .val = 0xffffffff },
	{ .addr = 0x0f0120294, .val = 0xffffffff },
	{ .addr = 0x0f0120298, .val = 0xffffffff },
	{ .addr = 0x0f012029c, .val = 0xffffffff },
	{ .addr = 0x0f01202a0, .val = 0xffffffff },
	{ .addr = 0x0f01202a4, .val = 0xffffffff },
	{ .addr = 0x0f01202a8, .val = 0xffffffff },
	{ .addr = 0x0f01202ac, .val = 0xffffffff },
	{ .addr = 0x0f01202b0, .val = 0xffffffff },
	{ .addr = 0x0f01202b4, .val = 0xffffffff },
	{ .addr = 0x0f01202b8, .val = 0xffffffff },
	{ .addr = 0x0f01202bc, .val = 0xffffffff },
	{ .addr = 0x0f01202c0, .val = 0xffffffff },
	{ .addr = 0x0f01202c4, .val = 0xffffffff },
	{ .addr = 0x0f01202c8, .val = 0xffffffff },
	{ .addr = 0x0f01202cc, .val = 0xffffffff },
	{ .addr = 0x0f01202d0, .val = 0xffffffff },
	{ .addr = 0x0f01202d4, .val = 0xffffffff },
	{ .addr = 0x0f01202d8, .val = 0xffffffff },
	{ .addr = 0x0f01202dc, .val = 0xffffffff },
	{ .addr = 0x0f01202e0, .val = 0xffffffff },
	{ .addr = 0x0f01202e4, .val = 0xffffffff },
	{ .addr = 0x0f01202e8, .val = 0xffffffff },
	{ .addr = 0x0f01202ec, .val = 0xffffffff },
	{ .addr = 0x0f01202f0, .val = 0xffffffff },
	{ .addr = 0x0f01202f4, .val = 0xffffffff },
	{ .addr = 0x0f01202f8, .val = 0xffffffff },
	{ .addr = 0x0f01202fc, .val = 0xffffffff },
	{ .addr = 0x0f0120300, .val = 0x0000ffff },
	{ .addr = 0x0f0120304, .val = 0x0000ffff },
	{ .addr = 0x0f0120308, .val = 0x0000ffff },
	{ .addr = 0x0f012030c, .val = 0x0000ffff },
	{ .addr = 0x0f0120310, .val = 0x0000ffff },
	{ .addr = 0x0f0120314, .val = 0x0000ffff },
	{ .addr = 0x0f0120318, .val = 0x0000ffff },
	{ .addr = 0x0f012031c, .val = 0x0000ffff },
	{ .addr = 0x0f0120320, .val = 0x0000ffff },
	{ .addr = 0x0f0120324, .val = 0x0000ffff },
	{ .addr = 0x0f0120328, .val = 0x0000ffff },
	{ .addr = 0x0f012032c, .val = 0x0000ffff },
	{ .addr = 0x0f0120330, .val = 0x0000ffff },
	{ .addr = 0x0f0120334, .val = 0x0000ffff },
	{ .addr = 0x0f0120338, .val = 0x0000ffff },
	{ .addr = 0x0f012033c, .val = 0x0000ffff },
	{ .addr = 0x0f0120340, .val = 0x0000ffff },
	{ .addr = 0x0f0120344, .val = 0x0000ffff },
	{ .addr = 0x0f0120348, .val = 0x0000ffff },
	{ .addr = 0x0f012034c, .val = 0x0000ffff },
	{ .addr = 0x0f0120350, .val = 0x0000ffff },
	{ .addr = 0x0f0120354, .val = 0x0000ffff },
	{ .addr = 0x0f0120358, .val = 0x0000ffff },
	{ .addr = 0x0f012035c, .val = 0x0000ffff },
	{ .addr = 0x0f0120360, .val = 0x0000ffff },
	{ .addr = 0x0f0120364, .val = 0x0000ffff },
	{ .addr = 0x0f0120368, .val = 0x0000ffff },
	{ .addr = 0x0f012036c, .val = 0x0000ffff },
	{ .addr = 0x0f0120370, .val = 0x0000ffff },
	{ .addr = 0x0f0120374, .val = 0x0000ffff },
	{ .addr = 0x0f0120378, .val = 0x0000ffff },
	{ .addr = 0x0f012037c, .val = 0x0000ffff },
	{ .addr = 0x0f0120380, .val = 0x0000ffff },
	{ .addr = 0x0f0120384, .val = 0x0000ffff },
	{ .addr = 0x0f0120388, .val = 0x0000ffff },
	{ .addr = 0x0f012038c, .val = 0x0000ffff },
	{ .addr = 0x0f0120390, .val = 0x0000ffff },
	{ .addr = 0x0f0120394, .val = 0x0000ffff },
	{ .addr = 0x0f0120398, .val = 0x0000ffff },
	{ .addr = 0x0f012039c, .val = 0x0000ffff },
	{ .addr = 0x0f01203a0, .val = 0x0000ffff },
	{ .addr = 0x0f01203a4, .val = 0x0000ffff },
	{ .addr = 0x0f01203a8, .val = 0x0000ffff },
	{ .addr = 0x0f01203ac, .val = 0x0000ffff },
	{ .addr = 0x0f01203b0, .val = 0x0000ffff },
	{ .addr = 0x0f01203b4, .val = 0x0000ffff },
	{ .addr = 0x0f01203b8, .val = 0x0000ffff },
	{ .addr = 0x0f01203bc, .val = 0x0000ffff },
	{ .addr = 0x0f01203c0, .val = 0x0000ffff },
	{ .addr = 0x0f01203c4, .val = 0x0000ffff },
	{ .addr = 0x0f01203c8, .val = 0x0000ffff },
	{ .addr = 0x0f01203cc, .val = 0x0000ffff },
	{ .addr = 0x0f01203d0, .val = 0x0000ffff },
	{ .addr = 0x0f01203d4, .val = 0x0000ffff },
	{ .addr = 0x0f01203d8, .val = 0x0000ffff },
	{ .addr = 0x0f01203dc, .val = 0x0000ffff },
	{ .addr = 0x0f01203e0, .val = 0x0000ffff },
	{ .addr = 0x0f01203e4, .val = 0x0000ffff },
	{ .addr = 0x0f01203e8, .val = 0x0000ffff },
	{ .addr = 0x0f01203ec, .val = 0x0000ffff },
	{ .addr = 0x0f01203f0, .val = 0x0000ffff },
	{ .addr = 0x0f01203f4, .val = 0x0000ffff },
	{ .addr = 0x0f01203f8, .val = 0x0000ffff },
	{ .addr = 0x0f01203fc, .val = 0x0000ffff },
	{ .addr = 0x0f0120400, .val = 0x8000003f },
	{ .addr = 0x0f0120404, .val = 0x8000003f },
	{ .addr = 0x0f0120408, .val = 0x8000003f },
	{ .addr = 0x0f012040c, .val = 0x8000003f },
	{ .addr = 0x0f0120410, .val = 0x8000003f },
	{ .addr = 0x0f0120414, .val = 0x8000003f },
	{ .addr = 0x0f0120418, .val = 0x8000003f },
	{ .addr = 0x0f012041c, .val = 0x8000003f },
	{ .addr = 0x0f0120420, .val = 0x8000003f },
	{ .addr = 0x0f0120424, .val = 0x8000003f },
	{ .addr = 0x0f0120428, .val = 0x8000003f },
	{ .addr = 0x0f012042c, .val = 0x8000003f },
	{ .addr = 0x0f0120430, .val = 0x8000003f },
	{ .addr = 0x0f0120434, .val = 0x8000003f },
	{ .addr = 0x0f0120438, .val = 0x8000003f },
	{ .addr = 0x0f012043c, .val = 0x8000003f },
	{ .addr = 0x0f0120440, .val = 0x8000003f },
	{ .addr = 0x0f0120444, .val = 0x8000003f },
	{ .addr = 0x0f0120448, .val = 0x8000003f },
	{ .addr = 0x0f012044c, .val = 0x8000003f },
	{ .addr = 0x0f0120450, .val = 0x8000003f },
	{ .addr = 0x0f0120454, .val = 0x8000003f },
	{ .addr = 0x0f0120458, .val = 0x8000003f },
	{ .addr = 0x0f012045c, .val = 0x8000003f },
	{ .addr = 0x0f0120460, .val = 0x8000003f },
	{ .addr = 0x0f0120464, .val = 0x8000003f },
	{ .addr = 0x0f0120468, .val = 0x8000003f },
	{ .addr = 0x0f012046c, .val = 0x8000003f },
	{ .addr = 0x0f0120470, .val = 0x8000003f },
	{ .addr = 0x0f0120474, .val = 0x8000003f },
	{ .addr = 0x0f0120478, .val = 0x8000003f },
	{ .addr = 0x0f012047c, .val = 0x8000003f },
	{ .addr = 0x0f0120480, .val = 0x8000003f },
	{ .addr = 0x0f0120484, .val = 0x8000003f },
	{ .addr = 0x0f0120488, .val = 0x8000003f },
	{ .addr = 0x0f012048c, .val = 0x8000003f },
	{ .addr = 0x0f0120490, .val = 0x8000003f },
	{ .addr = 0x0f0120494, .val = 0x8000003f },
	{ .addr = 0x0f0120498, .val = 0x8000003f },
	{ .addr = 0x0f012049c, .val = 0x8000003f },
	{ .addr = 0x0f01204a0, .val = 0x8000003f },
	{ .addr = 0x0f01204a4, .val = 0x8000003f },
	{ .addr = 0x0f01204a8, .val = 0x8000003f },
	{ .addr = 0x0f01204ac, .val = 0x8000003f },
	{ .addr = 0x0f01204b0, .val = 0x8000003f },
	{ .addr = 0x0f01204b4, .val = 0x8000003f },
	{ .addr = 0x0f01204b8, .val = 0x8000003f },
	{ .addr = 0x0f01204bc, .val = 0x8000003f },
	{ .addr = 0x0f01204c0, .val = 0x8000003f },
	{ .addr = 0x0f01204c4, .val = 0x8000003f },
	{ .addr = 0x0f01204c8, .val = 0x8000003f },
	{ .addr = 0x0f01204cc, .val = 0x8000003f },
	{ .addr = 0x0f01204d0, .val = 0x8000003f },
	{ .addr = 0x0f01204d4, .val = 0x8000003f },
	{ .addr = 0x0f01204d8, .val = 0x8000003f },
	{ .addr = 0x0f01204dc, .val = 0x8000003f },
	{ .addr = 0x0f01204e0, .val = 0x8000003f },
	{ .addr = 0x0f01204e4, .val = 0x8000003f },
	{ .addr = 0x0f01204e8, .val = 0x8000003f },
	{ .addr = 0x0f01204ec, .val = 0x8000003f },
	{ .addr = 0x0f01204f0, .val = 0x8000003f },
	{ .addr = 0x0f01204f4, .val = 0x8000003f },
	{ .addr = 0x0f01204f8, .val = 0x8000003f },
	{ .addr = 0x0f01204fc, .val = 0x8000003f },
	{ .addr = 0x0f0120500, .val = 0x8000003f },
	{ .addr = 0x0f0120504, .val = 0x8000003f },
	{ .addr = 0x0f0120508, .val = 0x8000003f },
	{ .addr = 0x0f012050c, .val = 0x8000003f },
	{ .addr = 0x0f0120510, .val = 0x8000003f },
	{ .addr = 0x0f0120514, .val = 0x8000003f },
	{ .addr = 0x0f0120518, .val = 0x8000003f },
	{ .addr = 0x0f012051c, .val = 0x8000003f },
	{ .addr = 0x0f0120520, .val = 0x8000003f },
	{ .addr = 0x0f0120524, .val = 0x8000003f },
	{ .addr = 0x0f0120528, .val = 0x8000003f },
	{ .addr = 0x0f012052c, .val = 0x8000003f },
	{ .addr = 0x0f0120530, .val = 0x8000003f },
	{ .addr = 0x0f0120534, .val = 0x8000003f },
	{ .addr = 0x0f0120538, .val = 0x8000003f },
	{ .addr = 0x0f012053c, .val = 0x8000003f },
	{ .addr = 0x0f0120540, .val = 0x8000003f },
	{ .addr = 0x0f0120544, .val = 0x8000003f },
	{ .addr = 0x0f0120548, .val = 0x8000003f },
	{ .addr = 0x0f012054c, .val = 0x8000003f },
	{ .addr = 0x0f0120550, .val = 0x8000003f },
	{ .addr = 0x0f0120554, .val = 0x8000003f },
	{ .addr = 0x0f0120558, .val = 0x8000003f },
	{ .addr = 0x0f012055c, .val = 0x8000003f },
	{ .addr = 0x0f0120560, .val = 0x8000003f },
	{ .addr = 0x0f0120564, .val = 0x8000003f },
	{ .addr = 0x0f0120568, .val = 0x8000003f },
	{ .addr = 0x0f012056c, .val = 0x8000003f },
	{ .addr = 0x0f0120570, .val = 0x8000003f },
	{ .addr = 0x0f0120574, .val = 0x8000003f },
	{ .addr = 0x0f0120578, .val = 0x8000003f },
	{ .addr = 0x0f012057c, .val = 0x8000003f },
	{ .addr = 0x0f0120580, .val = 0x8000003f },
	{ .addr = 0x0f0120584, .val = 0x8000003f },
	{ .addr = 0x0f0120588, .val = 0x8000003f },
	{ .addr = 0x0f012058c, .val = 0x8000003f },
	{ .addr = 0x0f0120590, .val = 0x8000003f },
	{ .addr = 0x0f0120594, .val = 0x8000003f },
	{ .addr = 0x0f0120598, .val = 0x8000003f },
	{ .addr = 0x0f012059c, .val = 0x8000003f },
	{ .addr = 0x0f01205a0, .val = 0x8000003f },
	{ .addr = 0x0f01205a4, .val = 0x8000003f },
	{ .addr = 0x0f01205a8, .val = 0x8000003f },
	{ .addr = 0x0f01205ac, .val = 0x8000003f },
	{ .addr = 0x0f01205b0, .val = 0x8000003f },
	{ .addr = 0x0f01205b4, .val = 0x8000003f },
	{ .addr = 0x0f01205b8, .val = 0x8000003f },
	{ .addr = 0x0f01205bc, .val = 0x8000003f },
	{ .addr = 0x0f01205c0, .val = 0x8000003f },
	{ .addr = 0x0f01205c4, .val = 0x8000003f },
	{ .addr = 0x0f01205c8, .val = 0x8000003f },
	{ .addr = 0x0f01205cc, .val = 0x8000003f },
	{ .addr = 0x0f01205d0, .val = 0x8000003f },
	{ .addr = 0x0f01205d4, .val = 0x8000003f },
	{ .addr = 0x0f01205d8, .val = 0x8000003f },
	{ .addr = 0x0f01205dc, .val = 0x8000003f },
	{ .addr = 0x0f01205e0, .val = 0x8000003f },
	{ .addr = 0x0f01205e4, .val = 0x8000003f },
	{ .addr = 0x0f01205e8, .val = 0x8000003f },
	{ .addr = 0x0f01205ec, .val = 0x8000003f },
	{ .addr = 0x0f01205f0, .val = 0x8000003f },
	{ .addr = 0x0f01205f4, .val = 0x8000003f },
	{ .addr = 0x0f01205f8, .val = 0x8000003f },
	{ .addr = 0x0f01205fc, .val = 0x8000003f },
	{ .addr = 0x0f0120600, .val = 0x8000003f },
	{ .addr = 0x0f0120604, .val = 0x8000003f },
	{ .addr = 0x0f0120608, .val = 0x8000003f },
	{ .addr = 0x0f012060c, .val = 0x8000003f },
	{ .addr = 0x0f0120610, .val = 0x8000003f },
	{ .addr = 0x0f0120614, .val = 0x8000003f },
	{ .addr = 0x0f0120618, .val = 0x8000003f },
	{ .addr = 0x0f012061c, .val = 0x8000003f },
	{ .addr = 0x0f0120620, .val = 0x8000003f },
	{ .addr = 0x0f0120624, .val = 0x8000003f },
	{ .addr = 0x0f0120628, .val = 0x8000003f },
	{ .addr = 0x0f012062c, .val = 0x8000003f },
	{ .addr = 0x0f0120630, .val = 0x8000003f },
	{ .addr = 0x0f0120634, .val = 0x8000003f },
	{ .addr = 0x0f0120638, .val = 0x8000003f },
	{ .addr = 0x0f012063c, .val = 0x8000003f },
	{ .addr = 0x0f0120640, .val = 0x8000003f },
	{ .addr = 0x0f0120644, .val = 0x8000003f },
	{ .addr = 0x0f0120648, .val = 0x8000003f },
	{ .addr = 0x0f012064c, .val = 0x8000003f },
	{ .addr = 0x0f0120650, .val = 0x8000003f },
	{ .addr = 0x0f0120654, .val = 0x8000003f },
	{ .addr = 0x0f0120658, .val = 0x8000003f },
	{ .addr = 0x0f012065c, .val = 0x8000003f },
	{ .addr = 0x0f0120660, .val = 0x8000003f },
	{ .addr = 0x0f0120664, .val = 0x8000003f },
	{ .addr = 0x0f0120668, .val = 0x8000003f },
	{ .addr = 0x0f012066c, .val = 0x8000003f },
	{ .addr = 0x0f0120670, .val = 0x8000003f },
	{ .addr = 0x0f0120674, .val = 0x8000003f },
	{ .addr = 0x0f0120678, .val = 0x8000003f },
	{ .addr = 0x0f012067c, .val = 0x8000003f },
	{ .addr = 0x0f0120680, .val = 0x8000003f },
	{ .addr = 0x0f0120684, .val = 0x8000003f },
	{ .addr = 0x0f0120688, .val = 0x8000003f },
	{ .addr = 0x0f012068c, .val = 0x8000003f },
	{ .addr = 0x0f0120690, .val = 0x8000003f },
	{ .addr = 0x0f0120694, .val = 0x8000003f },
	{ .addr = 0x0f0120698, .val = 0x8000003f },
	{ .addr = 0x0f012069c, .val = 0x8000003f },
	{ .addr = 0x0f01206a0, .val = 0x8000003f },
	{ .addr = 0x0f01206a4, .val = 0x8000003f },
	{ .addr = 0x0f01206a8, .val = 0x8000003f },
	{ .addr = 0x0f01206ac, .val = 0x8000003f },
	{ .addr = 0x0f01206b0, .val = 0x8000003f },
	{ .addr = 0x0f01206b4, .val = 0x8000003f },
	{ .addr = 0x0f01206b8, .val = 0x8000003f },
	{ .addr = 0x0f01206bc, .val = 0x8000003f },
	{ .addr = 0x0f01206c0, .val = 0x8000003f },
	{ .addr = 0x0f01206c4, .val = 0x8000003f },
	{ .addr = 0x0f01206c8, .val = 0x8000003f },
	{ .addr = 0x0f01206cc, .val = 0x8000003f },
	{ .addr = 0x0f01206d0, .val = 0x8000003f },
	{ .addr = 0x0f01206d4, .val = 0x8000003f },
	{ .addr = 0x0f01206d8, .val = 0x8000003f },
	{ .addr = 0x0f01206dc, .val = 0x8000003f },
	{ .addr = 0x0f01206e0, .val = 0x8000003f },
	{ .addr = 0x0f01206e4, .val = 0x8000003f },
	{ .addr = 0x0f01206e8, .val = 0x8000003f },
	{ .addr = 0x0f01206ec, .val = 0x8000003f },
	{ .addr = 0x0f01206f0, .val = 0x8000003f },
	{ .addr = 0x0f01206f4, .val = 0x8000003f },
	{ .addr = 0x0f01206f8, .val = 0x8000003f },
	{ .addr = 0x0f01206fc, .val = 0x8000003f },
	{ .addr = 0x0f0120700, .val = 0x8000003f },
	{ .addr = 0x0f0120704, .val = 0x8000003f },
	{ .addr = 0x0f0120708, .val = 0x8000003f },
	{ .addr = 0x0f012070c, .val = 0x8000003f },
	{ .addr = 0x0f0120710, .val = 0x8000003f },
	{ .addr = 0x0f0120714, .val = 0x8000003f },
	{ .addr = 0x0f0120718, .val = 0x8000003f },
	{ .addr = 0x0f012071c, .val = 0x8000003f },
	{ .addr = 0x0f0120720, .val = 0x8000003f },
	{ .addr = 0x0f0120724, .val = 0x8000003f },
	{ .addr = 0x0f0120728, .val = 0x8000003f },
	{ .addr = 0x0f012072c, .val = 0x8000003f },
	{ .addr = 0x0f0120730, .val = 0x8000003f },
	{ .addr = 0x0f0120734, .val = 0x8000003f },
	{ .addr = 0x0f0120738, .val = 0x8000003f },
	{ .addr = 0x0f012073c, .val = 0x8000003f },
	{ .addr = 0x0f0120740, .val = 0x8000003f },
	{ .addr = 0x0f0120744, .val = 0x8000003f },
	{ .addr = 0x0f0120748, .val = 0x8000003f },
	{ .addr = 0x0f012074c, .val = 0x8000003f },
	{ .addr = 0x0f0120750, .val = 0x8000003f },
	{ .addr = 0x0f0120754, .val = 0x8000003f },
	{ .addr = 0x0f0120758, .val = 0x8000003f },
	{ .addr = 0x0f012075c, .val = 0x8000003f },
	{ .addr = 0x0f0120760, .val = 0x8000003f },
	{ .addr = 0x0f0120764, .val = 0x8000003f },
	{ .addr = 0x0f0120768, .val = 0x8000003f },
	{ .addr = 0x0f012076c, .val = 0x8000003f },
	{ .addr = 0x0f0120770, .val = 0x8000003f },
	{ .addr = 0x0f0120774, .val = 0x8000003f },
	{ .addr = 0x0f0120778, .val = 0x8000003f },
	{ .addr = 0x0f012077c, .val = 0x8000003f },
	{ .addr = 0x0f0120780, .val = 0x8000003f },
	{ .addr = 0x0f0120784, .val = 0x8000003f },
	{ .addr = 0x0f0120788, .val = 0x8000003f },
	{ .addr = 0x0f012078c, .val = 0x8000003f },
	{ .addr = 0x0f0120790, .val = 0x8000003f },
	{ .addr = 0x0f0120794, .val = 0x8000003f },
	{ .addr = 0x0f0120798, .val = 0x8000003f },
	{ .addr = 0x0f012079c, .val = 0x8000003f },
	{ .addr = 0x0f01207a0, .val = 0x8000003f },
	{ .addr = 0x0f01207a4, .val = 0x8000003f },
	{ .addr = 0x0f01207a8, .val = 0x8000003f },
	{ .addr = 0x0f01207ac, .val = 0x8000003f },
	{ .addr = 0x0f01207b0, .val = 0x8000003f },
	{ .addr = 0x0f01207b4, .val = 0x8000003f },
	{ .addr = 0x0f01207b8, .val = 0x8000003f },
	{ .addr = 0x0f01207bc, .val = 0x8000003f },
	{ .addr = 0x0f01207c0, .val = 0x8000003f },
	{ .addr = 0x0f01207c4, .val = 0x8000003f },
	{ .addr = 0x0f01207c8, .val = 0x8000003f },
	{ .addr = 0x0f01207cc, .val = 0x8000003f },
	{ .addr = 0x0f01207d0, .val = 0x8000003f },
	{ .addr = 0x0f01207d4, .val = 0x8000003f },
	{ .addr = 0x0f01207d8, .val = 0x8000003f },
	{ .addr = 0x0f01207dc, .val = 0x8000003f },
	{ .addr = 0x0f01207e0, .val = 0x8000003f },
	{ .addr = 0x0f01207e4, .val = 0x8000003f },
	{ .addr = 0x0f01207e8, .val = 0x8000003f },
	{ .addr = 0x0f01207ec, .val = 0x8000003f },
	{ .addr = 0x0f01207f0, .val = 0x8000003f },
	{ .addr = 0x0f01207f4, .val = 0x8000003f },
	{ .addr = 0x0f01207f8, .val = 0x8000003f },
	{ .addr = 0x0f01207fc, .val = 0x8000003f },
	{ .addr = 0x0f0120800, .val = 0x000fffff },
	{ .addr = 0x0f0120804, .val = 0x000fffff },
	{ .addr = 0x0f0120808, .val = 0x000fffff },
	{ .addr = 0x0f012080c, .val = 0x000fffff },
	{ .addr = 0x0f0120810, .val = 0x000fffff },
	{ .addr = 0x0f0120814, .val = 0x000fffff },
	{ .addr = 0x0f0120818, .val = 0x000fffff },
	{ .addr = 0x0f012081c, .val = 0x000fffff },
	{ .addr = 0x0f0120820, .val = 0x000fffff },
	{ .addr = 0x0f0120824, .val = 0x000fffff },
	{ .addr = 0x0f0120828, .val = 0x000fffff },
	{ .addr = 0x0f012082c, .val = 0x000fffff },
	{ .addr = 0x0f0120830, .val = 0x000fffff },
	{ .addr = 0x0f0120834, .val = 0x000fffff },
	{ .addr = 0x0f0120838, .val = 0x000fffff },
	{ .addr = 0x0f012083c, .val = 0x000fffff },
	{ .addr = 0x0f0120840, .val = 0x000fffff },
	{ .addr = 0x0f0120844, .val = 0x000fffff },
	{ .addr = 0x0f0120848, .val = 0x000fffff },
	{ .addr = 0x0f012084c, .val = 0x000fffff },
	{ .addr = 0x0f0120850, .val = 0x000fffff },
	{ .addr = 0x0f0120854, .val = 0x000fffff },
	{ .addr = 0x0f0120858, .val = 0x000fffff },
	{ .addr = 0x0f012085c, .val = 0x000fffff },
	{ .addr = 0x0f0120860, .val = 0x000fffff },
	{ .addr = 0x0f0120864, .val = 0x000fffff },
	{ .addr = 0x0f0120868, .val = 0x000fffff },
	{ .addr = 0x0f012086c, .val = 0x000fffff },
	{ .addr = 0x0f0120870, .val = 0x000fffff },
	{ .addr = 0x0f0120874, .val = 0x000fffff },
	{ .addr = 0x0f0120878, .val = 0x000fffff },
	{ .addr = 0x0f012087c, .val = 0x000fffff },
	{ .addr = 0x0f0120880, .val = 0x000fffff },
	{ .addr = 0x0f0120884, .val = 0x000fffff },
	{ .addr = 0x0f0120888, .val = 0x000fffff },
	{ .addr = 0x0f012088c, .val = 0x000fffff },
	{ .addr = 0x0f0120890, .val = 0x000fffff },
	{ .addr = 0x0f0120894, .val = 0x000fffff },
	{ .addr = 0x0f0120898, .val = 0x000fffff },
	{ .addr = 0x0f012089c, .val = 0x000fffff },
	{ .addr = 0x0f01208a0, .val = 0x000fffff },
	{ .addr = 0x0f01208a4, .val = 0x000fffff },
	{ .addr = 0x0f01208a8, .val = 0x000fffff },
	{ .addr = 0x0f01208ac, .val = 0x000fffff },
	{ .addr = 0x0f01208b0, .val = 0x000fffff },
	{ .addr = 0x0f01208b4, .val = 0x000fffff },
	{ .addr = 0x0f01208b8, .val = 0x000fffff },
	{ .addr = 0x0f01208bc, .val = 0x000fffff },
	{ .addr = 0x0f01208c0, .val = 0x000fffff },
	{ .addr = 0x0f01208c4, .val = 0x000fffff },
	{ .addr = 0x0f01208c8, .val = 0x000fffff },
	{ .addr = 0x0f01208cc, .val = 0x000fffff },
	{ .addr = 0x0f01208d0, .val = 0x000fffff },
	{ .addr = 0x0f01208d4, .val = 0x000fffff },
	{ .addr = 0x0f01208d8, .val = 0x000fffff },
	{ .addr = 0x0f01208dc, .val = 0x000fffff },
	{ .addr = 0x0f01208e0, .val = 0x000fffff },
	{ .addr = 0x0f01208e4, .val = 0x000fffff },
	{ .addr = 0x0f01208e8, .val = 0x000fffff },
	{ .addr = 0x0f01208ec, .val = 0x000fffff },
	{ .addr = 0x0f01208f0, .val = 0x000fffff },
	{ .addr = 0x0f01208f4, .val = 0x000fffff },
	{ .addr = 0x0f01208f8, .val = 0x000fffff },
	{ .addr = 0x0f01208fc, .val = 0x000fffff },
	{ .addr = 0x0f0120900, .val = 0x1fffffff },
	{ .addr = 0x0f0120904, .val = 0x1fffffff },
	{ .addr = 0x0f0120908, .val = 0x1fffffff },
	{ .addr = 0x0f012090c, .val = 0x1fffffff },
	{ .addr = 0x0f0120910, .val = 0x1fffffff },
	{ .addr = 0x0f0120914, .val = 0x1fffffff },
	{ .addr = 0x0f0120918, .val = 0x1fffffff },
	{ .addr = 0x0f012091c, .val = 0x1fffffff },
	{ .addr = 0x0f0120920, .val = 0x1fffffff },
	{ .addr = 0x0f0120924, .val = 0x1fffffff },
	{ .addr = 0x0f0120928, .val = 0x1fffffff },
	{ .addr = 0x0f012092c, .val = 0x1fffffff },
	{ .addr = 0x0f0120930, .val = 0x1fffffff },
	{ .addr = 0x0f0120934, .val = 0x1fffffff },
	{ .addr = 0x0f0120938, .val = 0x1fffffff },
	{ .addr = 0x0f012093c, .val = 0x1fffffff },
	{ .addr = 0x0f0120940, .val = 0x1fffffff },
	{ .addr = 0x0f0120944, .val = 0x1fffffff },
	{ .addr = 0x0f0120948, .val = 0x1fffffff },
	{ .addr = 0x0f012094c, .val = 0x1fffffff },
	{ .addr = 0x0f0120950, .val = 0x1fffffff },
	{ .addr = 0x0f0120954, .val = 0x1fffffff },
	{ .addr = 0x0f0120958, .val = 0x1fffffff },
	{ .addr = 0x0f012095c, .val = 0x1fffffff },
	{ .addr = 0x0f0120960, .val = 0x1fffffff },
	{ .addr = 0x0f0120964, .val = 0x1fffffff },
	{ .addr = 0x0f0120968, .val = 0x1fffffff },
	{ .addr = 0x0f012096c, .val = 0x1fffffff },
	{ .addr = 0x0f0120970, .val = 0x1fffffff },
	{ .addr = 0x0f0120974, .val = 0x1fffffff },
	{ .addr = 0x0f0120978, .val = 0x1fffffff },
	{ .addr = 0x0f012097c, .val = 0x1fffffff },
	{ .addr = 0x0f0120980, .val = 0x1fffffff },
	{ .addr = 0x0f0120984, .val = 0x1fffffff },
	{ .addr = 0x0f0120988, .val = 0x1fffffff },
	{ .addr = 0x0f012098c, .val = 0x1fffffff },
	{ .addr = 0x0f0120990, .val = 0x1fffffff },
	{ .addr = 0x0f0120994, .val = 0x1fffffff },
	{ .addr = 0x0f0120998, .val = 0x1fffffff },
	{ .addr = 0x0f012099c, .val = 0x1fffffff },
	{ .addr = 0x0f01209a0, .val = 0x1fffffff },
	{ .addr = 0x0f01209a4, .val = 0x1fffffff },
	{ .addr = 0x0f01209a8, .val = 0x1fffffff },
	{ .addr = 0x0f01209ac, .val = 0x1fffffff },
	{ .addr = 0x0f01209b0, .val = 0x1fffffff },
	{ .addr = 0x0f01209b4, .val = 0x1fffffff },
	{ .addr = 0x0f01209b8, .val = 0x1fffffff },
	{ .addr = 0x0f01209bc, .val = 0x1fffffff },
	{ .addr = 0x0f01209c0, .val = 0x1fffffff },
	{ .addr = 0x0f01209c4, .val = 0x1fffffff },
	{ .addr = 0x0f01209c8, .val = 0x1fffffff },
	{ .addr = 0x0f01209cc, .val = 0x1fffffff },
	{ .addr = 0x0f01209d0, .val = 0x1fffffff },
	{ .addr = 0x0f01209d4, .val = 0x1fffffff },
	{ .addr = 0x0f01209d8, .val = 0x1fffffff },
	{ .addr = 0x0f01209dc, .val = 0x1fffffff },
	{ .addr = 0x0f01209e0, .val = 0x1fffffff },
	{ .addr = 0x0f01209e4, .val = 0x1fffffff },
	{ .addr = 0x0f01209e8, .val = 0x1fffffff },
	{ .addr = 0x0f01209ec, .val = 0x1fffffff },
	{ .addr = 0x0f01209f0, .val = 0x1fffffff },
	{ .addr = 0x0f01209f4, .val = 0x1fffffff },
	{ .addr = 0x0f01209f8, .val = 0x1fffffff },
	{ .addr = 0x0f01209fc, .val = 0x1fffffff },
	{ .addr = 0x0f0120a00, .val = 0x007fffff },
	{ .addr = 0x0f0120a04, .val = 0x007fffff },
	{ .addr = 0x0f0120a08, .val = 0x007fffff },
	{ .addr = 0x0f0120a0c, .val = 0x007fffff },
	{ .addr = 0x0f0120a10, .val = 0x007fffff },
	{ .addr = 0x0f0120a14, .val = 0x007fffff },
	{ .addr = 0x0f0120a18, .val = 0x007fffff },
	{ .addr = 0x0f0120a1c, .val = 0x007fffff },
	{ .addr = 0x0f0120a20, .val = 0x007fffff },
	{ .addr = 0x0f0120a24, .val = 0x007fffff },
	{ .addr = 0x0f0120a28, .val = 0x007fffff },
	{ .addr = 0x0f0120a2c, .val = 0x007fffff },
	{ .addr = 0x0f0120a30, .val = 0x007fffff },
	{ .addr = 0x0f0120a34, .val = 0x007fffff },
	{ .addr = 0x0f0120a38, .val = 0x007fffff },
	{ .addr = 0x0f0120a3c, .val = 0x007fffff },
	{ .addr = 0x0f0120a40, .val = 0x007fffff },
	{ .addr = 0x0f0120a44, .val = 0x007fffff },
	{ .addr = 0x0f0120a48, .val = 0x007fffff },
	{ .addr = 0x0f0120a4c, .val = 0x007fffff },
	{ .addr = 0x0f0120a50, .val = 0x007fffff },
	{ .addr = 0x0f0120a54, .val = 0x007fffff },
	{ .addr = 0x0f0120a58, .val = 0x007fffff },
	{ .addr = 0x0f0120a5c, .val = 0x007fffff },
	{ .addr = 0x0f0120a60, .val = 0x007fffff },
	{ .addr = 0x0f0120a64, .val = 0x007fffff },
	{ .addr = 0x0f0120a68, .val = 0x007fffff },
	{ .addr = 0x0f0120a6c, .val = 0x007fffff },
	{ .addr = 0x0f0120a70, .val = 0x007fffff },
	{ .addr = 0x0f0120a74, .val = 0x007fffff },
	{ .addr = 0x0f0120a78, .val = 0x007fffff },
	{ .addr = 0x0f0120a7c, .val = 0x007fffff },
	{ .addr = 0x0f0120a80, .val = 0x007fffff },
	{ .addr = 0x0f0120a84, .val = 0x007fffff },
	{ .addr = 0x0f0120a88, .val = 0x007fffff },
	{ .addr = 0x0f0120a8c, .val = 0x007fffff },
	{ .addr = 0x0f0120a90, .val = 0x007fffff },
	{ .addr = 0x0f0120a94, .val = 0x007fffff },
	{ .addr = 0x0f0120a98, .val = 0x007fffff },
	{ .addr = 0x0f0120a9c, .val = 0x007fffff },
	{ .addr = 0x0f0120aa0, .val = 0x007fffff },
	{ .addr = 0x0f0120aa4, .val = 0x007fffff },
	{ .addr = 0x0f0120aa8, .val = 0x007fffff },
	{ .addr = 0x0f0120aac, .val = 0x007fffff },
	{ .addr = 0x0f0120ab0, .val = 0x007fffff },
	{ .addr = 0x0f0120ab4, .val = 0x007fffff },
	{ .addr = 0x0f0120ab8, .val = 0x007fffff },
	{ .addr = 0x0f0120abc, .val = 0x007fffff },
	{ .addr = 0x0f0120ac0, .val = 0x007fffff },
	{ .addr = 0x0f0120ac4, .val = 0x007fffff },
	{ .addr = 0x0f0120ac8, .val = 0x007fffff },
	{ .addr = 0x0f0120acc, .val = 0x007fffff },
	{ .addr = 0x0f0120ad0, .val = 0x007fffff },
	{ .addr = 0x0f0120ad4, .val = 0x007fffff },
	{ .addr = 0x0f0120ad8, .val = 0x007fffff },
	{ .addr = 0x0f0120adc, .val = 0x007fffff },
	{ .addr = 0x0f0120ae0, .val = 0x007fffff },
	{ .addr = 0x0f0120ae4, .val = 0x007fffff },
	{ .addr = 0x0f0120ae8, .val = 0x007fffff },
	{ .addr = 0x0f0120aec, .val = 0x007fffff },
	{ .addr = 0x0f0120af0, .val = 0x007fffff },
	{ .addr = 0x0f0120af4, .val = 0x007fffff },
	{ .addr = 0x0f0120af8, .val = 0x007fffff },
	{ .addr = 0x0f0120afc, .val = 0x007fffff },
	{ .addr = 0x0f0120b00, .val = 0x07ffffff },
	{ .addr = 0x0f0120b04, .val = 0x07ffffff },
	{ .addr = 0x0f0120b08, .val = 0x07ffffff },
	{ .addr = 0x0f0120b0c, .val = 0x07ffffff },
	{ .addr = 0x0f0120b10, .val = 0x07ffffff },
	{ .addr = 0x0f0120b14, .val = 0x07ffffff },
	{ .addr = 0x0f0120b18, .val = 0x07ffffff },
	{ .addr = 0x0f0120b1c, .val = 0x07ffffff },
	{ .addr = 0x0f0120b20, .val = 0x07ffffff },
	{ .addr = 0x0f0120b24, .val = 0x07ffffff },
	{ .addr = 0x0f0120b28, .val = 0x07ffffff },
	{ .addr = 0x0f0120b2c, .val = 0x07ffffff },
	{ .addr = 0x0f0120b30, .val = 0x07ffffff },
	{ .addr = 0x0f0120b34, .val = 0x07ffffff },
	{ .addr = 0x0f0120b38, .val = 0x07ffffff },
	{ .addr = 0x0f0120b3c, .val = 0x07ffffff },
	{ .addr = 0x0f0120b40, .val = 0x07ffffff },
	{ .addr = 0x0f0120b44, .val = 0x07ffffff },
	{ .addr = 0x0f0120b48, .val = 0x07ffffff },
	{ .addr = 0x0f0120b4c, .val = 0x07ffffff },
	{ .addr = 0x0f0120b50, .val = 0x07ffffff },
	{ .addr = 0x0f0120b54, .val = 0x07ffffff },
	{ .addr = 0x0f0120b58, .val = 0x07ffffff },
	{ .addr = 0x0f0120b5c, .val = 0x07ffffff },
	{ .addr = 0x0f0120b60, .val = 0x07ffffff },
	{ .addr = 0x0f0120b64, .val = 0x07ffffff },
	{ .addr = 0x0f0120b68, .val = 0x07ffffff },
	{ .addr = 0x0f0120b6c, .val = 0x07ffffff },
	{ .addr = 0x0f0120b70, .val = 0x07ffffff },
	{ .addr = 0x0f0120b74, .val = 0x07ffffff },
	{ .addr = 0x0f0120b78, .val = 0x07ffffff },
	{ .addr = 0x0f0120b7c, .val = 0x07ffffff },
	{ .addr = 0x0f0120b80, .val = 0x07ffffff },
	{ .addr = 0x0f0120b84, .val = 0x07ffffff },
	{ .addr = 0x0f0120b88, .val = 0x07ffffff },
	{ .addr = 0x0f0120b8c, .val = 0x07ffffff },
	{ .addr = 0x0f0120b90, .val = 0x07ffffff },
	{ .addr = 0x0f0120b94, .val = 0x07ffffff },
	{ .addr = 0x0f0120b98, .val = 0x07ffffff },
	{ .addr = 0x0f0120b9c, .val = 0x07ffffff },
	{ .addr = 0x0f0120ba0, .val = 0x07ffffff },
	{ .addr = 0x0f0120ba4, .val = 0x07ffffff },
	{ .addr = 0x0f0120ba8, .val = 0x07ffffff },
	{ .addr = 0x0f0120bac, .val = 0x07ffffff },
	{ .addr = 0x0f0120bb0, .val = 0x07ffffff },
	{ .addr = 0x0f0120bb4, .val = 0x07ffffff },
	{ .addr = 0x0f0120bb8, .val = 0x07ffffff },
	{ .addr = 0x0f0120bbc, .val = 0x07ffffff },
	{ .addr = 0x0f0120bc0, .val = 0x07ffffff },
	{ .addr = 0x0f0120bc4, .val = 0x07ffffff },
	{ .addr = 0x0f0120bc8, .val = 0x07ffffff },
	{ .addr = 0x0f0120bcc, .val = 0x07ffffff },
	{ .addr = 0x0f0120bd0, .val = 0x07ffffff },
	{ .addr = 0x0f0120bd4, .val = 0x07ffffff },
	{ .addr = 0x0f0120bd8, .val = 0x07ffffff },
	{ .addr = 0x0f0120bdc, .val = 0x07ffffff },
	{ .addr = 0x0f0120be0, .val = 0x07ffffff },
	{ .addr = 0x0f0120be4, .val = 0x07ffffff },
	{ .addr = 0x0f0120be8, .val = 0x07ffffff },
	{ .addr = 0x0f0120bec, .val = 0x07ffffff },
	{ .addr = 0x0f0120bf0, .val = 0x07ffffff },
	{ .addr = 0x0f0120bf4, .val = 0x07ffffff },
	{ .addr = 0x0f0120bf8, .val = 0x07ffffff },
	{ .addr = 0x0f0120bfc, .val = 0x07ffffff },
	{ .addr = 0x0f0120c00, .val = 0x0fffffff },
	{ .addr = 0x0f0120c04, .val = 0x0fffffff },
	{ .addr = 0x0f0120c08, .val = 0x0fffffff },
	{ .addr = 0x0f0120c0c, .val = 0x0fffffff },
	{ .addr = 0x0f0120c10, .val = 0x0fffffff },
	{ .addr = 0x0f0120c14, .val = 0x0fffffff },
	{ .addr = 0x0f0120c18, .val = 0x0fffffff },
	{ .addr = 0x0f0120c1c, .val = 0x0fffffff },
	{ .addr = 0x0f0120c20, .val = 0x0fffffff },
	{ .addr = 0x0f0120c24, .val = 0x0fffffff },
	{ .addr = 0x0f0120c28, .val = 0x0fffffff },
	{ .addr = 0x0f0120c2c, .val = 0x0fffffff },
	{ .addr = 0x0f0120c30, .val = 0x0fffffff },
	{ .addr = 0x0f0120c34, .val = 0x0fffffff },
	{ .addr = 0x0f0120c38, .val = 0x0fffffff },
	{ .addr = 0x0f0120c3c, .val = 0x0fffffff },
	{ .addr = 0x0f0120c40, .val = 0x0fffffff },
	{ .addr = 0x0f0120c44, .val = 0x0fffffff },
	{ .addr = 0x0f0120c48, .val = 0x0fffffff },
	{ .addr = 0x0f0120c4c, .val = 0x0fffffff },
	{ .addr = 0x0f0120c50, .val = 0x0fffffff },
	{ .addr = 0x0f0120c54, .val = 0x0fffffff },
	{ .addr = 0x0f0120c58, .val = 0x0fffffff },
	{ .addr = 0x0f0120c5c, .val = 0x0fffffff },
	{ .addr = 0x0f0120c60, .val = 0x0fffffff },
	{ .addr = 0x0f0120c64, .val = 0x0fffffff },
	{ .addr = 0x0f0120c68, .val = 0x0fffffff },
	{ .addr = 0x0f0120c6c, .val = 0x0fffffff },
	{ .addr = 0x0f0120c70, .val = 0x0fffffff },
	{ .addr = 0x0f0120c74, .val = 0x0fffffff },
	{ .addr = 0x0f0120c78, .val = 0x0fffffff },
	{ .addr = 0x0f0120c7c, .val = 0x0fffffff },
	{ .addr = 0x0f0120c80, .val = 0x0007ffff },
	{ .addr = 0x0f0120c84, .val = 0x0007ffff },
	{ .addr = 0x0f0120c88, .val = 0x0007ffff },
	{ .addr = 0x0f0120c8c, .val = 0x0007ffff },
	{ .addr = 0x0f0120c90, .val = 0x0007ffff },
	{ .addr = 0x0f0120c94, .val = 0x0007ffff },
	{ .addr = 0x0f0120c98, .val = 0x0007ffff },
	{ .addr = 0x0f0120c9c, .val = 0x0007ffff },
	{ .addr = 0x0f0120ca0, .val = 0x0007ffff },
	{ .addr = 0x0f0120ca4, .val = 0x0007ffff },
	{ .addr = 0x0f0120ca8, .val = 0x0007ffff },
	{ .addr = 0x0f0120cac, .val = 0x0007ffff },
	{ .addr = 0x0f0120cb0, .val = 0x0007ffff },
	{ .addr = 0x0f0120cb4, .val = 0x0007ffff },
	{ .addr = 0x0f0120cb8, .val = 0x0007ffff },
	{ .addr = 0x0f0120cbc, .val = 0x0007ffff },
	{ .addr = 0x0f0120d00, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d04, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d08, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d0c, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d10, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d14, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d18, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d1c, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d20, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d24, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d28, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d2c, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d30, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d34, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d38, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d3c, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d40, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d44, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d48, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d4c, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d50, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d54, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d58, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d5c, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d60, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d64, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d68, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d6c, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d70, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d74, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d78, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d7c, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d80, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d84, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d88, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d8c, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d90, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d94, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d98, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120d9c, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120da0, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120da4, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120da8, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120dac, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120db0, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120db4, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120db8, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120dbc, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120dc0, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120dc4, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120dc8, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120dcc, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120dd0, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120dd4, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120dd8, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120ddc, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120de0, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120de4, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120de8, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120dec, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120df0, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120df4, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120df8, .val = 0x001fe7f9 },
	{ .addr = 0x0f0120dfc, .val = 0x001fe7f9 },
	{ .addr = 0x0f1c00004, .val = 0xc1010101 },
	{ .addr = 0x0f1c00008, .val = 0x0000003f },
	{ .addr = 0x0f1c0000c, .val = 0xffffffff },
	{ .addr = 0x0f1c00010, .val = 0xffffffff },
	{ .addr = 0x0f1c00014, .val = 0xffffffff },
	{ .addr = 0x0f1c00018, .val = 0xffffffff },
	{ .addr = 0x0f1c0001c, .val = 0xffffffff },
	{ .addr = 0x0f1c00020, .val = 0xffffffff },
	{ .addr = 0x0f1c00024, .val = 0xffffffff },
	{ .addr = 0x0f1c00028, .val = 0xffffffff },
	{ .addr = 0x0f1c0002c, .val = 0xffffffff },
	{ .addr = 0x0f1c00030, .val = 0xffffffff },
	{ .addr = 0x0f1c00034, .val = 0xffffffff },
	{ .addr = 0x0f1c00038, .val = 0xffffffff },
	{ .addr = 0x0f1c0003c, .val = 0xffffffff },
	{ .addr = 0x0f1c00040, .val = 0xffffffff },
	{ .addr = 0x0f1c00044, .val = 0xffffffff },
	{ .addr = 0x0f1c00048, .val = 0xffffffff },
	{ .addr = 0x0f1c0004c, .val = 0xffffffff },
	{ .addr = 0x0f1c00050, .val = 0xffffffff },
	{ .addr = 0x0f1c00054, .val = 0xffffffff },
	{ .addr = 0x0f1c00058, .val = 0xffffffff },
	{ .addr = 0x0f1c0005c, .val = 0xffffffff },
	{ .addr = 0x0f1c00060, .val = 0xffffffff },
	{ .addr = 0x0f1c00064, .val = 0xffffffff },
	{ .addr = 0x0f1c00068, .val = 0xffffffff },
	{ .addr = 0x0f1c0006c, .val = 0xffffffff },
	{ .addr = 0x0f1c00070, .val = 0xffffffff },
	{ .addr = 0x0f1c00074, .val = 0xffffffff },
	{ .addr = 0x0f1c00078, .val = 0xffffffff },
	{ .addr = 0x0f1c0007c, .val = 0xffffffff },
	{ .addr = 0x0f1c00080, .val = 0xffffffff },
	{ .addr = 0x0f1c00084, .val = 0xffffffff },
	{ .addr = 0x0f1c00088, .val = 0xffffffff },
	{ .addr = 0x0f1c0008c, .val = 0xffffffff },
	{ .addr = 0x0f1c00090, .val = 0xffffffff },
	{ .addr = 0x0f1c00094, .val = 0x00000011 },
	{ .addr = 0x0f1c0021c, .val = 0xffffffff },
	{ .addr = 0x0f1c00220, .val = 0xffffffff },
	{ .addr = 0x0f1c00224, .val = 0xffffffff },
	{ .addr = 0x0f1c00228, .val = 0xffffffff },
	{ .addr = 0x0f1c0022c, .val = 0xffffffff },
	{ .addr = 0x0f1c00230, .val = 0xffffffff },
	{ .addr = 0x0f1c00234, .val = 0xffffffff },
	{ .addr = 0x0f1c00238, .val = 0xffffffff },
	{ .addr = 0x0f1c0023c, .val = 0xffffffff },
	{ .addr = 0x0f1c00240, .val = 0xffffffff },
	{ .addr = 0x0f1c00244, .val = 0xffffffff },
	{ .addr = 0x0f1c00248, .val = 0xffffffff },
	{ .addr = 0x0f1c0024c, .val = 0xffffffff },
	{ .addr = 0x0f1c00250, .val = 0xffffffff },
	{ .addr = 0x0f1c00254, .val = 0xffffffff },
	{ .addr = 0x0f1c00258, .val = 0xffffffff },
	{ .addr = 0x0f1c0025c, .val = 0xffffffff },
	{ .addr = 0x0f1c00260, .val = 0xffffffff },
	{ .addr = 0x0f1c00264, .val = 0xffffffff },
	{ .addr = 0x0f1c00268, .val = 0xffffffff },
	{ .addr = 0x0f1c0026c, .val = 0xffffffff },
	{ .addr = 0x0f1c00270, .val = 0xffffffff },
	{ .addr = 0x0f1c00274, .val = 0xffffffff },
	{ .addr = 0x0f1c00278, .val = 0xffffffff },
	{ .addr = 0x0f1c0027c, .val = 0xffffffff },
	{ .addr = 0x0f1c00280, .val = 0xffffffff },
	{ .addr = 0x0f1c00284, .val = 0xffffffff },
	{ .addr = 0x0f1c00288, .val = 0xffffffff },
	{ .addr = 0x0f1c0028c, .val = 0xffffffff },
	{ .addr = 0x0f1c00290, .val = 0xffffffff },
	{ .addr = 0x0f1c00294, .val = 0xffffffff },
	{ .addr = 0x0f1c00298, .val = 0xffffffff },
	{ .addr = 0x0f1c0029c, .val = 0xffffffff },
	{ .addr = 0x0f1c002a0, .val = 0xffffffff },
	{ .addr = 0x0f1c002a4, .val = 0xffffffff },
	{ .addr = 0x0f1c002a8, .val = 0xffffffff },
	{ .addr = 0x0f1c002ac, .val = 0xffffffff },
	{ .addr = 0x0f1c002b0, .val = 0xffffffff },
	{ .addr = 0x0f1c002b4, .val = 0xffffffff },
	{ .addr = 0x0f1c002b8, .val = 0xffffffff },
	{ .addr = 0x0f1c002bc, .val = 0xffffffff },
	{ .addr = 0x0f1c002c0, .val = 0xffffffff },
	{ .addr = 0x0f1c002c4, .val = 0xffffffff },
	{ .addr = 0x0f1c002c8, .val = 0xffffffff },
	{ .addr = 0x0f1c002cc, .val = 0xffffffff },
	{ .addr = 0x0f1c002d0, .val = 0xffffffff },
	{ .addr = 0x0f1c002d4, .val = 0xffffffff },
	{ .addr = 0x0f1c002d8, .val = 0xffffffff },
	{ .addr = 0x0f1c002dc, .val = 0xffffffff },
	{ .addr = 0x0f1c002e0, .val = 0xffffffff },
	{ .addr = 0x0f1c002e4, .val = 0xffffffff },
	{ .addr = 0x0f1c002e8, .val = 0xffffffff },
	{ .addr = 0x0f1c002ec, .val = 0xffffffff },
	{ .addr = 0x0f1c002f0, .val = 0xffffffff },
	{ .addr = 0x0f1c002f4, .val = 0xffffffff },
	{ .addr = 0x0f1c002f8, .val = 0xffffffff },
	{ .addr = 0x0f1c002fc, .val = 0xffffffff },
	{ .addr = 0x0f1c00300, .val = 0xffffffff },
	{ .addr = 0x0f1c00304, .val = 0xffffffff },
	{ .addr = 0x0f1c00308, .val = 0xffffffff },
	{ .addr = 0x0f1c0030c, .val = 0xffffffff },
	{ .addr = 0x0f1c00310, .val = 0xffffffff },
	{ .addr = 0x0f1c00314, .val = 0xffffffff },
	{ .addr = 0x0f1c00318, .val = 0xffffffff },
	{ .addr = 0x0f1c0031c, .val = 0xffffffff },
	{ .addr = 0x0f1c00320, .val = 0xffffffff },
	{ .addr = 0x0f1c00324, .val = 0xffffffff },
	{ .addr = 0x0f1c00328, .val = 0x000fffff },
	{ .addr = 0x0f1c0032c, .val = 0x00000111 },
	{ .addr = 0x0f1c00330, .val = 0x83030301 },
	{ .addr = 0x0f1c00338, .val = 0xffffffff },
	{ .addr = 0x0f1c0033c, .val = 0xffffffff },
	{ .addr = 0x0f1c00340, .val = 0xffffffff },
	{ .addr = 0x0f1c00344, .val = 0xffffffff },
	{ .addr = 0x0f1800000, .val = 0xc0000707 },
	{ .addr = 0x0f1800004, .val = 0x00003fff },
	{ .addr = 0x0f1800008, .val = 0x0fff0fff },
	{ .addr = 0x0f180000c, .val = 0x0fff0fff },
	{ .addr = 0x0f1800010, .val = 0xffffffff },
	{ .addr = 0x0f1800014, .val = 0xffffffff },
	{ .addr = 0x0f1800018, .val = 0xffffffff },
	{ .addr = 0x0f180001c, .val = 0xffffffff },
	{ .addr = 0x0f180002c, .val = 0xffffffff },
	{ .addr = 0x0f1800030, .val = 0xffffffff },
	{ .addr = 0x0f1800034, .val = 0xffffffff },
	{ .addr = 0x0f1800044, .val = 0xffffffff },
	{ .addr = 0x0f1800048, .val = 0xffffffff },
	{ .addr = 0x0f180004c, .val = 0xffffffff },
	{ .addr = 0x0f180005c, .val = 0xffffffff },
	{ .addr = 0x0f1800060, .val = 0xffffffff },
	{ .addr = 0x0f1800064, .val = 0xffffffff },
	{ .addr = 0x0f1800074, .val = 0x00ffffff },
	{ .addr = 0x0f1800078, .val = 0xffffffff },
	{ .addr = 0x0f180007c, .val = 0xffffffff },
	{ .addr = 0x0f1800080, .val = 0xffffffff },
	{ .addr = 0x0f18000ac, .val = 0x00000001 },
	{ .addr = 0x0f1800100, .val = 0x00018101 },
	{ .addr = 0x0f1800104, .val = 0x0f0f0f0f },
	{ .addr = 0x0f1800108, .val = 0x00003fff },
	{ .addr = 0x0f180010c, .val = 0x0007ffff },
	{ .addr = 0x0f1800118, .val = 0x8001ffff },
	{ .addr = 0x0f1d00008, .val = 0x00010011 },
	{ .addr = 0x0f1d00010, .val = 0xffffffff },
	{ .addr = 0x0f1d00014, .val = 0xffffffff },
	{ .addr = 0x0f1d0002c, .val = 0x000000ff },
	{ .addr = 0x0f1d00030, .val = 0xffffffff },
	{ .addr = 0x0f1d00034, .val = 0xffffffff },
	{ .addr = 0x0f1d00038, .val = 0xffffffff },
	{ .addr = 0x0f1d0003c, .val = 0xffffffff },
	{ .addr = 0x0f1d00040, .val = 0xffffffff },
	{ .addr = 0x0f1d00044, .val = 0xffffffff },
	{ .addr = 0x0f1d00048, .val = 0xffffffff },
	{ .addr = 0x0f1d0004c, .val = 0xffffffff },
	{ .addr = 0x0f1d00050, .val = 0xffffffff },
	{ .addr = 0x0f1d00054, .val = 0xffffffff },
	{ .addr = 0x0f1d00058, .val = 0xffffffff },
	{ .addr = 0x0f1d0005c, .val = 0xffffffff },
	{ .addr = 0x0f1d00060, .val = 0xffffffff },
	{ .addr = 0x0f1d00064, .val = 0xffffffff },
	{ .addr = 0x0f1d00068, .val = 0xffffffff },
	{ .addr = 0x0f1d0006c, .val = 0xffffffff },
	{ .addr = 0x0f1e00c08, .val = 0x00010011 },
	{ .addr = 0x0f1e00c10, .val = 0xffffffff },
	{ .addr = 0x0f1e00c14, .val = 0xffffffff },
	{ .addr = 0x0f1e00c2c, .val = 0x000000ff },
	{ .addr = 0x0f1e00c30, .val = 0xffffffff },
	{ .addr = 0x0f1e00c34, .val = 0xffffffff },
	{ .addr = 0x0f1e00c38, .val = 0xffffffff },
	{ .addr = 0x0f1e00c3c, .val = 0xffffffff },
	{ .addr = 0x0f1e00c40, .val = 0xffffffff },
	{ .addr = 0x0f1e00c44, .val = 0xffffffff },
	{ .addr = 0x0f1e00c48, .val = 0xffffffff },
	{ .addr = 0x0f1e00c4c, .val = 0xffffffff },
	{ .addr = 0x0f1e00c50, .val = 0xffffffff },
	{ .addr = 0x0f1e00c54, .val = 0xffffffff },
	{ .addr = 0x0f1e00c58, .val = 0xffffffff },
	{ .addr = 0x0f1e00c5c, .val = 0xffffffff },
	{ .addr = 0x0f1e00c60, .val = 0xffffffff },
	{ .addr = 0x0f1e00c64, .val = 0xffffffff },
	{ .addr = 0x0f1e00c68, .val = 0xffffffff },
	{ .addr = 0x0f1e00c6c, .val = 0xffffffff },
	{ .addr = 0x0f2000000, .val = 0x000001ff },
	{ .addr = 0x0f2000004, .val = 0x0000ffff },
	{ .addr = 0x0f2000008, .val = 0x0000ffff },
	{ .addr = 0x0f200000c, .val = 0x0000ffff },
	{ .addr = 0x0f2000010, .val = 0x0000ffff },
	{ .addr = 0x0f2000014, .val = 0x0000ffff },
	{ .addr = 0x0f2000018, .val = 0x0000ffff },
	{ .addr = 0x0f200001c, .val = 0x0000ffff },
	{ .addr = 0x0f2000020, .val = 0x0000ffff },
	{ .addr = 0x0f2000024, .val = 0x0000ffff },
	{ .addr = 0x0f2000028, .val = 0x0000ffff },
	{ .addr = 0x0f200002c, .val = 0x0000ffff },
	{ .addr = 0x0f2000030, .val = 0x0000ffff },
	{ .addr = 0x0f2000034, .val = 0x0000ffff },
	{ .addr = 0x0f2000038, .val = 0x0000ffff },
	{ .addr = 0x0f200003c, .val = 0x0000ffff },
	{ .addr = 0x0f2000040, .val = 0x0000ffff },
	{ .addr = 0x0f2000044, .val = 0x0000ffff },
	{ .addr = 0x0f2000048, .val = 0x0000ffff },
	{ .addr = 0x0f0006004, .val = 0xffffffff },
	{ .addr = 0x0f0006008, .val = 0xffffffff },
	{ .addr = 0x0f000600c, .val = 0xffffffff },
	{ .addr = 0x0f0006010, .val = 0xffffffff },
	{ .addr = 0x0f0006014, .val = 0xffffffff },
	{ .addr = 0x0f0006020, .val = 0x000007ff },
	{ .addr = 0x0f0006024, .val = 0x000ff0f1 },
	{ .addr = 0x0f0006028, .val = 0x00000001 },
	{ .addr = 0x0f000602c, .val = 0x0000ffff },
	{ .addr = 0x0f0006030, .val = 0x0000ffff },
	{ .addr = 0x0f0006034, .val = 0x0000ffff },
	{ .addr = 0x0f0006038, .val = 0x0000ffff },
	{ .addr = 0x0f0006040, .val = 0xfbff03ff },
	{ .addr = 0x0f0006044, .val = 0xfbff03ff },
	{ .addr = 0x0f0006048, .val = 0xfbff03ff },
	{ .addr = 0x0f000604c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006050, .val = 0xfbff03ff },
	{ .addr = 0x0f0006054, .val = 0xfbff03ff },
	{ .addr = 0x0f0006058, .val = 0xfbff03ff },
	{ .addr = 0x0f000605c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006060, .val = 0xfbff03ff },
	{ .addr = 0x0f0006064, .val = 0xfbff03ff },
	{ .addr = 0x0f0006068, .val = 0xfbff03ff },
	{ .addr = 0x0f000606c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006070, .val = 0xfbff03ff },
	{ .addr = 0x0f0006074, .val = 0xfbff03ff },
	{ .addr = 0x0f0006078, .val = 0xfbff03ff },
	{ .addr = 0x0f000607c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006080, .val = 0xfbff03ff },
	{ .addr = 0x0f0006084, .val = 0xfbff03ff },
	{ .addr = 0x0f0006088, .val = 0xfbff03ff },
	{ .addr = 0x0f000608c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006090, .val = 0xfbff03ff },
	{ .addr = 0x0f0006094, .val = 0xfbff03ff },
	{ .addr = 0x0f0006098, .val = 0xfbff03ff },
	{ .addr = 0x0f000609c, .val = 0xfbff03ff },
	{ .addr = 0x0f00060a0, .val = 0xfbff03ff },
	{ .addr = 0x0f00060a4, .val = 0xfbff03ff },
	{ .addr = 0x0f00060a8, .val = 0xfbff03ff },
	{ .addr = 0x0f00060ac, .val = 0xfbff03ff },
	{ .addr = 0x0f00060b0, .val = 0xfbff03ff },
	{ .addr = 0x0f00060b4, .val = 0xfbff03ff },
	{ .addr = 0x0f00060b8, .val = 0xfbff03ff },
	{ .addr = 0x0f00060bc, .val = 0xfbff03ff },
	{ .addr = 0x0f00060c0, .val = 0xfbff03ff },
	{ .addr = 0x0f00060c4, .val = 0xfbff03ff },
	{ .addr = 0x0f00060c8, .val = 0xfbff03ff },
	{ .addr = 0x0f00060cc, .val = 0xfbff03ff },
	{ .addr = 0x0f00060d0, .val = 0xfbff03ff },
	{ .addr = 0x0f00060d4, .val = 0xfbff03ff },
	{ .addr = 0x0f00060d8, .val = 0xfbff03ff },
	{ .addr = 0x0f00060dc, .val = 0xfbff03ff },
	{ .addr = 0x0f00060e0, .val = 0xfbff03ff },
	{ .addr = 0x0f00060e4, .val = 0xfbff03ff },
	{ .addr = 0x0f00060e8, .val = 0xfbff03ff },
	{ .addr = 0x0f00060ec, .val = 0xfbff03ff },
	{ .addr = 0x0f00060f0, .val = 0xfbff03ff },
	{ .addr = 0x0f00060f4, .val = 0xfbff03ff },
	{ .addr = 0x0f00060f8, .val = 0xfbff03ff },
	{ .addr = 0x0f00060fc, .val = 0xfbff03ff },
	{ .addr = 0x0f0006100, .val = 0xfbff03ff },
	{ .addr = 0x0f0006104, .val = 0xfbff03ff },
	{ .addr = 0x0f0006108, .val = 0xfbff03ff },
	{ .addr = 0x0f000610c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006110, .val = 0xfbff03ff },
	{ .addr = 0x0f0006114, .val = 0xfbff03ff },
	{ .addr = 0x0f0006118, .val = 0xfbff03ff },
	{ .addr = 0x0f000611c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006120, .val = 0xfbff03ff },
	{ .addr = 0x0f0006124, .val = 0xfbff03ff },
	{ .addr = 0x0f0006128, .val = 0xfbff03ff },
	{ .addr = 0x0f000612c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006130, .val = 0xfbff03ff },
	{ .addr = 0x0f0006134, .val = 0xfbff03ff },
	{ .addr = 0x0f0006138, .val = 0xfbff03ff },
	{ .addr = 0x0f000613c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006140, .val = 0xfbff03ff },
	{ .addr = 0x0f0006144, .val = 0xfbff03ff },
	{ .addr = 0x0f0006148, .val = 0xfbff03ff },
	{ .addr = 0x0f000614c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006150, .val = 0xfbff03ff },
	{ .addr = 0x0f0006154, .val = 0xfbff03ff },
	{ .addr = 0x0f0006158, .val = 0xfbff03ff },
	{ .addr = 0x0f000615c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006160, .val = 0xfbff03ff },
	{ .addr = 0x0f0006164, .val = 0xfbff03ff },
	{ .addr = 0x0f0006168, .val = 0xfbff03ff },
	{ .addr = 0x0f000616c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006170, .val = 0xfbff03ff },
	{ .addr = 0x0f0006174, .val = 0xfbff03ff },
	{ .addr = 0x0f0006178, .val = 0xfbff03ff },
	{ .addr = 0x0f000617c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006180, .val = 0xfbff03ff },
	{ .addr = 0x0f0006184, .val = 0xfbff03ff },
	{ .addr = 0x0f0006188, .val = 0xfbff03ff },
	{ .addr = 0x0f000618c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006190, .val = 0xfbff03ff },
	{ .addr = 0x0f0006194, .val = 0xfbff03ff },
	{ .addr = 0x0f0006198, .val = 0xfbff03ff },
	{ .addr = 0x0f000619c, .val = 0xfbff03ff },
	{ .addr = 0x0f00061a0, .val = 0xfbff03ff },
	{ .addr = 0x0f00061a4, .val = 0xfbff03ff },
	{ .addr = 0x0f00061a8, .val = 0xfbff03ff },
	{ .addr = 0x0f00061ac, .val = 0xfbff03ff },
	{ .addr = 0x0f00061b0, .val = 0xfbff03ff },
	{ .addr = 0x0f00061b4, .val = 0xfbff03ff },
	{ .addr = 0x0f00061b8, .val = 0xfbff03ff },
	{ .addr = 0x0f00061bc, .val = 0xfbff03ff },
	{ .addr = 0x0f00061c0, .val = 0xfbff03ff },
	{ .addr = 0x0f00061c4, .val = 0xfbff03ff },
	{ .addr = 0x0f00061c8, .val = 0xfbff03ff },
	{ .addr = 0x0f00061cc, .val = 0xfbff03ff },
	{ .addr = 0x0f00061d0, .val = 0xfbff03ff },
	{ .addr = 0x0f00061d4, .val = 0xfbff03ff },
	{ .addr = 0x0f00061d8, .val = 0xfbff03ff },
	{ .addr = 0x0f00061dc, .val = 0xfbff03ff },
	{ .addr = 0x0f00061e0, .val = 0xfbff03ff },
	{ .addr = 0x0f00061e4, .val = 0xfbff03ff },
	{ .addr = 0x0f00061e8, .val = 0xfbff03ff },
	{ .addr = 0x0f00061ec, .val = 0xfbff03ff },
	{ .addr = 0x0f00061f0, .val = 0xfbff03ff },
	{ .addr = 0x0f00061f4, .val = 0xfbff03ff },
	{ .addr = 0x0f00061f8, .val = 0xfbff03ff },
	{ .addr = 0x0f00061fc, .val = 0xfbff03ff },
	{ .addr = 0x0f0006200, .val = 0xfbff03ff },
	{ .addr = 0x0f0006204, .val = 0xfbff03ff },
	{ .addr = 0x0f0006208, .val = 0xfbff03ff },
	{ .addr = 0x0f000620c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006210, .val = 0xfbff03ff },
	{ .addr = 0x0f0006214, .val = 0xfbff03ff },
	{ .addr = 0x0f0006218, .val = 0xfbff03ff },
	{ .addr = 0x0f000621c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006220, .val = 0xfbff03ff },
	{ .addr = 0x0f0006224, .val = 0xfbff03ff },
	{ .addr = 0x0f0006228, .val = 0xfbff03ff },
	{ .addr = 0x0f000622c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006230, .val = 0xfbff03ff },
	{ .addr = 0x0f0006234, .val = 0xfbff03ff },
	{ .addr = 0x0f0006238, .val = 0xfbff03ff },
	{ .addr = 0x0f000623c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006240, .val = 0xfbff03ff },
	{ .addr = 0x0f0006244, .val = 0xfbff03ff },
	{ .addr = 0x0f0006248, .val = 0xfbff03ff },
	{ .addr = 0x0f000624c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006250, .val = 0xfbff03ff },
	{ .addr = 0x0f0006254, .val = 0xfbff03ff },
	{ .addr = 0x0f0006258, .val = 0xfbff03ff },
	{ .addr = 0x0f000625c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006260, .val = 0xfbff03ff },
	{ .addr = 0x0f0006264, .val = 0xfbff03ff },
	{ .addr = 0x0f0006268, .val = 0xfbff03ff },
	{ .addr = 0x0f000626c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006270, .val = 0xfbff03ff },
	{ .addr = 0x0f0006274, .val = 0xfbff03ff },
	{ .addr = 0x0f0006278, .val = 0xfbff03ff },
	{ .addr = 0x0f000627c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006280, .val = 0xfbff03ff },
	{ .addr = 0x0f0006284, .val = 0xfbff03ff },
	{ .addr = 0x0f0006288, .val = 0xfbff03ff },
	{ .addr = 0x0f000628c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006290, .val = 0xfbff03ff },
	{ .addr = 0x0f0006294, .val = 0xfbff03ff },
	{ .addr = 0x0f0006298, .val = 0xfbff03ff },
	{ .addr = 0x0f000629c, .val = 0xfbff03ff },
	{ .addr = 0x0f00062a0, .val = 0xfbff03ff },
	{ .addr = 0x0f00062a4, .val = 0xfbff03ff },
	{ .addr = 0x0f00062a8, .val = 0xfbff03ff },
	{ .addr = 0x0f00062ac, .val = 0xfbff03ff },
	{ .addr = 0x0f00062b0, .val = 0xfbff03ff },
	{ .addr = 0x0f00062b4, .val = 0xfbff03ff },
	{ .addr = 0x0f00062b8, .val = 0xfbff03ff },
	{ .addr = 0x0f00062bc, .val = 0xfbff03ff },
	{ .addr = 0x0f00062c0, .val = 0xfbff03ff },
	{ .addr = 0x0f00062c4, .val = 0xfbff03ff },
	{ .addr = 0x0f00062c8, .val = 0xfbff03ff },
	{ .addr = 0x0f00062cc, .val = 0xfbff03ff },
	{ .addr = 0x0f00062d0, .val = 0xfbff03ff },
	{ .addr = 0x0f00062d4, .val = 0xfbff03ff },
	{ .addr = 0x0f00062d8, .val = 0xfbff03ff },
	{ .addr = 0x0f00062dc, .val = 0xfbff03ff },
	{ .addr = 0x0f00062e0, .val = 0xfbff03ff },
	{ .addr = 0x0f00062e4, .val = 0xfbff03ff },
	{ .addr = 0x0f00062e8, .val = 0xfbff03ff },
	{ .addr = 0x0f00062ec, .val = 0xfbff03ff },
	{ .addr = 0x0f00062f0, .val = 0xfbff03ff },
	{ .addr = 0x0f00062f4, .val = 0xfbff03ff },
	{ .addr = 0x0f00062f8, .val = 0xfbff03ff },
	{ .addr = 0x0f00062fc, .val = 0xfbff03ff },
	{ .addr = 0x0f0006300, .val = 0xfbff03ff },
	{ .addr = 0x0f0006304, .val = 0xfbff03ff },
	{ .addr = 0x0f0006308, .val = 0xfbff03ff },
	{ .addr = 0x0f000630c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006310, .val = 0xfbff03ff },
	{ .addr = 0x0f0006314, .val = 0xfbff03ff },
	{ .addr = 0x0f0006318, .val = 0xfbff03ff },
	{ .addr = 0x0f000631c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006320, .val = 0xfbff03ff },
	{ .addr = 0x0f0006324, .val = 0xfbff03ff },
	{ .addr = 0x0f0006328, .val = 0xfbff03ff },
	{ .addr = 0x0f000632c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006330, .val = 0xfbff03ff },
	{ .addr = 0x0f0006334, .val = 0xfbff03ff },
	{ .addr = 0x0f0006338, .val = 0xfbff03ff },
	{ .addr = 0x0f000633c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006340, .val = 0xfbff03ff },
	{ .addr = 0x0f0006344, .val = 0xfbff03ff },
	{ .addr = 0x0f0006348, .val = 0xfbff03ff },
	{ .addr = 0x0f000634c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006350, .val = 0xfbff03ff },
	{ .addr = 0x0f0006354, .val = 0xfbff03ff },
	{ .addr = 0x0f0006358, .val = 0xfbff03ff },
	{ .addr = 0x0f000635c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006360, .val = 0xfbff03ff },
	{ .addr = 0x0f0006364, .val = 0xfbff03ff },
	{ .addr = 0x0f0006368, .val = 0xfbff03ff },
	{ .addr = 0x0f000636c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006370, .val = 0xfbff03ff },
	{ .addr = 0x0f0006374, .val = 0xfbff03ff },
	{ .addr = 0x0f0006378, .val = 0xfbff03ff },
	{ .addr = 0x0f000637c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006380, .val = 0xfbff03ff },
	{ .addr = 0x0f0006384, .val = 0xfbff03ff },
	{ .addr = 0x0f0006388, .val = 0xfbff03ff },
	{ .addr = 0x0f000638c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006390, .val = 0xfbff03ff },
	{ .addr = 0x0f0006394, .val = 0xfbff03ff },
	{ .addr = 0x0f0006398, .val = 0xfbff03ff },
	{ .addr = 0x0f000639c, .val = 0xfbff03ff },
	{ .addr = 0x0f00063a0, .val = 0xfbff03ff },
	{ .addr = 0x0f00063a4, .val = 0xfbff03ff },
	{ .addr = 0x0f00063a8, .val = 0xfbff03ff },
	{ .addr = 0x0f00063ac, .val = 0xfbff03ff },
	{ .addr = 0x0f00063b0, .val = 0xfbff03ff },
	{ .addr = 0x0f00063b4, .val = 0xfbff03ff },
	{ .addr = 0x0f00063b8, .val = 0xfbff03ff },
	{ .addr = 0x0f00063bc, .val = 0xfbff03ff },
	{ .addr = 0x0f00063c0, .val = 0xfbff03ff },
	{ .addr = 0x0f00063c4, .val = 0xfbff03ff },
	{ .addr = 0x0f00063c8, .val = 0xfbff03ff },
	{ .addr = 0x0f00063cc, .val = 0xfbff03ff },
	{ .addr = 0x0f00063d0, .val = 0xfbff03ff },
	{ .addr = 0x0f00063d4, .val = 0xfbff03ff },
	{ .addr = 0x0f00063d8, .val = 0xfbff03ff },
	{ .addr = 0x0f00063dc, .val = 0xfbff03ff },
	{ .addr = 0x0f00063e0, .val = 0xfbff03ff },
	{ .addr = 0x0f00063e4, .val = 0xfbff03ff },
	{ .addr = 0x0f00063e8, .val = 0xfbff03ff },
	{ .addr = 0x0f00063ec, .val = 0xfbff03ff },
	{ .addr = 0x0f00063f0, .val = 0xfbff03ff },
	{ .addr = 0x0f00063f4, .val = 0xfbff03ff },
	{ .addr = 0x0f00063f8, .val = 0xfbff03ff },
	{ .addr = 0x0f00063fc, .val = 0xfbff03ff },
	{ .addr = 0x0f0006400, .val = 0xfbff03ff },
	{ .addr = 0x0f0006404, .val = 0xfbff03ff },
	{ .addr = 0x0f0006408, .val = 0xfbff03ff },
	{ .addr = 0x0f000640c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006410, .val = 0xfbff03ff },
	{ .addr = 0x0f0006414, .val = 0xfbff03ff },
	{ .addr = 0x0f0006418, .val = 0xfbff03ff },
	{ .addr = 0x0f000641c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006420, .val = 0xfbff03ff },
	{ .addr = 0x0f0006424, .val = 0xfbff03ff },
	{ .addr = 0x0f0006428, .val = 0xfbff03ff },
	{ .addr = 0x0f000642c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006430, .val = 0xfbff03ff },
	{ .addr = 0x0f0006434, .val = 0xfbff03ff },
	{ .addr = 0x0f0006438, .val = 0xfbff03ff },
	{ .addr = 0x0f000643c, .val = 0xfbff03ff },
	{ .addr = 0x0f0006534, .val = 0xffffffff },
	{ .addr = 0x0f000694c, .val = 0x9f81ffff },
	{ .addr = 0x0f000695c, .val = 0xffffffff },
	{ .addr = 0x0f0006960, .val = 0xffffffff },
	{ .addr = 0x0f0006964, .val = 0xffffffff },
	{ .addr = 0x0f0006968, .val = 0xffffffff },
	{ .addr = 0x0f000696c, .val = 0x0000000f },
	{ .addr = 0x0f0006970, .val = 0xffffffff },
	{ .addr = 0x0f0006974, .val = 0xffffffff },
	{ .addr = 0x0f0006978, .val = 0xffffffff },
	{ .addr = 0x0f000697c, .val = 0x00000003 },
	{ .addr = 0x0f0006990, .val = 0x00007fff },
	{ .addr = 0x0f1000000, .val = 0x0000ffff },
	{ .addr = 0x0f1000004, .val = 0x0000ffff },
	{ .addr = 0x0f1000008, .val = 0x0000ffff },
	{ .addr = 0x0f100000c, .val = 0x0000ffff },
	{ .addr = 0x0f1000010, .val = 0x0000ffff },
	{ .addr = 0x0f1000014, .val = 0x0000ffff },
	{ .addr = 0x0f1000018, .val = 0x0000ffff },
	{ .addr = 0x0f100001c, .val = 0x0000ffff },
	{ .addr = 0x0f1000020, .val = 0x0000ffff },
	{ .addr = 0x0f1000024, .val = 0x0000ffff },
	{ .addr = 0x0f1000028, .val = 0x0000ffff },
	{ .addr = 0x0f100002c, .val = 0x0000ffff },
	{ .addr = 0x0f1000030, .val = 0x0000ffff },
	{ .addr = 0x0f1000034, .val = 0x0000ffff },
	{ .addr = 0x0f1000038, .val = 0x0000ffff },
	{ .addr = 0x0f100003c, .val = 0x0000ffff },
	{ .addr = 0x0f1000040, .val = 0x000001ff },
	{ .addr = 0x0f1000044, .val = 0xffffffff },
	{ .addr = 0x0f1000080, .val = 0x00000007 },
	{ .addr = 0x0f10000ac, .val = 0x000003ff },
	{ .addr = 0x0f10000fc, .val = 0x1fffff37 },
	{ .addr = 0x0f1000100, .val = 0x1fffff37 },
	{ .addr = 0x0f1000104, .val = 0x1fffff37 },
	{ .addr = 0x0f1000108, .val = 0x1fffff37 },
	{ .addr = 0x0f100010c, .val = 0x1fffff37 },
	{ .addr = 0x0f1000110, .val = 0x1fffff37 },
	{ .addr = 0x0f1000114, .val = 0x1fffff37 },
	{ .addr = 0x0f1000118, .val = 0x1fffff37 },
	{ .addr = 0x0f100011c, .val = 0x1fffff37 },
	{ .addr = 0x0f1000120, .val = 0x1fffff37 },
	{ .addr = 0x0f1000124, .val = 0x1fffff37 },
	{ .addr = 0x0f1000128, .val = 0x1fffff37 },
	{ .addr = 0x0f100012c, .val = 0x1fffff37 },
	{ .addr = 0x0f1000130, .val = 0x1fffff37 },
	{ .addr = 0x0f1000134, .val = 0x1fffff37 },
	{ .addr = 0x0f1000138, .val = 0x1fffff37 },
	{ .addr = 0x0f100013c, .val = 0x0000000f },
	{ .addr = 0x0f1000140, .val = 0xffffffff },
	{ .addr = 0x0f1000144, .val = 0x0003ffff },
	{ .addr = 0x0f1000148, .val = 0xffffffff },
	{ .addr = 0x0f100014c, .val = 0x000007ff },
	{ .addr = 0x0f1000154, .val = 0x0000007f },
	{ .addr = 0x0f1000158, .val = 0x000003ff },
	{ .addr = 0x0f1000200, .val = 0x000f133f },
	{ .addr = 0x0f1000204, .val = 0x000f133f },
	{ .addr = 0x0f1000210, .val = 0x000f133f },
	{ .addr = 0x0f1000214, .val = 0x000f133f },
	{ .addr = 0x0f1000218, .val = 0x000f133f },
	{ .addr = 0x0f1000240, .val = 0x00000003 },
	{ .addr = 0x0f1000244, .val = 0x00000003 },
	{ .addr = 0x0f1000248, .val = 0x00000003 },
	{ .addr = 0x0f100024c, .val = 0x00000003 },
	{ .addr = 0x0f1000250, .val = 0x00000003 },
	{ .addr = 0x0f1000254, .val = 0x00000003 },
	{ .addr = 0x0f1000258, .val = 0x00000003 },
	{ .addr = 0x0f100025c, .val = 0x00000003 },
	{ .addr = 0x0f1000260, .val = 0x00000003 },
	{ .addr = 0x0f1000264, .val = 0x00000003 },
	{ .addr = 0x0f1000268, .val = 0x00000003 },
	{ .addr = 0x0f100026c, .val = 0x00000003 },
	{ .addr = 0x0f1000270, .val = 0x00000003 },
	{ .addr = 0x0f1000274, .val = 0x00000003 },
	{ .addr = 0x0f1000278, .val = 0x00000003 },
	{ .addr = 0x0f100027c, .val = 0x00000003 },
	{ .addr = 0x0f1000280, .val = 0x8000ffff },
	{ .addr = 0x0f1000284, .val = 0x8000ffff },
	{ .addr = 0x0f1000288, .val = 0x8000ffff },
	{ .addr = 0x0f100028c, .val = 0x8000ffff },
	{ .addr = 0x0f1000290, .val = 0x8000ffff },
	{ .addr = 0x0f1000294, .val = 0x8000ffff },
	{ .addr = 0x0f1000298, .val = 0x8000ffff },
	{ .addr = 0x0f100029c, .val = 0x8000ffff },
	{ .addr = 0x0f10002a0, .val = 0x8000ffff },
	{ .addr = 0x0f10002a4, .val = 0x8000ffff },
	{ .addr = 0x0f10002a8, .val = 0x8000ffff },
	{ .addr = 0x0f10002ac, .val = 0x8000ffff },
	{ .addr = 0x0f10002b0, .val = 0x8000ffff },
	{ .addr = 0x0f10002b4, .val = 0x8000ffff },
	{ .addr = 0x0f10002b8, .val = 0x8000ffff },
	{ .addr = 0x0f10002bc, .val = 0x8000ffff },
	{ .addr = 0x0f10002c0, .val = 0x00000003 },
	{ .addr = 0x0f10002c4, .val = 0x00000003 },
	{ .addr = 0x0f10002c8, .val = 0x00000003 },
	{ .addr = 0x0f10002cc, .val = 0x00000003 },
	{ .addr = 0x0f10002d0, .val = 0x00000003 },
	{ .addr = 0x0f10002d4, .val = 0x00000003 },
	{ .addr = 0x0f10002d8, .val = 0x00000003 },
	{ .addr = 0x0f10002dc, .val = 0x00000003 },
	{ .addr = 0x0f10002e0, .val = 0x00000003 },
	{ .addr = 0x0f10002e4, .val = 0x00000003 },
	{ .addr = 0x0f10002e8, .val = 0x00000003 },
	{ .addr = 0x0f10002ec, .val = 0x00000003 },
	{ .addr = 0x0f10002f0, .val = 0x00000003 },
	{ .addr = 0x0f10002f4, .val = 0x00000003 },
	{ .addr = 0x0f10002f8, .val = 0x00000003 },
	{ .addr = 0x0f10002fc, .val = 0x00000003 },
	{ .addr = 0x0f1000300, .val = 0x00000003 },
	{ .addr = 0x0f1000304, .val = 0x00000003 },
	{ .addr = 0x0f1000308, .val = 0x00000003 },
	{ .addr = 0x0f100030c, .val = 0x00000003 },
	{ .addr = 0x0f1000310, .val = 0x00000003 },
	{ .addr = 0x0f1000314, .val = 0x00000003 },
	{ .addr = 0x0f1000318, .val = 0x00000003 },
	{ .addr = 0x0f100031c, .val = 0x00000003 },
	{ .addr = 0x0f1000320, .val = 0x00000003 },
	{ .addr = 0x0f1000324, .val = 0x00000003 },
	{ .addr = 0x0f1000328, .val = 0x00000003 },
	{ .addr = 0x0f100032c, .val = 0x00000003 },
	{ .addr = 0x0f1000330, .val = 0x00000003 },
	{ .addr = 0x0f1000334, .val = 0x00000003 },
	{ .addr = 0x0f1000338, .val = 0x00000003 },
	{ .addr = 0x0f100033c, .val = 0x00000003 },
	{ .addr = 0x0f1000340, .val = 0x00000003 },
	{ .addr = 0x0f1000344, .val = 0x00000003 },
	{ .addr = 0x0f1000348, .val = 0x00000003 },
	{ .addr = 0x0f100034c, .val = 0x00000003 },
	{ .addr = 0x0f1000350, .val = 0x00000003 },
	{ .addr = 0x0f1000354, .val = 0x00000003 },
	{ .addr = 0x0f1000358, .val = 0x00000003 },
	{ .addr = 0x0f100035c, .val = 0x00000003 },
	{ .addr = 0x0f1000360, .val = 0x00000003 },
	{ .addr = 0x0f1000364, .val = 0x00000003 },
	{ .addr = 0x0f1000368, .val = 0x00000003 },
	{ .addr = 0x0f100036c, .val = 0x00000003 },
	{ .addr = 0x0f1000370, .val = 0x00000003 },
	{ .addr = 0x0f1000374, .val = 0x00000003 },
	{ .addr = 0x0f1000378, .val = 0x00000003 },
	{ .addr = 0x0f100037c, .val = 0x00000003 },
	{ .addr = 0x0f1000380, .val = 0x00000003 },
	{ .addr = 0x0f1000384, .val = 0x00000003 },
	{ .addr = 0x0f1000388, .val = 0x00000003 },
	{ .addr = 0x0f100038c, .val = 0x00000003 },
	{ .addr = 0x0f1000390, .val = 0x00000003 },
	{ .addr = 0x0f1000394, .val = 0x00000003 },
	{ .addr = 0x0f1000398, .val = 0x00000003 },
	{ .addr = 0x0f100039c, .val = 0x00000003 },
	{ .addr = 0x0f10003a0, .val = 0x00000003 },
	{ .addr = 0x0f10003a4, .val = 0x00000003 },
	{ .addr = 0x0f10003a8, .val = 0x00000003 },
	{ .addr = 0x0f10003ac, .val = 0x00000003 },
	{ .addr = 0x0f10003b0, .val = 0x00000003 },
	{ .addr = 0x0f10003b4, .val = 0x00000003 },
	{ .addr = 0x0f10003b8, .val = 0x00000003 },
	{ .addr = 0x0f10003bc, .val = 0x00000003 },
	{ .addr = 0x0f10003c0, .val = 0x00000003 },
	{ .addr = 0x0f10003c4, .val = 0x00000003 },
	{ .addr = 0x0f10003c8, .val = 0x00000003 },
	{ .addr = 0x0f10003cc, .val = 0x00000003 },
	{ .addr = 0x0f10003d0, .val = 0x00000003 },
	{ .addr = 0x0f10003d4, .val = 0x00000003 },
	{ .addr = 0x0f10003d8, .val = 0x00000003 },
	{ .addr = 0x0f10003dc, .val = 0x00000003 },
	{ .addr = 0x0f10003e0, .val = 0x00000003 },
	{ .addr = 0x0f10003e4, .val = 0x00000003 },
	{ .addr = 0x0f10003e8, .val = 0x00000003 },
	{ .addr = 0x0f10003ec, .val = 0x00000003 },
	{ .addr = 0x0f10003f0, .val = 0x00000003 },
	{ .addr = 0x0f10003f4, .val = 0x00000003 },
	{ .addr = 0x0f10003f8, .val = 0x00000003 },
	{ .addr = 0x0f10003fc, .val = 0x00000003 },
	{ .addr = 0x0f1000400, .val = 0x00000003 },
	{ .addr = 0x0f1000404, .val = 0x00000003 },
	{ .addr = 0x0f1000408, .val = 0x00000003 },
	{ .addr = 0x0f100040c, .val = 0x00000003 },
	{ .addr = 0x0f1000410, .val = 0x00000003 },
	{ .addr = 0x0f1000414, .val = 0x00000003 },
	{ .addr = 0x0f1000418, .val = 0x00000003 },
	{ .addr = 0x0f100041c, .val = 0x00000003 },
	{ .addr = 0x0f1000420, .val = 0x00000003 },
	{ .addr = 0x0f1000424, .val = 0x00000003 },
	{ .addr = 0x0f1000428, .val = 0x00000003 },
	{ .addr = 0x0f100042c, .val = 0x00000003 },
	{ .addr = 0x0f1000430, .val = 0x00000003 },
	{ .addr = 0x0f1000434, .val = 0x00000003 },
	{ .addr = 0x0f1000438, .val = 0x00000003 },
	{ .addr = 0x0f100043c, .val = 0x00000003 },
	{ .addr = 0x0f1000440, .val = 0x00000003 },
	{ .addr = 0x0f1000444, .val = 0x00000003 },
	{ .addr = 0x0f1000448, .val = 0x00000003 },
	{ .addr = 0x0f100044c, .val = 0x00000003 },
	{ .addr = 0x0f1000450, .val = 0x00000003 },
	{ .addr = 0x0f1000454, .val = 0x00000003 },
	{ .addr = 0x0f1000458, .val = 0x00000003 },
	{ .addr = 0x0f100045c, .val = 0x00000003 },
	{ .addr = 0x0f1000460, .val = 0x00000003 },
	{ .addr = 0x0f1000464, .val = 0x00000003 },
	{ .addr = 0x0f1000468, .val = 0x00000003 },
	{ .addr = 0x0f100046c, .val = 0x00000003 },
	{ .addr = 0x0f1000470, .val = 0x00000003 },
	{ .addr = 0x0f1000474, .val = 0x00000003 },
	{ .addr = 0x0f1000478, .val = 0x00000003 },
	{ .addr = 0x0f100047c, .val = 0x00000003 },
	{ .addr = 0x0f1000480, .val = 0x00000003 },
	{ .addr = 0x0f1000484, .val = 0x00000003 },
	{ .addr = 0x0f1000488, .val = 0x00000003 },
	{ .addr = 0x0f100048c, .val = 0x00000003 },
	{ .addr = 0x0f1000490, .val = 0x00000003 },
	{ .addr = 0x0f1000494, .val = 0x00000003 },
	{ .addr = 0x0f1000498, .val = 0x00000003 },
	{ .addr = 0x0f100049c, .val = 0x00000003 },
	{ .addr = 0x0f10004a0, .val = 0x00000003 },
	{ .addr = 0x0f10004a4, .val = 0x00000003 },
	{ .addr = 0x0f10004a8, .val = 0x00000003 },
	{ .addr = 0x0f10004ac, .val = 0x00000003 },
	{ .addr = 0x0f10004b0, .val = 0x00000003 },
	{ .addr = 0x0f10004b4, .val = 0x00000003 },
	{ .addr = 0x0f10004b8, .val = 0x00000003 },
	{ .addr = 0x0f10004bc, .val = 0x00000003 },
	{ .addr = 0x0f10004c0, .val = 0x00000003 },
	{ .addr = 0x0f10004c4, .val = 0x00000003 },
	{ .addr = 0x0f10004c8, .val = 0x00000003 },
	{ .addr = 0x0f10004cc, .val = 0x00000003 },
	{ .addr = 0x0f10004d0, .val = 0x00000003 },
	{ .addr = 0x0f10004d4, .val = 0x00000003 },
	{ .addr = 0x0f10004d8, .val = 0x00000003 },
	{ .addr = 0x0f10004dc, .val = 0x00000003 },
	{ .addr = 0x0f10004e0, .val = 0x00000003 },
	{ .addr = 0x0f10004e4, .val = 0x00000003 },
	{ .addr = 0x0f10004e8, .val = 0x00000003 },
	{ .addr = 0x0f10004ec, .val = 0x00000003 },
	{ .addr = 0x0f10004f0, .val = 0x00000003 },
	{ .addr = 0x0f10004f4, .val = 0x00000003 },
	{ .addr = 0x0f10004f8, .val = 0x00000003 },
	{ .addr = 0x0f10004fc, .val = 0x00000003 },
	{ .addr = 0x0f1000500, .val = 0x00000003 },
	{ .addr = 0x0f1000504, .val = 0x00000003 },
	{ .addr = 0x0f1000508, .val = 0x00000003 },
	{ .addr = 0x0f100050c, .val = 0x00000003 },
	{ .addr = 0x0f1000510, .val = 0x00000003 },
	{ .addr = 0x0f1000514, .val = 0x00000003 },
	{ .addr = 0x0f1000518, .val = 0x00000003 },
	{ .addr = 0x0f100051c, .val = 0x00000003 },
	{ .addr = 0x0f1000520, .val = 0x00000003 },
	{ .addr = 0x0f1000524, .val = 0x00000003 },
	{ .addr = 0x0f1000528, .val = 0x00000003 },
	{ .addr = 0x0f100052c, .val = 0x00000003 },
	{ .addr = 0x0f1000530, .val = 0x00000003 },
	{ .addr = 0x0f1000534, .val = 0x00000003 },
	{ .addr = 0x0f1000538, .val = 0x00000003 },
	{ .addr = 0x0f100053c, .val = 0x00000003 },
	{ .addr = 0x0f1000540, .val = 0x00000003 },
	{ .addr = 0x0f1000544, .val = 0x00000003 },
	{ .addr = 0x0f1000548, .val = 0x00000003 },
	{ .addr = 0x0f100054c, .val = 0x00000003 },
	{ .addr = 0x0f1000550, .val = 0x00000003 },
	{ .addr = 0x0f1000554, .val = 0x00000003 },
	{ .addr = 0x0f1000558, .val = 0x00000003 },
	{ .addr = 0x0f100055c, .val = 0x00000003 },
	{ .addr = 0x0f1000560, .val = 0x00000003 },
	{ .addr = 0x0f1000564, .val = 0x00000003 },
	{ .addr = 0x0f1000568, .val = 0x00000003 },
	{ .addr = 0x0f100056c, .val = 0x00000003 },
	{ .addr = 0x0f1000570, .val = 0x00000003 },
	{ .addr = 0x0f1000574, .val = 0x00000003 },
	{ .addr = 0x0f1000578, .val = 0x00000003 },
	{ .addr = 0x0f100057c, .val = 0x00000003 },
	{ .addr = 0x0f1000580, .val = 0x00000003 },
	{ .addr = 0x0f1000584, .val = 0x00000003 },
	{ .addr = 0x0f1000588, .val = 0x00000003 },
	{ .addr = 0x0f100058c, .val = 0x00000003 },
	{ .addr = 0x0f1000590, .val = 0x00000003 },
	{ .addr = 0x0f1000594, .val = 0x00000003 },
	{ .addr = 0x0f1000598, .val = 0x00000003 },
	{ .addr = 0x0f100059c, .val = 0x00000003 },
	{ .addr = 0x0f10005a0, .val = 0x00000003 },
	{ .addr = 0x0f10005a4, .val = 0x00000003 },
	{ .addr = 0x0f10005a8, .val = 0x00000003 },
	{ .addr = 0x0f10005ac, .val = 0x00000003 },
	{ .addr = 0x0f10005b0, .val = 0x00000003 },
	{ .addr = 0x0f10005b4, .val = 0x00000003 },
	{ .addr = 0x0f10005b8, .val = 0x00000003 },
	{ .addr = 0x0f10005bc, .val = 0x00000003 },
	{ .addr = 0x0f10005c0, .val = 0x00000003 },
	{ .addr = 0x0f10005c4, .val = 0x00000003 },
	{ .addr = 0x0f10005c8, .val = 0x00000003 },
	{ .addr = 0x0f10005cc, .val = 0x00000003 },
	{ .addr = 0x0f10005d0, .val = 0x00000003 },
	{ .addr = 0x0f10005d4, .val = 0x00000003 },
	{ .addr = 0x0f10005d8, .val = 0x00000003 },
	{ .addr = 0x0f10005dc, .val = 0x00000003 },
	{ .addr = 0x0f10005e0, .val = 0x00000003 },
	{ .addr = 0x0f10005e4, .val = 0x00000003 },
	{ .addr = 0x0f10005e8, .val = 0x00000003 },
	{ .addr = 0x0f10005ec, .val = 0x00000003 },
	{ .addr = 0x0f10005f0, .val = 0x00000003 },
	{ .addr = 0x0f10005f4, .val = 0x00000003 },
	{ .addr = 0x0f10005f8, .val = 0x00000003 },
	{ .addr = 0x0f10005fc, .val = 0x00000003 },
	{ .addr = 0x0f1000600, .val = 0x00000003 },
	{ .addr = 0x0f1000604, .val = 0x00000003 },
	{ .addr = 0x0f1000608, .val = 0x00000003 },
	{ .addr = 0x0f100060c, .val = 0x00000003 },
	{ .addr = 0x0f1000610, .val = 0x00000003 },
	{ .addr = 0x0f1000614, .val = 0x00000003 },
	{ .addr = 0x0f1000618, .val = 0x00000003 },
	{ .addr = 0x0f100061c, .val = 0x00000003 },
	{ .addr = 0x0f1000620, .val = 0x00000003 },
	{ .addr = 0x0f1000624, .val = 0x00000003 },
	{ .addr = 0x0f1000628, .val = 0x00000003 },
	{ .addr = 0x0f100062c, .val = 0x00000003 },
	{ .addr = 0x0f1000630, .val = 0x00000003 },
	{ .addr = 0x0f1000634, .val = 0x00000003 },
	{ .addr = 0x0f1000638, .val = 0x00000003 },
	{ .addr = 0x0f100063c, .val = 0x00000003 },
	{ .addr = 0x0f1000640, .val = 0x00000003 },
	{ .addr = 0x0f1000644, .val = 0x00000003 },
	{ .addr = 0x0f1000648, .val = 0x00000003 },
	{ .addr = 0x0f100064c, .val = 0x00000003 },
	{ .addr = 0x0f1000650, .val = 0x00000003 },
	{ .addr = 0x0f1000654, .val = 0x00000003 },
	{ .addr = 0x0f1000658, .val = 0x00000003 },
	{ .addr = 0x0f100065c, .val = 0x00000003 },
	{ .addr = 0x0f1000660, .val = 0x00000003 },
	{ .addr = 0x0f1000664, .val = 0x00000003 },
	{ .addr = 0x0f1000668, .val = 0x00000003 },
	{ .addr = 0x0f100066c, .val = 0x00000003 },
	{ .addr = 0x0f1000670, .val = 0x00000003 },
	{ .addr = 0x0f1000674, .val = 0x00000003 },
	{ .addr = 0x0f1000678, .val = 0x00000003 },
	{ .addr = 0x0f100067c, .val = 0x00000003 },
	{ .addr = 0x0f1000680, .val = 0x00000003 },
	{ .addr = 0x0f1000684, .val = 0x00000003 },
	{ .addr = 0x0f1000688, .val = 0x00000003 },
	{ .addr = 0x0f100068c, .val = 0x00000003 },
	{ .addr = 0x0f1000690, .val = 0x00000003 },
	{ .addr = 0x0f1000694, .val = 0x00000003 },
	{ .addr = 0x0f1000698, .val = 0x00000003 },
	{ .addr = 0x0f100069c, .val = 0x00000003 },
	{ .addr = 0x0f10006a0, .val = 0x00000003 },
	{ .addr = 0x0f10006a4, .val = 0x00000003 },
	{ .addr = 0x0f10006a8, .val = 0x00000003 },
	{ .addr = 0x0f10006ac, .val = 0x00000003 },
	{ .addr = 0x0f10006b0, .val = 0x00000003 },
	{ .addr = 0x0f10006b4, .val = 0x00000003 },
	{ .addr = 0x0f10006b8, .val = 0x00000003 },
	{ .addr = 0x0f10006bc, .val = 0x00000003 },
	{ .addr = 0x0f10006c0, .val = 0x00000003 },
	{ .addr = 0x0f10006c4, .val = 0x00000003 },
	{ .addr = 0x0f10006c8, .val = 0x00000003 },
	{ .addr = 0x0f10006cc, .val = 0x00000003 },
	{ .addr = 0x0f10006d0, .val = 0x00000003 },
	{ .addr = 0x0f10006d4, .val = 0x00000003 },
	{ .addr = 0x0f10006d8, .val = 0x00000003 },
	{ .addr = 0x0f10006dc, .val = 0x00000003 },
	{ .addr = 0x0f10006e0, .val = 0x00000003 },
	{ .addr = 0x0f10006e4, .val = 0x00000003 },
	{ .addr = 0x0f10006e8, .val = 0x00000003 },
	{ .addr = 0x0f10006ec, .val = 0x00000003 },
	{ .addr = 0x0f10006f0, .val = 0x00000003 },
	{ .addr = 0x0f10006f4, .val = 0x00000003 },
	{ .addr = 0x0f10006f8, .val = 0x00000003 },
	{ .addr = 0x0f10006fc, .val = 0x00000003 },
	{ .addr = 0x0f1000700, .val = 0x00000003 },
	{ .addr = 0x0f1000704, .val = 0x00000003 },
	{ .addr = 0x0f1000708, .val = 0x00000003 },
	{ .addr = 0x0f100070c, .val = 0x00000003 },
	{ .addr = 0x0f1000710, .val = 0x00000003 },
	{ .addr = 0x0f1000714, .val = 0x00000003 },
	{ .addr = 0x0f1000718, .val = 0x00000003 },
	{ .addr = 0x0f100071c, .val = 0x00000003 },
	{ .addr = 0x0f1000720, .val = 0x00000003 },
	{ .addr = 0x0f1000724, .val = 0x00000003 },
	{ .addr = 0x0f1000728, .val = 0x00000003 },
	{ .addr = 0x0f100072c, .val = 0x00000003 },
	{ .addr = 0x0f1000730, .val = 0x00000003 },
	{ .addr = 0x0f1000734, .val = 0x00000003 },
	{ .addr = 0x0f1000738, .val = 0x00000003 },
	{ .addr = 0x0f100073c, .val = 0x00000003 },
	{ .addr = 0x0f1000740, .val = 0x00000003 },
	{ .addr = 0x0f1000744, .val = 0x00000003 },
	{ .addr = 0x0f1000748, .val = 0x00000003 },
	{ .addr = 0x0f100074c, .val = 0x00000003 },
	{ .addr = 0x0f1000750, .val = 0x00000003 },
	{ .addr = 0x0f1000754, .val = 0x00000003 },
	{ .addr = 0x0f1000758, .val = 0x00000003 },
	{ .addr = 0x0f100075c, .val = 0x00000003 },
	{ .addr = 0x0f1000760, .val = 0x00000003 },
	{ .addr = 0x0f1000764, .val = 0x00000003 },
	{ .addr = 0x0f1000768, .val = 0x00000003 },
	{ .addr = 0x0f100076c, .val = 0x00000003 },
	{ .addr = 0x0f1000770, .val = 0x00000003 },
	{ .addr = 0x0f1000774, .val = 0x00000003 },
	{ .addr = 0x0f1000778, .val = 0x00000003 },
	{ .addr = 0x0f100077c, .val = 0x00000003 },
	{ .addr = 0x0f1000780, .val = 0x00000003 },
	{ .addr = 0x0f1000784, .val = 0x00000003 },
	{ .addr = 0x0f1000788, .val = 0x00000003 },
	{ .addr = 0x0f100078c, .val = 0x00000003 },
	{ .addr = 0x0f1000790, .val = 0x00000003 },
	{ .addr = 0x0f1000794, .val = 0x00000003 },
	{ .addr = 0x0f1000798, .val = 0x00000003 },
	{ .addr = 0x0f100079c, .val = 0x00000003 },
	{ .addr = 0x0f10007a0, .val = 0x00000003 },
	{ .addr = 0x0f10007a4, .val = 0x00000003 },
	{ .addr = 0x0f10007a8, .val = 0x00000003 },
	{ .addr = 0x0f10007ac, .val = 0x00000003 },
	{ .addr = 0x0f10007b0, .val = 0x00000003 },
	{ .addr = 0x0f10007b4, .val = 0x00000003 },
	{ .addr = 0x0f10007b8, .val = 0x00000003 },
	{ .addr = 0x0f10007bc, .val = 0x00000003 },
	{ .addr = 0x0f10007c0, .val = 0x00000003 },
	{ .addr = 0x0f10007c4, .val = 0x00000003 },
	{ .addr = 0x0f10007c8, .val = 0x00000003 },
	{ .addr = 0x0f10007cc, .val = 0x00000003 },
	{ .addr = 0x0f10007d0, .val = 0x00000003 },
	{ .addr = 0x0f10007d4, .val = 0x00000003 },
	{ .addr = 0x0f10007d8, .val = 0x00000003 },
	{ .addr = 0x0f10007dc, .val = 0x00000003 },
	{ .addr = 0x0f10007e0, .val = 0x00000003 },
	{ .addr = 0x0f10007e4, .val = 0x00000003 },
	{ .addr = 0x0f10007e8, .val = 0x00000003 },
	{ .addr = 0x0f10007ec, .val = 0x00000003 },
	{ .addr = 0x0f10007f0, .val = 0x00000003 },
	{ .addr = 0x0f10007f4, .val = 0x00000003 },
	{ .addr = 0x0f10007f8, .val = 0x00000003 },
	{ .addr = 0x0f10007fc, .val = 0x00000003 },
	{ .addr = 0x0f1000800, .val = 0x00000003 },
	{ .addr = 0x0f1000804, .val = 0x00000003 },
	{ .addr = 0x0f1000808, .val = 0x00000003 },
	{ .addr = 0x0f100080c, .val = 0x00000003 },
	{ .addr = 0x0f1000810, .val = 0x00000003 },
	{ .addr = 0x0f1000814, .val = 0x00000003 },
	{ .addr = 0x0f1000818, .val = 0x00000003 },
	{ .addr = 0x0f100081c, .val = 0x00000003 },
	{ .addr = 0x0f1000820, .val = 0x00000003 },
	{ .addr = 0x0f1000824, .val = 0x00000003 },
	{ .addr = 0x0f1000828, .val = 0x00000003 },
	{ .addr = 0x0f100082c, .val = 0x00000003 },
	{ .addr = 0x0f1000830, .val = 0x00000003 },
	{ .addr = 0x0f1000834, .val = 0x00000003 },
	{ .addr = 0x0f1000838, .val = 0x00000003 },
	{ .addr = 0x0f100083c, .val = 0x00000003 },
	{ .addr = 0x0f1000840, .val = 0x00000003 },
	{ .addr = 0x0f1000844, .val = 0x00000003 },
	{ .addr = 0x0f1000848, .val = 0x00000003 },
	{ .addr = 0x0f100084c, .val = 0x00000003 },
	{ .addr = 0x0f1000850, .val = 0x00000003 },
	{ .addr = 0x0f1000854, .val = 0x00000003 },
	{ .addr = 0x0f1000858, .val = 0x00000003 },
	{ .addr = 0x0f100085c, .val = 0x00000003 },
	{ .addr = 0x0f1000860, .val = 0x00000003 },
	{ .addr = 0x0f1000864, .val = 0x00000003 },
	{ .addr = 0x0f1000868, .val = 0x00000003 },
	{ .addr = 0x0f100086c, .val = 0x00000003 },
	{ .addr = 0x0f1000870, .val = 0x00000003 },
	{ .addr = 0x0f1000874, .val = 0x00000003 },
	{ .addr = 0x0f1000878, .val = 0x00000003 },
	{ .addr = 0x0f100087c, .val = 0x00000003 },
	{ .addr = 0x0f1000880, .val = 0x00000003 },
	{ .addr = 0x0f1000884, .val = 0x00000003 },
	{ .addr = 0x0f1000888, .val = 0x00000003 },
	{ .addr = 0x0f100088c, .val = 0x00000003 },
	{ .addr = 0x0f1000890, .val = 0x00000003 },
	{ .addr = 0x0f1000894, .val = 0x00000003 },
	{ .addr = 0x0f1000898, .val = 0x00000003 },
	{ .addr = 0x0f100089c, .val = 0x00000003 },
	{ .addr = 0x0f10008a0, .val = 0x00000003 },
	{ .addr = 0x0f10008a4, .val = 0x00000003 },
	{ .addr = 0x0f10008a8, .val = 0x00000003 },
	{ .addr = 0x0f10008ac, .val = 0x00000003 },
	{ .addr = 0x0f10008b0, .val = 0x00000003 },
	{ .addr = 0x0f10008b4, .val = 0x00000003 },
	{ .addr = 0x0f10008b8, .val = 0x00000003 },
	{ .addr = 0x0f10008bc, .val = 0x00000003 },
	{ .addr = 0x0f10008c0, .val = 0x83ffffff },
	{ .addr = 0x0f10008c4, .val = 0x83ffffff },
	{ .addr = 0x0f10008c8, .val = 0x83ffffff },
	{ .addr = 0x0f10008cc, .val = 0x83ffffff },
	{ .addr = 0x0f10008d0, .val = 0x83ffffff },
	{ .addr = 0x0f10008d4, .val = 0x83ffffff },
	{ .addr = 0x0f10008d8, .val = 0x83ffffff },
	{ .addr = 0x0f10008dc, .val = 0x83ffffff },
	{ .addr = 0x0f10008e0, .val = 0x83ffffff },
	{ .addr = 0x0f1000910, .val = 0xffffffff },
	{ .addr = 0x0f1000914, .val = 0xffffffff },
	{ .addr = 0x0f1000918, .val = 0xffffffff },
	{ .addr = 0x0f100091c, .val = 0xffffffff },
	{ .addr = 0x0f1000920, .val = 0xffffffff },
	{ .addr = 0x0f1000924, .val = 0xffffffff },
	{ .addr = 0x0f1000928, .val = 0xffffffff },
	{ .addr = 0x0f100092c, .val = 0xffffffff },
	{ .addr = 0x0f1000930, .val = 0xffffffff },
	{ .addr = 0x0f1000934, .val = 0xffffffff },
	{ .addr = 0x0f1000938, .val = 0xffffffff },
	{ .addr = 0x0f100093c, .val = 0xffffffff },
	{ .addr = 0x0f1000940, .val = 0xffffffff },
	{ .addr = 0x0f1000944, .val = 0xffffffff },
	{ .addr = 0x0f1000948, .val = 0xffffffff },
	{ .addr = 0x0f100094c, .val = 0xffffffff },
	{ .addr = 0x0f1000950, .val = 0xffffffff },
	{ .addr = 0x0f1000954, .val = 0xffffffff },
	{ .addr = 0x0f1000958, .val = 0xffffffff },
	{ .addr = 0x0f100095c, .val = 0xffffffff },
	{ .addr = 0x0f1000960, .val = 0xffffffff },
	{ .addr = 0x0f1000964, .val = 0xffffffff },
	{ .addr = 0x0f1000968, .val = 0xffffffff },
	{ .addr = 0x0f100096c, .val = 0xffffffff },
	{ .addr = 0x0f1000970, .val = 0xffffffff },
	{ .addr = 0x0f1000974, .val = 0xffffffff },
	{ .addr = 0x0f1000978, .val = 0xffffffff },
	{ .addr = 0x0f100097c, .val = 0xffffffff },
	{ .addr = 0x0f1000980, .val = 0xffffffff },
	{ .addr = 0x0f1000984, .val = 0xffffffff },
	{ .addr = 0x0f1000988, .val = 0xffffffff },
	{ .addr = 0x0f100098c, .val = 0xffffffff },
	{ .addr = 0x0f1000990, .val = 0xffffffff },
	{ .addr = 0x0f1000994, .val = 0xffffffff },
	{ .addr = 0x0f1000998, .val = 0xffffffff },
	{ .addr = 0x0f100099c, .val = 0xffffffff },
	{ .addr = 0x0f10009a0, .val = 0xffffffff },
	{ .addr = 0x0f10009a4, .val = 0xffffffff },
	{ .addr = 0x0f10009a8, .val = 0xffffffff },
	{ .addr = 0x0f10009ac, .val = 0xffffffff },
	{ .addr = 0x0f10009b0, .val = 0xffffffff },
	{ .addr = 0x0f10009b4, .val = 0xffffffff },
	{ .addr = 0x0f10009b8, .val = 0xffffffff },
	{ .addr = 0x0f10009bc, .val = 0xffffffff },
	{ .addr = 0x0f10009c0, .val = 0xffffffff },
	{ .addr = 0x0f10009c4, .val = 0xffffffff },
	{ .addr = 0x0f10009c8, .val = 0xffffffff },
	{ .addr = 0x0f10009cc, .val = 0xffffffff },
	{ .addr = 0x0f1010000, .val = 0xffffffff },
	{ .addr = 0x0f1010004, .val = 0xffffffff },
	{ .addr = 0x0f1010008, .val = 0xffffffff },
	{ .addr = 0x0f101000c, .val = 0xffffffff },
	{ .addr = 0x0f1010010, .val = 0xffffffff },
	{ .addr = 0x0f1010014, .val = 0xffffffff },
	{ .addr = 0x0f1010018, .val = 0xffffffff },
	{ .addr = 0x0f101001c, .val = 0xffffffff },
	{ .addr = 0x0f1010050, .val = 0x000000ff },
	{ .addr = 0x0f1010054, .val = 0xffffffff },
	{ .addr = 0x0f1010058, .val = 0x0000ffff },
	{ .addr = 0x0f101005c, .val = 0xffffffff },
	{ .addr = 0x0f1010060, .val = 0xffffffff },
	{ .addr = 0x0f1010064, .val = 0xffffffff },
	{ .addr = 0x0f1010068, .val = 0xffffffff },
	{ .addr = 0x0f101006c, .val = 0xffffffff },
	{ .addr = 0x0f1010070, .val = 0xffffffff },
	{ .addr = 0x0f1010074, .val = 0xffffffff },
	{ .addr = 0x0f1010078, .val = 0xffffffff },
	{ .addr = 0x0f101007c, .val = 0xffffffff },
	{ .addr = 0x0f1010080, .val = 0xffffffff },
	{ .addr = 0x0f1010084, .val = 0xffffffff },
	{ .addr = 0x0f1010088, .val = 0xffffffff },
	{ .addr = 0x0f101008c, .val = 0xffffffff },
	{ .addr = 0x0f1010090, .val = 0xffffffff },
	{ .addr = 0x0f1010094, .val = 0xffffffff },
	{ .addr = 0x0f1010098, .val = 0xffffffff },
	{ .addr = 0x0f101009c, .val = 0xffffffff },
	{ .addr = 0x0f10100a0, .val = 0xffffffff },
	{ .addr = 0x0f10100a4, .val = 0xffffffff },
	{ .addr = 0x0f10100a8, .val = 0xffffffff },
	{ .addr = 0x0f10100ac, .val = 0xffffffff },
	{ .addr = 0x0f10100b0, .val = 0xffffffff },
	{ .addr = 0x0f10100b4, .val = 0xffffffff },
	{ .addr = 0x0f10100b8, .val = 0xffffffff },
	{ .addr = 0x0f10100bc, .val = 0xffffffff },
	{ .addr = 0x0f10100c0, .val = 0xffffffff },
	{ .addr = 0x0f10100c4, .val = 0xffffffff },
	{ .addr = 0x0f10100c8, .val = 0xffffffff },
	{ .addr = 0x0f10100cc, .val = 0xffffffff },
	{ .addr = 0x0f10100d0, .val = 0xffffffff },
	{ .addr = 0x0f10100d4, .val = 0xffffffff },
	{ .addr = 0x0f10100d8, .val = 0xffffffff },
	{ .addr = 0x0f10100dc, .val = 0xffffffff },
	{ .addr = 0x0f10100e0, .val = 0xffffffff },
	{ .addr = 0x0f10100e4, .val = 0xffffffff },
	{ .addr = 0x0f10100e8, .val = 0xffffffff },
	{ .addr = 0x0f10100ec, .val = 0xffffffff },
	{ .addr = 0x0f10100f0, .val = 0xffffffff },
	{ .addr = 0x0f10100f4, .val = 0xffffffff },
	{ .addr = 0x0f10100f8, .val = 0xffffffff },
	{ .addr = 0x0f10100fc, .val = 0xffffffff },
	{ .addr = 0x0f1010100, .val = 0xffffffff },
	{ .addr = 0x0f1010104, .val = 0xffffffff },
	{ .addr = 0x0f1010108, .val = 0xffffffff },
	{ .addr = 0x0f101010c, .val = 0xffffffff },
	{ .addr = 0x0f1010110, .val = 0xffffffff },
	{ .addr = 0x0f1010114, .val = 0xffffffff },
	{ .addr = 0x0f1010118, .val = 0xffffffff },
	{ .addr = 0x0f101011c, .val = 0xffffffff },
	{ .addr = 0x0f1010120, .val = 0xffffffff },
	{ .addr = 0x0f1010124, .val = 0xffffffff },
	{ .addr = 0x0f1010128, .val = 0xffffffff },
	{ .addr = 0x0f101012c, .val = 0xffffffff },
	{ .addr = 0x0f1010130, .val = 0xffffffff },
	{ .addr = 0x0f1010134, .val = 0xffffffff },
	{ .addr = 0x0f1010138, .val = 0xffffffff },
	{ .addr = 0x0f101013c, .val = 0xffffffff },
	{ .addr = 0x0f1010140, .val = 0xffffffff },
	{ .addr = 0x0f1010144, .val = 0xffffffff },
	{ .addr = 0x0f1010148, .val = 0xffffffff },
	{ .addr = 0x0f101014c, .val = 0xffffffff },
	{ .addr = 0x0f1010150, .val = 0xffffffff },
	{ .addr = 0x0f1010154, .val = 0xffffffff },
	{ .addr = 0x0f1010158, .val = 0xffffffff },
	{ .addr = 0x0f101015c, .val = 0xffffffff },
	{ .addr = 0x0f1010160, .val = 0xffffffff },
	{ .addr = 0x0f1010164, .val = 0xffffffff },
	{ .addr = 0x0f1010168, .val = 0xffffffff },
	{ .addr = 0x0f101016c, .val = 0xffffffff },
	{ .addr = 0x0f1010170, .val = 0xffffffff },
	{ .addr = 0x0f1010174, .val = 0xffffffff },
	{ .addr = 0x0f1010178, .val = 0xffffffff },
	{ .addr = 0x0f101017c, .val = 0xffffffff },
	{ .addr = 0x0f1010180, .val = 0xffffffff },
	{ .addr = 0x0f1010184, .val = 0xffffffff },
	{ .addr = 0x0f1010188, .val = 0xffffffff },
	{ .addr = 0x0f101018c, .val = 0xffffffff },
	{ .addr = 0x0f1010190, .val = 0xffffffff },
	{ .addr = 0x0f1010194, .val = 0xffffffff },
	{ .addr = 0x0f1010198, .val = 0xffffffff },
	{ .addr = 0x0f101019c, .val = 0xffffffff },
	{ .addr = 0x0f10101a0, .val = 0xffffffff },
	{ .addr = 0x0f10101a4, .val = 0xffffffff },
	{ .addr = 0x0f10101a8, .val = 0xffffffff },
	{ .addr = 0x0f10101ac, .val = 0xffffffff },
	{ .addr = 0x0f10101b0, .val = 0xffffffff },
	{ .addr = 0x0f10101b4, .val = 0xffffffff },
	{ .addr = 0x0f10101b8, .val = 0xffffffff },
	{ .addr = 0x0f10101bc, .val = 0xffffffff },
	{ .addr = 0x0f10101c0, .val = 0xffffffff },
	{ .addr = 0x0f10101c4, .val = 0xffffffff },
	{ .addr = 0x0f10101c8, .val = 0xffffffff },
	{ .addr = 0x0f10101cc, .val = 0xffffffff },
	{ .addr = 0x0f10101d0, .val = 0xffffffff },
	{ .addr = 0x0f10101d4, .val = 0xffffffff },
	{ .addr = 0x0f10101d8, .val = 0xffffffff },
	{ .addr = 0x0f10101dc, .val = 0xffffffff },
	{ .addr = 0x0f10101e0, .val = 0xffffffff },
	{ .addr = 0x0f10101e4, .val = 0xffffffff },
	{ .addr = 0x0f10101e8, .val = 0xffffffff },
	{ .addr = 0x0f10101ec, .val = 0xffffffff },
	{ .addr = 0x0f10101f0, .val = 0xffffffff },
	{ .addr = 0x0f10101f4, .val = 0xffffffff },
	{ .addr = 0x0f10101f8, .val = 0xffffffff },
	{ .addr = 0x0f10101fc, .val = 0xffffffff },
	{ .addr = 0x0f1010200, .val = 0xffffffff },
	{ .addr = 0x0f1010204, .val = 0xffffffff },
	{ .addr = 0x0f1010208, .val = 0xffffffff },
	{ .addr = 0x0f101020c, .val = 0xffffffff },
	{ .addr = 0x0f1010210, .val = 0xffffffff },
	{ .addr = 0x0f1010214, .val = 0xffffffff },
	{ .addr = 0x0f1010218, .val = 0xffffffff },
	{ .addr = 0x0f101021c, .val = 0xffffffff },
	{ .addr = 0x0f1010220, .val = 0xffffffff },
	{ .addr = 0x0f1010224, .val = 0xffffffff },
	{ .addr = 0x0f1010228, .val = 0xffffffff },
	{ .addr = 0x0f101022c, .val = 0xffffffff },
	{ .addr = 0x0f1010230, .val = 0xffffffff },
	{ .addr = 0x0f1010234, .val = 0xffffffff },
	{ .addr = 0x0f1010238, .val = 0xffffffff },
	{ .addr = 0x0f101023c, .val = 0xffffffff },
	{ .addr = 0x0f1010240, .val = 0xffffffff },
	{ .addr = 0x0f1010244, .val = 0xffffffff },
	{ .addr = 0x0f1010248, .val = 0xffffffff },
	{ .addr = 0x0f101024c, .val = 0xffffffff },
	{ .addr = 0x0f1010250, .val = 0xffffffff },
	{ .addr = 0x0f1010254, .val = 0xffffffff },
	{ .addr = 0x0f1010258, .val = 0xffffffff },
	{ .addr = 0x0f101025c, .val = 0xffffffff },
	{ .addr = 0x0f1010260, .val = 0xffffffff },
	{ .addr = 0x0f1010264, .val = 0xffffffff },
	{ .addr = 0x0f1010268, .val = 0xffffffff },
	{ .addr = 0x0f101026c, .val = 0xffffffff },
	{ .addr = 0x0f1010270, .val = 0xffffffff },
	{ .addr = 0x0f1010274, .val = 0xffffffff },
	{ .addr = 0x0f1010278, .val = 0xffffffff },
	{ .addr = 0x0f101027c, .val = 0xffffffff },
	{ .addr = 0x0f1010280, .val = 0xffffffff },
	{ .addr = 0x0f1010284, .val = 0xffffffff },
	{ .addr = 0x0f1010288, .val = 0xffffffff },
	{ .addr = 0x0f101028c, .val = 0xffffffff },
	{ .addr = 0x0f1010290, .val = 0xffffffff },
	{ .addr = 0x0f1010294, .val = 0xffffffff },
	{ .addr = 0x0f1010298, .val = 0xffffffff },
	{ .addr = 0x0f101029c, .val = 0xffffffff },
	{ .addr = 0x0f10102a0, .val = 0xffffffff },
	{ .addr = 0x0f10102a4, .val = 0xffffffff },
	{ .addr = 0x0f10102a8, .val = 0xffffffff },
	{ .addr = 0x0f10102ac, .val = 0xffffffff },
	{ .addr = 0x0f10102b0, .val = 0xffffffff },
	{ .addr = 0x0f10102b4, .val = 0xffffffff },
	{ .addr = 0x0f10102b8, .val = 0xffffffff },
	{ .addr = 0x0f10102bc, .val = 0xffffffff },
	{ .addr = 0x0f10102c0, .val = 0xffffffff },
	{ .addr = 0x0f10102c4, .val = 0xffffffff },
	{ .addr = 0x0f10102c8, .val = 0xffffffff },
	{ .addr = 0x0f10102cc, .val = 0xffffffff },
	{ .addr = 0x0f10102d0, .val = 0xffffffff },
	{ .addr = 0x0f10102d4, .val = 0xffffffff },
	{ .addr = 0x0f10102d8, .val = 0xffffffff },
	{ .addr = 0x0f10102dc, .val = 0xffffffff },
	{ .addr = 0x0f10102e0, .val = 0xffffffff },
	{ .addr = 0x0f10102e4, .val = 0xffffffff },
	{ .addr = 0x0f10102e8, .val = 0xffffffff },
	{ .addr = 0x0f10102ec, .val = 0xffffffff },
	{ .addr = 0x0f10102f0, .val = 0xffffffff },
	{ .addr = 0x0f10102f4, .val = 0xffffffff },
	{ .addr = 0x0f10102f8, .val = 0xffffffff },
	{ .addr = 0x0f10102fc, .val = 0xffffffff },
	{ .addr = 0x0f1010300, .val = 0xffffffff },
	{ .addr = 0x0f1010304, .val = 0xffffffff },
	{ .addr = 0x0f1010308, .val = 0xffffffff },
	{ .addr = 0x0f101030c, .val = 0xffffffff },
	{ .addr = 0x0f1010310, .val = 0xffffffff },
	{ .addr = 0x0f1010314, .val = 0xffffffff },
	{ .addr = 0x0f1010318, .val = 0xffffffff },
	{ .addr = 0x0f101031c, .val = 0xffffffff },
	{ .addr = 0x0f1010320, .val = 0xffffffff },
	{ .addr = 0x0f1010324, .val = 0xffffffff },
	{ .addr = 0x0f1010328, .val = 0xffffffff },
	{ .addr = 0x0f101032c, .val = 0xffffffff },
	{ .addr = 0x0f1010330, .val = 0xffffffff },
	{ .addr = 0x0f1010334, .val = 0xffffffff },
	{ .addr = 0x0f1010338, .val = 0xffffffff },
	{ .addr = 0x0f101033c, .val = 0xffffffff },
	{ .addr = 0x0f1010340, .val = 0xffffffff },
	{ .addr = 0x0f1010344, .val = 0xffffffff },
	{ .addr = 0x0f1010348, .val = 0xffffffff },
	{ .addr = 0x0f101034c, .val = 0xffffffff },
	{ .addr = 0x0f1010350, .val = 0xffffffff },
	{ .addr = 0x0f1010354, .val = 0xffffffff },
	{ .addr = 0x0f1010358, .val = 0xffffffff },
	{ .addr = 0x0f101035c, .val = 0xffffffff },
	{ .addr = 0x0f1010360, .val = 0xffffffff },
	{ .addr = 0x0f1010364, .val = 0xffffffff },
	{ .addr = 0x0f1010368, .val = 0xffffffff },
	{ .addr = 0x0f101036c, .val = 0xffffffff },
	{ .addr = 0x0f1010370, .val = 0xffffffff },
	{ .addr = 0x0f1010374, .val = 0xffffffff },
	{ .addr = 0x0f1010378, .val = 0xffffffff },
	{ .addr = 0x0f101037c, .val = 0xffffffff },
	{ .addr = 0x0f1010380, .val = 0xffffffff },
	{ .addr = 0x0f1010384, .val = 0xffffffff },
	{ .addr = 0x0f1010388, .val = 0xffffffff },
	{ .addr = 0x0f101038c, .val = 0xffffffff },
	{ .addr = 0x0f1010390, .val = 0xffffffff },
	{ .addr = 0x0f1010394, .val = 0xffffffff },
	{ .addr = 0x0f1010398, .val = 0xffffffff },
	{ .addr = 0x0f101039c, .val = 0xffffffff },
	{ .addr = 0x0f10103a0, .val = 0xffffffff },
	{ .addr = 0x0f10103a4, .val = 0xffffffff },
	{ .addr = 0x0f10103a8, .val = 0xffffffff },
	{ .addr = 0x0f10103ac, .val = 0xffffffff },
	{ .addr = 0x0f10103b0, .val = 0xffffffff },
	{ .addr = 0x0f10103b4, .val = 0xffffffff },
	{ .addr = 0x0f10103b8, .val = 0xffffffff },
	{ .addr = 0x0f10103bc, .val = 0xffffffff },
	{ .addr = 0x0f10103c0, .val = 0xffffffff },
	{ .addr = 0x0f10103c4, .val = 0xffffffff },
	{ .addr = 0x0f10103c8, .val = 0xffffffff },
	{ .addr = 0x0f10103cc, .val = 0xffffffff },
	{ .addr = 0x0f10103d0, .val = 0xffffffff },
	{ .addr = 0x0f10103d4, .val = 0xffffffff },
	{ .addr = 0x0f10103d8, .val = 0xffffffff },
	{ .addr = 0x0f10103dc, .val = 0xffffffff },
	{ .addr = 0x0f10103e0, .val = 0xffffffff },
	{ .addr = 0x0f10103e4, .val = 0xffffffff },
	{ .addr = 0x0f10103e8, .val = 0xffffffff },
	{ .addr = 0x0f10103ec, .val = 0xffffffff },
	{ .addr = 0x0f10103f0, .val = 0xffffffff },
	{ .addr = 0x0f10103f4, .val = 0xffffffff },
	{ .addr = 0x0f10103f8, .val = 0xffffffff },
	{ .addr = 0x0f10103fc, .val = 0xffffffff },
	{ .addr = 0x0f1010400, .val = 0xffffffff },
	{ .addr = 0x0f1010404, .val = 0xffffffff },
	{ .addr = 0x0f1010408, .val = 0xffffffff },
	{ .addr = 0x0f101040c, .val = 0xffffffff },
	{ .addr = 0x0f1010410, .val = 0xffffffff },
	{ .addr = 0x0f1010414, .val = 0xffffffff },
	{ .addr = 0x0f1010418, .val = 0xffffffff },
	{ .addr = 0x0f101041c, .val = 0xffffffff },
	{ .addr = 0x0f1010420, .val = 0xffffffff },
	{ .addr = 0x0f1010424, .val = 0xffffffff },
	{ .addr = 0x0f1010428, .val = 0xffffffff },
	{ .addr = 0x0f101042c, .val = 0xffffffff },
	{ .addr = 0x0f1010430, .val = 0xffffffff },
	{ .addr = 0x0f1010434, .val = 0xffffffff },
	{ .addr = 0x0f1010438, .val = 0xffffffff },
	{ .addr = 0x0f101043c, .val = 0xffffffff },
	{ .addr = 0x0f1010440, .val = 0xffffffff },
	{ .addr = 0x0f1010444, .val = 0xffffffff },
	{ .addr = 0x0f1010448, .val = 0xffffffff },
	{ .addr = 0x0f101044c, .val = 0xffffffff },
	{ .addr = 0x0f1010450, .val = 0xffffffff },
	{ .addr = 0x0f1010454, .val = 0xffffffff },
	{ .addr = 0x0f1010458, .val = 0xffffffff },
	{ .addr = 0x0f101045c, .val = 0xffffffff },
	{ .addr = 0x0f1010460, .val = 0xffffffff },
	{ .addr = 0x0f1010464, .val = 0xffffffff },
	{ .addr = 0x0f1010468, .val = 0xffffffff },
	{ .addr = 0x0f101046c, .val = 0xffffffff },
	{ .addr = 0x0f1010470, .val = 0xffffffff },
	{ .addr = 0x0f1010474, .val = 0xffffffff },
	{ .addr = 0x0f1010478, .val = 0xffffffff },
	{ .addr = 0x0f101047c, .val = 0xffffffff },
	{ .addr = 0x0f1010480, .val = 0xffffffff },
	{ .addr = 0x0f1010484, .val = 0xffffffff },
	{ .addr = 0x0f1010488, .val = 0xffffffff },
	{ .addr = 0x0f101048c, .val = 0xffffffff },
	{ .addr = 0x0f1010490, .val = 0xffffffff },
	{ .addr = 0x0f1010494, .val = 0xffffffff },
	{ .addr = 0x0f1010498, .val = 0xffffffff },
	{ .addr = 0x0f101049c, .val = 0xffffffff },
	{ .addr = 0x0f10104a0, .val = 0xffffffff },
	{ .addr = 0x0f10104a4, .val = 0xffffffff },
	{ .addr = 0x0f10104a8, .val = 0xffffffff },
	{ .addr = 0x0f10104ac, .val = 0xffffffff },
	{ .addr = 0x0f10104b0, .val = 0xffffffff },
	{ .addr = 0x0f10104b4, .val = 0xffffffff },
	{ .addr = 0x0f10104b8, .val = 0xffffffff },
	{ .addr = 0x0f10104bc, .val = 0xffffffff },
	{ .addr = 0x0f10104c0, .val = 0xffffffff },
	{ .addr = 0x0f10104c4, .val = 0xffffffff },
	{ .addr = 0x0f10104c8, .val = 0xffffffff },
	{ .addr = 0x0f10104cc, .val = 0xffffffff },
	{ .addr = 0x0f10104d0, .val = 0xffffffff },
	{ .addr = 0x0f10104d4, .val = 0xffffffff },
	{ .addr = 0x0f10104d8, .val = 0xffffffff },
	{ .addr = 0x0f10104dc, .val = 0xffffffff },
	{ .addr = 0x0f10104e0, .val = 0xffffffff },
	{ .addr = 0x0f10104e4, .val = 0xffffffff },
	{ .addr = 0x0f10104e8, .val = 0xffffffff },
	{ .addr = 0x0f10104ec, .val = 0xffffffff },
	{ .addr = 0x0f10104f0, .val = 0xffffffff },
	{ .addr = 0x0f10104f4, .val = 0xffffffff },
	{ .addr = 0x0f10104f8, .val = 0xffffffff },
	{ .addr = 0x0f10104fc, .val = 0xffffffff },
	{ .addr = 0x0f1010500, .val = 0xffffffff },
	{ .addr = 0x0f1010504, .val = 0xffffffff },
	{ .addr = 0x0f1010508, .val = 0xffffffff },
	{ .addr = 0x0f101050c, .val = 0xffffffff },
	{ .addr = 0x0f1010510, .val = 0xffffffff },
	{ .addr = 0x0f1010514, .val = 0xffffffff },
	{ .addr = 0x0f1010518, .val = 0xffffffff },
	{ .addr = 0x0f101051c, .val = 0xffffffff },
	{ .addr = 0x0f1010520, .val = 0xffffffff },
	{ .addr = 0x0f1010524, .val = 0xffffffff },
	{ .addr = 0x0f1010528, .val = 0xffffffff },
	{ .addr = 0x0f101052c, .val = 0xffffffff },
	{ .addr = 0x0f1010530, .val = 0xffffffff },
	{ .addr = 0x0f1010534, .val = 0xffffffff },
	{ .addr = 0x0f1010538, .val = 0xffffffff },
	{ .addr = 0x0f101053c, .val = 0xffffffff },
	{ .addr = 0x0f1010540, .val = 0xffffffff },
	{ .addr = 0x0f1010544, .val = 0xffffffff },
	{ .addr = 0x0f1010548, .val = 0xffffffff },
	{ .addr = 0x0f101054c, .val = 0xffffffff },
	{ .addr = 0x0f1010550, .val = 0xffffffff },
	{ .addr = 0x0f1010554, .val = 0xffffffff },
	{ .addr = 0x0f1010558, .val = 0xffffffff },
	{ .addr = 0x0f101055c, .val = 0xffffffff },
	{ .addr = 0x0f1010560, .val = 0xffffffff },
	{ .addr = 0x0f1010564, .val = 0xffffffff },
	{ .addr = 0x0f1010568, .val = 0xffffffff },
	{ .addr = 0x0f101056c, .val = 0xffffffff },
	{ .addr = 0x0f1010570, .val = 0xffffffff },
	{ .addr = 0x0f1010574, .val = 0xffffffff },
	{ .addr = 0x0f1010578, .val = 0xffffffff },
	{ .addr = 0x0f101057c, .val = 0xffffffff },
	{ .addr = 0x0f1010580, .val = 0xffffffff },
	{ .addr = 0x0f1010584, .val = 0xffffffff },
	{ .addr = 0x0f1010588, .val = 0xffffffff },
	{ .addr = 0x0f101058c, .val = 0xffffffff },
	{ .addr = 0x0f1010590, .val = 0xffffffff },
	{ .addr = 0x0f1010594, .val = 0xffffffff },
	{ .addr = 0x0f1010598, .val = 0xffffffff },
	{ .addr = 0x0f101059c, .val = 0xffffffff },
	{ .addr = 0x0f10105a0, .val = 0xffffffff },
	{ .addr = 0x0f10105a4, .val = 0xffffffff },
	{ .addr = 0x0f10105a8, .val = 0xffffffff },
	{ .addr = 0x0f10105ac, .val = 0xffffffff },
	{ .addr = 0x0f10105b0, .val = 0xffffffff },
	{ .addr = 0x0f10105b4, .val = 0xffffffff },
	{ .addr = 0x0f10105b8, .val = 0xffffffff },
	{ .addr = 0x0f10105bc, .val = 0xffffffff },
	{ .addr = 0x0f10105c0, .val = 0xffffffff },
	{ .addr = 0x0f10105c4, .val = 0xffffffff },
	{ .addr = 0x0f10105c8, .val = 0xffffffff },
	{ .addr = 0x0f10105cc, .val = 0xffffffff },
	{ .addr = 0x0f10105d0, .val = 0xffffffff },
	{ .addr = 0x0f10105d4, .val = 0xffffffff },
	{ .addr = 0x0f10105d8, .val = 0xffffffff },
	{ .addr = 0x0f10105dc, .val = 0xffffffff },
	{ .addr = 0x0f10105e0, .val = 0xffffffff },
	{ .addr = 0x0f10105e4, .val = 0xffffffff },
	{ .addr = 0x0f10105e8, .val = 0xffffffff },
	{ .addr = 0x0f10105ec, .val = 0xffffffff },
	{ .addr = 0x0f10105f0, .val = 0xffffffff },
	{ .addr = 0x0f10105f4, .val = 0xffffffff },
	{ .addr = 0x0f10105f8, .val = 0xffffffff },
	{ .addr = 0x0f10105fc, .val = 0xffffffff },
	{ .addr = 0x0f1010600, .val = 0xffffffff },
	{ .addr = 0x0f1010604, .val = 0xffffffff },
	{ .addr = 0x0f1010608, .val = 0xffffffff },
	{ .addr = 0x0f101060c, .val = 0xffffffff },
	{ .addr = 0x0f1010610, .val = 0xffffffff },
	{ .addr = 0x0f1010614, .val = 0xffffffff },
	{ .addr = 0x0f1010618, .val = 0xffffffff },
	{ .addr = 0x0f101061c, .val = 0xffffffff },
	{ .addr = 0x0f1010620, .val = 0xffffffff },
	{ .addr = 0x0f1010624, .val = 0xffffffff },
	{ .addr = 0x0f1010628, .val = 0xffffffff },
	{ .addr = 0x0f101062c, .val = 0xffffffff },
	{ .addr = 0x0f1010630, .val = 0xffffffff },
	{ .addr = 0x0f1010634, .val = 0xffffffff },
	{ .addr = 0x0f1010638, .val = 0xffffffff },
	{ .addr = 0x0f101063c, .val = 0xffffffff },
	{ .addr = 0x0f1010640, .val = 0xffffffff },
	{ .addr = 0x0f1010644, .val = 0xffffffff },
	{ .addr = 0x0f1010648, .val = 0xffffffff },
	{ .addr = 0x0f101064c, .val = 0xffffffff },
	{ .addr = 0x0f1010650, .val = 0xffffffff },
	{ .addr = 0x0f1010654, .val = 0xffffffff },
	{ .addr = 0x0f1010658, .val = 0xffffffff },
	{ .addr = 0x0f101065c, .val = 0xffffffff },
	{ .addr = 0x0f1010660, .val = 0xffffffff },
	{ .addr = 0x0f1010664, .val = 0xffffffff },
	{ .addr = 0x0f1010668, .val = 0xffffffff },
	{ .addr = 0x0f101066c, .val = 0xffffffff },
	{ .addr = 0x0f1010670, .val = 0xffffffff },
	{ .addr = 0x0f1010674, .val = 0xffffffff },
	{ .addr = 0x0f1010678, .val = 0xffffffff },
	{ .addr = 0x0f101067c, .val = 0xffffffff },
	{ .addr = 0x0f1010680, .val = 0xffffffff },
	{ .addr = 0x0f1010684, .val = 0xffffffff },
	{ .addr = 0x0f1010688, .val = 0xffffffff },
	{ .addr = 0x0f101068c, .val = 0xffffffff },
	{ .addr = 0x0f1010690, .val = 0xffffffff },
	{ .addr = 0x0f1010694, .val = 0xffffffff },
	{ .addr = 0x0f1010698, .val = 0xffffffff },
	{ .addr = 0x0f101069c, .val = 0xffffffff },
	{ .addr = 0x0f10106a0, .val = 0xffffffff },
	{ .addr = 0x0f10106a4, .val = 0xffffffff },
	{ .addr = 0x0f10106a8, .val = 0xffffffff },
	{ .addr = 0x0f10106ac, .val = 0xffffffff },
	{ .addr = 0x0f10106b0, .val = 0xffffffff },
	{ .addr = 0x0f10106b4, .val = 0xffffffff },
	{ .addr = 0x0f10106b8, .val = 0xffffffff },
	{ .addr = 0x0f10106bc, .val = 0xffffffff },
	{ .addr = 0x0f10106c0, .val = 0xffffffff },
	{ .addr = 0x0f10106c4, .val = 0xffffffff },
	{ .addr = 0x0f10106c8, .val = 0xffffffff },
	{ .addr = 0x0f10106cc, .val = 0xffffffff },
	{ .addr = 0x0f10106d0, .val = 0xffffffff },
	{ .addr = 0x0f10106d4, .val = 0xffffffff },
	{ .addr = 0x0f10106d8, .val = 0xffffffff },
	{ .addr = 0x0f10106dc, .val = 0xffffffff },
	{ .addr = 0x0f10106e0, .val = 0xffffffff },
	{ .addr = 0x0f10106e4, .val = 0xffffffff },
	{ .addr = 0x0f10106e8, .val = 0xffffffff },
	{ .addr = 0x0f10106ec, .val = 0xffffffff },
	{ .addr = 0x0f10106f0, .val = 0xffffffff },
	{ .addr = 0x0f10106f4, .val = 0xffffffff },
	{ .addr = 0x0f10106f8, .val = 0xffffffff },
	{ .addr = 0x0f10106fc, .val = 0xffffffff },
	{ .addr = 0x0f1010700, .val = 0xffffffff },
	{ .addr = 0x0f1010704, .val = 0xffffffff },
	{ .addr = 0x0f1010708, .val = 0xffffffff },
	{ .addr = 0x0f101070c, .val = 0xffffffff },
	{ .addr = 0x0f1010710, .val = 0xffffffff },
	{ .addr = 0x0f1010714, .val = 0xffffffff },
	{ .addr = 0x0f1010718, .val = 0xffffffff },
	{ .addr = 0x0f101071c, .val = 0xffffffff },
	{ .addr = 0x0f1010720, .val = 0xffffffff },
	{ .addr = 0x0f1010724, .val = 0xffffffff },
	{ .addr = 0x0f1010728, .val = 0xffffffff },
	{ .addr = 0x0f101072c, .val = 0xffffffff },
	{ .addr = 0x0f1010730, .val = 0xffffffff },
	{ .addr = 0x0f1010734, .val = 0xffffffff },
	{ .addr = 0x0f1010738, .val = 0xffffffff },
	{ .addr = 0x0f101073c, .val = 0xffffffff },
	{ .addr = 0x0f1010740, .val = 0xffffffff },
	{ .addr = 0x0f1010744, .val = 0xffffffff },
	{ .addr = 0x0f1010748, .val = 0xffffffff },
	{ .addr = 0x0f101074c, .val = 0xffffffff },
	{ .addr = 0x0f1010750, .val = 0xffffffff },
	{ .addr = 0x0f1010754, .val = 0xffffffff },
	{ .addr = 0x0f1010758, .val = 0xffffffff },
	{ .addr = 0x0f101075c, .val = 0xffffffff },
	{ .addr = 0x0f1010760, .val = 0xffffffff },
	{ .addr = 0x0f1010764, .val = 0xffffffff },
	{ .addr = 0x0f1010768, .val = 0xffffffff },
	{ .addr = 0x0f101076c, .val = 0xffffffff },
	{ .addr = 0x0f1010770, .val = 0xffffffff },
	{ .addr = 0x0f1010774, .val = 0xffffffff },
	{ .addr = 0x0f1010778, .val = 0xffffffff },
	{ .addr = 0x0f101077c, .val = 0xffffffff },
	{ .addr = 0x0f1010780, .val = 0xffffffff },
	{ .addr = 0x0f1010784, .val = 0xffffffff },
	{ .addr = 0x0f1010788, .val = 0xffffffff },
	{ .addr = 0x0f101078c, .val = 0xffffffff },
	{ .addr = 0x0f1010790, .val = 0xffffffff },
	{ .addr = 0x0f1010794, .val = 0xffffffff },
	{ .addr = 0x0f1010798, .val = 0xffffffff },
	{ .addr = 0x0f101079c, .val = 0xffffffff },
	{ .addr = 0x0f10107a0, .val = 0xffffffff },
	{ .addr = 0x0f10107a4, .val = 0xffffffff },
	{ .addr = 0x0f10107a8, .val = 0xffffffff },
	{ .addr = 0x0f10107ac, .val = 0xffffffff },
	{ .addr = 0x0f10107b0, .val = 0xffffffff },
	{ .addr = 0x0f10107b4, .val = 0xffffffff },
	{ .addr = 0x0f10107b8, .val = 0xffffffff },
	{ .addr = 0x0f10107bc, .val = 0xffffffff },
	{ .addr = 0x0f10107c0, .val = 0xffffffff },
	{ .addr = 0x0f10107c4, .val = 0xffffffff },
	{ .addr = 0x0f10107c8, .val = 0xffffffff },
	{ .addr = 0x0f10107cc, .val = 0xffffffff },
	{ .addr = 0x0f10107d0, .val = 0xffffffff },
	{ .addr = 0x0f10107d4, .val = 0xffffffff },
	{ .addr = 0x0f10107d8, .val = 0xffffffff },
	{ .addr = 0x0f10107dc, .val = 0xffffffff },
	{ .addr = 0x0f10107e0, .val = 0xffffffff },
	{ .addr = 0x0f10107e4, .val = 0xffffffff },
	{ .addr = 0x0f10107e8, .val = 0xffffffff },
	{ .addr = 0x0f10107ec, .val = 0xffffffff },
	{ .addr = 0x0f10107f0, .val = 0xffffffff },
	{ .addr = 0x0f10107f4, .val = 0xffffffff },
	{ .addr = 0x0f10107f8, .val = 0xffffffff },
	{ .addr = 0x0f10107fc, .val = 0xffffffff },
	{ .addr = 0x0f1010800, .val = 0xffffffff },
	{ .addr = 0x0f1010804, .val = 0xffffffff },
	{ .addr = 0x0f1010808, .val = 0xffffffff },
	{ .addr = 0x0f101080c, .val = 0xffffffff },
	{ .addr = 0x0f1010810, .val = 0xffffffff },
	{ .addr = 0x0f1010814, .val = 0xffffffff },
	{ .addr = 0x0f1010818, .val = 0xffffffff },
	{ .addr = 0x0f101081c, .val = 0xffffffff },
	{ .addr = 0x0f1010820, .val = 0xffffffff },
	{ .addr = 0x0f1010824, .val = 0xffffffff },
	{ .addr = 0x0f1010828, .val = 0xffffffff },
	{ .addr = 0x0f101082c, .val = 0xffffffff },
	{ .addr = 0x0f1010830, .val = 0xffffffff },
	{ .addr = 0x0f1010834, .val = 0xffffffff },
	{ .addr = 0x0f1010838, .val = 0xffffffff },
	{ .addr = 0x0f101083c, .val = 0xffffffff },
	{ .addr = 0x0f1010840, .val = 0xffffffff },
	{ .addr = 0x0f1010844, .val = 0xffffffff },
	{ .addr = 0x0f1010848, .val = 0xffffffff },
	{ .addr = 0x0f101084c, .val = 0xffffffff },
	{ .addr = 0x0f1010850, .val = 0xffffffff },
	{ .addr = 0x0f1010854, .val = 0xffffffff },
	{ .addr = 0x0f1010858, .val = 0xffffffff },
	{ .addr = 0x0f101085c, .val = 0xffffffff },
	{ .addr = 0x0f101087c, .val = 0x0000030f },
	{ .addr = 0x0f1010880, .val = 0xffffffff },
	{ .addr = 0x0f1010890, .val = 0xffffffff },
	{ .addr = 0x0f10108a0, .val = 0xffffffff },
	{ .addr = 0x0f10108b0, .val = 0xffffffff },
	{ .addr = 0x0f10108c0, .val = 0x0fffffff },
	{ .addr = 0x0f10108d0, .val = 0x0fffffff },
	{ .addr = 0x0f10108e0, .val = 0x0fffffff },
	{ .addr = 0x0f10108f0, .val = 0x0fffffff },
	{ .addr = 0x0f1010920, .val = 0xffffffff },
	{ .addr = 0x0f1010924, .val = 0xffffffff },
	{ .addr = 0x0f1010928, .val = 0x400007ff },
	{ .addr = 0x0f1011150, .val = 0xffffffff },
	{ .addr = 0x0f1011154, .val = 0xffffffff },
	{ .addr = 0x0f1011158, .val = 0xffffffff },
	{ .addr = 0x0f101115c, .val = 0xffffffff },
	{ .addr = 0x0f1011160, .val = 0xffffffff },
	{ .addr = 0x0f1011164, .val = 0xffffffff },
	{ .addr = 0x0f1011168, .val = 0xffffffff },
	{ .addr = 0x0f101116c, .val = 0xffffffff },
	{ .addr = 0x0f1011170, .val = 0xffffffff },
	{ .addr = 0x0f1011174, .val = 0xffffffff },
	{ .addr = 0x0f1011178, .val = 0xffffffff },
	{ .addr = 0x0f101117c, .val = 0xffffffff },
	{ .addr = 0x0f1011180, .val = 0xffffffff },
	{ .addr = 0x0f1011184, .val = 0xffffffff },
	{ .addr = 0x0f1011188, .val = 0xffffffff },
	{ .addr = 0x0f101118c, .val = 0xffffffff },
	{ .addr = 0x0f1011190, .val = 0xffffffff },
	{ .addr = 0x0f1011194, .val = 0xffffffff },
	{ .addr = 0x0f1011198, .val = 0xffffffff },
	{ .addr = 0x0f101119c, .val = 0xffffffff },
	{ .addr = 0x0f10111a0, .val = 0xffffffff },
	{ .addr = 0x0f10111a4, .val = 0xffffffff },
	{ .addr = 0x0f10111a8, .val = 0xffffffff },
	{ .addr = 0x0f10111ac, .val = 0xffffffff },
	{ .addr = 0x0f10111b0, .val = 0xffffffff },
	{ .addr = 0x0f10111b4, .val = 0xffffffff },
	{ .addr = 0x0f10111b8, .val = 0xffffffff },
	{ .addr = 0x0f10111bc, .val = 0x00ffffff },
	{ .addr = 0x0f10111c8, .val = 0x0000000f },
	{ .addr = 0x0f10111cc, .val = 0xffffffff },
	{ .addr = 0x0f1011200, .val = 0x03ff03ff },
	{ .addr = 0x0f1011204, .val = 0x03ff03ff },
	{ .addr = 0x0f1011208, .val = 0x03ff03ff },
	{ .addr = 0x0f101120c, .val = 0x03ff03ff },
	{ .addr = 0x0f1011210, .val = 0x03ff03ff },
	{ .addr = 0x0f1011214, .val = 0x03ff03ff },
	{ .addr = 0x0f1011218, .val = 0x03ff03ff },
	{ .addr = 0x0f101121c, .val = 0x03ff03ff },
	{ .addr = 0x0f1011220, .val = 0x03ff03ff },
	{ .addr = 0x0f1011224, .val = 0x03ff03ff },
	{ .addr = 0x0f1011228, .val = 0x03ff03ff },
	{ .addr = 0x0f101122c, .val = 0x03ff03ff },
	{ .addr = 0x0f1011230, .val = 0x03ff03ff },
	{ .addr = 0x0f1011234, .val = 0x03ff03ff },
	{ .addr = 0x0f1011238, .val = 0x03ff03ff },
	{ .addr = 0x0f101123c, .val = 0x03ff03ff },
	{ .addr = 0x0f1011240, .val = 0x03ff03ff },
	{ .addr = 0x0f1011244, .val = 0x03ff03ff },
	{ .addr = 0x0f1011248, .val = 0x03ff03ff },
	{ .addr = 0x0f101124c, .val = 0x03ff03ff },
	{ .addr = 0x0f1011250, .val = 0x03ff03ff },
	{ .addr = 0x0f1011254, .val = 0x03ff03ff },
	{ .addr = 0x0f1011258, .val = 0x03ff03ff },
	{ .addr = 0x0f101125c, .val = 0x03ff03ff },
	{ .addr = 0x0f1011260, .val = 0x03ff03ff },
	{ .addr = 0x0f1011264, .val = 0x03ff03ff },
	{ .addr = 0x0f1011268, .val = 0x03ff03ff },
	{ .addr = 0x0f101126c, .val = 0x03ff03ff },
	{ .addr = 0x0f1011270, .val = 0x03ff03ff },
	{ .addr = 0x0f1011274, .val = 0x03ff03ff },
	{ .addr = 0x0f1011278, .val = 0x03ff03ff },
	{ .addr = 0x0f101127c, .val = 0x03ff03ff },
	{ .addr = 0x0f1011280, .val = 0x03ff03ff },
	{ .addr = 0x0f1011284, .val = 0x03ff03ff },
	{ .addr = 0x0f1011288, .val = 0x03ff03ff },
	{ .addr = 0x0f101128c, .val = 0x03ff03ff },
	{ .addr = 0x0f1011290, .val = 0x03ff03ff },
	{ .addr = 0x0f1011294, .val = 0x03ff03ff },
	{ .addr = 0x0f1011298, .val = 0x03ff03ff },
	{ .addr = 0x0f101129c, .val = 0x03ff03ff },
	{ .addr = 0x0f10112a0, .val = 0x03ff03ff },
	{ .addr = 0x0f10112a4, .val = 0x03ff03ff },
	{ .addr = 0x0f10112a8, .val = 0x03ff03ff },
	{ .addr = 0x0f10112ac, .val = 0x03ff03ff },
	{ .addr = 0x0f10112b0, .val = 0x03ff03ff },
	{ .addr = 0x0f10112b4, .val = 0x03ff03ff },
	{ .addr = 0x0f10112b8, .val = 0x03ff03ff },
	{ .addr = 0x0f10112bc, .val = 0x03ff03ff },
	{ .addr = 0x0f10112c0, .val = 0x03ff03ff },
	{ .addr = 0x0f10112c4, .val = 0x03ff03ff },
	{ .addr = 0x0f10112c8, .val = 0x03ff03ff },
	{ .addr = 0x0f10112cc, .val = 0x03ff03ff },
	{ .addr = 0x0f10112d0, .val = 0x03ff03ff },
	{ .addr = 0x0f10112d4, .val = 0x03ff03ff },
	{ .addr = 0x0f10112d8, .val = 0x03ff03ff },
	{ .addr = 0x0f10112dc, .val = 0x03ff03ff },
	{ .addr = 0x0f10112e0, .val = 0x03ff03ff },
	{ .addr = 0x0f10112e4, .val = 0x03ff03ff },
	{ .addr = 0x0f10112e8, .val = 0x03ff03ff },
	{ .addr = 0x0f10112ec, .val = 0x03ff03ff },
	{ .addr = 0x0f10112f0, .val = 0x03ff03ff },
	{ .addr = 0x0f10112f4, .val = 0x03ff03ff },
	{ .addr = 0x0f10112f8, .val = 0x03ff03ff },
	{ .addr = 0x0f10112fc, .val = 0x03ff03ff },
	{ .addr = 0x0f1011300, .val = 0x03ff03ff },
	{ .addr = 0x0f1011304, .val = 0x03ff03ff },
	{ .addr = 0x0f1011308, .val = 0x03ff03ff },
	{ .addr = 0x0f101130c, .val = 0x03ff03ff },
	{ .addr = 0x0f1011310, .val = 0x03ff03ff },
	{ .addr = 0x0f1011314, .val = 0x03ff03ff },
	{ .addr = 0x0f1011318, .val = 0x03ff03ff },
	{ .addr = 0x0f101131c, .val = 0x03ff03ff },
	{ .addr = 0x0f1011320, .val = 0x03ff03ff },
	{ .addr = 0x0f1011324, .val = 0x03ff03ff },
	{ .addr = 0x0f1011328, .val = 0x03ff03ff },
	{ .addr = 0x0f101132c, .val = 0x03ff03ff },
	{ .addr = 0x0f1011330, .val = 0x03ff03ff },
	{ .addr = 0x0f1011334, .val = 0x03ff03ff },
	{ .addr = 0x0f1011338, .val = 0x03ff03ff },
	{ .addr = 0x0f101133c, .val = 0x03ff03ff },
	{ .addr = 0x0f1011340, .val = 0x03ff03ff },
	{ .addr = 0x0f1011344, .val = 0x03ff03ff },
	{ .addr = 0x0f1011348, .val = 0x03ff03ff },
	{ .addr = 0x0f101134c, .val = 0x03ff03ff },
	{ .addr = 0x0f1011350, .val = 0x03ff03ff },
	{ .addr = 0x0f1011354, .val = 0x03ff03ff },
	{ .addr = 0x0f1011358, .val = 0x03ff03ff },
	{ .addr = 0x0f101135c, .val = 0x03ff03ff },
	{ .addr = 0x0f1011360, .val = 0x03ff03ff },
	{ .addr = 0x0f1011364, .val = 0x03ff03ff },
	{ .addr = 0x0f1011368, .val = 0x03ff03ff },
	{ .addr = 0x0f101136c, .val = 0x03ff03ff },
	{ .addr = 0x0f1011370, .val = 0x03ff03ff },
	{ .addr = 0x0f1011374, .val = 0x03ff03ff },
	{ .addr = 0x0f1011378, .val = 0x03ff03ff },
	{ .addr = 0x0f101137c, .val = 0x03ff03ff },
	{ .addr = 0x0f1011380, .val = 0x03ff03ff },
	{ .addr = 0x0f1011384, .val = 0x03ff03ff },
	{ .addr = 0x0f1011388, .val = 0x03ff03ff },
	{ .addr = 0x0f101138c, .val = 0x03ff03ff },
	{ .addr = 0x0f1011390, .val = 0x03ff03ff },
	{ .addr = 0x0f1011394, .val = 0x03ff03ff },
	{ .addr = 0x0f1011398, .val = 0x03ff03ff },
	{ .addr = 0x0f101139c, .val = 0x03ff03ff },
	{ .addr = 0x0f10113a0, .val = 0x03ff03ff },
	{ .addr = 0x0f10113a4, .val = 0x03ff03ff },
	{ .addr = 0x0f10113a8, .val = 0x03ff03ff },
	{ .addr = 0x0f10113ac, .val = 0x03ff03ff },
	{ .addr = 0x0f10113b0, .val = 0x03ff03ff },
	{ .addr = 0x0f10113b4, .val = 0x03ff03ff },
	{ .addr = 0x0f10113b8, .val = 0x03ff03ff },
	{ .addr = 0x0f10113bc, .val = 0x03ff03ff },
	{ .addr = 0x0f10113c0, .val = 0x03ff03ff },
	{ .addr = 0x0f10113c4, .val = 0x03ff03ff },
	{ .addr = 0x0f10113c8, .val = 0x03ff03ff },
	{ .addr = 0x0f10113cc, .val = 0x03ff03ff },
	{ .addr = 0x0f10113d0, .val = 0x03ff03ff },
	{ .addr = 0x0f10113d4, .val = 0x03ff03ff },
	{ .addr = 0x0f10113d8, .val = 0x03ff03ff },
	{ .addr = 0x0f10113dc, .val = 0x03ff03ff },
	{ .addr = 0x0f10113e0, .val = 0x03ff03ff },
	{ .addr = 0x0f10113e4, .val = 0x03ff03ff },
	{ .addr = 0x0f10113e8, .val = 0x03ff03ff },
	{ .addr = 0x0f10113ec, .val = 0x03ff03ff },
	{ .addr = 0x0f10113f0, .val = 0x03ff03ff },
	{ .addr = 0x0f10113f4, .val = 0x03ff03ff },
	{ .addr = 0x0f10113f8, .val = 0x03ff03ff },
	{ .addr = 0x0f10113fc, .val = 0x03ff03ff },
	{ .addr = 0x0f1020000, .val = 0x00000001 },
	{ .addr = 0x0f1020008, .val = 0x000003ff },
	{ .addr = 0x0f102000c, .val = 0x0000000f },
	{ .addr = 0x0f1020010, .val = 0xffffffff },
	{ .addr = 0x0f1020014, .val = 0xffffffff },
	{ .addr = 0x0f1020018, .val = 0xffffffff },
	{ .addr = 0x0f102001c, .val = 0xffffffff },
	{ .addr = 0x0f1020020, .val = 0xffffffff },
	{ .addr = 0x0f1020024, .val = 0xffffffff },
	{ .addr = 0x0f1020028, .val = 0xffffffff },
	{ .addr = 0x0f102002c, .val = 0xffffffff },
	{ .addr = 0x0f1020030, .val = 0xffffffff },
	{ .addr = 0x0f102007c, .val = 0x00003fff },
	{ .addr = 0x0f1020080, .val = 0x00000001 },
	{ .addr = 0x0f1020084, .val = 0x0000000f },
	{ .addr = 0x0f1020088, .val = 0x0000ffff },
	{ .addr = 0x0f102008c, .val = 0x0000ffff },
	{ .addr = 0x0f1020090, .val = 0x000fffff },
	{ .addr = 0x0f1020094, .val = 0x000fffff },
	{ .addr = 0x0f1020098, .val = 0x0000001f },
	{ .addr = 0x0f102009c, .val = 0x0000001f },
	{ .addr = 0x0f10200a0, .val = 0x000fffff },
	{ .addr = 0x0f10200a4, .val = 0x000fffff },
	{ .addr = 0x0f10200a8, .val = 0x0000001f },
	{ .addr = 0x0f10200ac, .val = 0x0000001f },
	{ .addr = 0x0f10200b0, .val = 0x0000ffff },
	{ .addr = 0x0f10200b4, .val = 0x0000ffff },
	{ .addr = 0x0f10200b8, .val = 0x000003ff },
	{ .addr = 0x0f10200bc, .val = 0xffffffff },
	{ .addr = 0x0f1020108, .val = 0x00000003 },
	{ .addr = 0x0f102010c, .val = 0xffffffff },
	{ .addr = 0x0f102011c, .val = 0x0fffffff },
	{ .addr = 0x0f1020124, .val = 0x00000001 },
	{ .addr = 0x0f102013c, .val = 0x0fffffff },
	{ .addr = 0x0f1020144, .val = 0x00000001 },
	{ .addr = 0x0f102015c, .val = 0x0fffffff },
	{ .addr = 0x0f1020164, .val = 0x00000001 },
	{ .addr = 0x0f102017c, .val = 0x0fffffff },
	{ .addr = 0x0f1020184, .val = 0x00000001 },
	{ .addr = 0x0f102019c, .val = 0x0fffffff },
	{ .addr = 0x0f10201a4, .val = 0x00000001 },
	{ .addr = 0x0f10201bc, .val = 0x0fffffff },
	{ .addr = 0x0f10201c4, .val = 0x00000001 },
	{ .addr = 0x0f10201dc, .val = 0x0fffffff },
	{ .addr = 0x0f10201e4, .val = 0x00000001 },
	{ .addr = 0x0f10201fc, .val = 0x0fffffff },
	{ .addr = 0x0f1020204, .val = 0x00000001 },
	{ .addr = 0x0f102021c, .val = 0x0fffffff },
	{ .addr = 0x0f1020224, .val = 0x00000001 },
	{ .addr = 0x0f102023c, .val = 0x0fffffff },
	{ .addr = 0x0f1020244, .val = 0x00000001 },
	{ .addr = 0x0f102025c, .val = 0x0fffffff },
	{ .addr = 0x0f1020264, .val = 0x00000001 },
	{ .addr = 0x0f102027c, .val = 0x0fffffff },
	{ .addr = 0x0f1020284, .val = 0x00000001 },
	{ .addr = 0x0f102029c, .val = 0x0fffffff },
	{ .addr = 0x0f10202a4, .val = 0x00000001 },
	{ .addr = 0x0f10202bc, .val = 0x0fffffff },
	{ .addr = 0x0f10202c4, .val = 0x00000001 },
	{ .addr = 0x0f10202dc, .val = 0x0fffffff },
	{ .addr = 0x0f10202e4, .val = 0x00000001 },
	{ .addr = 0x0f10202fc, .val = 0x0fffffff },
	{ .addr = 0x0f1020304, .val = 0x00000001 },
	{ .addr = 0x0f1020314, .val = 0x00001fff },
	{ .addr = 0x0f102031c, .val = 0xffffffff },
	{ .addr = 0x0f1020320, .val = 0x0000ffff },
	{ .addr = 0x0f10203c0, .val = 0xffffffff },
	{ .addr = 0x0f10203c4, .val = 0xffffffff },
	{ .addr = 0x0f10203c8, .val = 0xffffffff },
	{ .addr = 0x0f10203cc, .val = 0xffffffff },
	{ .addr = 0x0f10203d0, .val = 0xffffffff },
	{ .addr = 0x0f10203d4, .val = 0xffffffff },
	{ .addr = 0x0f10203d8, .val = 0xffffffff },
	{ .addr = 0x0f10203dc, .val = 0xffffffff },
	{ .addr = 0x0f10203e0, .val = 0xffffffff },
	{ .addr = 0x0f10203e4, .val = 0xffffffff },
	{ .addr = 0x0f10203e8, .val = 0xffffffff },
	{ .addr = 0x0f10203ec, .val = 0xffffffff },
	{ .addr = 0x0f10203f0, .val = 0xffffffff },
	{ .addr = 0x0f10203f4, .val = 0xffffffff },
	{ .addr = 0x0f10203f8, .val = 0xffffffff },
	{ .addr = 0x0f10203fc, .val = 0xffffffff },
	{ .addr = 0x0f11c0000, .val = 0x009ff1ff },
	{ .addr = 0x0f11c0004, .val = 0x00000001 },
	{ .addr = 0x0f11c0008, .val = 0xffffffff },
	{ .addr = 0x0f11c000c, .val = 0x0000001f },
	{ .addr = 0x0f11c0010, .val = 0x00000fff },
	{ .addr = 0x0f11c0014, .val = 0x0001ffff },
	{ .addr = 0x0f11c0034, .val = 0x7fc00000 },
	{ .addr = 0x0f11c003c, .val = 0x7fc00000 },
	{ .addr = 0x0f11c0044, .val = 0x7fc00000 },
	{ .addr = 0x0f11c0048, .val = 0x00000003 },
	{ .addr = 0x0f11c004c, .val = 0x40000020 },
	{ .addr = 0x0f11c005c, .val = 0x7fc00000 },
	{ .addr = 0x0f11c0060, .val = 0x800001ff },
	{ .addr = 0x0f11c0300, .val = 0xffffffff },
	{ .addr = 0x0f11c0304, .val = 0xffffffff },
	{ .addr = 0x0f11c0308, .val = 0xffffffff },
	{ .addr = 0x0f11c030c, .val = 0xffffffff },
	{ .addr = 0x0f11c0310, .val = 0xffffffff },
	{ .addr = 0x0f11c0314, .val = 0xffffffff },
	{ .addr = 0x0f11c0318, .val = 0xffffffff },
	{ .addr = 0x0f11c031c, .val = 0xffffffff },
	{ .addr = 0x0f11c0320, .val = 0xffffffff },
	{ .addr = 0x0f11c0324, .val = 0xffffffff },
	{ .addr = 0x0f11c0328, .val = 0xffffffff },
	{ .addr = 0x0f11c032c, .val = 0xffffffff },
	{ .addr = 0x0f11c0330, .val = 0xffffffff },
	{ .addr = 0x0f11c0334, .val = 0xffffffff },
	{ .addr = 0x0f11c0338, .val = 0xffffffff },
	{ .addr = 0x0f11c033c, .val = 0xffffffff },
	{ .addr = 0x0f11c0400, .val = 0xffffffff },
	{ .addr = 0x0f11c0404, .val = 0xffffffff },
	{ .addr = 0x0f11c0408, .val = 0xffffffff },
	{ .addr = 0x0f11c040c, .val = 0xffffffff },
	{ .addr = 0x0f11c0410, .val = 0xffffffff },
	{ .addr = 0x0f11c0414, .val = 0xffffffff },
	{ .addr = 0x0f11c0418, .val = 0xffffffff },
	{ .addr = 0x0f11c041c, .val = 0xffffffff },
	{ .addr = 0x0f11c0420, .val = 0xffffffff },
	{ .addr = 0x0f11c0424, .val = 0xffffffff },
	{ .addr = 0x0f11c0428, .val = 0xffffffff },
	{ .addr = 0x0f11c042c, .val = 0xffffffff },
	{ .addr = 0x0f11c0430, .val = 0xffffffff },
	{ .addr = 0x0f11c0434, .val = 0xffffffff },
	{ .addr = 0x0f11c0438, .val = 0xffffffff },
	{ .addr = 0x0f11c043c, .val = 0xffffffff },
	{ .addr = 0x0f0080004, .val = 0x0000ffff },
	{ .addr = 0x0f008000c, .val = 0x0000ffff },
	{ .addr = 0x0f0080010, .val = 0xffffffff },
	{ .addr = 0x0f0080014, .val = 0xffffffff },
	{ .addr = 0x0f008001c, .val = 0x0000ffff },
	{ .addr = 0x0f0080020, .val = 0x00ffffff },
	{ .addr = 0x0f0080024, .val = 0x00ffffff },
	{ .addr = 0x0f0080028, .val = 0x00ffffff },
	{ .addr = 0x0f008002c, .val = 0x00ffffff },
	{ .addr = 0x0f0080030, .val = 0x00ffffff },
	{ .addr = 0x0f0080034, .val = 0x00ffffff },
	{ .addr = 0x0f0080038, .val = 0x00ffffff },
	{ .addr = 0x0f008003c, .val = 0x00ffffff },
	{ .addr = 0x0f0080040, .val = 0x00ffffff },
	{ .addr = 0x0f0080044, .val = 0x00ffffff },
	{ .addr = 0x0f0080048, .val = 0x00ffffff },
	{ .addr = 0x0f008004c, .val = 0x00ffffff },
	{ .addr = 0x0f0080050, .val = 0x00ffffff },
	{ .addr = 0x0f0080054, .val = 0x00ffffff },
	{ .addr = 0x0f0080058, .val = 0x00ffffff },
	{ .addr = 0x0f008005c, .val = 0x00ffffff },
	{ .addr = 0x0f0080400, .val = 0x0000ffff },
	{ .addr = 0x0f0080404, .val = 0x0000ffff },
	{ .addr = 0x0f0080408, .val = 0x0000ffff },
	{ .addr = 0x0f008040c, .val = 0x0000ffff },
	{ .addr = 0x0f0080410, .val = 0x0000ffff },
	{ .addr = 0x0f0080414, .val = 0x0000ffff },
	{ .addr = 0x0f0080418, .val = 0x0000ffff },
	{ .addr = 0x0f008041c, .val = 0x0000ffff },
	{ .addr = 0x0f0080420, .val = 0x0000ffff },
	{ .addr = 0x0f0080424, .val = 0x0000ffff },
	{ .addr = 0x0f0080428, .val = 0x0000ffff },
	{ .addr = 0x0f008042c, .val = 0x0000ffff },
	{ .addr = 0x0f0080430, .val = 0x0000ffff },
	{ .addr = 0x0f0080434, .val = 0x0000ffff },
	{ .addr = 0x0f0080438, .val = 0x0000ffff },
	{ .addr = 0x0f008043c, .val = 0x0000ffff },
	{ .addr = 0x0f0080440, .val = 0x0000ffff },
	{ .addr = 0x0f0080444, .val = 0x0000ffff },
	{ .addr = 0x0f0080448, .val = 0x0000ffff },
	{ .addr = 0x0f008044c, .val = 0x0000ffff },
	{ .addr = 0x0f0080450, .val = 0x0000ffff },
	{ .addr = 0x0f0080454, .val = 0x0000ffff },
	{ .addr = 0x0f0080458, .val = 0x0000ffff },
	{ .addr = 0x0f008045c, .val = 0x0000ffff },
	{ .addr = 0x0f0080460, .val = 0x0000ffff },
	{ .addr = 0x0f0080464, .val = 0x0000ffff },
	{ .addr = 0x0f0080468, .val = 0x0000ffff },
	{ .addr = 0x0f008046c, .val = 0x0000ffff },
	{ .addr = 0x0f0080470, .val = 0x0000ffff },
	{ .addr = 0x0f0080474, .val = 0x0000ffff },
	{ .addr = 0x0f0080478, .val = 0x0000ffff },
	{ .addr = 0x0f008047c, .val = 0x0000ffff },
	{ .addr = 0x0f00804c0, .val = 0x0000ffff },
	{ .addr = 0x0f00804c4, .val = 0x0000ffff },
	{ .addr = 0x0f00804c8, .val = 0x0000ffff },
	{ .addr = 0x0f00804cc, .val = 0x0000ffff },
	{ .addr = 0x0f00804d0, .val = 0x0000ffff },
	{ .addr = 0x0f00804d4, .val = 0x0000ffff },
	{ .addr = 0x0f00804d8, .val = 0x0000ffff },
	{ .addr = 0x0f00804dc, .val = 0x0000ffff },
	{ .addr = 0x0f00804e0, .val = 0x0000ffff },
	{ .addr = 0x0f00804e4, .val = 0x0000ffff },
	{ .addr = 0x0f00804e8, .val = 0x0000ffff },
	{ .addr = 0x0f00804ec, .val = 0x0000ffff },
	{ .addr = 0x0f00804f0, .val = 0x0000ffff },
	{ .addr = 0x0f00804f4, .val = 0x0000ffff },
	{ .addr = 0x0f00804f8, .val = 0x0000ffff },
	{ .addr = 0x0f00804fc, .val = 0x0000ffff },
	{ .addr = 0x0f0080500, .val = 0x0000ffff },
	{ .addr = 0x0f0080504, .val = 0x0000ffff },
	{ .addr = 0x0f0080508, .val = 0x0000ffff },
	{ .addr = 0x0f008050c, .val = 0x0000ffff },
	{ .addr = 0x0f0080510, .val = 0x0000ffff },
	{ .addr = 0x0f0080514, .val = 0x0000ffff },
	{ .addr = 0x0f0080518, .val = 0x0000ffff },
	{ .addr = 0x0f008051c, .val = 0x0000ffff },
	{ .addr = 0x0f0080520, .val = 0x0000ffff },
	{ .addr = 0x0f0080524, .val = 0x0000ffff },
	{ .addr = 0x0f0080528, .val = 0x0000ffff },
	{ .addr = 0x0f008052c, .val = 0x0000ffff },
	{ .addr = 0x0f0080530, .val = 0x0000ffff },
	{ .addr = 0x0f0080534, .val = 0x0000ffff },
	{ .addr = 0x0f0080538, .val = 0x0000ffff },
	{ .addr = 0x0f008053c, .val = 0x0000ffff },
	{ .addr = 0x0f0080540, .val = 0xffffffff },
	{ .addr = 0x0f0080544, .val = 0xffffffff },
	{ .addr = 0x0f0080548, .val = 0xffffffff },
	{ .addr = 0x0f008054c, .val = 0xffffffff },
	{ .addr = 0x0f0080550, .val = 0xffffffff },
	{ .addr = 0x0f0080554, .val = 0xffffffff },
	{ .addr = 0x0f0080558, .val = 0xffffffff },
	{ .addr = 0x0f008055c, .val = 0xffffffff },
	{ .addr = 0x0f0080560, .val = 0xffffffff },
	{ .addr = 0x0f0080564, .val = 0xffffffff },
	{ .addr = 0x0f0080568, .val = 0xffffffff },
	{ .addr = 0x0f008056c, .val = 0xffffffff },
	{ .addr = 0x0f0080570, .val = 0xffffffff },
	{ .addr = 0x0f0080574, .val = 0xffffffff },
	{ .addr = 0x0f0080578, .val = 0xffffffff },
	{ .addr = 0x0f008057c, .val = 0xffffffff },
	{ .addr = 0x0f0080580, .val = 0x000000ff },
	{ .addr = 0x0f0080584, .val = 0x000000ff },
	{ .addr = 0x0f0080588, .val = 0x000000ff },
	{ .addr = 0x0f008058c, .val = 0x000000ff },
	{ .addr = 0x0f0080590, .val = 0x000000ff },
	{ .addr = 0x0f0080594, .val = 0x000000ff },
	{ .addr = 0x0f0080598, .val = 0x000000ff },
	{ .addr = 0x0f008059c, .val = 0x000000ff },
	{ .addr = 0x0f00805a0, .val = 0x000000ff },
	{ .addr = 0x0f00805a4, .val = 0x000000ff },
	{ .addr = 0x0f00805a8, .val = 0x000000ff },
	{ .addr = 0x0f00805ac, .val = 0x000000ff },
	{ .addr = 0x0f00805b0, .val = 0x000000ff },
	{ .addr = 0x0f00805b4, .val = 0x000000ff },
	{ .addr = 0x0f00805b8, .val = 0x000000ff },
	{ .addr = 0x0f00805bc, .val = 0x000000ff },
	{ .addr = 0x0f0080740, .val = 0xffffffff },
	{ .addr = 0x0f0080744, .val = 0xffffffff },
	{ .addr = 0x0f0080748, .val = 0xffffffff },
	{ .addr = 0x0f008074c, .val = 0xffffffff },
	{ .addr = 0x0f0080750, .val = 0xffffffff },
	{ .addr = 0x0f0080754, .val = 0xffffffff },
	{ .addr = 0x0f0080758, .val = 0xffffffff },
	{ .addr = 0x0f008075c, .val = 0xffffffff },
	{ .addr = 0x0f0080760, .val = 0xffffffff },
	{ .addr = 0x0f0080764, .val = 0xffffffff },
	{ .addr = 0x0f0080768, .val = 0xffffffff },
	{ .addr = 0x0f008076c, .val = 0xffffffff },
	{ .addr = 0x0f0080770, .val = 0xffffffff },
	{ .addr = 0x0f0080774, .val = 0xffffffff },
	{ .addr = 0x0f0080778, .val = 0xffffffff },
	{ .addr = 0x0f008077c, .val = 0xffffffff },
	{ .addr = 0x0f0b08000, .val = 0x00000001 },
	{ .addr = 0x0f0b08004, .val = 0x00000001 },
	{ .addr = 0x0f0b08008, .val = 0x00000001 },
	{ .addr = 0x0f0b0800c, .val = 0x00000001 },
	{ .addr = 0x0f0b08010, .val = 0x00000001 },
	{ .addr = 0x0f0b08014, .val = 0x00000001 },
	{ .addr = 0x0f0b08800, .val = 0x00000001 },
	{ .addr = 0x0f0b08804, .val = 0x00000001 },
	{ .addr = 0x0f0b08808, .val = 0x00000001 },
	{ .addr = 0x0f0b0880c, .val = 0x00000001 },
	{ .addr = 0x0f0b08810, .val = 0x00000001 },
	{ .addr = 0x0f0b08814, .val = 0x00000001 },
	{ .addr = 0x0f0b08818, .val = 0x00000001 },
	{ .addr = 0x0f0b0881c, .val = 0x00000001 },
	{ .addr = 0x0f0b08820, .val = 0x00000001 },
	{ .addr = 0x0f0b08824, .val = 0x00000001 },
	{ .addr = 0x0f0b08828, .val = 0x00000001 },
	{ .addr = 0x0f0b0882c, .val = 0x00000001 },
	{ .addr = 0x0f0b08830, .val = 0x00000001 },
	{ .addr = 0x0f0b08834, .val = 0x00000001 },
	{ .addr = 0x0f0b08838, .val = 0x00000001 },
	{ .addr = 0x0f0b0883c, .val = 0x00000001 },
	{ .addr = 0x0f0b09400, .val = 0x00000001 },
	{ .addr = 0x0f0b09800, .val = 0x000003ff },
	{ .addr = 0x0f0b09804, .val = 0x000003ff },
	{ .addr = 0x0f0b09808, .val = 0x000003ff },
	{ .addr = 0x0f0b0980c, .val = 0x000003ff },
	{ .addr = 0x0f0b09810, .val = 0x000003ff },
	{ .addr = 0x0f0b09814, .val = 0x000003ff },
	{ .addr = 0x0f0b09818, .val = 0x000003ff },
	{ .addr = 0x0f0b0981c, .val = 0x000003ff },
	{ .addr = 0x0f0b09820, .val = 0x000003ff },
	{ .addr = 0x0f0b09824, .val = 0x000003ff },
	{ .addr = 0x0f0b09828, .val = 0x000003ff },
	{ .addr = 0x0f0b0982c, .val = 0x000003ff },
	{ .addr = 0x0f0b09830, .val = 0x000003ff },
	{ .addr = 0x0f0b09834, .val = 0x000003ff },
	{ .addr = 0x0f0b09838, .val = 0x000003ff },
	{ .addr = 0x0f0b0983c, .val = 0x000003ff },
	{ .addr = 0x0f0b0a000, .val = 0xffffffff },
	{ .addr = 0x0f0b0a004, .val = 0xffffffff },
	{ .addr = 0x0f0b0a008, .val = 0xffffffff },
	{ .addr = 0x0f0b0a00c, .val = 0xffffffff },
	{ .addr = 0x0f0b0a010, .val = 0xffffffff },
	{ .addr = 0x0f0b0a014, .val = 0xffffffff },
	{ .addr = 0x0f0b0a018, .val = 0xffffffff },
	{ .addr = 0x0f0b0a01c, .val = 0xffffffff },
	{ .addr = 0x0f0b0a020, .val = 0xffffffff },
	{ .addr = 0x0f0b0a024, .val = 0xffffffff },
	{ .addr = 0x0f0b0a028, .val = 0xffffffff },
	{ .addr = 0x0f0b0a02c, .val = 0xffffffff },
	{ .addr = 0x0f0b0a030, .val = 0xffffffff },
	{ .addr = 0x0f0b0a034, .val = 0xffffffff },
	{ .addr = 0x0f0b0a038, .val = 0xffffffff },
	{ .addr = 0x0f0b0a03c, .val = 0xffffffff },
	{ .addr = 0x0f0b0b000, .val = 0x00000001 },
	{ .addr = 0x0f0b0b004, .val = 0x00000001 },
	{ .addr = 0x0f0b0b008, .val = 0x00000001 },
	{ .addr = 0x0f0b0b00c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b010, .val = 0x00000001 },
	{ .addr = 0x0f0b0b014, .val = 0x00000001 },
	{ .addr = 0x0f0b0b018, .val = 0x00000001 },
	{ .addr = 0x0f0b0b01c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b020, .val = 0x00000001 },
	{ .addr = 0x0f0b0b024, .val = 0x00000001 },
	{ .addr = 0x0f0b0b028, .val = 0x00000001 },
	{ .addr = 0x0f0b0b02c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b030, .val = 0x00000001 },
	{ .addr = 0x0f0b0b034, .val = 0x00000001 },
	{ .addr = 0x0f0b0b038, .val = 0x00000001 },
	{ .addr = 0x0f0b0b03c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b040, .val = 0x00000001 },
	{ .addr = 0x0f0b0b044, .val = 0x00000001 },
	{ .addr = 0x0f0b0b048, .val = 0x00000001 },
	{ .addr = 0x0f0b0b04c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b050, .val = 0x00000001 },
	{ .addr = 0x0f0b0b054, .val = 0x00000001 },
	{ .addr = 0x0f0b0b058, .val = 0x00000001 },
	{ .addr = 0x0f0b0b05c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b060, .val = 0x00000001 },
	{ .addr = 0x0f0b0b064, .val = 0x00000001 },
	{ .addr = 0x0f0b0b068, .val = 0x00000001 },
	{ .addr = 0x0f0b0b06c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b070, .val = 0x00000001 },
	{ .addr = 0x0f0b0b074, .val = 0x00000001 },
	{ .addr = 0x0f0b0b078, .val = 0x00000001 },
	{ .addr = 0x0f0b0b07c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b080, .val = 0x00000001 },
	{ .addr = 0x0f0b0b084, .val = 0x00000001 },
	{ .addr = 0x0f0b0b088, .val = 0x00000001 },
	{ .addr = 0x0f0b0b08c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b090, .val = 0x00000001 },
	{ .addr = 0x0f0b0b094, .val = 0x00000001 },
	{ .addr = 0x0f0b0b098, .val = 0x00000001 },
	{ .addr = 0x0f0b0b09c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0a0, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0a4, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0a8, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0ac, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0b0, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0b4, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0b8, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0bc, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0c0, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0c4, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0c8, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0cc, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0d0, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0d4, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0d8, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0dc, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0e0, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0e4, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0e8, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0ec, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0f0, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0f4, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0f8, .val = 0x00000001 },
	{ .addr = 0x0f0b0b0fc, .val = 0x00000001 },
	{ .addr = 0x0f0b0b100, .val = 0x00000001 },
	{ .addr = 0x0f0b0b104, .val = 0x00000001 },
	{ .addr = 0x0f0b0b108, .val = 0x00000001 },
	{ .addr = 0x0f0b0b10c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b110, .val = 0x00000001 },
	{ .addr = 0x0f0b0b114, .val = 0x00000001 },
	{ .addr = 0x0f0b0b118, .val = 0x00000001 },
	{ .addr = 0x0f0b0b11c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b120, .val = 0x00000001 },
	{ .addr = 0x0f0b0b124, .val = 0x00000001 },
	{ .addr = 0x0f0b0b128, .val = 0x00000001 },
	{ .addr = 0x0f0b0b12c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b130, .val = 0x00000001 },
	{ .addr = 0x0f0b0b134, .val = 0x00000001 },
	{ .addr = 0x0f0b0b138, .val = 0x00000001 },
	{ .addr = 0x0f0b0b13c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b140, .val = 0x00000001 },
	{ .addr = 0x0f0b0b144, .val = 0x00000001 },
	{ .addr = 0x0f0b0b148, .val = 0x00000001 },
	{ .addr = 0x0f0b0b14c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b150, .val = 0x00000001 },
	{ .addr = 0x0f0b0b154, .val = 0x00000001 },
	{ .addr = 0x0f0b0b158, .val = 0x00000001 },
	{ .addr = 0x0f0b0b15c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b160, .val = 0x00000001 },
	{ .addr = 0x0f0b0b164, .val = 0x00000001 },
	{ .addr = 0x0f0b0b168, .val = 0x00000001 },
	{ .addr = 0x0f0b0b16c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b170, .val = 0x00000001 },
	{ .addr = 0x0f0b0b174, .val = 0x00000001 },
	{ .addr = 0x0f0b0b178, .val = 0x00000001 },
	{ .addr = 0x0f0b0b17c, .val = 0x00000001 },
	{ .addr = 0x0f0b0b400, .val = 0x00000007 },
	{ .addr = 0x0f0b0b404, .val = 0x00000007 },
	{ .addr = 0x0f0b0b408, .val = 0x00000007 },
	{ .addr = 0x0f0b0b40c, .val = 0x00000007 },
	{ .addr = 0x0f0b0b410, .val = 0x00000007 },
	{ .addr = 0x0f0b0b414, .val = 0x00000007 },
	{ .addr = 0x0f0b0b418, .val = 0x00000007 },
	{ .addr = 0x0f0b0b41c, .val = 0x00000007 },
	{ .addr = 0x0f0b0b420, .val = 0x00000007 },
	{ .addr = 0x0f0b0b424, .val = 0x00000007 },
	{ .addr = 0x0f0b0b428, .val = 0x00000007 },
	{ .addr = 0x0f0b0b42c, .val = 0x00000007 },
	{ .addr = 0x0f0b0b430, .val = 0x00000007 },
	{ .addr = 0x0f0b0b434, .val = 0x00000007 },
	{ .addr = 0x0f0b0b438, .val = 0x00000007 },
	{ .addr = 0x0f0b0b43c, .val = 0x00000007 },
	{ .addr = 0x0f0b0b440, .val = 0x00000007 },
	{ .addr = 0x0f0b0b444, .val = 0x00000007 },
	{ .addr = 0x0f0b0b448, .val = 0x00000007 },
	{ .addr = 0x0f0b0b44c, .val = 0x00000007 },
	{ .addr = 0x0f0b0b450, .val = 0x00000007 },
	{ .addr = 0x0f0b0b454, .val = 0x00000007 },
	{ .addr = 0x0f0b0b458, .val = 0x00000007 },
	{ .addr = 0x0f0b0b45c, .val = 0x00000007 },
	{ .addr = 0x0f0b0b460, .val = 0x00000007 },
	{ .addr = 0x0f0b0b464, .val = 0x00000007 },
	{ .addr = 0x0f0b0b468, .val = 0x00000007 },
	{ .addr = 0x0f0b0b46c, .val = 0x00000007 },
	{ .addr = 0x0f0b0b470, .val = 0x00000007 },
	{ .addr = 0x0f0b0b474, .val = 0x00000007 },
	{ .addr = 0x0f0b0b478, .val = 0x00000007 },
	{ .addr = 0x0f0b0b47c, .val = 0x00000007 },
	{ .addr = 0x0f0b0b480, .val = 0x00000007 },
	{ .addr = 0x0f0b0b484, .val = 0x00000007 },
	{ .addr = 0x0f0b0b488, .val = 0x00000007 },
	{ .addr = 0x0f0b0b48c, .val = 0x00000007 },
	{ .addr = 0x0f0b0b490, .val = 0x00000007 },
	{ .addr = 0x0f0b0b494, .val = 0x00000007 },
	{ .addr = 0x0f0b0b498, .val = 0x00000007 },
	{ .addr = 0x0f0b0b49c, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4a0, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4a4, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4a8, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4ac, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4b0, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4b4, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4b8, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4bc, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4c0, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4c4, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4c8, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4cc, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4d0, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4d4, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4d8, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4dc, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4e0, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4e4, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4e8, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4ec, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4f0, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4f4, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4f8, .val = 0x00000007 },
	{ .addr = 0x0f0b0b4fc, .val = 0x00000007 },
	{ .addr = 0x0f0b0b500, .val = 0x00000007 },
	{ .addr = 0x0f0b0b504, .val = 0x00000007 },
	{ .addr = 0x0f0b0b508, .val = 0x00000007 },
	{ .addr = 0x0f0b0b50c, .val = 0x00000007 },
	{ .addr = 0x0f0b0b510, .val = 0x00000007 },
	{ .addr = 0x0f0b0b514, .val = 0x00000007 },
	{ .addr = 0x0f0b0b518, .val = 0x00000007 },
	{ .addr = 0x0f0b0b51c, .val = 0x00000007 },
	{ .addr = 0x0f0b0b520, .val = 0x00000007 },
	{ .addr = 0x0f0b0b524, .val = 0x00000007 },
	{ .addr = 0x0f0b0b528, .val = 0x00000007 },
	{ .addr = 0x0f0b0b52c, .val = 0x00000007 },
	{ .addr = 0x0f0b0b530, .val = 0x00000007 },
	{ .addr = 0x0f0b0b534, .val = 0x00000007 },
	{ .addr = 0x0f0b0b538, .val = 0x00000007 },
	{ .addr = 0x0f0b0b53c, .val = 0x00000007 },
	{ .addr = 0x0f0b0b540, .val = 0x00000007 },
	{ .addr = 0x0f0b0b544, .val = 0x00000007 },
	{ .addr = 0x0f0b0b548, .val = 0x00000007 },
	{ .addr = 0x0f0b0b54c, .val = 0x00000007 },
	{ .addr = 0x0f0b0b550, .val = 0x00000007 },
	{ .addr = 0x0f0b0b554, .val = 0x00000007 },
	{ .addr = 0x0f0b0b558, .val = 0x00000007 },
	{ .addr = 0x0f0b0b55c, .val = 0x00000007 },
	{ .addr = 0x0f0b0b560, .val = 0x00000007 },
	{ .addr = 0x0f0b0b564, .val = 0x00000007 },
	{ .addr = 0x0f0b0b568, .val = 0x00000007 },
	{ .addr = 0x0f0b0b56c, .val = 0x00000007 },
	{ .addr = 0x0f0b0b570, .val = 0x00000007 },
	{ .addr = 0x0f0b0b574, .val = 0x00000007 },
	{ .addr = 0x0f0b0b578, .val = 0x00000007 },
	{ .addr = 0x0f0b0b57c, .val = 0x00000007 },
	{ .addr = 0x0f0b0d000, .val = 0x00000007 },
	{ .addr = 0x0f0b0d004, .val = 0x00000007 },
	{ .addr = 0x0f0b0d008, .val = 0x00000007 },
	{ .addr = 0x0f0b0d00c, .val = 0x00000007 },
	{ .addr = 0x0f0b0d010, .val = 0x00000007 },
	{ .addr = 0x0f0b0d014, .val = 0x00000007 },
	{ .addr = 0x0f0b0d018, .val = 0x00000007 },
	{ .addr = 0x0f0b0d01c, .val = 0x00000007 },
	{ .addr = 0x0f0b0d020, .val = 0x00000007 },
	{ .addr = 0x0f0b0d024, .val = 0x00000007 },
	{ .addr = 0x0f0b0d028, .val = 0x00000007 },
	{ .addr = 0x0f0b0d02c, .val = 0x00000007 },
	{ .addr = 0x0f0b0d030, .val = 0x00000007 },
	{ .addr = 0x0f0b0d034, .val = 0x00000007 },
	{ .addr = 0x0f0b0d038, .val = 0x00000007 },
	{ .addr = 0x0f0b0d03c, .val = 0x00000007 },
	{ .addr = 0x0f0b0dc00, .val = 0x00000001 },
	{ .addr = 0x0f0b0dc04, .val = 0x00000001 },
	{ .addr = 0x0f0b0dc08, .val = 0x00000001 },
	{ .addr = 0x0f0b0dc0c, .val = 0x00000001 },
	{ .addr = 0x0f0b0dc10, .val = 0x00000001 },
	{ .addr = 0x0f0b0dc14, .val = 0x00000001 },
	{ .addr = 0x0f0b0dc18, .val = 0x00000001 },
	{ .addr = 0x0f0b0dc1c, .val = 0x00000001 },
	{ .addr = 0x0f0b0e000, .val = 0x00000007 },
	{ .addr = 0x0f0b0e004, .val = 0x00000007 },
	{ .addr = 0x0f0b0e008, .val = 0x00000007 },
	{ .addr = 0x0f0b0e00c, .val = 0x00000007 },
	{ .addr = 0x0f0b0e010, .val = 0x00000007 },
	{ .addr = 0x0f0b0e014, .val = 0x00000007 },
	{ .addr = 0x0f0b0e018, .val = 0x00000007 },
	{ .addr = 0x0f0b0e01c, .val = 0x00000007 },
	{ .addr = 0x0f0b0e400, .val = 0x00000007 },
	{ .addr = 0x0f0b0e404, .val = 0x00000007 },
	{ .addr = 0x0f0b0e408, .val = 0x00000007 },
	{ .addr = 0x0f0b0e40c, .val = 0x00000007 },
	{ .addr = 0x0f0b0e410, .val = 0x00000007 },
	{ .addr = 0x0f0b0e414, .val = 0x00000007 },
	{ .addr = 0x0f0b0e418, .val = 0x00000007 },
	{ .addr = 0x0f0b0e41c, .val = 0x00000007 },
	{ .addr = 0x0f0b0e800, .val = 0xffffffff },
	{ .addr = 0x0f0b0e804, .val = 0xffffffff },
	{ .addr = 0x0f0b0e808, .val = 0xffffffff },
	{ .addr = 0x0f0b0e80c, .val = 0xffffffff },
	{ .addr = 0x0f0b0e810, .val = 0xffffffff },
	{ .addr = 0x0f0b0e814, .val = 0xffffffff },
	{ .addr = 0x0f0b0e818, .val = 0xffffffff },
	{ .addr = 0x0f0b0e81c, .val = 0xffffffff },
	{ .addr = 0x0f0b0fc00, .val = 0x00000001 },
	{ .addr = 0x0f0b0fc04, .val = 0x00000001 },
	{ .addr = 0x0f0b0fc08, .val = 0x00000001 },
	{ .addr = 0x0f0b0fc0c, .val = 0x00000001 },
	{ .addr = 0x0f0b0fc10, .val = 0x00000001 },
	{ .addr = 0x0f0b0fc14, .val = 0x00000001 },
	{ .addr = 0x0f0b0fc18, .val = 0x00000001 },
	{ .addr = 0x0f0b0fc1c, .val = 0x00000001 },
	{ .addr = 0x0f0b10000, .val = 0x0003ffff },
	{ .addr = 0x0f0b10800, .val = 0xffffffff },
	{ .addr = 0x0f0b11000, .val = 0xffffffff },
	{ .addr = 0x0f0b12000, .val = 0x00ffffff },
	{ .addr = 0x0f0b12400, .val = 0xffffffff },
	{ .addr = 0x0f0b12800, .val = 0x0000ffff },
	{ .addr = 0x0f0b12c00, .val = 0x0000ffff },
	{ .addr = 0x0f0b13000, .val = 0x000000ff },
	{ .addr = 0x0f0b13004, .val = 0x000000ff },
	{ .addr = 0x0f0b13008, .val = 0x000000ff },
	{ .addr = 0x0f0b1300c, .val = 0x000000ff },
	{ .addr = 0x0f0b13010, .val = 0x000000ff },
	{ .addr = 0x0f0b13014, .val = 0x000000ff },
	{ .addr = 0x0f0b13018, .val = 0x000000ff },
	{ .addr = 0x0f0b1301c, .val = 0x000000ff },
	{ .addr = 0x0f0b13020, .val = 0x000000ff },
	{ .addr = 0x0f0b13024, .val = 0x000000ff },
	{ .addr = 0x0f0b13028, .val = 0x000000ff },
	{ .addr = 0x0f0b1302c, .val = 0x000000ff },
	{ .addr = 0x0f0b13030, .val = 0x000000ff },
	{ .addr = 0x0f0b13034, .val = 0x000000ff },
	{ .addr = 0x0f0b13038, .val = 0x000000ff },
	{ .addr = 0x0f0b1303c, .val = 0x000000ff },
	{ .addr = 0x0f0b13400, .val = 0x000000ff },
	{ .addr = 0x0f0b13404, .val = 0x000000ff },
	{ .addr = 0x0f0b13408, .val = 0x000000ff },
	{ .addr = 0x0f0b1340c, .val = 0x000000ff },
	{ .addr = 0x0f0b13410, .val = 0x000000ff },
	{ .addr = 0x0f0b13414, .val = 0x000000ff },
	{ .addr = 0x0f0b13418, .val = 0x000000ff },
	{ .addr = 0x0f0b1341c, .val = 0x000000ff },
	{ .addr = 0x0f0b13420, .val = 0x000000ff },
	{ .addr = 0x0f0b13424, .val = 0x000000ff },
	{ .addr = 0x0f0b13428, .val = 0x000000ff },
	{ .addr = 0x0f0b1342c, .val = 0x000000ff },
	{ .addr = 0x0f0b13430, .val = 0x000000ff },
	{ .addr = 0x0f0b13434, .val = 0x000000ff },
	{ .addr = 0x0f0b13438, .val = 0x000000ff },
	{ .addr = 0x0f0b1343c, .val = 0x000000ff },
	{ .addr = 0x0f0b13440, .val = 0x000000ff },
	{ .addr = 0x0f0b13444, .val = 0x000000ff },
	{ .addr = 0x0f0b13448, .val = 0x000000ff },
	{ .addr = 0x0f0b1344c, .val = 0x000000ff },
	{ .addr = 0x0f0b13450, .val = 0x000000ff },
	{ .addr = 0x0f0b13454, .val = 0x000000ff },
	{ .addr = 0x0f0b13458, .val = 0x000000ff },
	{ .addr = 0x0f0b1345c, .val = 0x000000ff },
	{ .addr = 0x0f0b13460, .val = 0x000000ff },
	{ .addr = 0x0f0b13464, .val = 0x000000ff },
	{ .addr = 0x0f0b13468, .val = 0x000000ff },
	{ .addr = 0x0f0b1346c, .val = 0x000000ff },
	{ .addr = 0x0f0b13470, .val = 0x000000ff },
	{ .addr = 0x0f0b13474, .val = 0x000000ff },
	{ .addr = 0x0f0b13478, .val = 0x000000ff },
	{ .addr = 0x0f0b1347c, .val = 0x000000ff },
	{ .addr = 0x0f0b16400, .val = 0x000000ff },
	{ .addr = 0x0f0b17000, .val = 0xffffffff },
	{ .addr = 0x0f0b18400, .val = 0xffffffff },
	{ .addr = 0x0f0b19400, .val = 0xffffffff },
	{ .addr = 0x0f0b19404, .val = 0xffffffff },
	{ .addr = 0x0f0b19408, .val = 0xffffffff },
	{ .addr = 0x0f0b1940c, .val = 0xffffffff },
	{ .addr = 0x0f0b19410, .val = 0xffffffff },
	{ .addr = 0x0f0b19414, .val = 0xffffffff },
	{ .addr = 0x0f0b19418, .val = 0xffffffff },
	{ .addr = 0x0f0b1941c, .val = 0xffffffff },
	{ .addr = 0x0f0b20800, .val = 0xffffffff },
	{ .addr = 0x0f0b20c00, .val = 0xffffffff },
	{ .addr = 0x0f0b21000, .val = 0x0000ffff },
	{ .addr = 0x0f0b28000, .val = 0x0000ffff },
	{ .addr = 0x0f0b28c00, .val = 0x0000000f },
	{ .addr = 0x0f0b29000, .val = 0x0000000f },
	{ .addr = 0x0f0b29400, .val = 0xffffffff },
	{ .addr = 0x0f0b29404, .val = 0xffffffff },
	{ .addr = 0x0f0b29408, .val = 0xffffffff },
	{ .addr = 0x0f0b2940c, .val = 0xffffffff },
	{ .addr = 0x0f0b29410, .val = 0xffffffff },
	{ .addr = 0x0f0b29414, .val = 0xffffffff },
	{ .addr = 0x0f0b29418, .val = 0xffffffff },
	{ .addr = 0x0f0b2941c, .val = 0xffffffff },
	{ .addr = 0x0f0b29420, .val = 0xffffffff },
	{ .addr = 0x0f0b29424, .val = 0xffffffff },
	{ .addr = 0x0f0b29428, .val = 0xffffffff },
	{ .addr = 0x0f0b2942c, .val = 0xffffffff },
	{ .addr = 0x0f0b29430, .val = 0xffffffff },
	{ .addr = 0x0f0b29434, .val = 0xffffffff },
	{ .addr = 0x0f0b29438, .val = 0xffffffff },
	{ .addr = 0x0f0b2943c, .val = 0xffffffff },
	{ .addr = 0x0f0b30800, .val = 0x0000001f },
	{ .addr = 0x0f0b30c00, .val = 0xffffffff },
	{ .addr = 0x0f0b38800, .val = 0x00000001 },
	{ .addr = 0x0f0b40400, .val = 0x0000ffff },
	{ .addr = 0x0f0b40800, .val = 0x00000003 },
	{ .addr = 0x0f0b40c00, .val = 0x00000001 },
	{ .addr = 0x0f0708000, .val = 0x00000001 },
	{ .addr = 0x0f0708004, .val = 0x00000001 },
	{ .addr = 0x0f0708008, .val = 0x00000001 },
	{ .addr = 0x0f070800c, .val = 0x00000001 },
	{ .addr = 0x0f0708010, .val = 0x00000001 },
	{ .addr = 0x0f0708014, .val = 0x00000001 },
	{ .addr = 0x0f0708800, .val = 0x00000001 },
	{ .addr = 0x0f0708804, .val = 0x00000001 },
	{ .addr = 0x0f0708808, .val = 0x00000001 },
	{ .addr = 0x0f070880c, .val = 0x00000001 },
	{ .addr = 0x0f0708810, .val = 0x00000001 },
	{ .addr = 0x0f0708814, .val = 0x00000001 },
	{ .addr = 0x0f0708818, .val = 0x00000001 },
	{ .addr = 0x0f070881c, .val = 0x00000001 },
	{ .addr = 0x0f0708820, .val = 0x00000001 },
	{ .addr = 0x0f0708824, .val = 0x00000001 },
	{ .addr = 0x0f0708828, .val = 0x00000001 },
	{ .addr = 0x0f070882c, .val = 0x00000001 },
	{ .addr = 0x0f0708830, .val = 0x00000001 },
	{ .addr = 0x0f0708834, .val = 0x00000001 },
	{ .addr = 0x0f0708838, .val = 0x00000001 },
	{ .addr = 0x0f070883c, .val = 0x00000001 },
	{ .addr = 0x0f0709400, .val = 0x00000001 },
	{ .addr = 0x0f0709800, .val = 0x000003ff },
	{ .addr = 0x0f0709804, .val = 0x000003ff },
	{ .addr = 0x0f0709808, .val = 0x000003ff },
	{ .addr = 0x0f070980c, .val = 0x000003ff },
	{ .addr = 0x0f0709810, .val = 0x000003ff },
	{ .addr = 0x0f0709814, .val = 0x000003ff },
	{ .addr = 0x0f0709818, .val = 0x000003ff },
	{ .addr = 0x0f070981c, .val = 0x000003ff },
	{ .addr = 0x0f0709820, .val = 0x000003ff },
	{ .addr = 0x0f0709824, .val = 0x000003ff },
	{ .addr = 0x0f0709828, .val = 0x000003ff },
	{ .addr = 0x0f070982c, .val = 0x000003ff },
	{ .addr = 0x0f0709830, .val = 0x000003ff },
	{ .addr = 0x0f0709834, .val = 0x000003ff },
	{ .addr = 0x0f0709838, .val = 0x000003ff },
	{ .addr = 0x0f070983c, .val = 0x000003ff },
	{ .addr = 0x0f070a000, .val = 0xffffffff },
	{ .addr = 0x0f070a004, .val = 0xffffffff },
	{ .addr = 0x0f070a008, .val = 0xffffffff },
	{ .addr = 0x0f070a00c, .val = 0xffffffff },
	{ .addr = 0x0f070a010, .val = 0xffffffff },
	{ .addr = 0x0f070a014, .val = 0xffffffff },
	{ .addr = 0x0f070a018, .val = 0xffffffff },
	{ .addr = 0x0f070a01c, .val = 0xffffffff },
	{ .addr = 0x0f070a020, .val = 0xffffffff },
	{ .addr = 0x0f070a024, .val = 0xffffffff },
	{ .addr = 0x0f070a028, .val = 0xffffffff },
	{ .addr = 0x0f070a02c, .val = 0xffffffff },
	{ .addr = 0x0f070a030, .val = 0xffffffff },
	{ .addr = 0x0f070a034, .val = 0xffffffff },
	{ .addr = 0x0f070a038, .val = 0xffffffff },
	{ .addr = 0x0f070a03c, .val = 0xffffffff },
	{ .addr = 0x0f070b000, .val = 0x00000001 },
	{ .addr = 0x0f070b004, .val = 0x00000001 },
	{ .addr = 0x0f070b008, .val = 0x00000001 },
	{ .addr = 0x0f070b00c, .val = 0x00000001 },
	{ .addr = 0x0f070b010, .val = 0x00000001 },
	{ .addr = 0x0f070b014, .val = 0x00000001 },
	{ .addr = 0x0f070b018, .val = 0x00000001 },
	{ .addr = 0x0f070b01c, .val = 0x00000001 },
	{ .addr = 0x0f070b020, .val = 0x00000001 },
	{ .addr = 0x0f070b024, .val = 0x00000001 },
	{ .addr = 0x0f070b028, .val = 0x00000001 },
	{ .addr = 0x0f070b02c, .val = 0x00000001 },
	{ .addr = 0x0f070b030, .val = 0x00000001 },
	{ .addr = 0x0f070b034, .val = 0x00000001 },
	{ .addr = 0x0f070b038, .val = 0x00000001 },
	{ .addr = 0x0f070b03c, .val = 0x00000001 },
	{ .addr = 0x0f070b040, .val = 0x00000001 },
	{ .addr = 0x0f070b044, .val = 0x00000001 },
	{ .addr = 0x0f070b048, .val = 0x00000001 },
	{ .addr = 0x0f070b04c, .val = 0x00000001 },
	{ .addr = 0x0f070b050, .val = 0x00000001 },
	{ .addr = 0x0f070b054, .val = 0x00000001 },
	{ .addr = 0x0f070b058, .val = 0x00000001 },
	{ .addr = 0x0f070b05c, .val = 0x00000001 },
	{ .addr = 0x0f070b060, .val = 0x00000001 },
	{ .addr = 0x0f070b064, .val = 0x00000001 },
	{ .addr = 0x0f070b068, .val = 0x00000001 },
	{ .addr = 0x0f070b06c, .val = 0x00000001 },
	{ .addr = 0x0f070b070, .val = 0x00000001 },
	{ .addr = 0x0f070b074, .val = 0x00000001 },
	{ .addr = 0x0f070b078, .val = 0x00000001 },
	{ .addr = 0x0f070b07c, .val = 0x00000001 },
	{ .addr = 0x0f070b080, .val = 0x00000001 },
	{ .addr = 0x0f070b084, .val = 0x00000001 },
	{ .addr = 0x0f070b088, .val = 0x00000001 },
	{ .addr = 0x0f070b08c, .val = 0x00000001 },
	{ .addr = 0x0f070b090, .val = 0x00000001 },
	{ .addr = 0x0f070b094, .val = 0x00000001 },
	{ .addr = 0x0f070b098, .val = 0x00000001 },
	{ .addr = 0x0f070b09c, .val = 0x00000001 },
	{ .addr = 0x0f070b0a0, .val = 0x00000001 },
	{ .addr = 0x0f070b0a4, .val = 0x00000001 },
	{ .addr = 0x0f070b0a8, .val = 0x00000001 },
	{ .addr = 0x0f070b0ac, .val = 0x00000001 },
	{ .addr = 0x0f070b0b0, .val = 0x00000001 },
	{ .addr = 0x0f070b0b4, .val = 0x00000001 },
	{ .addr = 0x0f070b0b8, .val = 0x00000001 },
	{ .addr = 0x0f070b0bc, .val = 0x00000001 },
	{ .addr = 0x0f070b0c0, .val = 0x00000001 },
	{ .addr = 0x0f070b0c4, .val = 0x00000001 },
	{ .addr = 0x0f070b0c8, .val = 0x00000001 },
	{ .addr = 0x0f070b0cc, .val = 0x00000001 },
	{ .addr = 0x0f070b0d0, .val = 0x00000001 },
	{ .addr = 0x0f070b0d4, .val = 0x00000001 },
	{ .addr = 0x0f070b0d8, .val = 0x00000001 },
	{ .addr = 0x0f070b0dc, .val = 0x00000001 },
	{ .addr = 0x0f070b0e0, .val = 0x00000001 },
	{ .addr = 0x0f070b0e4, .val = 0x00000001 },
	{ .addr = 0x0f070b0e8, .val = 0x00000001 },
	{ .addr = 0x0f070b0ec, .val = 0x00000001 },
	{ .addr = 0x0f070b0f0, .val = 0x00000001 },
	{ .addr = 0x0f070b0f4, .val = 0x00000001 },
	{ .addr = 0x0f070b0f8, .val = 0x00000001 },
	{ .addr = 0x0f070b0fc, .val = 0x00000001 },
	{ .addr = 0x0f070b100, .val = 0x00000001 },
	{ .addr = 0x0f070b104, .val = 0x00000001 },
	{ .addr = 0x0f070b108, .val = 0x00000001 },
	{ .addr = 0x0f070b10c, .val = 0x00000001 },
	{ .addr = 0x0f070b110, .val = 0x00000001 },
	{ .addr = 0x0f070b114, .val = 0x00000001 },
	{ .addr = 0x0f070b118, .val = 0x00000001 },
	{ .addr = 0x0f070b11c, .val = 0x00000001 },
	{ .addr = 0x0f070b120, .val = 0x00000001 },
	{ .addr = 0x0f070b124, .val = 0x00000001 },
	{ .addr = 0x0f070b128, .val = 0x00000001 },
	{ .addr = 0x0f070b12c, .val = 0x00000001 },
	{ .addr = 0x0f070b130, .val = 0x00000001 },
	{ .addr = 0x0f070b134, .val = 0x00000001 },
	{ .addr = 0x0f070b138, .val = 0x00000001 },
	{ .addr = 0x0f070b13c, .val = 0x00000001 },
	{ .addr = 0x0f070b140, .val = 0x00000001 },
	{ .addr = 0x0f070b144, .val = 0x00000001 },
	{ .addr = 0x0f070b148, .val = 0x00000001 },
	{ .addr = 0x0f070b14c, .val = 0x00000001 },
	{ .addr = 0x0f070b150, .val = 0x00000001 },
	{ .addr = 0x0f070b154, .val = 0x00000001 },
	{ .addr = 0x0f070b158, .val = 0x00000001 },
	{ .addr = 0x0f070b15c, .val = 0x00000001 },
	{ .addr = 0x0f070b160, .val = 0x00000001 },
	{ .addr = 0x0f070b164, .val = 0x00000001 },
	{ .addr = 0x0f070b168, .val = 0x00000001 },
	{ .addr = 0x0f070b16c, .val = 0x00000001 },
	{ .addr = 0x0f070b170, .val = 0x00000001 },
	{ .addr = 0x0f070b174, .val = 0x00000001 },
	{ .addr = 0x0f070b178, .val = 0x00000001 },
	{ .addr = 0x0f070b17c, .val = 0x00000001 },
	{ .addr = 0x0f070b400, .val = 0x00000007 },
	{ .addr = 0x0f070b404, .val = 0x00000007 },
	{ .addr = 0x0f070b408, .val = 0x00000007 },
	{ .addr = 0x0f070b40c, .val = 0x00000007 },
	{ .addr = 0x0f070b410, .val = 0x00000007 },
	{ .addr = 0x0f070b414, .val = 0x00000007 },
	{ .addr = 0x0f070b418, .val = 0x00000007 },
	{ .addr = 0x0f070b41c, .val = 0x00000007 },
	{ .addr = 0x0f070b420, .val = 0x00000007 },
	{ .addr = 0x0f070b424, .val = 0x00000007 },
	{ .addr = 0x0f070b428, .val = 0x00000007 },
	{ .addr = 0x0f070b42c, .val = 0x00000007 },
	{ .addr = 0x0f070b430, .val = 0x00000007 },
	{ .addr = 0x0f070b434, .val = 0x00000007 },
	{ .addr = 0x0f070b438, .val = 0x00000007 },
	{ .addr = 0x0f070b43c, .val = 0x00000007 },
	{ .addr = 0x0f070b440, .val = 0x00000007 },
	{ .addr = 0x0f070b444, .val = 0x00000007 },
	{ .addr = 0x0f070b448, .val = 0x00000007 },
	{ .addr = 0x0f070b44c, .val = 0x00000007 },
	{ .addr = 0x0f070b450, .val = 0x00000007 },
	{ .addr = 0x0f070b454, .val = 0x00000007 },
	{ .addr = 0x0f070b458, .val = 0x00000007 },
	{ .addr = 0x0f070b45c, .val = 0x00000007 },
	{ .addr = 0x0f070b460, .val = 0x00000007 },
	{ .addr = 0x0f070b464, .val = 0x00000007 },
	{ .addr = 0x0f070b468, .val = 0x00000007 },
	{ .addr = 0x0f070b46c, .val = 0x00000007 },
	{ .addr = 0x0f070b470, .val = 0x00000007 },
	{ .addr = 0x0f070b474, .val = 0x00000007 },
	{ .addr = 0x0f070b478, .val = 0x00000007 },
	{ .addr = 0x0f070b47c, .val = 0x00000007 },
	{ .addr = 0x0f070b480, .val = 0x00000007 },
	{ .addr = 0x0f070b484, .val = 0x00000007 },
	{ .addr = 0x0f070b488, .val = 0x00000007 },
	{ .addr = 0x0f070b48c, .val = 0x00000007 },
	{ .addr = 0x0f070b490, .val = 0x00000007 },
	{ .addr = 0x0f070b494, .val = 0x00000007 },
	{ .addr = 0x0f070b498, .val = 0x00000007 },
	{ .addr = 0x0f070b49c, .val = 0x00000007 },
	{ .addr = 0x0f070b4a0, .val = 0x00000007 },
	{ .addr = 0x0f070b4a4, .val = 0x00000007 },
	{ .addr = 0x0f070b4a8, .val = 0x00000007 },
	{ .addr = 0x0f070b4ac, .val = 0x00000007 },
	{ .addr = 0x0f070b4b0, .val = 0x00000007 },
	{ .addr = 0x0f070b4b4, .val = 0x00000007 },
	{ .addr = 0x0f070b4b8, .val = 0x00000007 },
	{ .addr = 0x0f070b4bc, .val = 0x00000007 },
	{ .addr = 0x0f070b4c0, .val = 0x00000007 },
	{ .addr = 0x0f070b4c4, .val = 0x00000007 },
	{ .addr = 0x0f070b4c8, .val = 0x00000007 },
	{ .addr = 0x0f070b4cc, .val = 0x00000007 },
	{ .addr = 0x0f070b4d0, .val = 0x00000007 },
	{ .addr = 0x0f070b4d4, .val = 0x00000007 },
	{ .addr = 0x0f070b4d8, .val = 0x00000007 },
	{ .addr = 0x0f070b4dc, .val = 0x00000007 },
	{ .addr = 0x0f070b4e0, .val = 0x00000007 },
	{ .addr = 0x0f070b4e4, .val = 0x00000007 },
	{ .addr = 0x0f070b4e8, .val = 0x00000007 },
	{ .addr = 0x0f070b4ec, .val = 0x00000007 },
	{ .addr = 0x0f070b4f0, .val = 0x00000007 },
	{ .addr = 0x0f070b4f4, .val = 0x00000007 },
	{ .addr = 0x0f070b4f8, .val = 0x00000007 },
	{ .addr = 0x0f070b4fc, .val = 0x00000007 },
	{ .addr = 0x0f070b500, .val = 0x00000007 },
	{ .addr = 0x0f070b504, .val = 0x00000007 },
	{ .addr = 0x0f070b508, .val = 0x00000007 },
	{ .addr = 0x0f070b50c, .val = 0x00000007 },
	{ .addr = 0x0f070b510, .val = 0x00000007 },
	{ .addr = 0x0f070b514, .val = 0x00000007 },
	{ .addr = 0x0f070b518, .val = 0x00000007 },
	{ .addr = 0x0f070b51c, .val = 0x00000007 },
	{ .addr = 0x0f070b520, .val = 0x00000007 },
	{ .addr = 0x0f070b524, .val = 0x00000007 },
	{ .addr = 0x0f070b528, .val = 0x00000007 },
	{ .addr = 0x0f070b52c, .val = 0x00000007 },
	{ .addr = 0x0f070b530, .val = 0x00000007 },
	{ .addr = 0x0f070b534, .val = 0x00000007 },
	{ .addr = 0x0f070b538, .val = 0x00000007 },
	{ .addr = 0x0f070b53c, .val = 0x00000007 },
	{ .addr = 0x0f070b540, .val = 0x00000007 },
	{ .addr = 0x0f070b544, .val = 0x00000007 },
	{ .addr = 0x0f070b548, .val = 0x00000007 },
	{ .addr = 0x0f070b54c, .val = 0x00000007 },
	{ .addr = 0x0f070b550, .val = 0x00000007 },
	{ .addr = 0x0f070b554, .val = 0x00000007 },
	{ .addr = 0x0f070b558, .val = 0x00000007 },
	{ .addr = 0x0f070b55c, .val = 0x00000007 },
	{ .addr = 0x0f070b560, .val = 0x00000007 },
	{ .addr = 0x0f070b564, .val = 0x00000007 },
	{ .addr = 0x0f070b568, .val = 0x00000007 },
	{ .addr = 0x0f070b56c, .val = 0x00000007 },
	{ .addr = 0x0f070b570, .val = 0x00000007 },
	{ .addr = 0x0f070b574, .val = 0x00000007 },
	{ .addr = 0x0f070b578, .val = 0x00000007 },
	{ .addr = 0x0f070b57c, .val = 0x00000007 },
	{ .addr = 0x0f070d000, .val = 0x00000007 },
	{ .addr = 0x0f070d004, .val = 0x00000007 },
	{ .addr = 0x0f070d008, .val = 0x00000007 },
	{ .addr = 0x0f070d00c, .val = 0x00000007 },
	{ .addr = 0x0f070d010, .val = 0x00000007 },
	{ .addr = 0x0f070d014, .val = 0x00000007 },
	{ .addr = 0x0f070d018, .val = 0x00000007 },
	{ .addr = 0x0f070d01c, .val = 0x00000007 },
	{ .addr = 0x0f070d020, .val = 0x00000007 },
	{ .addr = 0x0f070d024, .val = 0x00000007 },
	{ .addr = 0x0f070d028, .val = 0x00000007 },
	{ .addr = 0x0f070d02c, .val = 0x00000007 },
	{ .addr = 0x0f070d030, .val = 0x00000007 },
	{ .addr = 0x0f070d034, .val = 0x00000007 },
	{ .addr = 0x0f070d038, .val = 0x00000007 },
	{ .addr = 0x0f070d03c, .val = 0x00000007 },
	{ .addr = 0x0f070dc00, .val = 0x00000001 },
	{ .addr = 0x0f070dc04, .val = 0x00000001 },
	{ .addr = 0x0f070dc08, .val = 0x00000001 },
	{ .addr = 0x0f070dc0c, .val = 0x00000001 },
	{ .addr = 0x0f070dc10, .val = 0x00000001 },
	{ .addr = 0x0f070dc14, .val = 0x00000001 },
	{ .addr = 0x0f070dc18, .val = 0x00000001 },
	{ .addr = 0x0f070dc1c, .val = 0x00000001 },
	{ .addr = 0x0f070e000, .val = 0x00000007 },
	{ .addr = 0x0f070e004, .val = 0x00000007 },
	{ .addr = 0x0f070e008, .val = 0x00000007 },
	{ .addr = 0x0f070e00c, .val = 0x00000007 },
	{ .addr = 0x0f070e010, .val = 0x00000007 },
	{ .addr = 0x0f070e014, .val = 0x00000007 },
	{ .addr = 0x0f070e018, .val = 0x00000007 },
	{ .addr = 0x0f070e01c, .val = 0x00000007 },
	{ .addr = 0x0f070e400, .val = 0x00000007 },
	{ .addr = 0x0f070e404, .val = 0x00000007 },
	{ .addr = 0x0f070e408, .val = 0x00000007 },
	{ .addr = 0x0f070e40c, .val = 0x00000007 },
	{ .addr = 0x0f070e410, .val = 0x00000007 },
	{ .addr = 0x0f070e414, .val = 0x00000007 },
	{ .addr = 0x0f070e418, .val = 0x00000007 },
	{ .addr = 0x0f070e41c, .val = 0x00000007 },
	{ .addr = 0x0f070e800, .val = 0xffffffff },
	{ .addr = 0x0f070e804, .val = 0xffffffff },
	{ .addr = 0x0f070e808, .val = 0xffffffff },
	{ .addr = 0x0f070e80c, .val = 0xffffffff },
	{ .addr = 0x0f070e810, .val = 0xffffffff },
	{ .addr = 0x0f070e814, .val = 0xffffffff },
	{ .addr = 0x0f070e818, .val = 0xffffffff },
	{ .addr = 0x0f070e81c, .val = 0xffffffff },
	{ .addr = 0x0f070fc00, .val = 0x00000001 },
	{ .addr = 0x0f070fc04, .val = 0x00000001 },
	{ .addr = 0x0f070fc08, .val = 0x00000001 },
	{ .addr = 0x0f070fc0c, .val = 0x00000001 },
	{ .addr = 0x0f070fc10, .val = 0x00000001 },
	{ .addr = 0x0f070fc14, .val = 0x00000001 },
	{ .addr = 0x0f070fc18, .val = 0x00000001 },
	{ .addr = 0x0f070fc1c, .val = 0x00000001 },
	{ .addr = 0x0f0710000, .val = 0x0003ffff },
	{ .addr = 0x0f0710800, .val = 0xffffffff },
	{ .addr = 0x0f0711000, .val = 0xffffffff },
	{ .addr = 0x0f0712000, .val = 0x00ffffff },
	{ .addr = 0x0f0712400, .val = 0xffffffff },
	{ .addr = 0x0f0712800, .val = 0x0000ffff },
	{ .addr = 0x0f0712c00, .val = 0x0000ffff },
	{ .addr = 0x0f0713000, .val = 0x000000ff },
	{ .addr = 0x0f0713004, .val = 0x000000ff },
	{ .addr = 0x0f0713008, .val = 0x000000ff },
	{ .addr = 0x0f071300c, .val = 0x000000ff },
	{ .addr = 0x0f0713010, .val = 0x000000ff },
	{ .addr = 0x0f0713014, .val = 0x000000ff },
	{ .addr = 0x0f0713018, .val = 0x000000ff },
	{ .addr = 0x0f071301c, .val = 0x000000ff },
	{ .addr = 0x0f0713020, .val = 0x000000ff },
	{ .addr = 0x0f0713024, .val = 0x000000ff },
	{ .addr = 0x0f0713028, .val = 0x000000ff },
	{ .addr = 0x0f071302c, .val = 0x000000ff },
	{ .addr = 0x0f0713030, .val = 0x000000ff },
	{ .addr = 0x0f0713034, .val = 0x000000ff },
	{ .addr = 0x0f0713038, .val = 0x000000ff },
	{ .addr = 0x0f071303c, .val = 0x000000ff },
	{ .addr = 0x0f0713400, .val = 0x000000ff },
	{ .addr = 0x0f0713404, .val = 0x000000ff },
	{ .addr = 0x0f0713408, .val = 0x000000ff },
	{ .addr = 0x0f071340c, .val = 0x000000ff },
	{ .addr = 0x0f0713410, .val = 0x000000ff },
	{ .addr = 0x0f0713414, .val = 0x000000ff },
	{ .addr = 0x0f0713418, .val = 0x000000ff },
	{ .addr = 0x0f071341c, .val = 0x000000ff },
	{ .addr = 0x0f0713420, .val = 0x000000ff },
	{ .addr = 0x0f0713424, .val = 0x000000ff },
	{ .addr = 0x0f0713428, .val = 0x000000ff },
	{ .addr = 0x0f071342c, .val = 0x000000ff },
	{ .addr = 0x0f0713430, .val = 0x000000ff },
	{ .addr = 0x0f0713434, .val = 0x000000ff },
	{ .addr = 0x0f0713438, .val = 0x000000ff },
	{ .addr = 0x0f071343c, .val = 0x000000ff },
	{ .addr = 0x0f0713440, .val = 0x000000ff },
	{ .addr = 0x0f0713444, .val = 0x000000ff },
	{ .addr = 0x0f0713448, .val = 0x000000ff },
	{ .addr = 0x0f071344c, .val = 0x000000ff },
	{ .addr = 0x0f0713450, .val = 0x000000ff },
	{ .addr = 0x0f0713454, .val = 0x000000ff },
	{ .addr = 0x0f0713458, .val = 0x000000ff },
	{ .addr = 0x0f071345c, .val = 0x000000ff },
	{ .addr = 0x0f0713460, .val = 0x000000ff },
	{ .addr = 0x0f0713464, .val = 0x000000ff },
	{ .addr = 0x0f0713468, .val = 0x000000ff },
	{ .addr = 0x0f071346c, .val = 0x000000ff },
	{ .addr = 0x0f0713470, .val = 0x000000ff },
	{ .addr = 0x0f0713474, .val = 0x000000ff },
	{ .addr = 0x0f0713478, .val = 0x000000ff },
	{ .addr = 0x0f071347c, .val = 0x000000ff },
	{ .addr = 0x0f0716400, .val = 0x000000ff },
	{ .addr = 0x0f0717000, .val = 0xffffffff },
	{ .addr = 0x0f0718400, .val = 0xffffffff },
	{ .addr = 0x0f0719400, .val = 0xffffffff },
	{ .addr = 0x0f0719404, .val = 0xffffffff },
	{ .addr = 0x0f0719408, .val = 0xffffffff },
	{ .addr = 0x0f071940c, .val = 0xffffffff },
	{ .addr = 0x0f0719410, .val = 0xffffffff },
	{ .addr = 0x0f0719414, .val = 0xffffffff },
	{ .addr = 0x0f0719418, .val = 0xffffffff },
	{ .addr = 0x0f071941c, .val = 0xffffffff },
	{ .addr = 0x0f0720800, .val = 0xffffffff },
	{ .addr = 0x0f0720c00, .val = 0xffffffff },
	{ .addr = 0x0f0721000, .val = 0x0000ffff },
	{ .addr = 0x0f0728000, .val = 0x0000ffff },
	{ .addr = 0x0f0728c00, .val = 0x0000000f },
	{ .addr = 0x0f0729000, .val = 0x0000000f },
	{ .addr = 0x0f0729400, .val = 0xffffffff },
	{ .addr = 0x0f0729404, .val = 0xffffffff },
	{ .addr = 0x0f0729408, .val = 0xffffffff },
	{ .addr = 0x0f072940c, .val = 0xffffffff },
	{ .addr = 0x0f0729410, .val = 0xffffffff },
	{ .addr = 0x0f0729414, .val = 0xffffffff },
	{ .addr = 0x0f0729418, .val = 0xffffffff },
	{ .addr = 0x0f072941c, .val = 0xffffffff },
	{ .addr = 0x0f0729420, .val = 0xffffffff },
	{ .addr = 0x0f0729424, .val = 0xffffffff },
	{ .addr = 0x0f0729428, .val = 0xffffffff },
	{ .addr = 0x0f072942c, .val = 0xffffffff },
	{ .addr = 0x0f0729430, .val = 0xffffffff },
	{ .addr = 0x0f0729434, .val = 0xffffffff },
	{ .addr = 0x0f0729438, .val = 0xffffffff },
	{ .addr = 0x0f072943c, .val = 0xffffffff },
	{ .addr = 0x0f0730800, .val = 0x0000001f },
	{ .addr = 0x0f0730c00, .val = 0xffffffff },
	{ .addr = 0x0f0738800, .val = 0x00000001 },
	{ .addr = 0x0f0740400, .val = 0x0000ffff },
	{ .addr = 0x0f0740800, .val = 0x00000003 },
	{ .addr = 0x0f0740c00, .val = 0x00000001 },
};

const struct test_reg mem_zero[] = {
	{ .addr = 0x00f0090000, .val = 0x00000000 },
	{ .addr = 0x00f0090004, .val = 0x00000000 },
	{ .addr = 0x00f0090008, .val = 0x00000000 },
	{ .addr = 0x00f009000c, .val = 0x00000000 },
	{ .addr = 0x00f0090010, .val = 0x00000000 },
	{ .addr = 0x00f0090014, .val = 0x00000000 },
	{ .addr = 0x00f0090018, .val = 0x00000000 },
	{ .addr = 0x00f009001c, .val = 0x00000000 },
	{ .addr = 0x00f0090020, .val = 0x00000000 },
	{ .addr = 0x00f0090024, .val = 0x00000000 },
	{ .addr = 0x00f0090028, .val = 0x00000000 },
	{ .addr = 0x00f009002c, .val = 0x00000000 },
	{ .addr = 0x00f0090030, .val = 0x00000000 },
	{ .addr = 0x00f0090034, .val = 0x00000000 },
	{ .addr = 0x00f0090038, .val = 0x00000000 },
	{ .addr = 0x00f009003c, .val = 0x00000000 },
	{ .addr = 0x00f0090040, .val = 0x00000000 },
	{ .addr = 0x00f0090044, .val = 0x00000000 },
	{ .addr = 0x00f0090048, .val = 0x00000000 },
	{ .addr = 0x00f009004c, .val = 0x00000000 },
	{ .addr = 0x00f0090050, .val = 0x00000000 },
	{ .addr = 0x00f0090054, .val = 0x00000000 },
	{ .addr = 0x00f0090058, .val = 0x00000000 },
	{ .addr = 0x00f009005c, .val = 0x00000000 },
	{ .addr = 0x00f0090060, .val = 0x00000000 },
	{ .addr = 0x00f0090064, .val = 0x00000000 },
	{ .addr = 0x00f0090068, .val = 0x00000000 },
	{ .addr = 0x00f009006c, .val = 0x00000000 },
	{ .addr = 0x00f0090070, .val = 0x00000000 },
	{ .addr = 0x00f0090074, .val = 0x00000000 },
	{ .addr = 0x00f0090078, .val = 0x00000000 },
	{ .addr = 0x00f009007c, .val = 0x00000000 },
	{ .addr = 0x00f0090080, .val = 0x00000000 },
	{ .addr = 0x00f0090084, .val = 0x00000000 },
	{ .addr = 0x00f0090088, .val = 0x00000000 },
	{ .addr = 0x00f009008c, .val = 0x00000000 },
	{ .addr = 0x00f0090090, .val = 0x00000000 },
	{ .addr = 0x00f0090094, .val = 0x00000000 },
	{ .addr = 0x00f0090098, .val = 0x00000000 },
	{ .addr = 0x00f009009c, .val = 0x00000000 },
	{ .addr = 0x00f00900a0, .val = 0x00000000 },
	{ .addr = 0x00f00900a4, .val = 0x00000000 },
	{ .addr = 0x00f00900a8, .val = 0x00000000 },
	{ .addr = 0x00f00900ac, .val = 0x00000000 },
	{ .addr = 0x00f00900b0, .val = 0x00000000 },
	{ .addr = 0x00f00900b4, .val = 0x00000000 },
	{ .addr = 0x00f00900b8, .val = 0x00000000 },
	{ .addr = 0x00f00900bc, .val = 0x00000000 },
	{ .addr = 0x00f00900c0, .val = 0x00000000 },
	{ .addr = 0x00f00900c4, .val = 0x00000000 },
	{ .addr = 0x00f00900c8, .val = 0x00000000 },
	{ .addr = 0x00f00900cc, .val = 0x00000000 },
	{ .addr = 0x00f00900d0, .val = 0x00000000 },
	{ .addr = 0x00f00900d4, .val = 0x00000000 },
	{ .addr = 0x00f00900d8, .val = 0x00000000 },
	{ .addr = 0x00f00900dc, .val = 0x00000000 },
	{ .addr = 0x00f00900e0, .val = 0x00000000 },
	{ .addr = 0x00f00900e4, .val = 0x00000000 },
	{ .addr = 0x00f00900e8, .val = 0x00000000 },
	{ .addr = 0x00f00900ec, .val = 0x00000000 },
	{ .addr = 0x00f00900f0, .val = 0x00000000 },
	{ .addr = 0x00f00900f4, .val = 0x00000000 },
	{ .addr = 0x00f00900f8, .val = 0x00000000 },
	{ .addr = 0x00f00900fc, .val = 0x00000000 },
	{ .addr = 0x00f0090100, .val = 0x00000000 },
	{ .addr = 0x00f0090104, .val = 0x00000000 },
	{ .addr = 0x00f0090108, .val = 0x00000000 },
	{ .addr = 0x00f009010c, .val = 0x00000000 },
	{ .addr = 0x00f0090110, .val = 0x00000000 },
	{ .addr = 0x00f0090114, .val = 0x00000000 },
	{ .addr = 0x00f0090118, .val = 0x00000000 },
	{ .addr = 0x00f009011c, .val = 0x00000000 },
	{ .addr = 0x00f0090120, .val = 0x00000000 },
	{ .addr = 0x00f0090124, .val = 0x00000000 },
	{ .addr = 0x00f0090128, .val = 0x00000000 },
	{ .addr = 0x00f009012c, .val = 0x00000000 },
	{ .addr = 0x00f0090130, .val = 0x00000000 },
	{ .addr = 0x00f0090134, .val = 0x00000000 },
	{ .addr = 0x00f0090138, .val = 0x00000000 },
	{ .addr = 0x00f009013c, .val = 0x00000000 },
	{ .addr = 0x00f0090140, .val = 0x00000000 },
	{ .addr = 0x00f0090144, .val = 0x00000000 },
	{ .addr = 0x00f0090148, .val = 0x00000000 },
	{ .addr = 0x00f009014c, .val = 0x00000000 },
	{ .addr = 0x00f0090150, .val = 0x00000000 },
	{ .addr = 0x00f0090154, .val = 0x00000000 },
	{ .addr = 0x00f0090158, .val = 0x00000000 },
	{ .addr = 0x00f009015c, .val = 0x00000000 },
	{ .addr = 0x00f0090160, .val = 0x00000000 },
	{ .addr = 0x00f0090164, .val = 0x00000000 },
	{ .addr = 0x00f0090168, .val = 0x00000000 },
	{ .addr = 0x00f009016c, .val = 0x00000000 },
	{ .addr = 0x00f0090170, .val = 0x00000000 },
	{ .addr = 0x00f0090174, .val = 0x00000000 },
	{ .addr = 0x00f0090178, .val = 0x00000000 },
	{ .addr = 0x00f009017c, .val = 0x00000000 },
	{ .addr = 0x00f0090180, .val = 0x00000000 },
	{ .addr = 0x00f0090184, .val = 0x00000000 },
	{ .addr = 0x00f0090188, .val = 0x00000000 },
	{ .addr = 0x00f009018c, .val = 0x00000000 },
	{ .addr = 0x00f0090190, .val = 0x00000000 },
	{ .addr = 0x00f0090194, .val = 0x00000000 },
	{ .addr = 0x00f0090198, .val = 0x00000000 },
	{ .addr = 0x00f009019c, .val = 0x00000000 },
	{ .addr = 0x00f00901a0, .val = 0x00000000 },
	{ .addr = 0x00f00901a4, .val = 0x00000000 },
	{ .addr = 0x00f00901a8, .val = 0x00000000 },
	{ .addr = 0x00f00901ac, .val = 0x00000000 },
	{ .addr = 0x00f00901b0, .val = 0x00000000 },
	{ .addr = 0x00f00901b4, .val = 0x00000000 },
	{ .addr = 0x00f00901b8, .val = 0x00000000 },
	{ .addr = 0x00f00901bc, .val = 0x00000000 },
	{ .addr = 0x00f00901c0, .val = 0x00000000 },
	{ .addr = 0x00f00901c4, .val = 0x00000000 },
	{ .addr = 0x00f00901c8, .val = 0x00000000 },
	{ .addr = 0x00f00901cc, .val = 0x00000000 },
	{ .addr = 0x00f00901d0, .val = 0x00000000 },
	{ .addr = 0x00f00901d4, .val = 0x00000000 },
	{ .addr = 0x00f00901d8, .val = 0x00000000 },
	{ .addr = 0x00f00901dc, .val = 0x00000000 },
	{ .addr = 0x00f00901e0, .val = 0x00000000 },
	{ .addr = 0x00f00901e4, .val = 0x00000000 },
	{ .addr = 0x00f00901e8, .val = 0x00000000 },
	{ .addr = 0x00f00901ec, .val = 0x00000000 },
	{ .addr = 0x00f00901f0, .val = 0x00000000 },
	{ .addr = 0x00f00901f4, .val = 0x00000000 },
	{ .addr = 0x00f00901f8, .val = 0x00000000 },
	{ .addr = 0x00f00901fc, .val = 0x00000000 },
	{ .addr = 0x00f0091000, .val = 0x00000000 },
	{ .addr = 0x00f0091004, .val = 0x00000000 },
	{ .addr = 0x00f0091008, .val = 0x00000000 },
	{ .addr = 0x00f009100c, .val = 0x00000000 },
	{ .addr = 0x00f0091010, .val = 0x00000000 },
	{ .addr = 0x00f0091014, .val = 0x00000000 },
	{ .addr = 0x00f0091018, .val = 0x00000000 },
	{ .addr = 0x00f009101c, .val = 0x00000000 },
	{ .addr = 0x00f0091020, .val = 0x00000000 },
	{ .addr = 0x00f0091024, .val = 0x00000000 },
	{ .addr = 0x00f0091028, .val = 0x00000000 },
	{ .addr = 0x00f009102c, .val = 0x00000000 },
	{ .addr = 0x00f0091030, .val = 0x00000000 },
	{ .addr = 0x00f0091034, .val = 0x00000000 },
	{ .addr = 0x00f0091038, .val = 0x00000000 },
	{ .addr = 0x00f009103c, .val = 0x00000000 },
	{ .addr = 0x00f0091040, .val = 0x00000000 },
	{ .addr = 0x00f0091044, .val = 0x00000000 },
	{ .addr = 0x00f0091048, .val = 0x00000000 },
	{ .addr = 0x00f009104c, .val = 0x00000000 },
	{ .addr = 0x00f0091050, .val = 0x00000000 },
	{ .addr = 0x00f0091054, .val = 0x00000000 },
	{ .addr = 0x00f0091058, .val = 0x00000000 },
	{ .addr = 0x00f009105c, .val = 0x00000000 },
	{ .addr = 0x00f0091060, .val = 0x00000000 },
	{ .addr = 0x00f0091064, .val = 0x00000000 },
	{ .addr = 0x00f0091068, .val = 0x00000000 },
	{ .addr = 0x00f009106c, .val = 0x00000000 },
	{ .addr = 0x00f0091070, .val = 0x00000000 },
	{ .addr = 0x00f0091074, .val = 0x00000000 },
	{ .addr = 0x00f0091078, .val = 0x00000000 },
	{ .addr = 0x00f009107c, .val = 0x00000000 },
	{ .addr = 0x00f0091080, .val = 0x00000000 },
	{ .addr = 0x00f0091084, .val = 0x00000000 },
	{ .addr = 0x00f0091088, .val = 0x00000000 },
	{ .addr = 0x00f009108c, .val = 0x00000000 },
	{ .addr = 0x00f0091090, .val = 0x00000000 },
	{ .addr = 0x00f0091094, .val = 0x00000000 },
	{ .addr = 0x00f0091098, .val = 0x00000000 },
	{ .addr = 0x00f009109c, .val = 0x00000000 },
	{ .addr = 0x00f00910a0, .val = 0x00000000 },
	{ .addr = 0x00f00910a4, .val = 0x00000000 },
	{ .addr = 0x00f00910a8, .val = 0x00000000 },
	{ .addr = 0x00f00910ac, .val = 0x00000000 },
	{ .addr = 0x00f00910b0, .val = 0x00000000 },
	{ .addr = 0x00f00910b4, .val = 0x00000000 },
	{ .addr = 0x00f00910b8, .val = 0x00000000 },
	{ .addr = 0x00f00910bc, .val = 0x00000000 },
	{ .addr = 0x00f00910c0, .val = 0x00000000 },
	{ .addr = 0x00f00910c4, .val = 0x00000000 },
	{ .addr = 0x00f00910c8, .val = 0x00000000 },
	{ .addr = 0x00f00910cc, .val = 0x00000000 },
	{ .addr = 0x00f00910d0, .val = 0x00000000 },
	{ .addr = 0x00f00910d4, .val = 0x00000000 },
	{ .addr = 0x00f00910d8, .val = 0x00000000 },
	{ .addr = 0x00f00910dc, .val = 0x00000000 },
	{ .addr = 0x00f00910e0, .val = 0x00000000 },
	{ .addr = 0x00f00910e4, .val = 0x00000000 },
	{ .addr = 0x00f00910e8, .val = 0x00000000 },
	{ .addr = 0x00f00910ec, .val = 0x00000000 },
	{ .addr = 0x00f00910f0, .val = 0x00000000 },
	{ .addr = 0x00f00910f4, .val = 0x00000000 },
	{ .addr = 0x00f00910f8, .val = 0x00000000 },
	{ .addr = 0x00f00910fc, .val = 0x00000000 },
	{ .addr = 0x00f0091100, .val = 0x00000000 },
	{ .addr = 0x00f0091104, .val = 0x00000000 },
	{ .addr = 0x00f0091108, .val = 0x00000000 },
	{ .addr = 0x00f009110c, .val = 0x00000000 },
	{ .addr = 0x00f0091110, .val = 0x00000000 },
	{ .addr = 0x00f0091114, .val = 0x00000000 },
	{ .addr = 0x00f0091118, .val = 0x00000000 },
	{ .addr = 0x00f009111c, .val = 0x00000000 },
	{ .addr = 0x00f0091120, .val = 0x00000000 },
	{ .addr = 0x00f0091124, .val = 0x00000000 },
	{ .addr = 0x00f0091128, .val = 0x00000000 },
	{ .addr = 0x00f009112c, .val = 0x00000000 },
	{ .addr = 0x00f0091130, .val = 0x00000000 },
	{ .addr = 0x00f0091134, .val = 0x00000000 },
	{ .addr = 0x00f0091138, .val = 0x00000000 },
	{ .addr = 0x00f009113c, .val = 0x00000000 },
	{ .addr = 0x00f0091140, .val = 0x00000000 },
	{ .addr = 0x00f0091144, .val = 0x00000000 },
	{ .addr = 0x00f0091148, .val = 0x00000000 },
	{ .addr = 0x00f009114c, .val = 0x00000000 },
	{ .addr = 0x00f0091150, .val = 0x00000000 },
	{ .addr = 0x00f0091154, .val = 0x00000000 },
	{ .addr = 0x00f0091158, .val = 0x00000000 },
	{ .addr = 0x00f009115c, .val = 0x00000000 },
	{ .addr = 0x00f0091160, .val = 0x00000000 },
	{ .addr = 0x00f0091164, .val = 0x00000000 },
	{ .addr = 0x00f0091168, .val = 0x00000000 },
	{ .addr = 0x00f009116c, .val = 0x00000000 },
	{ .addr = 0x00f0091170, .val = 0x00000000 },
	{ .addr = 0x00f0091174, .val = 0x00000000 },
	{ .addr = 0x00f0091178, .val = 0x00000000 },
	{ .addr = 0x00f009117c, .val = 0x00000000 },
	{ .addr = 0x00f0091180, .val = 0x00000000 },
	{ .addr = 0x00f0091184, .val = 0x00000000 },
	{ .addr = 0x00f0091188, .val = 0x00000000 },
	{ .addr = 0x00f009118c, .val = 0x00000000 },
	{ .addr = 0x00f0091190, .val = 0x00000000 },
	{ .addr = 0x00f0091194, .val = 0x00000000 },
	{ .addr = 0x00f0091198, .val = 0x00000000 },
	{ .addr = 0x00f009119c, .val = 0x00000000 },
	{ .addr = 0x00f00911a0, .val = 0x00000000 },
	{ .addr = 0x00f00911a4, .val = 0x00000000 },
	{ .addr = 0x00f00911a8, .val = 0x00000000 },
	{ .addr = 0x00f00911ac, .val = 0x00000000 },
	{ .addr = 0x00f00911b0, .val = 0x00000000 },
	{ .addr = 0x00f00911b4, .val = 0x00000000 },
	{ .addr = 0x00f00911b8, .val = 0x00000000 },
	{ .addr = 0x00f00911bc, .val = 0x00000000 },
	{ .addr = 0x00f00911c0, .val = 0x00000000 },
	{ .addr = 0x00f00911c4, .val = 0x00000000 },
	{ .addr = 0x00f00911c8, .val = 0x00000000 },
	{ .addr = 0x00f00911cc, .val = 0x00000000 },
	{ .addr = 0x00f00911d0, .val = 0x00000000 },
	{ .addr = 0x00f00911d4, .val = 0x00000000 },
	{ .addr = 0x00f00911d8, .val = 0x00000000 },
	{ .addr = 0x00f00911dc, .val = 0x00000000 },
	{ .addr = 0x00f00911e0, .val = 0x00000000 },
	{ .addr = 0x00f00911e4, .val = 0x00000000 },
	{ .addr = 0x00f00911e8, .val = 0x00000000 },
	{ .addr = 0x00f00911ec, .val = 0x00000000 },
	{ .addr = 0x00f00911f0, .val = 0x00000000 },
	{ .addr = 0x00f00911f4, .val = 0x00000000 },
	{ .addr = 0x00f00911f8, .val = 0x00000000 },
	{ .addr = 0x00f00911fc, .val = 0x00000000 },
	{ .addr = 0x00f0092000, .val = 0x00000000 },
	{ .addr = 0x00f0092004, .val = 0x00000000 },
	{ .addr = 0x00f0092008, .val = 0x00000000 },
	{ .addr = 0x00f009200c, .val = 0x00000000 },
	{ .addr = 0x00f0092010, .val = 0x00000000 },
	{ .addr = 0x00f0092014, .val = 0x00000000 },
	{ .addr = 0x00f0092018, .val = 0x00000000 },
	{ .addr = 0x00f009201c, .val = 0x00000000 },
	{ .addr = 0x00f0092020, .val = 0x00000000 },
	{ .addr = 0x00f0092024, .val = 0x00000000 },
	{ .addr = 0x00f0092028, .val = 0x00000000 },
	{ .addr = 0x00f009202c, .val = 0x00000000 },
	{ .addr = 0x00f0092030, .val = 0x00000000 },
	{ .addr = 0x00f0092034, .val = 0x00000000 },
	{ .addr = 0x00f0092038, .val = 0x00000000 },
	{ .addr = 0x00f009203c, .val = 0x00000000 },
	{ .addr = 0x00f0092040, .val = 0x00000000 },
	{ .addr = 0x00f0092044, .val = 0x00000000 },
	{ .addr = 0x00f0092048, .val = 0x00000000 },
	{ .addr = 0x00f009204c, .val = 0x00000000 },
	{ .addr = 0x00f0092050, .val = 0x00000000 },
	{ .addr = 0x00f0092054, .val = 0x00000000 },
	{ .addr = 0x00f0092058, .val = 0x00000000 },
	{ .addr = 0x00f009205c, .val = 0x00000000 },
	{ .addr = 0x00f0092060, .val = 0x00000000 },
	{ .addr = 0x00f0092064, .val = 0x00000000 },
	{ .addr = 0x00f0092068, .val = 0x00000000 },
	{ .addr = 0x00f009206c, .val = 0x00000000 },
	{ .addr = 0x00f0092070, .val = 0x00000000 },
	{ .addr = 0x00f0092074, .val = 0x00000000 },
	{ .addr = 0x00f0092078, .val = 0x00000000 },
	{ .addr = 0x00f009207c, .val = 0x00000000 },
	{ .addr = 0x00f0092080, .val = 0x00000000 },
	{ .addr = 0x00f0092084, .val = 0x00000000 },
	{ .addr = 0x00f0092088, .val = 0x00000000 },
	{ .addr = 0x00f009208c, .val = 0x00000000 },
	{ .addr = 0x00f0092090, .val = 0x00000000 },
	{ .addr = 0x00f0092094, .val = 0x00000000 },
	{ .addr = 0x00f0092098, .val = 0x00000000 },
	{ .addr = 0x00f009209c, .val = 0x00000000 },
	{ .addr = 0x00f00920a0, .val = 0x00000000 },
	{ .addr = 0x00f00920a4, .val = 0x00000000 },
	{ .addr = 0x00f00920a8, .val = 0x00000000 },
	{ .addr = 0x00f00920ac, .val = 0x00000000 },
	{ .addr = 0x00f00920b0, .val = 0x00000000 },
	{ .addr = 0x00f00920b4, .val = 0x00000000 },
	{ .addr = 0x00f00920b8, .val = 0x00000000 },
	{ .addr = 0x00f00920bc, .val = 0x00000000 },
	{ .addr = 0x00f00920c0, .val = 0x00000000 },
	{ .addr = 0x00f00920c4, .val = 0x00000000 },
	{ .addr = 0x00f00920c8, .val = 0x00000000 },
	{ .addr = 0x00f00920cc, .val = 0x00000000 },
	{ .addr = 0x00f00920d0, .val = 0x00000000 },
	{ .addr = 0x00f00920d4, .val = 0x00000000 },
	{ .addr = 0x00f00920d8, .val = 0x00000000 },
	{ .addr = 0x00f00920dc, .val = 0x00000000 },
	{ .addr = 0x00f00920e0, .val = 0x00000000 },
	{ .addr = 0x00f00920e4, .val = 0x00000000 },
	{ .addr = 0x00f00920e8, .val = 0x00000000 },
	{ .addr = 0x00f00920ec, .val = 0x00000000 },
	{ .addr = 0x00f00920f0, .val = 0x00000000 },
	{ .addr = 0x00f00920f4, .val = 0x00000000 },
	{ .addr = 0x00f00920f8, .val = 0x00000000 },
	{ .addr = 0x00f00920fc, .val = 0x00000000 },
	{ .addr = 0x00f0092100, .val = 0x00000000 },
	{ .addr = 0x00f0092104, .val = 0x00000000 },
	{ .addr = 0x00f0092108, .val = 0x00000000 },
	{ .addr = 0x00f009210c, .val = 0x00000000 },
	{ .addr = 0x00f0092110, .val = 0x00000000 },
	{ .addr = 0x00f0092114, .val = 0x00000000 },
	{ .addr = 0x00f0092118, .val = 0x00000000 },
	{ .addr = 0x00f009211c, .val = 0x00000000 },
	{ .addr = 0x00f0092120, .val = 0x00000000 },
	{ .addr = 0x00f0092124, .val = 0x00000000 },
	{ .addr = 0x00f0092128, .val = 0x00000000 },
	{ .addr = 0x00f009212c, .val = 0x00000000 },
	{ .addr = 0x00f0092130, .val = 0x00000000 },
	{ .addr = 0x00f0092134, .val = 0x00000000 },
	{ .addr = 0x00f0092138, .val = 0x00000000 },
	{ .addr = 0x00f009213c, .val = 0x00000000 },
	{ .addr = 0x00f0092140, .val = 0x00000000 },
	{ .addr = 0x00f0092144, .val = 0x00000000 },
	{ .addr = 0x00f0092148, .val = 0x00000000 },
	{ .addr = 0x00f009214c, .val = 0x00000000 },
	{ .addr = 0x00f0092150, .val = 0x00000000 },
	{ .addr = 0x00f0092154, .val = 0x00000000 },
	{ .addr = 0x00f0092158, .val = 0x00000000 },
	{ .addr = 0x00f009215c, .val = 0x00000000 },
	{ .addr = 0x00f0092160, .val = 0x00000000 },
	{ .addr = 0x00f0092164, .val = 0x00000000 },
	{ .addr = 0x00f0092168, .val = 0x00000000 },
	{ .addr = 0x00f009216c, .val = 0x00000000 },
	{ .addr = 0x00f0092170, .val = 0x00000000 },
	{ .addr = 0x00f0092174, .val = 0x00000000 },
	{ .addr = 0x00f0092178, .val = 0x00000000 },
	{ .addr = 0x00f009217c, .val = 0x00000000 },
	{ .addr = 0x00f0092180, .val = 0x00000000 },
	{ .addr = 0x00f0092184, .val = 0x00000000 },
	{ .addr = 0x00f0092188, .val = 0x00000000 },
	{ .addr = 0x00f009218c, .val = 0x00000000 },
	{ .addr = 0x00f0092190, .val = 0x00000000 },
	{ .addr = 0x00f0092194, .val = 0x00000000 },
	{ .addr = 0x00f0092198, .val = 0x00000000 },
	{ .addr = 0x00f009219c, .val = 0x00000000 },
	{ .addr = 0x00f00921a0, .val = 0x00000000 },
	{ .addr = 0x00f00921a4, .val = 0x00000000 },
	{ .addr = 0x00f00921a8, .val = 0x00000000 },
	{ .addr = 0x00f00921ac, .val = 0x00000000 },
	{ .addr = 0x00f00921b0, .val = 0x00000000 },
	{ .addr = 0x00f00921b4, .val = 0x00000000 },
	{ .addr = 0x00f00921b8, .val = 0x00000000 },
	{ .addr = 0x00f00921bc, .val = 0x00000000 },
	{ .addr = 0x00f00921c0, .val = 0x00000000 },
	{ .addr = 0x00f00921c4, .val = 0x00000000 },
	{ .addr = 0x00f00921c8, .val = 0x00000000 },
	{ .addr = 0x00f00921cc, .val = 0x00000000 },
	{ .addr = 0x00f00921d0, .val = 0x00000000 },
	{ .addr = 0x00f00921d4, .val = 0x00000000 },
	{ .addr = 0x00f00921d8, .val = 0x00000000 },
	{ .addr = 0x00f00921dc, .val = 0x00000000 },
	{ .addr = 0x00f00921e0, .val = 0x00000000 },
	{ .addr = 0x00f00921e4, .val = 0x00000000 },
	{ .addr = 0x00f00921e8, .val = 0x00000000 },
	{ .addr = 0x00f00921ec, .val = 0x00000000 },
	{ .addr = 0x00f00921f0, .val = 0x00000000 },
	{ .addr = 0x00f00921f4, .val = 0x00000000 },
	{ .addr = 0x00f00921f8, .val = 0x00000000 },
	{ .addr = 0x00f00921fc, .val = 0x00000000 },
	{ .addr = 0x00f0093000, .val = 0x00000000 },
	{ .addr = 0x00f0093004, .val = 0x00000000 },
	{ .addr = 0x00f0093008, .val = 0x00000000 },
	{ .addr = 0x00f009300c, .val = 0x00000000 },
	{ .addr = 0x00f0093010, .val = 0x00000000 },
	{ .addr = 0x00f0093014, .val = 0x00000000 },
	{ .addr = 0x00f0093018, .val = 0x00000000 },
	{ .addr = 0x00f009301c, .val = 0x00000000 },
	{ .addr = 0x00f0093020, .val = 0x00000000 },
	{ .addr = 0x00f0093024, .val = 0x00000000 },
	{ .addr = 0x00f0093028, .val = 0x00000000 },
	{ .addr = 0x00f009302c, .val = 0x00000000 },
	{ .addr = 0x00f0093030, .val = 0x00000000 },
	{ .addr = 0x00f0093034, .val = 0x00000000 },
	{ .addr = 0x00f0093038, .val = 0x00000000 },
	{ .addr = 0x00f009303c, .val = 0x00000000 },
	{ .addr = 0x00f0093040, .val = 0x00000000 },
	{ .addr = 0x00f0093044, .val = 0x00000000 },
	{ .addr = 0x00f0093048, .val = 0x00000000 },
	{ .addr = 0x00f009304c, .val = 0x00000000 },
	{ .addr = 0x00f0093050, .val = 0x00000000 },
	{ .addr = 0x00f0093054, .val = 0x00000000 },
	{ .addr = 0x00f0093058, .val = 0x00000000 },
	{ .addr = 0x00f009305c, .val = 0x00000000 },
	{ .addr = 0x00f0093060, .val = 0x00000000 },
	{ .addr = 0x00f0093064, .val = 0x00000000 },
	{ .addr = 0x00f0093068, .val = 0x00000000 },
	{ .addr = 0x00f009306c, .val = 0x00000000 },
	{ .addr = 0x00f0093070, .val = 0x00000000 },
	{ .addr = 0x00f0093074, .val = 0x00000000 },
	{ .addr = 0x00f0093078, .val = 0x00000000 },
	{ .addr = 0x00f009307c, .val = 0x00000000 },
	{ .addr = 0x00f0093080, .val = 0x00000000 },
	{ .addr = 0x00f0093084, .val = 0x00000000 },
	{ .addr = 0x00f0093088, .val = 0x00000000 },
	{ .addr = 0x00f009308c, .val = 0x00000000 },
	{ .addr = 0x00f0093090, .val = 0x00000000 },
	{ .addr = 0x00f0093094, .val = 0x00000000 },
	{ .addr = 0x00f0093098, .val = 0x00000000 },
	{ .addr = 0x00f009309c, .val = 0x00000000 },
	{ .addr = 0x00f00930a0, .val = 0x00000000 },
	{ .addr = 0x00f00930a4, .val = 0x00000000 },
	{ .addr = 0x00f00930a8, .val = 0x00000000 },
	{ .addr = 0x00f00930ac, .val = 0x00000000 },
	{ .addr = 0x00f00930b0, .val = 0x00000000 },
	{ .addr = 0x00f00930b4, .val = 0x00000000 },
	{ .addr = 0x00f00930b8, .val = 0x00000000 },
	{ .addr = 0x00f00930bc, .val = 0x00000000 },
	{ .addr = 0x00f00930c0, .val = 0x00000000 },
	{ .addr = 0x00f00930c4, .val = 0x00000000 },
	{ .addr = 0x00f00930c8, .val = 0x00000000 },
	{ .addr = 0x00f00930cc, .val = 0x00000000 },
	{ .addr = 0x00f00930d0, .val = 0x00000000 },
	{ .addr = 0x00f00930d4, .val = 0x00000000 },
	{ .addr = 0x00f00930d8, .val = 0x00000000 },
	{ .addr = 0x00f00930dc, .val = 0x00000000 },
	{ .addr = 0x00f00930e0, .val = 0x00000000 },
	{ .addr = 0x00f00930e4, .val = 0x00000000 },
	{ .addr = 0x00f00930e8, .val = 0x00000000 },
	{ .addr = 0x00f00930ec, .val = 0x00000000 },
	{ .addr = 0x00f00930f0, .val = 0x00000000 },
	{ .addr = 0x00f00930f4, .val = 0x00000000 },
	{ .addr = 0x00f00930f8, .val = 0x00000000 },
	{ .addr = 0x00f00930fc, .val = 0x00000000 },
	{ .addr = 0x00f0093100, .val = 0x00000000 },
	{ .addr = 0x00f0093104, .val = 0x00000000 },
	{ .addr = 0x00f0093108, .val = 0x00000000 },
	{ .addr = 0x00f009310c, .val = 0x00000000 },
	{ .addr = 0x00f0093110, .val = 0x00000000 },
	{ .addr = 0x00f0093114, .val = 0x00000000 },
	{ .addr = 0x00f0093118, .val = 0x00000000 },
	{ .addr = 0x00f009311c, .val = 0x00000000 },
	{ .addr = 0x00f0093120, .val = 0x00000000 },
	{ .addr = 0x00f0093124, .val = 0x00000000 },
	{ .addr = 0x00f0093128, .val = 0x00000000 },
	{ .addr = 0x00f009312c, .val = 0x00000000 },
	{ .addr = 0x00f0093130, .val = 0x00000000 },
	{ .addr = 0x00f0093134, .val = 0x00000000 },
	{ .addr = 0x00f0093138, .val = 0x00000000 },
	{ .addr = 0x00f009313c, .val = 0x00000000 },
	{ .addr = 0x00f0093140, .val = 0x00000000 },
	{ .addr = 0x00f0093144, .val = 0x00000000 },
	{ .addr = 0x00f0093148, .val = 0x00000000 },
	{ .addr = 0x00f009314c, .val = 0x00000000 },
	{ .addr = 0x00f0093150, .val = 0x00000000 },
	{ .addr = 0x00f0093154, .val = 0x00000000 },
	{ .addr = 0x00f0093158, .val = 0x00000000 },
	{ .addr = 0x00f009315c, .val = 0x00000000 },
	{ .addr = 0x00f0093160, .val = 0x00000000 },
	{ .addr = 0x00f0093164, .val = 0x00000000 },
	{ .addr = 0x00f0093168, .val = 0x00000000 },
	{ .addr = 0x00f009316c, .val = 0x00000000 },
	{ .addr = 0x00f0093170, .val = 0x00000000 },
	{ .addr = 0x00f0093174, .val = 0x00000000 },
	{ .addr = 0x00f0093178, .val = 0x00000000 },
	{ .addr = 0x00f009317c, .val = 0x00000000 },
	{ .addr = 0x00f0093180, .val = 0x00000000 },
	{ .addr = 0x00f0093184, .val = 0x00000000 },
	{ .addr = 0x00f0093188, .val = 0x00000000 },
	{ .addr = 0x00f009318c, .val = 0x00000000 },
	{ .addr = 0x00f0093190, .val = 0x00000000 },
	{ .addr = 0x00f0093194, .val = 0x00000000 },
	{ .addr = 0x00f0093198, .val = 0x00000000 },
	{ .addr = 0x00f009319c, .val = 0x00000000 },
	{ .addr = 0x00f00931a0, .val = 0x00000000 },
	{ .addr = 0x00f00931a4, .val = 0x00000000 },
	{ .addr = 0x00f00931a8, .val = 0x00000000 },
	{ .addr = 0x00f00931ac, .val = 0x00000000 },
	{ .addr = 0x00f00931b0, .val = 0x00000000 },
	{ .addr = 0x00f00931b4, .val = 0x00000000 },
	{ .addr = 0x00f00931b8, .val = 0x00000000 },
	{ .addr = 0x00f00931bc, .val = 0x00000000 },
	{ .addr = 0x00f00931c0, .val = 0x00000000 },
	{ .addr = 0x00f00931c4, .val = 0x00000000 },
	{ .addr = 0x00f00931c8, .val = 0x00000000 },
	{ .addr = 0x00f00931cc, .val = 0x00000000 },
	{ .addr = 0x00f00931d0, .val = 0x00000000 },
	{ .addr = 0x00f00931d4, .val = 0x00000000 },
	{ .addr = 0x00f00931d8, .val = 0x00000000 },
	{ .addr = 0x00f00931dc, .val = 0x00000000 },
	{ .addr = 0x00f00931e0, .val = 0x00000000 },
	{ .addr = 0x00f00931e4, .val = 0x00000000 },
	{ .addr = 0x00f00931e8, .val = 0x00000000 },
	{ .addr = 0x00f00931ec, .val = 0x00000000 },
	{ .addr = 0x00f00931f0, .val = 0x00000000 },
	{ .addr = 0x00f00931f4, .val = 0x00000000 },
	{ .addr = 0x00f00931f8, .val = 0x00000000 },
	{ .addr = 0x00f00931fc, .val = 0x00000000 },
	{ .addr = 0x00f0094000, .val = 0x00000000 },
	{ .addr = 0x00f0094004, .val = 0x00000000 },
	{ .addr = 0x00f0094008, .val = 0x00000000 },
	{ .addr = 0x00f009400c, .val = 0x00000000 },
	{ .addr = 0x00f0094010, .val = 0x00000000 },
	{ .addr = 0x00f0094014, .val = 0x00000000 },
	{ .addr = 0x00f0094018, .val = 0x00000000 },
	{ .addr = 0x00f009401c, .val = 0x00000000 },
	{ .addr = 0x00f0094020, .val = 0x00000000 },
	{ .addr = 0x00f0094024, .val = 0x00000000 },
	{ .addr = 0x00f0094028, .val = 0x00000000 },
	{ .addr = 0x00f009402c, .val = 0x00000000 },
	{ .addr = 0x00f0094030, .val = 0x00000000 },
	{ .addr = 0x00f0094034, .val = 0x00000000 },
	{ .addr = 0x00f0094038, .val = 0x00000000 },
	{ .addr = 0x00f009403c, .val = 0x00000000 },
	{ .addr = 0x00f0094040, .val = 0x00000000 },
	{ .addr = 0x00f0094044, .val = 0x00000000 },
	{ .addr = 0x00f0094048, .val = 0x00000000 },
	{ .addr = 0x00f009404c, .val = 0x00000000 },
	{ .addr = 0x00f0094050, .val = 0x00000000 },
	{ .addr = 0x00f0094054, .val = 0x00000000 },
	{ .addr = 0x00f0094058, .val = 0x00000000 },
	{ .addr = 0x00f009405c, .val = 0x00000000 },
	{ .addr = 0x00f0094060, .val = 0x00000000 },
	{ .addr = 0x00f0094064, .val = 0x00000000 },
	{ .addr = 0x00f0094068, .val = 0x00000000 },
	{ .addr = 0x00f009406c, .val = 0x00000000 },
	{ .addr = 0x00f0094070, .val = 0x00000000 },
	{ .addr = 0x00f0094074, .val = 0x00000000 },
	{ .addr = 0x00f0094078, .val = 0x00000000 },
	{ .addr = 0x00f009407c, .val = 0x00000000 },
	{ .addr = 0x00f0094080, .val = 0x00000000 },
	{ .addr = 0x00f0094084, .val = 0x00000000 },
	{ .addr = 0x00f0094088, .val = 0x00000000 },
	{ .addr = 0x00f009408c, .val = 0x00000000 },
	{ .addr = 0x00f0094090, .val = 0x00000000 },
	{ .addr = 0x00f0094094, .val = 0x00000000 },
	{ .addr = 0x00f0094098, .val = 0x00000000 },
	{ .addr = 0x00f009409c, .val = 0x00000000 },
	{ .addr = 0x00f00940a0, .val = 0x00000000 },
	{ .addr = 0x00f00940a4, .val = 0x00000000 },
	{ .addr = 0x00f00940a8, .val = 0x00000000 },
	{ .addr = 0x00f00940ac, .val = 0x00000000 },
	{ .addr = 0x00f00940b0, .val = 0x00000000 },
	{ .addr = 0x00f00940b4, .val = 0x00000000 },
	{ .addr = 0x00f00940b8, .val = 0x00000000 },
	{ .addr = 0x00f00940bc, .val = 0x00000000 },
	{ .addr = 0x00f00940c0, .val = 0x00000000 },
	{ .addr = 0x00f00940c4, .val = 0x00000000 },
	{ .addr = 0x00f00940c8, .val = 0x00000000 },
	{ .addr = 0x00f00940cc, .val = 0x00000000 },
	{ .addr = 0x00f00940d0, .val = 0x00000000 },
	{ .addr = 0x00f00940d4, .val = 0x00000000 },
	{ .addr = 0x00f00940d8, .val = 0x00000000 },
	{ .addr = 0x00f00940dc, .val = 0x00000000 },
	{ .addr = 0x00f00940e0, .val = 0x00000000 },
	{ .addr = 0x00f00940e4, .val = 0x00000000 },
	{ .addr = 0x00f00940e8, .val = 0x00000000 },
	{ .addr = 0x00f00940ec, .val = 0x00000000 },
	{ .addr = 0x00f00940f0, .val = 0x00000000 },
	{ .addr = 0x00f00940f4, .val = 0x00000000 },
	{ .addr = 0x00f00940f8, .val = 0x00000000 },
	{ .addr = 0x00f00940fc, .val = 0x00000000 },
	{ .addr = 0x00f0094100, .val = 0x00000000 },
	{ .addr = 0x00f0094104, .val = 0x00000000 },
	{ .addr = 0x00f0094108, .val = 0x00000000 },
	{ .addr = 0x00f009410c, .val = 0x00000000 },
	{ .addr = 0x00f0094110, .val = 0x00000000 },
	{ .addr = 0x00f0094114, .val = 0x00000000 },
	{ .addr = 0x00f0094118, .val = 0x00000000 },
	{ .addr = 0x00f009411c, .val = 0x00000000 },
	{ .addr = 0x00f0094120, .val = 0x00000000 },
	{ .addr = 0x00f0094124, .val = 0x00000000 },
	{ .addr = 0x00f0094128, .val = 0x00000000 },
	{ .addr = 0x00f009412c, .val = 0x00000000 },
	{ .addr = 0x00f0094130, .val = 0x00000000 },
	{ .addr = 0x00f0094134, .val = 0x00000000 },
	{ .addr = 0x00f0094138, .val = 0x00000000 },
	{ .addr = 0x00f009413c, .val = 0x00000000 },
	{ .addr = 0x00f0094140, .val = 0x00000000 },
	{ .addr = 0x00f0094144, .val = 0x00000000 },
	{ .addr = 0x00f0094148, .val = 0x00000000 },
	{ .addr = 0x00f009414c, .val = 0x00000000 },
	{ .addr = 0x00f0094150, .val = 0x00000000 },
	{ .addr = 0x00f0094154, .val = 0x00000000 },
	{ .addr = 0x00f0094158, .val = 0x00000000 },
	{ .addr = 0x00f009415c, .val = 0x00000000 },
	{ .addr = 0x00f0094160, .val = 0x00000000 },
	{ .addr = 0x00f0094164, .val = 0x00000000 },
	{ .addr = 0x00f0094168, .val = 0x00000000 },
	{ .addr = 0x00f009416c, .val = 0x00000000 },
	{ .addr = 0x00f0094170, .val = 0x00000000 },
	{ .addr = 0x00f0094174, .val = 0x00000000 },
	{ .addr = 0x00f0094178, .val = 0x00000000 },
	{ .addr = 0x00f009417c, .val = 0x00000000 },
	{ .addr = 0x00f0094180, .val = 0x00000000 },
	{ .addr = 0x00f0094184, .val = 0x00000000 },
	{ .addr = 0x00f0094188, .val = 0x00000000 },
	{ .addr = 0x00f009418c, .val = 0x00000000 },
	{ .addr = 0x00f0094190, .val = 0x00000000 },
	{ .addr = 0x00f0094194, .val = 0x00000000 },
	{ .addr = 0x00f0094198, .val = 0x00000000 },
	{ .addr = 0x00f009419c, .val = 0x00000000 },
	{ .addr = 0x00f00941a0, .val = 0x00000000 },
	{ .addr = 0x00f00941a4, .val = 0x00000000 },
	{ .addr = 0x00f00941a8, .val = 0x00000000 },
	{ .addr = 0x00f00941ac, .val = 0x00000000 },
	{ .addr = 0x00f00941b0, .val = 0x00000000 },
	{ .addr = 0x00f00941b4, .val = 0x00000000 },
	{ .addr = 0x00f00941b8, .val = 0x00000000 },
	{ .addr = 0x00f00941bc, .val = 0x00000000 },
	{ .addr = 0x00f00941c0, .val = 0x00000000 },
	{ .addr = 0x00f00941c4, .val = 0x00000000 },
	{ .addr = 0x00f00941c8, .val = 0x00000000 },
	{ .addr = 0x00f00941cc, .val = 0x00000000 },
	{ .addr = 0x00f00941d0, .val = 0x00000000 },
	{ .addr = 0x00f00941d4, .val = 0x00000000 },
	{ .addr = 0x00f00941d8, .val = 0x00000000 },
	{ .addr = 0x00f00941dc, .val = 0x00000000 },
	{ .addr = 0x00f00941e0, .val = 0x00000000 },
	{ .addr = 0x00f00941e4, .val = 0x00000000 },
	{ .addr = 0x00f00941e8, .val = 0x00000000 },
	{ .addr = 0x00f00941ec, .val = 0x00000000 },
	{ .addr = 0x00f00941f0, .val = 0x00000000 },
	{ .addr = 0x00f00941f4, .val = 0x00000000 },
	{ .addr = 0x00f00941f8, .val = 0x00000000 },
	{ .addr = 0x00f00941fc, .val = 0x00000000 },
	{ .addr = 0x00f0095000, .val = 0x00000000 },
	{ .addr = 0x00f0095004, .val = 0x00000000 },
	{ .addr = 0x00f0095008, .val = 0x00000000 },
	{ .addr = 0x00f009500c, .val = 0x00000000 },
	{ .addr = 0x00f0095010, .val = 0x00000000 },
	{ .addr = 0x00f0095014, .val = 0x00000000 },
	{ .addr = 0x00f0095018, .val = 0x00000000 },
	{ .addr = 0x00f009501c, .val = 0x00000000 },
	{ .addr = 0x00f0095020, .val = 0x00000000 },
	{ .addr = 0x00f0095024, .val = 0x00000000 },
	{ .addr = 0x00f0095028, .val = 0x00000000 },
	{ .addr = 0x00f009502c, .val = 0x00000000 },
	{ .addr = 0x00f0095030, .val = 0x00000000 },
	{ .addr = 0x00f0095034, .val = 0x00000000 },
	{ .addr = 0x00f0095038, .val = 0x00000000 },
	{ .addr = 0x00f009503c, .val = 0x00000000 },
	{ .addr = 0x00f0095040, .val = 0x00000000 },
	{ .addr = 0x00f0095044, .val = 0x00000000 },
	{ .addr = 0x00f0095048, .val = 0x00000000 },
	{ .addr = 0x00f009504c, .val = 0x00000000 },
	{ .addr = 0x00f0095050, .val = 0x00000000 },
	{ .addr = 0x00f0095054, .val = 0x00000000 },
	{ .addr = 0x00f0095058, .val = 0x00000000 },
	{ .addr = 0x00f009505c, .val = 0x00000000 },
	{ .addr = 0x00f0095060, .val = 0x00000000 },
	{ .addr = 0x00f0095064, .val = 0x00000000 },
	{ .addr = 0x00f0095068, .val = 0x00000000 },
	{ .addr = 0x00f009506c, .val = 0x00000000 },
	{ .addr = 0x00f0095070, .val = 0x00000000 },
	{ .addr = 0x00f0095074, .val = 0x00000000 },
	{ .addr = 0x00f0095078, .val = 0x00000000 },
	{ .addr = 0x00f009507c, .val = 0x00000000 },
	{ .addr = 0x00f0095080, .val = 0x00000000 },
	{ .addr = 0x00f0095084, .val = 0x00000000 },
	{ .addr = 0x00f0095088, .val = 0x00000000 },
	{ .addr = 0x00f009508c, .val = 0x00000000 },
	{ .addr = 0x00f0095090, .val = 0x00000000 },
	{ .addr = 0x00f0095094, .val = 0x00000000 },
	{ .addr = 0x00f0095098, .val = 0x00000000 },
	{ .addr = 0x00f009509c, .val = 0x00000000 },
	{ .addr = 0x00f00950a0, .val = 0x00000000 },
	{ .addr = 0x00f00950a4, .val = 0x00000000 },
	{ .addr = 0x00f00950a8, .val = 0x00000000 },
	{ .addr = 0x00f00950ac, .val = 0x00000000 },
	{ .addr = 0x00f00950b0, .val = 0x00000000 },
	{ .addr = 0x00f00950b4, .val = 0x00000000 },
	{ .addr = 0x00f00950b8, .val = 0x00000000 },
	{ .addr = 0x00f00950bc, .val = 0x00000000 },
	{ .addr = 0x00f00950c0, .val = 0x00000000 },
	{ .addr = 0x00f00950c4, .val = 0x00000000 },
	{ .addr = 0x00f00950c8, .val = 0x00000000 },
	{ .addr = 0x00f00950cc, .val = 0x00000000 },
	{ .addr = 0x00f00950d0, .val = 0x00000000 },
	{ .addr = 0x00f00950d4, .val = 0x00000000 },
	{ .addr = 0x00f00950d8, .val = 0x00000000 },
	{ .addr = 0x00f00950dc, .val = 0x00000000 },
	{ .addr = 0x00f00950e0, .val = 0x00000000 },
	{ .addr = 0x00f00950e4, .val = 0x00000000 },
	{ .addr = 0x00f00950e8, .val = 0x00000000 },
	{ .addr = 0x00f00950ec, .val = 0x00000000 },
	{ .addr = 0x00f00950f0, .val = 0x00000000 },
	{ .addr = 0x00f00950f4, .val = 0x00000000 },
	{ .addr = 0x00f00950f8, .val = 0x00000000 },
	{ .addr = 0x00f00950fc, .val = 0x00000000 },
	{ .addr = 0x00f0095100, .val = 0x00000000 },
	{ .addr = 0x00f0095104, .val = 0x00000000 },
	{ .addr = 0x00f0095108, .val = 0x00000000 },
	{ .addr = 0x00f009510c, .val = 0x00000000 },
	{ .addr = 0x00f0095110, .val = 0x00000000 },
	{ .addr = 0x00f0095114, .val = 0x00000000 },
	{ .addr = 0x00f0095118, .val = 0x00000000 },
	{ .addr = 0x00f009511c, .val = 0x00000000 },
	{ .addr = 0x00f0095120, .val = 0x00000000 },
	{ .addr = 0x00f0095124, .val = 0x00000000 },
	{ .addr = 0x00f0095128, .val = 0x00000000 },
	{ .addr = 0x00f009512c, .val = 0x00000000 },
	{ .addr = 0x00f0095130, .val = 0x00000000 },
	{ .addr = 0x00f0095134, .val = 0x00000000 },
	{ .addr = 0x00f0095138, .val = 0x00000000 },
	{ .addr = 0x00f009513c, .val = 0x00000000 },
	{ .addr = 0x00f0095140, .val = 0x00000000 },
	{ .addr = 0x00f0095144, .val = 0x00000000 },
	{ .addr = 0x00f0095148, .val = 0x00000000 },
	{ .addr = 0x00f009514c, .val = 0x00000000 },
	{ .addr = 0x00f0095150, .val = 0x00000000 },
	{ .addr = 0x00f0095154, .val = 0x00000000 },
	{ .addr = 0x00f0095158, .val = 0x00000000 },
	{ .addr = 0x00f009515c, .val = 0x00000000 },
	{ .addr = 0x00f0095160, .val = 0x00000000 },
	{ .addr = 0x00f0095164, .val = 0x00000000 },
	{ .addr = 0x00f0095168, .val = 0x00000000 },
	{ .addr = 0x00f009516c, .val = 0x00000000 },
	{ .addr = 0x00f0095170, .val = 0x00000000 },
	{ .addr = 0x00f0095174, .val = 0x00000000 },
	{ .addr = 0x00f0095178, .val = 0x00000000 },
	{ .addr = 0x00f009517c, .val = 0x00000000 },
	{ .addr = 0x00f0095180, .val = 0x00000000 },
	{ .addr = 0x00f0095184, .val = 0x00000000 },
	{ .addr = 0x00f0095188, .val = 0x00000000 },
	{ .addr = 0x00f009518c, .val = 0x00000000 },
	{ .addr = 0x00f0095190, .val = 0x00000000 },
	{ .addr = 0x00f0095194, .val = 0x00000000 },
	{ .addr = 0x00f0095198, .val = 0x00000000 },
	{ .addr = 0x00f009519c, .val = 0x00000000 },
	{ .addr = 0x00f00951a0, .val = 0x00000000 },
	{ .addr = 0x00f00951a4, .val = 0x00000000 },
	{ .addr = 0x00f00951a8, .val = 0x00000000 },
	{ .addr = 0x00f00951ac, .val = 0x00000000 },
	{ .addr = 0x00f00951b0, .val = 0x00000000 },
	{ .addr = 0x00f00951b4, .val = 0x00000000 },
	{ .addr = 0x00f00951b8, .val = 0x00000000 },
	{ .addr = 0x00f00951bc, .val = 0x00000000 },
	{ .addr = 0x00f00951c0, .val = 0x00000000 },
	{ .addr = 0x00f00951c4, .val = 0x00000000 },
	{ .addr = 0x00f00951c8, .val = 0x00000000 },
	{ .addr = 0x00f00951cc, .val = 0x00000000 },
	{ .addr = 0x00f00951d0, .val = 0x00000000 },
	{ .addr = 0x00f00951d4, .val = 0x00000000 },
	{ .addr = 0x00f00951d8, .val = 0x00000000 },
	{ .addr = 0x00f00951dc, .val = 0x00000000 },
	{ .addr = 0x00f00951e0, .val = 0x00000000 },
	{ .addr = 0x00f00951e4, .val = 0x00000000 },
	{ .addr = 0x00f00951e8, .val = 0x00000000 },
	{ .addr = 0x00f00951ec, .val = 0x00000000 },
	{ .addr = 0x00f00951f0, .val = 0x00000000 },
	{ .addr = 0x00f00951f4, .val = 0x00000000 },
	{ .addr = 0x00f00951f8, .val = 0x00000000 },
	{ .addr = 0x00f00951fc, .val = 0x00000000 },
	{ .addr = 0x00f0096000, .val = 0x00000000 },
	{ .addr = 0x00f0096004, .val = 0x00000000 },
	{ .addr = 0x00f0096008, .val = 0x00000000 },
	{ .addr = 0x00f009600c, .val = 0x00000000 },
	{ .addr = 0x00f0096010, .val = 0x00000000 },
	{ .addr = 0x00f0096014, .val = 0x00000000 },
	{ .addr = 0x00f0096018, .val = 0x00000000 },
	{ .addr = 0x00f009601c, .val = 0x00000000 },
	{ .addr = 0x00f0096020, .val = 0x00000000 },
	{ .addr = 0x00f0096024, .val = 0x00000000 },
	{ .addr = 0x00f0096028, .val = 0x00000000 },
	{ .addr = 0x00f009602c, .val = 0x00000000 },
	{ .addr = 0x00f0096030, .val = 0x00000000 },
	{ .addr = 0x00f0096034, .val = 0x00000000 },
	{ .addr = 0x00f0096038, .val = 0x00000000 },
	{ .addr = 0x00f009603c, .val = 0x00000000 },
	{ .addr = 0x00f0096040, .val = 0x00000000 },
	{ .addr = 0x00f0096044, .val = 0x00000000 },
	{ .addr = 0x00f0096048, .val = 0x00000000 },
	{ .addr = 0x00f009604c, .val = 0x00000000 },
	{ .addr = 0x00f0096050, .val = 0x00000000 },
	{ .addr = 0x00f0096054, .val = 0x00000000 },
	{ .addr = 0x00f0096058, .val = 0x00000000 },
	{ .addr = 0x00f009605c, .val = 0x00000000 },
	{ .addr = 0x00f0096060, .val = 0x00000000 },
	{ .addr = 0x00f0096064, .val = 0x00000000 },
	{ .addr = 0x00f0096068, .val = 0x00000000 },
	{ .addr = 0x00f009606c, .val = 0x00000000 },
	{ .addr = 0x00f0096070, .val = 0x00000000 },
	{ .addr = 0x00f0096074, .val = 0x00000000 },
	{ .addr = 0x00f0096078, .val = 0x00000000 },
	{ .addr = 0x00f009607c, .val = 0x00000000 },
	{ .addr = 0x00f0096080, .val = 0x00000000 },
	{ .addr = 0x00f0096084, .val = 0x00000000 },
	{ .addr = 0x00f0096088, .val = 0x00000000 },
	{ .addr = 0x00f009608c, .val = 0x00000000 },
	{ .addr = 0x00f0096090, .val = 0x00000000 },
	{ .addr = 0x00f0096094, .val = 0x00000000 },
	{ .addr = 0x00f0096098, .val = 0x00000000 },
	{ .addr = 0x00f009609c, .val = 0x00000000 },
	{ .addr = 0x00f00960a0, .val = 0x00000000 },
	{ .addr = 0x00f00960a4, .val = 0x00000000 },
	{ .addr = 0x00f00960a8, .val = 0x00000000 },
	{ .addr = 0x00f00960ac, .val = 0x00000000 },
	{ .addr = 0x00f00960b0, .val = 0x00000000 },
	{ .addr = 0x00f00960b4, .val = 0x00000000 },
	{ .addr = 0x00f00960b8, .val = 0x00000000 },
	{ .addr = 0x00f00960bc, .val = 0x00000000 },
	{ .addr = 0x00f00960c0, .val = 0x00000000 },
	{ .addr = 0x00f00960c4, .val = 0x00000000 },
	{ .addr = 0x00f00960c8, .val = 0x00000000 },
	{ .addr = 0x00f00960cc, .val = 0x00000000 },
	{ .addr = 0x00f00960d0, .val = 0x00000000 },
	{ .addr = 0x00f00960d4, .val = 0x00000000 },
	{ .addr = 0x00f00960d8, .val = 0x00000000 },
	{ .addr = 0x00f00960dc, .val = 0x00000000 },
	{ .addr = 0x00f00960e0, .val = 0x00000000 },
	{ .addr = 0x00f00960e4, .val = 0x00000000 },
	{ .addr = 0x00f00960e8, .val = 0x00000000 },
	{ .addr = 0x00f00960ec, .val = 0x00000000 },
	{ .addr = 0x00f00960f0, .val = 0x00000000 },
	{ .addr = 0x00f00960f4, .val = 0x00000000 },
	{ .addr = 0x00f00960f8, .val = 0x00000000 },
	{ .addr = 0x00f00960fc, .val = 0x00000000 },
	{ .addr = 0x00f0096100, .val = 0x00000000 },
	{ .addr = 0x00f0096104, .val = 0x00000000 },
	{ .addr = 0x00f0096108, .val = 0x00000000 },
	{ .addr = 0x00f009610c, .val = 0x00000000 },
	{ .addr = 0x00f0096110, .val = 0x00000000 },
	{ .addr = 0x00f0096114, .val = 0x00000000 },
	{ .addr = 0x00f0096118, .val = 0x00000000 },
	{ .addr = 0x00f009611c, .val = 0x00000000 },
	{ .addr = 0x00f0096120, .val = 0x00000000 },
	{ .addr = 0x00f0096124, .val = 0x00000000 },
	{ .addr = 0x00f0096128, .val = 0x00000000 },
	{ .addr = 0x00f009612c, .val = 0x00000000 },
	{ .addr = 0x00f0096130, .val = 0x00000000 },
	{ .addr = 0x00f0096134, .val = 0x00000000 },
	{ .addr = 0x00f0096138, .val = 0x00000000 },
	{ .addr = 0x00f009613c, .val = 0x00000000 },
	{ .addr = 0x00f0096140, .val = 0x00000000 },
	{ .addr = 0x00f0096144, .val = 0x00000000 },
	{ .addr = 0x00f0096148, .val = 0x00000000 },
	{ .addr = 0x00f009614c, .val = 0x00000000 },
	{ .addr = 0x00f0096150, .val = 0x00000000 },
	{ .addr = 0x00f0096154, .val = 0x00000000 },
	{ .addr = 0x00f0096158, .val = 0x00000000 },
	{ .addr = 0x00f009615c, .val = 0x00000000 },
	{ .addr = 0x00f0096160, .val = 0x00000000 },
	{ .addr = 0x00f0096164, .val = 0x00000000 },
	{ .addr = 0x00f0096168, .val = 0x00000000 },
	{ .addr = 0x00f009616c, .val = 0x00000000 },
	{ .addr = 0x00f0096170, .val = 0x00000000 },
	{ .addr = 0x00f0096174, .val = 0x00000000 },
	{ .addr = 0x00f0096178, .val = 0x00000000 },
	{ .addr = 0x00f009617c, .val = 0x00000000 },
	{ .addr = 0x00f0096180, .val = 0x00000000 },
	{ .addr = 0x00f0096184, .val = 0x00000000 },
	{ .addr = 0x00f0096188, .val = 0x00000000 },
	{ .addr = 0x00f009618c, .val = 0x00000000 },
	{ .addr = 0x00f0096190, .val = 0x00000000 },
	{ .addr = 0x00f0096194, .val = 0x00000000 },
	{ .addr = 0x00f0096198, .val = 0x00000000 },
	{ .addr = 0x00f009619c, .val = 0x00000000 },
	{ .addr = 0x00f00961a0, .val = 0x00000000 },
	{ .addr = 0x00f00961a4, .val = 0x00000000 },
	{ .addr = 0x00f00961a8, .val = 0x00000000 },
	{ .addr = 0x00f00961ac, .val = 0x00000000 },
	{ .addr = 0x00f00961b0, .val = 0x00000000 },
	{ .addr = 0x00f00961b4, .val = 0x00000000 },
	{ .addr = 0x00f00961b8, .val = 0x00000000 },
	{ .addr = 0x00f00961bc, .val = 0x00000000 },
	{ .addr = 0x00f00961c0, .val = 0x00000000 },
	{ .addr = 0x00f00961c4, .val = 0x00000000 },
	{ .addr = 0x00f00961c8, .val = 0x00000000 },
	{ .addr = 0x00f00961cc, .val = 0x00000000 },
	{ .addr = 0x00f00961d0, .val = 0x00000000 },
	{ .addr = 0x00f00961d4, .val = 0x00000000 },
	{ .addr = 0x00f00961d8, .val = 0x00000000 },
	{ .addr = 0x00f00961dc, .val = 0x00000000 },
	{ .addr = 0x00f00961e0, .val = 0x00000000 },
	{ .addr = 0x00f00961e4, .val = 0x00000000 },
	{ .addr = 0x00f00961e8, .val = 0x00000000 },
	{ .addr = 0x00f00961ec, .val = 0x00000000 },
	{ .addr = 0x00f00961f0, .val = 0x00000000 },
	{ .addr = 0x00f00961f4, .val = 0x00000000 },
	{ .addr = 0x00f00961f8, .val = 0x00000000 },
	{ .addr = 0x00f00961fc, .val = 0x00000000 },
	{ .addr = 0x00f0097000, .val = 0x00000000 },
	{ .addr = 0x00f0097004, .val = 0x00000000 },
	{ .addr = 0x00f0097008, .val = 0x00000000 },
	{ .addr = 0x00f009700c, .val = 0x00000000 },
	{ .addr = 0x00f0097010, .val = 0x00000000 },
	{ .addr = 0x00f0097014, .val = 0x00000000 },
	{ .addr = 0x00f0097018, .val = 0x00000000 },
	{ .addr = 0x00f009701c, .val = 0x00000000 },
	{ .addr = 0x00f0097020, .val = 0x00000000 },
	{ .addr = 0x00f0097024, .val = 0x00000000 },
	{ .addr = 0x00f0097028, .val = 0x00000000 },
	{ .addr = 0x00f009702c, .val = 0x00000000 },
	{ .addr = 0x00f0097030, .val = 0x00000000 },
	{ .addr = 0x00f0097034, .val = 0x00000000 },
	{ .addr = 0x00f0097038, .val = 0x00000000 },
	{ .addr = 0x00f009703c, .val = 0x00000000 },
	{ .addr = 0x00f0097040, .val = 0x00000000 },
	{ .addr = 0x00f0097044, .val = 0x00000000 },
	{ .addr = 0x00f0097048, .val = 0x00000000 },
	{ .addr = 0x00f009704c, .val = 0x00000000 },
	{ .addr = 0x00f0097050, .val = 0x00000000 },
	{ .addr = 0x00f0097054, .val = 0x00000000 },
	{ .addr = 0x00f0097058, .val = 0x00000000 },
	{ .addr = 0x00f009705c, .val = 0x00000000 },
	{ .addr = 0x00f0097060, .val = 0x00000000 },
	{ .addr = 0x00f0097064, .val = 0x00000000 },
	{ .addr = 0x00f0097068, .val = 0x00000000 },
	{ .addr = 0x00f009706c, .val = 0x00000000 },
	{ .addr = 0x00f0097070, .val = 0x00000000 },
	{ .addr = 0x00f0097074, .val = 0x00000000 },
	{ .addr = 0x00f0097078, .val = 0x00000000 },
	{ .addr = 0x00f009707c, .val = 0x00000000 },
	{ .addr = 0x00f0097080, .val = 0x00000000 },
	{ .addr = 0x00f0097084, .val = 0x00000000 },
	{ .addr = 0x00f0097088, .val = 0x00000000 },
	{ .addr = 0x00f009708c, .val = 0x00000000 },
	{ .addr = 0x00f0097090, .val = 0x00000000 },
	{ .addr = 0x00f0097094, .val = 0x00000000 },
	{ .addr = 0x00f0097098, .val = 0x00000000 },
	{ .addr = 0x00f009709c, .val = 0x00000000 },
	{ .addr = 0x00f00970a0, .val = 0x00000000 },
	{ .addr = 0x00f00970a4, .val = 0x00000000 },
	{ .addr = 0x00f00970a8, .val = 0x00000000 },
	{ .addr = 0x00f00970ac, .val = 0x00000000 },
	{ .addr = 0x00f00970b0, .val = 0x00000000 },
	{ .addr = 0x00f00970b4, .val = 0x00000000 },
	{ .addr = 0x00f00970b8, .val = 0x00000000 },
	{ .addr = 0x00f00970bc, .val = 0x00000000 },
	{ .addr = 0x00f00970c0, .val = 0x00000000 },
	{ .addr = 0x00f00970c4, .val = 0x00000000 },
	{ .addr = 0x00f00970c8, .val = 0x00000000 },
	{ .addr = 0x00f00970cc, .val = 0x00000000 },
	{ .addr = 0x00f00970d0, .val = 0x00000000 },
	{ .addr = 0x00f00970d4, .val = 0x00000000 },
	{ .addr = 0x00f00970d8, .val = 0x00000000 },
	{ .addr = 0x00f00970dc, .val = 0x00000000 },
	{ .addr = 0x00f00970e0, .val = 0x00000000 },
	{ .addr = 0x00f00970e4, .val = 0x00000000 },
	{ .addr = 0x00f00970e8, .val = 0x00000000 },
	{ .addr = 0x00f00970ec, .val = 0x00000000 },
	{ .addr = 0x00f00970f0, .val = 0x00000000 },
	{ .addr = 0x00f00970f4, .val = 0x00000000 },
	{ .addr = 0x00f00970f8, .val = 0x00000000 },
	{ .addr = 0x00f00970fc, .val = 0x00000000 },
	{ .addr = 0x00f0097100, .val = 0x00000000 },
	{ .addr = 0x00f0097104, .val = 0x00000000 },
	{ .addr = 0x00f0097108, .val = 0x00000000 },
	{ .addr = 0x00f009710c, .val = 0x00000000 },
	{ .addr = 0x00f0097110, .val = 0x00000000 },
	{ .addr = 0x00f0097114, .val = 0x00000000 },
	{ .addr = 0x00f0097118, .val = 0x00000000 },
	{ .addr = 0x00f009711c, .val = 0x00000000 },
	{ .addr = 0x00f0097120, .val = 0x00000000 },
	{ .addr = 0x00f0097124, .val = 0x00000000 },
	{ .addr = 0x00f0097128, .val = 0x00000000 },
	{ .addr = 0x00f009712c, .val = 0x00000000 },
	{ .addr = 0x00f0097130, .val = 0x00000000 },
	{ .addr = 0x00f0097134, .val = 0x00000000 },
	{ .addr = 0x00f0097138, .val = 0x00000000 },
	{ .addr = 0x00f009713c, .val = 0x00000000 },
	{ .addr = 0x00f0097140, .val = 0x00000000 },
	{ .addr = 0x00f0097144, .val = 0x00000000 },
	{ .addr = 0x00f0097148, .val = 0x00000000 },
	{ .addr = 0x00f009714c, .val = 0x00000000 },
	{ .addr = 0x00f0097150, .val = 0x00000000 },
	{ .addr = 0x00f0097154, .val = 0x00000000 },
	{ .addr = 0x00f0097158, .val = 0x00000000 },
	{ .addr = 0x00f009715c, .val = 0x00000000 },
	{ .addr = 0x00f0097160, .val = 0x00000000 },
	{ .addr = 0x00f0097164, .val = 0x00000000 },
	{ .addr = 0x00f0097168, .val = 0x00000000 },
	{ .addr = 0x00f009716c, .val = 0x00000000 },
	{ .addr = 0x00f0097170, .val = 0x00000000 },
	{ .addr = 0x00f0097174, .val = 0x00000000 },
	{ .addr = 0x00f0097178, .val = 0x00000000 },
	{ .addr = 0x00f009717c, .val = 0x00000000 },
	{ .addr = 0x00f0097180, .val = 0x00000000 },
	{ .addr = 0x00f0097184, .val = 0x00000000 },
	{ .addr = 0x00f0097188, .val = 0x00000000 },
	{ .addr = 0x00f009718c, .val = 0x00000000 },
	{ .addr = 0x00f0097190, .val = 0x00000000 },
	{ .addr = 0x00f0097194, .val = 0x00000000 },
	{ .addr = 0x00f0097198, .val = 0x00000000 },
	{ .addr = 0x00f009719c, .val = 0x00000000 },
	{ .addr = 0x00f00971a0, .val = 0x00000000 },
	{ .addr = 0x00f00971a4, .val = 0x00000000 },
	{ .addr = 0x00f00971a8, .val = 0x00000000 },
	{ .addr = 0x00f00971ac, .val = 0x00000000 },
	{ .addr = 0x00f00971b0, .val = 0x00000000 },
	{ .addr = 0x00f00971b4, .val = 0x00000000 },
	{ .addr = 0x00f00971b8, .val = 0x00000000 },
	{ .addr = 0x00f00971bc, .val = 0x00000000 },
	{ .addr = 0x00f00971c0, .val = 0x00000000 },
	{ .addr = 0x00f00971c4, .val = 0x00000000 },
	{ .addr = 0x00f00971c8, .val = 0x00000000 },
	{ .addr = 0x00f00971cc, .val = 0x00000000 },
	{ .addr = 0x00f00971d0, .val = 0x00000000 },
	{ .addr = 0x00f00971d4, .val = 0x00000000 },
	{ .addr = 0x00f00971d8, .val = 0x00000000 },
	{ .addr = 0x00f00971dc, .val = 0x00000000 },
	{ .addr = 0x00f00971e0, .val = 0x00000000 },
	{ .addr = 0x00f00971e4, .val = 0x00000000 },
	{ .addr = 0x00f00971e8, .val = 0x00000000 },
	{ .addr = 0x00f00971ec, .val = 0x00000000 },
	{ .addr = 0x00f00971f0, .val = 0x00000000 },
	{ .addr = 0x00f00971f4, .val = 0x00000000 },
	{ .addr = 0x00f00971f8, .val = 0x00000000 },
	{ .addr = 0x00f00971fc, .val = 0x00000000 },
	{ .addr = 0x00f1014000, .val = 0x00000000 },
	{ .addr = 0x00f1014004, .val = 0x00000000 },
	{ .addr = 0x00f1014008, .val = 0x00000000 },
	{ .addr = 0x00f101400c, .val = 0x00000000 },
	{ .addr = 0x00f1014010, .val = 0x00000000 },
	{ .addr = 0x00f1014014, .val = 0x00000000 },
	{ .addr = 0x00f1014018, .val = 0x00000000 },
	{ .addr = 0x00f101401c, .val = 0x00000000 },
	{ .addr = 0x00f1014020, .val = 0x00000000 },
	{ .addr = 0x00f1014024, .val = 0x00000000 },
	{ .addr = 0x00f1014028, .val = 0x00000000 },
	{ .addr = 0x00f101402c, .val = 0x00000000 },
	{ .addr = 0x00f1014030, .val = 0x00000000 },
	{ .addr = 0x00f1014034, .val = 0x00000000 },
	{ .addr = 0x00f1014038, .val = 0x00000000 },
	{ .addr = 0x00f101403c, .val = 0x00000000 },
	{ .addr = 0x00f1014040, .val = 0x00000000 },
	{ .addr = 0x00f1014044, .val = 0x00000000 },
	{ .addr = 0x00f1014048, .val = 0x00000000 },
	{ .addr = 0x00f101404c, .val = 0x00000000 },
	{ .addr = 0x00f1014050, .val = 0x00000000 },
	{ .addr = 0x00f1014054, .val = 0x00000000 },
	{ .addr = 0x00f1014058, .val = 0x00000000 },
	{ .addr = 0x00f101405c, .val = 0x00000000 },
	{ .addr = 0x00f1014060, .val = 0x00000000 },
	{ .addr = 0x00f1014064, .val = 0x00000000 },
	{ .addr = 0x00f1014068, .val = 0x00000000 },
	{ .addr = 0x00f101406c, .val = 0x00000000 },
	{ .addr = 0x00f1014070, .val = 0x00000000 },
	{ .addr = 0x00f1014074, .val = 0x00000000 },
	{ .addr = 0x00f1014078, .val = 0x00000000 },
	{ .addr = 0x00f101407c, .val = 0x00000000 },
	{ .addr = 0x00f1014080, .val = 0x00000000 },
	{ .addr = 0x00f1014084, .val = 0x00000000 },
	{ .addr = 0x00f1014088, .val = 0x00000000 },
	{ .addr = 0x00f101408c, .val = 0x00000000 },
	{ .addr = 0x00f1014090, .val = 0x00000000 },
	{ .addr = 0x00f1014094, .val = 0x00000000 },
	{ .addr = 0x00f1014098, .val = 0x00000000 },
	{ .addr = 0x00f101409c, .val = 0x00000000 },
	{ .addr = 0x00f10140a0, .val = 0x00000000 },
	{ .addr = 0x00f10140a4, .val = 0x00000000 },
	{ .addr = 0x00f10140a8, .val = 0x00000000 },
	{ .addr = 0x00f10140ac, .val = 0x00000000 },
	{ .addr = 0x00f10140b0, .val = 0x00000000 },
	{ .addr = 0x00f10140b4, .val = 0x00000000 },
	{ .addr = 0x00f10140b8, .val = 0x00000000 },
	{ .addr = 0x00f10140bc, .val = 0x00000000 },
	{ .addr = 0x00f10140c0, .val = 0x00000000 },
	{ .addr = 0x00f10140c4, .val = 0x00000000 },
	{ .addr = 0x00f10140c8, .val = 0x00000000 },
	{ .addr = 0x00f10140cc, .val = 0x00000000 },
	{ .addr = 0x00f10140d0, .val = 0x00000000 },
	{ .addr = 0x00f10140d4, .val = 0x00000000 },
	{ .addr = 0x00f10140d8, .val = 0x00000000 },
	{ .addr = 0x00f10140dc, .val = 0x00000000 },
	{ .addr = 0x00f10140e0, .val = 0x00000000 },
	{ .addr = 0x00f10140e4, .val = 0x00000000 },
	{ .addr = 0x00f10140e8, .val = 0x00000000 },
	{ .addr = 0x00f10140ec, .val = 0x00000000 },
	{ .addr = 0x00f10140f0, .val = 0x00000000 },
	{ .addr = 0x00f10140f4, .val = 0x00000000 },
	{ .addr = 0x00f10140f8, .val = 0x00000000 },
	{ .addr = 0x00f10140fc, .val = 0x00000000 },
	{ .addr = 0x00f1014100, .val = 0x00000000 },
	{ .addr = 0x00f1014104, .val = 0x00000000 },
	{ .addr = 0x00f1014108, .val = 0x00000000 },
	{ .addr = 0x00f101410c, .val = 0x00000000 },
	{ .addr = 0x00f1014110, .val = 0x00000000 },
	{ .addr = 0x00f1014114, .val = 0x00000000 },
	{ .addr = 0x00f1014118, .val = 0x00000000 },
	{ .addr = 0x00f101411c, .val = 0x00000000 },
	{ .addr = 0x00f1014120, .val = 0x00000000 },
	{ .addr = 0x00f1014124, .val = 0x00000000 },
	{ .addr = 0x00f1014128, .val = 0x00000000 },
	{ .addr = 0x00f101412c, .val = 0x00000000 },
	{ .addr = 0x00f1014130, .val = 0x00000000 },
	{ .addr = 0x00f1014134, .val = 0x00000000 },
	{ .addr = 0x00f1014138, .val = 0x00000000 },
	{ .addr = 0x00f101413c, .val = 0x00000000 },
	{ .addr = 0x00f1014140, .val = 0x00000000 },
	{ .addr = 0x00f1014144, .val = 0x00000000 },
	{ .addr = 0x00f1014148, .val = 0x00000000 },
	{ .addr = 0x00f101414c, .val = 0x00000000 },
	{ .addr = 0x00f1014150, .val = 0x00000000 },
	{ .addr = 0x00f1014154, .val = 0x00000000 },
	{ .addr = 0x00f1014158, .val = 0x00000000 },
	{ .addr = 0x00f101415c, .val = 0x00000000 },
	{ .addr = 0x00f1014160, .val = 0x00000000 },
	{ .addr = 0x00f1014164, .val = 0x00000000 },
	{ .addr = 0x00f1014168, .val = 0x00000000 },
	{ .addr = 0x00f101416c, .val = 0x00000000 },
	{ .addr = 0x00f1014170, .val = 0x00000000 },
	{ .addr = 0x00f1014174, .val = 0x00000000 },
	{ .addr = 0x00f1014178, .val = 0x00000000 },
	{ .addr = 0x00f101417c, .val = 0x00000000 },
	{ .addr = 0x00f1014180, .val = 0x00000000 },
	{ .addr = 0x00f1014184, .val = 0x00000000 },
	{ .addr = 0x00f1014188, .val = 0x00000000 },
	{ .addr = 0x00f101418c, .val = 0x00000000 },
	{ .addr = 0x00f1014190, .val = 0x00000000 },
	{ .addr = 0x00f1014194, .val = 0x00000000 },
	{ .addr = 0x00f1014198, .val = 0x00000000 },
	{ .addr = 0x00f101419c, .val = 0x00000000 },
	{ .addr = 0x00f10141a0, .val = 0x00000000 },
	{ .addr = 0x00f10141a4, .val = 0x00000000 },
	{ .addr = 0x00f10141a8, .val = 0x00000000 },
	{ .addr = 0x00f10141ac, .val = 0x00000000 },
	{ .addr = 0x00f10141b0, .val = 0x00000000 },
	{ .addr = 0x00f10141b4, .val = 0x00000000 },
	{ .addr = 0x00f10141b8, .val = 0x00000000 },
	{ .addr = 0x00f10141bc, .val = 0x00000000 },
	{ .addr = 0x00f10141c0, .val = 0x00000000 },
	{ .addr = 0x00f10141c4, .val = 0x00000000 },
	{ .addr = 0x00f10141c8, .val = 0x00000000 },
	{ .addr = 0x00f10141cc, .val = 0x00000000 },
	{ .addr = 0x00f10141d0, .val = 0x00000000 },
	{ .addr = 0x00f10141d4, .val = 0x00000000 },
	{ .addr = 0x00f10141d8, .val = 0x00000000 },
	{ .addr = 0x00f10141dc, .val = 0x00000000 },
	{ .addr = 0x00f10141e0, .val = 0x00000000 },
	{ .addr = 0x00f10141e4, .val = 0x00000000 },
	{ .addr = 0x00f10141e8, .val = 0x00000000 },
	{ .addr = 0x00f10141ec, .val = 0x00000000 },
	{ .addr = 0x00f10141f0, .val = 0x00000000 },
	{ .addr = 0x00f10141f4, .val = 0x00000000 },
	{ .addr = 0x00f10141f8, .val = 0x00000000 },
	{ .addr = 0x00f10141fc, .val = 0x00000000 },
	{ .addr = 0x00f1014200, .val = 0x00000000 },
	{ .addr = 0x00f1014204, .val = 0x00000000 },
	{ .addr = 0x00f1014208, .val = 0x00000000 },
	{ .addr = 0x00f101420c, .val = 0x00000000 },
	{ .addr = 0x00f1014210, .val = 0x00000000 },
	{ .addr = 0x00f1014214, .val = 0x00000000 },
	{ .addr = 0x00f1014218, .val = 0x00000000 },
	{ .addr = 0x00f101421c, .val = 0x00000000 },
	{ .addr = 0x00f1014220, .val = 0x00000000 },
	{ .addr = 0x00f1014224, .val = 0x00000000 },
	{ .addr = 0x00f1014228, .val = 0x00000000 },
	{ .addr = 0x00f101422c, .val = 0x00000000 },
	{ .addr = 0x00f1014230, .val = 0x00000000 },
	{ .addr = 0x00f1014234, .val = 0x00000000 },
	{ .addr = 0x00f1014238, .val = 0x00000000 },
	{ .addr = 0x00f101423c, .val = 0x00000000 },
	{ .addr = 0x00f1014240, .val = 0x00000000 },
	{ .addr = 0x00f1014244, .val = 0x00000000 },
	{ .addr = 0x00f1014248, .val = 0x00000000 },
	{ .addr = 0x00f101424c, .val = 0x00000000 },
	{ .addr = 0x00f1014250, .val = 0x00000000 },
	{ .addr = 0x00f1014254, .val = 0x00000000 },
	{ .addr = 0x00f1014258, .val = 0x00000000 },
	{ .addr = 0x00f101425c, .val = 0x00000000 },
	{ .addr = 0x00f1014260, .val = 0x00000000 },
	{ .addr = 0x00f1014264, .val = 0x00000000 },
	{ .addr = 0x00f1014268, .val = 0x00000000 },
	{ .addr = 0x00f101426c, .val = 0x00000000 },
	{ .addr = 0x00f1014270, .val = 0x00000000 },
	{ .addr = 0x00f1014274, .val = 0x00000000 },
	{ .addr = 0x00f1014278, .val = 0x00000000 },
	{ .addr = 0x00f101427c, .val = 0x00000000 },
	{ .addr = 0x00f1014280, .val = 0x00000000 },
	{ .addr = 0x00f1014284, .val = 0x00000000 },
	{ .addr = 0x00f1014288, .val = 0x00000000 },
	{ .addr = 0x00f101428c, .val = 0x00000000 },
	{ .addr = 0x00f1014290, .val = 0x00000000 },
	{ .addr = 0x00f1014294, .val = 0x00000000 },
	{ .addr = 0x00f1014298, .val = 0x00000000 },
	{ .addr = 0x00f101429c, .val = 0x00000000 },
	{ .addr = 0x00f10142a0, .val = 0x00000000 },
	{ .addr = 0x00f10142a4, .val = 0x00000000 },
	{ .addr = 0x00f10142a8, .val = 0x00000000 },
	{ .addr = 0x00f10142ac, .val = 0x00000000 },
	{ .addr = 0x00f10142b0, .val = 0x00000000 },
	{ .addr = 0x00f10142b4, .val = 0x00000000 },
	{ .addr = 0x00f10142b8, .val = 0x00000000 },
	{ .addr = 0x00f10142bc, .val = 0x00000000 },
	{ .addr = 0x00f10142c0, .val = 0x00000000 },
	{ .addr = 0x00f10142c4, .val = 0x00000000 },
	{ .addr = 0x00f10142c8, .val = 0x00000000 },
	{ .addr = 0x00f10142cc, .val = 0x00000000 },
	{ .addr = 0x00f10142d0, .val = 0x00000000 },
	{ .addr = 0x00f10142d4, .val = 0x00000000 },
	{ .addr = 0x00f10142d8, .val = 0x00000000 },
	{ .addr = 0x00f10142dc, .val = 0x00000000 },
	{ .addr = 0x00f10142e0, .val = 0x00000000 },
	{ .addr = 0x00f10142e4, .val = 0x00000000 },
	{ .addr = 0x00f10142e8, .val = 0x00000000 },
	{ .addr = 0x00f10142ec, .val = 0x00000000 },
	{ .addr = 0x00f10142f0, .val = 0x00000000 },
	{ .addr = 0x00f10142f4, .val = 0x00000000 },
	{ .addr = 0x00f10142f8, .val = 0x00000000 },
	{ .addr = 0x00f10142fc, .val = 0x00000000 },
	{ .addr = 0x00f1014300, .val = 0x00000000 },
	{ .addr = 0x00f1014304, .val = 0x00000000 },
	{ .addr = 0x00f1014308, .val = 0x00000000 },
	{ .addr = 0x00f101430c, .val = 0x00000000 },
	{ .addr = 0x00f1014310, .val = 0x00000000 },
	{ .addr = 0x00f1014314, .val = 0x00000000 },
	{ .addr = 0x00f1014318, .val = 0x00000000 },
	{ .addr = 0x00f101431c, .val = 0x00000000 },
	{ .addr = 0x00f1014320, .val = 0x00000000 },
	{ .addr = 0x00f1014324, .val = 0x00000000 },
	{ .addr = 0x00f1014328, .val = 0x00000000 },
	{ .addr = 0x00f101432c, .val = 0x00000000 },
	{ .addr = 0x00f1014330, .val = 0x00000000 },
	{ .addr = 0x00f1014334, .val = 0x00000000 },
	{ .addr = 0x00f1014338, .val = 0x00000000 },
	{ .addr = 0x00f101433c, .val = 0x00000000 },
	{ .addr = 0x00f1014340, .val = 0x00000000 },
	{ .addr = 0x00f1014344, .val = 0x00000000 },
	{ .addr = 0x00f1014348, .val = 0x00000000 },
	{ .addr = 0x00f101434c, .val = 0x00000000 },
	{ .addr = 0x00f1014350, .val = 0x00000000 },
	{ .addr = 0x00f1014354, .val = 0x00000000 },
	{ .addr = 0x00f1014358, .val = 0x00000000 },
	{ .addr = 0x00f101435c, .val = 0x00000000 },
	{ .addr = 0x00f1014360, .val = 0x00000000 },
	{ .addr = 0x00f1014364, .val = 0x00000000 },
	{ .addr = 0x00f1014368, .val = 0x00000000 },
	{ .addr = 0x00f101436c, .val = 0x00000000 },
	{ .addr = 0x00f1014370, .val = 0x00000000 },
	{ .addr = 0x00f1014374, .val = 0x00000000 },
	{ .addr = 0x00f1014378, .val = 0x00000000 },
	{ .addr = 0x00f101437c, .val = 0x00000000 },
	{ .addr = 0x00f1014380, .val = 0x00000000 },
	{ .addr = 0x00f1014384, .val = 0x00000000 },
	{ .addr = 0x00f1014388, .val = 0x00000000 },
	{ .addr = 0x00f101438c, .val = 0x00000000 },
	{ .addr = 0x00f1014390, .val = 0x00000000 },
	{ .addr = 0x00f1014394, .val = 0x00000000 },
	{ .addr = 0x00f1014398, .val = 0x00000000 },
	{ .addr = 0x00f101439c, .val = 0x00000000 },
	{ .addr = 0x00f10143a0, .val = 0x00000000 },
	{ .addr = 0x00f10143a4, .val = 0x00000000 },
	{ .addr = 0x00f10143a8, .val = 0x00000000 },
	{ .addr = 0x00f10143ac, .val = 0x00000000 },
	{ .addr = 0x00f10143b0, .val = 0x00000000 },
	{ .addr = 0x00f10143b4, .val = 0x00000000 },
	{ .addr = 0x00f10143b8, .val = 0x00000000 },
	{ .addr = 0x00f10143bc, .val = 0x00000000 },
	{ .addr = 0x00f10143c0, .val = 0x00000000 },
	{ .addr = 0x00f10143c4, .val = 0x00000000 },
	{ .addr = 0x00f10143c8, .val = 0x00000000 },
	{ .addr = 0x00f10143cc, .val = 0x00000000 },
	{ .addr = 0x00f10143d0, .val = 0x00000000 },
	{ .addr = 0x00f10143d4, .val = 0x00000000 },
	{ .addr = 0x00f10143d8, .val = 0x00000000 },
	{ .addr = 0x00f10143dc, .val = 0x00000000 },
	{ .addr = 0x00f10143e0, .val = 0x00000000 },
	{ .addr = 0x00f10143e4, .val = 0x00000000 },
	{ .addr = 0x00f10143e8, .val = 0x00000000 },
	{ .addr = 0x00f10143ec, .val = 0x00000000 },
	{ .addr = 0x00f10143f0, .val = 0x00000000 },
	{ .addr = 0x00f10143f4, .val = 0x00000000 },
	{ .addr = 0x00f10143f8, .val = 0x00000000 },
	{ .addr = 0x00f10143fc, .val = 0x00000000 },
	{ .addr = 0x00f1014400, .val = 0x00000000 },
	{ .addr = 0x00f1014404, .val = 0x00000000 },
	{ .addr = 0x00f1014408, .val = 0x00000000 },
	{ .addr = 0x00f101440c, .val = 0x00000000 },
	{ .addr = 0x00f1014410, .val = 0x00000000 },
	{ .addr = 0x00f1014414, .val = 0x00000000 },
	{ .addr = 0x00f1014418, .val = 0x00000000 },
	{ .addr = 0x00f101441c, .val = 0x00000000 },
	{ .addr = 0x00f1014420, .val = 0x00000000 },
	{ .addr = 0x00f1014424, .val = 0x00000000 },
	{ .addr = 0x00f1014428, .val = 0x00000000 },
	{ .addr = 0x00f101442c, .val = 0x00000000 },
	{ .addr = 0x00f1014430, .val = 0x00000000 },
	{ .addr = 0x00f1014434, .val = 0x00000000 },
	{ .addr = 0x00f1014438, .val = 0x00000000 },
	{ .addr = 0x00f101443c, .val = 0x00000000 },
	{ .addr = 0x00f1014440, .val = 0x00000000 },
	{ .addr = 0x00f1014444, .val = 0x00000000 },
	{ .addr = 0x00f1014448, .val = 0x00000000 },
	{ .addr = 0x00f101444c, .val = 0x00000000 },
	{ .addr = 0x00f1014450, .val = 0x00000000 },
	{ .addr = 0x00f1014454, .val = 0x00000000 },
	{ .addr = 0x00f1014458, .val = 0x00000000 },
	{ .addr = 0x00f101445c, .val = 0x00000000 },
	{ .addr = 0x00f1014460, .val = 0x00000000 },
	{ .addr = 0x00f1014464, .val = 0x00000000 },
	{ .addr = 0x00f1014468, .val = 0x00000000 },
	{ .addr = 0x00f101446c, .val = 0x00000000 },
	{ .addr = 0x00f1014470, .val = 0x00000000 },
	{ .addr = 0x00f1014474, .val = 0x00000000 },
	{ .addr = 0x00f1014478, .val = 0x00000000 },
	{ .addr = 0x00f101447c, .val = 0x00000000 },
	{ .addr = 0x00f1014480, .val = 0x00000000 },
	{ .addr = 0x00f1014484, .val = 0x00000000 },
	{ .addr = 0x00f1014488, .val = 0x00000000 },
	{ .addr = 0x00f101448c, .val = 0x00000000 },
	{ .addr = 0x00f1014490, .val = 0x00000000 },
	{ .addr = 0x00f1014494, .val = 0x00000000 },
	{ .addr = 0x00f1014498, .val = 0x00000000 },
	{ .addr = 0x00f101449c, .val = 0x00000000 },
	{ .addr = 0x00f10144a0, .val = 0x00000000 },
	{ .addr = 0x00f10144a4, .val = 0x00000000 },
	{ .addr = 0x00f10144a8, .val = 0x00000000 },
	{ .addr = 0x00f10144ac, .val = 0x00000000 },
	{ .addr = 0x00f10144b0, .val = 0x00000000 },
	{ .addr = 0x00f10144b4, .val = 0x00000000 },
	{ .addr = 0x00f10144b8, .val = 0x00000000 },
	{ .addr = 0x00f10144bc, .val = 0x00000000 },
	{ .addr = 0x00f10144c0, .val = 0x00000000 },
	{ .addr = 0x00f10144c4, .val = 0x00000000 },
	{ .addr = 0x00f10144c8, .val = 0x00000000 },
	{ .addr = 0x00f10144cc, .val = 0x00000000 },
	{ .addr = 0x00f10144d0, .val = 0x00000000 },
	{ .addr = 0x00f10144d4, .val = 0x00000000 },
	{ .addr = 0x00f10144d8, .val = 0x00000000 },
	{ .addr = 0x00f10144dc, .val = 0x00000000 },
	{ .addr = 0x00f10144e0, .val = 0x00000000 },
	{ .addr = 0x00f10144e4, .val = 0x00000000 },
	{ .addr = 0x00f10144e8, .val = 0x00000000 },
	{ .addr = 0x00f10144ec, .val = 0x00000000 },
	{ .addr = 0x00f10144f0, .val = 0x00000000 },
	{ .addr = 0x00f10144f4, .val = 0x00000000 },
	{ .addr = 0x00f10144f8, .val = 0x00000000 },
	{ .addr = 0x00f10144fc, .val = 0x00000000 },
	{ .addr = 0x00f1014500, .val = 0x00000000 },
	{ .addr = 0x00f1014504, .val = 0x00000000 },
	{ .addr = 0x00f1014508, .val = 0x00000000 },
	{ .addr = 0x00f101450c, .val = 0x00000000 },
	{ .addr = 0x00f1014510, .val = 0x00000000 },
	{ .addr = 0x00f1014514, .val = 0x00000000 },
	{ .addr = 0x00f1014518, .val = 0x00000000 },
	{ .addr = 0x00f101451c, .val = 0x00000000 },
	{ .addr = 0x00f1014520, .val = 0x00000000 },
	{ .addr = 0x00f1014524, .val = 0x00000000 },
	{ .addr = 0x00f1014528, .val = 0x00000000 },
	{ .addr = 0x00f101452c, .val = 0x00000000 },
	{ .addr = 0x00f1014530, .val = 0x00000000 },
	{ .addr = 0x00f1014534, .val = 0x00000000 },
	{ .addr = 0x00f1014538, .val = 0x00000000 },
	{ .addr = 0x00f101453c, .val = 0x00000000 },
	{ .addr = 0x00f1014540, .val = 0x00000000 },
	{ .addr = 0x00f1014544, .val = 0x00000000 },
	{ .addr = 0x00f1014548, .val = 0x00000000 },
	{ .addr = 0x00f101454c, .val = 0x00000000 },
	{ .addr = 0x00f1014550, .val = 0x00000000 },
	{ .addr = 0x00f1014554, .val = 0x00000000 },
	{ .addr = 0x00f1014558, .val = 0x00000000 },
	{ .addr = 0x00f101455c, .val = 0x00000000 },
	{ .addr = 0x00f1014560, .val = 0x00000000 },
	{ .addr = 0x00f1014564, .val = 0x00000000 },
	{ .addr = 0x00f1014568, .val = 0x00000000 },
	{ .addr = 0x00f101456c, .val = 0x00000000 },
	{ .addr = 0x00f1014570, .val = 0x00000000 },
	{ .addr = 0x00f1014574, .val = 0x00000000 },
	{ .addr = 0x00f1014578, .val = 0x00000000 },
	{ .addr = 0x00f101457c, .val = 0x00000000 },
	{ .addr = 0x00f1014580, .val = 0x00000000 },
	{ .addr = 0x00f1014584, .val = 0x00000000 },
	{ .addr = 0x00f1014588, .val = 0x00000000 },
	{ .addr = 0x00f101458c, .val = 0x00000000 },
	{ .addr = 0x00f1014590, .val = 0x00000000 },
	{ .addr = 0x00f1014594, .val = 0x00000000 },
	{ .addr = 0x00f1014598, .val = 0x00000000 },
	{ .addr = 0x00f101459c, .val = 0x00000000 },
	{ .addr = 0x00f10145a0, .val = 0x00000000 },
	{ .addr = 0x00f10145a4, .val = 0x00000000 },
	{ .addr = 0x00f10145a8, .val = 0x00000000 },
	{ .addr = 0x00f10145ac, .val = 0x00000000 },
	{ .addr = 0x00f10145b0, .val = 0x00000000 },
	{ .addr = 0x00f10145b4, .val = 0x00000000 },
	{ .addr = 0x00f10145b8, .val = 0x00000000 },
	{ .addr = 0x00f10145bc, .val = 0x00000000 },
	{ .addr = 0x00f10145c0, .val = 0x00000000 },
	{ .addr = 0x00f10145c4, .val = 0x00000000 },
	{ .addr = 0x00f10145c8, .val = 0x00000000 },
	{ .addr = 0x00f10145cc, .val = 0x00000000 },
	{ .addr = 0x00f10145d0, .val = 0x00000000 },
	{ .addr = 0x00f10145d4, .val = 0x00000000 },
	{ .addr = 0x00f10145d8, .val = 0x00000000 },
	{ .addr = 0x00f10145dc, .val = 0x00000000 },
	{ .addr = 0x00f10145e0, .val = 0x00000000 },
	{ .addr = 0x00f10145e4, .val = 0x00000000 },
	{ .addr = 0x00f10145e8, .val = 0x00000000 },
	{ .addr = 0x00f10145ec, .val = 0x00000000 },
	{ .addr = 0x00f10145f0, .val = 0x00000000 },
	{ .addr = 0x00f10145f4, .val = 0x00000000 },
	{ .addr = 0x00f10145f8, .val = 0x00000000 },
	{ .addr = 0x00f10145fc, .val = 0x00000000 },
	{ .addr = 0x00f1014600, .val = 0x00000000 },
	{ .addr = 0x00f1014604, .val = 0x00000000 },
	{ .addr = 0x00f1014608, .val = 0x00000000 },
	{ .addr = 0x00f101460c, .val = 0x00000000 },
	{ .addr = 0x00f1014610, .val = 0x00000000 },
	{ .addr = 0x00f1014614, .val = 0x00000000 },
	{ .addr = 0x00f1014618, .val = 0x00000000 },
	{ .addr = 0x00f101461c, .val = 0x00000000 },
	{ .addr = 0x00f1014620, .val = 0x00000000 },
	{ .addr = 0x00f1014624, .val = 0x00000000 },
	{ .addr = 0x00f1014628, .val = 0x00000000 },
	{ .addr = 0x00f101462c, .val = 0x00000000 },
	{ .addr = 0x00f1014630, .val = 0x00000000 },
	{ .addr = 0x00f1014634, .val = 0x00000000 },
	{ .addr = 0x00f1014638, .val = 0x00000000 },
	{ .addr = 0x00f101463c, .val = 0x00000000 },
	{ .addr = 0x00f1014640, .val = 0x00000000 },
	{ .addr = 0x00f1014644, .val = 0x00000000 },
	{ .addr = 0x00f1014648, .val = 0x00000000 },
	{ .addr = 0x00f101464c, .val = 0x00000000 },
	{ .addr = 0x00f1014650, .val = 0x00000000 },
	{ .addr = 0x00f1014654, .val = 0x00000000 },
	{ .addr = 0x00f1014658, .val = 0x00000000 },
	{ .addr = 0x00f101465c, .val = 0x00000000 },
	{ .addr = 0x00f1014660, .val = 0x00000000 },
	{ .addr = 0x00f1014664, .val = 0x00000000 },
	{ .addr = 0x00f1014668, .val = 0x00000000 },
	{ .addr = 0x00f101466c, .val = 0x00000000 },
	{ .addr = 0x00f1014670, .val = 0x00000000 },
	{ .addr = 0x00f1014674, .val = 0x00000000 },
	{ .addr = 0x00f1014678, .val = 0x00000000 },
	{ .addr = 0x00f101467c, .val = 0x00000000 },
	{ .addr = 0x00f1014680, .val = 0x00000000 },
	{ .addr = 0x00f1014684, .val = 0x00000000 },
	{ .addr = 0x00f1014688, .val = 0x00000000 },
	{ .addr = 0x00f101468c, .val = 0x00000000 },
	{ .addr = 0x00f1014690, .val = 0x00000000 },
	{ .addr = 0x00f1014694, .val = 0x00000000 },
	{ .addr = 0x00f1014698, .val = 0x00000000 },
	{ .addr = 0x00f101469c, .val = 0x00000000 },
	{ .addr = 0x00f10146a0, .val = 0x00000000 },
	{ .addr = 0x00f10146a4, .val = 0x00000000 },
	{ .addr = 0x00f10146a8, .val = 0x00000000 },
	{ .addr = 0x00f10146ac, .val = 0x00000000 },
	{ .addr = 0x00f10146b0, .val = 0x00000000 },
	{ .addr = 0x00f10146b4, .val = 0x00000000 },
	{ .addr = 0x00f10146b8, .val = 0x00000000 },
	{ .addr = 0x00f10146bc, .val = 0x00000000 },
	{ .addr = 0x00f10146c0, .val = 0x00000000 },
	{ .addr = 0x00f10146c4, .val = 0x00000000 },
	{ .addr = 0x00f10146c8, .val = 0x00000000 },
	{ .addr = 0x00f10146cc, .val = 0x00000000 },
	{ .addr = 0x00f10146d0, .val = 0x00000000 },
	{ .addr = 0x00f10146d4, .val = 0x00000000 },
	{ .addr = 0x00f10146d8, .val = 0x00000000 },
	{ .addr = 0x00f10146dc, .val = 0x00000000 },
	{ .addr = 0x00f10146e0, .val = 0x00000000 },
	{ .addr = 0x00f10146e4, .val = 0x00000000 },
	{ .addr = 0x00f10146e8, .val = 0x00000000 },
	{ .addr = 0x00f10146ec, .val = 0x00000000 },
	{ .addr = 0x00f10146f0, .val = 0x00000000 },
	{ .addr = 0x00f10146f4, .val = 0x00000000 },
	{ .addr = 0x00f10146f8, .val = 0x00000000 },
	{ .addr = 0x00f10146fc, .val = 0x00000000 },
	{ .addr = 0x00f1014700, .val = 0x00000000 },
	{ .addr = 0x00f1014704, .val = 0x00000000 },
	{ .addr = 0x00f1014708, .val = 0x00000000 },
	{ .addr = 0x00f101470c, .val = 0x00000000 },
	{ .addr = 0x00f1014710, .val = 0x00000000 },
	{ .addr = 0x00f1014714, .val = 0x00000000 },
	{ .addr = 0x00f1014718, .val = 0x00000000 },
	{ .addr = 0x00f101471c, .val = 0x00000000 },
	{ .addr = 0x00f1014720, .val = 0x00000000 },
	{ .addr = 0x00f1014724, .val = 0x00000000 },
	{ .addr = 0x00f1014728, .val = 0x00000000 },
	{ .addr = 0x00f101472c, .val = 0x00000000 },
	{ .addr = 0x00f1014730, .val = 0x00000000 },
	{ .addr = 0x00f1014734, .val = 0x00000000 },
	{ .addr = 0x00f1014738, .val = 0x00000000 },
	{ .addr = 0x00f101473c, .val = 0x00000000 },
	{ .addr = 0x00f1014740, .val = 0x00000000 },
	{ .addr = 0x00f1014744, .val = 0x00000000 },
	{ .addr = 0x00f1014748, .val = 0x00000000 },
	{ .addr = 0x00f101474c, .val = 0x00000000 },
	{ .addr = 0x00f1014750, .val = 0x00000000 },
	{ .addr = 0x00f1014754, .val = 0x00000000 },
	{ .addr = 0x00f1014758, .val = 0x00000000 },
	{ .addr = 0x00f101475c, .val = 0x00000000 },
	{ .addr = 0x00f1014760, .val = 0x00000000 },
	{ .addr = 0x00f1014764, .val = 0x00000000 },
	{ .addr = 0x00f1014768, .val = 0x00000000 },
	{ .addr = 0x00f101476c, .val = 0x00000000 },
	{ .addr = 0x00f1014770, .val = 0x00000000 },
	{ .addr = 0x00f1014774, .val = 0x00000000 },
	{ .addr = 0x00f1014778, .val = 0x00000000 },
	{ .addr = 0x00f101477c, .val = 0x00000000 },
	{ .addr = 0x00f1014780, .val = 0x00000000 },
	{ .addr = 0x00f1014784, .val = 0x00000000 },
	{ .addr = 0x00f1014788, .val = 0x00000000 },
	{ .addr = 0x00f101478c, .val = 0x00000000 },
	{ .addr = 0x00f1014790, .val = 0x00000000 },
	{ .addr = 0x00f1014794, .val = 0x00000000 },
	{ .addr = 0x00f1014798, .val = 0x00000000 },
	{ .addr = 0x00f101479c, .val = 0x00000000 },
	{ .addr = 0x00f10147a0, .val = 0x00000000 },
	{ .addr = 0x00f10147a4, .val = 0x00000000 },
	{ .addr = 0x00f10147a8, .val = 0x00000000 },
	{ .addr = 0x00f10147ac, .val = 0x00000000 },
	{ .addr = 0x00f10147b0, .val = 0x00000000 },
	{ .addr = 0x00f10147b4, .val = 0x00000000 },
	{ .addr = 0x00f10147b8, .val = 0x00000000 },
	{ .addr = 0x00f10147bc, .val = 0x00000000 },
	{ .addr = 0x00f10147c0, .val = 0x00000000 },
	{ .addr = 0x00f10147c4, .val = 0x00000000 },
	{ .addr = 0x00f10147c8, .val = 0x00000000 },
	{ .addr = 0x00f10147cc, .val = 0x00000000 },
	{ .addr = 0x00f10147d0, .val = 0x00000000 },
	{ .addr = 0x00f10147d4, .val = 0x00000000 },
	{ .addr = 0x00f10147d8, .val = 0x00000000 },
	{ .addr = 0x00f10147dc, .val = 0x00000000 },
	{ .addr = 0x00f10147e0, .val = 0x00000000 },
	{ .addr = 0x00f10147e4, .val = 0x00000000 },
	{ .addr = 0x00f10147e8, .val = 0x00000000 },
	{ .addr = 0x00f10147ec, .val = 0x00000000 },
	{ .addr = 0x00f10147f0, .val = 0x00000000 },
	{ .addr = 0x00f10147f4, .val = 0x00000000 },
	{ .addr = 0x00f10147f8, .val = 0x00000000 },
	{ .addr = 0x00f10147fc, .val = 0x00000000 },
	{ .addr = 0x00f1014800, .val = 0x00000000 },
	{ .addr = 0x00f1014804, .val = 0x00000000 },
	{ .addr = 0x00f1014808, .val = 0x00000000 },
	{ .addr = 0x00f101480c, .val = 0x00000000 },
	{ .addr = 0x00f1014810, .val = 0x00000000 },
	{ .addr = 0x00f1014814, .val = 0x00000000 },
	{ .addr = 0x00f1014818, .val = 0x00000000 },
	{ .addr = 0x00f101481c, .val = 0x00000000 },
	{ .addr = 0x00f1014820, .val = 0x00000000 },
	{ .addr = 0x00f1014824, .val = 0x00000000 },
	{ .addr = 0x00f1014828, .val = 0x00000000 },
	{ .addr = 0x00f101482c, .val = 0x00000000 },
	{ .addr = 0x00f1014830, .val = 0x00000000 },
	{ .addr = 0x00f1014834, .val = 0x00000000 },
	{ .addr = 0x00f1014838, .val = 0x00000000 },
	{ .addr = 0x00f101483c, .val = 0x00000000 },
	{ .addr = 0x00f1014840, .val = 0x00000000 },
	{ .addr = 0x00f1014844, .val = 0x00000000 },
	{ .addr = 0x00f1014848, .val = 0x00000000 },
	{ .addr = 0x00f101484c, .val = 0x00000000 },
	{ .addr = 0x00f1014850, .val = 0x00000000 },
	{ .addr = 0x00f1014854, .val = 0x00000000 },
	{ .addr = 0x00f1014858, .val = 0x00000000 },
	{ .addr = 0x00f101485c, .val = 0x00000000 },
	{ .addr = 0x00f1014860, .val = 0x00000000 },
	{ .addr = 0x00f1014864, .val = 0x00000000 },
	{ .addr = 0x00f1014868, .val = 0x00000000 },
	{ .addr = 0x00f101486c, .val = 0x00000000 },
	{ .addr = 0x00f1014870, .val = 0x00000000 },
	{ .addr = 0x00f1014874, .val = 0x00000000 },
	{ .addr = 0x00f1014878, .val = 0x00000000 },
	{ .addr = 0x00f101487c, .val = 0x00000000 },
	{ .addr = 0x00f1014880, .val = 0x00000000 },
	{ .addr = 0x00f1014884, .val = 0x00000000 },
	{ .addr = 0x00f1014888, .val = 0x00000000 },
	{ .addr = 0x00f101488c, .val = 0x00000000 },
	{ .addr = 0x00f1014890, .val = 0x00000000 },
	{ .addr = 0x00f1014894, .val = 0x00000000 },
	{ .addr = 0x00f1014898, .val = 0x00000000 },
	{ .addr = 0x00f101489c, .val = 0x00000000 },
	{ .addr = 0x00f10148a0, .val = 0x00000000 },
	{ .addr = 0x00f10148a4, .val = 0x00000000 },
	{ .addr = 0x00f10148a8, .val = 0x00000000 },
	{ .addr = 0x00f10148ac, .val = 0x00000000 },
	{ .addr = 0x00f10148b0, .val = 0x00000000 },
	{ .addr = 0x00f10148b4, .val = 0x00000000 },
	{ .addr = 0x00f10148b8, .val = 0x00000000 },
	{ .addr = 0x00f10148bc, .val = 0x00000000 },
	{ .addr = 0x00f10148c0, .val = 0x00000000 },
	{ .addr = 0x00f10148c4, .val = 0x00000000 },
	{ .addr = 0x00f10148c8, .val = 0x00000000 },
	{ .addr = 0x00f10148cc, .val = 0x00000000 },
	{ .addr = 0x00f10148d0, .val = 0x00000000 },
	{ .addr = 0x00f10148d4, .val = 0x00000000 },
	{ .addr = 0x00f10148d8, .val = 0x00000000 },
	{ .addr = 0x00f10148dc, .val = 0x00000000 },
	{ .addr = 0x00f10148e0, .val = 0x00000000 },
	{ .addr = 0x00f10148e4, .val = 0x00000000 },
	{ .addr = 0x00f10148e8, .val = 0x00000000 },
	{ .addr = 0x00f10148ec, .val = 0x00000000 },
	{ .addr = 0x00f10148f0, .val = 0x00000000 },
	{ .addr = 0x00f10148f4, .val = 0x00000000 },
	{ .addr = 0x00f10148f8, .val = 0x00000000 },
	{ .addr = 0x00f10148fc, .val = 0x00000000 },
	{ .addr = 0x00f1014900, .val = 0x00000000 },
	{ .addr = 0x00f1014904, .val = 0x00000000 },
	{ .addr = 0x00f1014908, .val = 0x00000000 },
	{ .addr = 0x00f101490c, .val = 0x00000000 },
	{ .addr = 0x00f1014910, .val = 0x00000000 },
	{ .addr = 0x00f1014914, .val = 0x00000000 },
	{ .addr = 0x00f1014918, .val = 0x00000000 },
	{ .addr = 0x00f101491c, .val = 0x00000000 },
	{ .addr = 0x00f1014920, .val = 0x00000000 },
	{ .addr = 0x00f1014924, .val = 0x00000000 },
	{ .addr = 0x00f1014928, .val = 0x00000000 },
	{ .addr = 0x00f101492c, .val = 0x00000000 },
	{ .addr = 0x00f1014930, .val = 0x00000000 },
	{ .addr = 0x00f1014934, .val = 0x00000000 },
	{ .addr = 0x00f1014938, .val = 0x00000000 },
	{ .addr = 0x00f101493c, .val = 0x00000000 },
	{ .addr = 0x00f1014940, .val = 0x00000000 },
	{ .addr = 0x00f1014944, .val = 0x00000000 },
	{ .addr = 0x00f1014948, .val = 0x00000000 },
	{ .addr = 0x00f101494c, .val = 0x00000000 },
	{ .addr = 0x00f1014950, .val = 0x00000000 },
	{ .addr = 0x00f1014954, .val = 0x00000000 },
	{ .addr = 0x00f1014958, .val = 0x00000000 },
	{ .addr = 0x00f101495c, .val = 0x00000000 },
	{ .addr = 0x00f1014960, .val = 0x00000000 },
	{ .addr = 0x00f1014964, .val = 0x00000000 },
	{ .addr = 0x00f1014968, .val = 0x00000000 },
	{ .addr = 0x00f101496c, .val = 0x00000000 },
	{ .addr = 0x00f1014970, .val = 0x00000000 },
	{ .addr = 0x00f1014974, .val = 0x00000000 },
	{ .addr = 0x00f1014978, .val = 0x00000000 },
	{ .addr = 0x00f101497c, .val = 0x00000000 },
	{ .addr = 0x00f1014980, .val = 0x00000000 },
	{ .addr = 0x00f1014984, .val = 0x00000000 },
	{ .addr = 0x00f1014988, .val = 0x00000000 },
	{ .addr = 0x00f101498c, .val = 0x00000000 },
	{ .addr = 0x00f1014990, .val = 0x00000000 },
	{ .addr = 0x00f1014994, .val = 0x00000000 },
	{ .addr = 0x00f1014998, .val = 0x00000000 },
	{ .addr = 0x00f101499c, .val = 0x00000000 },
	{ .addr = 0x00f10149a0, .val = 0x00000000 },
	{ .addr = 0x00f10149a4, .val = 0x00000000 },
	{ .addr = 0x00f10149a8, .val = 0x00000000 },
	{ .addr = 0x00f10149ac, .val = 0x00000000 },
	{ .addr = 0x00f10149b0, .val = 0x00000000 },
	{ .addr = 0x00f10149b4, .val = 0x00000000 },
	{ .addr = 0x00f10149b8, .val = 0x00000000 },
	{ .addr = 0x00f10149bc, .val = 0x00000000 },
	{ .addr = 0x00f10149c0, .val = 0x00000000 },
	{ .addr = 0x00f10149c4, .val = 0x00000000 },
	{ .addr = 0x00f10149c8, .val = 0x00000000 },
	{ .addr = 0x00f10149cc, .val = 0x00000000 },
	{ .addr = 0x00f10149d0, .val = 0x00000000 },
	{ .addr = 0x00f10149d4, .val = 0x00000000 },
	{ .addr = 0x00f10149d8, .val = 0x00000000 },
	{ .addr = 0x00f10149dc, .val = 0x00000000 },
	{ .addr = 0x00f10149e0, .val = 0x00000000 },
	{ .addr = 0x00f10149e4, .val = 0x00000000 },
	{ .addr = 0x00f10149e8, .val = 0x00000000 },
	{ .addr = 0x00f10149ec, .val = 0x00000000 },
	{ .addr = 0x00f10149f0, .val = 0x00000000 },
	{ .addr = 0x00f10149f4, .val = 0x00000000 },
	{ .addr = 0x00f10149f8, .val = 0x00000000 },
	{ .addr = 0x00f10149fc, .val = 0x00000000 },
	{ .addr = 0x00f1014a00, .val = 0x00000000 },
	{ .addr = 0x00f1014a04, .val = 0x00000000 },
	{ .addr = 0x00f1014a08, .val = 0x00000000 },
	{ .addr = 0x00f1014a0c, .val = 0x00000000 },
	{ .addr = 0x00f1014a10, .val = 0x00000000 },
	{ .addr = 0x00f1014a14, .val = 0x00000000 },
	{ .addr = 0x00f1014a18, .val = 0x00000000 },
	{ .addr = 0x00f1014a1c, .val = 0x00000000 },
	{ .addr = 0x00f1014a20, .val = 0x00000000 },
	{ .addr = 0x00f1014a24, .val = 0x00000000 },
	{ .addr = 0x00f1014a28, .val = 0x00000000 },
	{ .addr = 0x00f1014a2c, .val = 0x00000000 },
	{ .addr = 0x00f1014a30, .val = 0x00000000 },
	{ .addr = 0x00f1014a34, .val = 0x00000000 },
	{ .addr = 0x00f1014a38, .val = 0x00000000 },
	{ .addr = 0x00f1014a3c, .val = 0x00000000 },
	{ .addr = 0x00f1014a40, .val = 0x00000000 },
	{ .addr = 0x00f1014a44, .val = 0x00000000 },
	{ .addr = 0x00f1014a48, .val = 0x00000000 },
	{ .addr = 0x00f1014a4c, .val = 0x00000000 },
	{ .addr = 0x00f1014a50, .val = 0x00000000 },
	{ .addr = 0x00f1014a54, .val = 0x00000000 },
	{ .addr = 0x00f1014a58, .val = 0x00000000 },
	{ .addr = 0x00f1014a5c, .val = 0x00000000 },
	{ .addr = 0x00f1014a60, .val = 0x00000000 },
	{ .addr = 0x00f1014a64, .val = 0x00000000 },
	{ .addr = 0x00f1014a68, .val = 0x00000000 },
	{ .addr = 0x00f1014a6c, .val = 0x00000000 },
	{ .addr = 0x00f1014a70, .val = 0x00000000 },
	{ .addr = 0x00f1014a74, .val = 0x00000000 },
	{ .addr = 0x00f1014a78, .val = 0x00000000 },
	{ .addr = 0x00f1014a7c, .val = 0x00000000 },
	{ .addr = 0x00f1014a80, .val = 0x00000000 },
	{ .addr = 0x00f1014a84, .val = 0x00000000 },
	{ .addr = 0x00f1014a88, .val = 0x00000000 },
	{ .addr = 0x00f1014a8c, .val = 0x00000000 },
	{ .addr = 0x00f1014a90, .val = 0x00000000 },
	{ .addr = 0x00f1014a94, .val = 0x00000000 },
	{ .addr = 0x00f1014a98, .val = 0x00000000 },
	{ .addr = 0x00f1014a9c, .val = 0x00000000 },
	{ .addr = 0x00f1014aa0, .val = 0x00000000 },
	{ .addr = 0x00f1014aa4, .val = 0x00000000 },
	{ .addr = 0x00f1014aa8, .val = 0x00000000 },
	{ .addr = 0x00f1014aac, .val = 0x00000000 },
	{ .addr = 0x00f1014ab0, .val = 0x00000000 },
	{ .addr = 0x00f1014ab4, .val = 0x00000000 },
	{ .addr = 0x00f1014ab8, .val = 0x00000000 },
	{ .addr = 0x00f1014abc, .val = 0x00000000 },
	{ .addr = 0x00f1014ac0, .val = 0x00000000 },
	{ .addr = 0x00f1014ac4, .val = 0x00000000 },
	{ .addr = 0x00f1014ac8, .val = 0x00000000 },
	{ .addr = 0x00f1014acc, .val = 0x00000000 },
	{ .addr = 0x00f1014ad0, .val = 0x00000000 },
	{ .addr = 0x00f1014ad4, .val = 0x00000000 },
	{ .addr = 0x00f1014ad8, .val = 0x00000000 },
	{ .addr = 0x00f1014adc, .val = 0x00000000 },
	{ .addr = 0x00f1014ae0, .val = 0x00000000 },
	{ .addr = 0x00f1014ae4, .val = 0x00000000 },
	{ .addr = 0x00f1014ae8, .val = 0x00000000 },
	{ .addr = 0x00f1014aec, .val = 0x00000000 },
	{ .addr = 0x00f1014af0, .val = 0x00000000 },
	{ .addr = 0x00f1014af4, .val = 0x00000000 },
	{ .addr = 0x00f1014af8, .val = 0x00000000 },
	{ .addr = 0x00f1014afc, .val = 0x00000000 },
	{ .addr = 0x00f1014b00, .val = 0x00000000 },
	{ .addr = 0x00f1014b04, .val = 0x00000000 },
	{ .addr = 0x00f1014b08, .val = 0x00000000 },
	{ .addr = 0x00f1014b0c, .val = 0x00000000 },
	{ .addr = 0x00f1014b10, .val = 0x00000000 },
	{ .addr = 0x00f1014b14, .val = 0x00000000 },
	{ .addr = 0x00f1014b18, .val = 0x00000000 },
	{ .addr = 0x00f1014b1c, .val = 0x00000000 },
	{ .addr = 0x00f1014b20, .val = 0x00000000 },
	{ .addr = 0x00f1014b24, .val = 0x00000000 },
	{ .addr = 0x00f1014b28, .val = 0x00000000 },
	{ .addr = 0x00f1014b2c, .val = 0x00000000 },
	{ .addr = 0x00f1014b30, .val = 0x00000000 },
	{ .addr = 0x00f1014b34, .val = 0x00000000 },
	{ .addr = 0x00f1014b38, .val = 0x00000000 },
	{ .addr = 0x00f1014b3c, .val = 0x00000000 },
	{ .addr = 0x00f1014b40, .val = 0x00000000 },
	{ .addr = 0x00f1014b44, .val = 0x00000000 },
	{ .addr = 0x00f1014b48, .val = 0x00000000 },
	{ .addr = 0x00f1014b4c, .val = 0x00000000 },
	{ .addr = 0x00f1014b50, .val = 0x00000000 },
	{ .addr = 0x00f1014b54, .val = 0x00000000 },
	{ .addr = 0x00f1014b58, .val = 0x00000000 },
	{ .addr = 0x00f1014b5c, .val = 0x00000000 },
	{ .addr = 0x00f1014b60, .val = 0x00000000 },
	{ .addr = 0x00f1014b64, .val = 0x00000000 },
	{ .addr = 0x00f1014b68, .val = 0x00000000 },
	{ .addr = 0x00f1014b6c, .val = 0x00000000 },
	{ .addr = 0x00f1014b70, .val = 0x00000000 },
	{ .addr = 0x00f1014b74, .val = 0x00000000 },
	{ .addr = 0x00f1014b78, .val = 0x00000000 },
	{ .addr = 0x00f1014b7c, .val = 0x00000000 },
	{ .addr = 0x00f1014b80, .val = 0x00000000 },
	{ .addr = 0x00f1014b84, .val = 0x00000000 },
	{ .addr = 0x00f1014b88, .val = 0x00000000 },
	{ .addr = 0x00f1014b8c, .val = 0x00000000 },
	{ .addr = 0x00f1014b90, .val = 0x00000000 },
	{ .addr = 0x00f1014b94, .val = 0x00000000 },
	{ .addr = 0x00f1014b98, .val = 0x00000000 },
	{ .addr = 0x00f1014b9c, .val = 0x00000000 },
	{ .addr = 0x00f1014ba0, .val = 0x00000000 },
	{ .addr = 0x00f1014ba4, .val = 0x00000000 },
	{ .addr = 0x00f1014ba8, .val = 0x00000000 },
	{ .addr = 0x00f1014bac, .val = 0x00000000 },
	{ .addr = 0x00f1014bb0, .val = 0x00000000 },
	{ .addr = 0x00f1014bb4, .val = 0x00000000 },
	{ .addr = 0x00f1014bb8, .val = 0x00000000 },
	{ .addr = 0x00f1014bbc, .val = 0x00000000 },
	{ .addr = 0x00f1014bc0, .val = 0x00000000 },
	{ .addr = 0x00f1014bc4, .val = 0x00000000 },
	{ .addr = 0x00f1014bc8, .val = 0x00000000 },
	{ .addr = 0x00f1014bcc, .val = 0x00000000 },
	{ .addr = 0x00f1014bd0, .val = 0x00000000 },
	{ .addr = 0x00f1014bd4, .val = 0x00000000 },
	{ .addr = 0x00f1014bd8, .val = 0x00000000 },
	{ .addr = 0x00f1014bdc, .val = 0x00000000 },
	{ .addr = 0x00f1014be0, .val = 0x00000000 },
	{ .addr = 0x00f1014be4, .val = 0x00000000 },
	{ .addr = 0x00f1014be8, .val = 0x00000000 },
	{ .addr = 0x00f1014bec, .val = 0x00000000 },
	{ .addr = 0x00f1014bf0, .val = 0x00000000 },
	{ .addr = 0x00f1014bf4, .val = 0x00000000 },
	{ .addr = 0x00f1014bf8, .val = 0x00000000 },
	{ .addr = 0x00f1014bfc, .val = 0x00000000 },
	{ .addr = 0x00f1014c00, .val = 0x00000000 },
	{ .addr = 0x00f1014c04, .val = 0x00000000 },
	{ .addr = 0x00f1014c08, .val = 0x00000000 },
	{ .addr = 0x00f1014c0c, .val = 0x00000000 },
	{ .addr = 0x00f1014c10, .val = 0x00000000 },
	{ .addr = 0x00f1014c14, .val = 0x00000000 },
	{ .addr = 0x00f1014c18, .val = 0x00000000 },
	{ .addr = 0x00f1014c1c, .val = 0x00000000 },
	{ .addr = 0x00f1014c20, .val = 0x00000000 },
	{ .addr = 0x00f1014c24, .val = 0x00000000 },
	{ .addr = 0x00f1014c28, .val = 0x00000000 },
	{ .addr = 0x00f1014c2c, .val = 0x00000000 },
	{ .addr = 0x00f1014c30, .val = 0x00000000 },
	{ .addr = 0x00f1014c34, .val = 0x00000000 },
	{ .addr = 0x00f1014c38, .val = 0x00000000 },
	{ .addr = 0x00f1014c3c, .val = 0x00000000 },
	{ .addr = 0x00f1014c40, .val = 0x00000000 },
	{ .addr = 0x00f1014c44, .val = 0x00000000 },
	{ .addr = 0x00f1014c48, .val = 0x00000000 },
	{ .addr = 0x00f1014c4c, .val = 0x00000000 },
	{ .addr = 0x00f1014c50, .val = 0x00000000 },
	{ .addr = 0x00f1014c54, .val = 0x00000000 },
	{ .addr = 0x00f1014c58, .val = 0x00000000 },
	{ .addr = 0x00f1014c5c, .val = 0x00000000 },
	{ .addr = 0x00f1014c60, .val = 0x00000000 },
	{ .addr = 0x00f1014c64, .val = 0x00000000 },
	{ .addr = 0x00f1014c68, .val = 0x00000000 },
	{ .addr = 0x00f1014c6c, .val = 0x00000000 },
	{ .addr = 0x00f1014c70, .val = 0x00000000 },
	{ .addr = 0x00f1014c74, .val = 0x00000000 },
	{ .addr = 0x00f1014c78, .val = 0x00000000 },
	{ .addr = 0x00f1014c7c, .val = 0x00000000 },
	{ .addr = 0x00f1014c80, .val = 0x00000000 },
	{ .addr = 0x00f1014c84, .val = 0x00000000 },
	{ .addr = 0x00f1014c88, .val = 0x00000000 },
	{ .addr = 0x00f1014c8c, .val = 0x00000000 },
	{ .addr = 0x00f1014c90, .val = 0x00000000 },
	{ .addr = 0x00f1014c94, .val = 0x00000000 },
	{ .addr = 0x00f1014c98, .val = 0x00000000 },
	{ .addr = 0x00f1014c9c, .val = 0x00000000 },
	{ .addr = 0x00f1014ca0, .val = 0x00000000 },
	{ .addr = 0x00f1014ca4, .val = 0x00000000 },
	{ .addr = 0x00f1014ca8, .val = 0x00000000 },
	{ .addr = 0x00f1014cac, .val = 0x00000000 },
	{ .addr = 0x00f1014cb0, .val = 0x00000000 },
	{ .addr = 0x00f1014cb4, .val = 0x00000000 },
	{ .addr = 0x00f1014cb8, .val = 0x00000000 },
	{ .addr = 0x00f1014cbc, .val = 0x00000000 },
	{ .addr = 0x00f1014cc0, .val = 0x00000000 },
	{ .addr = 0x00f1014cc4, .val = 0x00000000 },
	{ .addr = 0x00f1014cc8, .val = 0x00000000 },
	{ .addr = 0x00f1014ccc, .val = 0x00000000 },
	{ .addr = 0x00f1014cd0, .val = 0x00000000 },
	{ .addr = 0x00f1014cd4, .val = 0x00000000 },
	{ .addr = 0x00f1014cd8, .val = 0x00000000 },
	{ .addr = 0x00f1014cdc, .val = 0x00000000 },
	{ .addr = 0x00f1014ce0, .val = 0x00000000 },
	{ .addr = 0x00f1014ce4, .val = 0x00000000 },
	{ .addr = 0x00f1014ce8, .val = 0x00000000 },
	{ .addr = 0x00f1014cec, .val = 0x00000000 },
	{ .addr = 0x00f1014cf0, .val = 0x00000000 },
	{ .addr = 0x00f1014cf4, .val = 0x00000000 },
	{ .addr = 0x00f1014cf8, .val = 0x00000000 },
	{ .addr = 0x00f1014cfc, .val = 0x00000000 },
	{ .addr = 0x00f1014d00, .val = 0x00000000 },
	{ .addr = 0x00f1014d04, .val = 0x00000000 },
	{ .addr = 0x00f1014d08, .val = 0x00000000 },
	{ .addr = 0x00f1014d0c, .val = 0x00000000 },
	{ .addr = 0x00f1014d10, .val = 0x00000000 },
	{ .addr = 0x00f1014d14, .val = 0x00000000 },
	{ .addr = 0x00f1014d18, .val = 0x00000000 },
	{ .addr = 0x00f1014d1c, .val = 0x00000000 },
	{ .addr = 0x00f1014d20, .val = 0x00000000 },
	{ .addr = 0x00f1014d24, .val = 0x00000000 },
	{ .addr = 0x00f1014d28, .val = 0x00000000 },
	{ .addr = 0x00f1014d2c, .val = 0x00000000 },
	{ .addr = 0x00f1014d30, .val = 0x00000000 },
	{ .addr = 0x00f1014d34, .val = 0x00000000 },
	{ .addr = 0x00f1014d38, .val = 0x00000000 },
	{ .addr = 0x00f1014d3c, .val = 0x00000000 },
	{ .addr = 0x00f1014d40, .val = 0x00000000 },
	{ .addr = 0x00f1014d44, .val = 0x00000000 },
	{ .addr = 0x00f1014d48, .val = 0x00000000 },
	{ .addr = 0x00f1014d4c, .val = 0x00000000 },
	{ .addr = 0x00f1014d50, .val = 0x00000000 },
	{ .addr = 0x00f1014d54, .val = 0x00000000 },
	{ .addr = 0x00f1014d58, .val = 0x00000000 },
	{ .addr = 0x00f1014d5c, .val = 0x00000000 },
	{ .addr = 0x00f1014d60, .val = 0x00000000 },
	{ .addr = 0x00f1014d64, .val = 0x00000000 },
	{ .addr = 0x00f1014d68, .val = 0x00000000 },
	{ .addr = 0x00f1014d6c, .val = 0x00000000 },
	{ .addr = 0x00f1014d70, .val = 0x00000000 },
	{ .addr = 0x00f1014d74, .val = 0x00000000 },
	{ .addr = 0x00f1014d78, .val = 0x00000000 },
	{ .addr = 0x00f1014d7c, .val = 0x00000000 },
	{ .addr = 0x00f1014d80, .val = 0x00000000 },
	{ .addr = 0x00f1014d84, .val = 0x00000000 },
	{ .addr = 0x00f1014d88, .val = 0x00000000 },
	{ .addr = 0x00f1014d8c, .val = 0x00000000 },
	{ .addr = 0x00f1014d90, .val = 0x00000000 },
	{ .addr = 0x00f1014d94, .val = 0x00000000 },
	{ .addr = 0x00f1014d98, .val = 0x00000000 },
	{ .addr = 0x00f1014d9c, .val = 0x00000000 },
	{ .addr = 0x00f1014da0, .val = 0x00000000 },
	{ .addr = 0x00f1014da4, .val = 0x00000000 },
	{ .addr = 0x00f1014da8, .val = 0x00000000 },
	{ .addr = 0x00f1014dac, .val = 0x00000000 },
	{ .addr = 0x00f1014db0, .val = 0x00000000 },
	{ .addr = 0x00f1014db4, .val = 0x00000000 },
	{ .addr = 0x00f1014db8, .val = 0x00000000 },
	{ .addr = 0x00f1014dbc, .val = 0x00000000 },
	{ .addr = 0x00f1014dc0, .val = 0x00000000 },
	{ .addr = 0x00f1014dc4, .val = 0x00000000 },
	{ .addr = 0x00f1014dc8, .val = 0x00000000 },
	{ .addr = 0x00f1014dcc, .val = 0x00000000 },
	{ .addr = 0x00f1014dd0, .val = 0x00000000 },
	{ .addr = 0x00f1014dd4, .val = 0x00000000 },
	{ .addr = 0x00f1014dd8, .val = 0x00000000 },
	{ .addr = 0x00f1014ddc, .val = 0x00000000 },
	{ .addr = 0x00f1014de0, .val = 0x00000000 },
	{ .addr = 0x00f1014de4, .val = 0x00000000 },
	{ .addr = 0x00f1014de8, .val = 0x00000000 },
	{ .addr = 0x00f1014dec, .val = 0x00000000 },
	{ .addr = 0x00f1014df0, .val = 0x00000000 },
	{ .addr = 0x00f1014df4, .val = 0x00000000 },
	{ .addr = 0x00f1014df8, .val = 0x00000000 },
	{ .addr = 0x00f1014dfc, .val = 0x00000000 },
	{ .addr = 0x00f1014e00, .val = 0x00000000 },
	{ .addr = 0x00f1014e04, .val = 0x00000000 },
	{ .addr = 0x00f1014e08, .val = 0x00000000 },
	{ .addr = 0x00f1014e0c, .val = 0x00000000 },
	{ .addr = 0x00f1014e10, .val = 0x00000000 },
	{ .addr = 0x00f1014e14, .val = 0x00000000 },
	{ .addr = 0x00f1014e18, .val = 0x00000000 },
	{ .addr = 0x00f1014e1c, .val = 0x00000000 },
	{ .addr = 0x00f1014e20, .val = 0x00000000 },
	{ .addr = 0x00f1014e24, .val = 0x00000000 },
	{ .addr = 0x00f1014e28, .val = 0x00000000 },
	{ .addr = 0x00f1014e2c, .val = 0x00000000 },
	{ .addr = 0x00f1014e30, .val = 0x00000000 },
	{ .addr = 0x00f1014e34, .val = 0x00000000 },
	{ .addr = 0x00f1014e38, .val = 0x00000000 },
	{ .addr = 0x00f1014e3c, .val = 0x00000000 },
	{ .addr = 0x00f1014e40, .val = 0x00000000 },
	{ .addr = 0x00f1014e44, .val = 0x00000000 },
	{ .addr = 0x00f1014e48, .val = 0x00000000 },
	{ .addr = 0x00f1014e4c, .val = 0x00000000 },
	{ .addr = 0x00f1014e50, .val = 0x00000000 },
	{ .addr = 0x00f1014e54, .val = 0x00000000 },
	{ .addr = 0x00f1014e58, .val = 0x00000000 },
	{ .addr = 0x00f1014e5c, .val = 0x00000000 },
	{ .addr = 0x00f1014e60, .val = 0x00000000 },
	{ .addr = 0x00f1014e64, .val = 0x00000000 },
	{ .addr = 0x00f1014e68, .val = 0x00000000 },
	{ .addr = 0x00f1014e6c, .val = 0x00000000 },
	{ .addr = 0x00f1014e70, .val = 0x00000000 },
	{ .addr = 0x00f1014e74, .val = 0x00000000 },
	{ .addr = 0x00f1014e78, .val = 0x00000000 },
	{ .addr = 0x00f1014e7c, .val = 0x00000000 },
	{ .addr = 0x00f1014e80, .val = 0x00000000 },
	{ .addr = 0x00f1014e84, .val = 0x00000000 },
	{ .addr = 0x00f1014e88, .val = 0x00000000 },
	{ .addr = 0x00f1014e8c, .val = 0x00000000 },
	{ .addr = 0x00f1014e90, .val = 0x00000000 },
	{ .addr = 0x00f1014e94, .val = 0x00000000 },
	{ .addr = 0x00f1014e98, .val = 0x00000000 },
	{ .addr = 0x00f1014e9c, .val = 0x00000000 },
	{ .addr = 0x00f1014ea0, .val = 0x00000000 },
	{ .addr = 0x00f1014ea4, .val = 0x00000000 },
	{ .addr = 0x00f1014ea8, .val = 0x00000000 },
	{ .addr = 0x00f1014eac, .val = 0x00000000 },
	{ .addr = 0x00f1014eb0, .val = 0x00000000 },
	{ .addr = 0x00f1014eb4, .val = 0x00000000 },
	{ .addr = 0x00f1014eb8, .val = 0x00000000 },
	{ .addr = 0x00f1014ebc, .val = 0x00000000 },
	{ .addr = 0x00f1014ec0, .val = 0x00000000 },
	{ .addr = 0x00f1014ec4, .val = 0x00000000 },
	{ .addr = 0x00f1014ec8, .val = 0x00000000 },
	{ .addr = 0x00f1014ecc, .val = 0x00000000 },
	{ .addr = 0x00f1014ed0, .val = 0x00000000 },
	{ .addr = 0x00f1014ed4, .val = 0x00000000 },
	{ .addr = 0x00f1014ed8, .val = 0x00000000 },
	{ .addr = 0x00f1014edc, .val = 0x00000000 },
	{ .addr = 0x00f1014ee0, .val = 0x00000000 },
	{ .addr = 0x00f1014ee4, .val = 0x00000000 },
	{ .addr = 0x00f1014ee8, .val = 0x00000000 },
	{ .addr = 0x00f1014eec, .val = 0x00000000 },
	{ .addr = 0x00f1014ef0, .val = 0x00000000 },
	{ .addr = 0x00f1014ef4, .val = 0x00000000 },
	{ .addr = 0x00f1014ef8, .val = 0x00000000 },
	{ .addr = 0x00f1014efc, .val = 0x00000000 },
	{ .addr = 0x00f1014f00, .val = 0x00000000 },
	{ .addr = 0x00f1014f04, .val = 0x00000000 },
	{ .addr = 0x00f1014f08, .val = 0x00000000 },
	{ .addr = 0x00f1014f0c, .val = 0x00000000 },
	{ .addr = 0x00f1014f10, .val = 0x00000000 },
	{ .addr = 0x00f1014f14, .val = 0x00000000 },
	{ .addr = 0x00f1014f18, .val = 0x00000000 },
	{ .addr = 0x00f1014f1c, .val = 0x00000000 },
	{ .addr = 0x00f1014f20, .val = 0x00000000 },
	{ .addr = 0x00f1014f24, .val = 0x00000000 },
	{ .addr = 0x00f1014f28, .val = 0x00000000 },
	{ .addr = 0x00f1014f2c, .val = 0x00000000 },
	{ .addr = 0x00f1014f30, .val = 0x00000000 },
	{ .addr = 0x00f1014f34, .val = 0x00000000 },
	{ .addr = 0x00f1014f38, .val = 0x00000000 },
	{ .addr = 0x00f1014f3c, .val = 0x00000000 },
	{ .addr = 0x00f1014f40, .val = 0x00000000 },
	{ .addr = 0x00f1014f44, .val = 0x00000000 },
	{ .addr = 0x00f1014f48, .val = 0x00000000 },
	{ .addr = 0x00f1014f4c, .val = 0x00000000 },
	{ .addr = 0x00f1014f50, .val = 0x00000000 },
	{ .addr = 0x00f1014f54, .val = 0x00000000 },
	{ .addr = 0x00f1014f58, .val = 0x00000000 },
	{ .addr = 0x00f1014f5c, .val = 0x00000000 },
	{ .addr = 0x00f1014f60, .val = 0x00000000 },
	{ .addr = 0x00f1014f64, .val = 0x00000000 },
	{ .addr = 0x00f1014f68, .val = 0x00000000 },
	{ .addr = 0x00f1014f6c, .val = 0x00000000 },
	{ .addr = 0x00f1014f70, .val = 0x00000000 },
	{ .addr = 0x00f1014f74, .val = 0x00000000 },
	{ .addr = 0x00f1014f78, .val = 0x00000000 },
	{ .addr = 0x00f1014f7c, .val = 0x00000000 },
	{ .addr = 0x00f1014f80, .val = 0x00000000 },
	{ .addr = 0x00f1014f84, .val = 0x00000000 },
	{ .addr = 0x00f1014f88, .val = 0x00000000 },
	{ .addr = 0x00f1014f8c, .val = 0x00000000 },
	{ .addr = 0x00f1014f90, .val = 0x00000000 },
	{ .addr = 0x00f1014f94, .val = 0x00000000 },
	{ .addr = 0x00f1014f98, .val = 0x00000000 },
	{ .addr = 0x00f1014f9c, .val = 0x00000000 },
	{ .addr = 0x00f1014fa0, .val = 0x00000000 },
	{ .addr = 0x00f1014fa4, .val = 0x00000000 },
	{ .addr = 0x00f1014fa8, .val = 0x00000000 },
	{ .addr = 0x00f1014fac, .val = 0x00000000 },
	{ .addr = 0x00f1014fb0, .val = 0x00000000 },
	{ .addr = 0x00f1014fb4, .val = 0x00000000 },
	{ .addr = 0x00f1014fb8, .val = 0x00000000 },
	{ .addr = 0x00f1014fbc, .val = 0x00000000 },
	{ .addr = 0x00f1014fc0, .val = 0x00000000 },
	{ .addr = 0x00f1014fc4, .val = 0x00000000 },
	{ .addr = 0x00f1014fc8, .val = 0x00000000 },
	{ .addr = 0x00f1014fcc, .val = 0x00000000 },
	{ .addr = 0x00f1014fd0, .val = 0x00000000 },
	{ .addr = 0x00f1014fd4, .val = 0x00000000 },
	{ .addr = 0x00f1014fd8, .val = 0x00000000 },
	{ .addr = 0x00f1014fdc, .val = 0x00000000 },
	{ .addr = 0x00f1014fe0, .val = 0x00000000 },
	{ .addr = 0x00f1014fe4, .val = 0x00000000 },
	{ .addr = 0x00f1014fe8, .val = 0x00000000 },
	{ .addr = 0x00f1014fec, .val = 0x00000000 },
	{ .addr = 0x00f1014ff0, .val = 0x00000000 },
	{ .addr = 0x00f1014ff4, .val = 0x00000000 },
	{ .addr = 0x00f1014ff8, .val = 0x00000000 },
	{ .addr = 0x00f1014ffc, .val = 0x00000000 },
	{ .addr = 0x00f1015000, .val = 0x00000000 },
	{ .addr = 0x00f1015004, .val = 0x00000000 },
	{ .addr = 0x00f1015008, .val = 0x00000000 },
	{ .addr = 0x00f101500c, .val = 0x00000000 },
	{ .addr = 0x00f1015010, .val = 0x00000000 },
	{ .addr = 0x00f1015014, .val = 0x00000000 },
	{ .addr = 0x00f1015018, .val = 0x00000000 },
	{ .addr = 0x00f101501c, .val = 0x00000000 },
	{ .addr = 0x00f1015020, .val = 0x00000000 },
	{ .addr = 0x00f1015024, .val = 0x00000000 },
	{ .addr = 0x00f1015028, .val = 0x00000000 },
	{ .addr = 0x00f101502c, .val = 0x00000000 },
	{ .addr = 0x00f1015030, .val = 0x00000000 },
	{ .addr = 0x00f1015034, .val = 0x00000000 },
	{ .addr = 0x00f1015038, .val = 0x00000000 },
	{ .addr = 0x00f101503c, .val = 0x00000000 },
	{ .addr = 0x00f1015040, .val = 0x00000000 },
	{ .addr = 0x00f1015044, .val = 0x00000000 },
	{ .addr = 0x00f1015048, .val = 0x00000000 },
	{ .addr = 0x00f101504c, .val = 0x00000000 },
	{ .addr = 0x00f1015050, .val = 0x00000000 },
	{ .addr = 0x00f1015054, .val = 0x00000000 },
	{ .addr = 0x00f1015058, .val = 0x00000000 },
	{ .addr = 0x00f101505c, .val = 0x00000000 },
	{ .addr = 0x00f1015060, .val = 0x00000000 },
	{ .addr = 0x00f1015064, .val = 0x00000000 },
	{ .addr = 0x00f1015068, .val = 0x00000000 },
	{ .addr = 0x00f101506c, .val = 0x00000000 },
	{ .addr = 0x00f1015070, .val = 0x00000000 },
	{ .addr = 0x00f1015074, .val = 0x00000000 },
	{ .addr = 0x00f1015078, .val = 0x00000000 },
	{ .addr = 0x00f101507c, .val = 0x00000000 },
	{ .addr = 0x00f1015080, .val = 0x00000000 },
	{ .addr = 0x00f1015084, .val = 0x00000000 },
	{ .addr = 0x00f1015088, .val = 0x00000000 },
	{ .addr = 0x00f101508c, .val = 0x00000000 },
	{ .addr = 0x00f1015090, .val = 0x00000000 },
	{ .addr = 0x00f1015094, .val = 0x00000000 },
	{ .addr = 0x00f1015098, .val = 0x00000000 },
	{ .addr = 0x00f101509c, .val = 0x00000000 },
	{ .addr = 0x00f10150a0, .val = 0x00000000 },
	{ .addr = 0x00f10150a4, .val = 0x00000000 },
	{ .addr = 0x00f10150a8, .val = 0x00000000 },
	{ .addr = 0x00f10150ac, .val = 0x00000000 },
	{ .addr = 0x00f10150b0, .val = 0x00000000 },
	{ .addr = 0x00f10150b4, .val = 0x00000000 },
	{ .addr = 0x00f10150b8, .val = 0x00000000 },
	{ .addr = 0x00f10150bc, .val = 0x00000000 },
	{ .addr = 0x00f10150c0, .val = 0x00000000 },
	{ .addr = 0x00f10150c4, .val = 0x00000000 },
	{ .addr = 0x00f10150c8, .val = 0x00000000 },
	{ .addr = 0x00f10150cc, .val = 0x00000000 },
	{ .addr = 0x00f10150d0, .val = 0x00000000 },
	{ .addr = 0x00f10150d4, .val = 0x00000000 },
	{ .addr = 0x00f10150d8, .val = 0x00000000 },
	{ .addr = 0x00f10150dc, .val = 0x00000000 },
	{ .addr = 0x00f10150e0, .val = 0x00000000 },
	{ .addr = 0x00f10150e4, .val = 0x00000000 },
	{ .addr = 0x00f10150e8, .val = 0x00000000 },
	{ .addr = 0x00f10150ec, .val = 0x00000000 },
	{ .addr = 0x00f10150f0, .val = 0x00000000 },
	{ .addr = 0x00f10150f4, .val = 0x00000000 },
	{ .addr = 0x00f10150f8, .val = 0x00000000 },
	{ .addr = 0x00f10150fc, .val = 0x00000000 },
	{ .addr = 0x00f1015100, .val = 0x00000000 },
	{ .addr = 0x00f1015104, .val = 0x00000000 },
	{ .addr = 0x00f1015108, .val = 0x00000000 },
	{ .addr = 0x00f101510c, .val = 0x00000000 },
	{ .addr = 0x00f1015110, .val = 0x00000000 },
	{ .addr = 0x00f1015114, .val = 0x00000000 },
	{ .addr = 0x00f1015118, .val = 0x00000000 },
	{ .addr = 0x00f101511c, .val = 0x00000000 },
	{ .addr = 0x00f1015120, .val = 0x00000000 },
	{ .addr = 0x00f1015124, .val = 0x00000000 },
	{ .addr = 0x00f1015128, .val = 0x00000000 },
	{ .addr = 0x00f101512c, .val = 0x00000000 },
	{ .addr = 0x00f1015130, .val = 0x00000000 },
	{ .addr = 0x00f1015134, .val = 0x00000000 },
	{ .addr = 0x00f1015138, .val = 0x00000000 },
	{ .addr = 0x00f101513c, .val = 0x00000000 },
	{ .addr = 0x00f1015140, .val = 0x00000000 },
	{ .addr = 0x00f1015144, .val = 0x00000000 },
	{ .addr = 0x00f1015148, .val = 0x00000000 },
	{ .addr = 0x00f101514c, .val = 0x00000000 },
	{ .addr = 0x00f1015150, .val = 0x00000000 },
	{ .addr = 0x00f1015154, .val = 0x00000000 },
	{ .addr = 0x00f1015158, .val = 0x00000000 },
	{ .addr = 0x00f101515c, .val = 0x00000000 },
	{ .addr = 0x00f1015160, .val = 0x00000000 },
	{ .addr = 0x00f1015164, .val = 0x00000000 },
	{ .addr = 0x00f1015168, .val = 0x00000000 },
	{ .addr = 0x00f101516c, .val = 0x00000000 },
	{ .addr = 0x00f1015170, .val = 0x00000000 },
	{ .addr = 0x00f1015174, .val = 0x00000000 },
	{ .addr = 0x00f1015178, .val = 0x00000000 },
	{ .addr = 0x00f101517c, .val = 0x00000000 },
	{ .addr = 0x00f1015180, .val = 0x00000000 },
	{ .addr = 0x00f1015184, .val = 0x00000000 },
	{ .addr = 0x00f1015188, .val = 0x00000000 },
	{ .addr = 0x00f101518c, .val = 0x00000000 },
	{ .addr = 0x00f1015190, .val = 0x00000000 },
	{ .addr = 0x00f1015194, .val = 0x00000000 },
	{ .addr = 0x00f1015198, .val = 0x00000000 },
	{ .addr = 0x00f101519c, .val = 0x00000000 },
	{ .addr = 0x00f10151a0, .val = 0x00000000 },
	{ .addr = 0x00f10151a4, .val = 0x00000000 },
	{ .addr = 0x00f10151a8, .val = 0x00000000 },
	{ .addr = 0x00f10151ac, .val = 0x00000000 },
	{ .addr = 0x00f10151b0, .val = 0x00000000 },
	{ .addr = 0x00f10151b4, .val = 0x00000000 },
	{ .addr = 0x00f10151b8, .val = 0x00000000 },
	{ .addr = 0x00f10151bc, .val = 0x00000000 },
	{ .addr = 0x00f10151c0, .val = 0x00000000 },
	{ .addr = 0x00f10151c4, .val = 0x00000000 },
	{ .addr = 0x00f10151c8, .val = 0x00000000 },
	{ .addr = 0x00f10151cc, .val = 0x00000000 },
	{ .addr = 0x00f10151d0, .val = 0x00000000 },
	{ .addr = 0x00f10151d4, .val = 0x00000000 },
	{ .addr = 0x00f10151d8, .val = 0x00000000 },
	{ .addr = 0x00f10151dc, .val = 0x00000000 },
	{ .addr = 0x00f10151e0, .val = 0x00000000 },
	{ .addr = 0x00f10151e4, .val = 0x00000000 },
	{ .addr = 0x00f10151e8, .val = 0x00000000 },
	{ .addr = 0x00f10151ec, .val = 0x00000000 },
	{ .addr = 0x00f10151f0, .val = 0x00000000 },
	{ .addr = 0x00f10151f4, .val = 0x00000000 },
	{ .addr = 0x00f10151f8, .val = 0x00000000 },
	{ .addr = 0x00f10151fc, .val = 0x00000000 },
	{ .addr = 0x00f1015200, .val = 0x00000000 },
	{ .addr = 0x00f1015204, .val = 0x00000000 },
	{ .addr = 0x00f1015208, .val = 0x00000000 },
	{ .addr = 0x00f101520c, .val = 0x00000000 },
	{ .addr = 0x00f1015210, .val = 0x00000000 },
	{ .addr = 0x00f1015214, .val = 0x00000000 },
	{ .addr = 0x00f1015218, .val = 0x00000000 },
	{ .addr = 0x00f101521c, .val = 0x00000000 },
	{ .addr = 0x00f1015220, .val = 0x00000000 },
	{ .addr = 0x00f1015224, .val = 0x00000000 },
	{ .addr = 0x00f1015228, .val = 0x00000000 },
	{ .addr = 0x00f101522c, .val = 0x00000000 },
	{ .addr = 0x00f1015230, .val = 0x00000000 },
	{ .addr = 0x00f1015234, .val = 0x00000000 },
	{ .addr = 0x00f1015238, .val = 0x00000000 },
	{ .addr = 0x00f101523c, .val = 0x00000000 },
	{ .addr = 0x00f1015240, .val = 0x00000000 },
	{ .addr = 0x00f1015244, .val = 0x00000000 },
	{ .addr = 0x00f1015248, .val = 0x00000000 },
	{ .addr = 0x00f101524c, .val = 0x00000000 },
	{ .addr = 0x00f1015250, .val = 0x00000000 },
	{ .addr = 0x00f1015254, .val = 0x00000000 },
	{ .addr = 0x00f1015258, .val = 0x00000000 },
	{ .addr = 0x00f101525c, .val = 0x00000000 },
	{ .addr = 0x00f1015260, .val = 0x00000000 },
	{ .addr = 0x00f1015264, .val = 0x00000000 },
	{ .addr = 0x00f1015268, .val = 0x00000000 },
	{ .addr = 0x00f101526c, .val = 0x00000000 },
	{ .addr = 0x00f1015270, .val = 0x00000000 },
	{ .addr = 0x00f1015274, .val = 0x00000000 },
	{ .addr = 0x00f1015278, .val = 0x00000000 },
	{ .addr = 0x00f101527c, .val = 0x00000000 },
	{ .addr = 0x00f1015280, .val = 0x00000000 },
	{ .addr = 0x00f1015284, .val = 0x00000000 },
	{ .addr = 0x00f1015288, .val = 0x00000000 },
	{ .addr = 0x00f101528c, .val = 0x00000000 },
	{ .addr = 0x00f1015290, .val = 0x00000000 },
	{ .addr = 0x00f1015294, .val = 0x00000000 },
	{ .addr = 0x00f1015298, .val = 0x00000000 },
	{ .addr = 0x00f101529c, .val = 0x00000000 },
	{ .addr = 0x00f10152a0, .val = 0x00000000 },
	{ .addr = 0x00f10152a4, .val = 0x00000000 },
	{ .addr = 0x00f10152a8, .val = 0x00000000 },
	{ .addr = 0x00f10152ac, .val = 0x00000000 },
	{ .addr = 0x00f10152b0, .val = 0x00000000 },
	{ .addr = 0x00f10152b4, .val = 0x00000000 },
	{ .addr = 0x00f10152b8, .val = 0x00000000 },
	{ .addr = 0x00f10152bc, .val = 0x00000000 },
	{ .addr = 0x00f10152c0, .val = 0x00000000 },
	{ .addr = 0x00f10152c4, .val = 0x00000000 },
	{ .addr = 0x00f10152c8, .val = 0x00000000 },
	{ .addr = 0x00f10152cc, .val = 0x00000000 },
	{ .addr = 0x00f10152d0, .val = 0x00000000 },
	{ .addr = 0x00f10152d4, .val = 0x00000000 },
	{ .addr = 0x00f10152d8, .val = 0x00000000 },
	{ .addr = 0x00f10152dc, .val = 0x00000000 },
	{ .addr = 0x00f10152e0, .val = 0x00000000 },
	{ .addr = 0x00f10152e4, .val = 0x00000000 },
	{ .addr = 0x00f10152e8, .val = 0x00000000 },
	{ .addr = 0x00f10152ec, .val = 0x00000000 },
	{ .addr = 0x00f10152f0, .val = 0x00000000 },
	{ .addr = 0x00f10152f4, .val = 0x00000000 },
	{ .addr = 0x00f10152f8, .val = 0x00000000 },
	{ .addr = 0x00f10152fc, .val = 0x00000000 },
	{ .addr = 0x00f1015300, .val = 0x00000000 },
	{ .addr = 0x00f1015304, .val = 0x00000000 },
	{ .addr = 0x00f1015308, .val = 0x00000000 },
	{ .addr = 0x00f101530c, .val = 0x00000000 },
	{ .addr = 0x00f1015310, .val = 0x00000000 },
	{ .addr = 0x00f1015314, .val = 0x00000000 },
	{ .addr = 0x00f1015318, .val = 0x00000000 },
	{ .addr = 0x00f101531c, .val = 0x00000000 },
	{ .addr = 0x00f1015320, .val = 0x00000000 },
	{ .addr = 0x00f1015324, .val = 0x00000000 },
	{ .addr = 0x00f1015328, .val = 0x00000000 },
	{ .addr = 0x00f101532c, .val = 0x00000000 },
	{ .addr = 0x00f1015330, .val = 0x00000000 },
	{ .addr = 0x00f1015334, .val = 0x00000000 },
	{ .addr = 0x00f1015338, .val = 0x00000000 },
	{ .addr = 0x00f101533c, .val = 0x00000000 },
	{ .addr = 0x00f1015340, .val = 0x00000000 },
	{ .addr = 0x00f1015344, .val = 0x00000000 },
	{ .addr = 0x00f1015348, .val = 0x00000000 },
	{ .addr = 0x00f101534c, .val = 0x00000000 },
	{ .addr = 0x00f1015350, .val = 0x00000000 },
	{ .addr = 0x00f1015354, .val = 0x00000000 },
	{ .addr = 0x00f1015358, .val = 0x00000000 },
	{ .addr = 0x00f101535c, .val = 0x00000000 },
	{ .addr = 0x00f1015360, .val = 0x00000000 },
	{ .addr = 0x00f1015364, .val = 0x00000000 },
	{ .addr = 0x00f1015368, .val = 0x00000000 },
	{ .addr = 0x00f101536c, .val = 0x00000000 },
	{ .addr = 0x00f1015370, .val = 0x00000000 },
	{ .addr = 0x00f1015374, .val = 0x00000000 },
	{ .addr = 0x00f1015378, .val = 0x00000000 },
	{ .addr = 0x00f101537c, .val = 0x00000000 },
	{ .addr = 0x00f1015380, .val = 0x00000000 },
	{ .addr = 0x00f1015384, .val = 0x00000000 },
	{ .addr = 0x00f1015388, .val = 0x00000000 },
	{ .addr = 0x00f101538c, .val = 0x00000000 },
	{ .addr = 0x00f1015390, .val = 0x00000000 },
	{ .addr = 0x00f1015394, .val = 0x00000000 },
	{ .addr = 0x00f1015398, .val = 0x00000000 },
	{ .addr = 0x00f101539c, .val = 0x00000000 },
	{ .addr = 0x00f10153a0, .val = 0x00000000 },
	{ .addr = 0x00f10153a4, .val = 0x00000000 },
	{ .addr = 0x00f10153a8, .val = 0x00000000 },
	{ .addr = 0x00f10153ac, .val = 0x00000000 },
	{ .addr = 0x00f10153b0, .val = 0x00000000 },
	{ .addr = 0x00f10153b4, .val = 0x00000000 },
	{ .addr = 0x00f10153b8, .val = 0x00000000 },
	{ .addr = 0x00f10153bc, .val = 0x00000000 },
	{ .addr = 0x00f10153c0, .val = 0x00000000 },
	{ .addr = 0x00f10153c4, .val = 0x00000000 },
	{ .addr = 0x00f10153c8, .val = 0x00000000 },
	{ .addr = 0x00f10153cc, .val = 0x00000000 },
	{ .addr = 0x00f10153d0, .val = 0x00000000 },
	{ .addr = 0x00f10153d4, .val = 0x00000000 },
	{ .addr = 0x00f10153d8, .val = 0x00000000 },
	{ .addr = 0x00f10153dc, .val = 0x00000000 },
	{ .addr = 0x00f10153e0, .val = 0x00000000 },
	{ .addr = 0x00f10153e4, .val = 0x00000000 },
	{ .addr = 0x00f10153e8, .val = 0x00000000 },
	{ .addr = 0x00f10153ec, .val = 0x00000000 },
	{ .addr = 0x00f10153f0, .val = 0x00000000 },
	{ .addr = 0x00f10153f4, .val = 0x00000000 },
	{ .addr = 0x00f10153f8, .val = 0x00000000 },
	{ .addr = 0x00f10153fc, .val = 0x00000000 },
	{ .addr = 0x00f1015400, .val = 0x00000000 },
	{ .addr = 0x00f1015404, .val = 0x00000000 },
	{ .addr = 0x00f1015408, .val = 0x00000000 },
	{ .addr = 0x00f101540c, .val = 0x00000000 },
	{ .addr = 0x00f1015410, .val = 0x00000000 },
	{ .addr = 0x00f1015414, .val = 0x00000000 },
	{ .addr = 0x00f1015418, .val = 0x00000000 },
	{ .addr = 0x00f101541c, .val = 0x00000000 },
	{ .addr = 0x00f1015420, .val = 0x00000000 },
	{ .addr = 0x00f1015424, .val = 0x00000000 },
	{ .addr = 0x00f1015428, .val = 0x00000000 },
	{ .addr = 0x00f101542c, .val = 0x00000000 },
	{ .addr = 0x00f1015430, .val = 0x00000000 },
	{ .addr = 0x00f1015434, .val = 0x00000000 },
	{ .addr = 0x00f1015438, .val = 0x00000000 },
	{ .addr = 0x00f101543c, .val = 0x00000000 },
	{ .addr = 0x00f1015440, .val = 0x00000000 },
	{ .addr = 0x00f1015444, .val = 0x00000000 },
	{ .addr = 0x00f1015448, .val = 0x00000000 },
	{ .addr = 0x00f101544c, .val = 0x00000000 },
	{ .addr = 0x00f1015450, .val = 0x00000000 },
	{ .addr = 0x00f1015454, .val = 0x00000000 },
	{ .addr = 0x00f1015458, .val = 0x00000000 },
	{ .addr = 0x00f101545c, .val = 0x00000000 },
	{ .addr = 0x00f1015460, .val = 0x00000000 },
	{ .addr = 0x00f1015464, .val = 0x00000000 },
	{ .addr = 0x00f1015468, .val = 0x00000000 },
	{ .addr = 0x00f101546c, .val = 0x00000000 },
	{ .addr = 0x00f1015470, .val = 0x00000000 },
	{ .addr = 0x00f1015474, .val = 0x00000000 },
	{ .addr = 0x00f1015478, .val = 0x00000000 },
	{ .addr = 0x00f101547c, .val = 0x00000000 },
	{ .addr = 0x00f1015480, .val = 0x00000000 },
	{ .addr = 0x00f1015484, .val = 0x00000000 },
	{ .addr = 0x00f1015488, .val = 0x00000000 },
	{ .addr = 0x00f101548c, .val = 0x00000000 },
	{ .addr = 0x00f1015490, .val = 0x00000000 },
	{ .addr = 0x00f1015494, .val = 0x00000000 },
	{ .addr = 0x00f1015498, .val = 0x00000000 },
	{ .addr = 0x00f101549c, .val = 0x00000000 },
	{ .addr = 0x00f10154a0, .val = 0x00000000 },
	{ .addr = 0x00f10154a4, .val = 0x00000000 },
	{ .addr = 0x00f10154a8, .val = 0x00000000 },
	{ .addr = 0x00f10154ac, .val = 0x00000000 },
	{ .addr = 0x00f10154b0, .val = 0x00000000 },
	{ .addr = 0x00f10154b4, .val = 0x00000000 },
	{ .addr = 0x00f10154b8, .val = 0x00000000 },
	{ .addr = 0x00f10154bc, .val = 0x00000000 },
	{ .addr = 0x00f10154c0, .val = 0x00000000 },
	{ .addr = 0x00f10154c4, .val = 0x00000000 },
	{ .addr = 0x00f10154c8, .val = 0x00000000 },
	{ .addr = 0x00f10154cc, .val = 0x00000000 },
	{ .addr = 0x00f10154d0, .val = 0x00000000 },
	{ .addr = 0x00f10154d4, .val = 0x00000000 },
	{ .addr = 0x00f10154d8, .val = 0x00000000 },
	{ .addr = 0x00f10154dc, .val = 0x00000000 },
	{ .addr = 0x00f10154e0, .val = 0x00000000 },
	{ .addr = 0x00f10154e4, .val = 0x00000000 },
	{ .addr = 0x00f10154e8, .val = 0x00000000 },
	{ .addr = 0x00f10154ec, .val = 0x00000000 },
	{ .addr = 0x00f10154f0, .val = 0x00000000 },
	{ .addr = 0x00f10154f4, .val = 0x00000000 },
	{ .addr = 0x00f10154f8, .val = 0x00000000 },
	{ .addr = 0x00f10154fc, .val = 0x00000000 },
	{ .addr = 0x00f1015500, .val = 0x00000000 },
	{ .addr = 0x00f1015504, .val = 0x00000000 },
	{ .addr = 0x00f1015508, .val = 0x00000000 },
	{ .addr = 0x00f101550c, .val = 0x00000000 },
	{ .addr = 0x00f1015510, .val = 0x00000000 },
	{ .addr = 0x00f1015514, .val = 0x00000000 },
	{ .addr = 0x00f1015518, .val = 0x00000000 },
	{ .addr = 0x00f101551c, .val = 0x00000000 },
	{ .addr = 0x00f1015520, .val = 0x00000000 },
	{ .addr = 0x00f1015524, .val = 0x00000000 },
	{ .addr = 0x00f1015528, .val = 0x00000000 },
	{ .addr = 0x00f101552c, .val = 0x00000000 },
	{ .addr = 0x00f1015530, .val = 0x00000000 },
	{ .addr = 0x00f1015534, .val = 0x00000000 },
	{ .addr = 0x00f1015538, .val = 0x00000000 },
	{ .addr = 0x00f101553c, .val = 0x00000000 },
	{ .addr = 0x00f1015540, .val = 0x00000000 },
	{ .addr = 0x00f1015544, .val = 0x00000000 },
	{ .addr = 0x00f1015548, .val = 0x00000000 },
	{ .addr = 0x00f101554c, .val = 0x00000000 },
	{ .addr = 0x00f1015550, .val = 0x00000000 },
	{ .addr = 0x00f1015554, .val = 0x00000000 },
	{ .addr = 0x00f1015558, .val = 0x00000000 },
	{ .addr = 0x00f101555c, .val = 0x00000000 },
	{ .addr = 0x00f1015560, .val = 0x00000000 },
	{ .addr = 0x00f1015564, .val = 0x00000000 },
	{ .addr = 0x00f1015568, .val = 0x00000000 },
	{ .addr = 0x00f101556c, .val = 0x00000000 },
	{ .addr = 0x00f1015570, .val = 0x00000000 },
	{ .addr = 0x00f1015574, .val = 0x00000000 },
	{ .addr = 0x00f1015578, .val = 0x00000000 },
	{ .addr = 0x00f101557c, .val = 0x00000000 },
	{ .addr = 0x00f1015580, .val = 0x00000000 },
	{ .addr = 0x00f1015584, .val = 0x00000000 },
	{ .addr = 0x00f1015588, .val = 0x00000000 },
	{ .addr = 0x00f101558c, .val = 0x00000000 },
	{ .addr = 0x00f1015590, .val = 0x00000000 },
	{ .addr = 0x00f1015594, .val = 0x00000000 },
	{ .addr = 0x00f1015598, .val = 0x00000000 },
	{ .addr = 0x00f101559c, .val = 0x00000000 },
	{ .addr = 0x00f10155a0, .val = 0x00000000 },
	{ .addr = 0x00f10155a4, .val = 0x00000000 },
	{ .addr = 0x00f10155a8, .val = 0x00000000 },
	{ .addr = 0x00f10155ac, .val = 0x00000000 },
	{ .addr = 0x00f10155b0, .val = 0x00000000 },
	{ .addr = 0x00f10155b4, .val = 0x00000000 },
	{ .addr = 0x00f10155b8, .val = 0x00000000 },
	{ .addr = 0x00f10155bc, .val = 0x00000000 },
	{ .addr = 0x00f10155c0, .val = 0x00000000 },
	{ .addr = 0x00f10155c4, .val = 0x00000000 },
	{ .addr = 0x00f10155c8, .val = 0x00000000 },
	{ .addr = 0x00f10155cc, .val = 0x00000000 },
	{ .addr = 0x00f10155d0, .val = 0x00000000 },
	{ .addr = 0x00f10155d4, .val = 0x00000000 },
	{ .addr = 0x00f10155d8, .val = 0x00000000 },
	{ .addr = 0x00f10155dc, .val = 0x00000000 },
	{ .addr = 0x00f10155e0, .val = 0x00000000 },
	{ .addr = 0x00f10155e4, .val = 0x00000000 },
	{ .addr = 0x00f10155e8, .val = 0x00000000 },
	{ .addr = 0x00f10155ec, .val = 0x00000000 },
	{ .addr = 0x00f10155f0, .val = 0x00000000 },
	{ .addr = 0x00f10155f4, .val = 0x00000000 },
	{ .addr = 0x00f10155f8, .val = 0x00000000 },
	{ .addr = 0x00f10155fc, .val = 0x00000000 },
	{ .addr = 0x00f1015600, .val = 0x00000000 },
	{ .addr = 0x00f1015604, .val = 0x00000000 },
	{ .addr = 0x00f1015608, .val = 0x00000000 },
	{ .addr = 0x00f101560c, .val = 0x00000000 },
	{ .addr = 0x00f1015610, .val = 0x00000000 },
	{ .addr = 0x00f1015614, .val = 0x00000000 },
	{ .addr = 0x00f1015618, .val = 0x00000000 },
	{ .addr = 0x00f101561c, .val = 0x00000000 },
	{ .addr = 0x00f1015620, .val = 0x00000000 },
	{ .addr = 0x00f1015624, .val = 0x00000000 },
	{ .addr = 0x00f1015628, .val = 0x00000000 },
	{ .addr = 0x00f101562c, .val = 0x00000000 },
	{ .addr = 0x00f1015630, .val = 0x00000000 },
	{ .addr = 0x00f1015634, .val = 0x00000000 },
	{ .addr = 0x00f1015638, .val = 0x00000000 },
	{ .addr = 0x00f101563c, .val = 0x00000000 },
	{ .addr = 0x00f1015640, .val = 0x00000000 },
	{ .addr = 0x00f1015644, .val = 0x00000000 },
	{ .addr = 0x00f1015648, .val = 0x00000000 },
	{ .addr = 0x00f101564c, .val = 0x00000000 },
	{ .addr = 0x00f1015650, .val = 0x00000000 },
	{ .addr = 0x00f1015654, .val = 0x00000000 },
	{ .addr = 0x00f1015658, .val = 0x00000000 },
	{ .addr = 0x00f101565c, .val = 0x00000000 },
	{ .addr = 0x00f1015660, .val = 0x00000000 },
	{ .addr = 0x00f1015664, .val = 0x00000000 },
	{ .addr = 0x00f1015668, .val = 0x00000000 },
	{ .addr = 0x00f101566c, .val = 0x00000000 },
	{ .addr = 0x00f1015670, .val = 0x00000000 },
	{ .addr = 0x00f1015674, .val = 0x00000000 },
	{ .addr = 0x00f1015678, .val = 0x00000000 },
	{ .addr = 0x00f101567c, .val = 0x00000000 },
	{ .addr = 0x00f1015680, .val = 0x00000000 },
	{ .addr = 0x00f1015684, .val = 0x00000000 },
	{ .addr = 0x00f1015688, .val = 0x00000000 },
	{ .addr = 0x00f101568c, .val = 0x00000000 },
	{ .addr = 0x00f1015690, .val = 0x00000000 },
	{ .addr = 0x00f1015694, .val = 0x00000000 },
	{ .addr = 0x00f1015698, .val = 0x00000000 },
	{ .addr = 0x00f101569c, .val = 0x00000000 },
	{ .addr = 0x00f10156a0, .val = 0x00000000 },
	{ .addr = 0x00f10156a4, .val = 0x00000000 },
	{ .addr = 0x00f10156a8, .val = 0x00000000 },
	{ .addr = 0x00f10156ac, .val = 0x00000000 },
	{ .addr = 0x00f10156b0, .val = 0x00000000 },
	{ .addr = 0x00f10156b4, .val = 0x00000000 },
	{ .addr = 0x00f10156b8, .val = 0x00000000 },
	{ .addr = 0x00f10156bc, .val = 0x00000000 },
	{ .addr = 0x00f10156c0, .val = 0x00000000 },
	{ .addr = 0x00f10156c4, .val = 0x00000000 },
	{ .addr = 0x00f10156c8, .val = 0x00000000 },
	{ .addr = 0x00f10156cc, .val = 0x00000000 },
	{ .addr = 0x00f10156d0, .val = 0x00000000 },
	{ .addr = 0x00f10156d4, .val = 0x00000000 },
	{ .addr = 0x00f10156d8, .val = 0x00000000 },
	{ .addr = 0x00f10156dc, .val = 0x00000000 },
	{ .addr = 0x00f10156e0, .val = 0x00000000 },
	{ .addr = 0x00f10156e4, .val = 0x00000000 },
	{ .addr = 0x00f10156e8, .val = 0x00000000 },
	{ .addr = 0x00f10156ec, .val = 0x00000000 },
	{ .addr = 0x00f10156f0, .val = 0x00000000 },
	{ .addr = 0x00f10156f4, .val = 0x00000000 },
	{ .addr = 0x00f10156f8, .val = 0x00000000 },
	{ .addr = 0x00f10156fc, .val = 0x00000000 },
	{ .addr = 0x00f1015700, .val = 0x00000000 },
	{ .addr = 0x00f1015704, .val = 0x00000000 },
	{ .addr = 0x00f1015708, .val = 0x00000000 },
	{ .addr = 0x00f101570c, .val = 0x00000000 },
	{ .addr = 0x00f1015710, .val = 0x00000000 },
	{ .addr = 0x00f1015714, .val = 0x00000000 },
	{ .addr = 0x00f1015718, .val = 0x00000000 },
	{ .addr = 0x00f101571c, .val = 0x00000000 },
	{ .addr = 0x00f1015720, .val = 0x00000000 },
	{ .addr = 0x00f1015724, .val = 0x00000000 },
	{ .addr = 0x00f1015728, .val = 0x00000000 },
	{ .addr = 0x00f101572c, .val = 0x00000000 },
	{ .addr = 0x00f1015730, .val = 0x00000000 },
	{ .addr = 0x00f1015734, .val = 0x00000000 },
	{ .addr = 0x00f1015738, .val = 0x00000000 },
	{ .addr = 0x00f101573c, .val = 0x00000000 },
	{ .addr = 0x00f1015740, .val = 0x00000000 },
	{ .addr = 0x00f1015744, .val = 0x00000000 },
	{ .addr = 0x00f1015748, .val = 0x00000000 },
	{ .addr = 0x00f101574c, .val = 0x00000000 },
	{ .addr = 0x00f1015750, .val = 0x00000000 },
	{ .addr = 0x00f1015754, .val = 0x00000000 },
	{ .addr = 0x00f1015758, .val = 0x00000000 },
	{ .addr = 0x00f101575c, .val = 0x00000000 },
	{ .addr = 0x00f1015760, .val = 0x00000000 },
	{ .addr = 0x00f1015764, .val = 0x00000000 },
	{ .addr = 0x00f1015768, .val = 0x00000000 },
	{ .addr = 0x00f101576c, .val = 0x00000000 },
	{ .addr = 0x00f1015770, .val = 0x00000000 },
	{ .addr = 0x00f1015774, .val = 0x00000000 },
	{ .addr = 0x00f1015778, .val = 0x00000000 },
	{ .addr = 0x00f101577c, .val = 0x00000000 },
	{ .addr = 0x00f1015780, .val = 0x00000000 },
	{ .addr = 0x00f1015784, .val = 0x00000000 },
	{ .addr = 0x00f1015788, .val = 0x00000000 },
	{ .addr = 0x00f101578c, .val = 0x00000000 },
	{ .addr = 0x00f1015790, .val = 0x00000000 },
	{ .addr = 0x00f1015794, .val = 0x00000000 },
	{ .addr = 0x00f1015798, .val = 0x00000000 },
	{ .addr = 0x00f101579c, .val = 0x00000000 },
	{ .addr = 0x00f10157a0, .val = 0x00000000 },
	{ .addr = 0x00f10157a4, .val = 0x00000000 },
	{ .addr = 0x00f10157a8, .val = 0x00000000 },
	{ .addr = 0x00f10157ac, .val = 0x00000000 },
	{ .addr = 0x00f10157b0, .val = 0x00000000 },
	{ .addr = 0x00f10157b4, .val = 0x00000000 },
	{ .addr = 0x00f10157b8, .val = 0x00000000 },
	{ .addr = 0x00f10157bc, .val = 0x00000000 },
	{ .addr = 0x00f10157c0, .val = 0x00000000 },
	{ .addr = 0x00f10157c4, .val = 0x00000000 },
	{ .addr = 0x00f10157c8, .val = 0x00000000 },
	{ .addr = 0x00f10157cc, .val = 0x00000000 },
	{ .addr = 0x00f10157d0, .val = 0x00000000 },
	{ .addr = 0x00f10157d4, .val = 0x00000000 },
	{ .addr = 0x00f10157d8, .val = 0x00000000 },
	{ .addr = 0x00f10157dc, .val = 0x00000000 },
	{ .addr = 0x00f10157e0, .val = 0x00000000 },
	{ .addr = 0x00f10157e4, .val = 0x00000000 },
	{ .addr = 0x00f10157e8, .val = 0x00000000 },
	{ .addr = 0x00f10157ec, .val = 0x00000000 },
	{ .addr = 0x00f10157f0, .val = 0x00000000 },
	{ .addr = 0x00f10157f4, .val = 0x00000000 },
	{ .addr = 0x00f10157f8, .val = 0x00000000 },
	{ .addr = 0x00f10157fc, .val = 0x00000000 },
	{ .addr = 0x00f1015800, .val = 0x00000000 },
	{ .addr = 0x00f1015804, .val = 0x00000000 },
	{ .addr = 0x00f1015808, .val = 0x00000000 },
	{ .addr = 0x00f101580c, .val = 0x00000000 },
	{ .addr = 0x00f1015810, .val = 0x00000000 },
	{ .addr = 0x00f1015814, .val = 0x00000000 },
	{ .addr = 0x00f1015818, .val = 0x00000000 },
	{ .addr = 0x00f101581c, .val = 0x00000000 },
	{ .addr = 0x00f1015820, .val = 0x00000000 },
	{ .addr = 0x00f1015824, .val = 0x00000000 },
	{ .addr = 0x00f1015828, .val = 0x00000000 },
	{ .addr = 0x00f101582c, .val = 0x00000000 },
	{ .addr = 0x00f1015830, .val = 0x00000000 },
	{ .addr = 0x00f1015834, .val = 0x00000000 },
	{ .addr = 0x00f1015838, .val = 0x00000000 },
	{ .addr = 0x00f101583c, .val = 0x00000000 },
	{ .addr = 0x00f1015840, .val = 0x00000000 },
	{ .addr = 0x00f1015844, .val = 0x00000000 },
	{ .addr = 0x00f1015848, .val = 0x00000000 },
	{ .addr = 0x00f101584c, .val = 0x00000000 },
	{ .addr = 0x00f1015850, .val = 0x00000000 },
	{ .addr = 0x00f1015854, .val = 0x00000000 },
	{ .addr = 0x00f1015858, .val = 0x00000000 },
	{ .addr = 0x00f101585c, .val = 0x00000000 },
	{ .addr = 0x00f1015860, .val = 0x00000000 },
	{ .addr = 0x00f1015864, .val = 0x00000000 },
	{ .addr = 0x00f1015868, .val = 0x00000000 },
	{ .addr = 0x00f101586c, .val = 0x00000000 },
	{ .addr = 0x00f1015870, .val = 0x00000000 },
	{ .addr = 0x00f1015874, .val = 0x00000000 },
	{ .addr = 0x00f1015878, .val = 0x00000000 },
	{ .addr = 0x00f101587c, .val = 0x00000000 },
	{ .addr = 0x00f1015880, .val = 0x00000000 },
	{ .addr = 0x00f1015884, .val = 0x00000000 },
	{ .addr = 0x00f1015888, .val = 0x00000000 },
	{ .addr = 0x00f101588c, .val = 0x00000000 },
	{ .addr = 0x00f1015890, .val = 0x00000000 },
	{ .addr = 0x00f1015894, .val = 0x00000000 },
	{ .addr = 0x00f1015898, .val = 0x00000000 },
	{ .addr = 0x00f101589c, .val = 0x00000000 },
	{ .addr = 0x00f10158a0, .val = 0x00000000 },
	{ .addr = 0x00f10158a4, .val = 0x00000000 },
	{ .addr = 0x00f10158a8, .val = 0x00000000 },
	{ .addr = 0x00f10158ac, .val = 0x00000000 },
	{ .addr = 0x00f10158b0, .val = 0x00000000 },
	{ .addr = 0x00f10158b4, .val = 0x00000000 },
	{ .addr = 0x00f10158b8, .val = 0x00000000 },
	{ .addr = 0x00f10158bc, .val = 0x00000000 },
	{ .addr = 0x00f10158c0, .val = 0x00000000 },
	{ .addr = 0x00f10158c4, .val = 0x00000000 },
	{ .addr = 0x00f10158c8, .val = 0x00000000 },
	{ .addr = 0x00f10158cc, .val = 0x00000000 },
	{ .addr = 0x00f10158d0, .val = 0x00000000 },
	{ .addr = 0x00f10158d4, .val = 0x00000000 },
	{ .addr = 0x00f10158d8, .val = 0x00000000 },
	{ .addr = 0x00f10158dc, .val = 0x00000000 },
	{ .addr = 0x00f10158e0, .val = 0x00000000 },
	{ .addr = 0x00f10158e4, .val = 0x00000000 },
	{ .addr = 0x00f10158e8, .val = 0x00000000 },
	{ .addr = 0x00f10158ec, .val = 0x00000000 },
	{ .addr = 0x00f10158f0, .val = 0x00000000 },
	{ .addr = 0x00f10158f4, .val = 0x00000000 },
	{ .addr = 0x00f10158f8, .val = 0x00000000 },
	{ .addr = 0x00f10158fc, .val = 0x00000000 },
	{ .addr = 0x00f1015900, .val = 0x00000000 },
	{ .addr = 0x00f1015904, .val = 0x00000000 },
	{ .addr = 0x00f1015908, .val = 0x00000000 },
	{ .addr = 0x00f101590c, .val = 0x00000000 },
	{ .addr = 0x00f1015910, .val = 0x00000000 },
	{ .addr = 0x00f1015914, .val = 0x00000000 },
	{ .addr = 0x00f1015918, .val = 0x00000000 },
	{ .addr = 0x00f101591c, .val = 0x00000000 },
	{ .addr = 0x00f1015920, .val = 0x00000000 },
	{ .addr = 0x00f1015924, .val = 0x00000000 },
	{ .addr = 0x00f1015928, .val = 0x00000000 },
	{ .addr = 0x00f101592c, .val = 0x00000000 },
	{ .addr = 0x00f1015930, .val = 0x00000000 },
	{ .addr = 0x00f1015934, .val = 0x00000000 },
	{ .addr = 0x00f1015938, .val = 0x00000000 },
	{ .addr = 0x00f101593c, .val = 0x00000000 },
	{ .addr = 0x00f1015940, .val = 0x00000000 },
	{ .addr = 0x00f1015944, .val = 0x00000000 },
	{ .addr = 0x00f1015948, .val = 0x00000000 },
	{ .addr = 0x00f101594c, .val = 0x00000000 },
	{ .addr = 0x00f1015950, .val = 0x00000000 },
	{ .addr = 0x00f1015954, .val = 0x00000000 },
	{ .addr = 0x00f1015958, .val = 0x00000000 },
	{ .addr = 0x00f101595c, .val = 0x00000000 },
	{ .addr = 0x00f1015960, .val = 0x00000000 },
	{ .addr = 0x00f1015964, .val = 0x00000000 },
	{ .addr = 0x00f1015968, .val = 0x00000000 },
	{ .addr = 0x00f101596c, .val = 0x00000000 },
	{ .addr = 0x00f1015970, .val = 0x00000000 },
	{ .addr = 0x00f1015974, .val = 0x00000000 },
	{ .addr = 0x00f1015978, .val = 0x00000000 },
	{ .addr = 0x00f101597c, .val = 0x00000000 },
	{ .addr = 0x00f1015980, .val = 0x00000000 },
	{ .addr = 0x00f1015984, .val = 0x00000000 },
	{ .addr = 0x00f1015988, .val = 0x00000000 },
	{ .addr = 0x00f101598c, .val = 0x00000000 },
	{ .addr = 0x00f1015990, .val = 0x00000000 },
	{ .addr = 0x00f1015994, .val = 0x00000000 },
	{ .addr = 0x00f1015998, .val = 0x00000000 },
	{ .addr = 0x00f101599c, .val = 0x00000000 },
	{ .addr = 0x00f10159a0, .val = 0x00000000 },
	{ .addr = 0x00f10159a4, .val = 0x00000000 },
	{ .addr = 0x00f10159a8, .val = 0x00000000 },
	{ .addr = 0x00f10159ac, .val = 0x00000000 },
	{ .addr = 0x00f10159b0, .val = 0x00000000 },
	{ .addr = 0x00f10159b4, .val = 0x00000000 },
	{ .addr = 0x00f10159b8, .val = 0x00000000 },
	{ .addr = 0x00f10159bc, .val = 0x00000000 },
	{ .addr = 0x00f10159c0, .val = 0x00000000 },
	{ .addr = 0x00f10159c4, .val = 0x00000000 },
	{ .addr = 0x00f10159c8, .val = 0x00000000 },
	{ .addr = 0x00f10159cc, .val = 0x00000000 },
	{ .addr = 0x00f10159d0, .val = 0x00000000 },
	{ .addr = 0x00f10159d4, .val = 0x00000000 },
	{ .addr = 0x00f10159d8, .val = 0x00000000 },
	{ .addr = 0x00f10159dc, .val = 0x00000000 },
	{ .addr = 0x00f10159e0, .val = 0x00000000 },
	{ .addr = 0x00f10159e4, .val = 0x00000000 },
	{ .addr = 0x00f10159e8, .val = 0x00000000 },
	{ .addr = 0x00f10159ec, .val = 0x00000000 },
	{ .addr = 0x00f10159f0, .val = 0x00000000 },
	{ .addr = 0x00f10159f4, .val = 0x00000000 },
	{ .addr = 0x00f10159f8, .val = 0x00000000 },
	{ .addr = 0x00f10159fc, .val = 0x00000000 },
	{ .addr = 0x00f1015a00, .val = 0x00000000 },
	{ .addr = 0x00f1015a04, .val = 0x00000000 },
	{ .addr = 0x00f1015a08, .val = 0x00000000 },
	{ .addr = 0x00f1015a0c, .val = 0x00000000 },
	{ .addr = 0x00f1015a10, .val = 0x00000000 },
	{ .addr = 0x00f1015a14, .val = 0x00000000 },
	{ .addr = 0x00f1015a18, .val = 0x00000000 },
	{ .addr = 0x00f1015a1c, .val = 0x00000000 },
	{ .addr = 0x00f1015a20, .val = 0x00000000 },
	{ .addr = 0x00f1015a24, .val = 0x00000000 },
	{ .addr = 0x00f1015a28, .val = 0x00000000 },
	{ .addr = 0x00f1015a2c, .val = 0x00000000 },
	{ .addr = 0x00f1015a30, .val = 0x00000000 },
	{ .addr = 0x00f1015a34, .val = 0x00000000 },
	{ .addr = 0x00f1015a38, .val = 0x00000000 },
	{ .addr = 0x00f1015a3c, .val = 0x00000000 },
	{ .addr = 0x00f1015a40, .val = 0x00000000 },
	{ .addr = 0x00f1015a44, .val = 0x00000000 },
	{ .addr = 0x00f1015a48, .val = 0x00000000 },
	{ .addr = 0x00f1015a4c, .val = 0x00000000 },
	{ .addr = 0x00f1015a50, .val = 0x00000000 },
	{ .addr = 0x00f1015a54, .val = 0x00000000 },
	{ .addr = 0x00f1015a58, .val = 0x00000000 },
	{ .addr = 0x00f1015a5c, .val = 0x00000000 },
	{ .addr = 0x00f1015a60, .val = 0x00000000 },
	{ .addr = 0x00f1015a64, .val = 0x00000000 },
	{ .addr = 0x00f1015a68, .val = 0x00000000 },
	{ .addr = 0x00f1015a6c, .val = 0x00000000 },
	{ .addr = 0x00f1015a70, .val = 0x00000000 },
	{ .addr = 0x00f1015a74, .val = 0x00000000 },
	{ .addr = 0x00f1015a78, .val = 0x00000000 },
	{ .addr = 0x00f1015a7c, .val = 0x00000000 },
	{ .addr = 0x00f1015a80, .val = 0x00000000 },
	{ .addr = 0x00f1015a84, .val = 0x00000000 },
	{ .addr = 0x00f1015a88, .val = 0x00000000 },
	{ .addr = 0x00f1015a8c, .val = 0x00000000 },
	{ .addr = 0x00f1015a90, .val = 0x00000000 },
	{ .addr = 0x00f1015a94, .val = 0x00000000 },
	{ .addr = 0x00f1015a98, .val = 0x00000000 },
	{ .addr = 0x00f1015a9c, .val = 0x00000000 },
	{ .addr = 0x00f1015aa0, .val = 0x00000000 },
	{ .addr = 0x00f1015aa4, .val = 0x00000000 },
	{ .addr = 0x00f1015aa8, .val = 0x00000000 },
	{ .addr = 0x00f1015aac, .val = 0x00000000 },
	{ .addr = 0x00f1015ab0, .val = 0x00000000 },
	{ .addr = 0x00f1015ab4, .val = 0x00000000 },
	{ .addr = 0x00f1015ab8, .val = 0x00000000 },
	{ .addr = 0x00f1015abc, .val = 0x00000000 },
	{ .addr = 0x00f1015ac0, .val = 0x00000000 },
	{ .addr = 0x00f1015ac4, .val = 0x00000000 },
	{ .addr = 0x00f1015ac8, .val = 0x00000000 },
	{ .addr = 0x00f1015acc, .val = 0x00000000 },
	{ .addr = 0x00f1015ad0, .val = 0x00000000 },
	{ .addr = 0x00f1015ad4, .val = 0x00000000 },
	{ .addr = 0x00f1015ad8, .val = 0x00000000 },
	{ .addr = 0x00f1015adc, .val = 0x00000000 },
	{ .addr = 0x00f1015ae0, .val = 0x00000000 },
	{ .addr = 0x00f1015ae4, .val = 0x00000000 },
	{ .addr = 0x00f1015ae8, .val = 0x00000000 },
	{ .addr = 0x00f1015aec, .val = 0x00000000 },
	{ .addr = 0x00f1015af0, .val = 0x00000000 },
	{ .addr = 0x00f1015af4, .val = 0x00000000 },
	{ .addr = 0x00f1015af8, .val = 0x00000000 },
	{ .addr = 0x00f1015afc, .val = 0x00000000 },
	{ .addr = 0x00f1015b00, .val = 0x00000000 },
	{ .addr = 0x00f1015b04, .val = 0x00000000 },
	{ .addr = 0x00f1015b08, .val = 0x00000000 },
	{ .addr = 0x00f1015b0c, .val = 0x00000000 },
	{ .addr = 0x00f1015b10, .val = 0x00000000 },
	{ .addr = 0x00f1015b14, .val = 0x00000000 },
	{ .addr = 0x00f1015b18, .val = 0x00000000 },
	{ .addr = 0x00f1015b1c, .val = 0x00000000 },
	{ .addr = 0x00f1015b20, .val = 0x00000000 },
	{ .addr = 0x00f1015b24, .val = 0x00000000 },
	{ .addr = 0x00f1015b28, .val = 0x00000000 },
	{ .addr = 0x00f1015b2c, .val = 0x00000000 },
	{ .addr = 0x00f1015b30, .val = 0x00000000 },
	{ .addr = 0x00f1015b34, .val = 0x00000000 },
	{ .addr = 0x00f1015b38, .val = 0x00000000 },
	{ .addr = 0x00f1015b3c, .val = 0x00000000 },
	{ .addr = 0x00f1015b40, .val = 0x00000000 },
	{ .addr = 0x00f1015b44, .val = 0x00000000 },
	{ .addr = 0x00f1015b48, .val = 0x00000000 },
	{ .addr = 0x00f1015b4c, .val = 0x00000000 },
	{ .addr = 0x00f1015b50, .val = 0x00000000 },
	{ .addr = 0x00f1015b54, .val = 0x00000000 },
	{ .addr = 0x00f1015b58, .val = 0x00000000 },
	{ .addr = 0x00f1015b5c, .val = 0x00000000 },
	{ .addr = 0x00f1015b60, .val = 0x00000000 },
	{ .addr = 0x00f1015b64, .val = 0x00000000 },
	{ .addr = 0x00f1015b68, .val = 0x00000000 },
	{ .addr = 0x00f1015b6c, .val = 0x00000000 },
	{ .addr = 0x00f1015b70, .val = 0x00000000 },
	{ .addr = 0x00f1015b74, .val = 0x00000000 },
	{ .addr = 0x00f1015b78, .val = 0x00000000 },
	{ .addr = 0x00f1015b7c, .val = 0x00000000 },
	{ .addr = 0x00f1015b80, .val = 0x00000000 },
	{ .addr = 0x00f1015b84, .val = 0x00000000 },
	{ .addr = 0x00f1015b88, .val = 0x00000000 },
	{ .addr = 0x00f1015b8c, .val = 0x00000000 },
	{ .addr = 0x00f1015b90, .val = 0x00000000 },
	{ .addr = 0x00f1015b94, .val = 0x00000000 },
	{ .addr = 0x00f1015b98, .val = 0x00000000 },
	{ .addr = 0x00f1015b9c, .val = 0x00000000 },
	{ .addr = 0x00f1015ba0, .val = 0x00000000 },
	{ .addr = 0x00f1015ba4, .val = 0x00000000 },
	{ .addr = 0x00f1015ba8, .val = 0x00000000 },
	{ .addr = 0x00f1015bac, .val = 0x00000000 },
	{ .addr = 0x00f1015bb0, .val = 0x00000000 },
	{ .addr = 0x00f1015bb4, .val = 0x00000000 },
	{ .addr = 0x00f1015bb8, .val = 0x00000000 },
	{ .addr = 0x00f1015bbc, .val = 0x00000000 },
	{ .addr = 0x00f1015bc0, .val = 0x00000000 },
	{ .addr = 0x00f1015bc4, .val = 0x00000000 },
	{ .addr = 0x00f1015bc8, .val = 0x00000000 },
	{ .addr = 0x00f1015bcc, .val = 0x00000000 },
	{ .addr = 0x00f1015bd0, .val = 0x00000000 },
	{ .addr = 0x00f1015bd4, .val = 0x00000000 },
	{ .addr = 0x00f1015bd8, .val = 0x00000000 },
	{ .addr = 0x00f1015bdc, .val = 0x00000000 },
	{ .addr = 0x00f1015be0, .val = 0x00000000 },
	{ .addr = 0x00f1015be4, .val = 0x00000000 },
	{ .addr = 0x00f1015be8, .val = 0x00000000 },
	{ .addr = 0x00f1015bec, .val = 0x00000000 },
	{ .addr = 0x00f1015bf0, .val = 0x00000000 },
	{ .addr = 0x00f1015bf4, .val = 0x00000000 },
	{ .addr = 0x00f1015bf8, .val = 0x00000000 },
	{ .addr = 0x00f1015bfc, .val = 0x00000000 },
	{ .addr = 0x00f1015c00, .val = 0x00000000 },
	{ .addr = 0x00f1015c04, .val = 0x00000000 },
	{ .addr = 0x00f1015c08, .val = 0x00000000 },
	{ .addr = 0x00f1015c0c, .val = 0x00000000 },
	{ .addr = 0x00f1015c10, .val = 0x00000000 },
	{ .addr = 0x00f1015c14, .val = 0x00000000 },
	{ .addr = 0x00f1015c18, .val = 0x00000000 },
	{ .addr = 0x00f1015c1c, .val = 0x00000000 },
	{ .addr = 0x00f1015c20, .val = 0x00000000 },
	{ .addr = 0x00f1015c24, .val = 0x00000000 },
	{ .addr = 0x00f1015c28, .val = 0x00000000 },
	{ .addr = 0x00f1015c2c, .val = 0x00000000 },
	{ .addr = 0x00f1015c30, .val = 0x00000000 },
	{ .addr = 0x00f1015c34, .val = 0x00000000 },
	{ .addr = 0x00f1015c38, .val = 0x00000000 },
	{ .addr = 0x00f1015c3c, .val = 0x00000000 },
	{ .addr = 0x00f1015c40, .val = 0x00000000 },
	{ .addr = 0x00f1015c44, .val = 0x00000000 },
	{ .addr = 0x00f1015c48, .val = 0x00000000 },
	{ .addr = 0x00f1015c4c, .val = 0x00000000 },
	{ .addr = 0x00f1015c50, .val = 0x00000000 },
	{ .addr = 0x00f1015c54, .val = 0x00000000 },
	{ .addr = 0x00f1015c58, .val = 0x00000000 },
	{ .addr = 0x00f1015c5c, .val = 0x00000000 },
	{ .addr = 0x00f1015c60, .val = 0x00000000 },
	{ .addr = 0x00f1015c64, .val = 0x00000000 },
	{ .addr = 0x00f1015c68, .val = 0x00000000 },
	{ .addr = 0x00f1015c6c, .val = 0x00000000 },
	{ .addr = 0x00f1015c70, .val = 0x00000000 },
	{ .addr = 0x00f1015c74, .val = 0x00000000 },
	{ .addr = 0x00f1015c78, .val = 0x00000000 },
	{ .addr = 0x00f1015c7c, .val = 0x00000000 },
	{ .addr = 0x00f1015c80, .val = 0x00000000 },
	{ .addr = 0x00f1015c84, .val = 0x00000000 },
	{ .addr = 0x00f1015c88, .val = 0x00000000 },
	{ .addr = 0x00f1015c8c, .val = 0x00000000 },
	{ .addr = 0x00f1015c90, .val = 0x00000000 },
	{ .addr = 0x00f1015c94, .val = 0x00000000 },
	{ .addr = 0x00f1015c98, .val = 0x00000000 },
	{ .addr = 0x00f1015c9c, .val = 0x00000000 },
	{ .addr = 0x00f1015ca0, .val = 0x00000000 },
	{ .addr = 0x00f1015ca4, .val = 0x00000000 },
	{ .addr = 0x00f1015ca8, .val = 0x00000000 },
	{ .addr = 0x00f1015cac, .val = 0x00000000 },
	{ .addr = 0x00f1015cb0, .val = 0x00000000 },
	{ .addr = 0x00f1015cb4, .val = 0x00000000 },
	{ .addr = 0x00f1015cb8, .val = 0x00000000 },
	{ .addr = 0x00f1015cbc, .val = 0x00000000 },
	{ .addr = 0x00f1015cc0, .val = 0x00000000 },
	{ .addr = 0x00f1015cc4, .val = 0x00000000 },
	{ .addr = 0x00f1015cc8, .val = 0x00000000 },
	{ .addr = 0x00f1015ccc, .val = 0x00000000 },
	{ .addr = 0x00f1015cd0, .val = 0x00000000 },
	{ .addr = 0x00f1015cd4, .val = 0x00000000 },
	{ .addr = 0x00f1015cd8, .val = 0x00000000 },
	{ .addr = 0x00f1015cdc, .val = 0x00000000 },
	{ .addr = 0x00f1015ce0, .val = 0x00000000 },
	{ .addr = 0x00f1015ce4, .val = 0x00000000 },
	{ .addr = 0x00f1015ce8, .val = 0x00000000 },
	{ .addr = 0x00f1015cec, .val = 0x00000000 },
	{ .addr = 0x00f1015cf0, .val = 0x00000000 },
	{ .addr = 0x00f1015cf4, .val = 0x00000000 },
	{ .addr = 0x00f1015cf8, .val = 0x00000000 },
	{ .addr = 0x00f1015cfc, .val = 0x00000000 },
	{ .addr = 0x00f1015d00, .val = 0x00000000 },
	{ .addr = 0x00f1015d04, .val = 0x00000000 },
	{ .addr = 0x00f1015d08, .val = 0x00000000 },
	{ .addr = 0x00f1015d0c, .val = 0x00000000 },
	{ .addr = 0x00f1015d10, .val = 0x00000000 },
	{ .addr = 0x00f1015d14, .val = 0x00000000 },
	{ .addr = 0x00f1015d18, .val = 0x00000000 },
	{ .addr = 0x00f1015d1c, .val = 0x00000000 },
	{ .addr = 0x00f1015d20, .val = 0x00000000 },
	{ .addr = 0x00f1015d24, .val = 0x00000000 },
	{ .addr = 0x00f1015d28, .val = 0x00000000 },
	{ .addr = 0x00f1015d2c, .val = 0x00000000 },
	{ .addr = 0x00f1015d30, .val = 0x00000000 },
	{ .addr = 0x00f1015d34, .val = 0x00000000 },
	{ .addr = 0x00f1015d38, .val = 0x00000000 },
	{ .addr = 0x00f1015d3c, .val = 0x00000000 },
	{ .addr = 0x00f1015d40, .val = 0x00000000 },
	{ .addr = 0x00f1015d44, .val = 0x00000000 },
	{ .addr = 0x00f1015d48, .val = 0x00000000 },
	{ .addr = 0x00f1015d4c, .val = 0x00000000 },
	{ .addr = 0x00f1015d50, .val = 0x00000000 },
	{ .addr = 0x00f1015d54, .val = 0x00000000 },
	{ .addr = 0x00f1015d58, .val = 0x00000000 },
	{ .addr = 0x00f1015d5c, .val = 0x00000000 },
	{ .addr = 0x00f1015d60, .val = 0x00000000 },
	{ .addr = 0x00f1015d64, .val = 0x00000000 },
	{ .addr = 0x00f1015d68, .val = 0x00000000 },
	{ .addr = 0x00f1015d6c, .val = 0x00000000 },
	{ .addr = 0x00f1015d70, .val = 0x00000000 },
	{ .addr = 0x00f1015d74, .val = 0x00000000 },
	{ .addr = 0x00f1015d78, .val = 0x00000000 },
	{ .addr = 0x00f1015d7c, .val = 0x00000000 },
	{ .addr = 0x00f1015d80, .val = 0x00000000 },
	{ .addr = 0x00f1015d84, .val = 0x00000000 },
	{ .addr = 0x00f1015d88, .val = 0x00000000 },
	{ .addr = 0x00f1015d8c, .val = 0x00000000 },
	{ .addr = 0x00f1015d90, .val = 0x00000000 },
	{ .addr = 0x00f1015d94, .val = 0x00000000 },
	{ .addr = 0x00f1015d98, .val = 0x00000000 },
	{ .addr = 0x00f1015d9c, .val = 0x00000000 },
	{ .addr = 0x00f1015da0, .val = 0x00000000 },
	{ .addr = 0x00f1015da4, .val = 0x00000000 },
	{ .addr = 0x00f1015da8, .val = 0x00000000 },
	{ .addr = 0x00f1015dac, .val = 0x00000000 },
	{ .addr = 0x00f1015db0, .val = 0x00000000 },
	{ .addr = 0x00f1015db4, .val = 0x00000000 },
	{ .addr = 0x00f1015db8, .val = 0x00000000 },
	{ .addr = 0x00f1015dbc, .val = 0x00000000 },
	{ .addr = 0x00f1015dc0, .val = 0x00000000 },
	{ .addr = 0x00f1015dc4, .val = 0x00000000 },
	{ .addr = 0x00f1015dc8, .val = 0x00000000 },
	{ .addr = 0x00f1015dcc, .val = 0x00000000 },
	{ .addr = 0x00f1015dd0, .val = 0x00000000 },
	{ .addr = 0x00f1015dd4, .val = 0x00000000 },
	{ .addr = 0x00f1015dd8, .val = 0x00000000 },
	{ .addr = 0x00f1015ddc, .val = 0x00000000 },
	{ .addr = 0x00f1015de0, .val = 0x00000000 },
	{ .addr = 0x00f1015de4, .val = 0x00000000 },
	{ .addr = 0x00f1015de8, .val = 0x00000000 },
	{ .addr = 0x00f1015dec, .val = 0x00000000 },
	{ .addr = 0x00f1015df0, .val = 0x00000000 },
	{ .addr = 0x00f1015df4, .val = 0x00000000 },
	{ .addr = 0x00f1015df8, .val = 0x00000000 },
	{ .addr = 0x00f1015dfc, .val = 0x00000000 },
	{ .addr = 0x00f1015e00, .val = 0x00000000 },
	{ .addr = 0x00f1015e04, .val = 0x00000000 },
	{ .addr = 0x00f1015e08, .val = 0x00000000 },
	{ .addr = 0x00f1015e0c, .val = 0x00000000 },
	{ .addr = 0x00f1015e10, .val = 0x00000000 },
	{ .addr = 0x00f1015e14, .val = 0x00000000 },
	{ .addr = 0x00f1015e18, .val = 0x00000000 },
	{ .addr = 0x00f1015e1c, .val = 0x00000000 },
	{ .addr = 0x00f1015e20, .val = 0x00000000 },
	{ .addr = 0x00f1015e24, .val = 0x00000000 },
	{ .addr = 0x00f1015e28, .val = 0x00000000 },
	{ .addr = 0x00f1015e2c, .val = 0x00000000 },
	{ .addr = 0x00f1015e30, .val = 0x00000000 },
	{ .addr = 0x00f1015e34, .val = 0x00000000 },
	{ .addr = 0x00f1015e38, .val = 0x00000000 },
	{ .addr = 0x00f1015e3c, .val = 0x00000000 },
	{ .addr = 0x00f1015e40, .val = 0x00000000 },
	{ .addr = 0x00f1015e44, .val = 0x00000000 },
	{ .addr = 0x00f1015e48, .val = 0x00000000 },
	{ .addr = 0x00f1015e4c, .val = 0x00000000 },
	{ .addr = 0x00f1015e50, .val = 0x00000000 },
	{ .addr = 0x00f1015e54, .val = 0x00000000 },
	{ .addr = 0x00f1015e58, .val = 0x00000000 },
	{ .addr = 0x00f1015e5c, .val = 0x00000000 },
	{ .addr = 0x00f1015e60, .val = 0x00000000 },
	{ .addr = 0x00f1015e64, .val = 0x00000000 },
	{ .addr = 0x00f1015e68, .val = 0x00000000 },
	{ .addr = 0x00f1015e6c, .val = 0x00000000 },
	{ .addr = 0x00f1015e70, .val = 0x00000000 },
	{ .addr = 0x00f1015e74, .val = 0x00000000 },
	{ .addr = 0x00f1015e78, .val = 0x00000000 },
	{ .addr = 0x00f1015e7c, .val = 0x00000000 },
	{ .addr = 0x00f1015e80, .val = 0x00000000 },
	{ .addr = 0x00f1015e84, .val = 0x00000000 },
	{ .addr = 0x00f1015e88, .val = 0x00000000 },
	{ .addr = 0x00f1015e8c, .val = 0x00000000 },
	{ .addr = 0x00f1015e90, .val = 0x00000000 },
	{ .addr = 0x00f1015e94, .val = 0x00000000 },
	{ .addr = 0x00f1015e98, .val = 0x00000000 },
	{ .addr = 0x00f1015e9c, .val = 0x00000000 },
	{ .addr = 0x00f1015ea0, .val = 0x00000000 },
	{ .addr = 0x00f1015ea4, .val = 0x00000000 },
	{ .addr = 0x00f1015ea8, .val = 0x00000000 },
	{ .addr = 0x00f1015eac, .val = 0x00000000 },
	{ .addr = 0x00f1015eb0, .val = 0x00000000 },
	{ .addr = 0x00f1015eb4, .val = 0x00000000 },
	{ .addr = 0x00f1015eb8, .val = 0x00000000 },
	{ .addr = 0x00f1015ebc, .val = 0x00000000 },
	{ .addr = 0x00f1015ec0, .val = 0x00000000 },
	{ .addr = 0x00f1015ec4, .val = 0x00000000 },
	{ .addr = 0x00f1015ec8, .val = 0x00000000 },
	{ .addr = 0x00f1015ecc, .val = 0x00000000 },
	{ .addr = 0x00f1015ed0, .val = 0x00000000 },
	{ .addr = 0x00f1015ed4, .val = 0x00000000 },
	{ .addr = 0x00f1015ed8, .val = 0x00000000 },
	{ .addr = 0x00f1015edc, .val = 0x00000000 },
	{ .addr = 0x00f1015ee0, .val = 0x00000000 },
	{ .addr = 0x00f1015ee4, .val = 0x00000000 },
	{ .addr = 0x00f1015ee8, .val = 0x00000000 },
	{ .addr = 0x00f1015eec, .val = 0x00000000 },
	{ .addr = 0x00f1015ef0, .val = 0x00000000 },
	{ .addr = 0x00f1015ef4, .val = 0x00000000 },
	{ .addr = 0x00f1015ef8, .val = 0x00000000 },
	{ .addr = 0x00f1015efc, .val = 0x00000000 },
	{ .addr = 0x00f1015f00, .val = 0x00000000 },
	{ .addr = 0x00f1015f04, .val = 0x00000000 },
	{ .addr = 0x00f1015f08, .val = 0x00000000 },
	{ .addr = 0x00f1015f0c, .val = 0x00000000 },
	{ .addr = 0x00f1015f10, .val = 0x00000000 },
	{ .addr = 0x00f1015f14, .val = 0x00000000 },
	{ .addr = 0x00f1015f18, .val = 0x00000000 },
	{ .addr = 0x00f1015f1c, .val = 0x00000000 },
	{ .addr = 0x00f1015f20, .val = 0x00000000 },
	{ .addr = 0x00f1015f24, .val = 0x00000000 },
	{ .addr = 0x00f1015f28, .val = 0x00000000 },
	{ .addr = 0x00f1015f2c, .val = 0x00000000 },
	{ .addr = 0x00f1015f30, .val = 0x00000000 },
	{ .addr = 0x00f1015f34, .val = 0x00000000 },
	{ .addr = 0x00f1015f38, .val = 0x00000000 },
	{ .addr = 0x00f1015f3c, .val = 0x00000000 },
	{ .addr = 0x00f1015f40, .val = 0x00000000 },
	{ .addr = 0x00f1015f44, .val = 0x00000000 },
	{ .addr = 0x00f1015f48, .val = 0x00000000 },
	{ .addr = 0x00f1015f4c, .val = 0x00000000 },
	{ .addr = 0x00f1015f50, .val = 0x00000000 },
	{ .addr = 0x00f1015f54, .val = 0x00000000 },
	{ .addr = 0x00f1015f58, .val = 0x00000000 },
	{ .addr = 0x00f1015f5c, .val = 0x00000000 },
	{ .addr = 0x00f1015f60, .val = 0x00000000 },
	{ .addr = 0x00f1015f64, .val = 0x00000000 },
	{ .addr = 0x00f1015f68, .val = 0x00000000 },
	{ .addr = 0x00f1015f6c, .val = 0x00000000 },
	{ .addr = 0x00f1015f70, .val = 0x00000000 },
	{ .addr = 0x00f1015f74, .val = 0x00000000 },
	{ .addr = 0x00f1015f78, .val = 0x00000000 },
	{ .addr = 0x00f1015f7c, .val = 0x00000000 },
	{ .addr = 0x00f1015f80, .val = 0x00000000 },
	{ .addr = 0x00f1015f84, .val = 0x00000000 },
	{ .addr = 0x00f1015f88, .val = 0x00000000 },
	{ .addr = 0x00f1015f8c, .val = 0x00000000 },
	{ .addr = 0x00f1015f90, .val = 0x00000000 },
	{ .addr = 0x00f1015f94, .val = 0x00000000 },
	{ .addr = 0x00f1015f98, .val = 0x00000000 },
	{ .addr = 0x00f1015f9c, .val = 0x00000000 },
	{ .addr = 0x00f1015fa0, .val = 0x00000000 },
	{ .addr = 0x00f1015fa4, .val = 0x00000000 },
	{ .addr = 0x00f1015fa8, .val = 0x00000000 },
	{ .addr = 0x00f1015fac, .val = 0x00000000 },
	{ .addr = 0x00f1015fb0, .val = 0x00000000 },
	{ .addr = 0x00f1015fb4, .val = 0x00000000 },
	{ .addr = 0x00f1015fb8, .val = 0x00000000 },
	{ .addr = 0x00f1015fbc, .val = 0x00000000 },
	{ .addr = 0x00f1015fc0, .val = 0x00000000 },
	{ .addr = 0x00f1015fc4, .val = 0x00000000 },
	{ .addr = 0x00f1015fc8, .val = 0x00000000 },
	{ .addr = 0x00f1015fcc, .val = 0x00000000 },
	{ .addr = 0x00f1015fd0, .val = 0x00000000 },
	{ .addr = 0x00f1015fd4, .val = 0x00000000 },
	{ .addr = 0x00f1015fd8, .val = 0x00000000 },
	{ .addr = 0x00f1015fdc, .val = 0x00000000 },
	{ .addr = 0x00f1015fe0, .val = 0x00000000 },
	{ .addr = 0x00f1015fe4, .val = 0x00000000 },
	{ .addr = 0x00f1015fe8, .val = 0x00000000 },
	{ .addr = 0x00f1015fec, .val = 0x00000000 },
	{ .addr = 0x00f1015ff0, .val = 0x00000000 },
	{ .addr = 0x00f1015ff4, .val = 0x00000000 },
	{ .addr = 0x00f1015ff8, .val = 0x00000000 },
	{ .addr = 0x00f1015ffc, .val = 0x00000000 },
	{ .addr = 0x00f1016000, .val = 0x00000000 },
	{ .addr = 0x00f1016004, .val = 0x00000000 },
	{ .addr = 0x00f1016008, .val = 0x00000000 },
	{ .addr = 0x00f101600c, .val = 0x00000000 },
	{ .addr = 0x00f1016010, .val = 0x00000000 },
	{ .addr = 0x00f1016014, .val = 0x00000000 },
	{ .addr = 0x00f1016018, .val = 0x00000000 },
	{ .addr = 0x00f101601c, .val = 0x00000000 },
	{ .addr = 0x00f1016020, .val = 0x00000000 },
	{ .addr = 0x00f1016024, .val = 0x00000000 },
	{ .addr = 0x00f1016028, .val = 0x00000000 },
	{ .addr = 0x00f101602c, .val = 0x00000000 },
	{ .addr = 0x00f1016030, .val = 0x00000000 },
	{ .addr = 0x00f1016034, .val = 0x00000000 },
	{ .addr = 0x00f1016038, .val = 0x00000000 },
	{ .addr = 0x00f101603c, .val = 0x00000000 },
	{ .addr = 0x00f1016040, .val = 0x00000000 },
	{ .addr = 0x00f1016044, .val = 0x00000000 },
	{ .addr = 0x00f1016048, .val = 0x00000000 },
	{ .addr = 0x00f101604c, .val = 0x00000000 },
	{ .addr = 0x00f1016050, .val = 0x00000000 },
	{ .addr = 0x00f1016054, .val = 0x00000000 },
	{ .addr = 0x00f1016058, .val = 0x00000000 },
	{ .addr = 0x00f101605c, .val = 0x00000000 },
	{ .addr = 0x00f1016060, .val = 0x00000000 },
	{ .addr = 0x00f1016064, .val = 0x00000000 },
	{ .addr = 0x00f1016068, .val = 0x00000000 },
	{ .addr = 0x00f101606c, .val = 0x00000000 },
	{ .addr = 0x00f1016070, .val = 0x00000000 },
	{ .addr = 0x00f1016074, .val = 0x00000000 },
	{ .addr = 0x00f1016078, .val = 0x00000000 },
	{ .addr = 0x00f101607c, .val = 0x00000000 },
	{ .addr = 0x00f1016080, .val = 0x00000000 },
	{ .addr = 0x00f1016084, .val = 0x00000000 },
	{ .addr = 0x00f1016088, .val = 0x00000000 },
	{ .addr = 0x00f101608c, .val = 0x00000000 },
	{ .addr = 0x00f1016090, .val = 0x00000000 },
	{ .addr = 0x00f1016094, .val = 0x00000000 },
	{ .addr = 0x00f1016098, .val = 0x00000000 },
	{ .addr = 0x00f101609c, .val = 0x00000000 },
	{ .addr = 0x00f10160a0, .val = 0x00000000 },
	{ .addr = 0x00f10160a4, .val = 0x00000000 },
	{ .addr = 0x00f10160a8, .val = 0x00000000 },
	{ .addr = 0x00f10160ac, .val = 0x00000000 },
	{ .addr = 0x00f10160b0, .val = 0x00000000 },
	{ .addr = 0x00f10160b4, .val = 0x00000000 },
	{ .addr = 0x00f10160b8, .val = 0x00000000 },
	{ .addr = 0x00f10160bc, .val = 0x00000000 },
	{ .addr = 0x00f10160c0, .val = 0x00000000 },
	{ .addr = 0x00f10160c4, .val = 0x00000000 },
	{ .addr = 0x00f10160c8, .val = 0x00000000 },
	{ .addr = 0x00f10160cc, .val = 0x00000000 },
	{ .addr = 0x00f10160d0, .val = 0x00000000 },
	{ .addr = 0x00f10160d4, .val = 0x00000000 },
	{ .addr = 0x00f10160d8, .val = 0x00000000 },
	{ .addr = 0x00f10160dc, .val = 0x00000000 },
	{ .addr = 0x00f10160e0, .val = 0x00000000 },
	{ .addr = 0x00f10160e4, .val = 0x00000000 },
	{ .addr = 0x00f10160e8, .val = 0x00000000 },
	{ .addr = 0x00f10160ec, .val = 0x00000000 },
	{ .addr = 0x00f10160f0, .val = 0x00000000 },
	{ .addr = 0x00f10160f4, .val = 0x00000000 },
	{ .addr = 0x00f10160f8, .val = 0x00000000 },
	{ .addr = 0x00f10160fc, .val = 0x00000000 },
	{ .addr = 0x00f1016100, .val = 0x00000000 },
	{ .addr = 0x00f1016104, .val = 0x00000000 },
	{ .addr = 0x00f1016108, .val = 0x00000000 },
	{ .addr = 0x00f101610c, .val = 0x00000000 },
	{ .addr = 0x00f1016110, .val = 0x00000000 },
	{ .addr = 0x00f1016114, .val = 0x00000000 },
	{ .addr = 0x00f1016118, .val = 0x00000000 },
	{ .addr = 0x00f101611c, .val = 0x00000000 },
	{ .addr = 0x00f1016120, .val = 0x00000000 },
	{ .addr = 0x00f1016124, .val = 0x00000000 },
	{ .addr = 0x00f1016128, .val = 0x00000000 },
	{ .addr = 0x00f101612c, .val = 0x00000000 },
	{ .addr = 0x00f1016130, .val = 0x00000000 },
	{ .addr = 0x00f1016134, .val = 0x00000000 },
	{ .addr = 0x00f1016138, .val = 0x00000000 },
	{ .addr = 0x00f101613c, .val = 0x00000000 },
	{ .addr = 0x00f1016140, .val = 0x00000000 },
	{ .addr = 0x00f1016144, .val = 0x00000000 },
	{ .addr = 0x00f1016148, .val = 0x00000000 },
	{ .addr = 0x00f101614c, .val = 0x00000000 },
	{ .addr = 0x00f1016150, .val = 0x00000000 },
	{ .addr = 0x00f1016154, .val = 0x00000000 },
	{ .addr = 0x00f1016158, .val = 0x00000000 },
	{ .addr = 0x00f101615c, .val = 0x00000000 },
	{ .addr = 0x00f1016160, .val = 0x00000000 },
	{ .addr = 0x00f1016164, .val = 0x00000000 },
	{ .addr = 0x00f1016168, .val = 0x00000000 },
	{ .addr = 0x00f101616c, .val = 0x00000000 },
	{ .addr = 0x00f1016170, .val = 0x00000000 },
	{ .addr = 0x00f1016174, .val = 0x00000000 },
	{ .addr = 0x00f1016178, .val = 0x00000000 },
	{ .addr = 0x00f101617c, .val = 0x00000000 },
	{ .addr = 0x00f1016180, .val = 0x00000000 },
	{ .addr = 0x00f1016184, .val = 0x00000000 },
	{ .addr = 0x00f1016188, .val = 0x00000000 },
	{ .addr = 0x00f101618c, .val = 0x00000000 },
	{ .addr = 0x00f1016190, .val = 0x00000000 },
	{ .addr = 0x00f1016194, .val = 0x00000000 },
	{ .addr = 0x00f1016198, .val = 0x00000000 },
	{ .addr = 0x00f101619c, .val = 0x00000000 },
	{ .addr = 0x00f10161a0, .val = 0x00000000 },
	{ .addr = 0x00f10161a4, .val = 0x00000000 },
	{ .addr = 0x00f10161a8, .val = 0x00000000 },
	{ .addr = 0x00f10161ac, .val = 0x00000000 },
	{ .addr = 0x00f10161b0, .val = 0x00000000 },
	{ .addr = 0x00f10161b4, .val = 0x00000000 },
	{ .addr = 0x00f10161b8, .val = 0x00000000 },
	{ .addr = 0x00f10161bc, .val = 0x00000000 },
	{ .addr = 0x00f10161c0, .val = 0x00000000 },
	{ .addr = 0x00f10161c4, .val = 0x00000000 },
	{ .addr = 0x00f10161c8, .val = 0x00000000 },
	{ .addr = 0x00f10161cc, .val = 0x00000000 },
	{ .addr = 0x00f10161d0, .val = 0x00000000 },
	{ .addr = 0x00f10161d4, .val = 0x00000000 },
	{ .addr = 0x00f10161d8, .val = 0x00000000 },
	{ .addr = 0x00f10161dc, .val = 0x00000000 },
	{ .addr = 0x00f10161e0, .val = 0x00000000 },
	{ .addr = 0x00f10161e4, .val = 0x00000000 },
	{ .addr = 0x00f10161e8, .val = 0x00000000 },
	{ .addr = 0x00f10161ec, .val = 0x00000000 },
	{ .addr = 0x00f10161f0, .val = 0x00000000 },
	{ .addr = 0x00f10161f4, .val = 0x00000000 },
	{ .addr = 0x00f10161f8, .val = 0x00000000 },
	{ .addr = 0x00f10161fc, .val = 0x00000000 },
	{ .addr = 0x00f1016200, .val = 0x00000000 },
	{ .addr = 0x00f1016204, .val = 0x00000000 },
	{ .addr = 0x00f1016208, .val = 0x00000000 },
	{ .addr = 0x00f101620c, .val = 0x00000000 },
	{ .addr = 0x00f1016210, .val = 0x00000000 },
	{ .addr = 0x00f1016214, .val = 0x00000000 },
	{ .addr = 0x00f1016218, .val = 0x00000000 },
	{ .addr = 0x00f101621c, .val = 0x00000000 },
	{ .addr = 0x00f1016220, .val = 0x00000000 },
	{ .addr = 0x00f1016224, .val = 0x00000000 },
	{ .addr = 0x00f1016228, .val = 0x00000000 },
	{ .addr = 0x00f101622c, .val = 0x00000000 },
	{ .addr = 0x00f1016230, .val = 0x00000000 },
	{ .addr = 0x00f1016234, .val = 0x00000000 },
	{ .addr = 0x00f1016238, .val = 0x00000000 },
	{ .addr = 0x00f101623c, .val = 0x00000000 },
	{ .addr = 0x00f1016240, .val = 0x00000000 },
	{ .addr = 0x00f1016244, .val = 0x00000000 },
	{ .addr = 0x00f1016248, .val = 0x00000000 },
	{ .addr = 0x00f101624c, .val = 0x00000000 },
	{ .addr = 0x00f1016250, .val = 0x00000000 },
	{ .addr = 0x00f1016254, .val = 0x00000000 },
	{ .addr = 0x00f1016258, .val = 0x00000000 },
	{ .addr = 0x00f101625c, .val = 0x00000000 },
	{ .addr = 0x00f1016260, .val = 0x00000000 },
	{ .addr = 0x00f1016264, .val = 0x00000000 },
	{ .addr = 0x00f1016268, .val = 0x00000000 },
	{ .addr = 0x00f101626c, .val = 0x00000000 },
	{ .addr = 0x00f1016270, .val = 0x00000000 },
	{ .addr = 0x00f1016274, .val = 0x00000000 },
	{ .addr = 0x00f1016278, .val = 0x00000000 },
	{ .addr = 0x00f101627c, .val = 0x00000000 },
	{ .addr = 0x00f1016280, .val = 0x00000000 },
	{ .addr = 0x00f1016284, .val = 0x00000000 },
	{ .addr = 0x00f1016288, .val = 0x00000000 },
	{ .addr = 0x00f101628c, .val = 0x00000000 },
	{ .addr = 0x00f1016290, .val = 0x00000000 },
	{ .addr = 0x00f1016294, .val = 0x00000000 },
	{ .addr = 0x00f1016298, .val = 0x00000000 },
	{ .addr = 0x00f101629c, .val = 0x00000000 },
	{ .addr = 0x00f10162a0, .val = 0x00000000 },
	{ .addr = 0x00f10162a4, .val = 0x00000000 },
	{ .addr = 0x00f10162a8, .val = 0x00000000 },
	{ .addr = 0x00f10162ac, .val = 0x00000000 },
	{ .addr = 0x00f10162b0, .val = 0x00000000 },
	{ .addr = 0x00f10162b4, .val = 0x00000000 },
	{ .addr = 0x00f10162b8, .val = 0x00000000 },
	{ .addr = 0x00f10162bc, .val = 0x00000000 },
	{ .addr = 0x00f10162c0, .val = 0x00000000 },
	{ .addr = 0x00f10162c4, .val = 0x00000000 },
	{ .addr = 0x00f10162c8, .val = 0x00000000 },
	{ .addr = 0x00f10162cc, .val = 0x00000000 },
	{ .addr = 0x00f10162d0, .val = 0x00000000 },
	{ .addr = 0x00f10162d4, .val = 0x00000000 },
	{ .addr = 0x00f10162d8, .val = 0x00000000 },
	{ .addr = 0x00f10162dc, .val = 0x00000000 },
	{ .addr = 0x00f10162e0, .val = 0x00000000 },
	{ .addr = 0x00f10162e4, .val = 0x00000000 },
	{ .addr = 0x00f10162e8, .val = 0x00000000 },
	{ .addr = 0x00f10162ec, .val = 0x00000000 },
	{ .addr = 0x00f10162f0, .val = 0x00000000 },
	{ .addr = 0x00f10162f4, .val = 0x00000000 },
	{ .addr = 0x00f10162f8, .val = 0x00000000 },
	{ .addr = 0x00f10162fc, .val = 0x00000000 },
	{ .addr = 0x00f1016300, .val = 0x00000000 },
	{ .addr = 0x00f1016304, .val = 0x00000000 },
	{ .addr = 0x00f1016308, .val = 0x00000000 },
	{ .addr = 0x00f101630c, .val = 0x00000000 },
	{ .addr = 0x00f1016310, .val = 0x00000000 },
	{ .addr = 0x00f1016314, .val = 0x00000000 },
	{ .addr = 0x00f1016318, .val = 0x00000000 },
	{ .addr = 0x00f101631c, .val = 0x00000000 },
	{ .addr = 0x00f1016320, .val = 0x00000000 },
	{ .addr = 0x00f1016324, .val = 0x00000000 },
	{ .addr = 0x00f1016328, .val = 0x00000000 },
	{ .addr = 0x00f101632c, .val = 0x00000000 },
	{ .addr = 0x00f1016330, .val = 0x00000000 },
	{ .addr = 0x00f1016334, .val = 0x00000000 },
	{ .addr = 0x00f1016338, .val = 0x00000000 },
	{ .addr = 0x00f101633c, .val = 0x00000000 },
	{ .addr = 0x00f1016340, .val = 0x00000000 },
	{ .addr = 0x00f1016344, .val = 0x00000000 },
	{ .addr = 0x00f1016348, .val = 0x00000000 },
	{ .addr = 0x00f101634c, .val = 0x00000000 },
	{ .addr = 0x00f1016350, .val = 0x00000000 },
	{ .addr = 0x00f1016354, .val = 0x00000000 },
	{ .addr = 0x00f1016358, .val = 0x00000000 },
	{ .addr = 0x00f101635c, .val = 0x00000000 },
	{ .addr = 0x00f1016360, .val = 0x00000000 },
	{ .addr = 0x00f1016364, .val = 0x00000000 },
	{ .addr = 0x00f1016368, .val = 0x00000000 },
	{ .addr = 0x00f101636c, .val = 0x00000000 },
	{ .addr = 0x00f1016370, .val = 0x00000000 },
	{ .addr = 0x00f1016374, .val = 0x00000000 },
	{ .addr = 0x00f1016378, .val = 0x00000000 },
	{ .addr = 0x00f101637c, .val = 0x00000000 },
	{ .addr = 0x00f1016380, .val = 0x00000000 },
	{ .addr = 0x00f1016384, .val = 0x00000000 },
	{ .addr = 0x00f1016388, .val = 0x00000000 },
	{ .addr = 0x00f101638c, .val = 0x00000000 },
	{ .addr = 0x00f1016390, .val = 0x00000000 },
	{ .addr = 0x00f1016394, .val = 0x00000000 },
	{ .addr = 0x00f1016398, .val = 0x00000000 },
	{ .addr = 0x00f101639c, .val = 0x00000000 },
	{ .addr = 0x00f10163a0, .val = 0x00000000 },
	{ .addr = 0x00f10163a4, .val = 0x00000000 },
	{ .addr = 0x00f10163a8, .val = 0x00000000 },
	{ .addr = 0x00f10163ac, .val = 0x00000000 },
	{ .addr = 0x00f10163b0, .val = 0x00000000 },
	{ .addr = 0x00f10163b4, .val = 0x00000000 },
	{ .addr = 0x00f10163b8, .val = 0x00000000 },
	{ .addr = 0x00f10163bc, .val = 0x00000000 },
	{ .addr = 0x00f10163c0, .val = 0x00000000 },
	{ .addr = 0x00f10163c4, .val = 0x00000000 },
	{ .addr = 0x00f10163c8, .val = 0x00000000 },
	{ .addr = 0x00f10163cc, .val = 0x00000000 },
	{ .addr = 0x00f10163d0, .val = 0x00000000 },
	{ .addr = 0x00f10163d4, .val = 0x00000000 },
	{ .addr = 0x00f10163d8, .val = 0x00000000 },
	{ .addr = 0x00f10163dc, .val = 0x00000000 },
	{ .addr = 0x00f10163e0, .val = 0x00000000 },
	{ .addr = 0x00f10163e4, .val = 0x00000000 },
	{ .addr = 0x00f10163e8, .val = 0x00000000 },
	{ .addr = 0x00f10163ec, .val = 0x00000000 },
	{ .addr = 0x00f10163f0, .val = 0x00000000 },
	{ .addr = 0x00f10163f4, .val = 0x00000000 },
	{ .addr = 0x00f10163f8, .val = 0x00000000 },
	{ .addr = 0x00f10163fc, .val = 0x00000000 },
	{ .addr = 0x00f1016400, .val = 0x00000000 },
	{ .addr = 0x00f1016404, .val = 0x00000000 },
	{ .addr = 0x00f1016408, .val = 0x00000000 },
	{ .addr = 0x00f101640c, .val = 0x00000000 },
	{ .addr = 0x00f1016410, .val = 0x00000000 },
	{ .addr = 0x00f1016414, .val = 0x00000000 },
	{ .addr = 0x00f1016418, .val = 0x00000000 },
	{ .addr = 0x00f101641c, .val = 0x00000000 },
	{ .addr = 0x00f1016420, .val = 0x00000000 },
	{ .addr = 0x00f1016424, .val = 0x00000000 },
	{ .addr = 0x00f1016428, .val = 0x00000000 },
	{ .addr = 0x00f101642c, .val = 0x00000000 },
	{ .addr = 0x00f1016430, .val = 0x00000000 },
	{ .addr = 0x00f1016434, .val = 0x00000000 },
	{ .addr = 0x00f1016438, .val = 0x00000000 },
	{ .addr = 0x00f101643c, .val = 0x00000000 },
	{ .addr = 0x00f1016440, .val = 0x00000000 },
	{ .addr = 0x00f1016444, .val = 0x00000000 },
	{ .addr = 0x00f1016448, .val = 0x00000000 },
	{ .addr = 0x00f101644c, .val = 0x00000000 },
	{ .addr = 0x00f1016450, .val = 0x00000000 },
	{ .addr = 0x00f1016454, .val = 0x00000000 },
	{ .addr = 0x00f1016458, .val = 0x00000000 },
	{ .addr = 0x00f101645c, .val = 0x00000000 },
	{ .addr = 0x00f1016460, .val = 0x00000000 },
	{ .addr = 0x00f1016464, .val = 0x00000000 },
	{ .addr = 0x00f1016468, .val = 0x00000000 },
	{ .addr = 0x00f101646c, .val = 0x00000000 },
	{ .addr = 0x00f1016470, .val = 0x00000000 },
	{ .addr = 0x00f1016474, .val = 0x00000000 },
	{ .addr = 0x00f1016478, .val = 0x00000000 },
	{ .addr = 0x00f101647c, .val = 0x00000000 },
	{ .addr = 0x00f1016480, .val = 0x00000000 },
	{ .addr = 0x00f1016484, .val = 0x00000000 },
	{ .addr = 0x00f1016488, .val = 0x00000000 },
	{ .addr = 0x00f101648c, .val = 0x00000000 },
	{ .addr = 0x00f1016490, .val = 0x00000000 },
	{ .addr = 0x00f1016494, .val = 0x00000000 },
	{ .addr = 0x00f1016498, .val = 0x00000000 },
	{ .addr = 0x00f101649c, .val = 0x00000000 },
	{ .addr = 0x00f10164a0, .val = 0x00000000 },
	{ .addr = 0x00f10164a4, .val = 0x00000000 },
	{ .addr = 0x00f10164a8, .val = 0x00000000 },
	{ .addr = 0x00f10164ac, .val = 0x00000000 },
	{ .addr = 0x00f10164b0, .val = 0x00000000 },
	{ .addr = 0x00f10164b4, .val = 0x00000000 },
	{ .addr = 0x00f10164b8, .val = 0x00000000 },
	{ .addr = 0x00f10164bc, .val = 0x00000000 },
	{ .addr = 0x00f10164c0, .val = 0x00000000 },
	{ .addr = 0x00f10164c4, .val = 0x00000000 },
	{ .addr = 0x00f10164c8, .val = 0x00000000 },
	{ .addr = 0x00f10164cc, .val = 0x00000000 },
	{ .addr = 0x00f10164d0, .val = 0x00000000 },
	{ .addr = 0x00f10164d4, .val = 0x00000000 },
	{ .addr = 0x00f10164d8, .val = 0x00000000 },
	{ .addr = 0x00f10164dc, .val = 0x00000000 },
	{ .addr = 0x00f10164e0, .val = 0x00000000 },
	{ .addr = 0x00f10164e4, .val = 0x00000000 },
	{ .addr = 0x00f10164e8, .val = 0x00000000 },
	{ .addr = 0x00f10164ec, .val = 0x00000000 },
	{ .addr = 0x00f10164f0, .val = 0x00000000 },
	{ .addr = 0x00f10164f4, .val = 0x00000000 },
	{ .addr = 0x00f10164f8, .val = 0x00000000 },
	{ .addr = 0x00f10164fc, .val = 0x00000000 },
	{ .addr = 0x00f1016500, .val = 0x00000000 },
	{ .addr = 0x00f1016504, .val = 0x00000000 },
	{ .addr = 0x00f1016508, .val = 0x00000000 },
	{ .addr = 0x00f101650c, .val = 0x00000000 },
	{ .addr = 0x00f1016510, .val = 0x00000000 },
	{ .addr = 0x00f1016514, .val = 0x00000000 },
	{ .addr = 0x00f1016518, .val = 0x00000000 },
	{ .addr = 0x00f101651c, .val = 0x00000000 },
	{ .addr = 0x00f1016520, .val = 0x00000000 },
	{ .addr = 0x00f1016524, .val = 0x00000000 },
	{ .addr = 0x00f1016528, .val = 0x00000000 },
	{ .addr = 0x00f101652c, .val = 0x00000000 },
	{ .addr = 0x00f1016530, .val = 0x00000000 },
	{ .addr = 0x00f1016534, .val = 0x00000000 },
	{ .addr = 0x00f1016538, .val = 0x00000000 },
	{ .addr = 0x00f101653c, .val = 0x00000000 },
	{ .addr = 0x00f1016540, .val = 0x00000000 },
	{ .addr = 0x00f1016544, .val = 0x00000000 },
	{ .addr = 0x00f1016548, .val = 0x00000000 },
	{ .addr = 0x00f101654c, .val = 0x00000000 },
	{ .addr = 0x00f1016550, .val = 0x00000000 },
	{ .addr = 0x00f1016554, .val = 0x00000000 },
	{ .addr = 0x00f1016558, .val = 0x00000000 },
	{ .addr = 0x00f101655c, .val = 0x00000000 },
	{ .addr = 0x00f1016560, .val = 0x00000000 },
	{ .addr = 0x00f1016564, .val = 0x00000000 },
	{ .addr = 0x00f1016568, .val = 0x00000000 },
	{ .addr = 0x00f101656c, .val = 0x00000000 },
	{ .addr = 0x00f1016570, .val = 0x00000000 },
	{ .addr = 0x00f1016574, .val = 0x00000000 },
	{ .addr = 0x00f1016578, .val = 0x00000000 },
	{ .addr = 0x00f101657c, .val = 0x00000000 },
	{ .addr = 0x00f1016580, .val = 0x00000000 },
	{ .addr = 0x00f1016584, .val = 0x00000000 },
	{ .addr = 0x00f1016588, .val = 0x00000000 },
	{ .addr = 0x00f101658c, .val = 0x00000000 },
	{ .addr = 0x00f1016590, .val = 0x00000000 },
	{ .addr = 0x00f1016594, .val = 0x00000000 },
	{ .addr = 0x00f1016598, .val = 0x00000000 },
	{ .addr = 0x00f101659c, .val = 0x00000000 },
	{ .addr = 0x00f10165a0, .val = 0x00000000 },
	{ .addr = 0x00f10165a4, .val = 0x00000000 },
	{ .addr = 0x00f10165a8, .val = 0x00000000 },
	{ .addr = 0x00f10165ac, .val = 0x00000000 },
	{ .addr = 0x00f10165b0, .val = 0x00000000 },
	{ .addr = 0x00f10165b4, .val = 0x00000000 },
	{ .addr = 0x00f10165b8, .val = 0x00000000 },
	{ .addr = 0x00f10165bc, .val = 0x00000000 },
	{ .addr = 0x00f10165c0, .val = 0x00000000 },
	{ .addr = 0x00f10165c4, .val = 0x00000000 },
	{ .addr = 0x00f10165c8, .val = 0x00000000 },
	{ .addr = 0x00f10165cc, .val = 0x00000000 },
	{ .addr = 0x00f10165d0, .val = 0x00000000 },
	{ .addr = 0x00f10165d4, .val = 0x00000000 },
	{ .addr = 0x00f10165d8, .val = 0x00000000 },
	{ .addr = 0x00f10165dc, .val = 0x00000000 },
	{ .addr = 0x00f10165e0, .val = 0x00000000 },
	{ .addr = 0x00f10165e4, .val = 0x00000000 },
	{ .addr = 0x00f10165e8, .val = 0x00000000 },
	{ .addr = 0x00f10165ec, .val = 0x00000000 },
	{ .addr = 0x00f10165f0, .val = 0x00000000 },
	{ .addr = 0x00f10165f4, .val = 0x00000000 },
	{ .addr = 0x00f10165f8, .val = 0x00000000 },
	{ .addr = 0x00f10165fc, .val = 0x00000000 },
	{ .addr = 0x00f1016600, .val = 0x00000000 },
	{ .addr = 0x00f1016604, .val = 0x00000000 },
	{ .addr = 0x00f1016608, .val = 0x00000000 },
	{ .addr = 0x00f101660c, .val = 0x00000000 },
	{ .addr = 0x00f1016610, .val = 0x00000000 },
	{ .addr = 0x00f1016614, .val = 0x00000000 },
	{ .addr = 0x00f1016618, .val = 0x00000000 },
	{ .addr = 0x00f101661c, .val = 0x00000000 },
	{ .addr = 0x00f1016620, .val = 0x00000000 },
	{ .addr = 0x00f1016624, .val = 0x00000000 },
	{ .addr = 0x00f1016628, .val = 0x00000000 },
	{ .addr = 0x00f101662c, .val = 0x00000000 },
	{ .addr = 0x00f1016630, .val = 0x00000000 },
	{ .addr = 0x00f1016634, .val = 0x00000000 },
	{ .addr = 0x00f1016638, .val = 0x00000000 },
	{ .addr = 0x00f101663c, .val = 0x00000000 },
	{ .addr = 0x00f1016640, .val = 0x00000000 },
	{ .addr = 0x00f1016644, .val = 0x00000000 },
	{ .addr = 0x00f1016648, .val = 0x00000000 },
	{ .addr = 0x00f101664c, .val = 0x00000000 },
	{ .addr = 0x00f1016650, .val = 0x00000000 },
	{ .addr = 0x00f1016654, .val = 0x00000000 },
	{ .addr = 0x00f1016658, .val = 0x00000000 },
	{ .addr = 0x00f101665c, .val = 0x00000000 },
	{ .addr = 0x00f1016660, .val = 0x00000000 },
	{ .addr = 0x00f1016664, .val = 0x00000000 },
	{ .addr = 0x00f1016668, .val = 0x00000000 },
	{ .addr = 0x00f101666c, .val = 0x00000000 },
	{ .addr = 0x00f1016670, .val = 0x00000000 },
	{ .addr = 0x00f1016674, .val = 0x00000000 },
	{ .addr = 0x00f1016678, .val = 0x00000000 },
	{ .addr = 0x00f101667c, .val = 0x00000000 },
	{ .addr = 0x00f1016680, .val = 0x00000000 },
	{ .addr = 0x00f1016684, .val = 0x00000000 },
	{ .addr = 0x00f1016688, .val = 0x00000000 },
	{ .addr = 0x00f101668c, .val = 0x00000000 },
	{ .addr = 0x00f1016690, .val = 0x00000000 },
	{ .addr = 0x00f1016694, .val = 0x00000000 },
	{ .addr = 0x00f1016698, .val = 0x00000000 },
	{ .addr = 0x00f101669c, .val = 0x00000000 },
	{ .addr = 0x00f10166a0, .val = 0x00000000 },
	{ .addr = 0x00f10166a4, .val = 0x00000000 },
	{ .addr = 0x00f10166a8, .val = 0x00000000 },
	{ .addr = 0x00f10166ac, .val = 0x00000000 },
	{ .addr = 0x00f10166b0, .val = 0x00000000 },
	{ .addr = 0x00f10166b4, .val = 0x00000000 },
	{ .addr = 0x00f10166b8, .val = 0x00000000 },
	{ .addr = 0x00f10166bc, .val = 0x00000000 },
	{ .addr = 0x00f10166c0, .val = 0x00000000 },
	{ .addr = 0x00f10166c4, .val = 0x00000000 },
	{ .addr = 0x00f10166c8, .val = 0x00000000 },
	{ .addr = 0x00f10166cc, .val = 0x00000000 },
	{ .addr = 0x00f10166d0, .val = 0x00000000 },
	{ .addr = 0x00f10166d4, .val = 0x00000000 },
	{ .addr = 0x00f10166d8, .val = 0x00000000 },
	{ .addr = 0x00f10166dc, .val = 0x00000000 },
	{ .addr = 0x00f10166e0, .val = 0x00000000 },
	{ .addr = 0x00f10166e4, .val = 0x00000000 },
	{ .addr = 0x00f10166e8, .val = 0x00000000 },
	{ .addr = 0x00f10166ec, .val = 0x00000000 },
	{ .addr = 0x00f10166f0, .val = 0x00000000 },
	{ .addr = 0x00f10166f4, .val = 0x00000000 },
	{ .addr = 0x00f10166f8, .val = 0x00000000 },
	{ .addr = 0x00f10166fc, .val = 0x00000000 },
	{ .addr = 0x00f1016700, .val = 0x00000000 },
	{ .addr = 0x00f1016704, .val = 0x00000000 },
	{ .addr = 0x00f1016708, .val = 0x00000000 },
	{ .addr = 0x00f101670c, .val = 0x00000000 },
	{ .addr = 0x00f1016710, .val = 0x00000000 },
	{ .addr = 0x00f1016714, .val = 0x00000000 },
	{ .addr = 0x00f1016718, .val = 0x00000000 },
	{ .addr = 0x00f101671c, .val = 0x00000000 },
	{ .addr = 0x00f1016720, .val = 0x00000000 },
	{ .addr = 0x00f1016724, .val = 0x00000000 },
	{ .addr = 0x00f1016728, .val = 0x00000000 },
	{ .addr = 0x00f101672c, .val = 0x00000000 },
	{ .addr = 0x00f1016730, .val = 0x00000000 },
	{ .addr = 0x00f1016734, .val = 0x00000000 },
	{ .addr = 0x00f1016738, .val = 0x00000000 },
	{ .addr = 0x00f101673c, .val = 0x00000000 },
	{ .addr = 0x00f1016740, .val = 0x00000000 },
	{ .addr = 0x00f1016744, .val = 0x00000000 },
	{ .addr = 0x00f1016748, .val = 0x00000000 },
	{ .addr = 0x00f101674c, .val = 0x00000000 },
	{ .addr = 0x00f1016750, .val = 0x00000000 },
	{ .addr = 0x00f1016754, .val = 0x00000000 },
	{ .addr = 0x00f1016758, .val = 0x00000000 },
	{ .addr = 0x00f101675c, .val = 0x00000000 },
	{ .addr = 0x00f1016760, .val = 0x00000000 },
	{ .addr = 0x00f1016764, .val = 0x00000000 },
	{ .addr = 0x00f1016768, .val = 0x00000000 },
	{ .addr = 0x00f101676c, .val = 0x00000000 },
	{ .addr = 0x00f1016770, .val = 0x00000000 },
	{ .addr = 0x00f1016774, .val = 0x00000000 },
	{ .addr = 0x00f1016778, .val = 0x00000000 },
	{ .addr = 0x00f101677c, .val = 0x00000000 },
	{ .addr = 0x00f1016780, .val = 0x00000000 },
	{ .addr = 0x00f1016784, .val = 0x00000000 },
	{ .addr = 0x00f1016788, .val = 0x00000000 },
	{ .addr = 0x00f101678c, .val = 0x00000000 },
	{ .addr = 0x00f1016790, .val = 0x00000000 },
	{ .addr = 0x00f1016794, .val = 0x00000000 },
	{ .addr = 0x00f1016798, .val = 0x00000000 },
	{ .addr = 0x00f101679c, .val = 0x00000000 },
	{ .addr = 0x00f10167a0, .val = 0x00000000 },
	{ .addr = 0x00f10167a4, .val = 0x00000000 },
	{ .addr = 0x00f10167a8, .val = 0x00000000 },
	{ .addr = 0x00f10167ac, .val = 0x00000000 },
	{ .addr = 0x00f10167b0, .val = 0x00000000 },
	{ .addr = 0x00f10167b4, .val = 0x00000000 },
	{ .addr = 0x00f10167b8, .val = 0x00000000 },
	{ .addr = 0x00f10167bc, .val = 0x00000000 },
	{ .addr = 0x00f10167c0, .val = 0x00000000 },
	{ .addr = 0x00f10167c4, .val = 0x00000000 },
	{ .addr = 0x00f10167c8, .val = 0x00000000 },
	{ .addr = 0x00f10167cc, .val = 0x00000000 },
	{ .addr = 0x00f10167d0, .val = 0x00000000 },
	{ .addr = 0x00f10167d4, .val = 0x00000000 },
	{ .addr = 0x00f10167d8, .val = 0x00000000 },
	{ .addr = 0x00f10167dc, .val = 0x00000000 },
	{ .addr = 0x00f10167e0, .val = 0x00000000 },
	{ .addr = 0x00f10167e4, .val = 0x00000000 },
	{ .addr = 0x00f10167e8, .val = 0x00000000 },
	{ .addr = 0x00f10167ec, .val = 0x00000000 },
	{ .addr = 0x00f10167f0, .val = 0x00000000 },
	{ .addr = 0x00f10167f4, .val = 0x00000000 },
	{ .addr = 0x00f10167f8, .val = 0x00000000 },
	{ .addr = 0x00f10167fc, .val = 0x00000000 },
	{ .addr = 0x00f1016800, .val = 0x00000000 },
	{ .addr = 0x00f1016804, .val = 0x00000000 },
	{ .addr = 0x00f1016808, .val = 0x00000000 },
	{ .addr = 0x00f101680c, .val = 0x00000000 },
	{ .addr = 0x00f1016810, .val = 0x00000000 },
	{ .addr = 0x00f1016814, .val = 0x00000000 },
	{ .addr = 0x00f1016818, .val = 0x00000000 },
	{ .addr = 0x00f101681c, .val = 0x00000000 },
	{ .addr = 0x00f1016820, .val = 0x00000000 },
	{ .addr = 0x00f1016824, .val = 0x00000000 },
	{ .addr = 0x00f1016828, .val = 0x00000000 },
	{ .addr = 0x00f101682c, .val = 0x00000000 },
	{ .addr = 0x00f1016830, .val = 0x00000000 },
	{ .addr = 0x00f1016834, .val = 0x00000000 },
	{ .addr = 0x00f1016838, .val = 0x00000000 },
	{ .addr = 0x00f101683c, .val = 0x00000000 },
	{ .addr = 0x00f1016840, .val = 0x00000000 },
	{ .addr = 0x00f1016844, .val = 0x00000000 },
	{ .addr = 0x00f1016848, .val = 0x00000000 },
	{ .addr = 0x00f101684c, .val = 0x00000000 },
	{ .addr = 0x00f1016850, .val = 0x00000000 },
	{ .addr = 0x00f1016854, .val = 0x00000000 },
	{ .addr = 0x00f1016858, .val = 0x00000000 },
	{ .addr = 0x00f101685c, .val = 0x00000000 },
	{ .addr = 0x00f1016860, .val = 0x00000000 },
	{ .addr = 0x00f1016864, .val = 0x00000000 },
	{ .addr = 0x00f1016868, .val = 0x00000000 },
	{ .addr = 0x00f101686c, .val = 0x00000000 },
	{ .addr = 0x00f1016870, .val = 0x00000000 },
	{ .addr = 0x00f1016874, .val = 0x00000000 },
	{ .addr = 0x00f1016878, .val = 0x00000000 },
	{ .addr = 0x00f101687c, .val = 0x00000000 },
	{ .addr = 0x00f1016880, .val = 0x00000000 },
	{ .addr = 0x00f1016884, .val = 0x00000000 },
	{ .addr = 0x00f1016888, .val = 0x00000000 },
	{ .addr = 0x00f101688c, .val = 0x00000000 },
	{ .addr = 0x00f1016890, .val = 0x00000000 },
	{ .addr = 0x00f1016894, .val = 0x00000000 },
	{ .addr = 0x00f1016898, .val = 0x00000000 },
	{ .addr = 0x00f101689c, .val = 0x00000000 },
	{ .addr = 0x00f10168a0, .val = 0x00000000 },
	{ .addr = 0x00f10168a4, .val = 0x00000000 },
	{ .addr = 0x00f10168a8, .val = 0x00000000 },
	{ .addr = 0x00f10168ac, .val = 0x00000000 },
	{ .addr = 0x00f10168b0, .val = 0x00000000 },
	{ .addr = 0x00f10168b4, .val = 0x00000000 },
	{ .addr = 0x00f10168b8, .val = 0x00000000 },
	{ .addr = 0x00f10168bc, .val = 0x00000000 },
	{ .addr = 0x00f10168c0, .val = 0x00000000 },
	{ .addr = 0x00f10168c4, .val = 0x00000000 },
	{ .addr = 0x00f10168c8, .val = 0x00000000 },
	{ .addr = 0x00f10168cc, .val = 0x00000000 },
	{ .addr = 0x00f10168d0, .val = 0x00000000 },
	{ .addr = 0x00f10168d4, .val = 0x00000000 },
	{ .addr = 0x00f10168d8, .val = 0x00000000 },
	{ .addr = 0x00f10168dc, .val = 0x00000000 },
	{ .addr = 0x00f10168e0, .val = 0x00000000 },
	{ .addr = 0x00f10168e4, .val = 0x00000000 },
	{ .addr = 0x00f10168e8, .val = 0x00000000 },
	{ .addr = 0x00f10168ec, .val = 0x00000000 },
	{ .addr = 0x00f10168f0, .val = 0x00000000 },
	{ .addr = 0x00f10168f4, .val = 0x00000000 },
	{ .addr = 0x00f10168f8, .val = 0x00000000 },
	{ .addr = 0x00f10168fc, .val = 0x00000000 },
	{ .addr = 0x00f1016900, .val = 0x00000000 },
	{ .addr = 0x00f1016904, .val = 0x00000000 },
	{ .addr = 0x00f1016908, .val = 0x00000000 },
	{ .addr = 0x00f101690c, .val = 0x00000000 },
	{ .addr = 0x00f1016910, .val = 0x00000000 },
	{ .addr = 0x00f1016914, .val = 0x00000000 },
	{ .addr = 0x00f1016918, .val = 0x00000000 },
	{ .addr = 0x00f101691c, .val = 0x00000000 },
	{ .addr = 0x00f1016920, .val = 0x00000000 },
	{ .addr = 0x00f1016924, .val = 0x00000000 },
	{ .addr = 0x00f1016928, .val = 0x00000000 },
	{ .addr = 0x00f101692c, .val = 0x00000000 },
	{ .addr = 0x00f1016930, .val = 0x00000000 },
	{ .addr = 0x00f1016934, .val = 0x00000000 },
	{ .addr = 0x00f1016938, .val = 0x00000000 },
	{ .addr = 0x00f101693c, .val = 0x00000000 },
	{ .addr = 0x00f1016940, .val = 0x00000000 },
	{ .addr = 0x00f1016944, .val = 0x00000000 },
	{ .addr = 0x00f1016948, .val = 0x00000000 },
	{ .addr = 0x00f101694c, .val = 0x00000000 },
	{ .addr = 0x00f1016950, .val = 0x00000000 },
	{ .addr = 0x00f1016954, .val = 0x00000000 },
	{ .addr = 0x00f1016958, .val = 0x00000000 },
	{ .addr = 0x00f101695c, .val = 0x00000000 },
	{ .addr = 0x00f1016960, .val = 0x00000000 },
	{ .addr = 0x00f1016964, .val = 0x00000000 },
	{ .addr = 0x00f1016968, .val = 0x00000000 },
	{ .addr = 0x00f101696c, .val = 0x00000000 },
	{ .addr = 0x00f1016970, .val = 0x00000000 },
	{ .addr = 0x00f1016974, .val = 0x00000000 },
	{ .addr = 0x00f1016978, .val = 0x00000000 },
	{ .addr = 0x00f101697c, .val = 0x00000000 },
	{ .addr = 0x00f1016980, .val = 0x00000000 },
	{ .addr = 0x00f1016984, .val = 0x00000000 },
	{ .addr = 0x00f1016988, .val = 0x00000000 },
	{ .addr = 0x00f101698c, .val = 0x00000000 },
	{ .addr = 0x00f1016990, .val = 0x00000000 },
	{ .addr = 0x00f1016994, .val = 0x00000000 },
	{ .addr = 0x00f1016998, .val = 0x00000000 },
	{ .addr = 0x00f101699c, .val = 0x00000000 },
	{ .addr = 0x00f10169a0, .val = 0x00000000 },
	{ .addr = 0x00f10169a4, .val = 0x00000000 },
	{ .addr = 0x00f10169a8, .val = 0x00000000 },
	{ .addr = 0x00f10169ac, .val = 0x00000000 },
	{ .addr = 0x00f10169b0, .val = 0x00000000 },
	{ .addr = 0x00f10169b4, .val = 0x00000000 },
	{ .addr = 0x00f10169b8, .val = 0x00000000 },
	{ .addr = 0x00f10169bc, .val = 0x00000000 },
	{ .addr = 0x00f10169c0, .val = 0x00000000 },
	{ .addr = 0x00f10169c4, .val = 0x00000000 },
	{ .addr = 0x00f10169c8, .val = 0x00000000 },
	{ .addr = 0x00f10169cc, .val = 0x00000000 },
	{ .addr = 0x00f10169d0, .val = 0x00000000 },
	{ .addr = 0x00f10169d4, .val = 0x00000000 },
	{ .addr = 0x00f10169d8, .val = 0x00000000 },
	{ .addr = 0x00f10169dc, .val = 0x00000000 },
	{ .addr = 0x00f10169e0, .val = 0x00000000 },
	{ .addr = 0x00f10169e4, .val = 0x00000000 },
	{ .addr = 0x00f10169e8, .val = 0x00000000 },
	{ .addr = 0x00f10169ec, .val = 0x00000000 },
	{ .addr = 0x00f10169f0, .val = 0x00000000 },
	{ .addr = 0x00f10169f4, .val = 0x00000000 },
	{ .addr = 0x00f10169f8, .val = 0x00000000 },
	{ .addr = 0x00f10169fc, .val = 0x00000000 },
	{ .addr = 0x00f1016a00, .val = 0x00000000 },
	{ .addr = 0x00f1016a04, .val = 0x00000000 },
	{ .addr = 0x00f1016a08, .val = 0x00000000 },
	{ .addr = 0x00f1016a0c, .val = 0x00000000 },
	{ .addr = 0x00f1016a10, .val = 0x00000000 },
	{ .addr = 0x00f1016a14, .val = 0x00000000 },
	{ .addr = 0x00f1016a18, .val = 0x00000000 },
	{ .addr = 0x00f1016a1c, .val = 0x00000000 },
	{ .addr = 0x00f1016a20, .val = 0x00000000 },
	{ .addr = 0x00f1016a24, .val = 0x00000000 },
	{ .addr = 0x00f1016a28, .val = 0x00000000 },
	{ .addr = 0x00f1016a2c, .val = 0x00000000 },
	{ .addr = 0x00f1016a30, .val = 0x00000000 },
	{ .addr = 0x00f1016a34, .val = 0x00000000 },
	{ .addr = 0x00f1016a38, .val = 0x00000000 },
	{ .addr = 0x00f1016a3c, .val = 0x00000000 },
	{ .addr = 0x00f1016a40, .val = 0x00000000 },
	{ .addr = 0x00f1016a44, .val = 0x00000000 },
	{ .addr = 0x00f1016a48, .val = 0x00000000 },
	{ .addr = 0x00f1016a4c, .val = 0x00000000 },
	{ .addr = 0x00f1016a50, .val = 0x00000000 },
	{ .addr = 0x00f1016a54, .val = 0x00000000 },
	{ .addr = 0x00f1016a58, .val = 0x00000000 },
	{ .addr = 0x00f1016a5c, .val = 0x00000000 },
	{ .addr = 0x00f1016a60, .val = 0x00000000 },
	{ .addr = 0x00f1016a64, .val = 0x00000000 },
	{ .addr = 0x00f1016a68, .val = 0x00000000 },
	{ .addr = 0x00f1016a6c, .val = 0x00000000 },
	{ .addr = 0x00f1016a70, .val = 0x00000000 },
	{ .addr = 0x00f1016a74, .val = 0x00000000 },
	{ .addr = 0x00f1016a78, .val = 0x00000000 },
	{ .addr = 0x00f1016a7c, .val = 0x00000000 },
	{ .addr = 0x00f1016a80, .val = 0x00000000 },
	{ .addr = 0x00f1016a84, .val = 0x00000000 },
	{ .addr = 0x00f1016a88, .val = 0x00000000 },
	{ .addr = 0x00f1016a8c, .val = 0x00000000 },
	{ .addr = 0x00f1016a90, .val = 0x00000000 },
	{ .addr = 0x00f1016a94, .val = 0x00000000 },
	{ .addr = 0x00f1016a98, .val = 0x00000000 },
	{ .addr = 0x00f1016a9c, .val = 0x00000000 },
	{ .addr = 0x00f1016aa0, .val = 0x00000000 },
	{ .addr = 0x00f1016aa4, .val = 0x00000000 },
	{ .addr = 0x00f1016aa8, .val = 0x00000000 },
	{ .addr = 0x00f1016aac, .val = 0x00000000 },
	{ .addr = 0x00f1016ab0, .val = 0x00000000 },
	{ .addr = 0x00f1016ab4, .val = 0x00000000 },
	{ .addr = 0x00f1016ab8, .val = 0x00000000 },
	{ .addr = 0x00f1016abc, .val = 0x00000000 },
	{ .addr = 0x00f1016ac0, .val = 0x00000000 },
	{ .addr = 0x00f1016ac4, .val = 0x00000000 },
	{ .addr = 0x00f1016ac8, .val = 0x00000000 },
	{ .addr = 0x00f1016acc, .val = 0x00000000 },
	{ .addr = 0x00f1016ad0, .val = 0x00000000 },
	{ .addr = 0x00f1016ad4, .val = 0x00000000 },
	{ .addr = 0x00f1016ad8, .val = 0x00000000 },
	{ .addr = 0x00f1016adc, .val = 0x00000000 },
	{ .addr = 0x00f1016ae0, .val = 0x00000000 },
	{ .addr = 0x00f1016ae4, .val = 0x00000000 },
	{ .addr = 0x00f1016ae8, .val = 0x00000000 },
	{ .addr = 0x00f1016aec, .val = 0x00000000 },
	{ .addr = 0x00f1016af0, .val = 0x00000000 },
	{ .addr = 0x00f1016af4, .val = 0x00000000 },
	{ .addr = 0x00f1016af8, .val = 0x00000000 },
	{ .addr = 0x00f1016afc, .val = 0x00000000 },
	{ .addr = 0x00f1016b00, .val = 0x00000000 },
	{ .addr = 0x00f1016b04, .val = 0x00000000 },
	{ .addr = 0x00f1016b08, .val = 0x00000000 },
	{ .addr = 0x00f1016b0c, .val = 0x00000000 },
	{ .addr = 0x00f1016b10, .val = 0x00000000 },
	{ .addr = 0x00f1016b14, .val = 0x00000000 },
	{ .addr = 0x00f1016b18, .val = 0x00000000 },
	{ .addr = 0x00f1016b1c, .val = 0x00000000 },
	{ .addr = 0x00f1016b20, .val = 0x00000000 },
	{ .addr = 0x00f1016b24, .val = 0x00000000 },
	{ .addr = 0x00f1016b28, .val = 0x00000000 },
	{ .addr = 0x00f1016b2c, .val = 0x00000000 },
	{ .addr = 0x00f1016b30, .val = 0x00000000 },
	{ .addr = 0x00f1016b34, .val = 0x00000000 },
	{ .addr = 0x00f1016b38, .val = 0x00000000 },
	{ .addr = 0x00f1016b3c, .val = 0x00000000 },
	{ .addr = 0x00f1016b40, .val = 0x00000000 },
	{ .addr = 0x00f1016b44, .val = 0x00000000 },
	{ .addr = 0x00f1016b48, .val = 0x00000000 },
	{ .addr = 0x00f1016b4c, .val = 0x00000000 },
	{ .addr = 0x00f1016b50, .val = 0x00000000 },
	{ .addr = 0x00f1016b54, .val = 0x00000000 },
	{ .addr = 0x00f1016b58, .val = 0x00000000 },
	{ .addr = 0x00f1016b5c, .val = 0x00000000 },
	{ .addr = 0x00f1016b60, .val = 0x00000000 },
	{ .addr = 0x00f1016b64, .val = 0x00000000 },
	{ .addr = 0x00f1016b68, .val = 0x00000000 },
	{ .addr = 0x00f1016b6c, .val = 0x00000000 },
	{ .addr = 0x00f1016b70, .val = 0x00000000 },
	{ .addr = 0x00f1016b74, .val = 0x00000000 },
	{ .addr = 0x00f1016b78, .val = 0x00000000 },
	{ .addr = 0x00f1016b7c, .val = 0x00000000 },
	{ .addr = 0x00f1016b80, .val = 0x00000000 },
	{ .addr = 0x00f1016b84, .val = 0x00000000 },
	{ .addr = 0x00f1016b88, .val = 0x00000000 },
	{ .addr = 0x00f1016b8c, .val = 0x00000000 },
	{ .addr = 0x00f1016b90, .val = 0x00000000 },
	{ .addr = 0x00f1016b94, .val = 0x00000000 },
	{ .addr = 0x00f1016b98, .val = 0x00000000 },
	{ .addr = 0x00f1016b9c, .val = 0x00000000 },
	{ .addr = 0x00f1016ba0, .val = 0x00000000 },
	{ .addr = 0x00f1016ba4, .val = 0x00000000 },
	{ .addr = 0x00f1016ba8, .val = 0x00000000 },
	{ .addr = 0x00f1016bac, .val = 0x00000000 },
	{ .addr = 0x00f1016bb0, .val = 0x00000000 },
	{ .addr = 0x00f1016bb4, .val = 0x00000000 },
	{ .addr = 0x00f1016bb8, .val = 0x00000000 },
	{ .addr = 0x00f1016bbc, .val = 0x00000000 },
	{ .addr = 0x00f1016bc0, .val = 0x00000000 },
	{ .addr = 0x00f1016bc4, .val = 0x00000000 },
	{ .addr = 0x00f1016bc8, .val = 0x00000000 },
	{ .addr = 0x00f1016bcc, .val = 0x00000000 },
	{ .addr = 0x00f1016bd0, .val = 0x00000000 },
	{ .addr = 0x00f1016bd4, .val = 0x00000000 },
	{ .addr = 0x00f1016bd8, .val = 0x00000000 },
	{ .addr = 0x00f1016bdc, .val = 0x00000000 },
	{ .addr = 0x00f1016be0, .val = 0x00000000 },
	{ .addr = 0x00f1016be4, .val = 0x00000000 },
	{ .addr = 0x00f1016be8, .val = 0x00000000 },
	{ .addr = 0x00f1016bec, .val = 0x00000000 },
	{ .addr = 0x00f1016bf0, .val = 0x00000000 },
	{ .addr = 0x00f1016bf4, .val = 0x00000000 },
	{ .addr = 0x00f1016bf8, .val = 0x00000000 },
	{ .addr = 0x00f1016bfc, .val = 0x00000000 },
	{ .addr = 0x00f1016c00, .val = 0x00000000 },
	{ .addr = 0x00f1016c04, .val = 0x00000000 },
	{ .addr = 0x00f1016c08, .val = 0x00000000 },
	{ .addr = 0x00f1016c0c, .val = 0x00000000 },
	{ .addr = 0x00f1016c10, .val = 0x00000000 },
	{ .addr = 0x00f1016c14, .val = 0x00000000 },
	{ .addr = 0x00f1016c18, .val = 0x00000000 },
	{ .addr = 0x00f1016c1c, .val = 0x00000000 },
	{ .addr = 0x00f1016c20, .val = 0x00000000 },
	{ .addr = 0x00f1016c24, .val = 0x00000000 },
	{ .addr = 0x00f1016c28, .val = 0x00000000 },
	{ .addr = 0x00f1016c2c, .val = 0x00000000 },
	{ .addr = 0x00f1016c30, .val = 0x00000000 },
	{ .addr = 0x00f1016c34, .val = 0x00000000 },
	{ .addr = 0x00f1016c38, .val = 0x00000000 },
	{ .addr = 0x00f1016c3c, .val = 0x00000000 },
	{ .addr = 0x00f1016c40, .val = 0x00000000 },
	{ .addr = 0x00f1016c44, .val = 0x00000000 },
	{ .addr = 0x00f1016c48, .val = 0x00000000 },
	{ .addr = 0x00f1016c4c, .val = 0x00000000 },
	{ .addr = 0x00f1016c50, .val = 0x00000000 },
	{ .addr = 0x00f1016c54, .val = 0x00000000 },
	{ .addr = 0x00f1016c58, .val = 0x00000000 },
	{ .addr = 0x00f1016c5c, .val = 0x00000000 },
	{ .addr = 0x00f1016c60, .val = 0x00000000 },
	{ .addr = 0x00f1016c64, .val = 0x00000000 },
	{ .addr = 0x00f1016c68, .val = 0x00000000 },
	{ .addr = 0x00f1016c6c, .val = 0x00000000 },
	{ .addr = 0x00f1016c70, .val = 0x00000000 },
	{ .addr = 0x00f1016c74, .val = 0x00000000 },
	{ .addr = 0x00f1016c78, .val = 0x00000000 },
	{ .addr = 0x00f1016c7c, .val = 0x00000000 },
	{ .addr = 0x00f1016c80, .val = 0x00000000 },
	{ .addr = 0x00f1016c84, .val = 0x00000000 },
	{ .addr = 0x00f1016c88, .val = 0x00000000 },
	{ .addr = 0x00f1016c8c, .val = 0x00000000 },
	{ .addr = 0x00f1016c90, .val = 0x00000000 },
	{ .addr = 0x00f1016c94, .val = 0x00000000 },
	{ .addr = 0x00f1016c98, .val = 0x00000000 },
	{ .addr = 0x00f1016c9c, .val = 0x00000000 },
	{ .addr = 0x00f1016ca0, .val = 0x00000000 },
	{ .addr = 0x00f1016ca4, .val = 0x00000000 },
	{ .addr = 0x00f1016ca8, .val = 0x00000000 },
	{ .addr = 0x00f1016cac, .val = 0x00000000 },
	{ .addr = 0x00f1016cb0, .val = 0x00000000 },
	{ .addr = 0x00f1016cb4, .val = 0x00000000 },
	{ .addr = 0x00f1016cb8, .val = 0x00000000 },
	{ .addr = 0x00f1016cbc, .val = 0x00000000 },
	{ .addr = 0x00f1016cc0, .val = 0x00000000 },
	{ .addr = 0x00f1016cc4, .val = 0x00000000 },
	{ .addr = 0x00f1016cc8, .val = 0x00000000 },
	{ .addr = 0x00f1016ccc, .val = 0x00000000 },
	{ .addr = 0x00f1016cd0, .val = 0x00000000 },
	{ .addr = 0x00f1016cd4, .val = 0x00000000 },
	{ .addr = 0x00f1016cd8, .val = 0x00000000 },
	{ .addr = 0x00f1016cdc, .val = 0x00000000 },
	{ .addr = 0x00f1016ce0, .val = 0x00000000 },
	{ .addr = 0x00f1016ce4, .val = 0x00000000 },
	{ .addr = 0x00f1016ce8, .val = 0x00000000 },
	{ .addr = 0x00f1016cec, .val = 0x00000000 },
	{ .addr = 0x00f1016cf0, .val = 0x00000000 },
	{ .addr = 0x00f1016cf4, .val = 0x00000000 },
	{ .addr = 0x00f1016cf8, .val = 0x00000000 },
	{ .addr = 0x00f1016cfc, .val = 0x00000000 },
	{ .addr = 0x00f1016d00, .val = 0x00000000 },
	{ .addr = 0x00f1016d04, .val = 0x00000000 },
	{ .addr = 0x00f1016d08, .val = 0x00000000 },
	{ .addr = 0x00f1016d0c, .val = 0x00000000 },
	{ .addr = 0x00f1016d10, .val = 0x00000000 },
	{ .addr = 0x00f1016d14, .val = 0x00000000 },
	{ .addr = 0x00f1016d18, .val = 0x00000000 },
	{ .addr = 0x00f1016d1c, .val = 0x00000000 },
	{ .addr = 0x00f1016d20, .val = 0x00000000 },
	{ .addr = 0x00f1016d24, .val = 0x00000000 },
	{ .addr = 0x00f1016d28, .val = 0x00000000 },
	{ .addr = 0x00f1016d2c, .val = 0x00000000 },
	{ .addr = 0x00f1016d30, .val = 0x00000000 },
	{ .addr = 0x00f1016d34, .val = 0x00000000 },
	{ .addr = 0x00f1016d38, .val = 0x00000000 },
	{ .addr = 0x00f1016d3c, .val = 0x00000000 },
	{ .addr = 0x00f1016d40, .val = 0x00000000 },
	{ .addr = 0x00f1016d44, .val = 0x00000000 },
	{ .addr = 0x00f1016d48, .val = 0x00000000 },
	{ .addr = 0x00f1016d4c, .val = 0x00000000 },
	{ .addr = 0x00f1016d50, .val = 0x00000000 },
	{ .addr = 0x00f1016d54, .val = 0x00000000 },
	{ .addr = 0x00f1016d58, .val = 0x00000000 },
	{ .addr = 0x00f1016d5c, .val = 0x00000000 },
	{ .addr = 0x00f1016d60, .val = 0x00000000 },
	{ .addr = 0x00f1016d64, .val = 0x00000000 },
	{ .addr = 0x00f1016d68, .val = 0x00000000 },
	{ .addr = 0x00f1016d6c, .val = 0x00000000 },
	{ .addr = 0x00f1016d70, .val = 0x00000000 },
	{ .addr = 0x00f1016d74, .val = 0x00000000 },
	{ .addr = 0x00f1016d78, .val = 0x00000000 },
	{ .addr = 0x00f1016d7c, .val = 0x00000000 },
	{ .addr = 0x00f1016d80, .val = 0x00000000 },
	{ .addr = 0x00f1016d84, .val = 0x00000000 },
	{ .addr = 0x00f1016d88, .val = 0x00000000 },
	{ .addr = 0x00f1016d8c, .val = 0x00000000 },
	{ .addr = 0x00f1016d90, .val = 0x00000000 },
	{ .addr = 0x00f1016d94, .val = 0x00000000 },
	{ .addr = 0x00f1016d98, .val = 0x00000000 },
	{ .addr = 0x00f1016d9c, .val = 0x00000000 },
	{ .addr = 0x00f1016da0, .val = 0x00000000 },
	{ .addr = 0x00f1016da4, .val = 0x00000000 },
	{ .addr = 0x00f1016da8, .val = 0x00000000 },
	{ .addr = 0x00f1016dac, .val = 0x00000000 },
	{ .addr = 0x00f1016db0, .val = 0x00000000 },
	{ .addr = 0x00f1016db4, .val = 0x00000000 },
	{ .addr = 0x00f1016db8, .val = 0x00000000 },
	{ .addr = 0x00f1016dbc, .val = 0x00000000 },
	{ .addr = 0x00f1016dc0, .val = 0x00000000 },
	{ .addr = 0x00f1016dc4, .val = 0x00000000 },
	{ .addr = 0x00f1016dc8, .val = 0x00000000 },
	{ .addr = 0x00f1016dcc, .val = 0x00000000 },
	{ .addr = 0x00f1016dd0, .val = 0x00000000 },
	{ .addr = 0x00f1016dd4, .val = 0x00000000 },
	{ .addr = 0x00f1016dd8, .val = 0x00000000 },
	{ .addr = 0x00f1016ddc, .val = 0x00000000 },
	{ .addr = 0x00f1016de0, .val = 0x00000000 },
	{ .addr = 0x00f1016de4, .val = 0x00000000 },
	{ .addr = 0x00f1016de8, .val = 0x00000000 },
	{ .addr = 0x00f1016dec, .val = 0x00000000 },
	{ .addr = 0x00f1016df0, .val = 0x00000000 },
	{ .addr = 0x00f1016df4, .val = 0x00000000 },
	{ .addr = 0x00f1016df8, .val = 0x00000000 },
	{ .addr = 0x00f1016dfc, .val = 0x00000000 },
	{ .addr = 0x00f1016e00, .val = 0x00000000 },
	{ .addr = 0x00f1016e04, .val = 0x00000000 },
	{ .addr = 0x00f1016e08, .val = 0x00000000 },
	{ .addr = 0x00f1016e0c, .val = 0x00000000 },
	{ .addr = 0x00f1016e10, .val = 0x00000000 },
	{ .addr = 0x00f1016e14, .val = 0x00000000 },
	{ .addr = 0x00f1016e18, .val = 0x00000000 },
	{ .addr = 0x00f1016e1c, .val = 0x00000000 },
	{ .addr = 0x00f1016e20, .val = 0x00000000 },
	{ .addr = 0x00f1016e24, .val = 0x00000000 },
	{ .addr = 0x00f1016e28, .val = 0x00000000 },
	{ .addr = 0x00f1016e2c, .val = 0x00000000 },
	{ .addr = 0x00f1016e30, .val = 0x00000000 },
	{ .addr = 0x00f1016e34, .val = 0x00000000 },
	{ .addr = 0x00f1016e38, .val = 0x00000000 },
	{ .addr = 0x00f1016e3c, .val = 0x00000000 },
	{ .addr = 0x00f1016e40, .val = 0x00000000 },
	{ .addr = 0x00f1016e44, .val = 0x00000000 },
	{ .addr = 0x00f1016e48, .val = 0x00000000 },
	{ .addr = 0x00f1016e4c, .val = 0x00000000 },
	{ .addr = 0x00f1016e50, .val = 0x00000000 },
	{ .addr = 0x00f1016e54, .val = 0x00000000 },
	{ .addr = 0x00f1016e58, .val = 0x00000000 },
	{ .addr = 0x00f1016e5c, .val = 0x00000000 },
	{ .addr = 0x00f1016e60, .val = 0x00000000 },
	{ .addr = 0x00f1016e64, .val = 0x00000000 },
	{ .addr = 0x00f1016e68, .val = 0x00000000 },
	{ .addr = 0x00f1016e6c, .val = 0x00000000 },
	{ .addr = 0x00f1016e70, .val = 0x00000000 },
	{ .addr = 0x00f1016e74, .val = 0x00000000 },
	{ .addr = 0x00f1016e78, .val = 0x00000000 },
	{ .addr = 0x00f1016e7c, .val = 0x00000000 },
	{ .addr = 0x00f1016e80, .val = 0x00000000 },
	{ .addr = 0x00f1016e84, .val = 0x00000000 },
	{ .addr = 0x00f1016e88, .val = 0x00000000 },
	{ .addr = 0x00f1016e8c, .val = 0x00000000 },
	{ .addr = 0x00f1016e90, .val = 0x00000000 },
	{ .addr = 0x00f1016e94, .val = 0x00000000 },
	{ .addr = 0x00f1016e98, .val = 0x00000000 },
	{ .addr = 0x00f1016e9c, .val = 0x00000000 },
	{ .addr = 0x00f1016ea0, .val = 0x00000000 },
	{ .addr = 0x00f1016ea4, .val = 0x00000000 },
	{ .addr = 0x00f1016ea8, .val = 0x00000000 },
	{ .addr = 0x00f1016eac, .val = 0x00000000 },
	{ .addr = 0x00f1016eb0, .val = 0x00000000 },
	{ .addr = 0x00f1016eb4, .val = 0x00000000 },
	{ .addr = 0x00f1016eb8, .val = 0x00000000 },
	{ .addr = 0x00f1016ebc, .val = 0x00000000 },
	{ .addr = 0x00f1016ec0, .val = 0x00000000 },
	{ .addr = 0x00f1016ec4, .val = 0x00000000 },
	{ .addr = 0x00f1016ec8, .val = 0x00000000 },
	{ .addr = 0x00f1016ecc, .val = 0x00000000 },
	{ .addr = 0x00f1016ed0, .val = 0x00000000 },
	{ .addr = 0x00f1016ed4, .val = 0x00000000 },
	{ .addr = 0x00f1016ed8, .val = 0x00000000 },
	{ .addr = 0x00f1016edc, .val = 0x00000000 },
	{ .addr = 0x00f1016ee0, .val = 0x00000000 },
	{ .addr = 0x00f1016ee4, .val = 0x00000000 },
	{ .addr = 0x00f1016ee8, .val = 0x00000000 },
	{ .addr = 0x00f1016eec, .val = 0x00000000 },
	{ .addr = 0x00f1016ef0, .val = 0x00000000 },
	{ .addr = 0x00f1016ef4, .val = 0x00000000 },
	{ .addr = 0x00f1016ef8, .val = 0x00000000 },
	{ .addr = 0x00f1016efc, .val = 0x00000000 },
	{ .addr = 0x00f1016f00, .val = 0x00000000 },
	{ .addr = 0x00f1016f04, .val = 0x00000000 },
	{ .addr = 0x00f1016f08, .val = 0x00000000 },
	{ .addr = 0x00f1016f0c, .val = 0x00000000 },
	{ .addr = 0x00f1016f10, .val = 0x00000000 },
	{ .addr = 0x00f1016f14, .val = 0x00000000 },
	{ .addr = 0x00f1016f18, .val = 0x00000000 },
	{ .addr = 0x00f1016f1c, .val = 0x00000000 },
	{ .addr = 0x00f1016f20, .val = 0x00000000 },
	{ .addr = 0x00f1016f24, .val = 0x00000000 },
	{ .addr = 0x00f1016f28, .val = 0x00000000 },
	{ .addr = 0x00f1016f2c, .val = 0x00000000 },
	{ .addr = 0x00f1016f30, .val = 0x00000000 },
	{ .addr = 0x00f1016f34, .val = 0x00000000 },
	{ .addr = 0x00f1016f38, .val = 0x00000000 },
	{ .addr = 0x00f1016f3c, .val = 0x00000000 },
	{ .addr = 0x00f1016f40, .val = 0x00000000 },
	{ .addr = 0x00f1016f44, .val = 0x00000000 },
	{ .addr = 0x00f1016f48, .val = 0x00000000 },
	{ .addr = 0x00f1016f4c, .val = 0x00000000 },
	{ .addr = 0x00f1016f50, .val = 0x00000000 },
	{ .addr = 0x00f1016f54, .val = 0x00000000 },
	{ .addr = 0x00f1016f58, .val = 0x00000000 },
	{ .addr = 0x00f1016f5c, .val = 0x00000000 },
	{ .addr = 0x00f1016f60, .val = 0x00000000 },
	{ .addr = 0x00f1016f64, .val = 0x00000000 },
	{ .addr = 0x00f1016f68, .val = 0x00000000 },
	{ .addr = 0x00f1016f6c, .val = 0x00000000 },
	{ .addr = 0x00f1016f70, .val = 0x00000000 },
	{ .addr = 0x00f1016f74, .val = 0x00000000 },
	{ .addr = 0x00f1016f78, .val = 0x00000000 },
	{ .addr = 0x00f1016f7c, .val = 0x00000000 },
	{ .addr = 0x00f1016f80, .val = 0x00000000 },
	{ .addr = 0x00f1016f84, .val = 0x00000000 },
	{ .addr = 0x00f1016f88, .val = 0x00000000 },
	{ .addr = 0x00f1016f8c, .val = 0x00000000 },
	{ .addr = 0x00f1016f90, .val = 0x00000000 },
	{ .addr = 0x00f1016f94, .val = 0x00000000 },
	{ .addr = 0x00f1016f98, .val = 0x00000000 },
	{ .addr = 0x00f1016f9c, .val = 0x00000000 },
	{ .addr = 0x00f1016fa0, .val = 0x00000000 },
	{ .addr = 0x00f1016fa4, .val = 0x00000000 },
	{ .addr = 0x00f1016fa8, .val = 0x00000000 },
	{ .addr = 0x00f1016fac, .val = 0x00000000 },
	{ .addr = 0x00f1016fb0, .val = 0x00000000 },
	{ .addr = 0x00f1016fb4, .val = 0x00000000 },
	{ .addr = 0x00f1016fb8, .val = 0x00000000 },
	{ .addr = 0x00f1016fbc, .val = 0x00000000 },
	{ .addr = 0x00f1016fc0, .val = 0x00000000 },
	{ .addr = 0x00f1016fc4, .val = 0x00000000 },
	{ .addr = 0x00f1016fc8, .val = 0x00000000 },
	{ .addr = 0x00f1016fcc, .val = 0x00000000 },
	{ .addr = 0x00f1016fd0, .val = 0x00000000 },
	{ .addr = 0x00f1016fd4, .val = 0x00000000 },
	{ .addr = 0x00f1016fd8, .val = 0x00000000 },
	{ .addr = 0x00f1016fdc, .val = 0x00000000 },
	{ .addr = 0x00f1016fe0, .val = 0x00000000 },
	{ .addr = 0x00f1016fe4, .val = 0x00000000 },
	{ .addr = 0x00f1016fe8, .val = 0x00000000 },
	{ .addr = 0x00f1016fec, .val = 0x00000000 },
	{ .addr = 0x00f1016ff0, .val = 0x00000000 },
	{ .addr = 0x00f1016ff4, .val = 0x00000000 },
	{ .addr = 0x00f1016ff8, .val = 0x00000000 },
	{ .addr = 0x00f1016ffc, .val = 0x00000000 },
	{ .addr = 0x00f1017000, .val = 0x00000000 },
	{ .addr = 0x00f1017004, .val = 0x00000000 },
	{ .addr = 0x00f1017008, .val = 0x00000000 },
	{ .addr = 0x00f101700c, .val = 0x00000000 },
	{ .addr = 0x00f1017010, .val = 0x00000000 },
	{ .addr = 0x00f1017014, .val = 0x00000000 },
	{ .addr = 0x00f1017018, .val = 0x00000000 },
	{ .addr = 0x00f101701c, .val = 0x00000000 },
	{ .addr = 0x00f1017020, .val = 0x00000000 },
	{ .addr = 0x00f1017024, .val = 0x00000000 },
	{ .addr = 0x00f1017028, .val = 0x00000000 },
	{ .addr = 0x00f101702c, .val = 0x00000000 },
	{ .addr = 0x00f1017030, .val = 0x00000000 },
	{ .addr = 0x00f1017034, .val = 0x00000000 },
	{ .addr = 0x00f1017038, .val = 0x00000000 },
	{ .addr = 0x00f101703c, .val = 0x00000000 },
	{ .addr = 0x00f1017040, .val = 0x00000000 },
	{ .addr = 0x00f1017044, .val = 0x00000000 },
	{ .addr = 0x00f1017048, .val = 0x00000000 },
	{ .addr = 0x00f101704c, .val = 0x00000000 },
	{ .addr = 0x00f1017050, .val = 0x00000000 },
	{ .addr = 0x00f1017054, .val = 0x00000000 },
	{ .addr = 0x00f1017058, .val = 0x00000000 },
	{ .addr = 0x00f101705c, .val = 0x00000000 },
	{ .addr = 0x00f1017060, .val = 0x00000000 },
	{ .addr = 0x00f1017064, .val = 0x00000000 },
	{ .addr = 0x00f1017068, .val = 0x00000000 },
	{ .addr = 0x00f101706c, .val = 0x00000000 },
	{ .addr = 0x00f1017070, .val = 0x00000000 },
	{ .addr = 0x00f1017074, .val = 0x00000000 },
	{ .addr = 0x00f1017078, .val = 0x00000000 },
	{ .addr = 0x00f101707c, .val = 0x00000000 },
	{ .addr = 0x00f1017080, .val = 0x00000000 },
	{ .addr = 0x00f1017084, .val = 0x00000000 },
	{ .addr = 0x00f1017088, .val = 0x00000000 },
	{ .addr = 0x00f101708c, .val = 0x00000000 },
	{ .addr = 0x00f1017090, .val = 0x00000000 },
	{ .addr = 0x00f1017094, .val = 0x00000000 },
	{ .addr = 0x00f1017098, .val = 0x00000000 },
	{ .addr = 0x00f101709c, .val = 0x00000000 },
	{ .addr = 0x00f10170a0, .val = 0x00000000 },
	{ .addr = 0x00f10170a4, .val = 0x00000000 },
	{ .addr = 0x00f10170a8, .val = 0x00000000 },
	{ .addr = 0x00f10170ac, .val = 0x00000000 },
	{ .addr = 0x00f10170b0, .val = 0x00000000 },
	{ .addr = 0x00f10170b4, .val = 0x00000000 },
	{ .addr = 0x00f10170b8, .val = 0x00000000 },
	{ .addr = 0x00f10170bc, .val = 0x00000000 },
	{ .addr = 0x00f10170c0, .val = 0x00000000 },
	{ .addr = 0x00f10170c4, .val = 0x00000000 },
	{ .addr = 0x00f10170c8, .val = 0x00000000 },
	{ .addr = 0x00f10170cc, .val = 0x00000000 },
	{ .addr = 0x00f10170d0, .val = 0x00000000 },
	{ .addr = 0x00f10170d4, .val = 0x00000000 },
	{ .addr = 0x00f10170d8, .val = 0x00000000 },
	{ .addr = 0x00f10170dc, .val = 0x00000000 },
	{ .addr = 0x00f10170e0, .val = 0x00000000 },
	{ .addr = 0x00f10170e4, .val = 0x00000000 },
	{ .addr = 0x00f10170e8, .val = 0x00000000 },
	{ .addr = 0x00f10170ec, .val = 0x00000000 },
	{ .addr = 0x00f10170f0, .val = 0x00000000 },
	{ .addr = 0x00f10170f4, .val = 0x00000000 },
	{ .addr = 0x00f10170f8, .val = 0x00000000 },
	{ .addr = 0x00f10170fc, .val = 0x00000000 },
	{ .addr = 0x00f1017100, .val = 0x00000000 },
	{ .addr = 0x00f1017104, .val = 0x00000000 },
	{ .addr = 0x00f1017108, .val = 0x00000000 },
	{ .addr = 0x00f101710c, .val = 0x00000000 },
	{ .addr = 0x00f1017110, .val = 0x00000000 },
	{ .addr = 0x00f1017114, .val = 0x00000000 },
	{ .addr = 0x00f1017118, .val = 0x00000000 },
	{ .addr = 0x00f101711c, .val = 0x00000000 },
	{ .addr = 0x00f1017120, .val = 0x00000000 },
	{ .addr = 0x00f1017124, .val = 0x00000000 },
	{ .addr = 0x00f1017128, .val = 0x00000000 },
	{ .addr = 0x00f101712c, .val = 0x00000000 },
	{ .addr = 0x00f1017130, .val = 0x00000000 },
	{ .addr = 0x00f1017134, .val = 0x00000000 },
	{ .addr = 0x00f1017138, .val = 0x00000000 },
	{ .addr = 0x00f101713c, .val = 0x00000000 },
	{ .addr = 0x00f1017140, .val = 0x00000000 },
	{ .addr = 0x00f1017144, .val = 0x00000000 },
	{ .addr = 0x00f1017148, .val = 0x00000000 },
	{ .addr = 0x00f101714c, .val = 0x00000000 },
	{ .addr = 0x00f1017150, .val = 0x00000000 },
	{ .addr = 0x00f1017154, .val = 0x00000000 },
	{ .addr = 0x00f1017158, .val = 0x00000000 },
	{ .addr = 0x00f101715c, .val = 0x00000000 },
	{ .addr = 0x00f1017160, .val = 0x00000000 },
	{ .addr = 0x00f1017164, .val = 0x00000000 },
	{ .addr = 0x00f1017168, .val = 0x00000000 },
	{ .addr = 0x00f101716c, .val = 0x00000000 },
	{ .addr = 0x00f1017170, .val = 0x00000000 },
	{ .addr = 0x00f1017174, .val = 0x00000000 },
	{ .addr = 0x00f1017178, .val = 0x00000000 },
	{ .addr = 0x00f101717c, .val = 0x00000000 },
	{ .addr = 0x00f1017180, .val = 0x00000000 },
	{ .addr = 0x00f1017184, .val = 0x00000000 },
	{ .addr = 0x00f1017188, .val = 0x00000000 },
	{ .addr = 0x00f101718c, .val = 0x00000000 },
	{ .addr = 0x00f1017190, .val = 0x00000000 },
	{ .addr = 0x00f1017194, .val = 0x00000000 },
	{ .addr = 0x00f1017198, .val = 0x00000000 },
	{ .addr = 0x00f101719c, .val = 0x00000000 },
	{ .addr = 0x00f10171a0, .val = 0x00000000 },
	{ .addr = 0x00f10171a4, .val = 0x00000000 },
	{ .addr = 0x00f10171a8, .val = 0x00000000 },
	{ .addr = 0x00f10171ac, .val = 0x00000000 },
	{ .addr = 0x00f10171b0, .val = 0x00000000 },
	{ .addr = 0x00f10171b4, .val = 0x00000000 },
	{ .addr = 0x00f10171b8, .val = 0x00000000 },
	{ .addr = 0x00f10171bc, .val = 0x00000000 },
	{ .addr = 0x00f10171c0, .val = 0x00000000 },
	{ .addr = 0x00f10171c4, .val = 0x00000000 },
	{ .addr = 0x00f10171c8, .val = 0x00000000 },
	{ .addr = 0x00f10171cc, .val = 0x00000000 },
	{ .addr = 0x00f10171d0, .val = 0x00000000 },
	{ .addr = 0x00f10171d4, .val = 0x00000000 },
	{ .addr = 0x00f10171d8, .val = 0x00000000 },
	{ .addr = 0x00f10171dc, .val = 0x00000000 },
	{ .addr = 0x00f10171e0, .val = 0x00000000 },
	{ .addr = 0x00f10171e4, .val = 0x00000000 },
	{ .addr = 0x00f10171e8, .val = 0x00000000 },
	{ .addr = 0x00f10171ec, .val = 0x00000000 },
	{ .addr = 0x00f10171f0, .val = 0x00000000 },
	{ .addr = 0x00f10171f4, .val = 0x00000000 },
	{ .addr = 0x00f10171f8, .val = 0x00000000 },
	{ .addr = 0x00f10171fc, .val = 0x00000000 },
	{ .addr = 0x00f1017200, .val = 0x00000000 },
	{ .addr = 0x00f1017204, .val = 0x00000000 },
	{ .addr = 0x00f1017208, .val = 0x00000000 },
	{ .addr = 0x00f101720c, .val = 0x00000000 },
	{ .addr = 0x00f1017210, .val = 0x00000000 },
	{ .addr = 0x00f1017214, .val = 0x00000000 },
	{ .addr = 0x00f1017218, .val = 0x00000000 },
	{ .addr = 0x00f101721c, .val = 0x00000000 },
	{ .addr = 0x00f1017220, .val = 0x00000000 },
	{ .addr = 0x00f1017224, .val = 0x00000000 },
	{ .addr = 0x00f1017228, .val = 0x00000000 },
	{ .addr = 0x00f101722c, .val = 0x00000000 },
	{ .addr = 0x00f1017230, .val = 0x00000000 },
	{ .addr = 0x00f1017234, .val = 0x00000000 },
	{ .addr = 0x00f1017238, .val = 0x00000000 },
	{ .addr = 0x00f101723c, .val = 0x00000000 },
	{ .addr = 0x00f1017240, .val = 0x00000000 },
	{ .addr = 0x00f1017244, .val = 0x00000000 },
	{ .addr = 0x00f1017248, .val = 0x00000000 },
	{ .addr = 0x00f101724c, .val = 0x00000000 },
	{ .addr = 0x00f1017250, .val = 0x00000000 },
	{ .addr = 0x00f1017254, .val = 0x00000000 },
	{ .addr = 0x00f1017258, .val = 0x00000000 },
	{ .addr = 0x00f101725c, .val = 0x00000000 },
	{ .addr = 0x00f1017260, .val = 0x00000000 },
	{ .addr = 0x00f1017264, .val = 0x00000000 },
	{ .addr = 0x00f1017268, .val = 0x00000000 },
	{ .addr = 0x00f101726c, .val = 0x00000000 },
	{ .addr = 0x00f1017270, .val = 0x00000000 },
	{ .addr = 0x00f1017274, .val = 0x00000000 },
	{ .addr = 0x00f1017278, .val = 0x00000000 },
	{ .addr = 0x00f101727c, .val = 0x00000000 },
	{ .addr = 0x00f1017280, .val = 0x00000000 },
	{ .addr = 0x00f1017284, .val = 0x00000000 },
	{ .addr = 0x00f1017288, .val = 0x00000000 },
	{ .addr = 0x00f101728c, .val = 0x00000000 },
	{ .addr = 0x00f1017290, .val = 0x00000000 },
	{ .addr = 0x00f1017294, .val = 0x00000000 },
	{ .addr = 0x00f1017298, .val = 0x00000000 },
	{ .addr = 0x00f101729c, .val = 0x00000000 },
	{ .addr = 0x00f10172a0, .val = 0x00000000 },
	{ .addr = 0x00f10172a4, .val = 0x00000000 },
	{ .addr = 0x00f10172a8, .val = 0x00000000 },
	{ .addr = 0x00f10172ac, .val = 0x00000000 },
	{ .addr = 0x00f10172b0, .val = 0x00000000 },
	{ .addr = 0x00f10172b4, .val = 0x00000000 },
	{ .addr = 0x00f10172b8, .val = 0x00000000 },
	{ .addr = 0x00f10172bc, .val = 0x00000000 },
	{ .addr = 0x00f10172c0, .val = 0x00000000 },
	{ .addr = 0x00f10172c4, .val = 0x00000000 },
	{ .addr = 0x00f10172c8, .val = 0x00000000 },
	{ .addr = 0x00f10172cc, .val = 0x00000000 },
	{ .addr = 0x00f10172d0, .val = 0x00000000 },
	{ .addr = 0x00f10172d4, .val = 0x00000000 },
	{ .addr = 0x00f10172d8, .val = 0x00000000 },
	{ .addr = 0x00f10172dc, .val = 0x00000000 },
	{ .addr = 0x00f10172e0, .val = 0x00000000 },
	{ .addr = 0x00f10172e4, .val = 0x00000000 },
	{ .addr = 0x00f10172e8, .val = 0x00000000 },
	{ .addr = 0x00f10172ec, .val = 0x00000000 },
	{ .addr = 0x00f10172f0, .val = 0x00000000 },
	{ .addr = 0x00f10172f4, .val = 0x00000000 },
	{ .addr = 0x00f10172f8, .val = 0x00000000 },
	{ .addr = 0x00f10172fc, .val = 0x00000000 },
	{ .addr = 0x00f1017300, .val = 0x00000000 },
	{ .addr = 0x00f1017304, .val = 0x00000000 },
	{ .addr = 0x00f1017308, .val = 0x00000000 },
	{ .addr = 0x00f101730c, .val = 0x00000000 },
	{ .addr = 0x00f1017310, .val = 0x00000000 },
	{ .addr = 0x00f1017314, .val = 0x00000000 },
	{ .addr = 0x00f1017318, .val = 0x00000000 },
	{ .addr = 0x00f101731c, .val = 0x00000000 },
	{ .addr = 0x00f1017320, .val = 0x00000000 },
	{ .addr = 0x00f1017324, .val = 0x00000000 },
	{ .addr = 0x00f1017328, .val = 0x00000000 },
	{ .addr = 0x00f101732c, .val = 0x00000000 },
	{ .addr = 0x00f1017330, .val = 0x00000000 },
	{ .addr = 0x00f1017334, .val = 0x00000000 },
	{ .addr = 0x00f1017338, .val = 0x00000000 },
	{ .addr = 0x00f101733c, .val = 0x00000000 },
	{ .addr = 0x00f1017340, .val = 0x00000000 },
	{ .addr = 0x00f1017344, .val = 0x00000000 },
	{ .addr = 0x00f1017348, .val = 0x00000000 },
	{ .addr = 0x00f101734c, .val = 0x00000000 },
	{ .addr = 0x00f1017350, .val = 0x00000000 },
	{ .addr = 0x00f1017354, .val = 0x00000000 },
	{ .addr = 0x00f1017358, .val = 0x00000000 },
	{ .addr = 0x00f101735c, .val = 0x00000000 },
	{ .addr = 0x00f1017360, .val = 0x00000000 },
	{ .addr = 0x00f1017364, .val = 0x00000000 },
	{ .addr = 0x00f1017368, .val = 0x00000000 },
	{ .addr = 0x00f101736c, .val = 0x00000000 },
	{ .addr = 0x00f1017370, .val = 0x00000000 },
	{ .addr = 0x00f1017374, .val = 0x00000000 },
	{ .addr = 0x00f1017378, .val = 0x00000000 },
	{ .addr = 0x00f101737c, .val = 0x00000000 },
	{ .addr = 0x00f1017380, .val = 0x00000000 },
	{ .addr = 0x00f1017384, .val = 0x00000000 },
	{ .addr = 0x00f1017388, .val = 0x00000000 },
	{ .addr = 0x00f101738c, .val = 0x00000000 },
	{ .addr = 0x00f1017390, .val = 0x00000000 },
	{ .addr = 0x00f1017394, .val = 0x00000000 },
	{ .addr = 0x00f1017398, .val = 0x00000000 },
	{ .addr = 0x00f101739c, .val = 0x00000000 },
	{ .addr = 0x00f10173a0, .val = 0x00000000 },
	{ .addr = 0x00f10173a4, .val = 0x00000000 },
	{ .addr = 0x00f10173a8, .val = 0x00000000 },
	{ .addr = 0x00f10173ac, .val = 0x00000000 },
	{ .addr = 0x00f10173b0, .val = 0x00000000 },
	{ .addr = 0x00f10173b4, .val = 0x00000000 },
	{ .addr = 0x00f10173b8, .val = 0x00000000 },
	{ .addr = 0x00f10173bc, .val = 0x00000000 },
	{ .addr = 0x00f10173c0, .val = 0x00000000 },
	{ .addr = 0x00f10173c4, .val = 0x00000000 },
	{ .addr = 0x00f10173c8, .val = 0x00000000 },
	{ .addr = 0x00f10173cc, .val = 0x00000000 },
	{ .addr = 0x00f10173d0, .val = 0x00000000 },
	{ .addr = 0x00f10173d4, .val = 0x00000000 },
	{ .addr = 0x00f10173d8, .val = 0x00000000 },
	{ .addr = 0x00f10173dc, .val = 0x00000000 },
	{ .addr = 0x00f10173e0, .val = 0x00000000 },
	{ .addr = 0x00f10173e4, .val = 0x00000000 },
	{ .addr = 0x00f10173e8, .val = 0x00000000 },
	{ .addr = 0x00f10173ec, .val = 0x00000000 },
	{ .addr = 0x00f10173f0, .val = 0x00000000 },
	{ .addr = 0x00f10173f4, .val = 0x00000000 },
	{ .addr = 0x00f10173f8, .val = 0x00000000 },
	{ .addr = 0x00f10173fc, .val = 0x00000000 },
	{ .addr = 0x00f1017400, .val = 0x00000000 },
	{ .addr = 0x00f1017404, .val = 0x00000000 },
	{ .addr = 0x00f1017408, .val = 0x00000000 },
	{ .addr = 0x00f101740c, .val = 0x00000000 },
	{ .addr = 0x00f1017410, .val = 0x00000000 },
	{ .addr = 0x00f1017414, .val = 0x00000000 },
	{ .addr = 0x00f1017418, .val = 0x00000000 },
	{ .addr = 0x00f101741c, .val = 0x00000000 },
	{ .addr = 0x00f1017420, .val = 0x00000000 },
	{ .addr = 0x00f1017424, .val = 0x00000000 },
	{ .addr = 0x00f1017428, .val = 0x00000000 },
	{ .addr = 0x00f101742c, .val = 0x00000000 },
	{ .addr = 0x00f1017430, .val = 0x00000000 },
	{ .addr = 0x00f1017434, .val = 0x00000000 },
	{ .addr = 0x00f1017438, .val = 0x00000000 },
	{ .addr = 0x00f101743c, .val = 0x00000000 },
	{ .addr = 0x00f1017440, .val = 0x00000000 },
	{ .addr = 0x00f1017444, .val = 0x00000000 },
	{ .addr = 0x00f1017448, .val = 0x00000000 },
	{ .addr = 0x00f101744c, .val = 0x00000000 },
	{ .addr = 0x00f1017450, .val = 0x00000000 },
	{ .addr = 0x00f1017454, .val = 0x00000000 },
	{ .addr = 0x00f1017458, .val = 0x00000000 },
	{ .addr = 0x00f101745c, .val = 0x00000000 },
	{ .addr = 0x00f1017460, .val = 0x00000000 },
	{ .addr = 0x00f1017464, .val = 0x00000000 },
	{ .addr = 0x00f1017468, .val = 0x00000000 },
	{ .addr = 0x00f101746c, .val = 0x00000000 },
	{ .addr = 0x00f1017470, .val = 0x00000000 },
	{ .addr = 0x00f1017474, .val = 0x00000000 },
	{ .addr = 0x00f1017478, .val = 0x00000000 },
	{ .addr = 0x00f101747c, .val = 0x00000000 },
	{ .addr = 0x00f1017480, .val = 0x00000000 },
	{ .addr = 0x00f1017484, .val = 0x00000000 },
	{ .addr = 0x00f1017488, .val = 0x00000000 },
	{ .addr = 0x00f101748c, .val = 0x00000000 },
	{ .addr = 0x00f1017490, .val = 0x00000000 },
	{ .addr = 0x00f1017494, .val = 0x00000000 },
	{ .addr = 0x00f1017498, .val = 0x00000000 },
	{ .addr = 0x00f101749c, .val = 0x00000000 },
	{ .addr = 0x00f10174a0, .val = 0x00000000 },
	{ .addr = 0x00f10174a4, .val = 0x00000000 },
	{ .addr = 0x00f10174a8, .val = 0x00000000 },
	{ .addr = 0x00f10174ac, .val = 0x00000000 },
	{ .addr = 0x00f10174b0, .val = 0x00000000 },
	{ .addr = 0x00f10174b4, .val = 0x00000000 },
	{ .addr = 0x00f10174b8, .val = 0x00000000 },
	{ .addr = 0x00f10174bc, .val = 0x00000000 },
	{ .addr = 0x00f10174c0, .val = 0x00000000 },
	{ .addr = 0x00f10174c4, .val = 0x00000000 },
	{ .addr = 0x00f10174c8, .val = 0x00000000 },
	{ .addr = 0x00f10174cc, .val = 0x00000000 },
	{ .addr = 0x00f10174d0, .val = 0x00000000 },
	{ .addr = 0x00f10174d4, .val = 0x00000000 },
	{ .addr = 0x00f10174d8, .val = 0x00000000 },
	{ .addr = 0x00f10174dc, .val = 0x00000000 },
	{ .addr = 0x00f10174e0, .val = 0x00000000 },
	{ .addr = 0x00f10174e4, .val = 0x00000000 },
	{ .addr = 0x00f10174e8, .val = 0x00000000 },
	{ .addr = 0x00f10174ec, .val = 0x00000000 },
	{ .addr = 0x00f10174f0, .val = 0x00000000 },
	{ .addr = 0x00f10174f4, .val = 0x00000000 },
	{ .addr = 0x00f10174f8, .val = 0x00000000 },
	{ .addr = 0x00f10174fc, .val = 0x00000000 },
	{ .addr = 0x00f1017500, .val = 0x00000000 },
	{ .addr = 0x00f1017504, .val = 0x00000000 },
	{ .addr = 0x00f1017508, .val = 0x00000000 },
	{ .addr = 0x00f101750c, .val = 0x00000000 },
	{ .addr = 0x00f1017510, .val = 0x00000000 },
	{ .addr = 0x00f1017514, .val = 0x00000000 },
	{ .addr = 0x00f1017518, .val = 0x00000000 },
	{ .addr = 0x00f101751c, .val = 0x00000000 },
	{ .addr = 0x00f1017520, .val = 0x00000000 },
	{ .addr = 0x00f1017524, .val = 0x00000000 },
	{ .addr = 0x00f1017528, .val = 0x00000000 },
	{ .addr = 0x00f101752c, .val = 0x00000000 },
	{ .addr = 0x00f1017530, .val = 0x00000000 },
	{ .addr = 0x00f1017534, .val = 0x00000000 },
	{ .addr = 0x00f1017538, .val = 0x00000000 },
	{ .addr = 0x00f101753c, .val = 0x00000000 },
	{ .addr = 0x00f1017540, .val = 0x00000000 },
	{ .addr = 0x00f1017544, .val = 0x00000000 },
	{ .addr = 0x00f1017548, .val = 0x00000000 },
	{ .addr = 0x00f101754c, .val = 0x00000000 },
	{ .addr = 0x00f1017550, .val = 0x00000000 },
	{ .addr = 0x00f1017554, .val = 0x00000000 },
	{ .addr = 0x00f1017558, .val = 0x00000000 },
	{ .addr = 0x00f101755c, .val = 0x00000000 },
	{ .addr = 0x00f1017560, .val = 0x00000000 },
	{ .addr = 0x00f1017564, .val = 0x00000000 },
	{ .addr = 0x00f1017568, .val = 0x00000000 },
	{ .addr = 0x00f101756c, .val = 0x00000000 },
	{ .addr = 0x00f1017570, .val = 0x00000000 },
	{ .addr = 0x00f1017574, .val = 0x00000000 },
	{ .addr = 0x00f1017578, .val = 0x00000000 },
	{ .addr = 0x00f101757c, .val = 0x00000000 },
	{ .addr = 0x00f1017580, .val = 0x00000000 },
	{ .addr = 0x00f1017584, .val = 0x00000000 },
	{ .addr = 0x00f1017588, .val = 0x00000000 },
	{ .addr = 0x00f101758c, .val = 0x00000000 },
	{ .addr = 0x00f1017590, .val = 0x00000000 },
	{ .addr = 0x00f1017594, .val = 0x00000000 },
	{ .addr = 0x00f1017598, .val = 0x00000000 },
	{ .addr = 0x00f101759c, .val = 0x00000000 },
	{ .addr = 0x00f10175a0, .val = 0x00000000 },
	{ .addr = 0x00f10175a4, .val = 0x00000000 },
	{ .addr = 0x00f10175a8, .val = 0x00000000 },
	{ .addr = 0x00f10175ac, .val = 0x00000000 },
	{ .addr = 0x00f10175b0, .val = 0x00000000 },
	{ .addr = 0x00f10175b4, .val = 0x00000000 },
	{ .addr = 0x00f10175b8, .val = 0x00000000 },
	{ .addr = 0x00f10175bc, .val = 0x00000000 },
	{ .addr = 0x00f10175c0, .val = 0x00000000 },
	{ .addr = 0x00f10175c4, .val = 0x00000000 },
	{ .addr = 0x00f10175c8, .val = 0x00000000 },
	{ .addr = 0x00f10175cc, .val = 0x00000000 },
	{ .addr = 0x00f10175d0, .val = 0x00000000 },
	{ .addr = 0x00f10175d4, .val = 0x00000000 },
	{ .addr = 0x00f10175d8, .val = 0x00000000 },
	{ .addr = 0x00f10175dc, .val = 0x00000000 },
	{ .addr = 0x00f10175e0, .val = 0x00000000 },
	{ .addr = 0x00f10175e4, .val = 0x00000000 },
	{ .addr = 0x00f10175e8, .val = 0x00000000 },
	{ .addr = 0x00f10175ec, .val = 0x00000000 },
	{ .addr = 0x00f10175f0, .val = 0x00000000 },
	{ .addr = 0x00f10175f4, .val = 0x00000000 },
	{ .addr = 0x00f10175f8, .val = 0x00000000 },
	{ .addr = 0x00f10175fc, .val = 0x00000000 },
	{ .addr = 0x00f1017600, .val = 0x00000000 },
	{ .addr = 0x00f1017604, .val = 0x00000000 },
	{ .addr = 0x00f1017608, .val = 0x00000000 },
	{ .addr = 0x00f101760c, .val = 0x00000000 },
	{ .addr = 0x00f1017610, .val = 0x00000000 },
	{ .addr = 0x00f1017614, .val = 0x00000000 },
	{ .addr = 0x00f1017618, .val = 0x00000000 },
	{ .addr = 0x00f101761c, .val = 0x00000000 },
	{ .addr = 0x00f1017620, .val = 0x00000000 },
	{ .addr = 0x00f1017624, .val = 0x00000000 },
	{ .addr = 0x00f1017628, .val = 0x00000000 },
	{ .addr = 0x00f101762c, .val = 0x00000000 },
	{ .addr = 0x00f1017630, .val = 0x00000000 },
	{ .addr = 0x00f1017634, .val = 0x00000000 },
	{ .addr = 0x00f1017638, .val = 0x00000000 },
	{ .addr = 0x00f101763c, .val = 0x00000000 },
	{ .addr = 0x00f1017640, .val = 0x00000000 },
	{ .addr = 0x00f1017644, .val = 0x00000000 },
	{ .addr = 0x00f1017648, .val = 0x00000000 },
	{ .addr = 0x00f101764c, .val = 0x00000000 },
	{ .addr = 0x00f1017650, .val = 0x00000000 },
	{ .addr = 0x00f1017654, .val = 0x00000000 },
	{ .addr = 0x00f1017658, .val = 0x00000000 },
	{ .addr = 0x00f101765c, .val = 0x00000000 },
	{ .addr = 0x00f1017660, .val = 0x00000000 },
	{ .addr = 0x00f1017664, .val = 0x00000000 },
	{ .addr = 0x00f1017668, .val = 0x00000000 },
	{ .addr = 0x00f101766c, .val = 0x00000000 },
	{ .addr = 0x00f1017670, .val = 0x00000000 },
	{ .addr = 0x00f1017674, .val = 0x00000000 },
	{ .addr = 0x00f1017678, .val = 0x00000000 },
	{ .addr = 0x00f101767c, .val = 0x00000000 },
	{ .addr = 0x00f1017680, .val = 0x00000000 },
	{ .addr = 0x00f1017684, .val = 0x00000000 },
	{ .addr = 0x00f1017688, .val = 0x00000000 },
	{ .addr = 0x00f101768c, .val = 0x00000000 },
	{ .addr = 0x00f1017690, .val = 0x00000000 },
	{ .addr = 0x00f1017694, .val = 0x00000000 },
	{ .addr = 0x00f1017698, .val = 0x00000000 },
	{ .addr = 0x00f101769c, .val = 0x00000000 },
	{ .addr = 0x00f10176a0, .val = 0x00000000 },
	{ .addr = 0x00f10176a4, .val = 0x00000000 },
	{ .addr = 0x00f10176a8, .val = 0x00000000 },
	{ .addr = 0x00f10176ac, .val = 0x00000000 },
	{ .addr = 0x00f10176b0, .val = 0x00000000 },
	{ .addr = 0x00f10176b4, .val = 0x00000000 },
	{ .addr = 0x00f10176b8, .val = 0x00000000 },
	{ .addr = 0x00f10176bc, .val = 0x00000000 },
	{ .addr = 0x00f10176c0, .val = 0x00000000 },
	{ .addr = 0x00f10176c4, .val = 0x00000000 },
	{ .addr = 0x00f10176c8, .val = 0x00000000 },
	{ .addr = 0x00f10176cc, .val = 0x00000000 },
	{ .addr = 0x00f10176d0, .val = 0x00000000 },
	{ .addr = 0x00f10176d4, .val = 0x00000000 },
	{ .addr = 0x00f10176d8, .val = 0x00000000 },
	{ .addr = 0x00f10176dc, .val = 0x00000000 },
	{ .addr = 0x00f10176e0, .val = 0x00000000 },
	{ .addr = 0x00f10176e4, .val = 0x00000000 },
	{ .addr = 0x00f10176e8, .val = 0x00000000 },
	{ .addr = 0x00f10176ec, .val = 0x00000000 },
	{ .addr = 0x00f10176f0, .val = 0x00000000 },
	{ .addr = 0x00f10176f4, .val = 0x00000000 },
	{ .addr = 0x00f10176f8, .val = 0x00000000 },
	{ .addr = 0x00f10176fc, .val = 0x00000000 },
	{ .addr = 0x00f1017700, .val = 0x00000000 },
	{ .addr = 0x00f1017704, .val = 0x00000000 },
	{ .addr = 0x00f1017708, .val = 0x00000000 },
	{ .addr = 0x00f101770c, .val = 0x00000000 },
	{ .addr = 0x00f1017710, .val = 0x00000000 },
	{ .addr = 0x00f1017714, .val = 0x00000000 },
	{ .addr = 0x00f1017718, .val = 0x00000000 },
	{ .addr = 0x00f101771c, .val = 0x00000000 },
	{ .addr = 0x00f1017720, .val = 0x00000000 },
	{ .addr = 0x00f1017724, .val = 0x00000000 },
	{ .addr = 0x00f1017728, .val = 0x00000000 },
	{ .addr = 0x00f101772c, .val = 0x00000000 },
	{ .addr = 0x00f1017730, .val = 0x00000000 },
	{ .addr = 0x00f1017734, .val = 0x00000000 },
	{ .addr = 0x00f1017738, .val = 0x00000000 },
	{ .addr = 0x00f101773c, .val = 0x00000000 },
	{ .addr = 0x00f1017740, .val = 0x00000000 },
	{ .addr = 0x00f1017744, .val = 0x00000000 },
	{ .addr = 0x00f1017748, .val = 0x00000000 },
	{ .addr = 0x00f101774c, .val = 0x00000000 },
	{ .addr = 0x00f1017750, .val = 0x00000000 },
	{ .addr = 0x00f1017754, .val = 0x00000000 },
	{ .addr = 0x00f1017758, .val = 0x00000000 },
	{ .addr = 0x00f101775c, .val = 0x00000000 },
	{ .addr = 0x00f1017760, .val = 0x00000000 },
	{ .addr = 0x00f1017764, .val = 0x00000000 },
	{ .addr = 0x00f1017768, .val = 0x00000000 },
	{ .addr = 0x00f101776c, .val = 0x00000000 },
	{ .addr = 0x00f1017770, .val = 0x00000000 },
	{ .addr = 0x00f1017774, .val = 0x00000000 },
	{ .addr = 0x00f1017778, .val = 0x00000000 },
	{ .addr = 0x00f101777c, .val = 0x00000000 },
	{ .addr = 0x00f1017780, .val = 0x00000000 },
	{ .addr = 0x00f1017784, .val = 0x00000000 },
	{ .addr = 0x00f1017788, .val = 0x00000000 },
	{ .addr = 0x00f101778c, .val = 0x00000000 },
	{ .addr = 0x00f1017790, .val = 0x00000000 },
	{ .addr = 0x00f1017794, .val = 0x00000000 },
	{ .addr = 0x00f1017798, .val = 0x00000000 },
	{ .addr = 0x00f101779c, .val = 0x00000000 },
	{ .addr = 0x00f10177a0, .val = 0x00000000 },
	{ .addr = 0x00f10177a4, .val = 0x00000000 },
	{ .addr = 0x00f10177a8, .val = 0x00000000 },
	{ .addr = 0x00f10177ac, .val = 0x00000000 },
	{ .addr = 0x00f10177b0, .val = 0x00000000 },
	{ .addr = 0x00f10177b4, .val = 0x00000000 },
	{ .addr = 0x00f10177b8, .val = 0x00000000 },
	{ .addr = 0x00f10177bc, .val = 0x00000000 },
	{ .addr = 0x00f10177c0, .val = 0x00000000 },
	{ .addr = 0x00f10177c4, .val = 0x00000000 },
	{ .addr = 0x00f10177c8, .val = 0x00000000 },
	{ .addr = 0x00f10177cc, .val = 0x00000000 },
	{ .addr = 0x00f10177d0, .val = 0x00000000 },
	{ .addr = 0x00f10177d4, .val = 0x00000000 },
	{ .addr = 0x00f10177d8, .val = 0x00000000 },
	{ .addr = 0x00f10177dc, .val = 0x00000000 },
	{ .addr = 0x00f10177e0, .val = 0x00000000 },
	{ .addr = 0x00f10177e4, .val = 0x00000000 },
	{ .addr = 0x00f10177e8, .val = 0x00000000 },
	{ .addr = 0x00f10177ec, .val = 0x00000000 },
	{ .addr = 0x00f10177f0, .val = 0x00000000 },
	{ .addr = 0x00f10177f4, .val = 0x00000000 },
	{ .addr = 0x00f10177f8, .val = 0x00000000 },
	{ .addr = 0x00f10177fc, .val = 0x00000000 },
	{ .addr = 0x00f1017800, .val = 0x00000000 },
	{ .addr = 0x00f1017804, .val = 0x00000000 },
	{ .addr = 0x00f1017808, .val = 0x00000000 },
	{ .addr = 0x00f101780c, .val = 0x00000000 },
	{ .addr = 0x00f1017810, .val = 0x00000000 },
	{ .addr = 0x00f1017814, .val = 0x00000000 },
	{ .addr = 0x00f1017818, .val = 0x00000000 },
	{ .addr = 0x00f101781c, .val = 0x00000000 },
	{ .addr = 0x00f1017820, .val = 0x00000000 },
	{ .addr = 0x00f1017824, .val = 0x00000000 },
	{ .addr = 0x00f1017828, .val = 0x00000000 },
	{ .addr = 0x00f101782c, .val = 0x00000000 },
	{ .addr = 0x00f1017830, .val = 0x00000000 },
	{ .addr = 0x00f1017834, .val = 0x00000000 },
	{ .addr = 0x00f1017838, .val = 0x00000000 },
	{ .addr = 0x00f101783c, .val = 0x00000000 },
	{ .addr = 0x00f1017840, .val = 0x00000000 },
	{ .addr = 0x00f1017844, .val = 0x00000000 },
	{ .addr = 0x00f1017848, .val = 0x00000000 },
	{ .addr = 0x00f101784c, .val = 0x00000000 },
	{ .addr = 0x00f1017850, .val = 0x00000000 },
	{ .addr = 0x00f1017854, .val = 0x00000000 },
	{ .addr = 0x00f1017858, .val = 0x00000000 },
	{ .addr = 0x00f101785c, .val = 0x00000000 },
	{ .addr = 0x00f1017860, .val = 0x00000000 },
	{ .addr = 0x00f1017864, .val = 0x00000000 },
	{ .addr = 0x00f1017868, .val = 0x00000000 },
	{ .addr = 0x00f101786c, .val = 0x00000000 },
	{ .addr = 0x00f1017870, .val = 0x00000000 },
	{ .addr = 0x00f1017874, .val = 0x00000000 },
	{ .addr = 0x00f1017878, .val = 0x00000000 },
	{ .addr = 0x00f101787c, .val = 0x00000000 },
	{ .addr = 0x00f1017880, .val = 0x00000000 },
	{ .addr = 0x00f1017884, .val = 0x00000000 },
	{ .addr = 0x00f1017888, .val = 0x00000000 },
	{ .addr = 0x00f101788c, .val = 0x00000000 },
	{ .addr = 0x00f1017890, .val = 0x00000000 },
	{ .addr = 0x00f1017894, .val = 0x00000000 },
	{ .addr = 0x00f1017898, .val = 0x00000000 },
	{ .addr = 0x00f101789c, .val = 0x00000000 },
	{ .addr = 0x00f10178a0, .val = 0x00000000 },
	{ .addr = 0x00f10178a4, .val = 0x00000000 },
	{ .addr = 0x00f10178a8, .val = 0x00000000 },
	{ .addr = 0x00f10178ac, .val = 0x00000000 },
	{ .addr = 0x00f10178b0, .val = 0x00000000 },
	{ .addr = 0x00f10178b4, .val = 0x00000000 },
	{ .addr = 0x00f10178b8, .val = 0x00000000 },
	{ .addr = 0x00f10178bc, .val = 0x00000000 },
	{ .addr = 0x00f10178c0, .val = 0x00000000 },
	{ .addr = 0x00f10178c4, .val = 0x00000000 },
	{ .addr = 0x00f10178c8, .val = 0x00000000 },
	{ .addr = 0x00f10178cc, .val = 0x00000000 },
	{ .addr = 0x00f10178d0, .val = 0x00000000 },
	{ .addr = 0x00f10178d4, .val = 0x00000000 },
	{ .addr = 0x00f10178d8, .val = 0x00000000 },
	{ .addr = 0x00f10178dc, .val = 0x00000000 },
	{ .addr = 0x00f10178e0, .val = 0x00000000 },
	{ .addr = 0x00f10178e4, .val = 0x00000000 },
	{ .addr = 0x00f10178e8, .val = 0x00000000 },
	{ .addr = 0x00f10178ec, .val = 0x00000000 },
	{ .addr = 0x00f10178f0, .val = 0x00000000 },
	{ .addr = 0x00f10178f4, .val = 0x00000000 },
	{ .addr = 0x00f10178f8, .val = 0x00000000 },
	{ .addr = 0x00f10178fc, .val = 0x00000000 },
	{ .addr = 0x00f1017900, .val = 0x00000000 },
	{ .addr = 0x00f1017904, .val = 0x00000000 },
	{ .addr = 0x00f1017908, .val = 0x00000000 },
	{ .addr = 0x00f101790c, .val = 0x00000000 },
	{ .addr = 0x00f1017910, .val = 0x00000000 },
	{ .addr = 0x00f1017914, .val = 0x00000000 },
	{ .addr = 0x00f1017918, .val = 0x00000000 },
	{ .addr = 0x00f101791c, .val = 0x00000000 },
	{ .addr = 0x00f1017920, .val = 0x00000000 },
	{ .addr = 0x00f1017924, .val = 0x00000000 },
	{ .addr = 0x00f1017928, .val = 0x00000000 },
	{ .addr = 0x00f101792c, .val = 0x00000000 },
	{ .addr = 0x00f1017930, .val = 0x00000000 },
	{ .addr = 0x00f1017934, .val = 0x00000000 },
	{ .addr = 0x00f1017938, .val = 0x00000000 },
	{ .addr = 0x00f101793c, .val = 0x00000000 },
	{ .addr = 0x00f1017940, .val = 0x00000000 },
	{ .addr = 0x00f1017944, .val = 0x00000000 },
	{ .addr = 0x00f1017948, .val = 0x00000000 },
	{ .addr = 0x00f101794c, .val = 0x00000000 },
	{ .addr = 0x00f1017950, .val = 0x00000000 },
	{ .addr = 0x00f1017954, .val = 0x00000000 },
	{ .addr = 0x00f1017958, .val = 0x00000000 },
	{ .addr = 0x00f101795c, .val = 0x00000000 },
	{ .addr = 0x00f1017960, .val = 0x00000000 },
	{ .addr = 0x00f1017964, .val = 0x00000000 },
	{ .addr = 0x00f1017968, .val = 0x00000000 },
	{ .addr = 0x00f101796c, .val = 0x00000000 },
	{ .addr = 0x00f1017970, .val = 0x00000000 },
	{ .addr = 0x00f1017974, .val = 0x00000000 },
	{ .addr = 0x00f1017978, .val = 0x00000000 },
	{ .addr = 0x00f101797c, .val = 0x00000000 },
	{ .addr = 0x00f1017980, .val = 0x00000000 },
	{ .addr = 0x00f1017984, .val = 0x00000000 },
	{ .addr = 0x00f1017988, .val = 0x00000000 },
	{ .addr = 0x00f101798c, .val = 0x00000000 },
	{ .addr = 0x00f1017990, .val = 0x00000000 },
	{ .addr = 0x00f1017994, .val = 0x00000000 },
	{ .addr = 0x00f1017998, .val = 0x00000000 },
	{ .addr = 0x00f101799c, .val = 0x00000000 },
	{ .addr = 0x00f10179a0, .val = 0x00000000 },
	{ .addr = 0x00f10179a4, .val = 0x00000000 },
	{ .addr = 0x00f10179a8, .val = 0x00000000 },
	{ .addr = 0x00f10179ac, .val = 0x00000000 },
	{ .addr = 0x00f10179b0, .val = 0x00000000 },
	{ .addr = 0x00f10179b4, .val = 0x00000000 },
	{ .addr = 0x00f10179b8, .val = 0x00000000 },
	{ .addr = 0x00f10179bc, .val = 0x00000000 },
	{ .addr = 0x00f10179c0, .val = 0x00000000 },
	{ .addr = 0x00f10179c4, .val = 0x00000000 },
	{ .addr = 0x00f10179c8, .val = 0x00000000 },
	{ .addr = 0x00f10179cc, .val = 0x00000000 },
	{ .addr = 0x00f10179d0, .val = 0x00000000 },
	{ .addr = 0x00f10179d4, .val = 0x00000000 },
	{ .addr = 0x00f10179d8, .val = 0x00000000 },
	{ .addr = 0x00f10179dc, .val = 0x00000000 },
	{ .addr = 0x00f10179e0, .val = 0x00000000 },
	{ .addr = 0x00f10179e4, .val = 0x00000000 },
	{ .addr = 0x00f10179e8, .val = 0x00000000 },
	{ .addr = 0x00f10179ec, .val = 0x00000000 },
	{ .addr = 0x00f10179f0, .val = 0x00000000 },
	{ .addr = 0x00f10179f4, .val = 0x00000000 },
	{ .addr = 0x00f10179f8, .val = 0x00000000 },
	{ .addr = 0x00f10179fc, .val = 0x00000000 },
	{ .addr = 0x00f1017a00, .val = 0x00000000 },
	{ .addr = 0x00f1017a04, .val = 0x00000000 },
	{ .addr = 0x00f1017a08, .val = 0x00000000 },
	{ .addr = 0x00f1017a0c, .val = 0x00000000 },
	{ .addr = 0x00f1017a10, .val = 0x00000000 },
	{ .addr = 0x00f1017a14, .val = 0x00000000 },
	{ .addr = 0x00f1017a18, .val = 0x00000000 },
	{ .addr = 0x00f1017a1c, .val = 0x00000000 },
	{ .addr = 0x00f1017a20, .val = 0x00000000 },
	{ .addr = 0x00f1017a24, .val = 0x00000000 },
	{ .addr = 0x00f1017a28, .val = 0x00000000 },
	{ .addr = 0x00f1017a2c, .val = 0x00000000 },
	{ .addr = 0x00f1017a30, .val = 0x00000000 },
	{ .addr = 0x00f1017a34, .val = 0x00000000 },
	{ .addr = 0x00f1017a38, .val = 0x00000000 },
	{ .addr = 0x00f1017a3c, .val = 0x00000000 },
	{ .addr = 0x00f1017a40, .val = 0x00000000 },
	{ .addr = 0x00f1017a44, .val = 0x00000000 },
	{ .addr = 0x00f1017a48, .val = 0x00000000 },
	{ .addr = 0x00f1017a4c, .val = 0x00000000 },
	{ .addr = 0x00f1017a50, .val = 0x00000000 },
	{ .addr = 0x00f1017a54, .val = 0x00000000 },
	{ .addr = 0x00f1017a58, .val = 0x00000000 },
	{ .addr = 0x00f1017a5c, .val = 0x00000000 },
	{ .addr = 0x00f1017a60, .val = 0x00000000 },
	{ .addr = 0x00f1017a64, .val = 0x00000000 },
	{ .addr = 0x00f1017a68, .val = 0x00000000 },
	{ .addr = 0x00f1017a6c, .val = 0x00000000 },
	{ .addr = 0x00f1017a70, .val = 0x00000000 },
	{ .addr = 0x00f1017a74, .val = 0x00000000 },
	{ .addr = 0x00f1017a78, .val = 0x00000000 },
	{ .addr = 0x00f1017a7c, .val = 0x00000000 },
	{ .addr = 0x00f1017a80, .val = 0x00000000 },
	{ .addr = 0x00f1017a84, .val = 0x00000000 },
	{ .addr = 0x00f1017a88, .val = 0x00000000 },
	{ .addr = 0x00f1017a8c, .val = 0x00000000 },
	{ .addr = 0x00f1017a90, .val = 0x00000000 },
	{ .addr = 0x00f1017a94, .val = 0x00000000 },
	{ .addr = 0x00f1017a98, .val = 0x00000000 },
	{ .addr = 0x00f1017a9c, .val = 0x00000000 },
	{ .addr = 0x00f1017aa0, .val = 0x00000000 },
	{ .addr = 0x00f1017aa4, .val = 0x00000000 },
	{ .addr = 0x00f1017aa8, .val = 0x00000000 },
	{ .addr = 0x00f1017aac, .val = 0x00000000 },
	{ .addr = 0x00f1017ab0, .val = 0x00000000 },
	{ .addr = 0x00f1017ab4, .val = 0x00000000 },
	{ .addr = 0x00f1017ab8, .val = 0x00000000 },
	{ .addr = 0x00f1017abc, .val = 0x00000000 },
	{ .addr = 0x00f1017ac0, .val = 0x00000000 },
	{ .addr = 0x00f1017ac4, .val = 0x00000000 },
	{ .addr = 0x00f1017ac8, .val = 0x00000000 },
	{ .addr = 0x00f1017acc, .val = 0x00000000 },
	{ .addr = 0x00f1017ad0, .val = 0x00000000 },
	{ .addr = 0x00f1017ad4, .val = 0x00000000 },
	{ .addr = 0x00f1017ad8, .val = 0x00000000 },
	{ .addr = 0x00f1017adc, .val = 0x00000000 },
	{ .addr = 0x00f1017ae0, .val = 0x00000000 },
	{ .addr = 0x00f1017ae4, .val = 0x00000000 },
	{ .addr = 0x00f1017ae8, .val = 0x00000000 },
	{ .addr = 0x00f1017aec, .val = 0x00000000 },
	{ .addr = 0x00f1017af0, .val = 0x00000000 },
	{ .addr = 0x00f1017af4, .val = 0x00000000 },
	{ .addr = 0x00f1017af8, .val = 0x00000000 },
	{ .addr = 0x00f1017afc, .val = 0x00000000 },
	{ .addr = 0x00f1017b00, .val = 0x00000000 },
	{ .addr = 0x00f1017b04, .val = 0x00000000 },
	{ .addr = 0x00f1017b08, .val = 0x00000000 },
	{ .addr = 0x00f1017b0c, .val = 0x00000000 },
	{ .addr = 0x00f1017b10, .val = 0x00000000 },
	{ .addr = 0x00f1017b14, .val = 0x00000000 },
	{ .addr = 0x00f1017b18, .val = 0x00000000 },
	{ .addr = 0x00f1017b1c, .val = 0x00000000 },
	{ .addr = 0x00f1017b20, .val = 0x00000000 },
	{ .addr = 0x00f1017b24, .val = 0x00000000 },
	{ .addr = 0x00f1017b28, .val = 0x00000000 },
	{ .addr = 0x00f1017b2c, .val = 0x00000000 },
	{ .addr = 0x00f1017b30, .val = 0x00000000 },
	{ .addr = 0x00f1017b34, .val = 0x00000000 },
	{ .addr = 0x00f1017b38, .val = 0x00000000 },
	{ .addr = 0x00f1017b3c, .val = 0x00000000 },
	{ .addr = 0x00f1017b40, .val = 0x00000000 },
	{ .addr = 0x00f1017b44, .val = 0x00000000 },
	{ .addr = 0x00f1017b48, .val = 0x00000000 },
	{ .addr = 0x00f1017b4c, .val = 0x00000000 },
	{ .addr = 0x00f1017b50, .val = 0x00000000 },
	{ .addr = 0x00f1017b54, .val = 0x00000000 },
	{ .addr = 0x00f1017b58, .val = 0x00000000 },
	{ .addr = 0x00f1017b5c, .val = 0x00000000 },
	{ .addr = 0x00f1017b60, .val = 0x00000000 },
	{ .addr = 0x00f1017b64, .val = 0x00000000 },
	{ .addr = 0x00f1017b68, .val = 0x00000000 },
	{ .addr = 0x00f1017b6c, .val = 0x00000000 },
	{ .addr = 0x00f1017b70, .val = 0x00000000 },
	{ .addr = 0x00f1017b74, .val = 0x00000000 },
	{ .addr = 0x00f1017b78, .val = 0x00000000 },
	{ .addr = 0x00f1017b7c, .val = 0x00000000 },
	{ .addr = 0x00f1017b80, .val = 0x00000000 },
	{ .addr = 0x00f1017b84, .val = 0x00000000 },
	{ .addr = 0x00f1017b88, .val = 0x00000000 },
	{ .addr = 0x00f1017b8c, .val = 0x00000000 },
	{ .addr = 0x00f1017b90, .val = 0x00000000 },
	{ .addr = 0x00f1017b94, .val = 0x00000000 },
	{ .addr = 0x00f1017b98, .val = 0x00000000 },
	{ .addr = 0x00f1017b9c, .val = 0x00000000 },
	{ .addr = 0x00f1017ba0, .val = 0x00000000 },
	{ .addr = 0x00f1017ba4, .val = 0x00000000 },
	{ .addr = 0x00f1017ba8, .val = 0x00000000 },
	{ .addr = 0x00f1017bac, .val = 0x00000000 },
	{ .addr = 0x00f1017bb0, .val = 0x00000000 },
	{ .addr = 0x00f1017bb4, .val = 0x00000000 },
	{ .addr = 0x00f1017bb8, .val = 0x00000000 },
	{ .addr = 0x00f1017bbc, .val = 0x00000000 },
	{ .addr = 0x00f1017bc0, .val = 0x00000000 },
	{ .addr = 0x00f1017bc4, .val = 0x00000000 },
	{ .addr = 0x00f1017bc8, .val = 0x00000000 },
	{ .addr = 0x00f1017bcc, .val = 0x00000000 },
	{ .addr = 0x00f1017bd0, .val = 0x00000000 },
	{ .addr = 0x00f1017bd4, .val = 0x00000000 },
	{ .addr = 0x00f1017bd8, .val = 0x00000000 },
	{ .addr = 0x00f1017bdc, .val = 0x00000000 },
	{ .addr = 0x00f1017be0, .val = 0x00000000 },
	{ .addr = 0x00f1017be4, .val = 0x00000000 },
	{ .addr = 0x00f1017be8, .val = 0x00000000 },
	{ .addr = 0x00f1017bec, .val = 0x00000000 },
	{ .addr = 0x00f1017bf0, .val = 0x00000000 },
	{ .addr = 0x00f1017bf4, .val = 0x00000000 },
	{ .addr = 0x00f1017bf8, .val = 0x00000000 },
	{ .addr = 0x00f1017bfc, .val = 0x00000000 },
	{ .addr = 0x00f1017c00, .val = 0x00000000 },
	{ .addr = 0x00f1017c04, .val = 0x00000000 },
	{ .addr = 0x00f1017c08, .val = 0x00000000 },
	{ .addr = 0x00f1017c0c, .val = 0x00000000 },
	{ .addr = 0x00f1017c10, .val = 0x00000000 },
	{ .addr = 0x00f1017c14, .val = 0x00000000 },
	{ .addr = 0x00f1017c18, .val = 0x00000000 },
	{ .addr = 0x00f1017c1c, .val = 0x00000000 },
	{ .addr = 0x00f1017c20, .val = 0x00000000 },
	{ .addr = 0x00f1017c24, .val = 0x00000000 },
	{ .addr = 0x00f1017c28, .val = 0x00000000 },
	{ .addr = 0x00f1017c2c, .val = 0x00000000 },
	{ .addr = 0x00f1017c30, .val = 0x00000000 },
	{ .addr = 0x00f1017c34, .val = 0x00000000 },
	{ .addr = 0x00f1017c38, .val = 0x00000000 },
	{ .addr = 0x00f1017c3c, .val = 0x00000000 },
	{ .addr = 0x00f1017c40, .val = 0x00000000 },
	{ .addr = 0x00f1017c44, .val = 0x00000000 },
	{ .addr = 0x00f1017c48, .val = 0x00000000 },
	{ .addr = 0x00f1017c4c, .val = 0x00000000 },
	{ .addr = 0x00f1017c50, .val = 0x00000000 },
	{ .addr = 0x00f1017c54, .val = 0x00000000 },
	{ .addr = 0x00f1017c58, .val = 0x00000000 },
	{ .addr = 0x00f1017c5c, .val = 0x00000000 },
	{ .addr = 0x00f1017c60, .val = 0x00000000 },
	{ .addr = 0x00f1017c64, .val = 0x00000000 },
	{ .addr = 0x00f1017c68, .val = 0x00000000 },
	{ .addr = 0x00f1017c6c, .val = 0x00000000 },
	{ .addr = 0x00f1017c70, .val = 0x00000000 },
	{ .addr = 0x00f1017c74, .val = 0x00000000 },
	{ .addr = 0x00f1017c78, .val = 0x00000000 },
	{ .addr = 0x00f1017c7c, .val = 0x00000000 },
	{ .addr = 0x00f1017c80, .val = 0x00000000 },
	{ .addr = 0x00f1017c84, .val = 0x00000000 },
	{ .addr = 0x00f1017c88, .val = 0x00000000 },
	{ .addr = 0x00f1017c8c, .val = 0x00000000 },
	{ .addr = 0x00f1017c90, .val = 0x00000000 },
	{ .addr = 0x00f1017c94, .val = 0x00000000 },
	{ .addr = 0x00f1017c98, .val = 0x00000000 },
	{ .addr = 0x00f1017c9c, .val = 0x00000000 },
	{ .addr = 0x00f1017ca0, .val = 0x00000000 },
	{ .addr = 0x00f1017ca4, .val = 0x00000000 },
	{ .addr = 0x00f1017ca8, .val = 0x00000000 },
	{ .addr = 0x00f1017cac, .val = 0x00000000 },
	{ .addr = 0x00f1017cb0, .val = 0x00000000 },
	{ .addr = 0x00f1017cb4, .val = 0x00000000 },
	{ .addr = 0x00f1017cb8, .val = 0x00000000 },
	{ .addr = 0x00f1017cbc, .val = 0x00000000 },
	{ .addr = 0x00f1017cc0, .val = 0x00000000 },
	{ .addr = 0x00f1017cc4, .val = 0x00000000 },
	{ .addr = 0x00f1017cc8, .val = 0x00000000 },
	{ .addr = 0x00f1017ccc, .val = 0x00000000 },
	{ .addr = 0x00f1017cd0, .val = 0x00000000 },
	{ .addr = 0x00f1017cd4, .val = 0x00000000 },
	{ .addr = 0x00f1017cd8, .val = 0x00000000 },
	{ .addr = 0x00f1017cdc, .val = 0x00000000 },
	{ .addr = 0x00f1017ce0, .val = 0x00000000 },
	{ .addr = 0x00f1017ce4, .val = 0x00000000 },
	{ .addr = 0x00f1017ce8, .val = 0x00000000 },
	{ .addr = 0x00f1017cec, .val = 0x00000000 },
	{ .addr = 0x00f1017cf0, .val = 0x00000000 },
	{ .addr = 0x00f1017cf4, .val = 0x00000000 },
	{ .addr = 0x00f1017cf8, .val = 0x00000000 },
	{ .addr = 0x00f1017cfc, .val = 0x00000000 },
	{ .addr = 0x00f1017d00, .val = 0x00000000 },
	{ .addr = 0x00f1017d04, .val = 0x00000000 },
	{ .addr = 0x00f1017d08, .val = 0x00000000 },
	{ .addr = 0x00f1017d0c, .val = 0x00000000 },
	{ .addr = 0x00f1017d10, .val = 0x00000000 },
	{ .addr = 0x00f1017d14, .val = 0x00000000 },
	{ .addr = 0x00f1017d18, .val = 0x00000000 },
	{ .addr = 0x00f1017d1c, .val = 0x00000000 },
	{ .addr = 0x00f1017d20, .val = 0x00000000 },
	{ .addr = 0x00f1017d24, .val = 0x00000000 },
	{ .addr = 0x00f1017d28, .val = 0x00000000 },
	{ .addr = 0x00f1017d2c, .val = 0x00000000 },
	{ .addr = 0x00f1017d30, .val = 0x00000000 },
	{ .addr = 0x00f1017d34, .val = 0x00000000 },
	{ .addr = 0x00f1017d38, .val = 0x00000000 },
	{ .addr = 0x00f1017d3c, .val = 0x00000000 },
	{ .addr = 0x00f1017d40, .val = 0x00000000 },
	{ .addr = 0x00f1017d44, .val = 0x00000000 },
	{ .addr = 0x00f1017d48, .val = 0x00000000 },
	{ .addr = 0x00f1017d4c, .val = 0x00000000 },
	{ .addr = 0x00f1017d50, .val = 0x00000000 },
	{ .addr = 0x00f1017d54, .val = 0x00000000 },
	{ .addr = 0x00f1017d58, .val = 0x00000000 },
	{ .addr = 0x00f1017d5c, .val = 0x00000000 },
	{ .addr = 0x00f1017d60, .val = 0x00000000 },
	{ .addr = 0x00f1017d64, .val = 0x00000000 },
	{ .addr = 0x00f1017d68, .val = 0x00000000 },
	{ .addr = 0x00f1017d6c, .val = 0x00000000 },
	{ .addr = 0x00f1017d70, .val = 0x00000000 },
	{ .addr = 0x00f1017d74, .val = 0x00000000 },
	{ .addr = 0x00f1017d78, .val = 0x00000000 },
	{ .addr = 0x00f1017d7c, .val = 0x00000000 },
	{ .addr = 0x00f1017d80, .val = 0x00000000 },
	{ .addr = 0x00f1017d84, .val = 0x00000000 },
	{ .addr = 0x00f1017d88, .val = 0x00000000 },
	{ .addr = 0x00f1017d8c, .val = 0x00000000 },
	{ .addr = 0x00f1017d90, .val = 0x00000000 },
	{ .addr = 0x00f1017d94, .val = 0x00000000 },
	{ .addr = 0x00f1017d98, .val = 0x00000000 },
	{ .addr = 0x00f1017d9c, .val = 0x00000000 },
	{ .addr = 0x00f1017da0, .val = 0x00000000 },
	{ .addr = 0x00f1017da4, .val = 0x00000000 },
	{ .addr = 0x00f1017da8, .val = 0x00000000 },
	{ .addr = 0x00f1017dac, .val = 0x00000000 },
	{ .addr = 0x00f1017db0, .val = 0x00000000 },
	{ .addr = 0x00f1017db4, .val = 0x00000000 },
	{ .addr = 0x00f1017db8, .val = 0x00000000 },
	{ .addr = 0x00f1017dbc, .val = 0x00000000 },
	{ .addr = 0x00f1017dc0, .val = 0x00000000 },
	{ .addr = 0x00f1017dc4, .val = 0x00000000 },
	{ .addr = 0x00f1017dc8, .val = 0x00000000 },
	{ .addr = 0x00f1017dcc, .val = 0x00000000 },
	{ .addr = 0x00f1017dd0, .val = 0x00000000 },
	{ .addr = 0x00f1017dd4, .val = 0x00000000 },
	{ .addr = 0x00f1017dd8, .val = 0x00000000 },
	{ .addr = 0x00f1017ddc, .val = 0x00000000 },
	{ .addr = 0x00f1017de0, .val = 0x00000000 },
	{ .addr = 0x00f1017de4, .val = 0x00000000 },
	{ .addr = 0x00f1017de8, .val = 0x00000000 },
	{ .addr = 0x00f1017dec, .val = 0x00000000 },
	{ .addr = 0x00f1017df0, .val = 0x00000000 },
	{ .addr = 0x00f1017df4, .val = 0x00000000 },
	{ .addr = 0x00f1017df8, .val = 0x00000000 },
	{ .addr = 0x00f1017dfc, .val = 0x00000000 },
	{ .addr = 0x00f1017e00, .val = 0x00000000 },
	{ .addr = 0x00f1017e04, .val = 0x00000000 },
	{ .addr = 0x00f1017e08, .val = 0x00000000 },
	{ .addr = 0x00f1017e0c, .val = 0x00000000 },
	{ .addr = 0x00f1017e10, .val = 0x00000000 },
	{ .addr = 0x00f1017e14, .val = 0x00000000 },
	{ .addr = 0x00f1017e18, .val = 0x00000000 },
	{ .addr = 0x00f1017e1c, .val = 0x00000000 },
	{ .addr = 0x00f1017e20, .val = 0x00000000 },
	{ .addr = 0x00f1017e24, .val = 0x00000000 },
	{ .addr = 0x00f1017e28, .val = 0x00000000 },
	{ .addr = 0x00f1017e2c, .val = 0x00000000 },
	{ .addr = 0x00f1017e30, .val = 0x00000000 },
	{ .addr = 0x00f1017e34, .val = 0x00000000 },
	{ .addr = 0x00f1017e38, .val = 0x00000000 },
	{ .addr = 0x00f1017e3c, .val = 0x00000000 },
	{ .addr = 0x00f1017e40, .val = 0x00000000 },
	{ .addr = 0x00f1017e44, .val = 0x00000000 },
	{ .addr = 0x00f1017e48, .val = 0x00000000 },
	{ .addr = 0x00f1017e4c, .val = 0x00000000 },
	{ .addr = 0x00f1017e50, .val = 0x00000000 },
	{ .addr = 0x00f1017e54, .val = 0x00000000 },
	{ .addr = 0x00f1017e58, .val = 0x00000000 },
	{ .addr = 0x00f1017e5c, .val = 0x00000000 },
	{ .addr = 0x00f1017e60, .val = 0x00000000 },
	{ .addr = 0x00f1017e64, .val = 0x00000000 },
	{ .addr = 0x00f1017e68, .val = 0x00000000 },
	{ .addr = 0x00f1017e6c, .val = 0x00000000 },
	{ .addr = 0x00f1017e70, .val = 0x00000000 },
	{ .addr = 0x00f1017e74, .val = 0x00000000 },
	{ .addr = 0x00f1017e78, .val = 0x00000000 },
	{ .addr = 0x00f1017e7c, .val = 0x00000000 },
	{ .addr = 0x00f1017e80, .val = 0x00000000 },
	{ .addr = 0x00f1017e84, .val = 0x00000000 },
	{ .addr = 0x00f1017e88, .val = 0x00000000 },
	{ .addr = 0x00f1017e8c, .val = 0x00000000 },
	{ .addr = 0x00f1017e90, .val = 0x00000000 },
	{ .addr = 0x00f1017e94, .val = 0x00000000 },
	{ .addr = 0x00f1017e98, .val = 0x00000000 },
	{ .addr = 0x00f1017e9c, .val = 0x00000000 },
	{ .addr = 0x00f1017ea0, .val = 0x00000000 },
	{ .addr = 0x00f1017ea4, .val = 0x00000000 },
	{ .addr = 0x00f1017ea8, .val = 0x00000000 },
	{ .addr = 0x00f1017eac, .val = 0x00000000 },
	{ .addr = 0x00f1017eb0, .val = 0x00000000 },
	{ .addr = 0x00f1017eb4, .val = 0x00000000 },
	{ .addr = 0x00f1017eb8, .val = 0x00000000 },
	{ .addr = 0x00f1017ebc, .val = 0x00000000 },
	{ .addr = 0x00f1017ec0, .val = 0x00000000 },
	{ .addr = 0x00f1017ec4, .val = 0x00000000 },
	{ .addr = 0x00f1017ec8, .val = 0x00000000 },
	{ .addr = 0x00f1017ecc, .val = 0x00000000 },
	{ .addr = 0x00f1017ed0, .val = 0x00000000 },
	{ .addr = 0x00f1017ed4, .val = 0x00000000 },
	{ .addr = 0x00f1017ed8, .val = 0x00000000 },
	{ .addr = 0x00f1017edc, .val = 0x00000000 },
	{ .addr = 0x00f1017ee0, .val = 0x00000000 },
	{ .addr = 0x00f1017ee4, .val = 0x00000000 },
	{ .addr = 0x00f1017ee8, .val = 0x00000000 },
	{ .addr = 0x00f1017eec, .val = 0x00000000 },
	{ .addr = 0x00f1017ef0, .val = 0x00000000 },
	{ .addr = 0x00f1017ef4, .val = 0x00000000 },
	{ .addr = 0x00f1017ef8, .val = 0x00000000 },
	{ .addr = 0x00f1017efc, .val = 0x00000000 },
	{ .addr = 0x00f1017f00, .val = 0x00000000 },
	{ .addr = 0x00f1017f04, .val = 0x00000000 },
	{ .addr = 0x00f1017f08, .val = 0x00000000 },
	{ .addr = 0x00f1017f0c, .val = 0x00000000 },
	{ .addr = 0x00f1017f10, .val = 0x00000000 },
	{ .addr = 0x00f1017f14, .val = 0x00000000 },
	{ .addr = 0x00f1017f18, .val = 0x00000000 },
	{ .addr = 0x00f1017f1c, .val = 0x00000000 },
	{ .addr = 0x00f1017f20, .val = 0x00000000 },
	{ .addr = 0x00f1017f24, .val = 0x00000000 },
	{ .addr = 0x00f1017f28, .val = 0x00000000 },
	{ .addr = 0x00f1017f2c, .val = 0x00000000 },
	{ .addr = 0x00f1017f30, .val = 0x00000000 },
	{ .addr = 0x00f1017f34, .val = 0x00000000 },
	{ .addr = 0x00f1017f38, .val = 0x00000000 },
	{ .addr = 0x00f1017f3c, .val = 0x00000000 },
	{ .addr = 0x00f1017f40, .val = 0x00000000 },
	{ .addr = 0x00f1017f44, .val = 0x00000000 },
	{ .addr = 0x00f1017f48, .val = 0x00000000 },
	{ .addr = 0x00f1017f4c, .val = 0x00000000 },
	{ .addr = 0x00f1017f50, .val = 0x00000000 },
	{ .addr = 0x00f1017f54, .val = 0x00000000 },
	{ .addr = 0x00f1017f58, .val = 0x00000000 },
	{ .addr = 0x00f1017f5c, .val = 0x00000000 },
	{ .addr = 0x00f1017f60, .val = 0x00000000 },
	{ .addr = 0x00f1017f64, .val = 0x00000000 },
	{ .addr = 0x00f1017f68, .val = 0x00000000 },
	{ .addr = 0x00f1017f6c, .val = 0x00000000 },
	{ .addr = 0x00f1017f70, .val = 0x00000000 },
	{ .addr = 0x00f1017f74, .val = 0x00000000 },
	{ .addr = 0x00f1017f78, .val = 0x00000000 },
	{ .addr = 0x00f1017f7c, .val = 0x00000000 },
	{ .addr = 0x00f1017f80, .val = 0x00000000 },
	{ .addr = 0x00f1017f84, .val = 0x00000000 },
	{ .addr = 0x00f1017f88, .val = 0x00000000 },
	{ .addr = 0x00f1017f8c, .val = 0x00000000 },
	{ .addr = 0x00f1017f90, .val = 0x00000000 },
	{ .addr = 0x00f1017f94, .val = 0x00000000 },
	{ .addr = 0x00f1017f98, .val = 0x00000000 },
	{ .addr = 0x00f1017f9c, .val = 0x00000000 },
	{ .addr = 0x00f1017fa0, .val = 0x00000000 },
	{ .addr = 0x00f1017fa4, .val = 0x00000000 },
	{ .addr = 0x00f1017fa8, .val = 0x00000000 },
	{ .addr = 0x00f1017fac, .val = 0x00000000 },
	{ .addr = 0x00f1017fb0, .val = 0x00000000 },
	{ .addr = 0x00f1017fb4, .val = 0x00000000 },
	{ .addr = 0x00f1017fb8, .val = 0x00000000 },
	{ .addr = 0x00f1017fbc, .val = 0x00000000 },
	{ .addr = 0x00f1017fc0, .val = 0x00000000 },
	{ .addr = 0x00f1017fc4, .val = 0x00000000 },
	{ .addr = 0x00f1017fc8, .val = 0x00000000 },
	{ .addr = 0x00f1017fcc, .val = 0x00000000 },
	{ .addr = 0x00f1017fd0, .val = 0x00000000 },
	{ .addr = 0x00f1017fd4, .val = 0x00000000 },
	{ .addr = 0x00f1017fd8, .val = 0x00000000 },
	{ .addr = 0x00f1017fdc, .val = 0x00000000 },
	{ .addr = 0x00f1017fe0, .val = 0x00000000 },
	{ .addr = 0x00f1017fe4, .val = 0x00000000 },
	{ .addr = 0x00f1017fe8, .val = 0x00000000 },
	{ .addr = 0x00f1017fec, .val = 0x00000000 },
	{ .addr = 0x00f1017ff0, .val = 0x00000000 },
	{ .addr = 0x00f1017ff4, .val = 0x00000000 },
	{ .addr = 0x00f1017ff8, .val = 0x00000000 },
	{ .addr = 0x00f1017ffc, .val = 0x00000000 },
	{ .addr = 0x00f1018000, .val = 0x00000000 },
	{ .addr = 0x00f1018004, .val = 0x00000000 },
	{ .addr = 0x00f1018008, .val = 0x00000000 },
	{ .addr = 0x00f101800c, .val = 0x00000000 },
	{ .addr = 0x00f1018010, .val = 0x00000000 },
	{ .addr = 0x00f1018014, .val = 0x00000000 },
	{ .addr = 0x00f1018018, .val = 0x00000000 },
	{ .addr = 0x00f101801c, .val = 0x00000000 },
	{ .addr = 0x00f1018020, .val = 0x00000000 },
	{ .addr = 0x00f1018024, .val = 0x00000000 },
	{ .addr = 0x00f1018028, .val = 0x00000000 },
	{ .addr = 0x00f101802c, .val = 0x00000000 },
	{ .addr = 0x00f1018030, .val = 0x00000000 },
	{ .addr = 0x00f1018034, .val = 0x00000000 },
	{ .addr = 0x00f1018038, .val = 0x00000000 },
	{ .addr = 0x00f101803c, .val = 0x00000000 },
	{ .addr = 0x00f1018040, .val = 0x00000000 },
	{ .addr = 0x00f1018044, .val = 0x00000000 },
	{ .addr = 0x00f1018048, .val = 0x00000000 },
	{ .addr = 0x00f101804c, .val = 0x00000000 },
	{ .addr = 0x00f1018050, .val = 0x00000000 },
	{ .addr = 0x00f1018054, .val = 0x00000000 },
	{ .addr = 0x00f1018058, .val = 0x00000000 },
	{ .addr = 0x00f101805c, .val = 0x00000000 },
	{ .addr = 0x00f1018060, .val = 0x00000000 },
	{ .addr = 0x00f1018064, .val = 0x00000000 },
	{ .addr = 0x00f1018068, .val = 0x00000000 },
	{ .addr = 0x00f101806c, .val = 0x00000000 },
	{ .addr = 0x00f1018070, .val = 0x00000000 },
	{ .addr = 0x00f1018074, .val = 0x00000000 },
	{ .addr = 0x00f1018078, .val = 0x00000000 },
	{ .addr = 0x00f101807c, .val = 0x00000000 },
	{ .addr = 0x00f1018080, .val = 0x00000000 },
	{ .addr = 0x00f1018084, .val = 0x00000000 },
	{ .addr = 0x00f1018088, .val = 0x00000000 },
	{ .addr = 0x00f101808c, .val = 0x00000000 },
	{ .addr = 0x00f1018090, .val = 0x00000000 },
	{ .addr = 0x00f1018094, .val = 0x00000000 },
	{ .addr = 0x00f1018098, .val = 0x00000000 },
	{ .addr = 0x00f101809c, .val = 0x00000000 },
	{ .addr = 0x00f10180a0, .val = 0x00000000 },
	{ .addr = 0x00f10180a4, .val = 0x00000000 },
	{ .addr = 0x00f10180a8, .val = 0x00000000 },
	{ .addr = 0x00f10180ac, .val = 0x00000000 },
	{ .addr = 0x00f10180b0, .val = 0x00000000 },
	{ .addr = 0x00f10180b4, .val = 0x00000000 },
	{ .addr = 0x00f10180b8, .val = 0x00000000 },
	{ .addr = 0x00f10180bc, .val = 0x00000000 },
	{ .addr = 0x00f10180c0, .val = 0x00000000 },
	{ .addr = 0x00f10180c4, .val = 0x00000000 },
	{ .addr = 0x00f10180c8, .val = 0x00000000 },
	{ .addr = 0x00f10180cc, .val = 0x00000000 },
	{ .addr = 0x00f10180d0, .val = 0x00000000 },
	{ .addr = 0x00f10180d4, .val = 0x00000000 },
	{ .addr = 0x00f10180d8, .val = 0x00000000 },
	{ .addr = 0x00f10180dc, .val = 0x00000000 },
	{ .addr = 0x00f10180e0, .val = 0x00000000 },
	{ .addr = 0x00f10180e4, .val = 0x00000000 },
	{ .addr = 0x00f10180e8, .val = 0x00000000 },
	{ .addr = 0x00f10180ec, .val = 0x00000000 },
	{ .addr = 0x00f10180f0, .val = 0x00000000 },
	{ .addr = 0x00f10180f4, .val = 0x00000000 },
	{ .addr = 0x00f10180f8, .val = 0x00000000 },
	{ .addr = 0x00f10180fc, .val = 0x00000000 },
	{ .addr = 0x00f1018100, .val = 0x00000000 },
	{ .addr = 0x00f1018104, .val = 0x00000000 },
	{ .addr = 0x00f1018108, .val = 0x00000000 },
	{ .addr = 0x00f101810c, .val = 0x00000000 },
	{ .addr = 0x00f1018110, .val = 0x00000000 },
	{ .addr = 0x00f1018114, .val = 0x00000000 },
	{ .addr = 0x00f1018118, .val = 0x00000000 },
	{ .addr = 0x00f101811c, .val = 0x00000000 },
	{ .addr = 0x00f1018120, .val = 0x00000000 },
	{ .addr = 0x00f1018124, .val = 0x00000000 },
	{ .addr = 0x00f1018128, .val = 0x00000000 },
	{ .addr = 0x00f101812c, .val = 0x00000000 },
	{ .addr = 0x00f1018130, .val = 0x00000000 },
	{ .addr = 0x00f1018134, .val = 0x00000000 },
	{ .addr = 0x00f1018138, .val = 0x00000000 },
	{ .addr = 0x00f101813c, .val = 0x00000000 },
	{ .addr = 0x00f1018140, .val = 0x00000000 },
	{ .addr = 0x00f1018144, .val = 0x00000000 },
	{ .addr = 0x00f1018148, .val = 0x00000000 },
	{ .addr = 0x00f101814c, .val = 0x00000000 },
	{ .addr = 0x00f1018150, .val = 0x00000000 },
	{ .addr = 0x00f1018154, .val = 0x00000000 },
	{ .addr = 0x00f1018158, .val = 0x00000000 },
	{ .addr = 0x00f101815c, .val = 0x00000000 },
	{ .addr = 0x00f1018160, .val = 0x00000000 },
	{ .addr = 0x00f1018164, .val = 0x00000000 },
	{ .addr = 0x00f1018168, .val = 0x00000000 },
	{ .addr = 0x00f101816c, .val = 0x00000000 },
	{ .addr = 0x00f1018170, .val = 0x00000000 },
	{ .addr = 0x00f1018174, .val = 0x00000000 },
	{ .addr = 0x00f1018178, .val = 0x00000000 },
	{ .addr = 0x00f101817c, .val = 0x00000000 },
	{ .addr = 0x00f1018180, .val = 0x00000000 },
	{ .addr = 0x00f1018184, .val = 0x00000000 },
	{ .addr = 0x00f1018188, .val = 0x00000000 },
	{ .addr = 0x00f101818c, .val = 0x00000000 },
	{ .addr = 0x00f1018190, .val = 0x00000000 },
	{ .addr = 0x00f1018194, .val = 0x00000000 },
	{ .addr = 0x00f1018198, .val = 0x00000000 },
	{ .addr = 0x00f101819c, .val = 0x00000000 },
	{ .addr = 0x00f10181a0, .val = 0x00000000 },
	{ .addr = 0x00f10181a4, .val = 0x00000000 },
	{ .addr = 0x00f10181a8, .val = 0x00000000 },
	{ .addr = 0x00f10181ac, .val = 0x00000000 },
	{ .addr = 0x00f10181b0, .val = 0x00000000 },
	{ .addr = 0x00f10181b4, .val = 0x00000000 },
	{ .addr = 0x00f10181b8, .val = 0x00000000 },
	{ .addr = 0x00f10181bc, .val = 0x00000000 },
	{ .addr = 0x00f10181c0, .val = 0x00000000 },
	{ .addr = 0x00f10181c4, .val = 0x00000000 },
	{ .addr = 0x00f10181c8, .val = 0x00000000 },
	{ .addr = 0x00f10181cc, .val = 0x00000000 },
	{ .addr = 0x00f10181d0, .val = 0x00000000 },
	{ .addr = 0x00f10181d4, .val = 0x00000000 },
	{ .addr = 0x00f10181d8, .val = 0x00000000 },
	{ .addr = 0x00f10181dc, .val = 0x00000000 },
	{ .addr = 0x00f10181e0, .val = 0x00000000 },
	{ .addr = 0x00f10181e4, .val = 0x00000000 },
	{ .addr = 0x00f10181e8, .val = 0x00000000 },
	{ .addr = 0x00f10181ec, .val = 0x00000000 },
	{ .addr = 0x00f10181f0, .val = 0x00000000 },
	{ .addr = 0x00f10181f4, .val = 0x00000000 },
	{ .addr = 0x00f10181f8, .val = 0x00000000 },
	{ .addr = 0x00f10181fc, .val = 0x00000000 },
	{ .addr = 0x00f1018200, .val = 0x00000000 },
	{ .addr = 0x00f1018204, .val = 0x00000000 },
	{ .addr = 0x00f1018208, .val = 0x00000000 },
	{ .addr = 0x00f101820c, .val = 0x00000000 },
	{ .addr = 0x00f1018210, .val = 0x00000000 },
	{ .addr = 0x00f1018214, .val = 0x00000000 },
	{ .addr = 0x00f1018218, .val = 0x00000000 },
	{ .addr = 0x00f101821c, .val = 0x00000000 },
	{ .addr = 0x00f1018220, .val = 0x00000000 },
	{ .addr = 0x00f1018224, .val = 0x00000000 },
	{ .addr = 0x00f1018228, .val = 0x00000000 },
	{ .addr = 0x00f101822c, .val = 0x00000000 },
	{ .addr = 0x00f1018230, .val = 0x00000000 },
	{ .addr = 0x00f1018234, .val = 0x00000000 },
	{ .addr = 0x00f1018238, .val = 0x00000000 },
	{ .addr = 0x00f101823c, .val = 0x00000000 },
	{ .addr = 0x00f1018240, .val = 0x00000000 },
	{ .addr = 0x00f1018244, .val = 0x00000000 },
	{ .addr = 0x00f1018248, .val = 0x00000000 },
	{ .addr = 0x00f101824c, .val = 0x00000000 },
	{ .addr = 0x00f1018250, .val = 0x00000000 },
	{ .addr = 0x00f1018254, .val = 0x00000000 },
	{ .addr = 0x00f1018258, .val = 0x00000000 },
	{ .addr = 0x00f101825c, .val = 0x00000000 },
	{ .addr = 0x00f1018260, .val = 0x00000000 },
	{ .addr = 0x00f1018264, .val = 0x00000000 },
	{ .addr = 0x00f1018268, .val = 0x00000000 },
	{ .addr = 0x00f101826c, .val = 0x00000000 },
	{ .addr = 0x00f1018270, .val = 0x00000000 },
	{ .addr = 0x00f1018274, .val = 0x00000000 },
	{ .addr = 0x00f1018278, .val = 0x00000000 },
	{ .addr = 0x00f101827c, .val = 0x00000000 },
	{ .addr = 0x00f1018280, .val = 0x00000000 },
	{ .addr = 0x00f1018284, .val = 0x00000000 },
	{ .addr = 0x00f1018288, .val = 0x00000000 },
	{ .addr = 0x00f101828c, .val = 0x00000000 },
	{ .addr = 0x00f1018290, .val = 0x00000000 },
	{ .addr = 0x00f1018294, .val = 0x00000000 },
	{ .addr = 0x00f1018298, .val = 0x00000000 },
	{ .addr = 0x00f101829c, .val = 0x00000000 },
	{ .addr = 0x00f10182a0, .val = 0x00000000 },
	{ .addr = 0x00f10182a4, .val = 0x00000000 },
	{ .addr = 0x00f10182a8, .val = 0x00000000 },
	{ .addr = 0x00f10182ac, .val = 0x00000000 },
	{ .addr = 0x00f10182b0, .val = 0x00000000 },
	{ .addr = 0x00f10182b4, .val = 0x00000000 },
	{ .addr = 0x00f10182b8, .val = 0x00000000 },
	{ .addr = 0x00f10182bc, .val = 0x00000000 },
	{ .addr = 0x00f10182c0, .val = 0x00000000 },
	{ .addr = 0x00f10182c4, .val = 0x00000000 },
	{ .addr = 0x00f10182c8, .val = 0x00000000 },
	{ .addr = 0x00f10182cc, .val = 0x00000000 },
	{ .addr = 0x00f10182d0, .val = 0x00000000 },
	{ .addr = 0x00f10182d4, .val = 0x00000000 },
	{ .addr = 0x00f10182d8, .val = 0x00000000 },
	{ .addr = 0x00f10182dc, .val = 0x00000000 },
	{ .addr = 0x00f10182e0, .val = 0x00000000 },
	{ .addr = 0x00f10182e4, .val = 0x00000000 },
	{ .addr = 0x00f10182e8, .val = 0x00000000 },
	{ .addr = 0x00f10182ec, .val = 0x00000000 },
	{ .addr = 0x00f10182f0, .val = 0x00000000 },
	{ .addr = 0x00f10182f4, .val = 0x00000000 },
	{ .addr = 0x00f10182f8, .val = 0x00000000 },
	{ .addr = 0x00f10182fc, .val = 0x00000000 },
	{ .addr = 0x00f1018300, .val = 0x00000000 },
	{ .addr = 0x00f1018304, .val = 0x00000000 },
	{ .addr = 0x00f1018308, .val = 0x00000000 },
	{ .addr = 0x00f101830c, .val = 0x00000000 },
	{ .addr = 0x00f1018310, .val = 0x00000000 },
	{ .addr = 0x00f1018314, .val = 0x00000000 },
	{ .addr = 0x00f1018318, .val = 0x00000000 },
	{ .addr = 0x00f101831c, .val = 0x00000000 },
	{ .addr = 0x00f1018320, .val = 0x00000000 },
	{ .addr = 0x00f1018324, .val = 0x00000000 },
	{ .addr = 0x00f1018328, .val = 0x00000000 },
	{ .addr = 0x00f101832c, .val = 0x00000000 },
	{ .addr = 0x00f1018330, .val = 0x00000000 },
	{ .addr = 0x00f1018334, .val = 0x00000000 },
	{ .addr = 0x00f1018338, .val = 0x00000000 },
	{ .addr = 0x00f101833c, .val = 0x00000000 },
	{ .addr = 0x00f1018340, .val = 0x00000000 },
	{ .addr = 0x00f1018344, .val = 0x00000000 },
	{ .addr = 0x00f1018348, .val = 0x00000000 },
	{ .addr = 0x00f101834c, .val = 0x00000000 },
	{ .addr = 0x00f1018350, .val = 0x00000000 },
	{ .addr = 0x00f1018354, .val = 0x00000000 },
	{ .addr = 0x00f1018358, .val = 0x00000000 },
	{ .addr = 0x00f101835c, .val = 0x00000000 },
	{ .addr = 0x00f1018360, .val = 0x00000000 },
	{ .addr = 0x00f1018364, .val = 0x00000000 },
	{ .addr = 0x00f1018368, .val = 0x00000000 },
	{ .addr = 0x00f101836c, .val = 0x00000000 },
	{ .addr = 0x00f1018370, .val = 0x00000000 },
	{ .addr = 0x00f1018374, .val = 0x00000000 },
	{ .addr = 0x00f1018378, .val = 0x00000000 },
	{ .addr = 0x00f101837c, .val = 0x00000000 },
	{ .addr = 0x00f1018380, .val = 0x00000000 },
	{ .addr = 0x00f1018384, .val = 0x00000000 },
	{ .addr = 0x00f1018388, .val = 0x00000000 },
	{ .addr = 0x00f101838c, .val = 0x00000000 },
	{ .addr = 0x00f1018390, .val = 0x00000000 },
	{ .addr = 0x00f1018394, .val = 0x00000000 },
	{ .addr = 0x00f1018398, .val = 0x00000000 },
	{ .addr = 0x00f101839c, .val = 0x00000000 },
	{ .addr = 0x00f10183a0, .val = 0x00000000 },
	{ .addr = 0x00f10183a4, .val = 0x00000000 },
	{ .addr = 0x00f10183a8, .val = 0x00000000 },
	{ .addr = 0x00f10183ac, .val = 0x00000000 },
	{ .addr = 0x00f10183b0, .val = 0x00000000 },
	{ .addr = 0x00f10183b4, .val = 0x00000000 },
	{ .addr = 0x00f10183b8, .val = 0x00000000 },
	{ .addr = 0x00f10183bc, .val = 0x00000000 },
	{ .addr = 0x00f10183c0, .val = 0x00000000 },
	{ .addr = 0x00f10183c4, .val = 0x00000000 },
	{ .addr = 0x00f10183c8, .val = 0x00000000 },
	{ .addr = 0x00f10183cc, .val = 0x00000000 },
	{ .addr = 0x00f10183d0, .val = 0x00000000 },
	{ .addr = 0x00f10183d4, .val = 0x00000000 },
	{ .addr = 0x00f10183d8, .val = 0x00000000 },
	{ .addr = 0x00f10183dc, .val = 0x00000000 },
	{ .addr = 0x00f10183e0, .val = 0x00000000 },
	{ .addr = 0x00f10183e4, .val = 0x00000000 },
	{ .addr = 0x00f10183e8, .val = 0x00000000 },
	{ .addr = 0x00f10183ec, .val = 0x00000000 },
	{ .addr = 0x00f10183f0, .val = 0x00000000 },
	{ .addr = 0x00f10183f4, .val = 0x00000000 },
	{ .addr = 0x00f10183f8, .val = 0x00000000 },
	{ .addr = 0x00f10183fc, .val = 0x00000000 },
	{ .addr = 0x00f1018400, .val = 0x00000000 },
	{ .addr = 0x00f1018404, .val = 0x00000000 },
	{ .addr = 0x00f1018408, .val = 0x00000000 },
	{ .addr = 0x00f101840c, .val = 0x00000000 },
	{ .addr = 0x00f1018410, .val = 0x00000000 },
	{ .addr = 0x00f1018414, .val = 0x00000000 },
	{ .addr = 0x00f1018418, .val = 0x00000000 },
	{ .addr = 0x00f101841c, .val = 0x00000000 },
	{ .addr = 0x00f1018420, .val = 0x00000000 },
	{ .addr = 0x00f1018424, .val = 0x00000000 },
	{ .addr = 0x00f1018428, .val = 0x00000000 },
	{ .addr = 0x00f101842c, .val = 0x00000000 },
	{ .addr = 0x00f1018430, .val = 0x00000000 },
	{ .addr = 0x00f1018434, .val = 0x00000000 },
	{ .addr = 0x00f1018438, .val = 0x00000000 },
	{ .