#ifndef __INTEL_PRX300_CLK_H_
#define __INTEL_PRX300_CLK_H_

/* PLL clocks */
#define PRX300_CLK_PLL0A	2
#define PRX300_CLK_PLL0B	3
#define PRX300_CLK_PLL1		4
#define PRX300_CLK_PLL2		5
#define PRX300_CLK_LJPLL3	6
#define PRX300_CLK_LJPLL4	7
#define PRX300_CLK_LJPLL5	8

/* clocks from PLLs */
/* ROPLL0A */
#define PRX300_CLK_CPU		20
#define PRX300_CLK_QSPI		21
/* ROPLL0B */
#define PRX300_CLK_SW		25
#define PRX300_CLK_SSX4		26
#define PRX300_CLK_NGI		27
#define PRX300_CLK_PPV4		28
/* ROPLL1 */
#define PRX300_CLK_DSP		30
#define PRX300_CLK_IF		31
/* ROPLL2 */
#define PRX300_CLK_DDR		35
/* LJPLL3  */
#define PRX300_CLK_GPHY		40
#define PRX300_CLK_CBPHY	41
#define PRX300_CLK_POOL		42
#define PRX300_CLK_PTP		43
/* LJPLL4 */
#define PRX300_CLK_PCIE		45
/* LJPLL5 */
#define PRX300_CLK_PONPHY	50
#define PRX300_CLK_PONIP	51

#define PRX300_CLK_SLIC		55
#define PRX300_CLK_PONDEF	56

/* Gate0 clock shift */
#define PRX300_GCLK_XBAR0	80
#define PRX300_GCLK_XBAR1	81
#define PRX300_GCLK_XBAR7	82

/* clocks under gate1-clk */
#define PRX300_GCLK_V_CODEC	85
#define PRX300_GCLK_DMA0	86
#define PRX300_GCLK_I2C0	87
#define PRX300_GCLK_I2C1	88
#define PRX300_GCLK_I2C2	89
#define PRX300_GCLK_SPI1	90
#define PRX300_GCLK_SPI0	91
#define PRX300_GCLK_QSPI	92
#define PRX300_GCLK_CQEM	93
#define PRX300_GCLK_SSO		94
#define PRX300_GCLK_GPTC0	95
#define PRX300_GCLK_GPTC1	96
#define PRX300_GCLK_GPTC2	97
#define PRX300_GCLK_URT0	98
#define PRX300_GCLK_URT1	99
#define PRX300_GCLK_SECPT	100
#define PRX300_GCLK_SCPU	101
#define PRX300_GCLK_MPE		102
#define PRX300_GCLK_TDM		103
#define PRX300_GCLK_PP		104
#define PRX300_GCLK_DMA3	105
#define PRX300_GCLK_SWITCH	106
#define PRX300_GCLK_PON		107
#define PRX300_GCLK_AON		108
#define PRX300_GCLK_DDR		109

/* clocks under gate2-clk */
#define PRX300_GCLK_PCIE_CTRL0	110
#define PRX300_GCLK_MSI0	111
#define PRX300_GCLK_PD0		112
#define PRX300_GCLK_PCIE_CTRL1	113
#define PRX300_GCLK_MSI1	114
#define PRX300_GCLK_PD1		115
#define PRX300_GCLK_ASPI	116
#define PRX300_GCLK_ADMA	117
#define PRX300_GCLK_AHIF	118
#define PRX300_GCLK_ASL		119

/* clocks under gate3-clk */
#define PRX300_GCLK_SWREF	120
#define PRX300_GCLK_CBPHY0	121
#define PRX300_GCLK_CBPHY1	122

#define PRX300_CLK_NR_CLKS	128

#endif /* __INTEL_PRX300_CLK_H_ */
