#ifndef _NETFILTER_NF_NAT_H
#define _NETFILTER_NF_NAT_H

#include <linux/netfilter.h>
#include <linux/netfilter/nf_conntrack_tuple_common.h>

#define NF_NAT_RANGE_MAP_IPS			(1 << 0)
#define NF_NAT_RANGE_PROTO_SPECIFIED		(1 << 1)
#define NF_NAT_RANGE_PROTO_RANDOM		(1 << 2)
#define NF_NAT_RANGE_PERSISTENT			(1 << 3)
#define NF_NAT_RANGE_PROTO_RANDOM_FULLY		(1 << 4)

#define NF_NAT_RANGE_PROTO_RANDOM_ALL		\
	(NF_NAT_RANGE_PROTO_RANDOM | NF_NAT_RANGE_PROTO_RANDOM_FULLY)

#define NF_NAT_RANGE_MASK					\
	(NF_NAT_RANGE_MAP_IPS | NF_NAT_RANGE_PROTO_SPECIFIED |	\
	 NF_NAT_RANGE_PROTO_RANDOM | NF_NAT_RANGE_PERSISTENT |	\
	 NF_NAT_RANGE_PROTO_RANDOM_FULLY)

#ifdef CONFIG_SNAT_MAPE
//---   2020-0103 For Map-E SNAPT flow.
#define MAP_NAPT_MARK       	(1)
#define MAPE_DEBUG		(0)

#if( MAPE_DEBUG==1)
	#define print_mape(fmt, ...)	printk("[ALPHA]"fmt, ##__VA_ARGS__)
#else
	#define print_mape(fmt, ...)
#endif
#endif  //---   CONFIG_SNAT_MAPE end

struct nf_nat_ipv4_range {
	unsigned int			flags;
	__be32				min_ip;
	__be32				max_ip;
	union nf_conntrack_man_proto	min;
	union nf_conntrack_man_proto	max;
};

struct nf_nat_ipv4_multi_range_compat {
	unsigned int			rangesize;
	struct nf_nat_ipv4_range	range[1];
};

struct nf_nat_range {
	unsigned int			flags;
	union nf_inet_addr		min_addr;
	union nf_inet_addr		max_addr;
	union nf_conntrack_man_proto	min_proto;
	union nf_conntrack_man_proto	max_proto;
};

#ifdef CONFIG_SNAT_MAPE
//---   2020-0103 For Map-E SNAPT flow.
extern bool	mape_enable;
extern u16	mape_psid;
extern int	mape_psid_length;
extern int	mape_psid_offset;
#endif  //---   CONFIG_SNAT_MAPE end

#endif /* _NETFILTER_NF_NAT_H */
