/*
 * IPv6 passthrough 
 * This module is used to pass through the IPv6 packets
 * 
 * Peter Wu 20050804
 */

#include <linux/netdevice.h>
#include <linux/proc_fs.h>
#include <net/sock.h>

extern struct net_device	*dev_get_by_name(struct net *net, const char *name);
extern int		dev_set_promiscuity(struct net_device *dev, int inc);
extern int dev_queue_xmit(struct sk_buff *skb);

int ipv6_pt_enable = 0;

char ipv6_pt_landev[IFNAMSIZ];
char ipv6_pt_wandev[IFNAMSIZ];
#define ETH_TYPE_IPV6	0x86dd

#ifdef CONFIG_BRIDGE_MLD_MANAGER
#include <linux/etherdevice.h>
#include <linux/in6.h>
#include <net/mld.h>
#include <linux/icmpv6.h>
#include "../bridge/br_private.h"

#define IPV6_MULTICAST_MAC(mac) ((mac[0]==0x33)&&(mac[1]==0x33) && mac[2]!=0xff)

extern int getIpv6TransportProtocol(struct ipv6hdr* ipv6h);
extern void CIPV6toMac(unsigned char* icmpv6_McastAddr, unsigned char *gmac );
extern char ICMPv6_check(struct sk_buff *skb , unsigned char *gmac, unsigned int *gIndex,unsigned int *moreFlag);
extern void write_alpha_multicast (unsigned char op, struct net_bridge *br, unsigned char *dest, struct sk_buff *skb);
#endif

/* return 1, if we want to handle this packet, or
 * return 0, let other ones do this	 */
int ipv6_pthrough(struct sk_buff *skb)
{
	unsigned short proto;
	unsigned char *smac;
	unsigned char *dmac;
	struct net_device *dev;
	struct ethhdr *eth = eth_hdr(skb);
	struct net *net = sock_net(skb->sk);

	/* check if ipv6 pass through enabled or not
	 * if not set yet, just return and do nothing */
	if (!ipv6_pt_enable) return 0;
	
	// check and forward packets
	proto = eth->h_proto;
	dmac = eth->h_dest;
	smac = eth->h_source;
//	proto = skb->mac.ethernet->h_proto;
//	smac = skb->mac.ethernet->h_source;
//	dmac = skb->mac.ethernet->h_dest;

	if (proto == htons(ETH_TYPE_IPV6)) {
		if (strcmp(skb->dev->name, ipv6_pt_landev) == 0) {
//			printk("PeTeR: IPv6 OutGoing packet (%s)\n", skb->dev->name);
//			printk("PeTeR: skb->dev (%s->%s)\n", ipv6_pt_landev, ipv6_pt_wandev);
#ifdef CONFIG_BRIDGE_MLD_MANAGER
			const unsigned char *dest = eth_hdr(skb)->h_dest;
			struct net_bridge *br = netdev_priv(skb->dev);
			if (is_multicast_ether_addr(dest))
			{
				struct ipv6hdr *ipv6h=NULL;
				unsigned char proto=0;
				unsigned char macAddr[6];
				unsigned char operation;
				char tmpOp;
				unsigned int gIndex=0;
				unsigned int moreFlag=1;
				
				if(IPV6_MULTICAST_MAC(dest)
					&& (eth_hdr(skb)->h_proto == htons(ETH_P_IPV6)))
				{
					ipv6h=(struct ipv6hdr *)skb_network_header(skb);
					proto =  getIpv6TransportProtocol(ipv6h);
					/*icmp protocol*/
					if (proto == IPPROTO_ICMPV6) 
					{
#if 0
						if(net_ratelimit())
							printk("[%s:%d]ipv6 ICMPV6,\n",__FUNCTION__,__LINE__);		
#endif
						while(moreFlag)
						{
							tmpOp=ICMPv6_check(skb , macAddr, &gIndex, &moreFlag);
							if(tmpOp > 0)
							{
								operation=(unsigned char)tmpOp;
#if 0
								if( operation == 1)
									printk("icmpv6 add from frame finish\n");
								else if(operation == 2)
									printk("icmpv6 del from frame finish\n");
#endif
								write_alpha_multicast(operation, br, macAddr, skb);
							}
						}
					}
				}
			}
#endif
			dev = dev_get_by_name(net, ipv6_pt_wandev);
			if (!dev)
				return 0;
			else {
				skb->dev=dev;
				dev_put(skb->dev);
			}
			skb_push(skb, ETH_HLEN);
			dev_queue_xmit(skb);
			return 1;
		}
		if (strcmp(skb->dev->name, ipv6_pt_wandev) == 0) {
//			printk("PeTeR: IPv6 Incoming packet (%s)\n", skb->dev->name);
			dev = dev_get_by_name(net, ipv6_pt_landev);
			if (!dev)
				return 0;
			else {
				skb->dev=dev;
				dev_put(skb->dev);
			}
			skb_push(skb, ETH_HLEN);
			dev_queue_xmit(skb);
			return 1;
		}
	}

	return 0;
}
/*Modify function parameters in kernel version 3.10 */
int proc_ipv6_read(struct file *filp,char *buf,size_t count,loff_t *offp)
{
	if (ipv6_pt_enable) {
		sprintf(buf, "%s,%s\n", ipv6_pt_landev, ipv6_pt_wandev);
		printk("%s\n",buf);
	} else {
		sprintf(buf, "null,null\n");
		printk("%s\n",buf);
	}

	return 0;
}

#define isCHAR(x) ((x >= 'a') && (x <= 'z')) ? 1:((x >= '0') && (x <= '9')) ? 1:((x >= 'A') && (x <= 'Z')) ? 1:(x == '.') ? 1:0
int proc_ipv6_write(struct file *filp,char *buf,size_t count,loff_t *offp)
{
	char *pt;
	struct net_device *dev;

	if (ipv6_pt_enable) {
		ipv6_pt_enable = 0;
		if ((dev = dev_get_by_name(&init_net, ipv6_pt_landev))) {
			rtnl_lock();
			dev_set_promiscuity(dev, -1);
			rtnl_unlock();
			dev_put(dev);
		}
		if ((dev = dev_get_by_name(&init_net, ipv6_pt_wandev))) {
			rtnl_lock();
			dev_set_promiscuity(dev, -1);
			rtnl_unlock();
			dev_put(dev);
		}
	}

	/* we expect that buf contain format of "ipv6_pt_landev,ipv6_pt_wandev" */
	memset(ipv6_pt_landev, 0x0, sizeof (ipv6_pt_landev));
	for (pt=ipv6_pt_landev; *buf && (*buf != ','); buf++) {
		if ((*buf != ' ') && isCHAR(*buf)) {
			*pt = *buf;
			pt++;
		}
	}
	
	if (!(*buf))	goto ppw_failed;
	
	memset(ipv6_pt_wandev, 0x0, sizeof (ipv6_pt_wandev));
	for (pt=ipv6_pt_wandev, buf++; *buf; buf++) {
		if ((*buf != ' ') && isCHAR(*buf)) {
			*pt = *buf;
			pt++;
		}
	}
	
	if (!(dev = dev_get_by_name(&init_net, ipv6_pt_landev))) goto ppw_failed;
	else 
	{
		rtnl_lock();
		dev_set_promiscuity(dev, 1);
		rtnl_unlock();
		dev_put(dev);
	}
	if (!(dev = dev_get_by_name(&init_net, ipv6_pt_wandev))) goto ppw_failed;
	else 
	{
		rtnl_lock();
		dev_set_promiscuity(dev, 1);
		rtnl_unlock();
		dev_put(dev);
	}
	
	ipv6_pt_enable = 1;
	printk("ipv6 pass through (%s<->%s)\n",ipv6_pt_landev, ipv6_pt_wandev);
	return count;
	
ppw_failed:
	ipv6_pt_enable = 0;
	memset(ipv6_pt_landev, 0x0, sizeof (ipv6_pt_landev));
	memset(ipv6_pt_wandev, 0x0, sizeof (ipv6_pt_wandev));
//	printk("failed\n");

	return count;
}

