

#define _GNU_SOURCE 1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <signal.h>
#include <getopt.h>
#include <unistd.h>
#include <syslog.h>
#include <stdarg.h>

#include "pppoe.h"
#include "detect.h"

//#include "version.h"
#define	VERSION	"0.0.1"

/******************************************************************************/
/******************************************************************************/

/* from rp-pppoe/src/pppoe.c */
static void  usage(char const *argv0)
{
    fprintf(stderr, "Usage: %s [options]\n", argv0);
    fprintf(stderr, "Options:\n");
    fprintf(stderr, "   -I if_name     -- Specify interface (REQUIRED)\n");
    fprintf(stderr,
	    "   -h             -- Print usage information.\n\n"
	    "PPPoE Version %s, Copyright (C) 2001-2006 Roaring Penguin Software Inc.\n"
	    "PPPoE comes with ABSOLUTELY NO WARRANTY.\n"
	    "This is free software, and you are welcome to redistribute it under the terms\n"
	    "of the GNU General Public License, version 2 or any later version.\n"
	    "http://www.roaringpenguin.com\n", VERSION);
    exit(EXIT_SUCCESS);
}


/*
 */
int  main( int  argc, char*  argv[] )
{
	char const*		options;
	int			opt;
	char*		tmpopt_I = NULL;
	int			conn = 0;
	int			res = 0;

	options = "I:";

	while( (opt = getopt( argc, argv, options )) != -1 ){
		switch(opt) {
		case 'I':
			if( tmpopt_I == NULL ){
				if( (tmpopt_I = strdup( optarg )) == NULL ){
					return 0;
				}
			}
			break;
		default:
			usage(argv[0]);
			return 0;
		}
	}

	if( tmpopt_I == NULL ) return 0;

	openlog( basename( argv[0] ), LOG_NDELAY | LOG_PID, LOG_USER );
	
	/******************************************/
	
	if(pppoe_init( tmpopt_I ) != 1)
	{
		free( tmpopt_I );
		return 0;
	}

	free( tmpopt_I );

	if (PPPOEConnectDevice()==0)
	{
		printf("yes\n");
		FILE *fp=fopen("/tmp/recv_pado", "w");
		return 0;
	}
	else
	{
		printf("no\n");
		remove("/tmp/recv_pado");
		return 0;
	}
	
	/******************************************/
}


/*
 * EOF
 */
