
#include <asm/io.h>
#include <common.h>
#include <lantiq.h>

#define M4KEC_ONLY	0x1
#define CPU0		0x2
#define CPU1		0x4
#define CPU2		0x8
#define CPU3		0x10
#define OTHERS		0x20
#define	EIP123		0x40
#define IAP_N_4KEC	M4KEC_ONLY | CPU0 | CPU1 | CPU2 | CPU3
#define	GRP0_TO_4	M4KEC_ONLY | CPU0 | CPU1 | CPU2 | CPU3 | OTHERS
#define	ALL_CPUS	GRP0_TO_4 | 0x40

static u32 permission_wr(u32 base, u32 offset, u32 val)
{
	ltq_w32(base, offset, val);
	return 0;
}

void set_permission(void)
{
#if 0
	REG32(0xB8080050) = 0x01;	//TPM_TREG0 - only 4kec access 00000-7ffff
	REG32(0xB8080058) = 0x01;
	REG32(0xB8080C50) = 0x3F;	//TOTP_TOTP
	REG32(0xB8080C58) = 0x3F;
	REG32(0xB8081050) = 0x3F;	//TCBM1_TCBM1
	REG32(0xB8081058) = 0x3F;
	REG32(0xB8081450) = 0x3F;	//TCBM2_TCBM2
	REG32(0xB8081458) = 0x3F;
	REG32(0xB8081C50) = 0x01;	//TE123_TE123
	REG32(0xB8081C58) = 0x01;
	REG32(0xB8082050) = 0x3F;	//TDMA3_TDM3
	REG32(0xB8082058) = 0x3F;
	REG32(0xB8082450) = 0x3F;	//TDMAT1_TDMAT1
	REG32(0xB8082458) = 0x3F;
	REG32(0xB8084050) = 0x3F;	//TEX04_TEX04
	REG32(0xB8084058) = 0x3F;
	REG32(0xB8084450) = 0x7F;	//TDDR_TDDR_0
	REG32(0xB8084458) = 0x7F;
	REG32(0xB8084470) = 0x7F;	//TDDR_TDDR_1
	REG32(0xB8084478) = 0x7F;
	REG32(0xB8084490) = 0x7F;	//TDDR_TDDR_2
	REG32(0xB8084498) = 0x7F;
	REG32(0xB80844B0) = 0x7F;	//TDDR_TDDR_3
	REG32(0xB80844B8) = 0x7F;
	REG32(0xB80844D0) = 0x7F;	//TDDR_TDDR_4
	REG32(0xB80844D8) = 0x7F;
	REG32(0xB80844F0) = 0x7F;	//TDDR_TDDR_5
	REG32(0xB80844F8) = 0x7F;
	REG32(0xB8084510) = 0x7F;	//TDDR_TDDR_6
	REG32(0xB8084518) = 0x7F;
	REG32(0xB8084530) = 0x7F;	//TDDR_TDDR_7
	REG32(0xB8084538) = 0x7F;
	REG32(0xB8084850) = 0x3F;	//TPCTL_TPCTL
	REG32(0xB8084858) = 0x3F;
	REG32(0xB8084C50) = 0x3F;	//TPUB_TPUB
	REG32(0xB8084C58) = 0x3F;
	REG32(0xB8085050) = 0x3F;	//TPON_TPON
	REG32(0xB8085058) = 0x3F;
	REG32(0xB8085450) = 0x3F;	//TGSWIP_TGSWIP
	REG32(0xB8085458) = 0x3F;
	REG32(0xB8085850) = 0x3F;	//TQSPIC_TQSPIC
	REG32(0xB8085858) = 0x3F;
	REG32(0xB8085C50) = 0x3F;	//TMSI_TMSI1
	REG32(0xB8085C58) = 0x3F;
	REG32(0xB8086050) = 0x3F;	//TDMAT2_TDMAT2
	REG32(0xB8086058) = 0x3F;
	REG32(0xB8086450) = 0x3F;	//TQSPID_TQSPID
	REG32(0xB8086458) = 0x3F;
	REG32(0xB8086850) = 0x3F;	//TDMAR1_TDMAR1
	REG32(0xB8086858) = 0x3F;
	REG32(0xB8086C50) = 0x3F;	//TDMAR2_TDMAR2
	REG32(0xB8086C58) = 0x3F;
	REG32(0xB8087050) = 0x3F;	//TACA_TACA
	REG32(0xB8087058) = 0x3F;
	REG32(0xB8087450) = 0x3F;	//TPCIE_CR1_TPCIE_CR1
	REG32(0xB8087458) = 0x3F;
	REG32(0xB8087850) = 0x3F;	//TPCI2_TPCI2
	REG32(0xB8087858) = 0x3F;
	REG32(0xB8087C50) = 0x3F;	//TPCI1_TPCI1
	REG32(0xB8087C58) = 0x3F;
	REG32(0xB8088050) = 0x3F;	//TMSI2_TMSI2
	REG32(0xB8088058) = 0x3F;
	REG32(0xB8088850) = 0x3F;	//TPCIE_CR2_TPCIE_CR2
	REG32(0xB8088858) = 0x3F;
	REG32(0xB8092050) = 0x3F;	//TLNPPV4_TLNPPV4
	REG32(0xB8092058) = 0x3F;
	REG32(0xB8092450) = 0x3F;	//TXPCS_TXPCS
	REG32(0xB8092458) = 0x3F;
	REG32(0xB8092850) = 0x3F;	//TPC1DBI_TPCI1DBI
	REG32(0xB8092858) = 0x3F;
	REG32(0xB8092C50) = 0x3F;	//TPC2DBI_TPCI2DBI
	REG32(0xB8092C58) = 0x3F;
	REG32(0xB8093050) = 0x3F;	//TSSB_TSSB
	REG32(0xB8093058) = 0x3F;
	REG32(0xB8093450) = 0x3F;	//TROM_TROM
	REG32(0xB8093458) = 0x3F;
	REG32(0xB8095050) = 0x3F;	//TMACS_TMAC
	REG32(0xB8095058) = 0x3F;
	REG32(0xB8095450) = 0x3F;	//TIOCU1_TIOCU1
	REG32(0xB8095458) = 0x3F;
	REG32(0xB8095850) = 0x3F;
	REG32(0xB8095858) = 0x3F;	//TDM4_TDM4

/* SSX4 */
	REG32(0xB6080058) = 0x1;	//ssx4:reg0 - only 4kec access 00000-7ffff
	REG32(0xB6080050) = 0x1;
	REG32(0xB6080458) = 0x1f; 	//ssb4:cgu
	REG32(0xB6080450) = 0x1f;
	REG32(0xB6080858) = 0x1f; 	//ssb4:rcu
	REG32(0xB6080850) = 0x1f;
	REG32(0xB6080C58) = 0x1f; 	//ssb4:pmu
	REG32(0xB6080C50) = 0x1f;
	REG32(0xB6081058) = 0x1f; 	//ssb4:pcm
	REG32(0xB6081050) = 0x1f;
	REG32(0xB6081458) = 0x1f; 	//ssb4:gpio
	REG32(0xB6081450) = 0x1f;
	REG32(0xB6081858) = 0x1f; 	//ssb4:ssio
	REG32(0xB6081850) = 0x1f;
	REG32(0xB6081C58) = 0x1f; 	//ssb4:i2c0
	REG32(0xB6081C50) = 0x1f;
	REG32(0xB6082058) = 0x1f; 	//ssb4:asc0
	REG32(0xB6082050) = 0x1f;
	REG32(0xB6082458) = 0x1f; 	//ssb4:asc1
	REG32(0xB6082450) = 0x1f;
	REG32(0xB6082858) = 0x1f; 	//ssb4:gptc0
	REG32(0xB6082850) = 0x1f;
	REG32(0xB6082C58) = 0x1f; 	//ssb4:ssc0
	REG32(0xB6082C50) = 0x1f;
	REG32(0xB6083058) = 0x1f; 	//ssb4:ssc1
	REG32(0xB6083050) = 0x1f;
	REG32(0xB6083458) = 0x1f; 	//ssb4:dm0
	REG32(0xB6083450) = 0x1f;
	REG32(0xB6083C58) = 0x1f; 	//ssb4:gptc1
	REG32(0xB6083C50) = 0x1f;
	REG32(0xB6084058) = 0x1f; 	//ssb4:gptc2
	REG32(0xB6084050) = 0x1f;
	REG32(0xB6085058) = 0x1f; 	//ssb4:i2c1
	REG32(0xB6085050) = 0x1f;
	REG32(0xB6085458) = 0x1f; 	//ssb4:i2c2
	REG32(0xB6085450) = 0x1f;
#else
	/* SSX1 Registers */
	permission_wr(SSX1_MODULE_BASE,
			REG0_TREG0_PM_TREG0_PM_READ_PERMISSION_0, M4KEC_ONLY);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TREG0_PM_TREG0_PM_WRITE_PERMISSION_0, M4KEC_ONLY);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TOTP_PM_TOTP_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TOTP_PM_TOTP_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TCBM1_PM_TCBM1_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TCBM1_PM_TCBM1_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TCBM2_PM_TCBM2_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TCBM2_PM_TCBM2_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TE123_PM_TE123_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TE123_PM_TE123_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDMA3_PM_TDM3_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDMA3_PM_TDM3_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDMAT1_PM_TDMAT1_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDMAT1_PM_TDMAT1_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TEX04_PM_TEX04_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TEX04_PM_TEX04_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_0, ALL_CPUS);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_0, ALL_CPUS);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_1, ALL_CPUS);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_1, ALL_CPUS);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_2, ALL_CPUS);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_2, ALL_CPUS);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_3, ALL_CPUS);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_3, ALL_CPUS);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_4, ALL_CPUS);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_4, ALL_CPUS);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_5, ALL_CPUS);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_5, ALL_CPUS);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_6, ALL_CPUS);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_6, ALL_CPUS);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDDR_PM_TDDR_PM_READ_PERMISSION_7, ALL_CPUS);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDDR_PM_TDDR_PM_WRITE_PERMISSION_7, ALL_CPUS);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TPCTL_PM_TPCTL_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TPCTL_PM_TPCTL_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TPUB_PM_TPUB_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TPUB_PM_TPUB_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TPON_PM_TPON_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TPON_PM_TPON_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TGSWIP_PM_TGSWIP_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TGSWIP_PM_TGSWIP_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TQSPIC_PM_TQSPIC_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TQSPIC_PM_TQSPIC_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TMSI_PM_TMSI1_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TMSI_PM_TMSI1_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDMAT2_PM_TDMAT2_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDMAT2_PM_TDMAT2_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TQSPID_PM_TQSPID_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TQSPID_PM_TQSPID_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDMAR1_PM_TDMAR1_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDMAR1_PM_TDMAR1_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDMAR2_PM_TDMAR2_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDMAR2_PM_TDMAR2_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TACA_PM_TACA_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TACA_PM_TACA_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TPCIE_CR1_PM_TPCIE_CR1_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TPCIE_CR1_PM_TPCIE_CR1_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TPCI2_PM_TPCI2_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TPCI2_PM_TPCI2_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TPCI1_PM_TPCI1_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TPCI1_PM_TPCI1_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TMSI2_PM_TMSI2_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TMSI2_PM_TMSI2_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TPCIE_CR2_PM_TPCIE_CR2_PM_READ_PERMISSION_0,  GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TPCIE_CR2_PM_TPCIE_CR2_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TLNPPV4_PM_TLNPPV4_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TLNPPV4_PM_TLNPPV4_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TXPCS_PM_TXPCS_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TXPCS_PM_TXPCS_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TPC1DBI_PM_TPCI1DBI_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TPC1DBI_PM_TPCI1DBI_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TPC2DBI_PM_TPCI2DBI_PM_READ_PERMISSION_0,  GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TPC2DBI_PM_TPCI2DBI_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TSSB_PM_TSSB_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TSSB_PM_TSSB_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TROM_PM_TROM_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TROM_PM_TROM_PM_WRITE_PERMISSION_0,  GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TMACS_PM_TMAC_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TMACS_PM_TMAC_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TIOCU1_PM_TIOCU1_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TIOCU1_PM_TIOCU1_PM_WRITE_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDM4_PM_TDM4_PM_READ_PERMISSION_0, GRP0_TO_4);
	permission_wr(SSX1_MODULE_BASE,
			REG0_TDM4_PM_TDM4_PM_WRITE_PERMISSION_0, GRP0_TO_4);


	/* SSX 4 registers */
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TREG4_PM_TREG4_PM_WRITE_PERMISSION_0, M4KEC_ONLY);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TREG4_PM_TREG4_PM_READ_PERMISSION_0, M4KEC_ONLY);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TCGU_PM_TCGU_PM_WRITE_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TCGU_PM_TCGU_PM_READ_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TRCU_PM_TRCU_PM_WRITE_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TRCU_PM_TRCU_PM_READ_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TPMU_PM_TPMU_PM_WRITE_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TPMU_PM_TPMU_PM_READ_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TPCM_PM_TPCM_PM_WRITE_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TPCM_PM_TPCM_PM_READ_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TGPIO_PM_TGPIO_PM_WRITE_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TGPIO_PM_TGPIO_PM_READ_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TLEDC_PM_TLEDC_PM_WRITE_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TLEDC_PM_TLEDC_PM_READ_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TI2C_PM_TI2C0_PM_WRITE_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TI2C_PM_TI2C0_PM_READ_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TASC0_PM_TASC0_PM_WRITE_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TASC0_PM_TASC0_PM_READ_PERMISSION_0,  IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TASC1_PM_TASC1_PM_WRITE_PERMISSION_0,  IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TASC1_PM_TASC1_PM_READ_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TGPT0_PM_TGPT0_PM_WRITE_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TGPT0_PM_TGPT0_PM_READ_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TSSC0_PM_TSSC0_PM_WRITE_PERMISSION_0,  IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TSSC0_PM_TSSC0_PM_READ_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TSSC1_PM_TSSC1_PM_WRITE_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TSSC1_PM_TSSC1_PM_READ_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TDMA0_PM_TDM0_PM_WRITE_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TDMA0_PM_TDM0_PM_READ_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TGPT1_PM_TGPT1_PM_WRITE_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TGPT1_PM_TGPT1_PM_READ_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TGPT2_PM_TGPT2_PM_WRITE_PERMISSION_0,  IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TGPT2_PM_TGPT2_PM_READ_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TI2C0_PM_TI2C1_PM_WRITE_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TI2C0_PM_TI2C1_PM_READ_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TI2C1_PM_TI2C2_PM_WRITE_PERMISSION_0, IAP_N_4KEC);
	permission_wr(SSX4_SHARED_LINK_MODULE_BASE,
			REG4_TI2C1_PM_TI2C2_PM_READ_PERMISSION_0, IAP_N_4KEC);

#endif
}

void start_interaptiv(u32 addr)
{
	u32 reg;

	set_permission();

	/* wait until reset finished */
	reg = REG32(0xb6100014) & REG32(0xb6100024);	 // Dummy command for Read Only Reset Register

	if ((REG32(0xb6100014) & 4) == 0) {		// Read status if InterAptiv Cluster in reset?
		REG32(0xb6100010) = 0x00000004;		// If not in reset, reset it
		while ((REG32(0xb6100014) & 4) == 0);   // Wait until InterAptiv Cluster back in reset
	}

   	/* Re-configure XBAR to Little Endian. This is the
	* working configuration in PRX300 when CPU
	* is in BE
	*/
	REG32(CHIP_TOP_ENDIAN | KSEG1) |= 0x1;
	reg = ((1 << NGI_ENDIAN_IA_IA_MO2_POS) | (1 << NGI_ENDIAN_IA_IA_MPE_POS));
	REG32(CHIP_TOP_NGI_ENDIAN_IA | KSEG1) = reg;

	REG32(0xbf2001e0) = addr; // pointer to interaptiv normal entry program
	REG32(0xbf2001f4) = 0x56701dcb; // RVEC_INSTALLED

	REG32(0xbf2001e4) = addr; // pointer to interaptiv nmi handling program
	REG32(0xbf2001f8) = 0x45601CBA; // NVEC_INSTALLED

	REG32(0xb6100010) = 0x00000008;  // Bring InterAptiv Cluster out of reset

   return;
}
