
/*
OUTPUT_FORMAT("elf32-bigmips", "elf32-bigmips", "elf32-bigmips")
*/
OUTPUT_FORMAT("elf32-tradbigmips", "elf32-tradbigmips", "elf32-tradbigmips")
OUTPUT_ARCH(mips)
ENTRY(_start)
SECTIONS
{
        . = 0x00000000;

        . = ALIGN(4);
	.text       :
	{
	  *(.text)
	}

        . = ALIGN(4);
        .rodata  : { *(.rodata) }

        . = ALIGN(4);
        .data  : { *(.data) }

	. = ALIGN(4);
	.sdata  : { *(.sdata) }

	_gp = ALIGN(16);

	. = ALIGN(16);
	__got_start = .;
	.got  : { *(.got) }
	__got_end = .;

	.sdata  : { *(.sdata) }

	. = .;
    got_size = (__got_end - __got_start);
	uboot_end_data = .;
	num_got_entries = (__got_end - __got_start) >> 2;
	__init_end = .;

	__bss_start = .;
    . = ALIGN(4);
    .sbss  : { *(.sbss) }
    .bss  : { *(.bss) }
	__bss_end = .;


	uboot_end = .;
}
