/* Copyright (c) 2017, Intel Corporation.
 *
 * LQ_MICROCODE header file
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
*/

#include <lantiq.h>

typedef struct {
   u16 val_3;
   u16 val_2;
   u16 val_1;
   u16 val_0;
} pce_uc_row_t;

typedef struct {
	u16 key[16];
	u16 mask[4];
	u16 val[16];
	u16 table;
	u16 table_index;
	u16 op_mode:2;
	u16 extop:1;
	u16 key_format:1;
	u16 type:1;
	u16 valid:1;
	u16 group:4;
} pce_table_prog_t;

/** Description */
typedef enum {
  TABLE_ACCESS_OP_MODE_ADRD = 0,
  TABLE_ACCESS_OP_MODE_ADWR = 1,
  TABLE_ACCESS_OP_MODE_KSRD = 2,
  TABLE_ACCESS_OP_MODE_KSWR = 3
} table_access_op_mode_t;

#define PCE_MICRO_TABLE_SIZE 256
#define INSTR 0
#define IPV6 1
#define LENACCU 2
#define GSW_ENABLE	1
#define GSW_DISABLE 0
#define GSW_TRUE	1
#define GSW_FALSE	0

typedef pce_uc_row_t PCE_MICROCODE[PCE_MICRO_TABLE_SIZE];

#if defined(CONFIG_DRIVER_GRX500)
/* parser's microcode flag type */
enum {
	FLAG_NO = 0,
	FLAG_END,
	FLAG_CAPWAP,
	FLAG_GRE,
	FLAG_LEN,
	FLAG_NN0,
	FLAG_NN1,
	FLAG_NN2,
	FLAG_ITAG,
	FLAG_1VLAN,
	FLAG_2VLAN,  /* 10 */
	FLAG_3VLAN,
	FLAG_4VLAN,
	FLAG_SNAP,
	FLAG_PPPOES,
	FLAG_1IPV4,
	FLAG_1IPV6,
	FLAG_2IPV4,
	FLAG_2IPV6,
	FLAG_ROUTEXP,
	FLAG_TCP,  /* 20 */
	FLAG_1UDP,
	FLAG_IGMP,
	FLAG_IPV4OPT,
	FLAG_1IPV6EXT,
	FLAG_TCPACK,
	FLAG_IPFRAG,
	FLAG_EAPOL,
	FLAG_2IPV6EXT,
	FLAG_2UDP,
	FLAG_L2TPNEXP,	/* 30 */
	FLAG_LROEXP,
	FLAG_L2TP,
	FLAG_NN4,
	FLAG_NN5,
	FLAG_NN6,
	FLAG_NN7,
	FLAG_NN8,
	FLAG_NN9,
	FLAG_NN10,
	FLAG_NN11,	/* 40 */
	FLAG_NN12,
	FLAG_NN13,
	FLAG_NN14,
	FLAG_NN15,
	FLAG_NN16,
	FLAG_NN17,
	FLAG_NN18,
	FLAG_NN19,
	FLAG_NN20,
	FLAG_NN21,	/* 50 */
	FLAG_NN22,
	FLAG_NN23,
	FLAG_NN24,
	FLAG_NN25,
	FLAG_NN26,
	FLAG_NN27,
	FLAG_NN28,
	FLAG_NN29,
	FLAG_NN30,
	FLAG_NN31,	/* 60 */
	FLAG_NN32,
	FLAG_NN33,
	FLAG_NN34,
};

/* parser's microcode output field type */
enum {
    OUT_MAC0 = 0,
    OUT_MAC1,
    OUT_MAC2,
    OUT_MAC3,
    OUT_MAC4,
    OUT_MAC5,
    OUT_ITAG0,
    OUT_ITAG1,
    OUT_ITAG2,
    OUT_ITAG3,
    OUT_1VTAG0, /* 10 */
    OUT_1VTAG1,
    OUT_2VTAG0,
    OUT_2VTAG1,
    OUT_3VTAG0,
    OUT_3VTAG1,
    OUT_4VTAG0,
    OUT_4VTAG1,
    OUT_ETYPE,
    OUT_PPPOE0,
    OUT_PPPOE1, /* 20 */
    OUT_PPPOE3,
    OUT_PPP,
    OUT_RES,
    OUT_1IP0,
    OUT_1IP1,
    OUT_1IP2,
    OUT_1IP3,
    OUT_1IP4,
    OUT_1IP5,
    OUT_1IP6, /* 30 */
    OUT_1IP7,
    OUT_1IP8,
    OUT_1IP9,
    OUT_1IP10,
    OUT_1IP11,
    OUT_1IP12,
    OUT_1IP13,
    OUT_1IP14,
    OUT_1IP15,
    OUT_1IP16, /* 40 */
    OUT_1IP17,
    OUT_1IP18,
    OUT_1IP19,
    OUT_2IP0,
    OUT_2IP1,
    OUT_2IP2,
    OUT_2IP3,
    OUT_2IP4,
    OUT_2IP5,
    OUT_2IP6, /* 50 */
    OUT_2IP7,
    OUT_2IP8,
    OUT_2IP9,
    OUT_2IP10,
    OUT_2IP11,
    OUT_2IP12,
    OUT_2IP13,
    OUT_2IP14,
    OUT_2IP15,
    OUT_2IP16, /* 60 */
    OUT_2IP17,
    OUT_2IP18,
    OUT_2IP19,
    OUT_APP0,
    OUT_APP1,
    OUT_APP2,
    OUT_APP3,
    OUT_APP4,
    OUT_APP5,
    OUT_APP6, /* 70 */
    OUT_APP7,
    OUT_APP8,
    OUT_APP9,
    OUT_1PL,
    OUT_2PL,
    OUT_1LNH,
    OUT_2LNH = 77,
    OUT_NONE = 127
};

#define PCE_MC_M3(val, msk, ns, out, len, type, flags, ipv4_len) \
{ val, msk, (ns << 8 | out << 0), (len | type << 5 | flags << 8 | ipv4_len << 7)}

const PCE_MICROCODE pce_mc_max_ifx_tag_m_30 = {
		/* V30_8 */
	PCE_MC_M3(0x88C3 , 0xFFFF , 1 , OUT_ITAG0 , 4 , INSTR , FLAG_ITAG , 0),
	PCE_MC_M3(0x8100 , 0xFFFF , 4 , OUT_1VTAG0 , 2 , INSTR , FLAG_1VLAN , 0),
	PCE_MC_M3(0x88A8 , 0xFFFF , 4 , OUT_1VTAG0 , 2 , INSTR , FLAG_1VLAN , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 15 , OUT_NONE , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x8100 , 0xFFFF , 7 , OUT_2VTAG0 , 2 , INSTR , FLAG_2VLAN , 0),
	PCE_MC_M3(0x88A8 , 0xFFFF , 7 , OUT_2VTAG0 , 2 , INSTR , FLAG_2VLAN , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 15 , OUT_NONE , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x8100 , 0xFFFF , 10 , OUT_3VTAG0 , 2 , INSTR , FLAG_3VLAN , 0),
	PCE_MC_M3(0x88A8 , 0xFFFF , 10 , OUT_3VTAG0 , 2 , INSTR , FLAG_3VLAN , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 15 , OUT_NONE , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x8100 , 0xFFFF , 13 , OUT_4VTAG0 , 2 , INSTR , FLAG_4VLAN , 0),
	PCE_MC_M3(0x88A8 , 0xFFFF , 13 , OUT_4VTAG0 , 2 , INSTR , FLAG_4VLAN , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 15 , OUT_NONE , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x8100 , 0xFFFF , 13 , OUT_NONE , 2 , INSTR , FLAG_ROUTEXP , 0),
	PCE_MC_M3(0x88A8 , 0xFFFF , 13 , OUT_NONE , 2 , INSTR , FLAG_ROUTEXP , 0),
	PCE_MC_M3(0x0000 , 0xF800 , 17 , OUT_NONE , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 23 , OUT_NONE , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0600 , 0x0600 , 23 , OUT_NONE , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 19 , OUT_ETYPE , 1 , INSTR , FLAG_LEN , 0),
	PCE_MC_M3(0xAAAA , 0xFFFF , 21 , OUT_APP0 , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 130 , OUT_APP0 , 2 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0300 , 0xFF00 , 23 , OUT_APP1 , 2 , INSTR , FLAG_SNAP , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 130 , OUT_APP1 , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x8864 , 0xFFFF , 28 , OUT_ETYPE , 4 , INSTR , FLAG_PPPOES , 0),
	PCE_MC_M3(0x0800 , 0xFFFF , 31 , OUT_ETYPE , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x86DD , 0xFFFF , 47 , OUT_ETYPE , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x888E , 0xFFFF , 129 , OUT_ETYPE , 1 , INSTR , FLAG_EAPOL , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 129 , OUT_ETYPE , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0021 , 0xFFFF , 31 , OUT_PPP , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0057 , 0xFFFF , 47 , OUT_PPP , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 129 , OUT_PPP , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x4000 , 0xF000 , 33 , OUT_NONE , 0 , INSTR , FLAG_1IPV4 , 1),
	PCE_MC_M3(0x0000 , 0x0000 , 129 , OUT_NONE , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0500 , 0x0F00 , 36 , OUT_NONE , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 35 , OUT_NONE , 0 , INSTR , FLAG_IPV4OPT , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 36 , OUT_NONE , 0 , INSTR , FLAG_LROEXP , 0),
	PCE_MC_M3(0x0003 , 0x0003 , 38 , OUT_1IP0 , 3 , INSTR , FLAG_LROEXP , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 38 , OUT_1IP0 , 3 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x3FFF , 40 , OUT_1IP3 , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 40 , OUT_1IP3 , 1 , INSTR , FLAG_IPFRAG , 0),
	PCE_MC_M3(0x0000 , 0xFE00 , 41 , OUT_NONE , 0 , INSTR , FLAG_ROUTEXP , 0),
	PCE_MC_M3(0x0011 , 0x00FF , 107 , OUT_1IP4 , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x0006 , 0x00FF , 95 , OUT_1IP4 , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x0002 , 0x00FF , 112 , OUT_1IP4 , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x0029 , 0x00FF , 80 , OUT_1IP4 , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x0004 , 0x00FF , 70 , OUT_1IP4 , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 129 , OUT_1IP4 , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x6000 , 0xF000 , 49 , OUT_NONE , 0 , INSTR , FLAG_1IPV6 , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 129 , OUT_NONE , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0030 , 0x0030 , 51 , OUT_1IP0 , 3 , INSTR , FLAG_LROEXP , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 51 , OUT_1IP0 , 3 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x00FE , 52 , OUT_NONE , 0 , INSTR , FLAG_ROUTEXP , 0),
	PCE_MC_M3(0x1100 , 0xFF00 , 107 , OUT_1IP3 , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0600 , 0xFF00 , 95 , OUT_1IP3 , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 55 , OUT_NONE , 0 , INSTR , FLAG_LROEXP , 0),
	PCE_MC_M3(0x0400 , 0xFF00 , 70 , OUT_1IP3 , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x2900 , 0xFF00 , 80 , OUT_1IP3 , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0xFF00 , 61 , OUT_1IP3 , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x2B00 , 0xFF00 , 61 , OUT_1IP3 , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x3C00 , 0xFF00 , 61 , OUT_1IP3 , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 129 , OUT_1IP3 , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0xFF00 , 61 , OUT_1LNH , 1 , IPV6 , FLAG_1IPV6EXT , 0),
	PCE_MC_M3(0x2B00 , 0xFF00 , 61 , OUT_1LNH , 1 , IPV6 , FLAG_1IPV6EXT , 0),
	PCE_MC_M3(0x3C00 , 0xFF00 , 61 , OUT_1LNH , 1 , IPV6 , FLAG_1IPV6EXT , 0),
	PCE_MC_M3(0x1100 , 0xFF00 , 107 , OUT_1LNH , 1 , IPV6 , FLAG_1IPV6EXT , 0),
	PCE_MC_M3(0x0600 , 0xFF00 , 95 , OUT_1LNH , 1 , IPV6 , FLAG_1IPV6EXT , 0),
	PCE_MC_M3(0x0200 , 0xFF00 , 112 , OUT_1LNH , 1 , IPV6 , FLAG_1IPV6EXT , 0),
	PCE_MC_M3(0x0400 , 0xFF00 , 70 , OUT_1LNH , 1 , IPV6 , FLAG_1IPV6EXT , 0),
	PCE_MC_M3(0x2900 , 0xFF00 , 80 , OUT_1LNH , 1 , IPV6 , FLAG_1IPV6EXT , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 129 , OUT_1LNH , 1 , IPV6 , FLAG_1IPV6EXT , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 71 , OUT_NONE , 0 , INSTR , FLAG_2IPV4 , 1),
	PCE_MC_M3(0x0500 , 0x0F00 , 73 , OUT_2IP0 , 3 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 74 , OUT_2IP0 , 3 , INSTR , FLAG_IPV4OPT , 0),
	PCE_MC_M3(0x0000 , 0x3FFF , 75 , OUT_2IP3 , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 75 , OUT_2IP3 , 1 , INSTR , FLAG_IPFRAG , 0),
	PCE_MC_M3(0x0000 , 0xFE00 , 76 , OUT_NONE , 0 , INSTR , FLAG_ROUTEXP , 0),
	PCE_MC_M3(0x0011 , 0x00FF , 111 , OUT_2IP4 , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x0006 , 0x00FF , 95 , OUT_2IP4 , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x0002 , 0x00FF , 112 , OUT_2IP4 , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 129 , OUT_2IP4 , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 81 , OUT_2IP0 , 3 , INSTR , FLAG_2IPV6 , 0),
	PCE_MC_M3(0x0000 , 0x00FE , 82 , OUT_NONE , 0 , INSTR , FLAG_ROUTEXP , 0),
	PCE_MC_M3(0x1100 , 0xFF00 , 111 , OUT_2IP3 , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0600 , 0xFF00 , 95 , OUT_2IP3 , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0xFF00 , 88 , OUT_2IP3 , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x2B00 , 0xFF00 , 88 , OUT_2IP3 , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x3C00 , 0xFF00 , 88 , OUT_2IP3 , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 129 , OUT_2IP3 , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0xFF00 , 88 , OUT_2LNH , 1 , IPV6 , FLAG_2IPV6EXT , 0),
	PCE_MC_M3(0x2B00 , 0xFF00 , 88 , OUT_2LNH , 1 , IPV6 , FLAG_2IPV6EXT , 0),
	PCE_MC_M3(0x3C00 , 0xFF00 , 88 , OUT_2LNH , 1 , IPV6 , FLAG_2IPV6EXT , 0),
	PCE_MC_M3(0x1100 , 0xFF00 , 111 , OUT_2LNH , 1 , IPV6 , FLAG_2IPV6EXT , 0),
	PCE_MC_M3(0x0600 , 0xFF00 , 95 , OUT_2LNH , 1 , IPV6 , FLAG_2IPV6EXT , 0),
	PCE_MC_M3(0x0200 , 0xFF00 , 112 , OUT_2LNH , 1 , IPV6 , FLAG_2IPV6EXT , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 129 , OUT_2LNH , 1 , IPV6 , FLAG_2IPV6EXT , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 96 , OUT_APP0 , 6 , INSTR , FLAG_TCP , 0),
	PCE_MC_M3(0x0040 , 0x0040 , 97 , OUT_NONE , 0 , INSTR , FLAG_LROEXP , 0),
	PCE_MC_M3(0x0080 , 0x0080 , 98 , OUT_NONE , 0 , INSTR , FLAG_LROEXP , 0),
	PCE_MC_M3(0x0020 , 0x0020 , 99 , OUT_NONE , 0 , INSTR , FLAG_LROEXP , 0),
	PCE_MC_M3(0x0008 , 0x0008 , 100 , OUT_NONE , 0 , INSTR , FLAG_LROEXP , 0),
	PCE_MC_M3(0x0001 , 0x0001 , 101 , OUT_NONE , 0 , INSTR , FLAG_ROUTEXP , 0),
	PCE_MC_M3(0x0001 , 0x0001 , 102 , OUT_NONE , 0 , INSTR , FLAG_LROEXP , 0),
	PCE_MC_M3(0x0004 , 0x0004 , 103 , OUT_NONE , 0 , INSTR , FLAG_ROUTEXP , 0),
	PCE_MC_M3(0x0004 , 0x0004 , 104 , OUT_NONE , 0 , INSTR , FLAG_LROEXP , 0),
	PCE_MC_M3(0x0002 , 0x0002 , 105 , OUT_NONE , 0 , INSTR , FLAG_LROEXP , 0),
	PCE_MC_M3(0x0010 , 0x0010 , 130 , OUT_APP6 , 4 , INSTR , FLAG_TCPACK , 0),
	PCE_MC_M3(0x0000 , 0x0010 , 130 , OUT_APP6 , 4 , INSTR , FLAG_LROEXP , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 108 , OUT_APP0 , 1 , INSTR , FLAG_1UDP , 0),
	PCE_MC_M3(0x06A5 , 0xFFFF , 113 , OUT_APP1 , 3 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x147F , 0xFFFF , 125 , OUT_APP1 , 3 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 130 , OUT_APP1 , 3 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 130 , OUT_APP0 , 4 , INSTR , FLAG_2UDP , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 130 , OUT_APP0 , 4 , INSTR , FLAG_IGMP , 0),
	PCE_MC_M3(0x0000 , 0xCA00 , 120 , OUT_NONE , 3 , INSTR , FLAG_L2TP , 0),
	PCE_MC_M3(0x4000 , 0xCA00 , 120 , OUT_NONE , 4 , INSTR , FLAG_L2TP , 0),
	PCE_MC_M3(0x0200 , 0xCA00 , 118 , OUT_NONE , 3 , INSTR , FLAG_L2TP , 0),
	PCE_MC_M3(0x4200 , 0xCA00 , 118 , OUT_NONE , 4 , INSTR , FLAG_L2TP , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 130 , OUT_NONE , 0 , INSTR , FLAG_L2TP , 0),
	PCE_MC_M3(0x0000 , 0xFFFF , 120 , OUT_NONE , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 130 , OUT_NONE , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0xFF03 , 0xFFFF , 122 , OUT_NONE , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 130 , OUT_NONE , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0021 , 0xFFFF , 70 , OUT_NONE , 1 , INSTR , FLAG_L2TPNEXP , 0),
	PCE_MC_M3(0x0057 , 0xFFFF , 80 , OUT_NONE , 1 , INSTR , FLAG_L2TPNEXP , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 130 , OUT_NONE , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0010 , 0x00F8 , 127 , OUT_NONE , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 130 , OUT_NONE , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x01F8 , 130 , OUT_NONE , 0 , INSTR , FLAG_CAPWAP , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 130 , OUT_NONE , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 130 , OUT_APP0 , 2 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 131 , OUT_1PL , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_2PL , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 132 , OUT_NONE , 0 , INSTR , FLAG_END , 0),
};

#elif defined(CONFIG_DRIVER_PRX300)

/* parser's microcode flag type */
enum {
	FLAG_NO = 0,
	FLAG_END,
	FLAG_CAPWAP,
	FLAG_GRE,
	FLAG_LEN,
	FLAG_GREK,
	FLAG_NN1,
	FLAG_NN2,
	FLAG_ITAG,
	FLAG_1VLAN,
	FLAG_2VLAN,  /* 10 */
	FLAG_3VLAN,
	FLAG_4VLAN,
	FLAG_SNAP,
	FLAG_PPPOES,
	FLAG_1IPV4,
	FLAG_1IPV6,
	FLAG_2IPV4,
	FLAG_2IPV6,
	FLAG_ROUTEXP,
	FLAG_TCP,  /* 20 */
	FLAG_1UDP,
	FLAG_IGMP,
	FLAG_IPV4OPT,
	FLAG_1IPV6EXT,
	FLAG_TCPACK,
	FLAG_IPFRAG,
	FLAG_EAPOL,
	FLAG_2IPV6EXT,
	FLAG_2UDP,
	FLAG_L2TPNEXP,	/* 30 */
	FLAG_LROEXP,
	FLAG_L2TP,
	FLAG_GRE_VLAN1,
	FLAG_GRE_VLAN2,
	FLAG_GRE_PPPOE,
	FLAG_NN13,
	FLAG_NN14,
	FLAG_NN15,
	FLAG_NN16,
	FLAG_NN17, /* 40 */
	FLAG_NN18,
	FLAG_NN19,
	FLAG_NN20,
	FLAG_NN21,
	FLAG_NN22,
	FLAG_NN23,
	FLAG_NN24,
	FLAG_NN25,
	FLAG_NN26,
	FLAG_NN27, /* 50 */
	FLAG_NN28,
	FLAG_NN29,
	FLAG_NN30,
	FLAG_NN31,
	FLAG_NN32,
	FLAG_NN33,
	FLAG_NN34,
	FLAG_NN35,
	FLAG_NN36,
	FLAG_NN37, /* 60 */
	FLAG_NN38,
	FLAG_NN39,
	FLAG_NN40,
};

/* parser's microcode output field type */
enum {
	OUT_MAC0 = 0,
	OUT_MAC1,
	OUT_MAC2,
	OUT_MAC3,
	OUT_MAC4,
	OUT_MAC5,
	OUT_ITAG0,
	OUT_ITAG1,
	OUT_ITAG2,
	OUT_ITAG3,
	OUT_1VTAG0, /* 10 */
	OUT_1VTAG1,
	OUT_2VTAG0,
	OUT_2VTAG1,
	OUT_3VTAG0,
	OUT_3VTAG1,
	OUT_4VTAG0,
	OUT_4VTAG1,
	OUT_ETYPE,
	OUT_PPPOE0,
	OUT_PPPOE1, /* 20 */
	OUT_PPPOE3,
	OUT_PPP,
	OUT_RES,
	OUT_1IP0,
	OUT_1IP1,
	OUT_1IP2, 
	OUT_1IP3,
	OUT_1IP4,
	OUT_1IP5,
	OUT_1IP6, /* 30 */
	OUT_1IP7,
	OUT_1IP8,
	OUT_1IP9,
	OUT_1IP10,
	OUT_1IP11,
	OUT_1IP12,
	OUT_1IP13,
	OUT_1IP14,
	OUT_1IP15,
	OUT_1IP16, /* 40 */
	OUT_1IP17,
	OUT_1IP18,
	OUT_1IP19,
	OUT_2IP0,
	OUT_2IP1,
	OUT_2IP2,
	OUT_2IP3,
	OUT_2IP4,
	OUT_2IP5,
	OUT_2IP6, /* 50 */
	OUT_2IP7,
	OUT_2IP8,
	OUT_2IP9,
	OUT_2IP10,
	OUT_2IP11,
	OUT_2IP12,
	OUT_2IP13,
	OUT_2IP14,
	OUT_2IP15,
	OUT_2IP16, /* 60 */
	OUT_2IP17,
	OUT_2IP18,
	OUT_2IP19,
	OUT_APP0,
	OUT_APP1,
	OUT_APP2,
	OUT_APP3,
	OUT_APP4,		
	OUT_APP5,
	OUT_APP6, /* 70 */
	OUT_APP7,
	OUT_APP8,
	OUT_APP9,
	OUT_1PL,
	OUT_2PL,
	OUT_1LNH,
	OUT_2LNH = 77,
	OUT_NONE = 127
};
typedef struct { 
	u16 num_key;
	u16 num_mask;
	u16 num_val;
} gsw_pce_tbl_info_t;

#define PCE_MC_M3(val, msk, ns, out, len, type, flags, ipv4_len) \
    { val, msk, (ns << 8 | out << 0),\
        (len | type << 5 | flags << 8 | ipv4_len << 7)}

const PCE_MICROCODE pce_mc_max_ifx_tag_m_30 = {/* V31_01 */
	PCE_MC_M3(0x88C3 , 0xFFFF ,  1 , OUT_ITAG0  , 4 , INSTR , FLAG_ITAG , 0),
	PCE_MC_M3(0x8100 , 0xFFFF ,  4 , OUT_1VTAG0 , 2 , INSTR , FLAG_1VLAN , 0),
	PCE_MC_M3(0x88A8 , 0xFFFF ,  4 , OUT_1VTAG0 , 2 , INSTR , FLAG_1VLAN , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 12 , OUT_NONE   , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x8100 , 0xFFFF ,  7 , OUT_2VTAG0 , 2 , INSTR , FLAG_2VLAN , 0),
	PCE_MC_M3(0x88A8 , 0xFFFF ,  7 , OUT_2VTAG0 , 2 , INSTR , FLAG_2VLAN , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 12 , OUT_NONE   , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x8100 , 0xFFFF , 10 , OUT_3VTAG0 , 2 , INSTR , FLAG_3VLAN , 0),
	PCE_MC_M3(0x88A8 , 0xFFFF , 10 , OUT_3VTAG0 , 2 , INSTR , FLAG_3VLAN , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 12 , OUT_NONE   , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x8100 , 0xFFFF , 10 , OUT_NONE   , 2 , INSTR , FLAG_ROUTEXP , 0),
	PCE_MC_M3(0x88A8 , 0xFFFF , 10 , OUT_NONE   , 2 , INSTR , FLAG_ROUTEXP , 0),
	PCE_MC_M3(0x0000 , 0xF800 , 14 , OUT_NONE   , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 20 , OUT_NONE   , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0600 , 0x0600 , 20 , OUT_NONE   , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 16 , OUT_ETYPE  , 1 , INSTR , FLAG_LEN , 0),
	PCE_MC_M3(0xAAAA , 0xFFFF , 18 , OUT_APP0   , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 80 , OUT_APP0   , 2 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0300 , 0xFF00 , 20 , OUT_APP1   , 2 , INSTR , FLAG_SNAP , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 80 , OUT_APP1   , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x8864 , 0xFFFF , 25 , OUT_ETYPE  , 4 , INSTR , FLAG_PPPOES , 0),
	PCE_MC_M3(0x0800 , 0xFFFF , 28 , OUT_ETYPE  , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x86DD , 0xFFFF , 35 , OUT_ETYPE  , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x888E , 0xFFFF , 79 , OUT_ETYPE  , 1 , INSTR , FLAG_EAPOL , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 79 , OUT_ETYPE  , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0021 , 0xFFFF , 28 , OUT_PPP    , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0057 , 0xFFFF , 35 , OUT_PPP    , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 79 , OUT_PPP    , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 29 , OUT_1IP0   , 4 , INSTR , FLAG_1IPV4 , 1),
	PCE_MC_M3(0x0011 , 0x00FF , 77 , OUT_1IP4   , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x0006 , 0x00FF , 74 , OUT_1IP4   , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x0002 , 0x00FF , 78 , OUT_1IP4   , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x0029 , 0x00FF , 59 , OUT_1IP4   , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x0004 , 0x00FF , 54 , OUT_1IP4   , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 79 , OUT_1IP4   , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 36 , OUT_1IP0   , 3 , INSTR , FLAG_1IPV6 , 0),
	PCE_MC_M3(0x1100 , 0xFF00 , 77 , OUT_1IP3   , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0600 , 0xFF00 , 74 , OUT_1IP3   , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0400 , 0xFF00 , 54 , OUT_1IP3   , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x2900 , 0xFF00 , 59 , OUT_1IP3   , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0xFF00 , 44 , OUT_1IP3   , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x2B00 , 0xFF00 , 44 , OUT_1IP3   , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x3C00 , 0xFF00 , 44 , OUT_1IP3   , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 79 , OUT_1IP3   , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x00F8 , 46 , OUT_NONE   , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 79 , OUT_NONE   , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0xFF00 , 44 , OUT_1LNH   , 1 , IPV6 , FLAG_1IPV6EXT , 0),
	PCE_MC_M3(0x2B00 , 0xFF00 , 44 , OUT_1LNH   , 1 , IPV6 , FLAG_1IPV6EXT , 0),
	PCE_MC_M3(0x3C00 , 0xFF00 , 44 , OUT_1LNH   , 1 , IPV6 , FLAG_1IPV6EXT , 0),
	PCE_MC_M3(0x1100 , 0xFF00 , 77 , OUT_1LNH   , 1 , IPV6 , FLAG_1IPV6EXT , 0),
	PCE_MC_M3(0x0600 , 0xFF00 , 74 , OUT_1LNH   , 1 , IPV6 , FLAG_1IPV6EXT , 0),
	PCE_MC_M3(0x0400 , 0xFF00 , 54 , OUT_1LNH   , 1 , IPV6 , FLAG_1IPV6EXT , 0),
	PCE_MC_M3(0x2900 , 0xFF00 , 59 , OUT_1LNH   , 1 , IPV6 , FLAG_1IPV6EXT , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 79 , OUT_1LNH   , 1 , IPV6 , FLAG_1IPV6EXT , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 55 , OUT_2IP0   , 4 , INSTR , FLAG_2IPV4 , 1),
	PCE_MC_M3(0x0011 , 0x00FF , 77 , OUT_2IP4   , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x0006 , 0x00FF , 74 , OUT_2IP4   , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x0002 , 0x00FF , 78 , OUT_2IP4   , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 79 , OUT_2IP4   , 6 , LENACCU , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 60 , OUT_2IP0   , 3 , INSTR , FLAG_2IPV6 , 0),
	PCE_MC_M3(0x1100 , 0xFF00 , 77 , OUT_2IP3   , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0600 , 0xFF00 , 74 , OUT_2IP3   , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0xFF00 , 66 , OUT_2IP3   , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x2B00 , 0xFF00 , 66 , OUT_2IP3   , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x3C00 , 0xFF00 , 66 , OUT_2IP3   , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 79 , OUT_2IP3   , 17 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x00F8 , 68 , OUT_NONE   , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 79 , OUT_NONE   , 0 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0xFF00 , 66 , OUT_2LNH   , 1 , IPV6 , FLAG_2IPV6EXT , 0),
	PCE_MC_M3(0x2B00 , 0xFF00 , 66 , OUT_2LNH   , 1 , IPV6 , FLAG_2IPV6EXT , 0),
	PCE_MC_M3(0x3C00 , 0xFF00 , 66 , OUT_2LNH   , 1 , IPV6 , FLAG_2IPV6EXT , 0),
	PCE_MC_M3(0x1100 , 0xFF00 , 77 , OUT_2LNH   , 1 , IPV6 , FLAG_2IPV6EXT , 0),
	PCE_MC_M3(0x0600 , 0xFF00 , 74 , OUT_2LNH   , 1 , IPV6 , FLAG_2IPV6EXT , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 79 , OUT_2LNH   , 1 , IPV6 , FLAG_2IPV6EXT , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 75 , OUT_APP0   , 6 , INSTR , FLAG_TCP , 0),
	PCE_MC_M3(0x0010 , 0x0010 , 80 , OUT_APP6   , 4 , INSTR , FLAG_TCPACK , 0),
	PCE_MC_M3(0x0000 , 0x0010 , 80 , OUT_APP6   , 4 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 80 , OUT_APP0   , 4 , INSTR , FLAG_1UDP , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 80 , OUT_APP0   , 4 , INSTR , FLAG_IGMP , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 80 , OUT_APP0   , 2 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 81 , OUT_1PL    , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_2PL    , 1 , INSTR , FLAG_NO , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
	PCE_MC_M3(0x0000 , 0x0000 , 82 , OUT_NONE   , 0 , INSTR , FLAG_END , 0),
};
#endif /* CONFIG_DRIVER_GRX500 */

u32 gsw_reg_read(u32 base_addr, u32 offset)
{
	//printf("\n\t%s  Register: 0x%08x Data: 0x%08x\n", __func__, (GSW_BASE_ADDR + (offset * 4)), REG32(GSW_BASE_ADDR + (offset * 4)));
	return REG32(base_addr + (offset * 4));
}

u32 gsw_reg_write(u32 base_addr, u32 offset, u32 data)
{
	//printf("\n\t%s Register: 0x%08x Data: 0x%08x\n", __func__, (GSW_BASE_ADDR + (offset * 4)), data);
	REG32(base_addr + (offset * 4)) = data;
	return 0;
}

void gsw_w32(u32 base_addr, short Offset, short Shift, short Size, u32 value)
{
	u32 regValue, mask;
	regValue = gsw_reg_read(base_addr, Offset);
	mask = (1 << Size) - 1;
	mask = (mask << Shift);
	value = ((value << Shift) & mask);
	value = ((regValue & ~mask) | value);
	gsw_reg_write(base_addr, Offset, value);
}

void gsw_r32(u32 base_addr, short Offset, short Shift, short Size, u32 *value)
{
	u32 regValue, mask;
	regValue = gsw_reg_read(base_addr, Offset);
	mask = (1 << Size) - 1 ;
	regValue = (regValue >> Shift);
	*value = (regValue & mask);
}

