#ifndef NGI_MAP_H
#define NGI_MAP_H
#include "ngi.h"

/* Defaut Permission table */
static const struct ngi_ta_core ngi_ta_core_table[LTQ_NUM_TARGET_AGENTS] = 
{
	{0xB, "TA_SSB", 4 , {{"PR0", 0, 0x0, 0x0, 0, 0x1f, 0x1f}, 
			    {"PR1", 0, 0x0, 0x0, 0, 0x1, 0x1}, 
			    {"PR2", 0, 0x0, 0x0, 0, 0x1, 0x1},
			    {"PR3", 0, 0x0, 0x0, 0, 0x1, 0x1},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x8, "TA_ROM", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},}},
	{0x7, "TA_OTP", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x9, "TA_CBM1", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x109, "TA_CBM2", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0xe, "TA_EIP97", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0xf, "TA_EIP123", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0xc, "TA_DMA3", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0xd, "TA_DMA4", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0xf01, "TA_LN01", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0xf02, "TA_LN02", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0xf03, "TA_LN03", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0xf04, "TA_EX04", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0xf05, "TA_EX05", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0xf06, "TA_LN06", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1, 0x1},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},}},
	{0x14, "TA_DMA2R", 1 , {{"PR0", 0, 0x0, 0x0, 0, 0x1f, 0x1f}, 
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, 
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x13, "TA_DMA2T", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},}},
	{0x12, "TA_GSWIP_L", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0xf10, "TA_LN10", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1, 0x1},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x25, "TA_USB0", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x26, "TA_USB0C", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x27, "TA_USB1", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x28, "TA_USB1C", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x24, "TA_DMA1R", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x23, "TA_DMA1T", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x22, "TA_GSWIP_R", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0xf20, "TA_LN20", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1, 0x1},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x3a, "TA_PCIE3", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},}},
	{0x13a, "TA_PCIE3_A", 1 , {{"PR0", 0, 0x0, 0x0, 0, 0x1f, 0x1f}, 
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, 
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x3c, "TA_PCIE3_C", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},}},
	{0x3b, "TA_MSI3", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x36, "TA_PCIE1", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x136, "TA_PCIE1_A", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x38, "TA_PCIE1_C", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x37, "TA_MSI1", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x32, "TA_PCIE2", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x132, "TA_PCIE2_A", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x34, "TA_PCIE2_C", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x33, "TA_MSI2", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0xf30, "TA_LN30", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1, 0x1},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x41, "TA_CGU", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x42, "TA_RCU", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x43, "TA_PMU", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x44, "TA_PCM", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},}},
	{0x45, "TA_GPIO", 1 , {{"PR0", 0, 0x0, 0x0, 0, 0x1f, 0x1f}, 
			    {"NULL", 0, 0x0, 0x0, 0, 0x1, 0x1}, 
			    {"NULL", 0, 0x0, 0x0, 0, 0x1, 0x1},
			    {"NULL", 0, 0x0, 0x0, 0, 0x1, 0x1},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x46, "TA_LEDC", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},}},
	{0x47, "TA_I2C", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x48, "TA_ASC0", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x49, "TA_ASC1", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x4a, "TA_GPT0", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x4d, "TA_SSC0", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x4e, "TA_SSC1", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x4f, "TA_DMA0", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x50, "TA_EBU", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x4b, "TA_GPT1", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x4c, "TA_GPT2", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x62, "TA_IC", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x3, 0x3},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x65, "TA_DDR", 8, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x7f, 0x7f},
			    {"PR1", 0, 0x0, 0x0, 0, 0x7f, 0x7f},
			    {"PR2", 0, 0x0, 0x0, 0, 0x7f, 0x7f},
			    {"PR3", 0, 0x0, 0x0, 0, 0x7f, 0x7f},
			    {"PR4", 0, 0x0, 0x0, 0, 0x7f, 0x7f},
			    {"PR5", 0, 0x0, 0x0, 0, 0x7f, 0x7f},
			    {"PR6", 0, 0x0, 0x0, 0, 0x7f, 0x7f},
			    {"PR7", 0, 0x0, 0x0, 0, 0x7f, 0x7f}, }},
	{0x63, "TA_PCTL", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x64, "TA_PUB", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0xf60, "TA_LN60", 1, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x74, "TA_MPE", 0, {{"NULL", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x72, "TA_MI2", 0, {{"NULL", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{0x73, "TA_TOE", 0, {{"NULL", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
};

/* Defaut Permission table for register targets */
static const struct ngi_rt_core ngi_rt_core_table[LTQ_NUM_NGI_INSTANCES] = 
{
	{0, "TA_REG0", 2 , {{"PR0", 0, 0x0, 0x0, 0, 0x1f, 0x1f}, 
			    {"PR1", 0, 0x0, 0x0, 0, 0x1, 0x1}, 
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{1, "TA_REG1", 2, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"PR1", 0, 0x0, 0x0, 0, 0x1, 0x1},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},}},
	{2, "TA_REG2", 2, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"PR1", 0, 0x0, 0x0, 0, 0x1, 0x1},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{3, "TA_REG3", 2, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"PR1", 0, 0x0, 0x0, 0, 0x1, 0x1},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{4, "TA_REG4", 2, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"PR1", 0, 0x0, 0x0, 0, 0x1, 0x1},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{5, "TA_REG5", 2, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"PR1", 0, 0x0, 0x0, 0, 0x1, 0x1},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }},
	{6, "TA_REG6", 2, {{"PR0", 0x0, 0x0, 0x0, 0x0,0x1f, 0x1f},
			    {"PR1", 0, 0x0, 0x0, 0, 0x1, 0x1},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0},
			    {"NULL", 0, 0x0, 0x0, 0, 0x0, 0x0}, }}
};

static const struct ngi_ia_core ngi_ia_core_table[LTQ_NUM_INIT_AGENTS] = {
	{0x10e, "IA_E97W"},
	{0xe, "IA_E97R"},
	{0x10f, "IA_E123W"},
	{0xf, "IA_E123R"},
	{0x4f, "IA_DMA0"},
	{0xC, "IA_DMA3"},
	{0xD, "IA_DMA4"},
	{0xf01, "IA_LN10"},
	{0xf02, "IA_LN20"},
	{0xf03, "IA_LN30"},
	{0xf05, "IA_EX50"},
	{0xf06, "IA_LN60"},
	{0x7, "IA_TOE"},
	{0x14, "IA_DMA2R"},
	{0x13, "IA_DMA2T"},
	{0x1b, "IA_IXCM2"},
	{0x1c, "IA_IXCM3"},
	{0x1d, "IA_IXCM4"},
	{0x1e, "IA_IXCM5"},
	{0xf10, "IA_LN01"},
	{0x125, "IA_USB0_W"},
	{0x25, "IA_USB0_R"},
	{0x127, "IA_USB1_W"},
	{0x27, "IA_USB1_R"},
	{0x24, "IA_DMA1_R"},
	{0x23, "IA_DMA1_T"},
	{0x2e, "IA_XCMF"},
	{0xf20, "IA_LN02"},
	{0x13a, "IA_PCIE3_W"},
	{0x3a, "IA_PCIE3_R"},
	{0x136, "IA_PCIE1_W"},
	{0x36, "IA_PCIE1_R"},
	{0x132, "IA_PCIE2_W"},
	{0x32, "IA_PCIE2_R"},
	{0xf30, "IA_ILN03"},
	{0xf04, "IA_EX04"},
	{0x6a, "IA_L2"},
	{0x6b, "IA_TEP"},
	{0xf60, "IA_LN06"},
};
#endif
