/*
 * passthrough 
 * This module is used to pass through the specific packets
 * 
 * Peter Wu 20050804
 */

#include <linux/netdevice.h>
#include <linux/proc_fs.h>

extern int pppoe_pt_enable;
extern int ipv6_pt_enable;
extern int pppoe_pthrough(struct sk_buff *skb);
extern int ipv6_pthrough(struct sk_buff *skb);

/* return 1, if we want to handle this packet, or
 * return 0, let other ones do this	 */
int private_pthrough(struct sk_buff *skb)
{
	int ret = 0;

	if (pppoe_pt_enable) {
		ret = pppoe_pthrough(skb);
	}
	if (!ret && ipv6_pt_enable) {
		ret = ipv6_pthrough(skb);
	}
	
	return ret;
}

#define PT_ROOT		"pthrough"
static struct proc_dir_entry * root = NULL;
static struct proc_dir_entry * pppoe = NULL;
static struct proc_dir_entry * ipv6 = NULL;

/*Modify function parameters in kernel version 3.10 */
extern int proc_pppoe_read(struct file *filp,char *buf,size_t count,loff_t *offp);
extern int proc_pppoe_write(struct file *filp,const char *buf,size_t count,loff_t *offp);
extern int proc_ipv6_read(struct file *filp,char *buf,size_t count,loff_t *offp);
extern int proc_ipv6_write(struct file *filp,const char *buf,size_t count,loff_t *offp);

void pthrough_remove_proc_entry(void)
{
	if (pppoe) {
		remove_proc_entry("pppoe", root);
		pppoe = NULL;
	}
	if (ipv6) {
		remove_proc_entry("ipv6", root);
		ipv6 = NULL;
	}
	if (root) {
		remove_proc_entry(PT_ROOT, NULL);
		root = NULL;
	}
}
/*Add fops to map read/write function in kernel version 3.10 */
struct file_operations alpha_pppoe_proc_fops = {
        .write		    = proc_pppoe_write,
        .read           = proc_pppoe_read,
};
struct file_operations alpha_ipv6_proc_fops = {
        .write		    = proc_ipv6_write,
        .read           = proc_ipv6_read,
};

int pthrough_create_proc_entry(void)
{
	/* create directory */
	root = proc_mkdir(PT_ROOT, NULL);
	if (root == NULL) {
		printk("proc_mkdir return NULL!\n");
		goto pt_out;
	}

	/* create entries, use proc_create in kernel v3.10 */
	pppoe = proc_create("pppoe", 0644,root,&alpha_pppoe_proc_fops);
	if (pppoe == NULL) {
		printk("create_proc_entry (pppoe) return NULL!\n");
		goto pt_out;
	}
	
	ipv6 = proc_create("ipv6", 0644, root,&alpha_ipv6_proc_fops);
	if (ipv6 == NULL) {
		printk("create_proc_entry (ipv6) return NULL!\n");
		goto pt_out;
	}
	
	return 0;
	
pt_out:
	pthrough_remove_proc_entry();
	printk("Unable to create %s !!\n", PT_ROOT);
	return -1;
}

