/* Copyright (c) 2017, Intel Corporation.
 * 
 * GPIO Pad control header file
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
*/


#ifndef _GPIO_PAD_CTRL_H
#define _GPIO_PAD_CTRL_H

/*! \defgroup GPIO_PAD_CTRL Register File GPIO_PAD_CTRL - GPIO Pad Control Register Description */
/*! @{ */

/*! Base Address of GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_MODULE_BASE 0x16310000u

/*! \defgroup PORTMUXC0 Register PORTMUXC0 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC0 0x0
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC0 0x16380000u

/*! Register Reset Value */
#define PORTMUXC0_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC0_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC0_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC1 Register PORTMUXC1 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC1 0x4
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC1 0x16380004u

/*! Register Reset Value */
#define PORTMUXC1_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC1_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC1_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC2 Register PORTMUXC2 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC2 0x8
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC2 0x16380008u

/*! Register Reset Value */
#define PORTMUXC2_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC2_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC2_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC3 Register PORTMUXC3 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC3 0xC
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC3 0x1638000Cu

/*! Register Reset Value */
#define PORTMUXC3_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC3_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC3_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC4 Register PORTMUXC4 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC4 0x10
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC4 0x16380010u

/*! Register Reset Value */
#define PORTMUXC4_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC4_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC4_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC5 Register PORTMUXC5 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC5 0x14
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC5 0x16380014u

/*! Register Reset Value */
#define PORTMUXC5_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC5_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC5_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC6 Register PORTMUXC6 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC6 0x18
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC6 0x16380018u

/*! Register Reset Value */
#define PORTMUXC6_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC6_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC6_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC7 Register PORTMUXC7 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC7 0x1C
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC7 0x1638001Cu

/*! Register Reset Value */
#define PORTMUXC7_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC7_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC7_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC8 Register PORTMUXC8 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC8 0x20
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC8 0x16380020u

/*! Register Reset Value */
#define PORTMUXC8_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC8_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC8_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC9 Register PORTMUXC9 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC9 0x24
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC9 0x16380024u

/*! Register Reset Value */
#define PORTMUXC9_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC9_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC9_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC10 Register PORTMUXC10 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC10 0x28
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC10 0x16380028u

/*! Register Reset Value */
#define PORTMUXC10_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC10_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC10_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC11 Register PORTMUXC11 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC11 0x2C
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC11 0x1638002Cu

/*! Register Reset Value */
#define PORTMUXC11_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC11_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC11_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC12 Register PORTMUXC12 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC12 0x30
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC12 0x16380030u

/*! Register Reset Value */
#define PORTMUXC12_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC12_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC12_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC13 Register PORTMUXC13 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC13 0x34
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC13 0x16380034u

/*! Register Reset Value */
#define PORTMUXC13_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC13_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC13_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC14 Register PORTMUXC14 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC14 0x38
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC14 0x16380038u

/*! Register Reset Value */
#define PORTMUXC14_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC14_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC14_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC15 Register PORTMUXC15 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC15 0x3C
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC15 0x1638003Cu

/*! Register Reset Value */
#define PORTMUXC15_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC15_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC15_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC16 Register PORTMUXC16 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC16 0x40
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC16 0x16380040u

/*! Register Reset Value */
#define PORTMUXC16_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC16_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC16_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC17 Register PORTMUXC17 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC17 0x44
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC17 0x16380044u

/*! Register Reset Value */
#define PORTMUXC17_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC17_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC17_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC18 Register PORTMUXC18 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC18 0x48
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC18 0x16380048u

/*! Register Reset Value */
#define PORTMUXC18_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC18_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC18_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC19 Register PORTMUXC19 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC19 0x4C
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC19 0x1638004Cu

/*! Register Reset Value */
#define PORTMUXC19_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC19_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC19_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC20 Register PORTMUXC20 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC20 0x50
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC20 0x16380050u

/*! Register Reset Value */
#define PORTMUXC20_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC20_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC20_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC21 Register PORTMUXC21 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC21 0x54
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC21 0x16380054u

/*! Register Reset Value */
#define PORTMUXC21_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC21_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC21_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC22 Register PORTMUXC22 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC22 0x58
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC22 0x16380058u

/*! Register Reset Value */
#define PORTMUXC22_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC22_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC22_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC23 Register PORTMUXC23 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC23 0x5C
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC23 0x1638005Cu

/*! Register Reset Value */
#define PORTMUXC23_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC23_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC23_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC24 Register PORTMUXC24 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC24 0x60
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC24 0x16380060u

/*! Register Reset Value */
#define PORTMUXC24_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC24_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC24_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC25 Register PORTMUXC25 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC25 0x64
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC25 0x16380064u

/*! Register Reset Value */
#define PORTMUXC25_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC25_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC25_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC26 Register PORTMUXC26 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC26 0x68
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC26 0x16380068u

/*! Register Reset Value */
#define PORTMUXC26_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC26_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC26_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC27 Register PORTMUXC27 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC27 0x6C
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC27 0x1638006Cu

/*! Register Reset Value */
#define PORTMUXC27_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC27_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC27_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC28 Register PORTMUXC28 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC28 0x70
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC28 0x16380070u

/*! Register Reset Value */
#define PORTMUXC28_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC28_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC28_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC29 Register PORTMUXC29 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC29 0x74
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC29 0x16380074u

/*! Register Reset Value */
#define PORTMUXC29_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC29_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC29_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC30 Register PORTMUXC30 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC30 0x78
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC30 0x16380078u

/*! Register Reset Value */
#define PORTMUXC30_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC30_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC30_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC31 Register PORTMUXC31 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC31 0x7C
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC31 0x1638007Cu

/*! Register Reset Value */
#define PORTMUXC31_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC31_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC31_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PUEN_0 Register PUEN_0 - Pull Up Enable Register */
/*! @{ */

/*! Register Offset (relative) */
#define PUEN_0 0x80
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PUEN_0 0x16380080u

/*! Register Reset Value */
#define PUEN_0_RST 0xFFFFFFFFu

/*! Field P0 - Pad Pull Up Enable */
#define PUEN_0_P0_POS 0
/*! Field P0 - Pad Pull Up Enable */
#define PUEN_0_P0_MASK 0x1u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P0_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P0_EN 0x1

/*! Field P1 - Pad Pull Up Enable */
#define PUEN_0_P1_POS 1
/*! Field P1 - Pad Pull Up Enable */
#define PUEN_0_P1_MASK 0x2u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P1_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P1_EN 0x1

/*! Field P2 - Pad Pull Up Enable */
#define PUEN_0_P2_POS 2
/*! Field P2 - Pad Pull Up Enable */
#define PUEN_0_P2_MASK 0x4u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P2_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P2_EN 0x1

/*! Field P3 - Pad Pull Up Enable */
#define PUEN_0_P3_POS 3
/*! Field P3 - Pad Pull Up Enable */
#define PUEN_0_P3_MASK 0x8u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P3_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P3_EN 0x1

/*! Field P4 - Pad Pull Up Enable */
#define PUEN_0_P4_POS 4
/*! Field P4 - Pad Pull Up Enable */
#define PUEN_0_P4_MASK 0x10u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P4_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P4_EN 0x1

/*! Field P5 - Pad Pull Up Enable */
#define PUEN_0_P5_POS 5
/*! Field P5 - Pad Pull Up Enable */
#define PUEN_0_P5_MASK 0x20u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P5_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P5_EN 0x1

/*! Field P6 - Pad Pull Up Enable */
#define PUEN_0_P6_POS 6
/*! Field P6 - Pad Pull Up Enable */
#define PUEN_0_P6_MASK 0x40u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P6_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P6_EN 0x1

/*! Field P7 - Pad Pull Up Enable */
#define PUEN_0_P7_POS 7
/*! Field P7 - Pad Pull Up Enable */
#define PUEN_0_P7_MASK 0x80u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P7_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P7_EN 0x1

/*! Field P8 - Pad Pull Up Enable */
#define PUEN_0_P8_POS 8
/*! Field P8 - Pad Pull Up Enable */
#define PUEN_0_P8_MASK 0x100u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P8_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P8_EN 0x1

/*! Field P9 - Pad Pull Up Enable */
#define PUEN_0_P9_POS 9
/*! Field P9 - Pad Pull Up Enable */
#define PUEN_0_P9_MASK 0x200u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P9_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P9_EN 0x1

/*! Field P10 - Pad Pull Up Enable */
#define PUEN_0_P10_POS 10
/*! Field P10 - Pad Pull Up Enable */
#define PUEN_0_P10_MASK 0x400u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P10_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P10_EN 0x1

/*! Field P11 - Pad Pull Up Enable */
#define PUEN_0_P11_POS 11
/*! Field P11 - Pad Pull Up Enable */
#define PUEN_0_P11_MASK 0x800u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P11_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P11_EN 0x1

/*! Field P12 - Pad Pull Up Enable */
#define PUEN_0_P12_POS 12
/*! Field P12 - Pad Pull Up Enable */
#define PUEN_0_P12_MASK 0x1000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P12_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P12_EN 0x1

/*! Field P13 - Pad Pull Up Enable */
#define PUEN_0_P13_POS 13
/*! Field P13 - Pad Pull Up Enable */
#define PUEN_0_P13_MASK 0x2000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P13_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P13_EN 0x1

/*! Field P14 - Pad Pull Up Enable */
#define PUEN_0_P14_POS 14
/*! Field P14 - Pad Pull Up Enable */
#define PUEN_0_P14_MASK 0x4000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P14_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P14_EN 0x1

/*! Field P15 - Pad Pull Up Enable */
#define PUEN_0_P15_POS 15
/*! Field P15 - Pad Pull Up Enable */
#define PUEN_0_P15_MASK 0x8000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P15_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P15_EN 0x1

/*! Field P16 - Pad Pull Up Enable */
#define PUEN_0_P16_POS 16
/*! Field P16 - Pad Pull Up Enable */
#define PUEN_0_P16_MASK 0x10000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P16_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P16_EN 0x1

/*! Field P17 - Pad Pull Up Enable */
#define PUEN_0_P17_POS 17
/*! Field P17 - Pad Pull Up Enable */
#define PUEN_0_P17_MASK 0x20000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P17_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P17_EN 0x1

/*! Field P18 - Pad Pull Up Enable */
#define PUEN_0_P18_POS 18
/*! Field P18 - Pad Pull Up Enable */
#define PUEN_0_P18_MASK 0x40000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P18_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P18_EN 0x1

/*! Field P19 - Pad Pull Up Enable */
#define PUEN_0_P19_POS 19
/*! Field P19 - Pad Pull Up Enable */
#define PUEN_0_P19_MASK 0x80000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P19_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P19_EN 0x1

/*! Field P20 - Pad Pull Up Enable */
#define PUEN_0_P20_POS 20
/*! Field P20 - Pad Pull Up Enable */
#define PUEN_0_P20_MASK 0x100000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P20_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P20_EN 0x1

/*! Field P21 - Pad Pull Up Enable */
#define PUEN_0_P21_POS 21
/*! Field P21 - Pad Pull Up Enable */
#define PUEN_0_P21_MASK 0x200000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P21_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P21_EN 0x1

/*! Field P22 - Pad Pull Up Enable */
#define PUEN_0_P22_POS 22
/*! Field P22 - Pad Pull Up Enable */
#define PUEN_0_P22_MASK 0x400000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P22_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P22_EN 0x1

/*! Field P23 - Pad Pull Up Enable */
#define PUEN_0_P23_POS 23
/*! Field P23 - Pad Pull Up Enable */
#define PUEN_0_P23_MASK 0x800000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P23_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P23_EN 0x1

/*! Field P24 - Pad Pull Up Enable */
#define PUEN_0_P24_POS 24
/*! Field P24 - Pad Pull Up Enable */
#define PUEN_0_P24_MASK 0x1000000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P24_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P24_EN 0x1

/*! Field P25 - Pad Pull Up Enable */
#define PUEN_0_P25_POS 25
/*! Field P25 - Pad Pull Up Enable */
#define PUEN_0_P25_MASK 0x2000000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P25_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P25_EN 0x1

/*! Field P26 - Pad Pull Up Enable */
#define PUEN_0_P26_POS 26
/*! Field P26 - Pad Pull Up Enable */
#define PUEN_0_P26_MASK 0x4000000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P26_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P26_EN 0x1

/*! Field P27 - Pad Pull Up Enable */
#define PUEN_0_P27_POS 27
/*! Field P27 - Pad Pull Up Enable */
#define PUEN_0_P27_MASK 0x8000000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P27_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P27_EN 0x1

/*! Field P28 - Pad Pull Up Enable */
#define PUEN_0_P28_POS 28
/*! Field P28 - Pad Pull Up Enable */
#define PUEN_0_P28_MASK 0x10000000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P28_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P28_EN 0x1

/*! Field P29 - Pad Pull Up Enable */
#define PUEN_0_P29_POS 29
/*! Field P29 - Pad Pull Up Enable */
#define PUEN_0_P29_MASK 0x20000000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P29_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P29_EN 0x1

/*! Field P30 - Pad Pull Up Enable */
#define PUEN_0_P30_POS 30
/*! Field P30 - Pad Pull Up Enable */
#define PUEN_0_P30_MASK 0x40000000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P30_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P30_EN 0x1

/*! Field P31 - Pad Pull Up Enable */
#define PUEN_0_P31_POS 31
/*! Field P31 - Pad Pull Up Enable */
#define PUEN_0_P31_MASK 0x80000000u
/*! Constant DIS - DIS */
#define CONST_PUEN_0_P31_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_0_P31_EN 0x1

/*! @} */

/*! \defgroup PDEN_0 Register PDEN_0 - Pull Down Enable Register */
/*! @{ */

/*! Register Offset (relative) */
#define PDEN_0 0x84
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PDEN_0 0x16380084u

/*! Register Reset Value */
#define PDEN_0_RST 0x00000000u

/*! Field P0 - Pad Pull Down Enable */
#define PDEN_0_P0_POS 0
/*! Field P0 - Pad Pull Down Enable */
#define PDEN_0_P0_MASK 0x1u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P0_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P0_EN 0x1

/*! Field P1 - Pad Pull Down Enable */
#define PDEN_0_P1_POS 1
/*! Field P1 - Pad Pull Down Enable */
#define PDEN_0_P1_MASK 0x2u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P1_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P1_EN 0x1

/*! Field P2 - Pad Pull Down Enable */
#define PDEN_0_P2_POS 2
/*! Field P2 - Pad Pull Down Enable */
#define PDEN_0_P2_MASK 0x4u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P2_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P2_EN 0x1

/*! Field P3 - Pad Pull Down Enable */
#define PDEN_0_P3_POS 3
/*! Field P3 - Pad Pull Down Enable */
#define PDEN_0_P3_MASK 0x8u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P3_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P3_EN 0x1

/*! Field P4 - Pad Pull Down Enable */
#define PDEN_0_P4_POS 4
/*! Field P4 - Pad Pull Down Enable */
#define PDEN_0_P4_MASK 0x10u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P4_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P4_EN 0x1

/*! Field P5 - Pad Pull Down Enable */
#define PDEN_0_P5_POS 5
/*! Field P5 - Pad Pull Down Enable */
#define PDEN_0_P5_MASK 0x20u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P5_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P5_EN 0x1

/*! Field P6 - Pad Pull Down Enable */
#define PDEN_0_P6_POS 6
/*! Field P6 - Pad Pull Down Enable */
#define PDEN_0_P6_MASK 0x40u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P6_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P6_EN 0x1

/*! Field P7 - Pad Pull Down Enable */
#define PDEN_0_P7_POS 7
/*! Field P7 - Pad Pull Down Enable */
#define PDEN_0_P7_MASK 0x80u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P7_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P7_EN 0x1

/*! Field P8 - Pad Pull Down Enable */
#define PDEN_0_P8_POS 8
/*! Field P8 - Pad Pull Down Enable */
#define PDEN_0_P8_MASK 0x100u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P8_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P8_EN 0x1

/*! Field P9 - Pad Pull Down Enable */
#define PDEN_0_P9_POS 9
/*! Field P9 - Pad Pull Down Enable */
#define PDEN_0_P9_MASK 0x200u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P9_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P9_EN 0x1

/*! Field P10 - Pad Pull Down Enable */
#define PDEN_0_P10_POS 10
/*! Field P10 - Pad Pull Down Enable */
#define PDEN_0_P10_MASK 0x400u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P10_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P10_EN 0x1

/*! Field P11 - Pad Pull Down Enable */
#define PDEN_0_P11_POS 11
/*! Field P11 - Pad Pull Down Enable */
#define PDEN_0_P11_MASK 0x800u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P11_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P11_EN 0x1

/*! Field P12 - Pad Pull Down Enable */
#define PDEN_0_P12_POS 12
/*! Field P12 - Pad Pull Down Enable */
#define PDEN_0_P12_MASK 0x1000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P12_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P12_EN 0x1

/*! Field P13 - Pad Pull Down Enable */
#define PDEN_0_P13_POS 13
/*! Field P13 - Pad Pull Down Enable */
#define PDEN_0_P13_MASK 0x2000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P13_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P13_EN 0x1

/*! Field P14 - Pad Pull Down Enable */
#define PDEN_0_P14_POS 14
/*! Field P14 - Pad Pull Down Enable */
#define PDEN_0_P14_MASK 0x4000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P14_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P14_EN 0x1

/*! Field P15 - Pad Pull Down Enable */
#define PDEN_0_P15_POS 15
/*! Field P15 - Pad Pull Down Enable */
#define PDEN_0_P15_MASK 0x8000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P15_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P15_EN 0x1

/*! Field P16 - Pad Pull Down Enable */
#define PDEN_0_P16_POS 16
/*! Field P16 - Pad Pull Down Enable */
#define PDEN_0_P16_MASK 0x10000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P16_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P16_EN 0x1

/*! Field P17 - Pad Pull Down Enable */
#define PDEN_0_P17_POS 17
/*! Field P17 - Pad Pull Down Enable */
#define PDEN_0_P17_MASK 0x20000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P17_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P17_EN 0x1

/*! Field P18 - Pad Pull Down Enable */
#define PDEN_0_P18_POS 18
/*! Field P18 - Pad Pull Down Enable */
#define PDEN_0_P18_MASK 0x40000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P18_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P18_EN 0x1

/*! Field P19 - Pad Pull Down Enable */
#define PDEN_0_P19_POS 19
/*! Field P19 - Pad Pull Down Enable */
#define PDEN_0_P19_MASK 0x80000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P19_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P19_EN 0x1

/*! Field P20 - Pad Pull Down Enable */
#define PDEN_0_P20_POS 20
/*! Field P20 - Pad Pull Down Enable */
#define PDEN_0_P20_MASK 0x100000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P20_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P20_EN 0x1

/*! Field P21 - Pad Pull Down Enable */
#define PDEN_0_P21_POS 21
/*! Field P21 - Pad Pull Down Enable */
#define PDEN_0_P21_MASK 0x200000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P21_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P21_EN 0x1

/*! Field P22 - Pad Pull Down Enable */
#define PDEN_0_P22_POS 22
/*! Field P22 - Pad Pull Down Enable */
#define PDEN_0_P22_MASK 0x400000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P22_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P22_EN 0x1

/*! Field P23 - Pad Pull Down Enable */
#define PDEN_0_P23_POS 23
/*! Field P23 - Pad Pull Down Enable */
#define PDEN_0_P23_MASK 0x800000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P23_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P23_EN 0x1

/*! Field P24 - Pad Pull Down Enable */
#define PDEN_0_P24_POS 24
/*! Field P24 - Pad Pull Down Enable */
#define PDEN_0_P24_MASK 0x1000000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P24_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P24_EN 0x1

/*! Field P25 - Pad Pull Down Enable */
#define PDEN_0_P25_POS 25
/*! Field P25 - Pad Pull Down Enable */
#define PDEN_0_P25_MASK 0x2000000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P25_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P25_EN 0x1

/*! Field P26 - Pad Pull Down Enable */
#define PDEN_0_P26_POS 26
/*! Field P26 - Pad Pull Down Enable */
#define PDEN_0_P26_MASK 0x4000000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P26_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P26_EN 0x1

/*! Field P27 - Pad Pull Down Enable */
#define PDEN_0_P27_POS 27
/*! Field P27 - Pad Pull Down Enable */
#define PDEN_0_P27_MASK 0x8000000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P27_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P27_EN 0x1

/*! Field P28 - Pad Pull Down Enable */
#define PDEN_0_P28_POS 28
/*! Field P28 - Pad Pull Down Enable */
#define PDEN_0_P28_MASK 0x10000000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P28_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P28_EN 0x1

/*! Field P29 - Pad Pull Down Enable */
#define PDEN_0_P29_POS 29
/*! Field P29 - Pad Pull Down Enable */
#define PDEN_0_P29_MASK 0x20000000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P29_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P29_EN 0x1

/*! Field P30 - Pad Pull Down Enable */
#define PDEN_0_P30_POS 30
/*! Field P30 - Pad Pull Down Enable */
#define PDEN_0_P30_MASK 0x40000000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P30_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P30_EN 0x1

/*! Field P31 - Pad Pull Down Enable */
#define PDEN_0_P31_POS 31
/*! Field P31 - Pad Pull Down Enable */
#define PDEN_0_P31_MASK 0x80000000u
/*! Constant DIS - DIS */
#define CONST_PDEN_0_P31_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_0_P31_EN 0x1

/*! @} */

/*! \defgroup SRC_0 Register SRC_0 - Slew Rate Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define SRC_0 0x88
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_SRC_0 0x16380088u

/*! Register Reset Value */
#define SRC_0_RST 0x00000000u

/*! Field P0 - Pad Slew Control */
#define SRC_0_P0_POS 0
/*! Field P0 - Pad Slew Control */
#define SRC_0_P0_MASK 0x1u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P0_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P0_FAST 0x1

/*! Field P1 - Pad Slew Control */
#define SRC_0_P1_POS 1
/*! Field P1 - Pad Slew Control */
#define SRC_0_P1_MASK 0x2u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P1_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P1_FAST 0x1

/*! Field P2 - Pad Slew Control */
#define SRC_0_P2_POS 2
/*! Field P2 - Pad Slew Control */
#define SRC_0_P2_MASK 0x4u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P2_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P2_FAST 0x1

/*! Field P3 - Pad Slew Control */
#define SRC_0_P3_POS 3
/*! Field P3 - Pad Slew Control */
#define SRC_0_P3_MASK 0x8u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P3_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P3_FAST 0x1

/*! Field P4 - Pad Slew Control */
#define SRC_0_P4_POS 4
/*! Field P4 - Pad Slew Control */
#define SRC_0_P4_MASK 0x10u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P4_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P4_FAST 0x1

/*! Field P5 - Pad Slew Control */
#define SRC_0_P5_POS 5
/*! Field P5 - Pad Slew Control */
#define SRC_0_P5_MASK 0x20u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P5_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P5_FAST 0x1

/*! Field P6 - Pad Slew Control */
#define SRC_0_P6_POS 6
/*! Field P6 - Pad Slew Control */
#define SRC_0_P6_MASK 0x40u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P6_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P6_FAST 0x1

/*! Field P7 - Pad Slew Control */
#define SRC_0_P7_POS 7
/*! Field P7 - Pad Slew Control */
#define SRC_0_P7_MASK 0x80u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P7_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P7_FAST 0x1

/*! Field P8 - Pad Slew Control */
#define SRC_0_P8_POS 8
/*! Field P8 - Pad Slew Control */
#define SRC_0_P8_MASK 0x100u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P8_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P8_FAST 0x1

/*! Field P9 - Pad Slew Control */
#define SRC_0_P9_POS 9
/*! Field P9 - Pad Slew Control */
#define SRC_0_P9_MASK 0x200u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P9_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P9_FAST 0x1

/*! Field P10 - Pad Slew Control */
#define SRC_0_P10_POS 10
/*! Field P10 - Pad Slew Control */
#define SRC_0_P10_MASK 0x400u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P10_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P10_FAST 0x1

/*! Field P11 - Pad Slew Control */
#define SRC_0_P11_POS 11
/*! Field P11 - Pad Slew Control */
#define SRC_0_P11_MASK 0x800u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P11_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P11_FAST 0x1

/*! Field P12 - Pad Slew Control */
#define SRC_0_P12_POS 12
/*! Field P12 - Pad Slew Control */
#define SRC_0_P12_MASK 0x1000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P12_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P12_FAST 0x1

/*! Field P13 - Pad Slew Control */
#define SRC_0_P13_POS 13
/*! Field P13 - Pad Slew Control */
#define SRC_0_P13_MASK 0x2000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P13_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P13_FAST 0x1

/*! Field P14 - Pad Slew Control */
#define SRC_0_P14_POS 14
/*! Field P14 - Pad Slew Control */
#define SRC_0_P14_MASK 0x4000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P14_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P14_FAST 0x1

/*! Field P15 - Pad Slew Control */
#define SRC_0_P15_POS 15
/*! Field P15 - Pad Slew Control */
#define SRC_0_P15_MASK 0x8000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P15_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P15_FAST 0x1

/*! Field P16 - Pad Slew Control */
#define SRC_0_P16_POS 16
/*! Field P16 - Pad Slew Control */
#define SRC_0_P16_MASK 0x10000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P16_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P16_FAST 0x1

/*! Field P17 - Pad Slew Control */
#define SRC_0_P17_POS 17
/*! Field P17 - Pad Slew Control */
#define SRC_0_P17_MASK 0x20000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P17_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P17_FAST 0x1

/*! Field P18 - Pad Slew Control */
#define SRC_0_P18_POS 18
/*! Field P18 - Pad Slew Control */
#define SRC_0_P18_MASK 0x40000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P18_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P18_FAST 0x1

/*! Field P19 - Pad Slew Control */
#define SRC_0_P19_POS 19
/*! Field P19 - Pad Slew Control */
#define SRC_0_P19_MASK 0x80000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P19_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P19_FAST 0x1

/*! Field P20 - Pad Slew Control */
#define SRC_0_P20_POS 20
/*! Field P20 - Pad Slew Control */
#define SRC_0_P20_MASK 0x100000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P20_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P20_FAST 0x1

/*! Field P21 - Pad Slew Control */
#define SRC_0_P21_POS 21
/*! Field P21 - Pad Slew Control */
#define SRC_0_P21_MASK 0x200000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P21_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P21_FAST 0x1

/*! Field P22 - Pad Slew Control */
#define SRC_0_P22_POS 22
/*! Field P22 - Pad Slew Control */
#define SRC_0_P22_MASK 0x400000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P22_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P22_FAST 0x1

/*! Field P23 - Pad Slew Control */
#define SRC_0_P23_POS 23
/*! Field P23 - Pad Slew Control */
#define SRC_0_P23_MASK 0x800000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P23_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P23_FAST 0x1

/*! Field P24 - Pad Slew Control */
#define SRC_0_P24_POS 24
/*! Field P24 - Pad Slew Control */
#define SRC_0_P24_MASK 0x1000000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P24_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P24_FAST 0x1

/*! Field P25 - Pad Slew Control */
#define SRC_0_P25_POS 25
/*! Field P25 - Pad Slew Control */
#define SRC_0_P25_MASK 0x2000000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P25_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P25_FAST 0x1

/*! Field P26 - Pad Slew Control */
#define SRC_0_P26_POS 26
/*! Field P26 - Pad Slew Control */
#define SRC_0_P26_MASK 0x4000000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P26_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P26_FAST 0x1

/*! Field P27 - Pad Slew Control */
#define SRC_0_P27_POS 27
/*! Field P27 - Pad Slew Control */
#define SRC_0_P27_MASK 0x8000000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P27_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P27_FAST 0x1

/*! Field P28 - Pad Slew Control */
#define SRC_0_P28_POS 28
/*! Field P28 - Pad Slew Control */
#define SRC_0_P28_MASK 0x10000000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P28_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P28_FAST 0x1

/*! Field P29 - Pad Slew Control */
#define SRC_0_P29_POS 29
/*! Field P29 - Pad Slew Control */
#define SRC_0_P29_MASK 0x20000000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P29_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P29_FAST 0x1

/*! Field P30 - Pad Slew Control */
#define SRC_0_P30_POS 30
/*! Field P30 - Pad Slew Control */
#define SRC_0_P30_MASK 0x40000000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P30_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P30_FAST 0x1

/*! Field P31 - Pad Slew Control */
#define SRC_0_P31_POS 31
/*! Field P31 - Pad Slew Control */
#define SRC_0_P31_MASK 0x80000000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_0_P31_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_0_P31_FAST 0x1

/*! @} */

/*! \defgroup DCC_0 Register DCC_0 - Drive Current Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define DCC_0 0x8C
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_DCC_0 0x1638008Cu

/*! Register Reset Value */
#define DCC_0_RST 0x00000000u

/*! Field P0 - Pad Drive Control */
#define DCC_0_P0_POS 0
/*! Field P0 - Pad Drive Control */
#define DCC_0_P0_MASK 0x3u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_0_P0_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_0_P0_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_0_P0_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_0_P0_V12MA 0x3

/*! Field P1 - Pad Drive Control */
#define DCC_0_P1_POS 2
/*! Field P1 - Pad Drive Control */
#define DCC_0_P1_MASK 0xCu
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_0_P1_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_0_P1_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_0_P1_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_0_P1_V12MA 0x3

/*! Field P2 - Pad Drive Control */
#define DCC_0_P2_POS 4
/*! Field P2 - Pad Drive Control */
#define DCC_0_P2_MASK 0x30u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_0_P2_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_0_P2_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_0_P2_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_0_P2_V12MA 0x3

/*! Field P3 - Pad Drive Control */
#define DCC_0_P3_POS 6
/*! Field P3 - Pad Drive Control */
#define DCC_0_P3_MASK 0xC0u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_0_P3_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_0_P3_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_0_P3_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_0_P3_V12MA 0x3

/*! Field P4 - Pad Drive Control */
#define DCC_0_P4_POS 8
/*! Field P4 - Pad Drive Control */
#define DCC_0_P4_MASK 0x300u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_0_P4_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_0_P4_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_0_P4_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_0_P4_V12MA 0x3

/*! Field P5 - Pad Drive Control */
#define DCC_0_P5_POS 10
/*! Field P5 - Pad Drive Control */
#define DCC_0_P5_MASK 0xC00u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_0_P5_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_0_P5_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_0_P5_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_0_P5_V12MA 0x3

/*! Field P6 - Pad Drive Control */
#define DCC_0_P6_POS 12
/*! Field P6 - Pad Drive Control */
#define DCC_0_P6_MASK 0x3000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_0_P6_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_0_P6_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_0_P6_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_0_P6_V12MA 0x3

/*! Field P7 - Pad Drive Control */
#define DCC_0_P7_POS 14
/*! Field P7 - Pad Drive Control */
#define DCC_0_P7_MASK 0xC000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_0_P7_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_0_P7_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_0_P7_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_0_P7_V12MA 0x3

/*! Field P8 - Pad Drive Control */
#define DCC_0_P8_POS 16
/*! Field P8 - Pad Drive Control */
#define DCC_0_P8_MASK 0x30000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_0_P8_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_0_P8_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_0_P8_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_0_P8_V12MA 0x3

/*! Field P9 - Pad Drive Control */
#define DCC_0_P9_POS 18
/*! Field P9 - Pad Drive Control */
#define DCC_0_P9_MASK 0xC0000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_0_P9_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_0_P9_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_0_P9_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_0_P9_V12MA 0x3

/*! Field P10 - Pad Drive Control */
#define DCC_0_P10_POS 20
/*! Field P10 - Pad Drive Control */
#define DCC_0_P10_MASK 0x300000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_0_P10_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_0_P10_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_0_P10_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_0_P10_V12MA 0x3

/*! Field P11 - Pad Drive Control */
#define DCC_0_P11_POS 22
/*! Field P11 - Pad Drive Control */
#define DCC_0_P11_MASK 0xC00000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_0_P11_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_0_P11_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_0_P11_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_0_P11_V12MA 0x3

/*! Field P12 - Pad Drive Control */
#define DCC_0_P12_POS 24
/*! Field P12 - Pad Drive Control */
#define DCC_0_P12_MASK 0x3000000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_0_P12_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_0_P12_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_0_P12_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_0_P12_V12MA 0x3

/*! Field P13 - Pad Drive Control */
#define DCC_0_P13_POS 26
/*! Field P13 - Pad Drive Control */
#define DCC_0_P13_MASK 0xC000000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_0_P13_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_0_P13_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_0_P13_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_0_P13_V12MA 0x3

/*! Field P14 - Pad Drive Control */
#define DCC_0_P14_POS 28
/*! Field P14 - Pad Drive Control */
#define DCC_0_P14_MASK 0x30000000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_0_P14_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_0_P14_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_0_P14_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_0_P14_V12MA 0x3

/*! Field P15 - Pad Drive Control */
#define DCC_0_P15_POS 30
/*! Field P15 - Pad Drive Control */
#define DCC_0_P15_MASK 0xC0000000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_0_P15_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_0_P15_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_0_P15_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_0_P15_V12MA 0x3

/*! @} */

/*! \defgroup DCC_1 Register DCC_1 - Drive Current Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define DCC_1 0x90
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_DCC_1 0x16380090u

/*! Register Reset Value */
#define DCC_1_RST 0x00000000u

/*! Field P16 - Pad Drive Control */
#define DCC_1_P16_POS 0
/*! Field P16 - Pad Drive Control */
#define DCC_1_P16_MASK 0x3u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_1_P16_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_1_P16_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_1_P16_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_1_P16_V12MA 0x3

/*! Field P17 - Pad Drive Control */
#define DCC_1_P17_POS 2
/*! Field P17 - Pad Drive Control */
#define DCC_1_P17_MASK 0xCu
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_1_P17_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_1_P17_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_1_P17_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_1_P17_V12MA 0x3

/*! Field P18 - Pad Drive Control */
#define DCC_1_P18_POS 4
/*! Field P18 - Pad Drive Control */
#define DCC_1_P18_MASK 0x30u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_1_P18_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_1_P18_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_1_P18_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_1_P18_V12MA 0x3

/*! Field P19 - Pad Drive Control */
#define DCC_1_P19_POS 6
/*! Field P19 - Pad Drive Control */
#define DCC_1_P19_MASK 0xC0u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_1_P19_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_1_P19_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_1_P19_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_1_P19_V12MA 0x3

/*! Field P20 - Pad Drive Control */
#define DCC_1_P20_POS 8
/*! Field P20 - Pad Drive Control */
#define DCC_1_P20_MASK 0x300u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_1_P20_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_1_P20_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_1_P20_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_1_P20_V12MA 0x3

/*! Field P21 - Pad Drive Control */
#define DCC_1_P21_POS 10
/*! Field P21 - Pad Drive Control */
#define DCC_1_P21_MASK 0xC00u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_1_P21_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_1_P21_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_1_P21_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_1_P21_V12MA 0x3

/*! Field P22 - Pad Drive Control */
#define DCC_1_P22_POS 12
/*! Field P22 - Pad Drive Control */
#define DCC_1_P22_MASK 0x3000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_1_P22_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_1_P22_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_1_P22_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_1_P22_V12MA 0x3

/*! Field P23 - Pad Drive Control */
#define DCC_1_P23_POS 14
/*! Field P23 - Pad Drive Control */
#define DCC_1_P23_MASK 0xC000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_1_P23_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_1_P23_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_1_P23_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_1_P23_V12MA 0x3

/*! Field P24 - Pad Drive Control */
#define DCC_1_P24_POS 16
/*! Field P24 - Pad Drive Control */
#define DCC_1_P24_MASK 0x30000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_1_P24_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_1_P24_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_1_P24_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_1_P24_V12MA 0x3

/*! Field P25 - Pad Drive Control */
#define DCC_1_P25_POS 18
/*! Field P25 - Pad Drive Control */
#define DCC_1_P25_MASK 0xC0000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_1_P25_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_1_P25_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_1_P25_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_1_P25_V12MA 0x3

/*! Field P26 - Pad Drive Control */
#define DCC_1_P26_POS 20
/*! Field P26 - Pad Drive Control */
#define DCC_1_P26_MASK 0x300000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_1_P26_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_1_P26_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_1_P26_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_1_P26_V12MA 0x3

/*! Field P27 - Pad Drive Control */
#define DCC_1_P27_POS 22
/*! Field P27 - Pad Drive Control */
#define DCC_1_P27_MASK 0xC00000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_1_P27_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_1_P27_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_1_P27_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_1_P27_V12MA 0x3

/*! Field P28 - Pad Drive Control */
#define DCC_1_P28_POS 24
/*! Field P28 - Pad Drive Control */
#define DCC_1_P28_MASK 0x3000000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_1_P28_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_1_P28_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_1_P28_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_1_P28_V12MA 0x3

/*! Field P29 - Pad Drive Control */
#define DCC_1_P29_POS 26
/*! Field P29 - Pad Drive Control */
#define DCC_1_P29_MASK 0xC000000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_1_P29_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_1_P29_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_1_P29_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_1_P29_V12MA 0x3

/*! Field P30 - Pad Drive Control */
#define DCC_1_P30_POS 28
/*! Field P30 - Pad Drive Control */
#define DCC_1_P30_MASK 0x30000000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_1_P30_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_1_P30_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_1_P30_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_1_P30_V12MA 0x3

/*! Field P31 - Pad Drive Control */
#define DCC_1_P31_POS 30
/*! Field P31 - Pad Drive Control */
#define DCC_1_P31_MASK 0xC0000000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_1_P31_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_1_P31_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_1_P31_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_1_P31_V12MA 0x3

/*! @} */

/*! \defgroup OD_0 Register OD_0 - Open Drain Enable Register 0 */
/*! @{ */

/*! Register Offset (relative) */
#define OD_0 0x94
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_OD_0 0x16380094u

/*! Register Reset Value */
#define OD_0_RST 0x00000000u

/*! Field P0 - Pin Open Drain Enable */
#define OD_0_P0_POS 0
/*! Field P0 - Pin Open Drain Enable */
#define OD_0_P0_MASK 0x1u
/*! Constant NOP - No operation */
#define CONST_OD_0_P0_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P0_EN 0x1

/*! Field P1 - Pin Open Drain Enable */
#define OD_0_P1_POS 1
/*! Field P1 - Pin Open Drain Enable */
#define OD_0_P1_MASK 0x2u
/*! Constant NOP - No operation */
#define CONST_OD_0_P1_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P1_EN 0x1

/*! Field P2 - Pin Open Drain Enable */
#define OD_0_P2_POS 2
/*! Field P2 - Pin Open Drain Enable */
#define OD_0_P2_MASK 0x4u
/*! Constant NOP - No operation */
#define CONST_OD_0_P2_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P2_EN 0x1

/*! Field P3 - Pin Open Drain Enable */
#define OD_0_P3_POS 3
/*! Field P3 - Pin Open Drain Enable */
#define OD_0_P3_MASK 0x8u
/*! Constant NOP - No operation */
#define CONST_OD_0_P3_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P3_EN 0x1

/*! Field P4 - Pin Open Drain Enable */
#define OD_0_P4_POS 4
/*! Field P4 - Pin Open Drain Enable */
#define OD_0_P4_MASK 0x10u
/*! Constant NOP - No operation */
#define CONST_OD_0_P4_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P4_EN 0x1

/*! Field P5 - Pin Open Drain Enable */
#define OD_0_P5_POS 5
/*! Field P5 - Pin Open Drain Enable */
#define OD_0_P5_MASK 0x20u
/*! Constant NOP - No operation */
#define CONST_OD_0_P5_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P5_EN 0x1

/*! Field P6 - Pin Open Drain Enable */
#define OD_0_P6_POS 6
/*! Field P6 - Pin Open Drain Enable */
#define OD_0_P6_MASK 0x40u
/*! Constant NOP - No operation */
#define CONST_OD_0_P6_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P6_EN 0x1

/*! Field P7 - Pin Open Drain Enable */
#define OD_0_P7_POS 7
/*! Field P7 - Pin Open Drain Enable */
#define OD_0_P7_MASK 0x80u
/*! Constant NOP - No operation */
#define CONST_OD_0_P7_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P7_EN 0x1

/*! Field P8 - Pin Open Drain Enable */
#define OD_0_P8_POS 8
/*! Field P8 - Pin Open Drain Enable */
#define OD_0_P8_MASK 0x100u
/*! Constant NOP - No operation */
#define CONST_OD_0_P8_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P8_EN 0x1

/*! Field P9 - Pin Open Drain Enable */
#define OD_0_P9_POS 9
/*! Field P9 - Pin Open Drain Enable */
#define OD_0_P9_MASK 0x200u
/*! Constant NOP - No operation */
#define CONST_OD_0_P9_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P9_EN 0x1

/*! Field P10 - Pin Open Drain Enable */
#define OD_0_P10_POS 10
/*! Field P10 - Pin Open Drain Enable */
#define OD_0_P10_MASK 0x400u
/*! Constant NOP - No operation */
#define CONST_OD_0_P10_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P10_EN 0x1

/*! Field P11 - Pin Open Drain Enable */
#define OD_0_P11_POS 11
/*! Field P11 - Pin Open Drain Enable */
#define OD_0_P11_MASK 0x800u
/*! Constant NOP - No operation */
#define CONST_OD_0_P11_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P11_EN 0x1

/*! Field P12 - Pin Open Drain Enable */
#define OD_0_P12_POS 12
/*! Field P12 - Pin Open Drain Enable */
#define OD_0_P12_MASK 0x1000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P12_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P12_EN 0x1

/*! Field P13 - Pin Open Drain Enable */
#define OD_0_P13_POS 13
/*! Field P13 - Pin Open Drain Enable */
#define OD_0_P13_MASK 0x2000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P13_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P13_EN 0x1

/*! Field P14 - Pin Open Drain Enable */
#define OD_0_P14_POS 14
/*! Field P14 - Pin Open Drain Enable */
#define OD_0_P14_MASK 0x4000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P14_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P14_EN 0x1

/*! Field P15 - Pin Open Drain Enable */
#define OD_0_P15_POS 15
/*! Field P15 - Pin Open Drain Enable */
#define OD_0_P15_MASK 0x8000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P15_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P15_EN 0x1

/*! Field P16 - Pin Open Drain Enable */
#define OD_0_P16_POS 16
/*! Field P16 - Pin Open Drain Enable */
#define OD_0_P16_MASK 0x10000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P16_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P16_EN 0x1

/*! Field P17 - Pin Open Drain Enable */
#define OD_0_P17_POS 17
/*! Field P17 - Pin Open Drain Enable */
#define OD_0_P17_MASK 0x20000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P17_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P17_EN 0x1

/*! Field P18 - Pin Open Drain Enable */
#define OD_0_P18_POS 18
/*! Field P18 - Pin Open Drain Enable */
#define OD_0_P18_MASK 0x40000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P18_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P18_EN 0x1

/*! Field P19 - Pin Open Drain Enable */
#define OD_0_P19_POS 19
/*! Field P19 - Pin Open Drain Enable */
#define OD_0_P19_MASK 0x80000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P19_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P19_EN 0x1

/*! Field P20 - Pin Open Drain Enable */
#define OD_0_P20_POS 20
/*! Field P20 - Pin Open Drain Enable */
#define OD_0_P20_MASK 0x100000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P20_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P20_EN 0x1

/*! Field P21 - Pin Open Drain Enable */
#define OD_0_P21_POS 21
/*! Field P21 - Pin Open Drain Enable */
#define OD_0_P21_MASK 0x200000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P21_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P21_EN 0x1

/*! Field P22 - Pin Open Drain Enable */
#define OD_0_P22_POS 22
/*! Field P22 - Pin Open Drain Enable */
#define OD_0_P22_MASK 0x400000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P22_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P22_EN 0x1

/*! Field P23 - Pin Open Drain Enable */
#define OD_0_P23_POS 23
/*! Field P23 - Pin Open Drain Enable */
#define OD_0_P23_MASK 0x800000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P23_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P23_EN 0x1

/*! Field P24 - Pin Open Drain Enable */
#define OD_0_P24_POS 24
/*! Field P24 - Pin Open Drain Enable */
#define OD_0_P24_MASK 0x1000000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P24_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P24_EN 0x1

/*! Field P25 - Pin Open Drain Enable */
#define OD_0_P25_POS 25
/*! Field P25 - Pin Open Drain Enable */
#define OD_0_P25_MASK 0x2000000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P25_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P25_EN 0x1

/*! Field P26 - Pin Open Drain Enable */
#define OD_0_P26_POS 26
/*! Field P26 - Pin Open Drain Enable */
#define OD_0_P26_MASK 0x4000000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P26_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P26_EN 0x1

/*! Field P27 - Pin Open Drain Enable */
#define OD_0_P27_POS 27
/*! Field P27 - Pin Open Drain Enable */
#define OD_0_P27_MASK 0x8000000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P27_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P27_EN 0x1

/*! Field P28 - Pin Open Drain Enable */
#define OD_0_P28_POS 28
/*! Field P28 - Pin Open Drain Enable */
#define OD_0_P28_MASK 0x10000000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P28_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P28_EN 0x1

/*! Field P29 - Pin Open Drain Enable */
#define OD_0_P29_POS 29
/*! Field P29 - Pin Open Drain Enable */
#define OD_0_P29_MASK 0x20000000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P29_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P29_EN 0x1

/*! Field P30 - Pin Open Drain Enable */
#define OD_0_P30_POS 30
/*! Field P30 - Pin Open Drain Enable */
#define OD_0_P30_MASK 0x40000000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P30_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P30_EN 0x1

/*! Field P31 - Pin Open Drain Enable */
#define OD_0_P31_POS 31
/*! Field P31 - Pin Open Drain Enable */
#define OD_0_P31_MASK 0x80000000u
/*! Constant NOP - No operation */
#define CONST_OD_0_P31_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_0_P31_EN 0x1

/*! @} */

/*! \defgroup AVAIL_0 Register AVAIL_0 - Pad Control Availability Register */
/*! @{ */

/*! Register Offset (relative) */
#define AVAIL_0 0x98
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_AVAIL_0 0x16380098u

/*! Register Reset Value */
#define AVAIL_0_RST 0xFFFFFFFFu

/*! Field P0 - Pad Control Available */
#define AVAIL_0_P0_POS 0
/*! Field P0 - Pad Control Available */
#define AVAIL_0_P0_MASK 0x1u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P0_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P0_AV 0x1

/*! Field P1 - Pad Control Available */
#define AVAIL_0_P1_POS 1
/*! Field P1 - Pad Control Available */
#define AVAIL_0_P1_MASK 0x2u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P1_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P1_AV 0x1

/*! Field P2 - Pad Control Available */
#define AVAIL_0_P2_POS 2
/*! Field P2 - Pad Control Available */
#define AVAIL_0_P2_MASK 0x4u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P2_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P2_AV 0x1

/*! Field P3 - Pad Control Available */
#define AVAIL_0_P3_POS 3
/*! Field P3 - Pad Control Available */
#define AVAIL_0_P3_MASK 0x8u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P3_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P3_AV 0x1

/*! Field P4 - Pad Control Available */
#define AVAIL_0_P4_POS 4
/*! Field P4 - Pad Control Available */
#define AVAIL_0_P4_MASK 0x10u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P4_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P4_AV 0x1

/*! Field P5 - Pad Control Available */
#define AVAIL_0_P5_POS 5
/*! Field P5 - Pad Control Available */
#define AVAIL_0_P5_MASK 0x20u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P5_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P5_AV 0x1

/*! Field P6 - Pad Control Available */
#define AVAIL_0_P6_POS 6
/*! Field P6 - Pad Control Available */
#define AVAIL_0_P6_MASK 0x40u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P6_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P6_AV 0x1

/*! Field P7 - Pad Control Available */
#define AVAIL_0_P7_POS 7
/*! Field P7 - Pad Control Available */
#define AVAIL_0_P7_MASK 0x80u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P7_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P7_AV 0x1

/*! Field P8 - Pad Control Available */
#define AVAIL_0_P8_POS 8
/*! Field P8 - Pad Control Available */
#define AVAIL_0_P8_MASK 0x100u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P8_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P8_AV 0x1

/*! Field P9 - Pad Control Available */
#define AVAIL_0_P9_POS 9
/*! Field P9 - Pad Control Available */
#define AVAIL_0_P9_MASK 0x200u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P9_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P9_AV 0x1

/*! Field P10 - Pad Control Available */
#define AVAIL_0_P10_POS 10
/*! Field P10 - Pad Control Available */
#define AVAIL_0_P10_MASK 0x400u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P10_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P10_AV 0x1

/*! Field P11 - Pad Control Available */
#define AVAIL_0_P11_POS 11
/*! Field P11 - Pad Control Available */
#define AVAIL_0_P11_MASK 0x800u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P11_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P11_AV 0x1

/*! Field P12 - Pad Control Available */
#define AVAIL_0_P12_POS 12
/*! Field P12 - Pad Control Available */
#define AVAIL_0_P12_MASK 0x1000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P12_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P12_AV 0x1

/*! Field P13 - Pad Control Available */
#define AVAIL_0_P13_POS 13
/*! Field P13 - Pad Control Available */
#define AVAIL_0_P13_MASK 0x2000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P13_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P13_AV 0x1

/*! Field P14 - Pad Control Available */
#define AVAIL_0_P14_POS 14
/*! Field P14 - Pad Control Available */
#define AVAIL_0_P14_MASK 0x4000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P14_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P14_AV 0x1

/*! Field P15 - Pad Control Available */
#define AVAIL_0_P15_POS 15
/*! Field P15 - Pad Control Available */
#define AVAIL_0_P15_MASK 0x8000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P15_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P15_AV 0x1

/*! Field P16 - Pad Control Available */
#define AVAIL_0_P16_POS 16
/*! Field P16 - Pad Control Available */
#define AVAIL_0_P16_MASK 0x10000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P16_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P16_AV 0x1

/*! Field P17 - Pad Control Available */
#define AVAIL_0_P17_POS 17
/*! Field P17 - Pad Control Available */
#define AVAIL_0_P17_MASK 0x20000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P17_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P17_AV 0x1

/*! Field P18 - Pad Control Available */
#define AVAIL_0_P18_POS 18
/*! Field P18 - Pad Control Available */
#define AVAIL_0_P18_MASK 0x40000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P18_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P18_AV 0x1

/*! Field P19 - Pad Control Available */
#define AVAIL_0_P19_POS 19
/*! Field P19 - Pad Control Available */
#define AVAIL_0_P19_MASK 0x80000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P19_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P19_AV 0x1

/*! Field P20 - Pad Control Available */
#define AVAIL_0_P20_POS 20
/*! Field P20 - Pad Control Available */
#define AVAIL_0_P20_MASK 0x100000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P20_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P20_AV 0x1

/*! Field P21 - Pad Control Available */
#define AVAIL_0_P21_POS 21
/*! Field P21 - Pad Control Available */
#define AVAIL_0_P21_MASK 0x200000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P21_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P21_AV 0x1

/*! Field P22 - Pad Control Available */
#define AVAIL_0_P22_POS 22
/*! Field P22 - Pad Control Available */
#define AVAIL_0_P22_MASK 0x400000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P22_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P22_AV 0x1

/*! Field P23 - Pad Control Available */
#define AVAIL_0_P23_POS 23
/*! Field P23 - Pad Control Available */
#define AVAIL_0_P23_MASK 0x800000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P23_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P23_AV 0x1

/*! Field P24 - Pad Control Available */
#define AVAIL_0_P24_POS 24
/*! Field P24 - Pad Control Available */
#define AVAIL_0_P24_MASK 0x1000000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P24_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P24_AV 0x1

/*! Field P25 - Pad Control Available */
#define AVAIL_0_P25_POS 25
/*! Field P25 - Pad Control Available */
#define AVAIL_0_P25_MASK 0x2000000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P25_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P25_AV 0x1

/*! Field P26 - Pad Control Available */
#define AVAIL_0_P26_POS 26
/*! Field P26 - Pad Control Available */
#define AVAIL_0_P26_MASK 0x4000000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P26_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P26_AV 0x1

/*! Field P27 - Pad Control Available */
#define AVAIL_0_P27_POS 27
/*! Field P27 - Pad Control Available */
#define AVAIL_0_P27_MASK 0x8000000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P27_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P27_AV 0x1

/*! Field P28 - Pad Control Available */
#define AVAIL_0_P28_POS 28
/*! Field P28 - Pad Control Available */
#define AVAIL_0_P28_MASK 0x10000000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P28_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P28_AV 0x1

/*! Field P29 - Pad Control Available */
#define AVAIL_0_P29_POS 29
/*! Field P29 - Pad Control Available */
#define AVAIL_0_P29_MASK 0x20000000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P29_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P29_AV 0x1

/*! Field P30 - Pad Control Available */
#define AVAIL_0_P30_POS 30
/*! Field P30 - Pad Control Available */
#define AVAIL_0_P30_MASK 0x40000000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P30_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P30_AV 0x1

/*! Field P31 - Pad Control Available */
#define AVAIL_0_P31_POS 31
/*! Field P31 - Pad Control Available */
#define AVAIL_0_P31_MASK 0x80000000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_0_P31_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_0_P31_AV 0x1

/*! @} */

/*! \defgroup PORTMUXC32 Register PORTMUXC32 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC32 0x100
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC32 0x16380100u

/*! Register Reset Value */
#define PORTMUXC32_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC32_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC32_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC33 Register PORTMUXC33 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC33 0x104
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC33 0x16380104u

/*! Register Reset Value */
#define PORTMUXC33_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC33_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC33_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC34 Register PORTMUXC34 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC34 0x108
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC34 0x16380108u

/*! Register Reset Value */
#define PORTMUXC34_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC34_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC34_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC35 Register PORTMUXC35 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC35 0x10C
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC35 0x1638010Cu

/*! Register Reset Value */
#define PORTMUXC35_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC35_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC35_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC36 Register PORTMUXC36 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC36 0x110
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC36 0x16380110u

/*! Register Reset Value */
#define PORTMUXC36_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC36_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC36_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC37 Register PORTMUXC37 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC37 0x114
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC37 0x16380114u

/*! Register Reset Value */
#define PORTMUXC37_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC37_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC37_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC38 Register PORTMUXC38 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC38 0x118
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC38 0x16380118u

/*! Register Reset Value */
#define PORTMUXC38_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC38_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC38_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PORTMUXC39 Register PORTMUXC39 - Port Multiplexer Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define PORTMUXC39 0x11C
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PORTMUXC39 0x1638011Cu

/*! Register Reset Value */
#define PORTMUXC39_RST 0x00000000u

/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC39_PORT_MUX_POS 0
/*! Field PORT_MUX - Pad MUX Control */
#define PORTMUXC39_PORT_MUX_MASK 0x7u

/*! @} */

/*! \defgroup PUEN_1 Register PUEN_1 - Pull Up Enable Register */
/*! @{ */

/*! Register Offset (relative) */
#define PUEN_1 0x180
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PUEN_1 0x16380180u

/*! Register Reset Value */
#define PUEN_1_RST 0x000000FFu

/*! Field P32 - Port Pad Pull Up Enable */
#define PUEN_1_P32_POS 0
/*! Field P32 - Port Pad Pull Up Enable */
#define PUEN_1_P32_MASK 0x1u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P32_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P32_EN 0x1

/*! Field P33 - Port Pad Pull Up Enable */
#define PUEN_1_P33_POS 1
/*! Field P33 - Port Pad Pull Up Enable */
#define PUEN_1_P33_MASK 0x2u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P33_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P33_EN 0x1

/*! Field P34 - Port Pad Pull Up Enable */
#define PUEN_1_P34_POS 2
/*! Field P34 - Port Pad Pull Up Enable */
#define PUEN_1_P34_MASK 0x4u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P34_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P34_EN 0x1

/*! Field P35 - Port Pad Pull Up Enable */
#define PUEN_1_P35_POS 3
/*! Field P35 - Port Pad Pull Up Enable */
#define PUEN_1_P35_MASK 0x8u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P35_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P35_EN 0x1

/*! Field P36 - Port Pad Pull Up Enable */
#define PUEN_1_P36_POS 4
/*! Field P36 - Port Pad Pull Up Enable */
#define PUEN_1_P36_MASK 0x10u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P36_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P36_EN 0x1

/*! Field P37 - Port Pad Pull Up Enable */
#define PUEN_1_P37_POS 5
/*! Field P37 - Port Pad Pull Up Enable */
#define PUEN_1_P37_MASK 0x20u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P37_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P37_EN 0x1

/*! Field P38 - Port Pad Pull Up Enable */
#define PUEN_1_P38_POS 6
/*! Field P38 - Port Pad Pull Up Enable */
#define PUEN_1_P38_MASK 0x40u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P38_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P38_EN 0x1

/*! Field P39 - Port Pad Pull Up Enable */
#define PUEN_1_P39_POS 7
/*! Field P39 - Port Pad Pull Up Enable */
#define PUEN_1_P39_MASK 0x80u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P39_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P39_EN 0x1

/*! Field P40 - Port Pad Pull Up Enable */
#define PUEN_1_P40_POS 8
/*! Field P40 - Port Pad Pull Up Enable */
#define PUEN_1_P40_MASK 0x100u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P40_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P40_EN 0x1

/*! Field P41 - Port Pad Pull Up Enable */
#define PUEN_1_P41_POS 9
/*! Field P41 - Port Pad Pull Up Enable */
#define PUEN_1_P41_MASK 0x200u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P41_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P41_EN 0x1

/*! Field P42 - Port Pad Pull Up Enable */
#define PUEN_1_P42_POS 10
/*! Field P42 - Port Pad Pull Up Enable */
#define PUEN_1_P42_MASK 0x400u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P42_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P42_EN 0x1

/*! Field P43 - Port Pad Pull Up Enable */
#define PUEN_1_P43_POS 11
/*! Field P43 - Port Pad Pull Up Enable */
#define PUEN_1_P43_MASK 0x800u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P43_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P43_EN 0x1

/*! Field P44 - Port Pad Pull Up Enable */
#define PUEN_1_P44_POS 12
/*! Field P44 - Port Pad Pull Up Enable */
#define PUEN_1_P44_MASK 0x1000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P44_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P44_EN 0x1

/*! Field P45 - Port Pad Pull Up Enable */
#define PUEN_1_P45_POS 13
/*! Field P45 - Port Pad Pull Up Enable */
#define PUEN_1_P45_MASK 0x2000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P45_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P45_EN 0x1

/*! Field P46 - Port Pad Pull Up Enable */
#define PUEN_1_P46_POS 14
/*! Field P46 - Port Pad Pull Up Enable */
#define PUEN_1_P46_MASK 0x4000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P46_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P46_EN 0x1

/*! Field P47 - Port Pad Pull Up Enable */
#define PUEN_1_P47_POS 15
/*! Field P47 - Port Pad Pull Up Enable */
#define PUEN_1_P47_MASK 0x8000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P47_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P47_EN 0x1

/*! Field P48 - Port Pad Pull Up Enable */
#define PUEN_1_P48_POS 16
/*! Field P48 - Port Pad Pull Up Enable */
#define PUEN_1_P48_MASK 0x10000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P48_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P48_EN 0x1

/*! Field P49 - Port Pad Pull Up Enable */
#define PUEN_1_P49_POS 17
/*! Field P49 - Port Pad Pull Up Enable */
#define PUEN_1_P49_MASK 0x20000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P49_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P49_EN 0x1

/*! Field P50 - Port Pad Pull Up Enable */
#define PUEN_1_P50_POS 18
/*! Field P50 - Port Pad Pull Up Enable */
#define PUEN_1_P50_MASK 0x40000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P50_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P50_EN 0x1

/*! Field P51 - Port Pad Pull Up Enable */
#define PUEN_1_P51_POS 19
/*! Field P51 - Port Pad Pull Up Enable */
#define PUEN_1_P51_MASK 0x80000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P51_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P51_EN 0x1

/*! Field P52 - Port Pad Pull Up Enable */
#define PUEN_1_P52_POS 20
/*! Field P52 - Port Pad Pull Up Enable */
#define PUEN_1_P52_MASK 0x100000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P52_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P52_EN 0x1

/*! Field P53 - Port Pad Pull Up Enable */
#define PUEN_1_P53_POS 21
/*! Field P53 - Port Pad Pull Up Enable */
#define PUEN_1_P53_MASK 0x200000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P53_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P53_EN 0x1

/*! Field P54 - Port Pad Pull Up Enable */
#define PUEN_1_P54_POS 22
/*! Field P54 - Port Pad Pull Up Enable */
#define PUEN_1_P54_MASK 0x400000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P54_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P54_EN 0x1

/*! Field P55 - Port Pad Pull Up Enable */
#define PUEN_1_P55_POS 23
/*! Field P55 - Port Pad Pull Up Enable */
#define PUEN_1_P55_MASK 0x800000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P55_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P55_EN 0x1

/*! Field P56 - Port Pad Pull Up Enable */
#define PUEN_1_P56_POS 24
/*! Field P56 - Port Pad Pull Up Enable */
#define PUEN_1_P56_MASK 0x1000000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P56_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P56_EN 0x1

/*! Field P57 - Port Pad Pull Up Enable */
#define PUEN_1_P57_POS 25
/*! Field P57 - Port Pad Pull Up Enable */
#define PUEN_1_P57_MASK 0x2000000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P57_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P57_EN 0x1

/*! Field P58 - Port Pad Pull Up Enable */
#define PUEN_1_P58_POS 26
/*! Field P58 - Port Pad Pull Up Enable */
#define PUEN_1_P58_MASK 0x4000000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P58_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P58_EN 0x1

/*! Field P59 - Port Pad Pull Up Enable */
#define PUEN_1_P59_POS 27
/*! Field P59 - Port Pad Pull Up Enable */
#define PUEN_1_P59_MASK 0x8000000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P59_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P59_EN 0x1

/*! Field P60 - Port Pad Pull Up Enable */
#define PUEN_1_P60_POS 28
/*! Field P60 - Port Pad Pull Up Enable */
#define PUEN_1_P60_MASK 0x10000000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P60_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P60_EN 0x1

/*! Field P61 - Port Pad Pull Up Enable */
#define PUEN_1_P61_POS 29
/*! Field P61 - Port Pad Pull Up Enable */
#define PUEN_1_P61_MASK 0x20000000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P61_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P61_EN 0x1

/*! Field P62 - Port Pad Pull Up Enable */
#define PUEN_1_P62_POS 30
/*! Field P62 - Port Pad Pull Up Enable */
#define PUEN_1_P62_MASK 0x40000000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P62_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P62_EN 0x1

/*! Field P63 - Port Pad Pull Up Enable */
#define PUEN_1_P63_POS 31
/*! Field P63 - Port Pad Pull Up Enable */
#define PUEN_1_P63_MASK 0x80000000u
/*! Constant DIS - DIS */
#define CONST_PUEN_1_P63_DIS 0x0
/*! Constant EN - EN */
#define CONST_PUEN_1_P63_EN 0x1

/*! @} */

/*! \defgroup PDEN_1 Register PDEN_1 - Pull Down Enable Register */
/*! @{ */

/*! Register Offset (relative) */
#define PDEN_1 0x184
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_PDEN_1 0x16380184u

/*! Register Reset Value */
#define PDEN_1_RST 0x00000000u

/*! Field P32 - Pad Pull Down Enable */
#define PDEN_1_P32_POS 0
/*! Field P32 - Pad Pull Down Enable */
#define PDEN_1_P32_MASK 0x1u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P32_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P32_EN 0x1

/*! Field P33 - Pad Pull Down Enable */
#define PDEN_1_P33_POS 1
/*! Field P33 - Pad Pull Down Enable */
#define PDEN_1_P33_MASK 0x2u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P33_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P33_EN 0x1

/*! Field P34 - Pad Pull Down Enable */
#define PDEN_1_P34_POS 2
/*! Field P34 - Pad Pull Down Enable */
#define PDEN_1_P34_MASK 0x4u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P34_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P34_EN 0x1

/*! Field P35 - Pad Pull Down Enable */
#define PDEN_1_P35_POS 3
/*! Field P35 - Pad Pull Down Enable */
#define PDEN_1_P35_MASK 0x8u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P35_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P35_EN 0x1

/*! Field P36 - Pad Pull Down Enable */
#define PDEN_1_P36_POS 4
/*! Field P36 - Pad Pull Down Enable */
#define PDEN_1_P36_MASK 0x10u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P36_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P36_EN 0x1

/*! Field P37 - Pad Pull Down Enable */
#define PDEN_1_P37_POS 5
/*! Field P37 - Pad Pull Down Enable */
#define PDEN_1_P37_MASK 0x20u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P37_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P37_EN 0x1

/*! Field P38 - Pad Pull Down Enable */
#define PDEN_1_P38_POS 6
/*! Field P38 - Pad Pull Down Enable */
#define PDEN_1_P38_MASK 0x40u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P38_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P38_EN 0x1

/*! Field P39 - Pad Pull Down Enable */
#define PDEN_1_P39_POS 7
/*! Field P39 - Pad Pull Down Enable */
#define PDEN_1_P39_MASK 0x80u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P39_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P39_EN 0x1

/*! Field P40 - Pad Pull Down Enable */
#define PDEN_1_P40_POS 8
/*! Field P40 - Pad Pull Down Enable */
#define PDEN_1_P40_MASK 0x100u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P40_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P40_EN 0x1

/*! Field P41 - Pad Pull Down Enable */
#define PDEN_1_P41_POS 9
/*! Field P41 - Pad Pull Down Enable */
#define PDEN_1_P41_MASK 0x200u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P41_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P41_EN 0x1

/*! Field P42 - Pad Pull Down Enable */
#define PDEN_1_P42_POS 10
/*! Field P42 - Pad Pull Down Enable */
#define PDEN_1_P42_MASK 0x400u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P42_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P42_EN 0x1

/*! Field P43 - Pad Pull Down Enable */
#define PDEN_1_P43_POS 11
/*! Field P43 - Pad Pull Down Enable */
#define PDEN_1_P43_MASK 0x800u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P43_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P43_EN 0x1

/*! Field P44 - Pad Pull Down Enable */
#define PDEN_1_P44_POS 12
/*! Field P44 - Pad Pull Down Enable */
#define PDEN_1_P44_MASK 0x1000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P44_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P44_EN 0x1

/*! Field P45 - Pad Pull Down Enable */
#define PDEN_1_P45_POS 13
/*! Field P45 - Pad Pull Down Enable */
#define PDEN_1_P45_MASK 0x2000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P45_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P45_EN 0x1

/*! Field P46 - Pad Pull Down Enable */
#define PDEN_1_P46_POS 14
/*! Field P46 - Pad Pull Down Enable */
#define PDEN_1_P46_MASK 0x4000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P46_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P46_EN 0x1

/*! Field P47 - Pad Pull Down Enable */
#define PDEN_1_P47_POS 15
/*! Field P47 - Pad Pull Down Enable */
#define PDEN_1_P47_MASK 0x8000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P47_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P47_EN 0x1

/*! Field P48 - Pad Pull Down Enable */
#define PDEN_1_P48_POS 16
/*! Field P48 - Pad Pull Down Enable */
#define PDEN_1_P48_MASK 0x10000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P48_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P48_EN 0x1

/*! Field P49 - Pad Pull Down Enable */
#define PDEN_1_P49_POS 17
/*! Field P49 - Pad Pull Down Enable */
#define PDEN_1_P49_MASK 0x20000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P49_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P49_EN 0x1

/*! Field P50 - Pad Pull Down Enable */
#define PDEN_1_P50_POS 18
/*! Field P50 - Pad Pull Down Enable */
#define PDEN_1_P50_MASK 0x40000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P50_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P50_EN 0x1

/*! Field P51 - Pad Pull Down Enable */
#define PDEN_1_P51_POS 19
/*! Field P51 - Pad Pull Down Enable */
#define PDEN_1_P51_MASK 0x80000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P51_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P51_EN 0x1

/*! Field P52 - Pad Pull Down Enable */
#define PDEN_1_P52_POS 20
/*! Field P52 - Pad Pull Down Enable */
#define PDEN_1_P52_MASK 0x100000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P52_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P52_EN 0x1

/*! Field P53 - Pad Pull Down Enable */
#define PDEN_1_P53_POS 21
/*! Field P53 - Pad Pull Down Enable */
#define PDEN_1_P53_MASK 0x200000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P53_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P53_EN 0x1

/*! Field P54 - Pad Pull Down Enable */
#define PDEN_1_P54_POS 22
/*! Field P54 - Pad Pull Down Enable */
#define PDEN_1_P54_MASK 0x400000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P54_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P54_EN 0x1

/*! Field P55 - Pad Pull Down Enable */
#define PDEN_1_P55_POS 23
/*! Field P55 - Pad Pull Down Enable */
#define PDEN_1_P55_MASK 0x800000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P55_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P55_EN 0x1

/*! Field P56 - Pad Pull Down Enable */
#define PDEN_1_P56_POS 24
/*! Field P56 - Pad Pull Down Enable */
#define PDEN_1_P56_MASK 0x1000000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P56_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P56_EN 0x1

/*! Field P57 - Pad Pull Down Enable */
#define PDEN_1_P57_POS 25
/*! Field P57 - Pad Pull Down Enable */
#define PDEN_1_P57_MASK 0x2000000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P57_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P57_EN 0x1

/*! Field P58 - Pad Pull Down Enable */
#define PDEN_1_P58_POS 26
/*! Field P58 - Pad Pull Down Enable */
#define PDEN_1_P58_MASK 0x4000000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P58_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P58_EN 0x1

/*! Field P59 - Pad Pull Down Enable */
#define PDEN_1_P59_POS 27
/*! Field P59 - Pad Pull Down Enable */
#define PDEN_1_P59_MASK 0x8000000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P59_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P59_EN 0x1

/*! Field P60 - Pad Pull Down Enable */
#define PDEN_1_P60_POS 28
/*! Field P60 - Pad Pull Down Enable */
#define PDEN_1_P60_MASK 0x10000000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P60_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P60_EN 0x1

/*! Field P61 - Pad Pull Down Enable */
#define PDEN_1_P61_POS 29
/*! Field P61 - Pad Pull Down Enable */
#define PDEN_1_P61_MASK 0x20000000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P61_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P61_EN 0x1

/*! Field P62 - Pad Pull Down Enable */
#define PDEN_1_P62_POS 30
/*! Field P62 - Pad Pull Down Enable */
#define PDEN_1_P62_MASK 0x40000000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P62_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P62_EN 0x1

/*! Field P63 - Pad Pull Down Enable */
#define PDEN_1_P63_POS 31
/*! Field P63 - Pad Pull Down Enable */
#define PDEN_1_P63_MASK 0x80000000u
/*! Constant DIS - DIS */
#define CONST_PDEN_1_P63_DIS 0x0
/*! Constant EN - EN */
#define CONST_PDEN_1_P63_EN 0x1

/*! @} */

/*! \defgroup SRC_1 Register SRC_1 - Slew Rate Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define SRC_1 0x188
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_SRC_1 0x16380188u

/*! Register Reset Value */
#define SRC_1_RST 0x00000000u

/*! Field P32 - Pad Slew Control */
#define SRC_1_P32_POS 0
/*! Field P32 - Pad Slew Control */
#define SRC_1_P32_MASK 0x1u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P32_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P32_FAST 0x1

/*! Field P33 - Pad Slew Control */
#define SRC_1_P33_POS 1
/*! Field P33 - Pad Slew Control */
#define SRC_1_P33_MASK 0x2u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P33_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P33_FAST 0x1

/*! Field P34 - Pad Slew Control */
#define SRC_1_P34_POS 2
/*! Field P34 - Pad Slew Control */
#define SRC_1_P34_MASK 0x4u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P34_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P34_FAST 0x1

/*! Field P35 - Pad Slew Control */
#define SRC_1_P35_POS 3
/*! Field P35 - Pad Slew Control */
#define SRC_1_P35_MASK 0x8u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P35_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P35_FAST 0x1

/*! Field P36 - Pad Slew Control */
#define SRC_1_P36_POS 4
/*! Field P36 - Pad Slew Control */
#define SRC_1_P36_MASK 0x10u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P36_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P36_FAST 0x1

/*! Field P37 - Pad Slew Control */
#define SRC_1_P37_POS 5
/*! Field P37 - Pad Slew Control */
#define SRC_1_P37_MASK 0x20u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P37_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P37_FAST 0x1

/*! Field P38 - Pad Slew Control */
#define SRC_1_P38_POS 6
/*! Field P38 - Pad Slew Control */
#define SRC_1_P38_MASK 0x40u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P38_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P38_FAST 0x1

/*! Field P39 - Pad Slew Control */
#define SRC_1_P39_POS 7
/*! Field P39 - Pad Slew Control */
#define SRC_1_P39_MASK 0x80u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P39_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P39_FAST 0x1

/*! Field P40 - Pad Slew Control */
#define SRC_1_P40_POS 8
/*! Field P40 - Pad Slew Control */
#define SRC_1_P40_MASK 0x100u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P40_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P40_FAST 0x1

/*! Field P41 - Pad Slew Control */
#define SRC_1_P41_POS 9
/*! Field P41 - Pad Slew Control */
#define SRC_1_P41_MASK 0x200u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P41_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P41_FAST 0x1

/*! Field P42 - Pad Slew Control */
#define SRC_1_P42_POS 10
/*! Field P42 - Pad Slew Control */
#define SRC_1_P42_MASK 0x400u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P42_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P42_FAST 0x1

/*! Field P43 - Pad Slew Control */
#define SRC_1_P43_POS 11
/*! Field P43 - Pad Slew Control */
#define SRC_1_P43_MASK 0x800u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P43_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P43_FAST 0x1

/*! Field P44 - Pad Slew Control */
#define SRC_1_P44_POS 12
/*! Field P44 - Pad Slew Control */
#define SRC_1_P44_MASK 0x1000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P44_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P44_FAST 0x1

/*! Field P45 - Pad Slew Control */
#define SRC_1_P45_POS 13
/*! Field P45 - Pad Slew Control */
#define SRC_1_P45_MASK 0x2000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P45_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P45_FAST 0x1

/*! Field P46 - Pad Slew Control */
#define SRC_1_P46_POS 14
/*! Field P46 - Pad Slew Control */
#define SRC_1_P46_MASK 0x4000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P46_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P46_FAST 0x1

/*! Field P47 - Pad Slew Control */
#define SRC_1_P47_POS 15
/*! Field P47 - Pad Slew Control */
#define SRC_1_P47_MASK 0x8000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P47_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P47_FAST 0x1

/*! Field P48 - Pad Slew Control */
#define SRC_1_P48_POS 16
/*! Field P48 - Pad Slew Control */
#define SRC_1_P48_MASK 0x10000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P48_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P48_FAST 0x1

/*! Field P49 - Pad Slew Control */
#define SRC_1_P49_POS 17
/*! Field P49 - Pad Slew Control */
#define SRC_1_P49_MASK 0x20000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P49_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P49_FAST 0x1

/*! Field P50 - Pad Slew Control */
#define SRC_1_P50_POS 18
/*! Field P50 - Pad Slew Control */
#define SRC_1_P50_MASK 0x40000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P50_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P50_FAST 0x1

/*! Field P51 - Pad Slew Control */
#define SRC_1_P51_POS 19
/*! Field P51 - Pad Slew Control */
#define SRC_1_P51_MASK 0x80000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P51_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P51_FAST 0x1

/*! Field P52 - Pad Slew Control */
#define SRC_1_P52_POS 20
/*! Field P52 - Pad Slew Control */
#define SRC_1_P52_MASK 0x100000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P52_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P52_FAST 0x1

/*! Field P53 - Pad Slew Control */
#define SRC_1_P53_POS 21
/*! Field P53 - Pad Slew Control */
#define SRC_1_P53_MASK 0x200000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P53_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P53_FAST 0x1

/*! Field P54 - Pad Slew Control */
#define SRC_1_P54_POS 22
/*! Field P54 - Pad Slew Control */
#define SRC_1_P54_MASK 0x400000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P54_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P54_FAST 0x1

/*! Field P55 - Pad Slew Control */
#define SRC_1_P55_POS 23
/*! Field P55 - Pad Slew Control */
#define SRC_1_P55_MASK 0x800000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P55_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P55_FAST 0x1

/*! Field P56 - Pad Slew Control */
#define SRC_1_P56_POS 24
/*! Field P56 - Pad Slew Control */
#define SRC_1_P56_MASK 0x1000000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P56_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P56_FAST 0x1

/*! Field P57 - Pad Slew Control */
#define SRC_1_P57_POS 25
/*! Field P57 - Pad Slew Control */
#define SRC_1_P57_MASK 0x2000000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P57_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P57_FAST 0x1

/*! Field P58 - Pad Slew Control */
#define SRC_1_P58_POS 26
/*! Field P58 - Pad Slew Control */
#define SRC_1_P58_MASK 0x4000000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P58_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P58_FAST 0x1

/*! Field P59 - Pad Slew Control */
#define SRC_1_P59_POS 27
/*! Field P59 - Pad Slew Control */
#define SRC_1_P59_MASK 0x8000000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P59_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P59_FAST 0x1

/*! Field P60 - Pad Slew Control */
#define SRC_1_P60_POS 28
/*! Field P60 - Pad Slew Control */
#define SRC_1_P60_MASK 0x10000000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P60_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P60_FAST 0x1

/*! Field P61 - Pad Slew Control */
#define SRC_1_P61_POS 29
/*! Field P61 - Pad Slew Control */
#define SRC_1_P61_MASK 0x20000000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P61_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P61_FAST 0x1

/*! Field P62 - Pad Slew Control */
#define SRC_1_P62_POS 30
/*! Field P62 - Pad Slew Control */
#define SRC_1_P62_MASK 0x40000000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P62_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P62_FAST 0x1

/*! Field P63 - Pad Slew Control */
#define SRC_1_P63_POS 31
/*! Field P63 - Pad Slew Control */
#define SRC_1_P63_MASK 0x80000000u
/*! Constant SLOW - SLOW */
#define CONST_SRC_1_P63_SLOW 0x0
/*! Constant FAST - FAST */
#define CONST_SRC_1_P63_FAST 0x1

/*! @} */

/*! \defgroup DCC_2 Register DCC_2 - Drive Current Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define DCC_2 0x18C
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_DCC_2 0x1638018Cu

/*! Register Reset Value */
#define DCC_2_RST 0x00000000u

/*! Field P32 - Pad Drive Control */
#define DCC_2_P32_POS 0
/*! Field P32 - Pad Drive Control */
#define DCC_2_P32_MASK 0x3u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_2_P32_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_2_P32_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_2_P32_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_2_P32_V12MA 0x3

/*! Field P33 - Pad Drive Control */
#define DCC_2_P33_POS 2
/*! Field P33 - Pad Drive Control */
#define DCC_2_P33_MASK 0xCu
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_2_P33_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_2_P33_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_2_P33_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_2_P33_V12MA 0x3

/*! Field P34 - Pad Drive Control */
#define DCC_2_P34_POS 4
/*! Field P34 - Pad Drive Control */
#define DCC_2_P34_MASK 0x30u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_2_P34_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_2_P34_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_2_P34_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_2_P34_V12MA 0x3

/*! Field P35 - Pad Drive Control */
#define DCC_2_P35_POS 6
/*! Field P35 - Pad Drive Control */
#define DCC_2_P35_MASK 0xC0u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_2_P35_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_2_P35_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_2_P35_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_2_P35_V12MA 0x3

/*! Field P36 - Pad Drive Control */
#define DCC_2_P36_POS 8
/*! Field P36 - Pad Drive Control */
#define DCC_2_P36_MASK 0x300u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_2_P36_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_2_P36_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_2_P36_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_2_P36_V12MA 0x3

/*! Field P37 - Pad Drive Control */
#define DCC_2_P37_POS 10
/*! Field P37 - Pad Drive Control */
#define DCC_2_P37_MASK 0xC00u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_2_P37_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_2_P37_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_2_P37_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_2_P37_V12MA 0x3

/*! Field P38 - Pad Drive Control */
#define DCC_2_P38_POS 12
/*! Field P38 - Pad Drive Control */
#define DCC_2_P38_MASK 0x3000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_2_P38_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_2_P38_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_2_P38_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_2_P38_V12MA 0x3

/*! Field P39 - Pad Drive Control */
#define DCC_2_P39_POS 14
/*! Field P39 - Pad Drive Control */
#define DCC_2_P39_MASK 0xC000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_2_P39_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_2_P39_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_2_P39_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_2_P39_V12MA 0x3

/*! Field P40 - Pad Drive Control */
#define DCC_2_P40_POS 16
/*! Field P40 - Pad Drive Control */
#define DCC_2_P40_MASK 0x30000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_2_P40_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_2_P40_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_2_P40_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_2_P40_V12MA 0x3

/*! Field P41 - Pad Drive Control */
#define DCC_2_P41_POS 18
/*! Field P41 - Pad Drive Control */
#define DCC_2_P41_MASK 0xC0000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_2_P41_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_2_P41_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_2_P41_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_2_P41_V12MA 0x3

/*! Field P42 - Pad Drive Control */
#define DCC_2_P42_POS 20
/*! Field P42 - Pad Drive Control */
#define DCC_2_P42_MASK 0x300000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_2_P42_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_2_P42_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_2_P42_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_2_P42_V12MA 0x3

/*! Field P43 - Pad Drive Control */
#define DCC_2_P43_POS 22
/*! Field P43 - Pad Drive Control */
#define DCC_2_P43_MASK 0xC00000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_2_P43_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_2_P43_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_2_P43_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_2_P43_V12MA 0x3

/*! Field P44 - Pad Drive Control */
#define DCC_2_P44_POS 24
/*! Field P44 - Pad Drive Control */
#define DCC_2_P44_MASK 0x3000000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_2_P44_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_2_P44_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_2_P44_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_2_P44_V12MA 0x3

/*! Field P45 - Pad Drive Control */
#define DCC_2_P45_POS 26
/*! Field P45 - Pad Drive Control */
#define DCC_2_P45_MASK 0xC000000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_2_P45_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_2_P45_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_2_P45_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_2_P45_V12MA 0x3

/*! Field P46 - Pad Drive Control */
#define DCC_2_P46_POS 28
/*! Field P46 - Pad Drive Control */
#define DCC_2_P46_MASK 0x30000000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_2_P46_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_2_P46_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_2_P46_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_2_P46_V12MA 0x3

/*! Field P47 - Pad Drive Control */
#define DCC_2_P47_POS 30
/*! Field P47 - Pad Drive Control */
#define DCC_2_P47_MASK 0xC0000000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_2_P47_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_2_P47_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_2_P47_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_2_P47_V12MA 0x3

/*! @} */

/*! \defgroup DCC_3 Register DCC_3 - Drive Current Control Register */
/*! @{ */

/*! Register Offset (relative) */
#define DCC_3 0x190
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_DCC_3 0x16380190u

/*! Register Reset Value */
#define DCC_3_RST 0x00000000u

/*! Field P48 - Pad Drive Control */
#define DCC_3_P48_POS 0
/*! Field P48 - Pad Drive Control */
#define DCC_3_P48_MASK 0x3u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_3_P48_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_3_P48_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_3_P48_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_3_P48_V12MA 0x3

/*! Field P49 - Pad Drive Control */
#define DCC_3_P49_POS 2
/*! Field P49 - Pad Drive Control */
#define DCC_3_P49_MASK 0xCu
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_3_P49_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_3_P49_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_3_P49_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_3_P49_V12MA 0x3

/*! Field P50 - Pad Drive Control */
#define DCC_3_P50_POS 4
/*! Field P50 - Pad Drive Control */
#define DCC_3_P50_MASK 0x30u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_3_P50_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_3_P50_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_3_P50_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_3_P50_V12MA 0x3

/*! Field P51 - Pad Drive Control */
#define DCC_3_P51_POS 6
/*! Field P51 - Pad Drive Control */
#define DCC_3_P51_MASK 0xC0u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_3_P51_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_3_P51_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_3_P51_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_3_P51_V12MA 0x3

/*! Field P52 - Pad Drive Control */
#define DCC_3_P52_POS 8
/*! Field P52 - Pad Drive Control */
#define DCC_3_P52_MASK 0x300u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_3_P52_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_3_P52_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_3_P52_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_3_P52_V12MA 0x3

/*! Field P53 - Pad Drive Control */
#define DCC_3_P53_POS 10
/*! Field P53 - Pad Drive Control */
#define DCC_3_P53_MASK 0xC00u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_3_P53_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_3_P53_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_3_P53_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_3_P53_V12MA 0x3

/*! Field P54 - Pad Drive Control */
#define DCC_3_P54_POS 12
/*! Field P54 - Pad Drive Control */
#define DCC_3_P54_MASK 0x3000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_3_P54_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_3_P54_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_3_P54_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_3_P54_V12MA 0x3

/*! Field P55 - Pad Drive Control */
#define DCC_3_P55_POS 14
/*! Field P55 - Pad Drive Control */
#define DCC_3_P55_MASK 0xC000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_3_P55_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_3_P55_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_3_P55_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_3_P55_V12MA 0x3

/*! Field P56 - Pad Drive Control */
#define DCC_3_P56_POS 16
/*! Field P56 - Pad Drive Control */
#define DCC_3_P56_MASK 0x30000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_3_P56_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_3_P56_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_3_P56_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_3_P56_V12MA 0x3

/*! Field P57 - Pad Drive Control */
#define DCC_3_P57_POS 18
/*! Field P57 - Pad Drive Control */
#define DCC_3_P57_MASK 0xC0000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_3_P57_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_3_P57_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_3_P57_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_3_P57_V12MA 0x3

/*! Field P58 - Pad Drive Control */
#define DCC_3_P58_POS 20
/*! Field P58 - Pad Drive Control */
#define DCC_3_P58_MASK 0x300000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_3_P58_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_3_P58_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_3_P58_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_3_P58_V12MA 0x3

/*! Field P59 - Pad Drive Control */
#define DCC_3_P59_POS 22
/*! Field P59 - Pad Drive Control */
#define DCC_3_P59_MASK 0xC00000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_3_P59_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_3_P59_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_3_P59_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_3_P59_V12MA 0x3

/*! Field P60 - Pad Drive Control */
#define DCC_3_P60_POS 24
/*! Field P60 - Pad Drive Control */
#define DCC_3_P60_MASK 0x3000000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_3_P60_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_3_P60_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_3_P60_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_3_P60_V12MA 0x3

/*! Field P61 - Pad Drive Control */
#define DCC_3_P61_POS 26
/*! Field P61 - Pad Drive Control */
#define DCC_3_P61_MASK 0xC000000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_3_P61_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_3_P61_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_3_P61_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_3_P61_V12MA 0x3

/*! Field P62 - Pad Drive Control */
#define DCC_3_P62_POS 28
/*! Field P62 - Pad Drive Control */
#define DCC_3_P62_MASK 0x30000000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_3_P62_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_3_P62_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_3_P62_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_3_P62_V12MA 0x3

/*! Field P63 - Pad Drive Control */
#define DCC_3_P63_POS 30
/*! Field P63 - Pad Drive Control */
#define DCC_3_P63_MASK 0xC0000000u
/*! Constant V2_MA - 2 mA */
#define CONST_DCC_3_P63_V2_MA 0x0
/*! Constant V4MA - 4mA */
#define CONST_DCC_3_P63_V4MA 0x1
/*! Constant V8MA - 8mA */
#define CONST_DCC_3_P63_V8MA 0x2
/*! Constant V12MA - 12mA */
#define CONST_DCC_3_P63_V12MA 0x3

/*! @} */

/*! \defgroup OD_1 Register OD_1 - Open Drain Enable Register 1 */
/*! @{ */

/*! Register Offset (relative) */
#define OD_1 0x194
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_OD_1 0x16380194u

/*! Register Reset Value */
#define OD_1_RST 0x00000000u

/*! Field P32 - Pin Open Drain Enable */
#define OD_1_P32_POS 0
/*! Field P32 - Pin Open Drain Enable */
#define OD_1_P32_MASK 0x1u
/*! Constant NOP - No operation */
#define CONST_OD_1_P32_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P32_EN 0x1

/*! Field P33 - Pin Open Drain Enable */
#define OD_1_P33_POS 1
/*! Field P33 - Pin Open Drain Enable */
#define OD_1_P33_MASK 0x2u
/*! Constant NOP - No operation */
#define CONST_OD_1_P33_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P33_EN 0x1

/*! Field P34 - Pin Open Drain Enable */
#define OD_1_P34_POS 2
/*! Field P34 - Pin Open Drain Enable */
#define OD_1_P34_MASK 0x4u
/*! Constant NOP - No operation */
#define CONST_OD_1_P34_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P34_EN 0x1

/*! Field P35 - Pin Open Drain Enable */
#define OD_1_P35_POS 3
/*! Field P35 - Pin Open Drain Enable */
#define OD_1_P35_MASK 0x8u
/*! Constant NOP - No operation */
#define CONST_OD_1_P35_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P35_EN 0x1

/*! Field P36 - Pin Open Drain Enable */
#define OD_1_P36_POS 4
/*! Field P36 - Pin Open Drain Enable */
#define OD_1_P36_MASK 0x10u
/*! Constant NOP - No operation */
#define CONST_OD_1_P36_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P36_EN 0x1

/*! Field P37 - Pin Open Drain Enable */
#define OD_1_P37_POS 5
/*! Field P37 - Pin Open Drain Enable */
#define OD_1_P37_MASK 0x20u
/*! Constant NOP - No operation */
#define CONST_OD_1_P37_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P37_EN 0x1

/*! Field P38 - Pin Open Drain Enable */
#define OD_1_P38_POS 6
/*! Field P38 - Pin Open Drain Enable */
#define OD_1_P38_MASK 0x40u
/*! Constant NOP - No operation */
#define CONST_OD_1_P38_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P38_EN 0x1

/*! Field P39 - Pin Open Drain Enable */
#define OD_1_P39_POS 7
/*! Field P39 - Pin Open Drain Enable */
#define OD_1_P39_MASK 0x80u
/*! Constant NOP - No operation */
#define CONST_OD_1_P39_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P39_EN 0x1

/*! Field P40 - Pin Open Drain Enable */
#define OD_1_P40_POS 8
/*! Field P40 - Pin Open Drain Enable */
#define OD_1_P40_MASK 0x100u
/*! Constant NOP - No operation */
#define CONST_OD_1_P40_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P40_EN 0x1

/*! Field P41 - Pin Open Drain Enable */
#define OD_1_P41_POS 9
/*! Field P41 - Pin Open Drain Enable */
#define OD_1_P41_MASK 0x200u
/*! Constant NOP - No operation */
#define CONST_OD_1_P41_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P41_EN 0x1

/*! Field P42 - Pin Open Drain Enable */
#define OD_1_P42_POS 10
/*! Field P42 - Pin Open Drain Enable */
#define OD_1_P42_MASK 0x400u
/*! Constant NOP - No operation */
#define CONST_OD_1_P42_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P42_EN 0x1

/*! Field P43 - Pin Open Drain Enable */
#define OD_1_P43_POS 11
/*! Field P43 - Pin Open Drain Enable */
#define OD_1_P43_MASK 0x800u
/*! Constant NOP - No operation */
#define CONST_OD_1_P43_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P43_EN 0x1

/*! Field P44 - Pin Open Drain Enable */
#define OD_1_P44_POS 12
/*! Field P44 - Pin Open Drain Enable */
#define OD_1_P44_MASK 0x1000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P44_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P44_EN 0x1

/*! Field P45 - Pin Open Drain Enable */
#define OD_1_P45_POS 13
/*! Field P45 - Pin Open Drain Enable */
#define OD_1_P45_MASK 0x2000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P45_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P45_EN 0x1

/*! Field P46 - Pin Open Drain Enable */
#define OD_1_P46_POS 14
/*! Field P46 - Pin Open Drain Enable */
#define OD_1_P46_MASK 0x4000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P46_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P46_EN 0x1

/*! Field P47 - Pin Open Drain Enable */
#define OD_1_P47_POS 15
/*! Field P47 - Pin Open Drain Enable */
#define OD_1_P47_MASK 0x8000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P47_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P47_EN 0x1

/*! Field P48 - Pin Open Drain Enable */
#define OD_1_P48_POS 16
/*! Field P48 - Pin Open Drain Enable */
#define OD_1_P48_MASK 0x10000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P48_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P48_EN 0x1

/*! Field P49 - Pin Open Drain Enable */
#define OD_1_P49_POS 17
/*! Field P49 - Pin Open Drain Enable */
#define OD_1_P49_MASK 0x20000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P49_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P49_EN 0x1

/*! Field P50 - Pin Open Drain Enable */
#define OD_1_P50_POS 18
/*! Field P50 - Pin Open Drain Enable */
#define OD_1_P50_MASK 0x40000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P50_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P50_EN 0x1

/*! Field P51 - Pin Open Drain Enable */
#define OD_1_P51_POS 19
/*! Field P51 - Pin Open Drain Enable */
#define OD_1_P51_MASK 0x80000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P51_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P51_EN 0x1

/*! Field P52 - Pin Open Drain Enable */
#define OD_1_P52_POS 20
/*! Field P52 - Pin Open Drain Enable */
#define OD_1_P52_MASK 0x100000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P52_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P52_EN 0x1

/*! Field P53 - Pin Open Drain Enable */
#define OD_1_P53_POS 21
/*! Field P53 - Pin Open Drain Enable */
#define OD_1_P53_MASK 0x200000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P53_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P53_EN 0x1

/*! Field P54 - Pin Open Drain Enable */
#define OD_1_P54_POS 22
/*! Field P54 - Pin Open Drain Enable */
#define OD_1_P54_MASK 0x400000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P54_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P54_EN 0x1

/*! Field P55 - Pin Open Drain Enable */
#define OD_1_P55_POS 23
/*! Field P55 - Pin Open Drain Enable */
#define OD_1_P55_MASK 0x800000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P55_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P55_EN 0x1

/*! Field P56 - Pin Open Drain Enable */
#define OD_1_P56_POS 24
/*! Field P56 - Pin Open Drain Enable */
#define OD_1_P56_MASK 0x1000000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P56_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P56_EN 0x1

/*! Field P57 - Pin Open Drain Enable */
#define OD_1_P57_POS 25
/*! Field P57 - Pin Open Drain Enable */
#define OD_1_P57_MASK 0x2000000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P57_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P57_EN 0x1

/*! Field P58 - Pin Open Drain Enable */
#define OD_1_P58_POS 26
/*! Field P58 - Pin Open Drain Enable */
#define OD_1_P58_MASK 0x4000000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P58_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P58_EN 0x1

/*! Field P59 - Pin Open Drain Enable */
#define OD_1_P59_POS 27
/*! Field P59 - Pin Open Drain Enable */
#define OD_1_P59_MASK 0x8000000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P59_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P59_EN 0x1

/*! Field P60 - Pin Open Drain Enable */
#define OD_1_P60_POS 28
/*! Field P60 - Pin Open Drain Enable */
#define OD_1_P60_MASK 0x10000000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P60_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P60_EN 0x1

/*! Field P61 - Pin Open Drain Enable */
#define OD_1_P61_POS 29
/*! Field P61 - Pin Open Drain Enable */
#define OD_1_P61_MASK 0x20000000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P61_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P61_EN 0x1

/*! Field P62 - Pin Open Drain Enable */
#define OD_1_P62_POS 30
/*! Field P62 - Pin Open Drain Enable */
#define OD_1_P62_MASK 0x40000000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P62_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P62_EN 0x1

/*! Field P63 - Pin Open Drain Enable */
#define OD_1_P63_POS 31
/*! Field P63 - Pin Open Drain Enable */
#define OD_1_P63_MASK 0x80000000u
/*! Constant NOP - No operation */
#define CONST_OD_1_P63_NOP 0x0
/*! Constant EN - Enable */
#define CONST_OD_1_P63_EN 0x1

/*! @} */

/*! \defgroup AVAIL_1 Register AVAIL_1 - Pad Control Availability Register */
/*! @{ */

/*! Register Offset (relative) */
#define AVAIL_1 0x198
/*! Register Offset (absolute) for 1st Instance GPIO_PAD_CTRL */
#define GPIO_PAD_CTRL_AVAIL_1 0x16380198u

/*! Register Reset Value */
#define AVAIL_1_RST 0x000000FFu

/*! Field P32 - Pad Control Available */
#define AVAIL_1_P32_POS 0
/*! Field P32 - Pad Control Available */
#define AVAIL_1_P32_MASK 0x1u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P32_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P32_AV 0x1

/*! Field P33 - Pad Control Available */
#define AVAIL_1_P33_POS 1
/*! Field P33 - Pad Control Available */
#define AVAIL_1_P33_MASK 0x2u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P33_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P33_AV 0x1

/*! Field P34 - Pad Control Available */
#define AVAIL_1_P34_POS 2
/*! Field P34 - Pad Control Available */
#define AVAIL_1_P34_MASK 0x4u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P34_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P34_AV 0x1

/*! Field P35 - Pad Control Available */
#define AVAIL_1_P35_POS 3
/*! Field P35 - Pad Control Available */
#define AVAIL_1_P35_MASK 0x8u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P35_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P35_AV 0x1

/*! Field P36 - Pad Control Available */
#define AVAIL_1_P36_POS 4
/*! Field P36 - Pad Control Available */
#define AVAIL_1_P36_MASK 0x10u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P36_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P36_AV 0x1

/*! Field P37 - Pad Control Available */
#define AVAIL_1_P37_POS 5
/*! Field P37 - Pad Control Available */
#define AVAIL_1_P37_MASK 0x20u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P37_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P37_AV 0x1

/*! Field P38 - Pad Control Available */
#define AVAIL_1_P38_POS 6
/*! Field P38 - Pad Control Available */
#define AVAIL_1_P38_MASK 0x40u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P38_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P38_AV 0x1

/*! Field P39 - Pad Control Available */
#define AVAIL_1_P39_POS 7
/*! Field P39 - Pad Control Available */
#define AVAIL_1_P39_MASK 0x80u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P39_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P39_AV 0x1

/*! Field P40 - Pad Control Available */
#define AVAIL_1_P40_POS 8
/*! Field P40 - Pad Control Available */
#define AVAIL_1_P40_MASK 0x100u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P40_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P40_AV 0x1

/*! Field P41 - Pad Control Available */
#define AVAIL_1_P41_POS 9
/*! Field P41 - Pad Control Available */
#define AVAIL_1_P41_MASK 0x200u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P41_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P41_AV 0x1

/*! Field P42 - Pad Control Available */
#define AVAIL_1_P42_POS 10
/*! Field P42 - Pad Control Available */
#define AVAIL_1_P42_MASK 0x400u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P42_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P42_AV 0x1

/*! Field P43 - Pad Control Available */
#define AVAIL_1_P43_POS 11
/*! Field P43 - Pad Control Available */
#define AVAIL_1_P43_MASK 0x800u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P43_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P43_AV 0x1

/*! Field P44 - Pad Control Available */
#define AVAIL_1_P44_POS 12
/*! Field P44 - Pad Control Available */
#define AVAIL_1_P44_MASK 0x1000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P44_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P44_AV 0x1

/*! Field P45 - Pad Control Available */
#define AVAIL_1_P45_POS 13
/*! Field P45 - Pad Control Available */
#define AVAIL_1_P45_MASK 0x2000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P45_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P45_AV 0x1

/*! Field P46 - Pad Control Available */
#define AVAIL_1_P46_POS 14
/*! Field P46 - Pad Control Available */
#define AVAIL_1_P46_MASK 0x4000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P46_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P46_AV 0x1

/*! Field P47 - Pad Control Available */
#define AVAIL_1_P47_POS 15
/*! Field P47 - Pad Control Available */
#define AVAIL_1_P47_MASK 0x8000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P47_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P47_AV 0x1

/*! Field P48 - Pad Control Available */
#define AVAIL_1_P48_POS 16
/*! Field P48 - Pad Control Available */
#define AVAIL_1_P48_MASK 0x10000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P48_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P48_AV 0x1

/*! Field P49 - Pad Control Available */
#define AVAIL_1_P49_POS 17
/*! Field P49 - Pad Control Available */
#define AVAIL_1_P49_MASK 0x20000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P49_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P49_AV 0x1

/*! Field P50 - Pad Control Available */
#define AVAIL_1_P50_POS 18
/*! Field P50 - Pad Control Available */
#define AVAIL_1_P50_MASK 0x40000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P50_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P50_AV 0x1

/*! Field P51 - Pad Control Available */
#define AVAIL_1_P51_POS 19
/*! Field P51 - Pad Control Available */
#define AVAIL_1_P51_MASK 0x80000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P51_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P51_AV 0x1

/*! Field P52 - Pad Control Available */
#define AVAIL_1_P52_POS 20
/*! Field P52 - Pad Control Available */
#define AVAIL_1_P52_MASK 0x100000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P52_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P52_AV 0x1

/*! Field P53 - Pad Control Available */
#define AVAIL_1_P53_POS 21
/*! Field P53 - Pad Control Available */
#define AVAIL_1_P53_MASK 0x200000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P53_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P53_AV 0x1

/*! Field P54 - Pad Control Available */
#define AVAIL_1_P54_POS 22
/*! Field P54 - Pad Control Available */
#define AVAIL_1_P54_MASK 0x400000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P54_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P54_AV 0x1

/*! Field P55 - Pad Control Available */
#define AVAIL_1_P55_POS 23
/*! Field P55 - Pad Control Available */
#define AVAIL_1_P55_MASK 0x800000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P55_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P55_AV 0x1

/*! Field P56 - Pad Control Available */
#define AVAIL_1_P56_POS 24
/*! Field P56 - Pad Control Available */
#define AVAIL_1_P56_MASK 0x1000000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P56_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P56_AV 0x1

/*! Field P57 - Pad Control Available */
#define AVAIL_1_P57_POS 25
/*! Field P57 - Pad Control Available */
#define AVAIL_1_P57_MASK 0x2000000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P57_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P57_AV 0x1

/*! Field P58 - Pad Control Available */
#define AVAIL_1_P58_POS 26
/*! Field P58 - Pad Control Available */
#define AVAIL_1_P58_MASK 0x4000000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P58_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P58_AV 0x1

/*! Field P59 - Pad Control Available */
#define AVAIL_1_P59_POS 27
/*! Field P59 - Pad Control Available */
#define AVAIL_1_P59_MASK 0x8000000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P59_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P59_AV 0x1

/*! Field P60 - Pad Control Available */
#define AVAIL_1_P60_POS 28
/*! Field P60 - Pad Control Available */
#define AVAIL_1_P60_MASK 0x10000000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P60_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P60_AV 0x1

/*! Field P61 - Pad Control Available */
#define AVAIL_1_P61_POS 29
/*! Field P61 - Pad Control Available */
#define AVAIL_1_P61_MASK 0x20000000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P61_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P61_AV 0x1

/*! Field P62 - Pad Control Available */
#define AVAIL_1_P62_POS 30
/*! Field P62 - Pad Control Available */
#define AVAIL_1_P62_MASK 0x40000000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P62_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P62_AV 0x1

/*! Field P63 - Pad Control Available */
#define AVAIL_1_P63_POS 31
/*! Field P63 - Pad Control Available */
#define AVAIL_1_P63_MASK 0x80000000u
/*! Constant NAV - NAV */
#define CONST_AVAIL_1_P63_NAV 0x0
/*! Constant AV - AV */
#define CONST_AVAIL_1_P63_AV 0x1

/*! @} */

/*! @} */

#endif
